<?php

/**
 * SalarydistributionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SalarydistributionModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SalaryDistributionChild WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->GradeId;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SALARYDISTRIBUTION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SalaryDistributionChild WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['gradeid'] = (int)$row->GradeId;
				$res['expyears'] = $row->ExpYears;
				$res['salaryrangemin'] = $row->SalaryRangeMin;
				$res['salaryrangemax'] = $row->SalaryRangeMax;
				$res['paypattern'] = $row->PayPattern;
				$res['salarytype'] = $row->SalaryType;
				$res['exptype'] = $row->ExpType;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYDISTRIBUTION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYDISTRIBUTION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a SalaryDistributionChild (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		try{
		
		$data = json_decode($request[2], true);
		
		foreach($data as $value)
		{
			$sql = "UPDATE SalaryDistributionChild SET GradeId=?, ExpYears=?, SalaryRangeMin=?, SalaryRangeMax=?, PayPattern=?, SalaryType=?, ExpType=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
			$query = $this->db->prepare($sql);			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array($value['gradeid'], $value['expyears'], $value['salaryrangemin'], $value['salaryrangemax'], $value['paypattern'], $value['salarytype'], $value['exptype'], $mdate, $mid, $value['id'] ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
        if ($count == 1) {
           $status =true;
		   $successMsg = SALARYDISTRIBUTION_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYDISTRIBUTION_MODULE_UPDATION_FAILED;
        }
		
		}catch(Exception $e){
			$status =false;
		   $errorMsg = SALARYDISTRIBUTION_MODULE_UPDATION_FAILED;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a SalaryDistributionChild (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		foreach($request[2] as $value)
		{
			$sql = "INSERT INTO SalaryDistributionChild (GradeId, ExpYears, SalaryRangeMin, SalaryRangeMax, PayPattern, SalaryType, ExpType, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			$query = $this->db->prepare($sql);			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array($value['gradeid'], $value['expyears'], $value['salaryrangemin'], $value['salaryrangemax'], $value['paypattern'], $value['salarytype'], $value['exptype'],$orgid, $mdate, $mid, $mdate, $mid, $mid ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = SALARYDISTRIBUTION_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYDISTRIBUTION_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM SalaryDistributionChild WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = SALARYDISTRIBUTION_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = SALARYDISTRIBUTION_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($tablename, $id)
	{
		$name ="";
		$sql = "SELECT * FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'SalaryDistributionChild';
		$sIndexColumn = "Id";
		$aColumns = array( 'GradeId', 'ExpType', 'ExpYears', 'SalaryRangeMin', 'SalaryRangeMax', 'PayPattern', 'SalaryType',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}if($aColumns[$i]=="GradeId"){
					$sWhere .= "(GradeId in (select Id from GradeMaster where Name "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalarydistribution/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}else if($aColumns[$i]=="GradeId"){
					$row[] = '<a href="'.URL.'salary/viewsalarydistribution/'.Utils::encode5t($aRow->Id).'/1">'.$this->getName('GradeMaster',$aRow->{$aColumns[$i]}).'</a>';
				}else if($aColumns[$i]=="SalaryType"){
					$row[] = $this->getName('SalaryTypeMaster',$aRow->{$aColumns[$i]});
				}else if($aColumns[$i]=="PayPattern"){
					$row[] = ($aRow->{$aColumns[$i]}==1)?"Incentivised":"Non - Incentivised";
				}else if($aColumns[$i]=="ExpYears"){
					$row[] = $aRow->{$aColumns[$i]}." Year(s)";
				}else if($aColumns[$i]=="ExpType"){
					$row[] = ($aRow->{$aColumns[$i]}==1)?"More Than":"Less Than";
				}else if($aColumns[$i]=="SalaryRangeMin"){
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
				}else if($aColumns[$i]=="SalaryRangeMax"){
					if($aRow->{$aColumns[$i]}==0)
						$row[] = "Above";
					else
						$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
				}elseif($aColumns[$i]=="LastModifiedDate"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
