<?php

/**
 * SalaryapprovalModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SalaryapprovalModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SalaryApproval WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = LEAVE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$decodeid = Utils::decode5t($id);		
		
        $sql = "SELECT * FROM SalaryAdvance WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $decodeid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['sts'] 		= $row->LeaveStatus;      
				$res['employeeid'] 		= Utils::getEmployeeName($row->EmployeeId, $this->db);
				$res['remarks'] 		= $row->Remarks;
				$res['advanceamount'] 	= $row->AdvanceAmount;
				$res['installment'] 	= $row->InstallmentAmt;
				$res['applymonth'] 		= Utils::dateformatter($row->ApplyMonth);
				$res['gratuity'] 	= "";//Utils::getEmployeeGratuity($row->EmployeeId, 1, $this->db);
				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $row->EmployeeId ));
				while($r = $query1->fetch())
				{
					$res['division'] 	= Utils::getName($r->Division, 'DivisionMaster', 'Name', $this->db);
					$res['department'] 	= Utils::getName($r->Department, 'DepartmentMaster', 'Name', $this->db);
					$res['designation'] 	= Utils::getName($r->Designation, 'DesignationMaster', 'Name', $this->db);
				}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = "";
        } else {
           $status =false;
		   $errorMsg = SALARYADVANCE_MODULE_GETALL;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
   
	 public function Approve($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		
		$decodeid = Utils::decode5t($request[2]);
		
		$sql = "UPDATE SalaryApproval SET LeaveStatus =?, ApprovalDate =?, ApproverComment=? WHERE SalaryAdvanceId =? AND ApproverId=? and OrganizationId=?";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array($request[3], $mdate, $request[4], $decodeid, $mid, $orgid));
			$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
        if ($count >= 1) {
			$empid=Utils::getName($decodeid,'SalaryAdvance','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Personal loan of $empname has been Approval  ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Severance", $msg, $orgid));
           $status =true;
		   if($request[3]==2){
				$successMsg = SALARYADVANCE_MODULE_APPROVE;
				$sql1 = "select * from SalaryApproval WHERE SalaryAdvanceId = ? and LeaveStatus<>2 and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $decodeid, $orgid));
				if($query1->rowCount()==0)
				{
					$sql2 = "UPDATE SalaryAdvance SET LeaveStatus =?,LastModifiedDate=?,LastModifiedById=?,ApprovedBy=? WHERE Id =? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(2,$mdate,$mid,$mid, $decodeid));
					$sql2 = "SELECT * from SalaryAdvance WHERE Id =? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($decodeid));
					while($r=$query2->fetch())
					{
						$instamt=$r->AdvanceAmount;
						$inst=$r->InstallmentAmt;
						$applymonth=$r->ApplyMonth;
					}
					$temp1=(int)$instamt/$inst;
		
					$rem=(int)$instamt%$inst;
					$first=(int)$temp1+(int)$rem;
					
					$instmonth=$applymonth;
					$temp=strtotime($instmonth);
					for($i=0; $i<$inst; $i++)
					{	
						
							$record = array();
							if($i==0){
								$record[0] = $decodeid;
								$record[1] = $first;
								$record[2] = $instmonth;
										
							}else{
								$record[0] = $decodeid;
								$record[1] = $temp1;
								$record[2] = $instmonth;
							}
							$sqlinstdetails = " INSERT INTO SalaryAdvanceChild ( SalaryAdvanceId,  InstAmount,InstMonth) VALUES (?,?,?)";
							$queryinstdetails = $this->db->prepare($sqlinstdetails);
							$queryinstdetails->execute($record);
							$instmonth=date('Y-m-d', strtotime("+1 months", $temp));
							$temp=strtotime($instmonth);
						
					}
					
				}
				
		   }else{
				$sql2 = "UPDATE SalaryAdvance SET LeaveStatus =?, LastModifiedDate=?, LastModifiedById=?,ApprovedBy=? WHERE Id =? ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array(1, $mdate, $mid,$mid, $decodeid));
				$successMsg = SALARYADVANCE_MODULE_REJECT;
		   }
		  
        } else {
           $status =false;
		   $errorMsg = SALARYADVANCE_MODULE_GETDETAIL_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
   
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM SalaryApproval WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			
           $status =true;
		   $successMsg = LEAVE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = LEAVE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getApproverSts($id,$userid)
	{
		$flg =false;
		$employee=0;
		$sql = "SELECT * FROM SalaryApproval WHERE SalaryAdvanceId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
				if($row->LeaveStatus==3){
					$employee=$row->ApproverId;
					break;
				}
			}
			if($employee ==  $userid){
					$flg = true;
				}
		}catch(Exception $e) {
			
		}
		return $flg;
	}
	
	
	public function getDataTable($editper, $deleteper)
	{
		
		$sTable = 'SalaryAdvance';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId', 'AdvanceAmount', 'ApplyMonth' ,'LeaveStatus','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY  CreatedDate desc";
		}
		
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		if($sts==1){
			$sWhere = " WHERE OrganizationId= $orgid AND Id IN (SELECT SalaryAdvanceId FROM SalaryApproval Where ApproverId=$userid )";
			
		}else{
			$sWhere = " WHERE OrganizationId= $orgid and EmployeeId in ($ids) AND Id IN (SELECT SalaryAdvanceId FROM SalaryApproval Where ApproverId=$userid )";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		
		$sQuery = "
		 SELECT SQL_CALC_FOUND_ROWS   ".str_replace(" , ", " ", implode(", ", $aColumns))."  
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
										
					$edit =""; $delete="";
					$sts=$this->getApproverSts($aRow->Id,$userid);
					if($sts && $aRow->LeaveStatus==3){			
						$encodeid = Utils::encode5t($aRow->Id);
						$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'salary/viewsalaryadvanceapproval/'.$encodeid.'/0" class="text-green"><i class="fa fa-thumbs-up"></i></a>';
					}
					
					$row[] =$edit;
					
				}
				elseif($aColumns[$i]=="LeaveStatus"){
                    
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
                 }
				 elseif($aColumns[$i]=="EmployeeId"){
                    $encodeid = Utils::encode5t($aRow->Id);
					$row[] = '<a rel="tooltip" title="View Details" href="'.URL.'salary/viewsalaryadvanceapproval/'.$encodeid.'/1" >'.Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'</a>';
                 }
				elseif($aColumns[$i]=="ApplyMonth" ){
					$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
				}elseif($aColumns[$i]=="AdvanceAmount" ){
					$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
					$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
					$row[] =  Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	public function getAllApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $request[1];
		$leaveid = $request[2];
		$decodeid = Utils::decode5t($leaveid);
		
		$s1="SELECT * from SalaryApproval WHERE OrganizationId=? and SalaryAdvanceId = ? and LeaveStatus<>3";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $decodeid));
		//$count=$query->rowCount();
		while($row = $query->fetch())
		{
			$res = array();
			//$res['count'] = $count;
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->LeaveStatus;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data[] = $res;
			
			$successMsg=""; $status=true;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getAllClaimApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $request[1];
		$claimid = $request[2];
		//$decodeid = Utils::decode5t($leaveid);
		
		$s1="SELECT * from ClaimApproval WHERE OrganizationId=? and ClaimId = ? and ApproverSts<>3";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $claimid));
		//$count=$query->rowCount();
		while($row = $query->fetch())
		{
			$res = array();
			$res['count'] = $this->countAprroval($claimid);
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->ApproverSts;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data[] = $res;
			
			$successMsg=""; $status=true;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function countAprroval($claimid)
    {
		//$countleftapp=0;
		$s1="SELECT * from ClaimApproval WHERE ClaimId in($claimid) and ApproverSts=3";
		$query = $this->db->prepare($s1);
		$query->execute(array());
		$count=$query->rowCount();
		$row = $query->fetch();
		$countleftapp =$count;
			
		return $countleftapp;
  

	}
	}
