<?php

/**
 * SalaryadvanceModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SalaryAdvanceLoanModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SalaryAdvanceLoan WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SALARYADVANCE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	//function for get all employee names
	public function getAllemp($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? AND Id in (SELECT Id FROM EmployeeMaster where ReportingTo=? and Is_Delete=0 )";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array( $orgid ,$mid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->FirstName. " " .$row->LastName;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SALARYADVANCE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getempGratuity($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id'];
		//$id=Utils::decode5t($id);
        $sql = "SELECT Sum(AdvanceAmount) as totalamt FROM SalaryAdvanceLoan WHERE OrganizationId=? and EmployeeId = ? and LeaveStatus=2 ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid,$id ));
			$count =  $query->rowCount();
		
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				$totalpaid=0; $totalamt = 0;
				while($row = $query->fetch())
				{
					$totalamt = $row->totalamt;
				}
				$sql1 = "SELECT HeadAmount FROM SalaryMaster sm, SalaryChild sc WHERE sm.Id=sc.SalaryId and OrganizationId = ? and sm.EmployeeId =? and SalaryMonth in (SELECT InstMonth FROM SalaryAdvanceChildLoan where SalaryAdvanceId in (select Id from SalaryAdvanceLoan where EmployeeId=?)) and HeadType=2 and HeadId=1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,$id, $id));
				while($row1 = $query1->fetch())
				{
					$totalpaid += $row1->HeadAmount;
				}
				$res["outstanding"] =$outstanding=$totalamt-$totalpaid;
				$res["empgratuity"] =(Utils::getEmployeeGratuity($id,1,$this->db))-$outstanding;
				$data[]=$res;
			}
		
			if ($count == 1) {
			   $status =true;
			   $successMsg = SALARYADVANCE_MODULE_GETDETAIL_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = SALARYADVANCE_MODULE_GETDETAIL_FAILED;
			}
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id'];
		//$id=Utils::decode5t($id);
        $sql = "SELECT * FROM SalaryAdvanceLoan WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['employeeid'] = (int)$row->EmployeeId;
				$res['advanceamount'] = (int)$row->AdvanceAmount;
				$res['installmentamt'] =(int) $row->InstallmentAmt;
				$res['approvedby'] = $row->ApprovedBy;
				$res['remarks'] = $row->Remarks;
				$res['applymonth'] = Utils::monthdateformatter($row->ApplyMonth);
				$res['applymonth1'] = $row->ApplyMonth;
				$empdivision=Utils::getName($row->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
				$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
				$res['empcurency'] = $divcur;
				$res['applysts'] = $row->LeaveStatus;
				$advance=$row->AdvanceAmount;
				$res['closests'] = $row->LoanSTs;
				$res['closeamount'] = $row->CloseAmount;
				$res['closedate'] = Utils::dateformatter($row->CloseDate);
				$outstanding = Utils::getOutstandingLoanAmountsalary($row->EmployeeId,$row->Id, $orgid, $this->db);
				$recoverd=0;
				if($outstanding>0)
				$recoverd=abs($advance-$outstanding);
				$res['outstandingamt']= $outstanding;
				$res['recoveramt']= $recoverd;
				$sqlinst= "SELECT * FROM SalaryAdvanceChildLoan WHERE SalaryAdvanceId = :id";
				$queryinst= $this->db->prepare($sqlinst);
				$queryinst->execute(array(':id' => $id ));
				$inst=array();
				
				while($rowinst= $queryinst->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowinst->Id;
					$res1['month'] =Utils::monthdateformatter( $rowinst->InstMonth);
					$res1['instamt'] = $rowinst->InstAmount;
					$inst[] = $res1;
				}
				$res['installmentdetails']=$inst;
				$data[] = $res;
			}
        }
		$totalpaid=0; $totalamt = 0;
		$sql1 = "SELECT HeadAmount FROM SalaryMaster sm, SalaryChild sc WHERE sm.Id=sc.SalaryId and OrganizationId = ? and sm.EmployeeId =? and SalaryMonth in (SELECT InstMonth FROM SalaryAdvanceChildLoan where SalaryAdvanceId in (select Id from SalaryAdvanceLoan where EmployeeId=? and LeaveStatus=2)) and HeadType=2 and HeadId=1";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid,$_SESSION['ubihrm_user_id'], $_SESSION['ubihrm_user_id']));
		while($row1 = $query1->fetch())
		{
			$totalpaid += $row1->HeadAmount;
		}
		$sql1 = "SELECT Sum(AdvanceAmount) as totalamt FROM SalaryAdvanceLoan where OrganizationId=? and EmployeeId=? and LeaveStatus=2";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid,$_SESSION['ubihrm_user_id']));
		while($row1 = $query1->fetch())
		{
			$totalamt = $row1->totalamt;
		}
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYADVANCE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYADVANCE_MODULE_GETDETAIL_FAILED;
        }
		$ts1=strtotime(date('Y-m-1'));
		$result['month']=date('F Y', strtotime("+1 months", $ts1));
		$result['month1']=date('Y-m-d', strtotime("+1 months", $ts1));
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		$result["outstanding"] =$outstanding=$totalamt-$totalpaid;
		$result["empgratuity"] =(Utils::getEmployeeGratuity($_SESSION['ubihrm_user_id'],1,$this->db))-$outstanding;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a DocumentMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $empgratuity=0;
		$mdate = date("Y-m-d H:i:s");
		$applymonth = $request[8];//Utils::getDateformat($request[8]);
		$fiscalid = Utils::getFiscalId($applymonth, $this->db);
		$closedate=Utils::getDateformat($request[10]);
		$total=0;
		if($fiscalid>=0)
			{
					$sql = "UPDATE SalaryAdvanceLoan SET EmployeeId=?, AdvanceAmount=?,InstallmentAmt=?,  ApprovedBy=?, Remarks=?, LeaveStatus=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=?, ApplyMonth=?,CloseDate=?, CloseAmount=?,LoanSTs=?  where Id=?";
					$query = $this->db->prepare($sql);
					
					try{
						$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
						$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
						
						$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $request[9], $orgid, $mdate, $mid, $applymonth, $closedate, $request[11] ,$request[12] , $request[7] ));			
						
						
						//////INSERT INSTALLMENT///////////
						
							$instdetails = json_decode($_POST['installmentdetails'], true); 
							$sqlwork = " DELETE FROM SalaryAdvanceChildLoan WHERE SalaryAdvanceId=? ";
							$querywork = $this->db->prepare($sqlwork);
							$querywork->execute(array( $request[7]));	
							$instmonth=$applymonth;
							
							for($i=0; $i<$request[4]; $i++)
							{	
								if( $instdetails[0]['instamt']!=0 ){
									$record = array();
										
									$record[0] =$request[7];
									$record[1] = $instdetails[$i]['instamt'];
									$record[2] = $instmonth;
																		
									$sqlinstdetails = " INSERT INTO SalaryAdvanceChildLoan ( SalaryAdvanceId,  InstAmount,InstMonth) VALUES (?,?,?)";
									$queryinstdetails = $this->db->prepare($sqlinstdetails);
									$queryinstdetails->execute($record);
											
									$instmonth=date('Y-m-d', strtotime("+1 months".date($instmonth)));
									//$temp=strtotime($instmonth);
								}
							}
						
							$count =  $query->rowCount();
							
						
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
					if ($count == 1) {
						//$empid=Utils::getName($decodeid,'SalaryAdvance','EmployeeId',$this->db);
						$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
						$msg="Salary of $empname has been updated";
						$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($mid, "Salaryadvance", $msg, $orgid));
					   $status =true;
					   $successMsg = "Request for salary advance has been updated";
					} else {
					   $status =false;
					   $errorMsg = SALARYADVANCE_MODULE_UPDATION_FAILED;
					}
				
			}else{
					$status =false;
					$errorMsg = FISCAL_MODULE_GETALL;
			}
		
		
        
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a DocumentMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$applymonth = $request[7];//Utils::getDateformat($request[7]);
		$fiscalid = Utils::getFiscalId($applymonth, $this->db);
		$total=0;
		
			if($fiscalid>0)
			{
				$sql = "INSERT INTO SalaryAdvanceLoan (EmployeeId, AdvanceAmount,InstallmentAmt,  ApprovedBy, Remarks, LeaveStatus, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, ApplyMonth, FiscalId) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
				$leavests= ($request[8]==0)?3:$request[8];
				try{
						$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
						$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
						
						$query = $this->db->prepare($sql);
						$query->execute(array($request[2], $request[3],$request[4],  $mid, $request[6], $leavests, $orgid, $mdate, $mid, $mdate, $mid, $mid, $applymonth, $fiscalid));
						
						$salaryadvanceid=$this->db->lastInsertId();
						
						//////INSERT INSTALLMENT///////////
						if($leavests==2){
							$instdetails = json_decode($_POST['installmentdetails'], true); 
							$instmonth=$applymonth;
							//$temp=strtotime($instmonth);
							for($i=0; $i<$request[4]; $i++)
							{	
								if( $instdetails[0]['instamt']!=0 ){
									$record = array();
										
									$record[0] = $salaryadvanceid;
									$record[1] = $instdetails[$i]['instamt'];
									$record[2] = $instmonth;
																		
									$sqlinstdetails = " INSERT INTO SalaryAdvanceChildLoan ( SalaryAdvanceId,  InstAmount,InstMonth) VALUES (?,?,?)";
									$queryinstdetails = $this->db->prepare($sqlinstdetails);
									$queryinstdetails->execute($record);
											
									$instmonth=date('Y-m-d', strtotime("+1 months".date($instmonth)));
									//$temp=strtotime($instmonth);
								}
							}	
						}else{
							$sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";
							$query = $this->db->prepare($sql);
							$query->execute(array( $orgid));
							if($r=$query->fetch()){
								$hr=$r->EmployeeId;
							}
							$senior = Utils::getApprovalLevelEmp($mid, 11, $this->db);
							if($senior!=0)
							{
								/* $temp1 = explode(",", $senior);
								for($i=0;$i<count($temp1);$i++)
								{
									if($temp1[$i] == $hr){
										unset($temp1[$i]);
									}
								}
								$senior=implode(',',$temp1);
								if($hr !=0)
									$senior.=','.$hr; */
								$temp = explode(",", $senior);
								//$temp = explode(",", $senior);
								for($i=0; $i<count($temp); $i++)
								{
									$sql = "INSERT INTO SalaryApprovalLoan (SalaryAdvanceId, ApproverId, CreatedDate,  OrganizationId) VALUES (?, ?, ?, ?)";
									$query = $this->db->prepare($sql);
									$query->execute(array($salaryadvanceid, $temp[$i], $mdate, $orgid));
									$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
									$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
									$senioremail=Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db);
									$title="Personal loan request";
									$msg="<table>
											<tr><td>Hello $seniorname,</td></tr>
											<tr><td>$empname has requested for Salary Advance. Kindly approve the request.</td></tr>
											<tr><td>Thanks</td></tr>
									</table>";
									Utils::Trace($senioremail." ".$msg);
									Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
								}
							}else{
								$senior=Utils::getSeniorId($mid, $this->db);
								if($senior != $hr){
									if($hr !=0)
									$senior.=','.$hr;
								}
								$temp = explode(",", $senior);
								for($i=0; $i<count($temp); $i++)
								{
									$sql = "INSERT INTO SalaryApprovalLoan (SalaryAdvanceId, ApproverId, CreatedDate,  OrganizationId) VALUES (?, ?, ?, ?)";
									$query = $this->db->prepare($sql);
									$query->execute(array($salaryadvanceid, $temp[$i], $mdate, $orgid));
									$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
									$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
									$senioremail=Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db);
									$title="Personal loan request";
									$msg="<table>
											<tr><td>Hello $seniorname,</td></tr>
											<tr><td>$empname has requested for Salary Advance. Kindly approve the request.</td></tr>
											<tr><td>Thanks</td></tr>
									</table>";
									Utils::Trace($senioremail." ".$msg);
									Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
								}
							}
						}
						$count =  $query->rowCount();
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
					if ($count == 1) {
						//$empid=Utils::getName($decodeid,'SalaryAdvance','EmployeeId',$this->db);
						$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
						$msg="Salary of $empname has been created";
						$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($mid, "Salaryadvance", $msg, $orgid));
					   $status =true;
					   $successMsg = "Request for salary advance has been sent";
					} else {
					   $status =false;
					   $errorMsg = SALARYADVANCE_MODULE_CREATION_FAILED;
					}
				
			}else{
					$status =false;
					$errorMsg = FISCAL_MODULE_GETALL;
			}
		
        
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
   public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$sql = "DELETE FROM SalaryAdvanceLoan WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();
			$sql = "DELETE FROM SalaryAdvanceChildLoan WHERE SalaryAdvanceId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$sql = "DELETE FROM SalaryApprovalLoan WHERE SalaryAdvanceId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count +=  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count >= 1) {
			$empid=Utils::getName($did,'SalaryAdvanceLoan','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Salary of $empname has been deleted";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Salaryadvance", $msg, $orgid));
           $status =true;
		   $successMsg = "Salary advance deleted successfully";
        }else {
           $status =false;
		   $errorMsg = SALARYADVANCE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->FirstName. " " .$row->LastName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'SalaryAdvanceLoan';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId' , 'AdvanceAmount' , 'ApplyMonth'  ,'OrganizationId' ,'ApprovedBy', 'LeaveStatus' ,'Remarks' ,'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$ids = Utils::getReportingIds($userid ,$this->db);
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}else{
			$sWhere = " WHERE (EmployeeId in ($ids) AND OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) ) ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -4 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper && $aRow->LeaveStatus==3){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salaryadvanceloan/editsalaryadvance/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}elseif($editper && $aRow->LeaveStatus<>3){
						$edit = '<a href="#" rel="tooltip" title="Request is either Approved or Rejected"><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					
					if($hrsts==1){
						
						//$edit = '<a rel="tooltip" title="Edit" href="'.URL.'SalaryAdvanceloan/editsalaryadvance/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salaryadvanceloan/editsalaryadvance/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
								
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="EmployeeId" )
				{
					//$row[] = '<a href="'.URL.'SalaryAdvanceloan/viewsalaryadvance/'.Utils::encode5t($aRow->Id).'/1">'.$this->getName($aRow->{$aColumns[$i]}).'</a>';
					$row[] = '<a href="'.URL.'salaryadvanceloan/viewsalaryadvance/'.Utils::encode5t($aRow->Id).'/1">'.$this->getName($aRow->{$aColumns[$i]}).'</a>';
				}
				elseif($aColumns[$i]=="OrganizationId" )
				{
					if($aRow->LeaveStatus==2){
						$balance = Utils::getOutstandingLoanAmountsalary($aRow->EmployeeId,$aRow->Id, $orgid, $this->db);
						$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'Division',$this->db);
						$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
						$row[] = Utils::numberformatter($balance,$divcur);
					}else{
						$row[] ="-";
					}
				}
				elseif($aColumns[$i]=="ApprovedBy")
				{
					$name = $this->getName($aRow->{$aColumns[$i]});
					if($name==""){
						$row[] = "-";
					}
					else{
							$row[] = $name;
						}
				}
				elseif($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="AdvanceAmount" )
				{
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ApplyMonth"){
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="LeaveStatus"){
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
				}				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
