<?php

/**
 * SalaryModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SalaryModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of GRADE
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$ids =Utils::getReportingIds($mid, $this->db);
		
        $sql = "SELECT * FROM SalaryMaster WHERE OrganizationId = :id and EmployeeId in ($ids)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				//$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=SALARYMASTER_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$salaryid = Utils::decode5t($request[2]);	//SALARY ID CONTAINS IN ARRAY THIRD VALUE;
		
		$bankname =""; $bankcode =""; $bankacct =0;
        $sql = "SELECT * FROM SalaryMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $salaryid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['salaryid'] = $row->Id;
				$res['employee'] = $row->EmployeeId;
				$month=$res['empmonthdate'] = $row->SalaryMonth;
				$empdivision=Utils::getName($row->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
				$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
				$res['empcurency'] = $divcur;
				$res['emppaiddays'] = $row->PaidDays;
				$res['desc'] = $row->Description;
				$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
				$bankname = $row->BankName;
				$bankcode = Utils::decode5t($row->BankCode); 
				$bankacct = Utils::decode5t($row->BankAccountNo);
				$agentid = $row->agent_id;
				
				$res['salarydetail'] = array();
				$headarray = array();
				$total=0;$totaldeduction=0;
				$res['bankname'] = $bankname;
				$res['bankcode'] = $bankcode;
				$res['bankacct'] = $bankacct;
				$res['agentid'] = $agentid;
				$holdsts=$res['holdsts'] = $row->HoldStatus;
				
				////////////////   FIND OUT THE COMPANY DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT Name,Logo FROM Organization WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->OrganizationId ));
				while($row1 = $query1->fetch())
				{
					$res['companyname'] = $row1->Name;
					$res['logo'] = URL."public/uploads/".$row->OrganizationId."/".$row1->Logo;
				}
				
				////////////////   FIND OUT THE EMPLOYEE DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->EmployeeId, $orgid ));
				while($row1 = $query1->fetch())
				{
					$res['id'] = (float)$row1->Id;
					$res['name'] = ucwords(strtolower($row1->FirstName." ".$row1->LastName));
					$res['empcode'] = $row1->EmployeeCode;
					$res['empdivision'] = $this->getName($row1->Division,'DivisionMaster');
					$res['empdept'] = $this->getName($row1->Department,'DepartmentMaster');
					$res['empdesig'] = $this->getName($row1->Designation,'DesignationMaster');
					$res['empshift'] =$this->getName( $row1->Shift,'ShiftMaster');
					$res['empgrade'] = $this->getName($row1->Grade,'GradeMaster');
					$res['empctc'] = $row1->EmployeeCTC;
					
					////////////////////////////////// CHECKING FOR OLD DATA, IF WE CHECK OLD SALARY OR PAY SLIP, THERE MUST BE OLD DATA NOT THE CURRENT ONE, SO WE ARE FETHING THE DATA FROM JOB MODIFICATION TABLE//////////////////////////////////
					
					$sqljob="SELECT * FROM JobModificationMaster where EmployeeId=? ";
					$queryjob=$this->db->prepare($sqljob);
					$queryjob->execute(array($row->EmployeeId));
					while($rowjob = $queryjob->fetch())
					{
						if(strtotime($rowjob->ApplyFrom ) > strtotime($month))
						{
							$sqljob1="SELECT * FROM JobModificationChild where JobId=? ";
							$queryjob1=$this->db->prepare($sqljob1);
							$queryjob1->execute(array($rowjob->Id));
							while($rj = $queryjob1->fetch())
							{
								if($rj->FieldName == "Department")
									$res['empdept'] = $this->getName($rj->OldValue,'DepartmentMaster');
								if($rj->FieldName == "Designation")
									$res['empdesig'] = $this->getName($rj->OldValue,'DesignationMaster');
								if($rj->FieldName == "Division")
									$res['empdivision'] = $this->getName($rj->OldValue,'DivisionMaster');
								if($rj->FieldName == "EmployeeCTC")
									$res['empctc'] = $rj->OldValue;
								if($rj->FieldName == "Grade")
									$res['empgrade'] = $this->getName($rj->OldValue,'GradeMaster');
							}	
						}
						
					}
					
				}
				
				////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT *, sh.headtype as type FROM SalaryHead sh, SalaryChild sc where sc.headtype=1 and sc.headid=sh.id and salaryid=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->Id;
					$res1['amount'] = (float)$row1->HeadAmount;					
					$res1['name'] =(($row1->type==3)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 1;
					$res1['headtype'] = (int)($row1->type==3)?0:$row1->type;
					$res1['payslip'] = (int)$row1->IncludeInPayslip;
					$res1['additions'] = ($row1->type==3)?0:1;
					$headarray[]=$res1;
					if($row1->type==3)
					$totaldeduction += (float)$row1->HeadAmount;
					else
					$total += (float)$row1->HeadAmount;
				}
				///////////// LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////////////////////		
				$sql1 = "SELECT * FROM SalaryOtherHead sh, SalaryChild sc where sc.headtype=2 and sc.headid=sh.HeadCode and sc.salaryid=? and sh.OrganizationId=? and ActiveSts=1 ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ,$orgid));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->HeadCode;
					$res1['amount'] = (float)$row1->HeadAmount;
					$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 2;
					$res1['headtype'] = $row1->Type;
					$res1['payslip'] = $row1->IncludeInPayslip;
					$res1['additions'] = ($row1->Type==0)?0:1;
					$headarray[]=$res1;
					
					if($row1->Type)
					$total += (float)$row1->HeadAmount;
					else
					$totaldeduction += (float)$row1->HeadAmount;
				}
				
				
				
				$res['salarydetail'] = $headarray;
				$res['emptotal'] = round($total);
				$res['emptotaldeduction'] =round($totaldeduction);
				$res['netpay'] = round($total-$totaldeduction);
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYMASTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=SALARYMASTER_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	public function getDetailforUpdate($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$salaryid = Utils::decode5t($request[2]);	//SALARY ID CONTAINS IN ARRAY THIRD VALUE;
		
		$bankname =""; $bankcode =""; $bankacct =0;
        $sql = "SELECT * FROM SalaryMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $salaryid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['salaryid'] = $row->Id;
				$res['employee'] = $row->EmployeeId;
				$month = $row->SalaryMonth;
				//$res['empctc'] = $row->EmployeeCTC;
				$res['emppaiddays'] = $row->PaidDays;
				$res['desc'] = $row->Description;
				$res['createddate'] = $row->CreatedDate;
				$bankname = $row->BankName;
				$bankcode = $row->BankCode; 
				$bankacct = $row->BankAccountNo;
				$agentid = $row->agent_id;
				
				$res['salarydetail'] = array();
				$headarray = array();
				$total=0;$totaldeduction=0;
				
								
						
						//$res['empmonthdate'] =date('Y-m-d');
						
				if($bankcode=="")
				{
					$sql1 = "Select * from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->EmployeeId));
					while($r = $query1->fetch())
					{
						$bankname = Utils::getName($r->BankId, "BankMaster", "Name", $this->db);
						$bankcode = $r->SwiftCode;
						$bankacct = $r->IBAN;
					}
				}
				$res['bankname'] = $bankname;
				$res['bankcode'] = Utils::decode5t($bankcode);
				$res['bankacct'] = Utils::decode5t($bankacct);
				$res['agentid'] = $agentid;
				
				////////////////   FIND OUT THE COMPANY DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT Name,Logo FROM Organization WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->OrganizationId ));
				while($row1 = $query1->fetch())
				{
					$res['companyname'] = $row1->Name;
					$res['logo'] = URL."public/uploads/".$row->OrganizationId."/".$row1->Logo;
				}
				
				////////////////   FIND OUT THE EMPLOYEE DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->EmployeeId, $orgid ));
				while($row1 = $query1->fetch())
				{
					$res['id'] = $row1->Id;
					$res['name'] = ucwords(strtolower($row1->FirstName." ".$row1->LastName));
					$res['empcode'] = $row1->EmployeeCode;
					$res['empdivision'] = $this->getName($row1->Division,'DivisionMaster');
					$res['empdept'] = $this->getName($row1->Department,'DepartmentMaster');
					$res['empdesig'] = $this->getName($row1->Designation,'DesignationMaster');
					$res['empshift'] =$this->getName( $row1->Shift,'ShiftMaster');
					$res['empgrade'] = $this->getName($row1->Grade,'GradeMaster');
					$ctc = $row1->EmployeeCTC;
					$res['empctc'] = $ctc;
					$doj = $row1->DOJ;
					$lta=$row1->IATAFare;
					$ltamonth=$row1->OnceIn;
					$onedaysal = round($ctc/30, 2);
				}
				$res['empmonthdate']= $month;
				$res['empmonthname']=Utils::monthdateformatter($month);
				$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
				$res['emppaiddays']=$number;
				$newjoineeflg=false;
				if(date($res['empmonthdate'])<date($doj))
				{
					$d = date('d', strtotime($doj));
					$res['emppaiddays'] = $res['emppaiddays']-($d-1);
					$ctc = round(($res['emppaiddays'] * $onedaysal),2);
					$newjoineeflg=true;
				}
				////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT *, sh.headtype as type FROM SalaryHead sh, SalaryChild sc where sc.headtype=1 and sc.headid=sh.id and salaryid=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->Id;
					$res1['amount'] = (float)$row1->HeadAmount;					
					$res1['name'] =(($row1->type==3)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 1;
					$res1['headtype'] = (int)($row1->type==3)?0:$row1->type;
					$res1['payslip'] = (int)$row1->IncludeInPayslip;
					$res1['additions'] = ($row1->type==3)?0:1;
					$headarray[]=$res1;
					if($row1->type==3)
					$totaldeduction += (float)$row1->HeadAmount;
					else
					$total += (float)$row1->HeadAmount;
				}
				
				///////////// LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////////////////////		
				$sql1 = "SELECT * FROM SalaryOtherHead sh, SalaryChild sc where sc.headtype=2 and sc.headid=sh.HeadCode and sc.salaryid=? and sh.OrganizationId=? and ActiveSts=1 ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ,$orgid));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->HeadCode;
					$res1['amount'] = (float)$row1->HeadAmount;
					$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 2;
					$res1['headtype'] = (int)$row1->Type;
					$res1['payslip'] = (int)$row1->IncludeInPayslip;
					$res1['additions'] = ($row1->Type==0)?0:1;
					$headarray[]=$res1;
					
					if($row1->Type)
					$total += (float)$row1->HeadAmount;
					else
					$totaldeduction += (float)$row1->HeadAmount;
				}
				$sql1 = "SELECT HeadId,HeadAmount FROM EmployeeSalaryDetails WHERE OrganizationId = ? and EmployeeId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $row->EmployeeId ));
				if($query1->rowCount()>0)
				{
					while($row1 = $query1->fetch())
					{
						for($i=0; $i<count($headarray); $i++)
						{
							$temp=0;
							if(($headarray[$i]['id']==$row1->HeadId ) && ($headarray[$i]['type']==1))
							{
								//$headarray[$i]['name'];
								$temp=$headarray[$i]['amount'];
								if($headarray[$i]['additions'] && !$newjoineeflg){
									$headarray[$i]['amount']=(float)$row1->HeadAmount ;
									$total -= (float) $temp ;
									$total += (float)$row1->HeadAmount ;
									break;
								}elseif($headarray[$i]['additions'] && $newjoineeflg){
									$paidamt=(float)(($row1->HeadAmount/30)*$res['emppaiddays']);
									$paidamt=round($paidamt,2);
									$headarray[$i]['amount']=$paidamt;
									$total -= (float) $temp ;
									$total += $paidamt;
									break;
								}
								
							}
						}	
					}
							//$res['salarysts'] = true;
				}
						$month=$row->SalaryMonth;
						$salaryadvance_installment=0;
						////////////////   FIND OUT THE SALARY ADVANCE INSTALLMENT DEDUCTION AVAILABLE  /////////////////////////////				
						
						$leavededuction=0;
						
						$leavedays=0;
						$sql1 = "Select HalfDaySts,LossOfPay,Entitled,PaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and empleave.LeaveStatus=2 and (empchild.LeaveDay between '$month' and LAST_DAY('$month')) and empleave.OrganizationId = ? and empleave.EmployeeId =?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->EmployeeId));
						while($row1 = $query1->fetch())
						{
							if($row1->HalfDaySts==1 && $row1->LossOfPay==1)
								$leavedays=$leavedays+0.5;
							elseif($row1->HalfDaySts==0 && $row1->LossOfPay==1)
								$leavedays++;
							if($row1->PaySts == 2 && $row1->Entitled == 1)
								$leavedays=$leavedays+0.5;
							elseif($row1->PaySts == 0 && $row1->Entitled == 1)
								$leavedays++;
						}
						
						$res['emppaiddays'] = $res['emppaiddays']-($leavedays);
						//echo $leavedays;
						$leavededuction = round($onedaysal*$leavedays);
						
						for($i=0; $i<count($headarray); $i++)
						{
							$temp=0;
							if(($headarray[$i]['id']==9) && ($ltamonth>0) && ($headarray[$i]['type']==2))
							{
								/*if($this->getLTA($row->EmployeeId, $ltamonth)){
									$temp=$headarray[$i]['amount'];
									$headarray[$i]['amount'] = (float)$lta;
									$total -= (float)$temp ;
									$total += (float)$lta ;
								}*/
								
							}else if(($headarray[$i]['id']==5) && ($headarray[$i]['type']==2)){
								$incentive = $this->getEmployeeIncentive($row->EmployeeId, $month, 2);
								$temp=$headarray[$i]['amount'];
								$headarray[$i]['amount'] = (float)$incentive;
								$total -= (float)$temp ;
								$total += (float)$incentive ;
							}else if(($headarray[$i]['id']==4) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$headarray[$i]['amount'] = (float)$leavededuction;
								$totaldeduction -= (float)$temp ;
								$totaldeduction += (float)$leavededuction ;
							}else if(($headarray[$i]['id']==1) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$salaryadvance_installment=$this->getEmployeeLoanInstallment($row->EmployeeId,$month,2);
								$headarray[$i]['amount'] = (float)$salaryadvance_installment;
								$totaldeduction -= (float)$temp ;
								$totaldeduction  += (float)$salaryadvance_installment ;
							}else if(($headarray[$i]['id']==2) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$overtime = $this->getEmployeeOvertime($row->EmployeeId, $month);
								$headarray[$i]['amount'] = (float)$overtime;
								$total -= (float)$temp ;
								$total += (float)$overtime ;
							}
						}
				
				
				if($row->FinalSettlementSts==1)
				{
					$res['emppaiddays'] = $row->PaidDays;
				}
				$res['salarydetail'] = $headarray;
				$res['emptotal'] = round($total);
				
				$res['emptotaldeduction'] = round($totaldeduction);
				$netpay=$total-$totaldeduction;
				$res['netpay'] = round($netpay);
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYMASTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=SALARYMASTER_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getMonthPayrollDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$month = $request[2];	//SALARY ID CONTAINS IN ARRAY THIRD VALUE;
		$month = date('Y-m-01',strtotime($request[2]));
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
       try{
		
			$headarray=array();
			
			////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
			$sql1 = "SELECT Id,Name,HeadType FROM SalaryHead WHERE OrganizationId = ? ORDER BY field(HeadType, 4,1,2,3),Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ));
			while($row1 = $query1->fetch())
			{
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->HeadType==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 1;
				$res1['additions']=(($row1->HeadType==3)?0:1);
				$res1['headtype'] = (float)$row1->HeadType;
				$headarray[]=$res1;
			}
			///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
			$sql1 = "SELECT Id,Name,Type,HeadCode FROM SalaryOtherHead where OrganizationId=? and ActiveSts=1  ORDER BY Type,Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($orgid));
			while($row1 = $query1->fetch())
			{
				$res1 = array();
				$res1['id'] = $row1->HeadCode;
				$res1['amount'] = 0;
				$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 2;
				$res1['additions']=(($row1->Type==0)?0:1);
				$res1['headtype'] = (float)$row1->Type;
				$headarray[]=$res1;
			}
			$this->db->beginTransaction();	
        $sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids) and em.Is_Delete=0 order by Division, DOJ";
		if($hrsts==1 || $sts==1){
			$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and em.Is_Delete=0  order by Division, DOJ ";//and FinalSettlementSts=0
		}
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				while($row = $query->fetch())
				{
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->sid;
					$res['employee'] = $row->EmployeeId;
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					//$res['empctc'] = $row->EmployeeCTC;
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['empcode'] = $row->EmployeeCode;
					$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$ctc = $row->empctc;	
					$res['empctc']=$row->empctc;
					$res['salarydetail'] = array();
					
					
					$grandctc += $row->empctc; 
					$granddays +=$row->PaidDays;
					
					
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////	
					
					$sql1 = "SELECT HeadId,HeadAmount,HeadType from SalaryChild where SalaryId=? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $salaryid ));
					while($row1 = $query1->fetch())
					{
						if($row1->HeadType==1){
							for($i=0;$i<count($headarray);$i++){
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
								{
									$headarray[$i]['amount']=(float) $row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction += (float)$row1->HeadAmount;
									else
									$emptotal += (float)$row1->HeadAmount;
										
										break;
								}
							
							}
						}
						if($row1->HeadType==2){
							for($i=0;$i<count($headarray);$i++){	
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==2))
								{
									$headarray[$i]['amount']=(float) $row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction += (float)$row1->HeadAmount;
									else
									$emptotal += (float)$row1->HeadAmount;
										
										break;
								}
							}
						}
					}
					
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						
						
						$res['salarydetail']=$headarray;
						
						for($i=0; $i<count($headarray); $i++)
						{
							$headarray[$i]['amount']=0 ;
						}
						
					
					$res['emptotaldeduction'] = $emptotaldeduction;
					$res['netpay'] = $emptotal-$emptotaldeduction;
					$res['empctc'] = $ctc;
					$res['emptotal'] = $emptotal;
					$res['sts'] = true;
					$data[] = $res;
					$grandtotal +=$emptotal;
					$grandtotaldeduction += $emptotaldeduction;
					$grandnettotals +=($emptotal-$emptotaldeduction);
				}
				for($i=0; $i<count($headarray); $i++)
				{
					$headarray[$i]['amount']="" ;
				}
				$res = array();
				$res['salaryid'] = 0;
				$res['name'] = "Grand Total";
				$res['empdivision'] = "Grand Total";
				$res['empmonthdate'] = '-';
				$res['empctc'] = $grandctc;
				$res['emppaiddays'] = $granddays;
				$res['empmonthname'] ='-';
				$res['salarydetail'] = $headarray;
				$res['emptotal'] = $grandtotal;
				$res['emptotaldeduction'] = $grandtotaldeduction;
				$res['netpay'] = $grandnettotals;
				$data[] = $res;
		
		}
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = SALARYMASTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg="Payroll not found for ".date("F Y",strtotime(date($month)));
        }
		$companyname = ""; $logo ="";
		////////////////   FIND OUT THE COMPANY DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT Name,Logo FROM Organization WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid ));
				while($row1 = $query1->fetch())
				{
					$companyname = $row1->Name;
					$logo = URL."public/uploads/".$orgid."/".$row1->Logo;
				}
				
		$result["data"] =$data;
		$result['status']=$status;
		$result['companyname']=$companyname;
		$result['companylogo']=$logo;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	//////////////// FUNCTION TO GET EMPLOYEE SALARY DETAILS WHILE ADDING SALARY ONE BY ONE ///////////////
	
    public function getEmployeeSalaryDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$date = "";
		$empid = $request[2];
		$lta=0;
		$ltamonth=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
		$sWhere = "";
		$sql1 = "SELECT es.HeadId as headid, HeadAmount, Name, es.HeadType as headtp FROM EmployeeSalaryDetails es, SalaryHead sh WHERE es.HeadId=sh.Id and es.OrganizationId = ? and EmployeeId=? order by es.HeadType ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $empid ));
				if( $query1->rowCount()==0)
				{
					$result["data"] =$data;
					$result['status']=$status;
					$result['successMsg']=$successMsg;
					$result['errorMsg']="Salary not defined for the employee";
					
					return $result;
				}
		try{
        $sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? AND Id=? and EmployeeCTC > 0 and DOL ='0000-00-00' $sWhere";
        $query = $this->db->prepare($sql);
		
			
			$query->execute(array( $orgid, $empid ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$emptotal = 0;
				$emptotaldeduction=0;
				$onedaysal=0;
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empcode'] = $row->EmployeeCode;
				$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
				$res['empdept'] = $this->getName($row->Department,'DepartmentMaster');
				$res['empdesig'] = $this->getName($row->Designation,'DesignationMaster');
				$res['empshift'] =$this->getName( $row->Shift,'ShiftMaster');
				$res['empgrade'] = $this->getName($row->Grade,'GradeMaster');
				$res['empctc'] = $row->EmployeeCTC;
				$ctc = $row->EmployeeCTC;
				$res['empmonthname']=""; 
				$res['empmonthdate']=""; 
				$res['emppaiddays']=0;				
				$res['salarydetail'] = array();
				$lta=$row->IATAFare;
				$ltamonth=$row->OnceIn;
				
				$onedaysal = ($ctc)/30;
				
///////////////////// FIND OUT THE SALARY MONTH FOR THE EMPLOYEE ////////////////////////////
				$sql1 = "SELECT SalaryMonth FROM SalaryMaster WHERE EmployeeId=? order by Id desc limit 1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id));
				if($query1->rowCount()>0)
				{
					while($row1 = $query1->fetch())
					{
						//$res1['id'] = $row1->SalaryMonth;
						$date = date('Y-m-d', strtotime(date('Y-m', strtotime($row1->SalaryMonth))." +1 month"));
						$res['empmonthdate']= $date;
						$res['empmonthname']= Utils::monthdateformatter($date);
						$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($date)), date('Y', strtotime($date)));
						$res['emppaiddays']=$number;
					}
				}else{
					$sqlfis = "SELECT StartDate FROM FiscalMaster WHERE OrganizationId=? and FiscalSts=1";
					$queryfis = $this->db->prepare($sqlfis);
					$queryfis->execute(array($orgid));
					if($queryfis->rowCount()>0)
					{
						while($rowfis = $queryfis->fetch())
						{
							$date = $rowfis->StartDate;//date('Y-m-d', strtotime(date('Y-m', strtotime($rowfis->StartDate))." +1 month"));
							$res['empmonthdate']= $date;
							$res['empmonthname']= Utils::monthdateformatter($date);
							$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($date)), date('Y', strtotime($date)));
							$res['emppaiddays']=$number;
						}
						
					}else{
						$date = date('Y-m-d', strtotime(date('Y-m', strtotime($row->DOJ))));
						$res['empmonthdate']= $date;
						$res['empmonthname']=date('F Y', strtotime($date));
						$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($date)), date('Y', strtotime($date)));
						$res['emppaiddays']=$number;
					}
				}
				
				if(date($res['empmonthdate'])<date($row->DOJ))
				{					
					$d = date('d', strtotime($row->DOJ));
					$res['emppaiddays'] = $res['emppaiddays']-($d-1);
					$ctc = round(($onedaysal * $res['emppaiddays']), 2);
					
				}
				
				//$sql1 = "SELECT es.HeadId as headid, HeadAmount, Name, es.HeadType as headtp FROM EmployeeSalaryDetails es, SalaryHead sh WHERE es.HeadId=sh.Id and es.OrganizationId = ? and EmployeeId=? order by es.HeadType ";
				
				$sql1 = "SELECT sh.Id, sh.HeadType, coalesce(HeadAmount,0,HeadAmount) as headamount, sh.Name  FROM SalaryHead sh LEFT JOIN EmployeeSalaryDetails es ON  es.HeadId=sh.Id and EmployeeId=? and sh.OrganizationId = ?  ";
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $empid, $orgid ));
				while($row1 = $query1->fetch())
				{
						$res1 = array();
						$res1['id'] = $row1->Id;
						
						if($row1->HeadType != 3){
							$res1['name'] ="(+) ".$row1->Name;
							$res1['headtype'] = $row1->HeadType;
							$res1['amount'] = $row1->headamount;
						}else{
							$res1['name'] ="(-) ".$row1->Name;
							$res1['headtype'] = 0;
							$res1['amount'] = (float)$row1->headamount;
						}
						$res1['type'] = 1;
						$emptotal += (float)$row1->headamount;
						$res['salarydetail'][]=$res1;
				}
				
				
				$salaryadvance=0;$salaryadvance_installment=0;
////////////////   FIND OUT THE SALARY ADVANCE ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT AdvanceAmount FROM SalaryAdvance WHERE OrganizationId = ? and EmployeeId=? and ApplyMonth=? and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $empid, $date));
				if($query1->rowCount()>0)
				{
					while($row1 = $query1->fetch())
					{
						$salaryadvance = $row1->AdvanceAmount;
						//$emptotal  += $row1->AdvanceAmount;
					}
				}else{
				
////////////////   FIND OUT THE SALARY ADVANCE INSTALLMENT DEDUCTION AVAILABLE  /////////////////////////////			

					$salaryadvance_installment = $this->getEmployeeLoanInstallment($empid, $date, 2) ;
				}

				$leavededuction=0;
////////////////   FIND OUT THE LEAVE DEDUCTION AVAILABLE  /////////////////////////////			
	
				$leavededuction = 0;//$this->getEmployeeLeave($empid, $date, date("Y-m-t", strtotime($date)), $onedaysal, 2);
				$leavedays=0;
				$sql1 = "Select * from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=1 and empchild.LeaveStatus=2 and (empchild.LeaveDay between '$date' and LAST_DAY('$date')) and empleave.OrganizationId = ? and empleave.EmployeeId =?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,$empid));
				while($row1 = $query1->fetch())
				{
					if($row1->HalfDaySts==1)
					{
						$leavedays=$leavedays+0.5;
					}else{
						$leavedays++;
					}
				}
				//echo $leavedays;
				$leavededuction = round($onedaysal*$leavedays,2);

				$overtime=0;$weekoff=0; $holiday=0; $weekdays=0;
////////////////   FIND OUT THE OVERTIME AVAILABLE FOR THE EMPLOYEE /////////////////////////////				
				
				
////////////////   FIND OUT THE OVERTIME PAYMENT AVAILABLE FOR THE ORGANIZATION /////////////////////////////				
				
				$overtime = 0;//$this->getEmployeeOvertime($empid, $date, date("Y-m-t", strtotime($date)), 2);
				
////////////////// LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ///////////				
				$sql1 = "SELECT * FROM SalaryOtherHead WHERE HeadSts=1 and OrganizationId=? and ActiveSts=1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->HeadCode;
					$res1['amount'] = 0;
					if($row1->Id==8){
						$res1['amount'] = (float)$salaryadvance;
						$emptotal += (float)$salaryadvance;
						
					}elseif($row1->Id==9 && $ltamonth>0){
						if($this->getLTA($empid,$ltamonth)){
							$res1['amount'] = (float)$lta;
							$emptotal += (float)$lta;
						}
					}else if($row1->Id==2){
						$res1['amount']  = (float)$overtime;
						$emptotal += (float)$overtime ;
					}else if($row1->Id==5){
						$incentive = $this->getEmployeeIncentive($empid, $date, 2);
						$res1['amount']  = (float)$incentive;
						$emptotal += (float)$incentive ;
					}else if($row1->Id==4){
						$res1['amount']  = (float)$leavededuction;
						$emptotaldeduction += (float)$leavededuction ;
					}else if($row1->Id==1){
						$res1['amount']  = (float)$salaryadvance_installment;
						$emptotaldeduction += (float)$salaryadvance_installment ;
					}
					
					$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 2;
					$res1['headtype'] = (float)$row1->Type;
					$res['salarydetail'][]=$res1;
				}
				
				$bankname =""; $bankcode =""; $bankacct =0;
				$sqlbank = "Select * from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
				$querybank = $this->db->prepare($sqlbank);
				$querybank->execute(array($empid));
				while($r = $querybank->fetch())
				{
					$bankname = Utils::getName($r->BankId, "BankMaster", "Name", $this->db);
					$bankcode = $r->SwiftCode;
					$bankacct = $r->IBAN;
				}
				$res['bankname'] = $bankname;
				$res['bankcode'] = Utils::decode5t($bankcode);
				$res['bankacct'] = Utils::decode5t($bankacct);
				
				$res['empdeduction'] = $emptotaldeduction;
				$res['empnetsalary'] = $emptotal-$emptotaldeduction;
				$res['empctc'] = $ctc;
				$res['emptotal'] = $emptotal-$emptotaldeduction;
				$data[] = $res;
			}
        }else{
			$status=false;
			$errorMsg = "No salary defined for the employee";
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	////////////////  GENERATE EMPLOYEE BULK SALARY  //////////////////////////
	
	public function getEmployeeBulkSalaryDetail1($request,$val)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$headarray = array(); $emparray=array();
		try{
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$month = $this->getSalaryMonth($request);//Utils::getDateformat( $request[2]);
		if($val==2)
		{
			$month = $this->getCurrentSalaryMonth($request);
			$salarygenerateddate = $this->getCurrentSalaryGenerateDate($month);
			$extenddate=date('Y-m-d',strtotime("+3 days ".date($salarygenerateddate)));
			if(date($extenddate)<date('Y-m-d'))
			{
				$month = $this->getSalaryMonth($request);
			}
		}
		$division = 0;//isset($_POST['division']) ? $_POST['division'] : "0";
		
		if(date("Y-m-d")<date($month))
		{
			$result["data"] =$data;
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']="Cannot generate future month salary";
		
			return $result;
		}
		$sWhere=""; $nonemptable="";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts!=1 && $hrsts!=1 ){
			$ids = Utils::getReportingIds($mid, $this->db);
			$sWhere = " and Id in ($ids) ";
			$nonemptable=" and EmployeeId in ($ids)";
		}
		if($division!=0){
			$sWhere .= " and Division = $division ";
		}
		$lta = 0;
		$ltamonth = 0;
		
			$this->db->beginTransaction();		
			
			//////////////////check salary is generated or not///////
			$sql = "SELECT * FROM SalaryMaster WHERE OrganizationId = ? $nonemptable and SalaryMonth=? and FinalSettlementSts=0 ";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				while($row = $query->fetch())
				{
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->Id;
					$res['employee'] = $row->EmployeeId;
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					//$res['empctc'] = $row->EmployeeCTC;
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$bankname = $row->BankName;
					$bankcode = $row->BankCode; 
					$bankacct = $row->BankAccountNo;
					
					$res['salarydetail'] = array();
					$headarray = array();
					
					
					if($bankcode=="" || $bankname=="" || $bankacct==0)
					{
						$sql1 = "Select BankId,SwiftCode,IBAN from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($row->EmployeeId));
						while($r = $query1->fetch())
						{
							$bankname = Utils::getName($r->BankId, "BankMaster", "Name", $this->db);
							$bankcode = $r->SwiftCode;
							$bankacct = $r->IBAN;
						}
					}
					$res['bankname'] = $bankname;
					$res['bankcode'] = Utils::decode5t($bankcode);
					$res['bankacct'] = Utils::decode5t($bankacct);
					
					
					
					////////////////   FIND OUT THE EMPLOYEE DETAILS ARE AVAILABLE  /////////////////////////////				
					$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->EmployeeId, $orgid ));
					while($row1 = $query1->fetch())
					{
						
						$res['id'] = $row1->Id;
						$res['name'] = ucwords(strtolower($row1->FirstName." ".$row1->LastName));
						$res['empcode'] = $row1->EmployeeCode;
						$res['empdivision'] = $this->getName($row1->Division,'DivisionMaster');
						$res['empdept'] = $this->getName($row1->Department,'DepartmentMaster');
						$res['empdesig'] = $this->getName($row1->Designation,'DesignationMaster');
						$res['empshift'] =$this->getName( $row1->Shift,'ShiftMaster');
						$res['empgrade'] = $this->getName($row1->Grade,'GradeMaster');
						$res['empctc']=$row1->EmployeeCTC;
						$ctc = $row1->EmployeeCTC;
						$res['empmonthname']=""; 
						$res['empmonthdate']=""; 
						//$res['emppaiddays']=0;
						$res['emplta']=$row1->IATAFare;
						$lta=$row1->IATAFare;
						$ltamonth=$row1->OnceIn;
						$doj=$row1->DOJ;
						
						$onedaysal = round($ctc/30, 2);
					}
					
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
						$sql1 = "SELECT *, sh.headtype as type FROM SalaryHead sh, SalaryChild sc where sc.headtype=1 and sc.headid=sh.id and salaryid=? ORDER BY field(sh.HeadType, 4,1,2,3),sh.Id";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $salaryid ));
						while($row1 = $query1->fetch())
						{
							$res1 = array();
							$res1['id'] = $row1->Id;
							$res1['amount'] = (float)$row1->HeadAmount;					
							$res1['name'] =(($row1->type==3)?"(-) ":"(+) ").$row1->Name;
							$res1['label'] =(($row1->type==3)?"(-) ":"(+) ").$row1->Name;
							$res1['type'] = 1;
							$res1['headtype'] = (float)($row1->type==3)?0:$row1->type;
							$res1['payslip'] = (float)$row1->IncludeInPayslip;
							$res1['additions'] = ($row1->type==3)?0:1;
							$headarray[]=$res1;
							if($row1->type==3)
							$emptotaldeduction += (float)$row1->HeadAmount;
							else
							$emptotal += (float)$row1->HeadAmount;
						}
						
						///////////// LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////////////////////		
						$sql1 = "SELECT * FROM SalaryOtherHead sh, SalaryChild sc where sc.headtype=2 and sc.headid=sh.id and sc.salaryid=? and sh.OrganizationId=?  and sh.ActiveSts=1 order by Field(Type, 0,1), Id";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $salaryid,$orgid ));
						while($row1 = $query1->fetch())
						{
							$res1 = array();
							$res1['id'] = $row1->HeadCode;
							$res1['amount'] = (float)$row1->HeadAmount;
							$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
							$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
							$res1['type'] = 2;
							$res1['headtype'] = (float)$row1->Type;
							$res1['payslip'] = (float)$row1->IncludeInPayslip;
							$res1['additions'] = ($row1->Type==0)?0:1;
							$headarray[]=$res1;
							
							if($row1->Type)
							$emptotal += (float)$row1->HeadAmount;
							else
							$emptotaldeduction += (float)$row1->HeadAmount;
							
							
						}
					
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
						
						$res['emppaiddays']=$number;
								
						$newjoineeflg=false;
						//$res['empmonthdate'] =date('Y-m-d');
						if(date($res['empmonthdate'])<date($doj))
						{
							$d = date('d', strtotime($doj));
							$res['emppaiddays'] = $res['emppaiddays']-($d-1);
							//$ctc = round(($res['emppaiddays'] * $onedaysal),2);
							$newjoineeflg=true;
						}
						
						$res['salarysts'] = true;
						$salaryadvance_installment=0;
						////////////////   FIND OUT THE SALARY ADVANCE INSTALLMENT DEDUCTION AVAILABLE  /////////////////////////////				
						/*$sql1 = "SELECT AdvanceAmount, InstallmentAmt FROM SalaryAdvance WHERE OrganizationId = ? and EmployeeId=? and LeaveStatus=2 AND '$month' BETWEEN date_add(ApplyMonth, interval 1 month) AND date_add(ApplyMonth, interval InstallmentAmt month)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->EmployeeId));
						while($row1 = $query1->fetch())
						{
							$salaryadvance_installment = $row1->AdvanceAmount/$row1->InstallmentAmt;
							
						}	*/

						$leavededuction=0;
						
						$leavedays=0;
						$sql1 = "Select HalfDaySts,LossOfPay,Entitled,PaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and (empchild.LeaveDay between '$month' and LAST_DAY('$month')) and empleave.OrganizationId = ? and empleave.EmployeeId =?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->EmployeeId));
						while($row1 = $query1->fetch())
						{
							if($row1->HalfDaySts==1 && $row1->LossOfPay==1)
								$leavedays=$leavedays+0.5;
							elseif($row1->HalfDaySts==0 && $row1->LossOfPay==1)
								$leavedays++;
							if($row1->PaySts == 2 && $row1->Entitled == 1)
								$leavedays=$leavedays+0.5;
							elseif($row1->PaySts == 0 && $row1->Entitled == 1)
								$leavedays++;
						}
						
						
						$res['emppaiddays'] = $res['emppaiddays']-($leavedays);
						//echo $leavedays;
						$leavededuction = round($onedaysal*$leavedays);
						
						for($i=0; $i<count($headarray); $i++)
						{
							$temp=0;
							if(($headarray[$i]['id']==9) && ($ltamonth>0) && ($headarray[$i]['type']==2))
							{
								/*if($this->getLTA($row->EmployeeId, $ltamonth)){
									$temp=$headarray[$i]['amount'];
									$headarray[$i]['amount'] = (float)$lta;
									$emptotal -= (float)$temp ;
									$emptotal += (float)$lta ;
								}*/
								
								
							}else if(($headarray[$i]['id']==5) && ($headarray[$i]['type']==2)){
								$incentive = $this->getEmployeeIncentive($row->EmployeeId, $month, 2);
								$temp=$headarray[$i]['amount'];
								$headarray[$i]['amount'] = (float)$incentive;
								$emptotal -= (float)$temp ;
								$emptotal += (float)$incentive ;
							}else if(($headarray[$i]['id']==4) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$headarray[$i]['amount'] = (float)$leavededuction;
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction += (float)$leavededuction ;
							}else if(($headarray[$i]['id']==1) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$salaryadvance_installment=$this->getEmployeeLoanInstallment($row->EmployeeId,$month,2);
								$headarray[$i]['amount'] = (float)$salaryadvance_installment;
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction  += (float)$salaryadvance_installment ;
							}else if(($headarray[$i]['id']==2) && ($headarray[$i]['type']==2)){
								$overtime = $this->getEmployeeOvertime($row->EmployeeId, $month);
								$headarray[$i]['amount'] = (float)$overtime;
								$emptotal += (float)$overtime ;
							}
						}
						$res['salarydetail']=$headarray;
						
						for($i=0; $i<count($headarray); $i++)
						{
							$headarray[$i]['amount']=0 ;
							$headarray[$i]['name']="" ;
						}
					
					$status=true;
					$successMsg="$count Employees fetched successfully.";
					
					
					$res['empdeduction'] = $emptotaldeduction;
					$res['empnetsalary'] = $emptotal-$emptotaldeduction;
					$res['empctc'] = $ctc;
					$res['emptotal'] = $emptotal-$emptotaldeduction;
					$res['sts'] = true;
					$data[] = $res;
				}
				
			}else{
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
					$sql1 = "SELECT Id,Name,HeadType FROM SalaryHead WHERE OrganizationId = ? ORDER BY field(HeadType, 4,1,2,3),Id";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $request[1]));
					while($row1 = $query1->fetch())
					{
						$res1 = array();
						$res1['id'] = $row1->Id;
						$res1['amount'] = 0;
						$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").$row1->Name;
						$res1['type'] = 1;
						$res1['additions']=(($row1->HeadType==3)?0:1);
						$res1['headtype'] = (float)$row1->HeadType;
						$headarray[]=$res1;
					}
					///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
					$sql1 = "SELECT Id,Name,Type,HeadCode FROM SalaryOtherHead WHERE HeadSts=1 and OrganizationId=? and ActiveSts=1 ORDER BY Type,Id";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($orgid));
					while($row1 = $query1->fetch())
					{
						$res1 = array();
						$res1['id'] = $row1->HeadCode;
						$res1['amount'] = 0;
						$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
						$res1['type'] = 2;
						$res1['additions']=(($row1->Type==0)?0:1);
						$res1['headtype'] = (float)$row1->Type;
						$headarray[]=$res1;
					}
				
				$date1 = date('Y-m-d', strtotime(date('Y-m-01', strtotime($month))." +1 month"));
				///and EmployeeStatus in (4,5)
				$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00' $sWhere and DOJ<='$month' and Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$month') and OrganizationId = ?) and Id NOT IN (SELECT EmployeeId from SalaryMaster where SalaryMonth='$month' and OrganizationId = ?) order by Division, EmployeeCode, FirstName, MiddleName, LastName ";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $orgid, $orgid));
				$count =  $query->rowCount();
				
				if($count>=1)
				{
					$status=true;
					$empcount=0;
					while($row = $query->fetch())
					{
						$emptotal = 0;
						$emptotaldeduction = 0;
						$onedaysal =0;
						$res = array();
						$res['id'] = $row->Id;
						$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
						$res['empcode'] = $row->EmployeeCode;
						$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
						//$res['empdept'] = $this->getName($row->Department,'DepartmentMaster');
						$res['empdesig'] = $this->getName($row->Designation,'DesignationMaster');
						//$res['empshift'] =$this->getName( $row->Shift,'ShiftMaster');
						//$res['empgrade'] = $this->getName($row->Grade,'GradeMaster');
						$res['empctc'] = $row->EmployeeCTC;
						$ctc = $row->EmployeeCTC;
						$res['empmonthname']=""; 
						$res['empmonthdate']=""; 
						$res['emppaiddays']=0;
						$res['emplta']=$row->IATAFare;
						$res['desc'] = "";
						$lta=$row->IATAFare;
						$ltamonth=$row->OnceIn;
						
						$onedaysal = round($ctc/30, 2);
						//$res['salarydetail'] = array();
						
						$bankname = "";
						$bankcode = "";
						$bankacct = 0;
						$sql1 = "Select BankId,SwiftCode,IBAN from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($row->Id));
						while($r = $query1->fetch())
						{
							$bankname = Utils::getName($r->BankId, "BankMaster", "Name", $this->db);
							$bankcode = $r->SwiftCode;
							$bankacct = $r->IBAN;
						}
						
						$res['bankname'] = $bankname;
						$res['bankcode'] = Utils::decode5t($bankcode);
						$res['bankacct'] = Utils::decode5t($bankacct);
		///////////////////// FIND OUT THE SALARY MONTH FOR THE EMPLOYEE ////////////////////////////
						//$month = $month;
						//$date = date('Y-m-d', strtotime(date('Y-m-01', strtotime($month))));
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
						
						$res['emppaiddays']=$number;
								
						$newjoineeflg=false;
						//$res['empmonthdate'] =date('Y-m-d');
						if(date($res['empmonthdate'])<date($row->DOJ))
						{
							$d = date('d', strtotime($row->DOJ));
							$res['emppaiddays'] = $res['emppaiddays']-($d-1);
							//$ctc = round(($res['emppaiddays'] * $onedaysal),2);
							$newjoineeflg=true;
						}
						
						
						$sql1 = "SELECT HeadId,HeadAmount FROM EmployeeSalaryDetails WHERE OrganizationId = ? and EmployeeId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->Id ));
						if($query1->rowCount()>0)
						{
							while($row1 = $query1->fetch())
							{
								for($i=0; $i<count($headarray); $i++)
								{
									if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
									{
										
										if($headarray[$i]['additions'] && !$newjoineeflg){
											$headarray[$i]['amount']=(float)$row1->HeadAmount ;
											$emptotal += (float)$row1->HeadAmount ;
											break;
										}elseif($headarray[$i]['additions'] && $newjoineeflg){
											$paidamt=(float)(($row1->HeadAmount/30)*$res['emppaiddays']);
											$paidamt=round($paidamt,2);
											$headarray[$i]['amount']=$paidamt;
											$emptotal += $paidamt;
											break;
										}else{
											$headarray[$i]['amount']=(float)$row1->HeadAmount ;
											$emptotaldeduction += (float)$row1->HeadAmount ;
											break;
										}
										
									}
								}	
							}
							//$res['salarysts'] = true;
						}else{
							//$res['salarysts'] = false;
							$empcount++;
						}	
						$res['salarysts'] = true;
						$salaryadvance_installment=0;
						////////////////   FIND OUT THE SALARY ADVANCE INSTALLMENT DEDUCTION AVAILABLE  /////////////////////////////				
						/*$sql1 = "SELECT AdvanceAmount, InstallmentAmt FROM SalaryAdvance WHERE OrganizationId = ? and EmployeeId=? and LeaveStatus=2 AND '$month' BETWEEN date_add(ApplyMonth, interval 1 month) AND date_add(ApplyMonth, interval InstallmentAmt month)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->Id));
						while($row1 = $query1->fetch())
						{
							$salaryadvance_installment = $row1->AdvanceAmount/$row1->InstallmentAmt;
							
						}	*/

						$leavededuction=0;
						////////////////   FIND OUT THE LEAVE DEDUCTION AVAILABLE  /////////////////////////////				
						/*$sql1 = "SELECT COUNT(Id) as leavecount FROM AttendanceMaster WHERE OrganizationId = ? and EmployeeId=? and AttendanceStatus=6 AND (AttendanceDate BETWEEN '$month' AND LAST_DAY('$month'))";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->Id));
						while($row1 = $query1->fetch())
						{
							$leavededuction = $onedaysal*$row1->leavecount;
							//$emptotal  -= $row1->AdvanceAmount;
						}*/
						$leavedays=0;
						$sql1 = "Select HalfDaySts,LossOfPay,Entitled,PaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and (empchild.LeaveDay between '$month' and LAST_DAY('$month')) and empleave.OrganizationId = ? and empleave.EmployeeId =?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->Id));
						while($row1 = $query1->fetch())
						{
							if($row1->HalfDaySts==1 && $row1->LossOfPay==1)
								$leavedays=$leavedays+0.5;
							elseif($row1->HalfDaySts==0 && $row1->LossOfPay==1)
								$leavedays++;
							if($row1->PaySts == 2 && $row1->Entitled == 1)
								$leavedays=$leavedays+0.5;
							elseif($row1->PaySts == 0 && $row1->Entitled == 1)
								$leavedays++;
						}
						
						$res['emppaiddays'] = $res['emppaiddays']-($leavedays);
						//echo $leavedays;
						$leavededuction = round($onedaysal*$leavedays);
						
						for($i=0; $i<count($headarray); $i++)
						{
							if(($headarray[$i]['id']==9) && ($ltamonth>0) && ($headarray[$i]['type']==2))
							{
								/*if($this->getLTA($row->Id, $ltamonth)){
									$headarray[$i]['amount'] = (float)$this->getLTA($row->Id, $ltamonth);
									$emptotal += (float)$this->getLTA($row->Id, $ltamonth) ;
								}*/
								
							}else if(($headarray[$i]['id']==5) && ($headarray[$i]['type']==2)){
								$incentive = $this->getEmployeeIncentive($row->Id, $month, 2);
								$headarray[$i]['amount'] = (float)$incentive;
								$emptotal += (float)$incentive ;
							}else if(($headarray[$i]['id']==4) && ($headarray[$i]['type']==2)){
								$headarray[$i]['amount'] = (float)$leavededuction;
								$emptotaldeduction += (float)$leavededuction ;
							}else if(($headarray[$i]['id']==1) && ($headarray[$i]['type']==2)){
								$salaryadvance_installment=$this->getEmployeeLoanInstallment($row->Id,$month,2);
								$headarray[$i]['amount'] = (float)$salaryadvance_installment;
								$emptotaldeduction  += (float)$salaryadvance_installment ;
							}else if(($headarray[$i]['id']==2) && ($headarray[$i]['type']==2)){
								$overtime = $this->getEmployeeOvertime($row->Id, $month);
								$headarray[$i]['amount'] = (float)$overtime;
								$emptotal += (float)$overtime ;
							}
						}
						$res['salarydetail']=$headarray;
						
						for($i=0; $i<count($headarray); $i++)
						{
							$headarray[$i]['amount']=0 ;
							//$headarray[$i]['name']="" ;
						}
								
						$res['empdeduction'] = $emptotaldeduction;
						$res['empnetsalary'] = $emptotal-$emptotaldeduction;
						$res['empctc'] = $ctc;
						$res['emptotal'] = $emptotal-$emptotaldeduction;
						$res['sts'] = $res['salarysts'];
						$data[] = $res;
					}
					if($empcount>0){
						$status=true;
						$successMsg=$empcount." Employee found without salary distribution.";
					}
				}else{
					$status=false;
					$errorMsg = "No employee left to generate salary";
				}
				
			}
			//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
				$this->db->commit(); 
			}catch(PDOException $e)
				{
					
					$this->db->rollBack();
					//$errorMsg = 'Message: ' .$e->getMessage();
				}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['mnth']=$month;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmployeeBulkSalaryDetail($request,$val,$batch)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();$remainderearlyleaving=0;$remainderlatecoming=0;
		$headarray = array(); $emparray=array();
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$month = $this->getSalaryMonth($request);//Utils::getDateformat( $request[2]);
			$alreadygenerated=" and Id NOT IN (SELECT EmployeeId from SalaryMaster where OrganizationId=$orgid and SalaryMonth='$month' and (FinalStatus=1 or HoldStatus=1))"; ////////and Id NOT in (SELECT EmployeeId from SalaryMaster where OrganizationId=$orgid and HoldStatus=1)
			if($val==2)
			{
				$month = $this->getCurrentSalaryMonthold($request);
				$salarygenerateddate = $this->getCurrentSalaryGenerateDate($month);
				$extenddate=date('Y-m-d',strtotime("+7 days ".date($salarygenerateddate)));
				if(date($extenddate)<date('Y-m-d'))
				{
					//$month = $this->getSalaryMonth($request);
				}
				//$this->getSalaryMonth($request);
				$alreadygenerated="";
				
			}
			///////////// IF SALARY IS ALREADY BEEN GENERATED FOR CERTAIN EMPLOYEES, THEN THEY CAN NOT COME IN GENERATE SALARY, AND IF WE HOLD ANY EMP'S SALARY, SO THEY ALSO WILL NOT COME THERE///////////////////////
			$division = is_array($request[3])?implode(",",$request[3]):$request[3];
			$department=is_array($request[4])?implode(",",$request[4]):$request[4];
			$designation=is_array($request[6])?implode(",",$request[6]):$request[6];
			$employeeids=is_array($request[7])?implode(",",$request[7]):$request[7];
			$shiftids=is_array($request[8])?implode(",",$request[8]):$request[8];
			$modepayment=$request[5];
			
			if(date("Y-m-d")<date($month))
			{
				$result["data"] =$data;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']="Cannot generate future month salary";
			
				return $result;
			}
			$sWhere=""; $nonemptable="";
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			if($sts!=1 && $hrsts!=1 ){
				$ids = Utils::getReportingIds($mid, $this->db);
				$sWhere = " and Id in ($ids) ";
				$nonemptable=" and EmployeeId in ($ids)";
			}
			if($division!=0){
				$sWhere .= " and Division in ($division) ";
			}if($department!=0 ){
				$sWhere .= " and Department in ($department)  ";
			}if($modepayment!=0){
				$sWhere .= " and Id in (select EmployeeId from SalaryMaster where ModePayment=$modepayment and OrganizationId=$orgid )  ";
			}if($designation!=0 ){
				$sWhere .= " and Designation in ($designation)  ";
			}if($employeeids!=0 ){
				$sWhere .= " and Id in ($employeeids)  ";
			}if($shiftids!=0 ){
				$sWhere .= " and Shift in ($shiftids)  ";
			}
		
			$this->db->beginTransaction();		
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and (DOL='0000-00-00' or DOL>LAST_DAY('$month')) and Is_Delete=0 $sWhere and DOJ<=LAST_DAY('$month') and Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$month') and OrganizationId = ?) $alreadygenerated order by Division, EmployeeCode, FirstName, MiddleName, LastName ";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $orgid));
			$count =  $query->rowCount();
				
			if($count>=1)
				{
					$status=true;
					$empcount=0;
					while($row = $query->fetch())
					{
						$emptotal = 0;
						$emptotaldeduction = 0;
						$onedaysal =0;
						$onedaybasic =0;
						$res = array();
						$empid=$res['id'] = $row->Id;
						$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
						$res['empcode'] = $row->EmployeeCode;
						$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
						$res['empcurency'] = Utils::getDivisioncurrency($row->Division,$this->db);
						$res['empdept'] = $this->getName($row->Department,'DepartmentMaster');
						$res['empdesig'] = $this->getName($row->Designation,'DesignationMaster');
						//$res['empshift'] =$this->getName( $row->Shift,'ShiftMaster');
						$res['empgrade'] = $this->getName($row->Grade,'GradeMaster');
						$res['empctc'] = $row->EmployeeCTC;
						$res['modepayment'] = $row->ModePayment;
						$res['modepaymentname'] =Utils::getName($row->ModePayment, "ModeMaster","Name",$this->db);
						$ctc = $row->EmployeeCTC;
						$res['empmonthname']=""; 
						$res['empmonthdate']=""; 
						$res['emppaiddays']=0;
						$res['emplta']=$row->IATAFare;
						$res['desc'] = "";
						$lta=$row->IATAFare;
						$ltamonth=$row->OnceIn;
						
						//$onedaysal = round($ctc/30, 2);
						$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
						$onedaysal = ($ctc/$number);
						//$res['salarydetail'] = array();
						
						$bankid = "";
						$bankname = "";
						$bankcode = "";
						$bankacct = 0;
						$agent_id = 0;
						$sql1 = "Select BankId,SwiftCode,IBAN,agent_id from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($row->Id));
						while($r = $query1->fetch())
						{
							$bankid = $r->BankId;
							$bankname = Utils::getName($r->BankId, "BankMaster", "Name", $this->db);
							$bankcode = $r->SwiftCode;
							$bankacct = $r->IBAN;
							//$agent_id = $r->agent_id;
						}
						
						$res['bankname'] = $bankname;
						$res['agent_id'] = Utils::getName($bankid, "BankMaster", "agent_id", $this->db);
						$res['bankcode'] = Utils::decode5t($bankcode);
						$res['bankacct'] = Utils::decode5t($bankacct);
						///////////////////// FIND OUT THE SALARY MONTH FOR THE EMPLOYEE ////////////////////////////
						//$month = $month;
						//$date = date('Y-m-d', strtotime(date('Y-m-01', strtotime($month))));
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						$res['emppaiddays']=$number;
								
						$newjoineeflg=false;
						//$res['empmonthdate'] =date('Y-m-d');
						if(date($res['empmonthdate'])<date($row->DOJ))
						{
							$d = date('d', strtotime($row->DOJ));
							$res['emppaiddays'] = $res['emppaiddays']-($d-1);
							//$ctc = round(($res['emppaiddays'] * $onedaysal),2);
							$newjoineeflg=true;
						}
						$res['salarydetail'] = array();
						$headarray = array();
						
						$sql1 = "SELECT Id,Description,ModePayment FROM SalaryMaster WHERE OrganizationId = ? and EmployeeId=? and SalaryMonth=? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid,$row->Id,$month));
						
						if($query1->rowCount() > 0){
							while($row1 = $query1->fetch())
							{
								
								if($row1->ModePayment!=0){
									$res['modepayment'] = $row1->ModePayment;
									$res['modepaymentname'] =Utils::getName($row1->ModePayment, "ModeMaster","Name",$this->db);
								}	
								$salaryid=$res['salaryid'] = $row1->Id;
								$res['desc'] = $row1->Description;
								
								////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
								$sql1 = "SELECT *, sh.headtype as type FROM SalaryHead sh, SalaryChild sc where sc.headtype=1 and sc.headid=sh.id and salaryid=? ORDER BY field(sh.HeadType, 4,1,2,3),sh.Id";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array( $salaryid ));
								while($row1 = $query1->fetch())
								{
									$res1 = array();
									$res1['id'] = $row1->Id;
									$res1['amount'] = (float)$row1->HeadAmount;					
									$res1['name'] =(($row1->type==3)?"(-) ":"(+) ").$row1->Name;
									$res1['label'] =(($row1->type==3)?"(-) ":"(+) ").$row1->Name;
									$res1['headname'] = $row1->Name;
									$res1['type'] = 1;
									$res1['headtype'] = (int)($row1->type==3)?0:$row1->type;
									$res1['payslip'] = (int)$row1->IncludeInPayslip;
									$res1['additions'] = ($row1->type==3)?0:1;
									$headarray[]=$res1;
									
									if($row1->type==3)
									$emptotaldeduction += (float)$row1->HeadAmount;
									else
									$emptotal += (float)$row1->HeadAmount;
								}
									
								///////////// LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////////////////////		
								$sql1 = "SELECT * FROM SalaryOtherHead sh, SalaryChild sc where sc.headtype=2 and sc.headid=sh.HeadCode and sc.salaryid=? and sh.OrganizationId=? and ActiveSts=1 AND sh.HeadSts=1 order by Field(Type, 0,1), Id";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array( $salaryid , $orgid));
								while($row1 = $query1->fetch())
								{
									$res1 = array();
									$res1['id'] = $row1->HeadCode;
									$res1['amount'] = (float)$row1->HeadAmount;
									$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
									$res1['headname'] = $row1->Name;
									$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
									$res1['type'] = 2;
									$res1['headtype'] = (int)$row1->Type;
									$res1['payslip'] = (int)$row1->IncludeInPayslip;
									$res1['additions'] = ($row1->Type==0)?0:1;
									$headarray[]=$res1;
									
									if($row1->Type)
									$emptotal += (float)$row1->HeadAmount;
									else
									$emptotaldeduction += (float)$row1->HeadAmount;
								}
								
								////////////////   FIND OUT THE SALARY HEADS WHICH ARE 	NEWLY ADDED/////////////////////////////	
								$sql1 = "SELECT Id,Name,HeadType FROM SalaryHead WHERE OrganizationId = ? and ApplyDate<='$month' and Id not in( select headid from SalaryChild where HeadType=1 and salaryid=?) ORDER BY field(HeadType, 4,1,2,3),Id";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array( $request[1], $salaryid));
								while($row1 = $query1->fetch())
								{
									$res1 = array();
									$res1['id'] = $row1->Id;
									$res1['amount'] = 0;
									$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").$row1->Name;
									$res1['headname'] = $row1->Name;
									$res1['type'] = 1;
									$res1['additions']=(($row1->HeadType==3)?0:1);
									$res1['headtype'] = (int)($row1->HeadType==3)?0:$row1->HeadType;
									$headarray[]=$res1;
								}
								$sql1 = "SELECT * FROM SalaryOtherHead WHERE HeadSts=1 and ActiveSts=1 and OrganizationId = ? and HeadCode not in( select headid from SalaryChild where HeadType=2 and salaryid=?) order by Field(Type, 0,1), Id";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array( $request[1],$salaryid));
								while($row1 = $query1->fetch())
								{
									$res1 = array();
									$res1['id'] = $row1->HeadCode;
									$res1['amount'] = 0;
									$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
									$res1['headname'] = $row1->Name;
									$res1['type'] = 2;
									$res1['additions']=(($row1->Type==0)?0:1);
									$res1['headtype'] = (int)$row1->Type;
									$headarray[]=$res1;
								}
								
								$sql1 = "SELECT HeadId,HeadAmount FROM EmployeeSalaryDetails WHERE OrganizationId = ? and EmployeeId=?";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array( $orgid, $row->Id ));
								if($query1->rowCount()>0)
								{
									$salarydist=0;
									while($row1 = $query1->fetch())
									{
										///////FOR CHECKING  IF THERE IS NO ENTRY FOR THE EMPLOYEE SALARY DETAILS/////////
										
										$salarydist = $salarydist + $row1->HeadAmount;
										
										///////////////////
										for($i=0; $i<count($headarray); $i++)
										{
											if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1) && ($headarray[$i]['headtype']==4 || $headarray[$i]['headtype']==2)){
												$temp=$headarray[$i]['amount'];	
												if($headarray[$i]['additions'] && !$newjoineeflg){
													$headarray[$i]['amount']=(float)$row1->HeadAmount ;
													$emptotal -= (float)$temp ;
													$emptotal += (float)$row1->HeadAmount ;
												}elseif($headarray[$i]['additions'] && $newjoineeflg){
													$paidamt=(float)(($row1->HeadAmount/$number)*$res['emppaiddays']);
													$paidamt=round($paidamt,2);
													$headarray[$i]['amount']=$paidamt;
													$emptotal -= (float)$temp ;
													$emptotal += $paidamt;
												}
											}
										}	
									}//$res['salarysts'] = true;
									if($salarydist==0)
										$empcount++;
								}else{
									//$res['salarysts'] = false;
									$empcount++;
								}	
								$res['salarysts'] = true;
								
									
							}
						}else{
							//echo $row->FirstName;
							////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
							$sql1 = "SELECT Id,Name,HeadType FROM SalaryHead WHERE OrganizationId = ? ORDER BY field(HeadType, 4,1,2,3),Id";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array( $request[1]));
							while($row1 = $query1->fetch())
							{
								$res1 = array();
								$res1['id'] = $row1->Id;
								$res1['amount'] = 0;
								$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").$row1->Name;
								$res1['headname'] = $row1->Name;
								$res1['type'] = 1;
								$res1['additions']=(($row1->HeadType==3)?0:1);
								$res1['headtype'] = (int)($row1->HeadType==3)?0:$row1->HeadType;
								$headarray[]=$res1;
							}
							///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
							$sql1 = "SELECT Id,Name,Type,HeadCode FROM SalaryOtherHead WHERE HeadSts=1 and OrganizationId=? and ActiveSts=1  order by Field(Type, 0,1), Id";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($orgid));
							while($row1 = $query1->fetch())
							{
								$res1 = array();
								$res1['id'] = $row1->HeadCode;
								$res1['amount'] = 0;
								$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
								$res1['headname'] = $row1->Name;
								$res1['type'] = 2;
								$res1['additions']=(($row1->Type==0)?0:1);
								$res1['headtype'] = (int)$row1->Type;
								$headarray[]=$res1;
							}
							$sql1 = "SELECT HeadId,HeadAmount FROM EmployeeSalaryDetails WHERE OrganizationId = ? and EmployeeId=?";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array( $orgid, $row->Id ));
							if($query1->rowCount()>0)
							{
								while($row1 = $query1->fetch())
								{
									for($i=0; $i<count($headarray); $i++)
									{
										if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
										{
											$temp=$headarray[$i]['amount'];	
											if($headarray[$i]['additions'] && !$newjoineeflg){
												$headarray[$i]['amount']=(float)$row1->HeadAmount ;
												$emptotal -= (float)$temp ;
												$emptotal += (float)$row1->HeadAmount ;
												break;
											}elseif($headarray[$i]['additions'] && $newjoineeflg){
												$paidamt=(float)(($row1->HeadAmount/$number)*$res['emppaiddays']);
												$paidamt=round($paidamt,2);
												$headarray[$i]['amount']=$paidamt;
												$emptotal -= (float)$temp ;
												$emptotal += $paidamt;
												break;
											}else{
												$headarray[$i]['amount']=(float)$row1->HeadAmount ;
												$emptotaldeduction -= (float)$temp ;
												$emptotaldeduction += (float)$row1->HeadAmount ;
												break;
											}
												
										}
									}	
								}
									//$res['salarysts'] = true;
							}else{
									//$res['salarysts'] = false;
								$empcount++;
							}	
							$res['salarysts'] = true;
						}
						
						$salaryadvance_installment=0;
						$leavededuction=0;
						$leavedays=0;
						$leavefulldaynopay=0;
						$leavefulldayhalfpay=0;		$leavehalfdayhalfpay=0;
						$leavefullday_3_4_pay=0;	$leavehalfday_3_4_pay=0;
						$leavefullday_1_4_pay=0;	$leavehalfday_1_4_pay=0;
						
						$sql1 = "Select Leaveday, HalfDaySts,LossOfPay,Entitled,PaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and empleave.LeaveStatus=2 and (empchild.LeaveDay between '$month' and LAST_DAY('$month')) and empleave.OrganizationId = ? and empleave.EmployeeId =?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->Id));
						while($row1 = $query1->fetch())
						{
							//echo $row1->Leaveday;echo '<br>';
							
							if($row1->HalfDaySts==1 && $row1->LossOfPay==1){ 
								$leavedays=$leavedays+0.5;
								$leavefulldaynopay++;
							}elseif($row1->HalfDaySts==0 && $row1->LossOfPay==1){
								$leavedays++;
								$leavefulldaynopay++;
							}
							///////	When LeavePay is no pay ////////
							elseif($row1->PaySts == 0 && $row1->Entitled == 1 && $row1->HalfDaySts==0){
								$leavedays++;
								$leavefulldaynopay++; 
							}elseif($row1->PaySts == 0 && $row1->Entitled == 1 && $row1->HalfDaySts==1){
								$leavedays=$leavedays+0.5;	
								$leavefulldaynopay++;
							}	
							///////	When LeavePay is half pay ////////
							elseif($row1->PaySts == 2 && $row1->Entitled == 1 && $row1->HalfDaySts==0){
								$leavedays++;
								$leavefulldayhalfpay++; 
							
							}elseif($row1->PaySts == 2 && $row1->Entitled == 1 && $row1->HalfDaySts==1){//echo 'f';
								$leavedays=$leavedays+0.5;	
								$leavehalfdayhalfpay++;
							}
							///////	When LeavePay is 3/4 pay ////////
							elseif($row1->PaySts == 3 && $row1->Entitled == 1 && $row1->HalfDaySts==0){//echo 'g';
								$leavedays++;
								$leavefullday_3_4_pay++; 
							
							}elseif($row1->PaySts == 3 && $row1->Entitled == 1 && $row1->HalfDaySts==1){
								$leavedays=$leavedays+0.5;	
								$leavehalfday_3_4_pay++;
							}
							
							///////	When LeavePay is 1/4 pay ////////
							elseif($row1->PaySts == 4 && $row1->Entitled == 1 && $row1->HalfDaySts==0){
								$leavedays++;
								$leavefullday_1_4_pay++; 
							}elseif($row1->PaySts == 4 && $row1->Entitled == 1 && $row1->HalfDaySts==1){
								$leavedays=$leavedays+0.5;	
								$leavehalfday_1_4_pay++;
							}
							
						}
						
						$res['emppaiddays'] = $res['emppaiddays']-($leavedays);
						
					//	$leavededuction = round($onedaysal*$leavedays);
				//	echo $onedaysal;
						$leavededuction += round($onedaysal*$leavefulldaynopay);
						
						$leavededuction += round(($onedaysal*(1/2))*$leavefulldayhalfpay);
						$leavededuction += round((($onedaysal/2)*(1/2))*$leavehalfdayhalfpay);
						
						$leavededuction += round(($onedaysal*(1/4))*$leavefullday_3_4_pay);
						$leavededuction += round((($onedaysal/2)*(1/4))*$leavehalfday_3_4_pay);
						
						$leavededuction += round(($onedaysal*(3/4))*$leavefullday_1_4_pay);
						$leavededuction += round((($onedaysal/2)*(3/4))*$leavehalfday_1_4_pay);
						
						///////////////THIS CODE BELONGS TO SALARY CYCLE ,IF ANY LEAVE IS ENTERED AFTER SALARY GENERATION THEN THIS CODE WILL CALCULATE THAT,AND ADD IN LEAVE DEDUCTION FOR THE NEXT PAYROLL//////
						$leavedays1=0;
						$leavefulldaynopay1=0;
						$leavefulldayhalfpay1=0;		$leavehalfdayhalfpay1=0;
						$leavefullday_3_4_pay1=0;	$leavehalfday_3_4_pay1=0;
						$leavefullday_1_4_pay1=0;	$leavehalfday_1_4_pay1=0;
						$lastsalarymonth = $this->getCurrentSalaryMonth();
						$salarygenerateddate = date('Y-m-d',strtotime($this->getCurrentSalaryGenerateDate($lastsalarymonth)));
						$salarygenerateddate1 = date('Y-m-d H:i:s',strtotime($this->getCurrentSalaryGenerateDate($lastsalarymonth)));
						
						$sql1 = "Select HalfDaySts,LossOfPay,Entitled,PaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and empleave.LeaveStatus=2 and (empchild.LeaveDay between '$lastsalarymonth' and LAST_DAY('$lastsalarymonth')) and empleave.CreatedDate>='$salarygenerateddate1' and empleave.OrganizationId = ? and empleave.EmployeeId =?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $row->Id));
						while($row1 = $query1->fetch())
						{
							if($row1->HalfDaySts==1 && $row1->LossOfPay==1){
								$leavedays1=$leavedays1+0.5;
								$leavefulldaynopay1++; 
							}elseif($row1->HalfDaySts==0 && $row1->LossOfPay==1){
								$leavedays1++;
								$leavefulldaynopay1++; 
							}/* elseif($row1->PaySts == 2 && $row1->Entitled == 1)
								$leavedays1=$leavedays1+0.5;
							elseif($row1->PaySts == 0 && $row1->Entitled == 1)
								$leavedays1++; */
								
							///////	When LeavePay is no pay ////////
							elseif($row1->PaySts == 0 && $row1->Entitled == 1 && $row1->HalfDaySts==0){
								$leavedays1++;
								$leavefulldaynopay1++; 
							}elseif($row1->PaySts == 0 && $row1->Entitled == 1 && $row1->HalfDaySts==1){
								$leavedays1=$leavedays1+0.5;	
								$leavefulldaynopay1++;
							}	
							///////	When LeavePay is half pay ////////
							elseif($row1->PaySts == 2 && $row1->Entitled == 1 && $row1->HalfDaySts==0){
								$leavedays1++;
								$leavefulldayhalfpay1++; 
							}elseif($row1->PaySts == 2 && $row1->Entitled == 1 && $row1->HalfDaySts==1){
								$leavedays1=$leavedays1+0.5;	
								$leavehalfdayhalfpay1++;
							}
							///////	When LeavePay is 3/4 pay ////////
							elseif($row1->PaySts == 3 && $row1->Entitled == 1 && $row1->HalfDaySts==0){
								$leavedays1++;
								$leavefullday_3_4_pay1++; 
							}elseif($row1->PaySts == 3 && $row1->Entitled == 1 && $row1->HalfDaySts==1){
								$leavedays1=$leavedays1+0.5;	
								$leavehalfday_3_4_pay1++;
							}
							
							///////	When LeavePay is 1/4 pay ////////
							elseif($row1->PaySts == 4 && $row1->Entitled == 1 && $row1->HalfDaySts==0){
								$leavedays1++;
								$leavefullday_1_4_pay1++; 
							}elseif($row1->PaySts == 4 && $row1->Entitled == 1 && $row1->HalfDaySts==1){
								$leavedays1=$leavedays1+0.5;	
								$leavehalfday_1_4_pay1++;
							}
						}
					//	$leavededuction =$leavededuction+round($onedaysal*$leavedays1);
						
						$leavededuction += round($onedaysal*$leavefulldaynopay1);
						
						$leavededuction += round(($onedaysal*(1/2))*$leavefulldayhalfpay1);
						$leavededuction += round((($onedaysal/2)*(1/2))*$leavehalfdayhalfpay1);
						
						$leavededuction += round(($onedaysal*(1/4))*$leavefullday_3_4_pay1);
						$leavededuction += round((($onedaysal/2)*(1/4))*$leavehalfday_3_4_pay1);
						
						$leavededuction += round(($onedaysal*(3/4))*$leavefullday_1_4_pay1);
						$leavededuction += round((($onedaysal/2)*(3/4))*$leavehalfday_1_4_pay1);
						
						
						$penaltyamt=0;$absentamt=0;$earlyleaving=0;
						
						////////////////////////////////
						for($i=0; $i<count($headarray); $i++)
						{
							$temp=0; $pfamt=0; $protax=0; 
							$headarray[$i]['headdetails'] ="";
							if(($headarray[$i]['id']==9) && ($ltamonth>0) && ($headarray[$i]['type']==2))
							{
								/*if($this->getLTA($row->EmployeeId, $ltamonth)){
									$temp=$headarray[$i]['amount'];
									$headarray[$i]['amount'] = (float)$lta;
									$emptotal -= (float)$temp ;
									$emptotal += (float)$lta ;
								}*/
							}else if(($headarray[$i]['id']==5) && ($headarray[$i]['type']==2)){
								$incentive = $this->getEmployeeIncentive($row->Id, $month, 2);
								$temp=$headarray[$i]['amount'];
								$headarray[$i]['amount'] = (float)$incentive;
								$emptotal -= (float)$temp ;
								$emptotal += (float)$incentive ;
							}else if(($headarray[$i]['id']==4) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$headarray[$i]['amount'] = (float)$leavededuction;
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction += (float)$leavededuction ;
							}
							/////////used to Loan repayment(Personal Loan)///
							else if(($headarray[$i]['id']==1) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$salaryadvance_installment=$this->getEmployeeLoanInstallment($row->Id,$month,2);
								$headarray[$i]['amount'] = (float)$salaryadvance_installment;
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction  += (float)$salaryadvance_installment ;
							}/////////used to Advance repayment(Salary Advance)///
							else if(($headarray[$i]['id']==35) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$salaryadvanceamt_installment=$this->
								getAdvanceLoanInstallment($row->Id,$month,2);
								$headarray[$i]['amount'] = (float)$salaryadvanceamt_installment;
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction  += (float)$salaryadvanceamt_installment ;
							}else if(($headarray[$i]['id']==2) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$overtime = $this->getEmployeeOvertime($row->Id, $month);
								$headarray[$i]['amount'] = (float)$overtime;
								$emptotal -= (float)$temp ;
								$emptotal += (float)$overtime ;
							}
							else if(($headarray[$i]['id']==7) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$claims = $this->getEmployeeCliams($row->Id, $month);
								$headarray[$i]['amount'] = (float)$claims;
								$emptotal -= (float)$temp ;
								$emptotal += (float)$claims ;
							}
							else if(($headarray[$i]['headname']=='Leave Salary') && ($headarray[$i]['type']==1)){
								$temp=$headarray[$i]['amount'];
								$leavesal = $this->getLeaveSalary($row->Id, $month,$onedaysal);
								$headarray[$i]['amount'] = (float)$leavesal;
								$emptotal -= (float)$temp ;
								$emptotal += (float)$leavesal ;
							}
							//LateComing Sts=30 deduction FOR EMPLOYEE  //////
							else if(($headarray[$i]['id']==30) && ($headarray[$i]['type']==2)){
								$penaltyamt=0;
								$temp=$headarray[$i]['amount'];
								$basic=Utils::getEmployeeBasicSalary($empid,$this->db);
								//////Get Basic One Day Salary /////
								$basicnumber = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
								$onedaybasic = ($basic/$basicnumber);
								
								/////Get Penalty Data//////////
								$penalty=$this->getPenalty();
								
								if($penalty['data']){
									$LateComing=$penalty['data'][0]['LateComing'];
									
									//////Check LateComing sts (On/Off)/////
									if($LateComing==1){
										$lateInstance=$penalty['data'][0]['lateInstance'];
										$lateDeduct=$penalty['data'][0]['lateDeduct'];
										$lateSalaryType=$penalty['data'][0]['lateSalaryType'];
										$latecoming=0;
										/////List Of LateComing Employees//////
										$latecoming = $this->getEmpLateEarlyLeaving($empid,$month,1);
										
										if($latecoming>=$lateInstance){
											$headarray[$i]['headdetails'] ="$latecoming late coming instances";
										//print_r($empid."-".$latecoming."<br>");	
										////Get lateComing Quotient & Remainder////
										//echo $latecoming."<br>";
											list($quotient, $remainderlatecoming)=$this->getQuotientAndRemainder($latecoming,$lateInstance);
						
											//////1 For Basic Salary//////
											if($lateSalaryType==1){
												//////1 For Half Day///////
												if($lateDeduct==1){
													$penaltyamt=(float)($quotient *($onedaybasic/2));
												}//////2 For Full Day///////
												elseif($lateDeduct==2){
													$penaltyamt= (float)($quotient*$onedaybasic );
												}
											}//////2 For Gross Salary//////
											else if($lateSalaryType==2){
												//////1 For Half Day///////
												if($lateDeduct==1){
													$penaltyamt = (float)($quotient*($onedaysal/2));
												}//////2 Full Day///////
												elseif($lateDeduct==2){
													$penaltyamt = (float)($quotient*$onedaysal);
												}
											}
										}
									}//////Check Early Leaving sts (On/Off)///
								}
								//echo "sts $LateComing late coming $penaltyamt;";
								$headarray[$i]['amount'] = round((float)($penaltyamt),2);
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction += $headarray[$i]['amount'];
							}
							
							//UnAuthorized attendance STS=32 deduction FOR EMPLOYEE  ///
							else if(($headarray[$i]['id']==32) && ($headarray[$i]['type']==2)){
								$absentamt=0;
								$absentcount=0;
								$temp=$headarray[$i]['amount'];
								$basic=Utils::getEmployeeBasicSalary($empid,$this->db);
								//////Get Basic One Day Salary /////
								$basicnumber = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
								$onedaybasic = ($basic/$basicnumber);
								
								/////Get Penalty Data//////////
								$penalty=$this->getPenalty();
								
								if($penalty['data']){
									$AbsentUnautorized=$penalty['data'][0]['AbsentUnautorized'];
									//Check Absent unautorized sts (ON/Off)///
									if($AbsentUnautorized==1){
										$AbsentDeduct=$penalty['data'][0]['AbsentDeduct'];
										$AbsentSalaryType=$penalty['data'][0]['AbsentSalaryType'];
										
										$absentcount=$this->getEmpAbsentUnAutorized($empid,$month);
										if($absentcount>0){
											//////1 For Basic Salary//////
											if($AbsentSalaryType==1){
												//////1 For Full Day///////
												if($AbsentDeduct==1){
													$absentamt = (float)($absentcount*$onedaybasic) ;
												}//////2 For Half Day///////
												elseif($AbsentDeduct==2){
													$absentamt =(float)($absentcount*($onedaybasic/2) );
												}
											}//////2 For Gross Salary//////
											else if($AbsentSalaryType==2){
												//////1 For Half Day///////
												if($AbsentDeduct==1){
													$absentamt = (float)($absentcount*($onedaysal/2));
												}//////2 Full Day///////
												elseif($AbsentDeduct==2){
													$absentamt = (float)($absentcount*$onedaysal);
												}
											}
										}
									}
								}
								$headarray[$i]['headdetails'] ="$absentcount unautorized absence instances";
								$headarray[$i]['amount'] = round((float)($absentamt),2);
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction += $headarray[$i]['amount'];
							}
							//Early LeavingSTS=33 deduction FOR EMPLOYEE  ////
							else if(($headarray[$i]['id']==33) && ($headarray[$i]['type']==2)){
								$earlyleaving=0;
								$temp=$headarray[$i]['amount'];
								$basic=Utils::getEmployeeBasicSalary($empid,$this->db);
								//////Get Basic One Day Salary /////
								$basicnumber = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
								$onedaybasic = ($basic/$basicnumber);
								
								/////Get Penalty Data//////////
								$penalty=$this->getPenalty();
								
								if($penalty['data']){
									
									$Earlyleaving=$penalty['data'][0]['Earlyleaving'];
									//////Check Early Leaving sts (On/Off)/////
									if($Earlyleaving==1){
										
										$EarlyInstance=$penalty['data'][0]['EarlyInstance'];
										$EarlyDeduct=$penalty['data'][0]['EarlyDeduct'];
										$EarlySalaryType=$penalty['data'][0]['EarlySalaryType'];
										$earlyliving=0;
										////List Of Early Leaving Employees//
										$earlyliving = $this->getEmpLateEarlyLeaving($empid,$month,2);
										
										if($earlyliving>=$EarlyInstance){
											$headarray[$i]['headdetails'] ="$earlyliving early leaving instances";
											//echo $empid."-".$earlyliving."<br>";
											//echo $earlyliving."<br>";
											list($quotient, $remainderearlyleaving)=$this->getQuotientAndRemainder($earlyliving,$EarlyInstance);
											//////1 For Basic Salary//////
											if($EarlySalaryType==1){
												//////1 For Half Day///////
												if($EarlyDeduct==1){
													$earlyleaving = (float)($quotient*($onedaybasic/2)) ;
												}//////2 For Full Day///////
												elseif($EarlyDeduct==2){
													$earlyleaving = (float)($quotient*$onedaybasic);
												}
											}//////2 For Gross Salary//////
											else if($EarlySalaryType==2){
												//////1 For Half Day///////
												if($EarlyDeduct==1){
													$earlyleaving = (float)($quotient*($onedaysal/2));
												}//////2 Full Day///////
												elseif($EarlyDeduct==2){
													
													$earlyleaving = (float)($quotient*$onedaysal);
												}
											}
										}
									}
								}
								
								//echo "sts $Earlyleaving early leaving $earlyleaving;";
								$headarray[$i]['amount'] = round((float)($earlyleaving),2);
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction += $headarray[$i]['amount'];
							}
							
							
							
							//////////////// PF deduction FOR EMPLOYEE  ///////////////////////////
							else if(($headarray[$i]['id']==24) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$basic=Utils::getEmployeeBasicSalary($empid,$this->db);
								$totalemp=Utils::getTotalNoEmployee($orgid,$this->db);
								$pfsts=$this->getPFStatus($totalemp,$basic,$ctc,$empid);
								
								if($pfsts){
									$pfamt = $this->getEmployeePF($basic,$ctc,$orgid);
								}
								$headarray[$i]['amount'] = (float)$pfamt;
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction += (float)$pfamt ;
							}
							
							//////////////// ESI deduction FOR EMPLOYEE  ///////////////////////////
							else if(($headarray[$i]['id']==27) && ($headarray[$i]['type']==2)){
								$temp=$headarray[$i]['amount'];
								$basic=Utils::getEmployeeBasicSalary($empid,$this->db);
								$esists=$this->getESIStatus($basic,$ctc,$empid);
								//$esists=true;
								$claims=0;
								if($esists){
									$claims = $this->getEmployeeESI($basic,$ctc,$orgid);
									Utils::Trace("claims ".$claims);
								}
								$headarray[$i]['amount'] = (float)$claims;
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction += (float)$claims ;
							}
							
							//////////////// TDS deduction FOR EMPLOYEE  ///////////////////////////
							
							else if(($headarray[$i]['id']==28) && ($headarray[$i]['type']==2)){
								$taxableamt=$ctc - $pfamt - $protax;
								$temp=$headarray[$i]['amount'];
								$tdssts=$this->getTDSStatus($orgid,$ctc,$empid);
								$claims=0;
								if($tdssts){
									$claims = $this->getEmployeeTDS($ctc,$orgid,$taxableamt);
									
								}
								$headarray[$i]['amount'] = (float)$claims;
								$emptotaldeduction -= (float)$temp ;
								$emptotaldeduction += (float)$claims ;
							}
						}
						
						$result = $this->aasort($headarray,"id");
						$result = $this->aasort($headarray,"headtype");
						//print_r($result);
						$res['salarydetail']=$result;
						
						for($j=0; $j<count($headarray); $j++)
						{
							
							$headarray[$j]['amount']=0 ;
							//$headarray[$i]['name']="" ;
						}
								
						$res['remainderlatecoming'] =$remainderlatecoming;
						$res['remainderearlyleaving'] = $remainderearlyleaving;
						$res['empdeduction'] = ($emptotaldeduction);
						$res['empnetsalary'] = ($emptotal-$emptotaldeduction);
						$res['empctc'] =(float) $ctc;
						$res['emptotal'] =($emptotal);
						$res['sts'] = $res['salarysts'];
						$data[] = $res;
					}
				$status=true;
				$successMsg="$count employees found without salary distribution";	
			}else{
				$status=false;
				$errorMsg = "No data found";
			}
			//echo $batch;
			if($count==0 && $batch!=2)
			{
				$sql = "select * from SalaryGenerateMonth where SalaryMonth=? and OrganizationId=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($month, $orgid));
				if($query->rowCount()==0)
				{
					$mdate = date("Y-m-d H:i:s");
					$sql1 = "INSERT INTO SalaryGenerateMonth (SalaryMonth, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) values(?,?,?,?,?,?,?)";		
					$query1 = $this->db->prepare($sql1);			
					try{						
						$query1->execute(array($month, $orgid, $mdate, $mid, $mdate, $mid, $mid ));
						$count =  $query1->rowCount();	
						if($count==1)
						{
							$status =true;
							$successMsg=SALARYMASTER_MODULE_CREATION_SUCCESS;
						}							
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}
			}		
			//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
				$this->db->commit(); 
		}catch(PDOException $e)
		{
			$this->db->rollBack();
			//$errorMsg = 'Message: ' .$e->getMessage();
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result["count"] =$count;
		$result['status']=$status;
		$result['mnth']=$month;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	function aasort (&$array, $key) {
		$sorter=array();
		$ret=array();
		reset($array);

		foreach ($array as $ii => $va) {
			$sorter[]=$va[$key];
		}

		arsort($sorter);

		foreach ($sorter as $ii => $va) {
			$ret[]=$array[$ii];
		}

		return $array=$ret;
	}
	public function getQuotientAndRemainder($divisor, $dividend) {
		$quotient = (int)($divisor / $dividend);
		$remainder = $divisor % $dividend;
		return array( $quotient, $remainder );
	}
	public function isearlyTimeoff($empid, $date,$timein)
	{
		
		$name =0;
		$sql = "SELECT * FROM Timeoff WHERE EmployeeId = $empid and TimeofDate ='$date' and TimeFrom<'$timein'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$con=$query->rowCount();
			if($con>=1)
			{
				return true;
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		
		return false;
	}
	
	public function isearlyTimeout($empid,$date,$timeout)
	{
		$name =0;
		$sql = "SELECT * FROM Timeoff WHERE EmployeeId = $empid and TimeofDate = '$date' and TimeTo > '$timeout'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$con=$query->rowCount();
			if($con>=1)
			{
				return true;
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return false;
	}
	
	/////////GET BulkLTA Leaving OF EMPLOYEES////////////////
	public function getEmployeeBulkLTA($request,$val)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$headarray = array(); $emparray=array();
		$division=0;  $department=0; $grade=0; $designation=0;
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$division=	$request[3] ;
		$department=	$request[4] ;
		$designation=	$request[5] ;
		$grade	=	$request[6] ;
		$month = $this->getSalaryMonth($request);//Utils::getDateformat( $request[2]);
		
		if(date("Y-m-d")<date($month))
		{
			$result["data"] =$data;
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']="Cannot generate future month salary";
		
			return $result;
		}
		$sWhere=""; $nonemptable="";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts!=1 && $hrsts!=1 ){
			$ids = Utils::getReportingIds($mid, $this->db);
			$sWhere = " and Id in ($ids) ";
			$nonemptable=" and EmployeeId in ($ids)";
		}
		if($division!=0){
			$sWhere .= " and Division = $division ";
		}if($department!=0){
			$sWhere .= " and Department = $department ";
		}
		if($designation!=0){
			$sWhere .= " and Designation = $designation ";
		}
		if($grade!=0){
			$sWhere .= " and Grade = $grade ";
		}
		$lta = 0;
		$ltamonth = 0;
		try{
			$this->db->beginTransaction();		
				$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00' $sWhere and DOJ<=last_day('$month') and Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$month') and OrganizationId = ?)  order by Division, EmployeeCode, FirstName, MiddleName, LastName ";
				Utils::Trace($sql);
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid,  $orgid));
				$count =  $query->rowCount();
				
				if($count>=1)
				{
					$status=true;
					$empcount=0;
					while($row = $query->fetch())
					{
						$emptotal = 0;
						$emptotaldeduction = 0;
						$onedaysal =0;
						$res = array();
						$res['id'] = $row->Id;
						$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
						$res['empcode'] = $row->EmployeeCode;
						$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
						$res['empcurency'] = Utils::getDivisioncurrency($row->Division,$this->db);
						//$res['empdept'] = $this->getName($row->Department,'DepartmentMaster');
						$res['empdesig'] = $this->getName($row->Designation,'DesignationMaster');
						//$res['empshift'] =$this->getName( $row->Shift,'ShiftMaster');
						//$res['empgrade'] = $this->getName($row->Grade,'GradeMaster');
						$res['empctc'] = $row->EmployeeCTC;
						$ctc = $row->EmployeeCTC;
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						$res['emppaiddays']=0;
						$res['airticket'] = $row->AirTicket;
						$res['ticketclass'] = $row->TicketClass;
						$res['oncein'] = $row->OnceIn;
						$res['ticketamt'] = $row->LastTicketAmt;
						$res['iatafare'] = $row->IATAFare;
						$res['instructions'] = $row->TravelInstruction;
						$res['nearestairport'] = $row->NearestAirport;
						$res['familydetails'] = $row->FamilyDetail;
						
						$data[]=$res;
					}
				}else{
					$status=false;
					$errorMsg="No employee fround";
				}
				//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
				$this->db->commit(); 
			}catch(PDOException $e)
				{
					
					$this->db->rollBack();
					//$errorMsg = 'Message: ' .$e->getMessage();
				}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['mnth']=$month;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	/////////GET LateComing Or Early Leaving OF EMPLOYEES////////////////
	public function getEmpLateEarlyLeaving($empid,$month,$val)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$RemainingLateIns=0;$RemainingEarlyIns=0;$latecoming=0;$earlyleaving=0;
		$headarray = array(); $emparray=array();
		try{
		$previousmonth= date('Y-m-d', strtotime(date($month)." -1 month"));
		$sqlpre="select RemainingLateIns,RemainingEarlyIns from SalaryMaster where EmployeeId=? and SalaryMonth=?";
		$querypre=$this->db->prepare($sqlpre);
		$querypre->execute(array($empid,$previousmonth));
		while($rowpre=$querypre->fetch()){
			$RemainingLateIns=$rowpre->RemainingLateIns;
			$RemainingEarlyIns=$rowpre->RemainingEarlyIns;
		}
			$mid   = $_SESSION['ubihrm_user_id'];
			$orgid = $_SESSION['ubihrm_org_id'];
		
			$shift= Utils::getName($empid, "EmployeeMaster", "Shift", $this->db);
			
			$temp=date("Y-m-01",strtotime($month));
			$temp1=date("Y-m-t",strtotime($month));
			$con=0;$con1=0;
			$shifttimein = $this->getShiftTime($shift,"TimeInGrace");
			$shifttimeout = $this->getShiftTime($shift,"TimeOutGrace");
			$sql1="select TimeIn ,TimeOut,AttendanceDate from AttendanceMaster where EmployeeId=? and AttendanceDate between '$temp' and '$temp1' ";
			$query1=$this->db->prepare($sql1);
			$query1->execute(array($empid));
			
			while($r=$query1->fetch()){
				if($val==1){
					if(strtotime($r->TimeIn) > strtotime($shifttimein)){
						$getearlytime=$this->isearlyTimeoff($empid,$r->AttendanceDate,$r->TimeIn);
						if($getearlytime==""){
							//echo $empid."-".$r->AttendanceDate."<br>";
							$con++;
						}
					}
				}if($val==2){
					if($r->TimeOut!="00:00:00"){
						if(strtotime($r->TimeOut)< strtotime($shifttimeout) ){
							$getearlytimeout=$this->isearlyTimeout($empid,$r->AttendanceDate,$r->TimeOut);
							//print_r($getearlytimeout);
							if($getearlytimeout==""){
								$con1++;
							}
						}
					}
				}
			}
			
			//print_r( $empid." - ".$con."<br>");
			$latecoming=($con+$RemainingLateIns);
			$earlyleaving=($con1+$RemainingEarlyIns);
			
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if($val==1)
		return $latecoming;
		elseif($val==2)
		return $earlyleaving;
    }
	/////////GET AbsentUnAutorized EMPLOYEES////////////////
	public function getEmpAbsentUnAutorized($empid,$month)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$absent = 0; $emparray=array();
		
		$mid   = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
		try{
			/* $sql1 = "Select EmployeeId ,AttendanceDate from AttendanceMaster WHERE EmployeeId=? and YEAR(AttendanceDate)=YEAR($month)  AND MONTH(AttendanceDate) = MONTH($month) ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($empid));
			$count1 =  $query1->rowCount();	 */
			$shift= Utils::getName($empid, "EmployeeMaster", "Shift", $this->db);
			
			$temp=date("Y-m-01",strtotime($month));
			$temp1=date("Y-m-t",strtotime($month));
			$con=0;$con1=0;
			$shifttimein = $this->getShiftTime($shift,"TimeInGrace");
			$shifttimeout = $this->getShiftTime($shift,"TimeOutGrace");
			$sql1="select count(AttendanceStatus) as absent from AttendanceMaster where EmployeeId=? and AttendanceStatus=2 and AttendanceDate between '$temp' and '$temp1'";
			$query1=$this->db->prepare($sql1);
			$query1->execute(array($empid));
			$r=$query1->fetch();
			$absent=$r->absent;
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//print_r($con1);
		return $absent;
	}
	
	public function getShiftTime($id,$field)
	{
		$name =" ";
		$sql = "SELECT $field FROM ShiftMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$field;
				
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	
	//////////////// FUNTION TO GET EMPLOYEE FINAL SETTLEMENT SALARY DETAILS  ///////////////
	
    public function getFinalSettlementSalaryDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$lastdate =  Utils::getDateformat($request[3]);
		$date = date("Y-m-d");
		$empid = $request[2];
		$empsts = $request[4];
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
		$lta=0;
		$ltamonth=0;
		try{
        $sql = "SELECT *,datediff(DATE_ADD(DOJ, INTERVAL Provisionperiod month), curdate()) as daysleft FROM EmployeeMaster WHERE OrganizationId = ? AND Id=? ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $empid ));
		$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$emptotal = 0;
				$emptotaldeduction=0;
				$onedaysal=0;
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName));
				$res['empcode'] = $row->EmployeeCode;
				$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
				$res['empdept'] = $this->getName($row->Department,'DepartmentMaster');
				$res['empdesig'] = $this->getName($row->Designation,'DesignationMaster');
				$res['empshift'] =$this->getName( $row->Shift,'ShiftMaster');
				$res['empgrade'] = $this->getName($row->Grade,'GradeMaster');
				$res['empctc'] = $row->EmployeeCTC;
				$res['doj'] = Utils::dateformatter($row->DOJ);
				$ctc = $row->EmployeeCTC;
				$res['empmonthname']=""; 
				$res['empmonthdate']=""; 
				$res['emppaiddays']=0;				
				$res['salarydetail'] = array();
				$lta=$row->IATAFare;
				$ltamonth=$row->OnceIn;
				$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($lastdate)), date('Y', strtotime($lastdate)));
				$onedaysal = ($ctc)/$number ;
				$paymentsts=$row->OvertimePayment;
				
				///////////////////// FIND OUT THE SALARY MONTH FOR THE EMPLOYEE ////////////////////////////
				/*$sql1 = "SELECT SalaryMonth FROM SalaryMaster WHERE EmployeeId=? order by SalaryMonth desc limit 1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id));
				if($query1->rowCount()>0)
				{
					while($row1 = $query1->fetch())
					{
						$date = date('Y-m-d', strtotime(date('Y-m', strtotime($row1->SalaryMonth))." +1 month"));
						$res['empmonthdate']= $date;
					}
				}else{
						$date = date($row->DOJ);//date('Y-m-d', strtotime(date('Y-m-d', strtotime($row->DOJ))));
						$res['empmonthdate']= $date;
						
				}*/
				$date = date('Y-m-01', strtotime($lastdate));
				$res['empmonthdate']= $date;
				$res['empmonthdate1']= $lastdate;
				$res['empmonthname']=date('d M, Y', strtotime($date))." - ".date('d M, Y', strtotime($lastdate));
				$from=date_create(date($lastdate));
				$to=date_create($date);
				$diff=date_diff($to,$from);
				$days = $diff->format('%a');
				$res['emppaiddays'] = (float)$days+1;
				$ctc = round(($onedaysal * $res['emppaiddays']),2);
				if(date($res['empmonthdate'])<date($row->DOJ))
				{					
					$d = date('d', strtotime($row->DOJ));
					$res['emppaiddays'] = $res['emppaiddays']-($d-1);
					$ctc = round(($onedaysal * $res['emppaiddays']),2);					
				}
				
				$headid="0";
			
				/*$sql1 = "SELECT es.HeadId as headid, HeadAmount, Name, sh.HeadType as headtp FROM EmployeeSalaryDetails es, SalaryHead sh WHERE es.HeadId=sh.Id and es.OrganizationId = ? and EmployeeId=? order by es.HeadType ";
				
				//$sql1 = "SELECT * FROM SalaryHead WHERE OrganizationId = ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id));
					while($row1 = $query1->fetch())
					{
						$res1 = array();
						$res1['id'] = $row1->headid;
						$res1['amount'] = ((float)$row1->HeadAmount/30)*$res['emppaiddays'];
						$res1['days'] = 0;
						$res1['name'] = (($row1->headtp!=3)?"(+) ":"(-) ").$row1->Name;
						$res1['type'] = 1;
						$res1['headtype'] = $row1->headtp;
						$res['salarydetail'][]=$res1;
					}*/
				//////////////loss of pay leave,sick leave half pay and no pay//////////////
						$leavedays=0;
						$sql1 = "Select HalfDaySts,LossOfPay,Entitled,PaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and empleave.LeaveStatus=2 and (empchild.LeaveDay between '$date' and '$lastdate') and empleave.OrganizationId = ? and empleave.EmployeeId =?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $empid));
						while($row1 = $query1->fetch())
						{
							if($row1->HalfDaySts==1 && $row1->LossOfPay==1)
								$leavedays=$leavedays+0.5;
							elseif($row1->HalfDaySts==0 && $row1->LossOfPay==1)
								$leavedays++;
							elseif($row1->PaySts == 2 && $row1->Entitled == 1)
								$leavedays=$leavedays+0.5;
							elseif($row1->PaySts == 0 && $row1->Entitled == 1)
								$leavedays++;
						}
							$salaryadvance=0;
						////////////////   SALARY ADVANCE CAN NOT BE PAID IN FINAL SETTLEMENT  ///////			
						//// LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////				
						$sql1 = "SELECT * FROM SalaryOtherHead  where OrganizationId=? and ActiveSts=1 ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($orgid));
						while($row1 = $query1->fetch())
						{
							$res1 = array();
							$res1['id'] = $row1->HeadCode;
							$res1['amount'] = 0;
							$res1['days'] = 0;
							if($row1->HeadCode==8){
								$res1['amount'] = (float)$salaryadvance;
								$emptotal += (float)$salaryadvance;
								
							}elseif($row1->HeadCode==9 && $ltamonth>0){
								//if($this->getLTA($empid,$ltamonth)){
								//	$res1['amount'] = (float)$lta;
								//	$emptotal += (float)$lta;
								//}
							}  else if($row1->HeadCode==2){
								$overtime = 0;
						if($paymentsts){
							//$overtime = $this->getEmployeeOvertime($empid, $date, $lastdate, 1);
							$overtime = $this->getEmployeeOvertime($empid, $date);
							$overtime = (float)round($overtime,2);
						}						
						$res1['amount']  = (float)$overtime;
						$emptotal += (float)$overtime;
					}else if($row1->HeadCode==5){
						$incentive = $this->getEmployeeIncentive($empid, $date, 1);
						$res1['amount']  = (float)$incentive;
						$emptotal += (float)$incentive ;
					}else if($row1->HeadCode==4){
						//$leavededuction = 0;//$this->getEmployeeLeave($empid, $date, $lastdate, $onedaysal, 1);
						//$res['emppaiddays'] = $res['emppaiddays']-($leavedays);
						//echo $leavedays;
						$leavededuction = round($onedaysal*$leavedays);		
						$leavededuction = (float)round($leavededuction, 2);
						$res1['amount']  = $leavededuction;
						$emptotaldeduction += $leavededuction;
					}else if($row1->HeadCode==1){
						$salaryadvance_installment = $this->getEmployeeLoanInstallment($empid, $date, 1);
						$res1['amount']  = (float)$salaryadvance_installment;
						$emptotaldeduction += (float)$salaryadvance_installment ;
					}else if($row1->HeadCode==35){
						$salaryadvance_installmentamt = $this->getAdvanceLoanInstallment($empid, $date, 1);
						$res1['amount']  = (float)$salaryadvance_installmentamt;
						$emptotaldeduction += (float)$salaryadvance_installmentamt ;
					}else if($row1->HeadCode==19 ){
						$res1['amount']  = (float)round(($onedaysal * $res['emppaiddays']),2);
						$emptotal += (float)round(($onedaysal * $res['emppaiddays']),2);
					}else if($row1->HeadCode==10 ){
						$gratuity = Utils::getEmployeeGratuity($empid, $empsts, $this->db, $lastdate);
						$res1['amount']  = (float)round($gratuity,2);
						$emptotal += (float)round($gratuity,2);
					}else if($row1->HeadCode==18 && $row->daysleft<0){
						/////////CALCULATE ONE DAY SALARY ON THE BASIS OF 30 DAY BECAUSE WE DON'T KNOW THE LEAVE BALANCE IS FROM WHICH MONTH,SO HERE WE TAKE ESTIMATION OF 30 DAYS,ONLY FOR LEAVE SALARY WE ARE DOING THIS///////////
						$onedaysalary = ($row->EmployeeCTC)/30 ;
						$leavesal = self::getEmployeeLeaveSalary($empid,$lastdate,$onedaysalary);
						$res1['amount']  = (float)round($leavesal,2);
						$emptotal += (float)round($leavesal,2);
					}
					$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 2;
					$res1['headtype'] = (float)$row1->Type;
					$res['salarydetail'][]=$res1;
				}
				
				$bankname =""; $bankcode =""; $bankacct =0;
				$sqlbank = "Select * from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
				$querybank = $this->db->prepare($sqlbank);
				$querybank->execute(array($empid));
				while($r = $querybank->fetch())
				{
					$bankname = Utils::getName($r->BankId, "BankMaster", "Name", $this->db);
					$bankcode = $r->SwiftCode;
					$bankacct = $r->IBAN;
				}
				$res['bankname'] = $bankname;
				$res['bankcode'] = Utils::decode5t($bankcode);
				$res['bankacct'] = Utils::decode5t($bankacct);
				$res['emppaiddays'] = $res['emppaiddays']-($leavedays);
				$res['emptotaldeduction'] = $emptotaldeduction;
				$res['empnetsalary'] = $emptotal-$emptotaldeduction;
				//$res['empctc'] = $ctc;
				$res['emptotal'] = $emptotal;
				$res['emptotal1'] = $emptotal-$emptotaldeduction;
				$res['finalsts'] = 0;
				$res['pendingamt']=0;
				$res['paidamt']=0;
				$res['balanceamt']=0;
				$salaryid=$this->getFinalSalaryId($empid);
				if($salaryid!=0)
				{
					$res['bankname'] = Utils::getName($salaryid,'SalaryMaster','BankName',$this->db);
					$res['bankcode'] = Utils::decode5t(Utils::getName($salaryid,'SalaryMaster','BankCode',$this->db));
					$res['bankacct'] = Utils::decode5t(Utils::getName($salaryid,'SalaryMaster','BankAccountNo',$this->db));
					$res['finalsts'] = 1;
					$sql = "SELECT * from FinalSettlementHistory where EmployeeId=? and OrganizationId=?";
					$query = $this->db->prepare($sql);	
					$query->execute(array( $empid,$orgid));	
					while($rowfinal=$query->fetch())
					{
						$res['pendingamt']=$rowfinal->TotalAmount;
						$res['paidamt']=$rowfinal->PaidAmount;
						$res['balanceamt']=$rowfinal->BalanceAmount;
					}
				}
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	////////////update salary one by one from bulk module whenever user clicked on save ///////////

	public function UpdateSalary($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		///////////////  TRANSACTION BEGINS HERE ///////////////////////////////
		$this->db->beginTransaction();		
		try{	
			$emparr = json_decode($request[2] , true);
			$holdsts = $request[3];
			
			$fiscalid = Utils::getFiscalId($emparr['empmonthdate'], $this->db);
			
			if($fiscalid!=0)
			{
				$empid=0;
				
				$sql1 = "SELECT Id FROM SalaryMaster WHERE EmployeeId = ? and SalaryMonth=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $emparr['id'],$emparr['empmonthdate'] ));
				if($query1->rowCount()>0)
				{
					$r=$query1->fetch();
				 	$empid=$r->Id;
							
					$sql1 = "UPDATE SalaryMaster set EmployeeCTC=?, PaidDays=?, OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?,  BankName=?, BankCode=?, BankAccountNo=?,Description=? ,ModePayment=?,HoldStatus=? where Id=?";
					try{
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(  $emparr['empnetsalary'], $emparr['emppaiddays'], $orgid, $mdate, $mid,  $emparr['bankname'], Utils::encode5t($emparr['bankcode']) ,Utils::encode5t($emparr['bankacct']),$emparr['desc'], $emparr['modepayment'],$holdsts, $empid));
						$count =  $query1->rowCount();		
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}else{
					$sql = "INSERT INTO SalaryMaster ( FiscalId, EmployeeId, SalaryMonth, EmployeeCTC, PaidDays, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, BankName, BankCode, BankAccountNo,Description,ModePayment,HoldStatus) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
					try{
						$query = $this->db->prepare($sql);
						$query->execute(array( $fiscalid, $emparr['id'], $emparr['empmonthdate'], $emparr['empnetsalary'], $emparr['emppaiddays'], $orgid, $mdate, $mid, $mdate, $mid, $mid, $emparr['bankname'], Utils::encode5t($emparr['bankcode']), Utils::encode5t($emparr['bankacct']), $emparr['desc'], $emparr['modepayment'] ,$holdsts));
						$empid = $this->db->lastInsertId();
						$count =  $query->rowCount();		
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}
				if($count ==1){
					///////////////////UPDATE CHILD TABLE RECORD OF SALARY MASTER ////////////
					$sqlc="delete from SalaryChild where SalaryId=?";
					$queryc=$this->db->prepare($sqlc);
					$queryc->execute(array($empid));
					$salarychild = $emparr['salarydetail'];
					foreach( $salarychild as $value)
					{
						$sql = "INSERT INTO SalaryChild (SalaryId, HeadId, HeadType, HeadAmount, HeadAddDeduct) values(?,?,?,?,?)";		
						$query = $this->db->prepare($sql);			
						try{
						$query->execute(array($empid, $value['id'], $value['type'], $value['amount'] , $value['headtype'] ));
							$count =  $query->rowCount();						
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					}

					$status =true;
					$successMsg = "Changes saved successfully";
																
				}
			}else{
				$status =false;
				$errorMsg="Fiscal year not found for selected month";
			}
		//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
			$this->db->commit(); 
				 
			}catch(PDOException $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			}catch(Exception $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			} 
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
    /**
     * Setter for a SalaryMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$salaryid = Utils::decode5t($request[3]);	//SALARY ID CONTAINS IN ARRAY FOURTH VALUE;
		$paiddays=isset($_POST['paiddays'])?$_POST['paiddays']:30;	
		
			$sql = "UPDATE SalaryMaster SET  EmployeeCTC=?,PaidDays=?,LastModifiedDate=?, LastModifiedById=?, BankName=?, BankCode=?, BankAccountNo=?,Description=?,agent_id=? where Id = ?";		
			$query = $this->db->prepare($sql);			
			try{
				$query->execute(array($request[7],$paiddays,$mdate, $mid, $request[4], Utils::encode5t($request[5]), Utils::encode5t($request[6]), $request[8],$request[9], $salaryid ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			///////////////////UPDATE CHILD TABLE OF SALARY TYPE MASTER ////////////
			$salarychild = json_decode($request[2] , true);
			foreach($salarychild as $value)
			{
				$sql = "UPDATE SalaryChild SET  HeadAmount=? WHERE SalaryId = ? and HeadId=? and HeadType=?";		
				$query = $this->db->prepare($sql);			
				try{						
					$query->execute(array($value['amount'], $salaryid, $value['id'], $value['type'] ));
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			if ($count == 1) {
				$empid=Utils::getName($salaryid,'SalaryMaster','EmployeeId',$this->db);
				$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="A Salary has been updated $empname ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Salary", $msg, $orgid));
			   $status =true;
			   $successMsg = SALARYMASTER_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=SALARYMASTER_MODULE_UPDATION_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

    /**
     * Setter for a SalaryMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$month = $request[6];
		$fiscalid = Utils::getFiscalId($month, $this->db);
		$empid =0;
		if($fiscalid!=0)
		{
			$bankname =""; $bankcode =""; $bankacct =0;
			$sql = "Select * from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2]));
			while($row = $query->fetch())
			{
				$bankname = Utils::getName($row->BankId, "BankMaster", "Name", $this->db);
				$bankcode = $row->SwiftCode;
				$bankacct = $row->IBAN;
			}
			
			$sql = "INSERT INTO SalaryMaster (FiscalId, EmployeeId, SalaryMonth, EmployeeCTC, PaidDays, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, BankName, BankCode, BankAccountNo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query = $this->db->prepare($sql);

				$query->execute(array( $fiscalid, $request[2], $month, $request[3], $request[4], $orgid, $mdate, $mid, $mdate, $mid, $mid, $bankname, $bankcode, $bankacct ));
				$empid =$this->db->lastInsertId();
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
			if ($count == 1) {
				//$empid=Utils::getName($salaryid,'SalaryMaster','EmployeeId',$this->db);
				$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$msg="A Salary has been created $empname ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Salary", $msg, $orgid));
				///////////////////INSERT CHILD TABLE RECORD OF SALARY MASTER ////////////
				$salarychild = json_decode($request[5] , true);
				foreach( $salarychild as $value)
				{
					$sql = "INSERT INTO SalaryChild (SalaryId, HeadId, HeadType, HeadAmount, HeadAddDeduct) values(?,?,?,?,?)";		
					$query = $this->db->prepare($sql);			
					try{						
						$query->execute(array($empid, $value['id'], $value['type'], $value['amount'], $value['headtype'] ));
						$count =  $query->rowCount();
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}		
				
			   $status =true;
			   $successMsg = SALARYMASTER_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=SALARYMASTER_MODULE_CREATION_FAILED;
			}
		
		}else{
			$status =false;
			   $errorMsg="Fiscal year not found";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	/**
     * Setter for a SalaryMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function CreateFinalSettlement($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $balanceamount=0;
        $val=$_POST['val'];
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$month = $request[6];
		$netsalary = $request[3];
		$VisibleStatus = 1;
		$totalsalary = $_POST['totalsalary'];
		$fiscalid = Utils::getFiscalId($month, $this->db);
		$empid=0;
		if($fiscalid!=0)
		{
			$bankname =$request[9]; 
			$bankcode =$request[10]; 
			$bankacct =$request[11];
			
			/*$sql = "Select * from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2]));
			while($row = $query->fetch())
			{
				$bankname = Utils::getName($row->BankId, "BankMaster", "Name", $this->db);
				$bankcode = $row->SwiftCode;
				$bankacct = $row->IBAN;
			}*/
			
			///////////////  FINAL SETTLEMENT TRANSACTION BEGINS  ///////////////////////////////
		try{	
			if($val==1){
				$this->db->beginTransaction();	
				$sql1 = "SELECT Id FROM SalaryMaster WHERE EmployeeId = ? and SalaryMonth=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($request[2],$month ));
				if($query1->rowCount()>0)
				{
					$r=$query1->fetch();
				 	$salaryid=$r->Id;
					$sql1 = "UPDATE SalaryMaster set EmployeeCTC=?, PaidDays=?, OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?,  BankName=?, BankCode=?, BankAccountNo=?, FinalSettlementSts=1, VisibleStatus=1 where Id=?";
					
					try{
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $request[3], $request[4], $orgid, $mdate, $mid, $bankname, Utils::encode5t($bankcode), Utils::encode5t($bankacct),$salaryid));
						$count =  $query1->rowCount();		
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}else{	
					$sql = "INSERT INTO SalaryMaster ( FiscalId, EmployeeId, SalaryMonth, EmployeeCTC, PaidDays, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, FinalSettlementSts, BankName, BankCode, BankAccountNo, VisibleStatus) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
					$query = $this->db->prepare($sql);
					$query->execute(array( $fiscalid, $request[2], $month, $request[3], $request[4], $orgid, $mdate, $mid, $mdate, $mid, $mid, 1, $bankname, Utils::encode5t($bankcode), Utils::encode5t($bankacct),$VisibleStatus));
					$salaryid =$this->db->lastInsertId();
					$count =  $query->rowCount();		
				}
			
					if ($count == 1) {
						
						///////////////////INSERT CHILD TABLE RECORD OF SALARY MASTER ////////////
						$sqlc="delete from SalaryChild where SalaryId=?";
						$queryc=$this->db->prepare($sqlc);
						$queryc->execute(array($salaryid));
						$salarychild = json_decode($request[5] , true);
						foreach( $salarychild as $value)
						{
							$sql = "INSERT INTO SalaryChild (SalaryId, HeadId, HeadType, HeadAmount, HeadAddDeduct) values(?,?,?,?,?)";		
							$query = $this->db->prepare($sql);			
							try{						
								$query->execute(array($salaryid, $value['id'], $value['type'], $value['amount'], $value['headtype'] ));
								$count =  $query->rowCount();
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}		
						
						$checklist = json_decode($request[8] , true);
						foreach( $checklist as $value)
						{
							$sql = "INSERT INTO EmployeeChecklist (EmployeeId, Name, Sts, CategoryId, ChecklistId) values(?,?,?,?,?)";		
							$query = $this->db->prepare($sql);			
							try{						
								$query->execute(array($request[2], $value['name'], $value['sts'], 2, $value['id'] ));
								$count =  $query->rowCount();
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}
						$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
						$msg="Salary has been created $empname";
						$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($mid, "Employee Salary", $msg, $orgid));
						
					   $status =true;
					   $successMsg = SALARYMASTER_MODULE_CREATION_SUCCESS;
					} else {
					   $status =false;
					   $errorMsg=SALARYMASTER_MODULE_CREATION_FAILED;
					}
					$balanceamount=$totalsalary-$netsalary;
					$sql = "INSERT into FinalSettlementHistory( EmployeeId, TotalAmount, BalanceAmount, PaidAmount, OrganizationId) values (?,?,?,?,?)";
					$query = $this->db->prepare($sql);	
					$query->execute(array( $request[2],$totalsalary,$balanceamount,$netsalary,$orgid));	
					
					if($balanceamount==0)
					{
						$sql = "Update EmployeeMaster set DOL=? where Id=?";
						$query = $this->db->prepare($sql);	
						$query->execute(array(Utils::getDateformat($request[7]), $request[2]));
								
						$sql = "Update SeveranceMaster set FinalSts=1, EffectDate=? where EmployeeId=?";
						$query = $this->db->prepare($sql);	
						$query->execute(array( Utils::getDateformat($request[7]), $request[2]));
								
						$sql = "Update UserMaster set VisibleSts=0, LastModifiedDate=?, LastModifiedById=? where EmployeeId=?";
						$query = $this->db->prepare($sql);	
						$query->execute(array( $mdate, $mid, $request[2]));	
						$status =true;
						$successMsg = "Final settlement has been completed";
					}
					//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
					 $this->db->commit(); 
			}	
			if($val==2){
				$this->db->beginTransaction();	
				$sql1 = "SELECT Id FROM SalaryMaster WHERE EmployeeId = ? and SalaryMonth=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($request[2],$month ));
				if($query1->rowCount()>0)
				{
					$r=$query1->fetch();
				 	$salaryid=$r->Id;
					$sql1 = "UPDATE SalaryMaster set EmployeeCTC=?, PaidDays=?, OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?,  BankName=?, BankCode=?, BankAccountNo=?, FinalSettlementSts=1, VisibleStatus=0 where Id=?";
					
					try{
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $request[3], $request[4], $orgid, $mdate, $mid, $bankname, Utils::encode5t($bankcode), Utils::encode5t($bankacct),$salaryid));
						$count =  $query1->rowCount();		
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}else{	
					$sql = "INSERT INTO SalaryMaster ( FiscalId, EmployeeId, SalaryMonth, EmployeeCTC, PaidDays, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, FinalSettlementSts, BankName, BankCode, BankAccountNo, VisibleStatus) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array( $fiscalid, $request[2], $month, $request[3], $request[4], $orgid, $mdate, $mid, $mdate, $mid, $mid, 1, $bankname, Utils::encode5t($bankcode), Utils::encode5t($bankacct), 0));
					$salaryid =$this->db->lastInsertId();
					$count =  $query->rowCount();		
				}
			
					if ($count == 1) {
						
						///////////////////INSERT CHILD TABLE RECORD OF SALARY MASTER ////////////
						$sqlc="delete from SalaryChild where SalaryId=?";
						$queryc=$this->db->prepare($sqlc);
						$queryc->execute(array($salaryid));
						$salarychild = json_decode($request[5] , true);
						foreach( $salarychild as $value)
						{
							$sql = "INSERT INTO SalaryChild (SalaryId, HeadId, HeadType, HeadAmount, HeadAddDeduct) values(?,?,?,?,?)";		
							$query = $this->db->prepare($sql);			
							try{						
								$query->execute(array($salaryid, $value['id'], $value['type'], $value['amount'], $value['headtype'] ));
								$count =  $query->rowCount();
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}		
						
						$checklist = json_decode($request[8] , true);
						foreach( $checklist as $value)
						{
							$sql = "INSERT INTO EmployeeChecklist (EmployeeId, Name, Sts, CategoryId, ChecklistId) values(?,?,?,?,?)";		
							$query = $this->db->prepare($sql);			
							try{						
								$query->execute(array($request[2], $value['name'], $value['sts'], 2, $value['id'] ));
								$count =  $query->rowCount();
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}
						$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
						$msg="Salary has been created $empname";
						$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($mid, "Employee Salary", $msg, $orgid));
						
					   $status =true;
					   $successMsg = SALARYMASTER_MODULE_CREATION_SUCCESS;
					} else {
					   $status =false;
					   $errorMsg=SALARYMASTER_MODULE_CREATION_FAILED;
					}
					$balanceamount=$totalsalary-$netsalary;
					$sql = "INSERT into FinalSettlementHistory( EmployeeId, TotalAmount, BalanceAmount, PaidAmount, OrganizationId) values (?,?,?,?,?)";
					$query = $this->db->prepare($sql);	
					$query->execute(array( $request[2],$totalsalary,$balanceamount,$netsalary,$orgid));	
					
					if($balanceamount==0)
					{
						$sql = "Update EmployeeMaster set DOL=? where Id=?";
						$query = $this->db->prepare($sql);	
						$query->execute(array(Utils::getDateformat($request[7]), $request[2]));
								
						$sql = "Update SeveranceMaster set FinalSts=1, EffectDate=? where EmployeeId=?";
						$query = $this->db->prepare($sql);	
						$query->execute(array( Utils::getDateformat($request[7]), $request[2]));
								
						$sql = "Update UserMaster set VisibleSts=0, LastModifiedDate=?, LastModifiedById=? where EmployeeId=?";
						$query = $this->db->prepare($sql);	
						$query->execute(array( $mdate, $mid, $request[2]));	
						$status =true;
						$successMsg = "Final settlement has been completed";
					}
					//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
					 $this->db->commit(); 
			}
			else
			{
				$pendingamt=$_POST['pendingamt'];
				$paidamt=$_POST['paidamt'];
				$balanceamount=$_POST['balanceamt'];
				$sql = "UPDATE FinalSettlementHistory set TotalAmount=?, PaidAmount=?, BalanceAmount=? where EmployeeId=? and OrganizationId=?";
				$query = $this->db->prepare($sql);	
				$query->execute(array( $pendingamt,$paidamt,$balanceamount,$request[2],$orgid));	
				if($balanceamount==0)
				{
					$sql = "Update EmployeeMaster set DOL=? where Id=?";
					$query = $this->db->prepare($sql);	
					$query->execute(array(Utils::getDateformat($request[7]), $request[2]));
								
					$sql = "Update SeveranceMaster set FinalSts=1, EffectDate=? where EmployeeId=?";
					$query = $this->db->prepare($sql);	
					$query->execute(array( Utils::getDateformat($request[7]), $request[2]));
								
					$sql = "Update UserMaster set VisibleSts=0, LastModifiedDate=?, LastModifiedById=? where EmployeeId=?";
					$query = $this->db->prepare($sql);	
					$query->execute(array( $mdate, $mid, $request[2]));	
					$status =true;
					$successMsg = "Final settlement has been completed";
				}
				$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$msg="Final Settlement has been created $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Salary", $msg, $orgid));
				$status =true;
				$successMsg = "Salary details updated successfully";
				
			}
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}catch(Exception $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		} 			
		}else{
			$status =false;
			   $errorMsg="Fiscal year not found";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function CreateBulkSalary1($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$finalsts=$_POST['finalsts'];
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		///////////////  TRANSACTION BEGINS HERE ///////////////////////////////
		$this->db->beginTransaction();		
		try{	
			$emparr = json_decode($request[2] , true);
			$fiscalid = Utils::getFiscalId($emparr[0]['empmonthdate'], $this->db);
			
			if($fiscalid!=0)
			{
				for($i=0; $i<count($emparr); $i++)
				{
					if($emparr[$i]['sts'])
					{
						
						/*
						$bankname ="";
						$bankcode ="";
						$bankacct =0;
						$sql = "Select BankId,SwiftCode,IBAN from EmployeeBankDetails where EmployeeId=? and BankStatus=1";
						$query = $this->db->prepare($sql);
						$query->execute(array($emparr[$i]['id']));
						while($row = $query->fetch())
						{
							$bankname = Utils::getName($row->BankId, "BankMaster", "Name", $this->db);
							$bankcode = $row->SwiftCode;
							$bankacct = $row->IBAN;
						}*/
						
						$sql = "SELECT Id FROM SalaryMaster where EmployeeId=? and SalaryMonth=? and FiscalId=?";
						$query = $this->db->prepare($sql);
						$query->execute(array(  $emparr[$i]['id'], $emparr[$i]['empmonthdate'],$fiscalid ));
						
						if($query->rowCount()>0)
						{
							while($row=$query->fetch()){
							
								$empid=$row->Id;
								$sql1 = "UPDATE SalaryMaster set EmployeeCTC=?, PaidDays=?, OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?,  BankName=?, BankCode=?, BankAccountNo=?,Description=? where FiscalId=? and EmployeeId=? and SalaryMonth=?";
							
								try{
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array(  $emparr[$i]['empnetsalary'], $emparr[$i]['emppaiddays'], $orgid, $mdate, $mid,  $emparr[$i]['bankname'], Utils::encode5t($emparr[$i]['bankcode']) ,Utils::encode5t($emparr[$i]['bankacct']),$emparr[$i]['desc'],$fiscalid, $emparr[$i]['id'], $emparr[$i]['empmonthdate']));
									$count =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
								
								if($count ==1){
									///////////////////UPDATE CHILD TABLE RECORD OF SALARY MASTER ////////////
									$salarychild = $emparr[$i]['salarydetail'];
									foreach( $salarychild as $value)
									{
													
										try{
											$sql1 = "Select SalaryId from SalaryChild where SalaryId=? and HeadId=? and HeadType=?";
											$query1 = $this->db->prepare($sql1);
											$query1->execute(array($empid, $value['id'], $value['type']));
											if($query1->rowCount()>0){
												$sql2 = "UPDATE SalaryChild set HeadAmount=? where SalaryId=? and HeadId=? and HeadType=?";
												$query2 = $this->db->prepare($sql2);
												$query2->execute(array($value['amount'] , $empid, $value['id'], $value['type'] ));
											}else{
												$sql2 = "INSERT INTO SalaryChild (SalaryId, HeadId, HeadType, HeadAmount, HeadAddDeduct) values(?,?,?,?,?)";$query2 = $this->db->prepare($sql2);
												$query2->execute(array($empid, $value['id'], $value['type'],$value['amount'] , $value['headtype'] ));
											}
										}catch(Exception $e) {
											$errorMsg = 'Message: ' .$e->getMessage();
										}
									}	
								}
							   $status =true;
							   $successMsg = "Changes saved successfully";
							}
							
						}else{
							$sql = "INSERT INTO SalaryMaster ( FiscalId, EmployeeId, SalaryMonth, EmployeeCTC, PaidDays, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, BankName, BankCode, BankAccountNo,Description) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
							
							try{
								$query = $this->db->prepare($sql);
								$query->execute(array( $fiscalid, $emparr[$i]['id'], $emparr[$i]['empmonthdate'], $emparr[$i]['empnetsalary'], $emparr[$i]['emppaiddays'], $orgid, $mdate, $mid, $mdate, $mid, $mid, $emparr[$i]['bankname'], Utils::encode5t($emparr[$i]['bankcode']), Utils::encode5t($emparr[$i]['bankacct']), $emparr[$i]['desc'] ));
								$empid = $this->db->lastInsertId();
								$count =  $query->rowCount();		
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						
							if ($count == 1) {
								///////////////////INSERT CHILD TABLE RECORD OF SALARY MASTER ////////////
								$salarychild = $emparr[$i]['salarydetail'];
								foreach( $salarychild as $value)
								{
									$sql = "INSERT INTO SalaryChild (SalaryId, HeadId, HeadType, HeadAmount, HeadAddDeduct) values(?,?,?,?,?)";		
									$query = $this->db->prepare($sql);			
									try{
										
										$query->execute(array($empid, $value['id'], $value['type'], $value['amount'] , $value['headtype'] ));
										$count =  $query->rowCount();						
									}catch(Exception $e) {
										$errorMsg = 'Message: ' .$e->getMessage();
									}
								}	
							   $status =true;
							   $successMsg = "Changes saved successfully";
							}
						}
					}
				}
				
				if($finalsts==1){
					$sql = "select * from SalaryGenerateMonth where SalaryMonth=? and OrganizationId=?";
					$query = $this->db->prepare($sql);
					$query->execute(array($emparr[0]['empmonthdate'],$orgid));
					if($query->rowCount()==0)
					{
						$sql1 = "INSERT INTO SalaryGenerateMonth (SalaryMonth, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) values(?,?,?,?,?,?,?)";		
						$query1 = $this->db->prepare($sql1);			
						try{						
							$query1->execute(array($emparr[0]['empmonthdate'], $orgid, $mdate, $mid, $mdate, $mid, $mid ));
							$count =  $query1->rowCount();	
							if($count==1)
							{
								$status =true;
								$successMsg=SALARYMASTER_MODULE_CREATION_SUCCESS;
							}							
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					}
					
				}
			}else{
				$status =false;
				$errorMsg="Fiscal year not found for selected month";
			}
		//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
			$this->db->commit(); 
				 
			}catch(PDOException $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			}catch(Exception $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			} 
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
/* 	public function CreateBulkSalary($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$finalsts=$_POST['finalsts'];
		$sendmailsts=isset($_POST['sendmailsts'])?$_POST['sendmailsts']:0;
		$salarymonth="";
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		///////////////  TRANSACTION BEGINS HERE ///////////////////////////////
		$this->db->beginTransaction();		
		try{	
			$emparr = json_decode($request[2] , true);
			$fiscalid = Utils::getFiscalId($emparr[0]['empmonthdate'], $this->db);
			$salaryid=0;
			if($fiscalid!=0)
			{
				for($i=0; $i<count($emparr); $i++)
				{
					$empid1=$emparr[$i]['id'];
					$salarymonth=$emparr[$i]['empmonthdate'];
					$EmployeeCTC=$emparr[$i]['empnetsalary'];
					
					if($emparr[$i]['sts'])
					{
						$sql1 = "SELECT Id FROM SalaryMaster WHERE EmployeeId = ? and SalaryMonth=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $emparr[$i]['id'],$emparr[$i]['empmonthdate'] ));
						if($query1->rowCount()>0)
						{
							$r=$query1->fetch();
						 	$empid=$r->Id;
								$sql1 = "UPDATE SalaryMaster set EmployeeCTC=?, PaidDays=?, OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?,  BankName=?, BankCode=?, BankAccountNo=?,Description=?, agent_id=?, 	ModePayment=?, FinalStatus=?,RemainingLateIns=?,RemainingEarlyIns=?  where Id=?";
								try{
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array(  $emparr[$i]['empnetsalary'], $emparr[$i]['emppaiddays'], $orgid, $mdate, $mid,  $emparr[$i]['bankname'], Utils::encode5t($emparr[$i]['bankcode']) ,Utils::encode5t($emparr[$i]['bankacct']),$emparr[$i]['desc'], $emparr[$i]['agent_id'], $emparr[$i]['modepayment'],$finalsts,$emparr[$i]['remainderlatecoming'],$emparr[$i]['remainderearlyleaving'],$empid));
									$count =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
						}else{
							$sql = "INSERT INTO SalaryMaster ( FiscalId, EmployeeId, SalaryMonth, EmployeeCTC, PaidDays, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, BankName, BankCode, BankAccountNo,Description, agent_id,ModePayment,FinalStatus,RemainingLateIns,RemainingEarlyIns) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)";
							
							try{
								$query = $this->db->prepare($sql);
								$query->execute(array( $fiscalid, $emparr[$i]['id'], $emparr[$i]['empmonthdate'], $emparr[$i]['empnetsalary'], $emparr[$i]['emppaiddays'], $orgid, $mdate, $mid, $mdate, $mid, $mid, $emparr[$i]['bankname'], Utils::encode5t($emparr[$i]['bankcode']), Utils::encode5t($emparr[$i]['bankacct']), $emparr[$i]['desc'], $emparr[$i]['agent_id'],$emparr[$i]['modepayment'],$finalsts,$emparr[$i]['remainderlatecoming'],$emparr[$i]['remainderearlyleaving'] ));
								$salaryid=$empid = $this->db->lastInsertId();
								$count =  $query->rowCount();

								/*generate mail and alert for salary generate*/
	/*							$sid=$this->db->LastInsertId();
								Alerts::generateActionAlerts(38,$sid,$orgid,$this->db);
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						
						}
						if($count==1){
							$basic=Utils::getEmployeeBasicSalary($empid1,$this->db);
							$totalemp=Utils::getTotalNoEmployee($orgid,$this->db);
							$pfsts=$this->getPFStatus($totalemp,$basic,$EmployeeCTC);
							$PFEmployee=0;
							$PFEmployer=0;
							if($pfsts){
								$PFEmployee = $this->getEmployeePF($basic,$EmployeeCTC,$orgid);
								$PFEmployer = $this->getEmployerPF($basic,$EmployeeCTC,$orgid);
							}
							$previoustotal = $this->getPreviousTotalPF($empid1,$salarymonth);
							$total=$previoustotal+$PFEmployee+$PFEmployer;
							$sql1 = "SELECT * FROM ProvidentFundMaster WHERE EmployeeId = ? and SalaryMonth = ?";
							$query = $this->db->prepare($sql1);
							$query->execute(array($empid1,$salarymonth));	
							$count1=	$query->rowCount();
							//$totalpf=$this->getTotalPF();
							if($count1==1){
								$sql1 = "UPDATE ProvidentFundMaster set EmployeeId=?, SalaryMonth=?, EmployeePF=?, EmployerPF=?, Total=?,SalaryId=?,ModifiedDate=?,OrganizationId=? WHERE EmployeeId = ? and SalaryMonth=?";
							try{
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($empid1,$salarymonth,$PFEmployee,$PFEmployer,$total,$salaryid,$mdate,$orgid,$empid1,$salarymonth));
								$count =  $query1->rowCount();		
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}else{
								$sql = "INSERT INTO ProvidentFundMaster (EmployeeId, SalaryMonth, EmployeePF, EmployerPF, Total, SalaryId,OrganizationId,ModifiedDate) VALUES ( ?, ?, ?, ?, ?, ?, ?,?)";
								try{
									$query = $this->db->prepare($sql);
									$query->execute(array($empid1,$salarymonth,$PFEmployee,$PFEmployer,$total,$salaryid,$orgid,$mdate));
									$count =  $query->rowCount();		
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
							}
						}
						if($count ==1){
							$saldetails="";
							
							/////////////////// UPDATE CHILD TABLE RECORD OF SALARY MASTER ////////////
							$sqlc="delete from SalaryChild where SalaryId=?";
							$queryc=$this->db->prepare($sqlc);
							$queryc->execute(array($empid));
							$salarychild = $emparr[$i]['salarydetail'];
							foreach( $salarychild as $value)
							{
								$sql = "INSERT INTO SalaryChild (SalaryId, HeadId, HeadType, HeadAmount, HeadAddDeduct) values(?,?,?,?,?)";		
								$query = $this->db->prepare($sql);
								try{
									$query->execute(array($empid, $value['id'], $value['type'], $value['amount'] , $value['headtype'] ));
									$count =  $query->rowCount();						
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
								
							}
							///////////////IF FINALIZE SALARY CLICKED,THEN A FINAL SALARY WILL SEND TO EMPLOYEE AS A MAIL//////////////
						
							if($sendmailsts)
							{
								$msg="";
								$empmailencode=Utils::getName($empid1,'EmployeeMaster','CompanyEmail',$this->db);
								$empdoj=Utils::dateformatter( Utils::getName($empid1,'EmployeeMaster','DOJ',$this->db));
								$empmail=Utils::decode5t($empmailencode);
								
								if($empmail){
									
									$salmonth=date("M",strtotime($salarymonth));
									$companyname=Utils::getName($orgid,'Organization','Name',$this->db);
									$logo=Utils::getName($orgid,'Organization','Logo',$this->db);
									$companylogo = URL."public/uploads/".$orgid."/".$logo;
									$empname=$emparr[$i]['name'];
									
									$title="$salmonth's Salary has been prepared";
									$msg="<html><p>Hi $empname,</p><p>Your salary for $salmonth has got generated.Please get in touch with HR for any clarifications within 7 days. </p><p>Please note that after 7 days of receiving this mail,no queries will be entertained</p>";
									$msg.='<table border="1" style="width:800px;text-align:left">
									   <tr><td>
										<table width="100%" >
										<tr>
										<td width="33%"><img height="50px" src="'.$companylogo.'"></td>
										  <td width="34%" colspan="2" >
											<h4>'.$companyname.'</h4>
											<h4>Salary for the month of '.$salmonth.'</h4><br>
										  </td>
										  <td width="33%" ></td>
										</tr>
										<tr>
										  <td colspan="4" ></td>
										 </tr>
										 </table >
										 </td></tr>
										 <tr><td>
										<table width="100%" >
										<tr>
										  <th width="15%">Employee Name</th>
										  <td width="35%">'.$emparr[$i]['name'].'</td>
										  <th width="15%">Division</th>
										  <td width="35%">'.$emparr[$i]['empdivision'].'</td>
										</tr>
										<tr>
										  <th>Department</th>
										  <td>'.$emparr[$i]['empdept'].'</td>
										  <th>Designation</th>
										  <td>'.$emparr[$i]['empdesig'].'</td>
										</tr>
										<tr>
										  <th>Grade</th>
										  <td>'.$emparr[$i]['empgrade'].'</td>
										  <th>Date of Joining</th>
										  <td>'.$empdoj.'</td>
										</tr>
										<tr>
										  <th>Gross Salary</th>
										  <td>'.$emparr[$i]['empcurency'].'&nbsp;'.$emparr[$i]['empctc'].'</td>
										  <th>Days Worked</th>
										  <td>'.$emparr[$i]['emppaiddays'].'</td>
										</tr>
										</table>
									</td></tr>
									<tr><td>
										<table width="100%">
										<tr>
										  <th width="25%">Earnings</th>
										  <th width="25%"  style="padding-right:20px">Amount&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										  <th width="25%">Deductions</th>
										  <th width="25%" >Amount&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										</tr>
									</table>
									</td></tr>
									<tr><td>
										<table width="100%" >
										<tr><td width="50%" valign="top">
											<table width="100%" >';
											foreach( $salarychild as $value)
											{
												if($value['amount'] != 0 && $value['additions'] == 1){
													$msg.='<tr >
													<td width="25%">'.$value['headname'].'</td>
													<td width="25%"  style="padding-right:20px">'.$emparr[$i]['empcurency'].'&nbsp;'.$value['amount'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
											  
													</tr>';
												}
											}
										$msg.='</table>
										</td>
										<td width="50%" valign="top">
											<table width="100%" >';
											foreach( $salarychild as $value)
											{
												if($value['amount'] != 0 && $value['additions'] == 0){
													$msg.='<tr >
													<td width="25%">'.$value['headname'].'</td>
													<td width="25%"  style="padding-right:20px">'.$emparr[$i]['empcurency'].'&nbsp;'.$value['amount'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
											  
													</tr>';
												}
											}
										$msg.='</table>
										</td>
										</tr>
										</table>
									</td></tr>
									<tr><td>
										<table width="100%">
										<tr>
										  <th width="25%">Total Earnings</th>
										  <th width="25%"  style="padding-right:20px">'.$emparr[$i]['empcurency'].'&nbsp;'.$emparr[$i]['emptotal'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										  <th width="25%">Total Deductions</th>
										  <th width="25%" >'.$emparr[$i]['empcurency'].'&nbsp;'.$emparr[$i]['empdeduction'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										</tr>
										</table>
									</td></tr>
									<tr><td>
										<table width="100%">
										<tr>
										  <th width="25%"></th>
										  <th width="25%" class="text-right">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										  <th width="25%">Net Pay</th>
										  <th width="25%" class="text-right">'.$emparr[$i]['empcurency'].'&nbsp;'.$emparr[$i]['empnetsalary'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										</tr>
										</table>
									</td></tr>
									
									</table></html>';
									
									//Utils::sendMail($empmail,$empname,$title,$msg);
									if($emparr[$i]['empnetsalary']!=0){
									Utils::sendMail($empmail,$empname,$title,$msg);
									//Utils::sendMail("monika@ubitechsolutions.com",$empname,$title,$msg);
									//Utils::sendMail("anita@ubitechsolutions.com",$empname,$title,$msg);
									}
									
								}
								//echo $msg."<br>";	
							}
						   $status =true;
						   $successMsg = "Salary saved successfully";
						   if($sendmailsts)
							    $successMsg .= " and mail has been sent to employees";
																
						}
						
						
					}
				}
				
				$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and (DOL='0000-00-00' or DOL>LAST_DAY('$salarymonth')) and DOJ<=LAST_DAY('$salarymonth') and Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$salarymonth') and OrganizationId = ?) and Id NOT IN (SELECT EmployeeId from SalaryMaster where OrganizationId=$orgid and SalaryMonth='$salarymonth' and (FinalStatus=1 or HoldStatus=1)) ";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $orgid));
				$count =  $query->rowCount();
				if($count==0){
					 $sql = "select * from SalaryGenerateMonth where SalaryMonth=? and OrganizationId=?";
					$query = $this->db->prepare($sql);
					$query->execute(array($emparr[0]['empmonthdate'],$orgid));
					if($query->rowCount()==0)
					{
						$sql1 = "INSERT INTO SalaryGenerateMonth (SalaryMonth, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) values(?,?,?,?,?,?,?)";		
						$query1 = $this->db->prepare($sql1);			
						try{						
							$query1->execute(array($emparr[0]['empmonthdate'], $orgid, $mdate, $mid, $mdate, $mid, $mid ));
							$count =  $query1->rowCount();	
							if($count==1)
							{
								$status =true;
								$successMsg=SALARYMASTER_MODULE_CREATION_SUCCESS;
							}							
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					} 
					
				}
				
				if($finalsts==1){*/
					/* $sql = "select * from SalaryGenerateMonth where SalaryMonth=? and OrganizationId=?";
					$query = $this->db->prepare($sql);
					$query->execute(array($emparr[0]['empmonthdate'],$orgid));
					if($query->rowCount()==0)
					{
						$sql1 = "INSERT INTO SalaryGenerateMonth (SalaryMonth, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) values(?,?,?,?,?,?,?)";		
						$query1 = $this->db->prepare($sql1);			
						try{						
							$query1->execute(array($emparr[0]['empmonthdate'], $orgid, $mdate, $mid, $mdate, $mid, $mid ));
							$count =  $query1->rowCount();	
							if($count==1)
							{
								$status =true;
								$successMsg=SALARYMASTER_MODULE_CREATION_SUCCESS;
							}							
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					} */
					
	/*			}
			}else{
				$status =false;
				$errorMsg="Fiscal year not found for selected month";
			}
		//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
			$this->db->commit(); 
				 
			}catch(PDOException $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			}catch(Exception $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			} 
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    } */
	
	
	public function CreateBulkSalary($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$finalsts=$_POST['finalsts'];
		$sendmailsts=isset($_POST['sendmailsts'])?$_POST['sendmailsts']:0;
		$salarymonth="";
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		///////////////  TRANSACTION BEGINS HERE ///////////////////////////////
		$this->db->beginTransaction();		
		try{	
			$emparr = json_decode($request[2] , true);
			$fiscalid = Utils::getFiscalId($emparr[0]['empmonthdate'], $this->db);
			$salaryid=0;
			if($fiscalid!=0)
			{
				for($i=0; $i<count($emparr); $i++)
				{
					$empid1=$emparr[$i]['id'];
					$salarymonth=$emparr[$i]['empmonthdate'];
					$EmployeeCTC=$emparr[$i]['empnetsalary'];
					
					if($emparr[$i]['sts'])
					{
						$sql1 = "SELECT Id FROM SalaryMaster WHERE EmployeeId = ? and SalaryMonth=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $emparr[$i]['id'],$emparr[$i]['empmonthdate'] ));
						if($query1->rowCount()>0)
						{
							$r=$query1->fetch();
						 	$empid=$r->Id;
								$sql1 = "UPDATE SalaryMaster set EmployeeCTC=?, PaidDays=?, OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?,  BankName=?, BankCode=?, BankAccountNo=?,Description=?, agent_id=?, 	ModePayment=?, FinalStatus=?,RemainingLateIns=?,RemainingEarlyIns=?  where Id=?";
								try{
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array(  $emparr[$i]['empnetsalary'], $emparr[$i]['emppaiddays'], $orgid, $mdate, $mid,  $emparr[$i]['bankname'], Utils::encode5t($emparr[$i]['bankcode']) ,Utils::encode5t($emparr[$i]['bankacct']),$emparr[$i]['desc'], $emparr[$i]['agent_id'], $emparr[$i]['modepayment'],$finalsts,$emparr[$i]['remainderlatecoming'],$emparr[$i]['remainderearlyleaving'],$empid));
									$count =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
						}else{
							$sql = "INSERT INTO SalaryMaster ( FiscalId, EmployeeId, SalaryMonth, EmployeeCTC, PaidDays, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, BankName, BankCode, BankAccountNo,Description, agent_id,ModePayment,FinalStatus,RemainingLateIns,RemainingEarlyIns) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)";
							
							try{
								$query = $this->db->prepare($sql);
								$query->execute(array( $fiscalid, $emparr[$i]['id'], $emparr[$i]['empmonthdate'], $emparr[$i]['empnetsalary'], $emparr[$i]['emppaiddays'], $orgid, $mdate, $mid, $mdate, $mid, $mid, $emparr[$i]['bankname'], Utils::encode5t($emparr[$i]['bankcode']), Utils::encode5t($emparr[$i]['bankacct']), $emparr[$i]['desc'], $emparr[$i]['agent_id'],$emparr[$i]['modepayment'],$finalsts,$emparr[$i]['remainderlatecoming'],$emparr[$i]['remainderearlyleaving'] ));
								$salaryid=$empid = $this->db->lastInsertId();
								$count =  $query->rowCount();

								/*generate mail and alert for salary generate*/
								$sid=$this->db->LastInsertId();
								Alerts::generateActionAlerts(38,$sid,$orgid,$this->db);
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						
						}
						if($count==1){
							$basic=Utils::getEmployeeBasicSalary($empid1,$this->db);
							$totalemp=Utils::getTotalNoEmployee($orgid,$this->db);
							$pfsts=$this->getPFStatus($totalemp,$basic,$EmployeeCTC);
							$PFEmployee=0;
							$PFEmployer=0;
							if($pfsts){
								$PFEmployee = $this->getEmployeePF($basic,$EmployeeCTC,$orgid);
								$PFEmployer = $this->getEmployerPF($basic,$EmployeeCTC,$orgid);
							}
							$previoustotal = $this->getPreviousTotalPF($empid1,$salarymonth);
							$total=$previoustotal+$PFEmployee+$PFEmployer;
							$sql1 = "SELECT * FROM ProvidentFundMaster WHERE EmployeeId = ? and SalaryMonth = ?";
							$query = $this->db->prepare($sql1);
							$query->execute(array($empid1,$salarymonth));	
							$count1=	$query->rowCount();
							//$totalpf=$this->getTotalPF();
							if($count1==1){
								$sql1 = "UPDATE ProvidentFundMaster set EmployeeId=?, SalaryMonth=?, EmployeePF=?, EmployerPF=?, Total=?,SalaryId=?,ModifiedDate=?,OrganizationId=? WHERE EmployeeId = ? and SalaryMonth=?";
							try{
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($empid1,$salarymonth,$PFEmployee,$PFEmployer,$total,$salaryid,$mdate,$orgid,$empid1,$salarymonth));
								$count =  $query1->rowCount();		
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}else{
								$sql = "INSERT INTO ProvidentFundMaster (EmployeeId, SalaryMonth, EmployeePF, EmployerPF, Total, SalaryId,OrganizationId,ModifiedDate) VALUES ( ?, ?, ?, ?, ?, ?, ?,?)";
								try{
									$query = $this->db->prepare($sql);
									$query->execute(array($empid1,$salarymonth,$PFEmployee,$PFEmployer,$total,$salaryid,$orgid,$mdate));
									$count =  $query->rowCount();		
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
							}
						}
						if($count ==1){
							$saldetails="";
							
							/////////////////// UPDATE CHILD TABLE RECORD OF SALARY MASTER ////////////
							$sqlc="delete from SalaryChild where SalaryId=?";
							$queryc=$this->db->prepare($sqlc);
							$queryc->execute(array($empid));
							$salarychild = $emparr[$i]['salarydetail'];
							foreach( $salarychild as $value)
							{
								$sql = "INSERT INTO SalaryChild (SalaryId, HeadId, HeadType, HeadAmount, HeadAddDeduct) values(?,?,?,?,?)";		
								$query = $this->db->prepare($sql);
								try{
									$query->execute(array($empid, $value['id'], $value['type'], $value['amount'] , $value['headtype'] ));
									$count =  $query->rowCount();						
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
								
							}
							///////////////IF FINALIZE SALARY CLICKED,THEN A FINAL SALARY WILL SEND TO EMPLOYEE AS A MAIL//////////////
						
							if($sendmailsts)
							{
								$msg="";
								$empmailencode=Utils::getName($empid1,'EmployeeMaster','CompanyEmail',$this->db);
								$empdoj=Utils::dateformatter( Utils::getName($empid1,'EmployeeMaster','DOJ',$this->db));
								$empmail=Utils::decode5t($empmailencode);
								
								if($empmail){
									
									$salmonth=date("M",strtotime($salarymonth));
									$companyname=Utils::getName($orgid,'Organization','Name',$this->db);
									$logo=Utils::getName($orgid,'Organization','Logo',$this->db);
									$companylogo = URL."public/uploads/".$orgid."/".$logo;
									$empname=$emparr[$i]['name'];
									
									$title="$salmonth's Salary has been prepared";
									$msg="<html><p>Hi $empname,</p><p>Your salary for $salmonth has got generated.Please get in touch with HR for any clarifications within 7 days. </p><p>Please note that after 7 days of receiving this mail,no queries will be entertained</p>";
									$msg.='<table border="1" style="width:800px;text-align:left">
									   <tr><td>
										<table width="100%" >
										<tr>
										<td width="33%"><img height="50px" src="'.$companylogo.'"></td>
										  <td width="34%" colspan="2" >
											<h4>'.$companyname.'</h4>
											<h4>Salary for the month of '.$salmonth.'</h4><br>
										  </td>
										  <td width="33%" ></td>
										</tr>
										<tr>
										  <td colspan="4" ></td>
										 </tr>
										 </table >
										 </td></tr>
										 <tr><td>
										<table width="100%" >
										<tr>
										  <th width="15%">Employee Name</th>
										  <td width="35%">'.$emparr[$i]['name'].'</td>
										  <th width="15%">Division</th>
										  <td width="35%">'.$emparr[$i]['empdivision'].'</td>
										</tr>
										<tr>
										  <th>Department</th>
										  <td>'.$emparr[$i]['empdept'].'</td>
										  <th>Designation</th>
										  <td>'.$emparr[$i]['empdesig'].'</td>
										</tr>
										<tr>
										  <th>Grade</th>
										  <td>'.$emparr[$i]['empgrade'].'</td>
										  <th>Date of Joining</th>
										  <td>'.$empdoj.'</td>
										</tr>
										<tr>
										  <th>Gross Salary</th>
										  <td>'.$emparr[$i]['empcurency'].'&nbsp;'.$emparr[$i]['empctc'].'</td>
										  <th>Days Worked</th>
										  <td>'.$emparr[$i]['emppaiddays'].'</td>
										</tr>
										</table>
									</td></tr>
									<tr><td>
										<table width="100%">
										<tr>
										  <th width="25%">Earnings</th>
										  <th width="25%"  style="padding-right:20px">Amount&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										  <th width="25%">Deductions</th>
										  <th width="25%" >Amount&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										</tr>
									</table>
									</td></tr>
									<tr><td>
										<table width="100%" >
										<tr><td width="50%" valign="top">
											<table width="100%" >';
											foreach( $salarychild as $value)
											{
												if($value['amount'] != 0 && $value['additions'] == 1){
													$msg.='<tr >
													<td width="25%">'.$value['headname'].'</td>
													<td width="25%"  style="padding-right:20px">'.$emparr[$i]['empcurency'].'&nbsp;'.$value['amount'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
											  
													</tr>';
												}
											}
										$msg.='</table>
										</td>
										<td width="50%" valign="top">
											<table width="100%" >';
											foreach( $salarychild as $value)
											{
												if($value['amount'] != 0 && $value['additions'] == 0){
													$msg.='<tr >
													<td width="25%">'.$value['headname'].'</td>
													<td width="25%"  style="padding-right:20px">'.$emparr[$i]['empcurency'].'&nbsp;'.$value['amount'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
											  
													</tr>';
												}
											}
										$msg.='</table>
										</td>
										</tr>
										</table>
									</td></tr>
									<tr><td>
										<table width="100%">
										<tr>
										  <th width="25%">Total Earnings</th>
										  <th width="25%"  style="padding-right:20px">'.$emparr[$i]['empcurency'].'&nbsp;'.$emparr[$i]['emptotal'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										  <th width="25%">Total Deductions</th>
										  <th width="25%" >'.$emparr[$i]['empcurency'].'&nbsp;'.$emparr[$i]['empdeduction'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										</tr>
										</table>
									</td></tr>
									<tr><td>
										<table width="100%">
										<tr>
										  <th width="25%"></th>
										  <th width="25%" class="text-right">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										  <th width="25%">Net Pay</th>
										  <th width="25%" class="text-right">'.$emparr[$i]['empcurency'].'&nbsp;'.$emparr[$i]['empnetsalary'].'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
										</tr>
										</table>
									</td></tr>
									
									</table></html>';
									
									//Utils::sendMail($empmail,$empname,$title,$msg);
									if($emparr[$i]['empnetsalary']!=0){
									Utils::sendMail($empmail,$empname,$title,$msg);
									Utils::Trace("Prepare Salary");
								//	echo "<br>";
									Utils::Trace($msg);
							//		Utils::sendMail("pratibha@ubitechsolutions.com",$empname,$title,$msg);
							//		Utils::sendMail("pragati@ubitechsolutions.com",$empname,$title,$msg);
									}
									
								}
								//echo $msg."<br>";	
							}
						   $status =true;
						   $successMsg = "Salary saved successfully";
						   if($sendmailsts)
							    $successMsg .= " and mail has been sent to employees";
																
						}
						
						
					}
				}
				
				$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and (DOL='0000-00-00' or DOL>LAST_DAY('$salarymonth')) and DOJ<=LAST_DAY('$salarymonth') and Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$salarymonth') and OrganizationId = ?) and Id NOT IN (SELECT EmployeeId from SalaryMaster where OrganizationId=$orgid and SalaryMonth='$salarymonth' and (FinalStatus=1 or HoldStatus=1)) ";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $orgid));
				$count =  $query->rowCount();
				if($count==0){
					 $sql = "select * from SalaryGenerateMonth where SalaryMonth=? and OrganizationId=?";
					$query = $this->db->prepare($sql);
					$query->execute(array($emparr[0]['empmonthdate'],$orgid));
					if($query->rowCount()==0)
					{
						$sql1 = "INSERT INTO SalaryGenerateMonth (SalaryMonth, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) values(?,?,?,?,?,?,?)";		
						$query1 = $this->db->prepare($sql1);			
						try{						
							$query1->execute(array($emparr[0]['empmonthdate'], $orgid, $mdate, $mid, $mdate, $mid, $mid ));
							$count =  $query1->rowCount();	
							if($count==1)
							{
								$status =true;
								$successMsg=SALARYMASTER_MODULE_CREATION_SUCCESS;
							}							
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					} 
					
				}
				
				if($finalsts==1){
					/* $sql = "select * from SalaryGenerateMonth where SalaryMonth=? and OrganizationId=?";
					$query = $this->db->prepare($sql);
					$query->execute(array($emparr[0]['empmonthdate'],$orgid));
					if($query->rowCount()==0)
					{
						$sql1 = "INSERT INTO SalaryGenerateMonth (SalaryMonth, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) values(?,?,?,?,?,?,?)";		
						$query1 = $this->db->prepare($sql1);			
						try{						
							$query1->execute(array($emparr[0]['empmonthdate'], $orgid, $mdate, $mid, $mdate, $mid, $mid ));
							$count =  $query1->rowCount();	
							if($count==1)
							{
								$status =true;
								$successMsg=SALARYMASTER_MODULE_CREATION_SUCCESS;
							}							
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					} */
					
				}
			}else{
				$status =false;
				$errorMsg="Fiscal year not found for selected month";
			}
		//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
			$this->db->commit(); 
				 
			}catch(PDOException $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			}catch(Exception $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			} 
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }


	public function SaveBulkLTA($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$count1=0;
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		///////////////  TRANSACTION BEGINS HERE ///////////////////////////////
		$this->db->beginTransaction();		
		try{	
			$arr = json_decode($request[2] , true);
			$fiscalid = Utils::getFiscalId($arr[0]['empmonthdate'], $this->db);
			
			if($fiscalid!=0)
			{
				for($i=0; $i<count($arr); $i++)
				{
					try{
					
						$sql="UPDATE EmployeeMaster set AirTicket=?,TicketClass=?,OnceIn=?, LastTicketAmt=?, IATAFare=? ,TravelInstruction=?, NearestAirport=? ,FamilyDetail=? where Id =?";
						$query=$this->db->prepare($sql);
						$query->execute(array($arr[$i]['airticket'],$arr[$i]['ticketclass'],$arr[$i]['oncein'],$arr[$i]['ticketamt'],$arr[$i]['iatafare'],$arr[$i]['instructions'],$arr[$i]['nearestairport'],$arr[$i]['familydetails'],$arr[$i]['id']));
						$count1+=$query->rowCount();
						
						$salaryid=$this->getSalaryId($arr[$i]['id'],$arr[$i]['empmonthdate']);
						if($salaryid!=0)
						{
							$sql2 = "UPDATE SalaryChild set HeadAmount=? where SalaryId=? and HeadId=9 and HeadType=2";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array($arr[$i]['iatafare'] , $salaryid));
						}
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
					
				}
			}else{
				$status =false;
				$errorMsg="Fiscal year not found for selected month";
			}
			
			if($count1>0)
			{
				//$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$msg="A Salary has been generated ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Salary", $msg, $orgid));
				$status=true;
				$successMsg="LTA saved successfully";
			}else{
				$status =false;
				$errorMsg=SALARYMASTER_MODULE_CREATION_FAILED;
			}
		//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
			$this->db->commit(); 
				 
			}catch(PDOException $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			}catch(Exception $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			} 
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
    /**
     * Deletes a specific SALARYMASTER
     * @param  $did contains SALARYMASTER id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$mid= $_SESSION['ubihrm_user_id'];
			$sql1 = "DELETE FROM SalaryChild WHERE SalaryId = :id ";		
			try{
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $did));
				//$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			$sql = "DELETE FROM SalaryMaster WHERE Id = :id ";		
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
				$empid=Utils::getName($did,'EmployeeLeave','EmployeeId',$this->db);
                $empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="A salary  has been deleted $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Salary", $msg, $orgid));
			   $status =true;
			   $successMsg = SALARYMASTER_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=SALARYMASTER_MODULE_DELETE_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id, $tablename, $column='Name')
	{
		$name ="";
		$sql = "SELECT $column FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$column;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getsalarysettings($orgid)
	{
		$date=01;
		try{
			$sql1 = "SELECT SettingId, ExecutionValue FROM SettingMaster sm, SettingChild sc where sm.Id=sc.SettingId and PageType=4 and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid));
			while($row1 = $query1->fetch())
			{
				$date=$row1->ExecutionValue	;	
			}
		}catch(Exception $e) {
			
		}		
		return $date;
	}
	
	public function getCustomName($id, $tablename, $column, $columnalias)
	{
		$name ="";
		$sql = "SELECT $column FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$columnalias;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'SalaryMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','EmployeeId', 'SalaryMonth', 'EmployeeCTC','PaidDays', 'BankName', 'BankAccountNo','agent_id',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$month = $this->getCurrentSalaryMonth();
		$salarygenerateddate = date('Y-m-d',strtotime($this->getCurrentSalaryGenerateDate($month)));
		$extenddate=date('Y-m-d',strtotime("+3 days ".date($salarygenerateddate)));
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			//and FinalSettlementSts=0
		if($sts==1 || $hrsts==1){
			//$sWhere = " WHERE  OrganizationId= $orgid   and SalaryMonth='$month' and CURDATE() between '$salarygenerateddate' and '$extenddate'";
			$sWhere = " WHERE  OrganizationId= $orgid   and SalaryMonth='$month' and HoldStatus=0 and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
			$ids =Utils::getReportingIds($userid, $this->db);
			//$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid)   and SalaryMonth='$month' and CURDATE() between '$salarygenerateddate' and '$extenddate'";
			$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) )   and SalaryMonth='$month' and HoldStatus=0";
		}	
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( Select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}if($i==0){
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
				
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete="";
					
					
					/*if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalary/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					if(date($this->getEmployeeSalaryMonth($aRow->EmployeeId))== date($aRow->SalaryMonth)){
						$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
					}else{
						$row[] ='<a href="'.URL.'salary/viewsalary/'.Utils::encode5t($aRow->Id).'/1"><i class="fa fa-eye"></i></a>'.'&nbsp;&nbsp;|&nbsp;&nbsp;'.$delete;
					}*/
					//$row[] ="";
					if($sts==1 || $hrsts==1){
						$row[] = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalary/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
						
						//$row[] = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalary/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$row[] ="";
						//$row[] = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalary/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
					
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster","EmployeeCode",$this->db);
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					
					//$row[] = '<a href="'.URL.'salary/viewsalary/'.Utils::encode5t($aRow->Id).'/1">'.$this->getCustomName($aRow->{$aColumns[$i]}, "EmployeeMaster", " concat(FirstName,' ',LastName) as Name" ,'Name').'</a>';
				
					$row[] = $this->getCustomName($aRow->{$aColumns[$i]}, "EmployeeMaster", " concat(FirstName,' ',LastName) as Name" ,'Name');
				}
				elseif($aColumns[$i]=="EmployeeCTC" )
				{
					$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
					$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="SalaryMonth"){
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="BankAccountNo"){
					$row[] = Utils::decode5t($aRow->{$aColumns[$i]});
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	public function getPastSalaryDataTable($editper, $deleteper)
	{
		$sTable = 'SalaryMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'SalaryMonth', 'EmployeeCTC', 'PaidDays', 'BankName', 'BankAccountNo', 'agent_id', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$whr="";
		$month = $this->getCurrentSalaryMonth();
		$salarygenerateddate = date('Y-m-d',strtotime($this->getCurrentSalaryGenerateDate($month)));
		$extenddate=date('Y-m-d',strtotime("+2 days ".date($salarygenerateddate)));
		if( date('Y-m-d') <= $extenddate)
		{
			//$whr="and SalaryMonth<>'$month' ";
		}
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			//and FinalSettlementSts=0
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid   and SalaryMonth in (SELECT SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = $orgid) and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) $whr" ;//and SalaryMonth<>'$month'";
		}
		else{
			$ids =Utils::getReportingIds($userid, $this->db);
			$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)) and SalaryMonth in (SELECT SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = $orgid)  $whr";// SalaryMonth='$month' ";
		}	
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( Select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				if($i==1){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}elseif($i==0){
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete="";
					/*if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalary/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					if(date($this->getEmployeeSalaryMonth($aRow->EmployeeId))== date($aRow->SalaryMonth)){
						$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
					}else{
						$row[] ='<a href="'.URL.'salary/viewsalary/'.Utils::encode5t($aRow->Id).'/1"><i class="fa fa-eye"></i></a>'.'&nbsp;&nbsp;|&nbsp;&nbsp;'.$delete;
						
					}*/
					
					$row[] ='<a href="'.URL.'salary/viewsalary/'.Utils::encode5t($aRow->Id).'/1" rel="tooltip"  title="View Salary"><i class="fa fa-eye"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href="'.URL.'salary/viewpayslip/'.Utils::encode5t($aRow->Id).'/1" rel="tooltip"  title="Print Payslip" target="_blank"><i class="fa fa-print"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href="'.URL.'salary/viewsalarycertificate/'.Utils::encode5t($aRow->Id).'/1" rel="tooltip"  title="Issue Salary Certificate" target="_blank"><i class="fa fa-file-text-o"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href="'.URL.'salary/viewsalarytransfercertificate/'.Utils::encode5t($aRow->Id).'/1" rel="tooltip"  title="Issue Salary Transfer Letter" target="_blank"><i class="fa fa-file-o"></i></a>';

				}else if($aColumns[$i]=="EmployeeId")
				{
					
					$row[] = '<a href="'.URL.'salary/viewsalary/'.Utils::encode5t($aRow->Id).'/1">'.$this->getCustomName($aRow->{$aColumns[$i]}, "EmployeeMaster", " concat(FirstName,' ',LastName) as Name" ,'Name').'</a>';
				
					//$row[] = $this->getCustomName($aRow->{$aColumns[$i]}, "EmployeeMaster", " concat(FirstName,' ',LastName) as Name" ,'Name');
				}
				elseif($aColumns[$i]=="EmployeeCTC" )
				{
					$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
					$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="SalaryMonth"){
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="BankAccountNo"){
					$row[] = Utils::decode5t($aRow->{$aColumns[$i]});
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getHoldSalaryDataTable($editper, $deleteper)
	{
		$sTable = 'SalaryMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'SalaryMonth','EmployeeCTC', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$whr="";
		
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			//and FinalSettlementSts=0
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid  and HoldStatus=1 and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) $whr" ;//and SalaryMonth<>'$month'";
		}
		else{
			$ids =Utils::getReportingIds($userid, $this->db);
			$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) ) and HoldStatus=1  $whr";// SalaryMonth='$month' ";
		}	
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( Select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				if($i==1){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}elseif($i==0){
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete="";
					/*if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalary/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					if(date($this->getEmployeeSalaryMonth($aRow->EmployeeId))== date($aRow->SalaryMonth)){
						$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
					}else{
						$row[] ='<a href="'.URL.'salary/viewsalary/'.Utils::encode5t($aRow->Id).'/1"><i class="fa fa-eye"></i></a>'.'&nbsp;&nbsp;|&nbsp;&nbsp;'.$delete;
						
					}*/
					
					$row[] ='<a href="'.URL.'salary/editsalary/'.Utils::encode5t($aRow->Id).'/5" rel="tooltip"  title="Release Salary"><i class="fa fa-chevron-circle-right "></i></a>';

				}else if($aColumns[$i]=="EmployeeId")
				{
					
					$row[] = $this->getCustomName($aRow->{$aColumns[$i]}, "EmployeeMaster", " concat(FirstName,' ',LastName) as Name" ,'Name');
				
					//$row[] = $this->getCustomName($aRow->{$aColumns[$i]}, "EmployeeMaster", " concat(FirstName,' ',LastName) as Name" ,'Name');
				}
				elseif($aColumns[$i]=="EmployeeCTC" )
				{
					// $amt=$this->getHoldAmount($aRow->EmployeeCTC,$aRow->SalaryMonth);
					// if($amt==0)
						$amt=$aRow->EmployeeCTC;
					$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
					$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
					$row[] = Utils::numberformatter($amt,$divcur);
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="SalaryMonth"){
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="BankAccountNo"){
					$row[] = Utils::decode5t($aRow->{$aColumns[$i]});
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getFinalSalaryDataTable($editper, $deleteper)
	{
		$sTable = 'SalaryMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'SalaryMonth', 'EmployeeCTC','PaidDays', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
			$ids =Utils::getReportingIds($userid, $this->db);
			$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) ) ";
		}	
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				if($i==1){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalary/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}else if($aColumns[$i]=="EmployeeId")
				{
					
					$row[] = '<a href="'.URL.'salary/viewsalary/'.Utils::encode5t($aRow->Id).'/1">'.$this->getCustomName($aRow->{$aColumns[$i]}, "EmployeeMaster", " concat(FirstName,' ',LastName) as Name" ,'Name').'</a>';
				
					//$row[] = $this->getCustomName($aRow->{$aColumns[$i]}, "EmployeeMaster", " concat(FirstName,' ',LastName) as Name" ,'Name');
				}
				elseif($aColumns[$i]=="EmployeeCTC" )
				{
					$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
					$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="SalaryMonth"){
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getSalaryMonth($request)
	{
		$result = array();
		$month = "";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT DATE_ADD(salarymonth, INTERVAL 1 Month) as SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = ? order by Id desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['salarymonth'] = Utils::dateformatter($row->SalaryMonth);	
				$res['salarymonth1'] = $row->SalaryMonth;	
				$month = $row->SalaryMonth;					
				$data[] = $res;
			}
        }else{
			$month=date('Y-m-01');
			$month=date('Y-m-01',strtotime("- 1 month".date("Y-m-d")));
			$res['salarymonth'] = Utils::dateformatter($month);	
			$res['salarymonth1'] = $month;	
			$sql = "SELECT StartDate FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts=1 order by Id desc limit 1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				$res = array();
				$res['salarymonth'] = Utils::dateformatter($row->StartDate);	
				$res['salarymonth1'] = $row->StartDate;	
				$month = $row->StartDate;						
				$data[] = $res;
			}
			
			$status=true;
			$errorMsg="No Record found";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		//return $result;
		return $month;
	}
	
	public function getLTA($id, $month)
	{
		$result =0;
		$sql = "SELECT HeadAmount FROM SalaryMaster sm, SalaryChild sc WHERE sm.Id=sc.SalaryId and EmployeeId = ? and (SalaryMonth  BETWEEN DATE_SUB(CURDATE(), INTERVAL $month MONTH) AND CURDATE()) and sc.Headid=9 and sc.HeadType=2 and HeadAmount>0";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			if($query->rowCount()>0)
			{
				$result =false;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	
	public function getLeaveSalary($id, $month,$onedaysal)
	{
		$result =0;
		
		$sql = "SELECT ResetLeave FROM LeaveHistory where EmployeeId=? and FiscalId=? and LeaveSts=1 and ResetLeave <>0 and month(EncashDate)=month('$month')";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id,$_SESSION['ubihrm_fiscalid'] ));
			if($row=$query->fetch())
			{
				$leave =$row->ResetLeave;
				$result=round($leave*$onedaysal);
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	
	public function getHoldAmount($amt, $month)
	{
		$result =0;
		$curmonth=$this->getCurrentSalaryMonth();
		
		$d1 = $month;
		$d2 = $curmonth;
		$months = round(abs((strtotime($d1) - strtotime($d2))/(60*60*24*30)));
		$result = $months*$amt;
		
		return $result;
	}
	public function getCurrentSalaryMonthold() ///commented on 23 april 2018
	{
		$month= date("Y-m-01");
		$orgid = $_SESSION['ubihrm_org_id'];
		 $sql = "SELECT SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = ? order by Id desc limit 1";
        
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$month = $row->SalaryMonth;
			}
        }
		
		return $month;
	}
	
	public function getCurrentSalaryMonth() ////commented on 23 april 2018
	{
		$month= date("Y-m-01");
		$orgid = $_SESSION['ubihrm_org_id'];
		 $sql = "SELECT SalaryMonth FROM SalaryMaster WHERE OrganizationId = ? and FinalStatus=1 order by Id desc limit 1";
        
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$month = $row->SalaryMonth;
			}
        }
		
		return $month;
	}
	public function getCurrentSalaryGenerateDate($month)
	{
		//$month= date("Y-m-d");
		$orgid = $_SESSION['ubihrm_org_id'];
		
        $sql = "SELECT CreatedDate FROM SalaryGenerateMonth WHERE OrganizationId = ?  and SalaryMonth=? limit 1";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array( $orgid ,$month));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$month = $row->CreatedDate;
			}
        }
		
		return $month;
	}
	public function getFinalSalaryId($empid)
	{
		$result =0;
		$sql = "SELECT Id FROM SalaryMaster  WHERE EmployeeId = ? and FinalSettlementSts=1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid ));
			while($row = $query->fetch())
			{
				$result =$row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	public function getSalaryId($empid,$month)
	{
		$result =0;
		$sql = "SELECT Id FROM SalaryMaster  WHERE EmployeeId = ? and SalaryMonth=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid ,$month));
			while($row = $query->fetch())
			{
				$result =$row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	public function getEmployeeIncentive($empid, $month)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$result =0;
		$sql = "SELECT IncentiveAmount FROM EmployeeIncentive WHERE OrganizationId=? and EmployeeId = ? and ApplyDate=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid, $empid, $month));
			while($row = $query->fetch())
			{
				$result =$result+$row->IncentiveAmount;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	public function getShifTotalHour($shiftid)
	{
		$name =0;
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$sql = "SElect Id, Name, HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour , MINUTE(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn),TIMEDIFF(TimeOutBreak, TimeInBreak))) as totalmin,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? and Id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$shiftid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					if($row->totaltime < 0){
						$name =24 - $row->totalhour;
					}else{
					//$totalmin = ($row->totalmin/60)*100;
						$name = $row->totalhour;//.".".$totalmin;
					}
				}
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	///// FIND OUT THE OVERTIME AVAILABLE FOR THE EMPLOYEE ////	
	/*public function getEmployeeOvertime($empid, $date, $lastdate, $empsts,$shiftid)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$hourlyrate=0;
		$ctc=Utils::getName($empid,'EmployeeMaster','EmployeeCTC',$this->db);
		$shifthour=$this->getShifTotalHour($shiftid);
		if($shifthour>0){
			$hourlyrate = round((($ctc*12)/365)/$shifthour);
		}else{
			$hourlyrate=0;
		}
		$overtime=0;$weekoff=0; $holiday=0; $weekdays=0;
		$sql1 = "SELECT AttendanceStatus, hour(sum(Overtime)) as overtime FROM AttendanceMaster WHERE OrganizationId = ? and EmployeeId=? and AttendanceStatus NOT IN (2,6) AND (AttendanceDate BETWEEN '$date' AND '$lastdate') group by AttendanceStatus";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid));
		while($row1 = $query1->fetch())
		{
			if($row1->AttendanceStatus==3)
				$weekoff=$row1->overtime;
			elseif($row1->AttendanceStatus==5)
				$holiday=$row1->overtime;
			else
				$weekdays=$row1->overtime;
		}
				
////////////////   FIND OUT THE OVERTIME PAYMENT AVAILABLE FOR THE ORGANIZATION /////////////////////////////				
		$sql1 = "SELECT SettingId, ExecutionValue FROM SettingMaster sm, SettingChild sc where sm.Id=sc.SettingId and PageType=2 and OrganizationId=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid));
		while($row1 = $query1->fetch())
		{
			if($row1->SettingId==4)
				$overtime += $weekoff*$row1->ExecutionValue*$hourlyrate;
			elseif($row1->SettingId==5)
				$overtime += $holiday*$row1->ExecutionValue*$hourlyrate;
			else
				$overtime += $weekdays*$row1->ExecutionValue*$hourlyrate;
		}
		return $overtime;
	}*/
	public function getEmployeeOvertime($empid, $month)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$overtime=0;
		$sql1 = "SELECT OvertimeAmount FROM EmployeeOvertime where OrganizationId=? and EmployeeId=? and ApplyDate between '$month' and LAST_DAY('$month')";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid,$empid));
		while($row1 = $query1->fetch())
		{
			$overtime+=$row1->OvertimeAmount;
		}
		
		return $overtime;
	}
	/////////////////find out employee's reimbursement////////
	public function getEmployeeCliams($empid, $month)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$overtime=0;
		$sql1 = "SELECT TotalAmt FROM ClaimsMaster where OrganizationId=? and EmployeeId=? and month(ApplyMonth)=month('$month')";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid,$empid));
		while($row1 = $query1->fetch())
		{
			$overtime+=$row1->TotalAmt;
		}
		
		return $overtime;
	}
	
	/////FIND OUT THE LEAVE DEDUCTION AVAILABLE             //////////
	////salarysts  = 1 for final settlement and 2 for normal salary  /////////
	public function getEmployeeLeave($empid, $date, $lastdate, $onedaysal, $salarysts)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$leavededuction=0;			
		$sql1 = "SELECT Id FROM EmployeeLeave WHERE OrganizationId = ? and EmployeeId=? and LeaveStatus=2 AND (LeaveFrom BETWEEN '$date' AND '$lastdate') AND (LeaveTo BETWEEN '$date' AND '$lastdate')";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid));
		while($row1 = $query1->fetch())
		{
				//$leavededuction += $row1->leavecount;
			$sql2 = "SELECT * FROM EmployeeLeaveChild WHERE  EmployeeLeaveId=? And PaySts <> 0 AND (LeaveDay BETWEEN '$date' AND '$lastdate')";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $row1->Id));
			while($row2 = $query2->fetch())	
			{
				$leavededuction += ($onedaysal/$row2->PaySts);
			}
		}

		return $leavededuction;
	}
	
	public function getEmployeeLeaveSalary($empid, $lastdate, $onedaysal)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$leavesal=0;	
		$fiscalid = Utils::getFiscalId($lastdate, $this->db);		
		$sql1 = "SELECT BalanceLeave FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId=? and FiscalId=? ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid,$fiscalid));
		while($row1 = $query1->fetch())
		{
			$leavesal=($row1->BalanceLeave * $onedaysal);
		}

		return $leavesal;
	}
	///// FIND OUT THE SALARY ADVANCE INSTALLMENT DEDUCTION AVAILABLE  ///////
	/////empsts  = 1 for final settlement and 2 for normal salary  ////////
	public function getEmployeeLoanInstallment($empid, $date, $empsts)  
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$salaryadvance_installment=0;
		$sql1 = "SELECT Id, AdvanceAmount, InstallmentAmt FROM SalaryAdvance WHERE OrganizationId = ? and EmployeeId=? and LeaveStatus=2 AND '$date' BETWEEN ApplyMonth AND date_add(ApplyMonth, interval InstallmentAmt month) and LoanSTs=0";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid));
		while($row1 = $query1->fetch())
		{
			$sql2 = "SELECT InstAmount FROM SalaryAdvanceChild WHERE  SalaryAdvanceId=? and InstMonth=?";
			if($empsts==1){
				$sql2 = "SELECT InstAmount FROM SalaryAdvanceChild WHERE  SalaryAdvanceId=? and InstMonth >= ?";
			}
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $row1->Id, $date));
			while($row = $query2->fetch())
			{
				$salaryadvance_installment += $row->InstAmount;
			}
			
		}
		
		return $salaryadvance_installment;
	}
	
		///// FIND OUT THE SALARY ADVANCE INSTALLMENT DEDUCTION AVAILABLE  ///////
	/////empsts  = 1 for final settlement and 2 for normal salary  ////////
	public function getAdvanceLoanInstallment($empid, $date, $empsts)  
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$salaryadvance_installment=0;
		$sql1 = "SELECT Id, AdvanceAmount, InstallmentAmt FROM SalaryAdvanceLoan WHERE OrganizationId = ? and EmployeeId=? and LeaveStatus=2 AND '$date' BETWEEN ApplyMonth AND date_add(ApplyMonth, interval InstallmentAmt month) and LoanSTs=0";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid));
		while($row1 = $query1->fetch())
		{
			$sql2 = "SELECT InstAmount FROM SalaryAdvanceChildLoan WHERE  SalaryAdvanceId=? and InstMonth=?";
			if($empsts==1){
				$sql2 = "SELECT InstAmount FROM SalaryAdvanceChildLoan WHERE  SalaryAdvanceId=? and InstMonth >= ?";
			}
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $row1->Id, $date));
			while($row = $query2->fetch())
			{
				$salaryadvance_installment += $row->InstAmount;
			}
			
		}
		
		return $salaryadvance_installment;
	}
	public function getAllChecklist($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();$severandata = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$severanid = Utils::decode5t($request[2]);	// SEVERANCE ID
		
		$sql = "SELECT * FROM ChecklistMaster WHERE OrganizationId = ? and CategoryId =2 ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (float)$row->Id;
				$res['name'] = $row->Name;
				$res['sts'] = "1";
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=SALARYMASTER_MODULE_GETALL;
		}
		
		$sql = "SELECT * FROM SeveranceMaster WHERE OrganizationId = ? and Id =?";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array( $orgid, $severanid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['empid'] = (float)$row->EmployeeId;
				$res['empname'] = Utils::getEmployeeName($row->EmployeeId, $this->db);
				$res['lastdate'] = ($row->EffectDate=="0000-00-00")?"":Utils::dateformatter($row->EffectDate);
				$res['sts'] = $row->EmployeeStatus;
				$severandata[] = $res;
			}
        }else{
			$status=true;
			$successMsg=SALARYMASTER_MODULE_GETALL;
		}
		$result["severandata"] =$severandata;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getFinalSettlementDataTable()
	{
		$sTable = 'SeveranceMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'EmployeeStatus', 'SeveranceDate', 'EffectDate', 'FinalSts', 'Id');
		$mdate = date("Y-m-d");
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			///$sWhere = "WHERE OrganizationId= $orgid and EmployeeStatus<>3 ";
			///client wants absconded employees also 
			$sWhere = "WHERE OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
		//$sWhere = " WHERE  OrganizationId= $orgid and EmployeeStatus<>3 AND (EmployeeId in (SELECT Id FROM EmployeeMaster where ReportingTo=$userid) OR EmployeeId =$userid) ";
		$sWhere = " WHERE  OrganizationId= $orgid AND (EmployeeId in (SELECT Id FROM EmployeeMaster where ReportingTo=$userid and Is_Delete=0 ) OR EmployeeId =$userid) ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					
					if($aRow->FinalSts==0){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/addfinalsettlement/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$salaryid = $this->getFinalSalaryId($aRow->EmployeeId);
						$edit = '<a href="'.URL.'salary/viewpayslip/'.Utils::encode5t($salaryid).'/1" rel="tooltip"  title="Print Payslip" target="_blank"><i class="fa fa-print"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;';
						$edit .= '<a href="'.URL.'salary/viewsalary/'.Utils::encode5t($salaryid).'/1" rel="tooltip"  title="View Salary"><i class="fa fa-eye"></i></a>';
					}					
					$row[] =$edit;
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db);//'<a rel="tooltip" title="View" href="'.URL.'employee/viewseverance/'.Utils::encode5t($aRow->Id).'/1">'.Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db) .'</a>';
					
				}
				else if($aColumns[$i]=="EmployeeStatus")
				{
					$row[] = Utils::getEmployeeStatus($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'EmployeeMaster','FirstName',$this->db);
					
				}
				else if($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate" || $aColumns[$i]=="EffectDate" || $aColumns[$i]=="SeveranceDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getFinalSettlementHistoryData()
	{
		$sTable = 'FinalSettlementHistory';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'TotalAmount', 'PaidAmount', 'BalanceAmount');
		$mdate = date("Y-m-d");
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
			$sWhere = " WHERE  OrganizationId= $orgid AND (EmployeeId in (SELECT Id FROM EmployeeMaster where ReportingTo=$userid and Is_Delete=0 ) OR EmployeeId =$userid) ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="EmployeeId")
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db);//'<a rel="tooltip" title="View" href="'.URL.'employee/viewseverance/'.Utils::encode5t($aRow->Id).'/1">'.Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db) .'</a>';
					
				}
				else if($aColumns[$i]=="TotalAmount" || $aColumns[$i]=="PaidAmount" || $aColumns[$i]=="BalanceAmount" )
				{
					$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
					$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
					
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getSalarytrackDataTable()
	{
		$sTable = 'EmployeeMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$roleid = $_SESSION['ubihrm_user_roleid'];
		$aColumns = array('EmployeeCode', 'FirstName','ReportingTo', 'Division', 'Department','Designation', 'Nationality', 'DOJ', 'EmployeeCTC', 'Grade', 'EmployeeStatus', 'Id');
		
		//$roleid = $this->getRoleIds($roleid); 'CreatedById', 'CreatedDate', 'LastModifiedById', 'LastModifiedDate',
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and Is_Delete=0";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " WHERE (Id in ($ids) AND OrganizationId= $orgid and Is_Delete=0 ) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="FirstName"){
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR  MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR  LastName LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		$flg=false;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				
				if($aColumns[$i]=="DOL"){
					$flg=true;
					$sWhere .= $aColumns[$i]."  ".($_GET['sSearch_'.$i])." '0000-00-00' ";
				}else{
					$sWhere .= $aColumns[$i]." = '".($_GET['sSearch_'.$i])."' ";
				}
			}
		}
		if(!$flg){
			$sWhere .= " and (DOL='0000-00-00' or DOL>curdate())";
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					
					$edit = '<a rel="tooltip" title="View Salary" href="'.URL.'salary/viewsalarytrack/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-eye"></i></a>';
					
						
					$row[] =$edit;
				}
				else if($aColumns[$i]=="EmployeeCode")
				{
					$row[] = $aRow->{$aColumns[$i]};
					
				}
				elseif($aColumns[$i]=="EmployeeCTC"){
					
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);	
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="DOB" || $aColumns[$i]=="DOC" || $aColumns[$i]=="DOJ" || $aColumns[$i]=="DOL"){											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Division" || $aColumns[$i]=="Department" || $aColumns[$i]=="Designation" || $aColumns[$i]=="Grade" || $aColumns[$i]=="Shift" || $aColumns[$i]=="Nationality" || $aColumns[$i]=="Visa" || $aColumns[$i]=="Location"){
											
					$row[] =Utils::getName( $aRow->{$aColumns[$i]}, $aColumns[$i].'Master', "Name", $this->db);
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] =Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ReportingTo" || $aColumns[$i]=="LastModifiedById" || $aColumns[$i]=="CreatedById"){											
					$row[] =Utils::getEmployeeName( $aRow->{$aColumns[$i]},$this->db);
				}
				elseif($aColumns[$i]=="FirstName"){											
					$row[] =Utils::getEmployeeName( $aRow->Id,$this->db);
				}
				elseif($aColumns[$i]=="Gender" || $aColumns[$i]=="MaritalStatus" || $aColumns[$i]=="EmploymentType"){
											
					$row[] =Utils::getOtherName( $aRow->{$aColumns[$i]}, $aColumns[$i],$this->db);
				}
				elseif($aColumns[$i]=="EmployeeStatus"){
											
					$row[] =Utils::getOtherName( $aRow->{$aColumns[$i]}, 'EmployeeStatus', $this->db);
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getEmployeeSalarytrackDetails($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];	//SALARY ID CONTAINS IN ARRAY THIRD VALUE;
		
		$bankname =""; $bankcode =""; $bankacct =0;
        $sql = "SELECT * FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $empid ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row=$query->fetch())
			{
				$res['id'] = $row->Id;
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empcode'] = $row->EmployeeCode;
				$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
				$res['empcurency'] = Utils::getDivisioncurrency($row->Division,$this->db);
				$res['empdept'] = $this->getName($row->Department,'DepartmentMaster');
				$res['empdesig'] = $this->getName($row->Designation,'DesignationMaster');
				$res['empshift'] =$this->getName( $row->Shift,'ShiftMaster');
				$res['empgrade'] = $this->getName($row->Grade,'GradeMaster');
				$res['empctc'] = $row->EmployeeCTC;
				$oldsalary=0;
				$sql2 = "SELECT OldValue FROM JobModificationMaster jm,JobModificationChild jc where EmployeeId=? and OrganizationId=? and jm.Id=jc.JobId and PromotionType in (1,3) and FieldName='EmployeeCTC' Order By CreatedDate desc limit 1";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($empid ,$orgid));
				$heads = array();
				while($r=$query2->fetch()){
					
					$oldsalary=$r->OldValue;	
				}
				$res['oldempctc'] = $oldsalary;
				
				$sql2 = "SELECT HeadId FROM SalaryHistory WHERE EmployeeId = ? and OrganizationId=? Group by HeadId";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($empid ,$orgid));
				$heads = array();
				while($r=$query2->fetch()){
					
					$heads[]=$r->HeadId;	
				}
				
				$headarray=array();
				$sql2 = "SELECT CreatedDate FROM SalaryHistory WHERE EmployeeId = ? and OrganizationId=? Group by CreatedDate desc";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($empid ,$orgid));
				$dates=array();
				while($r=$query2->fetch()){
					
					$dates[] = Utils::dateformatter($r->CreatedDate);
				}
					
					for($i=0;$i<count($heads);$i++)
					{
						$res1 = array();
						$res1['name'] =Utils::getName($heads[$i],'SalaryHead','Name',$this->db);
						$res1['headtype'] =Utils::getName($heads[$i],'SalaryHead','HeadType',$this->db);
						$temp=array();
						$sql1 = "SELECT HeadAmount FROM SalaryHistory WHERE EmployeeId = ? and HeadId=? and OrganizationId=? Order by CreatedDate desc";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($empid,$heads[$i] ,$orgid));
						while($row1=$query1->fetch())
						{
							$temp[]=(float)$row1->HeadAmount;	
						}
						$res1['amount']=$temp;
						$headarray[]=$res1;
					}
				
					for($i=0;$i<count($headarray);$i++)
					{
						if(count($headarray[$i]['amount'])!=count($dates))
						{
							$amountarr=$headarray[$i]['amount'];
							for($y=0;$y<count($dates);$y++)
							{
								if(isset($amountarr[$y]))
								{
									
								}else{
									$amountarr[]=0;
								}
								//echo $amountarr[$y];
							}
							
							$headarray[$i]['amount']=$amountarr;
							
						}
					}
				
				
				//$heads=array_unique($heads,SORT_REGULAR);
				//$res['heads'] = $heads;
				$res['dates'] = $dates;
				$res['salarydetail'] = $headarray;
				
				$data[] = $res;
				
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = SALARYMASTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=SALARYMASTER_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAlerts($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		try{
		$res=array();
		$res['salarymonthdate']=$month = $this->getCurrentSalaryMonth();
		$res['salarymonth']=date("F'y",strtotime(date($month)));
		$res['salarygeneratedate']=$salarygenerateddate = date('Y-m-d',strtotime($this->getCurrentSalaryGenerateDate($month)));
		$res['extenddate']=$extenddate=date('Y-m-d',strtotime("+3 days ".date($salarygenerateddate)));
		$res['nextmonth']=date("F'y",strtotime("+1 months ".date($month)));
		$date1=date_create($extenddate);
		$date2=date_create(date('Y-m-d'));
		$diff=date_diff($date1,$date2);
		$daysleft=$diff->format('%d');
		$res['daysleft']=($daysleft==0)?"for Today":(($daysleft==1)?"until Tommorow":"for ".$daysleft." Days");
		if($extenddate>=date('Y-m-d'))
		$data[]=$res;
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }	
	
	/*
	Save PROVIDENT FUND SETTINGS
	*/
	public function setProvidentFund($request)
    {
			$result = array();
			$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			
			$mdate = date("Y-m-d H:i:s");
			$empid = $request[0];
			$orgid =$request[1];
			$minsalary =$request[2];
			$minemployee = $request[3];
			$pfsts =$request[4];
			$employeepercent =$request[5];
			$employeesalarytype = $request[6];
			$employerpercent = $request[7];
			$employersalarytype = $request[8];
			$rate= $request[9];
			$period= $request[10];
			$salarytype= $request[11];
			$maxamount= $request[12];
			$division= is_array($request[13])?implode(",",$request[13]):$request[13];
			$department= is_array($request[14])?implode(",",$request[14]):$request[14];
			$grade= is_array($request[15])?implode(",",$request[15]):$request[15];
			$employee= is_array($request[18])?implode(",",$request[18]):$request[18];
			$location= is_array($request[19])?implode(",",$request[19]):$request[19];
			$sql = "Select Id from PFSettings where OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			$PFSettingId=0;
			if($row = $query->fetch())
			{
				$PFSettingId = $row->Id;
			}
			if($count==0){
				$sql = "INSERT INTO `PFSettings`(`MinimumSalary`, `MinimumEmployee`, `Period`, `CreatedByid`, `Created Date`, `ModifiedDate`, `ModifiedBy`, `OrganizationId`, `EmployeeRate`, `EmployeeSalaryType`, `EmployerRate`, `EmployerSalaryType`, `Rate`,`PfSts`,`SalaryType`, MaxAmount, DivisionId, DepartmentId, GradeId, MinYear, MaxYear, EmployeeIds, EmpChk,LocationId) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array( $minsalary, $minemployee, $period, $empid, $mdate, $mdate, $empid, $orgid, $employeepercent, $employeesalarytype, $employerpercent, $employersalarytype, $rate, $pfsts, $salarytype, $maxamount , $division,$department, $grade, $request[16], $request[17], $employee, $request[19],$location));
					$count1 =  $query->rowCount();		
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
					Utils::Trace($errorMsg);
				}
			}else{
				$sql = "UPDATE `PFSettings` SET `MinimumSalary`=?, `MinimumEmployee`=?, `Period`=?,  `ModifiedDate`=?, `ModifiedBy`=?, `OrganizationId`=?, `EmployeeRate`=?, `EmployeeSalaryType`=?, `EmployerRate`=?, `EmployerSalaryType`=?, `Rate`=?,`PfSts`=?, `SalaryType`=?, MaxAmount=?, DivisionId=? ,DepartmentId=? ,GradeId=? ,MinYear=? ,MaxYear=? ,EmployeeIds=? ,EmpChk=?,LocationId=?  where `Id`=?";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array( $minsalary, $minemployee, $period,  $mdate, $empid, $orgid, $employeepercent, $employeesalarytype, $employerpercent, $employersalarytype, $rate, $pfsts,$salarytype,  $maxamount ,$division,$department, $grade,$request[16],$request[17],$employee,$location,$request[19],$PFSettingId ));
					$count1 =  $query->rowCount();		
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			if ($count1 == 1) {
			   $status =true;
			   $successMsg = "PF Settings is saved Successfully";
			} else {
			   $status =false;
			   $errorMsg="Error while saving PF Settings";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function setPenalty($request)
    {
			$result = array();
			$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			
			$mdate = date("Y-m-d H:i:s");
			$empid = $request[0];
			$orgid =$request[1];
			$latecomingsts =$request[2];
			$noofdayslate = $request[3];
			$latededuct =$request[4];
			$latesalarytype =$request[5];
			$earlyleaveing = $request[6];
			$noofdayearly = $request[7];
			$earlydeduct = $request[8];
			$earlysalarytype= $request[9];
			$absentunautho= $request[10];
			$absentdeduct= $request[11];
			$absentsalarytype= $request[12];
			$penaltyid= $request[13];
			$empchk= $request[14];
			$division=  is_array($request[15])?implode(",",$request[15]):$request[15];
			$department= is_array($request[16])?implode(",",$request[16]):$request[16];
			$employees= is_array($request[17])?implode(",",$request[17]):$request[17];
			
			$sql = "Select Id from PenaltyMaster where OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			$penaltyid=0;
			if($row = $query->fetch())
			{
				$penaltyid = $row->Id;
			}
			if($count==0){
				$sql = "INSERT INTO `PenaltyMaster`(`LateComing`, `lateInstance`, `lateDeduct`, `lateSalaryType`, `Earlyleaving`, `EarlyInstance`, `EarlyDeduct`, `EarlySalaryType`, `AbsentUnautorized`, `AbsentDeduct`, `AbsentSalaryType`, `OrganizationId`, `CreatedDate`, `EmpChk`,`DivisionId`,`DepartmentId`,`EmployeeIds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array( $latecomingsts, $noofdayslate, $latededuct, $latesalarytype,  $earlyleaveing, $noofdayearly, $earlydeduct, $earlysalarytype, $absentunautho, $absentdeduct, $absentsalarytype, $orgid,$mdate,$empchk,$division,$department,$employees));
					$count1 =  $query->rowCount();		
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
					Utils::Trace($errorMsg);
				}
			}else{
				$sql = "UPDATE `PenaltyMaster` SET `LateComing`=?, `lateInstance`=?, `lateDeduct`=?,  `lateSalaryType`=?, `Earlyleaving`=?, `EarlyInstance`=?, `EarlyDeduct`=?, `EarlySalaryType`=?, `AbsentUnautorized`=?, `AbsentDeduct`=?, `AbsentSalaryType`=?,`LastModifiedDate`=?, `LastModifiedById`=? , `EmpChk`=?,`DivisionId`=?,`DepartmentId`=?,`EmployeeIds`=? where `Id`=?";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array( $latecomingsts, $noofdayslate, $latededuct,  $latesalarytype, $earlyleaveing, $noofdayearly, $earlydeduct, $earlysalarytype, $absentunautho, $absentdeduct, $absentsalarytype,$mdate,$empid,$empchk,$division,$department,$employees,$penaltyid ));
					$count1 =  $query->rowCount();		
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			if ($count1 == 1) {
			   $status =true;
			   $successMsg = "Penalty Settings is saved Successfully";
			} else {
			   $status =false;
			   $errorMsg="Error while saving Penalty Settings";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	/*
       Save ESI SETTINGS
	*/
	public function setESI($request)
    {
			$result = array();
			$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			
			$mdate = date("Y-m-d H:i:s");
			$empid = $request[0];
			$orgid =$request[1];
			$minsalary =$request[2];
			$esists =$request[3];
			$employeepercent =$request[4];
			$employeesalarytype = $request[5];
			$employerpercent = $request[6];
			$employersalarytype = $request[7];
			$salarytype= $request[8];
			$allempsts= ($request[9]=="true") ? 1 : 0;
			$division=  is_array($request[10])?implode(",",$request[10]):$request[10];
			$department= is_array($request[11])?implode(",",$request[11]):$request[11];
			$grade= is_array($request[12])?implode(",",$request[12]):$request[12];
			$employee= is_array($request[15])?implode(",",$request[15]):$request[15];
			$sql = "Select Id from ESISettings where OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			$PFSettingId=0;
			if($row = $query->fetch())
			{
				$PFSettingId = $row->Id;
			}
			if($count==0){
				$sql = "INSERT INTO `ESISettings`(`MinimumSalary`, `CreatedByid`, `Created Date`, `ModifiedDate`, `ModifiedBy`, `OrganizationId`, `EmployeeRate`, `EmployeeSalaryType`, `EmployerRate`, `EmployerSalaryType`,`EsiSts`,`SalaryType`,`AllEmpSts`, DivisionId, DepartmentId, GradeId, MinYear ,MaxYear ,EmployeeIds ,EmpChk) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array( $minsalary, $empid, $mdate, $mdate, $empid, $orgid, $employeepercent, $employeesalarytype, $employerpercent, $employersalarytype, $esists, $salarytype, $allempsts, $division, $department,$grade, $request[13], $request[14], $employee, $request[16] ));
					$count1 =  $query->rowCount();		
					}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
					Utils::Trace($errorMsg);
				}
			}else{
				$sql = "UPDATE `ESISettings` SET `MinimumSalary`=?,  `ModifiedDate`=?, `ModifiedBy`=?, `OrganizationId`=?, `EmployeeRate`=?, `EmployeeSalaryType`=?, `EmployerRate`=?, `EmployerSalaryType`=?,`EsiSts`=?, `SalaryType`=?, `AllEmpSts`=?,DivisionId=? ,DepartmentId=? ,GradeId=? ,MinYear=? ,MaxYear=? ,EmployeeIds=? ,EmpChk=?  where `Id`=?";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array( $minsalary,  $mdate, $empid, $orgid, $employeepercent, $employeesalarytype, $employerpercent, $employersalarytype, $esists,$salarytype,$allempsts,  $division, $department,$grade, $request[13], $request[14], $employee, $request[16] ,$PFSettingId));
					$count1 =  $query->rowCount();		
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			if ($count1 == 1) {
			   $status =true;
			   $successMsg = "ESI Settings is saved Successfully";
			} else {
			   $status =false;
			   $errorMsg="Error while saving ESI Settings";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	/*
       Save TDS SETTINGS
	*/
	public function setTDS($request)
    {
			$result = array();
			$count=0; $count1=0; $countbank=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$tdsarray = json_decode($request[2], true); 
			
			$mdate = date("Y-m-d H:i:s");
			$empid = $request[0];
			$orgid =$request[1];
		
			$sql = "Select Id from TDSRangeSlab where OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			$PFSettingId=0;
			if($row = $query->fetch())
			{
				$PFSettingId = $row->Id;
			}
			if($count!=0){
				$sql = "DELETE from TDSRangeSlab where OrganizationId=?";
					try{
						$query = $this->db->prepare($sql);
						$query->execute(array( $orgid));
						$count1 =  $query->rowCount();		
						
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
					$sql = "DELETE from TDSSurchargeSlab where OrganizationId=?";
					try{
						$query = $this->db->prepare($sql);
						$query->execute(array( $orgid));
						$count1 =  $query->rowCount();		
						
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
			}
			
			for($i=0; $i<count($tdsarray); $i++)
				{	
					if(isset($tdsarray[$i]['minctc']) || isset($tdsarray[$i]['maxctc'])){
						$record = array();
						$record[0] = $empid;
						$record[1] = $tdsarray[$i]['minctc'];
						$record[2] = $tdsarray[$i]['maxctc'];
						$record[3] = $tdsarray[$i]['tax'];
						$record[4] = $orgid;
						$record[5] = $mdate;
						$record[6] = $request[3];
						$record[7] = $tdsarray[$i]['cess'];
						$record[8] = $tdsarray[$i]['surcharge'];
						$record[9] = is_array($request[4])?implode(",",$request[4]):$request[4];
						$record[10] = is_array($request[5])?implode(",",$request[5]):$request[5];
						$record[11] = is_array($request[6])?implode(",",$request[6]):$request[6];
						$record[12] = $request[7];
						$record[13] = $request[8];
						$record[14] = is_array($request[9])?implode(",",$request[9]):$request[9];
						$record[15] = $request[10];
						$sqlbank = "INSERT INTO TDSRangeSlab ( ModifiedBy, MinimumCTC, MaximumCTC,  Tax, OrganizationId,ModifiedDate, TdsSts, Cess, Surcharge , DivisionId, DepartmentId, GradeId, MinYear, MaxYear, EmployeeIds, EmpChk) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
						$querybank = $this->db->prepare($sqlbank);
						$querybank->execute($record);
						$countbank = $querybank->rowcount();
					}
				}
				$surchargearray = json_decode($request[11], true); 
				for($i=0; $i<count($surchargearray); $i++)
				{	
					if(isset($surchargearray[$i]['minctc']) || isset($surchargearray[$i]['maxctc'])){
						$record = array();
						$record[0] = $empid;
						$record[1] = $surchargearray[$i]['minctc'];
						$record[2] = $surchargearray[$i]['maxctc'];
						$record[3] = $orgid;
						$record[4] = $mdate;
						$record[5] = $surchargearray[$i]['surcharge'];
						
						$sqlbank = "INSERT INTO TDSSurchargeSlab ( ModifiedBy, MinimumCTC, MaximumCTC,  OrganizationId,ModifiedDate,Surcharge ) values (?,?,?,?,?,?)";
						$querybank = $this->db->prepare($sqlbank);
						$querybank->execute($record);
						$countbank = $querybank->rowcount();
					}
				}
			
			if ($countbank >= 1 || $count1 >= 1) {
			   $status =true;
			   $successMsg = "TDS Settings is saved Successfully";
			} else {
			   $status =false;
			   $errorMsg="Error while saving TDS Settings";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function setProfessionalTax($request)
    {
			$result = array();
			$count=0; $count1=0; $countbank=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$tdsarray = json_decode($request[2], true); 
			
			$mdate = date("Y-m-d H:i:s");
			$empid = $request[0];
			$orgid =$request[1];
		
			
			$sql = "DELETE from ProfessionalTax where OrganizationId=?";
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid));
				$count1 =  $query->rowCount();		
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
				
		
			for($i=0; $i<count($tdsarray); $i++)
				{	
					if(isset($tdsarray[$i]['minctc']) || isset($tdsarray[$i]['maxctc'])){
						$record = array();
						$record[0] = $empid;
						$record[1] = $tdsarray[$i]['minctc'];
						$record[2] = $tdsarray[$i]['maxctc'];
						$record[3] = $tdsarray[$i]['tax'];
						$record[4] = $orgid;
						$record[5] = $mdate;
						$record[6] = $request[3];
						$record[7] = implode(",",$tdsarray[$i]['months']);
						$record[8] = $tdsarray[$i]['division'];
						
						$sqlbank = "INSERT INTO ProfessionalTax ( LastModifiedById, MinSalary, MaxSalary,  Amount, OrganizationId, LastModifiedDate , PTSts, Months, Division) values (?,?,?,?,?,?,?,?,?)";
						$querybank = $this->db->prepare($sqlbank);
						$querybank->execute($record);
						$countbank = $querybank->rowcount();
					}
				}
				
			
			if ($countbank >= 1) {
			   $status =true;
			   $successMsg = "Professional Tax Settings has been saved";
			} else {
			   $status =false;
			   $errorMsg="Error while saving PT Settings";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getTDS($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;$tdssts=0;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM TDSRangeSlab WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{		
				$res = array();
				$res['minctc'] = $row->MinimumCTC;
				$res['maxctc'] = $row->MaximumCTC;
				$res['tax'] = (int)$row->Tax;
				$res['cess'] = (int)$row->Cess;
				$res['surcharge'] = (int)$row->Surcharge;
				$res['division'] = $row->DivisionId;
				$res['department'] = $row->DepartmentId; 
				$res['grade'] =$row->GradeId;
				$res['empids'] = $row->EmployeeIds;
				$res['minyr'] = $row->MinYear;
				$res['maxyr'] = $row->MaxYear;
				$res['empchk'] = $row->EmpChk;
				$res['location'] = $row->LocationId;
				$tdssts=$row->TdsSts;
				$data[] = $res;
			}
		$surcharge=array();
		$sql = "SELECT * FROM TDSSurchargeSlab WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{		
				$res1 = array();
				$res1['minctc'] = $row->MinimumCTC;
				$res1['maxctc'] = $row->MaximumCTC;
				$res1['surcharge'] = (int)$row->Surcharge;
				
				$surcharge[] = $res1;
			}
			
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
	
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = "ESI Details Fetch Successfull";
        } else {
           $status =false;
		   $errorMsg="No ESI Details found for this organization";
        }
		$result['tdssts']=$tdssts;
		$result["data"] =$data;
		$result["datasurcharge"] =$surcharge;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	public function getProfessionaltax($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;$tdssts=0;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM ProfessionalTax WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{		
				$res = array();
				$res['minctc'] = $row->MinSalary;
				$res['maxctc'] = $row->MaxSalary;
				$res['tax'] = (int)$row->Amount;
				$res['division'] = (int)$row->Division;
				$res['months'] = explode(",",$row->Months);
				
				$tdssts=$row->PTSts;
				$data[] = $res;
			}
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
	
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = "ESI Details Fetch Successfull";
        } else {
           $status =false;
		   $errorMsg="No ESI Details found for this organization";
        }
		$result['tdssts']=$tdssts;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	public function getProvidentFund($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM PFSettings WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			if($row = $query->fetch())
			{		
				$res = array();
				$res['minsalary'] = $row->MinimumSalary;
				$res['minemployee'] = $row->MinimumEmployee;
				$res['period'] = $row->Period;
				$res['employeepercent'] = $row->EmployeeRate;
				$res['employeesalarytype'] = $row->EmployeeSalaryType;
				$res['employerpercent'] = $row->EmployerRate;
				$res['employersalarytype'] = $row->EmployerSalaryType;
				$res['rate'] = $row->Rate;
				$res['pfsts'] = $row->PfSts;
				$res['salarytype'] = $row->SalaryType;
				$res['maxamount'] = $row->MaxAmount;
				$res['division'] = $row->DivisionId;
				$res['department'] = $row->DepartmentId; 
				$res['grade'] =$row->GradeId;
				$res['empids'] = $row->EmployeeIds;
				$res['minyr'] = $row->MinYear;
				$res['maxyr'] = $row->MaxYear;
				$res['empchk'] = $row->EmpChk;
				$res['location'] = $row->LocationId;
				$data[] = $res;				
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = "PF Details Fetch Successfull";
        } else {
           $status =false;
		   $errorMsg="No PF Details found for this organization";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	public function getPenalty()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $_SESSION['ubihrm_user_id'];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM PenaltyMaster WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			if($row = $query->fetch())
			{		
				$res = array();
				$res['penaltyid'] = $row->Id;
				$res['LateComing'] = $row->LateComing;
				$res['lateInstance'] = $row->lateInstance;
				$res['lateDeduct'] = $row->lateDeduct;
				$res['lateSalaryType'] = $row->lateSalaryType;
				$res['Earlyleaving'] = $row->Earlyleaving;
				$res['EarlyInstance'] = $row->EarlyInstance;
				$res['EarlyDeduct'] = $row->EarlyDeduct;
				$res['EarlySalaryType'] = $row->EarlySalaryType;
				$res['AbsentUnautorized'] = $row->AbsentUnautorized;
				$res['AbsentDeduct'] = $row->AbsentDeduct;
				$res['AbsentSalaryType'] = $row->AbsentSalaryType;
				$res['orgid'] = $row->OrganizationId;
				$res['EmpChk'] = $row->EmpChk;
				$res['DivisionId'] = $row->DivisionId;
				$res['DepartmentId'] = $row->DepartmentId;
				$res['EmployeeIds'] = $row->EmployeeIds;
				
				$data[] = $res;				
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = "PF Details Fetch Successfull";
        } else {
           $status =false;
		   $errorMsg="No PF Details found for this organization";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	public function getESI($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM ESISettings WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			if($row = $query->fetch())
			{		
				$res = array();
				$res['minsalary'] = $row->MinimumSalary;
				$res['allempsts'] = ($row->AllEmpSts==1)?true:false;
				$res['employeepercent'] = $row->EmployeeRate;
				$res['employeesalarytype'] = $row->EmployeeSalaryType;
				$res['employerpercent'] = $row->EmployerRate;
				$res['employersalarytype'] = $row->EmployerSalaryType;
				$res['esists'] = $row->EsiSts;
				$res['salarytype'] = $row->SalaryType;
				$res['division'] = $row->DivisionId;
				$res['department'] = $row->DepartmentId; 
				$res['grade'] =$row->GradeId;
				$res['empids'] = $row->EmployeeIds;
				$res['minyr'] = $row->MinYear;
				$res['maxyr'] = $row->MaxYear;
				$res['empchk'] = $row->EmpChk;
				$res['location'] = $row->LocationId;
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = "ESI Details Fetch Successfull";
        } else {
           $status =false;
		   $errorMsg="No ESI Details found for this organization";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	public function getEmployeePF($basic,$ctc,$orgid){
		
		$sql="select * from PFSettings where OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$pf=0;
		$basicsts=0;
		$employeepfrate=0;
		$salary=0;
		if($row=$query->fetch()){
			$basicsts=$row->EmployeeSalaryType;
			if($basicsts==1){
				$salary=$basic;
			}else{
				$salary=$ctc;
			}
			
			$employeepfrate=$row->EmployeeRate;
			$pf=($salary*$employeepfrate)/100;
			if($pf>$row->MaxAmount)
				$pf=$row->MaxAmount;
		}
		
		
		return $pf;
	}
	
	public function getEmployeeESI($basic,$ctc,$orgid){
		
		$sql="select * from ESISettings where OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$esi=0;
		$basicsts=0;
		$employeeesirate=0;
		$salary=0;
		if($row=$query->fetch()){
			$basicsts=$row->EmployeeSalaryType;
			if($basicsts==1){
			$salary=$basic;
		}else{
			$salary=$ctc;
		}
			$employeeesirate=$row->EmployeeRate;
		}
		$esi=($salary*$employeeesirate)/100;
		return $esi;
		
	}
	public function getEmployeeTDS($ctc,$orgid,$taxableamt=0){
			$ctctotal=$ctc*12;
			$sql="select * from TDSRangeSlab where OrganizationId=$orgid and $ctctotal between MinimumCTC and MaximumCTC";
			//Utils::Trace($sql);
			$query = $this->db->prepare($sql);
			$query->execute(array());
			$tax=0;
			$tds=0; $surcharge=0; $cess=0; 
			if($row=$query->fetch()){
				$tax=$row->Tax;
				$cess=$row->Cess;
			}
			
			//////////////////FIND OUT SURCHARGE ACCORDING TO SALARY RANGE////////////// 
			
			$sql="select * from TDSSurchargeSlab where OrganizationId=$orgid and $ctctotal between MinimumCTC and MaximumCTC";
			//Utils::Trace($sql);
			$query = $this->db->prepare($sql);
			$query->execute(array());
			if($row=$query->fetch()){
				$surcharge=$row->Surcharge;
			}
			$incometaxamt=0; $suramt =0; $cessamt =0;
			if($tax!=0){ 
				$incometaxamt = ($taxableamt* $tax)/100;
			}
			if($surcharge!=0){           ///////////// SURCHARGE IS N% FOR INCOME TAX//////////
				$suramt = ($taxableamt * $surcharge)/100;
			}
			$cesstax=$incometaxamt+$suramt;
			if($cess!=0){           ///////////// Education cess: 3% of tax plus surcharge  /////////
				$cessamt = ($cesstax * $cess)/100;
			}
			
			/////////////////////// ONE MONTH TAX///////////////////////////////////////////////////
			
			$tds=$incometaxamt  + $suramt + $cessamt; /////////////MONTHLY
			
			
			return $tds;
		}
	public function getEmployerPF($basic,$ctc,$orgid){
		$sql="select * from PFSettings where OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$pf=0;
		$basicsts=0;
		$employerpfrate=0;
		$salary=0;
		if($row=$query->fetch()){
			$basicsts=$row->EmployerSalaryType;
			if($basicsts==1){
			$salary=$basic;
		}else{
			$salary=$ctc;
		}
		$employerpfrate=$row->EmployerRate;
		}
		$pf=($salary*$employerpfrate)/100;
		return $pf;
	}
	
	public function getPFStatus($totalemp,$basic,$ctc,$empid=0){
		$orgid=$_SESSION['ubihrm_org_id'];
		$div=""; $depart=""; $grade=""; $exp=""; 
		$sql="select *,TIMESTAMPDIFF(YEAR, DOJ, CURDATE()) as curyear, TIMESTAMPDIFF(MONTH, DOJ, CURDATE()) as curmonth from EmployeeMaster where Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($empid));
		while($row = $query->fetch())
		{
			$div=$row->Division;
			$depart=$row->Department;
			$grade=$row->Grade;
			//echo$curyear =((int)$row->curyear < 0)?0:(int)$row->curyear."-". $row->FirstName;
			$curmonth = ((int)$row->curmonth < 0)?0:(int)$row->curmonth;
			$exp=round(($curmonth/12),2);
		}
			
		$divflag=false; $departflag=false; $gradeflag=false; $expflag=false;  $finalflag=false; 
		
		$sql="select * from PFSettings where OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$basicsts=0;
		$minsalary=0;
		$salary=0;
		$minemployee=0;
		$pfsts=0;
		
		if($row=$query->fetch()){
			$basicsts=$row->SalaryType;
			
			if($basicsts==1){
				$salary=$basic;
			}else{
				$salary=$ctc;
			}
			$divarr=($row->DivisionId!=0)?explode(",",$row->DivisionId):0;
			$departarr=($row->DepartmentId!=0)?explode(",",$row->DepartmentId):0;
			$gradearr=($row->GradeId!=0)?explode(",",$row->GradeId):0;
			$emparr=($row->EmployeeIds!=0)?explode(",",$row->EmployeeIds):0;
			
			$empchk=$row->EmpChk; 
			if( $empchk==1 ) ////////////for ALL/////////
			{
				//echo $exp."exp".$row->MinYear ."min".$row->MaxYear."max";
				if( $divarr==0)
					$divflag=true;
				elseif( in_array($div, $divarr ) )
					$divflag=true;
				if(  $departarr ==0 ) 
					$departflag=true;	
				elseif( in_array($depart, $departarr ) )
					$departflag=true;
				if( $gradearr ==0) 
					$gradeflag=true;	
				elseif( in_array($grade, $gradearr ) )
					$gradeflag=true;	
				if($exp>=$row->MinYear && $exp<=$row->MaxYear)
					$expflag=true;
				elseif( $row->MinYear== "" || $row->MinYear==0 ||  $row->MaxYear== "" || $row->MaxYear==0) 
					$expflag=true;	
				if($divflag && $departflag && $gradeflag && $expflag)	{
					$finalflag=true;
					
				}
				
			}
			else /////////////////FOR SPECIFIC///////////////////
			{
				if( in_array($empid, $emparr ) )
					$finalflag=true;
				elseif( $emparr ==0) 
					$finalflag=true;	
			}
			
			$minsalary=$row->MinimumSalary;
			$minemployee=$row->MinimumEmployee;
			$pfsts=$row->PfSts;
			if($totalemp>=$minemployee and $salary<=$minsalary and $pfsts==1 and $finalflag){
				
				return true;
			}else{
				return false;
			}
				
		}
			//Utils::Trace("total emp ".$totalemp." minemployee ".$minemployee." salary ".$salary." minsalary ".$minsalary." pfsts ".$pfsts);
			return false;
	}
	public function getTDSStatus($orgid,$ctc,$empid=0){
			
			$div=""; $depart=""; $grade=""; $exp=""; 
			$sql="select *,TIMESTAMPDIFF(YEAR, DOJ, CURDATE()) as curyear, TIMESTAMPDIFF(MONTH, DOJ, CURDATE()) as curmonth from EmployeeMaster where Id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($empid));
			while($row = $query->fetch())
			{
				$div=$row->Division;
				$depart=$row->Department;
				$grade=$row->Grade;
				//echo$curyear =((int)$row->curyear < 0)?0:(int)$row->curyear."-". $row->FirstName;
				$curmonth = ((int)$row->curmonth < 0)?0:(int)$row->curmonth;
				$exp=round(($curmonth/12),2);
			}
				
			$divflag=false; $departflag=false; $gradeflag=false; $expflag=false;  $finalflag=false; 
			$anuualctc=round($ctc*12,2);
			
			$sql="select * from TDSRangeSlab where OrganizationId=? and ? between MinimumCTC and MaximumCTC";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$anuualctc));
			$tdssts=0;
			if($row=$query->fetch()){
				
				$tdssts=$row->TdsSts;
				$divarr=($row->DivisionId!=0)?explode(",",$row->DivisionId):0;
				$departarr=($row->DepartmentId!=0)?explode(",",$row->DepartmentId):0;
				$gradearr=($row->GradeId!=0)?explode(",",$row->GradeId):0;
				$emparr=($row->EmployeeIds!=0)?explode(",",$row->EmployeeIds):0;
				
				$empchk=$row->EmpChk; 
				if( $empchk==1 ) ////////////for ALL/////////
				{
					//echo $exp."exp".$row->MinYear ."min".$row->MaxYear."max";
					if( $divarr==0)
						$divflag=true;
					elseif( in_array($div, $divarr ) )
						$divflag=true;
					if(  $departarr ==0 ) 
						$departflag=true;	
					elseif( in_array($depart, $departarr ) )
						$departflag=true;
					if( $gradearr ==0) 
						$gradeflag=true;	
					elseif( in_array($grade, $gradearr ) )
						$gradeflag=true;	
					if($exp>=$row->MinYear && $exp<=$row->MaxYear)
						$expflag=true;
					elseif( $row->MinYear== "" || $row->MinYear==0 ||  $row->MaxYear== "" || $row->MaxYear==0) 
						$expflag=true;	
					if($divflag && $departflag && $gradeflag && $expflag)	{
						$finalflag=true;
						
					}
					
				}
				else /////////////////FOR SPECIFIC///////////////////
				{
					if( in_array($empid, $emparr ) )
						$finalflag=true;
					elseif( $emparr ==0) 
						$finalflag=true;	
				}
			}
				//Utils::Trace("total emp ".$totalemp." minemployee ".$minemployee." salary ".$salary." minsalary ".$minsalary." pfsts ".$pfsts);
				if($tdssts==1 && $finalflag){
					return true;
				}else{
					return false;
				}
	}
	public function getESIStatus($basic,$ctc,$empid=0){
			$orgid=$_SESSION['ubihrm_org_id'];
			$div=""; $depart=""; $grade=""; $exp="";  $esicondition=false;
			$sql="select *,TIMESTAMPDIFF(YEAR, DOJ, CURDATE()) as curyear, TIMESTAMPDIFF(MONTH, DOJ, CURDATE()) as curmonth from EmployeeMaster where Id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($empid));
			while($row = $query->fetch())
			{
				$div=$row->Division;
				$depart=$row->Department;
				$grade=$row->Grade;
				//echo$curyear =((int)$row->curyear < 0)?0:(int)$row->curyear."-". $row->FirstName;
				$curmonth = ((int)$row->curmonth < 0)?0:(int)$row->curmonth;
				$exp=round(($curmonth/12),2);
			}
				
			$divflag=false; $departflag=false; $gradeflag=false; $expflag=false;  $finalflag=false; 
			$anuualctc=round($ctc*12,2);
			$sql="select * from ESISettings where OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$basicsts=0;
			$minsalary=0;
			$salary=0;
			$esists=0;
			
			if($row=$query->fetch()){
				$basicsts=$row->SalaryType;
				$divarr=($row->DivisionId!=0)?explode(",",$row->DivisionId):0;
				$departarr=($row->DepartmentId!=0)?explode(",",$row->DepartmentId):0;
				$gradearr=($row->GradeId!=0)?explode(",",$row->GradeId):0;
				$emparr=($row->EmployeeIds!=0)?explode(",",$row->EmployeeIds):0;
				$empchk=$row->EmpChk; 
				
				if( $empchk==1 ) ////////////for ALL/////////
				{
					//echo $exp."exp".$row->MinYear ."min".$row->MaxYear."max";
					if( $divarr==0)
						$divflag=true;
					elseif( in_array($div, $divarr ) )
						$divflag=true;
					if(  $departarr ==0 ) 
						$departflag=true;	
					elseif( in_array($depart, $departarr ) )
						$departflag=true;
					if( $gradearr ==0) 
						$gradeflag=true;	
					elseif( in_array($grade, $gradearr ) )
						$gradeflag=true;	
					if($exp>=$row->MinYear && $exp<=$row->MaxYear)
						$expflag=true;
					elseif( $row->MinYear== "" || $row->MinYear==0 ||  $row->MaxYear== "" || $row->MaxYear==0) 
						$expflag=true;	
					if($divflag && $departflag && $gradeflag && $expflag)	{
						$finalflag=true;
					}
				}
				else /////////////////FOR SPECIFIC///////////////////
				{
					
					if(is_array($emparr)){
					if( in_array($empid, $emparr ) )
						$finalflag=true;
					}
					if( $emparr ==0) 
						$finalflag=true;	
				}
				if($basicsts==1){
					$salary=$basic;
				}else{
						$salary=$ctc;
				}
				$minsalary=$row->MinimumSalary;
				$esists=$row->EsiSts;
				$allempsts=$row->AllEmpSts;
				if($salary>=$minsalary)
					$esicondition=true;
				if($allempsts==1)
					$esicondition=true;
			}
			//Utils::Trace("total emp ".$totalemp." minemployee ".$minemployee." salary ".$salary." minsalary ".$minsalary." pfsts ".$pfsts);
			if($esicondition and $esists==1 and $finalflag){
				return true;
			}else{
				return false;
			}
	}
	public function getPreviousTotalPF($empid1,$salarymonth){
			$orgid=$_SESSION['ubihrm_org_id'];
			$sql="select * from ProvidentFundMaster where EmployeeId=? and month(SalaryMonth)=month(DATE_SUB(?,INTERVAL 1 MONTH))";
			$query = $this->db->prepare($sql);
			$query->execute(array($empid1,$salarymonth));
			$count =  $query->rowCount();
			$previoustotal=0;
			if($row=$query->fetch()){
				$previoustotal=$row->Total;
			}
			Utils::Trace("Previous total ". $previoustotal);
			return $previoustotal;
		}
	public function getTotalPF($empid1,$salarymonth){
			$orgid=$_SESSION['ubihrm_org_id'];
			$sql="select * from ProvidentFundMaster where EmployeeId=? and month(SalaryMonth) in (select max(month(SalaryMonth)) from ProvidentFundMaster where SalaryMonth<=?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($empid1,$salarymonth));
			$count =  $query->rowCount();
			$total=0;
			if($row=$query->fetch()){
				$total=$row->Total;
			}
			//Utils::Trace("Previous total ". $total);
			return $total;
		}
	public function getEmployeeProvidentFundDataTable($arr)
	{
		$sTable = 'EmployeeMaster';
		$sIndexColumn = "Id";
		$userid = $arr[0];
		//echo $arr[2];
		$endate =$arr[2];
		//$roleid = $_SESSION['ubihrm_user_roleid'];
		$aColumns = array('EmployeeCode', 'FirstName','Division','Department','Channel','Designation', 'Grade', 'DOJ', 'EmployeeCTC', 'EmployeeCTC','Id');
		
		//$roleid = $this->getRoleIds($roleid);
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		
		$orgid=$arr[1];
		$sts=$_SESSION['ubihrm_user_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid  and Is_Delete=0 and (DOL='0000-00-00' or DOL>curdate())";
		}else{
			$sWhere = " WHERE Id in ($ids) AND OrganizationId= $orgid and (DOL='0000-00-00' or DOL>curdate())and Is_Delete=0 ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="Grade"){
					$sWhere .= "(Grade in (select Id from GradeMaster where Name "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				elseif($aColumns[$i]=="CurrentEmailId"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id" ){	
				
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					$row[] = Utils::numberformatter( $this->getTotalPF( $aRow->Id,$endate),$divcur);
				}
				elseif($aColumns[$i]=="Division" || $aColumns[$i]=="Department" || $aColumns[$i]=="Designation" || $aColumns[$i]=="Grade" || $aColumns[$i]=="Shift" || $aColumns[$i]=="Nationality" || $aColumns[$i]=="Visa" || $aColumns[$i]=="Channel"){
											
					$row[] =Utils::getName( $aRow->{$aColumns[$i]}, $aColumns[$i].'Master', "Name", $this->db);
				}
				elseif($aColumns[$i]=="FirstName"){
											
					$row[] =Utils::getEmployeeName( $aRow->Id, $this->db);
				}
				elseif($aColumns[$i]=="DOJ"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}elseif($aColumns[$i]=="EmployeeCTC" && $i==8){
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					$row[] = Utils::numberformatter(Utils::getEmployeeBasicSalary($aRow->Id, $this->db),$divcur);
					//$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="EmployeeCTC" && $i==9){
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					//$row[] = Utils::numberformatter(Utils::getEmployeeBasicSalary($aRow->Id, $this->db),$divcur);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function days_in_month($month, $year)
	{
		// calculate number of days in a month
		return $month == 2 ? ($year % 4 ? 28 : ($year % 100 ? 29 : ($year % 400 ? 28 : 29))) : (($month - 1) % 7 % 2 ? 30 : 31);
	}
	/* 
   public function salaryPaidDaysSetup()
   {
		
		$count=0; $data= array(); $status=false; $successMsg=""; $errorMsg=""; $result=array();
		
		$orgid = isset($_SESSION['ubicrm_org_id']) ? $_SESSION['ubicrm_org_id']:"0";
		
		$mid = isset($_SESSION['ubicrm_user_id'])  ? $_SESSION['ubicrm_user_id']:"0";
		
		$paydays = isset($_REQUEST['paydays']) ? $_REQUEST['paydays']:"";
		
		$weekoff = isset($_REQUEST['weekoff']) ? $_REQUEST['weekoff']:"";
		
		$holiday = isset($_REQUEST['holiday']) ? $_REQUEST['holiday']:"";
		
		$id		  =	isset($_REQUEST['id']) 	 ?	 $_REQUEST['id']	:"";
        $date     = date('Y-m-d H:i:s');
		
		/* check if usertype is already available*/
	/*	$this->db->select('Id');
		$whereCondition= $array= array('Id'=>$id, 'OrganizationId'=>$orgid);
		$this->db->where($whereCondition);
		$this->db->from('SalaryPaidDays');
		$query =$this->db->get();
		$count = $query->num_rows();
		if($count>=1){
		/*If lead is already there and we are creating it again then it will get update.*/
	/*	$row = $query->row();
		$id = $row->Id;
		$data = $id;
		$data1 = array(
			'PaidDays'=>$paydays,
			'Weekoffs'=>$weekoff,
			'Holidays'=>$holiday,
			'OrganizationId'=>$orgid,
			'LastModifiedDate'=>$date,
			'LastModifiedById'=>$mid
			
		);
		$this->db->where('Id',$id);
		$query=$this->db->update('SalaryPaidDays',$data1);
		if($query){
			$status=true;
			$successMsg="Salary Paid created successfully.";
		}else{
			$status =false;
			$errorMsg="There may be a problem while creating Salary.";
		}
	    }else{
		$data1 = array(
			'PaidDays'=>$paydays,
			'Weekoffs'=>$weekoff,
			'Holidays'=>$holiday,
			'OrganizationId'=>$orgid,
			'LastModifiedDate'=>$date,
			'LastModifiedById'=>$mid
		);
		$query=$this->db->insert('SalaryPaidDays',$data1);
		$data=$this->db->insert_id();
		if($query){
			$status=true;
			$successMsg="Salary Paid created successfully.";
		}else{
			$status =false;
			$errorMsg="There may be a problem while creating Salary.";
		}

	  }
	
		$result['data']= $data;
		$result['status'] =$status;
		$result['successMsg'] = $successMsg;
		$result['errorMsg'] = $errorMsg;
		return $result;
	}  */
	/*public function salaryPaidDaysSetup()
    {
		$count=0; $data= array(); $status=false; $successMsg=""; $errorMsg=""; $result=array();
		
		$orgid = $_SESSION['ubihrm_org_id'];
	 	
		$mid = $_SESSION['ubihrm_user_id'];
		$paydays =	$_POST['paydays'];
		
		$weekoff = $_POST['weekoff'];
		
		$holiday = $_POST['holiday'];
		
        $date     = date('Y-m-d H:i:s');
		
		
		$sql = "INSERT INTO SalaryPaidDays (PaidDays, Weekoffs, Holidays, OrganizationId, LastModifiedById, LastModifiedDate) VALUES (?, ?, ?, ?, ?, ?)";
		$query = $this->db->prepare($sql);			
		
		try
		{						
			$query->execute(array($paydays,$weekoff,$holiday,$orgid,$mid,$date));
			$count =  $query->rowCount();
		}
		catch(Exception $e)
		{
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if($query){
			$status =true;
			$successMsg = "ADDED SUCCESSFULLY";
		}
		else{
			$status =false;
			$errorMsg="There may be a problem while adding";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	} */
	public function salaryPaidDaysSetup($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
			$mdate = date("Y-m-d H:i:s");
			$mid   = $request[0];
			$orgid = $request[1];
			$paydays = $request[2];
			$weekoff = $request[3];
			$holiday =$request[4];
			$date =$request[5];
			
			$sql = "Select Id from SalaryPaidDays where OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			$SalaryPaidDaysId=0;
			if($row = $query->fetch())
			{
				$SalaryPaidDaysId = $row->Id;
			}
			
			if($count==0){
				$sql = "INSERT INTO SalaryPaidDays (PaidDays, Weekoffs, Holidays, OrganizationId, LastModifiedById, LastModifiedDate) VALUES (?, ?, ?, ?, ?, ?)";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array($paydays,$weekoff,$holiday,$orgid,$mid,$date));
					$count1 =  $query->rowCount();		
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
					Utils::Trace($errorMsg);
				}
			}else{
				$sql = "UPDATE `SalaryPaidDays` SET `PaidDays`=?,`Weekoffs`=?,`Holidays`=?,`OrganizationId`=?,`LastModifiedById`=?,`LastModifiedDate`=? WHERE `Id`=?";

				try{
					$query = $this->db->prepare($sql);
					$query->execute(array( $paydays,$weekoff,$holiday,$orgid,$mid,$mdate,$SalaryPaidDaysId ));
					$count1 =  $query->rowCount();		
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			
			if ($count1 == 1) {
			   $status =true;
			   $successMsg = "SalaryPaidDays is saved Successfully";
			} else {
			   $status =false;
			   $errorMsg="Error while saving SalaryPaidDays";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	}
	public function getsalarysetup($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM SalaryPaidDays WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			if($row = $query->fetch())
			{		
				$res = array();
				$res['paydays'] = $row->PaidDays;
				$res['weekoff'] = $row->Weekoffs;
				$res['holiday'] = $row->Holidays;
				$res['OrganizationId'] = $row->OrganizationId;
				$res['LastModifiedById'] = $row->LastModifiedById;
				$res['LastModifiedDate'] = $row->LastModifiedDate;
				$data[] = $res;				
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = "SalaryPaidDays Details Fetch Successfull";
        } else {
           $status =false;
		   $errorMsg="No SalaryPaidDays Details found for this organization";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
}
?>