<?php

/**
 * RootfareModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class RootfareModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM AirportRootFare WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['fromcity'] = $row->FromCityId;
				$res['tocity'] = $row->ToCityId;
				$res['fareamount'] = $row->FareAmount;
				$res['childfare'] = $row->ChildFare;
				$res['infantfare'] = $row->InfantFare;
				$res['tickettype'] = $row->TicketType;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=ROOTFARE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM AirportRootFare WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['fromcity'] = $row->FromCityId;
				$res['tocity'] = $row->ToCityId;
				$res['fromcountry'] = $row->FromCountryId;
				$res['tocountry'] = $row->ToCountryId;
				$res['fareamount'] = $row->FareAmount;
				$res['tickettype'] = $row->TicketType;
				$res['childfare'] = $row->ChildFare;
				$res['infantfare'] = $row->InfantFare;
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = ROOTFARE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=ROOTFARE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	///////////get root fare////////////////////
	
	public function getFare($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		///////////FIND OUT ARRIVAL CITY OF ORGANIZATION////////
		$orgid=$_SESSION['ubihrm_org_id'];
		$fromcity=Utils::getName($orgid,'Organization','City',$this->db);
		
		if($request[1]=="")
		{
			$status=false;
			$errorMsg="Choose Nearest Airport";
			$result["data"] =$data;
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']=$errorMsg;			
			return $result;
		}
		if($request[2]==0)
		{
			$status=false;
			$errorMsg="Choose Class";
			$result["data"] =$data;
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']=$errorMsg;
			return $result;
		}
        $sql = "SELECT * FROM AirportRootFare WHERE FromCityId = ? AND ToCityId = ? AND TicketType = ? and OrganizationId=? order by CreatedDate desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($fromcity , $request[1], $request[2] ,$orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['fareamount'] = $row->FareAmount;
				$res['childfareamount'] = $row->ChildFare;
				$res['infantfareamount'] = $row->InfantFare;
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = ROOTFARE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg="No record Found";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a AirportRootFare (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");		
		$fiscid =  Utils::getFiscalId(date("Y-m-d"), $this->db);
		
		$sql1 = "SELECT * FROM AirportRootFare WHERE Id != ? AND FromCityId = ? and ToCityId =? and TicketType=? and FiscalId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array(Utils::decode5t($request[8]), $request[2], $request[3], $request[7], $fiscid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=ROOTFARE_MODULE_UPDATION_DUPLICATE;
		}else{
			
			$sql = "UPDATE AirportRootFare SET FromCityId=?, ToCityId=?, FromCountryId=?, ToCountryId=?, FareAmount=?, TicketType=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=?, ChildFare=?, InfantFare=? where Id=?";
		
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $request[7], $orgid, $mdate, $mid,  $request[9],  $request[10], Utils::decode5t($request[8])));
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = ROOTFARE_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=ROOTFARE_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a AirportRootFare (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$fiscid =  Utils::getFiscalId(date("Y-m-d"), $this->db);
		if($fiscid>0)
		{
			$sql1 = "SELECT * FROM AirportRootFare WHERE FromCityId = ? and ToCityId =? and TicketType=? and FiscalId=?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $request[2], $request[3], $request[7], $fiscid));
				$count1 =  $query1->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count1>=1)
			{
				$status =false;
				 $errorMsg=ROOTFARE_MODULE_CREATION_DUPLICATE;
			}else{
				 
				$sql = "INSERT INTO AirportRootFare (FromCityId, ToCityId,  FromCountryId, ToCountryId, FareAmount, TicketType, OrganizationId,  CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, ChildFare, InfantFare, FiscalId) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
				
				try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					
					$query = $this->db->prepare($sql);
					$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $request[7], $orgid, $mdate, $mid, $mdate, $mid, $mid,  $request[8],  $request[9], $fiscid));
				
					$count =  $query->rowCount();		
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				
				if ($count == 1) {
				   $status =true;
				   $successMsg = ROOTFARE_MODULE_CREATION_SUCCESS;
				} else {
				   $status =false;
				   $errorMsg=ROOTFARE_MODULE_CREATION_FAILED;
				}
			
			}
		}else{
			$status =false;
			$errorMsg=ROOTFARE_MODULE_FISCAL_NOT_FOUND;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		
		
			$sql = "DELETE FROM AirportRootFare WHERE Id = :id ";		
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = ROOTFARE_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=ROOTFARE_MODULE_DELETE_FAILED;
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id, $table, $column='Name')
	{
		$name ="";
		$sql = "SELECT $column FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$column;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getTicketType($id)
	{
		$name ="";
		$sql = "SELECT DisplayName FROM OtherMaster WHERE ActualValue = ? and OtherType='TicketType'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($id ));
			while($row = $query->fetch())
			{
				$name = $row->DisplayName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'AirportRootFare';
		$sIndexColumn = "Id";
		$aColumns = array( 'FromCityId','ToCityId', 'ToCityId','FareAmount', 'ChildFare', 'InfantFare', 'TicketType', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$fiscid = Utils::getFiscalId(date("Y-m-d"), $this->db);
		
		$sWhere = " WHERE  OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}if($aColumns[$i]=="FromCityId" || $aColumns[$i]=="ToCityId"){
					$sWhere .= '('.$aColumns[$i] ." in (select Id from CityMaster where Name "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editrootfare/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}else if($i==1 && $aColumns[$i]=="ToCityId")
				{
					$cid= $this->getName($aRow->{$aColumns[$i]}, 'CityMaster','CountryId');
					$row[] = self::getName($cid, 'CountryMaster');
					
				}
				else if($aColumns[$i]=="FromCityId" || $aColumns[$i]=="ToCityId")
				{
					$row[] = self::getName($aRow->{$aColumns[$i]}, 'CityMaster');
					
				}else if($aColumns[$i]=="InfantFare" || $aColumns[$i]=="ChildFare" || $aColumns[$i]=="FareAmount")
				{
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
					
				}else if($aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
					
				}else if($aColumns[$i]=="TicketType")
				{
					$row[] = self::getTicketType($aRow->{$aColumns[$i]});
					
				}else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	 public function insertFileHeaders($request)
    {
		$result = array();
		$count=0; $count1=0;  $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$departure = $request[2];
		$arrival = $request[3];
		$adultfare = $request[4];
		$infantfare = $request[5];
		$childfare = $request[6];
		$tickettype = $request[7];
	
		$tocountry="";
		$tocity ="";
		$fromcity="1922";
		$fromcountry ="215";
		$fiscid =  Utils::getFiscalId(date("Y-m-d"), $this->db);
		$ticket=1;
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$i=0;	
			try{
				
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 				
						if($departure!=""){
							$sql = "SELECT Id, CountryId FROM CityMaster WHERE Name like ? limit 1";
							$query = $this->db->prepare($sql);
							try{ 							
								$query->execute(array( "%".$data[$departure]."%" ));
								while($row = $query->fetch()){
									$fromcity=$row->Id;
									$fromcountry =$row->CountryId;
								}
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
								
							}
						}
						if($tickettype!=""){
							$sql = "SELECT ActualValue FROM OtherMaster WHERE DisplayName like ? limit 1";
							$query = $this->db->prepare($sql);
							try{ 							
								$query->execute(array( "%".$data[$tickettype]."%" ));
								while($row = $query->fetch()){
									$ticket=$row->ActualValue;
								}
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
								
							}
						}
							$flg=0;
							if($data[$arrival] != ""){
								$sql = "SELECT Id, CountryId FROM CityMaster WHERE Name like ? limit 1";
								$query = $this->db->prepare($sql);
								try{ 							
									$query->execute(array( "%".$data[$arrival]."%" ));
									$flg =  $query->rowCount();
									while($row = $query->fetch()){
										$tocity=$row->Id;
										$tocountry =$row->CountryId;
									}
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
									
								}
							}
							if ($flg == 1) 
							{
								// SQL Query to insert data into DataBase
								$sql1 = "SELECT * FROM AirportRootFare WHERE FromCityId = ? and ToCityId =? and TicketType=? and FiscalId=? and OrganizationId=?";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array( $fromcity, $tocity, $ticket, $fiscid,$orgid));
								if($query1->rowCount() > 0)
								{
									$sql1 = "UPDATE AirportRootFare set FareAmount=?, ChildFare=?, InfantFare=? WHERE FromCityId = ? and ToCityId =? and TicketType=? and FiscalId=? and OrganizationId=?";
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array( $data[$adultfare],$data[$childfare], $data[$infantfare],$fromcity, $tocity, $ticket, $fiscid, $orgid));
									$c++;
								}
								else{
									$sql = "INSERT INTO AirportRootFare ( FromCityId, ToCityId, FromCountryId, ToCountryId, FareAmount, TicketType,  ChildFare, InfantFare, OrganizationId, CreatedDate,  CreatedById, LastModifiedDate, LastModifiedById, OwnerId, FiscalId) VALUES (?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
									try{
										
										$query = $this->db->prepare($sql);
										$query->execute(array($fromcity, $tocity, $fromcountry, $tocountry, $data[$adultfare],$ticket,$data[$childfare], $data[$infantfare], $orgid,  $mdate,  $mid,  $mdate,  $mid,  $mid, $fiscid));
										$c1++;
										$count1 =  $query->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
								}
							if ($count1 >= 1) {
							   $status =true;								   
							   
							   $successMsg = " LTA imported";
							} 
							}else{
								$status =true;
								
								$errorMsg = "Departure City not found";
							}
						
					}							
						$i++;
				}
			}		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}	
		if ($i == 1) {
			$status =false;
			$errorMsg = " LTA not imported";
		}  
		
		$result["repeatemp"] =$c;
		$result["importemp"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
}
