<?php

/**
 * QualificationModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ResignationModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM EmployeeRegination WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['emp'] = $row->EmployeeId;
				//$res['code'] = $row->Code;
				//$res['catid'] = $row->CategoryId;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = RESIGNATION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		
		$orgid = $_SESSION['ubihrm_org_id'];;
		$data = array();
		$data1 = array();
		
        $sql = "SELECT * FROM EmployeeRegination WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			$resapproval = array();
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['subject'] = $row->ResignSubject;
				$res['message'] = $row->ResignMessage;
				$res['noticeperiod'] = $row->NoticeDuration;
				$res['startdate'] = Utils::dateformatter($row->NoticeStart);
				$res['enddate'] = Utils::dateformatter($row->NoticeEnd);
				$res['startdate1'] = ($row->NoticeStart=='0000-00-00')?'':Utils::dateformatter($row->NoticeStart);
				$res['enddate1'] = ($row->NoticeEnd=='0000-00-00')?'':Utils::dateformatter($row->NoticeEnd);
				$res['resignsts'] = $row->ResignationStatus;
				$empid=$row->EmployeeId;
				$sql1 = "SELECT * FROM ResignationApproval WHERE ResignationId = ? and OrganizationId = ? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id,$orgid ));
				while($r=$query1->fetch())
				{
					$res1=array();
					$res1['id'] = $r->Id;
					$res1['name'] = Utils::getEmployeeName($r->ApproverId, $this->db);
					$res1['sts'] = $r->LeaveStatus;
					$res1['comment'] = $r->ApproverComment;
					$res1['approvaldate'] = Utils::datetimeformatter($r->ApprovalDate);
					$resapproval[]=$res1;
				}
				$res['Approvals']=$resapproval;
				$data[] = $res;
			}
			
			$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ? ";
        	$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $empid,$orgid ));
			while($r=$query1->fetch())
			{
				$res1 = array();			
				$res1['empname'] = $r->EmployeeCode." - ". ucwords(strtolower($r->FirstName." ".$r->LastName));
				$res1['division'] = Utils::getName($r->Division,"DivisionMaster", "Name", $this->db);
				$res1['department'] = Utils::getName($r->Department,"DepartmentMaster", "Name", $this->db);
				$res1['designation'] = Utils::getName($r->Designation,"DesignationMaster", "Name", $this->db);
				
				$data1[] = $res1;
			
			}
			
        	}
		
		if ($count == 1) {
           $status =true;
		   $successMsg = RESIGNATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = RESIGNATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result["data1"] =$data1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a QualificationTable (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
				
			$sql = "UPDATE EmployeeRegination SET NoticeStart=?, NoticeEnd=?, ResignationStatus=?, OrganizationId=? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array($this->getDateformat($request[2]), $this->getDateformat($request[3]), $request[4],  $orgid, $request[5]));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			///////////////// Insert record of resignation in Employee history /////////////
		
			$sql1 = "INSERT INTO EmployeeHistory (EmployeeId, Title, EventDate, Message, OrganizationId) VALUES (?, ?, ?, ?, ?)";	
		       $query1 = $this->db->prepare($sql1);
		
			try{
			
				if($request[4]==2)
				{
					$title='Accept Resignation';
					$msg = 'Job resignation is accepted';
				}
					
				if($request[4]==1)
				{
					$title='Reject Resignation';
					$msg = 'Job resignation is rejected';
				}
										
				$query1->execute(array($request[0], $title, $mdate, $msg, $request[1]));			
				$count1 =  $query1->rowCount();
			
			}catch(Exception $e) {
		                      
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
			////////////////////////////////////////////////////////////////////////////////
			
			if ($count == 1) {
			    $status =true;
			    $successMsg = RESIGNATION_MODULE_UPDATION_SUCCESS;
			    $sql = "UPDATE ResignationApproval set ApprovalDate=?, ApproverComment=?, LeaveStatus=? where ResignationId=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($mdate, $request[6], $request[4], $request[5]));
			   
			} else {
			   $status =false;
			   $errorMsg = RESIGNATION_MODULE_UPDATION_FAILED;
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a QualificationTable (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM EmployeeRegination WHERE Code = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[4]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=RESIGNATION_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "INSERT INTO EmployeeRegination (Name, CategoryId, Code, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $request[3], $request[4], $orgid, $mdate, $mid, $mdate, $mid, $mid));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = RESIGNATION_MODULE_CREATION_SUCCESS;
			   $resignationid=$result['id'] = $this->db->lastInsertId();
			  
				$senior = Utils::getApprovalLevelEmp($request[2], 4, $this->db);
				if($senior!=0)
				{
					$temp = explode(",", $senior);
					for($i=0; $i<count($temp); $i++)
					{
						$sql = "INSERT INTO ResignationApproval ( ResignationId, ApproverId, ApproverSts, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($resignationid, $temp[$i], 3, $mdate, $orgid));
						
						if($i==0){
									$approvelink=URL."approvalbymail/viewapproveseveranceapproval/$temp[$i]/$orgid/$resignationid/2";
									$rejectlink=URL."approvalbymail/viewapproveseveranceapproval/$temp[$i]/$orgid/$resignationid/1";
									$senioremail=Utils::decode5t(Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db));
									$title="Leave requested by $empname";
									
									$msg="<table>
													<tr><td>Requested by : $empname</td></tr>
													<tr><td>Reason for leave : $leavereason</td></tr>
													<tr><td>Duration :  $duration</td></tr>
													<tr><td>Leave days :  $leavedays</td></tr>
														<tr><td colspan='2'>														
														</td></tr>														
												</table></br>
												$leavehistory
												</br>
												$approverhistory<br>
												<table>
												<tr><td><br/><br/>
																<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
																-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
																&nbsp;&nbsp;
																&nbsp;&nbsp;
																<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
																-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
																<br/><br/>
																</td>															
																</tr>
												</table>";
									//$senioremail="monika@ubitechsolutions.com";
									Utils::sendMail($senioremail,$empname,$title,$msg);
									Utils::Trace($senioremail." ".$msg);
						}		
						
					}
				}
			} else {
			   $status =false;
			   $errorMsg = RESIGNATION_MODULE_CREATION_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT Id FROM EmployeeRegination WHERE Degree = :id";
        	$query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=RESIGNATION_MODULE_DELETE_EXIST;
		}else{
		
			$sql = "DELETE FROM EmployeeRegination WHERE Id = :id ";
		
			try{
			
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
		
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
			if ($count == 1) {
			   $status =true;
				   $successMsg = RESIGNATION_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
				   $errorMsg = RESIGNATION_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function UpdateResignationSts($id)
    {
		$rstatus=$_POST['status'];
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		 $sql = "UPDATE EmployeeRegination SET ResignationStatus = ? WHERE  Id = ?";
		 $query = $this->db->prepare($sql);
		     
		try{
			$query->execute(array($rstatus,$id));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			 $status =true;
			 if($rstatus == 4){
				$successMsg=RESIGNATION_MODULE_CANCEL;
			 }
			 elseif($rstatus == 5){
				$successMsg=RESIGNATION_MODULE_WITHDRAW;
			 }
			 else{
				$successMsg=RESIGNATION_MODULE_REAPPLY;
			 }
        }
		
		else {
           $status =false;
		   $errorMsg= RESIGNATION_MODULE_UPDATION_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getName1($id)
	{
		$name ="";
		$sql = "SELECT * FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->FirstName.' '.$row->LastName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'EmployeeRegination';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','NoticeDuration', 'NoticeStart', 'NoticeEnd', 'ResignationStatus', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		if($sts==1){
			$sWhere = " WHERE OrganizationId= $orgid AND ResignationStatus<>0";
		}else{
			//$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " WHERE OrganizationId= $orgid AND Id IN (SELECT ResignationId FROM ResignationApproval Where ApproverId=$userid ) AND ResignationStatus<>0";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						if($aRow->ResignationStatus==3 ){						
						$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'employee/editresignation/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" class="text-green"><i class="fa fa-thumbs-up"></i></a>';
						}
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit;//."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
					
				}elseif($aColumns[$i]=="EmployeeId")
				{
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'employee/viewresignation/'.Utils::encode5t($aRow->Id).'/1">'.self::getName1($aRow->{$aColumns[$i]}).'</a>';
				}
				elseif($aColumns[$i]=="NoticeStart"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="NoticeEnd"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}elseif($aColumns[$i]=="ResignationStatus"){
					
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	public function getDateformat($date)
	{	
		$format = $_SESSION['ubihrm_dateformate1'];
		$changedate=$date;
		if($format=="dd/mm/yyyy" || $format=="mm/dd/yyyy" || $format=="yyyy/mm/dd"){
			$temp = explode('/', $date);
			if($format=="dd/mm/yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm/dd/yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}elseif($format=="yyyy/mm/dd"){
				$changedate=$temp[0]."-".$temp[1]."-".$temp[2];
			}
		}elseif($format=="dd-mm-yyyy" || $format=="mm-dd-yyyy" || $format=="yyyy-mm-dd"){
			$temp = explode('-', $date);
			if($format=="dd-mm-yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm-dd-yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}else{
				$changedate=$date;
			}
		}
		return $changedate;
	}
	
}
