<?php
 
/**
 * ReportModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ReportModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
	 
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
	 
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$sql = "SELECT * FROM ReportMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = REPORT_MODULE_GETALL;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = ""; $csts=0; $startdate = date('Y-m-d');
		$enddate =  date('Y-m-d');
        $sql = "SELECT * FROM ReportMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$tablename=$res['module'] = $row->ModuleId;
				$res['selectedcol'] =  explode(',' ,$row->SelectedColumn);
				$res['groupby'] = $row->SelectedGroupBy;
				$res['reportype'] = $row->ReportType;
				$totalcol = $res['totalcolumn'] = $row->TotalColumn;
				$csts=$res['customsts'] = $row->CustomSts;
				$change =array(" asc"," desc") ;
				$sOrder = str_replace($change,"",$row->SelectedGroupBy);
				$colname="";
				if(strpos($totalcol,'.') != false)
				{
					$colsname=explode('.', $totalcol);
					$colname= $colsname[1];
				}
				else{
					$colname= $totalcol;
				}
				$sqlcoltyp = "SELECT FieldType FROM ModuleChild WHERE ColumnName = ?";
				$querycoltyp = $this->db->prepare($sqlcoltyp);
				$querycoltyp->execute(array($colname));
				while($rowcoltyp= $querycoltyp->fetch())
				{
					$res['totalcolumntyp'] = $rowcoltyp->FieldType;
				}
				$res['groupby1'] = $sOrder;
				$orgid =$row->OrganizationId;
				$sqlfilter= "SELECT * FROM ReportFilterMaster WHERE ReportId = :id";
				$queryfilter= $this->db->prepare($sqlfilter);
				$queryfilter->execute(array(':id' => $id ));
				$filter=array();
				$columns=array();
				$orgdetails=array();
				while($rowfilter= $queryfilter->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowfilter->Id;
					$res1['condition1'] = $rowfilter->Condition1;
					$res1['column'] = $rowfilter->SelectedColumn;
					$res1['condition2'] = $rowfilter->Condition2;
					if($rowfilter->Condition2=='between')
					{
						$temp=explode("'AND'",$rowfilter->TextValue);
						//echo $temp[0];
						//echo Utils::dateformatter($temp[0]);
						$temp1=Utils::dateformatter($temp[0])."'AND'".Utils::dateformatter($temp[1]);
						$res1['textvalue']=$temp1;
						$res1['textvalue1']=$rowfilter->TextValue;
					}else{
						$res1['textvalue'] = $rowfilter->TextValue;
						$res1['textvalue1'] = $rowfilter->TextValue;
					}
					$res1['type'] = "";
					$moduleid= $rowfilter->ModuleChildId;
					$sql1="SELECT * FROM ModuleChild WHERE Id =?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($moduleid));
					if($row= $query1->fetch()){
						$res1['tablename'] = $row->TableName;
						$res1['type'] = $row->FieldType;
					}
					$filter[] = $res1;
				}
					for($i=0;$i<count($res['selectedcol']);$i++){
						$modid=0;
						if (strpos($res['selectedcol'][$i],'.') == true)
						{
							$colarr=explode('.',$res['selectedcol'][$i]);
							$selectedcol=$colarr[1];
							$tablename1=$colarr[0];
							$modid=$this->getModuleId($tablename1,$csts);
						}
						else{
							$selectedcol=$res['selectedcol'][$i];
							$modid=$this->getModuleId($tablename,$csts);
						}
							$sql1 = "SELECT ColumnLabel,TableName FROM ModuleChild WHERE ColumnName = ? and ModuleId = $modid";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($selectedcol));
							while($row1= $query1->fetch())
							{
								if($selectedcol=='DOB' && $csts==5){
								$columns[]= "Birthday on";
								}elseif($selectedcol=='TotalExp' && $row1->TableName=='TotalExp'){
									$columns[]= "Total Experience";
								}
								else{
									$columns[] =$row1->ColumnLabel;
								}
							}
					}
				$res['reportfilter'] = $filter;
				$res['reportcolumns'] = $columns;
				$data[] = $res;
			}
        }
		
				$sqlfilter= "SELECT * FROM Organization WHERE Id = :id";
				$queryfilter= $this->db->prepare($sqlfilter);
				$queryfilter->execute(array(':id' => $orgid ));
				$orgdetails=array();
				while($rowfilter= $queryfilter->fetch())
				{
					$res1 = array();
					
					$res1['org'] = $rowfilter->Name;
					$res1['image'] = URL."public/uploads/".$orgid."/".$rowfilter->Logo;
					$res1['email'] = $rowfilter->Email;
					$res1['phone'] = $rowfilter->PhoneNumber;
					$res1['country'] = $this->getName($rowfilter->Country,'CountryMaster');
					$res1['city'] = $this->getName($rowfilter->City,'CityMaster');
					$orgdetails[] = $res1;
				}
				$fiscalid=$_SESSION['ubihrm_fiscalid'];
				$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $fiscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
				}
		
		if ($count == 1) {
			
           $status =true;
		   $successMsg = REPORT_MODULE_GETDETAIL_SUCCESS;
        } else {
			
           $status =false;
		   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
        }
		
		
		$result["date"] =date('Y-m-d');
		$result["startdate1"] ="[".date('d/m/Y')."]";
		$result['today']=Utils::dateformatter(date("Y-m-d"));
		$result['startdate']=Utils::monthdateformatter(date("Y-m-d"));
		//$result['enddate']=Utils::monthdateformatter(date("Y-m-d"));
		//$result['startdate']=Utils::monthdateformatter(date("Y-m-d"));
		$result["fiscalstartdate"] =$startdate;
		$result["fiscalenddate"] =$enddate;
		$result["fiscalview"] =Utils::monthdateformatter($startdate).' - '.Utils::monthdateformatter($enddate);
		$result["dateformat"] =$_SESSION['ubihrm_dateformate1'];
		$result["data"] =$data;
		$result['status']=$status;
		$result["orgdetails"] =$orgdetails;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		//$result["empcompleteassessments"] =$this->EmployeeAssessmentCompleteReport();
		
		if($csts==3){
			$result["leavecustomreport1"] =$this->createLeaveReport();
			
		}elseif($csts==2){
			
			$result["leavecustomreport2"] =$this->createLeaveUtilizedTable();
		}
		elseif($csts==4){
			$result["attendancereport1"] =$this->AttendanceSummaryReport2();
			
		}elseif($csts==7){
			$result["jobmodificationreport"] =$this->JobModificationReport(1);
			
		}
		elseif($csts==8){
			$result["jobmodificationreport"] =$this->JobModificationReport(2);
			
		}
		elseif($csts==9){
			$result["salarydistribution"] =$this->getMonthPayrollDetail();
			
		}
		elseif($csts==10){
			$result["leavecustomreport3"] =$this->EmployeeLeaveHistory();
			
		}
		elseif($csts==11){
			$result["leavecustomreport4"] =$this->CalenderDaysAnnaulLeaveEmp(11);
			
		}
		elseif($csts==12){
			$result["leavecustomreport4"] =$this->CalenderDaysAnnaulLeaveEmp(12);
			
		}
		elseif($csts==13){
			
			$result["empassessment"] =$this->EmployeeAssessmentCompleteReport();
		}
		elseif($csts==14){
			
			$result["salarydistribution"] =$this->getEmployeeAdditionDeduction();
		}
		elseif($csts==15){
			
			$result["empassessment"] =$this->EmployeeAssessmentReport();
		}
		elseif($csts==16){
			$result["empgratuity"] =$this->EmployeeGratuity();
		}
		elseif($csts==17){
			$result["attendancereport1"] =$this->AttendanceMonthlyReport();
			
		}
		elseif($csts==18){
			$result["timesheetreport"] =$this->TimesheetMonthlyReport();
			
		}
		elseif($csts==19){
			$result["timesheetreport"] =$this->TimesheetDailyReport();
			
		}
		elseif($csts==20){
			$result["timesheetreport"] =$this->TimesheetDelayReport();
			
		}
		elseif($csts==21){
			$result["timesheetreport"] =$this->TimesheetEarlyReport();
			
		}
		elseif($csts==22){
			$result["timesheetreport"] =$this->MonthlyReport();
			
		}
		elseif($csts==23){
			$result["timesheetreport"] =$this->ProjectReport();
			
		}
		elseif($csts==24){
			$result["attendancereport1"] =$this->AttendanceMonthlysummary();			
		}
		elseif($csts==29){
			$result["salarydistributiontotal"] =$this->getMonthPayrollTotal();			
		}
		/* elseif($csts==30){
			$result["attendancereport1"] =$this->MonthlySummaryOfLateHours();			
		} */
		elseif($csts==32){
			$result["attendancereport1"] =$this->DateWiseLateHours();			
		}
		elseif($csts==31){
			$result["wpsreport"] =$this->getMonthPayrollDetail(1);		 //////////LBT report	
		}
		elseif($csts==37){
			$result["wpsreport"] =$this->getMonthPayrollDetail(4);		 //////////prime leagueLBT report	
		}
		elseif($csts==30){
			$result["wpsreport"] =$this->getMonthPayrollDetail(3);	 /////////WPS report		
		}
		elseif($csts==33){
			$result["wpsreport"] =$this->getMonthPayrollDetail(2);	/////BT report 		
		}
		elseif($csts==34){
			$result["fundreport"] =$this->getFundDetail(1);	/////ESI report 		
		}
		elseif($csts==35){
			$result["fundreport"] =$this->getFundDetail(2);	/////PF report 		
		}
		elseif($csts==36){
			$result["fundreport"] =$this->getFundDetail(3);	/////TDS report 		
		}
		elseif($csts==38){
			$result["njvreport"] =$this->getNJVdata();	/////TDS report 		
		}
		elseif($csts==39){
			$result["njvreport"] =$this->getNJVdataEmpwise();	/////TDS report 		
		}
		elseif($csts==40){
			$result["timesheetreport"] = $this->getclientwiseReport();
		}
		elseif($csts==41){
			$result["gratuitynjvreport"] =$this->getGratuityNJVdata();	/////TDS report 		
		}
		elseif($csts==42){
			$result["timesheetreport"] = $this->getclientsummary();
		}elseif($csts==43){
			$result["timesheetreport"] = $this->getclientapplication();
		}
		elseif($csts==44){
			$result["skillgapreport"] = $this->EmployeeSkillGapReport();
		}
		elseif($csts==45){
			$result["timesheetreport"] = $this->getclientwiseprojectmanager();
		}elseif($csts==46){
			$result["timesheetreport"] = $this->gettimesheetbyproject();
		}elseif($csts==47){
			$result["timesheetreport"] = $this->getprojectwisetask();
		}elseif($csts==48){
			$result["timesheetreport"] = $this->getprojectwiseemployee();
		}elseif($csts==53){
			$result["attendanceyesterdayreport"] =$this->AttendanceYesterdayReport();
			
		}elseif($csts==55){
			$result["attendancereport1"] =$this->getMonthPayrollDetailSIF();
			
		}elseif($csts==57){
			$result["salarydistribution"] =$this->getMonthAttendancePayroll();
			
		}elseif($csts==58){
			$result["attendancereport1"] =$this->getMonthDubaiSIFDetail();
			
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		return $result;
    }
	
    public function getDetail1($id) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = ""; $csts=0; $startdate = date('Y-m-d');
		$enddate =  date('Y-m-d');
        $sql = "SELECT * FROM ReportMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$tablename=$res['module'] = $row->ModuleId;
				$res['selectedcol'] =  explode(',' ,$row->SelectedColumn);
				$res['groupby'] = $row->SelectedGroupBy;
				$res['reportype'] = $row->ReportType;
				$totalcol = $res['totalcolumn'] = $row->TotalColumn;
				$csts=$res['customsts'] = $row->CustomSts;
				$change =array(" asc"," desc") ;
				$sOrder = str_replace($change,"",$row->SelectedGroupBy);
				$colname="";
				if(strpos($totalcol,'.') != false)
				{
					$colsname=explode('.', $totalcol);
					$colname= $colsname[1];
				}
				else{
					$colname= $totalcol;
				}
				$sqlcoltyp = "SELECT FieldType FROM ModuleChild WHERE ColumnName = ?";
				$querycoltyp = $this->db->prepare($sqlcoltyp);
				$querycoltyp->execute(array($colname));
				while($rowcoltyp= $querycoltyp->fetch())
				{
					$res['totalcolumntyp'] = $rowcoltyp->FieldType;
				}
				$res['groupby1'] = $sOrder;
				$orgid =$row->OrganizationId;
				$sqlfilter= "SELECT * FROM ReportFilterMaster WHERE ReportId = :id";
				$queryfilter= $this->db->prepare($sqlfilter);
				$queryfilter->execute(array(':id' => $id ));
				$filter=array();
				$columns=array();
				$orgdetails=array();
				while($rowfilter= $queryfilter->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowfilter->Id;
					$res1['condition1'] = $rowfilter->Condition1;
					$res1['column'] = $rowfilter->SelectedColumn;
					$res1['condition2'] = $rowfilter->Condition2;
					
					if($rowfilter->Condition2=='between')
					{
						$temp=explode("'AND'",$rowfilter->TextValue);
						//echo $temp[0];
						//echo Utils::dateformatter($temp[0]);
						$temp1=Utils::dateformatter($temp[0])."'AND'".Utils::dateformatter($temp[1]);
						$res1['textvalue']=$temp1;
						$res1['textvalue1']=$rowfilter->TextValue;
					}else{
						$res1['textvalue'] = $rowfilter->TextValue;
						$res1['textvalue1'] = $rowfilter->TextValue;
					}
					$res1['type'] = "";
					$moduleid= $rowfilter->ModuleChildId;
					$sql1="SELECT * FROM ModuleChild WHERE Id =?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($moduleid));
					if($row= $query1->fetch()){
						$res1['tablename'] = $row->TableName;
						$res1['type'] = $row->FieldType;
					}
					$filter[] = $res1;
				}
				
				
					for($i=0;$i<count($res['selectedcol']);$i++){
						$modid=0;
						if (strpos($res['selectedcol'][$i],'.') == true)
						{
							$colarr=explode('.',$res['selectedcol'][$i]);
							$selectedcol=$colarr[1];
							$tablename1=$colarr[0];
							$modid=$this->getModuleId($tablename1,$csts);
						}
						else{
							$selectedcol=$res['selectedcol'][$i];
							$modid=$this->getModuleId($tablename,$csts);
						}
						
							$sql1 = "SELECT ColumnLabel,TableName FROM ModuleChild WHERE ColumnName = ? and ModuleId = $modid";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($selectedcol));
							while($row1= $query1->fetch())
							{
								if($selectedcol=='DOB' && $csts==5){
								$columns[]= "Birthday on";
								}elseif($selectedcol=='TotalExp' && $row1->TableName=='TotalExp'){
									$columns[]= "Total Experience";
								}
								else{
									$columns[] =$row1->ColumnLabel;
								}
								
							}
						
					}
				
				$res['reportfilter'] = $filter;
				$res['reportcolumns'] = $columns;
				$data[] = $res;
			}
        }
		
				$sqlfilter= "SELECT * FROM Organization WHERE Id = :id";
				$queryfilter= $this->db->prepare($sqlfilter);
				$queryfilter->execute(array(':id' => $orgid ));
				$orgdetails=array();
				while($rowfilter= $queryfilter->fetch())
				{
					$res1 = array();
					
					$res1['org'] = $rowfilter->Name;
					$res1['image'] = URL."public/uploads/".$orgid."/".$rowfilter->Logo;
					$res1['email'] = $rowfilter->Email;
					$res1['phone'] = $rowfilter->PhoneNumber;
					$res1['country'] = $this->getName($rowfilter->Country,'CountryMaster');
					$res1['city'] = $this->getName($rowfilter->City,'CityMaster');
					$orgdetails[] = $res1;
				}
				$fiscalid=isset($_SESSION['ubihrm_fiscalid'])?$_SESSION['ubihrm_fiscalid']:0;
				$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $fiscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
				}
		
		if ($count == 1) {
			
           $status =true;
		   $successMsg = REPORT_MODULE_GETDETAIL_SUCCESS;
        } else {
			
           $status =false;
		   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
        }
		
		
		$result["date"] =date('Y-m-d');
		$result['today']=Utils::dateformatter(date("Y-m-d"));
		$result['startdate']=Utils::monthdateformatter(date("Y-m-d"));
		//$result['startdate']=Utils::monthdateformatter(date("Y-m-d"));
		$result["fiscalstartdate"] =$startdate;
		$result["fiscalenddate"] =$enddate;
		$result["fiscalview"] =Utils::monthdateformatter($startdate).' - '.Utils::monthdateformatter($enddate);
		$result["dateformat"] ="Y-m-d";
		$result["data"] =$data;
		$result['status']=$status;
		$result["orgdetails"] =$orgdetails;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		//$result["empcompleteassessments"] =$this->EmployeeAssessmentCompleteReport();
		
		if($csts==3){
			$result["leavecustomreport1"] =$this->createLeaveReport();
			
		}elseif($csts==2){
			
			$result["leavecustomreport2"] =$this->createLeaveUtilizedTable();
		}
		elseif($csts==4){
			$result["attendancereport1"] =$this->AttendanceSummaryReport();
			
		}elseif($csts==7){
			$result["jobmodificationreport"] =$this->JobModificationReport(1);
			
		}
		elseif($csts==8){
			$result["jobmodificationreport"] =$this->JobModificationReport(2);
			
		}
		elseif($csts==9){
			$result["salarydistribution"] =$this->getMonthPayrollDetail();
			
		}
		elseif($csts==10){
			$result["leavecustomreport3"] =$this->EmployeeLeaveHistory();
			
		}
		elseif($csts==11){
			$result["leavecustomreport4"] =$this->CalenderDaysAnnaulLeaveEmp(11);
			
		}
		elseif($csts==12){
			$result["leavecustomreport4"] =$this->CalenderDaysAnnaulLeaveEmp(12);
			
		}
		elseif($csts==13){
			
			$result["empassessment"] =$this->EmployeeAssessmentCompleteReport();
		}
		elseif($csts==14){
			
			$result["salarydistribution"] =$this->getEmployeeAdditionDeduction();
		}
		elseif($csts==15){
			
			$result["empassessment"] =$this->EmployeeAssessmentReport();
		}
		elseif($csts==16){
			$result["empgratuity"] =$this->EmployeeGratuity();
		}
		elseif($csts==17){
			$result["attendancereport1"] =$this->AttendanceMonthlyReport();
			
		}
		elseif($csts==18){
			$result["timesheetreport"] =$this->TimesheetMonthlyReport();
			
		}
		elseif($csts==19){
			$result["timesheetreport"] =$this->TimesheetDailyReport();
			
		}
		elseif($csts==20){
				$result["timesheetreport"] =$this->MonthlyReport1($orgid);
			
		}
		elseif($csts==21){
			$result["timesheetreport"] =$this->TimesheetEarlyReport();
			
		}
		elseif($csts==22){
			$result["timesheetreport"] =$this->MonthlyReport1($orgid);
			
		}
		elseif($csts==23){
			$result["timesheetreport"] =$this->ProjectReport();
			
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		return $result;
    }
	/**
	 * Setter for a ReportMaster (update)
	 * @param array $request contains 5 parameter value that will be created
	 * @return array feedback /////ViewEmpTaskDetail//
	 */
     public function getprojectwisestatus(){
	 	$totalhour1 = "";
		$totalminute1 = "";
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate =  isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
			$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
			$enddate = date("Y-m-t");
		$swhere ="";
		if(isset($_POST['client']) && $_POST['client']!=0){
			$swhere .=" AND project_status=".$_POST['client'];
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sql = "SELECT * FROM project_master where owner_id in ($ids) and OrganizationId =? ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM project_master WHERE  start_date between '$startdate' and '$enddate' AND OrganizationId =? $swhere";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$timesheet = array();
					$res = array();
					$proId = $row->id;
					$status = $row->project_status;
					if( $row->project_status == 1){
							$res['prosts'] ="Running" ;
					}elseif( $row->project_status == 2){
						$res['prosts'] = "Abandoned";
					}elseif( $row->project_status == 3){
						$res['prosts'] = "Finished";
					}elseif( $row->project_status == 4){
						$res['prosts'] = "Reopened";
					}elseif( $row->project_status == 5){
						$res['prosts'] = "Not Started";
					}
					$sql3="SELECT (SUM(TIME_TO_SEC(total_time)))AS total FROM timesheet_master where  project_id = ? and OrganizationId=?";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array($proId,$orgid));
					$con1=$query3->rowCount();
					$days='';$hours='';$minutes=''; $acttotal_time="";
					while($row3 = $query3->fetch()) {
						$res1  = array();
						$start = $row3->total;
						if($row3->total!=""){
							$days = intval(intval($start) / (3600*24));
							$hours = (intval($start) / 3600) % 24;
							$minutes = (intval($start) / 60) % 60;
							// $seconds = intval($seconds) % 60;
							$res1['totaltime']  = $days.' days, '.$hours.' hours, '.$minutes.' minutes';	
						}
						$res1['project'] =  $row->project_title;
						$res1['client'] = Utils::getName($row->company,"EmployerMaster","Name",$this->db);$cont = explode(",",$row->assigned_to);
						$res1['count']  = count($cont);
						if($row->Billingsts!=""){
							if($row->Billingsts==1)
								$res1['billingsts'] = "Billable";
							elseif($row->Billingsts==2)
								$res1['billingsts'] = "Non Billable";
						}
						$timesheet[]=$res1;
					}
					$res['timesheet']= $timesheet;
					$data[]=$res;
				}
			}else {
				$status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result['data']=$data;
		$result['startdate']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		if(isset($_POST['startdate']) && isset($_POST['enddate'])){
			return $result;
		}else{
			return $data;
		}
	 }
     public function getprojectwiseemployee(){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate =  isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
			$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
			$enddate = date("Y-m-t");
		$swhere ="";
		$swhere1="";
		if(isset($_POST['division']) && $_POST['division']!=0){
			$empid	= $_POST['division'];
			$swhere .=" AND assigned_to =$empid";
		}if(isset($_POST['client']) && $_POST['client']!=0){
			$swhere .=" AND project_status=".$_POST['client'];
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sql = "SELECT * FROM project_master where CreatedById in ($ids) and OrganizationId =? ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM project_master Where OrganizationId =? AND (start_date between '$startdate' and '$enddate') $swhere";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$timesheet = array();
					$res = array();
					$res1 = array(); 
					$proId = $row->id;
					$empids = explode(" ",$row->assigned_to);
					foreach($empids as $empid){
						$res['firstname'] = Utils::getName($empid,"EmployeeMaster","FirstName",$this->db);
						$res['lastname'] = Utils::getName($empid,"EmployeeMaster","LastName",$this->db);	
						$desg = Utils::getName($empid,"EmployeeMaster","Designation",$this->db);		
						$res['desg'] = Utils::getName($desg,"DesignationMaster","Name",$this->db);
						$sql3="SELECT (SUM(TIME_TO_SEC(total_time)))AS total FROM timesheet_master where  project_id = ? and OrganizationId=?";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array($proId,$orgid));
						$con1=$query3->rowCount();
						$days='';$hours='';$minutes=''; $acttotal_time="";
						while($row3 = $query3->fetch()) {
							$res1  = array();
							$start = $row3->total;
							if($row3->total!=""){
								$days = intval(intval($start) / (3600*24));
								$hours = (intval($start) / 3600) % 24;
								$minutes = (intval($start) / 60) % 60;
								// $seconds = intval($seconds) % 60;
								$res1['totaltime']  = $days.'days, '.$hours.' hours, '.$minutes.' minutes';	
							}
						}	
						$task_id = $row->id;
						$res1['projectname'] = $row->project_title;			
						$res1['client'] = Utils::getName($row->company,"EmployerMaster","Name",$this->db);
						$status = $row->project_status;
						$type = "ProjectStatus";
						$sql1 = "SELECT DisplayName FROM OtherMaster WHERE OtherType=? AND ActualValue=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($type,$status));
						while($row1 = $query1->fetch()){
							$res1['prosts']  = $row1->DisplayName;
						}
						$res1['taskcomplete']=$this->getEmptask($row->id , $empid,1);
						$res1['taskassign']=$this->getEmptask($row->id , $empid,2);
						//$res1['projectmanager']=Utils::getEmployeeName($row->owner_id,$this->db);
						$timesheet[] = $res1;
						$res["totalcount"] = $count;
						$res['timesheet']= $timesheet;
						$data[]=$res;
					}
				}	
			}else {
				$status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result['data']=$data;
		$result['startdate']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		if(isset($_POST['startdate']) && isset($_POST['enddate'])) {
			return $result;
		}else{
			return $data;
		}
	}
     public function getprojectwisetask(){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate =  isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
			$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
			$enddate = date("Y-m-t");
		$swhere ="";
		$swhere1="";
		if(isset($_POST['division']) && $_POST['division']!=0){
			$swhere .=" AND assignto=".$_POST['division'];
		}if(isset($_POST['client']) && $_POST['client']!=0){
			$swhere .=" AND projectid=".$_POST['client'];
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sql = "SELECT * FROM task_master where CreatedById in ($ids) and OrganizationId =? ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM task_master Where OrganizationId =? AND (fromdate between '$startdate' and '$enddate') $swhere";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$timesheet = array();
					$res = array();
					$res1 = array(); 
					$res1['assignby'] = Utils::getName($row->CreatedById,"EmployeeMaster","FirstName",$this->db);	
					$task_id = $row->id;
					$res['projectname'] = Utils::getName($row->projectid,"project_master","project_title",$this->db);
					$res1['empname'] = Utils::getName($row->LastModifiedById,"EmployeeMaster","FirstName",$this->db);
					$company = Utils::getName($row->projectid,"project_master","company",$this->db);
					$res['client'] = Utils::getName($company,"EmployerMaster","Name",$this->db);
					$res1['task'] = $row->task_title;
					$res1['description'] = $row->description;
					$res1['startdate'] = $row->fromdate;
					$res1['enddate'] = $row->todate;
					$startDate= new DateTime($row->fromdate);
					$endDate = new DateTime($row->todate);
					$interval = $startDate->diff($endDate);
					$res1['totoltime'] = $interval->format(' %h hours %i minutes');
					//$res1['client'] = Utils::getName($row->company,"EmployerMaster","Name",$this->db);
					//$res1['clientmanager']=Utils::getEmployeeName($row->ClientManager,$this->db);
					//$res1['projectmanager']=Utils::getEmployeeName($row->owner_id,$this->db);
					$timesheet[] = $res1;
					$res["totalcount"] = $count;
					$res['timesheet']= $timesheet;
					$data[]=$res;
				}
			}else {
				$status =false;
				$errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result['data']=$data;
		$result['startdate']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		if(isset($_POST['startdate']) && isset($_POST['enddate'])){
			return $result;
		}else{
			return $data;
		}
	 }
     public function gettimesheetbyproject(){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate =  isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
		$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
		$enddate = date("Y-m-t");
		$swhere ="";
		$swhere1="";
		if(isset($_POST['division']) && $_POST['division']!=0){
			$swhere .=" AND assignto=".$_POST['division'];
		}if(isset($_POST['client']) && $_POST['client']!=0) {
			$swhere .=" AND projectid=".$_POST['client'];
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sql = "SELECT * FROM task_master where CreatedById in ($ids) and OrganizationId =? ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM task_master Where OrganizationId =? AND (fromdate between '$startdate' and '$enddate') $swhere";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$timesheet = array();
					$res = array();
					$res1 = array(); 
					$task_id = $row->id;
					$res['projectname'] = Utils::getName($row->projectid,"project_master","project_title",$this->db);
					$res1['empname'] = Utils::getName($row->LastModifiedById,"EmployeeMaster","FirstName",$this->db);
					$company = Utils::getName($row->projectid,"project_master","company",$this->db);
					$res['client'] = Utils::getName($company,"EmployerMaster","Name",$this->db);
					$res1['task'] = $row->task_title;
					$res1['description'] = $row->description;
					$res1['startdate'] = $row->fromdate;
					$res1['enddate'] = $row->todate;
					$startDate= new DateTime($row->fromdate);
					$endDate = new DateTime($row->todate);
					$interval = $startDate->diff($endDate);
					$res1['timeduration'] = $interval->format('%H:%i');						
					$res['totoltime'] = $interval->format(' %a days %h hours %i minutes');
					//$res1['client'] = Utils::getName($row->company,"EmployerMaster","Name",$this->db);
					//$res1['clientmanager']=Utils::getEmployeeName($row->ClientManager,$this->db);
					//$res1['projectmanager']=Utils::getEmployeeName($row->owner_id,$this->db);
					$timesheet[] = $res1;
					$res["totalcount"] = $count;
					$res['timesheet']= $timesheet;
					$data[]=$res;
				}
			}else {
				$status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result['data']=$data;
		$result['startdate']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		if(isset($_POST['startdate']) && isset($_POST['enddate'])){
			return $result;
		}else{
			return $data;
		}
	 }
     public function getclientwiseprojectmanager(){
		
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		 $startdate =  isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
		$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
		$enddate = date("Y-m-t");
		$swhere ="";
		$swhere1="";
		if(isset($_POST['division']) && $_POST['division']!=0){
			$swhere .=" AND owner_id=".$_POST['division'];
		}if(isset($_POST['client']) && $_POST['client']!=0)
		{
			//$swhere .=" AND id=".$_POST['client'];
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sql = "SELECT * FROM project_master where owner_id in ($ids) and OrganizationId =? ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM project_master Where OrganizationId =? AND (start_date between '$startdate' and '$enddate') $swhere";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$timesheet = array();
					$res = array();
					$res1 = array(); 
					$ownerid = $row->owner_id;
					$res['projectmanager']=Utils::getEmployeeName($row->owner_id,$this->db);$res1['project']  = $row->project_title;	
					$res1['client'] = Utils::getName($row->company,"EmployerMaster","Name",$this->db);
					$res1['clientmanager']=Utils::getEmployeeName($row->ClientManager,$this->db);
					$res1['projectmanager']=Utils::getEmployeeName($row->owner_id,$this->db);						
					$empId = Utils::getName($row->owner_id,"EmployeeMaster","Department",$this->db);					
					$res["deparment"] = Utils::getName($empId,"DepartmentMaster","Name",$this->db);				
					$empids = explode(" ",$row->assigned_to);
					foreach($empids as $empId)
					{		
						$res1['taskcomplete']=$this->getEmptask($row->id,$empId,1);
					    $res1['taskassign']=$this->getEmptask($row->id,$empId,2);
					}
					$timesheet[] = $res1;
					
					$res["totalcount"] = $count;
					
					$res['timesheet']= $timesheet;
					$data[]=$res;
				}
			}else {
				$status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result['data']=$data;
		$result['startdate']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
			if(isset($_POST['startdate']) && isset($_POST['enddate']))
		{
			return $result;
		}
		else{
			return $data;
		}
	}
     public function getclientapplication(){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate =  isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
			$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
			$enddate = date("Y-m-t");
		$swhere ="";
		$swhere1="";
		if(isset($_POST['projectid']) && $_POST['projectid']!=0){
			$swhere .=" AND id=".$_POST['projectid'];
		}if(isset($_POST['client']) && $_POST['client']!=0)
		{
			$swhere .=" AND project_status=".$_POST['client'];
		}
		try{
		
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			/////According to task start and end get project id //////////
			$projectid = $this->gettaskstartdate($startdate,$enddate);
			$sql = "SELECT * FROM project_master where owner_id in ($ids) and id in ($projectid) and OrganizationId =? $swhere";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM project_master Where OrganizationId =? AND (start_date between '$startdate' and '$enddate') and id in ($projectid) $swhere";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$timesheet = array();
					$res = array();
					$res1 = array(); 	
					$res['project']  = $row->project_title;	
					
					$res1['client'] = Utils::getName($row->company,"EmployerMaster","Name",$this->db);
					$res1['clientmanager']=Utils::getEmployeeName($row->ClientManager,$this->db);
					$res1['projectmanager']=Utils::getEmployeeName($row->owner_id,$this->db);
					$cont = explode(",",$row->assigned_to);
					$res1['count']  = count($cont);
					$res1['totalactualtime']=$this->ViewEmpTaskDetail($row->id ,2);////get task total estimated hours//////
					$res1['totalestimatedtime']=$this->ViewEmpTaskDetail($row->id,3);////get timesheet total logged hours//////
					$status = $row->project_status;
					$type = "ProjectStatus";
					$sql1 = "SELECT DisplayName FROM OtherMaster WHERE OtherType=? AND ActualValue=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($type,$status));
					while($row1 = $query1->fetch()){
						if( $row1->DisplayName == "Running"){
							$res1['prosts'] ="Running" ;
						}elseif( $row1->DisplayName == "Abandoned"){
							$res1['prosts'] = "Abandoned";
						}elseif( $row1->DisplayName == "Finished"){
							$res1['prosts'] = "Finished";
						}elseif( $row1->DisplayName == "Reopened"){
							$res1['prosts'] = "Reopened";
						}elseif( $row1->DisplayName == "Not Started"){
							$res1['prosts'] = "Not Started";
						}
					}
					$timesheet[] = $res1;
					$res['timesheet']= $timesheet;
					$data[]=$res;
				}
			}else {
				$status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result['data']=$data;
		$result['startdate']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
			if(isset($_POST['startdate']) && isset($_POST['enddate']))
		{
			return $result;
		}
		else{
			return $data;
		}
	}
	public function ViewEmpTaskDetail($projectid,$val)
	{
		$result = array(); $res=array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$totalleave=0;
			$totalday=0;$totalhour=0; $totalminute=0;
			$totalday1=0;$totalhour1=0; $totalminute1=0;
			//$sql="select * from task_master where projectid =? ";
			$sql="select * from project_master where id =? ";
			$query=$this->db->prepare($sql);
			$query->execute(array($projectid));
			$count = $query->rowcount();
			$days1='';$hours1='';$minutes1='';
			while($row1= $query->fetch()) {
				//$start = new DateTime($row1->fromdate);
			//	$since_start1 = $start->diff(new DateTime($row1->todate));
				$start = $row1->start_date;
				$today = $row1->completed_date;
				$days1 = strtotime($today) - strtotime($start);
				$totalday1 = floor($days1/(60*60*24));
				/* if($since_start1->d>0){
					$days1=$since_start1->d.' days';
					$totalday1=$totalday1+$since_start1->d;
				} */
				/* if($since_start1->h>0){
					$hours1 = $since_start1->h.' hours';
					$totalhour1=$totalhour1+$since_start1->h;
				}
				if($since_start1->i>0){
					$minutes1 = $since_start1->i.' minutes';
					$totalminute1=$totalminute1+$since_start1->i;
				}
				if($totalhour1>24){
					$totalday1=$totalday1+1;
					$totalhour1=$totalhour1-24;
				}
				if($totalminute1>60){
					$totalhour1=$totalhour1+1;
					$totalminute1=$totalminute1-60;
				} */
			}
			$sql="select * from task_master where projectid =? and OrganizationId=?";
			$query=$this->db->prepare($sql);
			$query->execute(array($projectid, $orgid));
			$count = $query->rowcount();
			while($row1= $query->fetch()) {
				$start = explode(":", $row1->Totalhour);
				if($row1->Totalhour!=""){
					$hours1= $start[0];
					$totalhour1=$totalhour1+$hours1;
					$minutes1 = $start[1];
					$totalminute1=$totalminute1+$minutes1;
				}
			
			$sql2="SELECT * FROM timesheet_master where task_id=? and  project_id = ? and OrganizationId=?";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($row1->id,$projectid, $orgid));
			$con1=$query2->rowCount();
			$mindate="";
			$maxdate="";	$days='';$hours='';$minutes=''; 	$acttotal_time="";
			while($row2 = $query2->fetch()) {
				$total_time = explode(":", $row2->total_time);
				if($row2->total_time!=""){
					$hours= $total_time[0];
					$totalhour=$totalhour+$hours;
					$minutes = $total_time[1];
					$totalminute=$totalminute+$minutes;
					if($totalminute>60){
						$totalhour=$totalhour+1;
						$totalminute=$totalminute-60;
					}
				}
				/*$maxdate=$row2->timesheetend;
				$mindate=$row2->timesheetstart;
				$start_date = new DateTime($mindate);
				$since_start = $start_date->diff(new DateTime($maxdate));
				 if($since_start->d>0){
					$days=$since_start->d.' days';
					$totalday=$totalday+$since_start->d;
				} 
				if($since_start->h>0){
					$hours = $since_start->h.' hours';
					$totalhour=$totalhour+$since_start->h;
				}
				if($since_start->i>0){
					$minutes = $since_start->i.' minutes';
					$totalminute=$totalminute+$since_start->i;
				}
				/* if($totalhour>24){
					$totalday=$totalday+1;
					$totalhour=$totalhour-24;
				} 
				if($totalminute>60){
					$totalhour=$totalhour+1;
					$totalminute=$totalminute-60;
				}*/
			}
		}
			//$acttotaltime= $days.' '.$hours.' '.$minutes;
			//$acttotaltime= $hours.' '.$minutes;
			$esttotal_time =$totalhour1.' hours, '.$totalminute1.' minutes';
			$project_time =$totalday1.' days';
			//$acttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
			$acttotal_time =$totalhour.' hours, '.$totalminute.' minutes';
				
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($val==1)
		return $project_time;
		if($val==2)
		return $acttotal_time;
		if($val==3)
		return $esttotal_time;
	}
	public function AttendanceYesterdayReport()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0;$count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		$date=date('Y-m-d');
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate1 = date('Y-m-d');
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"$startdate1";
		//echo $currentmonth;
		if($startdate=="")
			$startdate = date("Y-m-d");
		//$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		$swhere =" ";
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql="select * from ShiftMaster where OrganizationId=$orgid";
			$query=$this->db->prepare($sql);
			$query->execute();
			$count1=$query->rowCount();
			if($count1>=1){
				while($row=$query->fetch()){
					$res=array();
					$shiftid=$row->Id;
					$res['shiftid']=$row->Id;
					$res['shiftname']=$row->Name;
					$res['shiftTimeIn']=$row->TimeIn;
					$res['timegrace']=$row->TimeInGrace;
					$res['shiftTimeOut']=$row->TimeOut;	
					$attendancearr1=array();		
					$sql1 = "SELECT AttendanceMaster.EmployeeId, AttendanceMaster.ShiftId, AttendanceMaster.TimeIn, AttendanceMaster.TimeOut, AttendanceMaster.Overtime, ShiftMaster.TimeInGrace, AttendanceMaster.AttendanceDate, ((TIME_TO_SEC(ShiftMaster.TimeInGrace)-TIME_TO_SEC(AttendanceMaster.TimeIn))/60 >0) as perc,TIME_FORMAT(TIMEDIFF( AttendanceMaster.TimeIn,ShiftMaster.TimeIn) ,'%H:%i') as latehrs FROM AttendanceMaster,ShiftMaster WHERE AttendanceMaster.ShiftId=ShiftMaster.Id and  AttendanceMaster.OrganizationId = $orgid and AttendanceMaster.ShiftId=$shiftid and AttendanceMaster.TimeIn > ShiftMaster.TimeInGrace and AttendanceMaster.AttendanceStatus in (1,4) and AttendanceMaster.AttendanceDate='$startdate' ORDER BY AttendanceMaster.ShiftId asc";
					$query1 = $this->db->prepare($sql1);
					$query1->execute();
					$con=$query1->rowCount();
					$present=0; $latecomer=0;$earlycomer=0; $overtime=0; $undertime=0; $absent=0;	$halfday=0; 
					while($row1 = $query1->fetch())
					{
						$res1=array(); 
						$res1['empid']=$row1->EmployeeId;			
						$res1['empname']=Utils::getEmployeeName($row1->EmployeeId,$this->db);		
						$res1['shiftid']=$row1->ShiftId;			
						//$res1['shiftname']=Utils::getName($row1->ShiftId,"ShiftMaster","Name",$this->db);			
						//$res1['shiftTimeIn']=Utils::getName($row1->ShiftId,"ShiftMaster","TimeIn",$this->db);			
						$res1['shiftTimeOut']=Utils::getName($row1->ShiftId,"ShiftMaster","TimeOut",$this->db);			
						$res1['timein']=$row1->TimeIn;			
						$res1['timeout']=$row1->TimeOut;			
						$res1['latehrs']=$row1->latehrs;			
						//$res1['timegrace']=$row1->TimeInGrace;			
						$res1['AttendanceDate']=Utils::dateformatter($row1->AttendanceDate)	;			
						$attendancearr1[]=$res1;			
					}
					$res['attendancearr1']=$attendancearr1;
					$data[]=$res;
				}
				
			}	
			
			//$data[]=$attendanceyesarr;
			//print_r($data);
					
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::dateformatter($startdate):$startdate1;
		//$result['enddate']=isset($_POST['todate'])?Utils::monthdateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']))
		{
			return $result;
		}else{
			return $data;
		}
		
		
		
	}	
	
     public function getclientsummary(){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate =  isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
			$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
			$enddate = date("Y-m-t");
		$swhere ="";
		$swhere1="";
		$totalhour="";
		$nonbillablehour ="";
		$billablehour="";
		$nonbillable="";
		$billable="";
		if(isset($_POST['division']) && $_POST['division']!=0){
			$swhere =" AND Billingsts=".$_POST['division'];
		
		}if(isset($_POST['client']) && $_POST['client']!=0) {
			$swhere1 =" AND Id=".$_POST['client'];
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sql = "SELECT * FROM EmployerMaster where OwnerId in ($ids) and OrganizationId =? $swhere1 ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployerMaster Where OrganizationId =? $swhere1";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$timesheet = array();
					$res = array();
					$res['clientid'] = Utils::encode5t($row->Id);
					$res['clientid1'] = $row->Id;
					$res['client'] =  $row->Name;
					$res['contperson'] = $row->ContactPerson;
					$sql1 = "SELECT * FROM project_master WHERE company =? AND OrganizationId =? AND (created_date between '$startdate' and '$enddate') $swhere";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id,$orgid));	
					$count1=  $query1->rowCount();  $timehours=0;$timeminutes=0;
					while($row1 = $query1->fetch()){	
						$projetcId = $row1->id;
						$billingsts = $row1->Billingsts;
						$totalminute1=0;$totalhour1=0;$totalhour2=0;$totalminute2=0;$billable='00:00';$nonbillable='00:00';
						if($billingsts == 1) {
							$sql2 = "SELECT *  FROM task_master WHERE projectid=?";
							$query2=$this->db->prepare($sql2);
							$query2->execute(array($projetcId));
							while($row2 = $query2->fetch()) {	
								$start = explode(":", $row2->Totalhour);
								if($row2->Totalhour!=""){
									$hours1= $start[0];
									$totalhour1=$totalhour1+$hours1;
									$minutes1 = $start[1];
									$totalminute1=$totalminute1+$minutes1;
									$billable  =$totalhour1.':'.$totalminute1;
									$res['billable']  = $totalhour1.' hours, '.$totalminute1.' minutes';
								}
							}
						}
						if($billingsts == 2) {
							$sql2 = "SELECT *  FROM task_master WHERE projectid=?";
							$query2=$this->db->prepare($sql2);
							$query2->execute(array($projetcId));
							while($row2 = $query2->fetch()) {	
								$res1 = array();
								$nonbillablehour=  explode(":", $row2->Totalhour);
								if($row2->Totalhour!=""){
									$hours2= $nonbillablehour[0];
									$totalhour2=$totalhour2+$hours2;
									$minutes2 = $nonbillablehour[1];
									$totalminute2=$totalminute2+$minutes2;
									$nonbillable= $totalhour2.':'.$totalminute2;
									$res['nonbillable'] = $totalhour2.' hours, '.$totalminute2.' minutes';
								}
							}
						}
						$timesnonbill = explode(':',$nonbillable);	
						$timesbill  = explode(':',$billable);
						$hours = $timesnonbill[0]+$timesbill[0];
						$timehours=$timehours+$hours;
						$minutes = $timesnonbill[1]+$timesbill[1];
						$timeminutes=$timeminutes+$minutes;
						$res['totalhours'] = $timehours.' hours, ' .$timeminutes.' minutes';
					}
					$res['totalproject']=$count1;
					$res['timesheet']= $timesheet;
					$data[]=$res;
				}
			}else {
				$status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result['data']=$data;
		$result['startdate']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		if(isset($_POST['startdate']) && isset($_POST['enddate'])) {
			return $result;
		}else{
			return $data;
		}
	}
	public function getclientwiseReport(){
		
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		 $startdate =  isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
			$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
			$enddate = date("Y-m-t");
		$swhere ="";
		if(isset($_POST['division']) && $_POST['division']!=0){
			$swhere .=" AND Billingsts=".$_POST['division'];
		}if(isset($_POST['client']) && $_POST['client']!=0) {
			$swhere .=" AND company=".$_POST['client'];
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sql = "SELECT * FROM EmployerMaster where OwnerId in ($ids) and OrganizationId =? ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployerMaster Where OrganizationId =?";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$timesheet = array();
					$res = array();
					$res['clientid'] = $row->Id;
					$res['client'] =  $row->Name;
					$res['contperson'] = $row->ContactPerson; 
					$sql1 = "SELECT * FROM project_master WHERE company =? AND OrganizationId =? AND (created_date between '$startdate' and '$enddate') $swhere";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id,$orgid));	
					$count1=  $query1->rowCount();					
					while($row1 = $query1->fetch()){	
						$res1 = array();
						$res1['title'] = $row1->project_title;
						//$res1['billingsts'] = $row1->Billingsts;
						if($row1->Billingsts!=""){
							if($row1->Billingsts==1)
								$res1['billingsts'] = "Billable";
							elseif($row1->Billingsts==2)
								$res1['billingsts'] = "Non Billable";
						}
						$res1['clientmanager']=Utils::getEmployeeName($row1->ClientManager,$this->db);
						$res1['projectmanager']=Utils::getEmployeeName($row1->owner_id,$this->db);
						$timesheet[]=$res1;
					}
					$res['totalproject']=$count1;
					$res['timesheet']= $timesheet;
					$data[]=$res;
				}
			}else {
				$status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result['data']=$data;
		$result['startdate']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		if(isset($_POST['startdate']) && isset($_POST['enddate']))	{
			return $result;
		}else{
			return $data;
		}
	}
     public function gettaskstartdate($startdate,$enddate){
		$result=array(); $count=0;$completed=0;
		if($startdate!="" && $enddate!=""){
		$sql="select Distinct(projectid) from task_master where ((fromdate between '$startdate' and '$enddate') or (todate between '$startdate' and '$enddate'))";
		$query=$this->db->prepare($sql);
		$query->execute();
		$count = $query->rowcount();$projectid="";
			while($row= $query->fetch()){
				if($projectid=="")
				$projectid=$row->projectid;
			else
				$projectid .=','.$row->projectid;
			}
			//print($projectid);
				return $projectid;
			
		}
	} 
	public function getEmppro($productid,$empid,$val){
		$result=array(); $count=0;$completed=0;
		if($empid!="" && $productid!=""){
		$sql="select * from project_master where id =? and assignto=?";
		$query=$this->db->prepare($sql);
		$query->execute(array($productid,$empid));
		$count = $query->rowcount();
			while($row= $query->fetch()){
			if($row->taskstatus==2){
					$completed++;
				}
			}
			if($val ==1){
				return $completed;
			}else{
				return $count;
			}
		}
	}
	public function getempteam($id) {
	$count=0; $data= array(); $status=false; $successMsg=""; $errorMsg=""; $result=array();
		$orgid= isset($_SESSION['ubihrm_org_id'])?$_SESSION['ubihrm_org_id']:" ";
		$sql="select * from EmployeeMaster where Department =? and OrganizationId = ?";
		$query=$this->db->prepare($sql);
		$query->execute(array($id,$orgid));
		$count = $query->rowcount();
			while($row= $query->fetch()) {
			  $arr = array();
			  $arr["name"] = $row->FirstName." ".$row->LastName;
			  $arr["id"] = $row->Id;
			  $data[] = $arr;
			  $status = true; 
			}
			if($count == 0){
				$errorMsg="Employee not found by this department";
			}
		  $result['data']= $data;
		  $result['status'] = $status;
		  $result['successMsg'] = $successMsg;
		 $result['errorMsg'] = $errorMsg;
		return $result;
	}
     public function getEmptask($productid,$empid,$val){
		$result=array(); $count=0;$completed=0;
		if($empid!="" && $productid!=""){
		$sql="select * from task_master where projectid =? and assignto=?";
		$query=$this->db->prepare($sql);
		$query->execute(array($productid,$empid));
		$count = $query->rowcount();
			while($row= $query->fetch()){
			if($row->taskstatus==2){
					$completed++;
				}
			}
			if($val ==1){
				return $completed;
			}else{
				return $count;
			}
		}
	}
    public function Update($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $module=is_array($request[3]) ? implode(',',$request[3]): $request[3];
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$rid=$request[7];
		$tabid=$request[10];
		$customsts=$_POST['customsts'];
		try{
		
		$sql1 = "SELECT * FROM ReportMaster WHERE Id <> ? and Name = ? AND ModuleId = ? and TabId = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		
			$query1->execute(array($rid, $request[2], $module, $tabid, $orgid));
			$count1 =  $query1->rowCount();
		
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=REPORT_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "UPDATE ReportMaster SET Name=?, ModuleId = ?, SelectedColumn=?,  SelectedGroupBy=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=?,ReportType=?,TotalColumn=? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				
				
				$cols= "" ;
				$arr = json_decode($request[4]);
				if($arr!=""){
					foreach($arr as $value){
						if($cols==""){
							$cols=$value->name;
						}else{
							$cols=$cols.",".$value->name;
						}
					}
				}
				$query->execute(array($request[2],$module, $cols,  $request[6], $orgid, $mdate, $mid,$request[8],$request[9], $rid ));			
				$count =  $query->rowCount();
				
				//////INSERT FILTER///////////
				
				
				$filterid="0";
				$datefilterid="0";
					$filter = json_decode($_POST['filter'], true); 
					$datefilter = json_decode($_POST['datefilter'], true);
					for($i=0; $i<count($datefilter); $i++){
						$datefilterid .= ",".$datefilter[$i]['id'];
					}
					for($i=0; $i<count($filter); $i++){
						$filterid .= ",".$filter[$i]['id'];
					}
					$filterid .= ",".$datefilterid ;
					$sqlwork = " DELETE FROM ReportFilterMaster WHERE ReportId=? AND Id NOT IN ($filterid)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute(array( $rid));					
					
					
					
					for($i=0; $i<count($datefilter); $i++)
					{
							$record = array();
							$record[0] = $rid;
							$record[1] = $datefilter[$i]['condition1'];
							$record[2] = $datefilter[$i]['column'];
							$record[3] = $datefilter[$i]['condition2'];
							//$record[4] =$datefilter[$i]['textvalue'];
							$temp1=0;
							
								if (strpos($datefilter[$i]['textvalue'],"'AND'") == true)
								{
									$temp=explode("'AND'",$datefilter[$i]['textvalue']);
									
									$temp1=Utils::getDateformat($temp[0])."'AND'".Utils::getDateformat($temp[1]);
									
								}else{
									$temp1=$datefilter[$i]['textvalue'];
								}
							
							$record[4]=$temp1;
							
							$record[5] = "";
							if (strpos($record[2],'.') == true)
							{
								$temp=explode('.',$record[2]);
								$modulename=$temp[0];
								$colname=$temp[1];
								
								$moduleid=$this->getModuleId($modulename,$customsts);
							}else{
								$colname=$record[2];
								$moduleid=$this->getModuleId($module,$customsts);
							}
							
							$sql1="SELECT Id FROM ModuleChild WHERE ColumnName =? AND ModuleId =?";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($colname,$moduleid));
							if($row1= $query1->fetch()){
								$record[5] = $row1->Id;
							}
							$id = $datefilter[$i]['id'];
							
							if($id){
								$sqlfilter = " UPDATE ReportFilterMaster SET ReportId=?, Condition1=?, SelectedColumn=?, Condition2=?, TextValue=?,ModuleChildId=? where Id=?";
								$queryfilter = $this->db->prepare($sqlfilter);
								$queryfilter->execute(array($rid,$datefilter[$i]['condition1'],$datefilter[$i]['column'],$datefilter[$i]['condition2'],$temp1,$record[5], $id));
							}else{
								$sqlfilter = " INSERT INTO ReportFilterMaster (  ReportId, Condition1, SelectedColumn, Condition2, TextValue,ModuleChildId) VALUES (?,?,?,?,?,?)";
								$queryfilter = $this->db->prepare($sqlfilter);
								$queryfilter->execute($record);
							}
					}	
					
					for($i=0; $i<count($filter); $i++)
					{
						
						if($filter[$i]['column'] != "" && $filter[$i]['textvalue'] != ""){
							$record = array();
							$record[0] = $rid;
							$record[1] = $filter[$i]['condition1'];
							$record[2] = $filter[$i]['column'];
							$record[3] = $filter[$i]['condition2'];
							$record[4] = $filter[$i]['textvalue'];
							$record[5] = "";
							if (strpos($record[2],'.') == true)
							{
								$modulename=substr($record[2],0, strpos($record[2], ".") );
								$colname=substr($record[2], strpos($record[2], ".") + 1);
								$moduleid=$this->getModuleId($modulename,$customsts);
							}else{
								$colname=$record[2];
								$moduleid=$this->getModuleId($module,$customsts);
							}
							
							$sql1="SELECT Id FROM ModuleChild WHERE ColumnName =? AND ModuleId =?";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($colname,$moduleid));
							if($row1= $query1->fetch()){
								$record[5] = $row1->Id;
							}
							$id = $filter[$i]['id'];
							
							if($id){
								$sqlfilter = " UPDATE ReportFilterMaster SET ReportId=?, Condition1=?, SelectedColumn=?, Condition2=?, TextValue=?,ModuleChildId=? where Id=?";
								$queryfilter = $this->db->prepare($sqlfilter);
								$queryfilter->execute(array($rid,$filter[$i]['condition1'],$filter[$i]['column'],$filter[$i]['condition2'],$filter[$i]['textvalue'],$record[5], $id));
							}else{
								$sqlfilter = " INSERT INTO ReportFilterMaster (  ReportId, Condition1, SelectedColumn, Condition2, TextValue,ModuleChildId) VALUES (?,?,?,?,?,?)";
								$queryfilter = $this->db->prepare($sqlfilter);
								$queryfilter->execute($record);
							}
							
						}
					}
					
					
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = REPORT_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = REPORT_MODULE_UPDATION_FAILED;
			}
			
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["reportid"] =Utils::encode5t($rid);
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	/**
     * Setter for a ReportMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $module="";
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$tabid=$request[9];
		$mdate = date("Y-m-d H:i:s");
		$rid=0;
		try{
		$module=is_array($request[3]) ? implode(',',$request[3]): $request[3];
		
		
		$sql1 = "SELECT * FROM ReportMaster WHERE Name = ? AND ModuleId = ? and TabId = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		
			$query1->execute(array($request[2],$module, $tabid,$orgid));
			$count1 =  $query1->rowCount();
		
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=REPORT_MODULE_UPDATION_DUPLICATE;
		}else{	
				$cols= "" ;
				$arr = json_decode($request[4]);
				foreach($arr as $value){
					if($cols==""){
						$cols=$value->name;
					}else{
						$cols=$cols.",".$value->name;
					}
				}
		
			$sql = "INSERT INTO ReportMaster (Name, ModuleId, SelectedColumn,  SelectedGroupBy, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,TabId,ReportType,TotalColumn) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			
				
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$module, $cols,  $request[6], $orgid, $mdate, $mid, $mdate, $mid, $mid,$tabid,$request[7],$request[8]));
				$rid=$this->db->lastInsertId();
				
				
				//////INSERT FILTER///////////
				$modulearr=$request[3];
				
					$filter = json_decode($_POST['filter'], true); 
					$datefilter = json_decode($_POST['datefilter'], true);
									
					for($i=0; $i<count($datefilter); $i++)
					{
							$record = array();
							$record[0] = $rid;
							$record[1] = $datefilter[$i]['condition1'];
							$record[2] = $datefilter[$i]['column'];
							$record[3] = $datefilter[$i]['condition2'];
							//$record[4] =$datefilter[$i]['textvalue'];
							$temp1=0;
							
								if (strpos($datefilter[$i]['textvalue'],"'AND'") == true)
								{
									$temp=explode("'AND'",$datefilter[$i]['textvalue']);
									
									$temp1=Utils::getDateformat($temp[0])."'AND'".Utils::getDateformat($temp[1]);
									
								}else{
									$temp1=$datefilter[$i]['textvalue'];
								}
							
							$record[4]=$temp1;
							$customsts=isset($_POST['customsts'])?$_POST['customsts']:0;
							$record[5] = "";
							if (strpos($record[2],'.') == true)
							{
								$temp=explode('.',$record[2]);
								$modulename=$temp[0];
								$colname=$temp[1];
								
								$moduleid=$this->getModuleId($modulename,$customsts);
							}else{
								$colname=$record[2];
								$moduleid=$this->getModuleId($module,$customsts);
							}
							
							$sql1="SELECT Id FROM ModuleChild WHERE ColumnName =? AND ModuleId =?";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($colname,$moduleid));
							if($row1= $query1->fetch()){
								$record[5] = $row1->Id;
							}
							
							$sqlfilter = " INSERT INTO ReportFilterMaster (  ReportId, Condition1, SelectedColumn, Condition2, TextValue,ModuleChildId) VALUES (?,?,?,?,?,?)";
							$queryfilter = $this->db->prepare($sqlfilter);
							$queryfilter->execute($record);
							
					}	
					
				
					for($i=0; $i<count($filter); $i++)
					{	
						
						if($filter[$i]['column']!="" && $filter[$i]['textvalue']!=""){
							$record = array();
							$record[0] = $rid;
							$record[1] = $filter[$i]['condition1'];
							$record[2] = $filter[$i]['column'];
							$record[3] = $filter[$i]['condition2'];
							$record[4] = $filter[$i]['textvalue'];
							$record[5] = "";
							if (strpos($record[2],'.') == true)
							{
								$temp=explode('.',$record[2]);
								$modulename=$temp[0];
								$colname=$temp[1];
								$moduleid=$this->getModuleId($modulename,0);
							}else{
								$colname=$record[2];
								$moduleid=$this->getModuleId($module,0);
							}
							$sql1="SELECT Id FROM ModuleChild WHERE ColumnName =? AND ModuleId =?";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($colname,$moduleid));
							if($row1= $query1->fetch()){
								$record[5] = $row1->Id;
							}
							
								$sqlfilter = " INSERT INTO ReportFilterMaster (  ReportId, Condition1, SelectedColumn, Condition2, TextValue,ModuleChildId) VALUES (?,?,?,?,?,?)";
								$queryfilter = $this->db->prepare($sqlfilter);
								$queryfilter->execute($record);
							
							
						}
					}
				
			
				$count =  $query->rowCount();		
			
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = REPORT_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = REPORT_MODULE_CREATION_FAILED;
			}
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["reportid"] =Utils::encode5t($rid);
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function AddDateRange($request)  {
		
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$rid=$request[0];
		$fromdate=Utils::getDateformat($request[1]);
		$todate=Utils::getDateformat($request[2]);
		try{
			$sqlwork = " DELETE FROM ReportFilterMaster WHERE ReportId=? ";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $rid));
			$sqlfilter = " INSERT INTO ReportFilterMaster (  ReportId, Condition1, SelectedColumn, Condition2, TextValue) VALUES (?,?,?,?,?)";
			$queryfilter = $this->db->prepare($sqlfilter);
			$queryfilter->execute(array($rid,'AND','ApplyDate','between',"$fromdate 'and' $todate"));
			$count =  $queryfilter->rowCount();		
			
			if ($count >= 1) {
			   $status =true;
			   $successMsg = REPORT_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = REPORT_MODULE_CREATION_FAILED;
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["reportid"] =Utils::encode5t($rid);
		$result["fromdate"] =$request[1];
		$result["todate"] =$request[2];
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
	}
	/**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did){
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM ReportMaster WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
		
			$sql = "DELETE FROM ReportFilterMaster WHERE ReportId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
           $status =true;
		   $successMsg = REPORT_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = REPORT_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id,$table) {
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getOtherHead($id, $column)
	{
		$name ="";
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "SELECT $column FROM SalaryOtherHead WHERE HeadCode = :id and OrganizationId=:orgid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id , ':orgid' => $orgid ));
			while($row = $query->fetch())
			{
				$name = $row->$column;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getcurrentsalarymonth($orgid) {
		$name ="";
		$sql = "SELECT SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = :id order by SalaryMonth desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			while($row = $query->fetch())
			{
				$name = $row->SalaryMonth;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getModuleId($id,$sts)
	{
		$name =0;
		$sql = "SELECT * FROM ModuleMaster WHERE ModuleName = :id and ReportSts=1";
		if($sts==1){
			$sql = "SELECT * FROM ModuleMaster WHERE ModuleName = :id ";
		}
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			if($row = $query->fetch())
			{
				$name = $row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getReportSts($id)
	{
		$name ="";
		$sql = "SELECT CustomSts FROM ReportMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->CustomSts;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getEmployeeRating($score,$assobjid,$field)
	{
		$name =0;
		$sql = "SELECT $field FROM AssessmentResult WHERE AssessmentObjectiveId = ? and (? between MinMarks and MaxMarks)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($assobjid,$score));
			while($row = $query->fetch())
			{
				$name = $row->$field;
			}
			if($field=="Rating")
			{
				if($name==0)
				{
					$name=1;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper,$tabid)
	{
		$sTable = 'ReportMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'CreatedDate', 'LastModifiedDate', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid AND TabId = $tabid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$reportsts=$this->getReportSts($aRow->Id);
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete=""; $view ="";
					$reportid=Utils::encode5t($aRow->{$aColumns[$i]});
					
					if($editper && ($reportsts==0 || $reportsts==1) ){
						if($tabid ==1){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editreport/'.$reportid.'" ><i class="fa fa-edit"></i></a>';
						}
						elseif($tabid ==2){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'attendance/editreport/'.$reportid.'" ><i class="fa fa-edit"></i></a>';
						}
						elseif($tabid ==3){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'leave/editreport/'.$reportid.'" ><i class="fa fa-edit"></i></a>';
						}
						elseif($tabid ==4){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editreport/'.$reportid.'" ><i class="fa fa-edit"></i></a>';
						}
						elseif($tabid ==5){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editreport/'.$reportid.'" ><i class="fa fa-edit"></i></a>';
						}
						elseif($tabid ==6){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performance/editreport/'.$reportid.'" ><i class="fa fa-edit"></i></a>';
						}
						elseif($tabid ==7){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'timesheet/editreport/'.$reportid.'" ><i class="fa fa-edit"></i></a>';
						}
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper && $reportsts==0 ){
						
						$delete ='<a onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#confirm" href="#" rel="tooltip"  title="Delete"><i class="fa fa-trash"></i></a>';
												
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
						if($tabid ==1){
							$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'employee/viewreport/'.$reportid.'" ><i class="fa fa-file"></i></a>';
							if($reportsts==7){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'employee/viewcustomreport/'.$reportid.'/1" ><i class="fa fa-file"></i></a>';
							}elseif($reportsts==8){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'employee/viewcustomreport/'.$reportid.'/2" ><i class="fa fa-file"></i></a>';
							}	
						}
						elseif($tabid ==2){
							$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'attendance/viewreport/'.$reportid.'" ><i class="fa fa-file"></i></a>';
							if($reportsts==4 || $reportsts==17 || $reportsts==24 || $reportsts==30 || $reportsts==53){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'" ><i class="fa fa-file"></i></a>';
							}
							
						}
						elseif($tabid ==3){
							$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewreport/'.$reportid.'" ><i class="fa fa-file"></i></a>';
							if($reportsts==3 || $reportsts==2 || $reportsts==10 || $reportsts==11 || $reportsts==12){  
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'" ><i class="fa fa-file"></i></a>';
							}
							/* if($reportsts==3){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/3" ><i class="fa fa-file"></i></a>';
							}
							elseif($reportsts==2){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/2" ><i class="fa fa-file"></a>';
							}
							elseif($reportsts==10){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/10" ><i class="fa fa-file"></a>';
							}
							elseif($reportsts==11){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/11" ><i class="fa fa-file"></a>';
							}
							elseif($reportsts==12){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/12" ><i class="fa fa-file"></a>';
							} */
						}
						elseif($tabid ==4){
							$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'salary/viewreport/'.$reportid.'" ><i class="fa fa-file"></i></a>';
							/* if($reportsts==9){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/9" ><i class="fa fa-file"></i></a>';
							}elseif($reportsts==14){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/14" ><i class="fa fa-file"></i></a>';
							}elseif($reportsts==16){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/16" ><i class="fa fa-file"></i></a>';
							} */
							if($reportsts==9 || $reportsts==14 || $reportsts==16 || $reportsts==29 || $reportsts==30 || $reportsts==31 || $reportsts==33 || $reportsts==34 || $reportsts==35 || $reportsts==36 || $reportsts==37  || $reportsts==38  || $reportsts==39 || $reportsts==41|| $reportsts==57|| $reportsts==58){ 
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'" ><i class="fa fa-file"></i></a>';
							}
						}
						elseif($tabid ==5){
						$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'setup/viewreport/'.$reportid.'" ><i class="fa fa-file"></i></a>';
						}
						elseif($tabid ==6){
							$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'performance/viewreport/'.$reportid.'" ><i class="fa fa-file"></i></a>';
							if($reportsts==13 || $reportsts==15 || $reportsts==29 || $reportsts==44){ 
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'" ><i class="fa fa-file"></i></a>';
							}
							/* if($reportsts==13){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/13" ><i class="fa fa-file"></i></a>';
							}elseif($reportsts==15){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/15" ><i class="fa fa-file"></i></a>';
							} */
						}
						elseif($tabid ==7){
							$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'timesheet/viewreport/'.$reportid.'" ><i class="fa fa-file"></i></a>';
							if($reportsts==18 || $reportsts==19 || $reportsts==20 || $reportsts==21 || $reportsts==22 || $reportsts==23 ){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'" ><i class="fa fa-file"></i></a>';
							}
							/* if($reportsts==19){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/19" ><i class="fa fa-file"></i></a>';
							}
							if($reportsts==20){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/20" ><i class="fa fa-file"></i></a>';
							}
							if($reportsts==21){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/21" ><i class="fa fa-file"></i></a>';
							}
							if($reportsts==22){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/22" ><i class="fa fa-file"></i></a>';
							}
							if($reportsts==23){
								$view = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/23" ><i class="fa fa-file"></i></a>';
							} */
						}
										
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete."&nbsp;&nbsp;|&nbsp;&nbsp;".$view;
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate")
				
				{
					if($aRow->{$aColumns[$i]}=='0000-00-00')
					{
						$row[] = "";
					}else{
						$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				else if($aColumns[$i]=="Name")
				{	
						$reportid=Utils::encode5t($aRow->Id);
						////////////////////////////EMPLOYEE///////////////////////////////////
						if($tabid ==1){
							
							if($reportsts==7){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'employee/viewcustomreport/'.$reportid.'/1" >'.$aRow->{$aColumns[$i]}.'</a>';
							}elseif($reportsts==8){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'employee/viewcustomreport/'.$reportid.'/2" >'.$aRow->{$aColumns[$i]}.'</a>';
							}else{
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'employee/viewreport/'.$reportid.'">'.$aRow->{$aColumns[$i]}.'</a>';
							}	
						}
						/////////////////////////////////ATTENDANCE/////////////////////////////////
						elseif($tabid ==2){
							//if($reportsts==4 || $reportsts==17|| $reportsts==24 || $reportsts==30 || $reportsts==53){ 
							if($reportsts>0){	
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'">'.$aRow->{$aColumns[$i]}.'</a>';	
							}
							else{
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'attendance/viewreport/'.$reportid.'">'.$aRow->{$aColumns[$i]}.'</a>';
							}
						}
						//////////////////////LEAVE//////////////////////////////
						elseif($tabid ==3){
							//if($reportsts==3 || $reportsts==2 || $reportsts==10 || $reportsts==11 || $reportsts==12){ 
							if($reportsts>0){							
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'">'.$aRow->{$aColumns[$i]}.'</a>';	
							}else{
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewreport/'.$reportid.'">'.$aRow->{$aColumns[$i]}.'</a>';
							}
							/* if($reportsts==3){				
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/3" >'.$aRow->{$aColumns[$i]}.'</a>';
							}
							elseif($reportsts==2){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/2" >'.$aRow->{$aColumns[$i]}.'</a>';
							}elseif($reportsts==10){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/10" >'.$aRow->{$aColumns[$i]}.'</a>';
							}
							elseif($reportsts==11){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/11" >'.$aRow->{$aColumns[$i]}.'</a>';
							}
							elseif($reportsts==12){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/12" >'.$aRow->{$aColumns[$i]}.'</a>';
							} */
						} 
						//////////////////// SALARY///////////////////
						elseif($tabid ==4){   
							//if($reportsts==9 || $reportsts==14 || $reportsts==16 || $reportsts==29 || $reportsts==30 || $reportsts==31 || $reportsts==33 || $reportsts==34 || $reportsts==35 || $reportsts==36 || $reportsts==37 || $reportsts==38 || $reportsts==39 || $reportsts==41 ){ 
							if($reportsts>0){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'">'.$aRow->{$aColumns[$i]}.'</a>';	
							}
							
							else{
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'salary/viewreport/'.$reportid.'">'.$aRow->{$aColumns[$i]}.'</a>';
							}
						}
						///////////////////////ORGANIZATION /SETUP/////////////////////////
						elseif($tabid ==5){
							$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'setup/viewreport/'.$reportid.'">'.$aRow->{$aColumns[$i]}.'</a>';
						}
						//////////////////////PERFORMANCE///////////////////////
						elseif($tabid ==6){
							//if($reportsts==13 || $reportsts==15 || $reportsts==29 || $reportsts==44){ 
							if($reportsts>0){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'">'.$aRow->{$aColumns[$i]}.'</a>';	
							}
							else{
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'performance/viewreport/'.$reportid.'">'.$aRow->{$aColumns[$i]}.'</a>';
							}
						}
						///////////////////TIMESHEET///////////////////////
						elseif($tabid ==7){
							//if($reportsts==18 || $reportsts==19 || $reportsts==20 || $reportsts==21 || $reportsts==22 || $reportsts==23 || $reportsts==40|| $reportsts==42|| $reportsts==43 || $reportsts==45 || $reportsts==46 || $reportsts==47 || $reportsts==48 || $reportsts==49){
							if($reportsts>0){	
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/'.$reportsts.'">'.$aRow->{$aColumns[$i]}.'</a>';	
							}
							
							else{
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'timesheet/viewreport/'.$reportid.'">'.$aRow->{$aColumns[$i]}.'</a>';
							}
							/* if($reportsts==18){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/18">'.$aRow->{$aColumns[$i]}.'</a>';
							}elseif($reportsts==19){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/19">'.$aRow->{$aColumns[$i]}.'</a>';
							}elseif($reportsts==20){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/20">'.$aRow->{$aColumns[$i]}.'</a>';
							}elseif($reportsts==21){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/21">'.$aRow->{$aColumns[$i]}.'</a>';
								
							}elseif($reportsts==22){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/22">'.$aRow->{$aColumns[$i]}.'</a>';
							}
							elseif($reportsts==23){
								$row[] = '<a rel="tooltip" title="View" target="_blank" href="'.URL.'leave/viewcustomreport/'.$reportid.'/23">'.$aRow->{$aColumns[$i]}.'</a>';
							}*/
						}
					
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	////////////////// this custom report shows monthly leave summary of all employees in current fiscal year 'Leave Utilized In Current Fiscal'/////////
	public function createLeaveUtilizedTable()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['startdate'])?Utils::getDateformat($_POST['startdate']):"";
		$enddate =  isset($_POST['enddate'])?Utils::getDateformat($_POST['enddate']):"";
		
		if($startdate =="" && $enddate==""){
				$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$division=$row->Division;
					$department=$row->Department; 
					$designation=$row->Designation; 
					$grade=$row->Grade; 
					$religion=$row->Religion; 
					$gender=$row->Gender; 
					$marital=$row->MaritalStatus;
					$workingdays=$row->WorkingDays;
					$workingdays=substr_count($workingdays, '1');
					$halfdays=	substr_count($row->WorkingDays, '2');
					$workingdays=$workingdays+($halfdays * 0.5);
					
					$sql2 = "SELECT * FROM LeaveMaster where OrganizationId = ? order by Name";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($orgid));
					$totalleave=0; $leavedetails=array();
					while($row2=$query2->fetch()){
						
						$divisionflg=true;
						$departmentflg=true; 
						$designationflg=true; 
						$gradeflg=true; $religionflg=true;
						$genderflg=true; $maritalflg=true;
						
						$flg1=1; $totalleave=0; $flg2=0;
						
						$totallevetaken=0;
						if($row2->LeaveUsableSts==1){
								if($row2->DivisionId>0){
									if($row2->DivisionId==$division){
										$divisionflg=true;
									}else{$divisionflg=false;}
								}
								if($row2->DepartmentIds>0){
									if($row2->DepartmentIds==$department){
										$departmentflg=true; 
									}else{$departmentflg=false; }
								}
								if($row2->DesignationIds>0){
									if($row2->DesignationIds==$designation){
										$designationflg=true; 
									}else{$designationflg=false; }
								}
								if($row2->GenderId>0){
									if($row2->GenderId==$gender){
										$genderflg=true;
									}else{$genderflg=false;}
								}
								if($row2->MaritalId>0){
									if($row2->MaritalId==$marital){
										$maritalflg=true;
									}else{$maritalflg=false;}
								}
								if($row2->GradeId>0){
									if($row2->GradeId==$grade){
										$gradeflg=true; 
									}else{$gradeflg=false; }
								}
								if($row2->ReligionId>0){
									if($row2->ReligionId==$religion){
										$religionflg=true; 
									}else{$religionflg=false; }
								}
							}elseif($row2->LeaveUsableSts==2){
								$divisionflg=false;
								$departmentflg=false; 
								$designationflg=false; 
								$gradeflg=false; 
								$genderflg=false; $maritalflg=false;
								$religionflg=false; 
								
								if($row2->EmployeeIds!="")
								{
									$temp = explode(",", $row2->EmployeeIds);
									for($i=0; $i<count($temp); $i++)
									{
										if($row->Id==$temp[$i]){
											$divisionflg=true;
											$departmentflg=true; 
											$designationflg=true; 
											$gradeflg=true; $religionflg=true;
											$genderflg=true; $maritalflg=true;
											break;
										}
										
									}
								}					
							}
							$annual=true;
							if($row2->AnnualLeaveSts==1){
									if($row2->WorkingDays ==$workingdays){
										$annual=true;
									}else{$annual=false;}
							}
							$totalleave=$row2->LeaveDays;
							if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg && $annual && $religionflg)
							{
								$res1=array();
								$res1['leavetype']=$row2->Name;
								$res1['totalleave']=$row2->LeaveDays;
								
								$montharr=array();
								$stdate=$startdate;
								while(date($stdate) <= date($enddate))
								{
									$res2=array(); 
									$res2['month']=Utils::monthdateformatter($stdate);
									$sql1 = "SELECT HalfDaySts FROM EmployeeLeaveChild where EmployeeLeaveId in (select Id from EmployeeLeave where EmployeeId=? and OrganizationId=?) and LeaveTypeId = ? and Month(LeaveDay) = Month(?) and Year(LeaveDay) = Year(?) and Entitled=1";
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($row->Id,$orgid,$row2->Id,$stdate,$stdate));
									$con=$query1->rowCount();
									
									
									$flg=1; $employeeusedleave=0;
									while($row1 = $query1->fetch())
									{
										if($row1->HalfDaySts == 1){
											$employeeusedleave = $employeeusedleave + 0.5;
										}
										else{
											$employeeusedleave++;
										}
									
									}
									
									$res2['usedleave']=$employeeusedleave;
									$montharr[]=$res2;
									$totallevetaken=$totallevetaken+$employeeusedleave;
									$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
									
								}
								$res1['leftleave']=$row2->LeaveDays-$totallevetaken;
								$res1['montharr']=$montharr;
								$leavedetails[]=$res1;
								
							}	
						
						
						
					}
					$res['leavedetails']=$leavedetails;
					$data[]=$res;
					
				}	
						
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result['data']=$data;
		$result['startdate1']=isset($_POST['startdate'])?Utils::monthdateformatter($startdate):$startdate;
		$result['startdate']=isset($_POST['startdate'])?Utils::monthdateformatter($startdate):$startdate;
		$result['enddate1']=isset($_POST['enddate'])?Utils::monthdateformatter($enddate):$enddate;
		$result['enddate']=isset($_POST['enddate'])?Utils::monthdateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['startdate']) && isset($_POST['enddate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}	
	///////////// this custom report generate how much leave are taken by employees month wise and half day leave are also included 'Employee wise monthly summary of Leave taken'////////
	public function createLeaveReport()
	{
		 $result = array(); $swhere =" ";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['startdate'])?Utils::getDateformat($_POST['startdate']):"";
		$enddate =  isset($_POST['enddate'])?Utils::getDateformat($_POST['enddate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		
		$swhere1 =" ";
		if(isset($_POST['division']))
		{
			$swhere1="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere1 =" ";
			}
		}
		try{
		
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $swhere1 order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$stdate=$enddate;
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					$empname=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$empcode=$row->EmployeeCode;
					$flg1=1; $totalleave=0; $flg2=0;
					while(date($stdate) >= date($startdate))
					{
						
						$month=Utils::monthdateformatter($stdate);
						$sql1 = "SELECT * FROM EmployeeLeaveChild where EmployeeLeaveId in (select Id from EmployeeLeave where EmployeeId=? ) and LeaveStatus=2 and HalfDaySts = 0 and Month(LeaveDay) = Month(?) and Year(LeaveDay) = Year(?) order by LeaveDay desc";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($row->Id,$stdate,$stdate));
						$con=$query1->rowCount();
						$totalleave=$totalleave+$con;
						//$monthlytotal=0;
						//$leavedetails=array();
						
						$flg=1;
						while($row1 = $query1->fetch())
						{
							$res1=array();
							$leaveday=Utils::dateformatter($row1->LeaveDay);
							$leavetype=Utils::getName($row1->LeaveTypeId,'LeaveMaster','Name',$this->db);
							$temp=$row1->LeaveStatus;
							if($row1->LeaveDay<date('Y-m-d')){
								$leavests='<span class="label label-info">Utilized</span>';
							}
							else{
								$leavests='<span class="label label-success">Approved</span>';
							}
							//$leavedetails[]=$res1;
							
							
							$swhere.="<tr >";
							if($flg1)
							{
								$swhere.= "<tr><td  colspan='6' style='border: 0px'></td></tr><tr><td  colspan='6' class='bg-danger '><h4>Employee : ".$empcode.' - <b>'.$empname."</b></h4></td></tr>";
								$flg1=0; $flg2=1;
							}	
							if($flg)
							{
								$swhere.= "<td  class='text-center'  rowspan='$con'><h4>".$month."</h4></td><td  class='text-center' rowspan='$con'><h4>$con</h4></td>";
								$flg=0;
							}						
							$swhere.= "<td >$leaveday</td><td >$leavetype</td><td >$leavests</td></tr>";
							
						}
						
						//$res['leavedetails']=$leavedetails;
						//$data[]=$res;
						
						$stdate = date('Y-m-d', strtotime("-1 month, ".date($stdate)));
						
						
							
					}
					if($flg2){
							//$swhere.= "<tr><td  colspan='6' class='bg-success text-left'><b>Total Leave : ".$totalleave."</b></td></tr>";$totalleave=0;
							$flg2=0;
							$stdate=$startdate;
								$flg1=1;  $flg2=0;
							while(date($stdate) <= date($enddate))
							{
								
								$month=Utils::monthdateformatter($stdate);
								$sql1 = "SELECT * FROM EmployeeLeaveChild where EmployeeLeaveId in (select Id from EmployeeLeave where EmployeeId=? ) and HalfDaySts = 1 and Month(LeaveDay) = Month(?) and Year(LeaveDay) = Year(?)";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($row->Id,$stdate,$stdate));
								$con=$query1->rowCount();
								$totalleave=$totalleave+$con;
								//$monthlytotal=0;
								//$leavedetails=array();
								
								$flg=1;
								while($row1 = $query1->fetch())
								{
									$res1=array();
									$leaveday=Utils::dateformatter($row1->LeaveDay);
									$leavetype=Utils::getName($row1->LeaveTypeId,'LeaveMaster','Name',$this->db);
									$temp=$row1->LeaveStatus;
									if($row1->LeaveDay<date('Y-m-d')){
										$leavests='<span class="label label-info">Utilized</span>';
									}
									else{
										$leavests='<span class="label label-success">Approved</span>';
									}
									//$leavedetails[]=$res1;
									
									
									$swhere.="<tr >";
									if($flg1)
									{
										$swhere.= "<tr><td  colspan='6' class='bg-warning text-center'><h4>Half Day Leave</h4></td></tr>";
										$flg1=0; $flg2=1;
									}	
									if($flg)
									{
										$swhere.= "<td  class='text-center'  rowspan='$con'><h4>".$month."</h4></td><td  class='text-center' rowspan='$con'><h4>$con</h4></td>";
										$flg=0;
									}						
									$swhere.= "<td >$leaveday</td><td >$leavetype</td><td >$leavests</td></tr>";
									
								}
								
								//$res['leavedetails']=$leavedetails;
								//$data[]=$res;
								
								$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
								
								
									
							}
							if($totalleave>0){
								$swhere.= "<tr><td  colspan='6' class='bg-success text-left'><b>Total Leave : ".$totalleave."</b></td></tr>";
								$flg2=0;
							}
						}
				}	
						
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$data['data']=$swhere;
		$data['startdate1']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$data['startdate']=isset($_POST['startdate'])?Utils::monthdateformatter($startdate):$startdate;
		$data['enddate1']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$data['enddate']=isset($_POST['enddate'])?Utils::monthdateformatter($enddate):$enddate;
		$data['errorMsg']="No data found";
		$data['status']=true;
		
		if(isset($_POST['startdate']) && isset($_POST['enddate']))
		{
			return $data;
		}
		else{
			return $swhere;
		}
		
	}
	////////////////this custom report generate how much employee completeted task 'Employee wise monthly summary of Timesheet  ////////
	public function TimesheetMonthlyReport()
	{
		 $result = array(); $swhere =" ";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat( $_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		
		$swhere1 =" ";
		if(isset($_POST['division']))
		{
			$swhere1="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere1 =" ";
			}
		}
		try{
		
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where EmployeeId in ($ids) AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate'))) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where OrganizationId =? AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate'))) and OrganizationId =? and DOL='0000-00-00' $swhere1 order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					$empname=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$empcode=$row->EmployeeCode;
					$totalleave=0; $timesheet=array();
					
					//$sql1 = "SELECT * FROM timesheet_master where EmployeeId in (?) AND (timesheetstart >=? OR timesheetend <=?)";
					$sql1="SELECT * FROM timesheet_master where EmployeeId in (?) AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate')) order by timesheetstart";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					$con=$query1->rowCount();
					 $totalday1=0;$totalhour1=0; $totalminute1=0;
					 $totalday=0;$totalhour=0; $totalminute=0;
					
					//$monthlytotal=0;
					//$leavedetails=array();
					while($row1 = $query1->fetch())
					{
						$res1=array();
						///estimated duration///	
						$res1['start_time']=Utils::datetimeformatter($row1->start_time);
						$res1['end_time']=Utils::datetimeformatter($row1->end_time);
						/////actual duration/////
						$res1['timesheetstart']=Utils::datetimeformatter($row1->timesheetstart);
						$res1['timesheetend']=Utils::datetimeformatter($row1->timesheetend);
						if($row1->project_id==0){
						$res1['project_id']="Other";
						}else{
						$res1['project_id']=Utils::getName($row1->project_id,'project_master','project_title',$this->db);
						}
						if($row1->task_id==0){
							$res1['task_id']="Other";
						}
						else{
						$res1['task_id']=Utils::getName($row1->task_id,'task_master','task_title',$this->db);
						}
						$res1['description']=$row1->description;
						 $days1='';$hours1='';$minutes1='';
						$days='';$hours='';$minutes='';
						$start = new DateTime($row1->timesheetstart);
						$since_start1 = $start->diff(new DateTime($row1->timesheetend));
						if($since_start1->d>0){
							$days1=$since_start1->d.' days';
							$totalday1=$totalday1+$since_start1->d;
						}
						
						if($since_start1->h>0){
							$hours1 = $since_start1->h.' hours';
							$totalhour1=$totalhour1+$since_start1->h;
						}
						
						if($since_start1->i>0){
							$minutes1 = $since_start1->i.' minutes';
							$totalminute1=$totalminute1+$since_start1->i;
						}
						$res1['total_time']=$days1.' '.$hours1.' '.$minutes1;
						
						
						$start_date = new DateTime($row1->start_time);
						$since_start = $start_date->diff(new DateTime($row1->end_time));
						if($since_start->d>0){
							$days=$since_start->d.' days';
							$totalday=$totalday+$since_start->d;
						}
						
						if($since_start->h>0){
							$hours = $since_start->h.' hours';
							$totalhour=$totalhour+$since_start->h;
						}
						
						if($since_start->i>0){
							$minutes = $since_start->i.' minutes';
							$totalminute=$totalminute+$since_start->i;
						}
						if($totalhour>24){
							$totalday=$totalday+1;
							$totalhour=$totalhour-24;
						}
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
						if($totalhour1>24){
							$totalday1=$totalday1+1;
							$totalhour1=$totalhour1-24;
						}	
						if($totalminute1>60){
							$totalhour1=$totalhour1+1;
							$totalminute1=$totalminute1-60;
						}	
						$res1['esttotaltime']= $days.' '.$hours.' '.$minutes;
						
						
						
						$timesheet[]=$res1;	
					}
						
						$acttotal_time =$totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
						$esttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
						$res['timesheet']= $timesheet;
						$res['acttotal_time']=$acttotal_time;
						$res['esttotal_time']=$esttotal_time;
						$data[]=$res;
				}
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['todate'])?Utils::dateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
	}
	////////////////Timesheet Monthly ///////////////////
	public function MonthlyReport()
	{
		$result = array(); $swhere =" ";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$currentmonth = isset($_POST['fromdate'])?Utils::getDateformat( $_POST['fromdate']):"";
		if($currentmonth=="")
		$currentmonth = date("Y-m-d");
		//Utils::Trace("this is month in custom report for employee task by month1 ".$currentmonth);
		$swhere1 =" ";
		if(isset($_POST['division']))
		{
			$swhere1="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere1 =" ";
			}
		}
		try{
		
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where EmployeeId in ($ids) AND ((Month(timesheetstart)= Month('$currentmonth') and Year(timesheetstart) = Year('$currentmonth')) or (Month(timesheetend)= Month('$currentmonth')and Year(timesheetstart) = Year('$currentmonth') )) AND OrganizationId=?) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where OrganizationId =? AND ((Month(timesheetstart)= Month('$currentmonth') and Year(timesheetstart) = Year('$currentmonth')) or (Month(timesheetend)= Month('$currentmonth')and Year(timesheetstart) = Year('$currentmonth') ))) and OrganizationId =? and DOL='0000-00-00' $swhere1 order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$orgid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					$empname=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$empcode=$row->EmployeeCode;
					$totalleave=0; $timesheet=array();$timesheet1=array();
					//$sql1 = "SELECT * FROM timesheet_master where EmployeeId in (?) AND (timesheetstart >=? OR timesheetend <=?)";
					$sql1="SELECT * FROM task_master where assignto in (?) AND ((Month(fromdate)= Month('$currentmonth') and Year(fromdate) = Year('$currentmonth')) or (Month(todate)= Month('$currentmonth')and Year(todate) = Year('$currentmonth'))) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					$con=$query1->rowCount();
					if($con>=1){
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					
					$totalday=0;$totalhour=0; $totalminute=0;
					$totalday1=0;$totalhour1=0; $totalminute1=0;
					//$monthlytotal=0;
					//$leavedetails=array();
					while($row1 = $query1->fetch())
					{
						$res1=array();
						///estimated duration///	
						$res1['taskno']=$row1->task_no;
						$res1['tasktitle']=$row1->task_title;
						/////actual duration/////
						$res1['project']=Utils::getName($row1->projectid,'project_master','project_title',$this->db);
						$res1['eststartdate']=Utils::dateformatter($row1->fromdate);
						$res1['estenddate']=Utils::dateformatter($row1->todate);
						$res1['taskstatus']=$row1->taskstatus;
					
						$sql2="SELECT min(timesheetstart) as mindate, max(timesheetend) as maxdate FROM timesheet_master where task_id = ? group by task_id";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($row1->id));
						$con1=$query2->rowCount();
						$mindate="";
						$maxdate="";
						while($row2 = $query2->fetch())
						{
							$maxdate=$row2->maxdate;
							$mindate=$row2->mindate;
						}
						$res1['aststartdate']=$mindate;
						$res1['astenddate']=$maxdate;
						$days='';$hours='';$minutes='';
						$days1='';$hours1='';$minutes1='';
						$start_date = new DateTime($mindate);
						$since_start = $start_date->diff(new DateTime($maxdate));
						
						$start_date1 = new DateTime($row1->fromdate);
						$since_start1 = $start_date1->diff(new DateTime($row1->todate));
						
						if($since_start->d>0){
							$days=$since_start->d.' days';
							$totalday=$totalday+$since_start->d;
						}
						
						if($since_start->h>0){
							$hours = $since_start->h.' hours';
							$totalhour=$totalhour+$since_start->h;
						}
						
						if($since_start->i>0){
							$minutes = $since_start->i.' minutes';
							$totalminute=$totalminute+$since_start->i;
						}
						if($totalhour>24){
							$totalday=$totalday+1;
							$totalhour=$totalhour-24;
						}
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
						
							if($row1->Totalhour!=""){
							$start = explode(":", $row1->Totalhour);
							
								if( $start[0] == ""){
									$hours1 = '00';
								}
								if($start[1] == ""){
									$minutes1 = '00';
								}
								if($start[0] < 9){
									$hours1 = '0'.$start[0];
								}if($start[1] < 9 ){
									$minutes1 = '0'.$start[1];
								}
								if($start[0] && $start[1]){
									$hours1= $start[0];
                    				$minutes1 = $start[1];
								}	
                    			
                    			
                    			$totalminute1=$totalminute1+$minutes1;
                    			$totalhour1=$totalhour1+$hours1;
                    			if($totalhour1 < 9){
									$totalhour1 = '0'.$totalhour1;
								}
								if($totalminute1 < 9)
                    			{
									$totalminute1 = '0'.$totalminute1;
								}if($totalhour1 > 9 && $totalday1 > 9 ){
									$totalminute1=$totalminute1+$minutes1;
                    				$totalhour1=$totalhour1+$hours1;
								}
                    			
                    			
                }
						
						/*
						
							if($totoalhour[0]<=9 && $totoalhour[1]<=9){
                                $row[] = '0'.$totoalhour[0] .' : '.'0'.$totoalhour[1];
                        }else if($totoalhour[0]<=9 && $totoalhour[1]<>9){
                            $row[] = '0'.$totoalhour[0] .' : '.$totoalhour[1];
                        }else if($totoalhour[0]<>9 && $totoalhour[1]<=9){
                            $row[] = $totoalhour[0] .' : '.'0'.$totoalhour[1];
                        }else{
                                $row[] = $totoalhour[0] .' : '.$totoalhour[1];
                        }
						
						
						
						
						
						
						
						
						if($since_start1->d>0){
							$days1=$since_start1->d.' days';
							$totalday1=$totalday1+$since_start1->d;
						}
						
						if($since_start1->h>0){
							$hours1 = $since_start1->h.' hours';
							$totalhour1=$totalhour1+$since_start1->h;
						}
						
						if($since_start1->i>0){
							$minutes1 = $since_start1->i.' minutes';
							$totalminute1=$totalminute1+$since_start1->i;
						}
						if($totalhour1>24){
							$totalday1=$totalday1+1;
							$totalhour1=$totalhour1-24;
						}
						if($totalminute1>60){
							$totalhour1=$totalhour1+1;
							$totalminute1=$totalminute1-60;
						}	*/
							
							    	
										
						$res1['acttotaltime']= $days.' '.$hours.' '.$minutes;
						$res1['esttotaltime']= $hours1.' hours, '.$minutes1.' minutes';
						$timesheet[]=$res1;	
					}
				
						$esttotal_time =$totalhour1.' hours, '.$totalminute1.' minutes';
						$acttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
						$res['timesheet']= $timesheet;
			
						$res['acttotal_time']=$acttotal_time;
						$res['esttotal_time']=$esttotal_time;
						$data[]=$res;
				
					}
				}
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=Utils::monthdateformatter($currentmonth);
		//$result['enddate']=Utils::monthdateformatter($currentmonth);
		$result['errorMsg']="No data found";
		$result['status']=true;
	
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
	}
	
		////////////////Timesheet Monthly for schedule mail ///////////////////
	public function MonthlyReport1($orgid)
	{
		$result = array(); $swhere =" ";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		
		$filscalid="";
		$currentmonth = isset($_POST['fromdate'])?Utils::getDateformat( $_POST['fromdate']):"";
		
		if($currentmonth=="")
			$currentmonth = date("Y-m-d");
		
		$swhere1 =" ";
		if(isset($_POST['division']))
		{
			$swhere1="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere1 =" ";
			}
		}
		try{
			$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where OrganizationId =? AND ((Month(timesheetstart)= Month('$currentmonth') and Year(timesheetstart) = Year('$currentmonth')) or (Month(timesheetend)= Month('$currentmonth')and Year(timesheetstart) = Year('$currentmonth') ))) and OrganizationId =? and DOL='0000-00-00' $swhere1 order by FirstName";
			
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					$empname=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$empcode=$row->EmployeeCode;
					$totalleave=0; $timesheet=array();$timesheet1=array();
					//$sql1 = "SELECT * FROM timesheet_master where EmployeeId in (?) AND (timesheetstart >=? OR timesheetend <=?)";
					$sql1="SELECT * FROM task_master where assignto in (?) AND ((Week(fromdate)= Week('$currentmonth') and Year(fromdate) = Year('$currentmonth')) or (Week(todate)= Week('$currentmonth')and Year(todate) = Year('$currentmonth'))) order by fromdate ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					$con=$query1->rowCount();
					if($con>=1){
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					
					$totalday=0;$totalhour=0; $totalminute=0;
					$totalday1=0;$totalhour1=0; $totalminute1=0;
					//$monthlytotal=0;
					//$leavedetails=array();
					while($row1 = $query1->fetch())
					{
						$res1=array();
						///estimated duration///	
						$res1['taskno']=$row1->task_no;
						$res1['tasktitle']=$row1->task_title;
						/////actual duration/////
						$res1['project']=Utils::getName($row1->projectid,'project_master','project_title',$this->db);
						$res1['eststartdate']=Utils::datetimeformatter($row1->fromdate);
						$res1['estenddate']=Utils::datetimeformatter($row1->todate);
						$res1['taskstatus']=$row1->taskstatus;
						$sql2="SELECT min(timesheetstart) as mindate, max(timesheetend) as maxdate FROM timesheet_master where task_id = ? group by task_id";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($row1->id));
						$con1=$query2->rowCount();
						$mindate="";
						$maxdate="";
						while($row2 = $query2->fetch())
						{
							$maxdate=$row2->maxdate;
							$mindate=$row2->mindate;
						}
						$res1['aststartdate']=$mindate;
						$res1['astenddate']=$maxdate;
						$days='';$hours='';$minutes='';
						$days1='';$hours1='';$minutes1='';
						$start_date = new DateTime($mindate);
						$since_start = $start_date->diff(new DateTime($maxdate));
						
						$start_date1 = new DateTime($row1->fromdate);
						$since_start1 = $start_date1->diff(new DateTime($row1->todate));
						
						if($since_start->d>0){
							$days=$since_start->d.' days';
							$totalday=$totalday+$since_start->d;
						}
						
						if($since_start->h>0){
							$hours = $since_start->h.' hours';
							$totalhour=$totalhour+$since_start->h;
						}
						
						if($since_start->i>0){
							$minutes = $since_start->i.' minutes';
							$totalminute=$totalminute+$since_start->i;
						}
						if($totalhour>24){
							$totalday=$totalday+1;
							$totalhour=$totalhour-24;
						}
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
						
						if($since_start1->d>0){
							$days1=$since_start1->d.' days';
							$totalday1=$totalday1+$since_start1->d;
						}
						
						if($since_start1->h>0){
							$hours1 = $since_start1->h.' hours';
							$totalhour1=$totalhour1+$since_start1->h;
						}
						
						if($since_start1->i>0){
							$minutes1 = $since_start1->i.' minutes';
							$totalminute1=$totalminute1+$since_start1->i;
						}
						if($totalhour1>24){
							$totalday1=$totalday1+1;
							$totalhour1=$totalhour1-24;
						}
						if($totalminute1>60){
							$totalhour1=$totalhour1+1;
							$totalminute1=$totalminute1-60;
						}
										
						$res1['acttotaltime']= $days.' '.$hours.' '.$minutes;
						$res1['esttotaltime']= $days1.' '.$hours1.' '.$minutes1;
						$timesheet[]=$res1;	
					}
				
						$esttotal_time =$totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
						$acttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
						$res['timesheet']= $timesheet;
			
						$res['acttotal_time']=$acttotal_time;
						$res['esttotal_time']=$esttotal_time;
						$data[]=$res;
				
					}
				}
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=Utils::monthdateformatter($currentmonth);
		//$result['enddate']=Utils::monthdateformatter($currentmonth);
		$result['errorMsg']="No data found";
		$result['status']=true;
	
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
	}
		////////////////Daily task assign to employees  ////////
	public function TimesheetDailyReport()
	{
		 $result = array(); $swhere =" ";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat( $_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		
		$swhere1 =" ";
		if(isset($_POST['division']))
		{
			$swhere1="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere1 =" ";
			}
		}
		try{
		
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where EmployeeId in ($ids) AND (curdate() between start_time and end_time)) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where OrganizationId =? AND (curdate() between start_time and end_time)) and OrganizationId =? and DOL='0000-00-00' $swhere1 order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					$empname=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$empcode=$row->EmployeeCode;
					$totalleave=0; $timesheet=array();
					
					//$sql1 = "SELECT * FROM timesheet_master where EmployeeId in (?) AND (timesheetstart >=? OR timesheetend <=?)";
					$sql1="SELECT * FROM timesheet_master where EmployeeId in (?) AND (curdate() between start_time and end_time) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					$con=$query1->rowCount();
					 $totalday1=0;$totalhour1=0; $totalminute1=0;
					 $totalday=0;$totalhour=0; $totalminute=0;
					
					//$monthlytotal=0;
					//$leavedetails=array();
					while($row1 = $query1->fetch())
					{
						$res1=array();
						///estimated duration///	
						$res1['start_time']=Utils::datetimeformatter($row1->start_time);
						$res1['end_time']=Utils::datetimeformatter($row1->end_time);
						/////actual duration/////
						$res1['timesheetstart']=Utils::datetimeformatter($row1->timesheetstart);
						$res1['timesheetend']=Utils::datetimeformatter($row1->timesheetend);
						$res1['project_id']=Utils::getName($row1->project_id,'project_master','project_title',$this->db);
						$res1['task_id']=Utils::getName($row1->task_id,'task_master','task_title',$this->db);
						 $days1='';$hours1='';$minutes1='';
						$days='';$hours='';$minutes='';
						$start = new DateTime($row1->timesheetstart);
						$since_start1 = $start->diff(new DateTime($row1->timesheetend));
						if($since_start1->d>0){
							$days1=$since_start1->d.' days';
							$totalday1=$totalday1+$since_start1->d;
						}
						
						if($since_start1->h>0){
							$hours1 = $since_start1->h.' hours';
							$totalhour1=$totalhour1+$since_start1->h;
						}
						
						if($since_start1->i>0){
							$minutes1 = $since_start1->i.' minutes';
							$totalminute1=$totalminute1+$since_start1->i;
						}
						$res1['total_time']=$days1.' '.$hours1.' '.$minutes1;
						
						
						$start_date = new DateTime($row1->start_time);
						$since_start = $start_date->diff(new DateTime($row1->end_time));
						if($since_start->d>0){
							$days=$since_start->d.' days';
							$totalday=$totalday+$since_start->d;
						}
						
						if($since_start->h>0){
							$hours = $since_start->h.' hours';
							$totalhour=$totalhour+$since_start->h;
						}
						
						if($since_start->i>0){
							$minutes = $since_start->i.' minutes';
							$totalminute=$totalminute+$since_start->i;
						}
						if($totalhour>24){
							$totalday=$totalday+1;
							$totalhour=$totalhour-24;
						}
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
						if($totalhour1>24){
							$totalday1=$totalday1+1;
							$totalhour1=$totalhour1-24;
						}	
						if($totalminute1>60){
							$totalhour1=$totalhour1+1;
							$totalminute1=$totalminute1-60;
						}	
						$res1['esttotaltime']= $days.' '.$hours.' '.$minutes;
						
						
						
						$timesheet[]=$res1;	
					}
						
						$acttotal_time =$totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
						$esttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
						$res['timesheet']= $timesheet;
						$res['acttotal_time']=$acttotal_time;
						$res['esttotal_time']=$esttotal_time;
						$data[]=$res;
				}
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['today']=Utils::dateformatter(date("Y-m-d"));
		
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
	}
	
	////////////////this custom report generate how much employee completeted task 'Employee wise monthly summary of Timesheet  ////////
	public function TimesheetEarlyReport()
	{
		 $result = array(); $swhere =" ";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat( $_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		
		$swhere1 =" ";
		if(isset($_POST['division']))
		{
			$swhere1="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere1 =" ";
			}
		}
		try{
		
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where EmployeeId in ($ids) AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate' )) and (FLOOR(HOUR(TIMEDIFF(end_time,start_time)) / 24)>FLOOR(HOUR(TIMEDIFF(timesheetend,timesheetstart)) / 24))) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where OrganizationId =? AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate' )) and (FLOOR(HOUR(TIMEDIFF(end_time,start_time)) / 24)>FLOOR(HOUR(TIMEDIFF(timesheetend,timesheetstart)) / 24))) and OrganizationId =? and DOL='0000-00-00' $swhere1 order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					$empname=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$empcode=$row->EmployeeCode;
					$totalleave=0; $timesheet=array();
					
					//$sql1 = "SELECT * FROM timesheet_master where EmployeeId in (?) AND (timesheetstart >=? OR timesheetend <=?)";
					$sql1="SELECT * , (TIMESTAMPDIFF(MINUTE,start_time,end_time)-TIMESTAMPDIFF(MINUTE,timesheetstart,timesheetend)) as timediffrent FROM timesheet_master where EmployeeId in (?) AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate')) and (FLOOR(HOUR(TIMEDIFF(end_time,start_time)) / 24)>FLOOR(HOUR(TIMEDIFF(timesheetend,timesheetstart)) / 24))";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					$con=$query1->rowCount();
					 $totalday1=0;$totalhour1=0; $totalminute1=0;
					 $totalday=0;$totalhour=0; $totalminute=0;
					
					//$monthlytotal=0;
					//$leavedetails=array();
					while($row1 = $query1->fetch())
					{
						$res1=array();
						$act=$row1->timediffrent;	
						$res1['day'] = floor ($act / 1440);
						$res1['hour']= floor (($act - $res1['day'] * 1440) / 60);
						$res1['min']= $act - ($res1['day'] * 1440) - ($res1['hour'] * 60);
						//$res1['day']= floor ($act / 24);
						//$res1['hour'] = floor (($act - $res1['day'] * 24));
						
						$res1['start_time']=Utils::datetimeformatter($row1->start_time);
						$res1['end_time']=Utils::datetimeformatter($row1->end_time);
						$res1['timesheetstart']=Utils::datetimeformatter($row1->timesheetstart);
						$res1['timesheetend']=Utils::datetimeformatter($row1->timesheetend);
						$res1['project_id']=Utils::getName($row1->project_id,'project_master','project_title',$this->db);
						$res1['task_id']=Utils::getName($row1->task_id,'task_master','task_title',$this->db);
						 $days1='';$hours1='';$minutes1='';
						$days='';$hours='';$minutes='';
						$start = new DateTime($row1->timesheetstart);
						$since_start1 = $start->diff(new DateTime($row1->timesheetend));
						if($since_start1->d>0){
							$days1=$since_start1->d.' days';
							$totalday1=$totalday1+$since_start1->d;
						}
						
						if($since_start1->h>0){
							$hours1 = $since_start1->h.' hours';
							$totalhour1=$totalhour1+$since_start1->h;
						}
						
						if($since_start1->i>0){
							$minutes1 = $since_start1->i.' minutes';
							$totalminute1=$totalminute1+$since_start1->i;
						}
						$res1['total_time']=$days1.' '.$hours1.' '.$minutes1;
						
						
						$start_date = new DateTime($row1->start_time);
						$since_start = $start_date->diff(new DateTime($row1->end_time));
						if($since_start->d>0){
							$days=$since_start->d.' days';
							$totalday=$totalday+$since_start->d;
						}
						
						if($since_start->h>0){
							$hours = $since_start->h.' hours';
							$totalhour=$totalhour+$since_start->h;
						}
						
						if($since_start->i>0){
							$minutes = $since_start->i.' minutes';
							$totalminute=$totalminute+$since_start->i;
						}
						if($totalhour>24){
							$totalday=$totalday+1;
							$totalhour=$totalhour-24;
						}
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
						if($totalhour1>24){
							$totalday1=$totalday1+1;
							$totalhour1=$totalhour1-24;
						}	
						if($totalminute1>60){
							$totalhour1=$totalhour1+1;
							$totalminute1=$totalminute1-60;
						}	
						$res1['esttotaltime']= $days.' '.$hours.' '.$minutes;
						
						$timesheet[]=$res1;	
					}
						
						$acttotal_time =$totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
						$esttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
						
						$res['timesheet']= $timesheet;
						$res['acttotal_time']=$acttotal_time;
						$res['esttotal_time']=$esttotal_time;
						$data[]=$res;
				}
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['todate'])?Utils::dateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
	}
	
	///////////////////////////////////////////////////////////////////////////////
	public function getEmployeeIncentive($empid, $month)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$result =0;
		$sql = "SELECT IncentiveAmount FROM EmployeeIncentive WHERE OrganizationId=? and EmployeeId = ? and ApplyDate=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid, $empid, $month));
			while($row = $query->fetch())
			{
				$result =$result+$row->IncentiveAmount;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	
	public function getEmployeeLeavedays($empid, $month)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$leavedays=0;
		$sql1 = "Select HalfDaySts,LossOfPay,Entitled,PaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and empleave.LeaveStatus=2 and (empchild.LeaveDay between '$month' and LAST_DAY('$month')) and empleave.OrganizationId = ? and empleave.EmployeeId =?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid));
		while($row1 = $query1->fetch())
		{
			
			if($row1->HalfDaySts==1 && $row1->LossOfPay==1)
				$leavedays=$leavedays+0.5;
			elseif($row1->HalfDaySts==0 && $row1->LossOfPay==1)
				$leavedays=$leavedays+1;
			elseif($row1->PaySts == 2 && $row1->Entitled == 1)
				$leavedays=$leavedays+0.5;
			elseif($row1->PaySts == 1 && $row1->Entitled == 1)
				$leavedays=$leavedays+1;
			elseif($row1->PaySts == 0 && $row1->Entitled == 1)
				$leavedays=$leavedays+1;
		}
		//echo $leavedays;
		return $leavedays;
	}
	
	////////////////this custom report generate how much employee completeted task 'Employee wise monthly summary of Timesheet  ////////
	public function TimesheetDelayReport()
	{
		 $result = array(); $swhere =" ";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat( $_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		
		$swhere1 =" ";
		if(isset($_POST['division']))
		{
			$swhere1="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere1 =" ";
			}
		}
		try{
		
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where EmployeeId in ($ids) AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate' )) and (FLOOR(HOUR(TIMEDIFF(end_time,start_time)) / 24)<FLOOR(HOUR(TIMEDIFF(timesheetend,timesheetstart)) / 24))) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where Id in (select EmployeeId from timesheet_master where OrganizationId =? AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate' )) and (FLOOR(HOUR(TIMEDIFF(end_time,start_time)) / 24)<FLOOR(HOUR(TIMEDIFF(timesheetend,timesheetstart)) / 24))) and OrganizationId =? and DOL='0000-00-00' $swhere1 order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->Id,$this->db);
					$empname=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$empcode=$row->EmployeeCode;
					$totalleave=0; $timesheet=array();
					
					//$sql1 = "SELECT * FROM timesheet_master where EmployeeId in (?) AND (timesheetstart >=? OR timesheetend <=?)";
					$sql1="SELECT * , (TIMESTAMPDIFF(MINUTE,timesheetstart,timesheetend)-TIMESTAMPDIFF(MINUTE,start_time,end_time)) as timediffrent FROM timesheet_master where EmployeeId in (?) AND ((timesheetstart between '$startdate' and '$enddate') or (timesheetend between '$startdate' and '$enddate')) and (FLOOR(HOUR(TIMEDIFF(end_time,start_time)) / 24)<FLOOR(HOUR(TIMEDIFF(timesheetend,timesheetstart)) / 24))";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					$con=$query1->rowCount();
					 $totalday1=0;$totalhour1=0; $totalminute1=0;
					 $totalday=0;$totalhour=0; $totalminute=0;
						
					//$monthlytotal=0;
					//$leavedetails=array();
					while($row1 = $query1->fetch())
					{
						$res1=array();
						$act=$row1->timediffrent;	
						$res1['day'] = floor ($act / 1440);
						$res1['hour']= floor (($act - $res1['day'] * 1440) / 60);
						$res1['min']= $act - ($res1['day'] * 1440) - ($res1['hour'] * 60);	
						$res1['start_time']=Utils::datetimeformatter($row1->start_time);
						$res1['end_time']=Utils::datetimeformatter($row1->end_time);
						$res1['timesheetstart']=Utils::datetimeformatter($row1->timesheetstart);
						$res1['timesheetend']=Utils::datetimeformatter($row1->timesheetend);
						$res1['project_id']=Utils::getName($row1->project_id,'project_master','project_title',$this->db);
						$res1['task_id']=Utils::getName($row1->task_id,'task_master','task_title',$this->db);
						 $days1='';$hours1='';$minutes1='';
						$days='';$hours='';$minutes='';
						$start = new DateTime($row1->timesheetstart);
						$since_start1 = $start->diff(new DateTime($row1->timesheetend));
						if($since_start1->d>0){
							$days1=$since_start1->d.' days';
							$totalday1=$totalday1+$since_start1->d;
						}
						
						if($since_start1->h>0){
							$hours1 = $since_start1->h.' hours';
							$totalhour1=$totalhour1+$since_start1->h;
						}
						
						if($since_start1->i>0){
							$minutes1 = $since_start1->i.' minutes';
							$totalminute1=$totalminute1+$since_start1->i;
						}
						$res1['total_time']=$days1.' '.$hours1.' '.$minutes1;
						
						
						$start_date = new DateTime($row1->start_time);
						$since_start = $start_date->diff(new DateTime($row1->end_time));
						if($since_start->d>0){
							$days=$since_start->d.' days';
							$totalday=$totalday+$since_start->d;
						}
						
						if($since_start->h>0){
							$hours = $since_start->h.' hours';
							$totalhour=$totalhour+$since_start->h;
						}
						
						if($since_start->i>0){
							$minutes = $since_start->i.' minutes';
							$totalminute=$totalminute+$since_start->i;
						}
						if($totalhour>24){
							$totalday=$totalday+1;
							$totalhour=$totalhour-24;
						}
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
						if($totalhour1>24){
							$totalday1=$totalday1+1;
							$totalhour1=$totalhour1-24;
						}	
						if($totalminute1>60){
							$totalhour1=$totalhour1+1;
							$totalminute1=$totalminute1-60;
						}	
						$res1['esttotaltime']= $days.' '.$hours.' '.$minutes;
						$carray1=array();
						$carray2=array();
						preg_match_all('!\d+!', $res1['esttotaltime'], $carray1);
						preg_match_all('!\d+!', $res1['total_time'], $carray2);
						
						if($carray1[0]<$carray2[0]==1)
						{
							$res1['status'] = 1;
						}
						else
						{
							$res1['status'] = 0;
						}
						$timesheet[]=$res1;	
					}
						
						$acttotal_time =$totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
						$esttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
						$res['timesheet']= $timesheet;
						$res['acttotal_time']=$acttotal_time;
						$res['esttotal_time']=$esttotal_time;
						$data[]=$res;
				}
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['todate'])?Utils::dateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
	}
	
	////////////////// this custom report shows monthly leave summary of all employees in current fiscal year 'Annual leave utilization'/////////
	public function EmployeeLeaveHistory()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $leavetype=0;
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['startdate'])?Utils::getDateformat($_POST['startdate']):"";
		$enddate =  isset($_POST['enddate'])?Utils::getDateformat($_POST['enddate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					
					$entitled=0; $carryforward=0; $advance =0; $unpaid=0; 
					$leavetype=$this->getEmpAnnualLeavetype($row->Id,$orgid);
					$res['leavetype']=Utils::getName($leavetype,'LeaveMaster','Name',$this->db);
					$stdate=$startdate;
					while(date($stdate) <= date($enddate))
					{
						
						$sql1 = "SELECT Entitled, HalfDaySts, CarriedForward, Advance, LossOfPay FROM EmployeeLeaveChild where EmployeeLeaveId in (select Id from EmployeeLeave where EmployeeId=? and OrganizationId=?) and LeaveTypeId = ? and Month(LeaveDay) = Month(?) and Year(LeaveDay) = Year(?) ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $row->Id,$orgid, $leavetype,$stdate,$stdate));
						while($row3=$query1->fetch()){
						//	echo $row3->Entitled;
							if($row3->Entitled == 1 && $row3->HalfDaySts == 1){
								$entitled = $entitled + 0.5;
							}
							elseif($row3->Entitled == 1 && $row3->HalfDaySts != 1){
								$entitled++;
							}
							elseif($row3->CarriedForward == 1 && $row3->HalfDaySts == 1 ){
								$carryforward=$carryforward+0.5;
							}
							elseif($row3->CarriedForward == 1 && $row3->HalfDaySts != 1 ){
								$carryforward++;
							}
							elseif($row3->Advance == 1 && $row3->HalfDaySts == 1 ){
								$advance=$advance+0.5;
							}
							elseif($row3->Advance == 1 && $row3->HalfDaySts != 1 ){
								$advance++;
							}
							elseif($row3->LossOfPay == 1 && $row3->HalfDaySts == 1 ){
								$unpaid=$unpaid+0.5;
							}
							elseif($row3->LossOfPay == 1 && $row3->HalfDaySts != 1 ){
								$unpaid++;
							}
											
						}
						$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
					}	
						$res['entitled']=$entitled;
						$res['carryforward']=$carryforward;
						$res['advance']=$advance;
						$res['lossofpay']=$unpaid;
						$data[]=$res;
					
									
				}	
						
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result['data']=$data;
		$result['startdate1']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['startdate']=isset($_POST['startdate'])?Utils::monthdateformatter($startdate):$startdate;
		$result['enddate1']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['enddate']=isset($_POST['enddate'])?Utils::monthdateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}	
	
	////////////////// this custom report shows monthly leave summary of all employees in current fiscal year 'Annual leave utilization'/////////
	public function CalenderDaysAnnaulLeaveEmp($val)
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $leavetype=0;
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['startdate'])?Utils::getDateformat($_POST['startdate']):"";
		$enddate =  isset($_POST['enddate'])?Utils::getDateformat($_POST['enddate']):"";
		
		if($startdate =="" && $enddate==""){
				
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
			
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOJ between '$startdate' and '$enddate' and DOL='0000-00-00' $swhere order by Division,DOJ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOJ between '$startdate' and '$enddate' and DOL='0000-00-00' $swhere order by Division,DOJ";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					
					$leavedays=Utils::getannualleaves($row->Id,$this->db);
					$leavetype=self::getEmpAnnualLeavetype($row->Id,$orgid);
					$used=0; $leavealotted=0; $left=0;
					
					if($leavedays == 30 && $val==11){
						$res=array();
						$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
						$res['empcode']=$row->EmployeeCode;
						$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
						$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
						$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
						$res['empdoj']=Utils::dateformatter($row->DOJ);
						$res['leavetype']=Utils::getName($leavetype,'LeaveMaster','Name',$this->db);
						$start = strtotime($row->DOJ);
						$end = strtotime(date($enddate));
						$days_between = ceil(abs($end - $start) / 86400);
						$leavealotted=floor(($days_between * $leavedays)/365);
						if($days_between > (365*2))
						$leavealotted=$leavedays;
						
						$res['alloted']=$leavealotted;
						$stdate=$row->DOJ;
						while(date($stdate) <= date($enddate))
						{
							$sql1 = "SELECT Entitled,HalfDaySts FROM EmployeeLeaveChild where EmployeeLeaveId in (select Id from EmployeeLeave where EmployeeId=? and OrganizationId=?) and LeaveTypeId = ? and Month(LeaveDay) = Month(?) and Year(LeaveDay) = Year(?) ";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array( $row->Id,$orgid, $leavetype,$stdate,$stdate));
							while($row3=$query1->fetch()){
								if($row3->Entitled == 1 && $row3->HalfDaySts == 1){
									$used = $used + 0.5;
								}
								elseif($row3->Entitled == 1 && $row3->HalfDaySts != 1){
									$used++;
								}
							}
							$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
						}	
						$res['utilized']=$used;
						$res['balance']=$leavealotted-$used;
						$data[]=$res;
					}elseif($leavedays != 30 && $val==12){
						
						$res=array();
						$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
						$res['empcode']=$row->EmployeeCode;
						$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
						$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
						$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
						$res['empdoj']=Utils::dateformatter($row->DOJ);
						$res['leavetype']=Utils::getName($leavetype,'LeaveMaster','Name',$this->db);
						$start = strtotime($row->DOJ);
						$end = strtotime(date($enddate));
						$days_between = floor(abs($end - $start) / 86400);
						$leavealotted=floor(($days_between * $leavedays)/365);
						if($days_between > (365))
						$leavealotted=$leavedays;
						
						$res['alloted']=$leavealotted;
						$stdate=$startdate;
						while(date($stdate) <= date($enddate))
						{
							$sql1 = "SELECT Entitled,HalfDaySts FROM EmployeeLeaveChild where EmployeeLeaveId in (select Id from EmployeeLeave where EmployeeId=? and OrganizationId=?) and LeaveTypeId = ? and Month(LeaveDay) = Month(?) and Year(LeaveDay) = Year(?) ";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array( $row->Id,$orgid, $leavetype,$stdate,$stdate));
							while($row3=$query1->fetch()){
								if($row3->Entitled == 1 && $row3->HalfDaySts == 1){
									$used = $used + 0.5;
								}
								elseif($row3->Entitled == 1 && $row3->HalfDaySts != 1){
									$used++;
								}
							}
							$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
						}	
						$res['utilized']=$used;
						$res['balance']=$leavealotted-$used;
						
						$data[]=$res;
					
					}
					
				}		
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result['data']=$data;
		$result['startdate1']=isset($_POST['startdate'])?Utils::dateformatter($startdate):$startdate;
		$result['startdate']=isset($_POST['startdate'])?Utils::monthdateformatter($startdate):$startdate;
		$result['enddate1']=isset($_POST['enddate'])?Utils::dateformatter($enddate):$enddate;
		$result['enddate']=isset($_POST['enddate'])?Utils::monthdateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}	
	
	////////////////this custom report generate monthly attendance summary of all employees which shows how many time a employee present,absent,late,early and overtime////////
	public function AttendanceMonthlysummary()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$currentmonth = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		if($currentmonth=="")
			$currentmonth = date("Y-m-d");
		$shiftid=isset($_POST['shiftid'])?$_POST['shiftid']:"";
		$shiftid= is_array($shiftid)?implode(',', $shiftid):$shiftid;
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		$swhere4 =" ";
		if(isset($_POST['shiftid']))
		{
			$swhere4 ="AND Id in (select EmployeeId from AttendanceMaster where ShiftId in (".$shiftid.")) ";
			
			if($_POST['shiftid']=="")
			{
				$swhere4 =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere $swhere4 order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $swhere $swhere4 order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName.' - '.$row->EmployeeCode;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$res['empshift']=Utils::getName($row->Shift,'ShiftMaster','Name',$this->db);
					$stdate=$currentmonth;
					$attendancearr=array();
					$time = 0;
					$shifttime = 0;
					$overtime = 0;
					$latehrs=0;
					$earlyhrs=0;
					$res['month']=Utils::monthdateformatter($stdate);
					$sql1 = "SELECT TIME_FORMAT(TIMEDIFF(a.TimeOut, a.TimeIn),'%H:%i') as totaltime,TIME_FORMAT(TIMEDIFF(s.TimeOut, s.TimeIn),'%H:%i') as totalshifttime, TIME_FORMAT(TIMEDIFF(s.TimeOutBreak, s.TimeInBreak),'%H:%i') as breakTime, AttendanceDate, TIME_FORMAT((Overtime),'%H:%i') as otime,a.AttendanceStatus as asts,TIME_FORMAT(a.TimeIn,'%h:%i %p') as timein ,TIME_FORMAT(a.TimeOut,'%h:%i %p') as timeout,a.AttendanceDate as adate,device,a.TimeIn as TimeIn, a.TimeOut as TimeOut,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeInGrace),'%H:%i') as latehrs, TIME_FORMAT(TIMEDIFF(s.TimeIn, a.TimeIn),'%H:%i') as earlyhrs, ((TIME_TO_SEC(s.TimeIn)-TIME_TO_SEC(a.TimeIn))/60 >0) as early  FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?) and AttendanceDate != CURDATE() order by AttendanceDate ";
					//Utils::Trace($sql1." ".$stdate." ".$row->Id);
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id,$stdate,$stdate));
					$con=$query1->rowCount();
					$leave=0; $latecomer=0;$earlycomer=0; $overtime1=0; $undertime=0; $absent=0;$halfday=0; $breakhrs=0;
					while($row1 = $query1->fetch())
					{
						if($row1->asts==1 || $row1->asts==4){
							$timeoff=0;
							if($row1->asts!=4)
							$breakhrs +=$this->explode_time($row1->breakTime);
							else
								$breakhrs +=0;
							//$latehrs +=$this->explode_time($row1->latehrs);
							$timeoff=$this->getTimeoff($row->Id, $row1->adate);
						$isearlytimeoff=$this->isearlyTimeoff($row->Id,$row1->adate,$row1->TimeIn);
						if($isearlytimeoff){
							//$timeoff=$timeoff+$this->getTimeoffearly($row->Id, $row1->adate,$row1->TimeIn);
							$timeoff=0;
						}
						$isearlytimeout=$this->isearlyTimeout($row->Id,$row1->adate,$row1->TimeOut);
						if($isearlytimeout){
							//$timeoff=$timeoff+$this->getTimeofflater($row->Id, $row1->adate,$row1->TimeOut);
							$timeoff=0;
						}
						$otime=$row1->otime;
						if($row1->asts==4){
							$ttime = $this->explode_time($row1->totaltime);
							$otime= $this->second_to_hhmm($ttime - (($this->explode_time($row1->totalshifttime))/2));
						}
							$time =$time + ($this->explode_time($row1->totaltime))-$timeoff;//+$timeoff;
							$overtime1 = $overtime1 + ($this->explode_time($otime))-$timeoff;
							if($row1->asts==4)
							$shifttime +=($this->explode_time($row1->totalshifttime))/2;
							else
							$shifttime +=$this->explode_time($row1->totalshifttime);
						
							if($row1->asts==1){
									if($row1->perc==0){
									$latecomer++;
									$latehrs +=$this->explode_time($row1->latehrs);
								}
							}
						}
						if( $row1->asts==4){
							$halfday++;
						}elseif($row1->asts==6){
							$leave++;
						}elseif($row1->asts==2){
							$absent++;
						}
					}
					//$overtime =$time-$shifttime;
					$overtime = $overtime1;
					$totaltime=$this->second_to_hhmm($time-$breakhrs);
					$totallatehrs=$this->second_to_hhmm($latehrs);
					$totalearlyhrs=$this->second_to_hhmm($earlyhrs);
					$totalshifttime=$this->second_to_hhmm($shifttime-$breakhrs);
					$totalovertime=$this->second_to_hhmm($overtime);
					$totalbreakhrs=$this->second_to_hhmm($breakhrs );
					$totalundertime ="00:00";
					/* if($totalovertime < '00:00'){
						$totalundertime = $totalovertime;
						$totalovertime= "00:00";
					}
					else {
						$totalundertime = "00:00";
						$totalovertime= $totalovertime;
					} */
						//////////////////////////////privious date////////////////
				
                  $priviousmonth = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
				    if($priviousmonth!="")
					{
						$next_month_ts = strtotime("$priviousmonth -1 month");
                        $priviousmonth = date('Y-m-d', $next_month_ts);
					}
		            if($priviousmonth=="")
		         	$priviousmonth = date('Y-m-d', strtotime('last month'));
				
                    $timep = 0;
					$shifttimep = 0;
					$overtimep = 0;
					$latehrsp=0;
					$earlyhrsp=0;
					$stdatep=$priviousmonth;
					$sql3 = "SELECT TIME_FORMAT(TIMEDIFF(a.TimeOut, a.TimeIn),'%H:%i') as totaltime,TIME_FORMAT(TIMEDIFF(s.TimeOut, s.TimeIn),'%H:%i') as totalshifttime, TIME_FORMAT(TIMEDIFF(s.TimeOutBreak, s.TimeInBreak),'%H:%i') as breakTime, AttendanceDate, TIME_FORMAT((Overtime),'%H:%i') as otime,a.AttendanceStatus as asts,TIME_FORMAT(a.TimeIn,'%h:%i %p') as timein ,TIME_FORMAT(a.TimeOut,'%h:%i %p') as timeout,a.AttendanceDate as adate,device,a.TimeIn as TimeIn, a.TimeOut as TimeOut,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeInGrace),'%H:%i') as latehrs, TIME_FORMAT(TIMEDIFF(s.TimeIn, a.TimeIn),'%H:%i') as earlyhrs, ((TIME_TO_SEC(s.TimeIn)-TIME_TO_SEC(a.TimeIn))/60 >0) as early  FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?) order by AttendanceDate ";
					//Utils::Trace($sql1." ".$stdate." ".$row->Id);
					$query2 = $this->db->prepare($sql3);
					$query2->execute(array($row->Id,$stdatep,$stdatep));
					$conp=$query2->rowCount();
					$leavep=0; $latecomerp=0;$earlycomerp=0; $overtimep=0; $undertimep=0; $absentp=0;$halfdayp=0; $breakhrsp=0;
					while($row2 = $query2->fetch())
					{
						if($row2->asts==1 || $row2->asts==4){
							$timeoffp=0;
							if($row2->asts!=4)
							$breakhrsp +=$this->explode_time($row2->breakTime);
							else
								$breakhrsp +=0;
							//$latehrs +=$this->explode_time($row1->latehrs);
							$isearlyp=false;
							$isearlytimeoffp=$this->isearlyTimeoff($row->Id,$row2->adate,$row2->TimeIn);
							if($isearlytimeoffp){
								$timeoffp=$timeoffp+$this->getTimeoffearly($row->Id, $row2->adate,$row2->TimeIn);
							}
							$isearlytimeoutp=$this->isearlyTimeout($row->Id,$row2->adate,$row2->TimeOut);
							if($isearlytimeoutp){
								$timeoffp=$timeoffp+$this->getTimeofflater($row->Id, $row2->adate,$row2->TimeOut);
							}
							$timep =$timep+ ($this->explode_time($row2->totaltime));//+$timeoff;
							if($row2->asts==4)
							$shifttimep +=($this->explode_time($row2->totalshifttime))/2;
							else
							$shifttimep +=$this->explode_time($row2->totalshifttime);
						
							/*if($row2->asts==1){
									if($row2->perc==0){
									$latecomer++;
									$latehrs +=$this->explode_time($row2->latehrs);
								}
							}*/
						}
						/*if( $row2-->asts==4){
							$halfday++;
						}elseif($row2-->asts==6){
							$leave++;
						}elseif($row2-->asts==2){
							$absent++;
						}*/
						
					}
                     $overtimep =$timep-$shifttimep;
					 $totalovertimep=$this->second_to_hhmm($overtimep);
      ///////////////////////////////////////////////////////
					 $resulttime= $overtimep+$overtime;
					 $resulttime=$this->second_to_hhmm($resulttime);

					$res['resulttime']=$resulttime;	
					$res['totaltime']=$totaltime;	
					$res['totallatehrs']=$totallatehrs;
					$res['totalearlyhrs']=$totalearlyhrs;
					$res['halfday']=$halfday;			
					$res['leave']=$leave;			
					$res['absent']=$absent;
					$res['timeoff']=$this->second_to_hhmm($this->getTimeoffmonthly($row->Id,$stdate));			
					$res['totalshifttime']=$totalshifttime;			
					$res['latecomer']=$latecomer;		
					$res['earlycomer']=$earlycomer;						
					$res['undertime']=$totalundertime;			
					$res['overtime']=$totalovertime;			
					$res['overtimep']=$totalovertimep;			
					$res['breaktime']=$totalbreakhrs;
					$data[]=$res;
				}	
			}	
				
			else {
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::monthdateformatter($currentmonth):$currentmonth;
		
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}	
	
	
	public function AttendanceMonthlysummaryBak3jan2019()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$currentmonth = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		if($currentmonth=="")
			$currentmonth = date("Y-m-d");
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName.' - '.$row->EmployeeCode;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$res['empshift']=Utils::getName($row->Shift,'ShiftMaster','Name',$this->db);
					$stdate=$currentmonth;
					$attendancearr=array();
					$time = 0;
					$shifttime = 0;
					$overtime = 0;
					$latehrs=0;
					$earlyhrs=0;
					$res['month']=Utils::monthdateformatter($stdate);
					$sql1 = "SELECT TIME_FORMAT(TIMEDIFF(a.TimeOut, a.TimeIn),'%H:%i') as totaltime,TIME_FORMAT(TIMEDIFF(s.TimeOut, s.TimeIn),'%H:%i') as totalshifttime, TIME_FORMAT(TIMEDIFF(s.TimeOutBreak, s.TimeInBreak),'%H:%i') as breakTime, AttendanceDate, TIME_FORMAT((Overtime),'%H:%i') as otime,a.AttendanceStatus as asts,TIME_FORMAT(a.TimeIn,'%h:%i %p') as timein ,TIME_FORMAT(a.TimeOut,'%h:%i %p') as timeout,a.AttendanceDate as adate,device,a.TimeIn as TimeIn, a.TimeOut as TimeOut,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeInGrace),'%H:%i') as latehrs, TIME_FORMAT(TIMEDIFF(s.TimeIn, a.TimeIn),'%H:%i') as earlyhrs, ((TIME_TO_SEC(s.TimeIn)-TIME_TO_SEC(a.TimeIn))/60 >0) as early  FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?) and AttendanceDate != CURDATE() order by AttendanceDate ";
					//Utils::Trace($sql1." ".$stdate." ".$row->Id);
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id,$stdate,$stdate));
					$con=$query1->rowCount();
					$leave=0; $latecomer=0;$earlycomer=0; $overtime=0; $undertime=0; $absent=0;$halfday=0; $breakhrs=0;
					while($row1 = $query1->fetch())
					{
						if($row1->asts==1 || $row1->asts==4){
							$timeoff=0;
							if($row1->asts!=4)
							$breakhrs +=$this->explode_time($row1->breakTime);
							else
								$breakhrs +=0;
							//$latehrs +=$this->explode_time($row1->latehrs);
							$timeoff=$this->getTimeoff($row->Id, $row1->adate);
						$isearlytimeoff=$this->isearlyTimeoff($row->Id,$row1->adate,$row1->TimeIn);
						if($isearlytimeoff){
							//$timeoff=$timeoff+$this->getTimeoffearly($row->Id, $row1->adate,$row1->TimeIn);
							$timeoff=0;
						}
						$isearlytimeout=$this->isearlyTimeout($row->Id,$row1->adate,$row1->TimeOut);
						if($isearlytimeout){
							//$timeoff=$timeoff+$this->getTimeofflater($row->Id, $row1->adate,$row1->TimeOut);
							$timeoff=0;
						}
							$time =$time + ($this->explode_time($row1->totaltime))-$timeoff;//+$timeoff;
							if($row1->asts==4)
							$shifttime +=($this->explode_time($row1->totalshifttime))/2;
							else
							$shifttime +=$this->explode_time($row1->totalshifttime);
						
							if($row1->asts==1){
									if($row1->perc==0){
									$latecomer++;
									$latehrs +=$this->explode_time($row1->latehrs);
								}
							}
						}
						if( $row1->asts==4){
							$halfday++;
						}elseif($row1->asts==6){
							$leave++;
						}elseif($row1->asts==2){
							$absent++;
						}
					}
					$overtime =$time-$shifttime;
					$totaltime=$this->second_to_hhmm($time-$breakhrs);
					$totallatehrs=$this->second_to_hhmm($latehrs);
					$totalearlyhrs=$this->second_to_hhmm($earlyhrs);
					$totalshifttime=$this->second_to_hhmm($shifttime-$breakhrs);
					$totalovertime=$this->second_to_hhmm($overtime);
					$totalbreakhrs=$this->second_to_hhmm($breakhrs );
					$totalundertime ="00:00";
					/* if($totalovertime < '00:00'){
						$totalundertime = $totalovertime;
						$totalovertime= "00:00";
					}
					else {
						$totalundertime = "00:00";
						$totalovertime= $totalovertime;
					} */
						//////////////////////////////privious date////////////////
				
                  $priviousmonth = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
				    if($priviousmonth!="")
					{
						$next_month_ts = strtotime("$priviousmonth -1 month");
                        $priviousmonth = date('Y-m-d', $next_month_ts);
					}
		            if($priviousmonth=="")
		         	$priviousmonth = date('Y-m-d', strtotime('last month'));
				
                    $timep = 0;
					$shifttimep = 0;
					$overtimep = 0;
					$latehrsp=0;
					$earlyhrsp=0;
					$stdatep=$priviousmonth;
					$sql3 = "SELECT TIME_FORMAT(TIMEDIFF(a.TimeOut, a.TimeIn),'%H:%i') as totaltime,TIME_FORMAT(TIMEDIFF(s.TimeOut, s.TimeIn),'%H:%i') as totalshifttime, TIME_FORMAT(TIMEDIFF(s.TimeOutBreak, s.TimeInBreak),'%H:%i') as breakTime, AttendanceDate, TIME_FORMAT((Overtime),'%H:%i') as otime,a.AttendanceStatus as asts,TIME_FORMAT(a.TimeIn,'%h:%i %p') as timein ,TIME_FORMAT(a.TimeOut,'%h:%i %p') as timeout,a.AttendanceDate as adate,device,a.TimeIn as TimeIn, a.TimeOut as TimeOut,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeInGrace),'%H:%i') as latehrs, TIME_FORMAT(TIMEDIFF(s.TimeIn, a.TimeIn),'%H:%i') as earlyhrs, ((TIME_TO_SEC(s.TimeIn)-TIME_TO_SEC(a.TimeIn))/60 >0) as early  FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?) order by AttendanceDate ";
					//Utils::Trace($sql1." ".$stdate." ".$row->Id);
					$query2 = $this->db->prepare($sql3);
					$query2->execute(array($row->Id,$stdatep,$stdatep));
					$conp=$query2->rowCount();
					$leavep=0; $latecomerp=0;$earlycomerp=0; $overtimep=0; $undertimep=0; $absentp=0;$halfdayp=0; $breakhrsp=0;
					while($row2 = $query2->fetch())
					{
						if($row2->asts==1 || $row2->asts==4){
							$timeoffp=0;
							if($row2->asts!=4)
							$breakhrsp +=$this->explode_time($row2->breakTime);
							else
								$breakhrsp +=0;
							//$latehrs +=$this->explode_time($row1->latehrs);
							$isearlyp=false;
							$isearlytimeoffp=$this->isearlyTimeoff($row->Id,$row2->adate,$row2->TimeIn);
							if($isearlytimeoffp){
								$timeoffp=$timeoffp+$this->getTimeoffearly($row->Id, $row2->adate,$row2->TimeIn);
							}
							$isearlytimeoutp=$this->isearlyTimeout($row->Id,$row2->adate,$row2->TimeOut);
							if($isearlytimeoutp){
								$timeoffp=$timeoffp+$this->getTimeofflater($row->Id, $row2->adate,$row2->TimeOut);
							}
							$timep =$timep+ ($this->explode_time($row2->totaltime));//+$timeoff;
							if($row2->asts==4)
							$shifttimep +=($this->explode_time($row2->totalshifttime))/2;
							else
							$shifttimep +=$this->explode_time($row2->totalshifttime);
						
							/*if($row2->asts==1){
									if($row2->perc==0){
									$latecomer++;
									$latehrs +=$this->explode_time($row2->latehrs);
								}
							}*/
						}
						/*if( $row2-->asts==4){
							$halfday++;
						}elseif($row2-->asts==6){
							$leave++;
						}elseif($row2-->asts==2){
							$absent++;
						}*/
						
					}
                     $overtimep =$timep-$shifttimep;
					 $totalovertimep=$this->second_to_hhmm($overtimep);
      ///////////////////////////////////////////////////////
					 $resulttime= $overtimep+$overtime;
					 $resulttime=$this->second_to_hhmm($resulttime);

					$res['resulttime']=$resulttime;	
					$res['totaltime']=$totaltime;	
					$res['totallatehrs']=$totallatehrs;
					$res['totalearlyhrs']=$totalearlyhrs;
					$res['halfday']=$halfday;			
					$res['leave']=$leave;			
					$res['absent']=$absent;
					$res['timeoff']=$this->second_to_hhmm($this->getTimeoffmonthly($row->Id,$stdate));			
					$res['totalshifttime']=$totalshifttime;			
					$res['latecomer']=$latecomer;		
					$res['earlycomer']=$earlycomer;						
					$res['undertime']=$totalundertime;			
					$res['overtime']=$totalovertime;			
					$res['overtimep']=$totalovertimep;			
					$res['breaktime']=$totalbreakhrs;
					$data[]=$res;
				}	
			}	
				
			else {
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::monthdateformatter($currentmonth):$currentmonth;
		
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}	
	
	////////////////this custom report generate monthly Late hours summary of all employees////////
	public function MonthlySummaryOfLateHours()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$currentmonth = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		if($currentmonth=="")
			$currentmonth = date("Y-m-d");
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName.' - '.$row->EmployeeCode;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$res['empshift']=Utils::getName($row->Shift,'ShiftMaster','Name',$this->db);
					$stdate=$currentmonth;
					$attendancearr=array();
					
					$time = 0;
					$shifttime = 0;
					$overtime = 0;
					$latehrs=0;
					$earlyhrs=0;
					$res['month']=Utils::monthdateformatter($stdate);
					$sql1 = "SELECT TIME_FORMAT(TIMEDIFF(a.TimeOut, a.TimeIn),'%H:%i') as totaltime,TIME_FORMAT(TIMEDIFF(s.TimeOut, s.TimeIn),'%H:%i') as totalshifttime, TIME_FORMAT(TIMEDIFF(s.TimeOutBreak, s.TimeInBreak),'%H:%i') as breakTime, AttendanceDate, TIME_FORMAT((Overtime),'%H:%i') as otime,a.AttendanceStatus as asts,TIME_FORMAT(a.TimeIn,'%h:%i %p') as timein ,TIME_FORMAT(a.TimeOut,'%h:%i %p') as timeout,a.AttendanceDate as adate,device,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeInGrace),'%H:%i') as latehrs, TIME_FORMAT(TIMEDIFF(s.TimeIn, a.TimeIn),'%H:%i') as earlyhrs, ((TIME_TO_SEC(s.TimeIn)-TIME_TO_SEC(a.TimeIn))/60 >0) as early  FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?) order by latehrs";
					//Utils::Trace($sql1." ".$stdate." ".$row->Id);
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id,$stdate,$stdate));
					$con=$query1->rowCount();
					$leave=0; $latecomer=0;$earlycomer=0; $overtime=0; $undertime=0; $absent=0;	$halfday=0;
					while($row1 = $query1->fetch())
					{
						if($row1->asts==1 || $row1->asts==4){
							$timeoff=0;
							//$timeoff=$this->getTimeoff($row->Id, $row1->adate);
							$time +=($this->explode_time($row1->totaltime))-$timeoff;
							if($row1->asts==4)
							$shifttime +=($this->explode_time($row1->totalshifttime))/2;
						else
							$shifttime +=$this->explode_time($row1->totalshifttime);
						
						if($row1->perc==0){
							$latecomer++;
							$latehrs +=$this->explode_time($row1->latehrs);
						}
						if($row1->early==1){
							$earlycomer++;
							$earlyhrs +=$this->explode_time($row1->earlyhrs);
						}
						}
						if( $row1->asts==4){
							$halfday++;
						}elseif($row1->asts==6){
							$leave++;
						}
						
					}
					$overtime =$time-$shifttime;
					$totaltime=$this->second_to_hhmm($time);
					$totallatehrs=$this->second_to_hhmm($latehrs);
					$totalearlyhrs=$this->second_to_hhmm($earlyhrs);
					$totalshifttime=$this->second_to_hhmm($shifttime);
					$totalovertime=$this->second_to_hhmm($overtime);
					$totalundertime ="00:00";
					if($totalovertime < '00:00'){
						$totalundertime = $totalovertime;
						$totalovertime= "00:00";
					}
					else {
						$totalundertime = "00:00";
						$totalovertime= $totalovertime;
					}
						
					$res['totaltime']=$totaltime;	
					$res['totallatehrs']=$totallatehrs;
					$res['totalearlyhrs']=$totalearlyhrs;
					$res['halfday']=$halfday;			
					$res['leave']=$leave;			
					$res['timeoff']=$this->second_to_hhmm($this->getTimeoffmonthly($row->Id,$stdate));			
					$res['totalshifttime']=$totalshifttime;			
					$res['latecomer']=$latecomer;		
					$res['earlycomer']=$earlycomer;						
					$res['undertime']=$totalundertime;			
					$res['overtime']=$totalovertime;			
							
					$data[]=$res;
				}	
			}	
				
			else {
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::monthdateformatter($currentmonth):$currentmonth;
		
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}
	
	////////////////this custom report generate monthly attendance summary of all employees which shows how many time a employee present,absent,late,early and overtime////////
	public function AttendanceSummaryReport()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName.' - '.$row->EmployeeCode;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$res['empshift']=Utils::getName($row->Shift,'ShiftMaster','Name',$this->db);
					$stdate=$startdate;
					$attendancearr=array();
					
					while(date($stdate) <= date($enddate))
					{
						$res1=array(); 
						$latehrs=0;	$earlyhrs=0;
						$res1['month']=Utils::monthdateformatter($stdate);
						$sql1 = "SELECT ((TIME_TO_SEC(a.TimeIn)-TIME_TO_SEC(s.TimeIn))/60 >0) as undertime, ((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc,((TIME_TO_SEC(s.TimeOutGrace)-TIME_TO_SEC(a.TimeOut))/60 >0) as lategracests, AttendanceDate, TIME_TO_SEC(Overtime) as otime,a.AttendanceStatus as asts,TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeInGrace),'%H:%i') as latehrs,TIME_FORMAT(TIMEDIFF( a.TimeOut,s.TimeOut),'%H:%i') as earlyhrs FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($row->Id,$stdate,$stdate));
						$con=$query1->rowCount();
						$present=0; $latecomer=0;$earlycomer=0; $overtime=0; $undertime=0; $absent=0;	$halfday=0; 
						while($row1 = $query1->fetch())
						{
							if($row1->asts==1 || $row1->asts==4){
								$present++;
								if($row1->asts==4){
									$halfday++;
								}if($row1->asts==1){
									if($row1->perc==0){
									 $latecomer++;
									 $latehrs +=$this->explode_time($row1->latehrs);
								}
								 if($row1->lategracests==0){
									  $earlycomer++;
								$earlyhrs +=$this->explode_time($row1->earlyhrs);
							}
							}
								/* if($row1->undertime==0){
									$undertime++;
								} */
								if($row1->otime>0){
									$overtime++;
								}	elseif($row1->otime<0){
									$undertime++;
								}
							}elseif($row1->asts==2){
								$absent++;
							}							
									
						}
						$totallatehrs=$this->second_to_hhmm($latehrs);
						$earlyhrshh=$this->second_to_hhmm($earlyhrs);
						
						$res1['present']=$present;			
						$res1['absent']=$absent;			
						$res1['latecomer']=$totallatehrs;	
						$res1['late']=$latecomer;	
						$res1['early']=$earlycomer;
						$res1['earlyhrs'] = $earlyhrshh;
						$res1['undertime']=$undertime;			
						$res1['overtime']=$overtime;			
						$res1['halfday']=$halfday;			
						$attendancearr[]=$res1;			
						$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
					}
								
					$res['attendancearr']=$attendancearr;
					$data[]=$res;
				}	
				
					
			}else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::monthdateformatter($startdate):$startdate;
		//$result['enddate']=isset($_POST['todate'])?Utils::monthdateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}

	public function AttendanceSummaryReport2()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$empid=isset($_POST['empid'])?$_POST['empid']:"";
		$empid= is_array($empid)?implode(',',$empid):$empid;
		$shiftid=isset($_POST['shiftid'])?$_POST['shiftid']:"";
		$shiftid= is_array($shiftid)?implode(',',$shiftid):$shiftid;
		$startdate1=isset($_POST['startdate'])?$_POST['startdate']:"";
		$swhere1 =" ";
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		if($startdate1 !=""){
			$startdate = date("Y-m-01", strtotime($startdate1));
			$enddate =  date('Y-m-t',strtotime($startdate1));
			$swhere1="AND DOJ <='".$enddate."' And DOJ !='0000-00-00'";

		}
		else{
			// $sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			// $query = $this->db->prepare($sql);
			// $query->execute(array( $orgid, $filscalid ));
			// while($row = $query->fetch()){
				// $startdate = $row->StartDate;
				// $enddate =  date('Y-m-d');
			// }
			$startdate = date("Y-m-01");
			$enddate =  date('Y-m-t');
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		$swhere4 =" ";
		if(isset($_POST['shiftid']))
		{
			$swhere4 ="AND Id in (select EmployeeId from AttendanceMaster where ShiftId in (".$shiftid.")) ";
			
			if($_POST['shiftid']=="")
			{
				$swhere4 =" ";
			}
		}
		$swhere2 =" ";
		if(isset($_POST['empid']))
		{
			$swhere2="AND Id in (".$empid.")";
			if($_POST['empid']=="")
			{
				$swhere2 =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere1 $swhere $swhere4 order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? $swhere2 and  DOL='0000-00-00' $swhere1 $swhere $swhere4 order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName.' - '.$row->EmployeeCode;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$res['empshift']=Utils::getName($row->Shift,'ShiftMaster','Name',$this->db);
					$stdate=$startdate;
					$attendancearr=array();
				
					while(date($stdate) <= date($enddate))
					{
						$res1=array(); 
						$latehrs=0;	$earlyhrs=0;
						$res1['month']=Utils::monthdateformatter($stdate);
						$sql1 = "SELECT ((TIME_TO_SEC(a.TimeIn)-TIME_TO_SEC(s.TimeIn))/60 >0) as undertime, TimeInGrace,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0)as perc,((TIME_TO_SEC(s.TimeOutGrace)-TIME_TO_SEC(a.TimeOut))/60 >0) as lategracests, AttendanceDate, a.TimeIn, TIME_TO_SEC(Overtime) as otime,a.AttendanceStatus as asts,TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeInGrace),'%H:%i') as latehrs,TIME_FORMAT(TIMEDIFF( s.TimeOutGrace,a.TimeOut),'%H:%i') as earlyhrs,a.TimeOut FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($row->Id,$stdate,$stdate));
						$con=$query1->rowCount();
						$present=0; $latecomer=0;$earlycomer=0; $overtime=0; $undertime=0; $absent=0;	$halfday=0; 
						$latecomerarr=array();
						$earlygoingarr=array();
						$absenteedatearr=array();
						$halfdaydatearr=array();

						while($row1 = $query1->fetch())
						{
							if($row1->asts==1 || $row1->asts==4){
								$present++;
								if($row1->asts==4){
									$res6=array();
									$halfday++;
									$res6['halfdaydate']=Utils::dateformatter($row1->AttendanceDate);
									$halfdaydatearr[] = $res6;
								}if($row1->asts==1){
									$isearlytimeoff=$this->isearlyTimeoff1($row->Id,$row1->AttendanceDate,$row1->TimeIn);
									if($row1->perc == 0 && $row1->latehrs !='00:00' && $isearlytimeoff!=1){
										
									$res3=array();
									 $latecomer++;
									 $latehrs +=$this->explode_time($row1->latehrs);
									 $res3['latecomerdate']=Utils::dateformatter($row1->AttendanceDate);
									 $res3['TimeIn']=date('h:i',strtotime($row1->TimeIn));
									 $latecomerarr[]=$res3;	

									}
																												$isearlyTimeout=$this->isearlyTimeout1( 
									$row->Id, $row1->AttendanceDate, $row1->
									TimeOut);	

									if($row1->lategracests==1 && $row1->TimeOut!='00:00:00' && $isearlyTimeout!=1){
										$res4=array();
										$earlycomer++;
										$earlyhrs +=$this->explode_time($row1->earlyhrs);
										$res4['earlygoingdate']=Utils::dateformatter($row1->AttendanceDate);
										$res4['TimeOut']=date('h:i',strtotime($row1->TimeOut));
										$earlygoingarr[] = $res4;
									}
								}
								/* if($row1->undertime==0){
									$undertime++;
								} */
								if($row1->otime>0){
									$overtime++;
								}	elseif($row1->otime<0){
									$undertime++;
								}
							}elseif($row1->asts==2){
								$res5=array();
								$absent++;
								$res5['absenteedate']=Utils::dateformatter($row1->AttendanceDate);
								$absenteedatearr[] = $res5;
							}							
									
						}
						$totallatehrs=$this->second_to_hhmm($latehrs);
						$earlyhrshh=$this->second_to_hhmm($earlyhrs);
						
						$res1['present']=$present;			
						$res1['absent']=$absent;			
						$res1['latecomer']=$totallatehrs;	
						$res1['late']=$latecomer;	
						$res1['early']=$earlycomer;
						$res1['earlyhrs'] = $earlyhrshh;
						$res1['undertime']=$undertime;			
						$res1['overtime']=$overtime;			
						$res1['halfday']=$halfday;	
						$res1['latecomerarr']=$latecomerarr;			
						$res1['earlygoingarr']=$earlygoingarr;
						$res1['absenteedatearr']=$absenteedatearr;			
						$res1['halfdaydatearr']=$halfdaydatearr;			
						
						
						$attendancearr[]=$res1;			
						$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
					}
								
					$res['attendancearr']=$attendancearr;
					$data[]=$res;
				}	
				
					
			}else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=Utils::dateformatter($startdate);
		$result['startdate1']=Utils::monthdateformatter($startdate);
		$result['enddate']=Utils::dateformatter($enddate);
		/* if($startdate1 =="")
		{ 
			$result['fiscalstartdate']=Utils::monthdateformatter($startdate);
			$result['fiscalenddate']=Utils::monthdateformatter($enddate);

		} */
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['startdate']) && isset($_POST['enddate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}
	////////////////this custom report generate monthly Late hours summary of all employees which shows per day Late hours with total time ////////
	public function DateWiseLateHours()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['startdate'])?$_POST['startdate']:"";
		$enddate = isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
			$startdate = date("Y-m-d");
		if($enddate=="")
		$enddate = date("Y-m-d");
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' and Id in (select EmployeeId from AttendanceMaster where (AttendanceDate between '$startdate' and '$enddate') ) $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' and Id in (select EmployeeId from AttendanceMaster where (AttendanceDate between '$startdate' and '$enddate')) $swhere order by FirstName ";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName.' - '.$row->EmployeeCode;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$res['empshift']=Utils::getName($row->Shift,'ShiftMaster','Name',$this->db);
					$shifttimein=Utils::getName($row->Shift,'ShiftMaster','TimeIn',$this->db);
					$shifttimeout=Utils::getName($row->Shift,'ShiftMaster','TimeOut',$this->db);
					$res['shifttimein'] = date("g:i a", strtotime($shifttimein));
					$res['shifttimeout'] = date("g:i a", strtotime($shifttimeout));
					$brktime="";				
					$attendancearr=array();
					$time = 0;
					$shifttime = 0;
					$overtime = 0;
					$totallatehrs=0;
					$totalearlyhrs=0;
					$totaltime=0;
					$totalshifttime=0;
					$totalovertimestring=0;
					$sql1 = "SELECT TIME_FORMAT(TIMEDIFF(a.TimeOut, a.TimeIn),'%H:%i') as totaltime,TIME_FORMAT(TIMEDIFF(s.TimeOut, s.TimeIn),'%H:%i') as totalshifttime, TIME_FORMAT(TIMEDIFF(s.TimeOutBreak, s.TimeInBreak),'%H:%i') as breakTime, AttendanceDate, TIME_FORMAT((Overtime),'%H:%i') as otime,a.AttendanceStatus as asts,TIME_FORMAT(a.TimeIn,'%h:%i %p') as timein ,TIME_FORMAT(a.TimeOut,'%h:%i %p') as timeout,a.AttendanceDate as adate,device,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc,((TIME_TO_SEC(s.TimeOutGrace)-TIME_TO_SEC(a.TimeOut))/60 >0) as lategracests,TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeIn),'%H:%i') as latehrs ,TIME_FORMAT(TIMEDIFF( a.TimeOut,s.TimeOut),'%H:%i') as earlyhrs, a.TimeIn as TimeIn, a.TimeOut as TimeOut FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  (AttendanceDate between '$startdate' and '$enddate')  order by AttendanceDate ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					$con=$query1->rowCount();
					while($row1 = $query1->fetch())
					{
						$latehrs=0;
						$earlyhrs=0;
						$res1=array();	
						 if($row1->perc==0){
							
						if($row1->asts==1){
							$res1['status'] = "P";
						
						$res1['sts'] = $row1->asts;						
						$res1['date'] = Utils::dateformatter($row1->adate);
						$timeoff=$this->getTimeoff($row->Id, $row1->adate);
						$res1['timeoff'] =($timeoff!=0)?$this->second_to_hhmm($timeoff):"-";
						//Utils::Trace($timeoff);
						$res1['device'] = $row1->device;
						$brktime=$res1['breakTime'] = $row1->breakTime;
						if($row1->asts==1 || $row1->asts==4)
						$res1['overtime'] = $row1->otime;
						else
						$res1['overtime'] = "00:00";
						if($row1->asts==1){
							 if($row1->perc==0){
								$latehrs =$this->explode_time($row1->latehrs);
							}
							 if($row1->lategracests==0){
								$earlyhrs =$this->explode_time($row1->earlyhrs);
							}
						}
						
						//$latehrs =$this->explode_time($row1->latehrs);
						$totallatehrs+=$latehrs;
						$totalearlyhrs+=$earlyhrs;
						
						$latehrshh=$this->second_to_hhmm($latehrs);
						$res1['latehrs'] = $latehrshh;
						
						$earlyhrshh=$this->second_to_hhmm($earlyhrs);
						$res1['earlyhrs'] = $earlyhrshh;
						
						$res1['totaltime'] = "00:00";
						$res1['totalshifttime'] = "00:00";
						$res1['timein'] = "-";
						$res1['timeout'] = "-";	
						if($row1->asts==1 || $row1->asts==4){
							$res1['totalshifttime'] = $row1->totalshifttime;
							
							if($row1->asts==4){
							$res1['totaltime'] = $this->explode_time($row1->totaltime);
							$res1['overtime'] = $this->second_to_hhmm($res1['totaltime'] - (($this->explode_time($res1['totalshifttime'])-$this->explode_time($brktime))/2));
							}
							else
							$res1['totaltime'] = $this->explode_time($row1->totaltime)-$this->explode_time($row1->breakTime);//-$timeoff;
							$res1['totaltime'] = $this->second_to_hhmm($res1['totaltime']);
							//$res1['totalshifttime'] = $row1->totalshifttime;
							$res1['timein'] = ($row1->timein=="00:00:00")?"-":$row1->timein;
							$res1['timeout'] = ($row1->timeout=="00:00:00")?"-":$row1->timeout;
						}
						
						if($row1->timein=="00:00:00" || $row1->timeout=="00:00:00")
							$res1['totaltime'] = "00:00";
							$timeoff=0;
							//$latehrs +=$this->explode_time($row1->latehrs);
							$isearly=false;
							$isearlytimeoff=$this->isearlyTimeoff($row->Id,$row1->adate,$row1->TimeIn);
							if($isearlytimeoff){
								$timeoff=$timeoff+$this->getTimeoffearly($row->Id, $row1->adate,$row1->TimeIn);
							}
							$isearlytimeout=$this->isearlyTimeout($row->Id,$row1->adate,$row1->TimeOut);
							if($isearlytimeout){
								$timeoff=$timeoff+$this->getTimeofflater($row->Id, $row1->adate,$row1->TimeOut);
							}
						$time +=$this->explode_time($res1['totaltime']);//+$timeoff;
						if($row1->asts==4)
							$shifttime +=($this->explode_time($row1->totalshifttime)-$this->explode_time($brktime))/2;
						elseif($row1->asts==1)
							$shifttime +=$this->explode_time($res1['totalshifttime'])-$this->explode_time($brktime);
						else
							$shifttime +=$this->explode_time($res1['totalshifttime']);
						//commented because overtime is not entered exact//
						//$overtime +=$this->explode_time($res1['overtime']);
						$overtime =$time-$shifttime;
						$totaltime=$this->second_to_hhmm($time);
						$totalshifttime=$this->second_to_hhmm($shifttime);
						$totalovertime=$this->second_to_hhmm($overtime);
						if($totalovertime < '00:00')
						{
							$totalovertimestring = "Total Undertime ".$totalovertime;
						}
						else{
							$totalovertimestring = "Total Overtime ".$totalovertime;
						}
						//Utils::Trace($totalovertime);
						$attendancearr[]=$res1;	
						}
						 }//perc
					}//while
					
					$res['breaktime'] = $brktime;
					$totallatehrshh=$this->second_to_hhmm($totallatehrs);
					$res['totallatehrs'] = $totallatehrshh;
					$res['attendancearr']=$attendancearr;
					$res['total']=$totaltime;
					$res['totalshifttime']=$totalshifttime;
					$res['totalovertime']=$totalovertimestring;
					//$res['shifttotal']=$totaltime;
					$data[]=$res;
				}	
				
					
			}	
						
			
			else {
				
			   $status =false;
			   $errorMsg = "No record Found";
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=Utils::dateformatter($startdate);
		$result['enddate']=Utils::dateformatter($enddate);
		$result['startdate1']=$startdate;
		$result['enddate1']=$enddate;
		$result['errorMsg']=$errorMsg;
		$result['status']=$status;
		
		return $result;
	}	
	////////////////this custom report generate monthly attendance summary of all employees which shows per day attendance with total time ,overtime////////
	public function AttendanceMonthlyReport()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
		//$swhere="and LeaveDay Between $from and $to";
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$currentmonth = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		if($currentmonth=="")
		 $currentmonth = date("Y-m-d");
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		$shiftid=isset($_POST['shiftid'])?$_POST['shiftid']:"";
		$shiftid= is_array($shiftid)?implode(',', $shiftid):$shiftid;
		$empid=isset($_POST['empid'])?$_POST['empid']:"";
		$empid= is_array($empid)?implode(',', $empid):$empid;
		
		$swhere2 ="Id in ($ids) ";
		
		if(isset($_POST['empid']))
		{
			$swhere2=" Id in (".$empid.")";
			
			if($_POST['empid']=="")
			{
				$swhere2 =" ";
			}
		}
		$swhere4 =" ";
		if(isset($_POST['shiftid']))
		{
			$swhere4 ="and ShiftId in (".$shiftid.")";
			
			if($_POST['shiftid']=="")
			{
				$swhere4 =" ";
			}
		}
		$swhere3=" ";
		if(isset($_POST['empid']))
		{
			 if($_POST['empid']=="" && ($hrsts==1 || $sts==1))
			{
				$swhere3 ="  ";
			}else if( ($hrsts==1 || $sts==1))
			{
				$swhere3 =" EmployeeId in (".$empid.") and";  
			}
		}
		try{
			
			
			$sql = "SELECT * FROM EmployeeMaster Where $swhere2 and OrganizationId =? and DOL='0000-00-00' and Id in (select EmployeeId from AttendanceMaster where Month(AttendanceDate) = Month('$currentmonth') and Year(AttendanceDate) = Year('$currentmonth') and AttendanceDate!=CURDATE() $swhere4 ) $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
			 $sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' and Id in (select EmployeeId from AttendanceMaster where $swhere3  Month(AttendanceDate) = Month('$currentmonth') and Year(AttendanceDate) = Year('$currentmonth') and AttendanceDate!=CURDATE() $swhere4 )  $swhere order by FirstName ";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			 $count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName.' - '.$row->EmployeeCode;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$res['empshift']=Utils::getName($row->Shift,'ShiftMaster','Name',$this->db);
					$shifttimein=Utils::getName($row->Shift,'ShiftMaster','TimeIn',$this->db);
					$shifttimeout=Utils::getName($row->Shift,'ShiftMaster','TimeOut',$this->db);
					$res['shifttimein'] = date("g:i a", strtotime($shifttimein));
					$res['shifttimeout'] = date("g:i a", strtotime($shifttimeout));
					$brktime="";
					$attendancearr=array();
					$time = 0;
					$shifttime = 0;
					$overtime = 0;
					$totallatehrs=0;
					$totalearlyhrs=0;
					$totaltime=0;
					$totalshifttime=0;
					$totalovertimestring=0;
					$sql1 = "SELECT TIME_FORMAT(TIMEDIFF(a.TimeOut, a.TimeIn),'%H:%i') as totaltime,TIME_FORMAT(TIMEDIFF(s.TimeOut, s.TimeIn),'%H:%i') as totalshifttime, TIME_FORMAT(TIMEDIFF(s.TimeOutBreak, s.TimeInBreak),'%H:%i') as breakTime, AttendanceDate, TIME_FORMAT((Overtime),'%H:%i') as otime,a.AttendanceStatus as asts,TIME_FORMAT(a.TimeIn,'%h:%i %p') as timein ,TIME_FORMAT(a.TimeOut,'%h:%i %p') as timeout,a.AttendanceDate as adate,device,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 <0) as perc,((TIME_TO_SEC(s.TimeOutGrace)-TIME_TO_SEC(a.TimeOut))/60 <0) as lategracests,TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeIn),'%H:%i') as latehrs ,TIME_FORMAT(TIMEDIFF( a.TimeOut,s.TimeOut),'%H:%i') as earlyhrs, a.TimeIn as TimeIn, a.TimeOut as TimeOut, s.TimeOutBreak as TimeOutBreak,a.remarks as remarks FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?)  order by AttendanceDate ";
					
					///////////and AttendanceDate!=CURDATE()
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id,$currentmonth,$currentmonth));
					$con=$query1->rowCount();
					while($row1 = $query1->fetch())
					{
						$latehrs=0;
						$earlyhrs=0;
						$res1=array();	
						if($row1->asts==1){
							$res1['status'] = "P";
						}elseif($row1->asts==2){
							$res1['status'] = "A";
						}elseif($row1->asts==4){
							$res1['status'] = "H";
						}elseif($row1->asts==3){
							$res1['status'] = "W";
						}elseif($row1->asts==6){
							$res1['status'] = "L";
						}
						elseif($row1->asts==7){
							$res1['status'] = "CO";
						}
						elseif($row1->asts==8){
							$res1['status'] = "WH";
						}
						$res1['sts'] = $row1->asts;						
						$res1['date'] = Utils::dateformatter($row1->adate);
						$timeoff=$this->getTimeoff($row->Id, $row1->adate);
						$res1['timeoff'] =($timeoff!=0)?$this->second_to_hhmm($timeoff):"-";
						$isearlytimeoff=$this->isearlyTimeoff($row->Id,$row1->adate,$row1->TimeIn);
						if($isearlytimeoff){
							//$timeoff=$timeoff+$this->getTimeoffearly($row->Id, $row1->adate,$row1->TimeIn);
							$timeoff=0;
						}
						$isearlytimeout=$this->isearlyTimeout($row->Id,$row1->adate,$row1->TimeOut);
						if($isearlytimeout){
							//$timeoff=$timeoff+$this->getTimeofflater($row->Id, $row1->adate,$row1->TimeOut);
							$timeoff=0;
						}
						
						//Utils::Trace($timeoff);
						$res1['device'] = $row1->device;
						$res1['remarks'] = $row1->remarks;
						$brktime=$res1['breakTime'] = $row1->breakTime;
						if($row1->asts==1 || $row1->asts==4)
						$res1['overtime'] = $row1->otime;
						else
						$res1['overtime'] = "-";
						
						if($row1->asts==1){
							// if($row1->perc==0){
								$latehrs =$this->explode_time($row1->latehrs);
								//echo $row1->latehrs;
							//}
							//if($row1->lategracests==0){
								$earlyhrs =$this->explode_time($row1->earlyhrs);
							//}
						}
						
						
						//$latehrs =$this->explode_time($row1->latehrs);
						$totallatehrs+=$latehrs;
						$totalearlyhrs+=$earlyhrs;
						
						$latehrshh=$this->second_to_hhmm($latehrs);
						//Utils::Trace($latehrshh);
						$res1['latehrs'] = $latehrshh;
						
						$earlyhrshh=$this->second_to_hhmm($earlyhrs);
					//	echo$earlyhrshh;
						$res1['earlyhrs'] = "-";
						
						$res1['totaltime'] = "00:00";
						$res1['totalshifttime'] = "00:00";
						$res1['timein'] = "-";
						$res1['timeout'] = "-";	
						//if($row1->asts==1 || $row1->asts==4){
						if($row1->TimeIn!="00:00:00" && $row1->TimeOut!="00:00:00"){
							if($row1->asts==1 || $row1->asts==4){
								$res1['earlyhrs'] = $earlyhrshh;
								$res1['totalshifttime'] = $row1->totalshifttime;
							
								if($row1->asts==4){
									$res1['totaltime'] = $this->explode_time($row1->totaltime);
									$res1['overtime'] = $this->second_to_hhmm($res1['totaltime'] - (($this->explode_time($res1['totalshifttime']))/2));
								}
								else{
									$res1['totaltime'] = $this->explode_time($row1->totaltime)-$this->explode_time($row1->breakTime)-$timeoff;
									//$res1['overtime'] = $this->second_to_hhmm($res1['totaltime'] - (($this->explode_time($res1['totalshifttime']))-$this->explode_time($row1->breakTime)));
								}
								$res1['totaltime'] = $this->second_to_hhmm($res1['totaltime']);
							}
							
							//$res1['totalshifttime'] = $row1->totalshifttime;
							
						}
						$res1['timein'] = ($row1->TimeIn=="00:00:00")?"-":$row1->timein;
						$res1['timeout'] = ($row1->TimeOut=="00:00:00")?"-":$row1->timeout;
						if($row1->TimeIn=="00:00:00" || $row1->TimeOut=="00:00:00"){
							$res1['totaltime'] = "00:00";
							$timeoff=0;
							//$latehrs +=$this->explode_time($row1->latehrs);
							$isearly=false;
						}	
						$time +=$this->explode_time($res1['totaltime']);
						if($row1->asts==4){
							
							$shifttime +=($this->explode_time($row1->totalshifttime))/2;//-$this->explode_time($brktime))/2;
						}
						elseif($row1->asts==1){
						
							$shifttime +=$this->explode_time($res1['totalshifttime'])-$this->explode_time($brktime);
						}
						else{
							$shifttime +=$this->explode_time($res1['totalshifttime']);
						}
						//commented because overtime is not entered exact//
						if($res1['overtime']!="-")
						$overtime = $overtime + $this->explode_time($res1['overtime']) -$timeoff;
						//$overtime =$time-$shifttime;
						$totaltime=$this->second_to_hhmm($time);
						$totalshifttime=$this->second_to_hhmm($shifttime);
						$totalovertime=$this->second_to_hhmm($overtime);
						if($totalovertime < '00:00')
						{
							$totalovertimestring = "Total Undertime ".$totalovertime;
						}
						else{
							$totalovertimestring = "Total Overtime ".$totalovertime;
						}
						//Utils::Trace($totalovertime);
						$attendancearr[]=$res1;	
					}
					
					$res['breaktime'] = $brktime;
					$totallatehrshh=$this->second_to_hhmm($totallatehrs);
					$res['totallatehrs'] = $totallatehrshh;
					$res['attendancearr']=$attendancearr;
					$res['total']=$totaltime;
					$res['totalshifttime']=$totalshifttime;
					$res['totalovertime']=$totalovertimestring;
					//$res['shifttotal']=$totaltime;
					$data[]=$res;
				}	
				
					
			}	
						
			
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		
		$result['startdate']=Utils::monthdateformatter($currentmonth);
		//$result['enddate']=Utils::monthdateformatter($currentmonth);
		
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']))
		{
			return $result;
		}
		else{
			return $data;
		}
	}
   
	public function AttendanceMonthlyReportBak3jan2019()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$currentmonth = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		if($currentmonth=="")
			$currentmonth = date("Y-m-d");
		
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' and Id in (select EmployeeId from AttendanceMaster where Month(AttendanceDate) = Month('$currentmonth') and Year(AttendanceDate) = Year('$currentmonth') and AttendanceDate!=CURDATE()) $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' and Id in (select EmployeeId from AttendanceMaster where Month(AttendanceDate) = Month('$currentmonth') and Year(AttendanceDate) = Year('$currentmonth') and AttendanceDate!=CURDATE()) $swhere order by FirstName ";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName.' - '.$row->EmployeeCode;
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$res['empshift']=Utils::getName($row->Shift,'ShiftMaster','Name',$this->db);
					$shifttimein=Utils::getName($row->Shift,'ShiftMaster','TimeIn',$this->db);
					$shifttimeout=Utils::getName($row->Shift,'ShiftMaster','TimeOut',$this->db);
					$res['shifttimein'] = date("g:i a", strtotime($shifttimein));
					$res['shifttimeout'] = date("g:i a", strtotime($shifttimeout));
					$brktime="";
					$attendancearr=array();
					$time = 0;
					$shifttime = 0;
					$overtime = 0;
					$totallatehrs=0;
					$totalearlyhrs=0;
					$totaltime=0;
					$totalshifttime=0;
					$totalovertimestring=0;
					$sql1 = "SELECT TIME_FORMAT(TIMEDIFF(a.TimeOut, a.TimeIn),'%H:%i') as totaltime,TIME_FORMAT(TIMEDIFF(s.TimeOut, s.TimeIn),'%H:%i') as totalshifttime, TIME_FORMAT(TIMEDIFF(s.TimeOutBreak, s.TimeInBreak),'%H:%i') as breakTime, AttendanceDate, TIME_FORMAT((Overtime),'%H:%i') as otime,a.AttendanceStatus as asts,TIME_FORMAT(a.TimeIn,'%h:%i %p') as timein ,TIME_FORMAT(a.TimeOut,'%h:%i %p') as timeout,a.AttendanceDate as adate,device,((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 <0) as perc,((TIME_TO_SEC(s.TimeOutGrace)-TIME_TO_SEC(a.TimeOut))/60 <0) as lategracests,TIME_FORMAT(TIMEDIFF( a.TimeIn,s.TimeInGrace),'%H:%i') as latehrs ,TIME_FORMAT(TIMEDIFF( a.TimeOut,s.TimeOut),'%H:%i') as earlyhrs, a.TimeIn as TimeIn, a.TimeOut as TimeOut, s.TimeOutBreak as TimeOutBreak FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and EmployeeId=?  and  Month(AttendanceDate) = Month(?) and Year(AttendanceDate) = Year(?) and AttendanceDate!=CURDATE() order by AttendanceDate ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id,$currentmonth,$currentmonth));
					$con=$query1->rowCount();
					while($row1 = $query1->fetch())
					{
						$latehrs=0;
						$earlyhrs=0;
						$res1=array();	
						if($row1->asts==1){
							$res1['status'] = "P";
						}elseif($row1->asts==2){
							$res1['status'] = "A";
						}elseif($row1->asts==4){
							$res1['status'] = "H";
						}elseif($row1->asts==3){
							$res1['status'] = "W";
						}elseif($row1->asts==6){
							$res1['status'] = "L";
						}
						$res1['sts'] = $row1->asts;						
						$res1['date'] = Utils::dateformatter($row1->adate);
						$timeoff=$this->getTimeoff($row->Id, $row1->adate);
						$res1['timeoff'] =($timeoff!=0)?$this->second_to_hhmm($timeoff):"-";
						$isearlytimeoff=$this->isearlyTimeoff($row->Id,$row1->adate,$row1->TimeIn);
						if($isearlytimeoff){
							//$timeoff=$timeoff+$this->getTimeoffearly($row->Id, $row1->adate,$row1->TimeIn);
							$timeoff=0;
						}
						$isearlytimeout=$this->isearlyTimeout($row->Id,$row1->adate,$row1->TimeOut);
						if($isearlytimeout){
							//$timeoff=$timeoff+$this->getTimeofflater($row->Id, $row1->adate,$row1->TimeOut);
							$timeoff=0;
						}
						
						//Utils::Trace($timeoff);
						$res1['device'] = $row1->device;
						$brktime=$res1['breakTime'] = $row1->breakTime;
						if($row1->asts==1 || $row1->asts==4)
						$res1['overtime'] = $row1->otime;
						else
						$res1['overtime'] = "00:00";
						
						if($row1->asts==1){
							// if($row1->perc==0){
								$latehrs =$this->explode_time($row1->latehrs);
								//echo $row1->latehrs;
							//}
							//if($row1->lategracests==0){
								$earlyhrs =$this->explode_time($row1->earlyhrs);
							//}
						}
						
						
						//$latehrs =$this->explode_time($row1->latehrs);
						$totallatehrs+=$latehrs;
						$totalearlyhrs+=$earlyhrs;
						
						$latehrshh=$this->second_to_hhmm($latehrs);
						//Utils::Trace($latehrshh);
						$res1['latehrs'] = $latehrshh;
						
						$earlyhrshh=$this->second_to_hhmm($earlyhrs);
					//	echo$earlyhrshh;
						$res1['earlyhrs'] = $earlyhrshh;
						
						$res1['totaltime'] = "00:00";
						$res1['totalshifttime'] = "00:00";
						$res1['timein'] = "-";
						$res1['timeout'] = "-";	
						if($row1->asts==1 || $row1->asts==4){
							$res1['totalshifttime'] = $row1->totalshifttime;
							
							if($row1->asts==4){
							$res1['totaltime'] = $this->explode_time($row1->totaltime);
							$res1['overtime'] = $this->second_to_hhmm($res1['totaltime'] - (($this->explode_time($res1['totalshifttime']))/2));
							}
							else{
							$res1['totaltime'] = $this->explode_time($row1->totaltime)-$this->explode_time($row1->breakTime)-$timeoff;
							$res1['overtime'] = $this->second_to_hhmm($res1['totaltime'] - (($this->explode_time($res1['totalshifttime']))-$this->explode_time($row1->breakTime)));
							}
							$res1['totaltime'] = $this->second_to_hhmm($res1['totaltime']);
							//$res1['totalshifttime'] = $row1->totalshifttime;
							$res1['timein'] = ($row1->timein=="00:00:00")?"-":$row1->timein;
							$res1['timeout'] = ($row1->timeout=="00:00:00")?"-":$row1->timeout;
						}
						
						if($row1->timein=="00:00:00" || $row1->timeout=="00:00:00")
							$res1['totaltime'] = "00:00";
							$timeoff=0;
							//$latehrs +=$this->explode_time($row1->latehrs);
							$isearly=false;
							
						$time +=$this->explode_time($res1['totaltime']);
						if($row1->asts==4){
							
							$shifttime +=($this->explode_time($row1->totalshifttime))/2;//-$this->explode_time($brktime))/2;
						}
						elseif($row1->asts==1){
						
							$shifttime +=$this->explode_time($res1['totalshifttime'])-$this->explode_time($brktime);
						}
						else{
							$shifttime +=$this->explode_time($res1['totalshifttime']);
						}
						//commented because overtime is not entered exact//
						//$overtime +=$this->explode_time($res1['overtime']);
						$overtime =$time-$shifttime;
						$totaltime=$this->second_to_hhmm($time);
						$totalshifttime=$this->second_to_hhmm($shifttime);
						$totalovertime=$this->second_to_hhmm($overtime);
						if($totalovertime < '00:00')
						{
							$totalovertimestring = "Total Undertime ".$totalovertime;
						}
						else{
							$totalovertimestring = "Total Overtime ".$totalovertime;
						}
						//Utils::Trace($totalovertime);
						$attendancearr[]=$res1;	
					}
					
					$res['breaktime'] = $brktime;
					$totallatehrshh=$this->second_to_hhmm($totallatehrs);
					$res['totallatehrs'] = $totallatehrshh;
					$res['attendancearr']=$attendancearr;
					$res['total']=$totaltime;
					$res['totalshifttime']=$totalshifttime;
					$res['totalovertime']=$totalovertimestring;
					//$res['shifttotal']=$totaltime;
					$data[]=$res;
				}	
				
					
			}	
						
			
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=Utils::monthdateformatter($currentmonth);
		//$result['enddate']=Utils::monthdateformatter($currentmonth);
		
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
	}	
	
	public function explode_time($time) { //explode time and convert into seconds
	
	if($time!=""){
	if($time < '00:00')
	{
		$time = explode(':', $time);
		$time = $time[0] * 60 - $time[1];
		//Utils::Trace($time);
	}
	else{
		//Utils::Trace($time);
        $time = explode(':', $time);
        $time = $time[0] * 60 + $time[1];
	}
	}
        return $time;
}

	public function second_to_hhmm($time) { //convert seconds to hh:mm
	
	if($time < 0){
		$hours = trim($time, "-");
		$hour = floor($hours / 60);
		$hour = "-".$hour ;
	
		//$hour = $hour-1;
	}else if($time==0){
		$hour = "00";
	}else{
        $hour = floor($time / 60);
	}
		//Utils::Trace($hour);
        $minute = strval(floor($time % 60));
		//Utils::Trace($minute);
        if ($minute == 0) {
            $minute = "00";
        }
		elseif($minute < 0)
		{
			$minute = trim($minute, "-");
		}
		else {
            $minute = $minute;
        }
	
		if($minute < 10 && $minute != 00)
			$minute = "0".$minute;
			if($time==0){
				$minute="00";
			}
        $time = $hour . ":" . $minute;
		//print_r(  $time);
		//Utils::Trace($time);
        return $time;
		
}
	
	///////////////this custom report is for getting data of transferred or promoted employee//////
	///////////////val=1(Transfer/Relocation) , val=2(Promotion/Demotion)//////
	public function JobModificationReport1($val)
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $swhere order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$sql2 = "SELECT Id,ApplyFrom FROM JobModificationMaster Where OrganizationId =? and EmployeeId= ? and ModifyType=3 and ApplyFrom between ? and ? order by LastModifiedById";
					if($val==2){
						$sql2 = "SELECT Id,ApplyFrom FROM JobModificationMaster Where OrganizationId =? and EmployeeId= ? and ModifyType=2 and ApplyFrom between ? and ? order by LastModifiedById";
					}
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($orgid,$row->Id,$startdate,$enddate));
					$count1 =  $query2->rowCount();
				
					if($count1>=1)
					{
						$res=array();
						$res['empname']=$row->EmployeeCode." - ".$row->FirstName." ".$row->MiddleName." ".$row->LastName;
						
						$jobmodify=array();
						while($row2 = $query2->fetch())
						{
							$sql1 = "SELECT * from JobModificationChild where JobId=?";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($row2->Id));
							$con=$query1->rowCount();
							$res1=array();					
							$res1['effectdate']=Utils::dateformatter($row2->ApplyFrom);	
							while($row1 = $query1->fetch())
							{
								if($row1->FieldName=="Division"){
									$res1['fieldname'] = "Division";
									$res1['oldvalue'] = Utils::getName($row1->OldValue,'DivisionMaster','Name',$this->db);
									$res1['newvalue'] =Utils::getName($row1->NewValue,'DivisionMaster','Name',$this->db);
								}elseif($row1->FieldName=="Department"){
									$res1['fieldname']="Department";
									$res1['oldvalue'] = Utils::getName($row1->OldValue,'DepartmentMaster','Name',$this->db);
									$res1['newvalue'] =Utils::getName($row1->NewValue,'DepartmentMaster','Name',$this->db);
								}elseif($row1->FieldName=="Designation"){
									$res1['fieldname']="Designation";
									$res1['oldvalue'] = Utils::getName($row1->OldValue,'DesignationMaster','Name',$this->db);
									$res1['newvalue'] =Utils::getName($row1->NewValue,'DesignationMaster','Name',$this->db);
								}elseif($row1->FieldName=="Grade"){
									$res1['fieldname']="Grade";
									$res1['oldvalue'] = Utils::getName($row1->OldValue,'GradeMaster','Name',$this->db);
									$res1['newvalue'] =Utils::getName($row1->NewValue,'GradeMaster','Name',$this->db);
								}elseif($row1->FieldName=="EmployeeCTC"){
									$res1['fieldname']="Gross Salary";
									$res1['oldvalue'] = Utils::getcurrency().' '.$row1->OldValue;
									$res1['newvalue'] = Utils::getcurrency().' '.$row1->NewValue;
								}elseif($row1->FieldName=="EmployeeStatus"){
									$res1['fieldname']="Employee Status";
									$res1['oldvalue'] = Utils::getName($row1->OldValue,'EmploymentStatusMaster','Name',$this->db);
									$res1['newvalue'] =Utils::getName($row1->NewValue,'EmploymentStatusMaster','Name',$this->db);
								}elseif($row1->FieldName=="Location"){
									$res1['fieldname']="Location";
									$res1['oldvalue'] = Utils::getName($row1->OldValue,'LocationMaster','Name',$this->db);
									$res1['newvalue'] =Utils::getName($row1->NewValue,'LocationMaster','Name',$this->db);
								}				
									
										
										
							}
							$jobmodify[]=$res1;	
						}
						$res['jobmodifyarr']=$jobmodify;
						$data[]=$res;						
					}	
				}
			}
		
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::monthdateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['todate'])?Utils::monthdateformatter($enddate):$enddate;
		$result['division']=isset($_POST['division'])?Utils::getName($_POST['division'],'DivisionMaster','Name',$this->db):0;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['division']) )
		{
			return $result;
		}
		else{
			return $data;
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
	}	
	
	public function JobModificationReport($val)
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$div=$_POST['division'];
			$swhere="AND  EmployeeId in ( Select Id from EmployeeMaster where Division=$div)";
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$whr = "and EmployeeId in ($ids) ";
			if($hrsts==1 || $sts==1){
				$whr = "";
			}
			$sql2 = "SELECT Id,ApplyFrom,EmployeeId FROM JobModificationMaster Where OrganizationId =? $whr  $swhere and ModifyType=3 and ApplyFrom between ? and ? order by EmployeeId,LastModifiedById";
			if($val==2){
				$sql2 = "SELECT Id,ApplyFrom,EmployeeId FROM JobModificationMaster Where OrganizationId =? $whr $swhere and ModifyType=2 and ApplyFrom between ? and ? order by EmployeeId,LastModifiedById";
			}
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($orgid,$startdate,$enddate));
			$count1 =  $query2->rowCount();
		
			if($count1>=1)
			{
				
				$jobmodify=array();
				while($row2 = $query2->fetch())
				{
					$sql1 = "SELECT * from JobModificationChild where JobId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row2->Id));
					$con=$query1->rowCount();
					$res1=array();	
					
					$res1['empname']=Utils::getEmployeeName($row2->EmployeeId,$this->db);
					$empdiv=Utils::getName($row2->EmployeeId, "EmployeeMaster", "Division", $this->db);
					$res1['empdiv']=Utils::getName($empdiv, "DivisionMaster", "Name", $this->db);
					$res1['effectdate']=Utils::dateformatter($row2->ApplyFrom);	
					while($row1 = $query1->fetch())
					{
						if($row1->FieldName=="Division"){
							$res1['fieldname'] = "Division";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'DivisionMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'DivisionMaster','Name',$this->db);
						}elseif($row1->FieldName=="Department"){
							$res1['fieldname']="Department";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'DepartmentMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'DepartmentMaster','Name',$this->db);
						}elseif($row1->FieldName=="Designation"){
							$res1['fieldname']="Designation";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'DesignationMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'DesignationMaster','Name',$this->db);
						}elseif($row1->FieldName=="Grade"){
							$res1['fieldname']="Grade";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'GradeMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'GradeMaster','Name',$this->db);
						}elseif($row1->FieldName=="EmployeeCTC"){
							$res1['fieldname']="Gross Salary";
							$res1['oldvalue'] = Utils::getcurrency().' '.$row1->OldValue;
							$res1['newvalue'] = Utils::getcurrency().' '.$row1->NewValue;
						}elseif($row1->FieldName=="EmployeeStatus"){
							$res1['fieldname']="Employee Status";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'EmploymentStatusMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'EmploymentStatusMaster','Name',$this->db);
						}elseif($row1->FieldName=="Location"){
							$res1['fieldname']="Location";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'LocationMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'LocationMaster','Name',$this->db);
						}				
						
					}
					$data[]=$res1;						
				}
				
			}	
					
			//$result["date"] =date('Y-m-d');
			//$result["data"] =$data;
			$result['data']=$data;
			$result['startdate']=isset($_POST['fromdate'])?Utils::monthdateformatter($startdate):$startdate;
			$result['enddate']=isset($_POST['todate'])?Utils::monthdateformatter($enddate):$enddate;
			$result['division']=isset($_POST['division'])?Utils::getName($_POST['division'],'DivisionMaster','Name',$this->db):0;
			$result['errorMsg']="No data found";
			$result['status']=true;
			
			if(isset($_POST['division']) )
			{
				return $result;
			}
			else{
				return $data;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
	}	
	////////////////////fetch salary details of employee///////////////////////
	public function getMonthPayrollDetail($val=0)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['salarymonth'])?($_POST['salarymonth']):"";
		$month = isset($_POST['fromdate'])?($_POST['fromdate']):$month;
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		if(isset($_POST['department']))
		{
			if($_POST['department']!=0 && $_POST['department']!='')
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['costcentre']))
		{
			if($_POST['costcentre']!=0 && $_POST['costcentre']!='')
			{
				$swhere.=" AND Channel=".$_POST['costcentre'];
			}
		}
		////////////////// THIS IS ONLY FOR RED DISTRIBUTION/////////////////
		if($swhere ==""){
			$nbadbankcode=Utils::encode5t("NBAD");
			$nbadbankname="National Bank of Abu Dhabi";
			$cbkbankcode=Utils::encode5t("CBK");
			
			if($orgid == 11)  {
				if($val==2)  { ///BT
					$swhere.=" AND (sm.BankCode = '$nbadbankcode' or sm.BankName = '$nbadbankname') AND Division = 44";
					//////////////// FOR NBAD /////////////
				}else if($val==1) { ///LBT
					$swhere.=" AND sm.BankCode <> '$nbadbankcode' AND sm.BankName <> '$nbadbankname' AND sm.BankCode <> '$cbkbankcode' AND Division = 44";
					/////////////////// //////////////// FOR OTHER BANKS EXCEPT NBAD/////////////
				} else if($val==3)  {  ///WPS
					$swhere.=" AND Division = 45";
					/////////////////// //////////////// FOR OTHER BANKS EXCEPT NBAD/////////////
				}else if($val==4)  {  ///power league
					$swhere.=" AND Division = 71";
					/////////////////// //////////////// FOR OTHER BANKS EXCEPT NBAD/////////////
				}
				$swhere.=" AND em.Id not in (4264, 4265)";
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		try{
			$headarray=array();
			////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
			$sql1 = "SELECT Id,Name,HeadType,Code FROM SalaryHead WHERE OrganizationId = ? and Id in (select  HeadId from SalaryChild where HeadType =1 and SalaryId in (Select Id from SalaryMaster where OrganizationId = ? and SalaryMonth = ?)) ORDER BY field(HeadType, 4,1,2,3),Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ,$orgid ,$month));
			while($row1 = $query1->fetch()) {
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$name=($row1->Code=="")?$row1->Name:$row1->Code;
				//$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").($name);
				$res1['name'] =$name;
				//$res1['label'] =(($row1->HeadType==0)?"(-) ":"(+) ").$name;
				$res1['label'] =$name;
				$res1['type'] = 1;
				$res1['additions']=(($row1->HeadType==3)?0:1);
				$res1['headtype'] = (int)$row1->HeadType;
				$headarray[]=$res1;
			}
			///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
			$sql1 = "SELECT Id,Name,Type,HeadCode,Code FROM SalaryOtherHead where OrganizationId=?  and ActiveSts=1 ORDER BY Type,Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($orgid ));
			while($row1 = $query1->fetch()) {
				$res1 = array();
				$res1['id'] = $row1->HeadCode;
				$res1['amount'] = 0;
				//$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				//$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['name'] =($row1->Code=="")?$row1->Name:$row1->Code;
				$res1['label'] =($row1->Code=="")?$row1->Name:$row1->Code;
				$res1['type'] = 2;
				$res1['additions']=(($row1->Type==0)?0:1);
				$res1['headtype'] = (int)$row1->Type;
				$headarray[]=$res1;
			}
			$this->db->beginTransaction();	
			$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankName as bankname, sm.BankCode as bankcode,sm.BankAccountNo as bankacc, sm.CreatedDate as paymentdate  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids)  and em.Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$month') and OrganizationId = $orgid) $swhere  order by Division, DOJ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankName as bankname,sm.BankCode as bankcode,sm.BankAccountNo as bankacc, sm.CreatedDate as paymentdate  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and em.Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$month') and OrganizationId = $orgid)   $swhere  order by Division, EmployeeCode, FirstName, MiddleName, LastName ";//and FinalSettlementSts=0
			}
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				while($row = $query->fetch()) {
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->sid;
					$res['employee'] = $row->EmployeeId;
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					$res['empuniqueid'] =  Utils::decode5t($row->UniqueId);
					$res['agentid'] = $row->agent_id;
					$res['banaccountno'] = Utils::decode5t($row->bankacc);
					$res['bankcode'] = Utils::decode5t($row->bankcode);
					$res['bankname'] = $row->bankname;
					//$res['empctc'] = $row->EmployeeCTC;
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['empcode'] = $row->EmployeeCode;
					$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['debitaccountno'] = Utils::getName($row->Division,'DivisionMaster','Account',$this->db);
					$res['empdepartment'] = Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empchannel'] = Utils::getName($row->Channel,'ChannelMaster','Name',$this->db);
					$res['empcostcentre'] = Utils::getName($row->CostCentre,'CostCentre','Name',$this->db);
					$ctc = $row->empctc;	
					$res['empctc']=$row->empctc;
					$res['paymentdate']=Utils::dateformatter($row->paymentdate);
					$res['benefi_add_line1']=Utils::decode5t($row->CurrentAddress);
					$res['benefi_add_line2']=Utils::decode5t($row->HomeAddress);
					$divcur= Utils::getDivisioncurrency($row->Division,$this->db);
					$res['empcurrency']=$divcur;
					$res['salarydetail'] = array();
					$res['salaryfirstday'] =date('Y-m-01', strtotime($month));
					// Last day of the month.
					$res['salarylastday']=date('Y-m-t', strtotime($month));
					$grandctc += $row->empctc; 
					$granddays =$row->PaidDays;
					//////////////FIND OUT BANK DETAILS/////////////////
					$sqlbank = "SELECT * from EmployeeBankDetails where EmployeeId=? and BankStatus=1 ";
					$querybank = $this->db->prepare($sqlbank);
					$querybank->execute(array($row->EmployeeId));
					while($rowbank = $querybank->fetch())	{
						$res['countryid'] = Utils::getName($rowbank->CountryId,'CountryMaster','Name',$this->db);
						$res['address'] = $rowbank->Address;
						$res['clearingcode'] = $rowbank->ClearingCode;
						$res['location'] =  Utils::decode5t($rowbank->Branch);
						$res['swiftcode'] =  Utils::decode5t($rowbank->SwiftCode);
					}
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////	
					$sql1 = "SELECT HeadId,HeadAmount,HeadType from SalaryChild where SalaryId=? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $salaryid ));
					while($row1 = $query1->fetch())	{
						if($row1->HeadType==1){
							for($i=0;$i<count($headarray);$i++){
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
								{
									$headarray[$i]['amount']=(int) $row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction += (int)$row1->HeadAmount;
									else
									$emptotal += (float)$row1->HeadAmount;
									break;
								}
							}
						}
						if($row1->HeadType==2){
							for($i=0;$i<count($headarray);$i++){	
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==2))
								{
									$headarray[$i]['amount']=(int) $row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction += (int)$row1->HeadAmount;
									else
									$emptotal += (float)$row1->HeadAmount;
									break;
								}
							}
						}
					}
				
					if($val==2)
						$res['productcode'] = "BT";
					else
						$res['productcode'] = "LBT";
					$res['benefi_nick_name'] = "";	
					$res['changetype'] = "OUR";
					$res['purposecode'] = "SAL";
					$res['purpose_payment'] = "Salary";
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					$res['salarydetail']=$headarray;
					for($i=0; $i<count($headarray); $i++) {
						$headarray[$i]['amount']=0 ;
					}
					$res['emptotaldeduction'] = $emptotaldeduction;
					$res['netpay'] = $emptotal-$emptotaldeduction;
					$res['empctc'] = $ctc;
					$res['empvariablepay'] = $this->getEmployeeIncentive($row->EmployeeId , $month);
					$res['empleavedays'] = $this->getEmployeeLeavedays($row->EmployeeId , $month);
					$res['emptotal'] = (int)$emptotal;
					$res['sts'] = true;
					$data[] = $res;
					$grandtotal +=(int)$emptotal;
					$grandtotaldeduction += $emptotaldeduction;
					$grandnettotals +=($emptotal-$emptotaldeduction);
				}
				for($i=0; $i<count($headarray); $i++) {
					$headarray[$i]['amount']="" ;
					///////////////// CALCULATING HEADS TOTAL///////////////
					$swhere1="";
					if(isset($_POST['division'])) {
						$swhere1="where Division=".$_POST['division'];
						if($_POST['division']==0)
						{
							$swhere1 =" ";
						}
					}
					$sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=? and  HeadType =? and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=? and EmployeeId in (SELECT Id from EmployeeMaster $swhere1)) ";
					$qy=$this->db->prepare($sl);
					$qy->execute(array($headarray[$i]['id'],$headarray[$i]['type'],$month,$orgid));
					$amt=0;
					while($r1=$qy->fetch())
					{
						$headarray[$i]['amount']=(int) $r1->totalamt;
					}	
				}
				
				if($val==0){
					$res = array();
					$res['salaryid'] = 0;
					$res['empcode'] = "Grand Total";
					$res['name'] = "";
					$res['empdivision'] = "Grand Total";
					$res['empdepartment'] = "";
					$res['empchannel'] = "";
					$res['empcostcentre'] = "";
					$res['empcurrency'] = "";
					$res['empctc'] = $grandctc;
					$res['emppaiddays'] = $granddays;
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					$res['salarydetail'] = $headarray;
					$res['emptotal'] = (int)$grandtotal;
					$res['emptotaldeduction'] = (int)$grandtotaldeduction;
					$res['netpay'] = (int)$grandnettotals;
					$data[] = $res;
				}
		
		}
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=true;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		if(isset($_POST['fromdate']) || isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
    }
	public function getMonthAttendancePayroll($val=0)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['salarymonth'])?($_POST['salarymonth']):"";
		$month = isset($_POST['fromdate'])?($_POST['fromdate']):$month;
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			if($_POST['division']!=0 && $_POST['division']!='')
			{
				$swhere="AND Division=".$_POST['division'];
			}
			/* $swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			} */
		}
		if(isset($_POST['shift']))
		{
			if($_POST['shift']!=0 && $_POST['shift']!='')
			{
				$swhere.=" AND Shift=".$_POST['shift'];
			}
		}
		
		////////////////// THIS IS ONLY FOR RED DISTRIBUTION/////////////////
		if($swhere ==""){
			$nbadbankcode=Utils::encode5t("NBAD");
			$nbadbankname="National Bank of Abu Dhabi";
			$cbkbankcode=Utils::encode5t("CBK");
			
			if($orgid == 11)  {
				if($val==2)  { ///BT
					$swhere.=" AND (sm.BankCode = '$nbadbankcode' or sm.BankName = '$nbadbankname') AND Division = 44";
					//////////////// FOR NBAD /////////////
				}else if($val==1) { ///LBT
					$swhere.=" AND sm.BankCode <> '$nbadbankcode' AND sm.BankName <> '$nbadbankname' AND sm.BankCode <> '$cbkbankcode' AND Division = 44";
					/////////////////// //////////////// FOR OTHER BANKS EXCEPT NBAD/////////////
				} else if($val==3)  {  ///WPS
					$swhere.=" AND Division = 45";
					/////////////////// //////////////// FOR OTHER BANKS EXCEPT NBAD/////////////
				}else if($val==4)  {  ///power league
					$swhere.=" AND Division = 71";
					/////////////////// //////////////// FOR OTHER BANKS EXCEPT NBAD/////////////
				}
				$swhere.=" AND em.Id not in (4264, 4265)";
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		try{
			$headarray=array();
			////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
			$sql1 = "SELECT Id,Name,HeadType,Code FROM SalaryHead WHERE OrganizationId = ? and Id in (select  HeadId from SalaryChild where HeadType =1 and SalaryId in (Select Id from SalaryMaster where OrganizationId = ? and SalaryMonth = ?)) ORDER BY field(HeadType, 4,1,2,3),Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ,$orgid ,$month));
			while($row1 = $query1->fetch()) {
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$name=($row1->Code=="")?$row1->Name:$row1->Code;
				//$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").($name);
				$res1['name'] =$name;
				//$res1['label'] =(($row1->HeadType==0)?"(-) ":"(+) ").$name;
				$res1['label'] =$name;
				$res1['type'] = 1;
				$res1['additions']=(($row1->HeadType==3)?0:1);
				$res1['headtype'] = (int)$row1->HeadType;
				$headarray[]=$res1;
			}
			///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
			$sql1 = "SELECT Id,Name,Type,HeadCode,Code FROM SalaryOtherHead where OrganizationId=?  and ActiveSts=1 ORDER BY Type,Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($orgid ));
			while($row1 = $query1->fetch()) {
				$res1 = array();
				$res1['id'] = $row1->HeadCode;
				$res1['amount'] = 0;
				//$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				//$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['name'] =($row1->Code=="")?$row1->Name:$row1->Code;
				$res1['label'] =($row1->Code=="")?$row1->Name:$row1->Code;
				$res1['type'] = 2;
				$res1['additions']=(($row1->Type==0)?0:1);
				$res1['headtype'] = (int)$row1->Type;
				$headarray[]=$res1;
			}
			$this->db->beginTransaction();	
			$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankName as bankname, sm.BankCode as bankcode,sm.BankAccountNo as bankacc, sm.CreatedDate as paymentdate  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids)  and em.Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$month') and OrganizationId = $orgid) $swhere  order by EmployeeCode, DOJ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankName as bankname,sm.BankCode as bankcode,sm.BankAccountNo as bankacc, sm.CreatedDate as paymentdate  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and em.Id NOT IN (SELECT EmployeeId from SeveranceMaster where EffectDate<=LAST_DAY('$month') and OrganizationId = $orgid) $swhere  order by EmployeeCode, FirstName, MiddleName, LastName ";//and FinalSettlementSts=0
			}
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				while($row = $query->fetch()) {
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->sid;
					$res['employee'] = $row->EmployeeId;
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					$res['empuniqueid'] =  Utils::decode5t($row->UniqueId);
					$res['agentid'] = $row->agent_id;
					$res['banaccountno'] = Utils::decode5t($row->bankacc);
					$res['bankcode'] = Utils::decode5t($row->bankcode);
					$res['bankname'] = $row->bankname;
					//$res['empctc'] = $row->EmployeeCTC;
					$res['emppaiddays'] =  cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['empcode'] = $row->EmployeeCode;
					$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['debitaccountno'] = Utils::getName($row->Division,'DivisionMaster','Account',$this->db);
					$res['empdepartment'] = Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['presentdays']=$this->getEmpLateEarlyLeaving($row->EmployeeId,$month,1);
					$res['absentdays']=$this->getEmpLateEarlyLeaving($row->EmployeeId,$month,2);
					$res['weekoff']=$this->getWeekoffs($row->Shift,$month);
					
					$ctc = $row->empctc;	
					$res['empctc']=$row->empctc;
					$res['paymentdate']=Utils::dateformatter($row->paymentdate);
					$res['benefi_add_line1']=Utils::decode5t($row->CurrentAddress);
					$res['benefi_add_line2']=Utils::decode5t($row->HomeAddress);
					$divcur= Utils::getDivisioncurrency($row->Division,$this->db);
					$res['empcurrency']=$divcur;
					$res['salarydetail'] = array();
					$res['salaryfirstday'] =date('Y-m-01', strtotime($month));
					// Last day of the month.
					$res['salarylastday']=date('Y-m-t', strtotime($month));
					$grandctc += $row->empctc; 
					$granddays = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
					//////////////FIND OUT BANK DETAILS/////////////////
					$sqlbank = "SELECT * from EmployeeBankDetails where EmployeeId=? and BankStatus=1 ";
					$querybank = $this->db->prepare($sqlbank);
					$querybank->execute(array($row->EmployeeId));
					while($rowbank = $querybank->fetch())	{
						$res['countryid'] = Utils::getName($rowbank->CountryId,'CountryMaster','Name',$this->db);
						$res['address'] = $rowbank->Address;
						$res['clearingcode'] = $rowbank->ClearingCode;
						$res['location'] =  Utils::decode5t($rowbank->Branch);
						$res['swiftcode'] =  Utils::decode5t($rowbank->SwiftCode);
					}
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////	
					$sql1 = "SELECT HeadId,HeadAmount,HeadType from SalaryChild where SalaryId=? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $salaryid ));
					while($row1 = $query1->fetch())	{
						if($row1->HeadType==1){
							for($i=0;$i<count($headarray);$i++){
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
								{
									$headarray[$i]['amount']=(int) $row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction += (int)$row1->HeadAmount;
									else
									$emptotal += (float)$row1->HeadAmount;
									break;
								}
							}
						}
						if($row1->HeadType==2){
							for($i=0;$i<count($headarray);$i++){	
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==2))
								{
									$headarray[$i]['amount']=(int) $row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction += (int)$row1->HeadAmount;
									else
									$emptotal += (float)$row1->HeadAmount;
									break;
								}
							}
						}
					}
				
					if($val==2)
						$res['productcode'] = "BT";
					else
						$res['productcode'] = "LBT";
					$res['benefi_nick_name'] = "";	
					$res['changetype'] = "OUR";
					$res['purposecode'] = "SAL";
					$res['purpose_payment'] = "Salary";
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					$res['salarydetail']=$headarray;
					for($i=0; $i<count($headarray); $i++) {
						$headarray[$i]['amount']=0 ;
					}
					$res['emptotaldeduction'] = $emptotaldeduction;
					$res['netpay'] = $emptotal-$emptotaldeduction;
					$res['empctc'] = $ctc;
					$res['empvariablepay'] = $this->getEmployeeIncentive($row->EmployeeId , $month);
					$res['empleavedays'] = $this->getEmployeeLeavedays($row->EmployeeId , $month);
					$res['emptotal'] = (int)$emptotal;
					$res['sts'] = true;
					$data[] = $res;
					$grandtotal +=(int)$emptotal;
					$grandtotaldeduction += $emptotaldeduction;
					$grandnettotals +=($emptotal-$emptotaldeduction);
				}
				for($i=0; $i<count($headarray); $i++) {
					$headarray[$i]['amount']="" ;
					///////////////// CALCULATING HEADS TOTAL///////////////
					$swhere1="";
					if(isset($_POST['division'])) {
						$swhere1="where Division=".$_POST['division'];
						if($_POST['division']==0)
						{
							$swhere1 =" ";
						}
					}
					$sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=? and  HeadType =? and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=? and EmployeeId in (SELECT Id from EmployeeMaster $swhere1)) ";
					$qy=$this->db->prepare($sl);
					$qy->execute(array($headarray[$i]['id'],$headarray[$i]['type'],$month,$orgid));
					$amt=0;
					while($r1=$qy->fetch())
					{
						$headarray[$i]['amount']=(int) $r1->totalamt;
					}	
				}
				
				
		
		}
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=true;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		if(isset($_POST['fromdate']) || isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
    }
	/////////GET LateComing Or Early Leaving OF EMPLOYEES////////////////
	public function getEmpLateEarlyLeaving($empid,$month,$val)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		try{
			$mid   = $_SESSION['ubihrm_user_id'];
			$orgid = $_SESSION['ubihrm_org_id'];
			$shift= Utils::getName($empid, "EmployeeMaster", "Shift", $this->db);
			$swherepresent=""; $swhereabsent="";
			if($val==1)
			$swherepresent =" and AttendanceStatus IN (1,4,8)";
			if($val==2)
			$swhereabsent ="and AttendanceStatus =2";
			$temp=date("Y-m-01",strtotime($month));
			$temp1=date("Y-m-t",strtotime($month));
			$present=0;$absent=0;
			$sql1="select count(Id) as countids from AttendanceMaster where EmployeeId=? and (AttendanceDate between '$temp' and '$temp1') $swherepresent $swhereabsent";
			$query1=$this->db->prepare($sql1);
			$query1->execute(array($empid));
			while($r=$query1->fetch()){
				if($val==1){
					$present= $r->countids;
				}if($val==2){
					$absent= $r->countids;
				}
			}
		
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if($val==1)
		return $present;
		elseif($val==2)
		return $absent;
    }
	public function getWeekoffs($shiftid,$month)
	{
		
		$value=0;
		try{
			$sql1 = "SELECT WeekOff,Day FROM ShiftMasterChild WHERE ShiftId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $shiftid));
			while($row1 = $query1->fetch())
			{
				$week=$row1->WeekOff;
				$dayofmonth=$row1->Day;
				
				if($dayofmonth==1)
					$day="Sunday";
				if($dayofmonth==2)
					$day="Monday";
				if($dayofmonth==3)
					$day="Tuesday";
				if($dayofmonth==4)
					$day="Wednesday";
				if($dayofmonth==5)
					$day="Thursday";
				if($dayofmonth==6)
					$day="Friday";
				if($dayofmonth==7)
					$day="Saturday";
				
				$noofdays=$this->numWeekDays( $month ,$day );	
				//echo $day ." ".$noofdays." <br>";
				$weekarr=explode(",",$week);
				for($i=0;$i<$noofdays;$i++)
				{
					if($weekarr[$i]==1)
					{
						$value=$value+1;
					}	
				}	
			}
		}catch(Exception $e) {
			
		}		
		return $value;
	}
	public function numWeekdays( $month ,$day ) {

		$start=date("Y-m-01", strtotime($month));
		$end=date("Y-m-t", strtotime($month));
		$end = date('Y-m-d', strtotime($end.' +1 day'));
        $current = $start;
        $count = 0;

        while($current != $end){
			
            if(date('l', strtotime($current)) == $day){
				//echo date('l', strtotime($current))." $current<br> ";
                $count++;
            }

            $current = date('Y-m-d', strtotime($current.' +1 day'));
        };
		

		return (int)$count;

	}
	public function getMonthPayrollTotal()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['salarymonth'])?($_POST['salarymonth']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		if(isset($_POST['department']))
		{
			if($_POST['department']!=0 && $_POST['department']!='')
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['costcentre']))
		{
			if($_POST['costcentre']!=0 && $_POST['costcentre']!='')
			{
				$swhere.=" AND Channel=".$_POST['costcentre'];
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
		
			$headarray=array();
			
			////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
			$sql1 = "SELECT Id,Name,HeadType,Code FROM SalaryHead WHERE OrganizationId = ? and Id in (select  HeadId from SalaryChild where HeadType =1 and SalaryId in (Select Id from SalaryMaster where OrganizationId = ? and SalaryMonth = ?)) ORDER BY field(HeadType, 4,1,2,3),Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ,$orgid ,$month));
			while($row1 = $query1->fetch())
			{
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$name=($row1->Code=="")?$row1->Name:$row1->Code;
				$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").($name);
				$res1['label'] =(($row1->HeadType==0)?"(-) ":"(+) ").$name;
				$res1['type'] = 1;
				$res1['additions']=(($row1->HeadType==3)?0:1);
				$res1['headtype'] = (int)$row1->HeadType;
				$headarray[]=$res1;
			}
			///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
			$sql1 = "SELECT Id,Name,Type,HeadCode FROM SalaryOtherHead where OrganizationId=? and ActiveSts=1 and Id in (select  HeadId from SalaryChild where HeadType =2 and SalaryId in (Select Id from SalaryMaster where OrganizationId = ? and SalaryMonth = ?))  ORDER BY Type,Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($orgid, $orgid,$month));
			while($row1 = $query1->fetch())
			{
				$res1 = array();
				$res1['id'] = $row1->HeadCode;
				$res1['amount'] = 0;
				$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 2;
				$res1['additions']=(($row1->Type==0)?0:1);
				$res1['headtype'] = (int)$row1->Type;
				$headarray[]=$res1;
			}
			$this->db->beginTransaction();	
			 $sql = "SELECT *, sm.Id as sid,sum(em.EmployeeCTC) as empctc FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids) $swhere group by em.Division  order by Division, DOJ";
			if($hrsts==1 || $sts==1){
				 $sql = "SELECT *, sm.Id as sid,sum(em.EmployeeCTC)  as empctc FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=?  $swhere group by em.Division  order by Division, EmployeeCode, FirstName, MiddleName, LastName ";//and FinalSettlementSts=0
			}
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				while($row = $query->fetch())
				{
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->sid;
					$res['employee'] = $row->EmployeeId;
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					//$res['empctc'] = $row->EmployeeCTC;
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['empcode'] = $row->EmployeeCode;
					$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdepartment'] = Utils::getName($row->Department,'DepartmentMaster','Code',$this->db);
					$res['empchannel'] = Utils::getName($row->Channel,'ChannelMaster','Code',$this->db);
					$ctc = $row->empctc;	
					$res['empctc']=$row->empctc;
					$divcur= Utils::getDivisioncurrency($row->Division,$this->db);
					$res['empcurrency']=$divcur;
					$res['salarydetail'] = array();
					
					
					$grandctc += $row->empctc; 
					$granddays =$row->PaidDays;
					//Utils::Trace('salaryid'.$salaryid);
					
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////	
					
					/* $sql1 = "SELECT HeadId,HeadAmount,HeadType from SalaryChild where SalaryId=? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $salaryid ));
					while($row1 = $query1->fetch())
					{
						if($row1->HeadType==1){
							for($i=0;$i<count($headarray);$i++){
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
								{
									$headarray[$i]['amount']=(int) $row1->HeadAmount;
									if(!$headarray[$i]['additions']){
									$emptotaldeduction += (int)$row1->HeadAmount;
									//Utils::Trace('fff'.$row1->HeadAmount);
									}
									else
									$emptotal += (int)$row1->HeadAmount;
									break;
								}
							
							}
						}
						if($row1->HeadType==2){
							for($i=0;$i<count($headarray);$i++){	
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==2))
								{
									$headarray[$i]['amount']=(int) $row1->HeadAmount;
									if(!$headarray[$i]['additions']){
									echo $emptotaldeduction += (int)$row1->HeadAmount;
									//Utils::Trace('fff'.$row1->HeadAmount);
								}
									else
									$emptotal += (int)$row1->HeadAmount;
										
										break;
								}
							}
						}
					} */
					
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						
						 for($i=0; $i<count($headarray); $i++)
						{
							$headarray[$i]['amount']="" ;
							
							///////////////// CALCULATING HEADS TOTAL///////////////
							
							 $sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=? and  HeadType =? and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=? and EmployeeId in (Select Id from EmployeeMaster where Division=? $swhere)) ";
							$qy=$this->db->prepare($sl);
							$qy->execute(array($headarray[$i]['id'],$headarray[$i]['type'],$month,$orgid,$row->Division));
							$amt=0;
							while($r1=$qy->fetch())
							{
								$headarray[$i]['amount']=(int) $r1->totalamt;
							}	 
						} 
						$sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadAddDeduct =0 and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=? and EmployeeId in (Select Id from EmployeeMaster where Division=? $swhere)) ";
						$qy=$this->db->prepare($sl);
						$qy->execute(array($month,$orgid,$row->Division));
						$amt=0;
						while($r1=$qy->fetch())
						{
							
							$emptotaldeduction=(int) $r1->totalamt;
						}
						$sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadAddDeduct <>0 and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=? and EmployeeId in (Select Id from EmployeeMaster where Division=? $swhere)) ";
						$qy=$this->db->prepare($sl);
						$qy->execute(array($month,$orgid,$row->Division));
						$amt=0;
						while($r1=$qy->fetch())
						{
							
							$emptotal=(int) $r1->totalamt;
						}	 
						$res['salarydetail']=$headarray;
						
						for($i=0; $i<count($headarray); $i++)
						{
							$headarray[$i]['amount']=0 ;
						}
											
					$res['emptotaldeduction'] = $emptotaldeduction;
					$res['netpay'] = $emptotal-$emptotaldeduction;
					$res['empctc'] = $ctc;
					$res['emptotal'] = $emptotal;
					$res['sts'] = true;
					$data[] = $res;
					$grandtotal +=$emptotal;
					$grandtotaldeduction += $emptotaldeduction;
					$grandnettotals +=($emptotal-$emptotaldeduction);
				}
				for($i=0; $i<count($headarray); $i++)
				{
					$headarray[$i]['amount']="" ;
					
					///////////////// CALCULATING HEADS TOTAL///////////////
					
					$sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=? and  HeadType =? and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=? and EmployeeId in (Select Id from EmployeeMaster where 1=1 $swhere)) ";
					$qy=$this->db->prepare($sl);
					$qy->execute(array($headarray[$i]['id'],$headarray[$i]['type'],$month,$orgid));
					$amt=0;
					while($r1=$qy->fetch())
					{
						
						$headarray[$i]['amount']=(int) $r1->totalamt;
					}	
					
				}
				$res = array();
				$res['salaryid'] = 0;
				$res['name'] = "Grand Total";
				$res['empdivision'] = "Grand Total";
				$res['empdepartment'] = "";
				$res['empchannel'] = "";
				$res['empcurrency'] = "";
				$res['empmonthdate'] = '-';
				$res['empctc'] = $grandctc;
				$res['emppaiddays'] = $granddays;
				$res['empmonthname'] ='-';
				$res['salarydetail'] = $headarray;
				$res['emptotal'] = $grandtotal;
				$res['emptotaldeduction'] = $grandtotaldeduction;
				$res['netpay'] = $grandnettotals;
				$data[] = $res;
		
		}
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $data;
    }
	
	public function getMonthPayrollDetailSIF()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			
			if($_POST['division']!=0)
			{
				$swhere.="AND Division=".$_POST['division'];
			}
		}
		if(isset($_POST['department']))
		{
			
			if($_POST['department']!=0)
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['visa']))
		{
			
			if($_POST['visa']!=0)
			{
				$swhere.=" AND Visa=".$_POST['visa'];
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
			$headarray=array();			
			////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
			$sql1 = "SELECT Id,Name,HeadType FROM SalaryHead WHERE OrganizationId = ? ORDER BY field(HeadType, 4,1,2,3),Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ));
			while($row1 = $query1->fetch())
			{
				$status=true;
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->HeadType==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 1;
				$res1['additions']=(($row1->HeadType==3)?0:1);
				$res1['headtype'] = (int)$row1->HeadType;
				$headarray[]=$res1;
			}
			///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
			$sql1 = "SELECT Id,Name,Type FROM SalaryOtherHead ORDER BY Type,Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($row1 = $query1->fetch())
			{
				$status=true;
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 2;
				$res1['additions']=(($row1->Type==0)?0:1);
				$res1['headtype'] = (int)$row1->Type;
				$headarray[]=$res1;
			}
			$this->db->beginTransaction();	
			$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankCode as bankcode,sm.BankAccountNo as bankacc,em.Visa as visa  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids) $swhere  order by Division, DOJ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankCode as bankcode,sm.BankAccountNo as bankacc,em.Visa as visa FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=?  $swhere  order by Division, DOJ ";//and FinalSettlementSts=0
			}
		//	echo $sql."  ".$month;
		
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				$status=true;
				while($row = $query->fetch())
				{
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->sid;
					$res['employee'] = $row->EmployeeId;
					$res['edr'] = "EDR";
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					//$res['empctc'] = $row->EmployeeCTC;
					$estno =  ($row->UniqueId=="")?"N/A":$row->UniqueId;
					$res['empuniqueid'] = Utils::decode5t($estno);
					$res['bankcode'] = Utils::decode5t($row->bankcode);
					$res['banaccountno'] = Utils::decode5t($row->bankacc);
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['empcode'] = $row->EmployeeCode;
					$estno= Utils::getName($row->Division,'DivisionMaster','Establishment',$this->db);
					$divacc= Utils::getName($row->Division,'DivisionMaster','Account',$this->db);
					$res['empdivisionsif'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db)."   |     Establishment Number : $estno"."    |  Code of FGB : $divacc";
					$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$ctc = $row->empctc;	
					$res['empctc']=$row->empctc;
					$res['secondlast']="00.0";
					$res['last']="0";
					$res['salaryfirstday'] =date('Y-m-01', strtotime($month));
					// Last day of the month.
					$res['salarylastday']=date('Y-m-t', strtotime($month));
					$res['salarydetail'] = array();
					
					
					$grandctc += $row->empctc; 
					$granddays +=$row->PaidDays;
					
					
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////	
					
					$sql1 = "SELECT HeadId,HeadAmount,HeadType from SalaryChild where SalaryId=? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $salaryid ));
					while($row1 = $query1->fetch())
					{
						if($row1->HeadType==1){
							for($i=0;$i<count($headarray);$i++){
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
								{
									$headarray[$i]['amount']= $row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction +=$row1->HeadAmount;
									else
									$emptotal += $row1->HeadAmount;
									break;
								}
							
							}
						}
						if($row1->HeadType==2){
							for($i=0;$i<count($headarray);$i++){	
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==2))
								{
									$headarray[$i]['amount']=$row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction +=$row1->HeadAmount;
									else
									$emptotal +=$row1->HeadAmount;
										
										break;
								}
							}
						}
					}
					
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						
						
						//$res['salarydetail']=$headarray;
						
						for($i=0; $i<count($headarray); $i++)
						{
							$headarray[$i]['amount']=0 ;
						}
						
					
					$res['emptotaldeduction'] = $emptotaldeduction;
					$netpay= $emptotal-$emptotaldeduction;
					$res['netpay'] = number_format((float)$netpay, 2, '.', '');
					$res['empctc'] = $ctc;
					$res['emptotal'] = $emptotal;
					$res['lastrow'] = 0;
					$res['sts'] = true;
					$data[] = $res;
					$grandtotal +=$emptotal;
					$grandtotaldeduction += $emptotaldeduction;
					$grandnettotals +=($emptotal-$emptotaldeduction);
				}
				for($i=0; $i<count($headarray); $i++)
				{
					$headarray[$i]['amount']="" ;
					///////////////// CALCULATING HEADS TOTAL///////////////
					
					$sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=? and  HeadType =? and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=?) ";
					$qy=$this->db->prepare($sl);
					$qy->execute(array($headarray[$i]['id'],$headarray[$i]['type'],$month,$orgid));
					$amt=0;
					while($r1=$qy->fetch())
					{
						
						$headarray[$i]['amount']=$r1->totalamt;
					}	
				}
				if(isset($_POST['visa']))
				{
					$estno= Utils::getName($_POST['visa'],'VisaMaster','EstNumber',$this->db);
					$divacc= Utils::getName($_POST['visa'],'VisaMaster','BankACNo',$this->db);	
					$res = array();
					$res['salaryid'] = 0;
					$res['edr'] = "SCR";///Utils::getName($_POST['division'],'DivisionMaster','ShortName',$this->db);	
					$res['empuniqueid'] = "$estno";
					$res['bankcode'] = $divacc;
					$res['banaccountno'] = date("Y-m-d",strtotime($this->getCurrentSalaryGenerateDate($month)));  ////////////////////date of salary generate///////
					$res['salaryfirstday'] = date("H:i",strtotime($this->getCurrentSalaryGenerateDate($month))); /////////////time of salary generate////////////
					$res['salaryfirstday'] = str_replace(":","",$res['salaryfirstday'] );
					$res['salarylastday'] = date("m",strtotime($month)).date("Y",strtotime($month));
					$divid=0;
					if($estno!="")
						$divid=$this->getDivisionByEstno($estno);
					//////////// salary month
					$curid=Utils::getName($divid,'DivisionMaster','CurrencyId',$this->db);	
					$res['secondlast']=Utils::getName($curid,'CurrencyMaster','CurrencyCode',$this->db);	
					$res['last']=Utils::getName($divid,'DivisionMaster','Name',$this->db);	
					$res['emppaiddays'] = $count;
					
					$res['netpay'] =number_format((float)$grandnettotals, 2, '.', ''); 
					$res['lastrow'] = 1;
				}else{
					$res = array();
					$res['salaryid'] = 0;
					$res['edr'] = "";
					$res['name'] = "Grand Total";
					$res['empdivision'] = "Grand Total";
					$res['empctc'] = $grandctc;
					$res['emppaiddays'] = $granddays;
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					//$res['salarydetail'] = $headarray;
					$res['emptotal'] = $grandtotal;
					$res['emptotaldeduction'] = $grandtotaldeduction;
					$res['netpay'] = number_format((float)$grandnettotals, 2, '.', ''); 
					$res['secondlast']="00.0";
					$res['last']="0";
					
				}	
				
				$data[] = $res;
		
		}
		
		
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		if(isset($_POST['fromdate']) )
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
    }
	public function getMonthDubaiSIFDetail()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			
			if($_POST['division']!=0)
			{
				$swhere.="AND Division=".$_POST['division'];
			}
		}
		if(isset($_POST['department']))
		{
			
			if($_POST['department']!=0)
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['visa']))
		{
			
			if($_POST['visa']!=0)
			{
				$swhere.=" AND Visa=".$_POST['visa'];
			}
		}
		$grandtotal=0;$grandbasictotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
			$headarray=array();			
			////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
			$sql1 = "SELECT Id,Name,HeadType FROM SalaryHead WHERE OrganizationId = ? ORDER BY field(HeadType, 4,1,2,3),Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ));
			while($row1 = $query1->fetch())
			{
				$status=true;
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['namematch'] =$row1->Name;
				$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->HeadType==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 1;
				$res1['additions']=(($row1->HeadType==3)?0:1);
				$res1['headtype'] = (int)$row1->HeadType;
				$headarray[]=$res1;
			}
			///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
			$sql1 = "SELECT Id,Name,Type FROM SalaryOtherHead ORDER BY Type,Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($row1 = $query1->fetch())
			{
				$status=true;
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['namematch'] =$row1->Name;
				$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 2;
				$res1['additions']=(($row1->Type==0)?0:1);
				$res1['headtype'] = (int)$row1->Type;
				$headarray[]=$res1;
			}
			$this->db->beginTransaction();	
			$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankCode as bankcode,sm.BankAccountNo as bankacc,em.Visa as visa  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids) $swhere  order by Division, DOJ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankCode as bankcode,sm.BankAccountNo as bankacc,em.Visa as visa FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=?  $swhere  order by Division, DOJ ";//and FinalSettlementSts=0
			}
		//	echo $sql."  ".$month;
		
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				$status=true;
				while($row = $query->fetch())
				{
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->sid;
					$res['employee'] = $row->EmployeeId;
					$res['edr'] = "EDR";
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					//$res['empctc'] = $row->EmployeeCTC;
					$estno =  ($row->UniqueId=="")?"N/A":$row->UniqueId;
					$res['empuniqueid'] = Utils::decode5t($estno);
					$res['bankcode'] = Utils::decode5t($row->bankcode);
					$res['banaccountno'] = Utils::decode5t($row->bankacc);
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['absentdays']=$this->getEmpLateEarlyLeaving($row->EmployeeId,$month,2);
					$res['empcode'] = $row->EmployeeCode;
					$estno= Utils::getName($row->Division,'DivisionMaster','Establishment',$this->db);
					$divacc= Utils::getName($row->Division,'DivisionMaster','Account',$this->db);
					$res['empdivisionsif'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db)."   |     Establishment Number : $estno"."    |  Code of FGB : $divacc";
					$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$ctc = $row->empctc;	
					$res['empctc']=$row->empctc;
					$res['secondlast']="";
					$res['last']="0";
					$res['salaryfirstday'] =date('Y-m-01', strtotime($month));
					// Last day of the month.
					$res['salarylastday']=date('Y-m-t', strtotime($month));
					$res['salarydetail'] = array();
					
					
					$grandctc += $row->empctc; 
					$granddays +=$row->PaidDays;
					
					
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////	
					$basicsalary=0;
					$sql1 = "SELECT HeadId,HeadAmount,HeadType from SalaryChild where SalaryId=? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $salaryid ));
					while($row1 = $query1->fetch())
					{
						if($row1->HeadType==1){   /////////Salary head/////////
							for($i=0;$i<count($headarray);$i++){
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
								{
									////////find out all fixed components/////
									if($headarray[$i]['headtype']==4)
									{
										
										$basicsalary += $row1->HeadAmount;
									}
									$headarray[$i]['amount']= $row1->HeadAmount;
									if(!$headarray[$i]['additions']){
										$emptotaldeduction +=$row1->HeadAmount;
									}
									else{
										///////find out other then fixed components//
										if($headarray[$i]['headtype']!=4)
										{
											$emptotal += $row1->HeadAmount;
										}
									}
									break;
									
								}
							
							}
						}
						if($row1->HeadType==2){ //////salary other head//////////
							for($i=0;$i<count($headarray);$i++){	
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==2))
								{
									$headarray[$i]['amount']=$row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction +=$row1->HeadAmount;
									else
									$emptotal +=$row1->HeadAmount;
										
										break;
								}
							}
						}
					}
					
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						
						
						//$res['salarydetail']=$headarray;
						
						for($i=0; $i<count($headarray); $i++)
						{
							$headarray[$i]['amount']=0 ;
						}
						
					
					$res['emptotaldeduction'] = $emptotaldeduction;
					$netpay= $emptotal-$emptotaldeduction;
					$res['netpay'] = number_format((float)$netpay, 2, '.', '');
					$res['basicsalary'] = $basicsalary;
					$res['empctc'] = $ctc;
					
					$res['emptotal'] = $emptotal;//-$emptotaldeduction;
					$res['lastrow'] = 0;
					$res['sts'] = true;
					$data[] = $res;
					$grandbasictotal +=$basicsalary;
					$grandtotal +=$emptotal;
					$grandtotaldeduction += $emptotaldeduction;
					$grandnettotals +=($emptotal-$emptotaldeduction);
				}
				/* for($i=0; $i<count($headarray); $i++)
				{
					$headarray[$i]['amount']="" ;
					///////////////// CALCULATING HEADS TOTAL///////////////
					
					$sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=? and  HeadType =? and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=?) ";
					$qy=$this->db->prepare($sl);
					$qy->execute(array($headarray[$i]['id'],$headarray[$i]['type'],$month,$orgid));
					$amt=0;
					while($r1=$qy->fetch())
					{
						
						$headarray[$i]['amount']=$r1->totalamt;
					}	
				} */
				if(isset($_POST['division']))
				{
					$estno= Utils::getName($_POST['division'],'DivisionMaster','Establishment',$this->db);
					$divacc= Utils::getName($_POST['division'],'DivisionMaster','Account',$this->db);	
					$res = array();
					$res['salaryid'] = 0;
					$res['edr'] = "SCR";///Utils::getName($_POST['division'],'DivisionMaster','ShortName',$this->db);	
					$res['empuniqueid'] = "$estno";
					$res['bankcode'] = $divacc;
					$res['banaccountno'] = date("Y-m-d");  ////////////////////date of salary generate///////
					$res['salaryfirstday'] = date("H:i"); /////////////time of salary generate////////////
					$res['salaryfirstday'] = str_replace(":","",$res['salaryfirstday'] );
					$res['salarylastday'] = date("m",strtotime($month)).date("Y",strtotime($month));
					$divid=$_POST['division'];
					/* if($estno!="")
						$divid=$this->getDivisionByEstno($estno); */
					//////////// salary month
					 $curid=Utils::getName($_POST['division'],'DivisionMaster','CurrencyId',$this->db);	
					$res['secondlast']=Utils::getName($_POST['division'],'DivisionMaster','Email',$this->db);	
					$res['last']=Utils::getName($divid,'DivisionMaster','Name',$this->db);	
					$res['emppaiddays'] = $count;
					//$res['emppaiddays'] =  cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
					$res['netpay'] =number_format((float)$grandnettotals, 2, '.', ''); 
					$res['basicsalary'] = $grandbasictotal + $grandtotal-$grandtotaldeduction;
					$res['lastrow'] = 1;
					$res['emptotal'] =Utils::getName($curid,'CurrencyMaster','CurrencyCode',$this->db);	
					$res['absentdays'] =Utils::getName($_POST['division'],'DivisionMaster','Name',$this->db);
					
				}else{
					/* $res = array();
					$res['salaryid'] = 0;
					$res['edr'] = "";
					$res['name'] = "Grand Total";
					$res['empdivision'] = "Grand Total";
					$res['empctc'] = $grandctc;
					$res['emppaiddays'] = $count;
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					//$res['salarydetail'] = $headarray;
					$res['emptotal'] = $grandtotal;
					$res['emptotaldeduction'] = $grandtotaldeduction;
					$res['netpay'] = number_format((float)$grandnettotals, 2, '.', ''); 
					$res['secondlast']="00.0";
					$res['last']="0"; */
					
				}	
				
				$data[] = $res;
		
		}
		
		
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		if(isset($_POST['fromdate']) )
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
    }
	
	public function getMonthDubaiSIFDetailBck()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			
			if($_POST['division']!=0)
			{
				$swhere.="AND Division=".$_POST['division'];
			}
		}
		if(isset($_POST['department']))
		{
			
			if($_POST['department']!=0)
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['visa']))
		{
			
			if($_POST['visa']!=0)
			{
				$swhere.=" AND Visa=".$_POST['visa'];
			}
		}
		$grandtotal=0;$grandbasictotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
			$headarray=array();			
			////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
			$sql1 = "SELECT Id,Name,HeadType FROM SalaryHead WHERE OrganizationId = ? ORDER BY field(HeadType, 4,1,2,3),Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ));
			while($row1 = $query1->fetch())
			{
				$status=true;
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['namematch'] =$row1->Name;
				$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->HeadType==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 1;
				$res1['additions']=(($row1->HeadType==3)?0:1);
				$res1['headtype'] = (int)$row1->HeadType;
				$headarray[]=$res1;
			}
			///////////  LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////				
			$sql1 = "SELECT Id,Name,Type FROM SalaryOtherHead ORDER BY Type,Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($row1 = $query1->fetch())
			{
				$status=true;
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['namematch'] =$row1->Name;
				$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['label'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
				$res1['type'] = 2;
				$res1['additions']=(($row1->Type==0)?0:1);
				$res1['headtype'] = (int)$row1->Type;
				$headarray[]=$res1;
			}
			$this->db->beginTransaction();	
			$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankCode as bankcode,sm.BankAccountNo as bankacc,em.Visa as visa  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids) $swhere  order by Division, DOJ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankCode as bankcode,sm.BankAccountNo as bankacc,em.Visa as visa FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=?  $swhere  order by Division, DOJ ";//and FinalSettlementSts=0
			}
		//	echo $sql."  ".$month;
		
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				$status=true;
				while($row = $query->fetch())
				{
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->sid;
					$res['employee'] = $row->EmployeeId;
					$res['edr'] = "EDR";
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					//$res['empctc'] = $row->EmployeeCTC;
					$estno =  ($row->UniqueId=="")?"N/A":$row->UniqueId;
					$res['empuniqueid'] = Utils::decode5t($estno);
					$res['bankcode'] = Utils::decode5t($row->bankcode);
					$res['banaccountno'] = Utils::decode5t($row->bankacc);
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['absentdays']=$this->getEmpLateEarlyLeaving($row->EmployeeId,$month,2);
					$res['empcode'] = $row->EmployeeCode;
					$estno= Utils::getName($row->Division,'DivisionMaster','Establishment',$this->db);
					$divacc= Utils::getName($row->Division,'DivisionMaster','Account',$this->db);
					$res['empdivisionsif'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db)."   |     Establishment Number : $estno"."    |  Code of FGB : $divacc";
					$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$ctc = $row->empctc;	
					$res['empctc']=$row->empctc;
					$res['secondlast']="";
					$res['last']="0";
					$res['salaryfirstday'] =date('Y-m-01', strtotime($month));
					// Last day of the month.
					$res['salarylastday']=date('Y-m-t', strtotime($month));
					$res['salarydetail'] = array();
					
					
					$grandctc += $row->empctc; 
					$granddays +=$row->PaidDays;
					
					
					////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////	
					$basicsalary=0;
					$sql1 = "SELECT HeadId,HeadAmount,HeadType from SalaryChild where SalaryId=? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $salaryid ));
					while($row1 = $query1->fetch())
					{
						if($row1->HeadType==1){   /////////Salary head/////////
							for($i=0;$i<count($headarray);$i++){
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==1))
								{
									if($headarray[$i]['namematch'] == "Basic Salary" || $headarray[$i]['namematch'] == "Base Salary")
									{
										$basicsalary = $row1->HeadAmount;
									}
									$headarray[$i]['amount']= $row1->HeadAmount;
									if(!$headarray[$i]['additions']){
										$emptotaldeduction +=$row1->HeadAmount;
									}
									else{
										if($headarray[$i]['namematch'] == "Basic Salary" || $headarray[$i]['namematch']== "Base Salary")
										{
											break;
										}else{
											$emptotal += $row1->HeadAmount;
										}
									}
									break;
									
								}
							
							}
						}
						if($row1->HeadType==2){ //////salary other head//////////
							for($i=0;$i<count($headarray);$i++){	
								if(($headarray[$i]['id']==$row1->HeadId) && ($headarray[$i]['type']==2))
								{
									$headarray[$i]['amount']=$row1->HeadAmount;
									if(!$headarray[$i]['additions'])
									$emptotaldeduction +=$row1->HeadAmount;
									else
									$emptotal +=$row1->HeadAmount;
										
										break;
								}
							}
						}
					}
					
						$res['empmonthdate']= $month;
						$res['empmonthname']=Utils::monthdateformatter($month);
						
						
						//$res['salarydetail']=$headarray;
						
						for($i=0; $i<count($headarray); $i++)
						{
							$headarray[$i]['amount']=0 ;
						}
						
					
					$res['emptotaldeduction'] = $emptotaldeduction;
					$netpay= $emptotal-$emptotaldeduction;
					$res['netpay'] = number_format((float)$netpay, 2, '.', '');
					$res['basicsalary'] = $basicsalary;
					$res['empctc'] = $ctc;
					
					$res['emptotal'] = $emptotal;
					$res['lastrow'] = 0;
					$res['sts'] = true;
					$data[] = $res;
					$grandbasictotal +=$basicsalary;
					$grandtotal +=$emptotal;
					$grandtotaldeduction += $emptotaldeduction;
					$grandnettotals +=($emptotal-$emptotaldeduction);
				}
				/* for($i=0; $i<count($headarray); $i++)
				{
					$headarray[$i]['amount']="" ;
					///////////////// CALCULATING HEADS TOTAL///////////////
					
					$sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=? and  HeadType =? and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=?) ";
					$qy=$this->db->prepare($sl);
					$qy->execute(array($headarray[$i]['id'],$headarray[$i]['type'],$month,$orgid));
					$amt=0;
					while($r1=$qy->fetch())
					{
						
						$headarray[$i]['amount']=$r1->totalamt;
					}	
				} */
				if(isset($_POST['division']))
				{
					$estno= Utils::getName($_POST['division'],'DivisionMaster','Establishment',$this->db);
					$divacc= Utils::getName($_POST['division'],'DivisionMaster','Account',$this->db);	
					$res = array();
					$res['salaryid'] = 0;
					$res['edr'] = "SCR";///Utils::getName($_POST['division'],'DivisionMaster','ShortName',$this->db);	
					$res['empuniqueid'] = "$estno";
					$res['bankcode'] = $divacc;
					$res['banaccountno'] = date("Y-m-d");  ////////////////////date of salary generate///////
					$res['salaryfirstday'] = date("H:i"); /////////////time of salary generate////////////
					$res['salaryfirstday'] = str_replace(":","",$res['salaryfirstday'] );
					$res['salarylastday'] = date("m",strtotime($month)).date("Y",strtotime($month));
					$divid=$_POST['division'];
					/* if($estno!="")
						$divid=$this->getDivisionByEstno($estno); */
					//////////// salary month
					 $curid=Utils::getName($_POST['division'],'DivisionMaster','CurrencyId',$this->db);	
					$res['secondlast']=Utils::getName($_POST['division'],'DivisionMaster','Email',$this->db);	
					$res['last']=Utils::getName($divid,'DivisionMaster','Name',$this->db);	
					$res['emppaiddays'] = $count;
					//$res['emppaiddays'] =  cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
					$res['netpay'] =number_format((float)$grandnettotals, 2, '.', ''); 
					$res['basicsalary'] = $grandbasictotal + $grandtotal;
					$res['lastrow'] = 1;
					$res['emptotal'] =Utils::getName($curid,'CurrencyMaster','CurrencyCode',$this->db);	
					$res['absentdays'] =Utils::getName($_POST['division'],'DivisionMaster','Name',$this->db);
					
				}else{
					/* $res = array();
					$res['salaryid'] = 0;
					$res['edr'] = "";
					$res['name'] = "Grand Total";
					$res['empdivision'] = "Grand Total";
					$res['empctc'] = $grandctc;
					$res['emppaiddays'] = $count;
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					//$res['salarydetail'] = $headarray;
					$res['emptotal'] = $grandtotal;
					$res['emptotaldeduction'] = $grandtotaldeduction;
					$res['netpay'] = number_format((float)$grandnettotals, 2, '.', ''); 
					$res['secondlast']="00.0";
					$res['last']="0"; */
					
				}	
				
				$data[] = $res;
		
		}
		
		
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		if(isset($_POST['fromdate']) )
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
    }
	
	public function getCurrentSalaryGenerateDate($month)
	{
		//$month= date("Y-m-d");
		$orgid = $_SESSION['ubihrm_org_id'];
		
        $sql = "SELECT CreatedDate FROM SalaryGenerateMonth WHERE OrganizationId = ?  and SalaryMonth=? limit 1";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array( $orgid ,$month));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$month = $row->CreatedDate;
			}
        }
		
		return $month;
	}		

	public function getNJVdata()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$div1=0; $div=0; $channel=0; $depart=0;
		$month = isset($_POST['salarymonth'])?($_POST['salarymonth']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division1']))
		{
			$div1=$_POST['division1'];
			if($_POST['division1']!=0 && $_POST['division1']!='')
			{
				$swhere .=" AND Division=".$_POST['division1'];
			}
		}
		if(isset($_POST['division']))
		{
			$div=$_POST['division'];
			if($_POST['division']!=0 && $_POST['division']!='')
			{
				$swhere .=" AND Channel=".$_POST['division'];
			}
		}
		if(isset($_POST['department']))
		{
			$depart=$_POST['department']; 
			if($_POST['department']!=0 && $_POST['department']!='')
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['channel']))
		{
			$channel=$_POST['channel'];
			if($_POST['channel']!=0 && $_POST['channel']!='')
			{
				$swhere.=" AND CostCentre=".$_POST['channel'];
			}
		}
		
		
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
			if($swhere!=""){
			$headarray=array();
			
			////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
			$sql1 = "SELECT Id,Name,HeadType,Code,Main,Sub,Description FROM SalaryHead WHERE OrganizationId = ? and HeadType <> 3 and Id in (select  HeadId from SalaryChild where HeadType =1 and SalaryId in (Select Id from SalaryMaster where OrganizationId = ? and SalaryMonth = ?)) ORDER BY field(HeadType, 4,1,2,3),Id";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid,$orgid, $month ));
			while($row1 = $query1->fetch())
			{
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['main'] = $row1->Main;
				$res1['sub'] = $row1->Sub;
				$res1['desc'] = $row1->Description;
				$res1['amount'] = 0;
				$name=($row1->Code=="")?$row1->Name:$row1->Code;
				$res1['name'] =(($row1->HeadType==3)?"(-) ":"(+) ").($name);
				$res1['label'] =(($row1->HeadType==0)?"(-) ":"(+) ").$name;
				$res1['type'] = 1;
				$res1['additions']=(($row1->HeadType==3)?0:1);
				$res1['headtype'] = (int)$row1->HeadType;
				$headarray[]=$res1;
			}
			
			$this->db->beginTransaction();	
			
			
					
			$amount=0;
			for($i=0; $i<count($headarray); $i++)
			{
				$res=array();
				$res['divname']=Utils::getName($div,'ChannelMaster','Code',$this->db);
				$res['department']=Utils::getName($depart,'DepartmentMaster','Code',$this->db);
				$res['channel']=Utils::getName($channel,'CostCentre','Code',$this->db);
				$res['curdate']=Utils::dateformatter(date("Y-m-d"));
				$res['currency']=$_SESSION['ubihrm_currencycode'];
				$res['main']=$headarray[$i]['main'];
				$res['sub']=$headarray[$i]['sub'];
				$res['desc']=$headarray[$i]['desc'];
				$res['dbcr']=($headarray[$i]['headtype']==3)?"C":"D";
				$res['amount']=0;
				$res['empmonthname']=date("F Y",strtotime($month));
				$headamount=0;
				///////////////// CALCULATING HEADS TOTAL///////////////
				//////////////////////ALL ADDITIONS//////////////////////////
				$headid=$headarray[$i]['id']; 
				  $sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=$headid and  HeadType =1  and SalaryId in (Select Id from SalaryMaster where SalaryMonth='$month' and OrganizationId=$orgid and EmployeeId in (Select Id from EmployeeMaster where OrganizationId=$orgid $swhere )) ";
				$qy=$this->db->prepare($sl);
				$qy->execute();
				$amt=0;
				
				while($r1=$qy->fetch())
				{
					//echo $headarray[$i]['type']."-". $r1->totalamt."<br>";
					if( $r1->totalamt){
						$headamount=(int) $r1->totalamt;
						$amount=$amount+$headamount;
					}
				}	
				
				///////////////////ALL DEDUCTIONS///////////////////////////////
				
				/* $sl="SELECT sum(HeadAmount) as totalamt FROM SalaryChild  where HeadId=? and  HeadType =1 and HeadAddDeduct in (0,3) and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=? and EmployeeId in (Select Id from EmployeeMaster where OrganizationId=? $swhere)) ";
				$qy=$this->db->prepare($sl);
				$qy->execute(array($headarray[$i]['id'],$month,$orgid,$orgid));
				$amt=0;
				while($r1=$qy->fetch())
				{
					//echo $headarray[$i]['type']."-". $r1->totalamt."<br>";
					if( $r1->totalamt){
						$headamount=(int) $r1->totalamt;
						$amount=$amount-$headamount;
					}
				}	 */
				$res['amount']=$headamount;
				$data[]=$res;						
			} 
			$res=array();
			$res['divname']="<b>".Utils::getName($div,'ChannelMaster','Code',$this->db)."</b>";
			$res['department']="<b>".Utils::getName($depart,'DepartmentMaster','Code',$this->db)."</b>";
			$res['channel']="<b>".Utils::getName($channel,'CostCentre','Code',$this->db)."</b>";
			
			$res['curdate']="";
			$res['currency']="<b>".$_SESSION['ubihrm_currencycode']."</b>";
			$res['main']="<b>Total</b>";
			$res['sub']="";
			$res['desc']="";
			$res['dbcr']="<b>C</b>";
			$res['amount']=$amount;
			$data[] = $res;
					
			
			$this->db->commit(); 
			}		 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['div']=$div1;
		$result['divsupp']=$div;
		$result['channel']=$channel;
		$result['depart']=$depart;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		
		
		return $result;
    }
	
	public function getGratuityNJVdata()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['salarymonth'])?($_POST['salarymonth']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		if(isset($_POST['department']))
		{
			if($_POST['department']!=0 && $_POST['department']!='')
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['costcentre']))
		{
			if($_POST['costcentre']!=0 && $_POST['costcentre']!='')
			{
				$swhere.=" AND Channel=".$_POST['costcentre'];
			}
		}
		
		////////////////////////////////////////////////////////////////////
		$swhere1="";
		
		if(isset($_POST['costcentre']))
		{
			if($_POST['costcentre']!=0 && $_POST['costcentre']!='')
			{
				$swhere1.=" AND Id=".$_POST['costcentre'];
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
					$this->db->beginTransaction();	
			//////////////////////GRATUITY EXPENSES//////////////////////////
				 $sl="SELECT * FROM `SalaryChild` WHERE HeadType =2 AND HeadId =10 and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=?) ";
					
				$qy=$this->db->prepare($sl);
				$qy->execute(array($month,$orgid));
				$amt=0;
				
				while($r1=$qy->fetch())
				{
					$sql = "SELECT * from SalaryMaster where Id=? ";
					$query = $this->db->prepare($sql);
					$query->execute(array( $r1->SalaryId));
					while($row = $query->fetch()) {
						$res=array();
						$empid=$row->EmployeeId;
						$div=Utils::getName($row->EmployeeId,'EmployeeMaster','Division',$this->db);
						$res['divname']=Utils::getName($div,'DivisionMaster','Code',$this->db);
						$res['curdate']=Utils::dateformatter(date("Y-m-d"));
						$res['currency']=$_SESSION['ubihrm_currencycode'];
						$res['main']=$this->getOtherHead(10,'Code');
						$res['sub']=$this->getOtherHead(10,'Sub');
						$mon=$res['empmonthname']=date("F Y",strtotime($month));
						$res['desc']="GRATUITY ACCRUAL FOR $mon";
						$res['dbcr']="C";
						$res['amount']=$r1->HeadAmount;
						
						$data[]=$res;
						
					}
				}	
				
				//////////////////////GRATUITY ACCRUAL//////////////////////////
				
				 $sl="SELECT * FROM `SalaryChild` WHERE HeadType =2 AND HeadId =30 and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=?) ";
					
				$qy=$this->db->prepare($sl);
				$qy->execute(array($month,$orgid));
				$amt=0;
				
				while($r1=$qy->fetch())
				{
					$sql = "SELECT * from SalaryMaster where Id=? ";
					$query = $this->db->prepare($sql);
					$query->execute(array( $r1->SalaryId));
					while($row = $query->fetch()) {
						$res=array();
						$empid=$row->EmployeeId;
						$div=Utils::getName($row->EmployeeId,'EmployeeMaster','Division',$this->db);
						$res['divname']=Utils::getName($div,'DivisionMaster','Code',$this->db);
						$res['curdate']=Utils::dateformatter(date("Y-m-d"));
						$res['currency']=$_SESSION['ubihrm_currencycode'];
						$res['main']=$this->getOtherHead(30,'Code');
						$res['sub']=$this->getOtherHead(30,'Sub');
						$mon=$res['empmonthname']=date("F Y",strtotime($month));
						$res['desc']="GRATUITY ACCRUAL FOR $mon";
						$res['dbcr']="D";
						$res['amount']=$r1->HeadAmount;
						
						$data[]=$res;
					}
				}	
		
			
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $data;
    }
	
	
	public function getNJVdataEmpwise()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['salarymonth'])?($_POST['salarymonth']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		if(isset($_POST['department']))
		{
			if($_POST['department']!=0 && $_POST['department']!='')
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['costcentre']))
		{
			if($_POST['costcentre']!=0 && $_POST['costcentre']!='')
			{
				$swhere.=" AND Channel=".$_POST['costcentre'];
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
		
			$this->db->beginTransaction();	
			$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankName as bankname, sm.BankCode as bankcode,sm.BankAccountNo as bankacc, sm.CreatedDate as paymentdate  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids) $swhere order by Division, DOJ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc,sm.BankName as bankname,sm.BankCode as bankcode,sm.BankAccountNo as bankacc, sm.CreatedDate as paymentdate,sm.EmployeeCTC as totalamt  FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=?  $swhere  order by Division, EmployeeCode, FirstName, MiddleName, LastName ";//and FinalSettlementSts=0
			}
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				while($row = $query->fetch()) {
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					
					$res['empname'] = $row->FirstName;
					$res['dbcr'] = "D";
					$res['vchno'] = "JV-001";
					$res['vchtype'] = "IMPORT-JV";
					$res['narrationforentry'] = "Salary";
					$res['narration'] = "Salary";
					$res['costcentre'] = Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['channelterritory'] = Utils::getName($row->CostCentre,'CostCentre','Name',$this->db);
					$res['salaryfirstday'] =Utils::dateformatter(date('Y-m-01', strtotime($month)));
					$res['salarymonth'] =date('F Y', strtotime($month));
					
					$res['totalamt'] = $row->totalamt;
					$data[] = $res;
					$grandtotal +=(int)$row->totalamt;
					
				}
				
					$res = array();
					$res['salaryid'] = 0;
					$res['empname'] = "";
					$res['channelterritory'] = "";
					$res['costcentre'] = "";
					$res['vchno'] = "JV-001";
					$res['vchtype'] = "IMPORT-JV";
					$res['narrationforentry'] = "Salary Payment";
					$res['narration'] = "Salary Payment";
					$res['salaryfirstday'] =Utils::dateformatter(date('Y-m-01', strtotime($month)));
					$res['salarymonth'] =date('F Y', strtotime($month));
					$res['dbcr'] = "C";
					$res['totalamt'] = (int)$grandtotal;
					
					$data[] = $res;
				
			}
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $data;
    }
	
	/////////////////////EMPLOYEE FUND DETAILS/////////////////////////////////////////////////////////////
	
	public function getFundDetail($val)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['salarymonth'])?($_POST['salarymonth']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		if(isset($_POST['department']))
		{
			if($_POST['department']!=0 && $_POST['department']!='')
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['costcentre']))
		{
			if($_POST['costcentre']!=0 && $_POST['costcentre']!='')
			{
				$swhere.=" AND Channel=".$_POST['costcentre'];
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
		
			
			$this->db->beginTransaction();	
			 $sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=? and sm.EmployeeId in ($ids) $swhere   order by Division, DOJ";
			if($hrsts==1 || $sts==1){
				 $sql = "SELECT *, sm.Id as sid,em.EmployeeCTC as empctc FROM SalaryMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and sm.OrganizationId = ? and SalaryMonth=?  $swhere order by Division, EmployeeCode, FirstName, MiddleName, LastName "; //and FinalSettlementSts=0
			}
			
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				while($row = $query->fetch())
				{
					$emptotal = 0;
					$emptotaldeduction = 0;
					$onedaysal =0;
					$res = array();
					$salaryid=$res['salaryid'] = $row->sid;
					$res['employee'] = $row->EmployeeId;
					$res['empmonthdate'] = $row->SalaryMonth;
					$res['desc'] = $row->Description;
					//$res['empctc'] = $row->EmployeeCTC;
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['empcode'] = $row->EmployeeCode;
					$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdepartment'] = Utils::getName($row->Department,'DepartmentMaster','Code',$this->db);
					$res['empchannel'] = Utils::getName($row->Channel,'ChannelMaster','Code',$this->db);
					$ctc = $row->empctc;	
					$res['empctc']=$row->empctc;
					$divcur= Utils::getDivisioncurrency($row->Division,$this->db);
					$res['empcurrency']=$divcur;
					
					
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					
					/////////////////////// 27 IS FOR ESI 26 FOR PF 28 FOR TDS //////////////////
					
					$headid=27;
					if($val==2)
						$headid=26;
					elseif($val==3)
						$headid=28;
						
					$sl="SELECT HeadAmount FROM SalaryChild where HeadId=$headid and HeadType=2 and SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=? and EmployeeId=?)";
					$qy=$this->db->prepare($sl);
					$qy->execute(array($month,$orgid,$row->Id));
					$amt=0;
					while($r1=$qy->fetch())
					{
						$emptotal=(int) $r1->HeadAmount;
					}

					
					$res['fundamt']=	$emptotal;
					$data[] = $res;	
						
				}
			
		}
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $data;
    }
	
	////////////////////////////////////// GET MONTHLY PAYROLL GRAND TOTAL/////////////////////
	
	public function getMonthPayrollTotal1()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$month = isset($_POST['salarymonth'])?($_POST['salarymonth']):"";
		if($month =="")
		{
			$month = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			$swhere="AND EmployeeId in(select Id from EmployeeMaster where  Division=".$_POST['division'].")";
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		try{
		
			
		$this->db->beginTransaction();	
		$sqls = "SELECT sum(EmployeeCTC) as totalpayroll,PaidDays FROM SalaryMaster where OrganizationId=? and SalaryMonth =? $swhere ";//and FinalSettlementSts=0
		$querys = $this->db->prepare($sqls);
		$querys->execute(array( $orgid,$month));
		
        $sql = "SELECT sum(EmployeeCTC) as totalpayroll,PaidDays FROM SalaryMaster where OrganizationId=? and SalaryMonth =? and EmployeeId in ($ids) $swhere  ";
		if($hrsts==1 || $sts==1){
			$sql = "SELECT sum(EmployeeCTC) as totalpayroll,PaidDays FROM SalaryMaster where OrganizationId=? and SalaryMonth =? $swhere ";//and FinalSettlementSts=0
		}
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$month));
			$count=$query->rowCount();
			if($query->rowCount() > 0){
				while($row = $query->fetch())
				{
					$headarray1=array();
					$sl="SELECT sum( HeadAmount ) AS totalhead, HeadId , HeadType FROM SalaryChild  where SalaryId in (Select Id from SalaryMaster where SalaryMonth=? and OrganizationId=?) GROUP BY HeadType , HeadId";
					$qy=$this->db->prepare($sl);
					$qy->execute(array($month,$orgid));
					while($r1=$qy->fetch())
					{
						$res1=array();
						$res1['amount'] = $r1->totalhead;
						$addeductsts=($this->getOtherHead($r1->HeadId,'Type')==0)?"(-)":"(+)";
						$addeductsts1=(Utils::getName($r1->HeadId,'SalaryHead','HeadType',$this->db)==3)?"(-)":"(+)";
						$res1['name'] =($r1->HeadType==1)?$addeductsts1.Utils::getName($r1->HeadId,'SalaryHead','Name',$this->db):$addeductsts.$this->getOtherHead($r1->HeadId,'Name');
						$headarray1[]=$res1;
					}	
					
					$res = array();
					
					$res['emppaiddays'] = $row->PaidDays;
					$res['empmonthname'] =date("F Y",strtotime(date($month)));
					$res['salarydetail'] = $headarray1;
					$res['emptotal'] = $row->totalpayroll;
					
					$data[] = $res;
				}
				
				
		
		}
		$this->db->commit(); 
				 
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($month)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $data;
    }
	
	////////////////////fetch addition and deduction of employee///////////////////////
	
	public function getEmployeeAdditionDeduction()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		$swhere ="";
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$salarymonth = isset($_POST['fromdate'])?(Utils::getDateformat($_POST['fromdate'])):"";
		if($salarymonth =="")
		{
			$salarymonth = $this->getcurrentsalarymonth($orgid);
		}
		if(isset($_POST['division']))
		{
			$swhere="AND EmployeeId in (select Id from EmployeeMaster where Division=".$_POST['division'].")";
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		$sql = "select * from SalaryMaster sm,SalaryChild sc where sm.Id=sc.SalaryId and sm.OrganizationId=? and SalaryMonth=? and HeadAddDeduct in(0,1,3) $swhere and HeadAmount<>0 order by HeadAddDeduct, HeadId ";
		
        
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid, $salarymonth ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->HeadId;
				$res['employeecode'] = Utils::getName($row->EmployeeId,'EmployeeMaster','EmployeeCode',$this->db);
				$res['employee'] = Utils::getEmployeeName($row->EmployeeId,$this->db);
				$res['amount'] = (int)$row->HeadAmount;					
				$res['name'] =($row->HeadType==1)?Utils::getName($row->HeadId,'SalaryHead','Name',$this->db):$this->getOtherHead($row->HeadId,'Name');
				$res['additions'] = ($row->HeadAddDeduct==1)?$row->HeadAmount:0;
				$res['deduction'] =  ($row->HeadAddDeduct==3 || $row->HeadAddDeduct==0)?$row->HeadAmount:0;
				$res['empmonthname'] = date("F Y",strtotime(date($salarymonth)));
				$data[]=$res;
			}	
				
        }
			$status=true;
		$result["data"] =$data;
		$result['status']=$status;
		$result['salarymonth']=date("F Y",strtotime(date($salarymonth)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		if(isset($_POST['fromdate']))
		{
			return $result;
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		return $data;
    }
	public function getAssessmentEmployee($assessid, $desigid)
	{
		$name ="0";
		$sql = "SELECT EmployeeId FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ? and DesignationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $assessid, $desigid  ));
			while($row = $query->fetch())
			{
				$name = $row->EmployeeId;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	public function getWeightage($id)
	{
		$empcode =0;
		$sql = "SELECT Weightage FROM AssessmentObjectiveChild WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->Weightage;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	public function getRatingArray($empid,$id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		
		//$objective = json_decode($_POST['results'], true); 
			try{
			$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $empid ));
			while($row1 = $query2->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $desig ));
			while($row1 = $query2->fetch())
			{
				$aid=$row1->Id;
			}
			$sql3 = "SELECT DISTINCT Level FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? ORDER BY Level desc";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array( $id ));
			while($row3 = $query3->fetch())
			{
				$score=0;
				$level=$row3->Level;
				$sql4 = "SELECT Score,DesignationLevel,ObjectiveId FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? and Level=?";
				$query4 = $this->db->prepare($sql4);
				$query4->execute(array( $id,$level ));
				while($row4 = $query4->fetch())
				{
					$avgscore=0;
					$weightage=self::getWeightage($row4->ObjectiveId);
					if($row4->Score != 0)
						$avgscore=$weightage * ($row4->Score/100);
					$score=$score+$avgscore;
					$desigl=$row4->DesignationLevel;
				}
				if($score>0){	
					$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $aid ));
					if($score > 100)
						$score=100;
					while($row1 = $query2->fetch())
					{
						$min=$row1->MinMarks;
						$max=$row1->MaxMarks;
						//echo "min $min </br> max $max </br> score $score";
						if(($score >= $min) && ($score <= $max))
						{
							$res=array();
							$res['score']=$score;
							$res['comments']=$row1->Result;
							$res['rating']=$row1->Rating;	
							$res['level']=$level;	
							//$res['approvedby']=Utils::getName($desigl,'DesignationMaster','Name',$this->db);
							$empid1 = $this->getAssessmentEmployee($id, $desigl);
							$res['approver'] = Utils::getEmployeeName($empid1, $this->db);
							$data[ ]=$res;
						}
									
					}
				}
						
			}
					
			$status=true;
			$successMsg=$count." record found";
			$count =  $query2->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}	
        			
		return $data;
    }
	////////////////This report is for performance assessment of employee,their assessments are to be completed////////
	public function EmployeeAssessmentCompleteReport()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND EmployeeId in (Select Id from EmployeeMaster where Designation=".$_POST['division'].")";
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT Id,EmployeeId,FromDate,ToDate FROM EmployeeAssessment Where EmployeeId in ($ids) and OrganizationId =? and FromDate>='$startdate' and ToDate<='$enddate' and AssessmentSts=1  $swhere order by EmployeeId";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT Id,EmployeeId,FromDate,ToDate FROM EmployeeAssessment Where OrganizationId =? and FromDate>='$startdate' and ToDate<=Last_day('$enddate') and AssessmentSts=1  $swhere order by EmployeeId";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->EmployeeId,$this->db);
					$res['fromdate']=Utils::dateformatter($row->FromDate);
					$res['todate']=Utils::dateformatter($row->ToDate);
					$res['empcode']=Utils::getName($row->EmployeeId,'EmployeeMaster','EmployeeCode',$this->db);
					$div=Utils::getName($row->EmployeeId,'EmployeeMaster','Division',$this->db);
					$dept=Utils::getName($row->EmployeeId,'EmployeeMaster','Department',$this->db);
					$desig=Utils::getName($row->EmployeeId,'EmployeeMaster','Designation',$this->db);
					$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $desig ));
					while($row1 = $query2->fetch())
					{
						$aid=$row1->Id;
					}
					$res['empdiv']=Utils::getName($div,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($dept,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($desig,'DesignationMaster','Name',$this->db);
					$scorearr=array();
					$scorearr=self::getRatingArray($row->EmployeeId,$row->Id);
					
					
					$res['leveldetails']=$scorearr;
					$data[]=$res;
				}	
			}		
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['todate'])?Utils::dateformatter(date("Y-m-t",strtotime($enddate))):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}	
	
	public function EmployeeAssessmentCompleteSummaryReport()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		//$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		/* if($startdate ==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		} */
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND emp_id in (Select Id from EmployeeMaster where Designation=".$_POST['division'].")";
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM pi_master Where emp_id in ($ids) and OrganizationId =? and month ='$startdate' $swhere order by emp_id";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT *, FROM pi_master Where OrganizationId =? and month ='$startdate' $swhere order by emp_id";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=Utils::getEmployeeName($row->emp_id,$this->db);
					//$res['fromdate']=Utils::dateformatter($row->FromDate);
					//$res['todate']=Utils::dateformatter($row->ToDate);
					$res['empcode']=Utils::getName($row->emp_id,'EmployeeMaster','EmployeeCode',$this->db);
					$div=Utils::getName($row->emp_id,'EmployeeMaster','Division',$this->db);
					$dept=Utils::getName($row->emp_id,'EmployeeMaster','Department',$this->db);
					$desig=Utils::getName($row->emp_id,'EmployeeMaster','Designation',$this->db);
					/* $sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $desig ));
					while($row1 = $query2->fetch())
					{
						$aid=$row1->Id;
					} */
					$res['empdiv']=Utils::getName($div,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($dept,'DepartmentMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($desig,'DesignationMaster','Name',$this->db);
					$scorearr=array();
					//$scorearr=self::getRatingArray($row->emp_id,$row->Id);
					
					
					$res['leveldetails']=$scorearr;
					$data[]=$res;
				}	
			}		
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']="";
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}
	
	
	public function EmployeeAssessmentReport()
    {
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
		$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		
		if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		}
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND AssessmentObjectiveId in (select Id from AssessmentObjective where DesignationId= ".$_POST['division'].")";
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * from AssessmentObjectiveChild where OrganizationId=? $swhere";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array(); $assessmentobjid=0;
					$res['objective']=$row->Objective;
					//$res['empmonthname']=date("F Y",strtotime(date($startdate)));
					$res['fromdate']=Utils::dateformatter($startdate);
					$res['todate']=Utils::dateformatter(date("Y-m-t", strtotime($startdate)));
					$assessmentobjid=$row->AssessmentObjectiveId;
					$scorearr=array();
					$sql1 = "SELECT sum(Score) as score ,ec.Employeeassessmentid as assessmentid,ObjectiveId FROM EmployeeAssessmentChild ec,EmployeeAssessmentApproval ea where ec.EmployeeAssessmentId=ea.EmployeeAssessmentId and ec.Level=ea.level and ec.DesignationLevel=ea.DesignationId and AssessmentSts=1 and ObjectiveId=? and ec.Employeeassessmentid in (Select Id from EmployeeAssessment where OrganizationId=? and ? between FromDate and ToDate) group by ec.EmployeeAssessmentId,ObjectiveId";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id,$orgid,$startdate));
					while($row1=$query1->fetch())
					{
						$res1=array(); $empid=0;
						$empid=Utils::getName($row1->assessmentid,'EmployeeAssessment','EmployeeId',$this->db);
						$empdiv=Utils::getName($empid,'EmployeeMaster','Division',$this->db);
						$empdesig=Utils::getName($empid,'EmployeeMaster','Designation',$this->db);
						$res1['empname']=Utils::getEmployeeName($empid,$this->db);
						$res1['empdiv']=Utils::getName($empdiv,'DivisionMaster','Name',$this->db);
						$res1['empdesig']=Utils::getName($empdesig,'DesignationMaster','Name',$this->db);
						$res1['score']=$row1->score;
						$res1['rating']=$this->getEmployeeRating($row1->score,$assessmentobjid,'Rating');
						$res1['comments']=$this->getEmployeeRating($row1->score,$assessmentobjid,'Result');
						$sts=Utils::getName($row1->assessmentid,'EmployeeAssessment','AssessmentSts',$this->db);
						$res1['sts']=($sts)?"Completed":"Pending";
						$scorearr[]=$res1;
					}
					$res['emplist']=$scorearr;
					$data[]=$res;
				}	
			}		
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['todate'])?Utils::dateformatter(date("Y-m-t",strtotime($enddate))):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}	
	
	////////////////// Find out gratuity of employees on termination/////////
	public function EmployeeGratuity()
    {	
		$orgid = $_SESSION['ubihrm_org_id'];
		$result = array();
		$swhere="";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $leavetype=0;
		//$swhere="and LeaveDay Between $from and $to";
		
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$startdate = isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";
	 	$enddate =  isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";
		if($enddate == "")
			$enddate = date("Y-m-d");
		$dojcon=" and DOJ<'$enddate'";
		if($enddate == "")
			$dojcon="";
		
		
		$swhere =" ";
		if(isset($_POST['division']))
		{
			$swhere="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere =" ";
			}
		}
		if(isset($_POST['department']))
		{
			if($_POST['department']!=0)
			{
				$swhere.=" AND Department=".$_POST['department'];
			}
		}
		if(isset($_POST['costcentre']))
		{
			
			if($_POST['costcentre']!=0)
			{
				$swhere.=" AND Channel=".$_POST['costcentre'];
			}	
		}
	/*	if($startdate =="" && $enddate==""){
			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
			}
		} */
		
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster Where Id in ($ids) and OrganizationId =? and DOL='0000-00-00' $dojcon  $swhere order by Division,FirstName";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? and DOL='0000-00-00' $dojcon  $swhere order by Division,FirstName";
			}
			
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res=array();
					$res['empname']=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					$res['empmonthdate']=Utils::dateformatter(date('Y-m-d'));
					$res['empcode']=$row->EmployeeCode;
					$res['empdiv']=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
					$res['empdept']=Utils::getName($row->Department,'DepartmentMaster','Name',$this->db);
					$res['empcostcentre']=Utils::getName($row->CostCentre,'CostCentre','Name',$this->db);
					$res['empchannel']=Utils::getName($row->Channel,'ChannelMaster','Name',$this->db);
					$res['empdesig']=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
					$res['empdoj']=Utils::dateformatter($row->DOJ);
					$startdate = $row->DOJ;
					if(isset($_POST['fromdate']))
					{	
						if($_POST['fromdate']!="")
							$startdate = $_POST['fromdate'];
					}	
					/////////////////START/////////////////////////////////////////
					$resstart= Utils::getEmployeeGratuityNoExp( $row->Id, 1, $this->db,$startdate);
					$terstart= Utils::getEmployeeGratuityNoExp( $row->Id, 2, $this->db,$startdate);
					/////////////////////////////END DATE///////////////////////////
					$resend= Utils::getEmployeeGratuityNoExp( $row->Id, 1, $this->db,$enddate);
					$terend= Utils::getEmployeeGratuityNoExp( $row->Id, 2, $this->db,$enddate);
					$gratuityonres=$resend-$resstart;
					$gratuityonter=$terend-$terstart;
					
					$res['gratuityres']= $gratuityonres;
					$res['gratuityter']=$gratuityonter ;
					if($startdate == "" || $enddate=="")
					{
						$res['gratuityres']= $resstart;
						$res['gratuityter']=$terstart ;
					}
					
					$data[]=$res;
				}	
						
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result['data']=$data;
		$result['salarymonth']=isset($_POST['fromdate'])?Utils::monthdateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['todate'])?Utils::monthdateformatter($enddate):$enddate;
		if(isset($_POST['fromdate']))
		{	
			if($_POST['fromdate']=="")
				$result['salarymonth']=$result['enddate'];
		}	
		
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
		
	}	
	public function createDataTable($reportid)
	{
		try{
		$result=array();
		$result=$this->getDetail($reportid);
		$tablename= $result['data'][0]['module'];
		$selectedcol= $result['data'][0]['selectedcol'];
		$groupby= $result['data'][0]['groupby'];
		$customsts= $result['data'][0]['customsts'];
		
		$filter= $result['data'][0]['reportfilter'];
		
		$sTable = $tablename;
		$sIndexColumn = "Id";
		$aColumns =  $selectedcol;
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			$colname=$aColumns[$i];
			if($colname=='TotalExp')
			{
				$aColumns[$i]='doj';
			}
			if (strpos($aColumns[$i],'.') == true)
			{
				$temp=explode('.',$aColumns[$i]);
				$colname=$temp[1];
				if($colname=='TotalExp')
				{
					$aColumns[$i]=$temp[0].'.doj';
				}
			}
			
		}	
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		$sLimit = "";
		$sOrder="ORDER BY ";
		$temp=explode(' ',$groupby);
		array_splice( $temp, -1 );
		$groupby=implode( " ", $temp );
		if (!empty($groupby))
		{
			$sOrder .= $groupby ." " ;
		}
		//$sOrder = substr_replace( $sOrder, "", -2 );
		if ( $sOrder == "ORDER BY " )
			{
				$sOrder = "ORDER BY $aColumns[0] asc";
			}
			
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere="";	
		if($sts==1 || $hrsts==1){
		
			if($customsts==1){
				//////////this condition is for fetch employee's salary componenets/////////
				if($tablename == 'EmployeeSalaryDetails')
				{
					$sWhere="WHERE OrganizationId = $orgid and HeadId in (select Id from SalaryHead where IncludeInPayslip=1 and OrganizationId = $orgid) AND EmployeeId in (select Id from EmployeeMaster where EmployeeStatus in(4,5) and OrganizationId = $orgid )";
					$sOrder.=",HeadType desc";
				}
				//////////this condition is for fetch late comer /////////
				if($tablename == 'AttendanceMaster,ShiftMaster')
				{
					$sWhere="WHERE AttendanceMaster.OrganizationId = $orgid and AttendanceMaster.ShiftId=ShiftMaster.Id and  AttendanceMaster.TimeIn > ShiftMaster.TimeInGrace and AttendanceMaster.AttendanceStatus in (1,4) and AttendanceMaster.AttendanceDate=CURDATE()";
				}
				if($tablename == 'EmployeeLeave,EmployeeMaster')
				{
					$sWhere="WHERE EmployeeLeave.OrganizationId = $orgid  and EmployeeMaster.OrganizationId = $orgid and EmployeeLeave.EmployeeId=EmployeeMaster.Id and CURDATE() between EmployeeLeave.LeaveFrom and EmployeeLeave.LeaveTo and EmployeeLeave.LeaveStatus=2";
				}
				//////////this condition is for fetch employee's salary componenets/////////
				if($tablename == 'SalaryTypeMaster,SalaryTypeChild')
				{
					$sWhere="WHERE OrganizationId = $orgid  and SalaryTypeMaster.Id=SalaryTypeChild.SalaryId";
					
				}
			}elseif($customsts==5){
			//////////this condition is for fetch employee's upcoming birthdays/////////
				if($tablename == 'EmployeeMaster')
				{
					$sWhere="WHERE OrganizationId = $orgid and Month(DOB) = Month(CURDATE()) and DAY(DOB)>=DAY(CURDATE()) and DOL='0000-00-00'";
					$sOrder="Order by DAY(DOB)";
				}
				
			}
			else{
				if (strpos($tablename,',') == true)
				{
					
					$col1="";
					$table=explode(',',$tablename);
					
					if($table[0] == 'EmployeeMaster' && $table[1] != 'ShiftMaster'){
						if($table[1] != 'LeaveMaster')
						$col1="AND EmployeeMaster.Id=$table[1].EmployeeId ";
					}
					elseif($table[1] == 'EmployeeMaster' && $table[0] != 'ShiftMaster'){
						if($table[0] != 'LeaveMaster')
						$col1="AND EmployeeMaster.Id=$table[0].EmployeeId ";
						
					}
					elseif($table[0] == 'EmployeeMaster' && $table[1] == 'ShiftMaster'){
						$col1=" AND EmployeeMaster.Shift=ShiftMaster.Id  ";
					}
					elseif($table[0] == 'AttendanceMaster' && $table[1] == 'ShiftMaster'){
						$col1=" AND AttendanceMaster.ShiftId=ShiftMaster.Id  ";
					}
					elseif($table[0] == 'EmployeeLeave' && $table[1] == 'LeaveMaster'){
						$col1=" AND EmployeeLeave.LeaveTypeId=LeaveMaster.Id  ";
					}
					elseif (strpos($tablename,'SalaryTypeMaster') == true){
						$col1=" AND SalaryTypeMaster.Id=EmployeeMaster.BankAccount  ";
					}
					elseif($table[0] == 'pi_master' && $table[1] == 'pi_child'){
						$col1=" AND pi_master.id=pi_child.pi_id  ";
					}
					else{
						$col1=" ";
					}
					
					$sWhere = "WHERE $table[0].OrganizationId=$orgid AND $table[1].OrganizationId=$orgid $col1 ";
					
					if($table[0] == 'pi_master' && $table[1] == 'pi_child'){
						$sWhere = "WHERE $table[0].OrganizationId=$orgid $col1 ";
					}
					
					if($table[0]=='EmployeeSkills' || $table[1]=='EmployeeSkills')
					{
						$sWhere=" where EmployeeSkills.EmployeeId=EmployeeMaster.Id and OrganizationId = $orgid ";
					}
					if($table[0]=='EmployeeBankDetails' || $table[1]=='EmployeeBankDetails')
					{
						$sWhere=" where EmployeeBankDetails.EmployeeId=EmployeeMaster.Id and OrganizationId = $orgid ";
					}
					if($table[0]=='EmployeeLTADetail' || $table[1]=='EmployeeLTADetail')
					{
						$sWhere=" where EmployeeLTADetail.EmployeeId=EmployeeMaster.Id and OrganizationId = $orgid ";
					}
					if($table[0]=='EmployeeDependant' || $table[1]=='EmployeeDependant')
					{
						$sWhere=" where EmployeeDependant.EmployeeId=EmployeeMaster.Id and OrganizationId = $orgid ";
					}
					
				}
				else{
					$sWhere = "WHERE OrganizationId = $orgid ";
					if($tablename=='EmployeeSkills' || $tablename=='EmployeeBankDetails' || $tablename=='EmployeeLTADetail' || $tablename=='EmployeeDependant')
					{
						$sWhere=" where EmployeeId in (Select Id from EmployeeMaster where OrganizationId = $orgid )";
					}
				}
			}
		}
		else{
			if($customsts==1){
				if($tablename == 'EmployeeSalaryDetails')
				{
					$sWhere="WHERE OrganizationId = $orgid and HeadId in (select Id from SalaryHead where IncludeInPayslip=1 and OrganizationId = $orgid) AND EmployeeId in ($ids)";
				}
				if($tablename == 'AttendanceMaster,ShiftMaster')
				{
					$sWhere="WHERE AttendanceMaster.OrganizationId = $orgid and AttendanceMaster.ShiftId=ShiftMaster.Id and  AttendanceMaster.TimeIn > ShiftMaster.TimeInGrace and AttendanceMaster.AttendanceStatus in (1,4) and AttendanceMaster.EmployeeId IN ($ids) and AttendanceMaster.AttendanceDate=CURDATE()";
				}
				if($tablename == 'EmployeeLeave,EmployeeMaster')
				{
					$sWhere="WHERE EmployeeLeave.OrganizationId = $orgid  and EmployeeMaster.OrganizationId = $orgid and EmployeeLeave.EmployeeId=EmployeeMaster.Id and CURDATE() between EmployeeLeave.LeaveFrom and EmployeeLeave.LeaveTo and EmployeeLeave.LeaveStatus=2 and EmployeeLeave.EmployeeId IN ($ids)";
				}
			}elseif($customsts==5){
				if($tablename == 'EmployeeMaster')
				{
					$sWhere="WHERE OrganizationId = $orgid and Id in ($ids) and Month(DOB) = Month(CURDATE()) and DAY(DOB)>=DAY(CURDATE()) and DOL='0000-00-00'";
					$sOrder="Order by DAY(DOB)";
				}
			}
			
			else{
				if (strpos($tablename,',') == true)
				{	
					$table=explode(',',$tablename);
					
					if($table[0] == 'EmployeeMaster' && $table[1] != 'ShiftMaster'){
						$col1=" AND EmployeeMaster.Id=$table[1].EmployeeId  AND EmployeeMaster.Id IN ($ids)";
					}
					elseif($table[1] == 'EmployeeMaster' && $table[0] != 'ShiftMaster'){
						$col1=" AND EmployeeMaster.Id=$table[0].EmployeeId  AND EmployeeMaster.Id IN ($ids)";
					}
					elseif($table[0] == 'EmployeeMaster' && $table[1] == 'ShiftMaster'){
						$col1=" AND EmployeeMaster.Shift=ShiftMaster.Id  AND EmployeeMaster.Id IN ($ids)";
					}
					elseif($table[0] == 'AttendanceMaster' && $table[1] == 'ShiftMaster'){
						$col1=" AND AttendanceMaster.ShiftId=ShiftMaster.Id AND AttendanceMaster.EmployeeId IN ($ids )";
					}
					elseif($table[0] == 'EmployeeLeave' && $table[1] == 'LeaveMaster'){
						$col1=" AND EmployeeLeave.LeaveTypeId=LeaveMaster.Id  AND EmployeeLeave.EmployeeId IN ($ids)";
					}
					elseif($table[0] == 'pi_master' && $table[1] == 'pi_child'){
						$col1=" AND pi_master.id=pi_child.pi_id  ";
					}
					else{
						$col1=" ";
					}
					
					$sWhere = "WHERE $table[0].OrganizationId=$orgid AND $table[1].OrganizationId=$orgid $col1 ";
					if($table[0] == 'pi_master' && $table[1] == 'pi_child'){
						$sWhere = "WHERE $table[0].OrganizationId=$orgid $col1 ";
					}
					if($table[0]=='EmployeeSkills' || $table[1]=='EmployeeSkills')
					{
						$sWhere=" where EmployeeSkills.EmployeeId=EmployeeMaster.Id and EmployeeMaster.Id in ($ids)";
					}
				}
				else{
					if($tablename == 'EmployeeMaster'){
						$col1='Id';
						$sWhere = "WHERE OrganizationId = $orgid AND $col1 IN ($ids)";
					}
					elseif($tablename == 'DivisionMaster' || $tablename == 'DepartmentMaster' || $tablename == 'DesignationMaster' || $tablename == 'GradeMaster' || $tablename == 'HolidayMaster' || $tablename == 'ShiftMaster' || $tablename == 'AssetsMaster'){
						
						$sWhere = "WHERE OrganizationId = $orgid ";
					}
					else{
						$col1='EmployeeId';
						$sWhere = "WHERE OrganizationId = $orgid AND $col1 IN ($ids)";
						if($tablename=='EmployeeSkills' || $tablename=='EmployeeBankDetails' || $tablename=='EmployeeLTADetail' || $tablename=='EmployeeDependant')
						{
							$sWhere="WHERE $col1 IN ($ids)";
						}
					}				
					
				}
			}
		}
		if($sWhere == "" )
			$sWhere="where 1=1 ";
		if(!empty($filter) ){
					
				
				$orcondition="and ";
				for($i=0;$i<count($filter);$i++)
				{
					///////////////// ENCRYPT THE VALUE, WHEN THERE IS COLUMN WITH CONFIDENTIAL ENTRIES LIKE EMAIL, PHONE NUMBER, SALSRY ACCOUNT NUMBER, CODE AND NAME OF THE BANK ETC.../////
					
					if($filter[$i]['column'] == "SalaryMaster.BankCode" || $filter[$i]['column'] == "BankCode" ){
						$filter[$i]['textvalue1']=Utils::encode5t($filter[$i]['textvalue1']);
					}
					if($filter[$i]['column'] != "0" &&  $filter[$i]['condition1'] != "0" ){
						
						if($filter[$i]['condition2'] == 'between' || $filter[$i]['type'] == 'var' || $filter[$i]['type'] == 'tex' || $filter[$i]['type'] == 'tim'){
							$sWhere .= $filter[$i]['condition1']."( ". $filter[$i]['column']." ".$filter[$i]['condition2']." '".$filter[$i]['textvalue1']."' )";
						}
						else{
							if(isset($filter[$i+1]['condition1']))
							{
								if(($filter[$i+1]['condition1']) == 'OR' ){
									$orcondition = $filter[$i]['condition1']."( ";
								}else{
									$orcondition = $filter[$i]['condition1']." ";
								}
							}
							if(($filter[$i]['condition1']) == 'OR' ){
								$orcondition = $filter[$i]['condition1']." ";
							}
							$sWhere .= $orcondition. $filter[$i]['column']." ".$filter[$i]['condition2']." ".$filter[$i]['textvalue1']." ";
							
							if(($filter[$i]['condition1']) == 'OR' ){
								$sWhere .= ") ";
							}
							
						}
					}
					
					
				}
			
		}
		
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere  
		$sOrder
		$sLimit 
		
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		$total=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				$colname=$aColumns[$i];
				if (strpos($aColumns[$i],'.') == true)
				{
					$temp=explode('.',$aColumns[$i]);
					$colname=$temp[1];
				}
				$row[] =$this->getcolumnname($aColumns[$i],$tablename,$aRow->$colname,$customsts);
				//$row[]=$aRow->$colname;
			}			
			$output['aaData'][] = $row;
		
		}
		}catch(Exception $e) {
			
		}
		return  $output ;
	}
	////////////////default create the report//////////////
	public function createDataTable1($reportid)
	{
		try{
		$result=array();
		$result=$this->getDetail($reportid);
		$tablename= $result['data'][0]['module'];
		$selectedcol= $result['data'][0]['selectedcol'];
		$groupby= $result['data'][0]['groupby'];
		$customsts= $result['data'][0]['customsts'];
		
		$filter= $result['data'][0]['reportfilter'];
		
		$sTable = $tablename;
		$sIndexColumn = "Id";
		$aColumns =  $selectedcol;
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			$colname=$aColumns[$i];
			if($colname=='TotalExp')
			{
				$aColumns[$i]='doj';
			}
			if (strpos($aColumns[$i],'.') == true)
			{
				$temp=explode('.',$aColumns[$i]);
				$colname=$temp[1];
				if($colname=='TotalExp')
				{
					$aColumns[$i]=$temp[0].'.doj';
				}
			}
			
		}	
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		$sLimit = "";
		$sOrder="ORDER BY ";
		$temp=explode(' ',$groupby);
		array_splice( $temp, -1 );
		$groupby=implode( " ", $temp );
		if (!empty($groupby))
		{
			$sOrder .= $groupby ." " ;
		}
		//$sOrder = substr_replace( $sOrder, "", -2 );
		if ( $sOrder == "ORDER BY " )
			{
				$sOrder = "ORDER BY $aColumns[0] asc";
			}
			
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere="";	
		if($sts==1 || $hrsts==1){
		
			if($customsts==1){
				//////////this condition is for fetch employee's salary componenets/////////
				if($tablename == 'EmployeeSalaryDetails')
				{
					$sWhere="WHERE OrganizationId = $orgid and HeadId in (select Id from SalaryHead where IncludeInPayslip=1 and OrganizationId = $orgid) AND EmployeeId in (select Id from EmployeeMaster where (DOL='0000-00-00' or DOL>CURDATE()) and OrganizationId = $orgid )";
					$sOrder.=",HeadType desc";
				}
				//////////this condition is for fetch late comer /////////
				if($tablename == 'AttendanceMaster,ShiftMaster')
				{
					$sWhere="WHERE AttendanceMaster.OrganizationId = $orgid and AttendanceMaster.ShiftId=ShiftMaster.Id and  AttendanceMaster.TimeIn > ShiftMaster.TimeInGrace and AttendanceMaster.AttendanceStatus in (1,4) and AttendanceMaster.AttendanceDate=CURDATE()";
				}
				if($tablename == 'EmployeeLeave,EmployeeMaster')
				{
					$sWhere="WHERE EmployeeLeave.OrganizationId = $orgid  and EmployeeMaster.OrganizationId = $orgid and EmployeeLeave.EmployeeId=EmployeeMaster.Id and CURDATE() between EmployeeLeave.LeaveFrom and EmployeeLeave.LeaveTo and EmployeeLeave.LeaveStatus=2";
				}
				//////////this condition is for fetch employee's salary componenets/////////
				if($tablename == 'SalaryTypeMaster,SalaryTypeChild')
				{
					$sWhere="WHERE OrganizationId = $orgid  and SalaryTypeMaster.Id=SalaryTypeChild.SalaryId";
					
				}
			}elseif($customsts==5){
			//////////this condition is for fetch employee's upcoming birthdays/////////
				if($tablename == 'EmployeeMaster')
				{
					$sWhere="WHERE OrganizationId = $orgid and Month(DOB) = Month(CURDATE()) and DAY(DOB)>=DAY(CURDATE()) and (DOL='0000-00-00' or DOL>CURDATE())";
					$sOrder="Order by DAY(DOB)";
				}
				
			}
			else{
				if (strpos($tablename,',') == true)
				{	
					$col1="";
					$table=explode(',',$tablename);
					if($table[0] == 'EmployeeMaster' && $table[1] != 'ShiftMaster'){
						if($table[1] != 'LeaveMaster')
						$col1="AND EmployeeMaster.Id=$table[1].EmployeeId AND (EmployeeMaster.DOL='0000-00-00' or EmployeeMaster.DOL>CURDATE())";
					}
					elseif($table[1] == 'EmployeeMaster' && $table[0] != 'ShiftMaster'){
						if($table[0] != 'LeaveMaster')
						$col1="AND EmployeeMaster.Id=$table[0].EmployeeId AND (EmployeeMaster.DOL='0000-00-00' or EmployeeMaster.DOL>CURDATE())";
						
					}
					elseif($table[0] == 'EmployeeMaster' && $table[1] == 'ShiftMaster'){
						$col1=" AND EmployeeMaster.Shift=ShiftMaster.Id  AND (EmployeeMaster.DOL='0000-00-00' or EmployeeMaster.DOL>CURDATE())";
					}
					elseif($table[0] == 'AttendanceMaster' && $table[1] == 'ShiftMaster'){
						$col1=" AND AttendanceMaster.ShiftId=ShiftMaster.Id  and AttendanceMaster.EmployeeId in (select Id from EmployeeMaster where DOL='0000-00-00' or DOL>CURDATE())";
					}
					elseif($table[0] == 'EmployeeLeave' && $table[1] == 'LeaveMaster'){
						$col1=" AND EmployeeLeave.LeaveTypeId=LeaveMaster.Id and EmployeeLeave.EmployeeId in (select Id from EmployeeMaster where DOL='0000-00-00' or DOL>CURDATE())";
					}
					else{
						$col1=" ";
					}
					
					$sWhere = "WHERE $table[0].OrganizationId=$orgid AND $table[1].OrganizationId=$orgid $col1 ";
					if($table[0]=='EmployeeSkills' || $table[1]=='EmployeeSkills')
					{
						$sWhere=" where EmployeeSkills.EmployeeId=EmployeeMaster.Id ";
					}
				}
				else{
					$con="";
					if($tablename=="EmployeeMaster")
					$con="AND (DOL='0000-00-00' or DOL>CURDATE())";
					elseif($tablename=="EmployeeLeave" || $tablename=="AttendanceMaster" || $tablename=="EmployeeDocument" || $tablename=="EmployeeQualification" || $tablename=="EmployeeWorkExperience" || $tablename=="EmployeeIncentive" || $tablename=="EmployeeOvertime" || $tablename=="SalaryAdvance" || $tablename=="SalaryMaster")
					$con="AND EmployeeId in (select Id from EmployeeMaster where DOL='0000-00-00' or DOL>CURDATE())";
					$sWhere = "WHERE OrganizationId = $orgid $con";
					if($tablename=='EmployeeSkills' || $tablename=='EmployeeBankDetails')
					{
						$sWhere="";
					}
				}
			}
		}
		else{
			if($customsts==1){
				if($tablename == 'EmployeeSalaryDetails')
				{
					$sWhere="WHERE OrganizationId = $orgid and HeadId in (select Id from SalaryHead where IncludeInPayslip=1 and OrganizationId = $orgid) AND EmployeeId in ($ids)";
				}
				if($tablename == 'AttendanceMaster,ShiftMaster')
				{
					$sWhere="WHERE AttendanceMaster.OrganizationId = $orgid and AttendanceMaster.ShiftId=ShiftMaster.Id and  AttendanceMaster.TimeIn > ShiftMaster.TimeInGrace and AttendanceMaster.AttendanceStatus in (1,4) and AttendanceMaster.EmployeeId IN ($ids) and AttendanceMaster.AttendanceDate=CURDATE()";
				}
				if($tablename == 'EmployeeLeave,EmployeeMaster')
				{
					$sWhere="WHERE EmployeeLeave.OrganizationId = $orgid  and EmployeeMaster.OrganizationId = $orgid and EmployeeLeave.EmployeeId=EmployeeMaster.Id and CURDATE() between EmployeeLeave.LeaveFrom and EmployeeLeave.LeaveTo and EmployeeLeave.LeaveStatus=2 and EmployeeLeave.EmployeeId IN ($ids)";
				}
			}elseif($customsts==5){
				if($tablename == 'EmployeeMaster')
				{
					$sWhere="WHERE OrganizationId = $orgid and Id in ($ids) and Month(DOB) = Month(CURDATE()) and DAY(DOB)>=DAY(CURDATE())";
					$sOrder="Order by DAY(DOB)";
				}
			}
			
			else{
				if (strpos($tablename,',') == true)
				{	
					$table=explode(',',$tablename);
					
					if($table[0] == 'EmployeeMaster' && $table[1] != 'ShiftMaster'){
						$col1=" AND EmployeeMaster.Id=$table[1].EmployeeId  AND EmployeeMaster.Id IN ($ids)";
					}
					elseif($table[1] == 'EmployeeMaster' && $table[0] != 'ShiftMaster'){
						$col1=" AND EmployeeMaster.Id=$table[0].EmployeeId  AND EmployeeMaster.Id IN ($ids)";
					}
					elseif($table[0] == 'EmployeeMaster' && $table[1] == 'ShiftMaster'){
						$col1=" AND EmployeeMaster.Shift=ShiftMaster.Id  AND EmployeeMaster.Id IN ($ids)";
					}
					elseif($table[0] == 'AttendanceMaster' && $table[1] == 'ShiftMaster'){
						$col1=" AND AttendanceMaster.ShiftId=ShiftMaster.Id AND AttendanceMaster.EmployeeId IN ($ids )";
					}
					elseif($table[0] == 'EmployeeLeave' && $table[1] == 'LeaveMaster'){
						$col1=" AND EmployeeLeave.LeaveTypeId=LeaveMaster.Id  AND EmployeeLeave.EmployeeId IN ($ids)";
					}
					else{
						$col1=" ";
					}
					
					$sWhere = "WHERE $table[0].OrganizationId=$orgid AND $table[1].OrganizationId=$orgid $col1 ";
					if($table[0]=='EmployeeSkills' || $table[1]=='EmployeeSkills')
					{
						$sWhere=" where EmployeeSkills.EmployeeId=EmployeeMaster.Id and EmployeeMaster.Id in ($ids)";
					}
				}
				else{
					if($tablename == 'EmployeeMaster'){
						$col1='Id';
						$sWhere = "WHERE OrganizationId = $orgid AND $col1 IN ($ids)";
					}
					elseif($tablename == 'DivisionMaster' || $tablename == 'DepartmentMaster' || $tablename == 'DesignationMaster' || $tablename == 'GradeMaster' || $tablename == 'HolidayMaster' || $tablename == 'ShiftMaster' || $tablename == 'AssetsMaster'){
						
						$sWhere = "WHERE OrganizationId = $orgid ";
					}
					else{
						$col1='EmployeeId';
						$sWhere = "WHERE OrganizationId = $orgid AND $col1 IN ($ids)";
						if($tablename=='EmployeeSkills' || $tablename=='EmployeeBankDetails')
						{
							$sWhere="WHERE $col1 IN ($ids)";
						}
					}				
					
				}
			}
		}
		
		if(!empty($filter) ){
					
				
				$orcondition="";
				for($i=0;$i<count($filter);$i++)
				{
					
					if($filter[$i]['column'] != "0" &&  $filter[$i]['condition1'] != "0" ){
						
						if($filter[$i]['condition2'] == 'between' || $filter[$i]['type'] == 'var' || $filter[$i]['type'] == 'tex' || $filter[$i]['type'] == 'tim'){
							$sWhere .= $filter[$i]['condition1']."( ". $filter[$i]['column']." ".$filter[$i]['condition2']." '".$filter[$i]['textvalue1']."' )";
						}
						else{
							
							if(isset($filter[$i+1]['condition1']) =='OR' ){
								$orcondition = $filter[$i]['condition1']."( ";
							}else{
								$orcondition = $filter[$i]['condition1']." ";
							}
						
							$sWhere .= $orcondition. $filter[$i]['column']." ".$filter[$i]['condition2']." ".$filter[$i]['textvalue1']." ";
							
							if(($filter[$i]['condition1']) == 'OR' ){
								$sWhere .= ") ";
							}
						}
					}
					
					
				}
			
		}
		
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere  
		$sOrder
		$sLimit 
		
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		$total=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				$colname=$aColumns[$i];
				if (strpos($aColumns[$i],'.') == true)
				{
					$temp=explode('.',$aColumns[$i]);
					$colname=$temp[1];
				}
				$row[] =$this->getcolumnname($aColumns[$i],$tablename,$aRow->$colname,$customsts);
				//$row[]=$aRow->$colname;
			}			
			$output['aaData'][] = $row;
		
		}
		}catch(Exception $e) {
			
		}
		return  $output ;
	}
	/////////fetch values of selected field for the dropdown/////
	public function getAllColumnValue($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		
		if (strpos($request[3],'.') == false)
		{
			$columnname=$request[3];
		}
		else{
			$columnname = substr($request[3], strpos($request[3], ".") + 1);
		}
		
		$tablename1=$request[2];
		
		for($i=0;$i<count($tablename1);$i++){
			$moduleid=$this->getModuleId($tablename1[$i],0);
			$sql = "select * from ModuleChild WHERE ModuleId = ? AND ColumnName = ? ";
			$query = $this->db->prepare($sql);
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;			
				
				$query->execute(array($moduleid,$columnname));
				$count =  $query->rowCount();
				$sWhere="where OrganizationId = $orgid";
			if($count>=1)
			{
				$status=true;
					if($row= $query->fetch()){
						
						$tablename=$row->TableName;
					}
					if($tablename=="NationalityMaster" || $tablename=="ReligionMaster" || $tablename=="CountryMaster" || $tablename=="CityMaster")
					{
						$sWhere="";
					}
					if($tablename == "DivisionMaster"){
						$sWhere.=" and ArchiveSts=0";
					}
					
					if($tablename!=""){
						if($tablename == 'OtherMaster'){
							$sql2 = "select * from $tablename where OtherType = ?";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array($columnname));
							while($row2 =$query2->fetch()){
								$res=array();
								$res['id'] = $row2->ActualValue;
								$res['name'] = $row2->DisplayName;
								$data[]=$res;
							}
						}
						else{
						
							if($tablename == "EmployeeMaster"){
								$sWhere.=" order by Firstname";
							}else{
								$sWhere.=" order by Name";
							}
							$sql1 = "select * from $tablename $sWhere ";
							$query1 = $this->db->prepare($sql1);
							$query1->execute();
							while($row1 = $query1->fetch())
							{
								$res = array();
								
								 if($tablename == 'EmployeeMaster'){
									$res['id'] = $row1->Id;
									$res['name'] = $row1->EmployeeCode." - ". ucwords(strtolower($row1->FirstName." ".$row1->LastName));
								}
								else{
									$res['id'] = $row1->Id;
									$res['name'] = $row1->Name;
								}
								
								$data[] = $res;
							}
						}
					}
					
			}else{
				$status=true;
				$successMsg = EMPLOYEE_MODULE_GETALL;
			}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	//////////////////get column name according to data type of column, during generate report//////////////
	public function getcolumnname($colname,$tablename,$colid,$csts)
	{
		$name ="";
		
		if (strpos($colname,'.') == true)
		{
			$temp=explode('.',$colname);
			$tablename=$temp[0];
			$colname=$temp[1];
		}
		
			$moduleid=$this->getModuleId($tablename,$csts);
			$sql = "select * from ModuleChild WHERE ModuleId = ? AND ColumnName = ? ";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array($moduleid, $colname ));
				if($row = $query->fetch())
				{
					$fieldtype=$row->FieldType;
					$childtablests=$row->ListTable;
					$childtable = $row->TableName;
					if($childtablests == 1 && $childtable != ""){
						$columnname="";
						$swhere=" WHERE Id = $colid";
						if($childtable == 'OtherMaster'){
							$columnname="DisplayName";
							$swhere=" WHERE OtherType = '$colname' AND ActualValue =$colid";
						}
						elseif($childtable == 'EmployeeMaster'){
							$columnname="FirstName";
						}
						elseif($childtable == 'task_master'){
							$columnname="task_title";
						}elseif($childtable == 'project_master'){
							$columnname="project_title";
						}
						elseif($childtable == 'pi_child'){
							$columnname="attributes";
						}
						elseif($childtable == 'AssetsMaster'){
							$columnname="Name";
							$swhere=" WHERE Id in ($colid)";
						}
						elseif($childtable == 'Milestone'){
							$columnname="milestone_name";
							$swhere=" WHERE Id in ($colid)";
						}else{
							$columnname="Name";
						}
							
						if($colid==0 && $colname!="AssessmentSts"){
							$name ="";
						}else{
							$sql1 = "select * from $childtable $swhere ";
							$query1 = $this->db->prepare($sql1);
							$query1->execute();
							while($row1 = $query1->fetch())
							{
								$name.=' '.$row1->$columnname;
								if($childtable == 'EmployeeMaster'){
									$name =$row1->FirstName. " ".$row1->MiddleName. " ".$row1->LastName;
								}elseif($childtable == 'pi_child'){
									$name =$row1->attributes;
								}
								
								
							}
							
						}
					}
					elseif($fieldtype == 'dat'){
						if($colid == '0000-00-00'){
							$name="";
						}elseif($colname=='SalaryMonth'){
							$name= Utils::monthdateformatter($colid);
						}elseif($colname=='ApplyMonth'){
							$name= Utils::monthdateformatter($colid);
						}elseif($colname=='DOB' && $csts==5){
							$name= date('d M',strtotime($colid));
						}else{
							$name= Utils::dateformatter($colid);
						}
						
					}elseif($fieldtype == 'dattim'){
						if($colid == '0000-00-00 00:00:00'){
							$name="-";
						}else{
							$name= Utils::datetimeformatter($colid);
						}
						
					}
					else{
						
						if($colname == 'Password')
						{
							$colid=Utils::decode5t( $colid);
						}
						elseif($colname == 'HeadType'){
							if( $colid == 1)
							{	
								 $colid="Addition";
							}
							elseif( $colid == 3)
							{	
								$colid="Deduction";
							}elseif( $colid == 2)
							{	
								$colid="Allowance";
							}elseif( $colid == 4)
							{	
								$colid="Fixed";
							}
						}elseif($colname == "Period" || $colname == "AssessmentType")
						{
							if( $colid == 1)
							{	
								 $colid="Yearly";
							}
							elseif( $colid == 3)
							{	
								$colid="Half Yearly";
							}elseif( $colid == 2)
							{	
								$colid="Quarterly";
							}elseif( $colid == 4)
							{	
								$colid="Monthly";
							}
						}
						elseif($colname == "DesignationLevel")
						{
							$temp=explode(',',$colid);
							$temp1=array();
							for($i=0;$i<count($temp);$i++)
							{
								$temp1[]=Utils::getName($temp[$i],'DesignationMaster','Name',$this->db);
							}
							$colid=implode(', ',$temp1);
						}
						elseif($colname == "assigned_to")
						{
							$temp=explode(',',$colid);
							$temp1=array();
							for($i=0;$i<count($temp);$i++)
							{
								$temp1[]=Utils::getEmployeeName($temp[$i],$this->db);
							}
							$colid=implode(', ',$temp1);
						}
						elseif($colname == 'project_status'){
							if( $colid == 1)
							{	
								 $colid="Open";
							}
							else
							{	
								$colid="Close";
							}
						}
						
						elseif($colname=='ratings'){
							$star="";
							while($colid>0){
								$star.="<i class='fa fa-star' style='color:rgba(213, 133, 29, 1)'></i>";
								$colid--;
							}
							$colid=$star;
						}
						elseif($colname=='totalper'){
							
							$colid=$colid." %";
						}
						elseif($colname == "LeaveBreakDown")
						{
							$leavebreakdown=explode(",",$colid);
							$en=""; $cf=""; $ad=""; $lop="";
							if(count($leavebreakdown)>0)
							{
								$entitled=isset($leavebreakdown[0])?$leavebreakdown[0]:0;
								$carryforward=isset($leavebreakdown[1])?$leavebreakdown[1]:0;
								$advance=isset($leavebreakdown[2])?$leavebreakdown[2]:0;
								$unpaid=isset($leavebreakdown[3])?$leavebreakdown[3]:0;
								if($entitled!=0 && $entitled !=null )
									$en=$entitled."-Entitled ";
								if($carryforward!=0 && $carryforward!=null )
									$cf=$carryforward."-Carry forward ";
								if($advance!=0 && $advance!=null )
									$ad=$advance."-Advance ";
								if($unpaid!=0 && $unpaid!=null )
									$lop=$unpaid."-Loss of Pay";
							}
							$colid = $en.$cf.$ad.$lop;
						}
						$name=$colid;
					}
					
				}
				///////for employee experience/////////
				if($colname=='doj'){
					$doj=$colid;
					$curdate=date('Y-m-d');
					$diff = abs(strtotime($curdate) - strtotime($doj));

					$years = floor($diff / (365*60*60*24));
					$months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
					$name=$years.' years '.$months.' months';
				}
				elseif($colname=='CompanyEmail' || $colname=='CurrentContactNumber' || $colname=='CurrentEmailId' || $colname=='CurrentAddress' || $colname=='HomeContactNumber' || $colname=='HomeEmailId' || $colname=='HomeAddress' ||  $colname=='BankAccountNo' || $colname=='BankCode' || $colname=='EmergencyContactNumber' || $colname=='EmergencyEmailId' || $colname=='EmergencyAddress' || $colname=='CompanyEmail' || $colname=='UniqueId' || $colname=='IBAN' || $colname=='SwiftCode' || $colname=='Branch' || $colname=='LoanAmount' || $colname=='Tenure' || $colname=='EMI' || $colname=='CreditCardNo' || $colname=='Contact' || $colname=='DocumentNumber' || $colname=='EmiratesId'){
					$rec=Utils::decode5t($colid);
					$name=$rec;
				}				
			}catch(Exception $e) {
				
			}
			
		
		//echo $name;
		return $name;
	}
	/////////////////////////////get all columns from Module Child according to Name of Module////////
	  public function getAllColumnName($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$tablename = $request[2];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		if(count($tablename)>1)
		{
			for($i=0;$i<count($tablename);$i++)
			{
				$sql = "select Id,ModuleLabel from ModuleMaster where  ModuleName=? ";
				$query = $this->db->prepare($sql);
				$query->execute(array($tablename[$i]));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$status=true;
					$successMsg=$count." record found";
					$index=0;
					if($row = $query->fetch())
					{
						
						$moduleid = $row->Id;
						$modulelabel = $row->ModuleLabel;
						$sql = "Select * from ModuleChild where  ModuleId=? And ColumnSts = 1 order by ColumnLabel ";
						$query = $this->db->prepare($sql);
						$query->execute(array($moduleid));
						while($row1 = $query->fetch())
						{	
							$res = array();
							$res['name']=$tablename[$i].'.'.$row1->ColumnName;
							$res['label']=$modulelabel.' - '.$row1->ColumnLabel;
							$res['type']=$row1->FieldType;
							$res['tablename']=$row1->TableName;
							$res['colindex']="";
							$data[] = $res;
						}
					}	
					}else{
						$status=true;
						$successMsg = EMPLOYEE_MODULE_GETALL;
					}
				
			
			}
		}
		else{
			$tablename = is_array($request[2]) ? implode(',',$request[2]): $request[2];
			$sql = "select Id from ModuleMaster where  ModuleName=? ";// and Field<>'OrganizationId' and Field<>'CreatedById' and Field<>'CreatedDate' and Field<>'LastModifiedDate' and Field<>'LastModifiedById' and Field<>'OwnerId'";
			$query = $this->db->prepare($sql);
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;			
				
				$query->execute(array($tablename));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				$index=0;
				if($row = $query->fetch())
				{
					
					$moduleid = $row->Id;
					$sql = "Select * from ModuleChild where  ModuleId=? And ColumnSts =1 order by ColumnLabel asc";
					$query = $this->db->prepare($sql);
					$query->execute(array($moduleid));
					while($row1 = $query->fetch())
					{	
						$res = array();
						$res['name']=$row1->ColumnName;
						$res['label']=$row1->ColumnLabel;
						$res['type']=$row1->FieldType;
						$res['tablename']=$row1->TableName;
						$res['colindex']="";
						$data[] = $res;
					}
				}	
			}else{
				$status=true;
				$successMsg = EMPLOYEE_MODULE_GETALL;
			}
			
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmpAnnualLeavetype($empid,$orgid)
	{
		
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $workingdays=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $annualleave=""; $halfdays=0;
		
		$sql="select * from EmployeeMaster where OrganizationId=? and Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid,$empid));
		while($row=$query->fetch()){
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=substr_count($row->WorkingDays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);	
			$workingdays=Utils::averageWorkingDayWeek($row->Shift, $this->db);
			$sqlleave = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and WorkingDays =$workingdays and AnnualLeaveSts=1";
			$queryleave = $this->db->prepare($sqlleave);
			$queryleave->execute(array($orgid));
			$count1 =  $queryleave->rowCount();
			if($count1>=1)
				{
					while($rowleave = $queryleave->fetch())
					{
						$divisionflg=true;
						$departmentflg=true; 
						$designationflg=true; 
						$gradeflg=true; 
						$genderflg=true; $maritalflg=true;
						
						$employeeusedleave=0;
						
						if($rowleave->LeaveUsableSts==1){
							if($rowleave->DivisionId>0){
								if($rowleave->DivisionId==$division){
									$divisionflg=true;
								}else{$divisionflg=false;}
							}
							if($rowleave->DepartmentIds>0){
								if($rowleave->DepartmentIds==$department){
									$departmentflg=true; 
								}else{$departmentflg=false; }
							}
							if($rowleave->DesignationIds>0){
								if($rowleave->DesignationIds==$designation){
									$designationflg=true; 
								}else{$designationflg=false; }
							}
							if($rowleave->GenderId>0){
								if($rowleave->GenderId==$gender){
									$genderflg=true;
								}else{$genderflg=false;}
							}
							if($rowleave->MaritalId>0){
								if($rowleave->MaritalId==$marital){
									$maritalflg=true;
								}else{$maritalflg=false;}
							}
							if($rowleave->GradeId>0){
								if($rowleave->GradeId==$grade){
									$gradeflg=true; 
								}else{$gradeflg=false; }
							}
						}elseif($rowleave->LeaveUsableSts==2){
							$divisionflg=false;
							$departmentflg=false; 
							$designationflg=false; 
							$gradeflg=false; 
							$genderflg=false; $maritalflg=false;
							
							if($rowleave->EmployeeIds!="")
							{
								$temp = explode(",", $rowleave->EmployeeIds);
								for($i=0; $i<count($temp); $i++)
								{
									if($empid==$temp[$i]){
										$divisionflg=true;
										$departmentflg=true; 
										$designationflg=true; 
										$gradeflg=true; 
										$genderflg=true; $maritalflg=true;
										//echo $rowleave->Id.' '.$empid;
										break;
									}
									
								}
							}
							
						}
						
						if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg)
						{							
							$annualleave = $rowleave->Id;
							break;
						}
					}
				}
		}	
			return $annualleave;
	}
	
	////////////////Projectwise Report ///////////////////
	public function ProjectReport()
	{
		$result = array(); $swhere =" ";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
		$currentmonth = isset($_POST['fromdate'])?Utils::getDateformat( $_POST['fromdate']):"";
		
		if($currentmonth=="")
			$currentmonth = date("Y-m-d");
		//echo $currentmonth;
		//$swhere1 =" ";
		/* if(isset($_POST['division']))
		{
			$swhere1="AND Division=".$_POST['division'];
			if($_POST['division']==0)
			{
				$swhere1 =" ";
			}
		} */
		try{
		
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT * FROM project_master Where OrganizationId = ? and owner_id in ($ids) and id in (select distinct project_id from timesheet_master Where OrganizationId = ?) AND ((Month(start_date)= Month('$currentmonth') and Year(start_date) = Year('$currentmonth')) or (Month(completed_date)= Month('$currentmonth')and Year(start_date) = Year('$currentmonth'))) order by created_date";
			 if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM project_master Where OrganizationId = ? and id in (select distinct project_id from timesheet_master Where OrganizationId = ?) AND ((Month(start_date)= Month('$currentmonth') and Year(start_date) = Year('$currentmonth')) or (Month(completed_date)= Month('$currentmonth')and Year(start_date) = Year('$currentmonth'))) order by created_date";
			} 
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid, $orgid));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					
					$res=array();
					$res['projectname']=ucwords($row->project_title);
					$res['projectid']=$row->id;
					
					$projectid=$res['projectid'];
					//$empname=$row->FirstName.' '.$row->MiddleName.' '.$row->LastName;
					//$empcode=$row->EmployeeCode;
					//$totalleave=0; $timesheet=array();
					
					//$sql1 = "SELECT * FROM timesheet_master where EmployeeId in (?) AND (timesheetstart >=? OR timesheetend <=?)";
					$sql1="SELECT sum(TIMESTAMPDIFF(minute,start_time,end_time)) as estimatetime, sum(TIMESTAMPDIFF(minute,timesheetstart,timesheetend)) as actualtime,EmployeeId FROM timesheet_master where project_id = ? group by EmployeeId";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($projectid));
					$con=$query1->rowCount();
					 $totalestimate=0;
					 $totalactual=0;
					
					//$monthlytotal=0;
					//$leavedetails=array();
					$timesheet="";
					while($row1 = $query1->fetch())
					{
						$res1=array();
						$res1['empname']=Utils::getEmployeeName($row1->EmployeeId,$this->db);
						$res1['task_id']=$this->gettaskname($projectid, $row1->EmployeeId);
						$est = $row1->estimatetime;
						$act = $row1->actualtime;
						$ad="";$ah="";$am="";
						$ed="";$eh="";$em="";
						if($act){
						$ad = floor ($act / 1440);
						$ah = floor (($act - ($ad * 1440))/60);
						$am = floor ($act - (($ah * 60)+($ad * 1440)));
						}
						if($est){
						$ed = floor ($est / 1440);
						$eh = floor (($est - ($ed * 1440))/60);
						$em = floor ($est - (($eh * 60)+($ed * 1440)));
						}
						$totalestimate=$totalestimate + $est;
						$totalactual=$totalactual + $act;
						//$start = new DateTime($row1->timesheetstart);
						
						//$since_start1 = $start->diff(new DateTime($row1->timesheetend));
						/* if($since_start1->d>0){
							$days1=$since_start1->d.' days';
							$totalday1=$totalday1+$since_start1->d;
						}
						
						if($since_start1->h>0){
							$hours1 = $since_start1->h.' hours';
							$totalhour1=$totalhour1+$since_start1->h;
						}
						
						if($since_start1->i>0){
							$minutes1 = $since_start1->i.' minutes';
							$totalminute1=$totalminute1+$since_start1->i;
						}
						$res1['total_time']=$days1.' '.$hours1.' '.$minutes1;
						 */
						
						/* $start_date = new DateTime($row1->start_time);
						$since_start = $start_date->diff(new DateTime($row1->end_time));
						if($since_start->d>0){
							$days=$since_start->d.' days';
							$totalday=$totalday+$since_start->d;
						}
						
						if($since_start->h>0){
							$hours = $since_start->h.' hours';
							$totalhour=$totalhour+$since_start->h;
						}
						
						if($since_start->i>0){
							$minutes = $since_start->i.' minutes';
							$totalminute=$totalminute+$since_start->i;
						} */
						/* if($totalhour>24){
							$totalday=$totalday+1;
							$totalhour=$totalhour-24;
						}
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
						if($totalhour1>24){
							$totalday1=$totalday1+1;
							$totalhour1=$totalhour1-24;
						}	
						if($totalminute1>60){
							$totalhour1=$totalhour1+1;
							$totalminute1=$totalminute1-60;
						}	 */
						if($ad){$ad=$ad.' days ';} else{$ad="";}
						if($ah){$ah=$ah.' hours ';}else{$ah="";}
						if($am){$am=$am.' minutes';}else{$am="";}
						if($ed){$ed=$ed.' days ';}else{$ed="";}
						if($eh){$eh=$eh.' hours ';}else{$eh="";}
						if($em){$em=$em.' minutes';}else{$em="";}
						$res1['total_time']= $ad.$ah.$am;
						$res1['esttotaltime']= $ed.$eh.$em;
						$timesheet[]=$res1;	
					}
						$totalday1 = floor ($totalactual / 1440);
						if($totalday1){$totalday1=$totalday1.' days ';} else{$totalday1="";}
						$totalhour1 = floor (($totalactual - ($totalday1 * 1440))/60);
						if($totalhour1){$totalhour1=$totalhour1.' hours ';}else{$totalhour1="";}
						$totalminute1 = floor ($totalactual - (($totalhour1 * 60)+($totalday1 * 1440)));
						if($totalminute1){$totalminute1=$totalminute1.' minutes';}else{$totalminute1="";}
						$totalday = floor ($totalestimate / 1440);
						if($totalday){$totalday=$totalday.' days ';} else{$totalday="";}
						$totalhour = floor (($totalestimate - ($totalday * 1440))/60);
						if($totalhour){$totalhour=$totalhour.' hours ';}else{$totalhour="";}
						$totalminute = floor ($totalestimate - (($totalhour * 60)+($totalday * 1440)));
						if($totalminute){$totalminute=$totalminute.' minutes';}else{$totalminute="";}
						$acttotal_time =$totalday1.$totalhour1.$totalminute1;
						$esttotal_time =$totalday.$totalhour.$totalminute;
						if($acttotal_time=="")
						{
							$acttotal_time = "0 days";
						}
						$res['timesheet']= $timesheet;
						$res['acttotal_time']=$acttotal_time;
						$res['esttotal_time']=$esttotal_time;
						$data[]=$res;
				}
			}
			else {
				
			   $status =false;
			   $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result["date"] =date('Y-m-d');
		//$result["data"] =$data;
		$result['data']=$data;
		$result['startdate']=Utils::monthdateformatter($currentmonth);
		//$result['enddate']=Utils::monthdateformatter($currentmonth);
		$result['errorMsg']="No data found";
		$result['status']=true;
		
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
		
	}
	public function gettaskname($projectid, $employeeid)
	{
		$name ="";
		$sql = "SELECT * FROM timesheet_master WHERE project_id = ? and EmployeeId =?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($projectid, $employeeid));
			while($row = $query->fetch())
			{
				if($name == ""){
				$name = Utils::getName($row->task_id,'task_master','task_title',$this->db);
				}
			else{
				$name .= ",". Utils::getName($row->task_id,'task_master','task_title',$this->db);
			}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}

	public function getTimeoff($empid, $date)
	{
		$name =0;
		$sql = "SELECT TIME_FORMAT(TIMEDIFF(Timeto, TimeFrom),'%H:%i') as totaltime FROM Timeoff WHERE EmployeeId = $empid and TimeofDate ='$date' and ApprovalSts in (2,6)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			while($row = $query->fetch())
			{
				$name += $this->explode_time($row->totaltime);
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getTimeoffearly($empid, $date,$timein)
		{
		$name =0;
		$sql = "SELECT TIME_FORMAT(TIMEDIFF(Timeto, TimeFrom),'%H:%i') as totaltime FROM Timeoff WHERE EmployeeId = $empid and TimeofDate ='$date' and ApprovalSts =2 and TimeFrom<'$timein'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			while($row = $query->fetch())
			{
				$name += $this->explode_time($row->totaltime);
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return $name;
		}
	
		public function getTimeofflater($empid, $date,$timeout)
		{
		$name =0;
		$sql = "SELECT TIME_FORMAT(TIMEDIFF(Timeto, TimeFrom),'%H:%i') as totaltime FROM Timeoff WHERE EmployeeId = $empid and TimeofDate ='$date' and ApprovalSts =2 and TimeTo > '$timeout'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			while($row = $query->fetch())
			{
				$name += $this->explode_time($row->totaltime);
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return $name;
		}
	
		public function isearlyTimeoff1($empid, $date,$timein)
	{
		$name =0;
		$sql = "SELECT * FROM Timeoff WHERE EmployeeId = $empid and TimeofDate ='$date' and TimeTo<'$timein'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$con=$query->rowCount();
			if($con>=1)
			{
				return true;
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return false;
	}
	public function isearlyTimeout1($empid,$date,$timeout)
	{
		$name =0;
		$sql = "SELECT * FROM Timeoff WHERE EmployeeId = $empid and TimeofDate = '$date' and TimeFrom > '$timeout'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$con=$query->rowCount();
			if($con>=1)
			{
				return true;
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return false;
	}
	
	public function isearlyTimeoff($empid, $date,$timein)
	{
		$name =0;
		$sql = "SELECT * FROM Timeoff WHERE EmployeeId = $empid and TimeofDate ='$date' and TimeFrom<'$timein'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$con=$query->rowCount();
			if($con>=1)
			{
				return true;
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return false;
	}
	
	public function isearlyTimeout($empid,$date,$timeout)
	{
		$name =0;
		$sql = "SELECT * FROM Timeoff WHERE EmployeeId = $empid and TimeofDate = '$date' and TimeTo > '$timeout'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$con=$query->rowCount();
			if($con>=1)
			{
				return true;
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return false;
	}
	
	public function getTimeoffmonthly($empid, $date)
	{
		$name =0;
		$sql = "SELECT TIME_FORMAT(TIMEDIFF(Timeto, TimeFrom),'%H:%i') as totaltime FROM Timeoff WHERE EmployeeId = $empid and Year(TimeofDate) =Year(?) and month(TimeofDate) = month(?) and ApprovalSts =2";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($date,$date));
			while($row = $query->fetch())
			{
				$name += $this->explode_time($row->totaltime);
			}
			//Utils::Trace($name);
		}catch(Exception $e) {
			
		}
		return $name;
	}

     public function EmployeeSkillGapReport(){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();$skills=array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$filscalid=$_SESSION['ubihrm_fiscalid'];
	    $startdate = isset($_POST['fromdate'])?$_POST['fromdate']:"";
	    $enddate =  isset($_POST['todate'])?$_POST['todate']:"";
		if($startdate =="" && $enddate==""){
		/* 	//$startdate = $row->StartDate;
			//$enddate = $row->EndDate;
			$month_ini = new DateTime("first day of last month");
			$startdate = $month_ini->format('Y-m-d');  */
 			$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate = $row->EndDate;
			} 
		}
		$swhere ="";
		if(isset($_POST['division']) && $_POST['division']!=0){
			$swhere .=" AND Designation=".$_POST['division'];
		}
		if(isset($_POST['department']) && $_POST['department']!=0){
			$swhere .=" AND Department=".$_POST['department'];
		}
		if(isset($_POST['employee']) && $_POST['employee']!=0){
			$empids = Utils::getReportingIds($_POST['employee'], $this->db).",".$_POST['employee'];
			$swhere .=" AND Id in (".$empids.")";
		}
		try{
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$userid=$_SESSION['ubihrm_user_id'];
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			/*start query to get all the skills*/
			$sqlskill = "SELECT * FROM kpi WHERE OrganizationId = :id and QuadrantId in (Select Id from Quadrants where CompType=2) order by QuadrantId";
			$queryskill = $this->db->prepare($sqlskill);
			$queryskill->execute(array(':id' => $orgid ));
			while($rowskill = $queryskill->fetch())
				{
					$res = array();
					$res['id'] = $rowskill->Id;
					//$res['quadrantid'] = $rowskill->QuadrantId;
					$res['name'] = $rowskill->Name;
					//$res['desc'] = $rowskill->Description;
					$skills[] = $res;
				}
			/*end query to get all the skills*/
			$sql = "SELECT * FROM EmployeeMaster where ReportingTo in ($ids) and OrganizationId =? $swhere order by FirstName ";
			if($hrsts==1 || $sts==1){
				$sql = "SELECT * FROM EmployeeMaster Where OrganizationId =? $swhere order by FirstName";
			}
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			if($count>=1){
				while($row = $query->fetch()){	
					$empskills = array();
					$res = array();
					$res['empid'] = $row->Id;
					$res['empname'] =  $row->FirstName." ".$row->LastName;
					
					//$pic="";
					$color = sprintf('%06X', mt_rand(0, 16777215));
					$name=$row->FirstName;
					$name=strtoupper($name[0]);
					$photo="public/uploads/$orgid/".$row->ImageName;
					if($row->ImageName && file_exists($photo)){
						//$pic='<img src="'.URL.$photo.'" class="img-circle" style="width:50px;height:50px;" width="50px" height="50px">';
						$res['emppic'] = URL.$photo;
						$res['firstletter'] = "";
					}
					else{
						//$pic='<p data-letters="'.strtoupper($name[0]).'" style="background-color:#'.$color.'" ></p>';
						$res['firstletter'] = $name;
						$res['emppic'] = "";
					}
					$maxlevel=0;$empassessid=0;
					/*fetch heighest level of skill*/
					$sqllevel = "SELECT * FROM EmployeeSkillAssessment WHERE EmployeeId =? AND OrganizationId =? and AssessmentSts =1 order by Id desc limit 1";
					
					$querylevel = $this->db->prepare($sqllevel);
					$querylevel->execute(array($row->Id,$orgid));	
					while($rowlevel = $querylevel->fetch()){
					$empassessid=$rowlevel->Id;
					$deslvl=explode(",",$rowlevel->DesignationLevel);
					$maxlevel=count($deslvl);
					//Utils::Trace($maxlevel);
					$sql1 = "SELECT * FROM EmployeeSkillAssessmentChild WHERE EmployeeAssessmentId =? and Level=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($empassessid,$maxlevel));	
					$count1=  $query1->rowCount();					
					while($row1 = $query1->fetch()){	
						$res1 = array();
						$res1['gap'] = $this->getGapName($row1->Gap);
						$res1['skillid'] = Utils::getName($row1->ObjectiveId,'SkillGapObjectiveChild','ObjectiveId',$this->db);
						$assess = Utils::getName($row1->ObjectiveId,'SkillGapObjectiveChild','Weightage',$this->db);
						$res1['desirelvlno'] = Utils::getName($assess,'DesiredLevel','Level',$this->db);
						$res1['desirelvl'] = Utils::getName($assess,'DesiredLevel','Name',$this->db);
						$res1['assesslvlno'] = Utils::getName($row1->Score,'DesiredLevel','Level',$this->db);
						$res1['assesslvl'] = Utils::getName($row1->Score,'DesiredLevel','Name',$this->db);
						$empskills[]=$res1;
					}
					}
					$res['empskills']= $empskills;	
					$data['emp'][]=$res;
				}
			}else {
				$status =false;
			    $errorMsg = REPORT_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$data['skills'][]=$skills;
		$result['data']=$data;
		$result['startdate']=isset($_POST['fromdate'])?Utils::dateformatter($startdate):$startdate;
		$result['enddate']=isset($_POST['todate'])?Utils::dateformatter($enddate):$enddate;
		$result['errorMsg']="No data found";
		$result['status']=true;
		if(isset($_POST['fromdate']) && isset($_POST['todate']))
		{
			return $result;
		}
		else{
			return $data;
		}
	}
	public function getGapName($gap)
	{
		$gapname ="";
		//to get total weightage//
		 $sqlweigh = "Select Name from GapMaster where Gap = ?";
        $queryweigh = $this->db->prepare($sqlweigh);
		try{
			$queryweigh->execute(array($gap));
			while($rowweigh = $queryweigh->fetch())
			{
			$gapname=$rowweigh->Name;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		return $gapname;
	}     	
		
	
	
}
