<?php

/**
 * DepartmentModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class RelatedlistModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
	$org_id = $request[0];
	$table = $request[1];
	
	
	//$res = array();
	$result = array();
	
	//$result[] = $res; 
	//$data = array();
	//$column = array();
	$count=0; $count1=0;
	
	
	$sqlr ="SELECT * FROM RelatedListMaster WHERE ParentObject = :pobject";

	$query = $this->db->prepare($sqlr);
        
        
	$query->execute(array(':pobject' => $table));
	$count =  $query->rowCount();
		

     if($count>0)
     {	
     $i=0;
	while($rowRL = $query->fetch())
	{
					
			$listname = array();
			$dfields = array();
			$childname = array();
			
			
			$listname['lname'] = $rowRL->ListName;  //EmployeeMaster
			$dfields['fields'] = $rowRL->DisplayFields; //FirstName,DOB
			$childname['column'] = $rowRL->ChildObject; //QualificationTable
			
			$result[$i]['listname'] = $listname['lname'];
			$result[$i]['dfields'] = $dfields['fields'];
			$result[$i]['childname'] = $childname['column'];
			
			$sql2 ="";
						
			//$sql2 ="SELECT id, ? FROM ?";
			
			//$query1 = $this->db->prepare($sql2);
        		//$query1->execute(array(implode(',',$dfields), $table));
        		
			//$count1 =  $query1->rowCount();
			
			if($count1>=1)
			{
				//$c=0;
				$headerRow = true;
				while ($row = $query1->fetch()) 
				{
					
					$result[$i]['columnvalue'] = $row;
					//$c++;
				}

			}
			else
			{
				//$c=0;
				$result[$i]['columnvalue'] = "";
				//$c++;
			}
			$i++;
	  }
	  
	}
	
	  return $result;
    }
    
    
        
	public function createrelatedlist($request)
	{
		$result = array();
		//$orgid = $request[0];
		
		// Get post data variable submitted from form
		$mid   		= $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid 		= $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$name 		= $request[2];
		$pobject 	= $request[3];
		$cobject 	= $request[4];
		//$pid 		= $request[5];
		$dfields1	= $request[5];
		$dfields	= implode(',',$dfields1);
		$sts		= $request[6];
		//$relatedlistid  = $request[6];
		$pid=$orgid;
		
		$svalue=1;
		if($sts=='false')
		{
			$svalue=0;
		}
		
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		$sql1 = "SELECT * FROM RelatedListMaster WHERE ChildObject = ? AND ParentObject = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($cobject, $pobject));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=RELATEDLIST_MODULE_UPDATION_DUPLICATE;
		}else{
			
			$sql = "INSERT INTO RelatedListMaster (ListName, ParentObject, ChildObject, ParentId, DisplayFields, CreatedDate, LastModifiedDate, LastModifiedById, Sts) VALUES (?,?,?,?,?,?,?,?,?)";
		
			$query = $this->db->prepare($sql);
			
			try{
				
				$query->execute(array($name, $pobject, $cobject, $pid, $dfields, $mdate, $mdate, $mid,$svalue));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = RELATEDLIST_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=RELATEDLIST_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
		
		
	}


	public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
        	$svalue = 1;
        	if($request[7]=='false')
        	{
        		$svalue=0;
        	}
        	
        
		$mdate = date("Y-m-d H:i:s");
		$dfields = implode(',',$request[5]);
		
		$sql1 = "SELECT * FROM RelatedListMaster WHERE Id != ? AND ChildObject = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[6], $request[2]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=RELATEDLIST_MODULE_UPDATION_DUPLICATE;
		}else{
			
			$sql = "UPDATE RelatedListMaster SET ListName=?, ParentObject=?, ChildObject=?, DisplayFields=?, LastModifiedDate=?, LastModifiedById=?, Sts=? WHERE Id=?";
		
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array($request[2], $request[3], $request[4], $dfields, $mdate, $mid,$svalue, $request[6]));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = RELATEDLIST_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=RELATEDLIST_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }


	public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		//$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM RelatedListMaster WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id'=>$did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = RELATEDLIST_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = RELATEDLIST_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
    
    
    public function getAllList()
    {
        	$result = array();
        	$res = array();
        	$btable = "base table";
        	$tschema = "ubihrm";
        	$res['child_name'] = "Select List";
        	$result[] = $res;
				
		$sql = "SELECT table_name AS name FROM information_schema.tables WHERE table_type = :base_table AND table_schema= :table_schema order by name";
		
		$query = $this->db->prepare($sql);
	        $query->execute(array(':base_table' => $btable, ':table_schema' => $tschema));
		while($row = $query->fetch())
		{
			$res = array();
			$res['child_name'] = $row->name;			
			$result[] = $res;
		}
        
		return $result;
        // default return
     
    }

	public function getAllColumnName($child_name)
    {
        	$result = array();
        	
        	if($child_name!="Select List")
        	{				
			$sql = "DESCRIBE $child_name";
		
			$query = $this->db->prepare($sql);
			$query->execute();
			while($row = $query->fetch())
			{
				$res = array();
				if($row->Field=='Id')
				{}
				else
				{
					$res['dfields'] = $row->Field;
					$result[] = $res;
				}			
				
			}
        	}
		return $result;
        // default return
     
    }


	public function getName($id)
	{
		$name ="N/A";
		$sql = "SELECT * FROM RelatedListMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->ListName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM RelatedListMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->ListName;
				$res['pname'] = $row->ParentObject;
				$res['cname'] = $row->ChildObject;
				$res['pid'] = $row->ParentId;
				$res['dfields'] = $row->DisplayFields;
				
								
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = RELATEDLIST_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=RELATEDLIST_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }


	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'RelatedListMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'ListName', 'ParentObject', 'ChildObject','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		
		$sWhere = " ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere = " WHERE(";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a data-toggle="tooltip" title="Edit" href="'.URL.'setup/editrelatedlist/'.$aRow->{$aColumns[$i]}.'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" data-toggle="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a data-href="'.URL.'setup/deleterelatedlist/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" data-toggle="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}elseif($aColumns[$i]=="Id"){
					$row[] = self::getName($aRow->{$aColumns[$i]});
				}else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	


}
