<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class QuadrantModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM Quadrants WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = QUADRANT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$objective=array();
		
        $sql = "SELECT * FROM Quadrants WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['desc'] = $row->Description;
				$res['color'] = $row->Color;
				$res['ctype'] = (int)$row->CompType;
				$res['desig'] = (int)$row->Designation;
				$data[] = $res;
			}
			$sql1 = "SELECT * FROM kpi WHERE QuadrantId = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['quadrant'] = $row1->QuadrantId;
					$res1['objective'] = $row1->Name;
					$res1['desc'] = $row1->Description;
					$objective[]=$res1;
				}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = QUADRANT_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = QUADRANT_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result["data1"] =$objective;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a Quadrants (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=$_SESSION['ubihrm_org_id'];
		
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM Quadrants WHERE Id != ? and Name = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[3], $request[2], $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=QUADRANT_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "UPDATE Quadrants SET Name=?,Color=?,Description=?, CompType=?, Designation=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
			$query = $this->db->prepare($sql);
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				$query->execute(array($request[2],$request[4], $request[5],$request[6],$request[7], $mdate, $mid, $request[3] ));			
				$count =  $query->rowCount();
			// INSERTING AND UPDATING OBJECTIVE CHILD IF PASSED AS AN JSON
			$objective = json_decode($_POST['kpi'], true); 
			$objectiveid="0";
			for($i=0; $i<count($objective); $i++){
				$objectiveid .= ",".$objective[$i]['id'];
			}
			for($i=0; $i<count($objective); $i++)
			{
				if($objective[$i]['objective']!=""){
					$record = array();
					$record[0] = $request[3];
					$record[1] = $objective[$i]['objective'];
					$record[2] = $objective[$i]['desc'];
					$record[3] = $mdate;
					$record[4] = $mdate;
					$record[5] = $mid;
					$record[6] = $mid;
					$record[7] = $orgid;
					$id = $objective[$i]['id'];
					if($id){
						$sqlobjective = "UPDATE kpi SET QuadrantId=?, Name=?, Description=?, LastModifiedDate=?, LastModifiedById=? ,OrganizationId= ? where Id=?";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute(array($request[3],$objective[$i]['objective'],$objective[$i]['desc'],$mdate,$mid,$orgid,$id));
					}else{
						$sqlobjective = "INSERT INTO kpi (QuadrantId, Name, Description, CreatedDate, LastModifiedDate, CreatedById, LastModifiedById, OrganizationId) values (?,?,?,?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
					}
				}
			}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
			   $status =true;
			   $successMsg = QUADRANT_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = QUADRANT_MODULE_UPDATION_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a Quadrants (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=$_SESSION['ubihrm_org_id'];
		//$mid   = $request[0];
		$mdate = date("Y-m-d H:i:s");
		$desig = $request[6];
		
		$sql1 = "SELECT * FROM Quadrants WHERE Name = ? and OrganizationId=? and CompType=?";
		/*Removed the designation from skills on 5/6/2018*/
		/* if($request[5]==2){
			$sql1 = "SELECT * FROM Quadrants WHERE Name = ? and OrganizationId=? and CompType=? and Designation=$desig";
		} */
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[2],$orgid,$request[5]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg="This Competency is already available.";
		}else{
			$sql = "INSERT INTO Quadrants (Name,Color, Description, CompType, Designation, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,?,?)";
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3], $request[4],$request[5],$request[6], $orgid, $mdate, $mid, $mdate, $mid, $mid));
				$count =  $query->rowCount();
				$aid=$this->db->lastInsertId();
				if($count>=1){
				// INSERTING KPI IF PASSED AS AN JSON
				$objective = json_decode($_POST['kpi'], true); 
				for($i=0; $i<count($objective); $i++)
				{
					if($objective[$i]['objective']!=""){
						$record = array();
						$record[0] = $aid;
						$record[1] = $objective[$i]['objective'];
						$record[2] = $objective[$i]['desc'];
						$record[3] = $mdate;
						$record[4] = $mdate;
						$record[5] = $mid;
						$record[6] = $mid;
						$record[7] = $orgid;
						
						$sqlobjective = " INSERT INTO kpi (QuadrantId, Name, Description, CreatedDate, LastModifiedDate, CreatedById, LastModifiedById, OrganizationId) values (?,?,?,?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
					}
					}
				}				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Competency created successfully.";
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while creating competency.";
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$sql = "Select * from AssessmentObjectiveChild WHERE QuadrantId = :id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		if($row=$query->fetch()){
			$status =false;
			$errorMsg = QUADRANT_MODULE_DELETE_EXIST;
		
		}else{
			$sql = "DELETE FROM Quadrants WHERE Id = :id ";
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$count =  $query->rowCount();	
				if($count){
					$sql = "DELETE FROM kpi WHERE QuadrantId = :id ";
					$query = $this->db->prepare($sql);
					$query->execute(array(':id' => $did));
				}				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = QUADRANT_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg = QUADRANT_MODULE_DELETE_FAILED;
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'Quadrants';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name','Color',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid  and CompType=1";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performance/editquadrant/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'performance/viewquadrant/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				
				else if($aColumns[$i]=="Color")
				{
					
					$row[] = '<span class="label" style="width:250px;background-color:'.$aRow->{$aColumns[$i]}.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getallKpi($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM kpi WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['quadrantid'] = $row->QuadrantId;
				$res['name'] = $row->Name;
				$res['desc'] = $row->Description;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = QUADRANT_MODULE_GETALL;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	public function getallFuncKpi($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM kpi WHERE OrganizationId = :id and QuadrantId in (Select Id from Quadrants where CompType=2)";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = 0;
				$res['quadrant'] = $row->QuadrantId;
				$res['name'] = $row->Name;
				$res['objective'] = $row->Id;
				$res['desc'] = $row->Description;
				$res['weightage'] = "";
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = QUADRANT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
//functional competencies//
	public function getFuncDataTable($editper, $deleteper)
	{
		$sTable = 'kpi';
		$sIndexColumn = "Id";
		$aColumns = array( 'QuadrantId','Name','QuadrantId', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY QuadrantId,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid and QuadrantId in (Select Id from Quadrants where CompType=2)";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					$rowdata=htmlspecialchars(json_encode($aRow));
					if($editper){
						$edit = '<a rel="tooltip"  title="Edit" onclick="angular.element(this).scope().getskilldata(\''.$rowdata.'\')" href="#" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getSkillId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirmskill" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit;
				}
				else if($aColumns[$i]=="QuadrantId" && $i==0)
				{
					$quadname=Utils::getName($aRow->{$aColumns[$i]},'Quadrants','Name',$this->db);
					$row[] = $quadname;
					//'<a href="'.URL.'performance/viewquadrant/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/1">'.$quadname.'</a>';
				}
				else if($aColumns[$i]=="QuadrantId" && $i==2)
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performance/editSkillArea/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = $aRow->{$aColumns[$i]};
					//'<a href="'.URL.'performance/viewquadrant/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
				}
				/* else if($aColumns[$i]=="QuadrantId" && $i==2)
				{
					$color=Utils::getName($aRow->{$aColumns[$i]},'Quadrants','color',$this->db);
					$row[] = '<span class="label" style="width:250px;background-color:'.$color.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
				} */
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
 public function getCompTypeQuadrant($request,$type)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$cond="";
		$desig=(isset($request[2]))?$request[2]:0;
		if($desig && $type==2){
			$cond= "and Designation=$desig";
		}
        $sql = "SELECT * FROM Quadrants WHERE OrganizationId = :id and CompType = $type $cond";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$sql1 = "SELECT * FROM kpi WHERE QuadrantId =".$res['id'];
				$query1 = $this->db->prepare($sql1);
				$query1->execute();
				$kpidata=array();
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->Id;
					$res1['quadrantid'] = $row1->QuadrantId;
					$res1['name'] = $row1->Name;
					$res1['desc'] = $row1->Description;
					$kpidata[] = $res1;
				}
				$res['kpi'] = $kpidata;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = QUADRANT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

    public function onUpdateSkill($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $orgid=$_SESSION['ubihrm_org_id'];
		
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM kpi WHERE Id != ? and Name = ? and OrganizationId=? and QuadrantId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[3], $request[2], $orgid, $request[4]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg="Skill already exists in this skill area.";
		}else{
			$sql = "UPDATE kpi SET Name=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
			$query = $this->db->prepare($sql);
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				$query->execute(array($request[2], $mdate, $mid, $request[3] ));			
				$count =  $query->rowCount();
			
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Skill updated successfully.";
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while updating the skill.";
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
 public function DeleteSkill($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$sql = "Select * from AssessmentObjectiveChild WHERE QuadrantId = :id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		if($row=$query->fetch()){
			$status =false;
			$errorMsg = QUADRANT_MODULE_DELETE_EXIST;
		
		}else{
			$sql = "DELETE FROM kpi WHERE Id = :id ";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = QUADRANT_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg = QUADRANT_MODULE_DELETE_FAILED;
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
   
}
