<?php

/**
 * DiscussionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ProjectsModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function projects($user_id)
    {
		$limit = isset($_POST['limit']) ? $_POST['limit'] : "";
		$offset = isset($_POST['offset']) ? $_POST['offset'] : "0";
		$cond="";
		$view_projects=0;
		if($limit!="")
		{
			$cond="limit $limit offset $offset";
		}
		
		$userids=$user_id;
		$sql1 = "SELECT view_all_projects FROM user_master WHERE OwnerId=:userids";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array(':userids'=>$userids));
		while($row1 = $query1->fetch())
		{
			$view_projects =$row1->view_all_projects;
		}
        
		/////// get userids on the basis of designation ////////
		$levelid =100;
		$sql = "select level_id from designation_master d, user_master u where d.designation_id=u.designation_id and u.user_id=:id";
        	$query = $this->db->prepare($sql);
		$query->execute(array(':id'=>$user_id));
		while($row = $query->fetch())
		{
			$levelid =$row->level_id;
		}
		$sql = "SELECT user_id FROM user_master where designation_id in (select designation_id from designation_master where level_id>:levelid)";
		$query = $this->db->prepare($sql);
		$query->execute(array(':levelid'=>$levelid));
		while($row = $query->fetch())
        	{	
			$userids .=",".$row->user_id;	
		}
		if($view_projects==1)
		{
	        $sql = "SELECT id, project_title, project_prefix, estimated_date, created_date, start_date, completed_date, project_status, owner_id, project_desc FROM project_master order by created_date desc $cond";
		}
		else
		{
	        $sql = "SELECT id, project_title, project_prefix, estimated_date, created_date, start_date, completed_date, project_status, owner_id, project_desc FROM project_master where owner_id in ($userids) order by created_date desc $cond";
		}
		////////////////////////////////////////////////////////
		

        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->id;
			$res['project_title'] = $row->project_title;
			$res['project_prefix'] = strtoupper($row->project_prefix);
			$res['estimated_date'] = ($row->estimated_date!="0000-00-00")?date(DISPLAY_DATE_FORMATE, strtotime($row->estimated_date)):"Not Set";
			$res['created_date'] = ($row->created_date!="0000-00-00")?date(DISPLAY_DATE_FORMATE, strtotime($row->created_date)):"-";
			$res['start_date'] = ($row->start_date!="0000-00-00")?date(DISPLAY_DATE_FORMATE, strtotime($row->start_date)):"Not Set";
			$res['completed_date'] = $row->completed_date;
			$res['project_status'] =self::getOtherInfo($row->project_status);
			$res['name'] = self::getUserName($row->owner_id);			
			$res['project_desc'] = $row->project_desc;
			//$res['permission']=1;			
			if($user_id==$row->owner_id)
			{
				$res['permission']=1;
			}
			else
			{
				$res['permission']=0;
			}
		
			$result[] =$res;
		}
      
        return $result;
    }


	public function getAll($request)
	{
	try {
		$orgid=$request[1];	
		$userid=$request[0];	
		//$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			
		
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$adminsts=$_SESSION['ubihrm_user_sts'];
	//	$sql = "SELECT id,project_title FROM project_master where OrganizationId=? and assigned_to in ($ids) ";
		$sql = "SELECT id,project_title FROM project_master where OrganizationId=? and (owner_id = $userid OR ClientManager=$userid OR ProjectLead=$userid)";
		if($adminsts==1 || $hrsts==1)
		$sql = "SELECT id,project_title FROM project_master where OrganizationId=? ";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$result =array(); $data=array();
		while($row = $query->fetch())
		{
			$res= array();
			$res['id'] = $row->id;
			$res['name'] = $row->project_title;
			
			$data[] =$res;
		}
	}catch(Exception $e){}
	$result['status']=true;
	$result['data']=$data;
	return $result;
}

	public function getAllRunningProject($request)
	{
	try {
		$orgid=$request[1];	
		$userid=$request[0];	
		//$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$adminsts=$_SESSION['ubihrm_user_sts'];
		//$sql = "SELECT id,project_title FROM project_master where OrganizationId=? and (owner_id in ($ids) or find_in_set($userid,assigned_to)) and project_status in (1,4)";
		//$sql = "SELECT id,project_title FROM project_master where OrganizationId=? and (owner_id =$userid or find_in_set($userid,assigned_to) or ClientManager=$userid OR ProjectLead=$userid) and project_status in (1,4)";
		$sql = "SELECT id,project_title FROM project_master where OrganizationId=? and (owner_id =$userid or ClientManager=$userid OR ProjectLead=$userid) and project_status in (1,4)";
		if($adminsts==1 || $hrsts==1)
			$sql = "SELECT id,project_title FROM project_master where OrganizationId=?  and project_status in (1,4)";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$result =array(); $data=array();
		while($row = $query->fetch())
		{
			$res= array();
			$res['id'] = $row->id;
			$res['name'] = $row->project_title;
			
			$data[] =$res;
		}
		$res= array();
		$res['id'] = 0;
		$res['name'] = "Other";
		$data[] =$res;
	}catch(Exception $e){}
	$result['status']=true;
	$result['data']=$data;
	return $result;
}
  
	public function getAllProject($request)
	{
	try {
		
		$orgid=$request[1];	
		$userid=$request[0];	
		
		$sql = "SELECT id,project_title FROM project_master where OrganizationId=?";
		
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$result =array(); $data=array();
		while($row = $query->fetch())
		{
			$res= array();
			$res['id'] = $row->id;
			$res['name'] = $row->project_title;
			
			$data[] =$res;
		}
		$res= array();
			$res['id'] = "0";
			$res['name'] = "Others";
			$data[] =$res;
			
	}catch(Exception $e){}
	$result['status']=true;
	$result['data']=$data;
	return $result;
}

	public function getUserprojects($request)
	{
	try {
		
		$orgid=$request[1];	
		$userid=$request[0];	
		
		$sql = "SELECT id,project_title FROM project_master where OrganizationId=? and find_in_set($userid,assigned_to) and  project_status =1 order by project_title desc";
		
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$result =array(); $data=array();
		while($row = $query->fetch())
		{
			$res= array();
			$res['id'] = $row->id;
			$res['name'] = $row->project_title;
			
			$data[] =$res;
		}
		$res= array();
			$res['id'] = 0;
			$res['name'] = "Others";
			$data[] =$res;
			
	}catch(Exception $e){}
	$result['status']=true;
	$result['data']=$data;
	return $result;
}
     
    ///////////////////////////////////Project Milestone/////////////////////////////////
    public function getDetail($id)  {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM project_master WHERE id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch()) {
				$res = array();
				$res['id'] = $row->id;
				$res['project_title'] = $row->project_title;
				$res['start_date'] = Utils::dateformatter($row->start_date);
				$res['completed_date'] = Utils::dateformatter($row->completed_date);
				$res['clientmanager'] = $row->ClientManager;
				$res['owner_id'] = $row->owner_id;
				$res['project_desc'] = $row->project_desc;
				$res['project_status'] = $row->project_status;
				$res['billingmethod'] = $row->BillingMethod;
				$res['projectlead'] = $row->ProjectLead;
				$res['budget'] = $row->ProjectBudget;
				$res['costproject'] = $row->CostProject;
				$res['assigned_to'] =explode(',',$row->assigned_to);
				$res['jobchild'] = array();
				$res['company'] = $row->company;
				$res['billablests'] = $row->Billingsts;
				$res['ProjectDoc'] = $row->ProjectDoc;
				$res['milestoneids'] = explode(',',$row->milestones);
				$res['projecttypeid'] = $row->ProjectTypeId;
				if( $row->project_status==4){
					$sqlreopen="select * from ReopenProjectHistory where projectId =? order by Id desc";
					$queryreopen= $this->db->prepare($sqlreopen);
					$queryreopen->execute(array($row->id));
					$rowre=$queryreopen->fetch();
					$res['start_date'] = Utils::dateformatter($rowre->startreopeddate);
					$res['completed_date'] = Utils::dateformatter($rowre->endreopenddate);
				}
				$milestonesql = "SELECT * FROM ProjectMilestoneCost WHERE Projectid = ?";
				$milestonequery = $this->db->prepare($milestonesql);
				$milestonequery->execute(array( $row->id ));
				while($row1 = $milestonequery->fetch())	{
					$res1 = array();
					$res1['Id'] = $row1->Id;
					
					$res1['milestoneid'] =$row1->MileStoneId;
					$res1['milestonecost'] =$row1->MileStoneCost;
					$res['billingmilestone'][] = $res1;
				}
				$employeesql = "SELECT * FROM ProjectEmployeeCost WHERE ProjectId = ?";
				$employeequery = $this->db->prepare($employeesql);
				$employeequery->execute(array( $row->id ));
				while($row2 = $employeequery->fetch())	{
					$res2 = array();
					$res2['Id'] = $row2->Id;
					
					$res2['selectemployeeid'] =$row2->EmployeeId;
					$desi=Utils::getName($row2->EmployeeId,"EmployeeMaster","Designation",$this->db);
					$res2['empdesigid'] =Utils::getName($desi,"DesignationMaster","Name",$this->db);
					$res2['employeecost'] =$row2->EmployeeCost;
					$res['billingemployee'][] = $res2;
				}
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = JOBMODIFICATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = JOBMODIFICATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    } 
	public function gettimesheetDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid = $_SESSION['ubihrm_user_id'];
        $sql = "SELECT * FROM project_master WHERE id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['project_title'] = $row->project_title;
				
				$res['start_date'] = Utils::dateformatter($row->start_date);
				$res['completed_date'] = Utils::dateformatter($row->completed_date);
				$res['owner_id'] = (int)$row->owner_id;
				$res['project_desc'] = $row->project_desc;
				$res['assigned_to'] =explode(',',$row->assigned_to);
				$res['jobchild'] = array();
				
				$timesheetsql = "SELECT * FROM timesheet_master WHERE project_id = ? and EmployeeId=?";
				$timesheetquery = $this->db->prepare($timesheetsql);
				$timesheetquery->execute(array( $row->id,$mid ));
				while($row1 = $timesheetquery->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->id;
					$res1['priority'] = (int)($row1->priority);
					//$res1['project_id'] =(int)($row1->project_id);
					$res1['taskid'] = $row1->task_id;
					$res1['assignto'] =$row1->EmployeeId;
					$res1['sdate'] = Utils::datetimeformatter($row1->start_time);
					$res1['edate'] = Utils::datetimeformatter($row1->end_time);
					$res1['sstartdate']=Utils::datetimeformatter($row1->timesheetstart);
					$res1['senddate']=Utils::datetimeformatter($row1->timesheetend);
					if($row1->timesheetstart=='0000-00-00 00:00:00'){
						$res1['sstartdate']=Utils::datetimeformatter($row1->start_time);
					}
					if($row1->timesheetend=='0000-00-00 00:00:00'){
						$res1['senddate']=Utils::datetimeformatter($row1->end_time);
					}
					
					$res['jobchild'][] = $res1;
				}
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = JOBMODIFICATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = JOBMODIFICATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	////// test for project model //////
	public function GetProgressProjectData($pid) {		
	$msg="";
	$result1 =array();
	$result =array();
	$count1=0;
	$count2=0;
	$totalmilestone=0;
	$totaltasks=0;
	$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : "0";
	$mids="";
	$result['milestonetask'] = array();
 	$sql = "SELECT id FROM milestone where projectid=:pid";
    $query = $this->db->prepare($sql);
    $query->execute(array(':pid'=>$pid));
	$totalmilestone=$query->rowCount();
	while($row3=$query->fetch())
	{
		$mids=$mids.($row3->id).',';
	}
	$mids=rtrim($mids,',');
	
	if($mids!='')
	{
	$sql2 = "SELECT * FROM task_master where milestone_id in ($mids)";
	$query2 = $this->db->prepare($sql2);
	$query2->execute();
	$totaltasks=$query2->rowCount();

	$sql = "SELECT id FROM milestone where projectid=:pid";
        $query = $this->db->prepare($sql);
        $query->execute(array(':pid'=>$pid));
        while($row= $query->fetch())
        {
        
			$mid=$row->id;
			$sql1 = "SELECT count(status) as countstatus, milestone_id, status FROM task_master where milestone_id=$mid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($row1= $query1->fetch())
			{
				$arr = array();
				$arr['countstatus']= $row1->countstatus;
			
				if($arr['countstatus']!=0)
				{
				
					$arr['milestoneid']= $row1->milestone_id;
					$arr['milestonename']= self::getMilestoneName($row1->milestone_id);
					$arr['status1']= $row1->status;
					$arr['status']= self::getOtherInfo($row1->status);
					if($totaltasks!=0)
					{
						$arr['percent']= round((($row1->countstatus*100)/$totaltasks),2);
						$result['milestonetask'][]=$arr;
					}
					else
					{
						$arr['percent']=0;
						$result['milestonetask'][]=$arr;
					}
				}
			

			}
		
	   	}
		
	$result['totaltasks']=$totaltasks;  	
	$msg=$result;
	}//end of if
	$result1[] =$result;
		
        return $result1;
    }

  public function Update($request) {
		$result = array();
		$count=0; $countpro =0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");

		$sql1 = "SELECT * FROM project_master WHERE id<>? and project_title = ? and company=? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[15],$request[3],$request[2], $request[1]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1) {
			 $status =false;
			 $errorMsg="Project and Client already exist.";
		}else{
			$assignto= "" ;
			$assignto =is_array($request[12]) ? implode(',',$request[12]): $request[12];
		
			$milestoneids="";
			$milestoneids = is_array($request[5]) ? implode(',',$request[5]): $request[5];
			$from = Utils::getDateformat($request[6]);
			$to = Utils::getDateformat($request[7]);
			$sql1 = "SELECT project_status FROM project_master WHERE id=?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array($request[15]));
				$count1 =  $query1->rowCount();
				$row= $query1->fetch();
				$oldprostatus= $row->project_status;
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			$sql="";
			if($oldprostatus==4 || $request[9]==4){
				$sql = "UPDATE project_master SET project_title=?, owner_id =?, project_desc=?,project_status=?, updated_by=?, update_on=?, assigned_to=?, OrganizationId=?, company=?, milestones = ?, ProjectTypeId = ? , Billingsts=? , BillingMethod=? , CostProject=?, ClientManager=?, ProjectBudget=? , ProjectLead=?  where id=?";
				$query = $this->db->prepare($sql);
				try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					//$assignto = is_array($request[7]) ? implode(',',$request[7]): $request[7];
					//$from = $request[6];
					//$to = $request[7];
					$query = $this->db->prepare($sql);
					$query->execute(array($request[3], $request[11], $request[8],$request[9], $mid, $mdate, $assignto, $orgid, $request[2],$milestoneids,$request[4],$request[10],$request[13],$request[14],$request[16], $request[17],$request[18], $request[15]));
					$count =  $query->rowCount();
					if($count==1){
						$sql1="select projectId from ReopenProjectHistory where  projectId=?";
						$query2=$this->db->prepare($sql1);
						$query2->execute(array($request[15]));
						$countpro = $query2->rowCount();
						$sqlpro="";
						if($countpro==0){
							$sqlpro="insert into  ReopenProjectHistory(projectId , startreopeddate, endreopenddate ,projectstatus )values(?,?,?,?)";
							$query= $this->db->prepare($sqlpro);
							$query->execute(array($request[15], $from,$to,$request[9]));
						}else{
							$sqlpro="update ReopenProjectHistory set startreopeddate=? , endreopenddate=? where projectId =? order by Id desc";
							$query= $this->db->prepare($sqlpro);
							$query->execute(array($from,$to,$request[15]));
						}
						$status =true;
						$successMsg = "Project has been updated successfully";
					} else {
					   $status =false;
					   $errorMsg = BANK_MODULE_UPDATION_FAILED;
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}	
			else{
			
			$sql = "UPDATE project_master SET project_title=?, start_date=?, completed_date=?, owner_id =?, project_desc=?,project_status=?, updated_by=?, update_on=?, assigned_to=?, OrganizationId=?, company=?, milestones = ?, ProjectTypeId = ? , Billingsts=? , BillingMethod=? , CostProject=?, ClientManager=?, ProjectBudget=?, ProjectLead=?  where id=?";
			$query = $this->db->prepare($sql);
				try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					//$assignto = is_array($request[7]) ? implode(',',$request[7]): $request[7];
					
					$query = $this->db->prepare($sql);
					$query->execute(array($request[3],$from, $to, $request[11], $request[8],$request[9], $mid, $mdate, $assignto, $orgid, $request[2],$milestoneids,$request[4],$request[10],$request[13],$request[14],$request[16], $request[17],$request[18], $request[15]));
					$count =  $query->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				if ($count == 1) {
					$sql1 = "delete FROM ProjectMilestoneCost WHERE Projectid in ($request[15])";
					$query1 = $this->db->prepare($sql1);
					$query1->execute();			
					$milestonearr  = json_decode($_REQUEST['billingmillestone'],true);
					foreach($milestonearr as $value1){
						if($value1['milestoneid']!=""){
							$milestonename=$value1['milestoneid'];
							$milestonecost=$value1['milestonecost'];
							$projectid=$request[15];
							$sql = "INSERT INTO ProjectMilestoneCost (Projectid, MileStoneId, MileStoneCost ) VALUES (?, ?, ?)";
							$query = $this->db->prepare($sql);
							$query->execute(array($projectid, $milestonename, $milestonecost));
							$count3=$query->rowCount();
						}
					}
					$sql2 = "delete FROM ProjectEmployeeCost WHERE ProjectId in ($request[15])";
					$query2 = $this->db->prepare($sql2);
					$query2->execute();	
					$employeearr  = json_decode($_POST['billingemployee'],true);
					foreach($employeearr as $value){
						if($value['selectemployeeid']!=""){
							$employeename=$value['selectemployeeid'];
							$employeecost=$value['employeecost'];
							$projectid=$request[15];
							$sql = "INSERT INTO ProjectEmployeeCost (ProjectId, EmployeeId, EmployeeCost ) VALUES (?, ?, ?)";
							$query = $this->db->prepare($sql);
							$query->execute(array($projectid, $employeename, $employeecost));
							$count3=$query->rowCount();
						}
					}
					 $status =true;
				   $successMsg = "Project has been updated successfully";
				} else {
				   $status =false;
				   $errorMsg = BANK_MODULE_UPDATION_FAILED;
				}
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function UpdateTimesheet($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		try{
			$mid   = $request[0];//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$projectid = $request[3];
			
			$work = json_decode($_POST['timesheet'], true); 
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['taskid']!="")
				{
					$sstartdate = Utils::getDateTimeformat($work[$i]['sstartdate']);
					$senddate = Utils::getDateTimeformat($work[$i]['senddate']);
					$sqlsalary = "UPDATE timesheet_master SET timesheetstart=?, timesheetend=?, updated_date=? where project_id=? and  EmployeeId =?";
								
					$querysalary = $this->db->prepare($sqlsalary);
					$querysalary->execute(array($sstartdate,$senddate,$mdate,$projectid,$mid));
					$count =  $querysalary->rowCount();
					
				} 
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if ($count == 1) {
			$status =true;
			$successMsg = "Project has been updated successfully";
		}
		else{
			 $status =false;
			 $errorMsg = BANK_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

    /**
     * Setter for a project_master (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)  {
		$result = array();$pid=0;
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM project_master WHERE project_title = '".$request[3]."' and company =$request[2] and OrganizationId=$orgid";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute();
			 $count1 =  $query1->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1 > 0) {
			 $status =false;
			 $errorMsg=" Project and client already exist.";
		}else{
			$assignto= "" ;
			$assignto =is_array($request[12]) ? implode(',',$request[12]): $request[12];
		
			$milestoneids="";
			$milestoneids = is_array($request[5]) ? implode(',',$request[5]): $request[5];
			/* foreach($milestoneids as $value){
				if($milestone==""){
					$milestone=$value->id;
				}else{
					$milestone=$milestone.",".$value->id;
				}
			} */
			
			$project_id=strtoupper(substr($request[6],0,3));
			$query1 = $this->db->prepare("SELECT max(id)+1 as maxid FROM project_master");
			$query1->execute();
			if ($row1=$query1->fetch()) {
				$num1 =str_pad($row1->maxid, 4, '0', STR_PAD_LEFT);
				$project_id=$project_id."-".$num1;
			}
			//Utils::Trace($project_id);
			$sql = "INSERT INTO project_master (project_no, project_title,  created_date, start_date, completed_date, project_status, owner_id, project_desc, updated_by, update_on, assigned_to, OrganizationId, company,milestones,ProjectTypeId, Billingsts,BillingMethod,CostProject, ClientManager, ProjectBudget, ProjectLead) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		
			try{
				$from = Utils::getDateformat($request[6]);
				$to = Utils::getDateformat($request[7]);
				$query = $this->db->prepare($sql);
				$query->execute(array($project_id, $request[3],$mdate, $from,$to,$request[9], $request[11], $request[8], $mid, $mdate, $assignto, $orgid,$request[2],$milestoneids,$request[4],$request[10],$request[13],$request[14],$request[15], $request[16], $request[17]));
				$res=array();
				$res['projectid']=$this->db->lastInsertId();
				$pid=$res['projectid'];
				$count =  $query->rowCount();
				$data[]= $res;
				
				}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
				}
			
			if ($count == 1) {
				if($request[9]==4){
					$projectid=$res['projectid'];
					$sql1="insert into ReopenProjectHistory (projectId, startreopeddate, endreopenddate, projectstatus)values(?,?,?,?)";
					$query=$this->db->prepare($sql1);
					$query->execute(array($projectid, $from,$to,$request[9]));
				}
				/*generate mail and alert for project assigned*/
				Alerts::generateActionAlerts(20,$pid,$orgid,$this->db);
				
				$milestonearr  = json_decode($_REQUEST['billingmillestone'],true);
				foreach($milestonearr as $value1){
					if($value1['milestoneid']!=""){
						$milestonename=$value1['milestoneid'];
						$milestonecost=$value1['milestonecost'];
						$projectid=$res['projectid'];
						$sql = "INSERT INTO ProjectMilestoneCost (Projectid, MileStoneId, MileStoneCost ) VALUES (?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($projectid, $milestonename, $milestonecost));
						$count3=$query->rowCount();
					}
				}
				$employeearr  = json_decode($_POST['billingemployee'],true);
				foreach($employeearr as $value){
					if($value['selectemployeeid']!=""){
						$employeename=$value['selectemployeeid'];
						$employeecost=$value['employeecost'];
						$projectid=$res['projectid'];
						$sql = "INSERT INTO ProjectEmployeeCost (ProjectId, EmployeeId, EmployeeCost ) VALUES (?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($projectid, $employeename, $employeecost));
						$count3=$query->rowCount();
					}
				}
			   $status =true;
			   $successMsg = "Project has been created successfully";
			} else {
			   $status =false;
			   $errorMsg = BANK_MODULE_CREATION_FAILED;
				}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	public function uploadprojectdocs($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$projectid = $request[2];
		$new_name="";
		if (!file_exists("public/uploads/projectdocs/")) {
						mkdir("public/uploads/projectdocs/", 0777, true);
				}
		$dir="public/uploads/projectdocs/";
		$filename="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				/* if ($ext=='png' || $ext=='jpg' || $ext=='gif' || $ext=='MOV' || $ext=='ico' || $ext=='tif') */
				if(true)
				{
					
					$new_name=$projectid.".".$ext;
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/projectdocs/";
					if (file_exists($new_name))
				{ 
						unlink("public/uploads/projectdocs/$file_name"); 
				}
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					}	
					if(empty($errors)==true){
					
						move_uploaded_file($file_tmp, $location.$new_name);
						
					}
					else{
						print_r($errors);
					}
				}
				else{
					$status =false;
					$successMsg = "Choose Only Image Format..";
				}				
			}
				$sql = "UPDATE project_master SET ProjectDoc=? where id=?";	
            $query = $this->db->prepare($sql);
		
			try{
			
				$query->execute(array($new_name,$projectid ));			
				$count1 =  $query->rowCount();
			}catch(Exception $e) {
			
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count1 >= 1) {
			
			   $status =true;
			    $successMsg = "Project  attachment uploaded successfully..";
			} else {
			   $status =false;
			   $errorMsg .= "There is some problem while updating record.";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		// default return
        return $result;
	
	}  
	/**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $count2=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid =  $_SESSION['ubihrm_org_id'];
		$mdate = date("Y-m-d H:i:s");
		
		$sql2 = "select projectid from task_master where projectid = :id";
		$query2 = $this->db->prepare($sql2);
		$query2 ->execute(array(':id'=> $did));
		$count = $query2->rowCount();
		if($count>=1){
			$status =true;
		    //$errorMsg = "Project containing task cannot be deleted. ";
		          /* Delete Records from task_master table */
			$sql1 = "DELETE FROM task_master WHERE projectid = :projectid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':projectid' => $did));	
		} 
			
			try{
				    // Get the project title from project master
				$sql3 = "select project_title from project_master where id = :id";
				$query3 = $this->db->prepare($sql3);
				$query3 ->execute(array(':id'=> $did));
				$project_title="";
				while($row=$query3->fetch()){
				   $project_title=$row->project_title;
			    } 	
				
				    // Get the username from EmployeeMaster
				$sql4 = "select FirstName,LastName from  EmployeeMaster where Id = :id";
				$query4 = $this->db->prepare($sql4);
				$query4 ->execute(array(':id'=> $userid));
				$UserName="";
				while($row1=$query4->fetch()){
				   $UserName=$row1->FirstName;
			    } 
		
				$sql = "DELETE FROM project_master WHERE id = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$count =  $query->rowCount();	
              
                $msg = "The Project <b> ".$project_title." </b> has been deleted by ".$UserName."";
				         /* insert record in ActivityHistoryMaster table  */
				$sql2 = "INSERT INTO `ActivityHistoryMaster`(LastModifiedDate, LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?,?,?,?,?)";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($mdate, $userid, "Timesheet", $msg, $orgid)); 				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
					$status =true;
					$successMsg = "Project has been Deleted successfully";
			}else {
			       $status =false;
				   $errorMsg = BANK_MODULE_DELETE_FAILED;
			}
  		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	 public function deleteDefaultMilestone($did,$pid)
    {
        $result = array();
		$count=0; $count1=0; $count2=0; $count3=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$sql = "select DefaultMilestoneId FROM Milestone WHERE DefaultMilestoneId = :id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		$count3 = $query->rowCount();
		if($count3>=1){
			$status =false;
			$errorMsg = "Activity containing Task cannot be deleted. ";
		}else{
		$sql1 = "DELETE FROM SettingMilestone WHERE Id = :id";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
			$sql = "select * FROM SettingMilestone WHERE ProjectTypeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $pid));
			$count =  $query->rowCount();
			if($count==0){
				$sql1 = "DELETE FROM ProjectTypeMaster WHERE Id = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( ':id' => $pid));
				$count2 =  $query1->rowCount();
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if ($count1 == 1) {
			   $status =true;
				   $successMsg = "Activity has been deleted successfully";
			}else{
			   $status =false;
				$errorMsg = BANK_MODULE_DELETE_FAILED;
			}
			if ($count2 == 1) {
			   $status =true;
				   $successMsg = "Project Type and Activity has been deleted successfully";
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM project_master WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}

	public function getAllHierarchyEmployee($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
				
		$ids =Utils::getReportingIds($mid, $this->db);
		$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) and Id in ($ids) and Is_Delete=0 order by FirstName ";
		
		$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array(':id' => $orgid ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['sts'] = 0;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getProjectDetail($id)
    {
		$result1 =array();
        $result =array();
		$userid = $_SESSION['user_id'];
        $sql = "SELECT * FROM project_master WHERE id=:id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));
		if($query->rowCount()>0)
		{
		    	while($row = $query->fetch())
				{
				$res= array();
				$res['projectid'] =$row->id;
				$res['projectname'] =$row->project_title;
				$res['startdate'] =self::changedateformate($row->start_date);
				$res['enddate'] =self::changedateformate($row->estimated_date);			
				$res['status'] 	=self::getOtherInfo($row->project_status);
				$res['createby'] =self::getUserName($row->owner_id);
				$res['description'] = html_entity_decode($row->project_desc);
				$res['createdate'] =self::changedateformate($row->created_date);
				$res['completedate'] =self::changedateformate($row->completed_date);
				$res['createdate1'] =$row->created_date;
				$res['completedate1'] =$row->completed_date;
				$res['startdate1'] =$row->start_date;
				$res['enddate1'] =$row->estimated_date;
				$res['status1'] 	=$row->project_status;
				$result['projects'][] =$res;
			}
		}
		else
		{
			$result['projects'] = array();
		}


/////////////////////////////////Task Gantt Chart START//////////////////////////////////
		$i=1;
		
		$sql1="SELECT id, start_date, end_date FROM task_master where project_id=:id";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array(':id' =>$id ));

		if($query1->rowcount()>0)
		{
			while($row = $query1->fetch())
			{
				$res = array();
				$res['Phase'] ='Phase '.$i;
				$res['startdate'] = $row->start_date;
				$res['enddate'] = $row->end_date;
				$res['Task'] ='Task '.$i;

				$i++;
				$result['newtaskchart'][] = $res;
			}

		}
		else
		{
			$result['newtaskchart'] = array();
		}

/////////////////////////////////Task Gantt Chart END///////////////////////////////////
		
		$sql = "SELECT id, status, count(id) as totalp FROM task_master where project_id=:id group by status";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));
		if($query->rowCount()>0){
		    while($row = $query->fetch())
			{
				$res= array();
				$res['id'] =$row->id;
				$res['statusid'] =$row->status;
				$res['totalp'] =$row->totalp;
				$res['status'] =self::getOtherInfo($row->status);
				$result['tasks'][] = $res;
			}
		}
		else
		{
			$result['tasks'] = array();
		}
        
        
        $sql = "SELECT bug_id, bug_status, count(bug_id) as totalp FROM bug_master where project_id=:id group by bug_status";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));
		if($query->rowCount()>0){
		    while($row = $query->fetch())
			{
				$res= array();
				$res['id'] =$row->bug_id;
				$res['totalp'] =$row->totalp;
				$res['statusid'] =$row->bug_status;
				$res['status'] =self::getOtherInfo($row->bug_status);
				$result['bugs'][] = $res;
			
			}
		}
		else
		{
			$result['bugs'] = array();
		}
		
		$sql = "SELECT id, emp_id, count(id) as totalp FROM task_master where project_id=:id group by emp_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));
		if($query->rowCount()>0){
		    while($row = $query->fetch())
			{
				$res= array();
				$res['id'] =$row->id;
				$res['totalp'] =$row->totalp;
				$res['status'] =self::getUserName($row->emp_id);
				$res['imgsrc'] = self::getImageUrl($row->emp_id);
				$result['users'][] = $res;
			
			}
		}
		else
		{
			$result['users'] = array();
		}
		
        $result1[]= $result;
       return $result1;
    }


	public function getDataTable($editper, $deleteper, $type)
	{
		$sTable = 'project_master';
		$sIndexColumn = "id";
		$aColumns = array('project_title','ProjectTypeId','owner_id','assigned_to','start_date','completed_date','id','id','Billingsts','company','ClientManager','id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  id desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		else{
			$sOrder = "ORDER BY  created_date desc";
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$typecond="";
		if($type!=6){
			$typecond = " and project_status = $type";
		}	
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid $typecond   ";
		}else{
			//$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sWhere = " WHERE (((owner_id =$userid) OR (ClientManager=$userid) OR (ProjectLead=$userid)) AND OrganizationId=$orgid $typecond) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id" && $i==11){
					continue;
				}
				if($aColumns[$i]=="owner_id"){
				$sWhere .= " (owner_id in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else if($aColumns[$i]=="company"){
				$sWhere .= " (company in ( select Id from EmployerMaster where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3 && $type!=6){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
				//	$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
					if($aColumns[$i]=="start_date" && $i==4){
						//$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
						
						$sWhere .= " ('".$_GET['sSearch_'.$i]."' between start_date and completed_date) ";
					}else{
						$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
					}
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="owner_id" )
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					
				}else if($aColumns[$i]=="project_title" )
				{
					$row[] ='<a rel="tooltip" href="'.URL.'timesheet/viewproject/'.Utils::encode5t($aRow->id).'/1"  title="View Details">'.$aRow->project_title.'</a>';
					
				}else if($aColumns[$i]=="ClientManager" )
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					
				}
				elseif($aColumns[$i]=="ProjectTypeId" )
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},"ProjectTypeMaster","Name",$this->db);
					
				}
				elseif($aColumns[$i]=="start_date" || $aColumns[$i]=="completed_date" )
				{
					if(($aRow->{$aColumns[$i]})=="0000-00-00")
					{
						$row[]="-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}					
				}
				elseif($aColumns[$i]=="company" )
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},"EmployerMaster","Name",$this->db);
					
				}elseif($aColumns[$i]=="id" && $i==6 )
				{
						$row[] = $this->ViewEmpTaskDetail($aRow->{$aColumns[$i]},3);
				}elseif($aColumns[$i]=="id" && $i==7 )
				{
						$row[] = $this->ViewEmpTaskDetail($aRow->{$aColumns[$i]},2);
				}
				
				/* else if($aColumns[$i]=="project_status"){
					if($aRow->{$aColumns[$i]}==1)
						$sts="<span class='label label-success'>Running</span>";
					else if($aRow->{$aColumns[$i]}==2)
						$sts="<span class='label label-warning'>Abandoned</span>";
					else if($aRow->{$aColumns[$i]}==3)
						$sts="<span class='label label-danger'>Finished</span>";
					else if($aRow->{$aColumns[$i]}==4)
						$sts="<span class='label label-info'>Re opened</span>";
					else if($aRow->{$aColumns[$i]}==5)
						$sts="<span class='label label-primary'>Not Started</span>";
					$row[] = $sts;
				} */else if($aColumns[$i]=="Billingsts"){
					$billsts="";
					if($aRow->{$aColumns[$i]}==1)
						$billsts="<span class='label label-info'>Billable</span>";
					else if($aRow->{$aColumns[$i]}==2)
						$billsts="<span class='label label-warning'>Non Billable</span>";
					
					$row[] = $billsts;
				}
				elseif($aColumns[$i]=="assigned_to"){
					$assign=explode(",",$aRow->{$aColumns[$i]});
					$assignemp="";
					for($ij=0;$ij<count($assign);$ij++)
					{
						if($assignemp=="")
							$assignemp=Utils::getEmployeeName($assign[$ij], $this->db);
						else
							$assignemp.=", ".Utils::getEmployeeName($assign[$ij], $this->db);
					}
							
					$row[] = $assignemp;
				}
				elseif($aColumns[$i]=="id" && $i==11)
				{
					$edit=""; $delete=""; $checklist="";$viewdetail="";$addmilestone="";$reopenhistory="";
					$count= $this->countReopenedProject($aRow->{$aColumns[$i]});
					
					if($editper){
						$edit ='<a rel="tooltip" title="Edit" href="'.URL.'timesheet/editproject/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit ='<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
						
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
					$viewdetail= '<a rel="tooltip" href="'.URL.'timesheet/viewproject/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/1"  title="View Details"><i class="fa fa-eye green-700"></i></a>';
					$addmilestone= '  <a rel="tooltip" href="'.URL.'projects/milestonelist/'.$aRow->{$aColumns[$i]}.'"  title="Configure Milestones"><i class="fa fa-wrench green-700"></i></a>';	
					if($count>0){
					$reopenhistory = '<a onclick="angular.element(this).scope().reopenedhistory(\''.$aRow->{$aColumns[$i]}.'\',\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#reopenedhistory" rel="tooltip" href="#"  title="Reopened History" ><i class="fa fa-book"></i><span class="badge badge-danger up">'.$count.'</span></a>';
					$reopenhistory = '<a onclick="angular.element(this).scope().reopenedhistory(\''.$aRow->{$aColumns[$i]}.'\',\''.$aRow->project_title.'\')" data-toggle="modal" data-target="#reopenedhistory" rel="tooltip" href="#"  title="Reopened History" ><i class="fa fa-book"></i><span class="badge badge-danger up">'.$count.'</span></a>';
					}
					$row[] =$addmilestone."&nbsp;|&nbsp;".$viewdetail."&nbsp;|&nbsp;".$edit."&nbsp;|&nbsp;".$delete."&nbsp;|&nbsp;".$reopenhistory ;
				}
				
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
	public function countReopenedProject($projectid)
    {
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = '';
		
        $sql = "select count(*) as hiscount from ReopenProjectHistory where  projectId IN ($projectid) order by Id desc ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array());
			$count =  $query->rowCount();
			while($row = $query->fetch())
			{
				$res = array();
				$data =$row->hiscount;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		return $data;
    }	
	public function getReopenedHistory($projectid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $sql = "SELECT * FROM ReopenProjectHistory WHERE  projectId in ($projectid) order by Id desc";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array());
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				//$res['feedid'] =$row->feedid;
				$res['endreopenddate'] =Utils::dateformatter($row->endreopenddate);
				$res['startreopeddate'] =Utils::dateformatter($row->startreopeddate);
				
				$data[] = $res;
			}
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    } 
	 /**
     * Setter for a project_master (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function createProjectType($request)
    {
		$result = array();
		$count=0; $count1=0; $count2=0; $count3=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM ProjectTypeMaster WHERE Name = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[3],$orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg="Project type is already exist.";
		}else{
			
			$sql = "INSERT INTO ProjectTypeMaster ( Name, Description, CreatedDate, CreatedById, OrganizationId) VALUES (?, ?, ?, ?, ?)";
		
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[3], $request[4], $mdate, $mid, $orgid));
				$count =  $query->rowCount();
				if($count>=1){
					$projecttypeid = $this->db->lastInsertId();
					$arr = json_decode($request[2]);
					foreach($arr as $value){
						$milestonename=$value->name;
						$milestonedesc=$value->desc;
						$sql1 = "SELECT * FROM SettingMilestone WHERE Name = ? and ProjectTypeId = ? and OrganizationId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($milestonename, $projecttypeid, $orgid));
						$count2 =  $query1->rowCount();
						if($count2==0){
							$sql = "INSERT INTO SettingMilestone ( Name, Description, CreatedDate, CreatedById, OrganizationId, ProjectTypeId) VALUES (?, ?, ?, ?, ?, ?)";
							$query = $this->db->prepare($sql);
							$query->execute(array($milestonename, $milestonedesc, $mdate, $mid, $orgid, $projecttypeid));
							$count3=$query->rowCount();
						}
					}
				}
				}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
				}
			
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Project type has been created successfully";
			}else {
			   $status =false;
			   $errorMsg = "Project type creation is failed";
				}
				if($count2!=0){
				$status =true;
			   $successMsg = "Project type has been created with some duplicate milestone";
			}
			
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getProjectTypeData($editper, $deleteper)
	{
		$sTable = 'SettingMilestone';
		$sIndexColumn = "id";
		$aColumns = array(  'Name','Description','ProjectTypeId','Id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY ProjectTypeId desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid  ";
		}else{
		//$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			//$sWhere = " WHERE (CreatedById in ($ids) AND OrganizationId= $orgid OR( ProjectTypeId in (select ProjectTypeId from project_master  where (owner_id in ($userid )) OR (ClientManager=$userid))))";
			$sWhere = " WHERE (CreatedById =$userid AND OrganizationId= $orgid OR( ProjectTypeId in (select ProjectTypeId from project_master  where (owner_id =$userid ) OR (ClientManager=$userid) OR (ProjectLead=$userid))))";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (owner_id in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Name" )
				{
					$row[] = $aRow->{$aColumns[$i]};
					
				}
				
				elseif($aColumns[$i]=="Description"){
											
					$row[] = $aRow->{$aColumns[$i]};
				}
				else if($aColumns[$i]=="ProjectTypeId" and $i==2){
					$row[] =Utils::getName($aRow->{$aColumns[$i]},"ProjectTypeMaster","Name",$this->db);
				}
				else if($aColumns[$i]=="Id"){
					$edit =""; $delete=""; $checklist="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'timesheet/editprojecttype/'.Utils::encode5t($aRow->ProjectTypeId).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';						
					}					
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\',\''.$aRow->ProjectTypeId.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}							
					$row[] =$edit."&nbsp;|&nbsp;".$delete;
				}
				
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
	
	 ///////////////////////////////////Project Milestone/////////////////////////////////
    public function getaProjectType($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM ProjectTypeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name']=$row->Name;
				$res['desc']=$row->Description;
				$res['milestone'] = array();
			
				$timesheetsql = "SELECT * FROM SettingMilestone WHERE ProjectTypeId = ?";
				$timesheetquery = $this->db->prepare($timesheetsql);
				$timesheetquery->execute(array( $row->Id ));
				while($row1 = $timesheetquery->fetch())
				{
					$res1 = array();
					$res1['milestoneid'] = $row1->Id;
					$res1['name'] =$row1->Name;
					//$res1['project_id'] =(int)($row1->project_id);
					$res1['desc'] = $row1->Description;
					$res['milestone'][] = $res1;
				}
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = JOBMODIFICATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = JOBMODIFICATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    } 
	
	 public function UpdateProjectType($request)
    {
		$result = array();
		$count=0; $count1=0; $count2=0; $count3=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$projecttypeid = $request[5];
		
		$sql = "update ProjectTypeMaster set Name = ?, Description = ?, ModifiedDate = ?, ModifiedById = ?, OrganizationId = ? where Id = ?";
		
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[3], $request[4], $mdate, $mid, $orgid, $projecttypeid));
				$count =  $query->rowCount();
				if($count>=1){
					$arr = json_decode($request[2], true);
				
					$mileid="0";
					for($i=0; $i<count($arr); $i++){
						$mileid .= ",".$arr[$i]['milestoneid'];
					}
					//print_r($mileid);
					$sqlmile = " DELETE FROM SettingMilestone WHERE ProjectTypeId=? AND Id NOT IN ($mileid)";
					$querymile = $this->db->prepare($sqlmile);
					$querymile->execute(array( $projecttypeid));
					
					foreach($arr as $value){
					//	print_r($value);
						$milestoneid=$value['milestoneid'];
						$milestonename=$value['name'];
						$milestonedesc=$value['desc'];			
							
						if($milestonename!=""){
							if($milestoneid){
								$sqlmile = " UPDATE SettingMilestone SET Name=?, Description=?, ModifiedDate=?, ModifiedById=?, OrganizationId=?  WHERE Id=?";
								$querymile = $this->db->prepare($sqlmile);
								$querymile->execute(array($milestonename, $milestonedesc, $mdate, $mid, $orgid , $milestoneid));
							}else{
								$sqlmile = "INSERT INTO SettingMilestone ( Name, Description, CreatedDate, CreatedById, OrganizationId, ProjectTypeId) VALUES (?, ?, ?, ?, ?, ?)";
								$querymile = $this->db->prepare($sqlmile);
								$querymile->execute(array($milestonename, $milestonedesc, $mdate, $mid, $orgid, $projecttypeid));
								$count3=$querymile->rowCount();	
							}
						}
					}
				}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			
				if ($count == 1) {
				   $status =true;
				   $successMsg = "Project type has been updated successfully";
				}else {
				   $status =false;
				   $errorMsg = "Project type updation is failed";
				}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getAllProjectType($request)
	{
	try {
		$orgid=$request[1];	
		$userid=$request[0];		
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$adminsts=$_SESSION['ubihrm_user_sts'];
		$sql = "SELECT Id, Name FROM ProjectTypeMaster where OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$result =array(); $data=array();
		while($row = $query->fetch())
		{
			$res= array();
			$res['id'] = $row->Id;
			$res['name'] = $row->Name;
			$data[] =$res;
		}
	}catch(Exception $e){}
	$result['status']=true;
	$result['data']=$data;
	return $result;
}

	public function ViewEmpTaskDetail($projectid,$val)
	{
		$result = array(); $res=array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$totalleave=0;
			$totalday=0;$totalhour=0; $totalminute=0;
			$totalday1=0;$totalhour1=0; $totalminute1=0;
			//$sql="select * from task_master where projectid =? ";
			$sql="select * from project_master where id =? ";
			$query=$this->db->prepare($sql);
			$query->execute(array($projectid));
			$count = $query->rowcount();
			$days1='';$hours1='';$minutes1='';
			while($row1= $query->fetch()) {
				//$start = new DateTime($row1->fromdate);
			//	$since_start1 = $start->diff(new DateTime($row1->todate));
				$start = $row1->start_date;
				$today = $row1->completed_date;
				$days1 = strtotime($today) - strtotime($start);
				$totalday1 = floor($days1/(60*60*24));
				/* if($since_start1->d>0){
					$days1=$since_start1->d.' days';
					$totalday1=$totalday1+$since_start1->d;
				} */
				/* if($since_start1->h>0){
					$hours1 = $since_start1->h.' hours';
					$totalhour1=$totalhour1+$since_start1->h;
				}
				if($since_start1->i>0){
					$minutes1 = $since_start1->i.' minutes';
					$totalminute1=$totalminute1+$since_start1->i;
				}
				if($totalhour1>24){
					$totalday1=$totalday1+1;
					$totalhour1=$totalhour1-24;
				}
				if($totalminute1>60){
					$totalhour1=$totalhour1+1;
					$totalminute1=$totalminute1-60;
				} */
			}
			$sql="select * from task_master where projectid =? and OrganizationId=?";
			$query=$this->db->prepare($sql);
			$query->execute(array($projectid, $orgid));
			$count = $query->rowcount();
			while($row1= $query->fetch()) {
				$start = explode(":", $row1->Totalhour);
				if($row1->Totalhour!=""){
					$hours1= $start[0];
					$totalhour1=$totalhour1+$hours1;
					$minutes1 = $start[1];
					$totalminute1=$totalminute1+$minutes1;
				}
			
			$sql2="SELECT * FROM timesheet_master where task_id=? and  project_id = ? and OrganizationId=?";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($row1->id,$projectid, $orgid));
			$con1=$query2->rowCount();
			$mindate="";
			$maxdate="";	$days='';$hours='';$minutes=''; 	$acttotal_time="";
			while($row2 = $query2->fetch()) {
				$total_time = explode(":", $row2->total_time);
				if($row2->total_time!=""){
					$hours= $total_time[0];
					$totalhour=$totalhour+$hours;
					$minutes = $total_time[1];
					$totalminute=$totalminute+$minutes;
					if($totalminute>60){
						$totalhour=$totalhour+1;
						$totalminute=$totalminute-60;
					}
				}
				/*$maxdate=$row2->timesheetend;
				$mindate=$row2->timesheetstart;
				$start_date = new DateTime($mindate);
				$since_start = $start_date->diff(new DateTime($maxdate));
				 if($since_start->d>0){
					$days=$since_start->d.' days';
					$totalday=$totalday+$since_start->d;
				} 
				if($since_start->h>0){
					$hours = $since_start->h.' hours';
					$totalhour=$totalhour+$since_start->h;
				}
				if($since_start->i>0){
					$minutes = $since_start->i.' minutes';
					$totalminute=$totalminute+$since_start->i;
				}
				/* if($totalhour>24){
					$totalday=$totalday+1;
					$totalhour=$totalhour-24;
				} 
				if($totalminute>60){
					$totalhour=$totalhour+1;
					$totalminute=$totalminute-60;
				}*/
			}
		}
			//$acttotaltime= $days.' '.$hours.' '.$minutes;
			//$acttotaltime= $hours.' '.$minutes;
			$esttotal_time =$totalhour1.' hours, '.$totalminute1.' minutes';
			$project_time =$totalday1.' days';
			//$acttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
			$acttotal_time =$totalhour.' hours, '.$totalminute.' minutes';
				
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($val==1)
		return $project_time;
		if($val==2)
		return $acttotal_time;
		if($val==3)
		return $esttotal_time;
	}

	public function getProjectTeamData($projectid) {
		$count=0; $result=array(); $data=array(); $status=false;
		$sql="select * from project_master where id=?";
		$query=$this->db->prepare($sql);
		$query->execute(array($projectid));
		$count=$query->rowcount();
		if($count>=1){
			$status=true;
			$successMsg=$count." record found";
			while($row=$query->fetch()) {
				//$assigned_to['empid']=explode(',' ,$row->assigned_to);
				if($row->assigned_to!=0){
					$assign=$this->getEmpdesig($row->assigned_to);
					foreach($assign as $key=>$value){
						$res=array();
						//$assigned_to=array;
						$res['projectid']=$row->id;
						$res['project_title']=$row->project_title;
						$res['start_date']=$row->start_date;
						$res['completed_date']=$row->completed_date;
						$res['company']=$row->company;
						$res['empid']=$value['empid'];
						$res['empname']=$value['empname'];
						$res['empimage']=$value['ImageName'];
						$res['designame']=$value['designame'];
						$res['taskcomplete']=$this->getEmptask($row->id , $value['empid'],1);
						$res['taskassign']=$this->getEmptask($row->id , $value['empid'],2);
						$res['esttotaltime']=$this->getesttotaltime($row->id , $value['empid'],1);
						$res['getactultotaltime']=$this->getesttotaltime($row->id , $value['empid'],2);
						$res['totalprojecttime']=$this->ViewEmpTaskDetail($row->id,1);
						$res['totalactualtime']=$this->ViewEmpTaskDetail($row->id ,2);
						$res['totalestimatedtime']=$this->ViewEmpTaskDetail($row->id,3);
						$result[]=$res;
					}
				}
					//	$res['assigned_to']=$assigned_to;
			}
			}else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		return $result;
	}
	
	public function getProjectMilestoneData($projectid) {
		$count=0;$count1=0; $result=array(); $result1=array(); $data=array(); $status=false;
		$res=array(); 
		$orgid = $_SESSION['ubihrm_org_id'];	
		$res['projectid']=$projectid;
		$res['project']=Utils::getName($projectid,'project_master','project_title',$this->db);
		$sql1="select * from task_master where projectid=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($projectid));
		$count1= $query1->rowCount();
		if($count1>=1){
			while($row1=$query1->fetch()) {
				$res2=array();
				//$assigned_to=array;
				$res2['milestoneid']=$row1->milestoneid;
				if($row1->milestoneid==0){
					$res2['milesotnename']="Other";
				}else{
					$res2['milesotnename']=Utils::getName($row1->milestoneid,"SettingMilestone","Name",$this->db);
				}
				$res2['task_id']=$row1->id;
				$res2['task_title']=$row1->task_title;
				$res2['assignto']=$row1->assignto;
				$image= Utils::getName($row1->assignto,"EmployeeMaster","ImageName",$this->db);
				$gender= Utils::getName($row1->assignto,"EmployeeMaster","Gender",$this->db);
				//	$res['empgender'] = $row->Gender;
				$res2['ImageName']='<img src="'.URL.'public/avatars/male.png" height="50px" width="50px"  class="img-circle">';
				if($image != ""){
					if (file_exists( "public/uploads/$orgid/$image")) {
						 $res2['ImageName']='<img src="'.URL.'public/uploads/'.$orgid.'/'.$image.'" height="50px" width="50px"  class="img-circle">';
					}
				}
				if($image == ""){
					if($gender== 2)	{
						$res2['ImageName']='<img src="'.URL.'public/avatars/female.png" height="50px" width="50px" class="img-circle">';
					}
				}
				$res2['assigntoname']=self::getEmployeeName($row1->assignto);
				$res2['Totalhour']=$row1->Totalhour;
				$res2['esttotaltime']=$this->getesttotaltime($projectid , $row1->assignto,1);
				$res2['getactultotaltime']=$this->getesttotaltime($projectid ,$row1->assignto,2);
				$res2['totalMilestonetime']=$this->GetMilestoneDuration($row1->milestoneid);
				$res2['totalactualtime']=$this->ViewEmpTaskDetail($row1->id ,2);
				$res2['totalestimatedtime']=$this->ViewEmpTaskDetail($row1->id,3);
				$result1[]=$res2;
			}
		}
		$res['milestone']=$result1;	
		$data[] =$res;
	//	print_r($data);
		return $data;
	}
	  
	public function getEmptask($productid,$empid,$val){
		$result=array(); $count=0;$completed=0;
		if($empid!="" && $productid!=""){
		$sql="select * from task_master where projectid =? and assignto=?";
		$query=$this->db->prepare($sql);
		$query->execute(array($productid,$empid));
		$count = $query->rowcount();
			while($row= $query->fetch()){
			if($row->taskstatus==2){
					$completed++;
				}
			}
			if($val ==1){
				return $completed;
			}else{
				return $count;
			}
		}
	}
	public function getesttotaltime($productid,$empid,$val){
		$result=array();$esttotal_time="";$acttotal_time ="";
		if($empid!="" && $productid!="") {
			$sql="select * from task_master where projectid =? and assignto=?";
			$query=$this->db->prepare($sql);
			$query->execute(array($productid,$empid));
			$count = $query->rowcount();
			$totalday=0;$totalhour=0; $totalminute=0;
			$totalday1=0;$totalhour1=0; $totalminute1=0;
			$days1='';$hours1='';$minutes1='';
			while($row1= $query->fetch()) {
				$start = explode(":", $row1->Totalhour);
				if($row1->Totalhour!=""){
					$hours1= $start[0];
					$totalhour1=$totalhour1+$hours1;
					$minutes1 = $start[1];
					$totalminute1=$totalminute1+$minutes1;
					if($totalminute1>60){
						$totalhour1=$totalhour1+1;
						$totalminute1=$totalminute1-60;
					}
				}	
				//$start = new DateTime($row1->fromdate);
				//$since_start1 = $start->diff(new DateTime($row1->todate));
				
				/* if($since_start1->d>0){
					$days1=$since_start1->d.' days';
					$totalday1=$totalday1+$since_start1->d;
				} */
				/* if($since_start1->h>0){
					$hours1 = $since_start1->h.' hours';
					$totalhour1=$totalhour1+$since_start1->h;
				}
				if($since_start1->i>0){
					$minutes1 = $since_start1->i.' minutes';
					$totalminute1=$totalminute1+$since_start1->i;
				} */
				/* if($totalhour1>24){
					$totalday1=$totalday1+1;
					$totalhour1=$totalhour1-24;
				} */
				/* if($totalminute1>60){
					$totalhour1=$totalhour1+1;
					$totalminute1=$totalminute1-60;
				} */
				
			
			$sql2="SELECT * FROM timesheet_master where task_id=? and project_id = ? and EmployeeId=?";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($row1->id,$productid,$empid));
			$con1=$query2->rowCount();
			$mindate="";
			$maxdate="";
			$days='';$hours='';$minutes='';
			while($row2 = $query2->fetch()) 	{
				$total_time = explode(":", $row2->total_time);
				if($row2->total_time!=""){
					$hours= $total_time[0];
					$totalhour=$totalhour+$hours;
					$minutes = $total_time[1];
					$totalminute=$totalminute+$minutes;
					if($totalminute>60){
						$totalhour=$totalhour+1;
						$totalminute=$totalminute-60;
					}
				}
				/* $maxdate=$row2->timesheetend;
				$mindate=$row2->timesheetstart;
				 $start_date = new DateTime($mindate);
					 $since_start = $start_date->diff(new DateTime($maxdate));
				$start = strtotime($mindate);
				$end   = strtotime($maxdate);
				$diff  = $end - $start;

				$hours = floor($diff / (60 * 60));
				$totalhour=$totalhour+	$hours ;
				$minutes1 = $diff - $hours * (60 * 60);
				$minutes = floor( $minutes1 / 60 ) ;
				$totalminute=$totalminute+$minutes; 
				if($since_start->h>0){
						$hours = $since_start->h.' hours';
						$totalhour=$totalhour+$since_start->h;
					}
					if($since_start->i>0){
						$minutes = $since_start->i.' minutes';
						 $totalminute=$totalminute+$since_start->i;
					} 
					 if($totalhour>24){
						$totalday=$totalday+1;
						$totalhour=$totalhour-24;
					}
					 if($totalminute>60){
						$totalhour=$totalhour+1;
						$totalminute=$totalminute-60;
					}  */
			}
			}
			//$esttotal_time = $totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
			//$acttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
			//$esttotal_time =$totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
			$esttotal_time =$totalhour1.' hours, '.$totalminute1.' minutes';
			//$acttotal_time = $totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
			$acttotal_time = $totalhour.' hours, '.$totalminute.' minutes';
			$acttotal_time1 = $totalhour;
		}
		if($val==1)
			return $esttotal_time;
		if($val==2)
			return $acttotal_time;
		if($val==3)
			return $acttotal_time1;
	}
	public function getEmpdesig($empid){
		$result=array(); $count=0;
		$orgid = $_SESSION['ubihrm_org_id'];	
		if($empid!=""){
		$sql="select * from EmployeeMaster where Id in ($empid) and Is_Delete=0";
		$query=$this->db->prepare($sql);
		$query->execute();
		$count = $query->rowcount();
			while($row= $query->fetch()){
				$res=array();
				$res['empid']=$row->Id;
				$image= $row->ImageName;
			//	$res['empgender'] = $row->Gender;
				$res['ImageName']='<img src="'.URL.'public/avatars/male.png" height="50px" width="50px"  class="img-circle">';
				if($image != ""){
					if (file_exists( "public/uploads/$orgid/$image")) {
						 $res['ImageName']='<img src="'.URL.'public/uploads/'.$orgid.'/'.$image.'" height="50px" width="50px"  class="img-circle">';
					}
				}
				if($image == ""){
					if($row->Gender== 2)	{
						$res['ImageName']='<img src="'.URL.'public/avatars/female.png" height="50px" width="50px" class="img-circle">';
					}
				}
				$res['empname']= self::getEmployeeName($row->Id);
				$res['desigid']=$row->Designation;
				$res['designame']= Utils::getName($row->Designation,"DesignationMaster","Name",$this->db);
				$result[]=$res;
			}
			return $result;
		}
	}
	public function getMilestone($milestoneid){
		$result=array(); $count=0;
		$orgid = $_SESSION['ubihrm_org_id'];	
		if($milestoneid!=""){
		$sql="select * from SettingMilestone where Id in ($milestoneid)";
		$query=$this->db->prepare($sql);
		$query->execute();
		$count = $query->rowcount();
			while($row= $query->fetch()){
				$res=array();
				$res['milestoneid']=$row->Id;
				$res['milesotnename']=$row->Name;
			
				$result[]=$res;
			}
			return $result;
		}
	}
	
	public function getEmployeeName($id)
	{
		$name ="";
		$sql = "SELECT FirstName, MiddleName, LastName FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName));
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getDataMTable($editper, $deleteper, $projectid)
	{
		$sTable = 'Milestone';
		$sIndexColumn = "id";
		$aColumns = array('DefaultMilestoneId','projectid', 'Totalhour', 'id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  projectid desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid and projectid=$projectid";
		}else{
			//$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " WHERE  ( projectid in (select id from project_master where (owner_id=$userid) OR (ClientManager=$userid) OR (ProjectLead=$userid)) AND OrganizationId= $orgid and projectid=$projectid) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (owner_id in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					
						
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				if($aColumns[$i]=="Totalhour"){
					if($aRow->Totalhour!=""){
						$Totalhour=explode(":",$aRow->Totalhour);
						
						if($Totalhour[0]!=0 && $Totalhour[1]!=0 && $Totalhour[2]!=0)
						$row[] =$Totalhour[0]." Days, ". $Totalhour[1]." Hours, ".$Totalhour[2]." minutes";
						else if($Totalhour[0]!=0 && $Totalhour[1]!=0)
						$row[] =$Totalhour[0] ." Days, ". $Totalhour[1]." Hours ";
						else if($Totalhour[1]!=0 && $Totalhour[2]!=0)
						$row[] =$Totalhour[1]." Hours, ".$Totalhour[2]." minutes ";
						else if($Totalhour[0]!=0)
						$row[] =$Totalhour[0]." Days";
						else if($Totalhour[1]!=0)
						$row[] =$Totalhour[1]." Hours";
						else if($Totalhour[2]!=0)
						$row[] =$Totalhour[2]." minutes";
						else if($Totalhour[0]==0 && $Totalhour[1]==0 && $Totalhour[2]==0)
						$row[] ="";
					}else{
						$row[] ="";
					}
				}
				elseif($aColumns[$i]=="projectid"){
											
					$row[] =Utils::getName($aRow->{$aColumns[$i]},"project_master","project_title",$this->db);;
				}
				elseif($aColumns[$i]=="DefaultMilestoneId"){
											
					$row[] = Utils::getName($aRow->{$aColumns[$i]},"SettingMilestone","Name",$this->db);
				}
				/* elseif($aColumns[$i]=="id" && $i==4 )
				{
						$row[] = $this->GetMilestoneDuration($aRow->{$aColumns[$i]});
				} */
				elseif($aColumns[$i]=="id")
				{
					$edit =""; $delete=""; $checklist="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'milestone/editmilestone/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/'.Utils::encode5t($aRow->projectid).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';						
					}
					
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
						
					$row[] =$edit."&nbsp;|&nbsp;".$delete;
				}
				
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
	 public function GetMilestoneDuration($milestoneid)
	{
		$result = array(); $res=array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$totalday1=0;
			//$sql="select * from task_master where projectid =? ";
			$sql="select * from Milestone where id =? ";
			$query=$this->db->prepare($sql);
			$query->execute(array($milestoneid));
			$count = $query->rowcount();
			$days1='';$hours1='';$minutes1='';
			while($row1= $query->fetch()) {
				//$start = new DateTime($row1->fromdate);
			//	$since_start1 = $start->diff(new DateTime($row1->todate));
				$start = $row1->startdate;
				$today = $row1->enddate;
				$days1 = strtotime($today) - strtotime($start);
				$totalday1 = floor($days1/(60*60*24));
			}
			$esttotal_time =$totalday1.' days';
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		return $esttotal_time;
		
	}
	public function projectemployeeDashboard($projectid) {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
		
		//$senior = Utils::getApprovalLevelEmp($userid, 1, $this->db);
		//$senioremail=Utils::decode5t(Utils::getName($senior,'EmployeeMaster','CompanyEmail',$this->db));
		//echo "$filscalid";
		try{
			$sts=1;
			$hrsts=1;
		
			$data['chartdata1date'] = "";
			$data['chartdata1'] = array();
			$data['chartdata2'] = array();
			$data['chartdata3'] = array();
			$data['chartdata4']= array(); 
			///////////  GETTING LIST OF Project employees And Assign Task//////////////////
			$sql="select * from project_master where id=?";
			$query=$this->db->prepare($sql);
			$query->execute(array($projectid));
			$count=$query->rowcount();
			if($count>=1){
				while($row=$query->fetch()) {
				//$assigned_to['empid']=explode(',' ,$row->assigned_to);
					if($row->assigned_to!=0){
						$assign=$this->getEmpdesig($row->assigned_to);
						foreach($assign as $key=>$value){
								$res = array();
							//$assigned_to=array;
							$empid=$value['empid'];
							$res['name'] =$value['empname'];
							$res['value']=$this->getesttotaltime($projectid , $value['empid'],3);
							$data['chartdata1'][] = $res;
						}
					}
				}
			}
			/////////// Task by Status ////////////////////
			$sql1 = "select * from OtherMaster where OtherType='TaskStatus'";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($row1=$query1->fetch()){
				$res= array();
				$res['taskstatusid']= $row1->ActualValue;
				$res['name']= $row1->DisplayName;
				$sql = "select count(taskstatus) as totaltask  from task_master where  OrganizationId=? and projectid =? and taskstatus=? order by taskstatus";
				$query = $this->db->prepare($sql);
				$query->execute(array($orgid, $projectid,  $row1->ActualValue));
				if($query->rowCount()>0) {
					while($row= $query->fetch()){
					//	$data['chartdata2name'][] = strtoupper($row->project_title);
						$res['value']= $row->totaltask;
				}
			}
				$data['chartdata2'][] = $res;
			}
			///////////  Milestone by project  ////////////////////
			$sql2 = "Select * from Milestone Where OrganizationId=? and projectid=?";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($orgid, $projectid));
			if($query2->rowCount()>0)
			{
				while($row= $query2->fetch()){
					$res= array();$days="";$hours="";$minutes="";
					$res['name']=Utils::getName($row->DefaultMilestoneId,"SettingMilestone","Name",$this->db);
					$totalhour=explode(":",$row->Totalhour);
					if($row->Totalhour!=""){
					//print_r($totalhour);
						if($totalhour[0]!=""){
							$days=$totalhour[0] *24; 
						}if($totalhour[1]!=""){
							$hours=$totalhour[1]; 
						}if($totalhour[2]!=""){
							$minutes=$totalhour[2]/60; 
						}
					}
					$totaltime=$days+$hours+$minutes;
					$res['color']= '#' . substr(str_shuffle('ABCDEF0123456789'), 0, 6);
					$res['value']=$totaltime;
					$data['chartdata3'][] = $res;
					
			}
				
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }

	
}
