<?php

/**
 * RoleModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ProfileModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
	 
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    
    //////////////////
    
    public function getEvents1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$date = date("Y-m-d H:i:s");
		
        $sql = "SELECT * FROM HolidayMaster WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			$darr = array();
			$darr['cdate'] = $date;
			$data[] = $darr;
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['desc'] = $row->Description;
				$res['datefrom'] = $row->DateFrom;
				$res['dateto'] = $row->DateTo;
				$res['createddate'] = $row->CreatedDate;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=ROLE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
    public function getEvents($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$holiday=0; $leave=0; $present=0; $absent=0; $weekoff=0; $halfdays=0;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$date = isset($_POST['monthview'])?$_POST['monthview']:"";
		$date = ($date=="")?date("Y-m-01") : $date;
		$date1 = $date;
		$lastday = date("Y-m-t", strtotime($date));
		
		/* $sql = "SELECT WorkingDays FROM EmployeeMaster WHERE OrganizationId = ? AND Id = ? ";
        $query = $this->db->prepare($sql);
		$query->execute(array($orgid, $mid));
		if($query->rowCount()>=1)
		{
			$status=true;
			$weeks=array();
			while($row = $query->fetch())
			{
				$res = array();
				$temp = $row->WorkingDays;
				if($temp!=""){
					$weeks =explode(",",$temp);
				}
			}	 */	
			$status=true;
			try{
				while(date($date)<=$lastday){
				
					$flg=0;
					$dw =1 + date( "w", strtotime($date));
					/////// gettung weekly off from shift of employee
					$weekno=Utils::weekOfMonth($date);
					//$dayofdate= 1 + date("w", strtotime($leavefrom));
					$sql2 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=(select shift from EmployeeMaster where Id=$mid and Is_Delete=0) and Day=$dw";
				//echo" Date used - ".$date." day of month -  ".$dw." week of month - ".$weekno."<br>";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array());
					$week="";
					if($row2 = $query2->fetch()){
						$week=$row2->WeekOff;
					}
					$weekarr=explode(",",$week);
					if($query2->rowCount()>0){
						if($weekarr[$weekno-1]==1){
							$weekoff++;
							$res = array();
							$res['name'] = "Weekly Off";
							$res['datefrom'] = $date;
							$res['dateto'] = $date;
							$res['backcolor'] = '#f39c12';
							$res['timein'] = "";
							$res['timeout'] ="";
							$data[] = $res;
						}else if($weekarr[$weekno-1]==2){
							$weekoff = $weekoff++;
							$res = array();
							$res['name'] = "Weekly Off";
							$res['datefrom'] = $date;
							$res['dateto'] = $date;
							$res['backcolor'] = '#f39c12';
							$res['timein'] = "";
							$res['timeout'] ="";
							$data[] = $res;
						}
					}
					/////// FETCH WEEKOFF AFTER CURRENT DATE ////////////
					//if(count($weeks)==7 && date($date)>date("Y-m-d")){
				/* 	if(count($weeks)==7 ){
						if($weeks[$dw]==3){ $weekoff++; 
							$res = array();
							$res['name'] = "Weekly Off";
							$res['datefrom'] = $date;
							$res['dateto'] = $date;
							$res['backcolor'] = '#f39c12';
							$res['timein'] = "";
							$res['timeout'] ="";
							$data[] = $res;
							//continue;
						}elseif($weeks[$dw]==2){ $weekoff++; 
							$res = array();
							$res['name'] = "Weekly Off";
							$res['datefrom'] = $date;
							$res['dateto'] = $date;
							$res['backcolor'] = '#f39c12';
							$res['timein'] = "";
							$res['timeout'] ="";
							$data[] = $res;
							//continue;
						}
					} */
					//if($flg==1){$flg=0;continue;}
					//break;
					$userdesig=Utils::getName($mid , "EmployeeMaster", "Division", $this->db);
					$sql = "SELECT Id, Name, DateFrom, DateTo FROM HolidayMaster WHERE OrganizationId = ? AND  ('$date' between DateFrom and DateTo) and find_in_set($userdesig,DivisionId)  ";
					$query = $this->db->prepare($sql);
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						while($row = $query->fetch())
						{
							$res = array();
							$res['id'] = $row->Id;
							$res['name'] = $row->Name;
							$res['datefrom'] = $date;
							$res['dateto'] = $date;
							$res['status'] = 'Holiday';
							$res['backcolor'] = '#00a65a';
							$res['timein'] = "";
							$res['timeout'] ="";
							$data[] = $res;
							$holiday++;
						}
					}//else{				
						/* $sql2 = "SELECT EmployeeId, Id, LeaveReason, LeaveFrom FROM EmployeeLeave WHERE OrganizationId = ? AND LeaveStatus = ? AND EmployeeId = ? AND  '$date' between LeaveFrom AND LeaveTo AND ( FromDayType =1 OR ToDayType=1 ) ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($orgid, 2, $mid));
						if($query2->rowCount() >=1)
						{
								
								while($row2 = $query2->fetch())
								{
									$res = array();
									$res['id'] = $row2->Id;
									$res['name'] = 'Leave';
									//$res['name'] = 'Leave -'. $this->getEmployeeName($row2->EmployeeId);
									$res['datefrom'] = $date;
									$res['dateto'] = $date;
									$res['status'] = 'Leave';
									$res['backcolor'] = '#00c0ef';
									$res['timein'] = "";
									$res['timeout'] ="";
									$leave++;
									$data[] = $res;
								}
						} *///else{					
							$sql1 = "SELECT * FROM AttendanceMaster WHERE OrganizationId = ? and AttendanceStatus  in(1,2,4,6) AND  EmployeeId = ? AND  AttendanceDate = '$date'";
							
							$query1 = $this->db->prepare($sql1);
						
							$query1->execute(array($orgid, $mid));
							if($query1->rowCount() >=1)
							{		
								while($row1 = $query1->fetch())
								{
									$res = array();
									$res['id'] = $row1->Id;
									$res['name'] = 'Present';
									$res['datefrom'] = $row1->AttendanceDate;
									$res['dateto'] = $row1->AttendanceDate;
									$res['timein'] = $row1->TimeIn;
									$res['timeout'] = $row1->TimeOut;
									$attend= "Present";
									$backcolor='#3c8dbc';
									
									if($row1->AttendanceStatus==2){
										$attend= "Absent";$absent++;
										$backcolor='#dd4b39';
									}elseif($row1->AttendanceStatus==1){
										$attend= "Present";
										$backcolor='#3c8dbc';
										$present++;
									}elseif($row1->AttendanceStatus==3){
										$weekoff++; 
										$attend= "Weekly Off";
										$backcolor='#f39c12';
									}
									elseif($row1->AttendanceStatus==4){
										$halfdays++; 
										$attend= "Half Day";
										$backcolor='gray';
									}elseif($row1->AttendanceStatus==6){
										$leave++; 
										$attend= "Leave";
										$backcolor='#00c0ef';
									}
									$res['name'] = $attend;
									$res['backcolor'] = $backcolor;				
									$data[] = $res;
								}
								
							}
						//}
					//}	
				$date = date("Y-m-d", strtotime("$date, +1 day"));
				}     
				
			}	
			catch(Exception $e)
			{
				
			}			
        /* }else{
			$status=false;
			$errorMsg= EMPLOYEE_MODULE_GETALL;
		} */
		
		$result['holidaycount']=$holiday;
		$result['leavecount']=$leave;
		$result['presentcount']=$present;
		$result['absentcount']=$absent;
		$result['weekoffcount']=$weekoff;
		$result['halfdaycount']=$halfdays;
		$result['totaldays']=date('t', strtotime($date1));
		//$result['summary']=" Month Summary";
		$result["data"] =$data;
		$result['status']=$status;
		
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    ///////////////change password////////////
	public function changepwd($request)
    {         
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		$sql = "UPDATE UserMaster SET  Password=? where EmployeeId=? and Password=?";	
               $query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$oldpwd = Utils::encode5t($request[2]);
			$newpwd = Utils::encode5t($request[3]);
			
			$query->execute(array( $newpwd, $mid, $oldpwd ));			
			$count =  $query->rowCount();
			
		
		
			if ($count == 1) {
				$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
				$msg="$empname has changed the password";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Profiles", $msg, $orgid));
				
			   $status =true;
			   $successMsg = PASSWORD_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = PASSWORD_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
                              
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	///////////////////////////////profile//////////////
	public function ProfileUpdate($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$mid   = $request[0];	
		$arr = array();
		
		$arr[0] = $_POST['emp_fname'];
		$arr[1] = $_POST['emp_lname'];
		$arr[2] = $_POST['emp_nationality'];
		$arr[3] = $_POST['emp_marital'];
		$arr[4] = $_POST['emp_religion'];
		//$arr[5] = is_array($_POST['emp_known_lang']) ? implode(',',$_POST['emp_known_lang']): $_POST['emp_known_lang'];
		$arr[5] = $_POST['emp_visa_type'];
		$arr[6] = Utils::encode5t($_POST['emp_contact1']);
		$arr[7] = Utils::encode5t($_POST['emp_email1']);
		$arr[8] = Utils::encode5t($_POST['emp_address1']);
		$arr[9] = $_POST['emp_country1'];
		$arr[10] = $_POST['emp_city1'];
		$arr[11] = $_POST['emp_zipcode1'];
		$arr[12] = Utils::encode5t($_POST['emp_contact2']);
		$arr[13] = Utils::encode5t($_POST['emp_email2']);
		$arr[14] = Utils::encode5t($_POST['emp_address2']);
		$arr[15] = $_POST['emp_country2'];
		$arr[16] = $_POST['emp_city2'];
		$arr[17] = $_POST['emp_zipcode2'];
		$arr[18] = Utils::encode5t($_POST['emp_contact3']);
		$arr[19] = Utils::encode5t($_POST['emp_email3']);
		$arr[20] = Utils::encode5t($_POST['emp_address3']);
		$arr[21] = $_POST['emp_country3'];
		$arr[22] = $_POST['emp_city3'];
		$arr[23] = $_POST['emp_zipcode3'];
		$arr[24] = $_POST['emp_blood_group'];
		$arr[25] = $_POST['emp_gender'];
		$arr[26] = Utils::getDateformat($_POST['emp_dob']);
		$arr[27] = $_POST['bankname'];
		$arr[28] = $_POST['bankifsccode'];
		$arr[29] = $_POST['bankaddress'];
		$arr[30]=$mdate;
		$arr[31]=$mid;		
		//$arr[33] = $_POST['emp_exp'];
		$arr[32] = $_POST['emp_mname'];
		$arr[33] = $_POST['emp_id'];
		//$arr[34] = $_POST['emp_mname'];
		//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid =0;
		$empid=$request[0];
		$this->db->beginTransaction();
		try	
		{
			$sql = "UPDATE EmployeeMaster SET FirstName=?, LastName=?,  Nationality=?, MaritalStatus=?, Religion=?, Visa=?,  CurrentContactNumber=?, CurrentEmailId=?, CurrentAddress=?, CurrentCountry=?, CurrentCity=?, CurrentZipCode=?, HomeContactNumber=?, HomeEmailId=?, HomeAddress=?, HomeCountry=?, HomeCity=?, HomeZipCode=?, EmergencyContactNumber=?, EmergencyEmailId=?, EmergencyAddress=?, EmergencyCountry=?, EmergencyCity=?, EmergencyZipCode=?, BloodGroup=?, Gender=?, DOB=?, BankName=?, BankIFSCCode=?,  BankAddress=?,LastModifiedDate=?, LastModifiedById=?, MiddleName=?   where Id=?";
			
			$query = $this->db->prepare($sql);
			$query->execute($arr);
			
			// INSERTING AND UPDATING WORK EXPERIENCE RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_workarray'], true); 
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeWorkExperience WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$fdate=$record[3] =  Utils::getDateformat($work[$i]['fdate']);
					$tdate=$record[4] =  Utils::getDateformat($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mid;
					$record[8] = $mdate;
					$record[9] = $mid;
					$record[10] = $mid;
					$record[11] = $orgid;
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeWorkExperience SET CompanyName=?, Designation=?, FromDate=?, ToDate=?, Description=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'],$work[$i]['desig'],$fdate,$tdate,$work[$i]['desc'],$mdate,$mid,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeWorkExperience (EmployeeId, CompanyName, Designation, FromDate, ToDate, Description, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values (?,?,?,?,?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			} 
			// INSERTING AND UPDATING QUALIFICATION RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_qualificationarray'], true);
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeQualification WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
	
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$record[3] = $work[$i]['fdate'];
					$fdate=$record[4] =  Utils::getDateformat($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mid;
					$record[8] = $mdate;
					$record[9] = $mid;
					$record[10] = $mid;
					$record[11] = $orgid;
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeQualification SET InstituteName=?, Degree=?, FOS=?, DOC=?, GPA=?, LastModifiedDate=?, LastModifiedById=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'],$work[$i]['desig'],$work[$i]['fdate'],$fdate,$work[$i]['desc'],$mdate,$mid,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeQualification (EmployeeId, InstituteName, Degree, FOS, DOC, GPA, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values (?,?,?,?,?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			// INSERTING AND UPDATING DOCUMENT RECORD OF EMPLOYEE IF PASSED AS AN JSON
		/* 	$work = json_decode($_POST['emp_documentarray'], true);
			$workid="0";
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
				$docsts=isset($work[$i]['originaldoc'])?$work[$i]['originaldoc']:0;
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = Utils::encode5t($work[$i]['desig']);
					$fdate=$record[3] =  Utils::getDateformat($work[$i]['fdate']);
					$tdate=$record[4] =  Utils::getDateformat($work[$i]['tdate']);
					//$record[5] = $work[$i]['desc'];
					$record[5] = $mdate;
					$record[6] = $mid;
					$record[7] = $mdate;
					$record[8] = $mid;
					$record[9] = $mid;
					$record[10] = $orgid;
					$record[11] = $docsts;
					
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeDocument SET DocumentTypeId=?, DocumentNumber=?, IssuedOn=?, ExpiredOn=?, LastModifiedDate=?, LastModifiedById=?, OriginalDocSts=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'], Utils::encode5t($work[$i]['desig']), $fdate,$tdate, $mdate, $mid,$docsts,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeDocument (EmployeeId, DocumentTypeId, DocumentNumber, IssuedOn, ExpiredOn, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId,OriginalDocSts) values (?,?,?,?,?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			} */
			
			// INSERTING AND UPDATING DEPENDANT RECORD OF EMPLOYEE IF PASSED AS AN JSON
		/* 	$dependant = json_decode($_POST['emp_dependant'], true); 
			$depenid="0";
			
			for($i=0; $i<count($dependant); $i++)
			{
				if($dependant[$i]['relate']!="" && $dependant[$i]['fname']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $dependant[$i]['relate'];
					$record[2] = $dependant[$i]['fname'];
					$record[3] = $dependant[$i]['lname'];
					//$fdate=$record[4] =  Utils::getDateformat($dependant[$i]['bdate']);
					$record[4] = $dependant[$i]['nominee'];
					$record[5] = Utils::encode5t($dependant[$i]['contact']);
					
					
					$id = $dependant[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeDependant SET EmployeeRelationId=?, FirstName=?, LastName=?, NomineePercent=?,Contact=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($dependant[$i]['relate'], $dependant[$i]['fname'], $dependant[$i]['lname'], $dependant[$i]['nominee'],Utils::encode5t($dependant[$i]['contact']),  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeDependant (EmployeeId, EmployeeRelationId, FirstName, LastName,  NomineePercent,Contact) values (?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			} */
			
			// INSERTING SKILLS OF EMPLOYEE IF PASSED AS AN JSON
			$skill = json_decode($_POST['emp_skill'], true); 
			$skillid="0";
			for($i=0; $i<count($skill); $i++){
				$skillid .= ",".$skill[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeSkills WHERE EmployeeId=? AND Id NOT IN ($skillid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($skill); $i++)
			{
				if($skill[$i]['skill']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $skill[$i]['skill'];
					$record[2] = $skill[$i]['desc'];
					
					$id = $skill[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeSkills SET EmployeeId=?, SkillsId=?, Description=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$skill[$i]['skill'], $skill[$i]['desc'],  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeSkills (EmployeeId, SkillsId,Description) values (?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
					
				}
			} 
			
					//INSERTING CREDIT CARD DETAILS OF EMPLOYEE 
					$creditcard = json_decode($_POST['emp_creditcard'], true);
					$creditcardid="0";
					for($i=0; $i<count($creditcard); $i++){
						$creditcardid .= ",".$creditcard[$i]['id'];
					}
					$sqlwork = " DELETE FROM EmployeeCreditCard WHERE EmployeeId=? AND Id NOT IN ($creditcardid)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute(array( $empid));
					 
					for($i=0; $i<count($creditcard); $i++)
					{
						if($creditcard[$i]['creditcardid']!="" && $creditcard[$i]['bankid']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $creditcard[$i]['creditcardid'];
							$record[2] = $creditcard[$i]['bankid'];
							$record[3] = Utils::encode5t($creditcard[$i]['creditcard_no']);
							$fdate=$record[4] =  Utils::getDateformat($creditcard[$i]['credit_issuedate']);
							$tdate=$record[5] =  Utils::getDateformat($creditcard[$i]['credit_validdate']);
							$record[6] = $creditcard[$i]['credit_limit'];
							
							$id = $creditcard[$i]['id'];
							if($id){
								$sqlwork = " UPDATE EmployeeCreditCard SET EmployeeId=?, CreditCardId=?,  BankId=?,CreditCardNo=?, IssueDate=?, ValidTill=?, CreditCardLimit=?  WHERE Id=?";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute(array($empid,$creditcard[$i]['creditcardid'],$creditcard[$i]['bankid'], Utils::encode5t($creditcard[$i]['creditcard_no']),$fdate,$tdate,$creditcard[$i]['credit_limit'],  $id));
							}else{
								$sqlwork = " INSERT INTO EmployeeCreditCard (EmployeeId, CreditCardId, BankId,CreditCardNo, IssueDate, ValidTill, CreditCardLimit) values (?,?,?,?,?,?,?)";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute($record);
							}
							
						}
					}
					
					//INSERTING INSURANCE DETAILS OF EMPLOYEE 
					
				/* 	$insurance = json_decode($_POST['emp_insurance'], true); 
					
					$insuranceid="0";
					
					for($i=0; $i<count($insurance); $i++)
					{
						if($insurance[$i]['insuranceid']!="" ){
							$record = array();
							$record[0] = $empid;
							$record[1] = $insurance[$i]['insuranceid'];
							$record[2] = $insurance[$i]['insurance_period'];
							$record[3] = $insurance[$i]['insured_amt'];
							$record[4] = $insurance[$i]['premium_amt'];
							$fdate=$record[5] = Utils::getDateformat($insurance[$i]['insurance_validdate']);
							$record[6] = $insurance[$i]['insurance_nominee'];
							$id = $insurance[$i]['id'];
							if($id){
								$sqlwork = " UPDATE EmployeeInsuranceDetails SET EmployeeId=?, InsuranceId=?,InsurancePeriod=?,InsuredAmount=?, PremiumAmount=?, ValidTill=?,  NomineeDetails=? WHERE Id=?";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute(array($empid,$insurance[$i]['insuranceid'],$insurance[$i]['insurance_period'], $insurance[$i]['insured_amt'],$insurance[$i]['premium_amt'],$fdate, $insurance[$i]['insurance_nominee'],  $id));
							}else{
								$sqlwork = " INSERT INTO EmployeeInsuranceDetails ( EmployeeId, InsuranceId, InsurancePeriod,  InsuredAmount, PremiumAmount,  ValidTill, NomineeDetails) values (?,?,?,?,?,?,?)";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute($record);
							}
							
							
						}
					} */
					
					//INSERTING BANK DETAILS OF EMPLOYEE 
					
					$bank = json_decode($_POST['emp_bank'], true); 
					
					$bankid="0";
					
					for($i=0; $i<count($bank); $i++)
					{
						if($bank[$i]['bankid']!="" && $bank[$i]['iban_no']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $bank[$i]['bankid'];
							$record[2] = $bank[$i]['iban_no'];
							$record[3] = $bank[$i]['swiftcode'];
							$record[4] = $bank[$i]['branch'];
							$record[5] = $bank[$i]['status'];
							$id = $bank[$i]['id'];
							if($id){
								$sqlbank = " UPDATE EmployeeBankDetails SET EmployeeId=?, BankId=?, IBAN=?, SwiftCode=?, Branch=?,BankStatus=? WHERE Id=?";
								$querybank = $this->db->prepare($sqlbank);
								$querybank->execute(array($empid, $bank[$i]['bankid'], $record[2], $record[3], $record[4] ,$bank[$i]['status'], $id));
							}else{
								$sqlbank = " INSERT INTO EmployeeBankDetails ( EmployeeId, BankId, IBAN,  SwiftCode, Branch,BankStatus) values (?,?,?,?,?,?)";
								$querybank = $this->db->prepare($sqlbank);
								$querybank->execute($record);
							}
							
							
						}
					}
					
					//INSERTING BANKLOAN DETAILS OF EMPLOYEE 
					
					$bankloan = json_decode($_POST['emp_bankloan'], true); 
					
					$bankloanid="0";
					
					for($i=0; $i<count($bankloan); $i++)
					{
						if($bankloan[$i]['bankid']!="" && $bankloan[$i]['loan_amt']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $bankloan[$i]['bankid'];
							$record[2] = $bankloan[$i]['loan_amt'];
							$record[3] = $bankloan[$i]['tenure'];
							$record[4] = $bankloan[$i]['emi'];
							$id = $bankloan[$i]['id'];
							if($id){
								$sqlbankloan = " UPDATE EmployeeBankLoan SET EmployeeId=?, BankId=?, LoanAmount=?, Tenure=?, EMI=? WHERE Id=?";
								$querybankloan = $this->db->prepare($sqlbankloan);
								$querybankloan->execute(array($empid, $bankloan[$i]['bankid'], $record[2], $record[3], $record[4] , $id));
							}else{
								$sqlbankloan = " INSERT INTO EmployeeBankLoan ( EmployeeId, BankId, LoanAmount,  Tenure, EMI) values (?,?,?,?,?)";
								$querybankloan = $this->db->prepare($sqlbankloan);
								$querybankloan->execute($record);
							}
							
							
						}
					}
					
			
			
			$count =  $query->rowCount();		
			
			
			if ($count == 1) {
				
				$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Profile of $empname has been Updated  ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Profile", $msg, $orgid));
			
			   $status =true;
			   $successMsg = EMPLOYEE_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = EMPLOYEE_MODULE_UPDATION_FAILED;
			}
		  $this->db->commit();     
		}catch(PDOException $e)
		{
			$pdo->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}catch(Exception $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}  
		
        
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	////////////////////////function for getting employee data for profile//////////////////
	public function getempDetail($eid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
        $sql = "SELECT *, TIMESTAMPDIFF(YEAR, DOJ, CURDATE()) as curyear, TIMESTAMPDIFF(MONTH, DOJ, CURDATE()) as curmonth FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $eid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['emppic']="";
				$res['id'] = $row->Id;
				$empcode=$res['empcode'] = $row->EmployeeCode;
				$res['empfname'] = $row->FirstName;
				$res['emplname'] = $row->LastName;
				$res['empmname'] =$row->MiddleName;
				$res['empnation'] = $row->Nationality;
				$res['empnationforview'] = Utils::getName($row->Nationality,'NationalityMaster','Name',$this->db);
				$res['empgender'] = $row->Gender;
				$res['empmarists'] = $row->MaritalStatus;
				$res['empreligion'] = $row->Religion;
				$res['empreligionforview'] = Utils::getName($row->Religion,'ReligionMaster','Name',$this->db);
				$res['empbloodgroup'] = $row->BloodGroup;
				$res['empbloodgroupforview'] = Utils::getName($row->BloodGroup,'BloodGroupMaster','Name',$this->db);
				$res['emplang'] = $row->KnownLanguage;
				$res['empvisa'] = $row->Visa;
				$res['empvisacat'] = $row->VisaCategory;
				$res['empvisaforview'] = Utils::getName($row->Visa,'VisaMaster','Name',$this->db);
				$res['empcnumber'] = (int)Utils::decode5t($row->CurrentContactNumber);
				$res['empcemail'] = Utils::decode5t($row->CurrentEmailId);
				$res['empcaddres'] = Utils::decode5t($row->CurrentAddress);
				$res['empccountry'] = $row->CurrentCountry;
				$res['empccountryforview'] = Utils::getName($row->CurrentCountry,'CountryMaster','Name',$this->db);
				$res['empccity'] = $row->CurrentCity;
				$res['empczip'] = $row->CurrentZipCode;
				$res['emphnumber'] = (int)Utils::decode5t($row->HomeContactNumber);
				$res['emphemail'] = Utils::decode5t($row->HomeEmailId);
				$res['emphaddres'] = Utils::decode5t($row->HomeAddress);
				$res['emphcountry'] = $row->HomeCountry;
				$res['emphcountryforview'] = Utils::getName($row->HomeCountry,'CountryMaster','Name',$this->db);
				$res['emphcity'] = $row->HomeCity;
				$res['emphzip'] = $row->HomeZipCode;
				$res['empenumber'] = (int)Utils::decode5t($row->EmergencyContactNumber);
				$res['empeemail'] = Utils::decode5t($row->EmergencyEmailId);
				$res['empeaddress'] = Utils::decode5t($row->EmergencyAddress);
				$res['empecountry'] = $row->EmergencyCountry;
				$res['empecountryforview'] = Utils::getName($row->EmergencyCountry,'CountryMaster','Name',$this->db);
				$res['empecity'] = $row->EmergencyCity;
				$res['empezip'] = $row->EmergencyZipCode;
				$res['empreport'] = $this->getEmployeeName($row->ReportingTo,'EmployeeMaster');
				$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
				$res['empcurency'] = Utils::getDivisioncurrency($row->Division,$this->db);
				$res['empdept'] = $this->getName($row->Department,'DepartmentMaster');
				$res['empdesig'] = $this->getName($row->Designation,'DesignationMaster');
				$res['empchannel'] = $this->getName($row->Channel,'ChannelMaster');
				$res['empshift'] =$this->getName( $row->Shift,'ShiftMaster');
				$res['empgrade'] = Utils::getName($row->Grade,'GradeMaster','Code',$this->db);
				$grade=$row->Grade;
				$res['emplocation'] =$this->getName($row->Location,'LocationMaster');
				$res['empsts'] = $this->getOther($row->EmployeeStatus,'EmployeeStatus');
				$res['emptype'] = $this->getName($row->EmploymentType,'EmploymentTypeMaster');
				$days = $row->WorkingDays;
				$res['empcreateby'] = $row->CreatedById;
				$res['empmodifiedby'] = $row->LastModifiedById;
				$res['empownerid'] = $row->OwnerId;
				$res['empcdate'] = $row->CreatedDate;
				$res['empmdate'] = $row->LastModifiedDate;
				$res['empfuncarea'] = $row->FunctionalArea;
				$res['salaryctc'] = $row->EmployeeCTC;
				$res['empepaypattern'] = $row->PayPattern;
				$res['overtimepay'] = $row->OvertimePayment;
				$res['empebankname'] = $row->BankName;
				$res['empebankcode'] = Utils::decode5t($row->BankIFSCCode);
				$res['salarytype'] = Utils::getName($row->BankAccount,'SalaryTypeMaster','Name',$this->db);
				$res['empebankaddress'] = Utils::decode5t($row->BankAddress);
				$res['uidno'] = $row->UID_No;
				$res['fileno'] = $row->File_No;
				
				$res['cmpemail'] = Utils::decode5t($row->CompanyEmail);
				//$res['immigration'] = $row->ImmigrationCost;
				$res['airticket'] = $row->AirTicket;
				//$res['visa'] = $row->VisaType;
				//$res['visacost'] = $row->VisaCost;
				$res['ticketclass'] = $row->TicketClass;
				$res['oncein'] = $row->OnceIn;
				$res['ticketamt'] = $row->LastTicketAmt;
				$res['iatafare'] = $row->IATAFare;
				$res['instructions'] = $row->TravelInstruction;
				$res['nearestairport'] = $row->NearestAirport;
				$res['familydetails'] = $row->FamilyDetail;
				$res['provision'] = $row->ProvisionPeriod;
				$res['personal_no'] = Utils::decode5t($row->UniqueId);
				$res['curyear'] = ((int)$row->curyear < 0)?0:(int)$row->curyear;
				$res['curmonth'] = ((int)$row->curmonth < 0)?0:(int)$row->curmonth;
				$year=($res['curyear'] * 12);
				$res['curmonth']=$res['curmonth'] - $year;
				if($row->TotalExp!=""){
					$exp = explode(',',$row->TotalExp);
					$y=$exp[0] + $res['curyear'];
					$m=$exp[1] + $res['curmonth'];
					$res['totalexp'] = $y.','.$m;
				}
				else{
					$res['totalexp'] = $res['curyear'].','.$res['curmonth'];
				}
				$res['empexp'] = $row->TotalExp;
				if($row->DOB =="0000-00-00" ){
					$res['empdob']="";
				}else{
						$res['empdob'] = Utils::dateformatter($row->DOB);
					}
				if($row->DOJ=="0000-00-00" ){
					$res['empdoj']="";
				}else{
						$res['empdoj'] = Utils::dateformatter($row->DOJ);
					}
				if($row->DOC=="0000-00-00" ){
					$res['empdoc']="";
				}else{
						$res['empdoc']= Utils::dateformatter($row->DOC);
					}
				if($row->DOL=="0000-00-00" ){
					$res['empdol']="";
				}else{
						$res['empdol'] = Utils::dateformatter($row->DOL);
					}
				$image=$row->ImageName;
				if (file_exists( "public/uploads/$orgid/$image")) {
					
					$res['emppic']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
					
					
				}
				if($image == ""){
					if($res['empgender']== 1)
					{
						$res['emppic']= URL."public/avatars/male.png";
					}
					else{
						$res['emppic']= URL."public/avatars/female.png";
					}
				}
				
				$res['annualleave'] = Utils::getannualleaves($row->Id,$this->db);
	////////////////  FETCHING ANNUAL LEAVE FOR EMPLOYEE  //////////////	
	
				/*$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $workingdays=0;
				$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false;
		
				$division=$row->Division;
				$department=$row->Department; 
				$designation=$row->Designation; 
				$grade=$row->Grade; 
				$gender=$row->Gender; 
				$marital=$row->MaritalStatus;
				$workingdays=substr_count($row->WorkingDays, '1');
				
				$sqlleave = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and WorkingDays =$workingdays and AnnualLeaveSts=1";
				$queryleave = $this->db->prepare($sqlleave);
				$queryleave->execute(array($orgid));
					$count1 =  $queryleave->rowCount();
				if($count1>=1)
				{
					while($rowleave = $queryleave->fetch())
					{
						$divisionflg=true;
						$departmentflg=true; 
						$designationflg=true; 
						$gradeflg=true; 
						$genderflg=true; $maritalflg=true;
						
						$employeeusedleave=0;
						
						if($rowleave->LeaveUsableSts==1){
							if($rowleave->DivisionId>0){
								if($rowleave->DivisionId==$division){
									$divisionflg=true;
								}else{$divisionflg=false;}
							}
							if($rowleave->DepartmentIds>0){
								if($rowleave->DepartmentIds==$department){
									$departmentflg=true; 
								}else{$departmentflg=false; }
							}
							if($rowleave->DesignationIds>0){
								if($rowleave->DesignationIds==$designation){
									$designationflg=true; 
								}else{$designationflg=false; }
							}
							if($rowleave->GenderId>0){
								if($rowleave->GenderId==$gender){
									$genderflg=true;
								}else{$genderflg=false;}
							}
							if($rowleave->MaritalId>0){
								if($rowleave->MaritalId==$marital){
									$maritalflg=true;
								}else{$maritalflg=false;}
							}
							if($rowleave->GradeId>0){
								if($rowleave->GradeId==$grade){
									$gradeflg=true; 
								}else{$gradeflg=false; }
							}
						}elseif($rowleave->LeaveUsableSts==2){
							$divisionflg=false;
							$departmentflg=false; 
							$designationflg=false; 
							$gradeflg=false; 
							$genderflg=false; $maritalflg=false;
							
							if($rowleave->EmployeeIds!="")
							{
								$temp = explode(",", $rowleave->EmployeeIds);
								for($i=0; $i<count($temp); $i++)
								{
									if($mid==$temp[$i]){
										$divisionflg=true;
										$departmentflg=true; 
										$designationflg=true; 
										$gradeflg=true; 
										$genderflg=true; $maritalflg=true;
										break;
									}
									
								}
							}
							
						}
						
						if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg)
						{							
							$res['annualleave'] = (int)$rowleave->LeaveDays;
						}
					}
				}*/
				
				$city = array();
				$work = array();
				$qual = array();
				$doc  = array();
				$depen  = array();
				$skill = array();
				$creditcard = array();
				$insurance = array();
				$bank = array();
				$bankloan = array();
				$workfullday = array();
				$workhalfday = array();
				$ltadetails = array();
				$sqlwork = "SELECT * FROM EmployeeWorkExperience WHERE EmployeeId = :id";
				$querywork = $this->db->prepare($sqlwork);
				$querywork->execute(array(':id' => $eid ));
				while($rowwork = $querywork->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowwork->Id;
					$res1['name'] = $rowwork->CompanyName;
					$res1['desig'] = $rowwork->Designation;
					$res1['desc'] = $rowwork->Description;
					
					if($rowwork->FromDate =="0000-00-00" ){
					$res1['fdate'] ="";
					}else{
						$res1['fdate'] = Utils::dateformatter($rowwork->FromDate);
					}
					if($rowwork->ToDate =="0000-00-00" ){
					$res1['tdate'] ="";
					}else{
						$res1['tdate'] = Utils::dateformatter($rowwork->ToDate);
					}
					$work[] = $res1;
				}
				
				$sqlqual = "SELECT * FROM EmployeeQualification WHERE EmployeeId = :id";
				$queryqual = $this->db->prepare($sqlqual);
				$queryqual->execute(array(':id' => $eid ));
				while($rowqual = $queryqual->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowqual->Id;
					$res1['name'] = $rowqual->InstituteName;
					$res1['desig'] = $rowqual->Degree;
					$res1['fdate'] = $rowqual->FOS;					
					$res1['desc'] = $rowqual->GPA;					
					if($rowqual->DOC =="0000-00-00" ){
						$res1['tdate'] ="";
					}else{
						$res1['tdate'] = Utils::dateformatter($rowqual->DOC);
					}
					$filename=$rowqual->FileName;
					if($filename!="")
						$res1['empdoc']=URL."public/uploads/$orgid/$empcode/qualificationdocuments/$filename";
					$qual[] = $res1;
				}
				
				$sqldoc = "SELECT * FROM EmployeeDocument WHERE EmployeeId = :id";
				$querydoc = $this->db->prepare($sqldoc);
				$querydoc->execute(array(':id' => $eid ));
				while($rowdoc = $querydoc->fetch())
				{
					$res1 = array();
					$docid=$res1['id'] = $rowdoc->Id;
					$res1['name'] = $rowdoc->DocumentTypeId;
					$res1['desig'] = Utils::decode5t($rowdoc->DocumentNumber);					
					$res1['empdoc'] = "";
					$res1['originaldoc'] = (int)$rowdoc->OriginalDocSts;
					if($rowdoc->IssuedOn =="0000-00-00" ){
						$res1['fdate'] ="";
					}else{
						$res1['fdate'] = Utils::dateformatter($rowdoc->IssuedOn);
					}
					
					if($rowdoc->ExpiredOn =="0000-00-00" ){
						$res1['tdate'] ="";
					}else{
						$res1['tdate'] = Utils::dateformatter($rowdoc->ExpiredOn);
					}
					$code= $this->getCode($rowdoc->EmployeeId);
					$doc1="$code".'_'."$docid";
					$dir="public/uploads/$orgid/$code";
					$filename="";
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext = pathinfo($filename, PATHINFO_EXTENSION);
								if($filename=="$doc1.$ext")
								{
									$res1['empdoc']=URL."public/uploads/$orgid/$code/$filename";
								}
							}
							closedir($dh);
						}
					}
					
					$doc[] = $res1;
				}
				
				$sqldoc = "SELECT * FROM EmployeeDependant WHERE EmployeeId = :id";
				$querydoc = $this->db->prepare($sqldoc);
				$querydoc->execute(array(':id' => $eid ));
				while($rowdoc = $querydoc->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowdoc->Id;
					$res1['relate'] = $rowdoc->EmployeeRelationId;
					$res1['fname'] = $rowdoc->FirstName;
					$res1['lname'] = $rowdoc->LastName;
					//$res1['gender'] = $rowdoc->Gender;
					$res1['nominee'] = (float)$rowdoc->NomineePercent;
					//$res1['bdate'] = Utils::dateformatter($rowdoc->DOB);
					$res1['contact'] = (int)Utils::decode5t($rowdoc->Contact);
					
					$depen[] = $res1;
				}
				
				if($days!= null )
				{
				
					$day=explode(',' ,"$days");
					for($i=0;$i<=6;$i++)
					{
						$res1 = array();
						$res2 = array();
						if($day[$i] =='3')
						{
							$res1="";
						}
						elseif($day[$i] =='1')
						{	if($i==0)
							{
							$res1=" Sunday ";
							}
							if($i==1)
							{
							$res1=" Monday ";
							}
							if($i==2)
							{
							$res1=" Tuesday ";
							}
							if($i==3)
							{
							$res1=" Wednesday ";
							}
							if($i==4)
							{
							$res1=" Thursday ";
							}
							if($i==5)
							{
							$res1=" Friday ";
							}
							if($i==6)
							{
							$res1=" Saturday ";
							}
							$workfullday[] = $res1;
						}	
						elseif($day[$i] =='2')
						{	if($i==0)
							{
							$res2=" Sunday ";
							}
							if($i==1)
							{
							$res2=" Monday ";
							}
							if($i==2)
							{
							$res2=" Tuesday ";
							}
							if($i==3)
							{
							$res1=" Wednesday ";
							}
							if($i==4)
							{
							$res2=" Thursday ";
							}
							if($i==5)
							{
							$res2=" Friday ";
							}
							if($i==6)
							{
							$res2=" Saturday ";
							}
							$workhalfday[] = $res2;
						}	
						
					}
				}
				
				
				
				$sqlskill = "SELECT * FROM EmployeeSkills WHERE EmployeeId = :id";
				$queryskill = $this->db->prepare($sqlskill);
				$queryskill->execute(array(':id' => $eid ));
				while($rowskill = $queryskill->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowskill->Id;
					(int)$res1['skill'] = $rowskill->SkillsId;
					$res1['desc'] = $rowskill->Description;
					
					$skill[] = $res1;
				}
				
				$sqlcreditcard = "SELECT * FROM EmployeeCreditCard WHERE EmployeeId = :id";
				$querycreditcard = $this->db->prepare($sqlcreditcard);
				$querycreditcard->execute(array(':id' => $eid ));
				while($rowcreditcard = $querycreditcard->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowcreditcard->Id;
					$res1['creditcardid'] = $rowcreditcard->CreditCardId;
					$res1['bankid'] = $rowcreditcard->BankId;
					$res1['creditcard_no'] = Utils::decode5t($rowcreditcard->CreditCardNo);
					
					$res1['credit_limit'] = $rowcreditcard->CreditCardLimit;
					if($rowcreditcard->IssueDate =="0000-00-00" ){
						$res1['credit_issuedate'] ="";
					}else{
						$res1['credit_issuedate'] = Utils::dateformatter($rowcreditcard->IssueDate);
					}
					if($rowcreditcard->ValidTill =="0000-00-00" ){
						$res1['credit_validdate'] ="";
					}else{
						$res1['credit_validdate'] = Utils::dateformatter($rowcreditcard->ValidTill);
					}
					
					$creditcard[] = $res1;
				}
				
				$sqlinsurance = "SELECT * FROM EmployeeInsuranceDetails WHERE EmployeeId = :id";
				$queryinsurance = $this->db->prepare($sqlinsurance);
				$queryinsurance->execute(array(':id' => $eid ));
				while($rowinsurance = $queryinsurance->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowinsurance->Id;
					$res1['insuranceid'] = $rowinsurance->InsuranceId;
					$res1['insurance_period'] = $rowinsurance->InsurancePeriod;
					$res1['insured_amt'] = $rowinsurance->InsuredAmount;
					$res1['premium_amt'] = $rowinsurance->PremiumAmount;
					
					$res1['insurance_nominee'] = $rowinsurance->NomineeDetails;
					
					if($rowinsurance->ValidTill =="0000-00-00" ){
						$res1['insurance_validdate'] ="";
					}else{
						$res1['insurance_validdate'] = Utils::dateformatter($rowinsurance->ValidTill);
					}
					$insurance[] = $res1;
				}
				$sqlgr = "SELECT * FROM GradeMaster WHERE Id = ? ";
				$querygr = $this->db->prepare($sqlgr);
				$querygr->execute(array($grade));
				while($row1 = $querygr->fetch())
				{
					$res['gradebenefits'] =$row1->Description;
				}
				
				$sqlbank= "SELECT * FROM EmployeeBankDetails WHERE EmployeeId = :id";
				$querybank= $this->db->prepare($sqlbank);
				$querybank->execute(array(':id' => $eid ));
				while($rowbank= $querybank->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowbank->Id;
					$res1['bankid'] = $rowbank->BankId;
					$res1['iban_no'] = Utils::decode5t($rowbank->IBAN);
					$res1['swiftcode'] = Utils::decode5t($rowbank->SwiftCode);
					$res1['branch'] = Utils::decode5t($rowbank->Branch);
					$res1['status'] = $rowbank->BankStatus;
					
					$bank[] = $res1;
				}
				
				$sqlbankloan= "SELECT * FROM EmployeeBankLoan WHERE EmployeeId = :id";
				$querybankloan= $this->db->prepare($sqlbankloan);
				$querybankloan->execute(array(':id' => $eid ));
				while($rowbankloan= $querybankloan->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowbankloan->Id;
					$res1['bankid'] = $rowbankloan->BankId;
					$res1['loan_amt'] = Utils::decode5t($rowbankloan->LoanAmount);
					$res1['tenure'] = Utils::decode5t($rowbankloan->Tenure);
					$res1['emi'] = Utils::decode5t($rowbankloan->EMI);
					
					
					
					$bankloan[] = $res1;
				}
				$sqllta= "SELECT * FROM EmployeeLTADetail WHERE EmployeeId = :id";
				$querylta= $this->db->prepare($sqllta);
				$querylta->execute(array(':id' => $eid ));
				while($rowlta= $querylta->fetch())
				{
					$code= $this->getCode($rowlta->EmployeeId);
					$res1 = array();
					$res1['id'] = $rowlta->Id;
					$res1['fname'] = $rowlta->Name;
					$res1['bdate'] = Utils::dateformatter($rowlta->DOB);
					$res1['passportno'] = Utils::decode5t($rowlta->PassportNo);
					$res1['emiratesid'] = Utils::decode5t($rowlta->EmiratesId);
					$res1['relate'] = $rowlta->Relation;
					$pa=$rowlta->PassportAttachment;
					if($pa!=""){
						$res1['passportcopy'] = URL."public/uploads/$orgid/$code/$pa";
					}
					$va=$rowlta->VisaAttachment;
					if($va!=""){
						$res1['visacopy'] = URL."public/uploads/$orgid/$code/$va";
					}
					
					$ltadetails[] = $res1;
				}
				$sqlgr = "SELECT Description FROM DesignationMaster WHERE Id = ? ";
				$querygr = $this->db->prepare($sqlgr);
				$querygr->execute(array($row->Designation));
				while($row1 = $querygr->fetch())
				{
					$res['jobdesc'] =$row1->Description;
				}
				
				$res['empwork'] = $work;
				$res['empqual'] = $qual;
				$res['empdocarray'] = $doc;
				$res['empdepenarray'] = $depen;
				$res['empskills'] = $skill;
				$res['empcreditcard'] = $creditcard;
				$res['empinsurance'] = $insurance;
				$res['empworkhalfday'] = $workhalfday;
				$res['empworkfullday'] = $workfullday;
				$res['empbank'] = $bank;
				$res['empbankloan'] = $bankloan;
				$res['empltadetails'] = $ltadetails;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    public function getAssetName($id)
	{
		$name ="";
		$sql = "SELECT Name FROM AssetsMaster WHERE Id in ($id)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			while($row = $query->fetch())
			{
				if($name=="")
				$name = $row->Name;
				else
				$name .= ", ".$row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	///////// profile issued assets//////////////////
	public function getIssuedDataTable()
	{
		$sTable = 'AssetsIssued';
		$sIndexColumn = "Id";
		$aColumns = array( 'AssetId', 'Description', 'Issueddate','ReturnDate');
		$empid = $_SESSION['ubihrm_user_id'];
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$sWhere = " WHERE EmployeeId=$empid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="AssetId"){
					$sWhere .= $aColumns[$i]." in ( SELECT Id FROM AssetsMaster where Name LIKE '%".( $_GET['sSearch'] )."%')  OR ";
				}else{
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="AssetId")
				{
					$row[]=$this->getAssetName($aRow->{$aColumns[$i]});
				
				}
				elseif($aColumns[$i]=="Issueddate" || $aColumns[$i]=="ReturnDate"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getEmployeeSalaryDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$month = isset($_POST['monthview']) ? $_POST['monthview'] : '';
		$where ="order by SalaryMonth desc limit 1";
		if($month != "")
		{
			$where =" and SalaryMonth = '$month'";
			
		}
		$curmonth = $this->getCurrentSalaryMonth($mid);
		$salarygenerateddate = $this->getCurrentSalaryGenerateDate($mid);
		$extenddate=date('Y-m-d',strtotime("+6 days ".date($salarygenerateddate)));
		$start=strtotime(date('Y-m-d'));
		$end=strtotime($extenddate);
		$days_between = ceil(abs($end - $start) / 86400);
		$days=($days_between==0)?"Tomorrow":"after $days_between day(s)";
		$whr="";
		if( date('Y-m-d') <= $extenddate)
		{
			//$errorMsg="You can see your current salary details ".$days;
			//$whr="and SalaryMonth<>'$curmonth' ";
		}else{
			//$errorMsg="No data found";
		}
		$salaryid = isset($_POST['salaryid']) ? Utils::decode5t($_POST['salaryid']) : '';
		if($salaryid !=0){
			$where="and Id=$salaryid";
			$whr="";
		}
        $sql = "SELECT * FROM SalaryMaster WHERE EmployeeId=? and OrganizationId=? and SalaryMonth in (SELECT SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = ?) $whr $where ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($mid, $orgid, $orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$salaryid  = $row->Id;
				$res['salaryid'] = $row->Id;
				$res['salaryid1'] = Utils::encode5t($row->Id);
				$res['employee'] = $row->EmployeeId;
				$res['empmonthdate'] = $row->SalaryMonth;
				$empdivision=Utils::getName($row->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
				$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
				$res['empcurency'] = $divcur;
				$res['empctc'] = $row->EmployeeCTC;
				$res['emppaiddays'] = $row->PaidDays;
				$res['empmonthname'] = date("F Y", strtotime($row->SalaryMonth));
				$res['salarydetail'] = array();
				$headarray = array();
				$total=0;$totaldeduction=0;
				$res['nextmonth']="";
				$res['previousmonth']="";
				
				$sql1 = "SELECT * FROM SalaryMaster WHERE EmployeeId=? and SalaryMonth=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid, date("Y-m-d", strtotime("+1 month,".$row->SalaryMonth)) ));
				if($query1->rowCount()>0){
					$res['nextmonth']=date("Y-m-d", strtotime("+1 month,".$row->SalaryMonth));
				}
				
				$sql1 = "SELECT * FROM SalaryMaster WHERE EmployeeId=? and SalaryMonth=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid, date("Y-m-d", strtotime("-1 month,".$row->SalaryMonth)) ));
				if($query1->rowCount()>0){
					$res['previousmonth']=date("Y-m-d", strtotime("-1 month,".$row->SalaryMonth));
				}
				////////////////   FIND OUT THE EMPLOYEE DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid, $orgid ));
				while($row1 = $query1->fetch())
				{
					$res['id'] = (int)$row1->Id;
					$res['name'] = ucwords(strtolower($row1->FirstName." ".$row1->LastName));
					$res['empcode'] = $row1->EmployeeCode;
					$res['empdivision'] = $this->getName($row1->Division,'DivisionMaster');
					$res['empdept'] = $this->getName($row1->Department,'DepartmentMaster');
					$res['empdesig'] = $this->getName($row1->Designation,'DesignationMaster');
					$res['empshift'] =$this->getName( $row1->Shift,'ShiftMaster');
					$res['empgrade'] = $this->getName($row1->Grade,'GradeMaster');
					$res['empctc'] = $row1->EmployeeCTC;
				}
				////////////////   FIND OUT THE COMPANY DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT Name,Logo FROM Organization WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid ));
				while($row1 = $query1->fetch())
				{
					$res['companyname'] = $row1->Name;
					$res['logo'] = URL."public/uploads/".$orgid."/".$row1->Logo;
				}
				////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT *, sh.headtype as type FROM SalaryHead sh, SalaryChild sc where sc.headtype=1 and sc.headid=sh.id and salaryid=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = (int)$row1->Id;
					$res1['amount'] = (float)$row1->HeadAmount;					
					$res1['name'] =(($row1->type==3)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 1;
					$res1['headtype'] = (int)($row1->type==3)?0:$row1->type;
					$res1['payslip'] = (int)$row1->IncludeInPayslip;
					$res1['additions'] = ($row1->type==3)?0:1;
					$headarray[]=$res1;
					if($row1->type==3)
					$totaldeduction += (float)$row1->HeadAmount;
					else
					$total += (float)$row1->HeadAmount;
				}
				///////////// LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////////////////////		
				$sql1 = "SELECT * FROM SalaryOtherHead sh, SalaryChild sc where sc.headtype=2 and sc.headid=sh.HeadCode and sc.salaryid=? and sh.OrganizationId=? and ActiveSts=1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ,$orgid));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = (int)$row1->HeadCode;
					$res1['amount'] = (float)$row1->HeadAmount;
					$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 2;
					$res1['headtype'] = (int)$row1->Type;
					$res1['payslip'] = (int)$row1->IncludeInPayslip;
					$res1['additions'] = ($row1->Type==0)?0:1;
					$headarray[]=$res1;
					
					if($row1->Type)
					$total += (float)$row1->HeadAmount;
					else
					$totaldeduction += (float)$row1->HeadAmount;
				}
				$res['salarydetail'] = $headarray;
				$res['emptotal'] = round($total);
				$res['emptotaldeduction'] = round($totaldeduction);
				$data[] = $res;
			}
        }else {
           $status =false;
		   //$errorMsg=SALARYMASTER_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getCurrentSalaryMonth($mid)
	{
		$month= date("Y-m-01");
		$orgid = $_SESSION['ubihrm_org_id'];
		
        $sql = "SELECT SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = ?   order by SalaryMonth desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$month = $row->SalaryMonth;
			}
        }
		
		return $month;
	}
	
	public function getCurrentSalaryGenerateDate($mid)
	{
		$month= date("Y-m-d");
		$orgid = $_SESSION['ubihrm_org_id'];
		
        $sql = "SELECT CreatedDate FROM SalaryGenerateMonth WHERE OrganizationId = ?  order by SalaryMonth desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$month = $row->CreatedDate;
			}
        }
		
		return $month;
	}
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT Name FROM $table WHERE Id = :id";
		$query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getOther($id, $type)
	{
		$name ="";
		$sql = "SELECT DisplayName FROM OtherMaster WHERE OtherType = ? and ActualValue=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($type, $id ));
			while($row = $query->fetch())
			{
				$name = $row->DisplayName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getPriority($id,$table)
	{
		$name ="";
		$sql = "SELECT DisplayName FROM $table WHERE ActualValue = ? AND OtherType = 'Priority'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
					$name=$row->DisplayName;
				
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getCode($id)
	{
		$empcode ="";
		$sql = "SELECT EmployeeCode FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->EmployeeCode;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	public function getEmployeeName($id,$table="EmployeeMaster")
	{
		$name ="";
		$sql = "SELECT FirstName,LastName FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->FirstName. ' '.$row->LastName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getCarryforwardleave($empid,$fiscalid)
	{
		$name ="";
		$sql = "SELECT TotalLeave FROM LeaveHistory WHERE EmployeeId = ? and FiscalId =?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid ,$fiscalid));
			while($row = $query->fetch())
			{
				$name = $row->TotalLeave;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeAllLeaveType()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $_SESSION['ubihrm_user_id'];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$applydate = date('Y-m-d');	
		$division=0;$location=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $religion=0;
		$divisionflg=false;$locationflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $religionflg=false; $halfdays=0;
		$fiscaldata=array();
		$doj=date('Y-m-d');
		$mdate=date('Y-m-d');
		$startdate=date('Y-04-01');
		$enddate=date('Y-03-31');
		try{
		$fiscalid = Utils::getFiscalId($applydate, $this->db);
		$sql1 = "SELECT *  FROM FiscalMaster WHERE Id=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $fiscalid));
		while($row1=$query1->fetch()){
			$res1=array();
			$res1['id']=$row1->Id;
			$res1['name']=$row1->Name;
			$startdate=$row1->StartDate;
			$enddate=$row1->EndDate;
			$res1['startdate']=Utils::dateformatter($row1->StartDate);
			$res1['enddate']=Utils::dateformatter($row1->EndDate);
			$fiscaldata[]=$res1;
		}
		$sql = "SELECT MaritalStatus, Gender, Division,Location, Department, Designation, Grade, Religion, TotalExp,WorkingDays,DOJ ,Shift,ProvisionPeriod  FROM EmployeeMaster WHERE OrganizationId = ? and Id =? ";
		
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $mid));
		while($row = $query->fetch())
		{
			$division=$row->Division;
			$location=$row->Location;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$religion=$row->Religion; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=$row->WorkingDays;
			$workingdays=substr_count($workingdays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);
			$workingdays=Utils::averageWorkingDayWeek($row->Shift,$this->db);
			$doj=$row->DOJ;
			$ProvisionPeriod=$row->ProvisionPeriod;
			$date1= date("Y-m-d", strtotime("+".$ProvisionPeriod." month ".date($doj)));
			$currdate = date("Y-m-d");
		}
		
		
			
		$annualid =0; $annualcount =0;
		$sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() AND WorkingDays= $workingdays and AnnualLeaveSts=1 ";
		///////////and DepartmentIds=0 and DesignationIds=0 and GenderId=0 and maritalId=0  and DivisionId=0 and GradeId=0 and ReligionId=0";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		if($query->rowCount()>0)
		{
			while($row = $query->fetch())
			{
				$annualid =$row->Id;
			}
		}
		
        $sql1 = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and VisibleSts=1";
        $query = $this->db->prepare($sql1);
		try{
			
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				$divisionflg=true;
				$locationflg=true;
				$departmentflg=true; 
				$designationflg=true; 
				$gradeflg=true; $religionflg=true;
				$genderflg=true; $maritalflg=true;
				
				$gradearr=($row->GradeId!=0)?explode(",",$row->GradeId):0;

				
				$carryforward=0;
				$employeeusedleave=0;
				
				if($row->LeaveUsableSts==1){
					if($row->DivisionId>0){
						if($row->DivisionId==$division){
							$divisionflg=true;
						}else{$divisionflg=false;}
					}
					if($row->locationId>0){
						if($row->locationId==$location){
							$locationflg=true;
						}else{$locationflg=false;}
					}
					if($row->DepartmentIds>0){
						if($row->DepartmentIds==$department){
							$departmentflg=true; 
						}else{$departmentflg=false; }
					}
					if($row->DesignationIds>0){
						if($row->DesignationIds==$designation){
							$designationflg=true; 
						}else{$designationflg=false; }
					}
					if($row->GenderId>0){
						if($row->GenderId==$gender){
							$genderflg=true;
						}else{$genderflg=false;}
					}
					if($row->MaritalId>0){
						if($row->MaritalId==$marital){
							$maritalflg=true;
						}else{$maritalflg=false;}
					}
					/* if($row->GradeId>0){
						if($row->GradeId==$grade){
							$gradeflg=true; 
						}else{$gradeflg=false; }
					} */
					if( $gradearr ==0){ 
						$gradeflg=true;	
					}elseif( in_array($grade, $gradearr ) ){
						$gradeflg=true;
					}else{
						$gradeflg=false;
					}
					if($row->ReligionId>0){
						if($row->ReligionId==$religion){
							$religionflg=true; 
						}else{$religionflg=false; }
					}
				}elseif($row->LeaveUsableSts==2){
					$divisionflg=false;
					$locationflg=false;
					$departmentflg=false; 
					$designationflg=false; 
					$gradeflg=false; 
					$genderflg=false; $maritalflg=false;
					$religionflg=false; 
					
					if($row->EmployeeIds!="")
					{
						$temp = explode(",", $row->EmployeeIds);
						for($i=0; $i<count($temp); $i++)
						{
							if($mid==$temp[$i]){
								$divisionflg=true;
								$locationflg=true;
								$departmentflg=true; 
								$designationflg=true; 
								$gradeflg=true; $religionflg=true;
								$genderflg=true; $maritalflg=true;
								break;
							}
							
						}
					}					
				}
				$annual=true;
				if($row->AnnualLeaveSts==1){
					$annual=false;
					if($row->CarryForward == 1) ///checking anniversary year status//////
					{
						$annual=true;
					}else{
						/////Commenting if bcz want to remove working day in leavetype/////
						//if($row->WorkingDays ==$workingdays){
							$annual=true;
					//	}
					}
				}
				$leaveflg=true;
				if($row->ProbationSts==0)
				{
					if($currdate  > $date1){
						$leaveflg=true;
					}else{$leaveflg=false;}
				}
				
				//echo  $row->Name."div".$divisionflg ."<br>depart". $departmentflg ."<br>desog". $designationflg ."<br>grade". $gradeflg ."<br>gender".$genderflg ."<br>mar". $maritalflg ."<br>annual". $annual ."<br>rel". $religionflg ."<br>leav". $leaveflg."<br>location".$locationflg."<br><br>";
				if($divisionflg && $locationflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg && $annual && $religionflg && $leaveflg)
				{	
					$leavealotted=$row->LeaveDays;
					$anniversaryyearsts=$row->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
					if($row->AnnualLeaveSts==1){
						
						$carryforward=$this->getCarryforwardleave($mid,$fiscalid);
						if($anniversaryyearsts==1)
							$carryforward=0;
						if($row->WorkingDays ==$workingdays){
							++$annualcount;
						}
						$sql1 = "SELECT * FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";////////////
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $mid, $fiscalid));
						if($r = $query1->fetch())
						{
							$leavealotted =$r->LeaveAllotted;
							$employeeusedleave = $r->UsedLeave;
							$leftleave = $r->BalanceLeave;
						}else{
							$leavealotted =0;
							$employeeusedleave =0;
							$leftleave = 0;
							
						}
						////////////////////////////////////////////////////////
						
						
						/* if($anniversaryyearsts == 1)
						{
							$start = strtotime($doj);
							$end = strtotime(date('Y-m-d'));
							$days_between = floor(abs($end - $start) / 86400);
							$leavealotted1=floor(($days_between * $row->LeaveDays)/365);
							$leavealotted=$leavealotted1;
							$twoyearsdays=(365*2)+30;////ADD MORE 30 DAYS,FOR TAKE ACTION ON LEAVE///	
							if($days_between < $twoyearsdays)
							{
							//////////IN THIS CASE CALCULATION BASED ON DATE OF JOINING TILL NOW/////////
								
								$startdate=$doj;
								$enddate=$mdate;
							}else{
							/////////IN THIS CASE I FIND THE ANNIVERSARY YEAR OF EMPLOYEE OF THIS YEAR,AND CALCULATE LEAVE ,ON THIS BASIS////////
							
								$start = strtotime($doj);
								$end = strtotime(date("2015-04-01"));
								if($end>$start){
									$days_between = floor(($end - $start) / 86400);
									$leavealotted1=floor(($days_between * $row->LeaveDays)/365);
									$employeeusedleave = $employeeusedleave + $leavealotted1;
								}
								
								$startdate=date("2015-04-01");
								$enddate=$mdate;
								
								
							}
							/* /////////this condition is for 30 day calendar days employees,this calculation is based on anniversary year of the joining date,ex- 10/02/2014 -10/02/2015////////
							$myear=date('Y');
							$anniversaryyear=date('m-d',strtotime(date($doj)));
							$enddate=$myear.'-'.$anniversaryyear;
							$startdate=date('Y-m-d',strtotime("- 1 year".date($enddate)));
							if(strtotime($mdate) > strtotime($enddate))
							{
								$startdate=$myear.'-'.$anniversaryyear;
								$enddate=date('Y-m-d',strtotime("+ 1 year".date($startdate)));
							} */
							
						/* }elseif((strtotime($doj) > strtotime($startdate)) && $anniversaryyearsts !=1){
							//////////////////if an employee join organization in mid of fiscal year then leave days will calculated according to date of joining and end of fiscal year/////////////////
							//$sql="SELECT * FROM FiscalMaster where '$doj' between '$startdate' and '$enddate'";
							//$query = $this->db->prepare($sql);
							//$query->execute();
							//if($query->rowCount() >0 )
							//{
								$start = strtotime($doj);
								$end = strtotime($enddate);
								$days_between = floor(abs($end - $start) / 86400);
								$leavealotted1=floor(($days_between * $leavealotted)/365);
								$leavealotted=$leavealotted1;
							//}
						} */ 
						
						
						
					}else{
						$sql3 = "Select * from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=0 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 and empchild.Entitled=1";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array($startdate, $enddate, $orgid, $mid, $row->Id));
						while($row3=$query3->fetch()){
							if($row3->HalfDaySts == 1){
								$employeeusedleave = $employeeusedleave + 0.5;
							}
							else{
								$employeeusedleave++;
							}
						}
						$leftleave = $leavealotted-$employeeusedleave;
					}
					
					
					/* $sql3 = "Select * from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=0 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 and empchild.Entitled=1";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array($startdate, $enddate, $orgid, $mid, $row->Id));
					while($row3=$query3->fetch()){
						if($row3->HalfDaySts == 1){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					} */
				
					
					if($leftleave>=0)
					{
						$res = array();
						$res['id'] = (int)$row->Id;
						$res['name'] = $row->Name;
						$res['payrule'] = $row->LeavePayRule;
						$res['days'] = (int)$leavealotted;
						$res['usedleave'] = $employeeusedleave;
						$res['leftleave'] = $leftleave;
						$res['carryforward'] = $carryforward;
						$res['ProbationSts'] = $row->ProbationSts;
						
						$data[] = $res;
					}
				}
				
			}
		
				
        }else{
			$status=true;
			$successMsg = LEAVETYPE_MODULE_GETALL;
		}
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result["fiscaldata"] =$fiscaldata;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getLeaveDaysDifference($id)
	{
		$leavefrom = $_POST['leavefrom'];
		$leaveto   = $_POST['leaveto'];
		$leavefromtype   = $_POST['leavefromtype'];
		$leavetotype   = $_POST['leavetotype'];
		
		$leavetimeofto   = $_POST['leavetimeofto'];
		$orgid   = $_SESSION['ubihrm_org_id'];
		$leavetype   = $_POST['leavetype'];
		$resumptiondate ="";
		$leavecalculetedby=Utils::getName($leavetype,'LeaveMaster','CarryForward',$this->db);
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$total =0; $weekoff=0;
		if($leavefrom!="" && $leaveto!="")
		{
			$leavefrom = Utils::getDateformat($leavefrom);
			$leaveto = Utils::getDateformat($leaveto);
		//	$resumptiondate = date('Y-m-d', strtotime('+1 day', strtotime(date($leaveto))));
			/////////////////////////////////////////
			/*  $sql1 = "SELECT WorkingDays FROM EmployeeMaster WHERE Id = ?";
			 $query1 = $this->db->prepare($sql1);
			 $query1->execute(array( $id ));			
			 $row1 = $query1->fetch();
			 $workingday = $row1->WorkingDays; */
			 //////////////////////////////////////////
			$status=true;
			while(date($leavefrom)<=date($leaveto))
			{
				$j=0;	
				$div=Utils::getName($id,'EmployeeMaster','Division',$this->db);
				$sql = "SELECT Id, Name FROM HolidayMaster WHERE OrganizationId=? and ? between DateFrom and DateTo and FIND_IN_SET($div,DivisionId)";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid,$leavefrom ));
					if($query->rowCount()>0)
					{
						while($row = $query->fetch())
						{
							$j++;
							$weekoff++;
							$res = array();
							$res['date'] = date( "l, d F, Y", strtotime(date($leavefrom)));
							$res['label'] = "Holiday -".$row->Name;
							$data[] = $res;
						}
					}else{
						//$temparr = explode(',',$workingday);
						$dw = date( "w", strtotime(date($leavefrom)));
						if($leavefromtype==2 && $total==0 ){
							$date = "Leave Half Day";
							//$total=$total+0.5;
						}
						elseif($leavetotype==2 && (date($leavefrom)==date($leaveto)) ){
							$date = "Leave Half Day";
							//$total=$total+0.5;
						}else{
							$date = "Leave Full Day";
							//$total++;
						}	
						if($leavetotype==2 && $leavefromtype==2 && (date($leavefrom)==date($leaveto)) )
						{	if($leavetimeofto==2)
							{
								$resumptiondate = date('Y-m-d', strtotime('+1 day', strtotime(date($leaveto))));
							}
							else
							{
								$resumptiondate = date('Y-m-d', strtotime(date($leaveto)));
							}
						}
						elseif($leavetotype==2 && $leavefromtype==1 && (date($leavefrom)<date($leaveto)) )
						{
							if($leavetimeofto==1)
							{
								$resumptiondate = date('Y-m-d', strtotime(date($leaveto)));
							}
							else
							{
								$resumptiondate = date('Y-m-d', strtotime('+1 day', strtotime(date($leaveto))));
							}
						}
						elseif($leavetotype==1 && $leavefromtype==2 && (date($leavefrom)<date($leaveto)) )
						{
							$resumptiondate = date('Y-m-d', strtotime('+1 day', strtotime(date($leaveto))));
						}
						elseif($leavetotype==1 && $leavefromtype==1 && (date($leavefrom)<=date($leaveto)) )
					
						{ 
							$resumptiondate = date('Y-m-d', strtotime('+1 day', strtotime(date($leaveto))));
						}
									
						/////// gettung weekly off from shift of employee
						$weekno=Utils::weekOfMonth($leavefrom);
						$dayofdate= 1 + date("w", strtotime($leavefrom));
						$sql2 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=(select shift from EmployeeMaster where Id=$id) and Day=$dayofdate";
						
						//Utils::Trace($sql2." Date used - ".$leavefrom." day of month -  ".$dayofdate." week of month - ".$weekno);
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array());
						$week="";
						if($row2 = $query2->fetch()){
							$week=$row2->WeekOff;
						}
						$weekarr=explode(",",$week);
						if($query2->rowCount()>0){
							if($weekarr[$weekno-1]==1){
								$weekoff++;
								$j++;
								$date = " Weekly off  -".date( "l", strtotime(date($leavefrom)));
							}else if($weekarr[$weekno-1]==2){
								$weekoff = $weekoff +0.5;
								$date = " HalfDay -".date( "l", strtotime(date($leavefrom)));
							}
						}
						/* for($i=0; $i<count($temparr); $i++){
							if($dw == $i){
								if($temparr[$i]==3){
									$weekoff++;
									$j++;
									$date = " Weekly off  -".date( "l", strtotime(date($leavefrom)));
									break;
								}elseif($temparr[$i]==2){
									$weekoff = $weekoff +0.5;
									$date = " HalfDay -".date( "l", strtotime(date($leavefrom)));
									break;
								}
							}
						} */
						$res = array();
						$res['date'] = date( "l, d F, Y", strtotime(date($leavefrom)));
						$res['label'] = $date;
						$data[] = $res;
					}
					
			
					if($leavecalculetedby == 0){
						if($leavefromtype==2 && $total==0 && $j==0){
							$total=$total+0.5;
						}
						elseif($leavetotype==2 && (date($leavefrom)==date($leaveto)) && $j==0){
							$total=$total+0.5;
						}else{
							$total++;
						}
						//echo 	$annualleavests;
					}else{
						if($leavefromtype==2 && $total==0 ){
							$total=$total+0.5;
						}
						elseif($leavetotype==2 && (date($leavefrom)==date($leaveto)) ){
							$total=$total+0.5;
						}else{
							$total++;
						}
					}				
						
				}catch(Exception $e) {
					
				}
				$leavefrom = date('Y-m-d', strtotime('+1 day', strtotime(date($leavefrom))));
			}
		}
		//echo $total;
		$total1 = $total -$weekoff;
		if($total1>0 && $leavecalculetedby==0){
			$total=$total1;
		}elseif($leavecalculetedby==1){
			$total=$total;
		}else{
			$total=0;
		}
		
		if($leaveto!="" && $resumptiondate!="" )
		{
			$status=true;
			while(date($leaveto)<=date($resumptiondate))
			{
				$h=0;	
				$div1=Utils::getName($id,'EmployeeMaster','Division',$this->db);
				$sql1 = "SELECT Id, Name FROM HolidayMaster WHERE OrganizationId=? and ? between DateFrom and DateTo and FIND_IN_SET($div1,DivisionId)";
				
				$query = $this->db->prepare($sql1);
				try
				{
					$query->execute(array($orgid,$resumptiondate ));
					if($query->rowCount()>0)
					{
						while($row = $query->fetch())
						{
							$h++;
							$weekoff++;
							$resumptiondate = date('Y-m-d', strtotime('+1 day', strtotime(date($resumptiondate))));
						}
					}
					else
					{
						/////// getting weekly off from shift of employee
						$weekno=Utils::weekOfMonth($resumptiondate);
						$dayofdate= 1 + date("w", strtotime($resumptiondate));
						
						$sql2 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=(select shift from EmployeeMaster where Id=$id) and Day=$dayofdate";
						
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array());
						
						$week="";
						if($row2 = $query2->fetch()){
							$week=$row2->WeekOff;
						}
						$weekarr=explode(",",$week);
						if($query2->rowCount()>0){
							if($weekarr[$weekno-1]==1){
								$weekoff++;
								$h++;
								$date = " Weekly off  -".date( "l", strtotime(date($resumptiondate)));
							$resumptiondate = date('Y-m-d', strtotime('+1 day', strtotime(date($resumptiondate))));
						
							}else if($weekarr[$weekno-1]==2){
								$weekoff = $weekoff +0.5;
								$date = " HalfDay -".date( "l", strtotime(date($resumptiondate)));
							$resumptiondate = date('Y-m-d', strtotime(date($resumptiondate)));

							}
						}
					}
				}catch(Exception $e) {
					
				}
				$leaveto = date('Y-m-d', strtotime('+1 day', strtotime(date($leaveto))));
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		$result['totaldays']=$total;
		$result['resumptiondate']=Utils::dateformatter($resumptiondate);
		return $result;
	}
	
	public function getDepartmentEmployee($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT Id, EmployeeCode, FirstName, LastName FROM EmployeeMaster WHERE Id <> ? and Department in ( SELECT Department FROM EmployeeMaster WHERE Id = ?) and DOL='0000-00-00' Order by FirstName";
		/////////////and Division in  ( SELECT Division FROM EmployeeMaster WHERE Id = ?)
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id, $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".ucwords(strtolower($row->FirstName." ".$row->LastName));
				
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function Createtimeoff()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $month = date("Y-m-d");
		$userid = $_SESSION['ubihrm_user_id'];
		$timeoffdate = Utils::getDateformat($_POST['timeoffdate']);
		$timeoffdateformatted = $_POST['timeoffdate'];
		$fromtime=$_POST['fromtime'];
		$fromtime  = date("H:i", strtotime($fromtime));
		$totime=$_POST['totime'];
		$totime = date("H:i", strtotime($totime));
		$timeoffreason=$_POST['timeoffreason'];
		$orgid= $_SESSION['ubihrm_org_id'];
		try{
			$arr = array();
			$arr[0] = $userid;
			$arr[1] = $timeoffdate;
			$arr[2] = $fromtime;
			$arr[3] = $totime;
			$arr[4] = $timeoffreason;
			$arr[5] = $month;
			$arr[6] = $month;
			$arr[7] = $orgid;
			$approvelink="";
		    $rejectlink="";
			
			$sql = "INSERT INTO Timeoff (EmployeeId, TimeofDate,TimeFrom,TimeTo,Reason,CreatedDate,ModifiedDate,OrganizationId) VALUES (?,?,?,?,?,?,?,?)";		
				
				$query = $this->db->prepare($sql);
				$query->execute($arr);
				$count =  $query->rowCount();				
				$leaveid = $this->db->lastInsertId();
				if ($count == 1) {
					
				/*generate mail and alert for task requested*/
				Alerts::generateActionAlerts(36,$leaveid,$orgid,$this->db);
				//$empid=Utils::getName($did, 'Timeoff','EmployeeId',$this->db);
				$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
				$msg="$empname applied for TimeOff  ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($userid, "Profiles", $msg, $orgid));
				
					$status =true;
					$hr=0;
					$successMsg = "Your application for Time off has been sent successfully";;
					
				/*	$sql = "select EmployeeMaster.Id from DesignationMaster,EmployeeMaster where DesignationMaster.Id=EmployeeMaster.Designation and DesignationMaster.HrSts=1 and EmployeeMaster.OrganizationId=? and DesignationMaster.OrganizationId=? and  EmployeeMaster.DOL='0000-00-00'";  */  //Comment made by Pratibha
				
				 $sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";
					$query = $this->db->prepare($sql);
					$query->execute(array( $orgid));
					if($r=$query->fetch()){
						$hr=$r->EmployeeId;
					} 
					$senior = Utils::getApprovalLevelEmp($userid, 8, $this->db);
					if($senior!=0)
					{
						/* $temp1 = explode(",", $senior);
						for($i=0;$i<count($temp1);$i++)
						{
							if($temp1[$i] == $hr){
								unset($temp1[$i]);
							}
						}
						$senior=implode(',',$temp1);
						if($hr !=0)
							$senior.=','.$hr; */
						$temp = explode(",", $senior);
						for($i=0; $i<count($temp); $i++)
						{
							if($temp[$i] != 0){
								
								///////// fetching timeoff approval history ///////////
								
								$approverhistory="";
									$sql = "SELECT * FROM TimeoffApproval WHERE OrganizationId = ? AND TimeofId = ? AND ApproverSts<>3 ";
									$query = $this->db->prepare($sql);
									$query->execute(array($orgid, $leaveid));
									$count =  $query->rowCount();
									if($count>=1){
										$approverhistory="<p><b>Approval History</b></p>
										<table border='1' style=' border-collapse: collapse;width:70%'>
										<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															
															<th>Approval Status</th>
															<th>Approver</th>
															<th>Approval Date</th>
															<th>Remarks</th>
										</tr>
										";
									}
									while($r=$query->fetch()){
										$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
										$approvalsts=$r->ApproverSts;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}
										$approvaldate="";
										$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
										$approvercomment=$r->ApproverComment;
										$approverhistory.="<tr>
														
															<th>$approvalsts</th>
																<th>$approvername</th>
															<th>$approvaldate</th>
															<th>$approvercomment</th>
														</tr>";
									}
									
									if($count>=1){
										$approverhistory.="</table>";
									}
								
								$approvelink=URL."approvalbymail/viewapprovetimeoffapproval/$temp[$i]/$orgid/$leaveid/2";
								$rejectlink=URL."approvalbymail/viewapprovetimeoffapproval/$temp[$i]/$orgid/$leaveid/1";
								$sql = "INSERT INTO TimeoffApproval ( TimeofId, ApproverId, ApproverSts, CreatedDate , OrganizationId) VALUES (?, ?, ?, ?, ?)";
								$query = $this->db->prepare($sql);
								$query->execute(array($leaveid, $temp[$i], 3, $month, $orgid));
								$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
								$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
								if($i==0)
								{
									$senioremail=Utils::decode5t(Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db));
									$title="Timeoff approval";
									$msg="<table>
														<tr><td>Requested by: $empname</td></tr>
														<tr><td>Reason for leave: $timeoffreason</td></tr>
														<tr><td>Date: $timeoffdateformatted</td></tr>
														<tr><td>Duration: from $fromtime to $totime</td></tr>
														</table>
														
															$approverhistory
														
														<table>
														<tr><td><br/><br/>
														
																<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
																-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
																&nbsp;&nbsp;
																&nbsp;&nbsp;
																<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
																-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
																<br/><br/>
																</td>															
																</tr>
													</table>";
									Utils::Trace($senioremail." ".$msg);
									Utils::sendMail($senioremail,$empname,$title,$msg);
								}
							}
						}
					}else{
						$senior=Utils::getSeniorId($userid, $this->db);
						
						if($senior != $hr){
							if($hr !=0)
								$senior.=','.$hr;
						}
						$temp = explode(",", $senior);
						for($i=0; $i<count($temp); $i++)
						{
							if($temp[$i] != 0){
									///////// fetching timeoff approval history ///////////
								
								$approverhistory="";
									$sql = "SELECT * FROM TimeoffApproval WHERE OrganizationId = ? AND TimeofId = ? AND ApproverSts<>3 ";
									$query = $this->db->prepare($sql);
									$query->execute(array($orgid, $leaveid));
									$count =  $query->rowCount();
									if($count>=1){
										$approverhistory="<p><b>Approval History</b></p>
										<table border='1' style=' border-collapse: collapse;width:70%'>
										<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															
															<th>Approval Status</th>
															<th>Approver</th>
															<th>Approval Date</th>
															<th>Remarks</th>
										</tr>
										";
									}
									while($r=$query->fetch()){
										$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
										$approvalsts=$r->ApproverSts;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}
										$approvaldate="";
										$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
										$approvercomment=$r->ApproverComment;
										$approverhistory.="<tr>
															
															<th>$approvalsts</th>
															<th>$approvername</th>
															<th>$approvaldate</th>
															<th>$approvercomment</th>
														</tr>";
									}
									
									if($count>=1){
										$approverhistory.="</table>";
									}
								
								$sql = "INSERT INTO TimeoffApproval ( TimeofId, ApproverId, ApproverSts, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
								$query = $this->db->prepare($sql);
								$query->execute(array($leaveid, $temp[$i], 3, $month, $orgid));
								$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
								$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
								if($i==0){
								$senioremail=Utils::decode5t(Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db));
								$title="Timeoff request";
								$msg="<table>
												<tr><td>Requested by : $empname</td></tr>
												<tr><td>Reason for leave : $timeoffreason</td></tr>
												<tr><td>Date: $timeoffdateformatted</td></tr>
												<tr><td>Duration : from $fromtime to $totime</td></tr>
												</table>
												
												$approverhistory
												
												<table>
												<tr><td><br/><br/>
														<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
														-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
														&nbsp;&nbsp;
														&nbsp;&nbsp;
														<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
														-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
														<br/><br/>
														</td>															
														</tr>	
											</table>";
								Utils::Trace($senioremail." ".$msg);
								Utils::sendMail($senioremail,$empname,$title,$msg);
								}
							}
						}
					}
					
					
				} else {
				   $status =false;
				   $errorMsg = EMPLOYEELEAVE_MODULE_CREATION_FAILED;
				}
			
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function CreateLeave()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$month = date("Y-m-d");
		$fiscal = Utils::getFiscalId($month, $this->db);
		$userid = $_SESSION['ubihrm_user_id'];
		$leavefrom = Utils::getDateformat($_POST['leavefrom']);
		$leaveto = Utils::getDateformat($_POST['leaveto']);
		try{
		$sql = "SELECT * FROM EmployeeLeave WHERE EmployeeId=? and ((? between  LeaveFrom and LeaveTo ) or (? between  LeaveFrom and LeaveTo )) and (LeaveStatus=2 or LeaveStatus=3)";
		$query = $this->db->prepare($sql);
		$query->execute(array($userid,$leavefrom,$leaveto));
		$count =$count +  $query->rowCount();
		if($count>=1)
		{
			$status=false;
			$errorMsg="You already applied for same date";
		}
		else{
			$arr = array();
			$arr[0] = $userid;
			$orgid=$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $leavefrom;
			$arr[3] = $leaveto;
			$leavereason=$arr[4] = $_POST['leavereason'];
			$arr[5] = $_POST['leavetypeid']; 
			$arr[6] = Utils::getDateformat($_POST['resumptiondate']);
			$arr[7] = $mdate; 
			$arr[8] = $fiscal; 
			$arr[9] = 3; 
			$arr[10] = $mdate; 
			$arr[11] = $userid; 
			$arr[12] = $mdate; 
			$arr[13] = $userid; 
			$arr[14] = $userid; 
			$arr[15] = $_POST['substitute'];
			$arr[16] = $_POST['emergencycontact'];
			$leavedays=$arr[17] = $_POST['dayseligible'];
			$fromhalfsts=$arr[18] = $_POST['fromdaytype'];
			$tohalfsts=$arr[19] = $_POST['todaytype'];
			$fromtypehalf=$arr[20] = $_POST['timeoffrom'];
			$totypehalf=$arr[21] = $_POST['timeofto'];
			$leavebalance=$this->getEmployeeLeftLeave($userid,$_POST['leavetypeid'],$mdate);
			$fromhalf="";
			$tohalf="";
			if($fromhalfsts==2){
				if($fromtypehalf==1){
					$fromhalf=" (1st half)";
				}else{
					$fromhalf=" (2nd half)";
				}
			}
			if($tohalfsts==2){
				if($totypehalf==1){
					$tohalf=" (1st half)";
				}else{
					$tohalf=" (2nd half)";
				}
			}
			if($fiscal>0)
			{
				$sql = "INSERT INTO EmployeeLeave  (EmployeeId, OrganizationId, LeaveFrom, LeaveTo, LeaveReason, LeaveTypeId, ResumptionDate, ApplyDate, FiscalId, LeaveStatus, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, SubstituteEmployeeId, EmergencyContact,LeaveValidDays, FromDayType, ToDayType, TimeOfFrom, TimeOfTo) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
				$query = $this->db->prepare($sql);
				$query->execute($arr);
				$count =  $query->rowCount();				
				$leaveid = $this->db->lastInsertId();
				
				if ($count == 1) {
					/*generate mail and alert for leave request */
					Alerts::generateActionAlerts(35,$leaveid,$orgid,$this->db);
					
					$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
					$msg="$empname Applied for a Leave";
					$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($userid, "Profiles", $msg, $orgid));
					
					$status =true;
					$hr=0;
					$successMsg = EMPLOYEELEAVE_MODULE_CREATION_SUCCESS;
					
				/*	$sql = "select EmployeeMaster.Id from DesignationMaster,EmployeeMaster where DesignationMaster.Id=EmployeeMaster.Designation and DesignationMaster.HrSts=1 and EmployeeMaster.OrganizationId=? and DesignationMaster.OrganizationId=? and  EmployeeMaster.DOL='0000-00-00'";  */ //Comment made by Pratibha
				
				 $sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";

					$query = $this->db->prepare($sql);
					$query->execute(array( $orgid));
					if($r=$query->fetch()){
						$hr=$r->EmployeeId;
					}
					$senior = Utils::getApprovalLevelEmp($userid, 1, $this->db);
					if($senior!=0)
					{
					  $temp1 = explode(",", $senior);
						for($i=0;$i<count($temp1);$i++)
						{
							if($temp1[$i] == $hr){
								unset($temp1[$i]);
							}
						}
						$senior=implode(',',$temp1); 
						 if($hr !=0)
							$senior.=','.$hr; 
						$temp = explode(",", $senior);
						
						for($i=0; $i<count($temp); $i++)
						{
							if($temp[$i] != 0){
								$sql = "INSERT INTO LeaveApproval ( LeaveId, ApproverId, ApproverSts, CreatedDate ,  OrganizationId) VALUES (?, ?, ?, ?, ?)";
								$query = $this->db->prepare($sql);
								$query->execute(array($leaveid, $temp[$i], 3, $mdate, $orgid));
								$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
								$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
								//$url=URL.'approvalbymail/approveleaveapproval/'.$temp[$i].'/'.$orgid.'/'.$leaveid.'/2';
								//Utils::Trace($url);
								if($i==0){
									$approverhistory="";
									$sql = "SELECT * FROM LeaveApproval WHERE OrganizationId = ? AND LeaveId = ? AND ApproverSts<>3 ";
									$query = $this->db->prepare($sql);
									$query->execute(array($orgid, $leaveid));
									$count =  $query->rowCount();
									if($count>=1){
										$approverhistory="<p><b>Approval History</b></p>
										<table border='1' style=' border-collapse: collapse;width:70%'>
										<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
											
											<th>Approval Status</th>
											<th>Approver</th>
											<th>Approval Date</th>
											<th>Remarks</th>
										</tr>
										";
									}
									while($r=$query->fetch()){
										$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
										$approvalsts=$r->ApproverSts;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}
										$approvaldate="";
										$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
										$approvercomment=$r->ApproverComment;
										$approverhistory.="<tr>
															
															<th>$approvalsts</th>
															<th>$approvername</th>
															<th>$approvaldate</th>
															<th>$approvercomment</th>
														</tr>";
									}
									
									if($count>=1){
										$approverhistory.="</table>";
									}
									
									////////  Fetching Leave History //////////////
									$leavehistory="";
									$leavehistoryarr=$this->getEmployeeAllLeaveTypeForMail($orgid,$userid,$arr[5]);
									
									foreach($leavehistoryarr["data"] as $key => $value) {
										$leavetyp=$value['name'];
										$ent=$value['days'];
										$usedleave=$value['usedleave'];
										$leftleave=$value['leftleave'];
										$carryforward=$value['carryforward'];
										$leavehistory.="
										<p><b>Leave History</b></p>
											<table border='1' style=' border-collapse: collapse;width:70%'>
												<tr style=' background-color: rgba(107, 58, 137, 0.91); color: rgba(255, 247, 247, 1);'>
												<th>Leave Type</th>
												<th>Carried Forward</th>
												<th>Leave Entitled</th>
												<th>Leave Utilized</th>
												<th>Balance Leave</th>
												
												</tr>
												<tr>
												<td><center>$leavetyp</center></td>
												<td><center>$carryforward</center></td>
												<td><center>$ent</center></td>
												<td><center>$usedleave</center></td>
												<td><center>$leftleave</center></td>
												
												</tr>
											</table><br>";
									}
									$approvelink=URL."approvalbymail/viewapproveleaveapproval/$temp[$i]/$orgid/$leaveid/2";
									$rejectlink=URL."approvalbymail/viewapproveleaveapproval/$temp[$i]/$orgid/$leaveid/1";
									$senioremail=Utils::decode5t(Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db));
									$title="Leave requested by $empname";
									$from=$_POST['leavefrom'];
									$to=$_POST['leaveto'];
									$duration="";
									if($from==$to){
										$duration="$from $fromhalf";	
									}else{
										$duration=" from $from $fromhalf to $to $tohalf";	
									}
									$a="";
									if($leavebalance<$_POST['dayseligible']){
									$a=	"<tr><td>Note: Applied leave for $empname is in excess of the eligible leave. Would you like to proceed?</td></tr>";
									}
									$msg="<table>
													<tr><td>Requested by : $empname</td></tr>
													<tr><td>Reason for leave : $leavereason</td></tr>
													<tr><td>Leave Date :  $duration</td></tr>
													
													<tr><td>Leave days :  $leavedays</td></tr>
														<tr><td colspan='2'>														
														</td></tr>														
												</table></br>
												$leavehistory
												</br>
												$approverhistory<br>
												<b>$a </b><br>
												<table>
												<tr><td><br/><br/>
													<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
													-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
													&nbsp;&nbsp;
													&nbsp;&nbsp;
													<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
													-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
													<br/><br/>
													</td>															
													</tr>
												</table>";
									//$senioremail="monika@ubitechsolutions.com";
									Utils::sendMail($senioremail,$empname,$title,$msg);
									Utils::Trace($senioremail." ".$msg);
									
								}
								
							}
						}
					}else{
						$senior=Utils::getSeniorId($userid, $this->db);
						
						if($senior != $hr){
							if($hr !=0)
								$senior.=','.$hr;
						}
						$temp = explode(",", $senior);
						for($i=0; $i<count($temp); $i++)
						{
							if($temp[$i] != 0){
								$sql = "INSERT INTO LeaveApproval ( LeaveId, ApproverId, ApproverSts, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
								$query = $this->db->prepare($sql);
								$query->execute(array($leaveid, $temp[$i], 3, $mdate, $orgid));
								$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
								$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
								if($i==0){
										$approverhistory="";
									$sql = "SELECT * FROM LeaveApproval WHERE OrganizationId = ? AND LeaveId = ? AND ApproverSts<>3 ";
									$query = $this->db->prepare($sql);
									$query->execute(array($orgid, $leaveid));
									$count =  $query->rowCount();
									if($count>=1){
										
										$approverhistory="<p><b>Approval History</b></p>
										<table border='1' style=' border-collapse: collapse;width:70%'>
										<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															
															<th>Approval Status</th>
															<th>Approver</th>
															<th>Approval Date</th>
															<th>Remarks</th>
														</tr>
										";
									}
									while($r=$query->fetch()){
										$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
										$approvalsts=$r->ApproverSts;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}
										$approvaldate="";
										$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
										$approvercomment=$r->ApproverComment;
										$approverhistory.="<tr>
															
															<th>$approvalsts</th>
															<th>$approvername</th>
															<th>$approvaldate</th>
															<th>$approvercomment</th>
														</tr>";
									}
									if($count>=1){
										$approverhistory.="</table>";
									}
									
									////////  Fetching Leave History //////////////
									$leavehistory="";
									$leavehistoryarr=$this->getEmployeeAllLeaveTypeForMail($orgid,$userid,$arr[5]);
									foreach($leavehistoryarr as $key => $value) {
										$leavetyp=$value['name'];
										$ent=$value['days'];
										$usedleave=$value['usedleave'];
										$leftleave=$value['leftleave'];
										$carryforward=$value['carryforward'];
										$leavehistory.="
										<p><b>Leave History</b></p>
												
												<table border='1' style=' border-collapse: collapse;width:70%'>
														<tr style=' background-color: rgba(107, 58, 137, 0.91); color: rgba(255, 247, 247, 1);'>
														<th>Leave Type</th>
														<th>Carried Forward</th>
														<th>Leave Entitled</th>
														<th>Leave Utilized</th>
														<th>Balance Leave</th>
													
														</tr>
														<tr>
														<td><center>$leavetyp</center></td>
														<td><center>$carryforward</center></td>
														<td><center>$ent</center></td>
														<td><center>$usedleave</center></td>
														<td><center>$leftleave</center></td>
													
														</tr>
												</table><br>
										";
									}
									$approvelink=URL."approvalbymail/viewapproveleaveapproval/$temp[$i]/$orgid/$leaveid/2";
									$rejectlink=URL."approvalbymail/viewapproveleaveapproval/$temp[$i]/$orgid/$leaveid/1";
									$senioremail=Utils::decode5t(Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db));
									$title="Leave requested by $empname";
									$from=$_POST['leavefrom'];
									$to=$_POST['leaveto'];
									$a="";
									if($leavebalance<$_POST['dayseligible']){
									$a=	"<tr><td>Note: Applied leave for $empname is in excess of the eligible leave. Would you like to proceed?</td></tr>";
									}
									$duration="";
									if($from==$to){
									$duration="$from $fromhalf";	
									}else{
									$duration=" from $from $fromhalf to $to $tohalf";	
									}
									
									$msg="<table>
												<tr><td>Requested by : $empname</td></tr>
												<tr><td>Reason for leave : $leavereason</td></tr>
												<tr><td>Leave Date : $duration</td></tr>
												
												<tr><td>Leave days :  $leavedays</td></tr>
												<tr><td colspan='2'>														
												</td></tr>														
											</table></br>
											$leavehistory
											</br>
											$approverhistory<br>
											<b>$a </b><br>
											<table>
											<tr><td><br/><br/>
															<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
															-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
															&nbsp;&nbsp;
															&nbsp;&nbsp;
															<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
															-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
															<br/><br/>
															</td>															
															</tr>	
												
											</table>";
									Utils::sendMail($senioremail,$empname,$title,$msg);
									Utils::Trace($senioremail." ".$msg);
								}
							}
						}
					}
					
					
				} else {
				   $status =false;
				   $errorMsg = EMPLOYEELEAVE_MODULE_CREATION_FAILED;
				}
			}else{
				 $status = false;
				 $errorMsg = FISCAL_MODULE_GETALL;
			}
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function getEmployeeLeftLeave($mid,$leavetype,$applydate)
    {
		$orgid=$_SESSION['ubihrm_org_id'];
		$count=0; $leftleave=0;
		$leaveid=0; $result=0;
			try{
				$fiscalid = Utils::getFiscalId($applydate, $this->db);
				$employeeusedleave=0;
				$sql1 = "SELECT Id  FROM EmployeeLeave WHERE OrganizationId = ? and EmployeeId =? and LeaveTypeId=? and FiscalId =? and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $mid, $leavetype, $fiscalid));
				while($row1=$query1->fetch()){
					$leaveid.=','.$row1->Id;
				}
				$sql1 = "SELECT *  FROM LeaveMaster WHERE Id =?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $leavetype));
				while($row1=$query1->fetch()){
					$total=$row1->LeaveDays;
				}
				
					$sql = "SELECT *  FROM EmployeeLeaveChild WHERE EmployeeLeaveId in ($leaveid) and LeaveTypeId=? and Entitled=1  and LeaveStatus=2";
					$query = $this->db->prepare($sql);
					$query->execute(array( $leavetype));
					while($row1=$query->fetch())
					{
						if($row1->HalfDaySts == 1){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					}
					$leftleave = $total-$employeeusedleave;
					if($leftleave>0)
					{
						$result=$leftleave;
					}
				
				
				
		}catch(Exception $e) {
			
			$e->getMessage();
		}
		
		
		return $result;
    }

	/////////////////////////////Update TimeOff////////

	public function UpdateTimeoff()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $userid = $_SESSION['ubihrm_user_id'];
        $month = date("Y-m-d");
		$timeoffdate = Utils::getDateformat($_POST['timeoffdate']);
		$fromtime=$_POST['fromtime'];
		$totime=$_POST['totime'];
		$timeoffreason=$_POST['timeoffreason'];
		$orgid= $_SESSION['ubihrm_org_id'];
		$timeoffid=$_POST['timeoffid'];
		try{
			$arr = array();
			$arr[0] = $timeoffdate;
			$arr[1] = $fromtime;
			$arr[2] = $totime;
			$arr[3] = $timeoffreason;
			$arr[4] = $month;
			$arr[5]= $timeoffid;
			
 $sql = "update Timeoff  set TimeofDate = '$timeoffdate' , TimeFrom='$fromtime' ,TimeTo='$totime' ,Reason='$timeoffreason' ,ModifiedDate=$month where Id=$timeoffid and OrganizationId=$orgid";
			$query = $this->db->prepare($sql);
			$query->execute();
		
			$count =  $query->rowCount();		
		
		
        if ($count == 1) {
			
			//$empid=Utils::getName($decodeid,'SalaryAdvance','EmployeeId',$this->db);
            $empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
            $msg="Profile of $empname TimeOff has been Updated  ";
            $sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
            $query = $this->db->prepare($sql);
            $query->execute(array($userid, "Profile", $msg, $orgid));
           
           $status =true;
		   $successMsg = "Time off application has been updated successfully";
        } else {
           $status =false;
		   $errorMsg = EMPLOYEELEAVE_MODULE_UPDATION_FAILED;
        }
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }	
	
	public function UpdateLeave()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $userid = $_SESSION['ubihrm_user_id'];
		$mdate = date("Y-m-d H:i:s");
		$leavefrom = Utils::getDateformat($_POST['leavefrom']);
		$leaveto = Utils::getDateformat($_POST['leaveto']);
		try{
		
		$sql = "SELECT * FROM EmployeeLeave WHERE EmployeeId=? and ((? between  LeaveFrom and LeaveTo )or (? between  LeaveFrom and LeaveTo ))  and Id <>?";
		$query = $this->db->prepare($sql);
		$query->execute(array($userid,$leavefrom,$leaveto,$_POST['leaveid']));
		$count =$count +  $query->rowCount();
		
		//$leavefrom = date('Y-m-d', strtotime('+1 day', strtotime(date($leavefrom))));
		
		
		if($count>=1)
		{
			//$empid=Utils::getName($decodeid,'SalaryAdvance','EmployeeId',$this->db);
            $empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
            $msg="Profile of $empname Leave has been Updated  ";
            $sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
            $query = $this->db->prepare($sql);
            $query->execute(array($userid, "Profile", $msg, $orgid));
          
			$status=false;
			$errorMsg=" You already applied for same date";
		}
		else{
			$arr = array();
			$arr[0] = Utils::getDateformat($_POST['leavefrom']);
			$arr[1] = Utils::getDateformat($_POST['leaveto']);
			$arr[2] = $_POST['leavereason'];
			$arr[3] = $_POST['leavetypeid']; 
			$arr[4] = Utils::getDateformat($_POST['resumptiondate']);
			$arr[5] = $mdate; 
			$arr[6] = $userid; 
			$arr[7] = $_POST['substitute'];
			$arr[8] = $_POST['emergencycontact'];
			$arr[9] = $_POST['dayseligible'];
			$arr[10] = $_POST['fromdaytype'];
			$arr[11] = $_POST['todaytype'];
			$arr[12] = $_POST['timeoffrom'];
			$arr[13] = $_POST['timeofto'];
			$arr[14] = $_POST['leaveid'];
			
			
		$sql = "UPDATE EmployeeLeave  SET  LeaveFrom=?, LeaveTo=?, LeaveReason=?, LeaveTypeId=?, ResumptionDate=?, LastModifiedDate=?, LastModifiedById=?,  SubstituteEmployeeId=?, EmergencyContact=?,LeaveValidDays=?, FromDayType=?,ToDayType=?,TimeOfFrom=?,TimeOfTo=? where Id=?";		
		
		
			$query = $this->db->prepare($sql);
			$query->execute($arr);
		
			$count =  $query->rowCount();		
		
		
        if ($count == 1) {
           $status =true;
		   $successMsg = EMPLOYEELEAVE_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = EMPLOYEELEAVE_MODULE_UPDATION_FAILED;
        }
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	////////////////////////for grievance table/////////////
	public function getGrievanceTable()
	{
		$sTable = 'GrievanceMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Message', 'ApproverId','Priority','ApproveSts', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$sWhere = "Where CreatedById='$empid' ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "	SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$view = '<a rel="tooltip" title="View" href="'.URL.'profile/viewGrievance/'.Utils::encode5t($aRow->Id).'/2"><i class="fa fa-eye"></i></a>';
					
					if($aRow ->ApproveSts == 3){
						$edit = '<a rel="tooltip"  title="Edit" href="'.URL.'profile/editgrievance/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					
					
						$delete ='<a rel="tooltip"  title="Delete" data-href="'.URL.'profile/deletegrievance/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
						
						
					
						$row[] =$view."&nbsp;&nbsp;|&nbsp;&nbsp;".$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
					}else{
					
						$row[] =$view;
					}
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'profile/viewGrievance/'.Utils::encode5t($aRow->Id).'/2">'.$aRow->{$aColumns[$i]}.'</a>';					
				}
				else if($aColumns[$i]=="ApproverId")
				{
					$desc=$this->getGrievanceComment($aRow->Id);
					$len=strlen($desc);
					if($len >20){
						$desc=substr($desc,0,20);
						$desc =	$desc.'...';
					}
									
					$row[] = $desc;
					
				}
				else if($aColumns[$i]=="Message")
				{
					
					$desc=$aRow->{$aColumns[$i]};
					$len=strlen($desc);
					if($len >100){
						$desc=substr($desc,0,100);
						$desc =	$desc.'...';
					}
									
					$row[] = $desc;
					
					
				}
				elseif($aColumns[$i]=="Priority")
				{
					$row[] = $this->getPriority($aRow->{$aColumns[$i]},'OtherMaster');
				}
				elseif($aColumns[$i]=="ApproveSts"){
					$row[] = Utils::getgrievancetype($aRow->{$aColumns[$i]});
				}	
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getActivityLogData()
	{
		$sTable = 'ActivityHistoryMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'ActionPerformed', 'Module', 'LastModifiedById','LastModifiedDate');
		$orgid = $_SESSION['ubihrm_org_id'];
		$empid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		if($_SESSION['ubihrm_user_sts']==1){
			$sWhere = "Where OrganizationId='$orgid' ";
		}else{
			$sWhere = "Where OrganizationId='$orgid' and LastModifiedById=$empid";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "	SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="LastModifiedById"){
					$row[] = Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "FirstName", $this->db)." ".Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "LastName", $this->db);
				}	
				elseif( $aColumns[$i]=="LastModifiedDate"){
					$row[] =Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getGrievanceComment($grievid)
	{
		$comments="";
		$sql = "SELECT ApproverComment FROM GrievanceApproval WHERE GrievanceId = ?  order by Id desc Limit 1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $grievid ));
		while($row = $query->fetch())
		{
			$comments=$row->ApproverComment;
		}
		
		return $comments;
	}
	///////////////////////////Time Off////////////////
	
	public function getTimeOffTable()
	{
		try{
		$result=array();
		$empid = $_SESSION['ubihrm_user_id'];
		$orgid= $_SESSION['ubihrm_org_id'];
		$sql = "SELECT * from Timeoff where EmployeeId=$empid and OrganizationId=$orgid order by TimeofDate desc";
        $query = $this->db->prepare($sql);
		$query->execute(array());
		while($row = $query->fetch())
		{
			$res=array();
			$createdate=$row->CreatedDate;
			$timeofdate=$row->TimeofDate;
			$res["date"]=Utils::dateformatter($createdate);
			$res["timeoffdate"]=Utils::dateformatter($timeofdate);
			$res["timefrom"]=$row->TimeFrom;
			$res["timeto"]=$row->TimeTo;
			$res["reason"]=$row->Reason;
			$pendingapprover=$this->getTimeOffApproversts($row->Id,3);
			$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);	
			
			$res["ApproverId"]=$pendingapp;
			$sts=$row->ApprovalSts;
			$res["sts"]=$sts;
			$res["comment"]=$row->ApproverComment;
			$res["id"]=$row->Id;
			$result[]=$res;
		}	
		return  $result ;
		}catch(Exception $e){ echo $e->getMessage();}
		
	}
	
	///////////////////////////////////profile leave///////////////
	public function getLeaveTable()
	{
		$sTable = 'EmployeeLeave';
		$sIndexColumn = "Id";
		$aColumns = array( 'LeaveTypeId','ApplyDate', 'LeaveFrom','LeaveTo','LeaveValidDays','LeaveStatus', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  LeaveFrom desc, ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			//$sOrder .=",ApplyDate desc";

			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
	/*	$date = date("Y-m");
		$startdate = $date."-01";
		$enddate  =  $date."-31";
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;
		}*/
		$sWhere = " WHERE EmployeeId=$empid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] !='')
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($i==1){
					$sWhere .= " (date(".$aColumns[$i].") between ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}	
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
	//	echo $sQuery;
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
					$view='<a rel="tooltip" title="View"  href="'.URL.'profile/viewLeave/'.Utils::encode5t($aRow->Id).'/2"><i class="fa fa-eye"></i></a>';
					
					if($aRow->LeaveStatus==3){
						$edit="<a rel='tooltip' href='".URL."profile/editleave/".Utils::encode5t($aRow->{$aColumns[$i]})."' Title='Edit'><i class='fa fa-edit' ></i></a>";
						$del='<a rel="tooltip"  onclick = "angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm1" title="Withdraw" href="#" ><i class="fa fa-undo"></i></a>';
						
						$row[]=$view ."&nbsp;&nbsp; | &nbsp;&nbsp; ".$edit ."&nbsp;&nbsp; | &nbsp;&nbsp; ".$del;
					}
					else if($aRow->LeaveStatus==2){
						if($aRow->LeaveTo > (date('Y-m-d'))){
							$row[]=$view.'&nbsp;&nbsp; | &nbsp;&nbsp;<a rel="tooltip"  onclick = "angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm1" title="Withdraw" href="#" ><i class="fa fa-undo"></i></a>';
						}else{
							$row[]=$view;
						}
					}else{
						$row[]=$view;
					}
				}
				else if($aColumns[$i]=="LeaveTypeId"){
					$row[]='<a href="'.URL.'profile/viewLeave/'.Utils::encode5t($aRow->Id).'/2">'.$this->getName($aRow->{$aColumns[$i]},'LeaveMaster').'</a>';
				}
				else if($aColumns[$i]=="ApprovedBy"){
					$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]},'EmployeeMaster');
				}
				else if($aColumns[$i]=="LeaveStatus"){
					if($aRow->{$aColumns[$i]}==3){
						$pendingapprover=$this->getApproversts($aRow->{$aColumns[6]},3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
				}
				elseif($aColumns[$i]=="ApplyDate")
				{
					$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="LeaveFrom" || $aColumns[$i]=="LeaveTo")
				{
					$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});					
				}				
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function UpdateTimeoffSts($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		try{
		 
			$sql = "UPDATE Timeoff SET ApprovalSts = ? WHERE  Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( 5,$id));
			$count =  $query->rowCount();
			Utils::Trace($sql." ".$id);
		if($count>=1)
		{
			 $status =true;
			
			 $successMsg="Timeoff application has been successfully withdrawn.";
			
        }
		
		else {
           $status =false;
		   $errorMsg="Timeoff application has been already withdrawn.";
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function UpdateLeaveSts($id,$val)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		try{
		 
			$sql = "UPDATE EmployeeLeave SET LeaveStatus = ? WHERE  Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $val,$id));
			$count =  $query->rowCount();
			$sql = "UPDATE EmployeeLeaveChild SET LeaveStatus = ? WHERE  EmployeeLeaveId = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $val,$id));
			
		
		if($count>=1)
		{
			 $status =true;
			 if($val==5)
			 $successMsg=EMPLOYEELEAVE_MODULE_WITHDRAW;
			 else
			 $successMsg=EMPLOYEELEAVE_MODULE_CANCEL;
        }
		
		else {
           $status =false;
		   $errorMsg=LEAVE_MODULE_UPDATION_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getSalaryadvanceTable()
	{
		$sTable = 'SalaryAdvance';
		$sIndexColumn = "Id";
		$aColumns = array(  'AdvanceAmount' ,'ApplyMonth' ,'InstallmentAmt', 'FiscalId','OrganizationId', 'LeaveStatus', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  LastModifiedDate desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = " ORDER BY LastModifiedDate desc";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;
		}
		$sWhere = " WHERE EmployeeId=$empid and ApplyMonth between '$startdate' and '$enddate' ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -4 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
					$view = '<a rel="tooltip" href="'.URL.'profile/viewSalaryadvance/'.Utils::encode5t($aRow->Id).'/2" title="View"><i class="fa fa-eye"></i></a>';
					if($aRow->LeaveStatus == 0){
					
						$row[]=$view."&nbsp;&nbsp;|&nbsp;&nbsp;<a href='".URL."profile/editsalaryadvance/".Utils::encode5t($aRow->{$aColumns[$i]})."'><i class='fa fa-edit'></i></a>";
					}else{
						$row[]=$view;
					}	
					
				}
				else if($aColumns[$i]=="AdvanceAmount")
				{
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="ApprovedBy"){
					if($aRow->ApprovedBy>0){
						$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$row[] = "Waiting for approval";
					}
				}
				elseif($aColumns[$i]=="OrganizationId" )
				{
					if($aRow->LeaveStatus==2){
						$balance = Utils::getOutstandingLoanAmount($empid,$aRow->Id, $orgid, $this->db);
						$balance=abs($balance);
						$row[] = Utils::numberformatter($balance);
					}else{
						$row[] ="-";
					}
				}
				elseif($aColumns[$i]=="FiscalId" )
				{
					if($aRow->LeaveStatus==2){
						$advance=$aRow->AdvanceAmount;
						$outstanding = Utils::getOutstandingLoanAmount($empid,$aRow->Id, $orgid, $this->db);
						$recover=abs($advance-$outstanding);
						$row[] = Utils::numberformatter($recover);
					}else{
						$row[] ="-";
					}
				}
				else if($aColumns[$i]=="ApplyMonth"){
					
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="LeaveStatus"){
					
					if($aRow->{$aColumns[$i]}=="3"){
						$pendingapprover=$this->getApproversts($aRow->Id,3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getSalaryadvanceloanTable()
	{
		$sTable = 'SalaryAdvanceLoan';
		$sIndexColumn = "Id";
		$aColumns = array(  'AdvanceAmount' ,'ApplyMonth' ,'InstallmentAmt', 'FiscalId','OrganizationId', 'LeaveStatus', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  LastModifiedDate desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = " ORDER BY LastModifiedDate desc";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;
		}
		$sWhere = " WHERE EmployeeId=$empid and ApplyMonth between '$startdate' and '$enddate' ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -4 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
					$view = '<a rel="tooltip" href="'.URL.'profile/viewSalaryadvanceloan/'.Utils::encode5t($aRow->Id).'/2" title="View"><i class="fa fa-eye"></i></a>';
					if($aRow->LeaveStatus == 0){
					
						$row[]=$view."&nbsp;&nbsp;|&nbsp;&nbsp;<a href='".URL."profile/editsalaryadvanceloan/".Utils::encode5t($aRow->{$aColumns[$i]})."'><i class='fa fa-edit'></i></a>";
					}else{
						$row[]=$view;
					}	
					
				}
				else if($aColumns[$i]=="AdvanceAmount")
				{
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="ApprovedBy"){
					if($aRow->ApprovedBy>0){
						$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$row[] = "Waiting for approval";
					}
				}
				elseif($aColumns[$i]=="OrganizationId" )
				{
					if($aRow->LeaveStatus==2){
						$balance = Utils::getOutstandingLoanAmountsalary($empid,$aRow->Id, $orgid, $this->db);
						$balance=abs($balance);
						$row[] = Utils::numberformatter($balance);
					}else{
						$row[] ="-";
					}
				}
				elseif($aColumns[$i]=="FiscalId" )
				{
					if($aRow->LeaveStatus==2){
						$advance=$aRow->AdvanceAmount;
						$outstanding = Utils::getOutstandingLoanAmountsalary($empid,$aRow->Id, $orgid, $this->db);
						$recover=abs($advance-$outstanding);
						$row[] = Utils::numberformatter($recover);
					}else{
						$row[] ="-";
					}
				}
				else if($aColumns[$i]=="ApplyMonth"){
					
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
					
				}
				elseif($aColumns[$i]=="LeaveStatus"){
                    
					if($aRow->{$aColumns[$i]}==3){
						$pendingapprover=$this->getApproverPendingSts($aRow->Id,3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
                 }
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getApproverPendingSts($id,$sts)
		{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM SalaryApprovalLoan where SalaryAdvanceId=? and LeaveStatus=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM SalaryApprovalLoan where SalaryAdvanceId=? and LeaveStatus=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					$name = $row->ApproverId;
				}
			}catch(Exception $e) {}

			return $name;
		}
	
	/**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    
	
	/**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
	public function uploadLeaveImage($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$leaveid = $request[2];
		$empid = Utils::getName($leaveid,'EmployeeLeave','EmployeeId',$this->db);
		$empcode=$this->getCode($empid);
		$new_name="";
		
		if (!file_exists("public/uploads/$orgid/$empcode")) {
			mkdir("public/uploads/$orgid/$empcode" ,  0755,true);
		}
		
		$dir="public/uploads/$orgid/$empcode";
		
		$filename="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				/* if ($ext=='png' || $ext=='jpg' || $ext=='gif' || $ext=='MOV' || $ext=='ico' || $ext=='tif') */
				if(true)
				{
					
					$new_name=$empcode."_".$leaveid.".".$ext;
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/$orgid/$empcode/";
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						move_uploaded_file($file_tmp, $location.$new_name);
						
					}
					else{
						print_r($errors);
					}
				}
				else{
					$status =false;
					$successMsg = "Choose Only Image Format..";
				}				
			}
			
			
			   $status =true;
			   $successMsg = "Leave attachment uploaded successfully..";
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}
	
	public function getDocument($id,$table)
	{
		$name ="";
		$sql = "SELECT DocumentTypeId FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$docid = $row->DocumentTypeId;
				$sql1 = "SELECT Name FROM DocumentMaster WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $docid ));
				if($row1= $query1->fetch())
				{
					$name=$row1->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDocumentRequestTableData()
	{
		$sTable = 'DocumentReleaseMaster';
		$sIndexColumn = "Id";
		$aColumns = array('RequestDocId', 'ReleaseFrom'  ,'ReleaseTo','ApproverSts', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;
		}
		$sWhere = " WHERE EmployeeId = $empid AND OrganizationId = $orgid and CreatedDate between '$startdate' and '$enddate' ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				
					$edit="";
					if($aRow->ApproverSts==3){
						$edit = '<a data-toggle="tooltip" title="Edit" href="'.URL.'profile/editdocumentrequest/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
					
						/*$delete ='<a data-href="'.URL.'employee/deleteofficialcommunication/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';*/
								
					$row[] =$edit;
				}
				
				else if($aColumns[$i]=="ReleaseFrom" || $aColumns[$i]=="ReleaseTo"){
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[] ="";
					}else{
						$row[] =Utils::dateformatter($aRow->{$aColumns[$i]});
					}	
					
				}
				elseif($aColumns[$i]=="RequestDocId")
				{
					$row[] =  $this->getName($aRow->{$aColumns[$i]},'DocumentMaster');
					
				}else if($aColumns[$i]=="ApproverSts"){
					
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getOfficialCommunicationTable()
	{
		$sTable = 'OfficLetterMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Title', 'CreatedDate','Id');
		$userid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;
		}
		
		$sWhere = " WHERE  (OrganizationId= $orgid AND FIND_IN_SET($userid, EmployeeId )>0 ) and CreatedDate between '$startdate' and '$enddate'";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					
						$edit = '<a rel="tooltip" title="View" href="'.URL.'profile/viewofficialcommunication/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/1" ><i class="fa fa-eye"></i></a>';
					
					
						/*$delete ='<a data-href="'.URL.'employee/deleteofficialcommunication/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';*/
								
					$row[] =$edit;
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] =Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				else if($aColumns[$i]=="Title")
				{
					$row[] = '<a href="'.URL.'profile/viewofficialcommunication/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					//$eid=explode(',',$aRow->{$aColumns[$i]});
					//$row[]=count($eid);
					$displayname="Subordinate(s)";
					$eid=explode(',',$aRow->{$aColumns[$i]});
					for($x=0; $x<count($eid); $x++)
					{
						if($userid==$eid[$x]){
							$displayname="You";
						}
					}
					
					$row[]=$displayname;
					
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getAssessmentTable()
	{
		$sTable = 'EmployeeAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','AssessmentType' ,'FromDate','ToDate', 'AssessmentSts', 'DesignationLevel', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		$sWhere = " Where EmployeeId = $userid AND OrganizationId= $orgid ";
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					if($aRow->AssessmentSts==1 ){
						$edit = '<a rel="tooltip" title="View Assessment" href="'.URL.'profile/viewassessment/'.Utils::encode5t($aRow->Id).'/1" ><i class="fa fa-eye"></i></a>';
					}else{
						$sts = $this->getEmployeeAssessmentPending($aRow->Id, $userid);
						if($sts ){
							$edit = '<a rel="tooltip" title="Self Assessment" href="'.URL.'profile/viewassessment/'.Utils::encode5t($aRow->Id).'/1" ><i class="fa fa-edit"></i></a>';
						}else{
							$edit = '<a rel="tooltip" title="View Assessment" href="'.URL.'profile/viewassessment/'.Utils::encode5t($aRow->Id).'/1" ><i class="fa fa-eye"></i></a>';
						}
					}
					
								
					$row[] =$edit;
				}
				else if($aColumns[$i]=="AssessmentType")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[]=Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "FirstName", $this->db);
				}
				else if($aColumns[$i]=="AssessmentSts")
				{
					$img = "<img src='".URL."public/dist/img/Red-icon.png' rel='tooltip' title='Not Started'/>";
					if($aRow->{$aColumns[$i]}==1){
						$img="<img src='".URL."public/dist/img/Green-icon.png' rel='tooltip' title='Assessment completed'/>";
					}else{
						$sts = $this->getEmployeeAssessmentRunning($aRow->Id);
						if($sts){
							$img = "<img src='".URL."public/dist/img/Yellow-icon.png' rel='tooltip' title='Assessment in progress'/>";
						}
					}
					$row[]= $img;
				}
				else if($aColumns[$i]=="DesignationLevel")
				{
					$row[]='Level '.$this->getEmployeeAssessmentPendingAtLevel($aRow->Id) ;
				}
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate")
				{
					$row[]=Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getAssessmentkpiTable()
	{
		$sTable = 'EmployeeAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','AssessmentType' ,'FromDate','ToDate', 'AssessmentSts', 'DesignationLevel', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		$sWhere = " Where EmployeeId = $userid AND OrganizationId= $orgid ";
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					if($aRow->AssessmentSts==1 ){
						$edit = '<a rel="tooltip" title="View Assessment" href="'.URL.'profile/viewassessmentkpi/'.Utils::encode5t($aRow->Id).'/2" ><i class="fa fa-eye"></i></a>';
					}else{
						$sts = $this->getEmployeeAssessmentPending($aRow->Id, $userid);
						if($sts ){
							$edit = '<a rel="tooltip" title="Self Assessment" href="'.URL.'profile/viewassessmentkpi/'.Utils::encode5t($aRow->Id).'/1" ><i class="fa fa-thumbs-up "></i></a>';
						}else{
							$edit = '<a rel="tooltip" title="View Assessment" href="'.URL.'profile/viewassessmentkpi/'.Utils::encode5t($aRow->Id).'/2" ><i class="fa fa-eye"></i></a>';
						}
					}
					
								
					$row[] =$edit;
				}
				else if($aColumns[$i]=="AssessmentType")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[]=Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "FirstName", $this->db);
				}
				else if($aColumns[$i]=="AssessmentSts")
				{
					$img = "<img src='".URL."public/dist/img/Red-icon.png' rel='tooltip' title='Not Started'/>";
					if($aRow->{$aColumns[$i]}==1){
						$img="<img src='".URL."public/dist/img/Green-icon.png' rel='tooltip' title='Assessment completed'/>";
					}else{
						$sts = $this->getEmployeeAssessmentRunning($aRow->Id);
						if($sts){
							$img = "<img src='".URL."public/dist/img/Yellow-icon.png' rel='tooltip' title='Assessment in progress'/>";
						}
					}
					$row[]= $img;
				}
				else if($aColumns[$i]=="DesignationLevel")
				{
					$row[]='Level '.$this->getEmployeeAssessmentPendingAtLevel($aRow->Id) ;
				}
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate")
				{
					$row[]=Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getEmployeeAssessmentPendingAtLevel($assessid)
	{
		$level = 0;
		$sql1 = "SELECT EmployeeId, AssessmentSts FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				while( $row = $query1->fetch())
				{
					$level++;
					if($row->AssessmentSts==0)
					break;
				}
			}catch(Exception $e) {
			}
		return $level;
	}
	public function getEmployeeAssessmentPending($assessid, $empid)
	{
		$flg =false;
		$sql = "Select Designation from EmployeeMaster Where Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array( $empid  ));
		while($row = $query->fetch())
		{
			$desigid = $row->Designation;
			
			$sql1 = "SELECT EmployeeId FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ? and DesignationId=? and AssessmentSts=0";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid, $desigid  ));
				if($query1->rowCount()>0)
				{
					$flg =true;
				}
			}catch(Exception $e) {
				
				}
		}
		return $flg;
	}
	
	public function getEmployeeAssessmentRunning($assessid)
	{
		$flg =false;
		$sql1 = "SELECT EmployeeId FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ?  and AssessmentSts=1";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				if($query1->rowCount()>0)
				{
					$flg =true;
				}
			}catch(Exception $e) {
				
				}
		return $flg;
	}
	
	///////////////change password////////////
	
	public function getEmployeeResignation($request)
    {         
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        		
		$sql = "SELECT * FROM EmployeeRegination WHERE EmployeeId=? AND OrganizationId=? AND ResignationStatus<>0";	
               $query = $this->db->prepare($sql);
               
		try{
			$userid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid 	  = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($userid, $orgid));			
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
                              
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
        if ($count == 1) 
        {
        	while($row = $query->fetch())
        	{	   
			$res = array();
			$res['id'] = $row->Id;
			$res['subject'] = $row->ResignSubject;
			$res['message'] = $row->ResignMessage;
			$res['noticeperiod'] = $row->NoticeDuration;
			$res['fdate'] = Utils::dateformatter($row->NoticeStart);
			$res['tdate'] = Utils::dateformatter($row->NoticeEnd);
			$res['resignsts'] = $row->ResignationStatus;
			$data[] = $res;
		}
		              	   
        	$status =true;
		$successMsg = "Your Resignation detail fatched successfully !";
	   
	} else {
	
	   $status =false;
	   $errorMsg = "There is some problem while fetching resignation detail !";
	}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getEmployeeResignationreason()
    {         
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        		
		$sql = "SELECT * FROM OtherMaster WHERE OtherType='SeveranceReason' AND ActualValue < 20 AND ActualValue<>0";	
        $query = $this->db->prepare($sql);
               
		try{
			
			$query->execute();			
			$count =  $query->rowCount();
		
        if ($count > 1) 
        {
        	while($row = $query->fetch())
        	{	   
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = $row->DisplayName;
			$res['value'] = $row->ActualValue;
			
			$data[] = $res;
		}
		              	   
        $status =true;
		$successMsg = "Detail fatched successfully !";
	   
	} else {
	
	   $status =false;
	   $errorMsg = "There is some problem while fetching detail !";
	}
	}catch(Exception $e) {
                              
			$errorMsg = 'Message: ' .$e->getMessage();
		}	
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
		public function getNoticePeriod()
		{   
			$orgid=$_SESSION['ubihrm_org_id'];
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$sql = "SELECT * FROM SettingChild WHERE SettingId=8 AND OrganizationId=?";	
			$query = $this->db->prepare($sql);               
			try{
			$query->execute(array($orgid));			
			$count =  $query->rowCount();
			if ($count >= 1) 
			{
				if($row = $query->fetch())
				{
					$date=$result['noticeperiod'] = $row->ExecutionValue; 			
					$result['lastworkingday'] = Utils::dateformatter(date('Y-m-d', strtotime("+$date days")));
				}		              	   
			$status =true;
			$successMsg = "Detail fatched successfully !";	   
			}else {
			   $status =false;
			   $errorMsg = "There is some problem while fetching detail !";
			}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}	
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']=$errorMsg;
			// default return
			return $result;
		}
	
	public function EmployeeResignation($request)
    {         
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$startdate=''; $enddate=''; $resignationid=0;
		$data = array();
		        
		$mdate = date("Y-m-d H:i:s");
		
		//$date = date('Y-m-d H:i:s',strtotime($mdate.' +'.$noticeperiod.' days');
		
		
		$sql = "INSERT INTO EmployeeRegination (EmployeeId, ResignSubject, ResignMessage, NoticeDuration, NoticeStart, NoticeEnd, CreatedDate , CreatedById, OrganizationId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";	
               $query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$subject = $request[2];
			$message = $request[3];
			$noticeperiod = $request[4];
			$startdate= date("Y-m-d");
			$enddate = date('Y-m-d', strtotime($startdate.' +'.$noticeperiod.' months'));
			
			$query->execute(array($mid, $subject, $message, $noticeperiod, $startdate, $enddate, $mdate, $mid, $orgid));			
			echo$count =  $query->rowCount();
			$resignationid=$result['id'] = $this->db->lastInsertId();
		}catch(Exception $e) {
                              
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		///////////////// Insert record of resignation in Employee history /////////////
		
		$sql1 = "INSERT INTO EmployeeHistory (EmployeeId, Title, EventDate, Message, OrganizationId) VALUES (?, ?, ?, ?, ?)";	
               $query1 = $this->db->prepare($sql1);
		
		try{
			
			$title='Job Resignation';
			$msg = 'Send a job resignation letter';
						
			$query1->execute(array($request[0], $title, $mdate, $msg, $request[1]));			
			$count1 =  $query1->rowCount();
			
		}catch(Exception $e) {
                              
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		////////////////////////////////////////////////////////////////////////////////
		
        if ($count == 1) {
			   $status =true;
			   $successMsg = RESIGNATION_MODULE_SENT;
			   
			  
				$senior = Utils::getApprovalLevelEmp($mid, 1, $this->db);
				if($senior!=0)
				{
					$temp = explode(",", $senior);
					for($i=0; $i<count($temp); $i++)
					{
						$sql = "INSERT INTO ResignationApproval ( ResignationId, ApproverId, LeaveStatus, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($resignationid, $temp[$i], 3, $mdate, $orgid));
					}
				}
			} else {
			   $status =false;
			   $errorMsg = RESIGNATION_MODULE_UPDATION_FAILED;
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	///////////////////////////////// profile issued assets/////////
	public function getPendingNotificationTable()
	{
		$sTable = 'GenerateNotification';
		$sIndexColumn = "Id";
		$aColumns = array(  'Title','Message','NotifyDate','VisibleSts','Id');
				
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  NotifyDate desc ,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		
		$sWhere = "";
		$empid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		//$ids = Utils::getReportingIds($empid, $this->db);
		
		$sWhere = " WHERE EmployeeId = $empid and OrganizationId = $orgid AND  NotifyDate <=CURDATE() AND VisibleSts<>4";
		
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					if($aRow->VisibleSts == 2){
						$edit = '<a rel="tooltip"  title="Dont Show Again"   onclick="angular.element(this).scope().setnotifysts('.$aRow->Id.',0)" ><i class="fa fa-bell"></i></a>';
					}
					else{
						$edit = '<a rel="tooltip"  title="Visibility off" href="#" ><i class="fa fa-bell-slash-o"></i></a>';
						
					}
					
					$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().setnotifysts('.$aRow->Id.',4)"  ><i class="fa fa-trash"></i></a>';
								
					$row[] =$edit;//.'&nbsp;&nbsp;|&nbsp;&nbsp;'.$delete;
					
				}
				elseif($aColumns[$i]=="EmployeeId")
				{
					$row[]=self::getEmployeeName($aRow->{$aColumns[$i]});
				
				}
				elseif($aColumns[$i]=="NotifyDate" ){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="VisibleSts" ){
					if($aRow->{$aColumns[$i]} == 2){
					$row[] = "<span class='badge bg-green'>Visible</span>";
					}else{
					$row[] = "<span class='badge bg-red'>Not Visible</span>";
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	////////deleting pop-up notifications///////////
	 public function DeleteNotify($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM GenerateNotification WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = EMPLOYEELEAVE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = EMPLOYEELEAVE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	 public function DeleteTimeSheet($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$userid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "DELETE FROM timesheet_master WHERE id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count >=1) {
			$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
			$msg="$empname had deleted the timesheet filled for  Task [task name]";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($userid, "Self Service", $msg, $orgid));
           $status =true;
		   $successMsg = "Task deleted successfully";
        }else {
           $status =false;
		   $errorMsg = "Problem while deleting task";
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
	
		
        // default return
        return $result;
    }
	
	public function getCertificateRequestTable()
	{
		$sTable = 'CertificateReleaseMaster';
		$sIndexColumn = "Id";
		$aColumns = array('RequestDocId','Address_to','ApproverSts',  'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = " WHERE EmployeeId = $empid AND OrganizationId = $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
					if($aRow->ApproverSts ==3){
						$edit = '<a data-toggle="tooltip" title="Edit" href="'.URL.'profile/editcertificaterequest/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					
					}
					else{
						$edit = "";
					}
						/*$delete ='<a data-href="'.URL.'employee/deleteofficialcommunication/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';*/
								
					$row[] =$edit;
				}
				
				else if($aColumns[$i]=="ApproverSts" ){
					
					$row[] =Utils::getleavetype($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="RequestDocId")
				{
					$row[] =  Utils::getName($aRow->{$aColumns[$i]},'CertificateLetter','Name',$this->db);
					
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	////////////////////////claim /////////////////////
	public function getClaimData()
	{
		$sTable = 'ClaimsMaster';
		$sIndexColumn = "Id";
		$aColumns = array('FromDate'  ,'ToDate','Purpose','TotalAmt','ApproverSts', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;
		}
		$sWhere = " WHERE EmployeeId = $empid AND OrganizationId = $orgid and CreatedDate between '$startdate' and '$enddate' ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				
					$edit="";
					if($aRow->ApproverSts==3){
						$edit = '<a data-toggle="tooltip" title="Edit" href="'.URL.'profile/editclaim/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
					
						/*$delete ='<a data-href="'.URL.'employee/deleteofficialcommunication/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';*/
								
					$row[] =$edit;
				}
				
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate"){
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[] ="";
					}else{
						$row[] =Utils::dateformatter($aRow->{$aColumns[$i]});
					}	
					
				}
				elseif($aColumns[$i]=="RequestDocId")
				{
					$row[] =  $this->getName($aRow->{$aColumns[$i]},'DocumentMaster');
					
				}else if($aColumns[$i]=="ApproverSts"){
					if($aRow->{$aColumns[$i]}==3){
						$pendingapprover=$this->getApproverstsname($aRow->Id,3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
					//$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	///// to find out the approver on which the Claim is pending //////
	public function getApproverstsname($id,$sts)
	{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM ClaimApproval where ClaimId=? and ApproverSts=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM ClaimApproval where ClaimId=? and ApproverSts=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					 $name = $row->ApproverId;
				}
			}catch(Exception $e) {

			}

			return $name;
		}
	
	//////////////////////resignation severance last working day//////
	public function getLastWorkingDate($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $setting=0;
		$noticeperioddays=$request[2];
		try{
		$currentdate=strtotime(date('Y-m-d'));
		$lastwd=date('Y-m-d', strtotime("+".$noticeperioddays." days",$currentdate));
		$res=array();
		$res['value'] = Utils::dateformatter($lastwd);
						
		$data[] = $res;
			}catch(Exception $e){}
		$status=true;
		$successMsg = EMPSTATUS_MODULE_GETALL;
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getTimesheetData()
	{
		$sTable = 'timesheet_master';
		$sIndexColumn = "id";
		
		$aColumns = array( 'project_id' ,'task_name' ,'timesheet_date','start_time', 'end_time','total_time', 'time_status', 'id');
		$empid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY updated_date desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = " ORDER BY updated_date desc";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		
		$sWhere = " WHERE EmployeeId=$empid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -4 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
					$view = '<a rel="tooltip" href="'.URL.'profile/viewSalaryadvance/'.Utils::encode5t($aRow->Id).'/2" title="View"><i class="fa fa-eye"></i></a>';
					if($aRow->LeaveStatus == 0){
					
						$row[]=$view."&nbsp;&nbsp;|&nbsp;&nbsp;<a href='".URL."profile/editsalaryadvance/".Utils::encode5t($aRow->{$aColumns[$i]})."'><i class='fa fa-edit'></i></a>";
					}else{
						$row[]=$view;
					}	
					
				}
				else if($aColumns[$i]=="AdvanceAmount")
				{
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="ApprovedBy"){
					if($aRow->ApprovedBy>0){
						$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$row[] = "Waiting for approval";
					}
				}
				elseif($aColumns[$i]=="OrganizationId" )
				{
					if($aRow->LeaveStatus==2){
						$balance = Utils::getOutstandingLoanAmount($empid,$aRow->Id, $orgid, $this->db);
						$balance=abs($balance);
						$row[] = Utils::numberformatter($balance);
					}else{
						$row[] ="-";
					}
				}
				elseif($aColumns[$i]=="FiscalId" )
				{
					if($aRow->LeaveStatus==2){
						$advance=$aRow->AdvanceAmount;
						$outstanding = Utils::getOutstandingLoanAmount($empid,$aRow->Id, $orgid, $this->db);
						$recover=abs($advance-$outstanding);
						$row[] = Utils::numberformatter($recover);
					}else{
						$row[] ="-";
					}
				}
				else if($aColumns[$i]=="ApplyMonth"){
					
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="LeaveStatus"){
					
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getProjectData()
	{
		$sTable = 'project_master';
		$sIndexColumn = "id";
		
		$aColumns = array( 'project_title' ,'owner_id','start_date' ,'completed_date','project_status', 'id');
		$empid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY update_on desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = " ORDER BY update_on desc";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		
		$sWhere = " WHERE (owner_id=$empid or find_in_set($empid,assigned_to))";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -4 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
					$view = '<a rel="tooltip" href="'.URL.'profile/viewproject/'.Utils::encode5t($aRow->id).'/1" title="View"><i class="fa fa-eye"></i></a>';
					
						if($aRow->owner_id!=$empid){
							///if user is the owner then edit will be different ,and projectis assign to user then edit will different///
							$row[]=$view."&nbsp;&nbsp;|&nbsp;&nbsp;<a href='".URL."profile/ViewTimesheet/".Utils::encode5t($aRow->{$aColumns[$i]})."/1' title='update'><i class='fa fa-edit'></i></a>";
						}else{
							$row[]=$view."&nbsp;&nbsp;|&nbsp;&nbsp;<a href='".URL."profile/editproject/".Utils::encode5t($aRow->{$aColumns[$i]})."' title='update'><i class='fa fa-edit'></i></a>";
						}
				}
				
				else if($aColumns[$i]=="owner_id"){
					if($aRow->owner_id!=$empid){
						$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]},'EmployeeMaster');;
					}
				}
				
				else if($aColumns[$i]=="start_date" || $aColumns[$i]=="completed_date"){
					
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="project_status"){
					
					if($aRow->{$aColumns[$i]}==1)
						$sts="<span class='label label-success'>Running</span>";
					else if($aRow->{$aColumns[$i]}==2)
						$sts="<span class='label label-warning'>Absconded</span>";
					else if($aRow->{$aColumns[$i]}==3)
						$sts="<span class='label label-danger'>Finished</span>";
					else if($aRow->{$aColumns[$i]}==4)
						$sts="<span class='label label-info'>Re open</span>";
					else if($aRow->{$aColumns[$i]}==5)
						$sts="<span class='label label-primary'>Not begin</span>";
					$row[] = $sts;
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	////////////TimeSheet //////////////////
	public function getAlltask($request)
    {
		
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		
		$mid= $request[0];
		$orgid=$request[1];
		$type=$request[2];
		$datetime='';
		$mdate = date('Y-m-d');
		$date = isset($request[3])?$request[3]:"";
		if($date!=""){
			$date = str_replace('/','-',$date);
			$date= date('Y-m-d',strtotime($date));
		}
		
		try{
			if($date){
				$mdate=$date;
				if($type=="previous")
				{
					$mdate = date('Y-m-d',strtotime(($mdate).'- 1 day'));
					
				}
				else if($type=="next")
				{
					$mdate = date('Y-m-d',strtotime('+1 day'.','.($mdate)));
					
				}
			}
			
			$sql2 = "SELECT * FROM timesheet_master WHERE OrganizationId = ? and EmployeeId=? and ? between date(start_time) and date(end_time)";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($orgid,$mid,$mdate));
			$count =  $query2->rowCount();
			$datetime=Utils::dateformatter($mdate);
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row1 = $query2->fetch())
				{$minutes='';$hours='';$days='';
					$res= array();
					$res['id']=$row1->id;
					$res['date']=Utils::dateformatter($mdate);
					$res['priority']=$row1->priority;
					$res['project_id1']=$row1->project_id;
					$res['project_id']=Utils::getName($row1->project_id,'project_master','project_title',$this->db);
					$res['task_id1']=$row1->task_id;
					$res['desc']=$row1->description;
					
					if($row1->task_id==0){
						$res['task_id']="Other Task";
					}else{
					$res['task_id']=Utils::getName($row1->task_id,'task_master','task_title',$this->db);
					}
					$res['assignby']=Utils::getName($row1->assigned_by,'EmployeeMaster','FirstName',$this->db);
					$res['EmployeeId']=$row1->EmployeeId;
					$res['start_time']=Utils::datetimeformatter($row1->start_time);
					$res['end_time']=Utils::datetimeformatter($row1->end_time);
					
					
					$res['sstartdate']=Utils::datetimeformatter($row1->timesheetstart);
					$res['senddate']=Utils::datetimeformatter($row1->timesheetend);
					
					if($row1->timesheetstart=='0000-00-00 00:00:00'){
						$res['sstartdate']="";
					}
					if($row1->timesheetend=='0000-00-00 00:00:00'){
						$res['senddate']="";
					}
					
					$start_date = new DateTime($row1->timesheetstart);
					$since_start = $start_date->diff(new DateTime($row1->timesheetend));
					if($since_start->d>0){
						$days=$since_start->d.' days';
					}
					
					if($since_start->h>0){
						$hours = $since_start->h.' hours';
					}
					
					if($since_start->i>0){
						$minutes = $since_start->i.' minutes';
					}
					$res['totaltime1']= $days.' '.$hours.' '.$minutes;
					$res['totaltime']= $row1->total_time;
					//$res['obtainmarks']=0;
					$data[]=$res;
				}
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if ($count >= 1) {
			$status =true;
			$successMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_SUCCESS;
		} else {
			$status =false;
			$errorMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_FAILED;
		}
		$result["data"] =$data;
		$result["datetime"] =$datetime;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
    }
	public function getUnassigntask($request)
	{
		$sTable = 'timesheet_master';
		$sIndexColumn = "id";
		$userid = $request[0];
		$aColumns = array( 'project_id', 'task_id','description','timesheetstart','start_time','end_time','total_time','id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY id desc ,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
		
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}/* else{
			$sOrder = "ORDER BY  EmployeeId";
		} */
		$orgid=$request[1];
		
		$sWhere = "";
		$sWhere = " Where OrganizationId =$orgid and EmployeeId=$userid and assigned_by =$userid ";
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="project_id"){
				$sWhere .= " (project_id in ( select id from project_master where project_title LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}else if($aColumns[$i]=="task_id"){
				$sWhere .= " (task_id in ( select id from task_master where task_title LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				
				if($i==3){
					$sWhere .= "(".($_GET['sSearch_'.$i]).")";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array(); $flg=false;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
					
						$row[] = '<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
				}
				elseif($aColumns[$i]=="task_id"  )
				{
					if($aRow->{$aColumns[$i]}==0){
						$row[] = "Other";
					}else{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'task_master','task_title',$this->db);
					}
				}
				elseif($aColumns[$i]=="project_id"  )
				{
					if($aRow->{$aColumns[$i]}==0){
						$row[] = "Other";
					}else{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'project_master','project_title',$this->db);
					}
				}elseif($aColumns[$i]=="timesheetstart")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}elseif($aColumns[$i]=="start_time" || $aColumns[$i]=="end_time" || $aColumns[$i]=="total_time")
				{
					
					if($aRow->{$aColumns[$i]}!='00:00:00')
					$row[] = date('H:i', strtotime($aRow->{$aColumns[$i]}));
					else
						$row[]='-';
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	/* public function getUnassigntask($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		
		$mid= $request[0];
		$orgid=$request[1];
		$type=$request[2];
		$datetime='';
		$mdate = date('Y-m-d');
		$date = isset($request[3])?$request[3]:"";
		if($date!=""){
			$date = str_replace('/','-',$date);
			$date= date('Y-m-d',strtotime($date));
		}
		try{
			if($date){
				$mdate=$date;
				if($type=="previous")
				{
					$mdate =date("Y-m-d",strtotime("-1 day ".date($mdate)));
					
				}
				else if($type=="next")
				{
					$mdate =date("Y-m-d",strtotime("+1 day ".date($mdate)));
				}
			}
			$sql2 = "SELECT * FROM timesheet_master WHERE OrganizationId = ? and EmployeeId=? and ? between date(timesheetstart) and date(timesheetend) and assigned_by =? order by timesheetstart";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($orgid,$mid,$mdate,$mid));
			//Utils::Trace($sql2." ".$orgid." ".$mid." ".$mdate." ".$mid);
			$count =  $query2->rowCount();
			$datetime=Utils::dateformatter($mdate);
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row1 = $query2->fetch())
				{
					$minutes='';$hours='';$days='';
					$res= array();
					$res['id']=$row1->id;
					$res['date']=Utils::dateformatter($mdate);
					$res['priority']=$row1->priority;
					$res['project_id1']=$row1->project_id;
					$pid=$row1->project_id;
					if($pid==0){
						$res['project_id']="Other";
					}else{
					$res['project_id']=Utils::getName($row1->project_id,'project_master','project_title',$this->db);
					}
					$res['task_id1']=$row1->task_id;
					//$res['task_name']=$row1->task_name;
					$res['desc']=$row1->description;
					if($row1->task_id==0){
						$res['task_id']="Other Task";
					}else{
					$res['task_id']=Utils::getName($row1->task_id,'task_master','task_title',$this->db);
					}
					$res['EmployeeId']=$row1->EmployeeId;
					$res['start_time']=Utils::datetimeformatter($row1->start_time);
					$res['end_time']=Utils::datetimeformatter($row1->end_time);
					if($row1->timesheetstart!=""){
						$timesheetstart= explode(" ",$row1->timesheetstart);
						//print_r($timesheetstart);
						$res['sstartdate']=date('H:i:s A',strtotime($timesheetstart[1]));
					}if($row1->timesheetend!=""){
						$timesheetend= explode(" ",$row1->timesheetend);
						//print_r($timesheetend);
						$res['senddate']=date('H:i:s A',strtotime($timesheetend[1]));
					}
					
					//$res['sstartdate']=Utils::datetimeformatter($row1->timesheetstart);
					//$res['senddate']=Utils::datetimeformatter($row1->timesheetend);
					
					$createddate=$row1->created_date;
					$newDate = date("d-m-Y", strtotime($createddate));
					$currentdate=date("d-m-Y");
					if($newDate==$currentdate){
						$res['delete']=true;
					}else{
						$res['delete']=false;
					}
					
					if($row1->timesheetstart=='0000-00-00 00:00:00'){
						$res['sstartdate']=Utils::datetimeformatter($row1->start_time);
					}
					if($row1->timesheetend=='0000-00-00 00:00:00'){
						$res['senddate']=Utils::datetimeformatter($row1->end_time);
					}
					
					$start_date = new DateTime($row1->timesheetstart);
					$since_start = $start_date->diff(new DateTime($row1->timesheetend));
					if($since_start->d>0){
						$days=$since_start->d.' days';
					}
					
					if($since_start->h>0){
						$hours = $since_start->h.' hours';
					}
					
					if($since_start->i>0){
						$minutes = $since_start->i.' minutes';
					}
					$res['totaltime1']= $days.' '.$hours.' '.$minutes;
					$res['totaltime']= $row1->total_time;
					//$res['obtainmarks']=0;
					$data[]=$res;
				}
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if ($count >= 1) {
			$status =true;
			$successMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_SUCCESS;
		} else {
			$status =false;
			$errorMsg = "dsd";
		}
		$result["data"] =$data;
		$result["datetime"] =$datetime;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
    }
	 */
	public function UpdateTimesheet($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		try{
			$mid   = $request[0];//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$work = json_decode($_POST['timesheet'], true); 
			for($i=0; $i<count($work); $i++)
			{
				$projectid = $work[$i]['project_id1'];
				$taskid = $work[$i]['task_id1'];
				$totaltime = $work[$i]['totaltime'];
				$sstartdate = Utils::getDateTimeformat($work[$i]['sstartdate']);
				$senddate = Utils::getDateTimeformat($work[$i]['senddate']);
				$sqlsalary = "UPDATE timesheet_master SET timesheetstart=?, timesheetend=?, updated_date=? ,total_time=? where project_id=? and  EmployeeId =? and task_id=? ";
								
				$querysalary = $this->db->prepare($sqlsalary);
				$querysalary->execute(array($sstartdate,$senddate,$mdate,$totaltime ,$projectid,$mid,$taskid));
				$count =  $querysalary->rowCount();
					
				
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if ($count>= 1) {
			$status =true;
			$successMsg = "Project has been updated successfully";
		}
		else{
			 $status =false;
			 $errorMsg = BANK_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	//////Save TimeSheet By Self Serivce///////////////
	public function AddSelfTimesheet($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		try{
			$mid   = $request[0];//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$projectid = isset($_POST['projectid'])?$_POST['projectid']:0; 
			$taskid = isset($_POST['taskid'])?$_POST['taskid']:0; 
			$val = isset($_POST['val'])?$_POST['val']:0; 
			$startdate = isset($_POST['startdate'])?Utils::getDateformat($_POST['startdate']):""; 
			//$endate = isset($_POST['endate'])?Utils::getDateTimeformat($_POST['endate']):""; 
			$timeduration = isset($_POST['timeduration'])?$_POST['timeduration']:"";
			$starttime = isset($_POST['starttime'])?$_POST['starttime']:"";
			$endtime = isset($_POST['endtime'])?$_POST['endtime']:"";
			$hourssts = isset($_POST['hourssts'])?$_POST['hourssts']:"";
			if($_POST['endtime']!="" && $_POST['starttime']!="") {
				$datetime1 = new DateTime($starttime);
				$datetime2 = new DateTime($endtime);
				$interval = $datetime1->diff($datetime2);
				$timeduration= $interval->format('%H:%I:%S');
			}
			else{
				$timeduration = isset($_POST['timeduration'])?$_POST['timeduration']:"";
			}
			$newmindate= date('M d, Y ', strtotime($startdate));
			$desc = isset($_POST['desc'])?$_POST['desc']:"";
			$sqlsalary = " INSERT INTO timesheet_master (project_id,task_id, EmployeeId, created_date, updated_date , start_time, end_time, timesheetstart,hourssts,total_time, OrganizationId,assigned_by,description) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
			$querysalary = $this->db->prepare($sqlsalary);
			$querysalary->execute(array($projectid,$taskid,$mid,$mdate,$mdate,$starttime,$endtime,$startdate,$hourssts,$timeduration,$orgid,$mid,$desc));
			$count=$querysalary->rowCount();
			
			$sql = "select * from task_master WHERE OrganizationId =? and id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$taskid ));
			while($row = $query->fetch()) {
				$admin=$row->taskstatus;
				$taskid=$row->task_no;
				$title=$row->task_title;
				$projectid=$row->projectid;
				$assignedbyid=$row->CreatedById;
				$assigntoid=$row->assignto;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count>= 1) {
			/////Activities Logs ///////////
			$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
			$msg="<b>$empname</b> has filled the timesheet for Task <b>$title</b>";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Self Service", $msg, $orgid));
			////////////Send Mail /////////////////////
			/* if($val==1){
				/////GET ClientHead ,ProjectManager, ProjectLead IDs//////
				$clientheadID=Utils::getName($projectid,'project_master','ClientManager',$this->db);
				$ProjectmanagerID=Utils::getName($projectid,'project_master','owner_id',$this->db);
				$ProjectLeadID=Utils::getName($projectid,'project_master','ProjectLead',$this->db);
				/////////Get Project Name//////////////	
				if($projectid!=0)
					$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
				if($projectid==0){
					$projectname="Misc. Activities";
				}
				///Get Assigned To Name////////
				$assignedtoname=Utils::getEmployeeName($assigntoid,$this->db);
				///////Get Assigned by name/////////
				$assignedbyemail=Utils::decode5t(Utils::getName($assignedbyid,'EmployeeMaster','CompanyEmail',$this->db));
				$assignedbyname=Utils::getEmployeeName($assignedbyid,$this->db);
				// Start Get ClientHead , ProjectManager, ProjectLead Email ID & Name//
				if($clientheadID!=""){
					$Clientemail=Utils::decode5t(Utils::getName($clientheadID,'EmployeeMaster','CompanyEmail',$this->db));
					$Clientname=Utils::getEmployeeName($clientheadID,$this->db);
				}
				if($ProjectmanagerID!=""){
					$ProManageremail=Utils::decode5t(Utils::getName($ProjectmanagerID,'EmployeeMaster','CompanyEmail',$this->db));
					$ProManagername=Utils::getEmployeeName($ProjectmanagerID,$this->db);
				}	
				if($ProjectLeadID!=""){
					$ProLeademail=Utils::decode5t(Utils::getName($ProjectLeadID,'EmployeeMaster','CompanyEmail',$this->db));
					$ProLeadname=Utils::getEmployeeName($ProjectLeadID,$this->db);
				}
				// End Get ClientHead , ProjectManager, ProjectLead Email ID & Name//
				////////Send Mail//////////////	
				if($assigntoid==$ProjectLeadID && $ProjectLeadID!=""){
					if($assigntoid!=$assignedbyid){
						////////Send Mail ProjectManager///////////
						if($ProjectmanagerID!="" && $ProjectmanagerID==$assignedbyid){
							$sub="Task '$title' is saved by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear $ProManagername,</td></tr>
							<tr><td></td></tr>
							<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $timeduration hours</td></tr>
							<tr><td>Description: $desc</td></tr>
							
							</table>";
						$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg);	
						}else{
							////////Send Mail Assigned By/////
							$sub="Task '$title' is saved by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear $assignedbyname,</td></tr>
							<tr><td></td></tr>
							<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $timeduration hours</td></tr>
							<tr><td>Description: $desc</td></tr>
							
							</table>";
							$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
						}
					}else{
						////////Send Mail ProjectManager///////////
						if($ProjectmanagerID!=""){
							$sub="Task '$title' is saved by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear $ProManagername,</td></tr>
							<tr><td></td></tr>
							<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $timeduration hours</td></tr>
							<tr><td>Description: $desc</td></tr>
							
							</table>";
							$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg);
						}else{
							////////Send Mail ClientHead///////////
							$sub="Task '$title' is saved by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear $Clientname,</td></tr>
							<tr><td></td></tr>
							<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $timeduration hours</td></tr>
							<tr><td>Description: $desc</td></tr>
							
							</table>";
							$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
						}
					}
				}elseif($assigntoid==$ProjectmanagerID && $ProjectmanagerID!=""){
					if($assigntoid!=$assignedbyid){
						////////Send Mail Assigned By///////////
						$sub="Task '$title' is saved by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear $assignedtoname,</td></tr>
						<tr><td></td></tr>
						<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $timeduration hours</td></tr>
						<tr><td>Description: $desc</td></tr>
						</table>";
						$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
					}else{
						////////Send Mail ClientHead///////////
						$sub="Task '$title' is saved by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear $Clientname,</td></tr>
						<tr><td></td></tr>
						<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $timeduration hours</td></tr>
						<tr><td>Description: $desc</td></tr>
						
						</table>";
						$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
					}
				}else if($assigntoid==$clientheadID){
					if($assigntoid!=$assignedbyid){
						///////Send Mail Assigned To////////
						$sub="Task '$title' is saved by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear $assignedbyname,</td></tr>
						<tr><td></td></tr>
						<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $timeduration hours</td></tr>
						<tr><td>Description: $desc</td></tr>
						
						</table>";
						$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
					}else{
						/////Send Mail To Reporting To Person /////////
						$sendmail=Utils::getSeniorId($assigntoid,$this->db);
						$assignedbyemail=Utils::decode5t(Utils::getName($sendmail,'EmployeeMaster','CompanyEmail',$this->db));
						$assignedbyname=Utils::getEmployeeName($sendmail,$this->db);
						$sub="Task '$title' is saved by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear $assignedbyname,</td></tr>
						<tr><td></td></tr>
						<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $timeduration hours</td></tr>
						<tr><td>Description: $desc</td></tr>
						
						</table>";
						$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
					}	
				}else{
					if($assigntoid==$assignedbyid){
						//////Send Mail ProjectLead//////////
						if($ProjectLeadID!=""){
							$sub="Task '$title' is saved by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear $ProLeadname,</td></tr>
							<tr><td></td></tr>
							<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $timeduration hours</td></tr>
							<tr><td>Description: $desc</td></tr>
							
							</table>";
							$sts=Utils::sendMail($ProLeademail,$assignedtoname,$sub,$msg);
						}else if($ProjectmanagerID!=""){
							//////Send Mail ProjectManager//////////
							$sub="Task '$title' is saved by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear $ProManagername,</td></tr>
							<tr><td></td></tr>
							<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $timeduration hours</td></tr>
							<tr><td>Description: $desc</td></tr>
							
							</table>";
							$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg);
						}else {
							//////Send Mail ClientHead//////////
							$sub="Task '$title' is saved by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear $Clientname,</td></tr>
							<tr><td></td></tr>
							<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $timeduration hours</td></tr>
							<tr><td>Description: $desc</td></tr>
							
							</table>";
							$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
						}
					}else{
						//////////Send Mail Assigned By/////////
						$sub="Task '$title' is saved by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear $assignedtoname,</td></tr>
						<tr><td></td></tr>
						<tr><td>Task: '$title' assigned to $assignedtoname is saved.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $timeduration hours</td></tr>
						<tr><td>Description: $desc</td></tr>
						
						</table>";
						$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
					}
				}
				
				Utils::Trace($sts." ".$assignedbyemail." ".$sub." ".$msg);
			}// end send mail to assigned by//////
			 */
			$status =true;
			$successMsg = "Timesheet has been created successfully";
			Utils::Trace("Timesheet has been Created for Id:".$mid." Last inserted id ".$this->db->lastInsertId());
		}
		else{
			 $status =false;
			 $errorMsg = "Problem while creating timesheet";
		}
		$result["data"] =$data;
		
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	////////////////////////Attendance list ////////////////////////	
	public function getAttendanceDataTable()
	{
		$sTable = 'AttendanceMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$aColumns = array( 'EmployeeId','EmployeeId','AttendanceDate', 'TimeIn', 'TimeOut', 'Overtime','ShiftId','AttendanceStatus','CheckInLoc','EntryImage','CheckOutLoc','ExitImage', 'Id');
		$aColumns = array( 'AttendanceDate',  'ShiftId','TimeIn','TimeOut', 'Overtime', 'Overtime');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$date = date("Y-m-d");
		$empid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
			
		$sWhere = " WHERE EmployeeId=$empid ";
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				
			}
			$sWhere = substr_replace( $sWhere, "", -4 );
			$sWhere .= ')';
		}
		
		$flg=true;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				$flg=false;
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//Utils::getDateformat(
				if($i==0){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		if($flg)
		{
			$sWhere .= " AND AttendanceDate=Curdate() ";
		}
				
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		Utils::Trace("Datatable Attendance".$sQuery);
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				if($aColumns[$i]=="AttendanceDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}elseif($aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
					
				}elseif($aColumns[$i]=="TimeIn" || $aColumns[$i]=="TimeOut")
				{
					if($aRow->{$aColumns[$i]} == '00:00:00' ){
						$row[] = '00:00';
					}else{
						$row[] = Utils::timeformatter($aRow->{$aColumns[$i]});
					}
					
				}elseif($aColumns[$i]=="ShiftId")
				{
					$row[] = $this->getShift($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Overtime" && $i==4)
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != '00:00:00'){
						$str = $aRow->{$aColumns[$i]};
					}
					$row[] = $str;
				}
				elseif($aColumns[$i]=="Overtime" && $i==5)
				{
					$str="-";
					if( $aRow->TimeIn != '00:00:00' && $aRow->TimeOut != '00:00:00'){
						$str =$this->getTotaltime($aRow->TimeIn,$aRow->TimeOut);
					}
					$row[] = $str;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getShift($id)
	{
		$name =" ";
		$sql = "SELECT Name FROM ShiftMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
				
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	public function getOvertime($timein,$timeout,$id)
	{
		$name =" ";
		$sql = "SELECT * FROM ShiftMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$stime1 = strtotime(date("1980-01-01 ".$row->TimeIn)); 
				$stime2 = strtotime(date("1980-01-01 ".$row->TimeOut)); 
				$time1 = strtotime(date("1980-01-01 ".$timein)); 
				$time2 = strtotime(date("1980-01-01 ".$timeout));  
				$totaltime = ($time2 - $time1);
				$stotaltime = ($stime2 - $stime1) ;
				
				
				$overtime =($totaltime-$stotaltime);
				$overtime =($overtime/60);
				
				if($overtime>0)
				{					
					$name = date('H:i', mktime(0,$overtime));
				}	
				
				
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	
	public function getTotaltime($timein,$timeout)
	{
		$name =" ";
		
		try{
			$time1 = strtotime(date("1980-01-01 ".$timein)); 
				$time2 = strtotime(date("1980-01-01 ".$timeout));  
			
			$totaltime = ($time2 - $time1);
			$totaltime =($totaltime/60);
				
			if($totaltime>0)
			{					
				$name = date('H:i', mktime(0,$totaltime));
			}	
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	public function getEmpLimit()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$status=true;
		$orgid=$_SESSION['ubihrm_org_id'];
		$successMsg = "";
		$availemp=Utils::getTotalEmp($orgid, $this->db);
		$result["data"] =$availemp;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getEmployeeAllLeaveTypeForMail($orgid,$mid,$leavetypeid) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$applydate=date('Y-m-d');
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $religion=0; $workingdays=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $religionflg=false; $halfdays=0;
		$doj=date('Y-m-d');
		$mdate=date('Y-m-d');
		try{
		$fiscalid = Utils::getFiscalId($applydate, $this->db);
		$sql1 = "SELECT *  FROM FiscalMaster WHERE Id=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $fiscalid));
		while($row1=$query1->fetch()){
			$startdate=$row1->StartDate;
			$enddate=$row1->EndDate;
		}
		$sql = "SELECT MaritalStatus, Gender, Division, Department, Designation, Grade, Religion, TotalExp,WorkingDays,DOJ FROM EmployeeMaster WHERE OrganizationId = ? and Id =?";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $mid));
		while($row = $query->fetch())
		{
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$religion=$row->Religion; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=$row->WorkingDays;
			$workingdays=substr_count($workingdays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);
			$doj=$row->DOJ;
		}
		
		$annualid =0; $annualcount =0;
		$sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() AND WorkingDays= $workingdays and AnnualLeaveSts=1 and DepartmentIds=0 and DesignationIds=0 and GenderId=0 and maritalId=0  and DivisionId=0 and GradeId=0 and ReligionId=0 and Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid, $leavetypeid));
		if($query->rowCount()>0)
		{
			while($row = $query->fetch())
			{
				$annualid =$row->Id;
			}
		}
		
        $sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and Id=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid,$leavetypeid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$divisionflg=true;
				$departmentflg=true; 
				$designationflg=true; 
				$gradeflg=true; $religionflg=true;
				$genderflg=true; $maritalflg=true;
				$carryforward=0;
				$employeeusedleave=0;
				
				if($row->LeaveUsableSts==1){
					if($row->DivisionId>0){
						if($row->DivisionId==$division){
							$divisionflg=true;
						}else{$divisionflg=false;}
					}
					if($row->DepartmentIds>0){
						if($row->DepartmentIds==$department){
							$departmentflg=true; 
						}else{$departmentflg=false; }
					}
					if($row->DesignationIds>0){
						if($row->DesignationIds==$designation){
							$designationflg=true; 
						}else{$designationflg=false; }
					}
					if($row->GenderId>0){
						if($row->GenderId==$gender){
							$genderflg=true;
						}else{$genderflg=false;}
					}
					if($row->MaritalId>0){
						if($row->MaritalId==$marital){
							$maritalflg=true;
						}else{$maritalflg=false;}
					}
					if($row->GradeId>0){
						if($row->GradeId==$grade){
							$gradeflg=true; 
						}else{$gradeflg=false; }
					}
					if($row->ReligionId>0){
						if($row->ReligionId==$religion){
							$religionflg=true; 
						}else{$religionflg=false; }
					}
				}elseif($row->LeaveUsableSts==2){
					$divisionflg=false;
					$departmentflg=false; 
					$designationflg=false; 
					$gradeflg=false; 
					$genderflg=false; $maritalflg=false;
					$religionflg=false; 
					if($row->EmployeeIds!="")
					{
						$temp = explode(",", $row->EmployeeIds);
						for($i=0; $i<count($temp); $i++)
						{
							if($mid==$temp[$i]){
								$divisionflg=true;
								$departmentflg=true; 
								$designationflg=true; 
								$gradeflg=true; $religionflg=true;
								$genderflg=true; $maritalflg=true;
								break;
							}
							
						}
					}					
				}
				$annual=true;
				if($row->AnnualLeaveSts==1){
						if($row->WorkingDays ==$workingdays){
							$annual=true;
						}else{$annual=false;}
				}
				if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg && $annual && $religionflg)
				{
					$leavealotted=$row->LeaveDays;
					$anniversaryyearsts=$row->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
					if($row->AnnualLeaveSts==1){
						$carryforward=$this->getCarryforwardleave($mid,$fiscalid);
						
						if($row->WorkingDays ==$workingdays){
							++$annualcount;
						}
						if($anniversaryyearsts == 1)
						{
							$start = strtotime($doj);
							$end = strtotime(date('Y-m-d'));
							$days_between = floor(abs($end - $start) / 86400);
							$leavealotted1=floor(($days_between * $row->LeaveDays)/365);
							$leavealotted=$leavealotted1;
							$twoyearsdays=(365*2)+30;////ADD MORE 30 DAYS,FOR TAKE ACTION ON LEAVE///	
							if($days_between < $twoyearsdays)
							{
							//////////IN THIS CASE CALCULATION BASED ON DATE OF JOINING TILL NOW/////////
								
								$startdate=$doj;
								$enddate=$mdate;
							}else{
							/////////IN THIS CASE I FIND THE ANNIVERSARY YEAR OF EMPLOYEE OF THIS YEAR,AND CALCULATE LEAVE ,ON THIS BASIS////////
							
								$start = strtotime($doj);
								$end = strtotime(date("2015-04-01"));
								if($end>$start){
									$days_between = floor(($end - $start) / 86400);
									$leavealotted1=floor(($days_between * $row->LeaveDays)/365);
									$employeeusedleave = $employeeusedleave + $leavealotted1;
								}
								
								$startdate=date("2015-04-01");
								$enddate=$mdate;
								
								
							}
							/* /////////this condition is for 30 day calendar days employees,this calculation is based on anniversary year of the joining date,ex- 10/02/2014 -10/02/2015////////
							$myear=date('Y');
							$anniversaryyear=date('m-d',strtotime(date($doj)));
							$enddate=$myear.'-'.$anniversaryyear;
							$startdate=date('Y-m-d',strtotime("- 1 year".date($enddate)));
							if(strtotime($mdate) > strtotime($enddate))
							{
								$startdate=$myear.'-'.$anniversaryyear;
								$enddate=date('Y-m-d',strtotime("+ 1 year".date($startdate)));
							} */
							
						}
						
					}
					
					
					$sql3 = "Select * from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=0 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 and empchild.Entitled=1 and empleave.LeaveTypeId=? and empchild.LeaveTypeId=?";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array($startdate, $enddate, $orgid, $mid, $row->Id,$leavetypeid,$leavetypeid));
					while($row3=$query3->fetch()){
						if($row3->HalfDaySts == 1){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					}
				
					$leftleave = $leavealotted-$employeeusedleave;
					if($leftleave>=0)
					{
						$res = array();
						$res['id'] = (int)$row->Id;
						$res['name'] = $row->Name;
						$res['days'] = (int)$leavealotted;
						$res['usedleave'] = $employeeusedleave;
						$res['leftleave'] = $leavealotted-$employeeusedleave;
						$res['carryforward'] = $carryforward;
						
						$data[] = $res;
					}
				}
				
			}
				
        }else{
			$status=true;
			$successMsg = LEAVETYPE_MODULE_GETALL;
		}
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if(count($data)>0 && $annualcount>1){
			for($i=0; $i<count($data); $i++)
			{
				if($data[$i]['id']==$annualid)
				{
					array_splice($data, $i, 1);break;
				}
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	//////////////////////////// to find out the approver on which the leave is pending ///////////////////////////
	
		public function getApproversts($id,$sts)
		{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM LeaveApproval where LeaveId=? and ApproverSts=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM LeaveApproval where LeaveId=? and ApproverSts=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					$name = $row->ApproverId;
				}
			}catch(Exception $e) {

			}

			return $name;
		}
	
	
	//////////////////////////// to find out the approver on which the timeoff is pending (Made by Pratibha)///////////////////////////
	
		public function getTimeOffApproversts($id,$sts)
		{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM TimeoffApproval where TimeofId=? and ApproverSts=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM TimeoffApproval where TimeofId=? and ApproverSts=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					$name = $row->ApproverId;
				}
			}catch(Exception $e) {

			}

			return $name;
		}
	public function getSkillgapTable()
	{
		$sTable = 'SkillGapAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'Period' ,'FromDate','ToDate','AssessmentSts', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		$sWhere = " Where OrganizationId=$orgid and EmployeeId=$userid";
		
		//$sWhere = " Where OrganizationId=$orgid and (Id in (select SkillGapId from SkillGapApproval where EmployeeId=$userid)) AND EmployeeId<>$userid";
		//$sWhere = " Where Id in (select SkillGapId from (select * from SkillGapApproval where  AssessmentSts = 0 Group by SkillGapId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$aid=Utils::encode5t($aRow->Id);
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete=""; $view="";
					
					$view  = '<a rel="tooltip" title="View Skill Gap Assessment" href="'.URL.'profile/viewskillgapassessment/'.$aid.'/2" ><i class="fa fa-eye"></i></a>';
					$row[] = $view;
				}
				else if($aColumns[$i]=="Period")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}

		/*	else if($aColumns[$i]=="EmployeeId")
				{
					$row[]='<a rel="tooltip" title="View" href="'.URL.'performance/viewskillgapassessment/'.$aid.'/2" >'.Utils::getEmployeename($aRow->{$aColumns[$i]}, $this->db).'</a>';
				} */
				
				else if($aColumns[$i]=="AssessmentSts")
				{
					$img = "<img src='".URL."public/dist/img/Red-icon.png' rel='tooltip' title='Not Started'/>";
					if($aRow->{$aColumns[$i]}==1){
						$img="<img src='".URL."public/dist/img/Green-icon.png' rel='tooltip' title='Assessment completed'/>";
					}else{
						$sts = $this->getEmployeeAssessmentRunning($aRow->Id);
						if($sts){
							$img = "<img src='".URL."public/dist/img/Yellow-icon.png' rel='tooltip' title='Assessment is running'/>";
						}
					}
					$row[]= $img;
				}
				
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate")
				{
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[]="";
					}else{
						$row[]=Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	/*for medical insurance*/
 public function getselfdata($eid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
        $sql = "SELECT *, TIMESTAMPDIFF(YEAR, DOB, CURDATE()) AS age FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $eid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$empcode=$res['empcode'] = $row->EmployeeCode;
				$res['name'] = $row->FirstName." ".$row->MiddleName." ".$row->LastName;
				$res['nationality'] =  Utils::getName($row->Nationality,'NationalityMaster','Name',$this->db);
				$res['gender']="";
				if($row->Gender==1)
					$res['gender'] = 'Male';
				else if($row->Gender==2)
					$res['gender'] = 'Female';
				$res['maritalstatus'] = $this->getOther($row->MaritalStatus,'MaritalStatus');
				if($row->DOB =="0000-00-00" ){
					$res['age']="";	
				}else{
					$res['age'] = $row->age." Yrs.";
				}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
   public function getFamilyMembers($eid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
        $sql = "SELECT * FROM EmployeeLTADetail WHERE EmployeeId = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $eid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
   	
   public function getFamilyDetails($eid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
        $sql = "SELECT *, TIMESTAMPDIFF(YEAR, DOB, CURDATE()) AS age FROM EmployeeLTADetail WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $eid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['age'] = $row->age." Yrs.";
				$res['passport'] = Utils::decode5t($row->PassportNo);
				$res['relation'] =  Utils::getName($row->Relation,'RelationMaster','Name',$this->db);
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
   	
  public function createMedicalClaim()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $claimid=0; $status=false;
		$data = array();
        $mid   = $_SESSION['ubihrm_user_id'];		
		$orgid = $_SESSION['ubihrm_org_id'];
		$mdate = date("Y-m-d H:i:s");
		$hr = Utils::getHR($orgid, $this->db);
		$hr = ($hr!='')?implode($hr,","):0;
		
		$arr = array();
		$arr[0] = $_POST['employeeid'];
		$arr[1] = $_POST['claim'];
		$arr[2] = $_POST['familymembers'];
		$arr[3] = $_POST['fmobile'];
		$arr[4] = $_POST['minsuranceno'];
		$arr[5] = $_POST['tcountry'];
		$arr[6] = $_POST['tcity'];
		$arr[7] = $_POST['thospital'];
		$arr[8] = $_POST['tsymptoms'];
		$arr[9] = $_POST['tspeciality'];
		$arr[10] = $_POST['trefdoctor'];
		$arr[11] = $_POST['tdetails'];
		$arr[12] = $_POST['tdiagnosis'];
		$arr[13] = $_POST['tprognosis'];
		$arr[14] = $_POST['reqamount'];
		$arr[15] = Utils::getDateformat($_POST['leavefrom']);
		$arr[16] = Utils::getDateformat($_POST['leaveto']);
		$arr[17] = 1;
		$arr[18] = $orgid;
		$arr[19] = $mid;
		$arr[20] = $mdate;
		$arr[21] = $hr;
		$arr[22] = $mid;
		$arr[23] = $mdate;
		
		$rdate = "";
		$sql1="SELECT Id FROM MedicalClaim where EmployeeId=? and OrganizationId=? and ((? between  LeaveFrom and LeaveTo )or (? between  LeaveFrom and LeaveTo ))";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($arr[0],$orgid, $arr[15],$arr[16]));
		if($query1->rowCount()>0){
			$result["data"] =$data;
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']="You have already applied for the same duration";
			return $result;
		}		
		
			$sql = "INSERT INTO MedicalClaim ( EmployeeId,ClaimFor, FMemberId, MobileNo, InsuranceNo, tCountry,  tCity, tHospital, tSymptoms, tSpeciality, tRefDoc, tDetails, tDiagnosis, tPrognosis, ReqAmount, LeaveFrom, LeaveTo, ApproveSts, OrganizationId, CreatedById, CreatedDate,financeby,LastModifiedById,LastModifiedDate) VALUES (? ,? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			try{
				$query = $this->db->prepare($sql);
				$query->execute($arr);
				$count =  $query->rowCount();
			if ($count == 1) {				
			    $status =true;
			    $successMsg = "Your request for claim has been sent!";
			    $claimid = $this->db->lastInsertId();
				Utils::Trace("HR OUT".$hr);
				if($hr!=0)
				{
					Utils::Trace("HR IN".$hr);
						$empname=Utils::getName($arr[0],'EmployeeMaster','FirstName',$this->db);
						$seniorname=Utils::getName($hr,'EmployeeMaster','FirstName',$this->db);
						$senioremail=Utils::decode5t(Utils::getName($hr,'EmployeeMaster','CompanyEmail',$this->db));
						$title="Medical Claim";
						$msg="<table>
								<tr><td>Hello $seniorname,</td></tr>
								<tr><td>$empname has requested for Medical Claim.</td></tr>
								<tr><td>Thanks</td></tr>
							</table>";
						Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
				}
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
		$result["data"] =$data;
		$result["claimid"] =$claimid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	 public function updateMedicalClaim()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $_SESSION['ubihrm_user_id'];	
		$orgid = $_SESSION['ubihrm_org_id'];
		$mdate = date("Y-m-d H:i:s");
		
		$arr = array();
		$arr[0] = $_POST['employeeid'];
		$arr[1] = $_POST['claim'];
		$arr[2] = $_POST['familymembers'];
		$arr[3] = $_POST['fmobile'];
		$arr[4] = $_POST['minsuranceno'];
		$arr[5] = $_POST['tcountry'];
		$arr[6] = $_POST['tcity'];
		$arr[7] = $_POST['thospital'];
		$arr[8] = $_POST['tsymptoms'];
		$arr[9] = $_POST['tspeciality'];
		$arr[10] = $_POST['trefdoctor'];
		$arr[11] = $_POST['tdetails'];
		$arr[12] = $_POST['tdiagnosis'];
		$arr[13] = $_POST['tprognosis'];
		$arr[14] = $_POST['reqamount'];
		$arr[15] = Utils::getDateformat($_POST['leavefrom']);
		$arr[16] = Utils::getDateformat($_POST['leaveto']);
		$arr[17] = $mid;
		$arr[18] = $mdate;
		$arr[19] = $_POST['claimid'];
		
		$rdate = "";
		$sql1="SELECT Id FROM MedicalClaim where EmployeeId=? and OrganizationId=? and ((? between  LeaveFrom and LeaveTo )or (? between  LeaveFrom and LeaveTo )) and Id!=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($arr[0],$orgid, $arr[15],$arr[16],$arr[19]));
		if($query1->rowCount()>0){
			$result["data"] =$data;
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']="You have already applied for the same duration";
			return $result;
		}		
		
			$sql = "Update MedicalClaim set EmployeeId=?,ClaimFor=?, FMemberId=?, MobileNo=?, InsuranceNo=?, tCountry=?,  tCity=?, tHospital=?, tSymptoms=?, tSpeciality=?, tRefDoc=?, tDetails=?, tDiagnosis=?, tPrognosis=?, ReqAmount=?, LeaveFrom=?, LeaveTo=?, LastModifiedById=?, LastModifiedDate=? where Id=?";
			try{
				$query = $this->db->prepare($sql);
				$query->execute($arr);
				$count =  $query->rowCount();
			if ($count == 1) {				
			    $status =true;
			    $successMsg = "Your request for claim has been updated!";
			    $claimid = $this->db->lastInsertId();
				/*$hr = Utils::getHR($orgid, $this->db);
				 $hr = ($hr!='')?implode($hr,","):0;
				Utils::Trace("HR OUT".$hr);
				if($hr!=0)
				{
					Utils::Trace("HR IN".$hr);
						$empname=Utils::getName($arr[0],'EmployeeMaster','FirstName',$this->db);
						$seniorname=Utils::getName($hr,'EmployeeMaster','FirstName',$this->db);
						$senioremail=Utils::getName($hr,'EmployeeMaster','CompanyEmail',$this->db);
						$title="Medical Claim";
						$msg="<table>
								<tr><td>Hello $seniorname,</td></tr>
								<tr><td>$empname has requested for Medical Claim.</td></tr>
								<tr><td>Thanks</td></tr>
							</table>";
						Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
				} */
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  
   public function getMedicalClaimTable()
	{
		$sTable = 'MedicalClaim';
		$sIndexColumn = "Id";
		$aColumns = array('ClaimFor', 'ReqAmount' ,'LeaveFrom','LeaveTo','ApproveSts', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid = $_SESSION['ubihrm_org_id'];
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;
		}
		$sWhere = " WHERE EmployeeId = $empid AND OrganizationId = $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				
					$edit="";
					if($aRow->ApproveSts==1){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'profile/editmedicalclaim/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
						/*$delete ='<a data-href="'.URL.'employee/deleteofficialcommunication/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';*/
								
					$row[] =$edit;
				}
				
				else if($aColumns[$i]=="LeaveFrom" || $aColumns[$i]=="LeaveTo"){
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[] ="";
					}else{
						$row[] =Utils::dateformatter($aRow->{$aColumns[$i]});
					}	
					
				}
				else if($aColumns[$i]=="ApproveSts"){
					$row[] =Utils::getOtherName($aRow->ApproveSts,"MedClaimSts", $this->db);
				}
				else if($aColumns[$i]=="ClaimFor"){
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ="Self";
					}else{
						$row[] ="Family";
					}	
					
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	/*for medical insurance*/
	public function getmedicalclaimdata($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
        $sql = "SELECT * FROM MedicalClaim WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['employeeid'] = $row->EmployeeId;
				$empcode = $this->getCode($row->EmployeeId);
				$res['claim'] = $row->ClaimFor;
				$res['familymembers']=$row->FMemberId;
				$res['fmobile']=$row->MobileNo;
				$res['minsuranceno']=$row->InsuranceNo;
				$res['tcountry']=$row->tCountry;
				$res['tcity']=$row->tCity;
				$res['thospital']=$row->tHospital;
				$res['tsymptoms']=$row->tSymptoms;
				$res['tspeciality']=$row->tSpeciality;
				$res['trefdoctor']=$row->tRefDoc;
				$res['tdetails']=$row->tDetails;
				$res['tdiagnosis']=$row->tDiagnosis;
				$res['tprognosis']=$row->tPrognosis;
				$res['reqamount']=$row->ReqAmount;
				$res['sancamount']=$row->SancAmount;
				$res['leavefrom']=Utils::dateFormatter($row->LeaveFrom);
				$res['leaveto']=Utils::dateFormatter($row->LeaveTo);
				if($row->MedDoc)
					$res['docattach']=URL."public/uploads/$orgid/$empcode/medicalclaim/".$row->MedDoc;
				else
					$res['docattach']="";
				$res['approvests']=$row->ApproveSts;
				//$res['releasests']=$row->ReleaseSts;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }	

	//////////////////////////////uploading document/////////////////////////////
	public function uploadMedicalDocument()
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $_SESSION['ubihrm_user_id'];	
		$orgid = $_SESSION['ubihrm_org_id'];
		$claimid = $_POST['claimid'];
		$empid = Utils::getName($claimid,'MedicalClaim','EmployeeId',$this->db);
		$empcode=$this->getCode($empid);
		$new_name="";
		
		if (!file_exists("public/uploads/$orgid/$empcode/medicalclaim")) {
			mkdir("public/uploads/$orgid/$empcode/medicalclaim" ,  0755,true);
		}
		
		$dir="public/uploads/$orgid/$empcode/medicalclaim";
		
		$filename="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				/* if ($ext=='png' || $ext=='jpg' || $ext=='gif' || $ext=='MOV' || $ext=='ico' || $ext=='tif') */
				if ($ext=='png' || $ext=='PNG' || $ext=='jpg' || $ext=='JPG' || $ext=='gif' || $ext=='GIF' || $ext=='MOV' || $ext=='tif' || $ext=='TIF' || $ext=='jpeg' || $ext=='ico' || $ext=='pdf' || $ext=='PDF' || $ext=='doc' || $ext=='DOC' || $ext=='docx' || $ext=='DOCX' || $ext=='txt' || $ext=='TXT')
				{
					
					$new_name=$empcode."_".$claimid.".".$ext;
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/$orgid/$empcode/medicalclaim/";
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						move_uploaded_file($file_tmp, $location.$new_name);
						$count++;
					}
					else{
						print_r($errors);
					}
				}
				else{
					$status =false;
					$successMsg = "Choose Only Image Format..";
				}				
			}
			
			if ($count >= 1) 
			{
				$status =true;
				$successMsg = "Medical claim attachment uploaded successfully..";
					$sql="Update MedicalClaim set MedDoc=? where Id=?";
					$query=$this->db->prepare($sql);
					$query->execute(array($new_name,$claimid));
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}
	
	
}
	
