<?php

/**
 * PolicyModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class PolicyModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$sql = "SELECT pm.Id, ApplyDate, pm.Name as policyname, cm.Name as categoryname  FROM PolicyMaster pm, CategoryMaster cm  WHERE pm.CategoryId=cm.Id and cm.TypeId=?  and pm.OrganizationId = ? order by cm.Name";
				$query = $this->db->prepare($sql);
				try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					
					$query->execute(array(6, $orgid ));
					$count =  $query->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				if($count>=1)
				{
					$status=true;
					$successMsg=$count." record found";
					while($row = $query->fetch())
					{
						$res1 = array();
						$res['id'] = $row->Id;
						$res['categoryname'] = $row->categoryname;
						$res['policyname'] =$row->policyname;
						$res['applydate'] = Utils::dateformatter($row->ApplyDate);
						$data[] = $res;						
					}
				}else{
					$status=true;
					$successMsg = DOCUMENT_MODULE_GETALL;
				}
				
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM PolicyMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['policyname'] = $row->Name;
				$res['categoryid'] = $row->CategoryId;
				$res['applydate'] = Utils::dateformatter($row->ApplyDate);
				
				
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = POLICY_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = POLICY_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a PolicyMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$desc = Utils::getDateformat($request[4]);
		
		$sql = "UPDATE PolicyMaster SET Name=?, CategoryId=?, ApplyDate=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($request[3],$request[2], $desc, $orgid, $mdate, $mid, Utils::decode5t($request[5]) ));			
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			//$empid=Utils::getName($did,'LeaveMaster','EmployeeIds',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Policy has been updated  ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Policy", $msg, $orgid));
           $status =true;
		   $successMsg = POLICY_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = POLICY_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a PolicyMasterMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$desc = Utils::getDateformat($request[4]);
		
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$sql="select Name from PolicyMaster where CategoryId=? and OrganizationId=?";
		$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$orgid));
			$count =  $query->rowCount();
			if ($count >0)
			{		
		$result["data"] =$data;
		$result['status']=false;
		$result['successMsg']=$successMsg;
		$result['errorMsg']="This policy is already exist";
		 return $result;
			}
			
			$sql = "INSERT INTO PolicyMaster (CategoryId, Name, ApplyDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$request[3], $desc, $orgid,$mdate,$mid,$mdate,$mid,$mid));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			
		   	//$empid=Utils::getName($did,'LeaveMaster','EmployeeIds',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Policy has been created ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Policy", $msg, $orgid));
        
     	
           $status =true;
		   $successMsg = POLICY_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = POLICY_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
       
 	    $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$orgid = $_SESSION['ubihrm_org_id'];
		$mid = $_SESSION['ubihrm_user_id'];
		
		$sql = "DELETE FROM PolicyMaster WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
		    
			//$empid=Utils::getName($did,'LeaveMaster','EmployeeIds',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Policy has been deleted ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Policy", $msg, $orgid));
       	
           $status =true;
		   $successMsg = POLICY_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = POLICY_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	//function for getting name
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM CategoryMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	//function for getting HeadCategory
	public function getCategory($id)
	{
		$name ="";
		$sql = "SELECT Name FROM CategoryMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'PolicyMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'CategoryId','ApplyDate',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="CategoryId"){
					$sWhere .= " (CategoryId in ( select Id from CategoryMaster where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editpolicy/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="CategoryId")
				{
					$row[] = $this->getCategory($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="CreatedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				elseif($aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				elseif($aColumns[$i]=="ApplyDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
