<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class PimasterModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    
	public function getAllindicator($designationid)
    {
		$result = array();		
		$org_id=$_SESSION['ubihrm_org_id'];
		$sql = "SELECT * FROM Quadrants WHERE OrganizationId=:org_id and Id in(select QuadrantId from AssessmentObjectiveChild where AssessmentObjectiveId in (select Id from AssessmentObjective where DesignationId=:desi) and VisibleSts=1) ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':org_id' => $org_id,':desi' => $designationid));
		$KPA_arr=array();		
		while($row=$query->fetch())
		{
			$data=array();
			$data['KPA_Id']=$kpa_id=$row->Id;
			$data['KPA_Name']=$row->Name;
			$sql1 = "SELECT * FROM AssessmentObjectiveChild WHERE AssessmentObjectiveId in(select Id from AssessmentObjective where DesignationId=:desi) and QuadrantId=:cat_id  and VisibleSts=1";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(':desi'=>$designationid, ':cat_id'=>$kpa_id));
			$KPI_arr=array();
			while($row1=$query1->fetch())
			{	
				$res=array();			
				$res['KPI_Id']=$row1->Id;
				$res['KPI_Name']=$row1->Objective;
				$KPI_arr[]=$res;
			}
			$data['kpi']=$KPI_arr;
			$KPA_arr[]=$data;
		}
			$result['data']=$KPA_arr;
		return $result;		
    }
	
	
    public function GetAssessdata($id)
    {
		$result = array();
		$count=0;$count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		try{
			$sql2 = "SELECT * FROM pi_master WHERE id = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($id));
			$count =  $query2->rowCount();
			
		if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row1 = $query2->fetch())
				{
					$res= array();
					$res['id']=$row1->id;
					$res['emp_id']=$row1->emp_id;
					$res['month']=$row1->month;
					$res['marks']=(int)$row1->marks;
					$res['obtain_marks']=(int)$row1->obtain_marks;
					$res['remarks']=$row1->remarks;
					$res['ratings']=$row1->ratings;
					$res['totalper']=$row1->totalper;
					$res['summary']=$row1->summary;
					$data[]=$res;
				}
		}
		$assigndata=$this->getAssignindicator($id);
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count >= 1) {
			$status =true;
			$successMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_SUCCESS;
		} else {
			$status =false;
			$errorMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_FAILED;
		}
		$result["data"] =$data;
		$result["assigndata"] =$assigndata;
		
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
    }
	public function getAssignindicator($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$sql2 = "SELECT * FROM pi_child WHERE pi_id in ($id)";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($orgid ));
			$count =  $query2->rowCount();
		$totalmarks=0;
		if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row1 = $query2->fetch())
				{
					$res= array();
					$res['id']=$row1->id;
					$res['pi_id']=$row1->pi_id;
					$res['attributes1']=$row1->attributes;
					$res['attributes']=$this->getName($row1->attributes);
					$res['marks']=(int)$row1->mark;
					//$totalmarks=$totalmarks+$row1->mark; 
					$res['obtainmarks']=(int)$row1->obtain_mark;
					$data[]=$res;
				}
				
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count >= 1) {
			$status =true;
			//$successMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_SUCCESS;
		} else {
			$status =false;
			//$errorMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_FAILED;
		}
		
		return $data;
		
    }
	 public function getName($id){
    	try{
			$name="";
			$sql="select * from performance_indicator_master where id=$id";
			$query = $this->db->prepare($sql);
			$query->execute();
			$count =$query->rowCount();
			if($row= $query->fetch()){
				$name = $row->attribute;
			}
			return $name;
		}catch(Exception $e){}
	}
	
	public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		
		$assigndby   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];
		$emp_id = $request[2];
		$month = date('Y-m-d',strtotime($request[3]));
		
		$pi_date = date("Y-m-d H:i:s"); 
		$marks = $request[4];
		$obtain_marks = $request[5];
		$remarks = $request[6];
		$arr = json_decode($_POST['Indicator'] , true);
		//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		try{
			$sql= "select * from pi_master where OrganizationId=? and emp_id = ? and month=?";
			$query=$this->db->prepare($sql);
			$query->execute(array($orgid,$emp_id,$month));
			$row = $query->fetch();
			$count =$query->rowCount();
			//$year =date("Y",strtotime(date($row->month)));
			if($count>=1){
				$Status=false;
				$errorMsg = "Employee has assessed already for this month";
			}	
			else{
			
			$sqlv="INSERT into pi_master(emp_id, month, pi_date, marks, obtain_marks, assigndby, remarks, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, ratings, totalper,summary) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			$queryv=$this->db->prepare($sqlv);
			$queryv->execute(array($emp_id,$month,$pi_date,$marks,$obtain_marks,$assigndby,$remarks,$orgid,$pi_date, $assigndby, $pi_date, $assigndby, $request[7], $request[8], $request[9]));
			$count =$queryv->rowCount();
			$pimasterid =$this->db->lastInsertId();
			if($count == 1)
			{
				for($i=0; $i<count($arr); $i++)
				{
					$sql="INSERT into pi_child(pi_id, attributes, mark, obtain_mark) values (?, ?, ?, ?)";
					$query=$this->db->prepare($sql);
					$query->execute(array($pimasterid,$arr[$i]['id'], $arr[$i]['marks'], $arr[$i]['obtainmarks']));
					//$count =$query->rowCount();
				}
				$status =true;
				$successMsg = PERFORMANCE_ASSESS_INDICATOR_MODULE_CREATION_SUCCESS;
			}
			 else {
				$status =false;
				$errorMsg = PERFORMANCE_ASSESS_INDICATOR_MODULE_CREATION_FAILED;
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); 
		$assigndby   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];
		$assignid = $request[2];
		$pi_date = date("Y-m-d H:i:s"); 
		$obtain_marks = $request[3];
		$remarks = $request[4];
		$arr = json_decode($_POST['Indicator'] , true);
		
		try{
			
			$sqlv="UPDATE pi_master SET pi_date=?, obtain_marks=?, assigndby=?,remarks=?, LastModifiedDate=?, LastModifiedById=?, ratings=?, totalper=?,summary=? WHERE id=?";
			$queryv=$this->db->prepare($sqlv);
			$queryv->execute(array($pi_date,$obtain_marks,$assigndby ,$remarks ,$pi_date, $assigndby, $request[5] , $request[6], $request[7],$assignid));
			$count =$queryv->rowCount();
			if($count==1){
				$del = "delete from pi_child where pi_id =$assignid";
				$query=$this->db->prepare($del);
				$query->execute();
				$count1 =$query->rowCount();
				if($count1>=1){
					for($i=0; $i<count($arr); $i++)
					{
						$sql1="INSERT into pi_child(pi_id, attributes, mark, obtain_mark) values (?, ?, ?, ?)";
						$query1=$this->db->prepare($sql1);
						$query1->execute(array($assignid,$arr[$i]['attributes1'],$arr[$i]['marks'], $arr[$i]['obtainmarks']));
					}
					$status =true;
					$successMsg = PERFORMANCE_ASSESS_INDICATOR_MODULE_UPDATION_SUCCESS;
				}
				 else {
				$status =false;
				$errorMsg = PERFORMANCE_ASSESS_INDICATOR_MODULE_UPDATION_FAILED;
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	function getstars($ratings)
	{
		$stars="";
		while($ratings>0)
		{
			$stars .="<i class='fa fa-star' style='color:rgba(233, 176, 16, 1);'></i>";
			$ratings--;
		}
		
		return $stars;
	}
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$del = "delete from pi_child where pi_id =$did ";
			$query = $this->db->prepare($del);
			$query->execute();
			$count =  $query->rowCount();	
			$del1 = "delete from pi_master where id =$did ";
			$query1 = $this->db->prepare($del1);
			$query1->execute();
			$count =  $query1->rowCount();

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = PERFORMANCE_ASSESS_INDICATOR_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = PERFORMANCE_ASSESS_INDICATOR_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getAssignIndicatorData($editper, $deleteper)
	{
		$sTable = 'pi_master';
		$sIndexColumn = "id";
		$aColumns = array( 'emp_id', 'emp_id','month','marks','obtain_marks','ratings','remarks','assigndby','id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		
		
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		//$sWhere = " Where Id in (select EmployeeAssessmentId from (select * from EmployeeAssessmentApproval where  AssessmentSts = 0 Group by EmployeeAssessmentId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid  ";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sWhere = " WHERE (CreatedById in ($ids) AND OrganizationId= $orgid)";
			}
		
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}if($aColumns[$i]=="emp_id" and $i==1){
				$sWhere .= " (emp_id in ( select Id from EmployeeMaster where Designation in(select Id from DesignationMaster where Name LIKE '%".( $_GET['sSearch'] )."%') )) OR ";//and FiscalId=$fiscalid
				}
				if( $i==0){
					$sWhere .= " (emp_id in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				
				
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($aColumns[$i]=="emp_id" && $i==1){
					$sWhere .= " (emp_id in ( select Id from EmployeeMaster where  Designation LIKE '%".($_GET['sSearch_'.$i])."%'))  ";
				}elseif($i==2){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}else{
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id")
				{
					$edit =""; $edit1="";
					if($editper){
						
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performance/editAssessindicator/'.$aRow->id.'/1"  ><i class="fa fa-edit"></i></a>';
						
					}
					if($deleteper){
						$edit1 = '<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}		
					$row[] =$edit.' &nbsp;&nbsp; '.$edit1 ;
				}
				else if($aColumns[$i]=="assigndby" ){
					$assign=Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					$row[]=$assign;
				}
				else if($i==0 and $aColumns[$i]=="emp_id"){
					$assign=Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					$row[]=$assign;
				}
				else if($i==1 and $aColumns[$i]=="emp_id"){
					$desig=Utils::getName($aRow->{$aColumns[$i]}, "EmployeeMaster", "Designation", $this->db);
					$assign=Utils::getName($desig, "DesignationMaster", "Name", $this->db);
					$row[]=$assign;
				}
				else if($aColumns[$i]=="month"){
					$assign=Utils::monthdateformatter($aRow->month);
					$row[]=$assign;
				}
				else if($aColumns[$i]=="ratings"){
					$assign=$this->getstars($aRow->{$aColumns[$i]});
					
					
					$row[]=$assign;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
}
