<?php

/**
 * PolicyModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class Personnel_requisitionModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$sql = "SELECT pm.Id, ApplyDate, pm.Name as policyname, cm.Name as categoryname  FROM PolicyMaster pm, CategoryMaster cm  WHERE pm.CategoryId=cm.Id and cm.TypeId=?  and pm.OrganizationId = ? order by cm.Name";
				$query = $this->db->prepare($sql);
				try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					
					$query->execute(array(6, $orgid ));
					$count =  $query->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				if($count>=1)
				{
					$status=true;
					$successMsg=$count." record found";
					while($row = $query->fetch())
					{
						$res1 = array();
						$res['id'] = $row->Id;
						$res['categoryname'] = $row->categoryname;
						$res['policyname'] = $row->policyname;
						$res['applydate'] = Utils::dateformatter($row->ApplyDate);
						$data[] = $res;						
					}
				}else{
					$status=true;
					$successMsg = DOCUMENT_MODULE_GETALL;
				}
				
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM PersonnelRequisition WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['designationid'] =(int) $row->DesignationId;
				$res['salaryrange'] = $row->SalaryRange;
				$res['vacancy'] =(int) $row->TotalVacancy;
				$res['nationality'] = $row->NationalityId;
				$res['gender'] = $row->GenderId;
				$res['agelimit'] = $row->AgeRange;
				$res['position'] = $row->PositionType;
				$res['emptype'] = $row->EmploymentType;
				$res['qualification'] = $row->MinQualification;
				$res['experience'] = $row->Experience;
				$res['budgetapp'] = $row->BudgetApproval;
				$res['deadline'] = $row->SelectionPeriod;
				$res['desc'] = $row->Description;
				$res['applydate'] = Utils::dateformatter($row->ApplyDate);
				
				
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = POLICY_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = POLICY_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	 public function Approve($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "UPDATE PersonnelRequisitionApproval SET  ApproverSts=?, ApproverComment=?, ApprovalDate=? where PersonnelRequisitionId=? and ApproverId=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($request[3],$request[4], $mdate,$request[2],$mid ));			
			$count =  $query->rowCount();
			
			$sql = "Select Id from PersonnelRequisitionApproval where PersonnelRequisitionId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2]));			
			
			if($query->rowCount()==0)
			{
				$sql = "UPDATE PersonnelRequisition SET  ApproverSts=?, ApproverComment=? where Id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array(2,$request[4], $request[2] ));			
			
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = "Personnel Requisition Approved successfully";
        } else {
           $status =false;
		   $errorMsg = POLICY_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
    
    /**
     * Setter for a PersonnelRequisition (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "UPDATE PersonnelRequisition SET  DesignationId=?, TotalVacancy=?, SalaryRange=?, NationalityId=?, GenderId=?, AgeRange=?, PositionType=?, EmploymentType=?, MinQualification=?, Experience=?, BudgetApproval=?, SelectionPeriod=?, Description=?,  LastModifiedById=?, LastModifiedDate=? where Id=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($request[2],$request[3], $request[4],$request[5],$request[6],$request[7],$request[8],$request[9],$request[10],$request[11],$request[12],$request[13],$request[14],  $mdate, $mid, $request[15] ));			
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = "Personnel Requisition request updated successfully";
        } else {
           $status =false;
		   $errorMsg = POLICY_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a PersonnelRequisitionMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "INSERT INTO PersonnelRequisition (DesignationId, TotalVacancy, SalaryRange, NationalityId, GenderId, AgeRange, PositionType, EmploymentType, MinQualification, Experience, BudgetApproval, SelectionPeriod, Description, CreatedById, CreatedDate, LastModifiedById, LastModifiedDate, OrganizationId, OwnerId, ApplyDate,ApproverSts) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$request[3], $request[4],$request[5],$request[6],$request[7],$request[8],$request[9],$request[10],$request[11],$request[12],$request[13],$request[14], $mid,$mdate,$mid,$mdate,$orgid,$mid,date('Y-m-d'),3));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			$status =true;
			$successMsg = "Personnel Requisition request has sent successfully";
			$leaveid = $this->db->lastInsertId();
			$sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";

			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($r=$query->fetch()){
				$hr=$r->EmployeeId;
			}	
			$senior = Utils::getApprovalLevelEmp($mid, 6, $this->db);
					
			if($senior!=0)
			{
				$temp1=explode(',',$senior);
				for($i=0;$i<count($temp1);$i++){
					if($temp1[$i] == $hr){
						unset($temp1[$i]);
					}
				}
				$senior=implode(',',$temp1); 
					if($hr !=0)
					$senior.=','.$hr; 
					
				$temp = explode(",", $senior);
				for($i=0; $i<count($temp); $i++)
				{
					if($temp[$i] != 0){
						$sql = "INSERT INTO PersonnelRequisitionApproval ( PersonnelRequisitionId, ApproverId, ApproverSts, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($leaveid, $temp[$i], 3, $mdate, $orgid));
					}
					
				}
			}else{
				$senior=Utils::getSeniorIds($mid, $this->db);
				
				$temp = explode(",", $senior);
				for($i=0; $i<count($temp); $i++)
				{
					if($temp[$i] != 0){
						$sql = "INSERT INTO PersonnelRequisitionApproval ( PersonnelRequisitionId, ApproverId, ApproverSts, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($leaveid, $temp[$i], 3, $mdate, $orgid));
					}
				}
			}
					
					
		} else {
		   $status =false;
		   $errorMsg = POLICY_MODULE_CREATION_FAILED;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM PersonnelRequisition WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = "Personnel Requisition deleted successfully";
        }else {
           $status =false;
		   $errorMsg = POLICY_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getApproverSts($id,$userid)
	{
		$flg =false;
		$employee=0;
		$sql = "SELECT * FROM PersonnelRequisitionApproval WHERE PersonnelRequisitionId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
				if($row->ApproverSts==3){
					$employee=$row->ApproverId;
					break;
				}
			}
			if($employee ==  $userid){
					$flg = true;
				}
		}catch(Exception $e) {
			
		}
		return $flg;
	}
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'PersonnelRequisition';
		$sIndexColumn = "Id";
		$aColumns = array( 'DesignationId','TotalVacancy','Experience','SalaryRange','PositionType','EmploymentType', 'GenderId','CreatedById','ApproverSts', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$mid=$_SESSION['ubihrm_user_id'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$asts=$_SESSION['ubihrm_user_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = " WHERE  OrganizationId= $orgid and (CreatedById in ($ids) or CreatedById=$mid)";
		if($asts==1 || $hrsts==1)
		$sWhere = " WHERE  OrganizationId= $orgid ";
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="DesignationId"){
					$sWhere .= " (DesignationId in ( select Id from DesignationMaster where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete=""; $view="";
					if($editper && $aRow->ApproverSts==3){
						$sts=$this->getApproverSts($aRow->Id,$mid);
						if($sts)
						{
							$view='<a rel="tooltip" title="Require Approval" href="'.URL.'setup/viewpersonnel_requisition/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/1" ><i class="fa fa-thumbs-up"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;';
						}
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editpersonnel_requisition/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$view.$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="DesignationId")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'DesignationMaster','Name',$this->db);
				}
				elseif($aColumns[$i]=="Experience")
				{
					$temp = explode(',',$aRow->{$aColumns[$i]});
					$row[]=$temp[0].' - '.$temp[1].' Yrs ';
				}
				elseif($aColumns[$i]=="SalaryRange")
				{
					$temp = explode(',',$aRow->{$aColumns[$i]});
					$row[]=$temp[0].' - '.$temp[1].' '.Utils::getCurrency();
				}
				elseif($aColumns[$i]=="CreatedById")
				{
					$row[]=Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db);
				}
				elseif($aColumns[$i]=="GenderId")
				{   
					$gender="";
					if($aRow->{$aColumns[$i]}=="3"){
						$gender="Both";
					}else{
						$gender=Utils::getOtherName($aRow->{$aColumns[$i]},'Gender',$this->db);
					}
					$row[]=$gender;
				}
				elseif($aColumns[$i]=="EmploymentType")
				{
					$row[]=Utils::getName($aRow->{$aColumns[$i]},'EmploymentTypeMaster','Name',$this->db);
				}
				elseif($aColumns[$i]=="ApproverSts")
				{
					$row[]=Utils::getleavetype($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="PositionType")
				{
					if($aRow->{$aColumns[$i]}==0)
					$row[]="New";
					else
					$row[]="Replacement";
				}
				
				elseif($aColumns[$i]=="ApplyDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
