<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class PerformanceindicatorModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		try{
			$sql2 = "SELECT * FROM performance_indicator_master WHERE id = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($id ));
			$count =  $query2->rowCount();
		
		if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row1 = $query2->fetch())
				{
					$res= array();
					$res['id']=$row1->id;
					$res['attributes']=$row1->attribute;
					$res['marks']=(int)$row1->marks;
					$data[]=$res;
				}
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count >= 1) {
			$status =true;
			$successMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_SUCCESS;
		} else {
			$status =false;
			$errorMsg = PERFORMANCE_INDICATOR_MODULE_GETDETAIL_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
    }
	
	public function getCompetencyEmployee($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$designationid = $request[2];
		//$competencyid = $request[2];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sql = "";
		if($sts==1 || $hrsts==1){
			//$ids =Utils::getReportingIds($mid, $this->db); 
			/* $sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and Designation=:desi and Id in (Select EmployeeId from EmployeeAssessment where AssessmentSts=1 ) and (DOL='0000-00-00' or DOL>curdate()) and "; */
			$sql = "SELECT e.* FROM EmployeeMaster e,EmployeeAssessment ea, AssessmentResult ar, AssessmentObjective ao WHERE e.OrganizationId = :id and e.Designation=:desi and e.Id = ea.EmployeeId and ea.AssessmentSts=1 and e.Designation=ao.DesignationId and ao.Id=ar.AssessmentObjectiveId and ea.Rating=ar.Rating and ar.tcriteria=1 and (e.DOL='0000-00-00' or e.DOL>curdate()) order by e.FirstName ";
		}else{
			$ids =Utils::getReportingIds($mid, $this->db);
			/*$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and Designation=:desi and Id in (Select EmployeeId from EmployeeAssessment where AssessmentSts=1 ) and  (DOL='0000-00-00' or DOL>curdate()) and Id in ($ids) order by FirstName"; */
			$sql = "SELECT e.* FROM EmployeeMaster e,EmployeeAssessment ea, AssessmentResult ar, AssessmentObjective ao WHERE e.OrganizationId = :id and e.Designation=:desi and e.Id = ea.EmployeeId and ea.AssessmentSts=1 and e.Designation=ao.DesignationId and ao.Id=ar.AssessmentObjectiveId and ea.Rating=ar.Rating and ar.tcriteria=1 and (e.DOL='0000-00-00' or e.DOL>curdate()) and e.Id in ($ids) order by e.FirstName ";
		}
			$query = $this->db->prepare($sql);
			try{				
				$query->execute(array(':id' => $orgid,':desi' => $designationid ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['sts'] = 0;
				$res['empreport'] = Utils::getName($row->ReportingTo,"EmployeeMaster", "FirstName", $this->db).' '.Utils::getName($row->ReportingTo,"EmployeeMaster", "LastName", $this->db);
				$res['empdivision'] = Utils::getName($row->Division,"DivisionMaster", "Name", $this->db);
				$res['empdepartment'] = Utils::getName($row->Department,"DepartmentMaster", "Name", $this->db);
				$res['empdesignation'] = Utils::getName($row->Designation,"DesignationMaster", "Name", $this->db);
				$res['empgrade'] = Utils::getName($row->Grade,"GradeMaster", "Name", $this->db);
				$res['empsts'] = Utils::getOtherName($row->EmployeeStatus,"EmployeeStatus", $this->db);
				$res['empsts1'] = $row->EmployeeStatus;
				$res['salaryctc'] = $row->EmployeeCTC;
				$res['emplocation'] = Utils::getName($row->Location,"LocationMaster", "Name", $this->db);
				//$res['empgratuity']=round(Utils::getEmployeeGratuity($row->Id,1,$this->db));
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    public function getAllCompetencyType($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sql = "";
		if($sts==1 || $hrsts==1){
			//$ids =Utils::getReportingIds($mid, $this->db); 
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) order by FirstName ";
			
		}	
		else{		
			$ids =Utils::getReportingIds($mid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) and Id in ($ids) order by FirstName ";
		}	
		$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array(':id' => $orgid ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['sts'] = 0;
				$res['empreport'] = Utils::getName($row->ReportingTo,"EmployeeMaster", "FirstName", $this->db).' '.Utils::getName($row->ReportingTo,"EmployeeMaster", "LastName", $this->db);
				$res['empdivision'] = Utils::getName($row->Division,"DivisionMaster", "Name", $this->db);
				$res['empdepartment'] = Utils::getName($row->Department,"DepartmentMaster", "Name", $this->db);
				$res['empdesignation'] = Utils::getName($row->Designation,"DesignationMaster", "Name", $this->db);
				$res['empgrade'] = Utils::getName($row->Grade,"GradeMaster", "Name", $this->db);
				$res['empsts'] = Utils::getOtherName($row->EmployeeStatus,"EmployeeStatus", $this->db);
				$res['empsts1'] = $row->EmployeeStatus;
				$res['salaryctc'] = $row->EmployeeCTC;
				$res['emplocation'] = Utils::getName($row->Location,"LocationMaster", "Name", $this->db);
				//$res['empgratuity']=round(Utils::getEmployeeGratuity($row->Id,1,$this->db));
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAlltrainerdata($trainerid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();		
		$sql = "";	
		//$ids =Utils::getReportingIds($mid, $this->db); 
		$sql = "SELECT * FROM trainer WHERE TrainerId = $trainerid";		
		$query = $this->db->prepare($sql);
			try{				
				$query->execute(array());
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['trainer_name'] = $row->Name;			
				$res['trainer_address'] =$row->Address;
				$res['trainer_mobile']=(int)$row->Mobile;
				$res['trainer_email']=$row->Email;
				$res['trainer_qualification']=$row->Qualification;
				$res['trainer_specialization']=$row->Specialization;
				$res['trainer_experience']=$row->Experience;
				//$res['empgratuity']=round(Utils::getEmployeeGratuity($row->Id,1,$this->db));
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAlltrainingdata($trainingid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$sql = "";
		$sql = "SELECT * FROM training WHERE TrainingId = $trainingid";
		$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array());
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				//$res['KPI'] = $row->KPI;
				$kpi= explode(',', $row->KPI);
				$kpiarr=array();				
				foreach($kpi as $value)
				{						
						$kpiarr[]=$value;
				}
				$res['KPI']=$kpiarr;
				$res['DesignationId'] =(int)$row->DesignationId;
				$res['traineeid']=(int)$row->trainee;
				$empcode=$this->getName("EmployeeCode","Id",$row->trainee,"EmployeeMaster");
				$firstname=$this->getName("FirstName","Id",$row->trainee,"EmployeeMaster");
				$lastname=$this->getName("LastName","Id",$row->trainee,"EmployeeMaster");
				$res['traineename']=$empcode."-".$firstname." ".$lastname;
				$res['trainer']=$row->trainer;
				$startdate = strtotime($row->startdate);
				$startdate=date("m/d/Y",$startdate);
				$res['startdate']=$startdate;
				$enddate = strtotime($row->enddate);
				$enddate=date("m/d/Y",$enddate);
				$res['enddate']=$enddate;	
				$res['timefrom']=$row->timefrom;
				$res['timeto']=$row->timeto;				
				//$res['empgratuity']=round(Utils::getEmployeeGratuity($row->Id,1,$this->db));
				$data[] = $res;
			}
        }else{
			$status=false;
			$errorMsg = "";
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;		
		return $result;
    }
	
	public function CreateTraining($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); 
		$uid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$kpi_id = $request[2];
		$kpi_ids="";
			foreach($kpi_id as $value){
				if($kpi_ids==""){
					$kpi_ids=$value;
				}else{
					$kpi_ids.=",".$value;					
				}
			}
		$trainee[] = $request[3];		
		$trainerid = $request[4];	
		$designation = $request[9];	
		
		 //$sdate = strtotime($request[5]);
		$startdate=date("Y-m-d",strtotime($request[5]));
		$enddate=date("Y-m-d",strtotime($request[6]));
		
		//$edate = $request[6];	
		// $enddate=date("Y-m-d",$edate);
		//die();
		$timefrom = $request[7];	
		$timeto = $request[8];	
		
		//print_r($trainee[0][0]["id"]);
		try{
			
		foreach($trainee as $value)
			{
				foreach($value as $value1){					
					$sqlv="INSERT into training(DesignationId,KPI,trainee,trainer,startdate,enddate,timefrom,timeto,OrganizationId) values (?,?, ?, ?, ?, ?, ?, ?,?)";
					$queryv=$this->db->prepare($sqlv);
					$queryv->execute(array($designation,$kpi_ids,$value1['id'],$trainerid,$startdate,$enddate,$timefrom,$timeto,$orgid));
					$count =$queryv->rowCount();				
				}
			}
			
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		if ($count==1) {
		   $status =true;
		   $successMsg = TRAINING_MODULE_CREATE_SUCCESS;
		  
		} else {
		   $status =false;
		   $errorMsg = PERFORMANCE_INDICATOR_MODULE_CREATION_FAILED;
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
		public function CreateTrainer($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); 
		$uid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$trainer_name = $request[2];
		$trainer_email = $request[3];		
		$trainer_address = $request[4];	
		$trainer_mobile = $request[5];	
		$trainer_experience = $request[6];	
		$trainer_qualification = $request[7];
		$trainer_specialization=$request[8];
		
		//print_r($trainee[0][0]["id"]);
		try{
			
			
		$sqlv="INSERT into trainer(Name,Mobile,Email,Address,Qualification,Specialization,Experience,OrganizationId) values (?, ?, ?, ?, ?, ?, ?, ?)";
		$queryv=$this->db->prepare($sqlv);
		$queryv->execute(array($trainer_name,$trainer_mobile,$trainer_email,$trainer_address,$trainer_qualification,$trainer_specialization,$trainer_experience,$orgid));
		$count =$queryv->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		if ($count==1) {
		   $status =true;
		   $successMsg = "Trainer added successfully.";
		  
		} else {
		   $status =false;
		   $errorMsg = "Problem while  adding trainer.";
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function updateTraining($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); 
		$uid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
			$kpi_id = $request[2];
		$kpi_ids="";
			foreach($kpi_id as $value){
				if($kpi_ids==""){
					$kpi_ids=$value;
				}else{
					$kpi_ids.=",".$value;					
				}
			}
		$trainee[] = $request[3];		
		$trainerid = $request[4];	
		
		$startdate=date("Y-m-d",strtotime($request[5]));
		$enddate=date("Y-m-d",strtotime($request[6]));
		$timefrom = $request[7];	
		$timeto = $request[8];	
		$designationid = $request[9];
			$trainingid = $request[10];
		//print_r($trainee[0][0]["id"]);
		try{
			
		foreach($trainee as $value)
			{
				foreach($value as $value1){
					
			$sqlv="update training set DesignationId=?,KPI=?,trainee=?,trainer=?,startdate=?,enddate=?,timefrom=?,timeto=?,OrganizationId=? where TrainingId=?";
			$queryv=$this->db->prepare($sqlv);
			$queryv->execute(array($designationid,$kpi_ids,$value1['id'],$trainerid,$startdate,$enddate,$timefrom,$timeto,$orgid, $trainingid));
			$count =$queryv->rowCount();
				
				}
			}
			
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		if ($count==1) {
		   $status =true;
		   $successMsg = TRAINING_MODULE_UPDATE_SUCCESS;
		  
		} else {
		   $status =false;
		   $errorMsg = PERFORMANCE_INDICATOR_MODULE_CREATION_FAILED;
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function updateTrainer($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); 
		$uid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$trainer_name = $request[2];
		$trainer_email = $request[3];		
		$trainer_address = $request[4];	
		$trainer_mobile = $request[5];	
		$trainer_experience = $request[6];	
		$trainer_qualification = $request[7];
		$trainer_specialization=$request[8];
		$trainerid=$request[9];
		
		try{
			
			
		$sqlv="Update trainer set Name='$trainer_name',Mobile='$trainer_mobile',Email='$trainer_email',Address='$trainer_address',Experience='$trainer_experience',Qualification='$trainer_qualification',Specialization='$trainer_specialization' where TrainerId=$trainerid and OrganizationId=$orgid";
		$queryv=$this->db->prepare($sqlv);
		$queryv->execute(array());
		$count =$queryv->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}	
		if ($count==1) {
		   $status =true;
		   $successMsg = PERFORMANCE_INDICATOR_MODULE_CREATION_SUCCESS;
		  
		} else {
		   $status =false;
		   $errorMsg = PERFORMANCE_INDICATOR_MODULE_CREATION_FAILED;
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']="Trainer has been updated successfully";
		$result['errorMsg']="This information not successfully updated";
        // default return
        return $result;
    }
	
	public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); 
		$uid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		try{
			
			$sqlv="INSERT into performance_indicator_master(attribute, marks, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById) values (?, ?, ?, ?, ?, ?, ?)";
			$queryv=$this->db->prepare($sqlv);
			$queryv->execute(array($request[2],$request[3],$orgid,$mdate, $uid, $mdate, $uid));
			$count =$queryv->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		if ($count==1) {
		   $status =true;
		   $successMsg = PERFORMANCE_INDICATOR_MODULE_CREATION_SUCCESS;
		  
		} else {
		   $status =false;
		   $errorMsg = PERFORMANCE_INDICATOR_MODULE_CREATION_FAILED;
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); 
		$uid   = $request[0];	
		try{
			
			$sqlv="UPDATE performance_indicator_master SET attribute=?, marks=?, CreatedDate=?, CreatedById=?, LastModifiedDate=?, LastModifiedById=? WHERE id=?";
			$queryv=$this->db->prepare($sqlv);
			$queryv->execute(array($request[2],$request[3],$mdate, $uid, $mdate, $uid,$request[4]));
			$count =$queryv->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}		
		if ($count==1) {
		   $status =true;
		   $successMsg = PERFORMANCE_INDICATOR_MODULE_UPDATION_SUCCESS;
		  
		} else {
		   $status =false;
		   $errorMsg = PERFORMANCE_INDICATOR_MODULE_UPDATION_FAILED;
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			
				$sql = "DELETE FROM performance_indicator_master WHERE id = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = PERFORMANCE_INDICATOR_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = PERFORMANCE_INDICATOR_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function DeleteTraining($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			
				$sql = "DELETE FROM training WHERE TrainingId = $did ";
				$query = $this->db->prepare($sql);
				$query->execute(array());
				$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = TRAINING_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = PERFORMANCE_INDICATOR_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function DeleteTrainer($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			
				$sql = "DELETE FROM trainer WHERE TrainerId = $did ";
				$query = $this->db->prepare($sql);
				$query->execute(array());
				$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = PERFORMANCE_INDICATOR_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = PERFORMANCE_INDICATOR_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=" Trainer has been deleted successfully";
		$result['errorMsg']="trainer not successfully deledted";
		
        // default return
        return $result;
    }
	
	public function gettrainerbysorting($editper, $deleteper)
	{
		$sTable = 'training';
		$sIndexColumn = "TrainingId";
		$aColumns = array( 'trainee','KPI','startdate','enddate','trainer','TrainingId','TrainingId');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = " order by startdate desc";
		}else{
				$sOrder = " order by startdate desc";
		}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere ="";
		
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		//$sWhere = " Where Id in (select EmployeeAssessmentId from (select * from EmployeeAssessmentApproval where  AssessmentSts = 0 Group by EmployeeAssessmentId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		$sWhere = "WHERE OrganizationId= $orgid ";
		
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder 
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="TrainingId" && $i==6)
				{
					$edit =""; $edit1="";
					if($editper){						
						$edit = '<a  rel="tooltip" title="Edit" href="editTraining/'.$aRow->TrainingId.'/1" ><i class="fa fa-edit"></i></a>';						
					}
					if($deleteper){						
						$edit1 = '<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->TrainingId.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';						
					}		
					$row[] =$edit.' &nbsp;&nbsp; '.$edit1 ;
				}elseif($aColumns[$i]=="trainee"){
						$firstname = $this->getName("FirstName","Id",$aRow->{$aColumns[$i]}, "EmployeeMaster");
						$lastname = $this->getName("LastName","Id",$aRow->{$aColumns[$i]}, "EmployeeMaster");				
						$row[]=$firstname." ".$lastname;	
				}elseif($aColumns[$i]=="KPI"){
					$KPI_arr = explode(',', $aRow->{$aColumns[$i]});
					$kpi_names="";
					foreach($KPI_arr as $value){
						if($kpi_names==""){
							$kpi_names=$this->getName("Objective","Id",$value, "AssessmentObjectiveChild");	
						}else{
							$kpi_names.=",".$this->getName("Objective","Id",$value, "AssessmentObjectiveChild");	
						}
					}
						$row[] = $kpi_names;		
				}
				elseif($aColumns[$i]=="startdate" || $aColumns[$i]=="enddate" ){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="trainer"){
					$firstname = $this->getName("Name","TrainerId",$aRow->{$aColumns[$i]}, "trainer");
					//$lastname = $this->getName("LastName","Id",$aRow->{$aColumns[$i]}, "trainer");				
					$row[]=$firstname;	
				}elseif($aColumns[$i]=="TrainingId" && $i==5){
					$date_now = date("Y-m-d");
					$status="<label class='label label-success'>Planned</label>";
					if(strtotime($aRow->startdate)<=strtotime($date_now) && strtotime($aRow->enddate)>=strtotime($date_now)){
						$status="<label class='label label-info'>Ongoing</label>";
					}elseif(strtotime($aRow->enddate)<=strtotime($date_now)){
						$status="<label class='label label-danger'>Completed</label>";
					}		
					$row[]=$status;	
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getTraining($editper, $deleteper)
	{
		$sTable = 'training';
		$sIndexColumn = "TrainingId";
		$aColumns = array( 'trainee','KPI','startdate','enddate','trainer','TrainingId','TrainingId');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere ="";
		
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		//$sWhere = " Where Id in (select EmployeeAssessmentId from (select * from EmployeeAssessmentApproval where  AssessmentSts = 0 Group by EmployeeAssessmentId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		$sWhere = "WHERE OrganizationId= $orgid ";
		
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="TrainingId" && $i==6)
				{
					$edit =""; $edit1="";
					if($editper){						
						$edit = '<a  rel="tooltip" title="Edit" href="editTraining/'.$aRow->TrainingId.'/1" ><i class="fa fa-edit"></i></a>';						
					}
					if($deleteper){						
						$edit1 = '<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->TrainingId.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';						
					}		
					$row[] =$edit.' &nbsp;&nbsp; '.$edit1 ;
				}elseif($aColumns[$i]=="TrainingId" && $i==5){
					$date_now = date("Y-m-d");
					$status="<label class='label label-success'>Planned</label>";
					if(strtotime($aRow->startdate)<=strtotime($date_now) && strtotime($aRow->enddate)>=strtotime($date_now)){
						$status="<label class='label label-info'>Ongoing</label>";
					}elseif(strtotime($aRow->enddate)<=strtotime($date_now)){
						$status="<label class='label label-danger'>Completed</label>";
					}		
					$row[]=$status;	
				}elseif($aColumns[$i]=="trainee"){
						$firstname = $this->getName("FirstName","Id",$aRow->{$aColumns[$i]}, "EmployeeMaster");
						$lastname = $this->getName("LastName","Id",$aRow->{$aColumns[$i]}, "EmployeeMaster");				
						$row[]=$firstname." ".$lastname;	
				}elseif($aColumns[$i]=="KPI"){
					$KPI_arr = explode(',', $aRow->{$aColumns[$i]});
					$kpi_names="";
					foreach($KPI_arr as $value){
						if($kpi_names==""){
							$kpi_names=$this->getName("Objective","Id",$value, "AssessmentObjectiveChild");	
						}else{
							$kpi_names.=",".$this->getName("Objective","Id",$value, "AssessmentObjectiveChild");	
						}
					}
						$row[] = $kpi_names;		
				}
				elseif($aColumns[$i]=="startdate" || $aColumns[$i]=="enddate" ){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="trainer"){
						$firstname = $this->getName("Name","TrainerId",$aRow->{$aColumns[$i]}, "trainer");
						//$lastname = $this->getName("LastName","Id",$aRow->{$aColumns[$i]}, "trainer");				
						$row[]=$firstname;	
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getAlltrainer()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id'];		
		$sql = "";	
		//$ids =Utils::getReportingIds($mid, $this->db); 
		$sql = "SELECT * FROM trainer WHERE OrganizationId = ?";
		$query = $this->db->prepare($sql);
		try{				
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->TrainerId;
				$res['name'] = $row->Name;
				$res['name_spe'] = $row->Name." - [".$row->Specialization."]";
				$res['trainer_address'] =$row->Address;
				$res['trainer_mobile']=$row->Mobile;
				$res['trainer_email']=$row->Email;
				$res['trainer_qualification']=$row->Qualification;		
				$res['trainer_specialization']=$row->Specialization;
				$res['trainer_experience']=$row->Experience;
				//$res['empgratuity']=round(Utils::getEmployeeGratuity($row->Id,1,$this->db));
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getTrainer($editper, $deleteper)
	{
		$sTable = 'trainer';
		$sIndexColumn = "TrainerId";
		$aColumns = array( 'Name','Specialization','Qualification','Experience','TrainerId');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere ="";
		
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		//$sWhere = " Where Id in (select EmployeeAssessmentId from (select * from EmployeeAssessmentApproval where  AssessmentSts = 0 Group by EmployeeAssessmentId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		$sWhere = "WHERE OrganizationId= $orgid ";
		
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="TrainerId")
				{
					$edit =""; $edit1="";
					if($editper){
						
						$edit = '<a  rel="tooltip" title="Edit" href="editTrainer/'.$aRow->TrainerId.'/1" ><i class="fa fa-edit"></i></a>';
						
					}
					if($deleteper){
						
						$edit1 = '<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->TrainerId.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
						
					}		
					$row[] =$edit.' &nbsp;&nbsp; '.$edit1 ;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getName($get_name, $where_column, $id, $table)
	{
		$name ="";
		$sql = "SELECT $get_name FROM $table WHERE $where_column = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				$name = $row->$get_name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getCompetencyName($id)
	{
		$name ="";
		$sql = "SELECT Id FROM CompetencyType WHERE Id =(select TypeId from CompetencyMaster where Id=?)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				$name = $row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}

	public function getIndicatorAttributeTable($editper, $deleteper)
	{
		$sTable = 'performance_indicator_master';
		$sIndexColumn = "id";
		$aColumns = array( 'attribute','marks','id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere ="";
		
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		//$sWhere = " Where Id in (select EmployeeAssessmentId from (select * from EmployeeAssessmentApproval where  AssessmentSts = 0 Group by EmployeeAssessmentId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		$sWhere = "WHERE OrganizationId= $orgid ";
		
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id")
				{
					$edit =""; $edit1="";
					if($editper){
						
						$edit = '<a onclick="angular.element(this).scope().onfecthindicator(\''.$aRow->id.'\')" rel="tooltip" title="Edit" data-toggle="modal" data-target="#add_update" href="#" ><i class="fa fa-edit"></i></a>';
						
					}
					if($deleteper){
						$edit1 = '<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}		
					$row[] =$edit.' &nbsp;&nbsp; '.$edit1 ;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getAllRatingcriterias()
    {
		try{
			$org_id=$_SESSION['ubihrm_org_id'];
			$sql = "SELECT * FROM RatingCriteria where org_id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($org_id));
			$result =array(); $data =array(); $status=false;
			while($row1 = $query->fetch())
			{
				$status=true;
				$res1=array();
				$res1['id'] = $row1->Id;
				$res1['minmarks'] = (int)$row1->MinMarks;
				$res1['maxmarks'] = (int)$row1->MaxMarks;
				$res1['result'] = $row1->Result;
				$res1['rating'] =(int) $row1->Rating;
				
				$result[] =$res1;
			}
		}
		catch(Exception $e)
		{
		
		}
		$data['data']=$result;
		$data['status']=$status;
        return $data;
    }

	public function saveAllRatingcriterias()
    {
		$org_id=$_SESSION['ubihrm_org_id'];
       // INSERTING AND UPDATING ASSESSMENT RESULT IF PASSED AS AN JSON 
		$aresult = json_decode($_POST['result'], true); 
		$count=0; $result=array();
		$sql2="delete from RatingCriteria  where  org_id=:org_id";
		$query2= $this->db->prepare($sql2);
		$query2->execute(array(':org_id' =>$org_id));
		for($i=0; $i<count($aresult); $i++)
		{
			if(  $aresult[$i]['result']!=""){
				$record = array();
				$record[0] = $aresult[$i]['minmarks'];
				$record[1] = $aresult[$i]['maxmarks'];
				$record[2] = $aresult[$i]['result'];
				$record[3] = $aresult[$i]['rating'];
				$record[4] = $org_id;
				$id = $aresult[$i]['id'];
					$sqlaresult = " INSERT INTO RatingCriteria (  MinMarks, MaxMarks, Result,Rating,org_id) values (?, ?, ? ,? ,?)";
					$queryaresult = $this->db->prepare($sqlaresult);
					$queryaresult->execute($record);
				//}
				$count+=$queryaresult->rowCount();
			}
		}	
		
        if ($count >= 1) {
			
			$_SESSION["feedback_positive"][] = "Criteria has been saved successfully";
				$status=true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_TEST_CATEGORY_ADDITION_FAILED;
			$status=false;
        }
		$result['data']="";
		$result['status']=$status;
		
        return $result;
        
    }

}
