<?php

/**
 * OtherModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class OtherModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the all country details
     * @return array an array with several objects (the results)
     */
    public function getAllOtherData()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
			
		$sql = "SELECT * FROM OtherMaster";
		$query = $this->db->prepare($sql);
		
		try{
			
			$query->execute();
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['type'] = $row->OtherType;
					$res['name'] = $row->DisplayName;
					$res['value'] = $row->ActualValue;		
					$data[] = $res;
				}
			}else{
				$status=true;
				$successMsg = EMPSTATUS_MODULE_GETALL;
			}
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getAllreligion()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
			
		$sql = "SELECT * FROM ReligionMaster";
		$query = $this->db->prepare($sql);
		
		try{
			
			$query->execute();
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = (int)$row->Id;
					$res['name'] = $row->Name;
						
					$data[] = $res;
				}
			}else{
				$status=true;
				$successMsg = EMPSTATUS_MODULE_GETALL;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAllZones()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$countryid = isset($_POST['countryid']) ? $_POST['countryid'] : "";
		
		$sql = "SELECT * FROM ZoneMaster where CountryId=?";
		$query = $this->db->prepare($sql);
		
		try{
			
			$query->execute(array($countryid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['name'] = ($row->Name=="Asia/Dubai")?"GMT +04:00 , Abu Dhabi":$row->Name;
						
					$data[] = $res;
				}
			}else{
				$status=true;
				$successMsg = EMPSTATUS_MODULE_GETALL;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
}
