<?php

/**
 * OfficialCommunicationModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class OfficialCommunicationModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM OfficLetterMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Title;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = OFFICELETTER_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM OfficLetterMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			$ids =array();
			$empids =array();
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Title;
				$res['msg'] = $row->Message;
			//	print_r(	$res['msg'] );
				$res['seniorsts'] = $row->SeniorSts;
				$seniorids=$row->SeniorIds;
				$res['employeeid']=array();
				//$ids = explode(',',$row->EmployeeId.','.$seniorids);
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id in ( ? )";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->EmployeeId ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->Id;
					$res1['name'] =$row1->EmployeeCode."-". $row1->FirstName." ". $row1->LastName;
					$res1['sts'] =0;
					$res1['senior'] =  Utils::getEmployeeName($row1->ReportingTo, $this->db);
					
					$res['employeeid'][]=$res1;
				}
			
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
			
           $status =true;
		   $successMsg = OFFICELETTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = OFFICELETTER_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmployeeData($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id']; 
		$currencyid=0;
		$id=is_array($id)?implode(',',$id):$id;
        $sql = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ? ";
		//Utils::Trace($sql);
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($id,$orgid));
			$count =  $query->rowCount();
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			$salarydetails =array();
			if($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['code'] = $row->EmployeeCode;
				$res['firstname'] = $row->FirstName;
				$res['lastname'] = $row->LastName;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['sts'] = 0;
				$res['empgender'] = $row->Gender;
				$res['empdivision'] = Utils::getName($row->Division,"DivisionMaster", "Name", $this->db);
				$res['empdepartment'] = Utils::getName($row->Department,"DepartmentMaster", "Name", $this->db);
				$res['empdesignation'] = Utils::getName($row->Designation,"DesignationMaster", "Name", $this->db);
				$res['reportingto'] = Utils::getEmployeeName($row->ReportingTo, $this->db);
				$res['reportingtodesig'] = $this->getDesignation($row->ReportingTo);
				$res['salaryctc'] = $row->EmployeeCTC;
				$res['empsts'] = Utils::getOtherName($row->EmployeeStatus,"EmployeeStatus", $this->db);
				$res['empdoc'] =Utils::dateformatter($row->DOC); 
				$res['empgrade'] = Utils::getName($row->Grade,"GradeMaster", "Name", $this->db);
				$res['org'] = Utils::getName($row->OrganizationId,"Organization", "Name", $this->db);
				$res['address'] = Utils::decode5t($row->CurrentAddress);
				$res['contact'] =Utils::decode5t($row->CurrentContactNumber);
				$res['dob'] = Utils::dateformatter($row->DOB);
				$res['doj'] = Utils::dateformatter($row->DOJ);
				$res['dol'] = Utils::dateformatter($row->DOL);
				$res['doj1']= date("dS F Y", strtotime($row->DOJ));
				$res['dol1'] =date("dS F Y", strtotime($row->DOL));
				$currencyid = Utils::getName($row->OrganizationId,'Organization','Currency',$this->db);
				$orgcountry = Utils::getName($row->OrganizationId,'Organization','Country',$this->db);
				$res['orgcountry']=Utils::getName($orgcountry,'CountryMaster','Name',$this->db);
				$orgcity = Utils::getName($row->OrganizationId,'Organization','City',$this->db);
				$res['orgcity']=Utils::getName($orgcity,'CityMaster','Name',$this->db);
				$res['currency']=Utils::getName($currencyid,'CurrencyMaster','CurrencyName',$this->db);
				$res['empnat'] = Utils::getName($row->Nationality,'NationalityMaster','Name',$this->db);
				$res['senton']= date("Y-m-d");
				$passportno="N/A";
				$res['companyemail'] = Utils::decode5t($row->CompanyEmail);
			
				$sql1="select DocumentNumber From EmployeeDocument where EmployeeId=? and DocumentTypeId=(select Id from DocumentMaster where Name like '%passport%' and DocType=1 and OrganizationId=$orgid)";
				$query1=$this->db->prepare($sql1);
				$query1->execute(array($id));
				while($r1=$query1->fetch())
				{
					$passportno=Utils::decode5t($r1->DocumentNumber);	
				}
				$res['passport'] = $passportno;
				$res['doc'] = Utils::dateformatter($row->DOC);
				$sql1 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId = ? and BankStatus=1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($id));
				if($row1 = $query1->fetch())
					{
						
						$res['bank'] = Utils::getName($row1->BankId,'BankMaster','Name',$this->db);
						$res['iban'] = Utils::decode5t($row1->IBAN);
						$res['branch'] = Utils::decode5t($row1->Branch);
										
					}else{
						$res['bank'] = 'N/A';
						$res['iban'] =  'N/A';
						$res['branch'] = 'N/A';
					}	
				
				$sql = "select EmployeeMaster.Id,DesignationMaster.Name from DesignationMaster,EmployeeMaster where DesignationMaster.Id=EmployeeMaster.Designation and DesignationMaster.HrSts=1 and EmployeeMaster.OrganizationId=? and DesignationMaster.OrganizationId=?";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid,$orgid));
				if($r=$query->fetch()){
					$res['hrname'] = Utils::getEmployeeName($r->Id,$this->db);
					$res['hrdesig'] = $r->Name;
				}
				
				$sql = "SELECT Address from Organization WHERE ID = ?";
				$query2 = $this->db->prepare($sql);
				$query2->execute(array( $orgid));
				if($r1=$query2->fetch()){
					$res['orgaddress'] = $r1->Address;
					
				}

				$data[] = $res;
				
			}
        }
		
		if ($count == 1) {
			
           $status =true;
		   $successMsg = OFFICELETTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = OFFICELETTER_MODULE_GETDETAIL_FAILED;
        }
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		//print_r($result["data"]);
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getLetter($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $data1 = array();
		$userid = $_SESSION['ubihrm_user_id'];
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM OfficLetterMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			$ids =array();
			$empids =array();
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Title;
				$res['msg'] = $row->Message;
				$res['seniorsts'] = $row->SeniorSts;
				$ids = explode(',',$row->EmployeeId);
				$res['employeeid']=array();
				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id in ( ? )";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->EmployeeId ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->Id;
					$res1['name'] =$row1->EmployeeCode."-". $row1->FirstName." ". $row1->LastName;
					$res1['sts'] =0;
					$res1['senior'] =  Utils::getEmployeeName($row1->ReportingTo, $this->db);
					$res['employeeid'][]=$res1;
				}
				
				
				for($i=0;$i<count($ids);$i++)
				{
					$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $ids[$i] ));
					while($row = $query1->fetch())
					{
						$res1 = array();
						$res1['id'] = $row->Id;
						$res1['name'] =$row->EmployeeCode."-". $row->FirstName." ". $row->LastName;
						$res1['firstname'] = $row->FirstName;
						$res1['lastname'] = $row->LastName;
						$res1['desig'] = $this->getName($row->Designation,'DesignationMaster');
						$res1['dept'] = $this->getName($row->Department,'DepartmentMaster');
						$res1['div'] = $this->getName($row->Division,'DivisionMaster');
						$res1['org'] = $this->getName($row->OrganizationId,'Organization');
						$res1['dob'] = Utils::dateformatter($row->DOB);
						$res1['doj'] = Utils::dateformatter($row->DOJ);
						$res1['doc'] = Utils::dateformatter($row->DOC);
						$res1['reportingto'] = Utils::getEmployeeName($row->ReportingTo, $this->db);
						$res1['reportingtodesig'] = $this->getDesignation($row->ReportingTo);
						$data1[] = $res1;
						
					}
				}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
			
           $status =true;
		   $successMsg = OFFICELETTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = OFFICELETTER_MODULE_GETDETAIL_FAILED;
        }
		$result["data1"] =$data1;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
    /**
     * Setter for a OfficLetterMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
  public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		$sql = "UPDATE OfficLetterMaster SET Title=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? attachfile=? where Id=?";
		$query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array($request[2], $orgid, $mdate, $mid, $request[3], $request[7] ));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			$empid=Utils::getName($request[3],'OfficLetterMaster','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Official Communication has been updated.";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Employee", $msg, $orgid));
           $status =true;
		   $successMsg = OFFICELETTER_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = OFFICELETTER_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }


   
    /**
     * Setter for a OfficLetterMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
   /* public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $user_email="";
		$mdate = date("Y-m-d H:i:s");
		$seniorids="";
		if($request[5] == 1){
			$seniorids=Utils::getSeniorId($request[4],$this->db);
		}
		///////////certificate issue in CertificateReleaseMaster if certificate id not ZERO /////////////
		if($request[6] != 0){
			$sql1="UPDATE CertificateReleaseMaster set ApproverSts=? WHERE Id =?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(6,$request[6]));
		}
		$mailsts=0;
		if($request[7]){
			$mailsts=1;
		}
			$sql = "INSERT INTO OfficLetterMaster (Title, Message, OrganizationId, EmployeeId,SeniorSts,SeniorIds,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,MailSts) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?,?, ?)";
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $request[3], $orgid, $request[4],$request[5],$seniorids, $mdate, $mid, $mdate, $mid, $mid,$mailsts));	
			$count =  $query->rowCount();	
			if($mailsts==1){
				///////////for send email//////////
				$sql="SELECT * from EmployeeMaster where Id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($request[4]));
				while($row=$query->fetch()) {
					$user_email=$row->CompanyEmail;
					$user_name=$row->FirstName.' '.$row->LastName;
				}
				/* if($seniorids !=""){
					$sql="SELECT * from EmployeeMaster where Id=?";
					$query = $this->db->prepare($sql);
					$query->execute(array($seniorids));
					while($row=$query->fetch())
					{
						$user_email1=$row->CompanyEmail;
						$user_name1=$row->FirstName.' '.$row->LastName;
					}	
					if($user_email1 != "")
					{
						$emailsts=Utils::sendOfficialCommunicationMail($user_email1,$user_name1,$request[2],$request[3]);
					}
				} */
				/*$emailsts='';			
				if($user_email!="")
				{
					$emailsts=Utils::sendMail($user_email,$user_name,$request[2],$request[3]);
				}
			}
			///////////////////////////echo$emailsts;
			if ($count == 1) {
			
				/*if($request[4]!="")
				$temp = explode(",", $request[4]);
				for($i=0; $i<count($temp); $i++)
				{
					$title= $request[2];//"Office Communication";
					$msg ="The letter has been issued by the ".$this->getName($mid)." on ".date("d F, Y", strtotime($mdate));
					$sql = "INSERT INTO EmployeeHistory (EmployeeId, Title, Message, EventDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($temp[$i], $title, $msg, $mdate, $orgid));
					
				}*/
				//$empid=Utils::getName($request[3],'OfficLetterMaster','EmployeeId',$this->db);
				/*$empname=Utils::getName($request[4],'EmployeeMaster','FirstName',$this->db);
				$msg="Official Communication for $empname titled <b>'$request[2]'</b> has been created.";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Official Communication", $msg, $orgid));
			   $status =true;
			   $successMsg = "Official Letter Issued Successfully" ;
			} else {
			   $status =false;
			   $errorMsg = OFFICELETTER_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }*/

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
	 public function Create($request)
    {
		$result = array();
		$count=0;$count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $user_email="";
		$mdate = date("Y-m-d H:i:s");
		$seniorids="";
		$letterid=""; $new_name=""; $dir=""; $dir1="";
		$emp_email=$request[8];
		if($request[5] == 1)
		{
			$seniorids=Utils::getSeniorId($request[4],$this->db);
		}
		///////////certificate issue in CertificateReleaseMaster if certificate id not ZERO /////////////
		if($request[6] != 0)
		{
			$sql1="UPDATE CertificateReleaseMaster set ApproverSts=? WHERE Id =?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array(6,$request[6]));
		}
		$mailsts=0;
		if($request[7])
		{
			$mailsts=1;
		}
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		
		$sql = "INSERT INTO OfficLetterMaster (Title, Message, OrganizationId, EmployeeId,SeniorSts,SeniorIds,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,MailSts) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?,?, ?)";
		//	echo $sql;
		try
		{
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $request[3], $orgid, $request[4],$request[5],$seniorids, $mdate, $mid, $mdate, $mid, $mid,$mailsts));	
			$count1 =  $query->rowCount();
			$letterid =$this->db->lastInsertId();
			$file="";
			if($letterid!="")
			{
				$empcode=$this->getCode($request[4]);
				$dir="public/uploads/$orgid/officialcommunication";
				if (! is_dir($dir))
				{ 
			//echo 'ok';
					mkdir($dir);
					chmod($dir,0755);
					$dir1="public/uploads/$orgid/officialcommunication/$empcode";
					if (! is_dir($dir1))
					{ 
					mkdir($dir1);
					chmod($dir1,0755);
					}
				}
				else
				{
					$dir1="public/uploads/$orgid/officialcommunication/$empcode";
					if (! is_dir($dir1))
					{ 
					mkdir($dir1);
					chmod($dir1,0755);
					}
					
				}
				
				$filename="";
				if(isset($_FILES))
				{
					$con=count($_FILES);	
					for($i=0;$i<$con;$i++)
					{
						if(isset($_FILES['file'.$i]))
						{
							
							$doc1="$empcode".'_'."$letterid";
				
							$errors= array();
							$file_name = $_FILES['file'.$i]['name'];
							$ext = pathinfo($file_name, PATHINFO_EXTENSION);
							if ($ext=='doc' || $ext=='pdf' || $ext=='docx')
							{ 
								if (is_dir($dir1))
								{
									if ($dh = opendir($dir1))
									{
										while (($file = readdir($dh)) != false)
										{
											$filename=$file;
											$ext1 = pathinfo($filename, PATHINFO_EXTENSION);
											if($filename=="$doc1.$ext1")
											{
											unlink("public/uploads/$orgid/officialcommunication/$empcode/$filename");
											}
										}
										closedir($dh);
									}
								}
								$new_name="$empcode".'_'."$letterid.$ext";
								
								$file_size =$_FILES['file'.$i]['size'];
								$file_tmp =$_FILES['file'.$i]['tmp_name'];
								$file_type=$_FILES['file'.$i]['type'];   
								$location="public/uploads/$orgid/officialcommunication/$empcode/";
								$file=$location.$new_name;
								if($file_size > 5242880)
								{
									$errors[]='File size must be less than 5 MB';
								}	
							
								if(empty($errors)==true)
								{
									if(move_uploaded_file($file_tmp, $location.$new_name))
									{
									$count++;
									}
								
								}
								else
								{
									print_r($errors);
								}
								if ($count >= 1) 
								{
									$sql="Update OfficLetterMaster set attachfile=? where EmployeeId=? And Id =? ";
									Utils::Trace($sql);
									$query=$this->db->prepare($sql);
									$query->execute(array($new_name,$request[4],$letterid));
									
									$status =true;
									$successMsg = EMPLOYEE_MODULE_DOCUPLOAD;
								}
								else
								{
								   $status =false;
								   $errorMsg = EMPLOYEE_MODULE_DOCUPLOAD_FAILED;
								}
							}
							else
							{
							   $status =false;
							   $errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
							}
						}
						else
						{
							$con++;
						}
					}
				}
				else
				{
					$status =false;
					$errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
				}
				
			}
			
			//if($mailsts==1)
			//{
				///////////for send email//////////
				$sql="SELECT * from EmployeeMaster where Id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($request[4]));
				while($row=$query->fetch()) {
			//		$user_email=Utils::decode5t($row->CompanyEmail);
					$user_email=$emp_email;
					$user_name=$row->FirstName.' '.$row->LastName;
				}
				$emailsts='';			
				if($user_email!="")
				{	
					Utils::Trace($user_email);
					Utils::Trace($user_name);
					Utils::Trace($request[2]);
					Utils::Trace($request[3]);
					Utils::Trace($file);
					 $emailsts=Utils::sendMail($user_email,$user_name,$request[2],$request[3],$file);
					 
					Utils::Trace($emailsts);
					
				
				}
				$emailsts1='';
				
				if($seniorids !=""){
					/* $sql1="SELECT * from EmployeeMaster where Id=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($seniorids));
					while($row1=$query1->fetch())
					{
						$user_email1=Utils::decode5t($row1->CompanyEmail);
						$user_name1=$row1->FirstName.' '.$row1->LastName;
						
					}	
					if($user_email1 != "")
					{	
						$emailsts1=Utils::sendMail($user_email1,$user_name1,$request[2],$request[3],$file);
						
					} */
				} 
				
				
			//}
			///////////////////////////echo$emailsts;
			if ($count1 == 1)
			{
			
				/*if($request[4]!="")
				$temp = explode(",", $request[4]);
				for($i=0; $i<count($temp); $i++)
				{
					$title= $request[2];//"Office Communication";
					$msg ="The letter has been issued by the ".$this->getName($mid)." on ".date("d F, Y", strtotime($mdate));
					$sql = "INSERT INTO EmployeeHistory (EmployeeId, Title, Message, EventDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($temp[$i], $title, $msg, $mdate, $orgid));
					
				}*/
				//$empid=Utils::getName($request[3],'OfficLetterMaster','EmployeeId',$this->db);
				$empname=Utils::getName($request[4],'EmployeeMaster','FirstName',$this->db);
				$msg="Official Communication for $empname titled <b>'$request[2]'</b> has been created.";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee", $msg, $orgid));
			   $status =true;
			   $successMsg = "Official Letter Issued Successfully" ;
			} 
			else
			{
			   $status =false;
			   $errorMsg = OFFICELETTER_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e)
		{
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["letterid"] = $letterid;
		$result["emp_id"] = $request[4];
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		//print_r($result['successMsg']);
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$empid=Utils::getName($did,'OfficLetterMaster','EmployeeId',$this->db);
		$sql = "DELETE FROM OfficLetterMaster WHERE Id = :id ";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Official Communication of $empname has been deleted";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Official Communication Model", $msg, $orgid));
           $status =true;
		   $successMsg = OFFICELETTER_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = OFFICELETTER_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				if($table == 'EmployeeMaster'){
					$name = $row->EmployeeCode." ".ucwords(strtolower($row->FirstName. " " .$row->LastName));
				}
				else{
					$name = $row->Name;
				}
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	public function getDesignation($id)
	{
		$name ="";
		$sql = "SELECT Designation FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name =  Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'OfficLetterMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Title', 'EmployeeId', 'CreatedDate', 'Id','attachfile');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId IN ($ids) and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";	$print1="";	$print="";$download="";
					if($editper){
						$id=Utils::encode5t($aRow->{$aColumns[$i]});
						$edit = '<a rel="tooltip" title="View" href="'.URL.'employee/viewofficialcommunication/'.$id.'" ><i class="fa fa-eye"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper && ($hrsts==1 || $sts==1)){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" title="Delete"><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
					$print1=$this->getDetail($aRow->Id);
					//print_r($print1['data'][0]['msg']);
					if($print1['data']){
						$print ='<a rel="tooltip" onclick="angular.element(this).scope().printDiv(\''.$print1['data'][0]['msg'].'\')"  href="#" title="Print"><i class="fa fa-print"></i></a>';	
					}
					$empcode=$this->getCode($aRow->EmployeeId);
						if($aRow->attachfile != '')
						{
							$download = '<a rel="tooltip" title="Download"  target="_blank" href="'.URL.'public/uploads/'.$orgid.'/officialcommunication/'.$empcode.'/'.$aRow->attachfile.'" ><i class="fa fa-download"></i></a>';
						}
						else
						{
							$download = '<a href="#" rel="tooltip" title="No permission to edit"></a>';
						}
					$row[] =$edit.'&nbsp;&nbsp;|&nbsp;&nbsp;'.$delete.'&nbsp;&nbsp;|&nbsp;&nbsp;'.$download;
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] =Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="EmployeeId"){
					$row[] =Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
				}
				else if($aColumns[$i]=="Title")
				{
					$id=Utils::encode5t($aRow->Id);
					$row[] = '<a href="'.URL.'employee/viewofficialcommunication/'.$id.'">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getCode($id)
	{
		$empcode ="";
		$sql = "SELECT EmployeeCode FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->EmployeeCode;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	public function uploadDocument($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];
		$letterid = isset($_POST['letterid'])?$_POST['letterid']:0;
		$dir1="";
		$empcode=$this->getCode($empid);
		
		$new_name="";
		//$this->deletedoc("public/uploads/$orgid/2SD" );
		$dir="public/uploads/$orgid/officialcommunication";
		
		if (! is_dir($dir))
		{ 
			mkdir($dir);
			chmod($dir,0755);
			$dir1="public/uploads/$orgid/officialcommunication/$empcode";
			if (! is_dir($dir1))
			{ 
			mkdir($dir1);
			chmod($dir1,0755);
			}
		}
		else
		{
			$dir1="public/uploads/$orgid/officialcommunication/$empcode";
			if (! is_dir($dir1))
			{ 
			mkdir($dir1);
			chmod($dir1,0755);
			}
			
		}
		
		$filename="";
			if(isset($_FILES)){
			$con=count($_FILES);	
			for($i=0;$i<$con;$i++){
				if(isset($_FILES['file'.$i]))
				{
					
					$doc1="$empcode".'_'."$letterid";
		
					$errors= array();
					$file_name = $_FILES['file'.$i]['name'];
					$ext = pathinfo($file_name, PATHINFO_EXTENSION);
					if ($ext=='doc' || $ext=='pdf' || $ext=='docx')
					{ 
						if (is_dir($dir1))
						{
							if ($dh = opendir($dir1)) {
								while (($file = readdir($dh)) != false) {
									$filename=$file;
									$ext1 = pathinfo($file_name, PATHINFO_EXTENSION);
									if($filename=="$doc1.$ext1")
									{
										unlink("public/uploads/$orgid/officialcommunication/$empcode/$filename");
									}
								}
							closedir($dh);
							}
						}
						$new_name="$empcode".'_'."$letterid.$ext";
					
						$file_size =$_FILES['file'.$i]['size'];
						$file_tmp =$_FILES['file'.$i]['tmp_name'];
						$file_type=$_FILES['file'.$i]['type'];   
						$location="public/uploads/$orgid/officialcommunication/$empcode/";
						if($file_size > 5242880)
						{
						$errors[]='File size must be less than 5 MB';
						}	
					
						if(empty($errors)==true)
						{
							if(move_uploaded_file($file_tmp, $location.$new_name))
							{
							$count++;
							}
						
						}
						else
						{
							print_r($errors);
						}
						if ($count >= 1) 
						{
							$sql="Update OfficLetterMaster set attachfile=? where EmployeeId=? And Id =? ";
							Utils::Trace($sql);
							$query=$this->db->prepare($sql);
							$query->execute(array($new_name,$empid,$letterid));
							
							$status =true;
							$successMsg = EMPLOYEE_MODULE_DOCUPLOAD;
						}
						else
						{
						   $status =false;
						   $errorMsg = EMPLOYEE_MODULE_DOCUPLOAD_FAILED;
						}
					}
					else
					{
					   $status =false;
					   $errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
					}
				}
				else
				{
					$con++;
				}
			}
			}else{
				$status =false;
				   $errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
        // default return
        return $result;
	
	}
}
