<?php

class NotificationscroneModel
{
	public $smtpuser="";
	public $smtpassword="";
    /**
     * Constructor, expects a Database connection
     * @param Database $this->db The Database object
     */

    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	
	public function UpdateNotifications(){
		$sql = "SELECT Id,TimeZone FROM Organization where Id in (Select distinct OrganizationId from SettingChild)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array());
			while($row = $query->fetch())
			{
				$timezone=$row->TimeZone;
				if($timezone != 0)
				{
					$sql1 = "SELECT Name FROM ZoneMaster where Id=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($timezone));
					if($r=$query1->fetch()){
						//define('TIMEZONE', Session::get('ubihrm_timezone'));
						date_default_timezone_set($r->Name);
						$now = new DateTime();
						$mins = $now->getOffset() / 60;
						$sgn = ($mins < 0 ? -1 : 1);
						$mins = abs($mins);
						$hrs = floor($mins / 60);
						$mins -= $hrs * 60;
						$offset = sprintf('%+d:%02d', $hrs*$sgn, $mins);
						try {
							$this->db->exec("SET time_zone='$offset'");				
						} catch (PDOException $e) {
							die('Database connection could not be established.');
						}	
					}
					 $this->smtpuser=Utils::getName($row->Id, 'Organization','smtpuser',$this->db);
					 $this->smtpassword=Utils::getName($row->Id, 'Organization','smtppassword',$this->db);
					 $this->DeleteNotifications($row->Id);
					 $this->GenerateEmployeeAlerts($row->Id);
					 $this->GenerateSalaryAlerts($row->Id);
					 $this->GenerateLeaveAlerts($row->Id); 
					 $this->GenerateOrgAlerts($row->Id);
					 $this->GenerateTimesheetAlerts($row->Id);
					 $this->GeneratePerformanceAlerts($row->Id); 
				}
			}
			/* This function is used for setting time out if timeout is not marked */	
			// $this->SaveTimeOut(); 
			/* Automatic entry in attendence module , if leave is approved in leave module */	
		}catch(Exception $e){
			echo $e->getMessage();
		}
		/*to calculate execution time*/
		echo $executionTime = microtime(true) - $_SERVER["REQUEST_TIME_FLOAT"];
	}
	
	public function UpdateAtndcNotifications(){
		//place this before any script you want to calculate time
		
		$sql = "SELECT Id,TimeZone FROM Organization where Id in (Select distinct OrganizationId from SettingChild)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array());
			while($row = $query->fetch())
			{
				$timezone=$row->TimeZone;
				if($timezone != 0)
				{
					$sql1 = "SELECT Name FROM ZoneMaster where Id=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($timezone));
					if($r=$query1->fetch()){
						//define('TIMEZONE', Session::get('ubihrm_timezone'));
						date_default_timezone_set($r->Name);
						$now = new DateTime();
						$mins = $now->getOffset() / 60;
						$sgn = ($mins < 0 ? -1 : 1);
						$mins = abs($mins);
						$hrs = floor($mins / 60);
						$mins -= $hrs * 60;
						$offset = sprintf('%+d:%02d', $hrs*$sgn, $mins);
						try {
							$this->db->exec("SET time_zone='$offset'");				
						} catch (PDOException $e) {
							die('Database connection could not be established.');
						}	
					}
					$this->smtpuser=Utils::getName($row->Id, 'Organization','smtpuser',$this->db);
					$this->smtpassword=Utils::getName($row->Id, 'Organization','smtppassword',$this->db);
					$this->GenerateAttendanceAlerts($row->Id);
				}
			}
			/* This function is used for setting time out if timeout is not marked */	
			//$this->SaveTimeOut(); 
			/* Automatic entry in attendence module , if leave is approved in leave module */	
		}catch(Exception $e){
			echo $e->getMessage();
		}
		/*to calculate execution time*/
		echo $executionTime = microtime(true) - $_SERVER["REQUEST_TIME_FLOAT"];
	}
	
	public function GenerateEmployeeAlerts($orgid)
    {
		$mdate= date("Y-m-d H:i:s");
		$date= date("Y-m-d");
		$sWhere = "";
		$hradminarr=$this->getAdminHR($orgid);
		/*fetch settings for setup alerts*/
		$sqlsetting = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and Settingsonoff = 1 and (NotifyAlert=1 or SendMail=1)";
		$querysetting = $this->db->prepare($sqlsetting);
		$querysetting->execute(array($orgid));
		while($rowsetting = $querysetting->fetch()){
			$settingId = $rowsetting->SettingId;
			/*for upcoming birthday*/
			 if($settingId==3){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, LastName,Department, EmployeeCode, CompanyEmail, DOB, datediff( DATE_ADD(dob, INTERVAL YEAR(CURDATE())-YEAR(dob)+ IF(DAYOFYEAR(CURDATE()) >= DAYOFYEAR(dob),1,0) YEAR), curdate()) as diff FROM EmployeeMaster WHERE OrganizationId=? and  DATE_ADD(dob, INTERVAL YEAR(CURDATE())-YEAR(dob) + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0)YEAR) BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyall = $rowsetting->notifyall;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyall==1){
								$ids = implode($this->getAllEmployee($orgid),",");
							}else{
							if($notifyself==1){
								 if($ids=="")
									 $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
						}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->DOB);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
													
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										 $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->DOB);
									}else{
										 $msg = $msgother;
									}
									
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
							
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			} 
			 /*for completion of probation*/
			 else if($settingId==1){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName,Department, LastName, EmployeeCode, CompanyEmail, ReportingTo, DOJ, DATE_ADD(DOJ, INTERVAL Provisionperiod month)  as cdate, datediff(DATE_ADD(DOJ, INTERVAL Provisionperiod month), curdate()) as daysleft FROM EmployeeMaster WHERE Provisionperiod<>0 and OrganizationId = ? and  DATE_ADD(DOJ, INTERVAL Provisionperiod month) BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->cdate);
									}else{
										 $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			/*for new joining*/
			 else if($settingId==2){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, LastName, EmployeeCode, Department, DOJ, CompanyEmail, datediff( DOJ, curdate()) as daysleft FROM EmployeeMaster WHERE  OrganizationId = ? and (CURDATE() BETWEEN DATE_SUB(DOJ, INTERVAL $leaddays DAY) and DOJ) $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->DOJ);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->DOJ);
									}else{
										 $msg = $msgother;
									}
									
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			/*for work anniversary*/
			 else if($settingId==17){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, LastName, Department, EmployeeCode, CompanyEmail, DOJ, YEAR(curdate())-YEAR(DOJ) as completedyears,  DATE_ADD(doj, INTERVAL YEAR(CURDATE())-YEAR(doj) + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(doj),1,0)YEAR)  as wdate, datediff( DATE_ADD(doj, INTERVAL YEAR(CURDATE())-YEAR(doj)+ IF(DAYOFYEAR(CURDATE()) >= DAYOFYEAR(doj),1,0) YEAR), curdate()) as diff FROM EmployeeMaster WHERE OrganizationId=? and  DATE_ADD(doj, INTERVAL YEAR(CURDATE())-YEAR(doj) + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(doj),1,0)YEAR) BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) and YEAR(curdate())-YEAR(DOJ) <> 0  $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->wdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->wdate);
									}else{
										 $msg = $msgother;
									}
								
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									}
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			/*for document expiry*/
			 else if($settingId==12){
				//$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT EmployeeId, DocumentTypeId,ExpiredOn, DATEDIFF(ExpiredOn,curdate()) as daysleft from EmployeeDocument where OrganizationId=? and ExpiredOn<>'0000-00-00' and(DATEDIFF(ExpiredOn,curdate()) between 0 and $leaddays)";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							$dept = Utils::getName($row->EmployeeId,"EmployeeMaster", "Department", $this->db);
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->EmployeeId;
								 else 
									 $ids.= ",".$row->EmployeeId;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->EmployeeId, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->EmployeeId, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->EmployeeId, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($dept, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($dept, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($dept, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->EmployeeId, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->EmployeeId, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->EmployeeId, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->EmployeeId, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->EmployeeId, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->EmployeeId, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->EmployeeId,$row->ExpiredOn);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->EmployeeId){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->EmployeeId,$row->ExpiredOn);
									}else{
										 $msg = $msgother;
									}
								
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									}
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			/*for job confirmation*/
			 else if($settingId==15){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, LastName,Department, EmployeeCode, DOC as cdate FROM EmployeeMaster WHERE OrganizationId=? and  DOC BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
						$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										   $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->cdate);
									}else{
										  $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									}
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for employee promotion*/
			 else if($settingId==26){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT e.Id, e.FirstName,e.Department, e.LastName, e.EmployeeCode, e.ReportingTo, e.DOJ, j.ApplyFrom  as cdate FROM EmployeeMaster e, JobModificationMaster j WHERE e.OrganizationId = j.OrganizationId and e.OrganizationId=? and e.Id=j.EmployeeId and j.PromotionType=1 and j.ApplyFrom BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
						$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->cdate);
									}else{
										 $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									}
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for employee demotion*/
			 else if($settingId==47){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT e.Id, e.FirstName,e.Department, e.LastName, e.EmployeeCode, e.ReportingTo, e.DOJ, j.ApplyFrom  as cdate FROM EmployeeMaster e, JobModificationMaster j WHERE e.OrganizationId = j.OrganizationId and e.OrganizationId=? and e.Id=j.EmployeeId and j.PromotionType=2 and j.ApplyFrom BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
						$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->cdate);
									}else{
										  $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for on employee exit*/
			 else if($settingId==25){
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, LastName,Department, EmployeeCode, DOL FROM EmployeeMaster WHERE OrganizationId=? and  DOL BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) and  DOL!='0000-00-00'";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
						$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->DOL);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
													
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->DOL);
									}else{
										  $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
							
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			} 
			/*After employee exit*/
			 else if($settingId==46){
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, LastName,Department, EmployeeCode, DOL FROM EmployeeMaster WHERE OrganizationId=? and  DOL BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) and  DOL!='0000-00-00'";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
						$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->DOL);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
													
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->DOL);
									}else{
										  $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
							
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			} 
		
		}
		
	}
	
	public function GenerateAttendanceAlerts($orgid)
    {
		//Utils::Trace("enter ".$orgid);
		$mdate= date("Y-m-d H:i:s");
		$date= date("Y-m-d");
		$sWhere = "";
		$hradminarr=$this->getAdminHR($orgid);
		/*fetch settings for setup alerts*/
		$sqlsetting = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and Settingsonoff = 1 and (NotifyAlert=1 or SendMail=1) and SettingId in (29,30,51,58,62,63)";
		$querysetting = $this->db->prepare($sqlsetting);
		$querysetting->execute(array($orgid));
		while($rowsetting = $querysetting->fetch()){
			$settingId = $rowsetting->SettingId;
			/*For absent employees*/
			if($settingId==29){
				////Utils::Trace("enter ".$settingId);
				$dateby = date('Y-m-d');
				$dayofdate= 1 + date("w", strtotime($dateby));
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, Department, Shift,OrganizationId, CompanyEmail, curdate() as tdate from EmployeeMaster WHERE Id not in (select EmployeeId from AttendanceMaster where AttendanceDate=curdate()) and Id not in (select EmployeeId from Timeoff where TimeofDate=curdate() and (CURTIME() between TimeFrom and TimeTo) and ApprovalSts=2) and Id not in (select EmployeeId from EmployeeLeave where OrganizationId=$orgid and Id in (SELECT EmployeeLeaveId FROM `EmployeeLeaveChild` WHERE LeaveDay =curdate())) and Shift in (Select Id from ShiftMaster where time_to_sec(TIMEDIFF(CURTIME(), TimeIn))/60 > $leaddays) and DOL='0000-00-00' and DOJ!='0000-00-00' and curdate()>=date(DOJ) and OrganizationId=$orgid";
				$query = $this->db->prepare($sql);
				try{
					$query->execute();
					$count =  $query->rowCount();
					if($count>=1)
					{
						//Utils::Trace("enter in".$settingId);
						$OffSts=true;
						
						//////// FIND OUT THE HOLIDAY ON THE DAY OF ATTENDANCE  ///////////////////////
								
						$holidaycount=0;
						$sql2 = "SELECT  Id FROM HolidayMaster WHERE OrganizationId = $orgid  and (curdate() between DateFrom and DateTo)";
						$query2 = $this->db->prepare($sql2);
						try{
							$query2->execute();
							$holidaycount =  $query2->rowCount();
							if($holidaycount>0){
								$OffSts=false;
							}
						}catch(Exception $e){
							$errorMsg = 'Message: ' .$e->getMessage();
						}
						if($OffSts){
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							/////FIND OUT THE WEEKLY OFF ON THE DAY OF ATTENDANCE////
							$weekno=Utils::weekOfMonth(date('Y-m-d'));
							$sql1 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=? and Day=?";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($row->Shift,$dayofdate));
							$week="";
							if($row1 = $query1->fetch()){
								$week=$row1->WeekOff;
							}
							$weekarr=explode(",",$week);
							if($query1->rowCount()>0){
							if($weekarr[$weekno-1]==1)
								$OffSts=false;
							}
							if($OffSts){
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->tdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										 $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->tdate);
									}else{
										 $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									//$sts=$this->CheckNotification($title,$msg,$orgid, $emparr[$x]);
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
										/* Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg); */
									} 
							}
							
						}
					}
					}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			/*For not time out*/
			else if($settingId==58){
				//Utils::Trace("enter ".$settingId);
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, Department, Shift,OrganizationId, CompanyEmail, curdate() as tdate from EmployeeMaster WHERE Id in (select EmployeeId from AttendanceMaster where AttendanceDate=curdate() and TimeOut='00:00:00' and TimeIn!='00:00:00') and Shift in (Select Id from ShiftMaster where time_to_sec(TIMEDIFF(CURTIME(), TimeOut))/60 > $leaddays) and DOL='0000-00-00' and DOJ!='0000-00-00' and curdate()>=date(DOJ) and OrganizationId=$orgid";
				$query = $this->db->prepare($sql);
				try{
					$query->execute();
					$count =  $query->rowCount();
					if($count>=1)
					{
						//Utils::Trace("enter in".$settingId);
							$alert = $rowsetting->NotifyAlert;
							$mailsend = $rowsetting->SendMail;
							$notifyself = $rowsetting->notifyself;
							$notifysupervisor = $rowsetting->notifysupervisor;
							$notifyhradmin = $rowsetting->notifyhradmin	;
							$notifyteam = $rowsetting->notifyteam;
							$notifyjsteam = $rowsetting->notifyjsteam;
							$employeeType = $rowsetting->employeeType;
							while($row = $query->fetch())
							{
								$ids="";
								if($notifyself==1){
									if($ids=="")
										  $ids = $row->Id;
									 else 
										 $ids.= ",".$row->Id;
								}
								if($notifysupervisor==1){
									 if($ids=="")
										 $ids = $this->getSeniorId($row->Id, $orgid);
									 else{
										 $sid= $this->getSeniorId($row->Id, $orgid);
										 if($sid)
										 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
									 }
								}
								if($notifyhradmin==1){
									 if($ids=="")
										 $ids = implode($hradminarr,",");
									 else{
										 $sid= implode($hradminarr,",");
										 if($sid)
										 $ids.= ",".implode($hradminarr,",");
									 }
								}
								if($notifyteam==1){
									if($ids=="")
										 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
									 else{
										 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
										 if($sid)
										$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
									 }
								}
								if($notifyjsteam==1){
									 if($ids=="")
										 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
									 else{
											$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
									 }
									 if($ids=="")
										 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
									 else{
										$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
									 }
								}
								$emparr = explode(",",$ids);
								$emparr = array_unique($emparr);
								$emparr = array_values($emparr);
								 if($employeeType){ 
									$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
								  } 
								 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->tdate);
								for($x=0; $x<count($emparr); $x++)
								{	
										$msg="";$title="";
										$title = $rowsetting->Title;
										if($emparr[$x]==$row->Id){
											  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->tdate);
										}else{
											 $msg = $msgother;
										}
										$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
										if($alert){
											$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
										}
										if($mailsend){
											$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
											$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
										}
								}
								
						
						}
					
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*For Employee came late*/
			else if($settingId==30){
				////Utils::Trace("enter ".$settingId);
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.Department, em.Shift, am.AttendanceDate as tdate, am.TimeIn,time_to_sec(TIMEDIFF(am.TimeIn, sm.TimeIn))/60 as dtime from EmployeeMaster em, AttendanceMaster am, ShiftMaster sm WHERE em.Id=am.EmployeeId and sm.Id = em.Shift and time_to_sec(TIMEDIFF(am.TimeIn, sm.TimeIn))/60 > $leaddays and am.AttendanceDate = CURDATE() and em.Id not in (select EmployeeId from Timeoff where TimeofDate=CURDATE() and (am.TimeIn between TimeFrom and TimeTo)) and em.OrganizationId=$orgid";
				$query = $this->db->prepare($sql);
				//Utils::Trace($sql);
				try{
					$query->execute();
					$count =  $query->rowCount();
					if($count>=1)
					{
							//Utils::Trace("enter in".$settingId);
							$alert = $rowsetting->NotifyAlert;
							$mailsend = $rowsetting->SendMail;
							$notifyself = $rowsetting->notifyself;
							$notifysupervisor = $rowsetting->notifysupervisor;
							$notifyhradmin = $rowsetting->notifyhradmin;
							$notifyteam = $rowsetting->notifyteam;
							$notifyjsteam = $rowsetting->notifyjsteam;
							$employeeType = $rowsetting->employeeType;
							while($row = $query->fetch())
							{
								$ids="";
								if($notifyself==1){
									if($ids=="")
										  $ids = $row->Id;
									 else 
										 $ids.= ",".$row->Id;
								}
								if($notifysupervisor==1){
									 if($ids=="")
										 $ids = $this->getSeniorId($row->Id, $orgid);
									 else{
										 $sid= $this->getSeniorId($row->Id, $orgid);
										 if($sid)
										 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
									 }
								}
								if($notifyhradmin==1){
									 if($ids=="")
										 $ids = implode($hradminarr,",");
									 else{
										 $sid= implode($hradminarr,",");
										 if($sid)
										 $ids.= ",".implode($hradminarr,",");
									 }
								}
								if($notifyteam==1){
									if($ids=="")
										 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
									 else{
										 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
										 if($sid)
										$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
									 }
								}
								if($notifyjsteam==1){
									 if($ids=="")
										 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
									 else{
											$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
									 }
									 if($ids=="")
										 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
									 else{
										$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
									 }
								}
								$emparr = explode(",",$ids);
								$emparr = array_unique($emparr);
								$emparr = array_values($emparr);
								 if($employeeType){ 
									$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
								  } 
								  
								 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->tdate,$row->dtime);
								 $dtime=$row->dtime;
								$dtimegrace = floor($dtime-$leaddays);
								for($x=0; $x<count($emparr); $x++)
								{	
										$msg="";$title="";
										$title = $rowsetting->Title;
										if($emparr[$x]==$row->Id){
											  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->tdate,$row->dtime);
										}else{
											 $msg = $msgother;
										}
										 $msg =str_replace('{latebygrace}',$dtimegrace,$msg);
										$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
										if($alert){
											$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
										}
										if($mailsend){
											$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
											$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
										}
								}
								
						
						}
					
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*For Employee left early*/
			else if($settingId==51){
				////Utils::Trace("enter ".$settingId);
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.Department, em.Shift, am.AttendanceDate as tdate, am.TimeOut, sm.TimeOut, time_to_sec(TIMEDIFF(sm.TimeOut, am.TimeOut))/60 as dtime from EmployeeMaster em, AttendanceMaster am, ShiftMaster sm WHERE em.Id=am.EmployeeId and sm.Id = em.Shift and time_to_sec(TIMEDIFF(sm.TimeOut, am.TimeOut))/60 > $leaddays and am.AttendanceDate = CURDATE() and em.Id not in (select EmployeeId from Timeoff where TimeofDate=CURDATE() and (am.TimeOut between TimeFrom and TimeTo)) and am.TimeOut!='00:00:00'  and em.OrganizationId=$orgid";
				$query = $this->db->prepare($sql);
				try{
					$query->execute();
					$count =  $query->rowCount();
					if($count>=1)
					{
						//Utils::Trace("enter in".$settingId);
							$alert = $rowsetting->NotifyAlert;
							$mailsend = $rowsetting->SendMail;
							$notifyself = $rowsetting->notifyself;
							$notifysupervisor = $rowsetting->notifysupervisor;
							$notifyhradmin = $rowsetting->notifyhradmin	;
							$notifyteam = $rowsetting->notifyteam;
							$notifyjsteam = $rowsetting->notifyjsteam;
							$employeeType = $rowsetting->employeeType;
							while($row = $query->fetch())
							{
								$ids="";
								if($notifyself==1){
									if($ids=="")
										  $ids = $row->Id;
									 else 
										 $ids.= ",".$row->Id;
								}
								if($notifysupervisor==1){
									 if($ids=="")
										 $ids = $this->getSeniorId($row->Id, $orgid);
									 else{
										 $sid= $this->getSeniorId($row->Id, $orgid);
										 if($sid)
										 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
									 }
								}
								if($notifyhradmin==1){
									 if($ids=="")
										 $ids = implode($hradminarr,",");
									 else{
										 $sid= implode($hradminarr,",");
										 if($sid)
										 $ids.= ",".implode($hradminarr,",");
									 }
								}
								if($notifyteam==1){
									if($ids=="")
										 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
									 else{
										 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
										 if($sid)
										$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
									 }
								}
								if($notifyjsteam==1){
									 if($ids=="")
										 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
									 else{
											$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
									 }
									 if($ids=="")
										 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
									 else{
										$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
									 }
								}
								$emparr = explode(",",$ids);
								$emparr = array_unique($emparr);
								$emparr = array_values($emparr);
								 if($employeeType){ 
									$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
								  } 
								 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->tdate,$row->dtime);
								for($x=0; $x<count($emparr); $x++)
								{	
										$msg="";$title="";
										$title = $rowsetting->Title;
										if($emparr[$x]==$row->Id){
											  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->tdate,$row->dtime);
										}else{
											 $msg = $msgother;
										}
										$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
										if($alert){
											$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
										}
										if($mailsend){
											$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
											$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
										}
								}
								
						
						}
					
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*For Employee came early*/
			else if($settingId==62){
				////Utils::Trace("enter ".$settingId);
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.Department, em.Shift, am.AttendanceDate as tdate, am.TimeIn, time_to_sec(TIMEDIFF(sm.TimeIn, am.TimeIn))/60 as dtime from EmployeeMaster em, AttendanceMaster am, ShiftMaster sm WHERE em.Id=am.EmployeeId and em.OrganizationId=am.OrganizationId and sm.Id = em.Shift and time_to_sec(TIMEDIFF(sm.TimeIn, am.TimeIn))/60 > $leaddays and am.AttendanceDate = CURDATE() and em.OrganizationId=$orgid";
				$query = $this->db->prepare($sql);
				//Utils::Trace($sql);
				try{
					$query->execute();
					$count =  $query->rowCount();
					if($count>=1)
					{
							//Utils::Trace("enter in".$settingId);
							$alert = $rowsetting->NotifyAlert;
							$mailsend = $rowsetting->SendMail;
							$notifyself = $rowsetting->notifyself;
							$notifysupervisor = $rowsetting->notifysupervisor;
							$notifyhradmin = $rowsetting->notifyhradmin	;
							$notifyteam = $rowsetting->notifyteam;
							$notifyjsteam = $rowsetting->notifyjsteam;
							$employeeType = $rowsetting->employeeType;
							while($row = $query->fetch())
							{
								$ids="";
								if($notifyself==1){
									if($ids=="")
										  $ids = $row->Id;
									 else 
										 $ids.= ",".$row->Id;
								}
								if($notifysupervisor==1){
									 if($ids=="")
										 $ids = $this->getSeniorId($row->Id, $orgid);
									 else{
										 $sid= $this->getSeniorId($row->Id, $orgid);
										 if($sid)
										 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
									 }
								}
								if($notifyhradmin==1){
									 if($ids=="")
										 $ids = implode($hradminarr,",");
									 else{
										 $sid= implode($hradminarr,",");
										 if($sid)
										 $ids.= ",".implode($hradminarr,",");
									 }
								}
								if($notifyteam==1){
									if($ids=="")
										 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
									 else{
										 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
										 if($sid)
										$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
									 }
								}
								if($notifyjsteam==1){
									 if($ids=="")
										 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
									 else{
											$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
									 }
									 if($ids=="")
										 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
									 else{
										$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
									 }
								}
								$emparr = explode(",",$ids);
								$emparr = array_unique($emparr);
								$emparr = array_values($emparr);
								 if($employeeType){ 
									$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
								  } 
								 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->tdate,$row->dtime);
								for($x=0; $x<count($emparr); $x++)
								{	
										$msg="";$title="";
										$title = $rowsetting->Title;
										if($emparr[$x]==$row->Id){
											  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->tdate,$row->dtime);
										}else{
											  $msg = $msgother;
										}
										$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
										if($alert){
											$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
										}
										if($mailsend){
											$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
											$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
										}
								}
								
						
						}
					
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*For Employee on overtime*/
			else if($settingId==63){
				////Utils::Trace("enter ".$settingId);
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.Department, em.Shift, am.AttendanceDate as tdate, am.TimeOut, sm.TimeOut, time_to_sec(TIMEDIFF(am.TimeOut, sm.TimeOut))/60 as dtime from EmployeeMaster em, AttendanceMaster am, ShiftMaster sm WHERE em.Id=am.EmployeeId and em.OrganizationId=am.OrganizationId and sm.Id = em.Shift and time_to_sec(TIMEDIFF(am.TimeOut, sm.TimeOut))/60 > $leaddays and am.AttendanceDate = CURDATE() and am.TimeOut!='00:00:00'  and em.OrganizationId=$orgid";
				$query = $this->db->prepare($sql);
				try{
					$query->execute();
					$count =  $query->rowCount();
					if($count>=1)
					{
						//Utils::Trace("enter in".$settingId);
							$alert = $rowsetting->NotifyAlert;
							$mailsend = $rowsetting->SendMail;
							$notifyself = $rowsetting->notifyself;
							$notifysupervisor = $rowsetting->notifysupervisor;
							$notifyhradmin = $rowsetting->notifyhradmin	;
							$notifyteam = $rowsetting->notifyteam;
							$notifyjsteam = $rowsetting->notifyjsteam;
							$employeeType = $rowsetting->employeeType;
							while($row = $query->fetch())
							{
								$ids="";
								if($notifyself==1){
									if($ids=="")
										  $ids = $row->Id;
									 else 
										 $ids.= ",".$row->Id;
								}
								if($notifysupervisor==1){
									 if($ids=="")
										 $ids = $this->getSeniorId($row->Id, $orgid);
									 else{
										 $sid= $this->getSeniorId($row->Id, $orgid);
										 if($sid)
										 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
									 }
								}
								if($notifyhradmin==1){
									 if($ids=="")
										 $ids = implode($hradminarr,",");
									 else{
										 $sid= implode($hradminarr,",");
										 if($sid)
										 $ids.= ",".implode($hradminarr,",");
									 }
								}
								if($notifyteam==1){
									if($ids=="")
										 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
									 else{
										 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
										 if($sid)
										$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
									 }
								}
								if($notifyjsteam==1){
									 if($ids=="")
										 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
									 else{
											$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
									 }
									 if($ids=="")
										 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
									 else{
										$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
										 if($sid)
											$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
									 }
								}
								$emparr = explode(",",$ids);
								$emparr = array_unique($emparr);
								$emparr = array_values($emparr);
								 if($employeeType){ 
									$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
								  } 
								 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->tdate,$row->dtime);
								for($x=0; $x<count($emparr); $x++)
								{	
										$msg="";$title="";
										$title = $rowsetting->Title;
										if($emparr[$x]==$row->Id){
											   $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->tdate,$row->dtime);
										}else{
											  $msg = $msgother;
										}
										$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
										if($alert){
											$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
										}
										if($mailsend){
											$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
											$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
										}
								}
							}
					
						}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		
		
		}
	}
	
	public function GenerateSalaryAlerts($orgid)
    {
		$mdate= date("Y-m-d H:i:s");
		$date= date("Y-m-d");
		$sWhere = "";
		$hradminarr=$this->getAdminHR($orgid);
		/*fetch settings for setup alerts*/
		$sqlsetting = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and Settingsonoff = 1 and (NotifyAlert=1 or SendMail=1)";
		$querysetting = $this->db->prepare($sqlsetting);
		$querysetting->execute(array($orgid));
		while($rowsetting = $querysetting->fetch()){
			$settingId = $rowsetting->SettingId;
			/*for salary increment*/
			 if($settingId==27){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT e.Id, e.FirstName,e.Department, e.LastName, e.EmployeeCode, e.ReportingTo, e.DOJ, j.ApplyFrom  as cdate FROM EmployeeMaster e, JobModificationMaster j WHERE e.OrganizationId = j.OrganizationId and e.OrganizationId=? and e.Id=j.EmployeeId and j.PromotionType=3 and j.ApplyFrom BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										   $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->cdate);
									}else{
										   $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									}
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			/*for salary decrement*/
			 else if($settingId==48){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT e.Id, e.FirstName,e.Department, e.LastName, e.EmployeeCode, e.ReportingTo, e.DOJ, j.ApplyFrom  as cdate FROM EmployeeMaster e, JobModificationMaster j WHERE e.OrganizationId = j.OrganizationId and e.OrganizationId=? and e.Id=j.EmployeeId and j.PromotionType=4 and j.ApplyFrom BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) $sWhere ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									 $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$row->cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										   $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$row->cdate);
									}else{
										   $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		}
		
	}
	
	public function GenerateLeaveAlerts($orgid)
    {
		$mdate= date("Y-m-d H:i:s");
		$date= date("Y-m-d");
		$sWhere = "";
		$hradminarr=$this->getAdminHR($orgid);
		/*fetch settings for setup alerts*/
		$sqlsetting = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and Settingsonoff = 1 and (NotifyAlert=1 or SendMail=1)";
		$querysetting = $this->db->prepare($sqlsetting);
		$querysetting->execute(array($orgid));
		while($rowsetting = $querysetting->fetch()){
			$settingId = $rowsetting->SettingId;
			/*for Employee on leave today*/	
			 if($settingId==11){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				/*for today leave
				$sql = "SELECT Id, FirstName, LastName,Department, EmployeeCode, curdate() as cdate FROM EmployeeMaster WHERE OrganizationId=? and Id in (SELECT EmployeeId from EmployeeLeave where OrganizationId=? and LeaveStatus=2 and (curdate() between LeaveFrom and LeaveTo)) $sWhere"; 
				*/
				$sql = "SELECT em.Id, em.FirstName, em.LastName,em.Department, em.EmployeeCode,(Select Name from LeaveMaster where Id = el.LeaveTypeId) as leavetypename, el.LeaveFrom as sdate, el.LeaveTo as tdate FROM EmployeeMaster em, EmployeeLeave el WHERE em.OrganizationId=? and em.OrganizationId=el.OrganizationId and em.Id=el.EmployeeId and (el.LeaveFrom BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) or el.LeaveTo BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY)) and el.LeaveStatus=2 and em.DOL='0000-00-00'";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							  $cdate="";
							  if($row->sdate==$row->tdate){
								  $cdate=Alerts::staticdateformatter($row->sdate);
							  }
							  else{
								  $cdate=Alerts::staticdateformatter($row->sdate)." to ".Alerts::staticdateformatter($row->tdate);
							  }
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
														
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
									}else{
										  $msg = $msgother;
									}
									$msg =str_replace('{LeaveType}',$row->leavetypename,$msg);
									
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									}
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for Resumption date after leave*/
			 else if($settingId==10){
				$sWhere = " and  DOL='0000-00-00' ";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.LastName,em.Department, em.EmployeeCode, el.ResumptionDate as cdate FROM EmployeeMaster em, EmployeeLeave el WHERE em.OrganizationId=? and em.OrganizationId=el.OrganizationId and em.Id=el.EmployeeId and el.ResumptionDate BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY) and el.LeaveStatus=2 and  em.DOL='0000-00-00'";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							 $cdate=Alerts::staticdateformatter($row->cdate);
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										    $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
									}else{
										    $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for Employee on timeoff today*/	
			 else if($settingId==33){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.LastName,em.Department, em.EmployeeCode, t.TimeFrom as stime, t.TimeTo as ttime FROM EmployeeMaster em, Timeoff t WHERE em.OrganizationId=? and em.Id=t.EmployeeId and t.TimeofDate = CURDATE() and t.ApprovalSts=2 and em.DOL='0000-00-00'";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$cdate=$row->stime." to ".$row->ttime;
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->Id){
										   $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
									}else{
										   $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for Leave request Exceed approval period */	
			 else if($settingId==37){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT el.Id, el.EmployeeId, em.Designation, em.Department FROM EmployeeLeave el, EmployeeMaster em WHERE el.OrganizationId = ? and el.LeaveStatus=3 and em.Id=el.EmployeeId";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$mdate=date('Y-m-d');
						////////////to get hr///////
						$hronly="0";
						$sqlhr = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";
								
						$queryhr = $this->db->prepare($sqlhr);
						$queryhr->execute(array($orgid));
						while($rowhr = $queryhr->fetch())
						{
							$hronly = $rowhr->EmployeeId;
						}
						////////////end to get hr///////
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$escl=3;
							$sql1 = "SELECT EscalationPeriod FROM ApprovalProcess where Designation=? and ProcessType=1";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($row->Designation));
							if($row1=$query1->fetch())
							{
								$escl=$row1->EscalationPeriod;
							}
							if($escl>0){
								$createddate=date('Y-m-d');
								$sql1 = "SELECT ApprovalDate FROM LeaveApproval WHERE LeaveId =? and ApproverSts=2";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($row->Id));
								while($row1=$query1->fetch())
								{
									$createddate=$row1->ApprovalDate;
								}
								$sql1 = "SELECT CreatedDate,ApproverId FROM LeaveApproval WHERE LeaveId =? and ApproverSts=3 and ApproverId NOT IN ($hronly)";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($row->Id));
								$con=$query1->rowCount();
								if($con > 0){
									if($row1=$query1->fetch())
									{
										$createddate=$row1->CreatedDate;
										$appid=$row1->ApproverId;
									}
									
							$escldate=date("Y-m-d", strtotime("+".$escl." Day, ".date($createddate)));
							$curtime=strtotime($mdate);
							$esctime=strtotime($escldate);
							if(($curtime >= $esctime)){
								
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->EmployeeId;
								 else 
									 $ids.= ",".$row->EmployeeId;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->EmployeeId, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->EmployeeId, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->EmployeeId, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->EmployeeId, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->EmployeeId, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->EmployeeId, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->EmployeeId, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->EmployeeId, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->EmployeeId, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$cdate=Alerts::staticdateformatter($createddate);
							 $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->EmployeeId,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
									$msg="";$title="";
									$title = $rowsetting->Title;
									if($emparr[$x]==$row->EmployeeId){
										   $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->EmployeeId,$cdate);
									}else{
										   $msg = $msgother;
									}
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
							}
						}
					}
					}
					}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		}
	}
	
	public function GenerateOrgAlerts($orgid)
    {
		$mdate= date("Y-m-d H:i:s");
		$date= date("Y-m-d");
		$sWhere = "";
		$hradminarr=$this->getAdminHR($orgid);
		/*fetch settings for setup alerts*/
		$sqlsetting = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and Settingsonoff = 1 and (NotifyAlert=1 or SendMail=1)";
		$querysetting = $this->db->prepare($sqlsetting);
		$querysetting->execute(array($orgid));
		while($rowsetting = $querysetting->fetch()){
			$settingId = $rowsetting->SettingId;
			/*for Upcoming holidays*/	
			 if($settingId==44){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.Division, em.CompanyEmail, em.LastName, em.Department, em.EmployeeCode, h.Name as holidayname, h.DivisionId, h.DateFrom as sdate, h.DateTo as tdate FROM EmployeeMaster em, HolidayMaster h WHERE em.OrganizationId=? and em.OrganizationId=h.OrganizationId and FIND_IN_SET(em.Division, h.DivisionId) and (h.DateFrom BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY)) and em.DOL='0000-00-00'";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						while($row = $query->fetch())
						{
							$emparr=array();
							$emparr[]=$row->Id;
							  $ids="";
							  $cdate="";
							  $employeeType = $rowsetting->employeeType;
							  
							  if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
								//print_r($emparr); 
							  } 
							  if($emparr){
								  
							  if($row->sdate==$row->tdate){
								  $cdate=Alerts::staticdateformatter($row->sdate);
							  }
							  else{
								  $cdate=Alerts::staticdateformatter($row->sdate)." to ".Alerts::staticdateformatter($row->tdate);
							  }
							  $msg="";$title="";
													
							$title = $rowsetting->Title;
							$msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
							
							$msg =str_replace('{holidayname}',$row->holidayname,$msg);
							
							$this->CreateNotification($title,$msg,$orgid, $row->Id);
							if($alert){
								$this->CreateAlert($title,$msg,$orgid, $row->Id);
							}
							if($mailsend){
								$toemail=Utils::getName($row->Id, 'EmployeeMaster','CompanyEmail',$this->db);
								$this->CreateMail($title,$msg,$orgid, $row->Id,$toemail);
							}	
							  }
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for Issue Assets*/	
			 else if($settingId==45){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.Division, em.CompanyEmail, em.LastName,em.Department, em.EmployeeCode, ai.AssetId, ai.IssuedDate as sdate FROM EmployeeMaster em, AssetsIssued ai WHERE em.OrganizationId=? and em.OrganizationId=ai.OrganizationId and em.Id=ai.EmployeeId and (ai.IssuedDate BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $leaddays DAY)) and em.DOL='0000-00-00'";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							//print_r($ids);
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							//print_r($ids);
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
								//print_r($emparr); 
							  } 
							$cdate=Alerts::staticdateformatter($row->sdate);
							  $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
								$msg="";$title="";
								$title = $rowsetting->Title;
								if($emparr[$x]==$row->Id){
										$msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
								}else{
										$msg = $msgother;
								}
								$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
								if($alert){
									$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
								}
								if($mailsend){
									$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
									$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
								}
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		}
	}
	
	public function GenerateTimesheetAlerts($orgid)
    {
		$mdate= date("Y-m-d H:i:s");
		$date= date("Y-m-d");
		$sWhere = "";
		$hradminarr=$this->getAdminHR($orgid);
		/*fetch settings for setup alerts*/
		$sqlsetting = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and Settingsonoff = 1 and (NotifyAlert=1 or SendMail=1)";
		$querysetting = $this->db->prepare($sqlsetting);
		$querysetting->execute(array($orgid));
		$data=array();
		while($rowsetting = $querysetting->fetch()){
			$settingId = $rowsetting->SettingId;
			/*for Employee forgot to fill timesheet*/	
			  if($settingId==21){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT Id, FirstName, LastName, CompanyEmail, EmployeeCode, Department, DOJ, DATE_SUB(CURDATE(), INTERVAL 1 DAY) as sdate FROM EmployeeMaster WHERE  OrganizationId = ? and Id not in(Select EmployeeId from timesheet_master where timesheetstart = DATE_SUB(CURDATE(), INTERVAL 1 DAY) and OrganizationId=?)  and Id in (Select EmployeeId from AttendanceMaster where AttendanceDate=DATE_SUB(CURDATE(), INTERVAL 1 DAY) and TimeOut!='00:00:00' and TimeIn!='00:00:00' and OrganizationId = ?) $sWhere";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid, $orgid, $orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
										$ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$cdate=Alerts::staticdateformatter($row->sdate);
							   $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
								$msg="";$title="";
								$title = $rowsetting->Title;
								if($emparr[$x]==$row->Id){
									
									 $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
									$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
									if($alert){
										$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
									}
									if($mailsend){
										$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
										$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
									} 
									
								}else{
									$msg = $msgother;
									$res=array();
									$res['title']=$title;
									$res['msg']=$msg;
									$res['orgid']=$orgid;
									$res['emp']=$emparr[$x];
									$data[] = $res;
								}
							}
						}
						$empdata = array();
						foreach ($data as $key => $rowdata) {
							$empdata[$key]  = $rowdata['emp'];
						}	
						$empdata = array_values(array_unique($empdata));
						foreach ($empdata as $key => $emps) {
							$list = "The following Employees have not filled their timesheet yesterday<br/><ol>";
							$title="";
							foreach ($data as $key => $rows) {
								if($rows['emp']==$emps){
									$title=$rows['title'];
									$list .= "<li>".$rows['msg']."</li>";
								}
							}
							$list .= "</ol>";
							//print_r("<br/>".$list);
							$this->CreateNotification($title,$list,$orgid, $emps);
							if($alert){
								$this->CreateAlert($title,$list,$orgid, $emps);
							}
							if($mailsend){
								$toemail=Utils::getName($emps, 'EmployeeMaster','CompanyEmail',$this->db);
								$this->CreateMail($title,$list,$orgid, $emps,$toemail);
							} 
						}
						
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			/*for Task exceeded deadline*/	
			  else if($settingId==24){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.FirstName, em.Division, em.CompanyEmail, em.LastName,em.Department, em.EmployeeCode, tm.task_title, tm.todate as sdate FROM EmployeeMaster em, task_master tm WHERE em.OrganizationId=? and em.OrganizationId=tm.OrganizationId and em.Id=tm.assignto and tm.todate<CURDATE() and taskstatus=1 and em.DOL='0000-00-00'";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$cdate=Alerts::staticdateformatter($row->sdate);
							   $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
								$msg="";$title="";
								$title = $rowsetting->Title;
								if($emparr[$x]==$row->Id){
									  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
								}else{
									 $msg = $msgother;
								}
								$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
								if($alert){
									$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
								}
								if($mailsend){
									$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
									$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
								} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		}
	}
	
	public function GeneratePerformanceAlerts($orgid)
    {
		$mdate= date("Y-m-d H:i:s");
		$date= date("Y-m-d");
		$sWhere = "";
		$hradminarr=$this->getAdminHR($orgid);
		/*fetch settings for setup alerts*/
		$sqlsetting = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and Settingsonoff = 1 and (NotifyAlert=1 or SendMail=1)";
		$querysetting = $this->db->prepare($sqlsetting);
		$querysetting->execute(array($orgid));
		while($rowsetting = $querysetting->fetch()){
			$settingId = $rowsetting->SettingId;
		/*for Assess Performance*/	
			  if($settingId==42){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.Division, em.CompanyEmail, em.Department, em.EmployeeCode, ea.AssessmentType, ea.DesignationLevel, DATEDIFF(curdate(),ea.ToDate) as daysleft, ea.FromDate as sdate, ea.ToDate from EmployeeMaster em, EmployeeAssessment ea where ea.OrganizationId=? and em.OrganizationId=ea.OrganizationId and em.Id=ea.EmployeeId and ea.AssessmentSts=0 and CURDATE() > ea.ToDate and ea.Id in (SELECT EmployeeAssessmentId from EmployeeAssessmentApproval where  AssessmentSts=0)";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							$cdate=Alerts::staticdateformatter($row->sdate);
							    $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
								$msg="";$title="";
								$title = $rowsetting->Title;
								if($emparr[$x]==$row->Id){
									  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
								}else{
									$msg = $msgother;
								}
								$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
								if($alert){
									$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
								}
								if($mailsend){
									$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
									$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
								} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for Skill Gap Assessment*/	
			  else if($settingId==14){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT em.Id, em.Division, em.CompanyEmail, em.Department, em.EmployeeCode, DATEDIFF(curdate(),ea.ToDate) as daysleft, ea.FromDate as sdate, ea.ToDate from EmployeeMaster em, SkillGapAssessment ea where ea.OrganizationId=? and em.OrganizationId=ea.OrganizationId and em.Id=ea.EmployeeId and ea.AssessmentSts=0 and CURDATE() > ea.ToDate and ea.Id in (SELECT SkillGapId from SkillGapApproval where  AssessmentSts=0)";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							//print_r("1".$ids);
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							//print_r("2".$ids);
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							//print_r("3".$ids);
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
							  //print_r($emparr);
								$cdate=Alerts::staticdateformatter($row->sdate);
							     $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
								$msg="";$title="";
								$title = $rowsetting->Title;
								if($emparr[$x]==$row->Id){
									 $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
								}else{
									 $msg = $msgother;
								}
								$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
								if($alert){
									$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
								}
								if($mailsend){
									$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
									$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
								} 
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for Employee needs  training */	
			  else if($settingId==43){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT e.Id, e.Division, e.CompanyEmail, e.Department, e.EmployeeCode ,ea.FromDate as sdate FROM EmployeeMaster e, EmployeeAssessment ea, AssessmentResult ar, AssessmentObjective ao WHERE e.OrganizationId = ? and e.Id = ea.EmployeeId and ea.AssessmentSts=1 and e.Designation=ao.DesignationId and ao.Id=ar.AssessmentObjectiveId and ea.Rating=ar.Rating and ar.tcriteria=1 and ea.FromDate = (Select max(FromDate) from EmployeeAssessment where AssessmentSts = 1 and EmployeeId = e.Id) and (e.DOL='0000-00-00' or e.DOL>curdate()) and CAST(ea.LastModifiedDate as DATE) = CURDATE()";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
							$ids="";
							//print_r("1".$ids);
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							//print_r("2".$ids);
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							//print_r("3".$ids);
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
								 //print_r($emparr);
								 $cdate=Alerts::staticdateformatter($row->sdate);
							     $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
								$msg="";$title="";
								$title = $rowsetting->Title;
								if($emparr[$x]==$row->Id){
									  $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
								}else{
									  $msg = $msgother;
								}
								$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
								if($alert){
									$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
								}
								if($mailsend){
									$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
									$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
								}
							}
						}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for Performance upgraded */	
			  else if($settingId==56){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT e.Id, e.Division, e.CompanyEmail, e.Department, e.EmployeeCode ,ea.FromDate as sdate,ea.Rating FROM EmployeeMaster e, EmployeeAssessment ea WHERE e.OrganizationId = ? and e.Id = ea.EmployeeId and ea.AssessmentSts=1 and ea.FromDate = (Select max(FromDate) from EmployeeAssessment where AssessmentSts = 1 and EmployeeId = e.Id) and (e.DOL='0000-00-00' or e.DOL>curdate()) and CAST(ea.LastModifiedDate as DATE) = CURDATE()";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
						$sql1 = "SELECT Rating from EmployeeAssessment where EmployeeId = ? and AssessmentSts = 1 and FromDate < ? order by FromDate desc limit 1";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($row->Id, $row->sdate));
						$count1 =  $query1->rowCount();
						if($count1>=1)
						{
							while($row1 = $query1->fetch())
							{
							if($row->Rating > $row1->Rating){
							$ids="";
							//print_r("1".$ids);
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							//print_r("2".$ids);
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							//print_r("3".$ids);
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
								 //print_r($emparr);
								 $cdate=Alerts::staticdateformatter($row->sdate);
							     $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
								$msg="";$title="";
								$title = $rowsetting->Title;
								if($emparr[$x]==$row->Id){
									   $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
								}else{
									   $msg = $msgother;
								}
								$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
								if($alert){
									$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
								}
								if($mailsend){
									$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
									$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
								} 
							}
						}
						}
						}
					}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		/*for Performance degraded */	
			  else if($settingId==57){
				$sWhere = "and  DOL='0000-00-00'";
				$leaddays = $rowsetting->ExecutionValue;
				$sql = "SELECT e.Id, e.Division, e.CompanyEmail, e.Department, e.EmployeeCode ,ea.FromDate as sdate,ea.Rating FROM EmployeeMaster e, EmployeeAssessment ea WHERE e.OrganizationId = ? and e.Id = ea.EmployeeId and ea.AssessmentSts=1 and ea.FromDate = (Select max(FromDate) from EmployeeAssessment where AssessmentSts = 1 and EmployeeId = e.Id) and (e.DOL='0000-00-00' or e.DOL>curdate()) and CAST(ea.LastModifiedDate as DATE) = CURDATE()";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$alert = $rowsetting->NotifyAlert;
						$mailsend = $rowsetting->SendMail;
						$notifyself = $rowsetting->notifyself;
						$notifysupervisor = $rowsetting->notifysupervisor;
						$notifyhradmin = $rowsetting->notifyhradmin	;
						$notifyteam = $rowsetting->notifyteam;
						$notifyjsteam = $rowsetting->notifyjsteam;
						$employeeType = $rowsetting->employeeType;
						while($row = $query->fetch())
						{
						$sql1 = "SELECT Rating from EmployeeAssessment where EmployeeId = ? and AssessmentSts = 1 and FromDate < ? order by FromDate desc limit 1";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($row->Id, $row->sdate));
						$count1 =  $query1->rowCount();
						if($count1>=1)
						{
							while($row1 = $query1->fetch())
							{
							if($row->Rating < $row1->Rating){
							$ids="";
							//print_r("1".$ids);
							if($notifyself==1){
								if($ids=="")
									  $ids = $row->Id;
								 else 
									 $ids.= ",".$row->Id;
							}
							//print_r("2".$ids);
							if($notifysupervisor==1){
								 if($ids=="")
									 $ids = $this->getSeniorId($row->Id, $orgid);
								 else{
									 $sid= $this->getSeniorId($row->Id, $orgid);
									 if($sid)
									 $ids.= ",".$this->getSeniorId($row->Id, $orgid);
								 }
							}
							//print_r("3".$ids);
							if($notifyhradmin==1){
								 if($ids=="")
									 $ids = implode($hradminarr,",");
								 else{
									 $sid= implode($hradminarr,",");
									 if($sid)
									 $ids.= ",".implode($hradminarr,",");
								 }
							}
							if($notifyteam==1){
								if($ids=="")
									 $ids = implode($this->getDepTeamIds($row->Department, $orgid),",");
								 else{
									 $sid= implode($this->getDepTeamIds($row->Department, $orgid),",");
									 if($sid)
									$ids.= ",".implode($this->getDepTeamIds($row->Department, $orgid),",");
								 }
							}
							if($notifyjsteam==1){
								 if($ids=="")
									 $ids = implode($this->getSeniorIds($row->Id, $orgid),",");
								 else{
										$sid= implode($this->getSeniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getSeniorIds($row->Id, $orgid),",");
								 }
								 if($ids=="")
									 $ids = implode($this->getJuniorIds($row->Id, $orgid),",");
								 else{
									$sid= implode($this->getJuniorIds($row->Id, $orgid),",");
									 if($sid)
										$ids.= ",".implode($this->getJuniorIds($row->Id, $orgid),",");
								 }
							}
							$emparr = explode(",",$ids);
							$emparr = array_unique($emparr);
							$emparr = array_values($emparr);
							//print_r($emparr);
							 if($employeeType){ 
								$emparr = $this->getEmpTypeEmp($employeeType,$emparr);
							  } 
								 //print_r($emparr);
								 $cdate=Alerts::staticdateformatter($row->sdate);
							     $msgother = $this->getParseMailMessage($rowsetting->DescOther,$row->Id,$cdate);
							for($x=0; $x<count($emparr); $x++)
							{	
								$msg="";$title="";
								$title = $rowsetting->Title;
								if($emparr[$x]==$row->Id){
									   $msg = $this->getParseMailMessage($rowsetting->DescEmp,$row->Id,$cdate);
								}else{
									   $msg = $msgother;
								}
								$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
								if($alert){
									$this->CreateAlert($title,$msg,$orgid, $emparr[$x]);
								}
								if($mailsend){
									$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
									$this->CreateMail($title,$msg,$orgid, $emparr[$x],$toemail);
								} 
							}
						}
						}
						}
					}
					}
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		}
	}
	
	public function DeleteNotifications($orgid)
	{
		try{
			$date=date('Y-m-d', strtotime('-7 days', strtotime(date('Y-m-d'))));
			$sql1 = "DELETE FROM GenerateNotification WHERE NotifyDate<? and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($date,$orgid));
			
		}catch(Exception $e) {
			
		}
	}
	public function CreateNotification($title,$msg,$orgid, $empid)
	{
		$count=0;
		$mdate= date("Y-m-d H:i:s");
		
		try{
				$sql1 = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=CURDATE()";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,$empid,$title,$msg ));
				$count=$query1->rowCount();
				if($count == 0){
					$sql1 = "INSERT INTO GenerateNotification (EmployeeId, Title, Message, NotifyDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $empid,$title,$msg,$mdate,$orgid ));
					
				}
				
			
		}
		catch(Exception $e){
		}
	
	}
	
	public function CheckNotification($title,$msg,$orgid, $empid)
	{
		$count=0;
		$mdate= date("Y-m-d H:i:s");
		try{
				$sql1 = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=CURDATE()";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,$empid,$title,$msg ));
				$count=$query1->rowCount();
				if($count == 0){
					return 1;
				}
				else{
				return 0;
				}
		}
		catch(Exception $e){
		}
	}
	
	public function CreateAlert($title,$msg,$orgid, $empid)
	{
		$count=0;
		$mdate= date("Y-m-d H:i:s");
		try{
				$sql1 = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=CURDATE() and AlertSts = 0";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,$empid,$title,$msg ));
				$count=$query1->rowCount();
				if($count >= 1){
					$r=$query1->fetch();
					$sql = "Update GenerateNotification set AlertSts = 1 where Id =?";
					$query = $this->db->prepare($sql);
					$query->execute(array($r->Id));
					return 1;
				}
				return;
		}
		catch(Exception $e){
		}
	}
	
	public function CreateMail($title,$msg,$orgid, $empid, $to)
	{
		$count=0;
		$mdate= date("Y-m-d H:i:s");
		try{
				$orgname = Utils::getName($orgid,"Organization", "Name", $this->db);
				$sql1 = "SELECT Id FROM GenerateNotification WHERE OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=CURDATE() and MailSts = 0";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid,$empid,$title,$msg));
				$count=$query1->rowCount();
				if($count >= 1){
					$r=$query1->fetch();
					$id=$r->Id;
					$sts = Utils::sendMail(Utils::decode5t($to),$orgname,$title,$msg,'',$this->smtpuser,$this->smtpassword); 
					if($sts){
					$sql = "Update GenerateNotification set MailSts = 1 where Id =?";
					$query = $this->db->prepare($sql);
					$query->execute(array($id));
					return 1;
				}
				}
				return;
		}
		catch(Exception $e){
		}
	}
	
	public function getAdminHR($orgid)
	{
		$index=0;
		$ids=array();
		$sql = "select EmployeeId from UserMaster where OrganizationId=? and (HRSts=1 or AdminSts = 1)";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		while($r=$query->fetch()){
			$ids[] = $r->EmployeeId;
		}
		return $ids;
	}
	
	public function getcurrency( $orgid)
	{
		$name=0;
		
		$sql = "SELECT Currency FROM Organization WHERE Id = ? ";
				
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		
		while($row = $query->fetch())
		{
			$sql1 = "SELECT CurrencyCode FROM CurrencyMaster WHERE Id = ? ";
				
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->Currency));
			
			while($row1 = $query1->fetch())
			{
				
				$name= Utils::getCurrencySymbolHex($row1->CurrencyCode);
								
			}	
			
				
		}
		
		return $name;
	}
	
	public function getSeniorIds($empid, $orgid)
	{
		$ids = array();
		$index=0;
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and Id in ( $parentid ) and  DOL='0000-00-00' ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->ReportingTo;
					}else{
						$parentid .= ", ".$row1->ReportingTo;
					}
					
					$ids[] = $row1->ReportingTo;					
					
				}
				
			}
		}
			return $ids;
	}
	
	
	public function getJuniorIds($empid, $orgid)
	{
		$ids = array();
		
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and ReportingTo in ( $parentid ) and  DOL='0000-00-00' ";
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->Id;
					}else{
						$parentid .= ", ".$row1->Id;
					}
						$ids[] = $row1->Id;
				}
				
			}
		}
			return $ids;
	}
	
	
	public function getSeniorId($empid, $orgid)
	{
		$seniorid = "0";
		$index=0;
		$sql1 = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and Id = ?  and  DOL='0000-00-00' ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid ));
		$parentid="";
		while($row1 = $query1->fetch())
		{
			$seniorid = $row1->ReportingTo;
				
		}             
		return $seniorid;
	}
	public function getDepTeamIds($depid, $orgid)
	{
		$teamid = array();
		$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and Department = ?  and  DOL='0000-00-00' ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $depid ));
		while($row1 = $query1->fetch())
		{
			$teamid[] = $row1->Id;
		}
		return $teamid;
	}
	public function getParseMailMessage($msg,$empid,$date,$time='')
	{
		$searcharr=array();$status=false;$errorMsg=""; $successMsg="";
		$data=array();
		$searcharr  = array("{EmployeeName}","{dateofbirth}","{division}","{department}","{designation}","{phone}","{address}","{dateofjoining}","{dateofconfirmation}","{reportingto}","{reportingtodesig}","{organizationname}","{actiondate}"," his "," him "," Mr "," he ","{earlyby}","{lateby}");
		$replacearr = array();
		$sql="select * from EmployeeMaster where Id =$empid";
		$query = $this->db->prepare($sql);
		$query->execute();
		$count =  $query->rowCount();
		if ($count >0){
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$replacearr[0] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$replacearr[1] = Alerts::staticdateformatter($row->DOB);
				$replacearr[2] = Utils::getName($row->Division,"DivisionMaster", "Name", $this->db);
				$replacearr[3] = Utils::getName($row->Department,"DepartmentMaster", "Name", $this->db);
				$replacearr[4] = Utils::getName($row->Designation,"DesignationMaster", "Name", $this->db);
				$replacearr[5]= Utils::decode5t($row->CurrentContactNumber);
				$replacearr[6] = Utils::decode5t($row->CurrentAddress);
				$replacearr[7] =Alerts::staticdateformatter($row->DOJ);
				$replacearr[8] = Alerts::staticdateformatter($row->DOC);
				$replacearr[9]= Utils::getEmployeeName($row->ReportingTo, $this->db);
				$replacearr[10] = $this->getDesignation($row->ReportingTo);
				$replacearr[11] = Utils::getName($row->OrganizationId,"Organization", "Name", $this->db);
				$replacearr[12]  = $date;
				$gender =$row->Gender;
				if($gender==1){
				$replacearr[13] =" his ";
				$replacearr[14] =" him ";
				$replacearr[15] =" Mr ";
				$replacearr[16] =" he ";
				}elseif($gender == 2)
				{
					$replacearr[13] =" her ";
					$replacearr[14] =" her";
					$replacearr[15] =" Ms/Mrs ";
					$replacearr[16] =" she ";
				}
				$replacearr[17] = floor($time);
				$replacearr[18] = floor($time);
			}
		}
		$phrase = $msg;
		//$msg = Utils::strip_word_html(html_entity_decode($phrase,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><u>');
		$msg =str_replace($searcharr,$replacearr,$phrase);
		return $msg;
	}	
			
	public function getEmpTypeEmp($emptype,$emparr)
	{
		$ids = array();
		$emparr=implode($emparr,",");
		$sql = "SELECT Id FROM EmployeeMaster WHERE EmploymentType = :emptype and Id in ($emparr)";
		 $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':emptype' => $emptype ));
			while($row = $query->fetch())
			{
				$ids[] =  $row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $ids;
	}		
	public function getDesignation($id)
	{
		$name ="";
		$sql = "SELECT Designation FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name =  Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getAllEmployee($orgid)
	{
		$teamid = array();
		$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00' ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid ));
		while($row1 = $query1->fetch())
		{
			$teamid[] = $row1->Id;
		}
		return $teamid;
	}
}

?>