<?php

/**
 * LeavetypeModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class NotificationModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$arr=array();
		$month = date('F');
		$nmonth = date('m',strtotime($month));
		$year = date('Y');
		$nyear = date('Y',strtotime($year));
        $sql = "SELECT * FROM NotificationMaster WHERE OrganizationId = ? AND YEAR(CreatedDate)=? AND MONTH(CreatedDate)=?";
        $query = $this->db->prepare($sql);
		try{
			
			
			$query->execute(array( $orgid,$nyear,$nmonth ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=" record found";
			while($row = $query->fetch())
			{
				$res = array();
				$div = $row->Division;
				$dept = $row->Department;
				$desig = $row->Designation;
				$arr=($row->EmployeeIds!=0)?explode(",",$row->EmployeeIds):0;
				if(is_array($arr)){
					for($i=0;$i<count($arr);$i++)
					{
						if($arr[$i]==$mid && $div==0 && $dept==0 && $desig==0){
							$res['employeeids']=($row->EmployeeIds!="")?explode(",",$row->EmployeeIds):"";
							$res['id'] = $row->Id;
							$res['name'] = $row->Name;   
							$res['date'] = $row->CreatedDate;  
							$res['message'] = $row->Message; 
							$res['employee'] =$this->getEmployeeName($row->CreatedById,'EmployeeMaster'); 
							$image =$this->getEmployeeImage($row->CreatedById,'EmployeeMaster');
							$res['priority'] = $this->getpriority($row->NotificationPriority,'OtherMaster');
							$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
							
							
							
							$data[] = $res;

						}
					
					}
				}
				elseif( $div != 0 || $dept != 0 || $desig != 0 && $arr == ""){
						$res['employeeids']=($row->EmployeeIds!="")?explode(",",$row->EmployeeIds):"";
						$res['id'] = $row->Id;
						$res['name'] = $row->Name;   
						$res['date'] = $row->CreatedDate;  
						$res['message'] = $row->Message; 
						$res['employee'] =$this->getEmployeeName($row->CreatedById,'EmployeeMaster'); 
						$image =$this->getEmployeeImage($row->CreatedById,'EmployeeMaster');
						$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
						$res['priority'] = $this->getpriority($row->NotificationPriority,'OtherMaster');
						
						$data[] = $res;

					}
				else{
						$res['employeeids']=($row->EmployeeIds!="")?explode(",",$row->EmployeeIds):"";
						$res['id'] = $row->Id;
						$res['name'] = $row->Name;   
						$res['date'] = $row->CreatedDate;  
						$res['message'] = $row->Message; 
						$res['employee'] =$this->getEmployeeName($row->CreatedById,'EmployeeMaster'); 
						$image =$this->getEmployeeImage($row->CreatedById,'EmployeeMaster');
						$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
						$res['priority'] = $this->getpriority($row->NotificationPriority,'OtherMaster');
						
						$data[] = $res;

					}	
				
			}
        }else{
			$status=true;
			$successMsg = NOTIFICATION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$emp="";
		$array=array();
        $sql = "SELECT * FROM NotificationMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
		//		$orgid = $row->OrganizationId;
		//		$filename = $row->fileattach;
		//		$file = "public/uploads/$orgid/notification/$filename";
				$res['id'] = $row->Id;
				$res['notificationname'] = $row->Name;
				$res['message'] = $row->Message;
			//	$res['fileattach'] = $file;
				$res['fileattach'] = $row->fileattach;
				$res['division'] = $row->Division;
                $res['department'] = $row->Department;
                $res['designation'] = $row->Designation;
                $res['startdate']=Utils::dateformatter($row->StartDate);
				$res['enddate']= Utils::dateformatter($row->EndDate);
				$res['priority']=$row->NotificationPriority;
				$res['createdby']=$this->getEmployeeName($row->CreatedById,'EmployeeMaster');
				$res['employeeids']=($row->EmployeeIds!="")?explode(",",$row->EmployeeIds):"";
				
				$res['toggle'] = $row->NotificationType;
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = NOTIFICATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = NOTIFICATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a DocumentMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sendmail=$request[12]; //SEND MAIL STATUS CONTAINS IN ARRAY 12TH VALUE;

		$mdate = date("Y-m-d H:i:s");
		$empid= "0" ;
		$arr = json_decode($request[8]);
		if(count($arr)!=0)
		{
			foreach($arr as $value){
				if($empid==""){
					$empid=$value->id;
				}else{
					$empid=$empid.",".$value->id;
				}
			}
		}
		
		if($sendmail==true)
		{
			$empids=explode(",",$empid);
			$user_email="";
			foreach($empids as $value)
			{
				$sql="SELECT * from EmployeeMaster where Id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($value));
				while($row=$query->fetch())
				{
					if($user_email=""){
						$user_email=$row->CompanyEmail;
					}else{
						$user_email=$user_email.",".$row->CompanyEmail;
					}
				}
			}
			if($user_email!="")
			{
				$emailsts=Utils::sendMail($user_email,$request[5],$request[2],$request[3]);
				if($emailsts==true)
				$successMsg = NOTIFICATION_MODULE_CREATION_SUCCESS." and mails have been sent to employees";
				else
				$successMsg = NOTIFICATION_MODULE_CREATION_SUCCESS. " but mail send is failed";
			}
		}
		$dir="public/uploads/$orgid/notification";
		if (! is_dir($dir))
		{
			mkdir($dir);
			chmod($dir,0755);
		}
			
		$filename="";
		if(isset($_FILES))
		{
			$con=count($_FILES);	
			for($i=0;$i<$con;$i++)
			{
				if(isset($_FILES['file'.$i]))
				{
					$doc1="notification".'_'."$request[3]";
			
					$errors= array();
					$file_name = $_FILES['file'.$i]['name'];
					$ext = pathinfo($file_name, PATHINFO_EXTENSION);
					if ($ext != 'exe' && $ext != 'zip' && $ext != 'rar' )
					{ 
						if (is_dir($dir))
						{
							if ($dh = opendir($dir))
							{
								while (($file = readdir($dh)) != false)
								{
									$filename=$file;
									$ext1 = end((explode(".", $filename)));
									if($filename=="$doc1.$ext1")
									{
										unlink("public/uploads/$orgid/notification/$filename");
									}
								}
							closedir($dh);
							}
						}
						$new_name="notification".'_'."$request[3].$ext";
						
						$file_size =$_FILES['file'.$i]['size'];
						$file_tmp =$_FILES['file'.$i]['tmp_name'];
						$file_type=$_FILES['file'.$i]['type'];   
						$location="public/uploads/$orgid/notification/";
						if($file_size > 2097152)
						{
						$errors[]='File size must be less than 2 MB';
						}	
					
						if(empty($errors)==true)
						{
						
							if(move_uploaded_file($file_tmp, $location.$new_name))
							{
							$count++;
							}
						
						}
						else
						{
							print_r($errors);
						}
						if ($count >= 1)
						{
							$status =true;
							$successMsg = EMPLOYEE_MODULE_DOCUPLOAD;

							$sql = "UPDATE NotificationMaster SET Name=?, Message=?, fileattach=? , Division=? , Department=? ,Designation =? ,EmployeeIds =?,StartDate=?,EndDate=?,NotificationPriority=?,  LastModifiedDate=?, LastModifiedById=?,NotificationType=?  where Id=?";
							$query = $this->db->prepare($sql);
							try{
								
								$query->execute(array($request[2],$request[4], $new_name, $request[5],$request[6],$request[7],$empid, $this->getDateformat($request[9]),$this->getDateformat($request[10]),$request[11],$mdate, $mid,$request[12], $request[3] ));			
								$count1 =  $query->rowCount();
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if ($count1 == 1)
							{
								//$empid=Utils::getName($did,'JobModificationMaster','EmployeeId',$this->db);
								$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
								$msg="Notification has been updated $empname";
								$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
								$query = $this->db->prepare($sql);
								$query->execute(array($mid, "Notification", $msg, $orgid));
							   $status =true;
							   $successMsg = NOTIFICATION_MODULE_UPDATION_SUCCESS;
							}
							else {
							   $status =false;
							   $errorMsg = NOTIFICATION_MODULE_UPDATION_FAILED;
							}
						}
						else 
						{
						   $status =false;
						   $errorMsg = EMPLOYEE_MODULE_DOCUPLOAD_FAILED;
						}
					}
					else
					{
					   $status =false;
					   $errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
					}
				}
				else
				{
					$con++;
				}
			}
		}
		else
		{
				$status =false;
				$errorMsg = "EMPLOYEE_MODULE_IMAGEIMPORT";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a DocumentMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */

    public function Create($request)
    {
		$result = array();
		$count=0;$count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sendmail=$request[12]; //SEND MAIL STATUS CONTAINS IN ARRAY 12TH VALUE;
        $empid= "0" ;
		try
		{
			$arr = json_decode($request[7],true);
			if(count($arr)!=0){
				for($i=0;$i<count($arr);$i++){
					if($empid=="0"){
						$empid=$arr[$i]['id'];
					}else{
						$empid=$empid.",".$arr[$i]['id'];
					}
				}
			}
			$sql = "SELECT * FROM NotificationMaster WHERE Name = ? and Message=? and Division=? and Department=? and Designation=? and EmployeeIds=? and  OrganizationId=? and StartDate=? and Enddate=? and NotificationPriority=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $request[3],  $request[4], $request[5], $request[6], $empid,  $orgid, $this->getDateformat($request[8]),$this->getDateformat($request[9]),$request[10]));
			if($query->rowCount()==0)
			{
				
				$sql = "INSERT INTO NotificationMaster (Name, Message, Division, Department, Designation,  EmployeeIds,  OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, Enddate ,NotificationPriority,NotificationType) VALUES ( ?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $empid,  $orgid, $mdate, $mid, $mdate, $mid, $mid,$this->getDateformat($request[8]),$this->getDateformat($request[9]),$request[10],$request[11]));
				$count1 =  $query->rowCount();
				$notificationid=$this->db->lastInsertId();
				
				if ($count1 == 1)
				{
					//$empid=Utils::getName($did,'JobModificationMaster','EmployeeId',$this->db);
					$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
					$msg="Notification has been created $empname";
					$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($mid, "Notification", $msg, $orgid));
					$status =true;
					$successMsg = NOTIFICATION_MODULE_CREATION_SUCCESS;
					if($sendmail==true)
					{
						$empids=explode(",",$empid);
						$user_email="";
						foreach($empids as $value)
						{
							$sql="SELECT * from EmployeeMaster where Id=?";
							$query = $this->db->prepare($sql);
							$query->execute(array($value));
							while($row=$query->fetch())
							{
								if($user_email=""){
									$user_email=$row->CompanyEmail;
								}else{
									$user_email=$user_email.",".$row->CompanyEmail;
								}
							}
						}
						if($user_email!="")
						{
							$emailsts=Utils::sendMail($user_email,$request[5],$request[2],$request[3]);
							if($emailsts==true)
							$successMsg = NOTIFICATION_MODULE_CREATION_SUCCESS." and mails have been sent to employees";
							else
							$successMsg = NOTIFICATION_MODULE_CREATION_SUCCESS. " but mail send is failed";
						}
					}
					
					$dir="public/uploads/$orgid/notification";
					if (! is_dir($dir))
					{
						mkdir($dir);
						chmod($dir,0755);
					}
				
					if(isset($_FILES))
					{
						$con=count($_FILES);	
						for($i=0;$i<$con;$i++)
						{
							if(isset($_FILES['file'.$i]))
							{
								$doc1="notification".'_'."$notificationid";
						
								$errors= array();
								$file_name = $_FILES['file'.$i]['name'];
								$ext = pathinfo($file_name, PATHINFO_EXTENSION);
								if ($ext != 'exe' && $ext != 'zip' && $ext != 'rar' )
								{ 
									if (is_dir($dir))
									{
										if ($dh = opendir($dir))
										{
											while (($file = readdir($dh)) != false)
											{
												$filename=$file;
												$ext1 = end((explode(".", $filename)));
												if($filename=="$doc1.$ext1")
												{
													unlink("public/uploads/$orgid/notification/$filename");
												}
											}
										closedir($dh);
										}
									}
									$new_name="notification".'_'."$notificationid.$ext";
									
									$file_size =$_FILES['file'.$i]['size'];
									$file_tmp =$_FILES['file'.$i]['tmp_name'];
									$file_type=$_FILES['file'.$i]['type'];   
									$location="public/uploads/$orgid/notification/";
									if($file_size > 2097152)
									{
									$errors[]='File size must be less than 2 MB';
									}	
								
									if(empty($errors)==true)
									{
									
										if(move_uploaded_file($file_tmp, $location.$new_name))
										{
										$count++;
										}										
									}
									else
									{
										print_r($errors);
									}
									if ($count>=1)
									{
										$status =true;
										$successMsg = EMPLOYEE_MODULE_DOCUPLOAD;

										$sql = "UPDATE NotificationMaster SET  fileattach=?  where Id=?";
										$query = $this->db->prepare($sql);
										try{
											
											$query->execute(array($new_name, $notificationid ));			
											$count2 =  $query->rowCount();
										}catch(Exception $e) {
											$errorMsg = 'Message: ' .$e->getMessage();
										}
										if ($count2 == 1)
										{
											
										   $status =true;
										   $successMsg = NOTIFICATION_MODULE_UPDATION_SUCCESS;
										}
										else {
										   $status =false;
										   $errorMsg = NOTIFICATION_MODULE_UPDATION_FAILED;
										}
									}
									else 
									{
									   $status =false;
									   $errorMsg = EMPLOYEE_MODULE_DOCUPLOAD_FAILED;
									}
								}
								else
								{
								   $status =false;
								   $errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
								}
							}
							
						}
					}
					else
					{
							$status =false;
							$errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
					}
				}
				else 
				{
					   $status =false;
					   $errorMsg = NOTIFICATION_MODULE_CREATION_FAILED;
				}
				
				
			}	
			else
			{
			   $status =false;
			   $errorMsg = NOTIFICATION_MODULE_CREATION_DUPLICATE;
			}
		}
		catch(Exception $e)
		{
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	/**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "DELETE FROM NotificationMaster WHERE Id = :id ";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			$empid=Utils::getName($did,'NotificationMaster','EmployeeIds',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Notification has been deleted $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Notification", $msg, $orgid));
           $status =true;
		   $successMsg = NOTIFICATION_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = NOTIFICATION_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->FirstName. ' '.$row->LastName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeImage($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->ImageName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getPriority($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE ActualValue = ? AND OtherType = 'Priority'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
					$name=$row->DisplayName;
				
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	public function getDateformat($date)
	{	
		$format = $_SESSION['ubihrm_dateformate1'];
		$changedate=$date;
		if($format=="dd/mm/yyyy" || $format=="mm/dd/yyyy" || $format=="yyyy/mm/dd"){
			$temp = explode('/', $date);
			if($format=="dd/mm/yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm/dd/yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}elseif($format=="yyyy/mm/dd"){
				$changedate=$temp[0]."-".$temp[1]."-".$temp[2];
			}
		}elseif($format=="dd-mm-yyyy" || $format=="mm-dd-yyyy" || $format=="yyyy-mm-dd"){
			$temp = explode('-', $date);
			if($format=="dd-mm-yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm-dd-yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}else{
				$changedate=$date;
			}
		}
		return $changedate;
	}
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'NotificationMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name','Message', 'EmployeeIds','StartDate','EndDate','NotificationPriority','fileattach', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		else{
			$ids="";
			$sql="SELECT Id FROM EmployeeMaster where ReportingTo=$userid ";
			$query = $this->db->prepare($sql);
			$query->execute();
			while($row = $query->fetch()){
				if($ids==""){
						$ids = "FIND_IN_SET(".$row->Id .", EmployeeIds )>0 ";
				}else{
					$ids .="OR FIND_IN_SET(".$row->Id .", EmployeeIds )>0 ";
				}
			}
			if($ids!="")
			{
			$ids.=' AND';
			}
			
			$sWhere = " Where (  OrganizationId= $orgid AND $ids Division in (SELECT Division FROM EmployeeMaster where ReportingTo=$userid ) OR Department in (SELECT Department FROM EmployeeMaster where ReportingTo=$userid ) OR Designation in (SELECT Designation FROM EmployeeMaster where ReportingTo=$userid )   ) ";
		}	
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($i==3){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
	 	SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete=""; $download="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editnotification/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip" title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
					
					if($aRow->fileattach != ''){
						$download = '<a rel="tooltip" title="Download"  target="_blank" href="'.URL.'public/uploads/'.$orgid.'/notification/'.$aRow->fileattach.'" ><i class="fa fa-download"></i></a>';
					}else{
						$download = '<a href="#" rel="tooltip" title="No permission to edit"></a>';
					}
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete."&nbsp;&nbsp;|&nbsp;&nbsp;".$download;
				}
				elseif($aColumns[$i]=="StartDate" || $aColumns[$i]=="EndDate"){
					if($aRow->{$aColumns[$i]}=="0000-00-00")
					{
						$row[] = $aRow->{$aColumns[$i]}="";
					}else{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'employee/viewnotification/'.Utils::encode5t($aRow->Id).'/1" >'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				
				elseif($aColumns[$i]=="NotificationPriority")
				{
					$row[] = $this->getPriority($aRow->{$aColumns[$i]},'OtherMaster');
				}
				elseif($aColumns[$i]=="EmployeeIds")
				{
					$emps="All";
					if($aRow->{$aColumns[$i]} != 0){
						$empids=explode(",",$aRow->{$aColumns[$i]});
						for($ii=0;$ii<count($empids);$ii++)
						{
							if($ii==0)
								$emps=Utils::getEmployeeName($empids[$ii],$this->db);
							else
								$emps.=", ".Utils::getEmployeeName($empids[$ii],$this->db);
						}
					}
					$row[] = $emps;
				}
				
				else if($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'EmployeeMaster','FirstName',$this->db);
					
				}
				else if($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getDataTableAlert($editper, $deleteper)
	{
		$sTable = 'GenerateNotification';
		$sIndexColumn = "Id";
		$aColumns = array( 'Title','EmployeeId','Message','NotifyDate','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		else{
			$ids="";
			$sql="SELECT Id FROM EmployeeMaster where ReportingTo=$userid ";
			$query = $this->db->prepare($sql);
			$query->execute();
			while($row = $query->fetch()){
				if($ids==""){
						$ids = "FIND_IN_SET(".$row->Id .", EmployeeIds )>0 ";
				}else{
					$ids .="OR FIND_IN_SET(".$row->Id .", EmployeeIds )>0 ";
				}
			}
			if($ids!="")
			{
			$ids.=' AND';
			}
			
			$sWhere = " Where (  OrganizationId= $orgid AND $ids Division in (SELECT Division FROM EmployeeMaster where ReportingTo=$userid ) OR Department in (SELECT Department FROM EmployeeMaster where ReportingTo=$userid ) OR Designation in (SELECT Designation FROM EmployeeMaster where ReportingTo=$userid )   ) ";
		}	
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						//$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editnotification/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						//$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip" title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
					$row[] =$edit."".$delete;
				}
				elseif($aColumns[$i]=="StartDate" || $aColumns[$i]=="EndDate"){
					if($aRow->{$aColumns[$i]}=="0000-00-00")
					{
						$row[] = $aRow->{$aColumns[$i]}="";
					}else{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'employee/viewnotification/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				elseif($aColumns[$i]=="NotificationPriority")
				{
					$row[] = $this->getPriority($aRow->{$aColumns[$i]},'OtherMaster');
				}
				elseif($aColumns[$i]=="EmployeeId")
				{
					$emps="All";
					if($aRow->{$aColumns[$i]} != 0){
						
						$emps=Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db);
							
					}
					$row[] = $emps;
				}
				
				else if($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'EmployeeMaster','FirstName',$this->db);
					
				}
				else if($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="NotifyDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
