<?php

/**
 * SalarytypeModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ModepaymentModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of GRADE
     * @return array an array with several objects (the results)
     */
    public function getAll($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$sql = "SELECT * FROM ModeMaster WHERE OrganizationId = :id order by Name";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
			if($count>=1) {
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch()) {
					$res = array();
					$res['id'] = $row->Id;
					$res['name'] = $row->Name;
					$data[] = $res;
				}
			}else{
				$status=true;
				$successMsg="No record found.";
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }

	public function getDetail($id) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$id=Utils::decode5t($id);
        $sql = "SELECT * FROM ModeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch()) {
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$data[] = $res;
			}
        }
		if ($count == 1) {
           $status =true;
		   $successMsg = "Mode Payment  fetched successfully!";
        } else {
           $status =false;
		   $errorMsg="There is some problem while updating record.";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	/**
     * Setter for a SalaryTypeMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request) {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$mdate = date("Y-m-d H:i:s");
		$sqlcode="SELECT * FROM ModeMaster WHERE  Name=? and OrganizationId=? and Id<>?";
		$querycode=$this->db->prepare($sqlcode);
		$querycode->execute(array($request[2],  $orgid, $request[3] ));
		$count1=$querycode->rowCount();
		if($count1>=1 ){
			$status =false;
		    $errorMsg ="Mode Payment criteria already exists.";
		}else{
			try{
				$sql = "UPDATE ModeMaster SET Name=?,OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";		
				$query = $this->db->prepare($sql);			
				$query->execute(array($request[2],$orgid, $mdate, $mid,$request[3] ));			
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			///////////////////UPDATE CHILD TABLE OF SALARY TYPE MASTER ////////////
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Mode payment  updated successfully!";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while updating record.";
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	/**
     * Setter for a SalaryTypeMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request) {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$mdate = date("Y-m-d H:i:s");
		$sqlcode="SELECT * FROM ModeMaster WHERE Name=? and OrganizationId=?";
		$querycode=$this->db->prepare($sqlcode);
		$querycode->execute(array($request[2], $orgid));
		$count1=$querycode->rowCount();
		if($count1>=1){
			$status =false;
		    $errorMsg = "Mode  payment or name already exist.";
		}else{
			$sql = "INSERT INTO ModeMaster (Name,OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?)";
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $orgid, $mdate, $mid, $mdate, $mid, $mid,));
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
			   $status =true;
			   $successMsg =  "Mode payment  created successfully!";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while updating record.";
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		// default return
        return $result;
    }
	/**
     * Deletes a specific SALARYTYPE
     * @param  $did contains SALARYTYPE id
     * @return array feedback conatining status of request
     */
    public function Delete($did) {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$sql = "DELETE FROM ModeMaster WHERE Id = :id ";		
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			$status =true;
			$successMsg =  "Mode payment deleted successfully!";
		}else {
		   $status =false;
		   $errorMsg="There is some problem while deleting record.";
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM SalaryTypeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'ModeMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editModePayment/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="Name" )
				{
					$row[] = '<a href="'.URL.'salary/viewModePayment/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
