<?php

/**
 * DiscussionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class MilestoneModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function milestone($user_id)
    {
		$limit = isset($_POST['limit']) ? $_POST['limit'] : "";
		$offset = isset($_POST['offset']) ? $_POST['offset'] : "0";
		$cond="";
		$view_projects=0;
		if($limit!="")
		{
			$cond="limit $limit offset $offset";
		}
		
		$userids=$user_id;
		$sql1 = "SELECT view_all_projects FROM user_master WHERE user_id=:userids";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array(':userids'=>$userids));
		while($row1 = $query1->fetch())
		{
			$view_projects =$row1->view_all_projects;
		}
        
		/////// get userids on the basis of designation ////////
		$levelid =100;
		$sql = "select level_id from designation_master d, user_master u where d.designation_id=u.designation_id and u.user_id=:id";
        	$query = $this->db->prepare($sql);
		$query->execute(array(':id'=>$user_id));
		while($row = $query->fetch())
		{
			$levelid =$row->level_id;
		}
		$sql = "SELECT user_id FROM user_master where designation_id in (select designation_id from designation_master where level_id>:levelid)";
		$query = $this->db->prepare($sql);
		$query->execute(array(':levelid'=>$levelid));
		while($row = $query->fetch())
        	{	
			$userids .=",".$row->user_id;	
		}
		if($view_projects==1)
		{
	        $sql = "SELECT id, project_title, project_prefix, estimated_date, created_date, start_date, completed_date, project_status, owner_id, project_desc FROM project_master order by created_date desc $cond";
		}
		else
		{
	        $sql = "SELECT id, project_title, project_prefix, estimated_date, created_date, start_date, completed_date, project_status, owner_id, project_desc FROM project_master where owner_id in ($userids) order by created_date desc $cond";
		}
		////////////////////////////////////////////////////////
		

        $query = $this->db->prepare($sql);
        $query->execute();
        $result =array();
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->id;
			$res['project_title'] = ucwords(strtolower($row->project_title));
			$res['project_prefix'] = strtoupper($row->project_prefix);
			$res['estimated_date'] = ($row->estimated_date!="0000-00-00")?date(DISPLAY_DATE_FORMATE, strtotime($row->estimated_date)):"Not Set";
			$res['created_date'] = ($row->created_date!="0000-00-00")?date(DISPLAY_DATE_FORMATE, strtotime($row->created_date)):"-";
			$res['start_date'] = ($row->start_date!="0000-00-00")?date(DISPLAY_DATE_FORMATE, strtotime($row->start_date)):"Not Set";
			$res['completed_date'] = $row->completed_date;
			$res['project_status'] =self::getOtherInfo($row->project_status);
			$res['name'] = self::getUserName($row->owner_id);			
			$res['project_desc'] = $row->project_desc;
			//$res['permission']=1;			
			if($user_id==$row->owner_id)
			{
				$res['permission']=1;
			}
			else
			{
				$res['permission']=0;
			}
		
			$result[] =$res;
		}
      
        return $result;
    }


	public function getAll($request)
	{
	try {
		$orgid=$request[1];	
		$userid=$request[0];	
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$adminsts=$_SESSION['ubihrm_user_sts'];
		$sql = "SELECT id,project_title FROM project_master where OrganizationId=? and find_in_set($userid,assigned_to)";
		if($adminsts==1 || $hrsts==1)
			$sql = "SELECT id,project_title FROM project_master where OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$result =array(); $data=array();
		while($row = $query->fetch())
		{
			$res= array();
			$res['id'] = $row->id;
			$res['name'] = strtolower($row->project_title);
			
			$data[] =$res;
		}
	}catch(Exception $e){}
	$result['status']=true;
	$result['data']=$data;
	return $result;
}

 public function getAllDefaultMileStone($request)
 {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SettingMilestone WHERE OrganizationId = :id and ProjectTypeId = :projecttypeid";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$projecttypeid = $request[2];
			
			$query->execute(array(':id' => $orgid, ':projecttypeid' => $projecttypeid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
}
  
  
   public function getDefaultMilestoneByProject($request)  {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT milestones FROM project_master WHERE OrganizationId = :id and id= :projectid";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid, ':projectid' => $request[2] ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())	{
				$milestones = explode(",",$row->milestones);
			}
			for($i=0;$i<count($milestones); $i++) {
				$milestoneid=$milestones[$i];
				$sql = "SELECT * FROM SettingMilestone WHERE OrganizationId = :id and Id = :milestoneid";
				$query = $this->db->prepare($sql);
				try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					$query->execute(array(':id' => $orgid, ':milestoneid' => $milestoneid ));
					$count =  $query->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				if($count>=1)	{
					$status=true;
					$successMsg=$count." record found";
					while($row = $query->fetch())	{
						$res = array();
						$res['id'] = $row->Id;
						$res['name'] = $row->Name;
						$res['Description'] = $row->Description;
						$res['projectid'] = $request[2] ;
						$data[] = $res;
					}
				}else{
				$status=false;
				$errorMsg = "No milestone found for this Project";
			}
		}
        }else{
			$status=false;
			$successMsg = "No record found";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
    }

	public function getUserprojects($request)
	{
	try {
		
		$orgid=$request[1];	
		$userid=$request[0];	
		
		$sql = "SELECT id,project_title FROM project_master where OrganizationId=? and find_in_set($userid,assigned_to)";
		
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$result =array(); $data=array();
		while($row = $query->fetch())
		{
			$res= array();
			$res['id'] = $row->id;
			$res['name'] = strtolower($row->project_title);
			
			$data[] =$res;
		}
	}catch(Exception $e){}
	$result['status']=true;
	$result['data']=$data;
	return $result;
}
     
   
    ///////////////////////////////////Project Milestone/////////////////////////////////
    public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM Milestone WHERE id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['projectid'] = $row->projectid;
				$res['title'] = $row->DefaultMilestoneId;
				if($row->Totalhour!=""){
					$Totalhour =explode(":",$row->Totalhour);
					if($Totalhour[0]!=""){
							$res['durationday'] =(int)$Totalhour[0];
					}if($Totalhour[1]!=""){
							$res['durationhours'] = (int)$Totalhour[1];
					}if($Totalhour[2]!=""){
							$res['durationminutes'] = (int)$Totalhour[2];
					}
				}
				//$res['fromdate'] = Utils::dateformatter($row->startdate);
				//$res['todate'] = Utils::dateformatter($row->enddate);
				$res['desc'] = $row->description;
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = "Activity successfully fetched";
        } else {
           $status =false;
		   $errorMsg = "Problem, while fetching Activity";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    } 
	
	   /////////////////////////////////// getting default Milestone /////////////////////////////////
    public function getdefaultmilestonebyid($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SettingMilestone WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['milestoneid'] = $row->Id;
				$res['name'] = $row->Name;
				$res['description'] = $row->Description;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = "Activity successfully fetched";
        } else {
           $status =false;
		   $errorMsg = "Problem, while fetching Activity";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    } 
	
	
	public function gettimesheetDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid = $_SESSION['ubihrm_user_id'];
        $sql = "SELECT * FROM project_master WHERE id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['project_title'] = $row->project_title;
				
				$res['start_date'] = Utils::dateformatter($row->start_date);
				$res['completed_date'] = Utils::dateformatter($row->completed_date);
				$res['owner_id'] = (int)$row->owner_id;
				$res['project_desc'] = $row->project_desc;
				$res['assigned_to'] =explode(',',$row->assigned_to);
				$res['jobchild'] = array();
				
				$timesheetsql = "SELECT * FROM timesheet_master WHERE project_id = ? and EmployeeId=?";
				$timesheetquery = $this->db->prepare($timesheetsql);
				$timesheetquery->execute(array( $row->id,$mid ));
				while($row1 = $timesheetquery->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->id;
					$res1['priority'] = (int)($row1->priority);
					//$res1['project_id'] =(int)($row1->project_id);
					$res1['taskid'] = $row1->task_id;
					$res1['assignto'] =$row1->EmployeeId;
					$res1['sdate'] = Utils::datetimeformatter($row1->start_time);
					$res1['edate'] = Utils::datetimeformatter($row1->end_time);
					$res1['sstartdate']=Utils::datetimeformatter($row1->timesheetstart);
					$res1['senddate']=Utils::datetimeformatter($row1->timesheetend);
					if($row1->timesheetstart=='0000-00-00 00:00:00'){
						$res1['sstartdate']=Utils::datetimeformatter($row1->start_time);
					}
					if($row1->timesheetend=='0000-00-00 00:00:00'){
						$res1['senddate']=Utils::datetimeformatter($row1->end_time);
					}
					
					$res['jobchild'][] = $res1;
				}
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = JOBMODIFICATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = JOBMODIFICATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }


	////// test for project model //////
public function GetProgressProjectData($pid)
{		
	$msg="";
	$result1 =array();
	$result =array();
	$count1=0;
	$count2=0;
	$totalmilestone=0;
	$totaltasks=0;
	$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : "0";
	$mids="";
	$result['milestonetask'] = array();
 	$sql = "SELECT id FROM milestone where projectid=:pid";
    $query = $this->db->prepare($sql);
    $query->execute(array(':pid'=>$pid));
	$totalmilestone=$query->rowCount();
	while($row3=$query->fetch())
	{
		$mids=$mids.($row3->id).',';
	}
	$mids=rtrim($mids,',');
	
	if($mids!='')
	{
	$sql2 = "SELECT * FROM task_master where milestone_id in ($mids)";
	$query2 = $this->db->prepare($sql2);
	$query2->execute();
	$totaltasks=$query2->rowCount();

	$sql = "SELECT id FROM milestone where projectid=:pid";
        $query = $this->db->prepare($sql);
        $query->execute(array(':pid'=>$pid));
        while($row= $query->fetch())
        {
        
			$mid=$row->id;
			$sql1 = "SELECT count(status) as countstatus, milestone_id, status FROM task_master where milestone_id=$mid";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($row1= $query1->fetch())
			{
				$arr = array();
				$arr['countstatus']= $row1->countstatus;
			
				if($arr['countstatus']!=0)
				{
				
					$arr['milestoneid']= $row1->milestone_id;
					$arr['milestonename']= self::getMilestoneName($row1->milestone_id);
					$arr['status1']= $row1->status;
					$arr['status']= self::getOtherInfo($row1->status);
					if($totaltasks!=0)
					{
						$arr['percent']= round((($row1->countstatus*100)/$totaltasks),2);
						$result['milestonetask'][]=$arr;
					}
					else
					{
						$arr['percent']=0;
						$result['milestonetask'][]=$arr;
					}
				}
			

			}
		
	   	}
		
	$result['totaltasks']=$totaltasks;  	
	$msg=$result;
	}//end of if
	$result1[] =$result;
		
        return $result1;
    }

  public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");	
		$milestonearr  = json_decode($_REQUEST['milestone'],true);
		foreach($milestonearr as $value1){
			if($value1['projectid']!=""){
				$projectid=$value1['projectid'];
				$title=$value1['title'];
				$desc=$value1['desc'];
			//	$fromdate=Utils::getDateformat($value1['fromdate']);
				//$todate=Utils::getDateformat($value1['todate']);
				$durationday=isset($value1['durationday'])?$value1['durationday']:"";
				$durationhours=isset($value1['durationhours'])?$value1['durationhours']:"";
				$durationminutes=isset($value1['durationminutes'])?$value1['durationminutes']:"";
				$todate=$durationday.':'.$durationhours.':'.$durationminutes;
				
				$sql1 = "SELECT * FROM Milestone WHERE DefaultMilestoneId = ? and projectid=? and OrganizationId=? and id != ?";
				$query1 = $this->db->prepare($sql1);
				try{
					$query1->execute(array($title, $projectid, $orgid, $request[3]));
					$count1 =  $query1->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				if($count1>=1) {
					 $status =false;
					 $errorMsg="Milestone is already exist for this project..";
				}else{ 
					$sql = "UPDATE Milestone SET projectid=?, DefaultMilestoneId=?, Totalhour=?, description =?,  LastModifiedById=?, OrganizationId=?, LastModifiedDate=? where id=?";
					try{
						$query = $this->db->prepare($sql);
						$query->execute(array($projectid,$title, $todate, $desc, $mid, $orgid, $mdate,  $request[3] ));
						$count=$query->rowCount();
						if ($count == 1) {
							$status =true;
							$successMsg = "Activity updated successfully";
						} else {
							$status =false;
							$errorMsg = BANK_MODULE_CREATION_FAILED;
						}
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	//////////////////////////////////////////////////////// Update default milestone /////////////////////////////////////////////////////////////
	
	public function UpdateDefaultMilestone($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
	
		
			$sql = "UPDATE SettingMilestone SET Description =?, Name=? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3],$request[4]));
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				$status =true;
			   $successMsg = "Activity updated successfully";
			} else {
			   $status =false;
			   $errorMsg = "Problem while updating Activity";
			}
	
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	///////////////////////////////////////////////////////// Ending Update default milestone ///////////////////////////////////////////////////////
	
	
	
	public function UpdateTimesheet($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		try{
			$mid   = $request[0];//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$projectid = $request[3];
			
			$work = json_decode($_POST['timesheet'], true); 
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['taskid']!="")
				{
					$sstartdate = Utils::getDateTimeformat($work[$i]['sstartdate']);
					$senddate = Utils::getDateTimeformat($work[$i]['senddate']);
					$sqlsalary = "UPDATE timesheet_master SET timesheetstart=?, timesheetend=?, updated_date=? where project_id=? and  EmployeeId =?";
								
					$querysalary = $this->db->prepare($sqlsalary);
					$querysalary->execute(array($sstartdate,$senddate,$mdate,$projectid,$mid));
					$count =  $querysalary->rowCount();
					
				} 
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if ($count == 1) {
			$status =true;
			$successMsg = "Project has been updated successfully";
		}
		else{
			 $status =false;
			 $errorMsg = BANK_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a project_master (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request) {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d");
		$milestonearr  = json_decode($_REQUEST['milestone'],true);
		foreach($milestonearr as $value1){
			if($value1['projectid']!=""){
				$projectid=$value1['projectid'];
				$title=$value1['title'];
				$desc=$value1['desc'];
				//$fromdate=Utils::getDateformat($value1['fromdate']);
				//$todate=Utils::getDateformat($value1['todate']);
				$durationday=$value1['durationday'];
				$durationhours=$value1['durationhours'];
				$durationminutes=$value1['durationminutes'];
				$todate=$durationday.':'.$durationhours.':'.$durationminutes;
				$sql1 = "SELECT * FROM Milestone WHERE DefaultMilestoneId = ? and projectid=? and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				try{
					$query1->execute(array($title,$projectid,$orgid));
					$count1 =  $query1->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				if($count1>=1) {
					 $status =false;
					 $errorMsg="Activity is already exist for this project..";
				}else{ 
					$sql = "INSERT INTO Milestone ( projectid, DefaultMilestoneId, Totalhour ,description,OrganizationId,CreatedById) VALUES (?, ?, ?,  ?, ?, ?)";
					try{
						$query = $this->db->prepare($sql);
						$query->execute(array($projectid,$title,  $todate, $desc, $orgid,  $mid));
						$count=$query->rowCount();
						if ($count == 1) {
							$status =true;
							$successMsg = "Activity configured successfully";
						} else {
							$status =false;
							$errorMsg = BANK_MODULE_CREATION_FAILED;
						}
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	/////////////////////////////////////////////// saving default milestone //////////////////////////////////
	
	 public function saveDefaultMilestone($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d");
		
		$sql1 = "SELECT * FROM SettingMilestone WHERE Name = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[2],$orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg="Activity already exist";
		}else{
						
			$sql = "INSERT INTO SettingMilestone (Name, Description,OrganizationId) VALUES (?, ?, ?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $request[3],$orgid));
			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count >= 1) {
			   $status =true;
			   $successMsg = "Activity has been created successfully";
			} else {
			   $status =false;
			   $errorMsg = BANK_MODULE_CREATION_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	//////////////////////////////////////////////  End saving default milestone ///////////////////////////////
	
	
  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		Utils::Trace("did ");
		
		$sql = "select DefaultMilestoneId from Milestone where id = :id";
		$query= $this->db->prepare($sql);
		$query->execute(array(':id'=> $did));
		$row = $query->fetch();
		$sql2 = "select milestoneid from task_master where milestoneid = :id";
		$query2 = $this->db->prepare($sql2);
		$query2 ->execute(array(':id'=> $row->DefaultMilestoneId));
		$count = $query2->rowCount();
		
		if($count>=1){
			$status =false;
			$errorMsg = "Activity containing employee cannot be deleted. ";
		}else{
			$sql1 = "DELETE FROM Milestone WHERE id = :id ";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( ':id' => $did));
				$count1 =  $query1->rowCount();
				if ($count1 == 1) {
					$status =true;
				   $successMsg = "Activity has been successfully deleted";
				}else {
					$status =false;
				   $errorMsg = "Problem while deleting Activity";
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	///////////////////////////////////////////////////// Deleting default milestone /////////////////////////////////////////////////////
	
	    public function deletedefaultmilestone($did)
		{
        $result = array();
		$count=0; $count1=0; $count2=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		//Utils::Trace("did ");
		$sql1 = "DELETE FROM SettingMilestone WHERE Id = :id ";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
					
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if ($count1 == 1) {
			   $status =true;
				   $successMsg = "Default Activity has been successfully deleted";
			}else {
			   $status =false;
				   $errorMsg = "Problem while deleting Activity";
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	///////////////////////////////////////////////////// End Deleting default milestone ///////////////////////////////////////////////
	
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT Name FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}

	public function getAllHierarchyEmployee($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
				
		$ids =Utils::getReportingIds($mid, $this->db);
		$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) and Id in ($ids) and Is_Delete=0 order by FirstName ";
		
		$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array(':id' => $orgid ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['sts'] = 0;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getProjectDetail($id)
    {
		$result1 =array();
        $result =array();
		$userid = $_SESSION['user_id'];
        $sql = "SELECT * FROM project_master WHERE id=:id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));
		if($query->rowCount()>0)
		{
		    	while($row = $query->fetch())
				{
				$res= array();
				$res['projectid'] =$row->id;
				$res['projectname'] =$row->project_title;
				$res['startdate'] =self::changedateformate($row->start_date);
				$res['enddate'] =self::changedateformate($row->estimated_date);			
				$res['status'] 	=self::getOtherInfo($row->project_status);
				$res['createby'] =self::getUserName($row->owner_id);
				$res['description'] = html_entity_decode($row->project_desc);
				$res['createdate'] =self::changedateformate($row->created_date);
				$res['completedate'] =self::changedateformate($row->completed_date);
				$res['createdate1'] =$row->created_date;
				$res['completedate1'] =$row->completed_date;
				$res['startdate1'] =$row->start_date;
				$res['enddate1'] =$row->estimated_date;
				$res['status1'] 	=$row->project_status;
				$result['projects'][] =$res;
			}
		}
		else
		{
			$result['projects'] = array();
		}


/////////////////////////////////Task Gantt Chart START//////////////////////////////////
		$i=1;
		
		$sql1="SELECT id, start_date, end_date FROM task_master where project_id=:id";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array(':id' =>$id ));

		if($query1->rowcount()>0)
		{
			while($row = $query1->fetch())
			{
				$res = array();
				$res['Phase'] ='Phase '.$i;
				$res['startdate'] = $row->start_date;
				$res['enddate'] = $row->end_date;
				$res['Task'] ='Task '.$i;

				$i++;
				$result['newtaskchart'][] = $res;
			}

		}
		else
		{
			$result['newtaskchart'] = array();
		}

/////////////////////////////////Task Gantt Chart END///////////////////////////////////
		
		$sql = "SELECT id, status, count(id) as totalp FROM task_master where project_id=:id group by status";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));
		if($query->rowCount()>0){
		    while($row = $query->fetch())
			{
				$res= array();
				$res['id'] =$row->id;
				$res['statusid'] =$row->status;
				$res['totalp'] =$row->totalp;
				$res['status'] =self::getOtherInfo($row->status);
				$result['tasks'][] = $res;
			}
		}
		else
		{
			$result['tasks'] = array();
		}
        
        
        $sql = "SELECT bug_id, bug_status, count(bug_id) as totalp FROM bug_master where project_id=:id group by bug_status";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));
		if($query->rowCount()>0){
		    while($row = $query->fetch())
			{
				$res= array();
				$res['id'] =$row->bug_id;
				$res['totalp'] =$row->totalp;
				$res['statusid'] =$row->bug_status;
				$res['status'] =self::getOtherInfo($row->bug_status);
				$result['bugs'][] = $res;
			
			}
		}
		else
		{
			$result['bugs'] = array();
		}
		
		$sql = "SELECT id, emp_id, count(id) as totalp FROM task_master where project_id=:id group by emp_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $id));
		if($query->rowCount()>0){
		    while($row = $query->fetch())
			{
				$res= array();
				$res['id'] =$row->id;
				$res['totalp'] =$row->totalp;
				$res['status'] =self::getUserName($row->emp_id);
				$res['imgsrc'] = self::getImageUrl($row->emp_id);
				$result['users'][] = $res;
			
			}
		}
		else
		{
			$result['users'] = array();
		}
		
        $result1[]= $result;
       return $result1;
    }


	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'project_master';
		$sIndexColumn = "id";
		$aColumns = array(  'project_title','owner_id', 'start_date','completed_date', 'assigned_to', 'project_status', 'id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid  ";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " WHERE (Id in ($ids) AND OrganizationId= $orgid)";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (owner_id in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					
						
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="owner_id" )
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					
				}
				
				elseif($aColumns[$i]=="created_date" || $aColumns[$i]=="start_date" || $aColumns[$i]=="completed_date"){
											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				else if($aColumns[$i]=="project_status"){
					
					if($aRow->{$aColumns[$i]}==1)
						$sts="<span class='label label-success'>Running</span>";
					else if($aRow->{$aColumns[$i]}==2)
						$sts="<span class='label label-warning'>Absconded</span>";
					else if($aRow->{$aColumns[$i]}==3)
						$sts="<span class='label label-danger'>Finished</span>";
					else if($aRow->{$aColumns[$i]}==4)
						$sts="<span class='label label-info'>Re open</span>";
					else if($aRow->{$aColumns[$i]}==5)
						$sts="<span class='label label-primary'>Not begin</span>";
					$row[] = $sts;
				}
				elseif($aColumns[$i]=="assigned_to"){
					$assign=explode(",",$aRow->{$aColumns[$i]});
					$assignemp="";
					for($ij=0;$ij<count($assign);$ij++)
					{
						if($assignemp=="")
							$assignemp=Utils::getEmployeeName($assign[$ij], $this->db);
						else
							$assignemp.=", ".Utils::getEmployeeName($assign[$ij], $this->db);
					}
							
					$row[] = $assignemp;
				}
				
				elseif($aColumns[$i]=="id")
				{
					$edit =""; $delete=""; $checklist="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'timesheet/editproject/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
						
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
						
					$row[] =$edit."&nbsp;|&nbsp;".$delete;
				}
				
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
	
	  ///Milestones
	  	public function GetMilestoneDuration($milestoneid)
	{
		$result = array(); $res=array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$totalday1=0;
			//$sql="select * from task_master where projectid =? ";
			$sql="select * from Milestone where id =? ";
			$query=$this->db->prepare($sql);
			$query->execute(array($milestoneid));
			$count = $query->rowcount();
			$days1='';$hours1='';$minutes1='';
			while($row1= $query->fetch()) {
				//$start = new DateTime($row1->fromdate);
			//	$since_start1 = $start->diff(new DateTime($row1->todate));
				$start = $row1->startdate;
				$today = $row1->enddate;
				$days1 = strtotime($today) - strtotime($start);
				$totalday1 = floor($days1/(60*60*24));
			}
			$esttotal_time =$totalday1.' days';
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		return $esttotal_time;
		
	}
	
	  public function getDataMTable($editper, $deleteper,$type)
	{
		$sTable = 'Milestone';
		$sIndexColumn = "id";
		$aColumns = array( 'DefaultMilestoneId','projectid', 'Totalhour','description','id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  projectid desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid and projectid in (select id from project_master where project_status=$type) ";
		}else{
			//$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			//$sWhere = " WHERE (CreatedById in ($ids) AND OrganizationId= $orgid) and projectid in (select id from project_master where project_status=$type) ";
			$sWhere = " WHERE ( OrganizationId= $orgid) and projectid in (select id from project_master where (owner_id=$userid or ClientManager=$userid or ProjectLead =$userid) and project_status=$type) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="projectid"){
				$sWhere .= " (projectid in ( select id from project_master where project_title LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else if($aColumns[$i]=="DefaultMilestoneId"){
				$sWhere .= " (DefaultMilestoneId in ( select Id from SettingMilestone where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=1){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					
						
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				
				/* if($aColumns[$i]=="startdate" || $aColumns[$i]=="enddate"){
											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				} */
				if($aColumns[$i]=="Totalhour"){
						
						if($aRow->Totalhour!=""){
							$Totalhour=explode(":",$aRow->Totalhour);
						
						if($Totalhour[0]!=0 && $Totalhour[1]!=0 && $Totalhour[2]!=0)
						$row[] =$Totalhour[0]." Days, ". $Totalhour[1]." Hours, ".$Totalhour[2]." minutes";
						else if($Totalhour[0]!=0 && $Totalhour[1]!=0)
						$row[] =$Totalhour[0] ." Days, ". $Totalhour[1]." Hours ";
						else if($Totalhour[1]!=0 && $Totalhour[2]!=0)
						$row[] =$Totalhour[1]." Hours, ".$Totalhour[2]." minutes ";
						else if($Totalhour[0]!=0)
						$row[] =$Totalhour[0]." Days";
						else if($Totalhour[1]!=0)
						$row[] =$Totalhour[1]." Hours";
						else if($Totalhour[2]!=0)
						$row[] =$Totalhour[2]." minutes";
						else if($Totalhour[0]==0 && $Totalhour[1]==0 && $Totalhour[2]==0)
						$row[] ="";
					}else{
						$row[] ="";
					}
				}
			elseif($aColumns[$i]=="projectid"){
											
					$row[] = $this->getProject($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="DefaultMilestoneId"){
											
					$row[] = $this->getName($aRow->{$aColumns[$i]},"SettingMilestone");
				}
				/* elseif($aColumns[$i]=="id" && $i==4 )
				{
						$row[] = $this->GetMilestoneDuration($aRow->{$aColumns[$i]});
				} */
				elseif($aColumns[$i]=="id")
				{
					$edit =""; $delete=""; $checklist="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'milestone/editmilestone/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/'.Utils::encode5t($aRow->projectid).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';						
					}
					
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
						
					$row[] =$edit."&nbsp;|&nbsp;".$delete;
				}
				
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
	
	////////////////////////////////////////// getting default Milestone DataTable ///////////////////////////////////////////
	
	
	  public function getDefaultMilestoneData($editper, $deleteper)
	{
		$sTable = 'SettingMilestone';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Description','Id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid  ";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " WHERE (Id in ($ids) AND OrganizationId= $orgid)";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (owner_id in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					
						
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				
				if($aColumns[$i]=="startdate" || $aColumns[$i]=="enddate"){
											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
			elseif($aColumns[$i]=="projectid"){
											
					$row[] = $this->getProject($aRow->{$aColumns[$i]});
				}
				
				elseif($aColumns[$i]=="Id")
				{
					$edit =""; $delete=""; $checklist="";
					if($editper){
						$edit = '<a rel="tooltip"  title="Edit" onclick="angular.element(this).scope().fetchDefaultMilestone(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#myModal" href="#" ><i class="fa fa-edit"></i></a>';
						
						
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
						
					}
					
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->{$aColumns[$i]}.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
						
					$row[] =$edit."&nbsp;|&nbsp;".$delete;
				}
				
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
	
	
	///////////////////////////////////////// end getting default Milestone DataTable ////////////////////////////////////
	
	public function getProject($id)
	{
	try {
		$project_name="N.A.";
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "SELECT project_title FROM project_master where OrganizationId=? and id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid,$id));
		while($row = $query->fetch())
		{
			$project_name = strtolower($row->project_title);
		}
	}catch(Exception $e){}
	

	return $project_name;
}
	
	  
	  
}
