<?php

/**
 * LoginModel
 *
 * Handles the user's login / logout / registration stuff
 */


class LoginModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
    /**
     * Login process (for DEFAULT user accounts).
     * Users who login with Facebook etc. are handled with loginWithFacebook()
     * @return bool success state
     */
    public function login($request,$pdf=1)
    {
    	$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$user_name = strtolower($request[0]);
		$user_password = $request[1];
		//echo Utils::encode5t($user_name);

        // get user's data
        // (we check if the password fits the password_hash via password_verify() some lines below)
        $sth = $this->db->prepare("SELECT Id, 
                                          EmployeeId,
                                          Password,
                                          UserName,userprofile,
                                          RoleId,
                                          OrganizationId,
                                          CreatedDate,
                                          CreatedById,
                                          LastModifiedDate,
                                          LastModifiedById,
										  AdminSts,
                                          OwnerId,HRSts FROM   UserMaster
                                   WHERE  (UserName = :user_name or username_mobile = :mobile)
                                          AND Password = :user_password and VisibleSts=1 and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) ");
        // DEFAULT is the marker for "normal" accounts (that have a password etc.)
        // There are other types of accounts that don't have passwords etc. (FACEBOOK)
       // echo Utils::encode5t($user_name)."<br>";
        //echo Utils::encode5t($user_password)."<br>";
        try{
			$sth->execute(array(':user_name' => Utils::encode5t($user_name), ':mobile' => Utils::encode5t($user_name), ':user_password' => Utils::encode5t($user_password)));
        	$count =  $sth->rowCount();
			$row = $sth->fetch();
			//$count =  $sth->rowCount();
			
			
			
		$ubihrmsap_integration_status=0;
			
        if($count==1)
        {
			
				$ubihrmsap_integration_status=Utils::getName($row->OrganizationId, "Organization", "SAP_Integration_status", $this->db);
			//echo $ubihrmsap_integration_status;
			//echo $mdate = date("Y-m-d H:i:s");
			$query = $this->db->prepare("select * from licence_ubihrm where OrganizationId = ? and curdate() between start_date and end_date");
			$query->execute(array($row->OrganizationId));
			$countt = $query->rowCount();
			if($countt==0)
			{
				$result['data'] =$data;
				$result['status']=false;
				$result['successMsg']=$successMsg;
				$result['errorMsg']="Your plan has expired.";
				return $result;
			}
			$timezone=$this->getOrgTimezone($row->OrganizationId);
			date_default_timezone_set($timezone);
			$mdate = date("Y-m-d H:i:s");
			
        	$status=true;
        	$successMsg=$count." record found";
			/////for getting IP Address//////////
			
			if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
				$ip = $_SERVER['HTTP_CLIENT_IP'];
			} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
				$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
			} else {
				$ip = $_SERVER['REMOTE_ADDR'];
			}
			/////Getting Browser Name and Plateform through getBrowser() function////////
			
			$historyid="";
			$logintime=date("dS M, h:i A");
			if($pdf==1){
			$ua=$this->getBrowser();
			$browser=$ua['name'] . " , " .$ua['platform'] ;
			$query = $this->db->prepare("INSERT INTO LoginHistory( loggedinById, LoginTime,  IpAddress, Browser) VALUES (?,?,?,?)");
			$query->execute(array($row->EmployeeId,$mdate,$ip,$browser));
			$historyid=$this->db->lastInsertId();
			
			$query = $this->db->prepare("SELECT LoginTime FROM LoginHistory WHERE Id<>? and loggedinById=? order by Id desc limit 1");
			$query->execute(array($historyid, $row->EmployeeId));
			date_default_timezone_set($timezone);
			while($history = $query->fetch()){
				$logintime=date("dS M, h:i A", strtotime($history->LoginTime));
			}
			}
			$designame="";
			$querydesig = $this->db->prepare("SELECT Name FROM DesignationMaster WHERE Id = ?");
			$querydesig->execute(array( $row->RoleId));
			while($empdesig = $querydesig->fetch())
			{
				$designame=$empdesig->Name;
			}
			$hrsts=0;
			$queryhrsts = $this->db->prepare("SELECT HRSts FROM DesignationMaster WHERE Id = ?");
			$queryhrsts->execute(array( $row->RoleId));
			while($emphrsts = $queryhrsts->fetch())
			{
				$hrsts=$emphrsts->HRSts;
			}
			
        	Session::init();
            Session::set('ubihrm_user_logged_in', true);
			Session::set('ubihrm_org_id', $row->OrganizationId);
			Session::set('ubihrm_user_id',$row->EmployeeId);
			Session::set('ubihrm_user_roleid',$designame);
			Session::set('ubihrm_user_sts',$row->AdminSts);
			Session::set('ubihrm_hr_sts',$row->HRSts);
			Session::set('ubihrm_login_historyid',$historyid);
			Session::set('ubihrm_lastlogin_time',$logintime);
			Session::set('ubihrm_fiscalid',0);
			Session::set('ubihrm_fiscalformat','');
			Session::set('ubihrm_SAPintegration_status',$ubihrmsap_integration_status);
			Utils::Trace("this is session user id ".$_SESSION['ubihrm_user_id']);
			////////////////////////////////////////////////////////////////////
			$smtpuser = Utils::getName($row->OrganizationId, "Organization", "smtpuser", $this->db);
			if($smtpuser == "")
				$smtpuser = "ubihrmsupport@ubitechsolutions.com";
			Session::set('ubihrm_smtpuser', $smtpuser);
			Session::set('session_expiry',(time()+ (60 * 60)));
			
			$queryf = $this->db->prepare("SELECT Id, StartDate, EndDate FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts=1");
			$queryf->execute(array($row->OrganizationId));
			while($rowf = $queryf->fetch())
			{
				Session::set('ubihrm_fiscalid',$rowf->Id);
				Session::set('ubihrm_fiscalformat',(date("M'y", strtotime(date($rowf->StartDate)))." - ".date("M'y", strtotime(date($rowf->EndDate)))));
			}
			$divid =0;
			$query = $this->db->prepare("SELECT ImageName, TIMESTAMPDIFF(year,DOJ, curdate()) as totalexp, Gender, FirstName, LastName, Division, EmployeeCode, EmployeeStatus FROM EmployeeMaster WHERE Id = ?");
			$query->execute(array($row->EmployeeId));
			if ($query->rowCount()>0) {
				$emp = $query->fetch();
				Session::set('user_empname', ucwords(strtolower($emp->FirstName." ".$emp->LastName)));
				Session::set('user_empcode', $emp->EmployeeCode);
				Session::set('user_empdivision', $emp->Division);
				Session::set('user_totalexp', $emp->totalexp);
				Session::set('user_empsts', $emp->EmployeeStatus);
				$divid =$emp->Division;
				
				if(!file_exists("public/uploads/".$row->OrganizationId."/".$emp->ImageName))
				{
					if($emp->Gender == 1){
						Session::set('user_logged_image', "public/avatars/male.png");
					}else{
						Session::set('user_logged_image', "public/avatars/female.png");
					}				
				}else{
					Session::set('user_logged_image', "public/uploads/".$row->OrganizationId."/".$emp->ImageName);
				}
			}
			$dateformat1="";
			$dateformat2="";
			$timeformat="";
			$currency="";
			$timezone="";
			$query = $this->db->prepare("SELECT CurrencyId, DateFormatId, TimeFormatId, TimeZoneId FROM DivisionMaster WHERE Id = ? and OrganizationId=?");
			$query->execute(array($divid, $row->OrganizationId));
			if ($query->rowCount()>0) {
				$emp = $query->fetch();
				
				$query11 = $this->db->prepare("SELECT OtherType, ActualValue, DisplayName FROM OtherMaster WHERE Id = ? or Id = ?");
				$query11->execute(array( $emp->DateFormatId, $emp->TimeFormatId));
				while($emp1 = $query11->fetch())
				{

			Utils::Trace("15");
			if($emp1->OtherType=="DateFormat"){
						$dateformat1=$emp1->ActualValue;
						$dateformat2=$emp1->DisplayName;
					}elseif($emp1->OtherType=="TimeFormat"){
						$timeformat=$emp1->ActualValue;
					}
				}
				
				$query12 = $this->db->prepare("SELECT CurrencyCode, CurrencyImage FROM CurrencyMaster WHERE Id = ?");
				$query12->execute(array( $emp->CurrencyId));
				while($emp1 = $query12->fetch())
				{
					$currency=$emp1->CurrencyCode;
				}
				
				$query13 = $this->db->prepare("SELECT Name FROM ZoneMaster WHERE Id = ?");
				$query13->execute(array( $emp->TimeZoneId));
				while($emp1 = $query13->fetch())
				{
					$timezone=$emp1->Name;
				}
				
			}
			
			if($dateformat1=="" || $timeformat=="" || $currency=="" || $timezone=="")
			{
				$query = $this->db->prepare("SELECT Currency, DateFormat, TimeFormat, TimeZone FROM Organization WHERE Id = ?");
				$query->execute(array($row->OrganizationId));
				if ($query->rowCount()>0) {
					$emp = $query->fetch();
					
					if($dateformat1=="" || $timeformat=="")
					{
						$query11 = $this->db->prepare("SELECT OtherType, ActualValue, DisplayName FROM OtherMaster WHERE Id = ? or Id = ?");
						$query11->execute(array( $emp->DateFormat, $emp->TimeFormat));
						while($emp1 = $query11->fetch())
						{
							if($emp1->OtherType=="DateFormat"){
								$dateformat1=$emp1->ActualValue;
								$dateformat2=$emp1->DisplayName;
							}elseif($emp1->OtherType=="TimeFormat"){
								$timeformat=$emp1->ActualValue;
							}						
						}
					}
					if($currency=="")
					{
						$query12 = $this->db->prepare("SELECT CurrencyCode, CurrencyImage FROM CurrencyMaster WHERE Id = ?");
						$query12->execute(array( $emp->Currency));
						while($emp1 = $query12->fetch())
						{
							$currency=$emp1->CurrencyCode;
							/*if($emp1->CurrencyImage=="")
							$currency=$emp1->CurrencyCode;					
							else
							$currency="<i class='fa fa-".$emp1->CurrencyImage."'></i>";*/
						}	
					}
					if($timezone=="")
					{
						$query13 = $this->db->prepare("SELECT Name FROM ZoneMaster WHERE Id = ?");
						$query13->execute(array( $emp->TimeZone));
						while($emp1 = $query13->fetch())
						{
							$timezone=$emp1->Name;
						}
					}
				}
			}
			
			if($dateformat1==""){
				$dateformat1="yyyy-mm-dd";
				$dateformat2="Y-m-d";
			}if($timeformat==""){
				$timeformat="h:i A";
			}if($currency==""){
				$currency="<i class='fa fa-dollar'></i>";
			}if($timezone==""){
				$timezone="Asia/Kolkata";
			}
			$timeformat1="h:i";
			$orgname=Utils::getName($row->OrganizationId, "Organization", "Name", $this->db);
			Session::set('ubihrm_org_name', $orgname);
			Session::set('ubihrm_currencycode', $currency);
			Session::set('ubihrm_dateformate', $dateformat1);
			Session::set('ubihrm_dateformate1', $dateformat2);
			Session::set('ubihrm_timeformate', $timeformat);
			Session::set('ubihrm_datetimeformate',$dateformat2.' '.$timeformat1);
			Session::set('ubihrm_timezone', $timezone);
			
			Session::set('ubihrm_employeetab', false);
			Session::set('ubihrm_attendancetab', false);
			Session::set('ubihrm_leavetab', false);
			Session::set('ubihrm_salarytab', false);
			Session::set('ubihrm_setuptab', false);
			Session::set('ubihrm_performancetab', false);
			Session::set('ubihrm_timesheettab', false);
			
			/* $query = $this->db->prepare("select TabId from ModuleMaster where ModuleSts=1 and TabId<>0 and Id in (SELECT ModuleId FROM UserPermission WHERE ViewPermission =1 and RoleId = ? and OrganizationId = ?) group by TabId");
			$query->execute(array($row->RoleId, $row->OrganizationId)); */
				$query = $this->db->prepare("select TabId from ModuleMaster where ModuleSts=1 and TabId<>0 and Id in (SELECT ModuleId FROM UserProfile_permission WHERE ViewPermission =1 and Userprofileid = ? and OrganizationId = ?) group by TabId");
			$query->execute(array($row->userprofile, $row->OrganizationId));
			if ($query->rowCount()>0) {
				$perm1 = array();
				while($tab = $query->fetch())
				{
					
					if($tab->TabId==1){
						Session::set('ubihrm_employeetab', true);
					}elseif($tab->TabId==2){
						Session::set('ubihrm_attendancetab', true);
					}elseif($tab->TabId==3){
						Session::set('ubihrm_leavetab', true);
					}elseif($tab->TabId==4){
						Session::set('ubihrm_salarytab', true);
					}elseif($tab->TabId==5){
						Session::set('ubihrm_setuptab', true);
					}elseif($tab->TabId==6){
						Session::set('ubihrm_performancetab', true);
					}elseif($tab->TabId==7){
						Session::set('ubihrm_timesheettab', true);
					}
					
				}			
			}
			
			Session::set('user_perm_arr', array());
			/* $query = $this->db->prepare("SELECT ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission FROM UserPermission WHERE RoleId = ? and OrganizationId = ?");
			$query->execute(array($row->RoleId, $row->OrganizationId)); */
			$query = $this->db->prepare("SELECT ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission FROM UserProfile_permission WHERE Userprofileid = ? and OrganizationId = ?");
			$query->execute(array($row->userprofile, $row->OrganizationId));
			if ($query->rowCount()>0) {
				$perm1 = array();
				while($permission = $query->fetch())
				{
					$perm = array();
					$perm['module']=$permission->ModuleId;
					$perm['view']=$permission->ViewPermission;
					$perm['edit']=$permission->EditPermission;
					$perm['delete']=$permission->DeletePermission;
					$perm['add']=$permission->AddPermission;
					$perm1[] =$perm;
				}
				Session::set('user_perm_arr', $perm1);
				
			}
			////////////////CHECK ORGANIZATION'S ALL PERMISSIONS FOR SELF SERVICE TABS///////////
			
			Session::set('org_perm_arr', array());
			$query = $this->db->prepare("SELECT ModuleId, ViewPermission FROM OrgPermission WHERE OrgId = ?");
			$query->execute(array($row->OrganizationId));
			if ($query->rowCount()>0) {
				$perm1 = array();
				while($permission = $query->fetch())
				{
					$perm = array();
					$perm['module']=$permission->ModuleId;
					$perm['view']=$permission->ViewPermission;
					$perm1[] =$perm;
				}
				Session::set('org_perm_arr', $perm1);
				
			}
			////////////////////// CALLING UPDATE FUNCTION FOR INITIAL UPDATE OF SOFTWARE ONLY ON ADMIN LOGIN /////////////
			
			/*if($row->AdminSts==1){
				$this->UpdateFieldsFirst();
			}*/
			
			if ($request[2]==1) {
				// set cookie
				setcookie('user_name', $user_name, 2000000000);
				setcookie('user_password', $user_password, 2000000000);
				setcookie('user_rememberme', 'true', 2000000000); 
		   }else {
					/* Cookie expires when browser closes */
					if(isset($_COOKIE['user_rememberme']))
					{
						unset($_COOKIE['user_rememberme']);
						unset($_COOKIE['user_name']);
						unset($_COOKIE['user_password']);
						
						setcookie('user_name', '', 2000000000);
						setcookie('user_password', '', 2000000000);
						setcookie('user_rememberme', 'false', 2000000000);
						
					}
			}
        }else{
        	$status=false;
        	$errorMsg="Login failed!";
        }
       }catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
    $orgid=isset($_SESSION['ubihrm_org_id'])?$_SESSION['ubihrm_org_id']:0;   
    $result['data'] =$data;
    $result['orgid'] = $orgid;
	$result['status']=$status;
	 $result['sap_integration_status'] = $ubihrmsap_integration_status;
	 
	$result['successMsg']=$successMsg;
	$result['errorMsg']=$errorMsg;
	
	
        
        return $result;
        
	
        // block login attempt if somebody has already failed 3 times and the last login attempt is less than 30sec ago
        /*if (($result->user_failed_logins >= 3) AND ($result->user_last_failed_login > (time()-30))) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_WRONG_3_TIMES;
            return false;
        }*///commented by jaidev

        // check if hash of provided password matches the hash in the database
      /*  if (password_verify($_POST['user_password'], $result->user_password_hash)) {

            if ($result->user_active != 1) {
                $_SESSION["feedback_negative"][] = FEEDBACK_ACCOUNT_NOT_ACTIVATED_YET;
                return false;
            }

            // login process, write the user data into session
            Session::init();
            Session::set('ubihrm_user_logged_in', true);
            Session::set('user_id', $result->user_id);
            Session::set('user_name', $result->user_name);
            Session::set('user_email', $result->user_email);
            Session::set('user_account_type', $result->user_account_type);
            Session::set('user_provider_type', 'DEFAULT');
            // put native avatar path into session
            Session::set('user_avatar_file', $this->getUserAvatarFilePath());
            // put Gravatar URL into session
            $this->setGravatarImageUrl($result->user_email, AVATAR_SIZE);

            // reset the failed login counter for that user (if necessary)
            if ($result->user_last_failed_login > 0) {
                $sql = "UPDATE users SET user_failed_logins = 0, user_last_failed_login = NULL
                        WHERE user_id = :user_id AND user_failed_logins != 0";
                $sth = $this->db->prepare($sql);
                $sth->execute(array(':user_id' => $result->user_id));
            }

            // generate integer-timestamp for saving of last-login date
            $user_last_login_timestamp = time();
            // write timestamp of this login into database (we only write "real" logins via login form into the
            // database, not the session-login on every page request
            $sql = "UPDATE users SET user_last_login_timestamp = :user_last_login_timestamp WHERE user_id = :user_id";
            $sth = $this->db->prepare($sql);
            $sth->execute(array(':user_id' => $result->user_id, ':user_last_login_timestamp' => $user_last_login_timestamp));

            // if user has checked the "remember me" checkbox, then write cookie
            if (isset($_POST['user_rememberme'])) {

                // generate 64 char random string
                $random_token_string = hash('sha256', mt_rand());

                // write that token into database
                $sql = "UPDATE users SET user_rememberme_token = :user_rememberme_token WHERE user_id = :user_id";
                $sth = $this->db->prepare($sql);
                $sth->execute(array(':user_rememberme_token' => $random_token_string, ':user_id' => $result->user_id));

                // generate cookie string that consists of user id, random string and combined hash of both
                $cookie_string_first_part = $result->user_id . ':' . $random_token_string;
                $cookie_string_hash = hash('sha256', $cookie_string_first_part);
                $cookie_string = $cookie_string_first_part . ':' . $cookie_string_hash;

                // set cookie
                setcookie('rememberme', $cookie_string, time() + COOKIE_RUNTIME, "/", COOKIE_DOMAIN);
            }

            // return true to make clear the login was successful
            return true;

        } else {
            // increment the failed login counter for that user
            $sql = "UPDATE users
                    SET user_failed_logins = user_failed_logins+1, user_last_failed_login = :user_last_failed_login
                    WHERE user_name = :user_name OR user_email = :user_name";
            $sth = $this->db->prepare($sql);
            $sth->execute(array(':user_name' => $_POST['user_name'], ':user_last_failed_login' => time() ));
            // feedback message
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_WRONG;
            return false;
        }*/  //commented by jaidev

        // default return
       // return false;
    }
	
	//////////////////////////  CODE EXECUTING BEFORE LOGIN  /////////////////////////
	
	/*public function UpdateFieldsFirst()
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$mdate= date("Y-m-d H:i:s");
		
		///////////  AUTO CREATING OF FISCAL YEAR AT THE END OF YEAR  //////////////
		
		$sql = "SELECT Id, YEAR(Date_add(StartDate, Interval 12 month)) as newyear, Date_add(StartDate, Interval 12 month) as startdate, Date_add(EndDate, Interval 12 month) as enddate FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts=1 and EndDate <= CURDATE()";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
			
				$sql2 = "INSERT INTO FiscalMaster(Name, StartDate, EndDate, FiscalSts, OrganizationId) VALUES(?, ?, ?, ?, ?)";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( "Fiscal Year ".$row->newyear, $row->startdate, $row->enddate, 1, $orgid));
				
				$sql2 = "UPDATE FiscalMaster SET FiscalSts=0 WHERE Id = ?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $row->Id ));
					
			}
		}catch(Exception $e) {
			
			}
		
		
		///////////// PENDING JOB MODIFICATION QUERY AUTO FIRING ON ADMIN LOGIN /////////////////
		
		$sql = "SELECT * FROM JobModificationMaster WHERE OrganizationId = ? and ApplySts=0 and ApplyFrom <= CURDATE()";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				$title = "Job Modification";
				/*if($row->ModifyType==1)
					$title = "Employee Promotion";
				else 
					$title = "Employee Demotion";
					
				$sql1 = "SELECT * FROM JobModificationChild WHERE JobId = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id ));
				while($row1 = $query1->fetch())
				{
					$sql2 = "UPDATE EmployeeMaster SET ".$row1->FieldName." = ".$row1->NewValue." WHERE Id = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->EmployeeId ));					
					
					$msg = "";
					if($row1->FieldName=="EmployeeCTC"){
						$msg ="Monthly CTC has been changed to ".$row1->NewValue;
					}else if($row1->FieldName=="DOC"){
						$msg ="Confirmation date has been set to ".date("d F, Y", strtotime($row1->NewValue));
					}else if($row1->FieldName=="EmployeeStatus"){
						$msg ="Employee Status has been changed to ".$this->getName($row1->NewValue, 'EmploymentStatusMaster');
					}else if($row1->FieldName=="Division"){
						$msg ="Division has been changed to ".$this->getName($row1->NewValue, 'DivisionMaster');
					}else if($row1->FieldName=="Department"){
						$msg ="Department has been changed to ".$this->getName($row1->NewValue, 'DepartmentMaster');
					}else if($row1->FieldName=="Grade"){
						$msg ="Grade has been changed to ".$this->getName($row1->NewValue, 'GradeMaster');
					}else if($row1->FieldName=="Designation"){
						$msg ="Designation has been changed to ".$this->getName($row1->NewValue, 'DesignationMaster');
					}	
					$sql2 = "INSERT INTO EmployeeHistory(EmployeeId, Title, Message, EventDate, OrganizationId) VALUES(?, ?, ?, ?, ?)";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->EmployeeId, $title, $msg, $mdate, $orgid));
					
				}
				
				$sql2 = "UPDATE JobModificationMaster SET ApplySts=1 WHERE Id = ?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $row->Id ));	
			}
		}catch(Exception $e) {
			
			}
			
			///////////  AUTO CREATING OF EMPLOYEE ASSESSMENT   //////////////
		$provision=0;	
		$fromdate="";
		$todate="";
		$assessmentype=0;
		$empid = $_SESSION['ubihrm_user_id'];	
		$count = 0;
		$desiglevel="";
		
		$sql = "SELECT Id,Designation FROM EmployeeMaster WHERE OrganizationId = ? and  ReportingTo = ? and DOL ='0000-00-00' or Id = ?";
		$query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid,$empid,$empid));
			
			while($row=$query->fetch())
			{
				
				$assessmentype=0;
				$emp=$row->Id;
				$desig=$row->Designation;
				$sql1 = "SELECT ProvisionPeriod  FROM EmployeeMaster WHERE Id= ? and OrganizationId = ? and  DOL='0000-00-00' and CURDATE() BETWEEN  DOJ AND (DOJ + Interval ProvisionPeriod month) and ProvisionPeriod <> 0";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($emp, $orgid ));
				if($row1=$query1->fetch()){
					$provision=$row1->ProvisionPeriod;
					$fromdate=$mdate;
					$todate=$mdate;
					$assessmentype=4;
				}
				else{
				
						$sql1 = "SELECT Period,DesignationLevel FROM AssessmentObjective WHERE OrganizationId = ? and DesignationId = ? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid,$desig));
						while($r1=$query1->fetch()){
							$assessmentype=$r1->Period;
							$desiglevel=$r1->DesignationLevel;
						}
						$sql1 = "SELECT * FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts = ? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid,1));
						while($row1 = $query1->fetch())
						{
							$ts1 = strtotime($row1->StartDate);
							$ts2 = strtotime($row1->EndDate);
							$ts3 = strtotime('now');
							
							if($assessmentype == 1){
								$fromdate=$row1->StartDate;
								$todate=$row1->EndDate;
							}
							elseif($assessmentype == 2){
								$sixMonthsLater = strtotime("+6 months", $ts1);
								if($ts3 > $sixMonthsLater){
								
									$sixMonthsLater =date('Y-m-d', strtotime("+6 months", $ts1));
									$fromdate= $sixMonthsLater;
									$todate= $row1->EndDate;
								}
								else{
								
									$sixMonthsLater =date('Y-m-d', strtotime("+6 months", $ts1));
									$fromdate= $row1->StartDate;
									$todate= $sixMonthsLater;
										
								}						
							}
							elseif($assessmentype == 3){
								$nineMonthsLater = strtotime("+9 months", $ts1);
								$sixMonthsLater = strtotime("+6 months", $ts1);
								$threeMonthsLater = strtotime("+3 months", $ts1);
								if($ts3 > $ts1 && $threeMonthsLater <= $ts1){
									$threeMonthsLater =date('Y-m-d', strtotime("+3 months", $ts1));
									$fromdate= $row1->StartDate;
									$todate= $threeMonthsLater;
								}
								elseif($ts3 > $threeMonthsLater && $sixMonthsLater <=$threeMonthsLater ){
									$threeMonthsLater =date('Y-m-d', strtotime("+3 months", $ts1));
									$sixMonthsLater =date('Y-m-d', strtotime("+6 months", $ts1));
									$fromdate= $threeMonthsLater;
									$todate=$sixMonthsLater;
								}
								elseif($ts3 > $sixMonthsLater && $nineMonthsLater <=$sixMonthsLater ){
									$nineMonthsLater =date('Y-m-d', strtotime("+9 months", $ts1));
									$sixMonthsLater =date('Y-m-d', strtotime("+6 months", $ts1));
									$fromdate= $sixMonthsLater;
									$todate=$nineMonthsLater;
								}
								elseif($ts3 >= $nineMonthsLater && $nineMonthsLater <= $ts2){
									$nineMonthsLater =date('Y-m-d', strtotime("+9 months", $ts1));
									$fromdate= $nineMonthsLater;
									$todate= $row1->EndDate;
								}
							}							
						}
					}
					
					if($assessmentype != 0 )	{			
						$sqla = "SELECT * FROM EmployeeAssessment WHERE EmployeeId =? and FromDate =? and ToDate = ?";
						$querya = $this->db->prepare($sqla);
						$querya->execute(array( $emp,$fromdate,$todate));
						$count =  $querya->rowCount();
						if($rowa=$querya->fetch()){
							$eid=$rowa->Id;	
						}else{
							$sql2 = "INSERT INTO EmployeeAssessment (  EmployeeId, FromDate, ToDate, AssessmentType, CreatedById, CreatedDate, OrganizationId, OwnerId,DesignationLevel) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?)";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array( $emp,$fromdate,$todate,$assessmentype,$empid,$mdate,$orgid,$empid,$desiglevel ));
						}
					}
			}
				
			
		}catch(Exception $e) {
				
			}
	}*/

	public function getOrgTimezone($id)
	{
		$name ="";
		$sql = "Select z.Name as zname from Organization o,ZoneMaster z where o.TimeZone=z.Id and o.Id= :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->zname;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	
	public function getName($id, $tablename)
	{
		$name ="";
		$sql = "SELECT * FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	
	///////////getting Browser////////////
	
		public	function getBrowser() 
			{ 
				$u_agent = $_SERVER['HTTP_USER_AGENT']; 
				$bname = 'Unknown';
				$platform = 'Unknown';
				$version= "";
				$ub = "";
				//First get the platform?
				if (preg_match('/linux/i', $u_agent)) {
					$platform = 'linux';
				}
				elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
					$platform = 'mac';
				}
				elseif (preg_match('/windows|win32/i', $u_agent)) {
					$platform = 'windows';
				}
				
				// Next get the name of the useragent yes seperately and for good reason
				if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) 
				{ 
					$bname = 'Internet Explorer'; 
					$ub = "MSIE"; 
				} 
				elseif(preg_match('/Firefox/i',$u_agent)) 
				{ 
					$bname = 'Mozilla Firefox'; 
					$ub = "Firefox"; 
				} 
				elseif(preg_match('/Chrome/i',$u_agent)) 
				{ 
					$bname = 'Google Chrome'; 
					$ub = "Chrome"; 
				} 
				elseif(preg_match('/Safari/i',$u_agent)) 
				{ 
					$bname = 'Apple Safari'; 
					$ub = "Safari"; 
				} 
				elseif(preg_match('/Opera/i',$u_agent)) 
				{ 
					$bname = 'Opera'; 
					$ub = "Opera"; 
				} 
				elseif(preg_match('/Netscape/i',$u_agent)) 
				{ 
					$bname = 'Netscape'; 
					$ub = "Netscape"; 
				} 
				
				// finally get the correct version number
				$known = array('Version', $ub, 'other');
				$pattern = '#(?<browser>' . join('|', $known) .
				')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
				if (!preg_match_all($pattern, $u_agent, $matches)) {
					// we have no matching number just continue
				}
				
				// see how many we have
				$i = count($matches['browser']);
				if ($i != 1) {
					//we will have two since we are not using 'other' argument yet
					//see if version is before or after the name
					if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
						$version= $matches['version'][0];
					}
					else {
						$version= $matches['version'][1];
					}
				}
				else {
					$version= $matches['version'][0];
				}
				
				// check if we have a number
				if ($version==null || $version=="") {$version="?";}
				
				return array(
					'userAgent' => $u_agent,
					'name'      => $bname,
					'version'   => $version,
					'platform'  => $platform,
					'pattern'    => $pattern
				);
			}
    /**
     * performs the login via cookie (for DEFAULT user account, FACEBOOK-accounts are handled differently)
     * @return bool success state
     */
    public function loginWithCookie()
    {
        $cookie = isset($_COOKIE['rememberme']) ? $_COOKIE['rememberme'] : '';

        // do we have a cookie var ?
        if (!$cookie) {
            $_SESSION["feedback_negative"][] = FEEDBACK_COOKIE_INVALID;
            return false;
        }

        // check cookie's contents, check if cookie contents belong together
        list ($user_id, $token, $hash) = explode(':', $cookie);
        if ($hash !== hash('sha256', $user_id . ':' . $token)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_COOKIE_INVALID;
            return false;
        }

        // do not log in when token is empty
        if (empty($token)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_COOKIE_INVALID;
            return false;
        }

        // get real token from database (and all other data)
        $query = $this->db->prepare("SELECT user_id, user_name, user_email, user_password_hash, user_active,
                                          user_account_type,  user_has_avatar, user_failed_logins, user_last_failed_login
                                     FROM users
                                     WHERE user_id = :user_id
                                       AND user_rememberme_token = :user_rememberme_token
                                       AND user_rememberme_token IS NOT NULL
                                       AND user_provider_type = :provider_type");
        $query->execute(array(':user_id' => $user_id, ':user_rememberme_token' => $token, ':provider_type' => 'DEFAULT'));
        $count =  $query->rowCount();
        if ($count == 1) {
            // fetch one row (we only have one result)
            $result = $query->fetch();
            // TODO: this block is same/similar to the one from login(), maybe we should put this in a method
            // write data into session
            Session::init();
            Session::set('ubihrm_user_logged_in', true);
            Session::set('user_id', $result->user_id);
            Session::set('user_name', $result->user_name);
            Session::set('user_email', $result->user_email);
            Session::set('user_account_type', $result->user_account_type);
            Session::set('user_provider_type', 'DEFAULT');
            Session::set('user_avatar_file', $this->getUserAvatarFilePath());
            // call the setGravatarImageUrl() method which writes gravatar urls into the session
            $this->setGravatarImageUrl($result->user_email, AVATAR_SIZE);

            // generate integer-timestamp for saving of last-login date
            $user_last_login_timestamp = time();
            // write timestamp of this login into database (we only write "real" logins via login form into the
            // database, not the session-login on every page request
            $sql = "UPDATE users SET user_last_login_timestamp = :user_last_login_timestamp WHERE user_id = :user_id";
            $sth = $this->db->prepare($sql);
            $sth->execute(array(':user_id' => $user_id, ':user_last_login_timestamp' => $user_last_login_timestamp));

            // NOTE: we don't set another rememberme-cookie here as the current cookie should always
            // be invalid after a certain amount of time, so the user has to login with username/password
            // again from time to time. This is good and safe ! ;)
            $_SESSION["feedback_positive"][] = FEEDBACK_COOKIE_LOGIN_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_COOKIE_INVALID;
            return false;
        }
    }

	
	
    /**
     * Tries to log the user in via Facebook-authentication
     * @return bool
     */
    public function loginWithFacebook()
    {
        // instantiate the facebook object
        $facebook = new Facebook(array('appId' => FACEBOOK_LOGIN_APP_ID, 'secret' => FACEBOOK_LOGIN_APP_SECRET));

        // get "user", if the user object (array?) exists, the user has identified as a real facebook user
        $user = $facebook->getUser();
        if ($user) {
            try {
                // proceed knowing you have a logged in user who's authenticated.
                $facebook_user_data = $facebook->api('/me');

                // check database for data from exactly that user (identified via Facebook ID)
                $query = $this->db->prepare("SELECT user_id,
                                              user_name,
                                              user_email,
                                              user_account_type,
                                              user_provider_type
                                           FROM users
                                           WHERE user_facebook_uid = :user_facebook_uid
                                             AND user_provider_type = :provider_type");
                $query->execute(array(':user_facebook_uid' => $facebook_user_data["id"], ':provider_type' => 'FACEBOOK'));
                $count =  $query->rowCount();
                if ($count != 1) {
                    $_SESSION["feedback_negative"][] = FEEDBACK_FACEBOOK_LOGIN_NOT_REGISTERED;
                    return false;
                }

                $result = $query->fetch();
                // put user data into session
                Session::init();
                Session::set('ubihrm_user_logged_in', true);
                Session::set('user_id', $result->user_id);
                Session::set('user_name', $result->user_name);
                Session::set('user_email', $result->user_email);
                Session::set('user_account_type', $result->user_account_type);
                Session::set('user_provider_type', 'FACEBOOK');
                Session::set('user_avatar_file', $this->getUserAvatarFilePath());

                // generate integer-timestamp for saving of last-login date
                $user_last_login_timestamp = time();
                // write timestamp of this login into database (we only write "real" logins via login form into the
                // database, not the session-login on every page request
                $sql = "UPDATE users SET user_last_login_timestamp = :user_last_login_timestamp WHERE user_id = :user_id";
                $sth = $this->db->prepare($sql);
                $sth->execute(array(':user_id' => $result->user_id, ':user_last_login_timestamp' => $user_last_login_timestamp));

                return true;

            } catch (FacebookApiException $e) {
                // when facebook goes offline
                error_log($e);
                $user = null;
            }
        }
        // default return
        return false;
    }

    /**
     * Log out process, deletes cookie, deletes session
     */
    public function logout()
    {
		
        // set the remember-me-cookie to ten years ago (3600sec * 365 days * 10).
        // that's obviously the best practice to kill a cookie via php
        // @see http://stackoverflow.com/a/686166/1114320
        setcookie('rememberme', false, time() - (3600 * 3650), '/', COOKIE_DOMAIN);
		
		
		if(isset($_SESSION['ubihrm_login_historyid'])){
		$query = $this->db->prepare("UPDATE LoginHistory SET LogoutTime=CURRENT_TIMESTAMP WHERE Id= ?");
		$query->execute(array($_SESSION['ubihrm_login_historyid']));
        // delete the session
        Session::destroy();
		}
	
    }

    /**
     * Deletes the (invalid) remember-cookie to prevent infinitive login loops
     */
    public function deleteCookie()
    {
        // set the rememberme-cookie to ten years ago (3600sec * 365 days * 10).
        // that's obviously the best practice to kill a cookie via php
        // @see http://stackoverflow.com/a/686166/1114320
        setcookie('rememberme', false, time() - (3600 * 3650), '/', COOKIE_DOMAIN);
    }

    /**
     * Returns the current state of the user's login
     * @return bool user's login status
     */
    public function isUserLoggedIn()
    {
        return Session::get('ubihrm_user_logged_in');
    }

    /**
     * Edit the user's name, provided in the editing form
     * @return bool success status
     */
    public function editUserName()
    {
        // new username provided ?
        if (!isset($_POST['user_name']) OR empty($_POST['user_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USERNAME_FIELD_EMPTY;
            return false;
        }

        // new username same as old one ?
        if ($_POST['user_name'] == $_SESSION["user_name"]) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USERNAME_SAME_AS_OLD_ONE;
            return false;
        }

        // username cannot be empty and must be azAZ09 and 2-64 characters
        if (!preg_match("/^(?=.{2,64}$)[a-zA-Z][a-zA-Z0-9]*(?: [a-zA-Z0-9]+)*$/", $_POST['user_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USERNAME_DOES_NOT_FIT_PATTERN;
            return false;
        }

        // clean the input
        $user_name = substr(strip_tags($_POST['user_name']), 0, 64);

        // check if new username already exists
        $query = $this->db->prepare("SELECT user_id FROM users WHERE user_name = :user_name");
        $query->execute(array(':user_name' => $user_name));
        $count =  $query->rowCount();
        if ($count == 1) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USERNAME_ALREADY_TAKEN;
            return false;
        }

        $query = $this->db->prepare("UPDATE users SET user_name = :user_name WHERE user_id = :user_id");
        $query->execute(array(':user_name' => $user_name, ':user_id' => $_SESSION['user_id']));
        $count =  $query->rowCount();
        if ($count == 1) {
            Session::set('user_name', $user_name);
            $_SESSION["feedback_positive"][] = FEEDBACK_USERNAME_CHANGE_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_UNKNOWN_ERROR;
            return false;
        }
    }

    /**
     * Edit the user's email, provided in the editing form
     * @return bool success status
     */
    public function editUserEmail()
    {
        // email provided ?
        if (!isset($_POST['user_email']) OR empty($_POST['user_email'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_FIELD_EMPTY;
            return false;
        }

        // check if new email is same like the old one
        if ($_POST['user_email'] == $_SESSION["user_email"]) {
            $_SESSION["feedback_negative"][] = FEEDBACK_EMAIL_SAME_AS_OLD_ONE;
            return false;
        }

        // user's email must be in valid email format
        if (!filter_var($_POST['user_email'], FILTER_VALIDATE_EMAIL)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_EMAIL_DOES_NOT_FIT_PATTERN;
            return false;
        }

        // check if user's email already exists
        $query = $this->db->prepare("SELECT * FROM users WHERE user_email = :user_email");
        $query->execute(array(':user_email' => $_POST['user_email']));
        $count =  $query->rowCount();
        if ($count == 1) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USER_EMAIL_ALREADY_TAKEN;
            return false;
        }

        // cleaning and write new email to database
        $user_email = substr(strip_tags($_POST['user_email']), 0, 64);
        $query = $this->db->prepare("UPDATE users SET user_email = :user_email WHERE user_id = :user_id");
        $query->execute(array(':user_email' => $user_email, ':user_id' => $_SESSION['user_id']));
        $count =  $query->rowCount();
        if ($count != 1) {
            $_SESSION["feedback_negative"][] = FEEDBACK_UNKNOWN_ERROR;
            return false;
        }

        Session::set('user_email', $user_email);
        // call the setGravatarImageUrl() method which writes gravatar URLs into the session
        $this->setGravatarImageUrl($user_email, AVATAR_SIZE);
        $_SESSION["feedback_positive"][] = FEEDBACK_EMAIL_CHANGE_SUCCESSFUL;
        return false;
    }

    /**
     * handles the entire registration process for DEFAULT users (not for people who register with
     * 3rd party services, like facebook) and creates a new user in the database if everything is fine
     * @return boolean Gives back the success status of the registration
     */
    public function registerNewUser()
    {
        // perform all necessary form checks
        if (empty($_POST['user_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USERNAME_FIELD_EMPTY;
        } elseif (empty($_POST['user_password_new']) OR empty($_POST['user_password_repeat'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_FIELD_EMPTY;
        } elseif ($_POST['user_password_new'] !== $_POST['user_password_repeat']) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_REPEAT_WRONG;
        } elseif (strlen($_POST['user_password_new']) < 6) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_TOO_SHORT;
        } elseif (strlen($_POST['user_name']) > 64 OR strlen($_POST['user_name']) < 2) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USERNAME_TOO_SHORT_OR_TOO_LONG;
        } elseif (!preg_match('/^[a-z\d]{2,64}$/i', $_POST['user_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USERNAME_DOES_NOT_FIT_PATTERN;
        } elseif (empty($_POST['user_email'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_EMAIL_FIELD_EMPTY;
        } elseif (strlen($_POST['user_email']) > 64) {
            $_SESSION["feedback_negative"][] = FEEDBACK_EMAIL_TOO_LONG;
        } elseif (!filter_var($_POST['user_email'], FILTER_VALIDATE_EMAIL)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_EMAIL_DOES_NOT_FIT_PATTERN;
        } elseif (!empty($_POST['user_name'])
            AND strlen($_POST['user_name']) <= 64
            AND strlen($_POST['user_name']) >= 2
            AND preg_match('/^[a-z\d]{2,64}$/i', $_POST['user_name'])
            AND !empty($_POST['user_email'])
            AND strlen($_POST['user_email']) <= 64
            AND filter_var($_POST['user_email'], FILTER_VALIDATE_EMAIL)
            AND !empty($_POST['user_password_new'])
            AND !empty($_POST['user_password_repeat'])
            AND ($_POST['user_password_new'] === $_POST['user_password_repeat'])) {

            // clean the input
            $user_name = strip_tags($_POST['user_name']);
            $user_email = strip_tags($_POST['user_email']);

            $user_password_hash = $_POST['user_password_new'];//password_hash($_POST['user_password_new'], PASSWORD_DEFAULT, array('cost' => $hash_cost_factor));

            // check if username already exists
            $query = $this->db->prepare("SELECT Id FROM EmployeeMaster WHERE CurrentEmailId = ?");
            $query->execute(array( $user_email));
            $count =  $query->rowCount();
            if ($count == 1) {
                $_SESSION["feedback_negative"][] = FEEDBACK_USER_EMAIL_ALREADY_TAKEN;
                return false;
            }
			 
			$mdate = date("Y-m-d H:i:s");

            // write new users data into database
            $sql = "INSERT INTO Organization (Name, Email, Country, City, Currency, DateFormat, TimeFormat, CreatedDate, LastModifiedDate) VALUES (?,?,?,?,?,?,?,?,?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($user_name, $user_email, 216, 2242, 227, 2, 7, $mdate, $mdate));			
			$orgid = $this->db->lastInsertId();
			
			$sql = "INSERT INTO DesignationMaster (Name, Code, OrganizationId, CreatedDate, LastModifiedDate) VALUES (?,?,?,?,?)";
			$query = $this->db->prepare($sql);
			$query->execute(array("ADMIN", "ADMIN", $orgid, $mdate, $mdate));			
			$desigid = $this->db->lastInsertId();
			
			$rsql1 = "SELECT * FROM ModuleMaster where TabId>0";
				$rquery1 = $this->db->prepare($rsql1);
				$rquery1->execute();
				$count =  $rquery1->rowCount();
				if($count>=1)
				{
					while($row = $rquery1->fetch())
					{
						$sql2 = "INSERT INTO UserPermission (RoleId, ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission, OrganizationId,  LastModifiedDate, CreatedDate) VALUES (?,?,?,?,?,?,?,?,?)";
			
						try{
								
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array($desigid, $row->Id, 1, 1, 1, 1, $orgid, $mdate, $mdate));
			
							$count =  $query2->rowCount();		
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					}
				}
			
			$sqlmax = "select coalesce(Max(Id)+1,1) as maxid from EmployeeSequence";
			$querymax = $this->db->prepare($sqlmax);
			$querymax->execute();
			$maxrow = $querymax->fetch();
			$empid = $maxrow->maxid;
			
			$empcode = strtoupper(dechex(strtotime("now")));
			$sql = "INSERT INTO EmployeeMaster (Id, EmployeeCode, Designation, FirstName, CurrentEmailId, OrganizationId, CreatedDate, LastModifiedDate) VALUES (?,?,?,?,?,?,?,?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($empid, $empcode, $desigid, $user_name, $user_email, $orgid, $mdate, $mdate));
			
			
			$sql = "INSERT INTO UserMaster (EmployeeId, Password, Username, RoleId, OrganizationId, CreatedDate, LastModifiedDate) VALUES (?,?,?,?,?,?,?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($empid, $user_password_hash, $user_email, $desigid, $orgid, $mdate, $mdate));
			
            $count =  $query->rowCount();
            if ($count != 1) {
                $_SESSION["feedback_negative"][] = FEEDBACK_ACCOUNT_CREATION_FAILED;
                return false;
            }

            // get user_id of the user that has been created, to keep things clean we DON'T use lastInsertId() here
            $query = $this->db->prepare("SELECT user_id FROM users WHERE user_name = :user_name");
            $query->execute(array(':user_name' => $user_name));
            if ($query->rowCount() != 1) {
                $_SESSION["feedback_negative"][] = FEEDBACK_UNKNOWN_ERROR;
                return false;
            }
            $result_user_row = $query->fetch();
            $user_id = $result_user_row->user_id;

            // send verification email, if verification email sending failed: instantly delete the user
            /*if ($this->sendVerificationEmail($user_id, $user_email, $user_activation_hash)) {
                $_SESSION["feedback_positive"][] = FEEDBACK_ACCOUNT_SUCCESSFULLY_CREATED;
                return true;
            } else {
                $query = $this->db->prepare("DELETE FROM users WHERE user_id = :last_inserted_id");
                $query->execute(array(':last_inserted_id' => $user_id));
                $_SESSION["feedback_negative"][] = FEEDBACK_VERIFICATION_MAIL_SENDING_FAILED;
                return false;
            }*/
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_UNKNOWN_ERROR;
        }
        // default return, returns only true of really successful (see above)
        return false;
    }

    /**
     * sends an email to the provided email address
     * @param int $user_id user's id
     * @param string $user_email user's email
     * @param string $user_activation_hash user's mail verification hash string
     * @return boolean gives back true if mail has been sent, gives back false if no mail could been sent
     */
    private function sendVerificationEmail($user_id, $user_email, $user_activation_hash)
    {
        // create PHPMailer object (this is easily possible as we auto-load the according class(es) via composer)
        $mail = new PHPMailer;

        // please look into the config/config.php for much more info on how to use this!
        if (EMAIL_USE_SMTP) {
            // set PHPMailer to use SMTP
            $mail->IsSMTP();
            // useful for debugging, shows full SMTP errors, config this in config/config.php
            $mail->SMTPDebug = PHPMAILER_DEBUG_MODE;
            // enable SMTP authentication
            $mail->SMTPAuth = EMAIL_SMTP_AUTH;
            // enable encryption, usually SSL/TLS
            if (defined('EMAIL_SMTP_ENCRYPTION')) {
                $mail->SMTPSecure = EMAIL_SMTP_ENCRYPTION;
            }
            // set SMTP provider's credentials
            $mail->Host = EMAIL_SMTP_HOST;
            $mail->Username = EMAIL_SMTP_USERNAME;
            $mail->Password = EMAIL_SMTP_PASSWORD;
            $mail->Port = EMAIL_SMTP_PORT;
        } else {
            $mail->IsMail();
        }

        // fill mail with data
        $mail->From = EMAIL_VERIFICATION_FROM_EMAIL;
        $mail->FromName = EMAIL_VERIFICATION_FROM_NAME;
        $mail->AddAddress($user_email);
        $mail->Subject = EMAIL_VERIFICATION_SUBJECT;
        $mail->Body = EMAIL_VERIFICATION_CONTENT . EMAIL_VERIFICATION_URL . '/' . urlencode($user_id) . '/' . urlencode($user_activation_hash);

        // final sending and check
        if($mail->Send()) {
            $_SESSION["feedback_positive"][] = FEEDBACK_VERIFICATION_MAIL_SENDING_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_VERIFICATION_MAIL_SENDING_ERROR . $mail->ErrorInfo;
            return false;
        }
    }

    /**
     * checks the email/verification code combination and set the user's activation status to true in the database
     * @param int $user_id user id
     * @param string $user_activation_verification_code verification token
     * @return bool success status
     */
    public function verifyNewUser($user_id, $user_activation_verification_code)
    {
        $sth = $this->db->prepare("UPDATE users
                                   SET user_active = 1, user_activation_hash = NULL
                                   WHERE user_id = :user_id AND user_activation_hash = :user_activation_hash");
        $sth->execute(array(':user_id' => $user_id, ':user_activation_hash' => $user_activation_verification_code));

        if ($sth->rowCount() == 1) {
            $_SESSION["feedback_positive"][] = FEEDBACK_ACCOUNT_ACTIVATION_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_ACCOUNT_ACTIVATION_FAILED;
            return false;
        }
    }

    /**
     * Get either a Gravatar URL or complete image tag for a specified email address.
     * Gravatar is the #1 (free) provider for email address based global avatar hosting.
     * The image url (on gravatar servers), will return in something like (note that there's no .jpg)
     * http://www.gravatar.com/avatar/205e460b479e2e5b48aec07710c08d50?s=80&d=mm&r=g
     *
     * For deeper info on the different parameter possibilities:
     * @see http://gravatar.com/site/implement/images/
     * @source http://gravatar.com/site/implement/images/php/
     *
     * @param string $email The email address
     * @param int $s Size in pixels [ 1 - 2048 ]
     * @param string $d Default imageset to use [ 404 | mm | identicon | monsterid | wavatar ]
     * @param string $r Maximum rating (inclusive) [ g | pg | r | x ]
     * @param array $attributes Optional, additional key/value attributes to include in the IMG tag
     */
    public function setGravatarImageUrl($email, $s = 44, $d = 'mm', $r = 'pg', $attributes = array())
    {
        // create image URL, write it into session
        $image_url = 'http://www.gravatar.com/avatar/' . md5(strtolower(trim($email))) .  "?s=$s&d=$d&r=$r";
        Session::set('user_gravatar_image_url', $image_url);

        // build <img /> tag around the URL
        $image_url_with_tag = '<img src="' . $image_url . '"';
        foreach ($attributes as $key => $val) {
            $image_url_with_tag .= ' ' . $key . '="' . $val . '"';
        }
        $image_url_with_tag .= ' />';

        // the image url like above but with an additional <img src .. /> around, write to session
        Session::set('user_gravatar_image_tag', $image_url_with_tag);
    }

    /**
     * Gets the user's avatar file path
     * @return string avatar picture path
     */
    public function getUserAvatarFilePath()
    {
        $query = $this->db->prepare("SELECT user_has_avatar FROM users WHERE user_id = :user_id");
        $query->execute(array(':user_id' => $_SESSION['user_id']));

        if ($query->fetch()->user_has_avatar) {
            return URL . AVATAR_PATH . $_SESSION['user_id'] . '.jpg';
        } else {
            return URL . AVATAR_PATH . AVATAR_DEFAULT_IMAGE;
        }
    }

    /**
     * Create an avatar picture (and checks all necessary things too)
     * @return bool success status
     */
    public function createAvatar()
    {
        if (!is_dir(AVATAR_PATH) OR !is_writable(AVATAR_PATH)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_AVATAR_FOLDER_DOES_NOT_EXIST_OR_NOT_WRITABLE;
            return false;
        }

        if (!isset($_FILES['avatar_file']) OR empty ($_FILES['avatar_file']['tmp_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_AVATAR_IMAGE_UPLOAD_FAILED;
            return false;
        }

        // get the image width, height and mime type
        $image_proportions = getimagesize($_FILES['avatar_file']['tmp_name']);

        // if input file too big (>5MB)
        if ($_FILES['avatar_file']['size'] > 5000000 ) {
            $_SESSION["feedback_negative"][] = FEEDBACK_AVATAR_UPLOAD_TOO_BIG;
            return false;
        }
        // if input file too small
        if ($image_proportions[0] < AVATAR_SIZE OR $image_proportions[1] < AVATAR_SIZE) {
            $_SESSION["feedback_negative"][] = FEEDBACK_AVATAR_UPLOAD_TOO_SMALL;
            return false;
        }

        if ($image_proportions['mime'] == 'image/jpeg' || $image_proportions['mime'] == 'image/png') {
            // create a jpg file in the avatar folder
            $target_file_path = AVATAR_PATH . $_SESSION['user_id'] . ".jpg";
            $this->resizeAvatarImage($_FILES['avatar_file']['tmp_name'], $target_file_path, AVATAR_SIZE, AVATAR_SIZE, AVATAR_JPEG_QUALITY, true);
            $query = $this->db->prepare("UPDATE users SET user_has_avatar = TRUE WHERE user_id = :user_id");
            $query->execute(array(':user_id' => $_SESSION['user_id']));
            Session::set('user_avatar_file', $this->getUserAvatarFilePath());
            $_SESSION["feedback_positive"][] = FEEDBACK_AVATAR_UPLOAD_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_AVATAR_UPLOAD_WRONG_TYPE;
            return false;
        }
    }

    /**
     * Resize avatar image (while keeping aspect ratio and cropping it off sexy)
     * Originally written by:
     * @author Jay Zawrotny <jayzawrotny@gmail.com>
     * @license Do whatever you want with it.
     *
     * @param string $source_image The location to the original raw image.
     * @param string $destination_filename The location to save the new image.
     * @param int $width The desired width of the new image
     * @param int $height The desired height of the new image.
     * @param int $quality The quality of the JPG to produce 1 - 100
     * @param bool $crop Whether to crop the image or not. It always crops from the center.
     * @return bool success state
     */
    public function resizeAvatarImage(
        $source_image, $destination_filename, $width = 44, $height = 44, $quality = 85, $crop = true)
    {
        $image_data = getimagesize($source_image);
        if (!$image_data) {
            return false;
        }

        // set to-be-used function according to filetype
        switch ($image_data['mime']) {
            case 'image/gif':
                $get_func = 'imagecreatefromgif';
                $suffix = ".gif";
            break;
            case 'image/jpeg';
                $get_func = 'imagecreatefromjpeg';
                $suffix = ".jpg";
            break;
            case 'image/png':
                $get_func = 'imagecreatefrompng';
                $suffix = ".png";
            break;
        }

        $img_original = call_user_func($get_func, $source_image );
        $old_width = $image_data[0];
        $old_height = $image_data[1];
        $new_width = $width;
        $new_height = $height;
        $src_x = 0;
        $src_y = 0;
        $current_ratio = round($old_width / $old_height, 2);
        $desired_ratio_after = round($width / $height, 2);
        $desired_ratio_before = round($height / $width, 2);

        if ($old_width < $width OR $old_height < $height) {
             // the desired image size is bigger than the original image. Best not to do anything at all really.
            return false;
        }

        // if crop is on: it will take an image and best fit it so it will always come out the exact specified size.
        if ($crop) {
            // create empty image of the specified size
            $new_image = imagecreatetruecolor($width, $height);

            // landscape image
            if ($current_ratio > $desired_ratio_after) {
                $new_width = $old_width * $height / $old_height;
            }

            // nearly square ratio image
            if ($current_ratio > $desired_ratio_before AND $current_ratio < $desired_ratio_after) {

                if ($old_width > $old_height) {
                    $new_height = max($width, $height);
                    $new_width = $old_width * $new_height / $old_height;
                } else {
                    $new_height = $old_height * $width / $old_width;
                }
            }

            // portrait sized image
            if ($current_ratio < $desired_ratio_before) {
                $new_height = $old_height * $width / $old_width;
            }

            // find ratio of original image to find where to crop
            $width_ratio = $old_width / $new_width;
            $height_ratio = $old_height / $new_height;

            // calculate where to crop based on the center of the image
            $src_x = floor((($new_width - $width) / 2) * $width_ratio);
            $src_y = round((($new_height - $height) / 2) * $height_ratio);
        }
        // don't crop the image, just resize it proportionally
        else {
            if ($old_width > $old_height) {
                $ratio = max($old_width, $old_height) / max($width, $height);
            } else {
                $ratio = max($old_width, $old_height) / min($width, $height);
            }

            $new_width = $old_width / $ratio;
            $new_height = $old_height / $ratio;
            $new_image = imagecreatetruecolor($new_width, $new_height);
        }

        // create avatar thumbnail
        imagecopyresampled($new_image, $img_original, 0, 0, $src_x, $src_y, $new_width, $new_height, $old_width, $old_height);

        // save it as a .jpg file with our $destination_filename parameter
        imagejpeg($new_image, $destination_filename, $quality);

        // delete "working copy" and original file, keep the thumbnail
        imagedestroy($new_image);
        imagedestroy($img_original);

        if (file_exists($destination_filename)) {
            return true;
        }
        // default return
        return false;
    }

    /**
     * Perform the necessary actions to send a password reset mail
     * @return bool success status
     */
    public function requestPasswordReset()
    {
		$result1 = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        if (!isset($_POST['email']) OR empty($_POST['email'])) {
            $errorMsg = FEEDBACK_USERNAME_FIELD_EMPTY;
			$status=false;
        }else{
			// generate integer-timestamp (to see when exactly the user (or an attacker) requested the password reset mail)
			$temporary_timestamp = time();
			// generate random hash for email password reset verification (40 char string)
			$user_password_reset_hash = Utils::encode5t(substr(str_shuffle(str_repeat($x=sha1(uniqid(mt_rand(), true)), ceil(7/strlen($x)) )),1,7));
			// clean user input
			$user_name = strip_tags($_POST['email']);

			// check if that username exists
			$query = $this->db->prepare("SELECT Id, 
                                          EmployeeId,
                                          Password,UserName
                                   FROM   UserMaster
                                   WHERE  UserName = :user_name");
			$query->execute(array(':user_name' => Utils::encode5t(strtolower($user_name))));
			$count = $query->rowCount();
			if ($count != 1) {
				$errorMsg = FEEDBACK_USER_DOES_NOT_EXIST;
				$status=false;
			}else{

				// get result
				$result_user_row = $result = $query->fetch();
				$user_email = Utils::decode5t($result_user_row->UserName);

				// set token (= a random hash string and a timestamp) into database
				/* if ($this->setPasswordResetDatabaseToken($user_name, $user_password_reset_hash, $temporary_timestamp) == true) 		{
				 */	
					// send a mail to the user, containing a link with username and token hash string
					if ($this->sendPasswordResetMail($user_name, $user_password_reset_hash, $user_email)) {
						$successMsg = "Please check your mail to reset your password";
						$status=true;
					}
				/* } */
			}
		}
		
        $result1["data"] =$data;
		$result1['status']=$status;
		$result1['successMsg']=$successMsg;
		$result1['errorMsg']=$errorMsg;
		
		return $result1;
    }

    /**
     * Set password reset token in database (for DEFAULT user accounts)
     * @param string $user_name username
     * @param string $user_password_reset_hash password reset hash
     * @param int $temporary_timestamp timestamp
     * @return bool success status
     */
    public function setPasswordResetDatabaseToken($user_name, $user_password_reset_hash)
    {
        $query_two = $this->db->prepare("UPDATE UserMaster
                                            SET Password = :user_password_reset_hash
                                          WHERE UserName = :user_name" );
        $query_two->execute(array(':user_password_reset_hash' => $user_password_reset_hash ,                                  ':user_name' => Utils::encode5t(strtolower($user_name))));

        // check if exactly one row was successfully changed
        $count =  $query_two->rowCount();
        if ($count == 1) {
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_RESET_TOKEN_FAIL;
            return false;
        }
    }

    /**
     * send the password reset mail
     * @param string $user_name username
     * @param string $user_password_reset_hash password reset hash
     * @param string $user_email user email
     * @return bool success status
     */
    public function sendPasswordResetMail($user_name, $user_password_reset_hash, $user_email)
    {
        // create PHPMailer object here. This is easily possible as we auto-load the according class(es) via composer
        $mail = new PHPMailer;

        // please look into the config/config.php for much more info on how to use this!
        if (EMAIL_USE_SMTP) {
            // Set mailer to use SMTP
            $mail->IsSMTP();
            //useful for debugging, shows full SMTP errors, config this in config/config.php
            $mail->SMTPDebug = PHPMAILER_DEBUG_MODE;
            // Enable SMTP authentication
            $mail->SMTPAuth = EMAIL_SMTP_AUTH;
            // Enable encryption, usually SSL/TLS
            if (defined('EMAIL_SMTP_ENCRYPTION')) {
                $mail->SMTPSecure = EMAIL_SMTP_ENCRYPTION;
            }
            // Specify host server
            $mail->Host = EMAIL_SMTP_HOST;
            $mail->Username = EMAIL_SMTP_USERNAME;
            $mail->Password = EMAIL_SMTP_PASSWORD;
            $mail->Port = EMAIL_SMTP_PORT;
        } else {
            $mail->IsMail();
        }

        // build the email
        $mail->From = "noreply@ubihrm.com";
		$mail->FromName = "UBIHRM";
        $mail->AddAddress($user_email);
        $mail->Subject = "Password reset link for UBIHRM";
        $link = EMAIL_PASSWORD_RESET_URL . '/' . urlencode(Utils::encode5t($user_name)) . '/' . urlencode($user_password_reset_hash);
        $mail->Body = EMAIL_PASSWORD_RESET_CONTENT . '  ' . $link;

        // send the mail
        if($mail->Send()) {
            //$_SESSION["feedback_positive"][] = FEEDBACK_PASSWORD_RESET_MAIL_SENDING_SUCCESSFUL;
            return true;
        } else {
            //$_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_RESET_MAIL_SENDING_ERROR ;
            return false;
        }
    }

    /**
     * Verifies the password reset request via the verification hash token (that's only valid for one hour)
     * @param string $user_name Username
     * @param string $verification_code Hash token
     * @return bool Success status
     */
    public function verifyPasswordReset($user_name, $verification_code)
    {
        // check if user-provided username + verification code combination exists
        $query = $this->db->prepare("SELECT user_id, user_password_reset_timestamp
                                       FROM users
                                      WHERE user_name = :user_name
                                        AND user_password_reset_hash = :user_password_reset_hash
                                        AND user_provider_type = :user_provider_type");
        $query->execute(array(':user_password_reset_hash' => $verification_code,
                              ':user_name' => $user_name,
                              ':user_provider_type' => 'DEFAULT'));

        // if this user with exactly this verification hash code exists
        if ($query->rowCount() != 1) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_RESET_COMBINATION_DOES_NOT_EXIST;
            return false;
        }

        // get result row (as an object)
        $result_user_row = $query->fetch();
        // 3600 seconds are 1 hour
        $timestamp_one_hour_ago = time() - 3600;
        // if password reset request was sent within the last hour (this timeout is for security reasons)
        if ($result_user_row->user_password_reset_timestamp > $timestamp_one_hour_ago) {
            // verification was successful
            $_SESSION["feedback_positive"][] = FEEDBACK_PASSWORD_RESET_LINK_VALID;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_RESET_LINK_EXPIRED;
            return false;
        }
    }

    /**
     * Set the new password (for DEFAULT user, FACEBOOK-users don't have a password)
     * Please note: At this point the user has already pre-verified via verifyPasswordReset() (within one hour),
     * so we don't need to check again for the 60min-limit here. In this method we authenticate
     * via username & password-reset-hash from (hidden) form fields.
     * @return bool success state of the password reset
     */
    public function setNewPassword()
    {
        // basic checks
        if (!isset($_POST['user_name']) OR empty($_POST['user_name'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_USERNAME_FIELD_EMPTY;
            return false;
        }
        if (!isset($_POST['user_password_reset_hash']) OR empty($_POST['user_password_reset_hash'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_RESET_TOKEN_MISSING;
            return false;
        }
        if (!isset($_POST['user_password_new']) OR empty($_POST['user_password_new'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_FIELD_EMPTY;
            return false;
        }
        if (!isset($_POST['user_password_repeat']) OR empty($_POST['user_password_repeat'])) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_FIELD_EMPTY;
            return false;
        }
        // password does not match password repeat
        if ($_POST['user_password_new'] !== $_POST['user_password_repeat']) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_REPEAT_WRONG;
            return false;
        }
        // password too short
        if (strlen($_POST['user_password_new']) < 6) {
            $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_TOO_SHORT;
            return false;
        }

        // check if we have a constant HASH_COST_FACTOR defined
        // if so: put the value into $hash_cost_factor, if not, make $hash_cost_factor = null
       
       
        $user_password_hash = Utils::encode5t($_POST['user_password_new']);

        // write users new password hash into database, reset user_password_reset_hash
        $query = $this->db->prepare("UPDATE UserMaster
                                        SET Password = :user_password_hash
                                       WHERE UserName = :user_name
                                        
                                        ");

        $query->execute(array(':user_password_hash' => $user_password_hash,
                              ':user_name' => $_POST['user_name']));

        // check if exactly one row was successfully changed:
        if ($query->rowCount() == 1) {
            // successful password change!
            $_SESSION["feedback_positive"][] = FEEDBACK_PASSWORD_CHANGE_SUCCESSFUL;
            return true;
        }

        // default return
        $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_CHANGE_FAILED;
        return false;
    }

    /**
     * Upgrades/downgrades the user's account (for DEFAULT and FACEBOOK users)
     * Currently it's just the field user_account_type in the database that
     * can be 1 or 2 (maybe "basic" or "premium"). In this basic method we
     * simply increase or decrease this value to emulate an account upgrade/downgrade.
     * Put some more complex stuff in here, maybe a pay-process or whatever you like.
     */
    public function changeAccountType()
    {
        if (isset($_POST["user_account_upgrade"]) AND !empty($_POST["user_account_upgrade"])) {

            // do whatever you want to upgrade the account here (pay-process etc)
            // ...
            // ... myPayProcess();
            // ...

            // upgrade account type
            $query = $this->db->prepare("UPDATE users SET user_account_type = 2 WHERE user_id = :user_id");
            $query->execute(array(':user_id' => $_SESSION["user_id"]));

            if ($query->rowCount() == 1) {
                // set account type in session to 2
                Session::set('user_account_type', 2);
                $_SESSION["feedback_positive"][] = FEEDBACK_ACCOUNT_UPGRADE_SUCCESSFUL;
            } else {
                $_SESSION["feedback_negative"][] = FEEDBACK_ACCOUNT_UPGRADE_FAILED;
            }
        } elseif (isset($_POST["user_account_downgrade"]) AND !empty($_POST["user_account_downgrade"])) {

            // do whatever you want to downgrade the account here (pay-process etc)
            // ...
            // ... myWhateverProcess();
            // ...

            $query = $this->db->prepare("UPDATE users SET user_account_type = 1 WHERE user_id = :user_id");
            $query->execute(array(':user_id' => $_SESSION["user_id"]));

            if ($query->rowCount() == 1) {
                // set account type in session to 1
                Session::set('user_account_type', 1);
                $_SESSION["feedback_positive"][] = FEEDBACK_ACCOUNT_DOWNGRADE_SUCCESSFUL;
            } else {
                $_SESSION["feedback_negative"][] = FEEDBACK_ACCOUNT_DOWNGRADE_FAILED;
            }
        }
    }

    /**
     * Generates the captcha, "returns" a real image,
     * this is why there is header('Content-type: image/jpeg')
     * Note: This is a very special method, as this is echoes out binary data.
     * Eventually this is something to refactor
     */
    public function generateCaptcha()
    {
        // create a captcha with the CaptchaBuilder lib
        $builder = new CaptchaBuilder;
        $builder->build();

        // write the captcha character into session
        $_SESSION['captcha'] = $builder->getPhrase();

        // render an image showing the characters (=the captcha)
        header('Content-type: image/jpeg');
        $builder->output();
    }

    /**
     * Checks if the entered captcha is the same like the one from the rendered image which has been saved in session
     * @return bool success of captcha check
     */
    private function checkCaptcha()
    {
        if (isset($_POST["captcha"]) AND ($_POST["captcha"] == $_SESSION['captcha'])) {
            return true;
        }
        // default return
        return false;
    }

    /**
     * Gets the URL where the "Login with Facebook"-button redirects the user to
     * @return string The URL
     */
    public function getFacebookLoginUrl()
    {
        // Create Facebook object (official Facebook SDK, loaded via Composer: facebook/php-sdk), this is the official
        // way to login via Facebook with PHP. Constants come from config/config.php.
        $facebook = new Facebook(array('appId'  => FACEBOOK_LOGIN_APP_ID, 'secret' => FACEBOOK_LOGIN_APP_SECRET));

        // get the "login"-URL: This is the URL the user will be redirected to after being sent to the Facebook Auth
        // server by clicking the "login via facebook"-button. Don't touch this until you know exactly what you do.
        $facebook_login_url = $facebook->getLoginUrl(array('redirect_uri' => URL . FACEBOOK_LOGIN_PATH));

        return $facebook_login_url;
    }

    /**
     * Gets the URL where the "Register with Facebook"-button redirects the user to
     * @return string The URL
     */
    public function getFacebookRegisterUrl()
    {
        // create our Application instance (necessary to request Facebook data)
        $facebook = new Facebook(array('appId'  => FACEBOOK_LOGIN_APP_ID, 'secret' => FACEBOOK_LOGIN_APP_SECRET));

        // build the URL where the user will be redirected to after being authenticated on the Facebook server
        // Note: Facebook needs to know that URL, that's why we pass this
        $redirect_url_after_facebook_auth = URL . FACEBOOK_REGISTER_PATH;

        // hard to explain, read the Facebook PHP SDK for more information!
        // basically, when the user clicks the Facebook register button, the following arguments will be passed
        // to Facebook: In this case a request for getting the email (not shown by default btw) and the URL
        // when facebook will send the user after he/she has authenticated
        // "scope" => 'email' means that we need read-access to the user's "public" data plus his/her email address
        // (not public by default)
        $facebook_register_url = $facebook->getLoginUrl(array(
            'scope' => 'email',
            'redirect_uri' => $redirect_url_after_facebook_auth
        ));

        return $facebook_register_url;
    }

    /**
     * This is the main method to handle the full facebook registration process
     * @return bool The entire facebook registration's success status
     */
    public function registerWithFacebook()
    {
        // instantiate the facebook object
        $facebook = new Facebook(array('appId'  => FACEBOOK_LOGIN_APP_ID, 'secret' => FACEBOOK_LOGIN_APP_SECRET));

        // get user id (string)
        $user = $facebook->getUser();

        // if the user object (array?) exists, the user has identified as a real facebook user
        if ($user) {
            try {
                // Proceed knowing you have a logged in user who's authenticated
                $facebook_user_data = $facebook->api('/me');
            } catch (FacebookApiException $e) {
                // when facebook goes offline or armageddon comes or some shit like that
                error_log($e);
                $user = null;
                $_SESSION["feedback_negative"][] = FEEDBACK_FACEBOOK_OFFLINE;
                return false;
            }
        }

        // if we don't have the facebook-user array variable, leave the method
        if (!$facebook_user_data) {
            $_SESSION["feedback_negative"][] = FEEDBACK_FACEBOOK_UID_ALREADY_EXISTS;
            return false;
        }

        // check if user provides mail address (registration will only work when user agrees to provide email address)
        if (!$this->facebookUserHasEmail($facebook_user_data)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_FACEBOOK_EMAIL_NEEDED;
            return false;
        }

        // check if a user with that facebook user id (UID) has already registered
        if ($this->facebookUserIdExistsAlreadyInDatabase($facebook_user_data)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_FACEBOOK_UID_ALREADY_EXISTS;
            return false;
        }

        // check if a user with that username already exists in our database
        // note: Facebook's internal username is usually the person's full name plus a number (and dots between)
        if ($this->facebookUserNameExistsAlreadyInDatabase($facebook_user_data)) {
        	$facebook_user_data["username"] = $this->generateUniqueUserNameFromExistingUserName($facebook_user_data["username"]);
         if ($this->facebookUserNameExistsAlreadyInDatabase($facebook_user_data)) {
        	//shouldn't get here if we managed to generate a unique name!
        	$_SESSION["feedback_negative"][] = FEEDBACK_FACEBOOK_USERNAME_ALREADY_EXISTS;
          return false;
         }
        }


        // check if that email address already exists in our database
        if ($this->facebookUserEmailExistsAlreadyInDatabase($facebook_user_data)) {
            $_SESSION["feedback_negative"][] = FEEDBACK_FACEBOOK_EMAIL_ALREADY_EXISTS;
            return false;
        }

        // all necessary things have been checked, so let's create that user
        if ($this->registerNewUserWithFacebook($facebook_user_data)) {
            $_SESSION["feedback_positive"][] = FEEDBACK_FACEBOOK_REGISTER_SUCCESSFUL;
            return true;
        } else {
            $_SESSION["feedback_negative"][] = FEEDBACK_UNKNOWN_ERROR;
            return false;
        }

        // default return
        return false;
    }

    /**
     * Register user with data from the "facebook object"
     * @param array $facebook_user_data stuff from the facebook class
     * @return bool success state
     */
    public function registerNewUserWithFacebook($facebook_user_data)
    {
        // delete dots from facebook-username (it's the common way to do this like that)
        $clean_user_name_from_facebook = str_replace(".", "", $facebook_user_data["username"]);
        // generate integer-timestamp for saving of account-creating date
        $user_creation_timestamp = time();

        $sql = "INSERT INTO users (user_name, user_email, user_creation_timestamp, user_active, user_provider_type, user_facebook_uid)
                VALUES (:user_name, :user_email, :user_creation_timestamp, :user_active, :user_provider_type, :user_facebook_uid)";
        $query = $this->db->prepare($sql);
        $query->execute(array(':user_name' => $clean_user_name_from_facebook,
                              ':user_email' => $facebook_user_data["email"],
                              ':user_creation_timestamp' => $user_creation_timestamp,
                              ':user_active' => 1,
                              ':user_provider_type' => 'FACEBOOK',
                              ':user_facebook_uid' => $facebook_user_data["id"]));

        $count = $query->rowCount();
        if ($count == 1) {
            $query = $this->db->prepare("SELECT user_id, user_name, user_email, user_account_type, user_provider_type
                                         FROM   users
                                         WHERE  user_name = :user_name AND user_provider_type = :provider_type");
            $query->execute(array(':user_name' => $clean_user_name_from_facebook, ':provider_type' => 'FACEBOOK'));
            $count_from_select_statement = $query->rowCount();
            if ($count_from_select_statement == 1) {
                // registration successful
                return true;
            }
        }
        // default return
        return false;
    }

    /**
     * Checks if the facebook-user data array has an email. It's possible that users block this, so we don't have
     * an email and therefore cannot register this person (registration without email is impossible).
     * @param array $facebook_user_data stuff from the facebook class
     * @return bool user has email yes/no
     */
    public function facebookUserHasEmail($facebook_user_data)
    {
        if (isset($facebook_user_data["email"]) && !empty($facebook_user_data["email"])) {
            return true;
        }
        // default return
        return false;
    }

    /**
     * Check if the facebook-user's UID (unique facebook ID) already exists in our database
     * @param array $facebook_user_data stuff from the facebook class
     * @return bool success state
     */
    public function facebookUserIdExistsAlreadyInDatabase($facebook_user_data)
    {
        $query = $this->db->prepare("SELECT user_id FROM users WHERE user_facebook_uid = :user_facebook_uid");
        $query->execute(array(':user_facebook_uid' => $facebook_user_data["id"]));

        if ($query->rowCount() == 1) {
            return true;
        }
        // default return
        return false;
    }

    /**
     * Checks if the facebook-user's username is already in our database
     * Note: facebook's user-names have dots, so we remove all dots.
     * @param array $facebook_user_data stuff from the facebook class
     * @return bool success state
     */
    public function facebookUserNameExistsAlreadyInDatabase($facebook_user_data)
    {
        // delete dots from facebook's username (it's the common way to do this like that)
        $clean_user_name_from_facebook = str_replace(".", "", $facebook_user_data["username"]);

        $query = $this->db->prepare("SELECT user_id FROM users WHERE user_name = :clean_user_name_from_facebook");
        $query->execute(array(':clean_user_name_from_facebook' => $clean_user_name_from_facebook));

        if ($query->rowCount() == 1) {
            return true;
        }
        // default return
        return false;
    }

    /**
     * Checks if the facebook-user's email address is already in our database
     * @param array $facebook_user_data stuff from the facebook class
     * @return bool success state
     */
    public function facebookUserEmailExistsAlreadyInDatabase($facebook_user_data)
    {
        $query = $this->db->prepare("SELECT user_id FROM users WHERE user_email = :facebook_email");
        $query->execute(array(':facebook_email' => $facebook_user_data["email"]));

        if ($query->rowCount() == 1) {
            return true;
        }
        // default return
        return false;
    }

    /**
     * Generate unique user_name from facebook-user's username appended with a number
     * @param string $existing_name $facebook_user_data stuff from the facebook class
     * @return string unique user_name not in database yet
     */
    public function generateUniqueUserNameFromExistingUserName($existing_name)
    {
    	//strip any dots, trailing numbers and white spaces
        $existing_name = str_replace(".", "", $existing_name);
        $existing_name = preg_replace('/\s*\d+$/', '', $existing_name);

        // loop until we have a new username, adding an increasing number to the given string every time
    	$n = 0;
    	do {
            $n = $n+1;
            $new_username = $existing_name . $n;
            $query = $this->db->prepare("SELECT user_id FROM users WHERE user_name = :name_with_number");
            $query->execute(array(':name_with_number' => $new_username));
    	 	 
    	 } while ($query->rowCount() == 1);

    	return $new_username;
    }
    
    public function getDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		
		if ($request[0]) 
		{
			$res = array();
			$res['username'] = $request[1];
			$res['password'] = $request[2];
				
			$data[] = $res;
			
           		$status =true;
		   	$successMsg = "data fetched successfully!";
        	}
        	else
        	{
        					
           		$status =false;
		   	$errorMsg="failed to fetch data!";
        	}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
    
    public function requestPasswordReset1($request)
    {
        
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
        $user_email = $request;        
        // generate random hash for email password reset verification (40 char string)
        $user_password_reset_hash = sha1(uniqid(mt_rand(), true));
        
            // send a mail to the user, containing a link with username and token hash string
            if ($this->sendPasswordResetEmail('Jaidev', $user_password_reset_hash, $user_email))
            {
            	$status =true;
				$successMsg = "Message sent successfully!";
                //return true;
            }
            else
            {
            	$status =false;
				$errorMsg="Message send failed.";
            }
       
       	   $result["data"] =$data;
	   $result['status']=$status;
	   $result['successMsg']=$successMsg;
	   $result['errorMsg']=$errorMsg;
		
	   return $result;
       
        // default return
        //return false;
    }
    
    
    public function sendPasswordResetEmail($user_name, $user_password_reset_hash, $user_email)
    {
        // create PHPMailer object here. This is easily possible as we auto-load the according class(es) via composer
        $mail = new PHPMailer;

        // please look into the config/config.php for much more info on how to use this!
        if (EMAIL_USE_SMTP) {
            // Set mailer to use SMTP
            $mail->IsSMTP();
            //useful for debugging, shows full SMTP errors, config this in config/config.php
            $mail->SMTPDebug = PHPMAILER_DEBUG_MODE;
            // Enable SMTP authentication
            $mail->SMTPAuth = EMAIL_SMTP_AUTH;
            // Enable encryption, usually SSL/TLS
            if (defined('EMAIL_SMTP_ENCRYPTION')) {
                $mail->SMTPSecure = EMAIL_SMTP_ENCRYPTION;
            }
            // Specify host server
            $mail->Host = EMAIL_SMTP_HOST;
            $mail->Username = EMAIL_SMTP_USERNAME;
            $mail->Password = EMAIL_SMTP_PASSWORD;
            $mail->Port = EMAIL_SMTP_PORT;
        } else {
            $mail->IsMail();
        }

        // build the email
		$mail->From = "noreply@ubihrm.com";
		$mail->FromName = "UBIHRM";
        $mail->AddAddress($user_email);
        $mail->Subject = "Password reset for UBIHRM";
        $link = EMAIL_PASSWORD_RESET_URL . '/' . urlencode($user_name) . '/' . urlencode($user_password_reset_hash);
        $mail->Body = EMAIL_PASSWORD_RESET_CONTENT . ' ' . $link;

	
        // send the mail
        if($mail->Send()) {
            //$_SESSION["feedback_positive"][] = FEEDBACK_PASSWORD_RESET_MAIL_SENDING_SUCCESSFUL;
            return true;
        } else {
           // $_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_RESET_MAIL_SENDING_ERROR . $mail->ErrorInfo;
            return false;
        }
        
    }
    
	
	public function onBoardEmployee()
    {
    
    	$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$user_name	= trim(isset ($_REQUEST['ubihrm_userid']) ? $_REQUEST['ubihrm_userid'] : ''); 
		$user_password	= trim(isset ($_REQUEST['ubihrm_password']) ? $_REQUEST['ubihrm_password'] : ''); 
		$user_orgid	= trim(isset ($_REQUEST['ubihrm_orgid']) ? $_REQUEST['ubihrm_orgid'] : ''); 
		
        // get user's data
        // (we check if the password fits the password_hash via password_verify() some lines below)
        $sth = $this->db->prepare("SELECT Id, EmployeeId, Password, UserName, RoleId, OrganizationId, CreatedDate, CreatedById, LastModifiedDate,LastModifiedById,OwnerId FROM   UserMaster
                                   WHERE  UserName = ? AND Password = ? and OrganizationId=?");
        
        try{
			$sth->execute(array( $user_name, Utils::encode5t($user_password), $user_orgid));
        	$count =  $sth->rowCount();
			
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
        
        if($count==1)
        {
				$row = $sth->fetch();			
				 $ubihrm_data	= trim(isset ($_REQUEST['ubihrm_data']) ? $_REQUEST['ubihrm_data'] : ''); 
				
				if($ubihrm_data!="")
				{
					$cdata = json_decode($ubihrm_data, true);
					
					//$data = $cdata;
					$c=0;$s=0;
					$mdate = date('Y-m-d H:i:s');
					$uid = $row->EmployeeId;
					$orgid = $row->OrganizationId;
					
				
					$this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);//raise error, throw errors
					for($i=0; $i<count($cdata); $i++)
					{
						$this->db->beginTransaction();
						
						try{
						$query11 = $this->db->prepare("SELECT coalesce(max(Id),0,max(Id)) as maxid FROM EmployeeNewJoinee");
						
						$query11->execute();
						$maxarr = $query11->fetch();
						$newid = ($maxarr->maxid)+1;
						$code = strtoupper(dechex(strtotime("now")))."".$newid;
						$filename="";
						if($cdata[$i]['photo']!="")
						{
							$temp = explode('.',$cdata[$i]['photo']);
							$len = count($temp);
							$ext = $temp[$len-1];
							$filename = $cdata[$i]['photo'];
							//$code.".".$ext;							
						}
						
						$query11 = $this->db->prepare("INSERT INTO EmployeeNewJoinee(Id, EmployeeCode, FirstName, LastName, DOB, Gender, ImageName, CurrentContactNumber, CurrentEmailId, Nationality, MaritalStatus, TotalExp, OnboardSts, CurrentAddress, CurrentCountry, CurrentCity, CurrentZipCode, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
						
						$query11->execute(array($newid, $code, $cdata[$i]['first_name'], $cdata[$i]['last_name'], $cdata[$i]['birth_date'],$cdata[$i]['gender'],$filename,$cdata[$i]['current_contact'],$cdata[$i]['current_email'], $cdata[$i]['nationality'], $cdata[$i]['marital_status'], $cdata[$i]['total_ex'], 1, $cdata[$i]['current_address'], $cdata[$i]['country'], $cdata[$i]['city'], $cdata[$i]['zipcode'],$mdate, $uid, $mdate, $uid, $uid, $orgid));
						
						if($query11->rowCount()>0)
						{
							$query12 = $this->db->prepare("INSERT INTO EmployeeNewJoiningReference(EmployeeId, Name, Company, Email, Contact) values(?,?,?,?,?)");
							if($cdata[$i]['ref_name1'] != ""){
								$query12->execute(array($newid, $cdata[$i]['ref_name1'], $cdata[$i]['ref_rela1'],$cdata[$i]['ref_email1'], $cdata[$i]['ref_cont1']));
							}
							if($cdata[$i]['ref_name2'] != ""){
								$query12->execute(array($newid, $cdata[$i]['ref_name2'], $cdata[$i]['ref_rela2'],$cdata[$i]['ref_email2'], $cdata[$i]['ref_cont2']));
							}
							for($j=0; $j<count($cdata[$i]['can_exper']); $j++)
							{
								$query12 = $this->db->prepare("INSERT INTO EmployeeNewJoiningWorkExperience(EmployeeId, CompanyName, Designation, FromDate, ToDate, Description, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values(?,?,?,?,?,?,?,?,?,?,?,?)");
							
								$query12->execute(array($newid, $cdata[$i]['can_exper'][$j]['company_name'], $cdata[$i]['can_exper'][$j]['desig'],$cdata[$i]['can_exper'][$j]['date_from'],$cdata[$i]['can_exper'][$j]['date_to'],"",$mdate, $uid, $mdate, $uid, $uid, $orgid));						
							
							}
							
							for($j=0; $j<count($cdata[$i]['can_qual']); $j++)
							{
								$query12 = $this->db->prepare("INSERT INTO EmployeeNewJoiningQualification(EmployeeId, InstituteName, Degree, FOS, DOC, GPA, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values(?,?,?,?,?,?,?,?,?,?,?,?)");
							
								$query12->execute(array($newid, $cdata[$i]['can_qual'][$j]['college'], $cdata[$i]['can_qual'][$j]['degree'],$cdata[$i]['can_qual'][$j]['specialization'],$cdata[$i]['can_qual'][$j]['can_to'],$cdata[$i]['can_qual'][$j]['percentage'] ,$mdate, $uid, $mdate, $uid, $uid, $orgid));			
								
							}
						}
						
						if($cdata[$i]['photo']!="")
						{
							copy("http://192.168.0.200/CMS_candidate/admin/php/uploads/".$cdata[$i]['photo'], "public/uploads/newjoining/".$filename);
							//copy("http://ubicrm.co/ubitech/ubirecruit/admin/php/uploads/".$cdata[$i]['photo'], "public/uploads/newjoining/".$filename);
						}
						$temp = array();
						$temp['id'] = $cdata[$i]['can_id'];
						$temp['email'] = $cdata[$i]['current_email'];
						$temp['name'] =$cdata[$i]['first_name'];
						$data[] = $temp;
						
						$this->db->commit();
						
						}catch(PDOException $e)
						{
							$this->db->rollback();
							$status=false;
							$errorMsg = $e->getMessage();
						}
						
						if($query11->rowCount()==1){
							$c++;
						}else{
							$s++;
						}
					 }
					if(count($data)>0){
						$status=true;
						$successMsg=$c." record boarded successfully";
					}else{
						$status=false;
						$errorMsg =" No employee boarded to hrm, due to ".$errorMsg;
					}
				}else{
					$status=false;
					$errorMsg="No employee found to onboard";
				}
			
        }else{
        	$status=false;
        	$errorMsg="Please check your login credentials";
        }
        
        
        $result['data'] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
	
	
        
        return $result;
        
	
    }
	
public function sendMailAWS(){
		 $json_arr[0] = json_decode(file_get_contents('php://input'), true);
		 $arrval=json_encode($json_arr);
			 
		 Utils::Trace($arrval);
		 $arr = array();
		 $i=0;
		foreach ($json_arr[0] as $key => $values){
			$arr[$i] = $values;
			$i++;
		}
		$to		=	isset($arr[0])	?	$arr[0]	:"";
		$fname		=	isset($arr[1])	?	$arr[1]	:"";
		$subject		=		isset($arr[2])	?	$arr[2]	:"";
		$msg		=		isset($arr[3])	?	$arr[3]	:"";
		$file		=		isset($arr[4])	?	$arr[4]	:"";
		Utils::Trace('To:   '.$to);
		Utils::Trace($subject);
		Utils::Trace($msg);
	Utils::sendMail($to,$fname,$subject,$msg,$file);
	return true;
}		

}
