<?php

/**
 * LeavetypeModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class LeavetypeModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['days'] = $row->LeaveDays;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = LEAVETYPE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmployeeAllLeaveType($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$applydate = Utils::getDateformat($request[2]);	
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $religion=0; $workingdays=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $religionflg=false; $halfdays=0; $leaveflg=false;
		$doj=date('Y-m-d');
		$mdate=date('Y-m-d');
		try{
		$fiscalid = Utils::getFiscalId($applydate, $this->db);
		$sql1 = "SELECT *  FROM FiscalMaster WHERE Id=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $fiscalid));
		while($row1=$query1->fetch()){
			$startdate=$row1->StartDate;
			$enddate=$row1->EndDate;
		}
		$sql = "SELECT MaritalStatus, Gender, Division, Department, Designation, Grade, Religion, TotalExp,WorkingDays,DOJ ,Shift,ProvisionPeriod  FROM EmployeeMaster WHERE OrganizationId = ? and Id =? ";
		
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $mid));
		while($row = $query->fetch())
		{
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$religion=$row->Religion; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=$row->WorkingDays;
			$workingdays=substr_count($workingdays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);
			$workingdays=Utils::averageWorkingDayWeek($row->Shift,$this->db);
			$doj=$row->DOJ;
			$ProvisionPeriod=$row->ProvisionPeriod;
			$date1= date("Y-m-d", strtotime("+".$ProvisionPeriod." month ".date($doj)));
			$currdate = date("Y-m-d");
		}
		
		
			
		$annualid =0; $annualcount =0;
		$sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() AND WorkingDays= $workingdays and AnnualLeaveSts=1 ";
		///////////and DepartmentIds=0 and DesignationIds=0 and GenderId=0 and maritalId=0  and DivisionId=0 and GradeId=0 and ReligionId=0";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		if($query->rowCount()>0)
		{
			while($row = $query->fetch())
			{
				$annualid =$row->Id;
			}
		}
		
        $sql1 = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE()";
        $query = $this->db->prepare($sql1);
		try{
			
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				$divisionflg=true;
				$departmentflg=true; 
				$designationflg=true; 
				$gradeflg=true; $religionflg=true;
				$genderflg=true; $maritalflg=true;
				
				$carryforward=0;
				$employeeusedleave=0;
				
				if($row->LeaveUsableSts==1){
					if($row->DivisionId>0){
						if($row->DivisionId==$division){
							$divisionflg=true;
						}else{$divisionflg=false;}
					}
					if($row->DepartmentIds>0){
						if($row->DepartmentIds==$department){
							$departmentflg=true; 
						}else{$departmentflg=false; }
					}
					if($row->DesignationIds>0){
						if($row->DesignationIds==$designation){
							$designationflg=true; 
						}else{$designationflg=false; }
					}
					if($row->GenderId>0){
						if($row->GenderId==$gender){
							$genderflg=true;
						}else{$genderflg=false;}
					}
					if($row->MaritalId>0){
						if($row->MaritalId==$marital){
							$maritalflg=true;
						}else{$maritalflg=false;}
					}
					if($row->GradeId>0){
						if($row->GradeId==$grade){
							$gradeflg=true; 
						}else{$gradeflg=false; }
					}
					if($row->ReligionId>0){
						if($row->ReligionId==$religion){
							$religionflg=true; 
						}else{$religionflg=false; }
					}
				}elseif($row->LeaveUsableSts==2){
					$divisionflg=false;
					$departmentflg=false; 
					$designationflg=false; 
					$gradeflg=false; 
					$genderflg=false; $maritalflg=false;
					$religionflg=false; 
					
					if($row->EmployeeIds!="")
					{
						$temp = explode(",", $row->EmployeeIds);
						for($i=0; $i<count($temp); $i++)
						{
							if($mid==$temp[$i]){
								$divisionflg=true;
								$departmentflg=true; 
								$designationflg=true; 
								$gradeflg=true; $religionflg=true;
								$genderflg=true; $maritalflg=true;
								break;
							}
							
						}
					}					
				}
				$annual=true;
				if($row->AnnualLeaveSts==1){
					$annual=false;
					if($row->CarryForward == 1) ///checking anniversary year status//////
					{
						$annual=true;
					}else{	
						if($row->WorkingDays ==$workingdays){
							$annual=true;
						}
					}
				}
				$leaveflg=true;
				if($row->ProbationSts==0)
				{
					if($currdate  > $date1){
						$leaveflg=true;
					}else{$leaveflg=false;}
				}
				
				//echo  $row->Name."div".$divisionflg ."<br>depart". $departmentflg ."<br>desog". $designationflg ."<br>grade". $gradeflg ."<br>gender".$genderflg ."<br>mar". $maritalflg ."<br>annual". $annual ."<br>rel". $religionflg ."<br>leav". $leaveflg."<br>";
				if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg && $annual && $religionflg && $leaveflg)
				{	
					$leavealotted=$row->LeaveDays;
					$anniversaryyearsts=$row->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
					if($row->AnnualLeaveSts==1){
						
						$carryforward=$this->getCarryforwardleave($mid,$fiscalid);
						if($anniversaryyearsts==1)
							$carryforward=0;
						if($row->WorkingDays ==$workingdays){
							++$annualcount;
						}
						$sql1 = "SELECT * FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";////////////
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $mid, $fiscalid));
						if($r = $query1->fetch())
						{
							$leavealotted =$r->LeaveAllotted;
							$employeeusedleave = $r->UsedLeave;
							$leftleave = $r->BalanceLeave;
						}else{
							$leavealotted =0;
							$employeeusedleave =0;
							$leftleave = 0;
							
						}
						////////////////////////////////////////////////////////
						
						
						/* if($anniversaryyearsts == 1)
						{
							$start = strtotime($doj);
							$end = strtotime(date('Y-m-d'));
							$days_between = floor(abs($end - $start) / 86400);
							$leavealotted1=floor(($days_between * $row->LeaveDays)/365);
							$leavealotted=$leavealotted1;
							$twoyearsdays=(365*2)+30;////ADD MORE 30 DAYS,FOR TAKE ACTION ON LEAVE///	
							if($days_between < $twoyearsdays)
							{
							//////////IN THIS CASE CALCULATION BASED ON DATE OF JOINING TILL NOW/////////
								
								$startdate=$doj;
								$enddate=$mdate;
							}else{
							/////////IN THIS CASE I FIND THE ANNIVERSARY YEAR OF EMPLOYEE OF THIS YEAR,AND CALCULATE LEAVE ,ON THIS BASIS////////
							
								$start = strtotime($doj);
								$end = strtotime(date("2015-04-01"));
								if($end>$start){
									$days_between = floor(($end - $start) / 86400);
									$leavealotted1=floor(($days_between * $row->LeaveDays)/365);
									$employeeusedleave = $employeeusedleave + $leavealotted1;
								}
								
								$startdate=date("2015-04-01");
								$enddate=$mdate;
								
								
							}
							/* /////////this condition is for 30 day calendar days employees,this calculation is based on anniversary year of the joining date,ex- 10/02/2014 -10/02/2015////////
							$myear=date('Y');
							$anniversaryyear=date('m-d',strtotime(date($doj)));
							$enddate=$myear.'-'.$anniversaryyear;
							$startdate=date('Y-m-d',strtotime("- 1 year".date($enddate)));
							if(strtotime($mdate) > strtotime($enddate))
							{
								$startdate=$myear.'-'.$anniversaryyear;
								$enddate=date('Y-m-d',strtotime("+ 1 year".date($startdate)));
							} */
							
						/* }elseif((strtotime($doj) > strtotime($startdate)) && $anniversaryyearsts !=1){
							//////////////////if an employee join organization in mid of fiscal year then leave days will calculated according to date of joining and end of fiscal year/////////////////
							//$sql="SELECT * FROM FiscalMaster where '$doj' between '$startdate' and '$enddate'";
							//$query = $this->db->prepare($sql);
							//$query->execute();
							//if($query->rowCount() >0 )
							//{
								$start = strtotime($doj);
								$end = strtotime($enddate);
								$days_between = floor(abs($end - $start) / 86400);
								$leavealotted1=floor(($days_between * $leavealotted)/365);
								$leavealotted=$leavealotted1;
							//}
						} */ 
						
						
						
					}else{
						$sql3 = "Select * from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=0 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 and empchild.Entitled=1";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array($startdate, $enddate, $orgid, $mid, $row->Id));
						while($row3=$query3->fetch()){
							if($row3->HalfDaySts == 1){
								$employeeusedleave = $employeeusedleave + 0.5;
							}
							else{
								$employeeusedleave++;
							}
						}
						$leftleave = $leavealotted-$employeeusedleave;
					}
					
					
					/* $sql3 = "Select * from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=0 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 and empchild.Entitled=1";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array($startdate, $enddate, $orgid, $mid, $row->Id));
					while($row3=$query3->fetch()){
						if($row3->HalfDaySts == 1){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					} */
				
					
					if($leftleave>=0)
					{
						$res = array();
						$res['id'] = (int)$row->Id;
						$res['name'] = $row->Name;
						$res['payrule'] = $row->LeavePayRule;
						$res['days'] = (int)$leavealotted;
						$res['usedleave'] = $employeeusedleave;
						$res['leftleave'] = $leftleave;
						$res['carryforward'] = $carryforward;
						$res['ProbationSts'] = $row->ProbationSts;
						
						$data[] = $res;
					}
				}
				
			}
		
				
        }else{
			$status=true;
			$successMsg = LEAVETYPE_MODULE_GETALL;
		}
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		/* if(count($data)>0 && $annualcount>1){
			for($i=0; $i<count($data); $i++)
			{
				if($data[$i]['id']==$annualid)
				{ array_splice($data, $i, 1);break;
				}
			}
		} */
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM LeaveMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['leavedays'] = $row->LeaveDays;
				$res['leavepaytype'] = $row->LeavePayRule;
                $res['fiscal_id'] = $row->fiscal_id;
                $res['leaveusablests'] = $row->LeaveUsableSts;
                $res['leaveallowedsts'] = $row->LeaveAllowedSts;
                $res['leavecolor'] = $row->LeaveColor;
                $res['department']= (int)$row->DepartmentIds;
                $res['designation']= (int)$row->DesignationIds;
				$res['division']= (int)$row->DivisionId;
                $res['grade']= explode(',',$row->GradeId);
                //$res['grade']=$row->GradeId;
				$res['religion']= (int)$row->ReligionId;
				$res['location']= (int)$row->locationId;
                $res['genderid']= $row->GenderId; 
                $res['maritalid']= $row->MaritalId;
                $res['employeeids']=($row->EmployeeIds!="")?explode(",",$row->EmployeeIds):"";
                $res['employeeexperience']=$row->EmployeeExperience; 
				$res['leavepayrule']=$row->LeavePayRule;
				$res['leaverule']=$row->LeaveRules;
				$res['workday']=$row->WorkingDays;
				$res['leaveapply']=	Utils::dateformatter($row->LeaveApply);
				$res['annualleave']=$row->AnnualLeaveSts;
				$res['desc']=$row->Description;
				$res['leavecal']=$row->CarryForward;///1 is for calender days///0 is for annual days
				$res['visiblests']=$row->VisibleSts;
				$res['ProbationSts']=$row->ProbationSts;
					
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = LEAVETYPE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = LEAVETYPE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getLeavehistory($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id'];
        $sql = "SELECT * FROM LeaveHistory WHERE Id = ? and OrganizationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ,$orgid));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['empid'] = $row->EmployeeId;
				$res['leavetype'] = $this->getEmpAnnualLeavetype($row->EmployeeId,$orgid );
				$res['empname'] = Utils::getEmployeeName($row->EmployeeId,$this->db);
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->EmployeeId ));
				while($row1 = $query1->fetch())
				{
					$res['empcode'] = $row1->EmployeeCode;
					$res['empdivision'] = Utils::getName($row1->Division,'DivisionMaster','Name',$this->db);
					$res['empdept'] = Utils::getName($row1->Department,'DepartmentMaster','Name',$this->db);
					$res['empdesig'] = Utils::getName($row1->Designation,'DesignationMaster','Name',$this->db);
					$res['empshift'] =Utils::getName( $row1->Shift,'ShiftMaster','Name',$this->db);
					$res['empgrade'] = Utils::getName($row1->Grade,'GradeMaster','Name',$this->db);
					$res['empdoj'] = Utils::dateformatter($row1->DOJ);
				}
				
				$res['leavealloted'] = $row->LeaveAllotted;
				$res['leaveutilize'] = $row->UsedLeave;
				$res['balanceleave'] = $row->BalanceLeave;
				$res['carryforward'] = $row->TotalLeave;
				$res['advance'] = $row->AdvanceLeave;
				$res['availableleave'] = $row->TotalLeave;
				
				//$alloted = Utils::getannualleaves($row->EmployeeId,$this->db);
				$leavetypeid = $this->getEmpAnnualLeavetypeId($row->EmployeeId,$orgid );
				$anniversaryyearsts=Utils::getName($leavetypeid,'LeaveMaster','CarryForward',$this->db); //////checking anniversary year status 1 for anniversary year,other than that working day/fiscal year leave/////////
				/////////Find out experience of employee according to doj//////////
				$doj=Utils::getName($row->EmployeeId,'EmployeeMaster','DOJ',$this->db);
				$start = strtotime($doj);
				$end = strtotime(date('Y-m-d'));
				$days_between = floor(abs($end - $start) / 86400);
				$twoyearsdays=(365*2)+30;	
				if($anniversaryyearsts ==1  )//&& ($days_between < $twoyearsdays))
				{
					$res['availableleave'] = $row->BalanceLeave;
				}
				
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = LEAVETYPE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = LEAVETYPE_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a DocumentMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$empid="";
		//for($i=0; $i<count($request[12]); $i++){
		$arr = json_decode($request[12]);
		foreach($arr as $value){
			if($empid==""){
				$empid=$value->id;
			}else{
				$empid=$empid.",".$value->id;
			}
		}
		
		$gradeids="";
			$gradeids = is_array($request[17]) ? implode(',',$request[17]): $request[17];
		//for($i=0; $i<count($request[12]); $i++){
		
		$leaveapply = Utils::getDateformat($request[19]);
		$sqlcode="SELECT * FROM LeaveMaster WHERE OrganizationId=? and Name=? and  WorkingDays = ? and AnnualLeaveSts=?  and  DepartmentIds=? and DesignationIds=? and GenderId=? and MaritalId=? and DivisionId=? and GradeId in (?) and ReligionId=? and EmployeeIds =? and LeaveDays=? and  locationId=? and Id<>?";
		
		$querycode=$this->db->prepare($sqlcode);
		$querycode->execute(array($orgid,$request[2],$request[20], $request[21], $request[8], $request[9], $request[10], $request[11] , $request[16], $gradeids, $request[23], $empid,$request[3],$request[28], $request[18] ));
		$count1=$querycode->rowCount();
		if($count1>=1 ){
			$status =false;
		    $errorMsg = LEAVETYPE_MODULE_WORKINGDAY_DUPLICATE;
		}else{
			$sql = "UPDATE LeaveMaster SET Name=?, LeaveDays=?, fiscal_id=?, LeaveUsableSts=? , LeaveAllowedSts=?, LeaveColor=?, DepartmentIds=? ,DesignationIds =? ,GenderId =? ,MaritalId = ? ,EmployeeIds =?,  EmployeeExperience =?, LeavePayRule=?, LeaveRules=?, DivisionId=?, GradeId=?, LastModifiedDate=?, LastModifiedById=?, LeaveApply=?, WorkingDays=?, Description=?, AnnualLeaveSts=?, ReligionId=?,CarryForward=?,VisibleSts=?, ProbationSts=?,locationId=?  where Id=?";
			
			$query = $this->db->prepare($sql);
			
			try{
				$query->execute(array($request[2],$request[3],$request[4],$request[5],$request[6],$request[7],$request[8],$request[9], $request[10], $request[11], $empid, $request[13], $request[14], $request[15], $request[16], $gradeids, $mdate, $mid, $leaveapply, $request[20],$request[22],$request[21], $request[23], $request[26],$request[25],$request[27],$request[28],$request[18]));			
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				//$empid=Utils::getName($did,'BenefitCompansationMaster','EmployeeId',$this->db);
				
				$msg="Leave type has been updated  ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Leave type", $msg, $orgid));
			   $status =true;
			   $successMsg = LEAVETYPE_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = LEAVETYPE_MODULE_UPDATION_FAILED;
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   public function UpdateLeaveHistory($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$leavehistoryid = $request[2];
			$availleave = $request[3];
			$resetleave = $request[4];
			$resettype = $request[5];
			$leavests="Lapse";/////////0 for lapse
			$cond="";
			if($resettype==1){
				$leavests="Encash";/////////1 for encash
				$cond=",EncashDate='$mdate'";
			}	
			$empid = $_POST['empid'];
			$changefield = "TotalLeave";//carryforward working days
			//$alloted = Utils::getannualleaves($empid,$this->db);
			$leavetypeid = $this->getEmpAnnualLeavetypeId($empid,$orgid );
			$anniversaryyearsts=Utils::getName($leavetypeid,'LeaveMaster','CarryForward',$this->db); //////checking anniversary year status 1 for anniversary year,other than that working day/fiscal year leave/////////
			/////////Find out experience of employee according to doj//////////
			$doj=Utils::getName($empid,'EmployeeMaster','DOJ',$this->db);
			$start = strtotime($doj);
			$end = strtotime(date('Y-m-d'));
			$days_between = floor(abs($end - $start) / 86400);
			$twoyearsdays=(365*2)+30;	
			/* if($alloted == 30 && ($days_between < $twoyearsdays))
			{
				$changefield = "BalanceLeave";//un-utilized 
			} */
			if($anniversaryyearsts == 1) 
			{
				$changefield = "BalanceLeave";//un-utilized 
			}
			
			$balleave=$availleave-$resetleave;
			if($balleave >=0){
				$sql = "Select ResetLeave from LeaveHistory where Id=$leavehistoryid";
				$query = $this->db->prepare($sql);
				$query->execute();	
				while($row=$query->fetch())
				{
					//$resetleave+=$row->ResetLeave;
				}	
				$sql = "UPDATE LeaveHistory SET $changefield=$balleave,CFLeave=$balleave, LeaveSts=$resettype, ResetLeave=$resetleave $cond where Id=$leavehistoryid";
				$query = $this->db->prepare($sql);
				$query->execute();			
				$count =  $query->rowCount();
				
				if ($count == 1) {
					//$empid=Utils::getName($did,'BenefitCompansationMaster','EmployeeId',$this->db);
					$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
					$msg="Leave History of $empname has been updated  ";
					$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($mid, "Leave Type", $msg, $orgid));
				   $status =true;
				   $successMsg = "Leave $leavests Successfully";
				} else {
				   $status =false;
				   $errorMsg = LEAVETYPE_MODULE_UPDATION_FAILED;
				}
			}else{
				$status =false;
				$errorMsg = "You can't $leavests more than $availleave leave";
			
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
    /**
     * Setter for a DocumentMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */

    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$empid="";
		//for($i=0; $i<count($request[12]); $i++){
		$arr = json_decode($request[12]);
		foreach($arr as $value){
			if($empid==""){
				$empid=$value->id;
			}else{
				$empid=$empid.",".$value->id;
			}
		}
		$gradeids="";
			$gradeids = is_array($request[17]) ? implode(',',$request[17]): $request[17];
		$leaveapply = Utils::getDateformat($request[18]);
		$sqlcode="SELECT * FROM LeaveMaster WHERE  OrganizationId=? and Name=? and  WorkingDays = ? and AnnualLeaveSts=?  and  DepartmentIds=? and DesignationIds=? and GenderId=? and MaritalId=? and DivisionId=? and GradeId in(?) and EmployeeIds =? and ReligionId=? and  locationId=? and LeaveDays=?";
		
		$querycode=$this->db->prepare($sqlcode);
		$querycode->execute(array($orgid, $request[2],$request[19], $request[20], $request[8], $request[9], $request[10], $request[11] , $request[16], $gradeids, $empid,$request[22],$request[27],$request[3] ));
		
		$count1=$querycode->rowCount();
		if($count1>=1){
			$status =false;
		    $errorMsg = LEAVETYPE_MODULE_WORKINGDAY_DUPLICATE;
		}else{
			$sql = "INSERT INTO LeaveMaster (Name, LeaveDays, fiscal_id, LeaveUsableSts, LeaveAllowedSts, LeaveColor, DepartmentIds, DesignationIds, GenderId, MaritalId, EmployeeIds, EmployeeExperience, LeavePayRule, LeaveRules, DivisionId, GradeId, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, LeaveApply, WorkingDays,Description,AnnualLeaveSts,ReligionId,CarryForward,VisibleSts,ProbationSts,locationId) VALUES (? , ? ,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $request[7], $request[8], $request[9], $request[10], $request[11], $empid, $request[13], $request[14], $request[15], $request[16], $gradeids, $orgid, $mdate, $mid, $mdate, $mid, $mid, $leaveapply, $request[19],$request[21],$request[20],$request[22],$request[25],$request[24],$request[26],$request[27]));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				//$empid=Utils::getName($did,'BenefitCompansationMaster','EmployeeId',$this->db);
			
				$msg="Leave Type has been created  ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Leave Type", $msg, $orgid));
			   $status =true;
			   $successMsg = LEAVETYPE_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = LEAVETYPE_MODULE_CREATION_FAILED;
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql1 = "SELECT Id FROM EmployeeLeave WHERE LeaveTypeId = :id ";
        	$query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg="Leavetype assigned to an employee cannot be deleted";
		}else{
		
			$sql = "DELETE FROM LeaveMaster WHERE Id = :id ";
		
			try{
			
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
		
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
			if ($count == 1) {
				
				
				$msg="Leave Type has been deleted  ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Leave Type", $msg, $orgid));
			   $status =true;
				   $successMsg = LEAVETYPE_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
				   $errorMsg = LEAVETYPE_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM LeaveMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getLeaveCF()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $_SESSION['ubihrm_user_id'];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$applydate = date("Y-m-d");	
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $religion=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $religionflg=false; $halfdays=0;
		$fiscaldata=array();
		$doj=date('Y-m-d');
		$mdate=date('Y-m-d');
		$startdate=date('Y-04-01');
		$enddate=date('Y-03-31');
		try{
			$fiscalid = Utils::getFiscalId($applydate, $this->db);
			$sql1 = "SELECT *  FROM FiscalMaster WHERE Id=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $fiscalid));
			while($row1=$query1->fetch()){
				$res1=array();
				$res1['id']=$row1->Id;
				$res1['name']=$row1->Name;
				$startdate=$row1->StartDate;
				$enddate=$row1->EndDate;
				$res1['startdate']=Utils::dateformatter($row1->StartDate);
				$res1['enddate']=Utils::dateformatter($row1->EndDate);
				$fiscaldata[]=$res1;
			}
			
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$sWhere ="";
			if($sts==1 || $hrsts==1){
				$sWhere = "WHERE OrganizationId= $orgid AND DOL='0000-00-00' and Is_Delete=0 ";
			}
			else{
				$ids = Utils::getReportingIds($mid, $this->db);
				$sWhere = " WHERE  OrganizationId= $orgid and Is_Delete=0 AND DOL='0000-00-00'  AND Id in ($ids ) ";
			}
			
			$sql = "SELECT Id,FirstName,LastName,EmployeeCode,MaritalStatus, Gender, Division, Department, Designation, Grade, Religion, TotalExp,WorkingDays,DOJ,Shift,ProvisionPeriod FROM EmployeeMaster $sWhere order by FirstName";
			$query = $this->db->prepare($sql);
			$query->execute();
			while($row = $query->fetch())
			{
				$division=$row->Division;
				$department=$row->Department; 
				$designation=$row->Designation; 
				$grade=$row->Grade; 
				$religion=$row->Religion; 
				$gender=$row->Gender; 
				$marital=$row->MaritalStatus;
				$doj=$row->DOJ;
				$empid= $row->Id;
				$ProvisionPeriod=$row->ProvisionPeriod;
				$date1= date("Y-m-d", strtotime("+".$ProvisionPeriod." month ".date($doj)));
				$currdate = date("Y-m-d");
				
				$workingdays=Utils::averageWorkingDayWeek($row->Shift, $this->db);
				$sqlleave = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and WorkingDays =$workingdays and AnnualLeaveSts=1";
				$query1 = $this->db->prepare($sqlleave);
				$query1->execute(array($orgid));
				$count =  $query1->rowCount();
				
				while($rowleave = $query1->fetch())
				{
					$divisionflg=true;
					$departmentflg=true; 
					$designationflg=true; 
					$gradeflg=true; $religionflg=true;
					$genderflg=true; $maritalflg=true;
					
					$carryforward=0;
					$employeeusedleave=0;
				
					$leavealotted=$rowleave->LeaveDays;
					if($rowleave->LeaveUsableSts==1){
							if($rowleave->DivisionId>0){
								if($rowleave->DivisionId==$division){
									$divisionflg=true;
								}else{$divisionflg=false;}
							}
							if($rowleave->DepartmentIds>0){
								if($rowleave->DepartmentIds==$department){
									$departmentflg=true; 
								}else{$departmentflg=false; }
							}
							if($rowleave->DesignationIds>0){
								if($rowleave->DesignationIds==$designation){
									$designationflg=true; 
								}else{$designationflg=false; }
							}
							if($rowleave->GenderId>0){
								if($rowleave->GenderId==$gender){
									$genderflg=true;
								}else{$genderflg=false;}
							}
							if($rowleave->MaritalId>0){
								if($rowleave->MaritalId==$marital){
									$maritalflg=true;
								}else{$maritalflg=false;}
							}
							if($rowleave->GradeId>0){
								if($rowleave->GradeId==$grade){
									$gradeflg=true; 
								}else{$gradeflg=false; }
							}
						}elseif($rowleave->LeaveUsableSts==2){
							$divisionflg=false;
							$departmentflg=false; 
							$designationflg=false; 
							$gradeflg=false; 
							$genderflg=false; $maritalflg=false;
							
							if($rowleave->EmployeeIds!="")
							{
								$temp = explode(",", $rowleave->EmployeeIds);
								for($i=0; $i<count($temp); $i++)
								{
									if($empid==$temp[$i]){
										$divisionflg=true;
										$departmentflg=true; 
										$designationflg=true; 
										$gradeflg=true; 
										$genderflg=true; $maritalflg=true;
										//echo $rowleave->Id.' '.$empid;
										break;
									}
									
								}
							}
							
						}
						
						if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg)
						{
						
						////////////////FIND OUT LEAVE BALANCE OF LAST YEAR/MONTH/////////////
						
						$sqlcf = "SELECT Id,CFLeave,TotalLeave FROM LeaveHistory WHERE EmployeeId = ? and OrganizationId =? and FiscalId=?";
						$querycf = $this->db->prepare($sqlcf);
						$querycf->execute(array( $empid ,$orgid, $fiscalid));
						$concf=$querycf->rowCount();
						
						while($rowcf = $querycf->fetch())
						{
							$res1 = array();
							$res1['id'] = (int)$rowcf->Id;
							$res1['empname']=	$row->FirstName." "	.$row->LastName;		
							$res1['empid'] = $row->Id;
							$res1['empcode'] = $row->EmployeeCode;
							$res['empdoj'] = Utils::dateformatter($row->DOJ);
							$res1['leaveid'] = (int)$rowleave->Id;
							$res1['leavetype'] = $rowleave->Name;
							$res1['fiscalid'] = $fiscalid;
							$res1['carryforward'] = (float)$rowcf->TotalLeave;
							$data[] = $res1;
						}
						
					}
				}
			}
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data"] =$data;
		$result["fiscaldata"] =$fiscaldata;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function UpdateLeaveCF($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$leavecfid = $request[2];
			$carryforward = $request[3];
			$empid = $request[4];
			$fiscalid = $request[5];
			
			$sql = "UPDATE LeaveHistory SET CFLeave=?, TotalLeave=? where Id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($carryforward, $carryforward,  $leavecfid));
			$count =  $query->rowCount();
			
			if ($count == 1) {
				//$empid=Utils::getName($did,'BenefitCompansationMaster','EmployeeId',$this->db);
				$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Leave Carried forward of $empname has been updated  ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Leave Carry forward", $msg, $orgid));
			   $status =true;
			   $successMsg = "Leave Carry forward has been updated Successfully";
			} else {
			   $status =false;
			   $errorMsg = LEAVETYPE_MODULE_UPDATION_FAILED;
			}
			
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
    
	public function getCarryforwardleave($empid,$fiscalid)
	{
		$name =0;
		$sql = "SELECT TotalLeave FROM LeaveHistory WHERE EmployeeId = ? and FiscalId =?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid ,$fiscalid));
			while($row = $query->fetch())
			{
				$name = $row->TotalLeave;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'LeaveMaster';
		$sIndexColumn = "Id";
		$aColumns = array(  'Name', 'LeaveDays', 'LeaveApply','LeaveColor','WorkingDays','Description',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'leave/editleavetype/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'EmployeeMaster','FirstName',$this->db);
					
				}
				else if($aColumns[$i]=="LeaveColor")
				{
					$row[] = '<span class="label" style="color:white;background-color:'.$aRow->{$aColumns[$i]}.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
					
				}
				else if($aColumns[$i]=="LeaveApply" || $aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getEmpAnnualLeavetype($empid,$orgid)
	{
		
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $workingdays=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $annualleave=""; $halfdays=0;
		
		$sql="select * from EmployeeMaster where OrganizationId=? and Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid,$empid));
		while($row=$query->fetch()){
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=substr_count($row->WorkingDays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);	
			$workingdays=Utils::averageWorkingDayWeek($row->Shift, $this->db);
			$sqlleave = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE()  and AnnualLeaveSts=1";
			//$sqlleave = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and WorkingDays =$workingdays and AnnualLeaveSts=1";
			$queryleave = $this->db->prepare($sqlleave);
			$queryleave->execute(array($orgid));
			$count1 =  $queryleave->rowCount();
			if($count1>=1)
				{
					while($rowleave = $queryleave->fetch())
					{
						$anniversaryyearsts=$rowleave->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
						
						$divisionflg=true;
						$departmentflg=true; 
						$designationflg=true; 
						$gradeflg=true; 
						$genderflg=true; $maritalflg=true;
						
						$employeeusedleave=0;
						
						if($rowleave->LeaveUsableSts==1){
							if($rowleave->DivisionId>0){
								if($rowleave->DivisionId==$division){
									$divisionflg=true;
								}else{$divisionflg=false;}
							}
							if($rowleave->DepartmentIds>0){
								if($rowleave->DepartmentIds==$department){
									$departmentflg=true; 
								}else{$departmentflg=false; }
							}
							if($rowleave->DesignationIds>0){
								if($rowleave->DesignationIds==$designation){
									$designationflg=true; 
								}else{$designationflg=false; }
							}
							if($rowleave->GenderId>0){
								if($rowleave->GenderId==$gender){
									$genderflg=true;
								}else{$genderflg=false;}
							}
							if($rowleave->MaritalId>0){
								if($rowleave->MaritalId==$marital){
									$maritalflg=true;
								}else{$maritalflg=false;}
							}
							if($rowleave->GradeId>0){
								if($rowleave->GradeId==$grade){
									$gradeflg=true; 
								}else{$gradeflg=false; }
							}
						}elseif($rowleave->LeaveUsableSts==2){
							$divisionflg=false;
							$departmentflg=false; 
							$designationflg=false; 
							$gradeflg=false; 
							$genderflg=false; $maritalflg=false;
							
							if($rowleave->EmployeeIds!="")
							{
								$temp = explode(",", $rowleave->EmployeeIds);
								for($i=0; $i<count($temp); $i++)
								{
									if($empid==$temp[$i]){
										$divisionflg=true;
										$departmentflg=true; 
										$designationflg=true; 
										$gradeflg=true; 
										$genderflg=true; $maritalflg=true;
										break;
									}
									
								}
							}
							
						}
						
						if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg)
						{							
							if($anniversaryyearsts!=1)
							{
								if($rowleave->WorkingDays==$workingdays)
								{
									$annualleave = $rowleave->Name;
								}
							}elseif($anniversaryyearsts==1){		
								$annualleave = $rowleave->Name;
							}
							
						}
					}
				}
		}	
			return $annualleave;
	}
	
	public function getEmpAnnualLeavetypeId($empid,$orgid)
	{
		
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $workingdays=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $annualleave=""; $halfdays=0;
		
		$sql="select * from EmployeeMaster where OrganizationId=? and Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid,$empid));
		while($row=$query->fetch()){
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=substr_count($row->WorkingDays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);	
			$workingdays=Utils::averageWorkingDayWeek($row->Shift, $this->db);
			$sqlleave = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE()  and AnnualLeaveSts=1";
			//$sqlleave = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and WorkingDays =$workingdays and AnnualLeaveSts=1";
			$queryleave = $this->db->prepare($sqlleave);
			$queryleave->execute(array($orgid));
			$count1 =  $queryleave->rowCount();
			if($count1>=1)
				{
					while($rowleave = $queryleave->fetch())
					{
						$anniversaryyearsts=$rowleave->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
						
						$divisionflg=true;
						$departmentflg=true; 
						$designationflg=true; 
						$gradeflg=true; 
						$genderflg=true; $maritalflg=true;
						
						$employeeusedleave=0;
						
						if($rowleave->LeaveUsableSts==1){
							if($rowleave->DivisionId>0){
								if($rowleave->DivisionId==$division){
									$divisionflg=true;
								}else{$divisionflg=false;}
							}
							if($rowleave->DepartmentIds>0){
								if($rowleave->DepartmentIds==$department){
									$departmentflg=true; 
								}else{$departmentflg=false; }
							}
							if($rowleave->DesignationIds>0){
								if($rowleave->DesignationIds==$designation){
									$designationflg=true; 
								}else{$designationflg=false; }
							}
							if($rowleave->GenderId>0){
								if($rowleave->GenderId==$gender){
									$genderflg=true;
								}else{$genderflg=false;}
							}
							if($rowleave->MaritalId>0){
								if($rowleave->MaritalId==$marital){
									$maritalflg=true;
								}else{$maritalflg=false;}
							}
							if($rowleave->GradeId>0){
								if($rowleave->GradeId==$grade){
									$gradeflg=true; 
								}else{$gradeflg=false; }
							}
						}elseif($rowleave->LeaveUsableSts==2){
							$divisionflg=false;
							$departmentflg=false; 
							$designationflg=false; 
							$gradeflg=false; 
							$genderflg=false; $maritalflg=false;
							
							if($rowleave->EmployeeIds!="")
							{
								$temp = explode(",", $rowleave->EmployeeIds);
								for($i=0; $i<count($temp); $i++)
								{
									if($empid==$temp[$i]){
										$divisionflg=true;
										$departmentflg=true; 
										$designationflg=true; 
										$gradeflg=true; 
										$genderflg=true; $maritalflg=true;
										break;
									}
									
								}
							}
							
						}
						
						if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg)
						{							
							if($anniversaryyearsts!=1)
							{
								if($rowleave->WorkingDays==$workingdays)
								{
									$annualleave = $rowleave->Id;
								}
							}elseif($anniversaryyearsts==1){		
								$annualleave = $rowleave->Id;
							}
							
						}
					}
				}
		}	
			return $annualleave;
	}
	
	public function getLeaveBalanceDataTable($editper, $deleteper)
	{
		$sTable = 'LeaveHistory';
		$sIndexColumn = "Id";
		$aColumns = array(  'EmployeeId','FiscalId','EmployeeId','EmployeeId', 'LeaveAllotted', 'UsedLeave','BalanceLeave','TotalLeave','AdvanceLeave','Id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$sts=$_SESSION['ubihrm_user_sts'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$fiscalid=$_SESSION['ubihrm_fiscalid'];
		$dept=isset($_GET['department'])?$_GET['department']:0;
		$desig=isset($_GET['designation'])?$_GET['designation']:0;
		$div=isset($_GET['division'])?$_GET['division']:0;
		$userid = $_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId = $orgid and AnnualSts=1 and EmployeeId in ( select Id from EmployeeMaster where DOL='0000-00-00' and Is_Delete=0)";
		}else{
			$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid and Is_Delete=0) ";
		}
		if($dept != 0 || $desig != 0 || $div != 0){
			$sWhere = " WHERE  OrganizationId = $orgid and (EmployeeId in (select Id from EmployeeMaster where DOL='0000-00-00' and Is_Delete=0 and Department=$dept OR Designation =$desig OR Division =$div))";
		}
		if($dept != 0 && $desig != 0 && $div != 0){
			$sWhere = " WHERE  OrganizationId = $orgid and (EmployeeId in (select Id from EmployeeMaster where DOL='0000-00-00' and Is_Delete=0 and Department=$dept AND Designation =$desig AND Division =$div))";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					
						if($i==1){
							$sWhere .= $aColumns[$i]." in (select Id from FiscalMaster where '".($_GET['sSearch_'.$i])."' between StartDate and EndDate) ";
						}else{
							$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
						}
					
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==2)
				{
					$row[] = self::getEmpAnnualLeavetype($aRow->EmployeeId,$orgid);
					
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==3)
				{
					$doj = Utils::getName($aRow->EmployeeId,'EmployeeMaster','DOJ',$this->db);
					$row[] = Utils::dateformatter($doj);
				}
				/*elseif($aColumns[$i]=="BalanceLeave" && $i>5)
				{
					$totalleave=($aRow->BalanceLeave)+($aRow->TotalLeave)-($aRow->AdvanceLeave);
					$row[] =$totalleave ;
				}*/
				elseif($aColumns[$i]=="Id"  )
				{
					if($hrsts==1){
						$row[] = '<a rel="tooltip" title="Encash/Lapse" href="'.URL.'leave/lapsencashleave/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
					else{
						$row[] ="";
					}
					
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
	
	public function getAnniversaryLeaveBalanceDataTable($editper, $deleteper)
	{
		$sTable = 'LeaveHistory';
		$sIndexColumn = "Id";
		$aColumns = array(  'EmployeeId','FiscalId','EmployeeId','EmployeeId', 'LeaveAllotted', 'UsedLeave','BalanceLeave','Id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$fiscalid=$_SESSION['ubihrm_fiscalid'];
		$dept=isset($_GET['department'])?$_GET['department']:0;
		$desig=isset($_GET['designation'])?$_GET['designation']:0;
		$div=isset($_GET['division'])?$_GET['division']:0;
		
		$sWhere = " WHERE  OrganizationId = $orgid and FiscalId=$fiscalid and AnnualSts=0 and EmployeeId in (select Id from EmployeeMaster where DOL='0000-00-00' and Is_Delete=0 )";
		
		if($dept != 0 || $desig != 0 || $div != 0){
			$sWhere = " WHERE  OrganizationId = $orgid and FiscalId=$fiscalid and AnnualSts=0 and (EmployeeId in (select Id from EmployeeMaster where DOL='0000-00-00' and Is_Delete=0 and Department=$dept OR Designation =$desig OR Division =$div ))";
		}
		if($dept != 0 && $desig != 0 && $div != 0){
			$sWhere = " WHERE  OrganizationId = $orgid and FiscalId=$fiscalid and AnnualSts=0 and (EmployeeId in (select Id from EmployeeMaster where DOL='0000-00-00' and Is_Delete=0 and Department=$dept AND Designation =$desig AND Division =$div))";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					
						if($i==1){
							$sWhere .= $aColumns[$i]." in (select Id from FiscalMaster where '".($_GET['sSearch_'.$i])."' between StartDate and EndDate) ";
						}else{
							$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
						}
					
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==2)
				{
					$row[] = self::getEmpAnnualLeavetype($aRow->EmployeeId,$orgid);
					
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==3)
				{
					$doj = Utils::getName($aRow->EmployeeId,'EmployeeMaster','DOJ',$this->db);
					$row[] = Utils::dateformatter($doj);
				}
				/*elseif($aColumns[$i]=="BalanceLeave" && $i>5)
				{
					$totalleave=($aRow->BalanceLeave)+($aRow->TotalLeave)-($aRow->AdvanceLeave);
					$row[] =$totalleave ;
				}*/
				elseif($aColumns[$i]=="Id"  )
				{
					if($hrsts==1){
						$row[] = '<a rel="tooltip" title="Encash/Lapse" href="'.URL.'leave/lapsencashleave/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
					else{
						$row[] ="";
					}
					
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
}
