<?php

/**
 * LeaveModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class LeaveapprovalModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM LeaveApproval WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = LEAVE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$sql = "SELECT * FROM EmployeeLeave WHERE Id = :id";
			$query = $this->db->prepare($sql);
		
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['fromdate'] 		= Utils::dateformatter($row->LeaveFrom);       
				$res['employeeid'] 		= Utils::getEmployeeName($row->EmployeeId, $this->db);
				$res['employee'] 		= $row->EmployeeId;
				$res['todate'] 			= Utils::dateformatter($row->LeaveTo);
				$res['leavereason'] 	= $row->LeaveReason;
				$res['leavestatus'] 	= $row->LeaveStatus;
				$res['approvercomment'] = $row->ApproverComment;
				$res['applydate'] 		= Utils::dateformatter($row->ApplyDate);
				$res['leavevalidsts'] 	= $row->LeaveValidDays;
				$res['approvedby'] 		= $row->ApprovedBy;
				$res['fiscalid'] 		= $row->FiscalId;
				$res['leavetypeid'] 	= $row->LeaveTypeId;
				$res['leavetype'] 	= Utils::getName($row->LeaveTypeId,'LeaveMaster', 'Name', $this->db);
				$res['resumptiondate'] 	= Utils::dateformatter($row->ResumptionDate);
				$res['substituteid'] 	= Utils::getEmployeeName($row->SubstituteEmployeeId, $this->db);
				$res['emergencycontact']= $row->EmergencyContact;
				$res['leavebreakdown'] 	= $row->LeaveBreakDown;
				$res['leaveattachment'] 	= "";
					$code=Utils::getName($row->EmployeeId,'EmployeeMaster','EmployeeCode',$this->db);
					$doc1="$code".'_'."$id";
					$dir="public/uploads/$orgid/$code";
					$filename="";
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext = pathinfo($filename, PATHINFO_EXTENSION);
								if($filename=="$doc1.$ext")
								{
									$res['leaveattachment']=URL.$dir."/$filename";
								}
							}
							closedir($dh);
						}
					}
				
                $sql2 = "SELECT * FROM LeaveHistory WHERE EmployeeId =?  and FiscalId=?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($row->EmployeeId,$row->FiscalId));
				while($r=$query2->fetch())
				{
					$res['carryforwarded'] 	= $r->TotalLeave;
				}
				$sql2 = "SELECT *, TIMESTAMPDIFF(YEAR, DOJ, CURDATE()) as curyear, TIMESTAMPDIFF(MONTH, DOJ, CURDATE()) as curmonth FROM EmployeeMaster WHERE Id =? ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($row->EmployeeId));
				while($r=$query2->fetch())
				{
					$res['designation'] = Utils::getName($r->Designation,'DesignationMaster','Name',$this->db);
					$res['curyear'] = ((int)$r->curyear < 0)?0:(int)$r->curyear;
					$curmonth = ((int)$r->curmonth < 0)?0:(int)$r->curmonth;
					$year=($res['curyear'] * 12);
					$res['curmonth']=$curmonth  - $year;
	
				}
				
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = "SUCCESS";
        } else {
           $status =false;
		   $errorMsg = "FAILED";
        }
		
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
   public function getTimeoffDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$sql = "SELECT * FROM Timeoff WHERE Id = :id";
			$query = $this->db->prepare($sql);
		
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['TimeofDate'] 		= Utils::dateformatter($row->TimeofDate);       
				$res['employeeid'] 		= Utils::getEmployeeName($row->EmployeeId, $this->db);
				$res['employee'] 		= $row->EmployeeId;
				$res['FromTime'] 			=$row->TimeFrom;
				$res['ToTime'] 			=$row->TimeTo;
				$from = strtotime($row->TimeFrom);
								$to = strtotime($row->TimeTo);
								$diff=$to-$from;
								$diff=$diff/60;
								if($diff>60)
								{
									$diff=$diff/60;
									$diff.= "hrs";
									
								}else{
									$diff.="min";
								}
				$res['TotalTime']=$diff;
				$res['Reason'] 	= $row->Reason;
				$res['ApprovalSts'] 	= $row->ApprovalSts;
				$res['ApproverComment'] = $row->ApproverComment;
				$res['CreatedDate'] 		= Utils::dateformatter($row->CreatedDate);
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = "SUCCESS";
        } else {
           $status =false;
		   $errorMsg = "FAILED";
        }
		
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    } 
   
    public function Reject($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		try{
			$sql1 = "UPDATE EmployeeLeave SET LeaveStatus =?, ApprovedBy=?, ApproverComment=?,LastModifiedDate=?, LastModifiedById=?  WHERE Id =? ";
			$query = $this->db->prepare($sql1);
			$query->execute(array(1,$mid,'Rejected by HR',$mdate,$mid, $request[2]));
			$count=$query->rowCount();
			
			$sql = "UPDATE EmployeeLeaveChild SET LeaveStatus = ? WHERE  EmployeeLeaveId = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( 1,$request[2]));
			
			/*generate mail and alert for leave request rejected */
				Alerts::generateActionAlerts(59,$request[2],$orgid,$this->db);
				
			if ($count >= 1) {
			   $status =true;
			   $successMsg = EMPLOYEELEAVE_LEAVE_REJECT;
			   
			} else {
			   $status =false;
			   $errorMsg = EMPLOYEELEAVE_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	    /*public function Reject($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "Select * FROM LeaveApproval WHERE LeaveId =? AND ApproverId = ? ";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[2], $mid));
		$count =  $query->rowCount();
		if($count >=1){
			$sql1 = "UPDATE LeaveApproval SET ApproverSts =? WHERE LeaveId =? AND ApproverId=? ";
			try{
				$query = $this->db->prepare($sql1);
				$query->execute(array(1,$request[2], $mid));
		
			$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		else{
			$sql1 = "INSERT INTO LeaveApproval ( LeaveId, ApproverId, ApproverSts, CreatedDate,  OrganizationId) VALUES (?, ?, ?, ?, ?)";
			
			try{
				$query = $this->db->prepare($sql1);
				$query->execute(array($request[2], $mid,1, $mdate, $orgid));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
        if ($count >= 1) {
           $status =true;
		   $successMsg = EMPLOYEELEAVE_LEAVE_REJECT;
		   
		   $sql1 = "UPDATE EmployeeLeave SET LeaveStatus =?,LastModifiedDate=?, LastModifiedById=?  WHERE Id =? ";
		   $query = $this->db->prepare($sql1);
			$query->execute(array(1,$mdate,$mid, $request[2]));
        } else {
           $status =false;
		   $errorMsg = EMPLOYEELEAVE_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }*/

	 public function Approve($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false; $leavereason=""; $duration=""; $leavedays="";
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$leaveid = $request[2];
		$empid=0;
		$mdate = date("Y-m-d H:i:s");
		//$fiscalid=Utils::getFiscalId($mdate,$this->db);
		$sql = "UPDATE LeaveApproval SET ApproverSts =?, ApprovalDate =?, ApproverComment=? WHERE LeaveId =? AND ApproverId=? and OrganizationId=? and  ApproverSts =3 and ApprovalDate ='0000-00-00 00:00:00'";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array($request[3], $mdate, $request[4], $leaveid, $mid, $orgid));
			$count =  $query->rowCount();		
			if ($count >= 1) {
				$empid=Utils::getName($leaveid,'EmployeeLeave','EmployeeId',$this->db);
				 $empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="A leave has been approved of $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Leave", $msg, $orgid));
			   $status =true;
				$emp_name="";
				$emp_mail="";
				$sql3="select Id, CompanyEmail, FirstName, LastName from EmployeeMaster where Id=(select EmployeeId from EmployeeLeave where Id=$leaveid)";
				//Utils::Trace($sql3." ".$leaveid);
				$query3=$this->db->prepare($sql3);
				$query3->execute();
				if($row3=$query3->fetch()){
					$emp_mail=Utils::decode5t($row3->CompanyEmail);
					$emp_name=$row3->FirstName." ".$row3->LastName;
					$emp_id=$row3->Id;
					//Utils::Trace("name and email".$emp_mail." ".$emp_name);
				}
			   ///////////////if application is approve///////////////////////////
			   if($request[3]==2){
				$leavetypeid=Utils::getName($leaveid, "EmployeeLeave", "LeaveTypeId", $this->db);
					$LeaveValidDays=Utils::getName($leaveid, "EmployeeLeave", "LeaveValidDays", $this->db);
					$applydate=Utils::getName($leaveid, "EmployeeLeave", "ApplyDate", $this->db);
					$leavebalance=$this->getEmployeeLeftLeave($emp_id,$leavetypeid,$applydate);
					if($leavebalance<$LeaveValidDays){
						$successMsg = "Leave in excess of eligible leave for $emp_name has been approved.";
					}else{
						$successMsg = EMPLOYEELEAVE_LEAVE_APPROVE;
					}
				//$successMsg = EMPLOYEELEAVE_LEAVE_APPROVE;
				$sql1 = "select * from LeaveApproval WHERE LeaveId = ? and ApproverSts=3 and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $leaveid, $orgid));
				$con=$query1->rowCount();
				if($r=$query1->fetch())
				{
					/////////////////////////get next approval and send mail to them////////////////
					$approverid=$r->ApproverId;
					$approveremail=Utils::decode5t(Utils::getName($approverid ,'EmployeeMaster','CompanyEmail',$this->db));
					$leavereason="";
					$leavefrom="";
					$leaveto="";
					$fromhalfsts="";
					$tohalfsts="";
					$fromtypehalf="";
					$totypehalf="";
					$fromhalf="";
					$tohalf="";
					$leavetypeid="";
					$leavedays=0;
					$sql2 = "select * from EmployeeLeave WHERE Id = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $leaveid));
					while($r1=$query2->fetch())
					{
						$leavereason=$r1->LeaveReason;
						$leavefrom=date("d/m/Y", strtotime($r1->LeaveFrom));
						$leaveto=date("d/m/Y", strtotime($r1->LeaveTo));
						$fromhalfsts=$r1->FromDayType;
						$tohalfsts=$r1->ToDayType;
						$fromtypehalf=$r1->TimeOfFrom;
						$totypehalf=$r1->TimeOfTo;
						$leavetypeid=$r1->LeaveTypeId;
						$leavedays=$r1->LeaveValidDays;
					}
					
					if($fromhalfsts==2){
						if($fromtypehalf==1){
						$fromhalf=" (1st half)";
						}else{
							$fromhalf=" (2nd half)";
						}
					}
					if($tohalfsts==2){
						if($totypehalf==1){
							$tohalf=" (1st half)";
						}else{
							$tohalf=" (2nd half)";
						}
					}
					
					$duration="";
					if($leavefrom==$leaveto){
					$duration="$leavefrom $fromhalf";	
					}else{
					$duration=" from $leavefrom $fromhalf to $leaveto $tohalf";	
					}
					
					if($con==1){
						/////////////// FOR LAST APPROVAL,WE DON'T NEED TO SEND APPROVAL LINK, BECAUSE LAST APPROVAL WILL DISTRIBUTE THE LEAVE WHICH CAN NOT BE DONE THROUGH MAIL /////////////////
						$approverhistory="";
									$sql = "SELECT * FROM LeaveApproval WHERE OrganizationId = ? AND LeaveId = ? AND ApproverSts<>3 ";
									$query = $this->db->prepare($sql);
									$query->execute(array($orgid, $leaveid));
									$count =  $query->rowCount();
									if($count>=1){
										$approverhistory="<p><b>Approval History</b></p>
										<table border='1' style=' border-collapse: collapse;width:70%'>
										<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															
															<th>Approval Status</th>
															<th>Approver</th>
															<th>Approval Date</th>
															<th>Remarks</th>
														</tr>
										";
									}
									while($r=$query->fetch()){
										$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
										$approvalsts=$r->ApproverSts;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}elseif($approvalsts==7){
											$approvalsts="Escalated";
										}
										$approvaldate="";
										$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
										$approvercomment=$r->ApproverComment;
										$approverhistory.="<tr>
															
															<th>$approvalsts</th>
															<th>$approvername</th>
															<th>$approvaldate</th>
															<th>$approvercomment</th>
														</tr>";
									}
									if($count>=1){
										$approverhistory.="</table>";
									}
									
									///////////////////  Fetching Leave History //////////////////
									
									$leavehistory="";
									$leavehistoryarr=$this->getEmployeeAllLeaveTypeForMail($orgid,$mid,$leavetypeid);
									foreach($leavehistoryarr["data"] as $key => $value) {
										$leavetyp=$value['name'];
										$ent=$value['days'];
										$usedleave=$value['usedleave'];
										$leftleave=$value['leftleave'];
										$carryforward=$value['carryforward'];
										$leavehistory.="
										<p><b>Leave History</b></p>
												
												<table border='1' style=' border-collapse: collapse;width:70%'>
														<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															<th>Leave Type</th>
															<th>Carried Forward</th>
															<th>Leave Entitled</th>
															<th>Leave Utilized</th>
															<th>Balance Leave</th>
															
														</tr>
														<tr>
															<td><center>$leavetyp</center></td>
															<td><center>$carryforward</center></td>
															<td><center>$ent</center></td>
															<td><center>$usedleave</center></td>
															<td><center>$leftleave</center></td>
															
														</tr>
												</table><br>
										";
									}
								$title="Leave approval";
								$a="";
								if($leavebalance<$LeaveValidDays){
									$a=	"<tr><td>Note: Applied leave for $emp_name is in excess of the eligible leave. Would you like to proceed?</td></tr>";
								}
								$msg="<table>
										<tr><td>Requested by : $emp_name</td></tr>
										<tr><td>Reason for leave : $leavereason</td></tr>
										<tr><td>Duration: $duration</td></tr>
										<tr><td>Leave days :  $leavedays</td></tr>
										
										</table>
										$leavehistory
											</br>
										$approverhistory<br>
										<b>$a</b>
										<table>
										<tr><td>Thanks</td></tr></table>
								";
					}else{
							$approverhistory="";
									$sql = "SELECT * FROM LeaveApproval WHERE OrganizationId = ? AND LeaveId = ? AND ApproverSts<>3 ";
									$query = $this->db->prepare($sql);
									$query->execute(array($orgid, $leaveid));
									$count =  $query->rowCount();
									if($count>=1){
										$approverhistory="<p><b>Approval History</b></p>
										<table border='1' style=' border-collapse: collapse;width:70%'>
										<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
														
															<th>Approval Status</th>
															<th>Approver</th>
															<th>Approval Date</th>
															<th>Remarks</th>
														</tr>";
									}
									while($r=$query->fetch()){
										$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
										$approvalsts=$r->ApproverSts;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}elseif($approvalsts==7){
											$approvalsts="Escalated";
										}
										$approvaldate="";
										$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
										$approvercomment=$r->ApproverComment;
										$approverhistory.="<tr>
															
															<th>$approvalsts</th>
															<th>$approvername</th>
															<th>$approvaldate</th>
															<th>$approvercomment</th>
														</tr>";
									}
									if($count>=1){
										$approverhistory.="</table>";
									}
									
									////////  Fetching Leave History //////////////
									
									$leavehistory="";
									$leavehistoryarr=$this->getEmployeeAllLeaveTypeForMail($orgid,$mid,$leavetypeid);
									foreach($leavehistoryarr["data"] as $key => $value) {
										$leavetyp=$value['name'];
										$ent=$value['days'];
										$usedleave=$value['usedleave'];
										$leftleave=$value['leftleave'];
										$carryforward=$value['carryforward'];
										$leavehistory.="
										<p><b>Leave History</b></p>
												
												<table border='1' style=' border-collapse: collapse;width:70%'>
														<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
														<th>Leave Type</th>
														<th>Carried Forward</th>
														<th>Leave Entitled</th>
														<th>Leave Utilized</th>
														<th>Balance Leave</th>
														
														</tr>
														<tr>
														<td><center>$leavetyp</center></td>
														<td><center>$carryforward</center></td>
														<td><center>$ent</center></td>
														<td><center>$usedleave</center></td>
														<td><center>$leftleave</center></td>
														
														</tr>
												</table><br>
										";
									}
						$approvelink=URL."approvalbymail/viewapproveleaveapproval/$approverid/$orgid/$leaveid/2";
						$rejectlink=URL."approvalbymail/viewapproveleaveapproval/$approverid/$orgid/$leaveid/1";
						////////////  APPROVAL LINK /////////////////
						$title="Leave approval";
						$a="";
						if($leavebalance<$LeaveValidDays){
						$a=	"<tr><td>Note: Leave in excess of eligible leave for $emp_name has been approved.</td></tr>";
						}
						$msg="			<table>
												<tr><td>Requested by : $emp_name</td></tr>
												<tr><td>Reason for leave : $leavereason</td></tr>
												<tr><td>Duration : $duration</td></tr>
												<tr><td>Leave days :  $leavedays</td></tr>
												<tr><td colspan='2'>														
												</td></tr>														
												</table></br>
												$leavehistory
												</br>
												$approverhistory<br>
												<b>$a </b><br>
												<table>
												<tr><td><br/><br/>
																<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
																-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
																&nbsp;&nbsp;
																&nbsp;&nbsp;
																<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
																-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
																<br/><br/>
																</td>															
																</tr>	
								
											</table>";
						
					}
					//$approveremail="monika@ubitechsolutions.com";
					Utils::sendMail($approveremail,$emp_name,$title,$msg); //// sending mail to next approver
					Utils::Trace($approveremail." ".$msg);
					/////////////////////////////////////////				
				}	
				if($query1->rowCount()==0)
				{
					$sql2 = "UPDATE EmployeeLeave SET LeaveStatus =?,LeaveBreakDown=?, LastModifiedDate=?, LastModifiedById=?,ApprovedBy=? WHERE Id =? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(2,$request[5],$mdate,$mid,$mid, $leaveid));
					
					/*generate mail and alert for leave approved */
					Alerts::generateActionAlerts(52,$leaveid,$orgid,$this->db);
					
					/////////////////////sending mail to employee /////////////////////////
					
					$leavetypeid="";
					$leavedays=0;
					$sql2 = "select * from EmployeeLeave WHERE Id = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $leaveid));
					while($r1=$query2->fetch())
					{
						$leavereason=$r1->LeaveReason;
						$leavefrom=date("d/m/Y", strtotime($r1->LeaveFrom));
						$leaveto=date("d/m/Y", strtotime($r1->LeaveTo));
						$fromhalfsts=$r1->FromDayType;
						$tohalfsts=$r1->ToDayType;
						$fromtypehalf=$r1->TimeOfFrom;
						$totypehalf=$r1->TimeOfTo;
						$leavetypeid=$r1->LeaveTypeId;
						$leavedays=$r1->LeaveValidDays;
					}
					$fromhalf="";
					$tohalf="";
					if($fromhalfsts==2){
						if($fromtypehalf==1){
						$fromhalf=" (1st half)";
						}else{
							$fromhalf=" (2nd half)";
						}
					}
					if($tohalfsts==2){
						if($totypehalf==1){
							$tohalf=" (1st half)";
						}else{
							$tohalf=" (2nd half)";
						}
					}
					
					$duration="";
					if($leavefrom==$leaveto){
					$duration="$leavefrom $fromhalf";	
					}else{
					$duration=" from $leavefrom $fromhalf to $leaveto $tohalf";	
					}
					
					
						$approverhistory="";
									$sql = "SELECT * FROM LeaveApproval WHERE OrganizationId = ? AND LeaveId = ? AND ApproverSts<>3 ";
									$query = $this->db->prepare($sql);
									$query->execute(array($orgid, $leaveid));
									$count =  $query->rowCount();
									if($count>=1){
										$approverhistory="<p><b>Approval History</b></p>
										<table border='1' style=' border-collapse: collapse;width:70%'>
										<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															
															<th>Approval Status</th>
															<th>Approver</th>
															<th>Approval Date</th>
															<th>Remarks</th>
														</tr>";
									}
									while($r=$query->fetch()){
										$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
										$approvalsts=$r->ApproverSts;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}elseif($approvalsts==7){
											$approvalsts="Escalated";
										}
										$approvaldate="";
										$approvaldate=date("d/m/Y", strtotime($r->ApprovalDate));
										$approvercomment=$r->ApproverComment;
										$approverhistory.="<tr>															
															<th>$approvalsts</th>
															<th>$approvername</th>
															<th>$approvaldate</th>
															<th>$approvercomment</th>
														</tr>";
									}
									if($count>=1){
										$approverhistory.="</table>";
									}
									
									////////  Fetching Leave History //////////////
									
									$leavehistory="";
									$leavehistoryarr=$this->getEmployeeAllLeaveTypeForMail($orgid,$mid,$leavetypeid);
									foreach($leavehistoryarr["data"] as $key => $value) {
										$leavetyp=$value['name'];
										$ent=$value['days'];
										$usedleave=$value['usedleave'];
										$leftleave=$value['leftleave'];
										$carryforward=$value['carryforward'];
										$leavehistory.="
										<p><b>Leave History</b></p>
												
												<table border='1' style=' border-collapse: collapse;width:70%'>
														<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															<th>Leave Type</th>
															<th>Carried Forward</th>
															<th>Leave Entitled</th>
															<th>Leave Utilized</th>
															<th>Balance Leave</th>
															
														</tr>
														<tr>
															<td><center>$leavetyp</center></td>
															<td><center>$carryforward</center></td>
															<td><center>$ent</center></td>
															<td><center>$usedleave</center></td>
															<td><center>$leftleave</center></td>
														
														</tr>
												</table><br>
										";
									}
								
								
					
							///////////////////// ending send mail to employee //////////////////
							$title="Application for Leave is approved";
							$msg="<p>Dear $emp_name</p> <p> Your application for Leave has been approved.</p><br>";
							$msg.="<table>
										<tr><td>Reason for leave : $leavereason</td></tr>
										<tr><td>Duration: $duration</td></tr>
										<tr><td>Leave days :  $leavedays</td></tr>
										</table>
										$leavehistory
											</br>
										$approverhistory<br>
										<table>
										<tr><td>Thanks</td></tr></table>
								";
							$sts=Utils::sendMail($emp_mail,$emp_name,$title,$msg);
							Utils::Trace($emp_mail." ".$title." ".$msg);
							$sql3 = "Select * From EmployeeLeave where Id=?";
							$query3 = $this->db->prepare($sql3);
							$query3->execute(array( $leaveid ));
							while($row3 = $query3->fetch())
							{
								$from=$row3->LeaveFrom;
								$to = $row3->LeaveTo;
								$fromtype = $row3->FromDayType;
								$totype = $row3->ToDayType;
								$leavebreakdown = explode(',',$row3->LeaveBreakDown);
								$entitled=$leavebreakdown[0];
								$carryforward=$leavebreakdown[1];
								$advance=$leavebreakdown[2];
								$unpaid=$leavebreakdown[3];
								$leavecal=Utils::getName($row3->LeaveTypeId,'LeaveMaster','CarryForward',$this->db);						
								$i=0;
								while(date($from)<=date($to))
								{
									if($this->checkHoliday($from, $row3->EmployeeId,$leavecal))
									{
										$paysts = Utils::getName($row3->LeaveTypeId, "LeaveMaster", "LeavePayRule", $this->db);
										$halfday=0;
										
										/*if($paysts !=0){
											$leftleave=$this->getEmployeeLeftLeave($row3->EmployeeId,$row3->LeaveTypeId,$from);
											if($leftleave<=0)
											{
												$paysts =0;
											}
										}*/
										if($i==0)
										{
											if($fromtype ==2)
											{
												$halfday=1;
											}	
										}
										if(date($from)==date($to) && $this->checkHoliday($to, $row3->EmployeeId,$leavecal))
										{
											if($totype ==2)
											{
												$halfday=1;
												
											}	
										}
										if($this->checkHalfday($leavefrom, $empid))
										{
											$halfday=1;
										}
										////  paysts field manage full, half and no pay status and values are 1, 2, 0 respectively
										//////This calculation belongs to leave break down//////////
										
										if($entitled>0)
										{
											$e=1; $c=0; $a=0; $l=0;
											$entitled--;
											if($entitled == ".5")
												$halfday=1;
										}
										elseif($carryforward>0 )
										{
											$e=0; $c=1; $a=0; $l=0;
											$carryforward--;
											if($carryforward == ".5")
												$halfday=1;
										}
										elseif($advance>0 )
										{
											$e=0; $c=0; $a=1; $l=0;
											$advance--;
											if($advance == ".5")
												$halfday=1;
										}
										elseif($unpaid>0 )
										{
											$e=0; $c=0; $a=0; $l=1;
											$unpaid--;
											if($unpaid == ".5")
												$halfday=1;
										}
										
										$sql2 = "SELECT * from EmployeeLeaveChild  where EmployeeLeaveId =? and LeaveDay =? and LeaveTypeId=?";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array( $leaveid, $from,  $row3->LeaveTypeId));
										if($query2->rowCount()==0){
											$sql = "INSERT INTO EmployeeLeaveChild  (EmployeeLeaveId, LeaveDay, LeaveStatus, LeaveTypeId, PaySts,HalfDaySts, Entitled, CarriedForward, Advance, LossOfPay) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
											$query = $this->db->prepare($sql);
											$query->execute(array( $leaveid, $from, $row3->LeaveStatus, $row3->LeaveTypeId, $paysts,$halfday,$e,$c,$a,$l ));
										}else{
											$sql = "UPDATE EmployeeLeaveChild  set  LeaveStatus=?, PaySts=?,HalfDaySts=?, Entitled=?, CarriedForward=?, Advance=?, LossOfPay=? where EmployeeLeaveId =? and LeaveDay =? and LeaveTypeId=?";
											$query = $this->db->prepare($sql);
											$query->execute(array( $row3->LeaveStatus,  $paysts,$halfday,$e,$c,$a,$l,$leaveid, $from, $row3->LeaveTypeId ));
										}
										
									}
									$i++;
									$from = date("Y-m-d", strtotime(date($from).", +1 day"));							
								}
							}
						}
						
					   }else{  
					//////////////////////if application is rejected////////////////////////////////
					$successMsg = EMPLOYEELEAVE_LEAVE_REJECT;
					$sql1 = "UPDATE EmployeeLeave SET LeaveStatus =?, ApprovedBy=?, LastModifiedDate=?, LastModifiedById=?  WHERE Id =?";
					$query = $this->db->prepare($sql1);
					$query->execute(array(1,$mid,$mdate,$mid, $request[2]));
					
					/*generate mail and alert for leave request rejected */
					Alerts::generateActionAlerts(59,$leaveid,$orgid,$this->db);
					
					/////////////////////sending mail to employee /////////////////
						$leavedays=0;
					$sql2 = "select * from EmployeeLeave WHERE Id = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $leaveid));
					while($r1=$query2->fetch())
					{
						$leavereason=$r1->LeaveReason;
						$leavefrom=date("d/m/Y", strtotime($r1->LeaveFrom));
						$leaveto=date("d/m/Y", strtotime($r1->LeaveTo));
						$fromhalfsts=$r1->FromDayType;
						$tohalfsts=$r1->ToDayType;
						$fromtypehalf=$r1->TimeOfFrom;
						$totypehalf=$r1->TimeOfTo;
						$leavetypeid=$r1->LeaveTypeId;
						$leavedays=$r1->LeaveValidDays;
					}
					$fromhalf="";
					$tohalf="";
					if($fromhalfsts==2){
						if($fromtypehalf==1){
						$fromhalf=" (1st half)";
						}else{
							$fromhalf=" (2nd half)";
						}
					}
					if($tohalfsts==2){
						if($totypehalf==1){
							$tohalf=" (1st half)";
						}else{
							$tohalf=" (2nd half)";
						}
					}
					
					$duration="";
					if($leavefrom==$leaveto){
					$duration="$leavefrom $fromhalf";	
					}else{
					$duration=" from $leavefrom $fromhalf to $leaveto $tohalf";	
					}
					
					
					$approverhistory="";
									$sql = "SELECT * FROM LeaveApproval WHERE OrganizationId = ? AND LeaveId = ? AND ApproverSts<>3 ";
									$query = $this->db->prepare($sql);
									$query->execute(array($orgid, $leaveid));
									$count =  $query->rowCount();
									if($count>=1){
										$approverhistory="<p><b>Approval History</b></p>
										<table border='1' style=' border-collapse: collapse;width:70%'>
										<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															<th>Approval Status</th>
															<th>Approver</th>
															<th>Approval Date</th>
															<th>Remarks</th>
														</tr>";
									}
									while($r=$query->fetch()){
										$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
										$approvalsts=$r->ApproverSts;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}elseif($approvalsts==7){
											$approvalsts="Escalated";
										}
										$approvaldate="";
										$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
										$approvercomment=$r->ApproverComment;
										$approverhistory.="<tr>															
															<th>$approvalsts</th>															
															<th>$approvername</th>
															<th>$approvaldate</th>
															<th>$approvercomment</th>
														</tr>";
									}
									if($count>=1){
										$approverhistory.="</table>";
									}
									
									////////  Fetching Leave History //////////////
									
									$leavehistory="";
									$leavehistoryarr=$this->getEmployeeAllLeaveTypeForMail($orgid,$mid,$leavetypeid);
									foreach($leavehistoryarr["data"] as $key => $value) {
										$leavetyp=$value['name'];
										$ent=$value['days'];
										$usedleave=$value['usedleave'];
										$leftleave=$value['leftleave'];
										$carryforward=$value['carryforward'];
										$leavehistory.="
										<p><b>Leave History</b></p>
												
												<table border='1' style=' border-collapse: collapse;width:70%'>
														<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
															<th>Leave Type</th>
															<th>Carried Forward</th>
															<th>Leave Entitled</th>
															<th>Leave Utilized</th>
															<th>Balance Leave</th>
															
														</tr>
														<tr>
															<td><center>$leavetyp</center></td>
															<td><center>$carryforward</center></td>
															<td><center>$ent</center></td>
															<td><center>$usedleave</center></td>
															<td><center>$leftleave</center></td>
															
														</tr>
												</table><br>
										";
									}
					
					
						$title="Application for Leave is rejected";
						
						$msg="<p>Dear $emp_name</p> <p> Your application for Leave has been rejected.</p><br>";
							$msg.="<table>
										<tr><td>Reason for leave : $leavereason</td></tr>
										<tr><td>Duration: $duration</td></tr>
										<tr><td>Leave days :  $leavedays</td></tr>
										</table>
										$leavehistory
											</br>
										$approverhistory<br>
										<table>
										<tr><td>Thanks</td></tr></table>
								";
						$sts=Utils::sendMail($emp_mail,$emp_name,$title,$msg);
						Utils::Trace($emp_mail." ".$title." ".$msg);
			   }
			  
			} else {
			   $status =false;
			   	$sql1 = "select * from LeaveApproval WHERE LeaveId = ? and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $leaveid, $orgid));
				$con=$query1->rowCount();
				$ApproverSts="Marked";
				if($r=$query1->fetch()){
					$ApproverSts=$r->ApproverSts;
				}
				if($ApproverSts==1){
					$ApproverSts="Rejected";
				}
				if($ApproverSts==2){
					$ApproverSts="Approved";
				}
				
			   $errorMsg = "Leave already has been $ApproverSts";
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function ApproveTimeoff($request) { 	
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$timeoffid = $request[2];
		$mdate = date("Y-m-d");
		$sql = "UPDATE TimeoffApproval SET ApproverSts =$request[3], ApprovalDate ='$mdate', ApproverComment='$request[4]' WHERE TimeofId =$timeoffid AND ApproverId=$mid  and OrganizationId=$orgid and  ApproverSts =3 and ApprovalDate='0000-00-00 00:00:00'";
		//Utils::Trace($sql);
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array());
			$count =  $query->rowCount();		
			if ($count >= 1) {
				$empid=Utils::getName($timeoffid,'Timeoff','EmployeeId',$this->db);
                $empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Time off has been approved of $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Leave Approval", $msg, $orgid));
				$status =true;
				$successMsg="Time off has been approved";
				$empname="";
				$userid="";
				$empmail="";
				$timeoffreason="";
				$timeoffdate="";
				$fromtime="";
				$totime="";
				
				$sql3="select * from Timeoff where Id=$timeoffid";
				//Utils::Trace($sql3." ".$leaveid);
				$query3=$this->db->prepare($sql3);
				$query3->execute();
				if($row3=$query3->fetch()){
					$userid=$row3->EmployeeId;
					$timeoffreason=$row3->Reason;
					$timeoffdate=Utils::dateformatter($row3->TimeofDate);
					$fromtime=$row3->TimeFrom;
					$totime=$row3->TimeTo;
					//Utils::Trace("name and email".$emp_mail." ".$emp_name);
				}
				$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
				$empemail=Utils::decode5t(Utils::getName($userid,'EmployeeMaster','CompanyEmail',$this->db));
				///////// fetching timeoff approval history ///////////
				$approverhistory="";
				$sql = "SELECT * FROM TimeoffApproval WHERE OrganizationId = ? AND TimeofId = ? AND ApproverSts<>3 ";
				$query = $this->db->prepare($sql);
				$query->execute(array($orgid, $timeoffid));
				$count =  $query->rowCount();
				if($count>=1){
					$approverhistory="<p><b>Approval History</b></p>
					<table border='1' style=' border-collapse: collapse;width:70%'>
					<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
										
										<th>Approval Status</th>
										<th>Approver</th>
										<th>Approval Date</th>
										<th>Remarks</th>
					</tr>";
				}
				while($r=$query->fetch()){
					$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
					$approvalsts=$r->ApproverSts;
					if($approvalsts==1){
						$approvalsts="Rejected";
					}elseif($approvalsts==2){
						$approvalsts="Approved";
					}elseif($approvalsts==3){
						$approvalsts="Pending";
					}elseif($approvalsts==4){
						$approvalsts="Cancel";
					}elseif($approvalsts==5){
						$approvalsts="Withdrawn";
					}
					$approvaldate="";
					$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
					$approvercomment=$r->ApproverComment;
					$approverhistory.="<tr>
					<th>$approvalsts</th>
					<th>$approvername</th>
					<th>$approvaldate</th>
					<th>$approvercomment</th>
					</tr>";
				}
				if($count>=1){
					$approverhistory.="</table>";
				}
				if($request[3]==2){
					$sql1 = "select * from TimeoffApproval WHERE TimeofId = ? and ApproverSts=3 and OrganizationId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $timeoffid, $orgid));
					if($r=$query1->fetch())
					{				
						$nxtapproverid=$r->ApproverId;
						$approvelink=URL."approvalbymail/viewapprovetimeoffapproval/$nxtapproverid/$orgid/$timeoffid/2";
						$rejectlink=URL."approvalbymail/viewapprovetimeoffapproval/$nxtapproverid/$orgid/$timeoffid/1";
						$seniorname=Utils::getName($nxtapproverid,'EmployeeMaster','FirstName',$this->db);
						$senioremail=Utils::decode5t(Utils::getName($nxtapproverid,'EmployeeMaster','CompanyEmail',$this->db));
						$title="Timeoff approval";
						$msg="<table>
								<tr><td>Requested by: $empname</td></tr>
								<tr><td>Reason for leave: $timeoffreason</td></tr>
								<tr><td>Date: $timeoffdate</td></tr>
								<tr><td>Duration: from $fromtime to $totime</td></tr>
						</table><br>
						$approverhistory<br>
						<table>
							<tr><td><br/><br/>
							<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
							-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
							&nbsp;&nbsp;
							&nbsp;&nbsp;
							<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
							-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
							<br/><br/>
							</td></tr>	
						</table>";
						Utils::Trace($senioremail." ".$msg);
						Utils::sendMail($senioremail,$empname,$title,$msg);
					}
					if($query1->rowCount()==0){
						$sql2 = "UPDATE Timeoff SET ApprovalSts =?, ModifiedDate=?,ApproverId=?,ApproverComment=? WHERE Id =? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array(2,$mdate,$mid, $request[4],$timeoffid));
						if ($count >= 1) {
							$successMsg = "Time off application is approved successfully";
							
							/*generate mail and alert for time off approved*/
							Alerts::generateActionAlerts(53,$timeoffid,$orgid,$this->db);
							$empname="";
							$userid="";
							$empmail="";
							$timeoffreason="";
							$timeoffdate="";
							$fromtime="";
							
							$sql3="select * from Timeoff where Id=$timeoffid";
							//Utils::Trace($sql3." ".$leaveid);
							$query3=$this->db->prepare($sql3);
							$query3->execute();
							if($row3=$query3->fetch()){
								$userid=$row3->EmployeeId;
								$timeoffreason=$row3->Reason;
								$timeoffdate=Utils::dateformatter($row3->TimeofDate);
								$fromtime=$row3->TimeFrom;
								$totime=$row3->TimeTo;
								//Utils::Trace("name and email".$emp_mail." ".$emp_name);
							}
							$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
							$approverhistory="";
							$sql = "SELECT * FROM TimeoffApproval WHERE OrganizationId = ? AND TimeofId = ? AND ApproverSts<>3 ";
							$query = $this->db->prepare($sql);
							$query->execute(array($orgid, $timeoffid));
							$count =  $query->rowCount();
							if($count>=1){
								$approverhistory="<p><b>Approval History</b></p>
								<table border='1' style=' border-collapse: collapse;width:70%'>
								<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
												
													<th>Approval Status</th>
														<th>Approver</th>
													<th>Approval Date</th>
													<th>Remarks</th>
								</tr>";
							}
							while($r=$query->fetch()){
								$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
								$approvalsts=$r->ApproverSts;
								if($approvalsts==1){
									$approvalsts="Rejected";
								}elseif($approvalsts==2){
									$approvalsts="Approved";
								}elseif($approvalsts==3){
									$approvalsts="Pending";
								}elseif($approvalsts==4){
									$approvalsts="Cancel";
								}elseif($approvalsts==5){
									$approvalsts="Withdrawn";
								}
								$approvaldate="";
								$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
								$approvercomment=$r->ApproverComment;
								$approverhistory.="<tr>
								<th>$approvalsts</th>
								<th>$approvername</th>
								<th>$approvaldate</th>
								<th>$approvercomment</th>
								</tr>";
							}
							if($count>=1){
								$approverhistory.="</table>";
							}
							$title="Application for Time Off is accepted";
							$msg="Dear $empname <br> Your application for Time off is accepted.";
							$msg.="<table>
								<tr><td>Reason for leave: $timeoffreason</td></tr>
								<tr><td>Date: $timeoffdate</td></tr>
								<tr><td>Duration: from $fromtime to $totime</td></tr>
								</table><br>
								$approverhistory<br>
							<table>";
							$sts=Utils::sendMail($empemail,$empname,$title,$msg);
							if($sts){
								Utils::Trace("Mail sent successfully for time off . Tittle =$title, Message=$msg");
							}else{
								Utils::Trace("Mail sent failed for time off .Tittle =$title, Message=$msg");
							}
						}
					}
				}
				else{
					$status=true;
					$successMsg = "Time off application is rejected successfully";
					$sql1 = "UPDATE Timeoff SET ApprovalSts =?, ApproverId=?,ApproverComment=?, ModifiedDate=? WHERE Id =?";
					$query = $this->db->prepare($sql1);
					$query->execute(array(1,$mid,$request[4],$mdate,$timeoffid));
					/*generate mail and alert for time off request rejected*/
					Alerts::generateActionAlerts(60,$timeoffid,$orgid,$this->db);
					$empname="";
					$userid="";
					$empmail="";
					$timeoffreason="";
					$timeoffdate="";
					$fromtime="";
					$totime="";
					$sql3="select * from Timeoff where Id=$timeoffid";
					//Utils::Trace($sql3." ".$leaveid);
					$query3=$this->db->prepare($sql3);
					$query3->execute();
					if($row3=$query3->fetch()){
						$userid=$row3->EmployeeId;
						$timeoffreason=$row3->Reason;
						$timeoffdate=Utils::dateformatter($row3->TimeofDate);
						$fromtime=$row3->TimeFrom;
						$totime=$row3->TimeTo;
						//Utils::Trace("name and email".$emp_mail." ".$emp_name);
					}
					$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
					$approverhistory="";
					$sql = "SELECT * FROM TimeoffApproval WHERE OrganizationId = ? AND TimeofId = ? AND ApproverSts<>3 ";
					$query = $this->db->prepare($sql);
					$query->execute(array($orgid, $timeoffid));
					$count =  $query->rowCount();
					if($count>=1){
						$approverhistory="<p><b>Approval History</b></p>
						<table border='1' style=' border-collapse: collapse;width:70%'>
						<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
											
											<th>Approval Status</th>
											<th>Approver</th>
											<th>Approval Date</th>
											<th>Remarks</th>
						</tr>";
					}
					while($r=$query->fetch()){
						$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
						$approvalsts=$r->ApproverSts;
						if($approvalsts==1){
							$approvalsts="Rejected";
						}elseif($approvalsts==2){
							$approvalsts="Approved";
						}elseif($approvalsts==3){
							$approvalsts="Pending";
						}elseif($approvalsts==4){
							$approvalsts="Cancel";
						}elseif($approvalsts==5){
							$approvalsts="Withdrawn";
						}
						$approvaldate="";
						$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
						$approvercomment=$r->ApproverComment;
						$approverhistory.="<tr>
														
														<th>$approvalsts</th>
														<th>$approvername</th>
														<th>$approvaldate</th>
														<th>$approvercomment</th>
														</tr>";
					}
					if($count>=1){
						$approverhistory.="</table>";
					}
					$title="Application for Timeoff is Rejected";
					$msg="Dear $empname,<br>
						Your Application for TimeOff is Rejected.";
					$msg.="<table>
					<tr><td>Reason for leave: $timeoffreason</td></tr>
					<tr><td>Date: $timeoffdate</td></tr>
					<tr><td>Duration: from $fromtime to $totime</td></tr>
					</table><br>
					$approverhistory<br>
					<table>";
					Utils::Trace($empemail." ".$msg);
					Utils::sendMail($empemail,$empname,$title,$msg);
				}
			} else{
				$sql1 = "select * from TimeoffApproval WHERE TimeofId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $timeoffid));
				$sts=0;
				if($r=$query1->fetch()){
					$sts=$r->ApproverSts;
				}
				if($sts==1){
					$sts="rejected";
				}elseif($sts==2){
					$sts="approved";
				}else{
					$sts="answered";
				}
				$status=false;
				$errorMsg="Request already been ".$sts;
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
				Utils::Trace($errorMsg);
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }	
	
	public function ApproveJobmodification($request){ 	
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;	
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$jobid = $request[2];
		$mdate = date("Y-m-d");
		
		$sql = "UPDATE JobModificationApproval SET ApproverSts =$request[3], ApprovalDate ='$mdate', ApproverComment='$request[4]' WHERE JobId =$jobid AND ApproverId=$mid  and OrganizationId=$orgid and  ApproverSts =3 and ApprovalDate='0000-00-00 00:00:00'";
		//Utils::Trace($sql);
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array());
			$count =  $query->rowCount();		
			if ($count >= 1) {
				$empid=Utils::getName($jobid,'JobModificationMaster','EmployeeId',$this->db);
                $empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Promotion/Demotion has been approved of $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Jobmodification Approval", $msg, $orgid));
				$status =true;
				$successMsg="Promotion/Demotion has been approved";
				$empname="";
				$empid="";
				$empmail="";
				$reason="";
				$timeoffdate="";
				$PromotionType="";
				$ModifyType="";
				
				$sql3="select * from JobModificationMaster where Id=$jobid";
				//Utils::Trace($sql3." ".$leaveid);
				$query3=$this->db->prepare($sql3);
				$query3->execute();
				if($row3=$query3->fetch()){
					$empid=$row3->EmployeeId;
					$empname=Utils::getName($row3->EmployeeId,'EmployeeMaster','FirstName',$this->db);
					$username=Utils::getName($row3->CreatedById,'EmployeeMaster','FirstName',$this->db);
					$DesiId=Utils::getName($row3->EmployeeId,'EmployeeMaster','Designation',$this->db);
					$DepartiId=Utils::getName($row3->EmployeeId,'EmployeeMaster','Department',$this->db);
					$DesiName=Utils::getName($DesiId,'DesignationMaster','Name',$this->db);
					$DepartName=Utils::getName($DepartiId,'DepartmentMaster','Name',$this->db);
					
					$reason=$row3->Remarks;
					$PromotionType=$row3->PromotionType;
					$ModifyType=$row3->ModifyType;
					//Utils::Trace("name and email".$emp_mail." ".$emp_name);
				}
					//$empemail=Utils::decode5t(Utils::getName($mid,'EmployeeMaster','CompanyEmail',$this->db));
					///////// fetching timeoff approval history ///////////
					$approverhistory="";
					$sql = "SELECT * FROM JobModificationApproval WHERE OrganizationId = ? AND JobId = ? AND ApproverSts<>3 ";
					$query = $this->db->prepare($sql);
					$query->execute(array($orgid, $jobid));
					$count =  $query->rowCount();
					if($count>=1){
						$approverhistory="<p><b>Approval History</b></p>
						<table border='1' style=' border-collapse: collapse;width:70%'>
						<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
							<th>Approval Status</th>
							<th>Approver</th>
							<th>Approval Date</th>
							<th>Remarks</th>
						</tr>";
					}
					while($r=$query->fetch()){
						$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
						$approvalsts=$r->ApproverSts;
						if($approvalsts==1){
							$approvalsts="Rejected";
						}elseif($approvalsts==2){
							$approvalsts="Approved";
						}elseif($approvalsts==3){
							$approvalsts="Pending";
						}
						$approvaldate="";$Demotionhistory="";
						$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
						$approvercomment=$r->ApproverComment;
						$approverhistory.="<tr>
							<th>$approvalsts</th>
							<th>$approvername</th>
							<th>$approvaldate</th>
							<th>$approvercomment</th>
						</tr>";
					}
					if($count>=1){
						$approverhistory.="</table>";
					}
					//////Promotion/Domotion History ////////
					if($PromotionType=="1"){
						$field1="Promotion";
					}elseif($PromotionType=="2"){
						$field1="Demotion";
					}elseif($PromotionType=="3"){
						$field1="Salary Increment";
					}elseif($PromotionType=="4"){
						$field1="Salary decrement";
					}elseif($PromotionType=="5"){
						$field1="Grade Change";
					}
					$Demotionhistory="<p><b>$field1 History</b></p>
						<table border='1' style=' border-collapse: collapse;width:70%'>
						<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
						<th>Field Name</th>
						<th>Current</th>
						<th>Revised</th>
					</tr>";
					$jobsql="select * from JobModificationChild where JobId in($jobid)";
					$jobquery=$this->db->prepare($jobsql);
					$jobquery->execute();
					while($jobrow=$jobquery->fetch()){
						$field=$jobrow->FieldName;
						$oldfield=$jobrow->OldValue;
						$newfield=$jobrow->NewValue;
						if($field=="Division"){
							$oldfield = Utils::getName($jobrow->OldValue,'DivisionMaster','Name',$this->db);
							$newfield = Utils::getName($jobrow->NewValue,'DivisionMaster','Name',$this->db);
						}
						elseif($field=="Department"){
							$oldfield = Utils::getName($jobrow->OldValue,'DepartmentMaster','Name',$this->db);
							$newfield = Utils::getName($jobrow->NewValue,'DepartmentMaster','Name',$this->db);
						}elseif($field=="Designation"){
							$oldfield = Utils::getName($jobrow->OldValue,'DesignationMaster','Name',$this->db);
							$newfield = Utils::getName($jobrow->NewValue,'DesignationMaster','Name',$this->db);
						}elseif($field=="Grade"){
							$oldfield = Utils::getName($jobrow->OldValue,'GradeMaster','Name',$this->db);
							$newfield = Utils::getName($jobrow->NewValue,'GradeMaster','Name',$this->db);
						}elseif($field=="Location"){
							$oldfield = Utils::getName($jobrow->OldValue,'LocationMaster','Name',$this->db);
							$newfield = Utils::getName($jobrow->NewValue,'LocationMaster','Name',$this->db);
						}
						elseif($field=="DOC" ){
							$oldfield = Utils::dateformatter($jobrow->OldValue);
							$newfield = Utils::dateformatter($jobrow->NewValue);
						}
						$Demotionhistory.="<tr>
							<th>$field</th>
							<th>$oldfield</th>
							<th>$newfield</th>
						</tr>";	
					}
					$Demotionhistory.="</table>";
					//////End Promotion/Domotion History ////////
					if($request[3]==2){
						$sql1 = "select * from JobModificationApproval WHERE JobId = ? and ApproverSts=3 and OrganizationId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $jobid, $orgid));
						if($r=$query1->fetch()) {				
							$nxtapproverid=$r->ApproverId;
							$approvelink=URL."approvalbymail/viewapprovalpromotionapproval/$nxtapproverid/$orgid/$jobid/2";
							$rejectlink=URL."approvalbymail/viewapprovalpromotionapproval/$nxtapproverid/$orgid/$jobid/1";
							$seniorname=Utils::getName($nxtapproverid,'EmployeeMaster','FirstName',$this->db);
							$senioremail=Utils::decode5t(Utils::getName($nxtapproverid,'EmployeeMaster','CompanyEmail',$this->db));
							$title="$field1 approval";
							$msg="<span>$username has requested for <b>$field1</b>,<br>
								Details are given bellow.</span>
								<table>
									<tr><td>Employee Name: $empname</td></tr>
									<tr><td>Department: $DepartName</td></tr>
									<tr><td>Designation: $DesiName</td></tr>
									<tr><td>Remarks: $request[5]</td></tr>
								</table>
								$Demotionhistory<br>
								$approverhistory<br>
							<table>
								<tr><td><br/><br/>
								<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
								-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
								&nbsp;&nbsp;
								&nbsp;&nbsp;
								<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
								-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
								<br/><br/>
								</td></tr>	
							</table>";
							Utils::Trace($senioremail." ".$msg);
							Utils::sendMail($senioremail,$empname,$title,$msg);
						}
						if($query1->rowCount()==0){
							$sql2 = "UPDATE JobModificationMaster SET status =?, LastModifiedDate=?,LastModifiedById =? WHERE Id =? ";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array(2,$mdate,$mid, $jobid));
							if ($count >= 1) {
								$successMsg = "$field1 application is approved successfully";
							}
						}
						/*	if ($count >= 1) {
							$successMsg = "Promotion/Demotion application is approved successfully";
						
							/*generate mail and alert for time off approved*/
							/*Alerts::generateActionAlerts(53,$jobid,$orgid,$this->db);
							$empname="";
							$userid="";
							$empmail="";
							$timeoffreason="";
							$timeoffdate="";
							$fromtime="";
							$totime="";
							
							$sql3="select * from JobModificationMaster where Id=$jobid";
							//Utils::Trace($sql3." ".$leaveid);
							$query3=$this->db->prepare($sql3);
							$query3->execute();
							if($row3=$query3->fetch()){
								$empid=$row3->EmployeeId;
								$empname=Utils::getName($row3->EmployeeId,'EmployeeMaster','FirstName',$this->db);
								$DesiId=Utils::getName($row3->EmployeeId,'EmployeeMaster','Designation',$this->db);
								$DepartiId=Utils::getName($row3->EmployeeId,'EmployeeMaster','Department',$this->db);
								$DesiName=Utils::getName($DesiId,'DesignationMaster','Name',$this->db);
								$DepartName=Utils::getName($DepartiId,'DepartmentMaster','Name',$this->db);
								
								$reason=$row3->Remarks;
								$PromotionType=$row3->PromotionType;
								$ModifyType=$row3->ModifyType;
								//Utils::Trace("name and email".$emp_mail." ".$emp_name);
							}
						$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
						$approverhistory="";
						$sql = "SELECT * FROM TimeoffApproval WHERE OrganizationId = ? AND TimeofId = ? AND ApproverSts<>3 ";
						$query = $this->db->prepare($sql);
						$query->execute(array($orgid, $timeoffid));
						$count =  $query->rowCount();
						if($count>=1){
							$approverhistory="<p><b>Approval History</b></p>
							<table border='1' style=' border-collapse: collapse;width:70%'>
							<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
										
											<th>Approval Status</th>
												<th>Approver</th>
											<th>Approval Date</th>
											<th>Remarks</th>
							</tr>";
						}
						while($r=$query->fetch()){
							$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
							$approvalsts=$r->ApproverSts;
							if($approvalsts==1){
								$approvalsts="Rejected";
							}elseif($approvalsts==2){
								$approvalsts="Approved";
							}elseif($approvalsts==3){
								$approvalsts="Pending";
							}
							$approvaldate="";
							$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
							$approvercomment=$r->ApproverComment;
							$approverhistory.="<tr>
								<th>$approvalsts</th>
								<th>$approvername</th>
								<th>$approvaldate</th>
								<th>$approvercomment</th>
								</tr>";
							}
							if($count>=1){
								$approverhistory.="</table>";
							}
							$title="Application for Time Off is accepted";
							$msg="Dear $empname <br> Your application for Time off is accepted.";
							$msg.="<table>
										<tr><td>Reason for leave: $timeoffreason</td></tr>
										<tr><td>Date: $timeoffdate</td></tr>
										<tr><td>Duration: from $fromtime to $totime</td></tr>
										</table><br>
										$approverhistory<br>
										<table>";
							$sts=Utils::sendMail($empemail,$empname,$title,$msg);
							if($sts){
								Utils::Trace("Mail sent successfully for time off . Tittle =$title, Message=$msg");
							}else{
								Utils::Trace("Mail sent failed for time off .Tittle =$title, Message=$msg");
							}
						}
					}
				}else{
				   $status=true;
					$successMsg = "Promotion/Demotion application is rejected successfully";
					$sql1 = "UPDATE JobModificationApproval SET ApprovalSts =?, ApproverId=?,ApproverComment=?, ModifiedDate=? WHERE Id =?";
					$query = $this->db->prepare($sql1);
					$query->execute(array(1,$mid,$request[4],$mdate,$jobid));
					/*generate mail and alert for time off request rejected*/
						/*Alerts::generateActionAlerts(60,$timeoffid,$orgid,$this->db);
						$empname="";
						$userid="";
						$empmail="";
						$timeoffreason="";
						$timeoffdate="";
						$fromtime="";
						$totime="";
						$sql3="select * from JobModificationMaster where Id=$jobid";
						//Utils::Trace($sql3." ".$leaveid);
						$query3=$this->db->prepare($sql3);
						$query3->execute();
						if($row3=$query3->fetch()){
							$userid=$row3->EmployeeId;
							$timeoffreason=$row3->Reason;
							$timeoffdate=Utils::dateformatter($row3->TimeofDate);
							$fromtime=$row3->TimeFrom;
							$totime=$row3->TimeTo;
							//Utils::Trace("name and email".$emp_mail." ".$emp_name);
						}
						$empname=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
						$approverhistory="";
						$sql = "SELECT * FROM TimeoffApproval WHERE OrganizationId = ? AND TimeofId = ? AND ApproverSts<>3 ";
						$query = $this->db->prepare($sql);
						$query->execute(array($orgid, $timeoffid));
						$count =  $query->rowCount();
						if($count>=1){
							$approverhistory="<p><b>Approval History</b></p>
							<table border='1' style=' border-collapse: collapse;width:70%'>
							<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
								<th>Approval Status</th>
								<th>Approver</th>
								<th>Approval Date</th>
								<th>Remarks</th>
							</tr>";
						}
						while($r=$query->fetch()){
							$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
							$approvalsts=$r->ApproverSts;
							if($approvalsts==1){
								$approvalsts="Rejected";
							}elseif($approvalsts==2){
								$approvalsts="Approved";
							}elseif($approvalsts==3){
								$approvalsts="Pending";
							}
							$approvaldate="";
							$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
							$approvercomment=$r->ApproverComment;
							$approverhistory.="<tr>
								<th>$approvalsts</th>
								<th>$approvername</th>
								<th>$approvaldate</th>
								<th>$approvercomment</th>
								</tr>";
						}
						if($count>=1){
							$approverhistory.="</table>";
						}
						$title="Application for Timeoff is Rejected";
						$msg="Dear $empname,<br>
						Your Application for TimeOff is Rejected.";
						$msg.="<table>
							<tr><td>Reason for leave: $timeoffreason</td></tr>
							<tr><td>Date: $timeoffdate</td></tr>
							<tr><td>Duration: from $fromtime to $totime</td></tr>
							</table><br>
							$approverhistory<br>
							<table>";
							Utils::Trace($empemail." ".$msg);
							Utils::sendMail($empemail,$empname,$title,$msg);
					} */
					}else{
						$status=true;
						$successMsg = "$field1 application is rejected successfully";
						$sql1 = "UPDATE JobModificationMaster SET status =?, LastModifiedById=?, LastModifiedDate=? WHERE Id =?";
						$query = $this->db->prepare($sql1);
						$query->execute(array(1,$mid,$mdate,$jobid));
					}	
				}else{
					$sql1 = "select * from JobModificationApproval WHERE JobId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $jobid));
					$sts=0;
					if($r=$query1->fetch()){
						$sts=$r->ApproverSts;
					}
					if($sts==1){
						$sts="rejected";
					}elseif($sts==2){
						$sts="approved";
					}else{
						$sts="answered";
					}
					$status=false;
					$errorMsg="Request already been ".$sts;
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
				Utils::Trace($errorMsg);
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }	
	
	
	public function checkHoliday($leavefrom, $empid,$leavecal)
	{
		if($leavecal==0){
			$sql = "SELECT Id, Name FROM HolidayMaster WHERE ? between DateFrom and DateTo";
			$query = $this->db->prepare($sql);
			$query->execute(array($leavefrom ));
			if($query->rowCount()>0)
			{
				return false;
			}else{
				$sql1 = "SELECT WorkingDays FROM EmployeeMaster WHERE Id = ?";
				 $query1 = $this->db->prepare($sql1);
				 $query1->execute(array( $empid ));			
				 $row1 = $query1->fetch();
				 $workingday = $row1->WorkingDays;
				 
				$temparr = explode(',',$workingday);
				$dw = date( "w", strtotime(date($leavefrom)));
				$date = "Leave Day";
				for($i=0; $i<count($temparr); $i++)
				{
					if($dw == $i){
						if($temparr[$i]==3){
							return false;
							//break;
						}/* elseif($temparr[$i]==2){
							return false;
							break;
						} */
					}
				}			
			}
			
			return true;
		}else{
			return true;
		}
	}

	public function checkHalfday($leavefrom, $empid)
	{
		$weekno=Utils::weekOfMonth($leavefrom);
		$dayofdate= 1 + date("w", strtotime($leavefrom));
		$sql1 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=(select shift from EmployeeMaster where Id=$empid) and Day=$dayofdate";
		Utils::Trace($sql1);
		 $query1 = $this->db->prepare($sql1);
		 $query1->execute(array( $empid ));			
		 $row1 = $query1->fetch();
		 $workingday = $row1->WeekOff;
		$temparr = explode(',',$workingday);
		$dw = date( "w", strtotime(date($leavefrom)));
		$date = "Leave Day";
		if($temparr[$weekno-1]==2){
			return true;
			//break;
		}
		return false;
		
	}
	public function Forward($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$sql = "Select * FROM LeaveApproval WHERE LeaveId =? AND ApproverId = ? ";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[2], $mid));
		$count =  $query->rowCount();
		if($count >=1){
			$sql1 = "UPDATE LeaveApproval SET ApproverSts =? ,ApprovalDate =?  WHERE LeaveId =? AND ApproverId=?";
			try{
				$query = $this->db->prepare($sql1);
				$query->execute(array(2, $mdate , $request[2], $mid));
		
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		else{
			$sql = "INSERT INTO LeaveApproval ( LeaveId, ApproverId, ApproverSts, CreatedDate , ApprovalDate ,  OrganizationId) VALUES (?, ?, ?, ?, ?,?)";
		
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $mid,2, $mdate,$mdate, $orgid));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
        if ($count >= 1) {
           
		   if($request[3]!=0){
				$sql = "Select * FROM LeaveApproval WHERE LeaveId =? AND ApproverId = ? AND ApproverSts = 3";
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $request[3]));
				if($row=$query->fetch())
				{
					 $status =false;
					$errorMsg = EMPLOYEELEAVE_LEAVE_FORWARDALREADY;
				}
				else{
			   $sql = "INSERT INTO LeaveApproval ( LeaveId, ApproverId, ApproverSts, CreatedDate , ApprovalDate ,  OrganizationId) VALUES (?, ?, ?, ?, ?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($request[2], $request[3],3, $mdate,$mdate, $orgid));
			   $sql1 = "UPDATE EmployeeLeave SET LeaveStatus =? WHERE Id =? ";
			   $query = $this->db->prepare($sql1);
			   $query->execute(array(3, $request[2]));
			   $status =true;
				$successMsg = EMPLOYEELEAVE_LEAVE_FORWARD;
			   }
			}
        } else {
           $status =false;
		   $errorMsg = EMPLOYEELEAVE_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
   
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM LeaveApproval WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = LEAVE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = LEAVE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getTimeoffApproverSts($id,$userid)
	{
		$flg =false;
		$employee=0;
		$sql = "SELECT * FROM TimeoffApproval WHERE TimeofId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
				if($row->ApproverSts==3){
					$employee=$row->ApproverId;
					break;
				}
			}
			if($employee ==  $userid){
					$flg = true;
				}
		}catch(Exception $e) {
			
		}
		return $flg;
	}
	public function getApproverSts($id,$userid)
	{
		$flg =false;
		$employee=0;
		$sql = "SELECT * FROM LeaveApproval WHERE LeaveId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
				if($row->ApproverSts==3){
					$employee=$row->ApproverId;
					break;
				}
			}
			if($employee ==  $userid){
					$flg = true;
				}
		}catch(Exception $e) {
			
		}
		return $flg;
	}
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'EmployeeLeave';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId', 'LeaveFrom', 'LeaveTo', 'LeaveReason','ApplyDate' ,'LeaveStatus','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		$sOrder = "ORDER BY "; 
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			//$sOrder .= ", ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY  ApplyDate desc";
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		//$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		if($hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid ";
		}else{
			$sWhere = " WHERE OrganizationId= $orgid AND Id IN (SELECT LeaveId FROM LeaveApproval Where ApproverId=$userid )";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		
		$sQuery = "
		 SELECT SQL_CALC_FOUND_ROWS   ".str_replace(" , ", " ", implode(", ", $aColumns))."  
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
										
					$edit =""; $delete="";
					$sts=$this->getApproverSts($aRow->Id,$userid);
					if($sts && $aRow->LeaveStatus==3 ){						
						$edit = '<a rel="tooltip" title="Approve/Reject" href="'.URL.'leave/editleaveapproval/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" class="text-green"><i class="fa fa-thumbs-up"></i></a>';
					}
					
					if($hrsts==1 && $sts && $aRow->LeaveStatus==3){
						
						$edit = '<a rel="tooltip" title="Approve/Reject" href="'.URL.'leave/viewemployeeleaveapproval/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/2" ><i class="fa fa-thumbs-up"></i></a>';	
					}	
					$row[] =$edit;
					
				}
				elseif($aColumns[$i]=="LeaveStatus"){
                    
				if($aRow->{$aColumns[$i]}==3){
						$pendingapprover=$this->getApproverPendingSts($aRow->{$aColumns[6]},3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
                 }
				 elseif($aColumns[$i]=="EmployeeId"){
                    
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'leave/viewemployeeleaveapproval/'.Utils::encode5t($aRow->Id).'/1" >'.Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'</a>';
                 }
				elseif($aColumns[$i]=="ApplyDate" || $aColumns[$i]=="ResumptionDate" || $aColumns[$i]=="LeaveFrom" || $aColumns[$i]=="LeaveTo"){
					if(($aRow->{$aColumns[$i]})=="0000-00-00")
					{
						$row[]="-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getAllApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data1 = array();
		
		$orgid = $request[1];
		$leaveid = $request[2];
		
		$s1="SELECT * from LeaveApproval WHERE OrganizationId=? and LeaveId = ? and ApproverSts<>3";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $leaveid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->ApproverSts;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data[] = $res;
			
			$successMsg=""; $status=true;
		}
		
		$s1="SELECT * from LeaveApproval WHERE OrganizationId=? and LeaveId = ? ";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $leaveid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->ApproverSts;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data1[] = $res;
			
			
		}
		
		$result["data"] =$data;
		$result["allapprovers"] =$data1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getAlljobmodificationApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data1 = array();
		
		$orgid = $request[1];
		$jobid = $request[2];
		
		$s1="SELECT * from JobModificationApproval WHERE OrganizationId=? and JobId = ? and ApproverSts<>3";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $jobid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$approvalsts = $row->ApproverSts;
			if($approvalsts==1){
				$res['sts'] ="Rejected";
			}elseif($approvalsts==2){
				$res['sts']="Approved";
			}elseif($approvalsts==3){
				$res['sts']="Pending";
			}
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data[] = $res;
			
			$successMsg=""; $status=true;
		}
		
		$s1="SELECT * from JobModificationApproval WHERE OrganizationId=? and JobId = ? ";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $jobid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->ApproverSts;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data1[] = $res;
		}
		
		$result["data"] =$data;
		$result["allapprovers"] =$data1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
public function getAllTimeoffApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data1 = array();
		
		$orgid = $request[1];
		$timeoffid = $request[2];
		
		$s1="SELECT * from  TimeoffApproval WHERE OrganizationId=? and TimeofId = ? and ApproverSts<>3";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $timeoffid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->ApproverSts;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data[] = $res;
			
			$successMsg=""; $status=true;
		}
		
		$s1="SELECT * from TimeoffApproval WHERE OrganizationId=? and TimeofId = ? ";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $leaveid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->ApproverSts;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data1[] = $res;
		}
		
		$result["data"] =$data;
		$result["allapprovers"] =$data1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }	
	
	public function getEmployeeLeftLeave($mid,$leavetype,$applydate)
    {
		$orgid=$_SESSION['ubihrm_org_id'];
		$count=0; $leftleave=0;
		$leaveid=0; $result=0;
			try{
				$fiscalid = Utils::getFiscalId($applydate, $this->db);
				$employeeusedleave=0;
				$sql1 = "SELECT Id  FROM EmployeeLeave WHERE OrganizationId = ? and EmployeeId =? and LeaveTypeId=? and FiscalId =? and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $mid, $leavetype, $fiscalid));
				while($row1=$query1->fetch()){
					$leaveid.=','.$row1->Id;
				}
				$sql1 = "SELECT *  FROM LeaveMaster WHERE Id =?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $leavetype));
				while($row1=$query1->fetch()){
					$total=$row1->LeaveDays;
				}
				
					$sql = "SELECT *  FROM EmployeeLeaveChild WHERE EmployeeLeaveId in ($leaveid) and LeaveTypeId=? and Entitled=1  and LeaveStatus=2";
					$query = $this->db->prepare($sql);
					$query->execute(array( $leavetype));
					while($row1=$query->fetch())
					{
						if($row1->HalfDaySts == 1){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					}
					$leftleave = $total-$employeeusedleave;
					if($leftleave>0)
					{
						$result=$leftleave;
					}
				
				
				
		}catch(Exception $e) {
			
			$e->getMessage();
		}
		
		
		return $result;
    }
	
	public function getEmployeeAllLeaveTypeForMail($orgid,$mid,$leavetypeid) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$applydate=date('Y-m-d');
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $religion=0; $workingdays=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $religionflg=false; $halfdays=0;
		$doj=date('Y-m-d');
		$mdate=date('Y-m-d');
		try{
		$fiscalid = Utils::getFiscalId($applydate, $this->db);
		$sql1 = "SELECT *  FROM FiscalMaster WHERE Id=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $fiscalid));
		while($row1=$query1->fetch()){
			$startdate=$row1->StartDate;
			$enddate=$row1->EndDate;
		}
		$sql = "SELECT MaritalStatus, Gender, Division, Department, Designation, Grade, Religion, TotalExp,WorkingDays,DOJ FROM EmployeeMaster WHERE OrganizationId = ? and Id =?";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $mid));
		while($row = $query->fetch())
		{
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$religion=$row->Religion; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=$row->WorkingDays;
			$workingdays=substr_count($workingdays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);
			$doj=$row->DOJ;
		}
		
		$annualid =0; $annualcount =0;
		$sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() AND WorkingDays= $workingdays and AnnualLeaveSts=1 and DepartmentIds=0 and DesignationIds=0 and GenderId=0 and maritalId=0  and DivisionId=0 and GradeId=0 and ReligionId=0 and Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid, $leavetypeid));
		if($query->rowCount()>0)
		{
			while($row = $query->fetch())
			{
				$annualid =$row->Id;
			}
		}
		
        $sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and Id=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid,$leavetypeid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$divisionflg=true;
				$departmentflg=true; 
				$designationflg=true; 
				$gradeflg=true; $religionflg=true;
				$genderflg=true; $maritalflg=true;
				$carryforward=0;
				$employeeusedleave=0;
				
				if($row->LeaveUsableSts==1){
					if($row->DivisionId>0){
						if($row->DivisionId==$division){
							$divisionflg=true;
						}else{$divisionflg=false;}
					}
					if($row->DepartmentIds>0){
						if($row->DepartmentIds==$department){
							$departmentflg=true; 
						}else{$departmentflg=false; }
					}
					if($row->DesignationIds>0){
						if($row->DesignationIds==$designation){
							$designationflg=true; 
						}else{$designationflg=false; }
					}
					if($row->GenderId>0){
						if($row->GenderId==$gender){
							$genderflg=true;
						}else{$genderflg=false;}
					}
					if($row->MaritalId>0){
						if($row->MaritalId==$marital){
							$maritalflg=true;
						}else{$maritalflg=false;}
					}
					if($row->GradeId>0){
						if($row->GradeId==$grade){
							$gradeflg=true; 
						}else{$gradeflg=false; }
					}
					if($row->ReligionId>0){
						if($row->ReligionId==$religion){
							$religionflg=true; 
						}else{$religionflg=false; }
					}
				}elseif($row->LeaveUsableSts==2){
					$divisionflg=false;
					$departmentflg=false; 
					$designationflg=false; 
					$gradeflg=false; 
					$genderflg=false; $maritalflg=false;
					$religionflg=false; 
					if($row->EmployeeIds!="")
					{
						$temp = explode(",", $row->EmployeeIds);
						for($i=0; $i<count($temp); $i++)
						{
							if($mid==$temp[$i]){
								$divisionflg=true;
								$departmentflg=true; 
								$designationflg=true; 
								$gradeflg=true; $religionflg=true;
								$genderflg=true; $maritalflg=true;
								break;
							}
							
						}
					}					
				}
				$annual=true;
				if($row->AnnualLeaveSts==1){
						if($row->WorkingDays ==$workingdays){
							$annual=true;
						}else{$annual=false;}
				}
				if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg && $annual && $religionflg)
				{
					$leavealotted=$row->LeaveDays;
					$anniversaryyearsts=$row->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
					if($row->AnnualLeaveSts==1){
						$carryforward=$this->getCarryforwardleave($mid,$fiscalid);
						
						if($row->WorkingDays ==$workingdays){
							++$annualcount;
						}
						if($anniversaryyearsts == 1)
						{
							$start = strtotime($doj);
							$end = strtotime(date('Y-m-d'));
							$days_between = floor(abs($end - $start) / 86400);
							$leavealotted1=floor(($days_between * $row->LeaveDays)/365);
							$leavealotted=$leavealotted1;
							$twoyearsdays=(365*2)+30;////ADD MORE 30 DAYS,FOR TAKE ACTION ON LEAVE///	
							if($days_between < $twoyearsdays)
							{
							//////////IN THIS CASE CALCULATION BASED ON DATE OF JOINING TILL NOW/////////
								
								$startdate=$doj;
								$enddate=$mdate;
							}else{
							/////////IN THIS CASE I FIND THE ANNIVERSARY YEAR OF EMPLOYEE OF THIS YEAR,AND CALCULATE LEAVE ,ON THIS BASIS////////
							
								$start = strtotime($doj);
								$end = strtotime(date("2015-04-01"));
								if($end>$start){
									$days_between = floor(($end - $start) / 86400);
									$leavealotted1=floor(($days_between * $row->LeaveDays)/365);
									$employeeusedleave = $employeeusedleave + $leavealotted1;
								}
								
								$startdate=date("2015-04-01");
								$enddate=$mdate;
								
								
							}
							/* /////////this condition is for 30 day calendar days employees,this calculation is based on anniversary year of the joining date,ex- 10/02/2014 -10/02/2015////////
							$myear=date('Y');
							$anniversaryyear=date('m-d',strtotime(date($doj)));
							$enddate=$myear.'-'.$anniversaryyear;
							$startdate=date('Y-m-d',strtotime("- 1 year".date($enddate)));
							if(strtotime($mdate) > strtotime($enddate))
							{
								$startdate=$myear.'-'.$anniversaryyear;
								$enddate=date('Y-m-d',strtotime("+ 1 year".date($startdate)));
							} */
							
						}
						
					}
					
					
					$sql3 = "Select * from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=0 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 and empchild.Entitled=1 and empleave.LeaveTypeId=? and empchild.LeaveTypeId=?";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array($startdate, $enddate, $orgid, $mid, $row->Id,$leavetypeid,$leavetypeid));
					while($row3=$query3->fetch()){
						if($row3->HalfDaySts == 1){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					}
				
					$leftleave = $leavealotted-$employeeusedleave;
					if($leftleave>=0)
					{
						$res = array();
						$res['id'] = (int)$row->Id;
						$res['name'] = $row->Name;
						$res['days'] = (int)$leavealotted;
						$res['usedleave'] = $employeeusedleave;
						$res['leftleave'] = $leavealotted-$employeeusedleave;
						$res['carryforward'] = $carryforward;
						
						$data[] = $res;
					}
				}
				
			}
				
        }else{
			$status=true;
			$successMsg = LEAVETYPE_MODULE_GETALL;
		}
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if(count($data)>0 && $annualcount>1){
			for($i=0; $i<count($data); $i++)
			{
				if($data[$i]['id']==$annualid)
				{
					array_splice($data, $i, 1);break;
				}
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

		public function getCarryforwardleave($empid,$fiscalid)
		{
			$name ="";
			$sql = "SELECT TotalLeave FROM LeaveHistory WHERE EmployeeId = ? and FiscalId =?";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $empid ,$fiscalid));
				while($row = $query->fetch())
				{
					$name = $row->TotalLeave;
				}
			}catch(Exception $e) {
				
			}
			return $name;
		}
		/////////// to find out the previous status of leave wether it is approved or not /////////////
		public function getpreviousApprovalSts($user_id,$org_id,$employeeleaveid){
				$sql1 = "select * from LeaveApproval WHERE LeaveId =? AND ApproverId=? and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $employeeleaveid,$user_id,$org_id));
				$con=$query1->rowCount();
				$ApproverSts=3;
				if($r=$query1->fetch()){
					$ApproverSts=$r->ApproverSts;
				}
				return $ApproverSts;
		}
		/////////// to find out the previous status of time off wether it is approved or not /////////////
		public function getpreviousTimeOffApprovalSts($user_id,$org_id,$employeetimeoffid){
				$sql1 = "select * from TimeoffApproval WHERE TimeofId =? AND ApproverId=? and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $employeetimeoffid,$user_id,$org_id));
				$con=$query1->rowCount();
				$ApproverSts=3;
				if($r=$query1->fetch()){
					$ApproverSts=$r->ApproverSts;
				}
				return $ApproverSts;
		}
		/////////// to find out the previous status of Promotion/Demotion wether it is approved or not /////////////
		public function getpreviousPromotionApprovalSts($user_id,$org_id,$employeejobid){
				$sql1 = "select * from JobModificationApproval WHERE jobId =? AND ApproverId=? and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $employeejobid,$user_id,$org_id));
				$con=$query1->rowCount();
				$ApproverSts=3;
				if($r=$query1->fetch()){
					$ApproverSts=$r->ApproverSts;
				}
				return $ApproverSts;
		}
		
				//////////////////////////// to find out the approver on which the leave is pending ///////////////////////////
	
		public function getApproverPendingSts($id,$sts)
		{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM LeaveApproval where LeaveId=? and ApproverSts=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM LeaveApproval where LeaveId=? and ApproverSts=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					$name = $row->ApproverId;
				}
			}catch(Exception $e) {}

			return $name;
		}
	
	
		}
