<?php

/**
 * JobModificationModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class JobModificationModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM JobModificationMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = JOBMODIFICATION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM JobModificationMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['empid'] = (int)$row->EmployeeId;
				$res['modifytype'] = $row->ModifyType;
				$res['remarks'] = $row->Remarks;
				$res['applyfrom'] = Utils::dateformatter($row->ApplyFrom);
				$res['promotiontype'] = $row->PromotionType;
				$res['empname'] = "";;
				$res['division'] = "";
				$res['department'] = "";
				$res['designation'] = "";
				
				$empsql = "SELECT * FROM EmployeeMaster WHERE Id = ?";
				$empquery = $this->db->prepare($empsql);
				$empquery->execute(array( $row->EmployeeId ));
				while($row1 = $empquery->fetch())
				{
					
					$res['empname'] = ucwords(strtolower($row1->FirstName." ".$row1->MiddleName." ".$row1->LastName));
					$res['division'] = Utils::getName($row1->Division,'DivisionMaster','Name',$this->db);
					$res['department'] = Utils::getName($row1->Department,'DepartmentMaster','Name',$this->db);
					$res['designation'] = Utils::getName($row1->Designation,'DesignationMaster','Name',$this->db);
					
				}
				$res['jobchild'] = array();
				
				$jobsql = "SELECT * FROM JobModificationChild WHERE JobId = ?";
				$jobquery = $this->db->prepare($jobsql);
				$jobquery->execute(array( $row->Id ));
				while($row1 = $jobquery->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->Id;
						if($row1->FieldName=="Division"){
							$res1['name'] = "Division";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'DivisionMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'DivisionMaster','Name',$this->db);
						}elseif($row1->FieldName=="Department"){
							$res1['name']="Department";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'DepartmentMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'DepartmentMaster','Name',$this->db);
						}elseif($row1->FieldName=="Designation"){
							$res1['name']="Designation";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'DesignationMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'DesignationMaster','Name',$this->db);
						}elseif($row1->FieldName=="Grade"){
							$res1['name']="Grade";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'GradeMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'GradeMaster','Name',$this->db);
						}elseif($row1->FieldName=="DOL"){
							$res1['name']="Termination Date";
							$res1['oldvalue'] = Utils::dateformatter($row1->OldValue);
							$res1['newvalue'] = Utils::dateformatter($row1->NewValue);
						}elseif($row1->FieldName=="DOC"){
							$res1['name']="Confirmation Date";
							$res1['oldvalue'] = Utils::dateformatter($row1->OldValue);
							$res1['newvalue'] = Utils::dateformatter($row1->NewValue);
						}elseif($row1->FieldName=="EmployeeCTC"){
							$res1['name']="Gross Salary";
							$res1['oldvalue'] = Utils::getcurrency().' '.$row1->OldValue;
							$res1['newvalue'] = Utils::getcurrency().' '.$row1->NewValue;
						}elseif($row1->FieldName=="EmployeeStatus"){
							$res1['name']="Employee Status";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'EmploymentStatusMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'EmploymentStatusMaster','Name',$this->db);
						}elseif($row1->FieldName=="Location"){
							$res1['name']="Location";
							$res1['oldvalue'] = Utils::getName($row1->OldValue,'LocationMaster','Name',$this->db);
							$res1['newvalue'] =Utils::getName($row1->NewValue,'LocationMaster','Name',$this->db);
						}
					
					$res['jobchild'][] = $res1;
				}
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = JOBMODIFICATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = JOBMODIFICATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a JobModificationMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		$sql = "UPDATE JobModificationMaster SET EmployeeId=?, ModifyType=?, ApplyFrom=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
		$query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array($request[2], $request[3], $request[4], $orgid, $mdate, $mid, $request[5] ));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			$jobid = $request[5];
			$sqlwork = " DELETE from JobModificationChild where JobId=?";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array($jobid));
			$empsql = "SELECT * FROM EmployeeMaster where Id=?";
			$empquery = $this->db->prepare($empsql);
			$empquery->execute(array($request[2]));
			$row= $empquery->fetch();
			// INSERTING WORK EXPERIENCE RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['json'], true); 
			for($i=0; $i<count($work); $i++){
				if($work[$i]['name']!=""){
					if($work[$i]['name']=="1"){
						$field="Division";
					}elseif($work[$i]['name']=="2"){
						$field="Department";
					}elseif($work[$i]['name']=="3"){
						$field="Designation";
					}elseif($work[$i]['name']=="4"){
						$field="Grade";
					}elseif($work[$i]['name']=="5"){
						$field="Location";
					}elseif($work[$i]['name']=="6"){
						$field="DOC";
					}elseif($work[$i]['name']=="7"){
						$field="EmployeeCTC";
					}
					$record = array();
					$record[0] = $jobid;
					$record[1] = $field;
					$record[2] = $row->$field;
					if($work[$i]['name']=="6"){
						$record[3] = Utils::getDateformat($work[$i]['newvalue']);
					}else{
						$record[3] = $work[$i]['newvalue'];
					}
					$sqlwork = " INSERT INTO JobModificationChild (JobId, FieldName, OldValue, NewValue) values (?,?,?,?)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute($record);
				}
			}
			//$empid=Utils::getName($did,'GrievanceMaster','EmployeeIds',$this->db);
			$ty="Promotion/Demotion";
		   if($request[3] == 3){
			   $ty="Transfer/Relocation";
			
		   }elseif($request[3] == 2){
			   $ty="Promotion/Demotion";
		   
		   }
			$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
			$msg="$ty has been updated for $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "$ty", $msg, $orgid));
		   $status =true;
		   $successMsg = JOBMODIFICATION_MODULE_UPDATION_SUCCESS;
		} else {
		   $status =false;
		   $errorMsg = JOBMODIFICATION_MODULE_UPDATION_FAILED;
		}
		
		$_SESSION["feedback_positive"][] = "Success! We have updated your settings. Background Process can take upto 12 hours to detect changes and refresh. ubiHRM has no control over that refresh process. ";
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

    /**
     * Setter for a JobModificationMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		$userid = $_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$status=2;
		}else{
			$status=3;
		}
		$sql = "INSERT INTO JobModificationMaster (EmployeeId, ModifyType, ApplyFrom, Remarks,  OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,PromotionType,status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $request[3], Utils::getDateformat($request[4]), $request[5], $orgid, $mdate, $mid, $mdate, $mid, $mid,$request[6],$status));
			$count =  $query->rowCount();		
			if ($count == 1) {
				$jobid = $this->db->lastInsertId();
				$empsql = "SELECT * FROM EmployeeMaster where Id=?";
				$empquery = $this->db->prepare($empsql);
				$empquery->execute(array($request[2]));
				$row= $empquery->fetch();
				// INSERTING WORK EXPERIENCE RECORD OF EMPLOYEE IF PASSED AS AN JSON
				$work = json_decode($_POST['json'], true); 
				for($i=0; $i<count($work); $i++) {
					if($work[$i]['name']!=""){
						if($work[$i]['name']=="1"){
							$field="Division";
						}elseif($work[$i]['name']=="2"){
							$field="Department";
						}elseif($work[$i]['name']=="3"){
							$field="Designation";
						}elseif($work[$i]['name']=="4"){
							$field="Grade";
						}elseif($work[$i]['name']=="5"){
							$field="Location";
						}elseif($work[$i]['name']=="6"){
							$field="DOC";
						}elseif($work[$i]['name']=="7"){
							$field="EmployeeCTC";
							
							// INSERTING AND UPDATING SALARY RECORD OF EMPLOYEE IF PASSED AS AN JSON
							$salary = json_decode($_POST['emp_salarydetails'], true); 
							for($j=0; $j<count($salary); $j++)	
							{
								if($salary[$i]['name']!=""){
									$record1 = array();
									$record1[0] = $request[2];
									$record1[1] = $salary[$j]['id'];
									$record1[2] = $salary[$j]['headtype'];
									$record1[3] = $salary[$j]['amount'];
									$record1[4] = $orgid;
									$record1[5] = Utils::getDateformat($request[4]);
									
									$sqlsalary = " INSERT INTO SalaryHistory (EmployeeId, HeadId, HeadType, HeadAmount, OrganizationId,CreatedDate) values (?,?,?,?,?,?)";
									$querysalary = $this->db->prepare($sqlsalary);
									$querysalary->execute($record1);
								}
							}
						}elseif($work[$i]['name']=="8"){
							$field="EmployeeStatus";
						}
						$record = array();
						$record[0] = $jobid;
						$record[1] = $field;
						$record[2] = $row->$field;
						if($work[$i]['name']=="6" ){
						$record[3] = Utils::getDateformat($work[$i]['newvalue']);
						}else{
						$record[3] = $work[$i]['newvalue'];
						}
						$sqlwork = " INSERT INTO JobModificationChild (JobId, FieldName, OldValue, NewValue) values (?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
				$status =true; $ty="Promotion/Demotion";
			   if($request[3] == 3){
				   $ty="Transfer/Relocation";
				$successMsg = TRANSFER_MODULE_CREATION_SUCCESS;
			   }elseif($request[3] == 2){
				   $ty="Promotion/Demotion";
			    $successMsg = PROMOTION_MODULE_CREATION_SUCCESS;
			   }elseif($request[3] == 4){
			    $successMsg = TERMINATION_MODULE_CREATION_SUCCESS;
			   }
				//$empid=Utils::getName($did,'GrievanceMaster','EmployeeIds',$this->db);
				$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$DesiId=Utils::getName($request[2],'EmployeeMaster','Designation',$this->db);
				$DepartiId=Utils::getName($request[2],'EmployeeMaster','Department',$this->db);
				$DesiName=Utils::getName($DesiId,'DesignationMaster','Name',$this->db);
				$DepartName=Utils::getName($DepartiId,'DepartmentMaster','Name',$this->db);
				
				$msg="$ty has been entered for $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "$ty", $msg, $orgid));
			   
				///////Approval Follow For Promotion/Demotion////////////
				if($sts==0 && $hrsts==0){
					 $sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";
					$query = $this->db->prepare($sql);
					$query->execute(array( $orgid));
					if($r=$query->fetch()){
						$hr=$r->EmployeeId;
					}
					if($request[3]==2){
						$senior = Utils::getApprovalLevelEmp($userid, 9, $this->db);
					}elseif($request[3]==3){
						$senior = Utils::getApprovalLevelEmp($userid, 10, $this->db);
					}
						if($senior!=0)
						{
							/* $temp1 = explode(",", $senior);
							for($i=0;$i<count($temp1);$i++)
							{
								if($temp1[$i] == $hr){
									unset($temp1[$i]);
								}
							}
							$senior=implode(',',$temp1);
							if($hr !=0)
								$senior.=','.$hr; */
							$temp = explode(",", $senior);
							for($i=0; $i<count($temp); $i++){
								if($temp[$i] != 0){
									///////// fetching timeoff approval history ///////////
									$approverhistory="";$Demotionhistory="";
										$sql = "SELECT * FROM JobModificationApproval WHERE OrganizationId = ? AND JobId = ? AND ApproverSts<>3 ";
										$query = $this->db->prepare($sql);
										$query->execute(array($orgid, $jobid));
										$count =  $query->rowCount();
										if($count>=1){
											$approverhistory="<p><b>Approval History</b></p>
											<table border='1' style=' border-collapse: collapse;width:70%'>
											<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
																
																<th>Approval Status</th>
																<th>Approver</th>
																<th>Approval Date</th>
																<th>Remarks</th>
											</tr>
											";
										}
										while($r=$query->fetch()){
											$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
											$approvalsts=$r->ApproverSts;
											if($approvalsts==1){
												$approvalsts="Rejected";
											}elseif($approvalsts==2){
												$approvalsts="Approved";
											}elseif($approvalsts==3){
												$approvalsts="Pending";
											}
											$approvaldate="";
											$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
											$approvercomment=$r->ApproverComment;
											$approverhistory.="<tr>
												<th>$approvalsts</th>
												<th>$approvername</th>
												<th>$approvaldate</th>
												<th>$approvercomment</th>
												</tr>";
										}
										
										if($count>=1){
											$approverhistory.="</table>";
										}
										//////Promotion/Domotion History ////////
										if($request[3]==2){
											if($request[6]=="1"){
												$field1="Promotion";
											}elseif($request[6]=="2"){
												$field1="Demotion";
											}elseif($request[6]=="3"){
												$field1="Salary Increment";
											}elseif($request[6]=="4"){
												$field1="Salary decrement";
											}elseif($request[6]=="5"){
												$field1="Grade Change";
											}
										}elseif($request[3]==3){
											$field1="Transfer/Redesignation";
										}
										$Demotionhistory="<p><b>$field1 History</b></p>
											<table border='1' style=' border-collapse: collapse;width:70%'>
											<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
												<th>Field Name</th>
												<th>Current</th>
												<th>Revised</th>
											</tr>
											";
									$work = json_decode($_POST['json'], true); 
									$oldfield="";$newfield="";
									for($j=0; $j<count($work); $j++) {
										
										if($work[$j]['name']!=""){
											if($work[$j]['name']=="1"){
												$field="Division";
											}elseif($work[$j]['name']=="2"){
												$field="Department";
											}elseif($work[$j]['name']=="3"){
												$field="Designation";
											}elseif($work[$j]['name']=="4"){
												$field="Grade";
											}elseif($work[$j]['name']=="5"){
												$field="Location";
											}elseif($work[$j]['name']=="6"){
												$field="DOC";
											}elseif($work[$j]['name']=="7"){
												$field="EmployeeCTC";
											}elseif($work[$j]['name']=="8"){
												$field="EmployeeStatus";
											}
											//$oldfield = $row->$field;
											if($work[$j]['name']=="1"){
												$oldfield = Utils::getName($field,'DivisionMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'DivisionMaster','Name',$this->db);
											}
											elseif($work[$j]['name']=="2"){
												$oldfield = Utils::getName($field,'DepartmentMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'DepartmentMaster','Name',$this->db);
											}elseif($work[$j]['name']=="3"){
												$oldfield = Utils::getName($field,'DesignationMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'DesignationMaster','Name',$this->db);
											}elseif($work[$j]['name']=="4"){
												$oldfield = Utils::getName($field,'GradeMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'GradeMaster','Name',$this->db);
											}elseif($work[$j]['name']=="5"){
												$oldfield = Utils::getName($field,'LocationMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'LocationMaster','Name',$this->db);
											}elseif($work[$j]['name']=="6" ){
												$oldfield = $row->$field;
												$newfield = Utils::getDateformat($work[$j]['newvalue']);
											}else{
											$newfield = $work[$j]['newvalue'];
											}
											$Demotionhistory.="<tr>
												<th>$field</th>
												<th>$oldfield</th>
												<th>$newfield</th>
												
												</tr>";	
										}
									}
									$Demotionhistory.="</table>";
									$approvelink=URL."approvalbymail/viewapprovalpromotionapproval/$temp[$i]/$orgid/$jobid/2";
									$rejectlink=URL."approvalbymail/viewapprovalpromotionapproval/$temp[$i]/$orgid/$jobid/1";
									$sql = "INSERT INTO JobModificationApproval ( JobId, ApproverId, ApproverSts, CreatedDate , OrganizationId) VALUES (?, ?, ?, ?, ?)";
									$query = $this->db->prepare($sql);
									$query->execute(array($jobid, $temp[$i], 3, $mdate, $orgid));
									$username=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
									$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
									
									if($i==0)
									{
										$senioremail=Utils::decode5t(Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db));
										$title="$field1 Approval";
										$msg="<span>$username has requested for <b>$field1</b>,<br>
											Details are given bellow.</span>
											<table>
											<tr><td>Employee Name: $empname</td></tr>
											<tr><td>Department: $DepartName</td></tr>
											<tr><td>Designation: $DesiName</td></tr>
											<tr><td>Remarks: $request[5]</td></tr>
											</table>
											$Demotionhistory
											$approverhistory
											<table>
											<tr><td><br/><br/>
												<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
												-webkit-border-radius:4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
												&nbsp;&nbsp;
												&nbsp;&nbsp;
											<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
											-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
											<br/><br/>
										</td>														</tr>
														</table>";
										Utils::Trace($senioremail." ".$msg);
									//	Utils::sendMail($senioremail,$username,$title,$msg);
									}
								}
							}
						}
						else{
							$senior=Utils::getSeniorId($userid, $this->db);
							
							if($senior != $hr){
								if($hr !=0)
									$senior.=','.$hr;
							}
							$temp = explode(",", $senior);
							for($i=0; $i<count($temp); $i++)
							{
								if($temp[$i] != 0){
										///////// fetching timeoff approval history ///////////
									
									$approverhistory="";$Demotionhistory="";
										$sql = "SELECT * FROM JobModificationApproval WHERE OrganizationId = ? AND JobId = ? AND ApproverSts<>3 ";
										$query = $this->db->prepare($sql);
										$query->execute(array($orgid, $jobid));
										$count =  $query->rowCount();
										if($count>=1){
											$approverhistory="<p><b>Approval History</b></p>
											<table border='1' style=' border-collapse: collapse;width:70%'>
											<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
												<th>Approval Status</th>
												<th>Approver</th>
												<th>Approval Date</th>
												<th>Remarks</th>
											</tr>
											";
										}
										while($r=$query->fetch()){
											$approvername=Utils::getEmployeeName($r->ApproverId,$this->db);
											$approvalsts=$r->ApproverSts;
											if($approvalsts==1){
												$approvalsts="Rejected";
											}elseif($approvalsts==2){
												$approvalsts="Approved";
											}elseif($approvalsts==3){
												$approvalsts="Pending";
											}
											$approvaldate="";
											$approvaldate=Utils::datetimeformatter($r->ApprovalDate);
											$approvercomment=$r->ApproverComment;
											$approverhistory.="<tr>
																
																<th>$approvalsts</th>
																<th>$approvername</th>
																<th>$approvaldate</th>
																<th>$approvercomment</th>
															</tr>";
										}
										
										if($count>=1){
											$approverhistory.="</table>";
										}
									//////Promotion/Domotion History ////////
										if($request[3]==2){
											if($request[6]=="1"){
												$field1="Promotion";
											}elseif($request[6]=="2"){
												$field1="Demotion";
											}elseif($request[6]=="3"){
												$field1="Salary Increment";
											}elseif($request[6]=="4"){
												$field1="Salary decrement";
											}elseif($request[6]=="5"){
												$field1="Grade Change";
											}
										}elseif($request[3]==3){
											$field1="Transfer/Redesignation";
										}
										$Demotionhistory="<p><b>$field1 History</b></p>
											<table border='1' style=' border-collapse: collapse;width:70%'>
											<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
												<th>Field Name</th>
												<th>Current</th>
												<th>Revised</th>
											</tr>
											";
								for($j=0; $j<count($work); $j++) {
										
										if($work[$j]['name']!=""){
											if($work[$j]['name']=="1"){
												$field="Division";
											}elseif($work[$j]['name']=="2"){
												$field="Department";
											}elseif($work[$j]['name']=="3"){
												$field="Designation";
											}elseif($work[$j]['name']=="4"){
												$field="Grade";
											}elseif($work[$j]['name']=="5"){
												$field="Location";
											}elseif($work[$j]['name']=="6"){
												$field="DOC";
											}elseif($work[$j]['name']=="7"){
												$field="EmployeeCTC";
											}elseif($work[$j]['name']=="8"){
												$field="EmployeeStatus";
											}
											//$oldfield = $row->$field;
											if($work[$j]['name']=="1"){
												$oldfield = Utils::getName($row->$field,'DivisionMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'DivisionMaster','Name',$this->db);
											}
											elseif($work[$j]['name']=="2"){
												$oldfield = Utils::getName($row->$field,'DepartmentMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'DepartmentMaster','Name',$this->db);
											}elseif($work[$j]['name']=="3"){
												$oldfield = Utils::getName($row->$field,'DesignationMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'DesignationMaster','Name',$this->db);
											}elseif($work[$j]['name']=="4"){
												$oldfield = Utils::getName($row->$field,'GradeMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'GradeMaster','Name',$this->db);
											}elseif($work[$j]['name']=="5"){
												$oldfield = Utils::getName($row->$field,'LocationMaster','Name',$this->db);
												$newfield = Utils::getName($work[$j]['newvalue'],'LocationMaster','Name',$this->db);
											}elseif($work[$j]['name']=="6" ){
												$oldfield = $row->$field;
												$newfield = Utils::getDateformat($work[$j]['newvalue']);
											}else{
											$newfield = $work[$j]['newvalue'];
											}
											$Demotionhistory.="<tr>
												<th>$field</th>
												<th>$oldfield</th>
												<th>$newfield</th>
												
												</tr>";	
										}
									}
									$Demotionhistory.="</table>";
									$approvelink=URL."approvalbymail/viewapprovalpromotionapproval/$temp[$i]/$orgid/$jobid/2";
									$rejectlink=URL."approvalbymail/viewapprovalpromotionapproval/$temp[$i]/$orgid/$jobid/1";
									$sql = "INSERT INTO JobModificationApproval ( JobId, ApproverId, ApproverSts, CreatedDate , OrganizationId) VALUES (?, ?, ?, ?, ?)";
									$query = $this->db->prepare($sql);
									$query->execute(array($jobid, $temp[$i], 3, $mdate, $orgid));
									$username=Utils::getName($userid,'EmployeeMaster','FirstName',$this->db);
									$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
									
									if($i==0)
									{
										$senioremail=Utils::decode5t(Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db));
										$title="$field1 Approval";
										$msg="<span>$username has requested for <b>$field1</b>,<br>
											Details are given bellow.</span>
											<table>
											<tr><td>Employee Name: $empname</td></tr>
											<tr><td>Department: $DepartName</td></tr>
											<tr><td>Designation: $DesiName</td></tr>
											<tr><td>Remarks: $request[5]</td></tr>
											</table>
											$Demotionhistory
											$approverhistory
											<table>
											<tr><td><br/><br/>
												<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
												-webkit-border-radius:4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
												&nbsp;&nbsp;
												&nbsp;&nbsp;
											<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
											-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
											<br/><br/>
										</td>														</tr>
														</table>";
										Utils::Trace($senioremail." ".$msg);
									//	Utils::sendMail($senioremail,$username,$title,$msg);
									}
								}
							}
						}
					
				}	
			} else {
			   $status =false;
			   $errorMsg = JOBMODIFICATION_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$_SESSION["feedback_positive"][] = "Success! We have updated your settings. Background Process can take upto 12 hours to detect changes and refresh. ubiHRM has no control over that refresh process. ";	
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		 // default return
        return $result;
    }
	/**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$empid=Utils::getName($did,'JobModificationMaster','EmployeeId',$this->db);
		$type=Utils::getName($did,'JobModificationMaster','ModifyType',$this->db);
		$ty="Transfer/Relocation";
		if($type == 3){
		   $ty="Transfer/Relocation";
		$successMsg = TRANSFER_MODULE_CREATION_SUCCESS;
	   }elseif($type == 2){
		   $ty="Promotion/Demotion";
	   } 
		$sql = "DELETE FROM JobModificationChild WHERE JobId = :id ";		
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		$sql = "DELETE FROM JobModificationMaster WHERE Id = :id ";		
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="$ty has been deleted of $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "$ty", $msg, $orgid));
           $status =true;
		   $successMsg = JOBMODIFICATION_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = JOBMODIFICATION_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = ucwords(strtolower($row->FirstName." ".$row->LastName));
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getValue($id,$val)
	{
		$field='NewValue';
		if($val==1)
		{
			$field='OldValue';
		}
		$name ="";
		$sql = "SELECT * FROM JobModificationChild WHERE JobId = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row1 = $query->fetch())
			{
				if($row1->FieldName=="Division"){
					$name = Utils::getName($row1->$field,'DivisionMaster','Name',$this->db);
					break;
				}elseif($row1->FieldName=="Department"){
					$name = Utils::getName($row1->$field,'DepartmentMaster','Name',$this->db);
					break;
				}elseif($row1->FieldName=="Designation"){
					$name = Utils::getName($row1->$field,'DesignationMaster','Name',$this->db);
					break;
				}elseif($row1->FieldName=="Grade"){
					$name = Utils::getName($row1->$field,'GradeMaster','Name',$this->db);
					break;
				}elseif($row1->FieldName=="EmployeeCTC"){
					$name = Utils::getcurrency().' '.$row1->$field;
					break;
				}elseif($row1->FieldName=="Location"){
					$name = Utils::getName($row1->$field,'LocationMaster','Name',$this->db);
					break;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	public function getDataTable($editper, $deleteper, $id)
	{
		$sTable = 'JobModificationMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','ApplySts','ApplySts',  'ApplyFrom', 'Remarks','status', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid and ModifyType=$id and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) ";
		}
		else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " WHERE  OrganizationId= $orgid and ModifyType=$id AND (EmployeeId in ($ids) OR EmployeeId =$userid) and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";$approval="";
					if($editper){
						$edit = '<a rel="tooltip" title="View" href="'.URL.'employee/editjobmodification/'.Utils::encode5t($aRow->{$aColumns[$i]})."/".$id.'" ><i class="fa fa-eye"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to View"><i class="fa fa-eye"></i></a>';
					}
					if($editper && ($hrsts==1 || $sts==1)){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" title="Delete"><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
					$sts=$this->getApproverSts($aRow->Id,$userid);
					if($sts && $aRow->status==3 )
					{						
						$approval = '<a rel="tooltip" title="Approve/Reject" href="'.URL.'employee/editjobmodification/'.Utils::encode5t($aRow->{$aColumns[$i]})."/".$id.'/1" class="text-green"><i class="fa fa-thumbs-up"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;';
					}
					if($hrsts==1 && $sts && $aRow->status==3){
						$approval = '<a rel="tooltip" title="Approve/Reject" href="'.URL.'employee/editjobmodification/'.Utils::encode5t($aRow->{$aColumns[$i]})."/".$id.'/2" ><i class="fa fa-thumbs-up"></i></a> &nbsp;&nbsp;|&nbsp;&nbsp;';	
					}						
					$row[] =$approval.$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="status"){
				if($aRow->{$aColumns[$i]}==3)
				{
						$pendingapprover=$this->getApproverPendingSts($aRow->{$aColumns[6]},3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
				}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
                 }
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'employee/editjobmodification/'.Utils::encode5t($aRow->Id)."/".$id.'" >'.$this->getName($aRow->{$aColumns[$i]}).'</a>';
					
				}else if($aColumns[$i]=="ModifyType")
				{
					$row[] = ($aRow->{$aColumns[$i]}==1)?"Promotion":"Demotion";					
				}else if($aColumns[$i]=="ApplySts" && $i==1)
				{
					$row[] = $this->getValue($aRow->Id,1);					
				}
				else if($aColumns[$i]=="ApplySts" && $i==2)
				{
					$row[] = $this->getValue($aRow->Id,2);					
				}
				else if($aColumns[$i]=="ApplyFrom" || $aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});				
				}
				else if($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'EmployeeMaster','FirstName',$this->db);
					
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getApproverSts($id,$userid)
	{
		$flg =false;
		$employee=0;
		$sql = "SELECT * FROM JobModificationApproval WHERE JobId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
				if($row->ApproverSts==3){
					$employee=$row->ApproverId;
					break;
				}
			}
			if($employee ==  $userid){
					$flg = true;
				}
		}catch(Exception $e) {
			
		}
		return $flg;
	}
	public function getApproverPendingSts($id,$sts)
		{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM JobModificationApproval where jobId=? and ApproverSts=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM JobModificationApproval where jobId=? and ApproverSts=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					$name = $row->ApproverId;
				}
			}catch(Exception $e) {}

			return $name;
		}
	
}
	
	