<?php

/**
 * ImportwizardModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ImportwizardModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

	public function getFileHeaders($request)
	{
		try
		{
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$file_name = "";
			
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				//$ext = end((explode(".", $file_name))); 
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				$storage_name="newjoining.$ext";
					if (!file_exists("public/uploads/$orgid/")) {
						mkdir("public/uploads/$orgid/", 0777);
						}
					//echo	
					$a=file_exists("public/uploads/$orgid/$storage_name");
				if ($a)
				{ //echo 'sdfv';
					unlink("public/uploads/$orgid/$storage_name"); 
				}

				$file_size =$_FILES['file0']['size'];
				$file_tmp =$_FILES['file0']['tmp_name'];
				$file_type=$_FILES['file0']['type'];   
				$location="public/uploads/$orgid/";
				if($file_size > 2097152){
				$errors[]='File size must be less than 2 MB';
				}	
				
				if(empty($errors)==true){
				
					move_uploaded_file($file_tmp, $location.$storage_name );
					
				}else{
					print_r($errors);
				}
			}		
		//$actual_date = "candidate_details_".$_REQUEST['org_id'];
		//$org_id = isset($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
		//$fileName=isset ($_REQUEST['fileName'])	? $_REQUEST['fileName'] : '';
		$ext = pathinfo($file_name, PATHINFO_EXTENSION);
		if ($ext=='csv'){
		
			$fp = $location.$storage_name;
			
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				$row = 1;
				$ind=1;
				$arrData 		= array();
				while (($data = fgetcsv($handle, 5000, ",")) !== FALSE) 
				{
					
					if($row == 1)
					{
						for($i = 0 ; $i<count($data);$i++)
						{
							
							$record 	= array();				
							
							$record['head_name'] = $data[$i];
							
							$record['rows'] = $count;
							$record['column_index'] = (int)$count;
							$record['sts'] = true;
							$count++;
							
							$arrData[] = $record;			
						}
									
						$row++;
						
					}
				}
				
				
				if ($count >= 1) {
				   $status =true;
				   
				} 
				else {
				   $status =false;
				   $errorMsg = EMPLOYEE_MODULE_CREATION_FAILED;
				}
				$result["data"] =$arrData;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;
				return $result;
			}
		} 
		else if (strpos('xls',$ext)!==false || strpos('xlsx',$ext)!==false){
			
				$result['status']=false;
				$result['errorMsg']="Invalid File Type";
				return $result;
				
			/* require_once  LIBS_PATH.'ExcelClasses/PHPExcel/IOFactory.php';
			
			if ($ext=='xls'){
				$objReader = PHPExcel_IOFactory::createReader('Excel5');
			}else if($ext=='xlsx'){ 
				$objReader = PHPExcel_IOFactory::createReader('Excel2007');
			}
			 $objReader->setReadDataOnly(true); $objPHPExcel = $objReader->load($location.$file_name.".".$ext);
			 $objWorksheet = $objPHPExcel->getActiveSheet(); 
			 foreach ($objWorksheet->getRowIterator() as $row) 
			 {
				 $cellIterator = $row->getCellIterator(); 
				 $cellIterator->setIterateOnlyExistingCells(false); 
				 $count = 0;
					$record 						= array();				
					$record['head_name'] = "None";
					$record['name'] = '';
					$record['type'] = '';
					$record['data_label'] = '';
					$record['rows'] = $count;
					$record['h_count'] = $count;
					$record['sts'] = true;
					$arrData[] = $record;
					
				 foreach ($cellIterator as $cell) 
				 {
					
					$record = array();				
							
					$record['head_name'] = $cell->getValue();
					$record['name'] = '';
					$record['type'] = '';
					$record['data_label'] = '';
					$record['rows'] = $count;
					$record['h_count'] = $count;
					$record['sts'] = true;
					$count++;
					$arrData[] = $record;
				 } 
				 
				  array_pop($arrData);
				 break;
			 }
				
				
				return $result; */
		}
			}catch(Exception $e){
				Utils::Trace($e->getMessage());
			}
	}
	
	
	  public function insertDivisionFileHeaders($request)
    {
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$div_name = $request[2];
		$div_code = $request[3];
		$contact_person = $request[4];
		$contact_number = $request[5];
		$email = $request[6];
		$address = $request[7];
		$country = $request[8];
	//	$city = $request[9];
		//$known_lang = $request[9];
		//$zipcode = $request[10];
		$short_name = $request[9];
		
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$i=0;
			
				
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
							$sql = "SELECT * FROM DivisionMaster WHERE Code = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$div_code],$orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
							   	/////// checking Country Master
								
									$sql11 = "SELECT * FROM CountryMaster WHERE Name = ?";
								$query11 = $this->db->prepare($sql11);
							
							
								$query11->execute(array($data[$country]));
								if($row11=$query11->fetch())
								{
									$data[$country]=$row11->Id;
								}else{
									$data[$country]=0;
								}
							 if($data[$div_name]!=""){  
							 $sql1 = "UPDATE DivisionMaster SET  Name=?,  ContactPerson=?, ContactNumber=?, Email=?, Address=?, CountryId=?, ShortName=? WHERE Code=? and OrganizationId=?";
								try{
									
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$div_name],$data[$contact_person],$data[$contact_number],$data[$email],$data[$address],$data[$country],$data[$short_name],$data[$div_code],$orgid));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								} else{
									$status =true;
								   
								$c1++;
								}
							}
							}
							else{
								
									/////// checking Country Master
								
									$sql11 = "SELECT * FROM CountryMaster WHERE Name = ?";
								$query11 = $this->db->prepare($sql11);
							
							
								$query11->execute(array($data[$country]));
								if($row11=$query11->fetch())
								{
									$data[$country]=$row11->Id;
								}else{
									$data[$country]=0;
								}
								
								
								if($data[$div_name]!=""){
								// SQL Query to insert data into DataBase
								$sql1 = "INSERT INTO DivisionMaster ( Name, Code, ContactPerson, ContactNumber, Email, Address, CountryId, ShortName,OrganizationId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";		
								try{
									
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$div_name], $data[$div_code],$data[$contact_person],$data[$contact_number],$data[$email],$data[$address],$data[$country],$data[$short_name],$orgid));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								} 
								}
							}
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatdiv"] =$c;
		$result["importdiv"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
		 public function insertDepartmentFileHeaders($request)
		{
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$dept_code = $request[2];
		$dept_name = $request[3];
				
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
				            
							$sql = "SELECT * FROM DepartmentMaster WHERE (Name=? || Code=?) and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array(ltrim($data[$dept_name]), $data[$dept_code], $orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
							  // SQL Query to insert data into DataBase
							  if($data[$dept_name]!=""){
								$sql1 = "UPDATE DepartmentMaster SET Name=? WHERE Code=? AND OrganizationId=?";
								try{
									
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$dept_name], $data[$dept_code], $orgid));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								}else{
									$status =true;
								   
								   $c1++;
								} 
							  }
							}
							else{
								// SQL Query to insert data into DataBase
								 if($data[$dept_name]!=""){
								$sql1 = "INSERT INTO DepartmentMaster ( Name, Code,OrganizationId) VALUES (?, ?, ?)";		
								try{
									
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$dept_name], $data[$dept_code],$orgid));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								} 
								 }
							}
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatdep"] =$c;
		$result["importdep"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
			  public function insertGradeFileHeaders($request)
		{
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$grade_code = $request[2];
		$grade_name = $request[3];
		$grade_desc = $request[4];
				
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
							$sql = "SELECT * FROM GradeMaster WHERE  Name=? || Code = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$grade_name],$data[$grade_code],$orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
							   // SQL Query to insert data into DataBase
							   if($data[$grade_name]!=""){
								   
								
								$sql1 = "UPDATE GradeMaster SET  Name=?, Description=? WHERE Code=?  AND OrganizationId=?";		
								try{
									
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$grade_name],$data[$grade_desc], $data[$grade_code],$orgid));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								} else{
									 $status =true;
								   
								   $c1++;
								}
							   }
							}
							else{
								
							
								// SQL Query to insert data into DataBase
								if($data[$grade_name]!=""){
								$sql1 = "INSERT INTO GradeMaster ( Name, Code,Description,OrganizationId) VALUES (?, ?, ?, ?)";		
								try{
									
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$grade_name], $data[$grade_code],$data[$grade_desc],$orgid));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								} 
								}
							}
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatgrade"] =$c;
		$result["importgrade"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	  public function insertLocationFileHeaders($request)
		{
		$result = array();
		$count=0;$count1=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$loc_countryid = $request[2];
		//$loc_cityid = $request[3];
		$loc_address = $request[3];
		$loc_landmark = $request[4];
		$loc_zipcode = $request[5];		
		$loc_name = $request[6];	
			$loc_code = $request[7];	
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
							$sql = "SELECT * FROM LocationMaster WHERE Code = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$loc_code],$orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
						/////// checking Country Master
								
									$sql11 = "SELECT * FROM CountryMaster WHERE Name = ?";
								$query11 = $this->db->prepare($sql11);
							
							
								$query11->execute(array($data[$loc_countryid]));
								if($row11=$query11->fetch())
								{
									$data[$loc_countryid]=$row11->Id;
								}else{
									$data[$loc_countryid]=0;
								}
								if($loc_name!= '')
								{
									if($data[$loc_name] != '')
									{
										$data[$loc_name] = $data[$loc_name];
									}
								}
								else{
									$data[$loc_name] = "";
								}
								if($loc_landmark!= '')
								{
									if($data[$loc_landmark] != '')
									{
										$data[$loc_landmark] = $data[$loc_landmark];
									}
								}
								else{
									$data[$loc_landmark] = "";
								}
								if($loc_address!= '')
								{
									if($data[$loc_address] != '')
									{
										$data[$loc_address] = $data[$loc_address];
									}
								}
								else{
									$data[$loc_address] = "";
								}
								if($loc_zipcode!= '')
								{
									if($data[$loc_zipcode] != '')
									{
										$data[$loc_zipcode] = $data[$loc_zipcode];
									}
								}
								else{
									$data[$loc_zipcode] = "" ;
								}
								if($loc_code!= '')
								{
									if($data[$loc_code] != '')
									{
										$data[$loc_code] = $data[$loc_code];
									}
								}
								else{
									$data[$loc_code] = "" ;
								}
								// SQL Query to insert data into DataBase
								if($data[$loc_name]!=""){
									$sql1 = "UPDATE LocationMaster SET Name=?,CountryId=?,Address=?,Landmark=?,ZipCode=? WHERE  Code=? and OrganizationId=? ";
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$loc_name],$data[$loc_countryid], $data[$loc_address],$data[$loc_landmark],$data[$loc_zipcode],$data[$loc_code],$orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} else{
										$status =true;
									   
									   $c1++;
									}
								}
						
							}else{
								
								/////// checking Country Master
								
									$sql11 = "SELECT * FROM CountryMaster WHERE Name = ?";
								$query11 = $this->db->prepare($sql11);
							
							
								$query11->execute(array($data[$loc_countryid]));
								if($row11=$query11->fetch())
								{
									$data[$loc_countryid]=$row11->Id;
								}else{
									$data[$loc_countryid]=0;
								}
								if($loc_name!= '')
								{
									if($data[$loc_name] != '')
									{
										$data[$loc_name] = $data[$loc_name];
									}
								}
								else{
									$data[$loc_name] = "";
								}
								if($loc_landmark!= '')
								{
									if($data[$loc_landmark] != '')
									{
										$data[$loc_landmark] = $data[$loc_landmark];
									}
								}
								else{
									$data[$loc_landmark] = "";
								}
								if($loc_address!= '')
								{
									if($data[$loc_address] != '')
									{
										$data[$loc_address] = $data[$loc_address];
									}
								}
								else{
									$data[$loc_address] = "";
								}
								if($loc_zipcode!= '')
								{
									if($data[$loc_zipcode] != '')
									{
										$data[$loc_zipcode] = $data[$loc_zipcode];
									}
								}
								else{
									$data[$loc_zipcode] = "" ;
								}
								if($loc_code!= '')
								{
									if($data[$loc_code] != '')
									{
										$data[$loc_code] = $data[$loc_code];
									}
								}
								else{
									$data[$loc_code] = "" ;
								}
								// SQL Query to insert data into DataBase
								if($data[$loc_name]!=""){
									$sql1 = "INSERT INTO LocationMaster (Code, Name,CountryId,Address,Landmark,ZipCode,OrganizationId) VALUES (?, ?, ?,?,?,?,?)";		
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$loc_code],$data[$loc_name],$data[$loc_countryid], $data[$loc_address],$data[$loc_landmark],$data[$loc_zipcode],$orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} 
								}
							}
							
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatloc"] =$c;
		$result["importloc"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
		  public function insertDocumentFileHeaders($request)
		{
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$doc_name = $request[2];	
		$doc_code = $request[3];	
		$doc_type = $request[4];	
		$issue_date = $request[5];	
		$expiry_date = $request[6];	
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
							$sql = "SELECT * FROM DocumentMaster WHERE Code = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$doc_code],$orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
					
								// SQL Query to insert data into DataBase
								if($data[$doc_name]!="")
								{
									$sql1 = "UPDATE DocumentMaster SET Name=?,issuedate=?,expiredate=?,DocType=? WHERE  Code=? and OrganizationId=? ";
									try
									{
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$doc_name],$data[$issue_date],$data[$expiry_date],$data[$doc_type],$data[$doc_code],$orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} else{
										$status =true;
									   
									   $c1++;
									}
								}
						
							}else{
								
								// SQL Query to insert data into DataBase
								if($data[$doc_name]!=""){
									$sql1 = "INSERT INTO DocumentMaster (Code, Name,OrganizationId,DocType,issuedate,expiredate) VALUES (?, ?, ?, ?,?,?)";		
									try{
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$doc_code],$data[$doc_name],$orgid,$data[$doc_type],$data[$issue_date],$data[$expiry_date]));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} 
								}
							}
							
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatdoc"] =$c;
		$result["importdoc"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	 public function insertBankFileHeaders($request)
		{
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$bank_name = $request[2];	
			$bank_code = $request[3];	
			$bank_desc = $request[4];	
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
							$sql = "SELECT * FROM BankMaster WHERE Code = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$bank_code],$orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
					
								// SQL Query to insert data into DataBase
								if($data[$bank_name]!=""){
									$sql1 = "UPDATE BankMaster SET Name=?,Description=? WHERE  Code=? and OrganizationId=? ";
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$bank_name],$data[$bank_desc],$data[$bank_code],$orgid));
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} else{
										 $status =true;
									   
									   $c1++;
									}
								}
						
							}else{
								// SQL Query to insert data into DataBase
								if($data[$bank_name]!=""){
									$sql1 = "INSERT INTO BankMaster (Code, Name,Description,OrganizationId) VALUES (?, ?,?,?)";		
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$bank_code],$data[$bank_name],$data[$bank_desc],$orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} 
								}
							}
							
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatbank"] =$c;
		$result["importbank"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function insertDesignationFileHeaders($request)
		{
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$desi_name = $request[2];	
			$desi_code = $request[3];	
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					if($i>0)
					{ 
							$sql = "SELECT * FROM DesignationMaster WHERE (Name=? or Code = ?) and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$desi_name],$data[$desi_code],$orgid));
					
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
					
								// SQL Query to insert data into DataBase
								if($data[$desi_name]!=""){
									$sql1 = "UPDATE DesignationMaster SET Name=? WHERE Code=? and OrganizationId=? ";
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$desi_name], $data[$desi_code],$orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} else{
										$status =true;
									   
									   $c1++;
									}
								}
						
							}else{
								// SQL Query to insert data into DataBase
								if($data[$desi_name]!=""){
									$sql1 = "INSERT INTO DesignationMaster (Code, Name,OrganizationId) VALUES (?, ?, ?)";		
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$desi_code],$data[$desi_name],$orgid));
					
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} 
								}
							}
							
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatdesi"] =$c;
		$result["importdesi"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function insertEmployeeTypeFileHeaders($request)
		{
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$emp_code = $request[2];
		$emp_type = $request[3];
		
				
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
							$sql = "SELECT * FROM EmploymentTypeMaster WHERE Code = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$emp_code],$orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
							 // SQL Query to insert data into DataBase
							 	if($data[$emp_type]!=""){
									$sql1 = "UPDATE EmploymentTypeMaster SET Name=? WHERE Code=? AND OrganizationId=?";
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$emp_type], $data[$emp_code],$orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} else{
										
										$status =true;
									   
									   $c1++;
									}
								}
							}
							else{
								// SQL Query to insert data into DataBase
								if($data[$emp_type]!=""){
									$sql1 = "INSERT INTO EmploymentTypeMaster ( Name, Code,OrganizationId) VALUES (?, ?, ?)";		
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$emp_type], $data[$emp_code],$orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} 
								}
							}
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeattype"] =$c;
		$result["importtype"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
		public function insertFunctionalAreaFileHeaders($request)
		{
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$functional_area = $request[2];
		
		
				
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
			
			
			while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
							
						
							$sql = "SELECT * FROM FunctionalAreaMaster WHERE Name = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$functional_area],$orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							   
							   $status =true;
							   $c++;
								$errorMsg = DIVISION_MODULE_UPDATION_DUPLICATE;
							}
						
						else{
								// SQL Query to insert data into DataBase
								if($data[$functional_area]!=""){
									$sql1 = "INSERT INTO FunctionalAreaMaster ( Name,OrganizationId) VALUES (?, ?)";		
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$functional_area], $orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									}
								}								
						}
						
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatfunc"] =$c;
		$result["importfunc"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function insertShiftFileHeaders($request)
		{
		$result = array();
		$count1=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$shift = $request[2];
		$timein = $request[3];
		$timeout =$request[4];
		$timeingrace = $request[5];
		$timeoutgrace = $request[6];
		$timeinbreak = $request[7];
		$timeoutbreak = $request[8];
		$breakingrace = $request[9];
		$breakoutgrace = $request[10];
		//date("H:i", strtotime($request[11]));
				
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
						$sql = "SELECT * FROM ShiftMaster WHERE Name = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($data[$shift],$orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
							
								// SQL Query to insert data into DataBase
								if($data[$shift]!=""){
									$sql1 = "UPDATE ShiftMaster SET TimeIn=?,TimeOut=?,TimeInGrace=?,TimeOutGrace=?,TimeInBreak=?,TimeOutBreak=?,BreakInGrace=?,BreakOutGrace=? WHERE Name=? and OrganizationId=?";		
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array(date("H:i", strtotime($data[$timein])),date("H:i", strtotime($data[$timeout])),date("H:i", strtotime($data[$timeingrace])),date("H:i", strtotime($data[$timeoutgrace])),date("H:i", strtotime($data[$timeinbreak])),date("H:i", strtotime($data[$timeoutbreak])),date("H:i", strtotime($data[$breakingrace])),date("H:i", strtotime($data[$breakoutgrace])),$data[$shift], $orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} 	else{
										 $status =true;
									   
									   $c1++;
										
									}						
								}
							}
						else{
								// SQL Query to insert data into DataBase
								if($data[$shift]!=""){
									$sql1 = "INSERT INTO ShiftMaster ( Name,TimeIn,TimeOut,TimeInGrace,TimeOutGrace,TimeInBreak,TimeOutBreak,BreakInGrace,BreakOutGrace,OrganizationId) VALUES (?, ?,?,?,?,?,?,?,?,?)";		
									try{
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$shift],date("H:i", strtotime($data[$timein])),date("H:i", strtotime($data[$timeout])),date("H:i", strtotime($data[$timeingrace])),date("H:i", strtotime($data[$timeoutgrace])),date("H:i", strtotime($data[$timeinbreak])),date("H:i", strtotime($data[$timeoutbreak])),date("H:i", strtotime($data[$breakingrace])),date("H:i", strtotime($data[$breakoutgrace])), $orgid));
									
										$count1 =  $query1->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count1 >= 1) {
									   $status =true;
									   
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									} 
								}
						}
						
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatshift"] =$c;
		$result["importshift"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	/////////////////changed on 3 sep 2018 by monika///////////////
	
	  public function insertEmployeeFileHeadersBak($request)
    {
		
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$fname = $request[2];
		$lname = $request[3];
		$dob = $request[4];
		$nat = $request[5];
		$marital = $request[6];
		$religion = $request[7];
		$bloodgrp = $request[8];
		//$known_lang = $request[9];
		$doj = $request[9];
		$doc = $request[10];
		$gender = $request[11];
		$contact_no = $request[12];
		$email = $request[13];
		$address = $request[14];
		//$city = $request[15];
		$country = $request[15];
		$zipcode = $request[16];
		$mname= $request[17];
		$empctc= $request[18];
		$division=$request[19];
		$grade=$request[20];
		$location_code=$request[21];
		$employment_type=$request[22];
		$functional_area_code=$request[23];
		$shift_code=$request[24];
		$department=$request[25];
		$emp_code=$request[26];
		$designation=$request[27];
		$b_code=$request[28];
		$b_acc_no=$request[29];
		$personal_no=$request[30];
		$emp_sts=$request[31];
		$dol=$request[32];
		$maxid=$this->getMaxEmpid($orgid);
		$employeecode="E".$maxid;
		$bank_id=0;
		//Utils::Trace($email);
		$branch="";
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		if (($handle = fopen($fp, "r")) !== FALSE) 
		{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
							if($i>0)
							{ 
							if($data[$emp_code]==""){
							$maxid=$this->getMaxEmpid($orgid);
							$employeecode="E".$maxid;
							$data[$emp_code]=$employeecode;
							}
							//Utils::Trace("This is Emp_code ".$data[$emp_code]);
							$sql = "SELECT * FROM EmployeeMaster WHERE EmployeeCode=? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							$query->execute(array($data[$emp_code],$orgid));
							if (($query->rowcount())>0) {
							   	/////// checking department code
								$sql2 = "SELECT * FROM DepartmentMaster WHERE Name = ? and OrganizationId=?";
								$query2 = $this->db->prepare($sql2);
								$query2->execute(array($data[$department],$orgid));
								if($row2=$query2->fetch())
								{
									$data[$department]=$row2->Id;
								}else{
									$data[$department]=0;
								}
								
								/////// checking division code
								$sql3 = "SELECT * FROM DivisionMaster WHERE Name = ? and OrganizationId=?";
								$query3 = $this->db->prepare($sql3);
								$query3->execute(array($data[$division],$orgid));
								if($row3=$query3->fetch())
								{
									$data[$division]=$row3->Id;
								}else{
									$data[$division]=0;
								}
								/////// checking grade code/////
								$sql4 = "SELECT * FROM GradeMaster WHERE Name = ? and OrganizationId=?";
								$query4 = $this->db->prepare($sql4);
							
							
								$query4->execute(array($data[$grade],$orgid));
								if($row4=$query4->fetch())
								{
									$data[$grade]=$row4->Id;
								}else{
									$data[$grade]=0;
								}
								
									/////// checking location code
								$sql5 = "SELECT * FROM LocationMaster WHERE Name = ? and OrganizationId=?";
								$query5 = $this->db->prepare($sql5);
							
							
								$query5->execute(array($data[$location_code],$orgid));
								if($row5=$query5->fetch())
								{
									$data[$location_code]=$row5->Id;
								}else{
									$data[$location_code]=0;
								}
								
								
								
								
								
								/////// checking Employment Type code
								$sql7 = "SELECT * FROM EmploymentTypeMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array($data[$employment_type],$orgid));
								//Utils::Trace($data[$employment_type]);
								if($row7=$query7->fetch())
								{
									$data[$employment_type]=$row7->Id;
									
								}else{
									$data[$employment_type]=0;
								}
							//	Utils::Trace($data[$employment_type]);
								/////// checking Functional Area Master code
								$sql7 = "SELECT * FROM FunctionalAreaMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array($data[$functional_area_code],$orgid));
								if($row7=$query7->fetch())
								{
									$data[$functional_area_code]=$row7->Id;
								}else{
									$data[$functional_area_code]=0;
								}
								
								
								/////// checking Shift Code
								
									$sql8 = "SELECT * FROM ShiftMaster WHERE Name = ? and OrganizationId=?";
								$query8 = $this->db->prepare($sql8);
							
						//	Utils::Trace($data[$shift_code]);
								$query8->execute(array($data[$shift_code],$orgid));
								if($row8=$query8->fetch())
								{
									$data[$shift_code]=$row8->Id;
								}else{
									$data[$shift_code]=0;
								}
								//	Utils::Trace($data[$shift_code]);
								
								
								/////// checking Blood Group Code
								
									$sql9 = "SELECT * FROM BloodGroupMaster WHERE Name = ?";
								$query9 = $this->db->prepare($sql9);
							
							
								$query9->execute(array($data[$bloodgrp]));
								if($row9=$query9->fetch())
								{
									$data[$bloodgrp]=$row9->Id;
								}else{
									$data[$bloodgrp]=0;
								}
								
								/////// checking Nationality Master
								
									$sql10 = "SELECT * FROM NationalityMaster WHERE Name = ?";
								$query10 = $this->db->prepare($sql10);
							
								//Utils::Trace($data[$nat]);
								$query10->execute(array($data[$nat]));
								if($row10=$query10->fetch())
								{
									$data[$nat]=$row10->Id;
								}else{
									$data[$nat]=0;
								}
								//	Utils::Trace($data[$nat]);
								
								
								/////// checking Country Master
								
									$sql11 = "SELECT * FROM CountryMaster WHERE Name = ?";
								$query11 = $this->db->prepare($sql11);
							
							
								$query11->execute(array($data[$country]));
								if($row11=$query11->fetch())
								{
									$data[$country]=$row11->Id;
								}else{
									$data[$country]=0;
								}
								
								
									/////// checking Religion Master
								
									$sql12 = "SELECT * FROM ReligionMaster WHERE Name = ?";
								$query12 = $this->db->prepare($sql12);
							
							
								$query12->execute(array($data[$religion]));
								if($row12=$query12->fetch())
								{
									$data[$religion]=$row12->Id;
								}else{
									$data[$religion]=0;
								}
								
									/////// checking Desination Code
								
									$sql13 = "SELECT * FROM DesignationMaster WHERE Name = ? and OrganizationId=?";
								$query13 = $this->db->prepare($sql13);
							
							
								$query13->execute(array($data[$designation],$orgid));
								if($row13=$query13->fetch())
								{
									$data[$designation]=$row13->Id;
								}else{
									$data[$designation]=0;
								}
								
								  /////// checking bank code
								$sql14 = "SELECT * FROM BankMaster WHERE Name = ? and OrganizationId=?";
								$query14 = $this->db->prepare($sql14);
								$query14->execute(array($data[$b_code],$orgid));
								if($row14=$query14->fetch())
								{
									$bank_id=$row14->Id;
									$branch=$row14->Description;
								}else{
									$bank_id=0;
									$branch="";
								}
							
								
								if($data[$dob]!=""){
								$data[$dob]=Utils::getDateformat($data[$dob],'dd-mm-yyyy');
								}else{
									$data[$dob]="0000-00-00";
								}
								if($data[$doj]!=""){
								$data[$doj]=Utils::getDateformat($data[$doj],'dd-mm-yyyy');
								}else{
									$data[$doj]="0000-00-00";
								}
								if($data[$doc]!=""){
								$data[$doc]=Utils::getDateformat($data[$doc],'dd-mm-yyyy');
								}else{
									$data[$doc]="0000-00-00";
								}
								$count1 = 0;
								if($data[$fname] != "" && $data[$email] != ""){
								
									// SQL Query to insert data into DataBase
									$sql1 = "UPDATE EmployeeMaster SET FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?,  DOJ=?,DOC=?, Gender=?,CurrentContactNumber=?, PersonalNo=?, CompanyEmail=?, CurrentEmailId=?,EmergencyEmailId=?,HomeEmailId=?,CurrentAddress=?, CurrentCountry=?, CurrentZipCode=?,  CreatedDate=?, MiddleName=?, EmployeeCTC=?,Division=?,Grade=?,Department=?,Location=?,Shift=?,FunctionalArea=?,EmploymentType=?,Designation=?,EmployeeStatus=?,DOL=? WHERE EmployeeCode=? and  OrganizationId=?";
							
									
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$fname], $data[$lname],$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doc],$data[$gender],Utils::encode5t($data[$contact_no]),Utils::encode5t($data[$personal_no]),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(strtolower($data[$email])),Utils::encode5t($data[$address]),$data[$country],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts],$data[$dol],$data[$emp_code],$orgid));
									
									$count1 =  $query1->rowCount();		
									//Utils::Trace("this is insert part");
									
									
								}
								if ($count1 == 1) {
									
									  /////// checking Employee code
									$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
									$query16 = $this->db->prepare($sql16);
									$query16->execute(array($data[$emp_code],$orgid));
									if($row16=$query16->fetch())
									{
										$data[$emp_code]=$row16->Id;
											
									}else{
										$data[$emp_code]=0;
									}
									
								     $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
									$query15 = $this->db->prepare($sql15);
									$query15->execute(array($data[$emp_code],$bank_id));
									
									if (($query15->rowcount())>0) {
											$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array(Utils::encode5t($data[$b_acc_no]),Utils::encode5t($data[$b_code]),Utils::encode5t($branch),$data[$emp_code],$bank_id));
									}else{
									$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array($data[$emp_code],$bank_id,Utils::encode5t($data[$b_code]),Utils::encode5t($branch), Utils::encode5t($data[$b_acc_no])));
									}
									
									
									/////////////////////////////////////////////////
									/////// checking user master//////
									/////////////////////////////////////////////////
													
									
								     $sql15 = "SELECT * FROM UserMaster WHERE EmployeeId=? or Username=?";
									$query15 = $this->db->prepare($sql15);
									$query15->execute(array($data[$emp_code],Utils::encode5t(strtolower($data[$email]))));
									
									if (($query15->rowcount())>0) {
											/* $sql17 = "UPDATE UserMaster SET Password=?,Username=?,VisibleSts=? WHERE EmployeeId=? and OrganizationId=?";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid)); */
									}else{
									$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId) VALUES (?, ?,?,?, ?)";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid));
									}
									
									$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
									$queryseq = $this->db->prepare($sqlseq);
									$queryseq->execute(array($maxid,$orgid));
									
									
								   $status =true;
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								   
								   
								   
								}else{
									
									  /////// checking Employee code
									$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
									$query16 = $this->db->prepare($sql16);
									$query16->execute(array($data[$emp_code],$orgid));
									if($row16=$query16->fetch())
									{
										$data[$emp_code]=$row16->Id;
											
									}else{
										$data[$emp_code]=0;
									}
									
								     $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
									$query15 = $this->db->prepare($sql15);
									$query15->execute(array($data[$emp_code],$bank_id));
									
									if (($query15->rowcount())>0) {
											$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array(Utils::encode5t($data[$b_acc_no]),Utils::encode5t($data[$b_code]),Utils::encode5t($branch),$data[$emp_code],$bank_id));
									}else{
									$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array($data[$emp_code],$bank_id,Utils::encode5t($data[$b_code]),Utils::encode5t($branch), Utils::encode5t($data[$b_acc_no])));
									}
									
										/////////////////////////////////////////////////
									/////// checking user master//////
									/////////////////////////////////////////////////
									$orgname=Utils::getName($orgid, "Organization", "Name", $this->db);
									$orgname = substr($orgname, 0, 3);	
									$orgname = strtoupper($orgname);
									$password=$orgname."123";	
									
									if (strpos($data[$email], '@') !== false) {
										$sql15 = "SELECT * FROM UserMaster WHERE EmployeeId=? and OrganizationId=?";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array($data[$emp_code],$orgid));
										
										if (($query15->rowcount())>0) {
												$sql17 = "UPDATE UserMaster SET Password=?,Username=?,VisibleSts=? WHERE EmployeeId=? and OrganizationId=?";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(Utils::encode5t($password),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid));
										}else{
											$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId) VALUES (?, ?,?,?, ?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t($password),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid));
										}
									}
									
									 $status =true;
								   
									  $c1++;
									
								}
								
								
								
								
								
								
							}
							else{
								/////// checking department code
								$sql2 = "SELECT * FROM DepartmentMaster WHERE Name = ? and OrganizationId=?";
								$query2 = $this->db->prepare($sql2);
							
							
								$query2->execute(array($data[$department],$orgid));
								if($row2=$query2->fetch())
								{
									$data[$department]=$row2->Id;
								}else{
									$data[$department]=0;
								}
								
								/////// checking division code
								$sql3 = "SELECT * FROM DivisionMaster WHERE Name = ? and OrganizationId=?";
								$query3 = $this->db->prepare($sql3);
							
							
								$query3->execute(array($data[$division],$orgid));
								if($row3=$query3->fetch())
								{
									$data[$division]=$row3->Id;
								}else{
									$data[$division]=0;
								}
							
							
									/////// checking grade code
								$sql4 = "SELECT * FROM GradeMaster WHERE Name = ? and OrganizationId=?";
								$query4 = $this->db->prepare($sql4);
							
							
								$query4->execute(array($data[$grade],$orgid));
								if($row4=$query4->fetch())
								{
									$data[$grade]=$row4->Id;
								}else{
									$data[$grade]=0;
								}
								
									/////// checking location code
								$sql5 = "SELECT * FROM LocationMaster WHERE Name = ? and OrganizationId=?";
								$query5 = $this->db->prepare($sql5);
							
							
								$query5->execute(array($data[$location_code],$orgid));
								if($row5=$query5->fetch())
								{
									$data[$location_code]=$row5->Id;
								}else{
									$data[$location_code]=0;
								}
								
								
								
								
								
								/////// checking Employment Type code
								$sql7 = "SELECT * FROM EmploymentTypeMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array($data[$employment_type],$orgid));
								if($row7=$query7->fetch())
								{
									$data[$employment_type]=$row7->Id;
								}else{
									$data[$employment_type]=0;
								}
								
								/////// checking Functional Area Master code
								$sql7 = "SELECT * FROM FunctionalAreaMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array($data[$functional_area_code],$orgid));
								if($row7=$query7->fetch())
								{
									$data[$functional_area_code]=$row7->Id;
								}else{
									$data[$functional_area_code]=0;
								}
								
								
								/////// checking Shift Code
								
									$sql8 = "SELECT * FROM ShiftMaster WHERE Name = ? and OrganizationId=?";
								$query8 = $this->db->prepare($sql8);
							
						//	Utils::Trace($data[$shift_code]);
								$query8->execute(array($data[$shift_code],$orgid));
								if($row8=$query8->fetch())
								{
									$data[$shift_code]=$row8->Id;
								}else{
									$data[$shift_code]=0;
								}
									//Utils::Trace($data[$shift_code]);
								
								/////// checking Blood Group Code
								
									$sql9 = "SELECT * FROM BloodGroupMaster WHERE Name = ?";
								$query9 = $this->db->prepare($sql9);
							
							
								$query9->execute(array($data[$bloodgrp]));
								if($row9=$query9->fetch())
								{
									$data[$bloodgrp]=$row9->Id;
								}else{
									$data[$bloodgrp]=0;
								}
								
								/////// checking Nationality Master
								
									$sql10 = "SELECT * FROM NationalityMaster WHERE Name = ?";
								$query10 = $this->db->prepare($sql10);
							
							
								$query10->execute(array($data[$nat]));
								if($row10=$query10->fetch())
								{
									$data[$nat]=$row10->Id;
								}else{
									$data[$nat]=0;
								}
								
								
								
								/////// checking Country Master
								
									$sql11 = "SELECT * FROM CountryMaster WHERE Name = ?";
								$query11 = $this->db->prepare($sql11);
							
							
								$query11->execute(array($data[$country]));
								if($row11=$query11->fetch())
								{
									$data[$country]=$row11->Id;
								}else{
									$data[$country]=0;
								}
								
								
									/////// checking Religion Master
								
									$sql12 = "SELECT * FROM ReligionMaster WHERE Name = ?";
								$query12 = $this->db->prepare($sql12);
							
							
								$query12->execute(array($data[$religion]));
								if($row12=$query12->fetch())
								{
									$data[$religion]=$row12->Id;
								}else{
									$data[$religion]=0;
								}
								
									/////// checking Desination Code
								
									$sql13 = "SELECT * FROM DesignationMaster WHERE Name = ? and OrganizationId=?";
								$query13 = $this->db->prepare($sql13);
							
							
								$query13->execute(array($data[$designation],$orgid));
								if($row13=$query13->fetch())
								{
									$data[$designation]=$row13->Id;
								}else{
									$data[$designation]=0;
								}
								
								  /////// checking bank code
								$sql14 = "SELECT * FROM BankMaster WHERE Code = ? and OrganizationId=?";
								$query14 = $this->db->prepare($sql14);
								$query14->execute(array($data[$b_code],$orgid));
								if($row14=$query14->fetch())
								{
									$bank_id=$row14->Id;
									$branch=$row14->Description;
								}else{
									$bank_id=0;
									$branch="";
								}
							//	Utils::Trace($branch);
								
								
							
								
								if($data[$dob]!=""){
								$data[$dob]=Utils::getDateformat($data[$dob],'dd-mm-yyyy');
								}else{
									$data[$dob]="0000-00-00";
								}
								if($data[$doj]!=""){
								$data[$doj]=Utils::getDateformat($data[$doj],'dd-mm-yyyy');
								}else{
									$data[$doj]="0000-00-00";
								}
								if($data[$doc]!=""){
								$data[$doc]=Utils::getDateformat($data[$doc],'dd-mm-yyyy');
								}else{
									$data[$doc]="0000-00-00";
								}
								if($data[$dol]!=""){
								//$data[$dol]=Utils::getDateformat($data[$dol],'dd-mm-yyyy');
								}else{
									$data[$dol]="0000-00-00";
								}
								$count1 = 0;
								if($data[$fname] != "" && $data[$email] != ""){
									// SQL Query to insert data into DataBase
									$sql1 = "INSERT INTO EmployeeMaster (EmployeeCode, FirstName, LastName, DOB, Nationality, MaritalStatus, Religion, BloodGroup,  DOJ,DOC,   Gender, CurrentContactNumber,PersonalNo, CompanyEmail,CurrentEmailId,EmergencyEmailId,HomeEmailId, CurrentAddress, CurrentCountry, CurrentZipCode,  CreatedDate, MiddleName, EmployeeCTC,OrganizationId,Division,Grade,Department,Location,Shift,FunctionalArea,EmploymentType,Designation,EmployeeStatus,DOL) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";		
								
								
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$emp_code],$data[$fname], $data[$lname],$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doj],$data[$gender],Utils::encode5t($data[$contact_no]),Utils::encode5t($data[$personal_no]),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(strtolower($data[$email])),Utils::encode5t($data[$address]),$data[$country],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$orgid,$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts],$data[$dol]));
									
									$count1 =  $query1->rowCount();		
									//Utils::Trace("this is insert part");
								}
							
								if ($count1 == 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								    /////// checking Employee code
									
									$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
									$query16 = $this->db->prepare($sql16);
									$query16->execute(array($data[$emp_code],$orgid));
									if($row16=$query16->fetch())
									{
										$data[$emp_code]=$row16->Id;
											
									}else{
										$data[$emp_code]=0;
									}
									
								     $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
									$query15 = $this->db->prepare($sql15);
									$query15->execute(array($data[$emp_code],$bank_id));
									
									if (($query15->rowcount())>0) {
											$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array(Utils::encode5t($data[$b_acc_no]),Utils::encode5t($data[$b_code]),Utils::encode5t($branch),$data[$emp_code],$bank_id));
									}else{
									$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array($data[$emp_code],$bank_id,Utils::encode5t($data[$b_code]),Utils::encode5t($branch), Utils::encode5t($data[$b_acc_no])));
									}
									
									
										/////////////////////////////////////////////////
									/////// checking user master//////
									/////////////////////////////////////////////////
													
									
								     $sql15 = "SELECT * FROM UserMaster WHERE EmployeeId=? and OrganizationId=?";
									$query15 = $this->db->prepare($sql15);
									$query15->execute(array($data[$emp_code],$orgid));
									
									if (($query15->rowcount())>0) {
											$sql17 = "UPDATE UserMaster SET Password=?,Username=?,VisibleSts=? WHERE EmployeeId=? and OrganizationId=?";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid));
									}else{
									$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId) VALUES (?, ?,?,?, ?)";		
									$query17 = $this->db->prepare($sql17);
									$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid));
									}
									
									$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
									$queryseq = $this->db->prepare($sqlseq);
									$queryseq->execute(array($maxid,$orgid));
									
								} 
							}
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatemp"] =$c;
		$result["importemp"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	////////////////////// IN THIS FUNCTION WE ARE IMPORTING EMPLOYEES FILE,ALONG WITH ALL THE DATA///////////////
	
	public function insertEmployeeFileHeaders($request)
    {
		
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$fname = $request[2];
		$lname = $request[3];
		$dob = $request[4];
		$nat = $request[5];
		$marital = $request[6];
		$religion = $request[7];
		$bloodgrp = $request[8];
		//$known_lang = $request[9];
		$doj = $request[9];
		$doc = $request[10];
		$gender = $request[11];
		$contact_no = $request[12];
		$email = $request[13];
		$address = $request[14];
		//$city = $request[15];
		$country = $request[15];
		$zipcode = $request[16];
		$mname= $request[17];
		$empctc= $request[18];
		$division=$request[19];
		$grade=$request[20];
		$location_code=$request[21];
		$employment_type=$request[22];
		$functional_area_code=$request[23];
		$shift_code=$request[24];
		$department=$request[25];
		$emp_code=$request[26];
		$designation=$request[27];
		$b_code=$request[28];
		$b_acc_no=$request[29];
		$emp_uniq_pid=$request[30];
		$emp_sts=$request[31];
		$dol=$request[32];
		$uid_no=$request[33];
		$file_no=$request[34];
		//$emp_uniq_pid=$request[35];
		$visa_type=$request[35];
		$visa_category=$request[36];
		$cocenter=$request[37];
		
		$maxid=$this->getMaxEmpid($orgid);
		$employeecode="E".$maxid;
		$bank_id=0;
		//Utils::Trace($email);
		$branch="";
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		$q=0;
		
		if (($handle = fopen($fp, "r")) !== FALSE) 
		{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						if($i>0)
						{ 
							////////////IF THERE IS NO EMPLOYEE CODE IN CSV FILE THEN WE HAVE TO CHECK EMPLOYEE ACCORDING TO EMAIL ID///
							//echo $data[$doj];
							if($data[$emp_code]=="")
							{
								$maxid=$this->getMaxEmpid($orgid);
								 $divcode=0;
								$sqldiv="SELECT Code FROM DivisionMaster WHERE Name =?";	
								$querydiv = $this->db->prepare($sqldiv);
								$querydiv->execute(array(trim($data[$division])));
								while($rowdiv = $querydiv->fetch()){
									if($rowdiv->Code!=''){
									$divcode=strtoupper($rowdiv->Code);
									}
									
									else{
										$Orgname=Utils::getName($orgid, "Organization", "Name", $this->db);
									$divcode=strtoupper(substr($Orgname, 0, 3));
									}
									
								} 
								
								//$doj=Utils::getDateformat($data[$doj]);					
								$doj1=$data[$doj];					
								$yearofjoining=date("y", strtotime(date($doj1)));
								$employeecode="E".$maxid;
								$ecode=$divcode.$yearofjoining;	
							
								$employeecode=$this->CheckexistingEmpcode($ecode,$request[1]);
								$data[$emp_code]=$employeecode;
								$t=Utils::encode5t(str_replace(' ','',strtolower(trim($data[$email]))));
								$sql = "SELECT * FROM EmployeeMaster WHERE CompanyEmail='$t' and OrganizationId=$orgid";
								$query = $this->db->prepare($sql);
								$query->execute(array());
								$swhr="AND CompanyEmail=?";
								$field=Utils::encode5t(str_replace(' ','',strtolower(trim($data[$email]))));
								
								/* $e=Utils::encode5t($data[$personal_no]);
								$d=Utils::encode5t(str_replace(' ','',strtolower($data[$email])));
								
								$swhr1="WHERE ( CompanyEmail='$d')"; */
								
							}
							else{
								///////// IF THERE IS EMPLOYEE CODE MENTIONED IN FILE THEN WE HAVE TO CHECK IT ACCORDING TO EMPLOYEE CODE/////////
								//echo "sssss";
								$sql = "SELECT * FROM EmployeeMaster WHERE EmployeeCode=? and OrganizationId=?";
								$query = $this->db->prepare($sql);
								$query->execute(array($data[$emp_code],$orgid));
								$swhr="AND EmployeeCode=?";
								$field=$data[$emp_code];
								
								/* $a=Utils::encode5t(str_replace(' ','',strtolower($data[$email])));
								$b=Utils::encode5t($data[$personal_no]);
								
								$swhr1="WHERE (CompanyEmail='$a')";
								//$field1=$a." , ".$b;
								 */
								
							}
							//Utils::Trace("This is Emp_code ".$data[$emp_code]);
							 
							if (($query->rowcount())>0) 
							{
							   	/////// checking department code
								
								$sql2 = "SELECT * FROM DepartmentMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query2 = $this->db->prepare($sql2);
								$query2->execute(array(trim($data[$department]),$data[$department],$orgid));
								if($row2=$query2->fetch())
								{
									$data[$department]=$row2->Id;
								}else{
									if($data[$department] != ""){
										$code=substr(trim($data[$department]), 0, 3);
										$divcode=strtoupper($code."".mt_rand(1,1000));
										$sql2 = "INSERT INTO DepartmentMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$department]),$divcode,$mdate,$orgid));
										$data[$department]=$this->db->lastInsertId();
									}else{
										$data[$department]=0;
									}
									
								}
								
								/////// checking division code
								$sql3 = "SELECT * FROM DivisionMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query3 = $this->db->prepare($sql3);
								$query3->execute(array(trim($data[$division]),trim($data[$division]),$orgid));
								if($row3=$query3->fetch())
								{
									$data[$division]=$row3->Id;
								}else{
									if($data[$division] != ""){
										$code=substr(trim($data[$division]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO DivisionMaster (Name,Code,ShortName,CreatedDate, OrganizationId) values (?,?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$division]),$divcode,$divcode,$mdate,$orgid));
										$data[$division]=$this->db->lastInsertId();
									}else{
										$data[$division]=0;
									}
								}
								/////// checking grade code/////
								$sql4 = "SELECT * FROM GradeMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query4 = $this->db->prepare($sql4);
							
							
								$query4->execute(array(trim($data[$grade]),trim($data[$grade]),$orgid));
								if($row4=$query4->fetch())
								{
									$data[$grade]=$row4->Id;
								}else{
									if($data[$grade] != ""){
										$code=substr(trim($data[$grade]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO GradeMaster (Name,Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$grade]),$divcode,$mdate,$orgid));
										$data[$grade]=$this->db->lastInsertId();
									}else{
										$data[$grade]=0;
									}
								}
								
									/////// checking location code
								$sql5 = "SELECT * FROM LocationMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query5 = $this->db->prepare($sql5);
							
							
								$query5->execute(array(trim($data[$location_code]),trim($data[$location_code]),$orgid));
								if($row5=$query5->fetch())
								{
									$data[$location_code]=$row5->Id;
								}else{
									if($data[$location_code] != ""){
										$code=substr(trim($data[$location_code]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO LocationMaster (Name, Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$location_code]),$divcode,$mdate,$orgid));
										$data[$location_code]=$this->db->lastInsertId();
									}else{
										$data[$location_code]=0;
									}
								}
								
								/////// checking Employment Type code
								$sql7 = "SELECT * FROM EmploymentTypeMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array(trim($data[$employment_type]),$data[$employment_type],$orgid));
								//Utils::Trace($data[$employment_type]);
								if($row7=$query7->fetch())
								{
									$data[$employment_type]=$row7->Id;
									
								}else{
									if($data[$employment_type] != ""){
										$code=substr(trim($data[$employment_type]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO EmploymentTypeMaster (Name, Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$employment_type]),$divcode,$mdate,$orgid));
										$data[$employment_type]=$this->db->lastInsertId();
									}else{
										$data[$employment_type]=0;
									}
								}
							//	Utils::Trace($data[$employment_type]);
								/////// checking Functional Area Master code
								$sql7 = "SELECT * FROM FunctionalAreaMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array(trim($data[$functional_area_code]),$orgid));
								if($row7=$query7->fetch())
								{
									$data[$functional_area_code]=$row7->Id;
								}else{
									if($data[$functional_area_code] != ""){
										$sql2 = "INSERT INTO FunctionalAreaMaster (Name,CreatedDate, OrganizationId) values (?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$functional_area_code]),$mdate,$orgid));
										$data[$functional_area_code]=$this->db->lastInsertId();
									}else{
										$data[$functional_area_code]=0;
									}
								}
								/////// checking Shift Code
								
								$sql8 = "SELECT * FROM ShiftMaster WHERE Name = ? and OrganizationId=?";
								$query8 = $this->db->prepare($sql8);
							
						//	Utils::Trace($data[$shift_code]);
								$query8->execute(array(trim($data[$shift_code]),$orgid));
								if($row8=$query8->fetch())
								{
									$data[$shift_code]=$row8->Id;
								}else{
									if($data[$shift_code] != ""){
										$sql2 = "INSERT INTO ShiftMaster (Name, CreatedDate, OrganizationId) values (?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$shift_code]),$mdate,$orgid));
										$data[$shift_code]=$this->db->lastInsertId();
									}else{
										$data[$shift_code]=0;
									}
								}
								//	Utils::Trace($data[$shift_code]);
								/////// checking Blood Group Code
								
								$sql9 = "SELECT * FROM BloodGroupMaster WHERE Name = ?";
								$query9 = $this->db->prepare($sql9);
								$query9->execute(array(trim($data[$bloodgrp])));
								if($row9=$query9->fetch())
								{
									$data[$bloodgrp]=$row9->Id;
								}else{
									$data[$bloodgrp]=0;
								}
								
								/////// checking Nationality Master
								
								$sql10 = "SELECT * FROM NationalityMaster WHERE Lower(Name) =  ?";
								$query10 = $this->db->prepare($sql10);
								//Utils::Trace($data[$nat]);
								$query10->execute(array(strtolower($data[$nat])));
								if($row10=$query10->fetch())
								{
									$data[$nat]=$row10->Id;
								}else{
									$data[$nat]=0;
								}
								//	Utils::Trace($data[$nat]);
								/////// checking Country Master
								
								$sql11 = "SELECT * FROM CountryMaster WHERE Lower(Name)  = ?";
								$query11 = $this->db->prepare($sql11);
								$query11->execute(array(strtolower($data[$country])));
								if($row11=$query11->fetch())
								{
									$data[$country]=$row11->Id;
								}else{
									$data[$country]=0;
								}
								/////// checking Religion Master
								$sql12 = "SELECT * FROM ReligionMaster WHERE Lower(Name) = ?";
								$query12 = $this->db->prepare($sql12);
								$query12->execute(array(strtolower($data[$religion])));
								if($row12=$query12->fetch())
								{
									$data[$religion]=$row12->Id;
								}else{
									$data[$religion]=0;
								}
								
								/* echo "********";
								echo $data[$designation];
								echo "********";
								$a=trim($data[$designation]);
								echo "@@@@@";
								echo $a;
								echo "@@@@@"; */
								/////// checking Desination Code
								$sql13 = "SELECT * FROM DesignationMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query13 = $this->db->prepare($sql13);
								$query13->execute(array(trim($data[$designation]),trim($data[$designation]),$orgid));
								if($row13=$query13->fetch())
								{
									$data[$designation]=$row13->Id;
								}else{
									if($data[$designation] != ""){
										$code=substr($data[$designation], 0, 3);
										$divcode=strtoupper($code."".mt_rand(1,1000));
										$sql2 = "INSERT INTO DesignationMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$designation]),$divcode,$mdate,$orgid));
										$data[$designation]=$this->db->lastInsertId();
									}else{
										$data[$designation]=0;
									}
								}
								
								/////// checking bank code
								$sql14 = "SELECT * FROM BankMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query14 = $this->db->prepare($sql14);
								$query14->execute(array(trim($data[$b_code]),trim($data[$b_code]),$orgid));
								if($row14=$query14->fetch())
								{
									$data[$b_code]=$row14->Id;
									$branch=$row14->Description;
								}else{
									$bank_id=0;
									$branch="";
									if($data[$b_code] != ""){
										$code=substr(trim($data[$b_code]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO BankMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$b_code]),$divcode,$mdate,$orgid));
										$data[$b_code]=$this->db->lastInsertId();
									}
								}
								
								//////GETTING VISA TYPE/////
								
								$sql14 = "SELECT * FROM VisaMaster WHERE (Name = ?) and OrganizationId=?";
								$query14 = $this->db->prepare($sql14);
								$query14->execute(array(trim($data[$visa_type]),$orgid));
								if($row14=$query14->fetch())
								{
									$data[$visa_type]=$row14->Id;
								}else{
									if($data[$visa_type] != ""){
										//$code=substr($data[$designation], 0, 3);
									//	$divcode=strtoupper($code);
										$sql2 = "INSERT INTO VisaMaster (Name, OrganizationId,  LastModifiedDate,  CreatedDate) VALUES (?, ?, ?, ?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$visa_type]),$orgid,$mdate,$mdate));
										$data[$visa_type]=$this->db->lastInsertId();
									}else{
										$data[$visa_type]=0;
									}
								}
								
								/////// checking Cost Center Code
								$sql18 = "SELECT * FROM CostCentreMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query18 = $this->db->prepare($sql18);
								$query18->execute(array(trim($data[$cocenter]),trim($data[$cocenter]),$orgid));
								if($row18=$query18->fetch())
								{
									$data[$cocenter]=$row18->Id;
								}else{
									if($data[$cocenter] != ""){
										$code=substr($data[$cocenter], 0, 3);
										$cocentercode=strtoupper($code."".mt_rand(1,1000));
										$sql19 = "INSERT INTO CostCentreMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query19 = $this->db->prepare($sql19);
										$query19->execute(array(trim($data[$cocenter]),$cocentercode,$mdate,$orgid));
										$data[$cocenter]=$this->db->lastInsertId();
									}else{
										$data[$cocenter]=0;
									}
								}
								
								//////GETTING VISA Category/////
								
								$sql15 = "SELECT * FROM VisaCategory WHERE (Name = ?) and OrganizationId=?";
								$query15 = $this->db->prepare($sql15);
								$query15->execute(array(trim($data[$visa_category]),$orgid));
								if($row15=$query15->fetch())
								{
									$data[$visa_category]=$row15->Id;
								}else{
									if($data[$visa_category] != ""){
										//$code=substr($data[$designation], 0, 3);
									//	$divcode=strtoupper($code);
										$sql2 = "INSERT INTO VisaCategory (Name, OrganizationId,  LastModifiedDate,  CreatedDate) VALUES (?, ?, ?, ?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$visa_category]),$orgid,$mdate,$mdate));
										$data[$visa_category]=$this->db->lastInsertId();
									}else{
										$data[$visa_category]=0;
									}
								}
								//////////GETTING EMPLOYEESTATUS///////
								/////// checking Functional Area Master code
								
								$sql7 = "SELECT * FROM OtherMaster WHERE OtherType = 'EmployeeStatus' and Lower(DisplayName) = ?";
								$query7 = $this->db->prepare($sql7);
								$query7->execute(array(strtolower($data[$emp_sts])));
								
								if($row7 = $query7->fetch())
								{
									$data[$emp_sts]=$row7->ActualValue;
								}else{
									
									//////On job//////
									$data[$emp_sts]=5;
								}
								
								//////////////////////////////////
								
								if($data[$gender] == "Male")
									$data[$gender]=1;
								else
									$data[$gender]=2;
								
								if(trim($data[$marital]) == "Single" || trim($data[$marital]) == "Unmarried")
									$data[$marital]=1;
								elseif(trim($data[$marital]) == "Married")
									$data[$marital]=2;
								elseif(trim($data[$marital]) == "Widowed")
									$data[$marital]=3;
								elseif(trim($data[$marital]) == "Separated")
									$data[$marital]=4;
								elseif(trim($data[$marital]) == "Divorced")
									$data[$marital]=5;
									
								if($data[$dob]!=""){
									 $data[$dob]=Utils::getDateformat($data[$dob],'dd/mm/yyyy');
								}else{
									$data[$dob]="0000-00-00";
								}
								
								if($data[$doj]!=""){
									$data[$doj]=Utils::getDateformat($data[$doj],'dd/mm/yyyy');
								}else{
									$data[$doj]="0000-00-00";
								}
								
								if($data[$doc]!=""){
									$data[$doc]=Utils::getDateformat($data[$doc],'dd/mm/yyyy');
								}else{
									$data[$doc]="0000-00-00";
								}
								$count1 = 0;$count5=0;$count6=0;
								
							
						//echo $field1;
								
						 		$sql5 = "SELECT * FROM EmployeeMaster WHERE  CompanyEmail=? ";
						
								$query5 = $this->db->prepare($sql5);
								$query5->execute(array(Utils::encode5t(str_replace(' ','',$data[$email]))));
								$count5 =  $query5->rowCount();	
								if($count5!=1 && $data[$emp_code]!='' )
								{
									$sql6 = "SELECT * FROM EmployeeMaster WHERE  (EmployeeCode=?  and EmployeeCode<>'') and OrganizationId=?";
									$query6 = $this->db->prepare($sql6);
									$query6->execute(array(trim($data[$emp_code]),$orgid));
									$count6 =  $query6->rowCount();	
									if($count6==1)
									{
										if($data[$fname] != ""){
											
										
											// SQL Query to insert data into DataBase
											$sql1 = "UPDATE EmployeeMaster SET  FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?,  DOJ=?,DOC=?, Gender=?,CurrentContactNumber=?,  CurrentEmailId=?,CurrentAddress=?, CurrentCountry=?, CurrentZipCode=?,  CreatedDate=?, MiddleName=?, EmployeeCTC=?, Division=?, Grade=?,  Department=?, Location=?, Shift=? ,FunctionalArea=?, EmploymentType=?, Designation=?, EmployeeStatus=?, UID_No=?, File_No=?,UniqueId=?,Visa=?,VisaCategory=?, CoCentre=? WHERE  OrganizationId=? and EmployeeCode=?";
									
											
											$query1 = $this->db->prepare($sql1);
										$query1->execute(array(trim($data[$fname]), trim($data[$lname]),$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doc],$data[$gender],Utils::encode5t(str_replace(' ','',$data[$contact_no])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t(trim($data[$address])),$data[$country],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts], $data[$uid_no], trim($data[$file_no]),Utils::encode5t(str_replace(' ','',$data[$emp_uniq_pid]))
										,$data[$visa_type],$data[$visa_category], $data[$cocenter],$orgid, trim($data[$emp_code])));
											
											$count1 =  $query1->rowCount();		
											//Utils::Trace("this is insert part");
											 $count1;
											
										}
									}
									if ($count1 == 1) {
										
										  /////// checking Employee code
										$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
										$query16 = $this->db->prepare($sql16);
										$query16->execute(array($data[$emp_code],$orgid));
										if($row16=$query16->fetch())
										{
											$data[$emp_code]=$row16->Id;
												
										}else{
											$data[$emp_code]=0;
										}
										
										 $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array($data[$emp_code],$data[$b_code]));
										
										if (($query15->rowcount())>0) {
										$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array(Utils::encode5t(trim($data[$b_acc_no])),Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)),$data[$emp_code],$data[$b_code]));
										}else{
										$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array($data[$emp_code],$data[$b_code],Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)), Utils::encode5t(trim($data[$b_acc_no]))));
										}
										
										
										/////////////////////////////////////////////////
										/////// checking user master//////
										/////////////////////////////////////////////////
														
										if($data[$email] != ""){
											$sql15 = "SELECT * FROM UserMaster WHERE EmployeeId=? or Username=?";
											$query15 = $this->db->prepare($sql15);
											$query15->execute(array($data[$emp_code],Utils::encode5t(strtolower(trim($data[$email])))));
											
											if (($query15->rowcount())>0) {
												$sql17 = "UPDATE UserMaster SET  VisibleSts=? WHERE EmployeeId=? and OrganizationId=?";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(1,$data[$emp_code],$orgid));
											}else{
											$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId) VALUES (?, ?,?,?, ?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower(trim($data[$email]))),1,$data[$emp_code],$orgid));
											}
										}	
										$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
										$queryseq = $this->db->prepare($sqlseq);
										$queryseq->execute(array($maxid,$orgid));
										
										
									   $status =true;
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									   
									   
									   
									}else{
										
										  /////// checking Employee code
										$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
										$query16 = $this->db->prepare($sql16);
										$query16->execute(array($data[$emp_code],$orgid));
										if($row16=$query16->fetch())
										{
											$data[$emp_code]=$row16->Id;
												
										}else{
											$data[$emp_code]=0;
										}
										
										 $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array($data[$emp_code],$data[$b_code]));
										
										if (($query15->rowcount())>0) {
											$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t(trim($data[$b_acc_no])),Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)),$data[$emp_code],$data[$b_code]));
											}else{
											$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array($data[$emp_code],$data[$b_code],Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)), Utils::encode5t(trim($data[$b_acc_no]))));
										}
										
											/////////////////////////////////////////////////
										/////// checking user master//////
										/////////////////////////////////////////////////
										$orgname=Utils::getName($orgid, "Organization", "Name", $this->db);
										$orgname = substr($orgname, 0, 3);	
										$orgname = strtoupper($orgname);
										$password=$orgname."123";	
										$password="123456";	
										
										if (strpos($data[$email], '@') !== false && $data[$email] != "") {
											$sql15 = "SELECT * FROM UserMaster WHERE EmployeeId = ? or ( Username=? ) ";
											$query15 = $this->db->prepare($sql15);
											$query15->execute(array($data[$emp_code],Utils::encode5t(strtolower(trim($data[$email])))));
											
											if (($query15->rowcount())>0) {
												$sql17 = "UPDATE UserMaster SET username_mobile=? WHERE EmployeeId=? and OrganizationId=?";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(Utils::encode5t(trim($data[$contact_no])),$data[$emp_code],$orgid));
											}else{
												$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId,username_mobile) VALUES (?, ?, ?, ?, ?, ?)";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(Utils::encode5t($password),Utils::encode5t(strtolower(trim($data[$email]))),1,$data[$emp_code],$orgid,Utils::encode5t(trim($data[$contact_no]))));
											}
										}
										
										 $status =true;
									   
										  $c1++;
										
									}
								}
								if($count5==1)
								{
									
									if($data[$fname] != ""){
										
									
										// SQL Query to insert data into DataBase
										$sql1 = "UPDATE EmployeeMaster SET  FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?,  DOJ=?,DOC=?, Gender=?,CurrentContactNumber=?,  CurrentEmailId=?,CurrentAddress=?, CurrentCountry=?, CurrentZipCode=?,  CreatedDate=?, MiddleName=?, EmployeeCTC=?, Division=?, Grade=?,  Department=?, Location=?, Shift=? ,FunctionalArea=?, EmploymentType=?, Designation=?, EmployeeStatus=?, UID_No=?, File_No=?,UniqueId=?,Visa=?,VisaCategory=?,CoCentre=? WHERE  OrganizationId=? $swhr";
								
										
										$query1 = $this->db->prepare($sql1);
									$query1->execute(array(trim($data[$fname]), trim($data[$lname]),$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doc],$data[$gender],Utils::encode5t(str_replace(' ','',$data[$contact_no])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t(trim($data[$address])),$data[$country],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts], $data[$uid_no], trim($data[$file_no]),Utils::encode5t(str_replace(' ','',$data[$emp_uniq_pid]))
									,$data[$visa_type],$data[$visa_category],$data[$cocenter], $orgid, $field));
										
										$count1 =  $query1->rowCount();		
										//Utils::Trace("this is insert part");
										
										
									}
									if ($count1 == 1) {
										
										  /////// checking Employee code
										$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
										$query16 = $this->db->prepare($sql16);
										$query16->execute(array($data[$emp_code],$orgid));
										if($row16=$query16->fetch())
										{
											$data[$emp_code]=$row16->Id;
												
										}else{
											$data[$emp_code]=0;
										}
										
										 $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array($data[$emp_code],$data[$b_code]));
										
										if (($query15->rowcount())>0) {
										$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array(Utils::encode5t(trim($data[$b_acc_no])),Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)),$data[$emp_code],$data[$b_code]));
										}else{
										$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array($data[$emp_code],$data[$b_code],Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)), Utils::encode5t(trim($data[$b_acc_no]))));
										}
										
										
										/////////////////////////////////////////////////
										/////// checking user master//////
										/////////////////////////////////////////////////
														
										if($data[$email] != ""){
											$sql15 = "SELECT * FROM UserMaster WHERE EmployeeId=? or Username=?";
											$query15 = $this->db->prepare($sql15);
											$query15->execute(array($data[$emp_code],Utils::encode5t(strtolower(trim($data[$email])))));
											
											if (($query15->rowcount())>0) {
												$sql17 = "UPDATE UserMaster SET  VisibleSts=? WHERE EmployeeId=? and OrganizationId=?";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(1,$data[$emp_code],$orgid));
											}else{
											$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId) VALUES (?, ?,?,?, ?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower(trim($data[$email]))),1,$data[$emp_code],$orgid));
											}
										}	
										$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
										$queryseq = $this->db->prepare($sqlseq);
										$queryseq->execute(array($maxid,$orgid));
										
										
									   $status =true;
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									   
									   
									   
									}else{
										
										  /////// checking Employee code
										$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
										$query16 = $this->db->prepare($sql16);
										$query16->execute(array($data[$emp_code],$orgid));
										if($row16=$query16->fetch())
										{
											$data[$emp_code]=$row16->Id;
												
										}else{
											$data[$emp_code]=0;
										}
										
										 $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array($data[$emp_code],$data[$b_code]));
										
										if (($query15->rowcount())>0) {
											$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t(trim($data[$b_acc_no])),Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)),$data[$emp_code],$data[$b_code]));
											}else{
											$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array($data[$emp_code],$data[$b_code],Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)), Utils::encode5t(trim($data[$b_acc_no]))));
										}
										
											/////////////////////////////////////////////////
										/////// checking user master//////
										/////////////////////////////////////////////////
										$orgname=Utils::getName($orgid, "Organization", "Name", $this->db);
										$orgname = substr($orgname, 0, 3);	
										$orgname = strtoupper($orgname);
										$password=$orgname."123";	
										$password="123456";	
										
										if (strpos($data[$email], '@') !== false && $data[$email] != "") {
											$sql15 = "SELECT * FROM UserMaster WHERE EmployeeId = ? or ( Username=? ) ";
											$query15 = $this->db->prepare($sql15);
											$query15->execute(array($data[$emp_code],Utils::encode5t(strtolower(trim($data[$email])))));
											
											if (($query15->rowcount())>0) {
												$sql17 = "UPDATE UserMaster SET username_mobile=? WHERE EmployeeId=? and OrganizationId=?";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(Utils::encode5t(trim($data[$contact_no])),$data[$emp_code],$orgid));
											}else{
												$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId,username_mobile) VALUES (?, ?, ?, ?, ?, ?)";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(Utils::encode5t($password),Utils::encode5t(strtolower(trim($data[$email]))),1,$data[$emp_code],$orgid,Utils::encode5t(trim($data[$contact_no]))));
											}
										}
										
										 $status =true;
									   
										  $c1++;
										
									}
								}
 							
							
							}
							else{
								/////// checking department code
								$sql2 = "SELECT * FROM DepartmentMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query2 = $this->db->prepare($sql2);
							
							
								$query2->execute(array(trim($data[$department]),trim($data[$department]),$orgid));
								if($row2=$query2->fetch())
								{
									$data[$department]=$row2->Id;
								}else{
									if($data[$department] != ""){
										$code=substr(trim($data[$department]), 0, 3);
										$divcode=strtoupper($code."".mt_rand(1,1000));
										$sql2 = "INSERT INTO DepartmentMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$department]),$divcode,$mdate,$orgid));
										$data[$department]=$this->db->lastInsertId();
									}else{
										$data[$department]=0;
									}
								}
								
								/////// checking division code
								$sql3 = "SELECT * FROM DivisionMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query3 = $this->db->prepare($sql3);
							
							
								$query3->execute(array(trim($data[$division]),trim($data[$division]),$orgid));
								if($row3=$query3->fetch())
								{
									$data[$division]=$row3->Id;
								}else{
									if($data[$division] != ""){
										$code=substr(trim($data[$division]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO DivisionMaster (Name,Code,ShortName,CreatedDate, OrganizationId) values (?,?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$division]),$divcode,$divcode,$mdate,$orgid));
										$data[$division]=$this->db->lastInsertId();
									}else{
										$data[$division]=0;
									}
								}
							
							
									/////// checking grade code
								$sql4 = "SELECT * FROM GradeMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query4 = $this->db->prepare($sql4);
							
							
								$query4->execute(array(trim($data[$grade]),trim($data[$grade]),$orgid));
								if($row4=$query4->fetch())
								{
									$data[$grade]=$row4->Id;
								}else{
									if($data[$grade] != ""){
										$code=substr(trim($data[$grade]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO GradeMaster (Name,Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$grade]),$divcode,$mdate,$orgid));
										$data[$grade]=$this->db->lastInsertId();
									}else{
										$data[$grade]=0;
									}
								}
								
									/////// checking location code
								$sql5 = "SELECT * FROM LocationMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query5 = $this->db->prepare($sql5);
							
							
								$query5->execute(array(trim($data[$location_code]),trim($data[$location_code]),$orgid));
								if($row5=$query5->fetch())
								{
									$data[$location_code]=$row5->Id;
								}else{
									if($data[$location_code] != ""){
										$code=substr(trim($data[$location_code]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO LocationMaster (Name, Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$location_code]),$divcode,$mdate,$orgid));
										$data[$location_code]=$this->db->lastInsertId();
									}else{
										$data[$location_code]=0;
									}
								}
								
								/////// checking Employment Type code
								$sql7 = "SELECT * FROM EmploymentTypeMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array(trim($data[$employment_type]),$orgid));
								if($row7=$query7->fetch())
								{
									$data[$employment_type]=$row7->Id;
								}else{
									if($data[$employment_type] != ""){
										$code=substr(trim($data[$employment_type]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO EmploymentTypeMaster (Name, Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$employment_type]),$divcode,$mdate,$orgid));
										$data[$employment_type]=$this->db->lastInsertId();
									}else{
										$data[$employment_type]=0;
									}
								}
								
								/////// checking Functional Area Master code
								$sql7 = "SELECT * FROM FunctionalAreaMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array(trim($data[$functional_area_code]),$orgid));
								if($row7=$query7->fetch())
								{
									$data[$functional_area_code]=$row7->Id;
								}else{
									if($data[$functional_area_code] != ""){
										$sql2 = "INSERT INTO FunctionalAreaMaster (Name, CreatedDate, OrganizationId) values (?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$functional_area_code]),$mdate,$orgid));
										$data[$functional_area_code]=$this->db->lastInsertId();
									}else{
										$data[$functional_area_code]=0;
									}
								}
								
								//////////GETTING EMPLOYEESTATUS///////
								/////// checking Functional Area Master code
								
								$sql7 = "SELECT * FROM OtherMaster WHERE OtherType = 'EmployeeStatus' and Lower(DisplayName) = ?";
								$query7 = $this->db->prepare($sql7);
								$query7->execute(array(strtolower($data[$emp_sts])));
								
								if($row7 = $query7->fetch())
								{
									$data[$emp_sts]=$row7->ActualValue;
								}else{
									
									//////On job//////
									$data[$emp_sts]=5;
								}
								
								/////// checking Shift Code
								
									$sql8 = "SELECT * FROM ShiftMaster WHERE Name = ? and OrganizationId=?";
								$query8 = $this->db->prepare($sql8);
							
						//	Utils::Trace($data[$shift_code]);
								$query8->execute(array(trim($data[$shift_code]),$orgid));
								if($row8=$query8->fetch())
								{
									$data[$shift_code]=$row8->Id;
								}else{
									if($data[$shift_code] != ""){
										$sql2 = "INSERT INTO ShiftMaster (Name, CreatedDate, OrganizationId) values (?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$shift_code]),$mdate,$orgid));
										$data[$shift_code]=$this->db->lastInsertId();
									}else{
										$data[$shift_code]=0;
									}
								}
									//Utils::Trace($data[$shift_code]);
								
								/////// checking Blood Group Code
								
									$sql9 = "SELECT * FROM BloodGroupMaster WHERE Name = ?";
								$query9 = $this->db->prepare($sql9);
							
							
								$query9->execute(array(trim($data[$bloodgrp])));
								if($row9=$query9->fetch())
								{
									$data[$bloodgrp]=$row9->Id;
								}else{
									$data[$bloodgrp]=0;
								}
								
								/////// checking Nationality Master
								
									$sql10 = "SELECT * FROM NationalityMaster WHERE Lower(Name) =   ?";
								$query10 = $this->db->prepare($sql10);
							
							
								$query10->execute(array(strtolower($data[$nat])));
								if($row10=$query10->fetch())
								{
									$data[$nat]=$row10->Id;
								}else{
									$data[$nat]=0;
								}
								
								/////// checking Country Master
								
									$sql11 = "SELECT * FROM CountryMaster WHERE Lower(Name)   = ?";
								$query11 = $this->db->prepare($sql11);
							
							
								$query11->execute(array(strtolower($data[$country])));
								if($row11=$query11->fetch())
								{
									$data[$country]=$row11->Id;
								}else{
									$data[$country]=0;
								}
								
								
									/////// checking Religion Master
								
									$sql12 = "SELECT * FROM ReligionMaster WHERE Lower(Name)   = ?";
								$query12 = $this->db->prepare($sql12);
							
							
								$query12->execute(array(strtolower($data[$religion])));
								if($row12=$query12->fetch())
								{
									$data[$religion]=$row12->Id;
								}else{
									$data[$religion]=0;
								}
								
								
								/* echo "********";
								echo $data[$designation];
								echo "********";
								$a=trim($data[$designation]);
								echo "@@@@@";
								echo $a;
								echo "@@@@@"; */
								
									/////// checking Desination Code
								
								$sql13 = "SELECT * FROM DesignationMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query13 = $this->db->prepare($sql13);
							
							
								$query13->execute(array(trim($data[$designation]),trim($data[$designation]),$orgid));
								if($row13=$query13->fetch())
								{
									$data[$designation]=$row13->Id;
								}else{
									if($data[$designation] != ""){
										$code=substr(trim($data[$designation]), 0, 3);
										$divcode=strtoupper($code."".mt_rand(1,1000));
										$sql2 = "INSERT INTO DesignationMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$designation]),$divcode,$mdate,$orgid));
										$data[$designation]=$this->db->lastInsertId();
									}else{
										$data[$designation]=0;
									}
								}
								
								
								
								
								  /////// checking bank code
								$sql14 = "SELECT * FROM BankMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query14 = $this->db->prepare($sql14);
								$query14->execute(array(trim($data[$b_code]),trim($data[$b_code]),$orgid));
								if($row14=$query14->fetch())
								{
									$data[$b_code]=$row14->Id;
									$branch=$row14->Description;
								}else{
									$bank_id=0;
									$branch="";
									if($data[$b_code] != ""){
										$code=substr(trim($data[$b_code]), 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO BankMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$b_code]),$divcode,$mdate,$orgid));
										$data[$b_code]=$this->db->lastInsertId();
									}
								}
							//	Utils::Trace($branch);
								
								//////GETTING VISA TYPE/////
								
								$sql16 = "SELECT * FROM VisaMaster WHERE (Name = ?) and OrganizationId=?";
								$query16 = $this->db->prepare($sql16);
								$query16->execute(array(trim($data[$visa_type]),$orgid));
								if($row16=$query16->fetch())
								{
									$data[$visa_type]=$row16->Id;
								}else{
									if($data[$visa_type] != ""){
										//$code=substr($data[$designation], 0, 3);
									//	$divcode=strtoupper($code);
										$sql2 = "INSERT INTO VisaMaster (Name, OrganizationId,  LastModifiedDate,  CreatedDate) VALUES (?, ?, ?, ?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$visa_type]),$orgid,$mdate,$mdate));
										$data[$visa_type]=$this->db->lastInsertId();
									}else{
										$data[$visa_type]=0;
									}
								}
								
								//////GETTING VISA Category/////
								
								$sql15 = "SELECT * FROM VisaCategory WHERE (Name = ?) and OrganizationId=?";
								$query15 = $this->db->prepare($sql15);
								$query15->execute(array(trim($data[$visa_category]),$orgid));
								if($row15=$query15->fetch())
								{
									$data[$visa_category]=$row15->Id;
								}else{
									if($data[$visa_category] != ""){
										//$code=substr($data[$designation], 0, 3);
									//	$divcode=strtoupper($code);
										$sql2 = "INSERT INTO VisaCategory (Name, OrganizationId,  LastModifiedDate,  CreatedDate) VALUES (?, ?, ?, ?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array(trim($data[$visa_category]),$orgid,$mdate,$mdate));
										$data[$visa_category]=$this->db->lastInsertId();
									}else{
										$data[$visa_category]=0;
									}
								}
								
								/////// checking Cost Center Code ///////
								$sql18 = "SELECT * FROM CostCentreMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query18 = $this->db->prepare($sql18);
								$query18->execute(array(trim($data[$cocenter]),trim($data[$cocenter]),$orgid));
								if($row18=$query18->fetch())
								{
									$data[$cocenter]=$row18->Id;
								}else{
									if($data[$cocenter] != ""){
										$code=substr($data[$cocenter], 0, 3);
										$cocentercode=strtoupper($code."".mt_rand(1,1000));
										$sql19 = "INSERT INTO CostCentreMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query19 = $this->db->prepare($sql19);
										$query19->execute(array(trim($data[$cocenter]),$cocentercode,$mdate,$orgid));
										$data[$cocenter]=$this->db->lastInsertId();
									}else{
										$data[$cocenter]=0;
									}
								}
								
								if($data[$gender] == "Male")
									$data[$gender]=1;
								else
									$data[$gender]=2;
								
								if(trim($data[$marital]) == "Single")
									$data[$marital]=1;
								elseif(trim($data[$marital]) == "Married")
									$data[$marital]=2;
								elseif(trim($data[$marital]) == "Widowed")
									$data[$marital]=3;
								elseif(trim($data[$marital]) == "Separated")
									$data[$marital]=4;
								elseif(trim($data[$marital]) == "Divorced")
									$data[$marital]=5;
								elseif(trim($data[$marital]) == "Unmarried")
									$data[$marital]=1;	
									
								if($data[$dob]!=""){
								
								$data[$dob]=Utils::getDateformat($data[$dob],'dd/mm/yyyy');
								}else{
									$data[$dob]="0000-00-00";
								}
								
								if($data[$doj]!=""){
								$data[$doj]=Utils::getDateformat($data[$doj],'dd/mm/yyyy');
								}else{
									$data[$doj]="0000-00-00";
								}
								
								if($data[$doc]!=""){
								$data[$doc]=Utils::getDateformat($data[$doc],'dd/mm/yyyy');
								}else{
									$data[$doc]="0000-00-00";
								}
								/* if($data[$dol]!=""){
								//$data[$dol]=Utils::getDateformat($data[$dol],'dd-mm-yyyy');
								}else{
									$data[$dol]="0000-00-00";
								} */
								$count1 = 0;
								
								
								
								if($data[$fname] != ""){
									// SQL Query to insert data into DataBase
									$sqll = "SELECT * FROM EmployeeMaster WHERE CompanyEmail=?  and CompanyEmail <>''";
									$queryl = $this->db->prepare($sqll);
									$queryl->execute(array(Utils::encode5t(str_replace(' ','',strtolower(trim($data[$email]))))));
									
									$sql2 = "SELECT * FROM EmployeeMaster WHERE CurrentContactNumber=?  and CurrentContactNumber <>''";
									$query2 = $this->db->prepare($sql2);
									$query2->execute(array(Utils::encode5t(trim($data[$contact_no]))));
								 	$query2->rowCount();
									$e=$queryl->rowCount();
									$e1=$query2->rowCount();
									
								
									if(($queryl->rowCount()==0) && ($query2->rowCount()==0)){
										$sql1 = "INSERT INTO EmployeeMaster (EmployeeCode, FirstName, LastName, DOB, Nationality, MaritalStatus, Religion, BloodGroup,  DOJ,DOC,   Gender, CurrentContactNumber, CompanyEmail, CurrentEmailId, CurrentAddress, CurrentCountry, CurrentZipCode,  CreatedDate, MiddleName, EmployeeCTC, OrganizationId, Division, Grade, Department, Location, Shift, FunctionalArea ,EmploymentType, Designation, EmployeeStatus, UID_No, File_No ,UniqueId,Visa,VisaCategory,CoCentre) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";		
									
									
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array(trim($data[$emp_code]),trim($data[$fname]), trim($data[$lname]),$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doc],$data[$gender],Utils::encode5t(trim($data[$contact_no])),Utils::encode5t(str_replace(' ','',trim($data[$email]))),Utils::encode5t(str_replace(' ','',trim($data[$email]))),Utils::encode5t(trim($data[$address])),$data[$country],$data[$zipcode],  $mdate, trim($data[$mname]), $data[$empctc],$orgid,$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts],$data[$uid_no],$data[$file_no],Utils::encode5t(trim($data[$emp_uniq_pid])),$data[$visa_type],$data[$visa_category],$data[$cocenter]));
										
										$count1 =  $query1->rowCount();		
										//Utils::Trace("this is insert part");
									}
									/* else{
										$sql1 = "UPDATE EmployeeMaster SET EmployeeCode=?, FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?,  DOJ=?,DOC=?, Gender=?,CurrentContactNumber=?, PersonalNo=?, CompanyEmail=?, CurrentEmailId=?,EmergencyEmailId=?,HomeEmailId=?,CurrentAddress=?, CurrentCountry=?, CurrentZipCode=?,  CreatedDate=?, MiddleName=?, EmployeeCTC=?, Division=?, Grade=?,  Department=?, Location=?, Shift=? ,FunctionalArea=?, EmploymentType=?, Designation=?, EmployeeStatus=? WHERE  OrganizationId=? and  CompanyEmail=?";
								
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$emp_code],$data[$fname], $data[$lname],$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doc],$data[$gender],Utils::encode5t(str_replace(' ','',$data[$contact_no])),Utils::encode5t($data[$personal_no]),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t($data[$address]),$data[$country],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts],$orgid, Utils::encode5t(str_replace(' ','',$data[$email]))));
										
										$count1 =  $query1->rowCount();	
									} */
								}
							
								if ($count1 == 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = "Employees imported successfully";
								    /////// checking Employee code
									
									$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
									$query16 = $this->db->prepare($sql16);
									$query16->execute(array($data[$emp_code],$orgid));
									if($row16=$query16->fetch())
									{
										$data[$emp_code]=$row16->Id;
											
									}else{
										$data[$emp_code]=0;
									}
									
								    $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
									$query15 = $this->db->prepare($sql15);
									$query15->execute(array($data[$emp_code],$data[$b_code]));
									
									if (($query15->rowcount())>0) {
										$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array(Utils::encode5t(trim($data[$b_acc_no])),Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)),$data[$emp_code],$data[$b_code]));
										}else{
										$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array($data[$emp_code],$data[$b_code],Utils::encode5t(trim($data[$b_code])),Utils::encode5t(trim($branch)), Utils::encode5t(trim($data[$b_acc_no]))));
									}
									
									
										/////////////////////////////////////////////////
									/////// checking user master//////
									/////////////////////////////////////////////////
													
									if($data[$email] != ""){
										$sql15 = "SELECT * FROM UserMaster WHERE ( Username=?) and (Username <>'')";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array(Utils::encode5t(str_replace(' ','',(trim($data[$email]))))));
										
										if (($query15->rowcount())>0) {
											/* $sql17 = "UPDATE UserMaster SET Password=?,Username=?,VisibleSts=? WHERE EmployeeId=? and OrganizationId=?";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid)); */
										}else{ 
											$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts, EmployeeId, OrganizationId,username_mobile) VALUES (?, ?, ?,?, ?,?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(str_replace(' ','',(trim($data[$email])))),1,$data[$emp_code],$orgid,Utils::encode5t($data[$contact_no])));
										}
									}
									$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
									$queryseq = $this->db->prepare($sqlseq);
									$queryseq->execute(array($maxid,$orgid));
									
								} 
							}
						
						}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatemp"] =$c;
		$result["importemp"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	public function insertEmpdocsFileHeaders($request)
		{
		$result = array();
		$count1=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$employee = $request[2];
		$document = $request[3];
		$docno =$request[4];
		$issuedon = $request[5];
		$expiredon = $request[6];
		
		//date("H:i", strtotime($request[11]));
				
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ //echo $i." ".$data[$i]."<br>";
							
							$empid=$this->getEmpIdByCode(trim($data[$employee]),$orgid);
							
							
							$sql = "SELECT * FROM DocumentMaster WHERE Name = ? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							$query->execute(array($data[$document],$orgid));
							if (($query->rowcount())>0) {
								$row=$query->fetch();
								$docid=$row->Id;
							}else{
								$code=strtoupper(substr($data[$document], 0, 3));
								$sql1 = "INSERT INTO DocumentMaster (Code, Name,OrganizationId) VALUES (?, ?, ?)";		
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($code,$data[$document],$orgid));
								$docid=$this->db->lastInsertId();
							}
							$sql = "SELECT * FROM EmployeeDocument WHERE EmployeeId = ? and DocumentTypeId=? and OrganizationId=?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array($empid, $docid , $orgid));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
							if (($query->rowcount())>0) {
								if($data[$issuedon]!=""){
									$data[$issuedon]=Utils::getDateformat($data[$issuedon],'dd/mm/yyyy');
								}else{
									$data[$issuedon]="0000-00-00";
								}
								if($data[$expiredon]!=""){
									$data[$expiredon]=Utils::getDateformat($data[$expiredon],'dd/mm/yyyy');
								}else{
									$data[$expiredon]="0000-00-00";
								}
								$row=$query->fetch();
								
								$empdocid=$row->Id;

								// SQL Query to insert data into DataBase
								$sql1 = "UPDATE EmployeeDocument SET DocumentNumber=?, IssuedOn=?, ExpiredOn=?, LastModifiedById = ? , LastModifiedDate = ? where Id=?";		
								try{
									
									$issue=$data[$issuedon];
									$expire=$data[$expiredon];
									$data[$docno]=Utils::encode5t($data[$docno]);
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$docno], $issue, $expire, $mid, $mdate , $empdocid ));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c++;
								   $successMsg = "Employee Documents imported successfully!";
								} 						
							
							}
						else{
								if($data[$issuedon]!=""){
									$data[$issuedon]=Utils::getDateformat($data[$issuedon],'dd/mm/yyyy');
								}else{
									$data[$issuedon]="0000-00-00";
								}
								if($data[$expiredon]!=""){
									$data[$expiredon]=Utils::getDateformat($data[$expiredon],'dd/mm/yyyy');
								}else{
									$data[$expiredon]="0000-00-00";
								}
							
								// SQL Query to insert data into DataBase
								$sql1 = "INSERT INTO EmployeeDocument ( EmployeeId, DocumentTypeId ,DocumentNumber, IssuedOn, ExpiredOn, CreatedById, CreatedDate, OrganizationId) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";		
								try{
									
									$issue=$data[$issuedon];
									$expire=$data[$expiredon];
									$data[$docno]=Utils::encode5t($data[$docno]);
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($empid, $docid, $data[$docno],$issue,$expire, $mid, $mdate, $orgid));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = "Employee Documents imported successfully!";
								} 
						}
						
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatempdocs"] =$c;
		$result["importempdocs"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function CheckexistingEmpcode($ecode,$orgid)
	{
		$empcode =0;
		$sql = "SELECT coalesce(MAX(Id), 0, MAX(Id)) as maxid FROM EmployeeSequence WHERE  OrganizationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ));
			while( $row =  $query->fetch() )
			{
				if($row->maxid ==0){
					$empcode=$ecode."01";
				}
				else{
					$max=($row->maxid)+1;
					$empcode=$ecode."0".$max;
					if($max>9)
						$empcode=$ecode.$max;
				}
			}
			
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	public function getMaxEmpid($orgid)
	{
		$empcode =0;
		$sql = "SELECT MAX(Id) as maxid FROM EmployeeSequence WHERE  OrganizationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ));
			while( $row =  $query->fetch() )
			{
				if($row->maxid ==0){
					$empcode="01";
				}
				else{
					$mid=($row->maxid)+1;
					$empcode="0".$mid;
					if($mid>9)
					$empcode=$mid;
				}
			}
			
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	
	public function getEmpIdByCode($empcode,$orgid)
	{
		$empid ="";
		$sql = "SELECT Id FROM EmployeeMaster WHERE  OrganizationId=? and EmployeeCode = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ,$empcode ));
			while( $row =  $query->fetch() )
			{
				$empid=$row->Id;
			}
			
		}catch(Exception $e) {
			
		}
		return $empid;
	}
	
	
	/*
	
	IMPORT WIZARD CODE BY PRATIBHA
	
	public function insertEmployeeFileHeaders($request)
    {
		
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$fname = $request[2];
		$lname = $request[3];
		$dob = $request[4];
		$nat = $request[5];
		$marital = $request[6];
		$religion = $request[7];
		$bloodgrp = $request[8];
		//$known_lang = $request[9];
		$doj = $request[9];
		$doc = $request[10];
		$gender = $request[11];
		$contact_no = $request[12];
		$email = $request[13];
		$address = $request[14];
		//$city = $request[15];
		$country = $request[15];
		$zipcode = $request[16];
		$mname= $request[17];
		$empctc= $request[18];
		$division=$request[19];
		$grade=$request[20];
		$location_code=$request[21];
		$employment_type=$request[22];
		$functional_area_code=$request[23];
		$shift_code=$request[24];
		$department=$request[25];
		$emp_code=$request[26];
		$designation=$request[27];
		$b_code=$request[28];
		$b_acc_no=$request[29];
		$personal_no=$request[30];
		$emp_sts=$request[31];
		$dol=$request[32];
		$maxid=$this->getMaxEmpid($orgid);
		$employeecode="E".$maxid;
		$bank_id=0;
		//Utils::Trace($email);
		$branch="";
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
		$i=0;	
		if (($handle = fopen($fp, "r")) !== FALSE) 
		{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						if($i>0)
						{ 
							////////////IF THERE IS NO EMPLOYEE CODE IN CSV FILE THEN WE HAVE TO CHECK EMPLOYEE ACCORDING TO EMAIL ID///
							//echo $data[$doj];
							if($data[$emp_code]=="" && $data[$email]=="")
							{
								$maxid=$this->getMaxEmpid($orgid);
								$divcode=0;
								$sqldiv="SELECT Code FROM DivisionMaster WHERE Id =?";	
								$querydiv = $this->db->prepare($sqldiv);
								$querydiv->execute(array($data[$division]));
								while($rowdiv = $querydiv->fetch()){
									$divcode=$rowdiv->Code;
								}
								
								//$doj=Utils::getDateformat($data[$doj]);					
								$doj1=$data[$doj];					
								$yearofjoining=date("y", strtotime(date($doj1)));
								$employeecode="E".$maxid;
								$ecode=$divcode.$yearofjoining;	
								$employeecode=$this->CheckexistingEmpcode($ecode,$request[1]);
								$data[$emp_code]=$employeecode;
								
								
								$sql = "SELECT * FROM EmployeeMaster WHERE PersonalNo=? and OrganizationId=?";
								$query = $this->db->prepare($sql);
								$query->execute(array(Utils::encode5t($data[$personal_no]),$orgid));
								$swhr="AND PersonalNo=?";
								$field=Utils::encode5t($data[$personal_no]);
								
								$field1=Utils::encode5t($data[$personal_no]);
								$swhr1="WHERE PersonalNo='$field1'";
								

								
							}
							elseif($data[$emp_code]==""){
								$maxid=$this->getMaxEmpid($orgid);
								$divcode=0;
								$sqldiv="SELECT Code FROM DivisionMaster WHERE Id =?";	
								$querydiv = $this->db->prepare($sqldiv);
								$querydiv->execute(array($data[$division]));
								while($rowdiv = $querydiv->fetch()){
									$divcode=$rowdiv->Code;
								}
								
								//$doj=Utils::getDateformat($data[$doj]);					
								$doj1=$data[$doj];					
								$yearofjoining=date("y", strtotime(date($doj1)));
								$employeecode="E".$maxid;
								$ecode=$divcode.$yearofjoining;	
								$employeecode=$this->CheckexistingEmpcode($ecode,$request[1]);
								$data[$emp_code]=$employeecode;
								
								$sql = "SELECT * FROM EmployeeMaster WHERE CompanyEmail=? and OrganizationId=?";
								$query = $this->db->prepare($sql);
								$query->execute(array(Utils::encode5t(str_replace(' ','',strtolower($data[$email]))),$orgid));
								$swhr="AND CompanyEmail=?";
								$field=Utils::encode5t(str_replace(' ','',strtolower($data[$email])));
								
								$e=Utils::encode5t($data[$personal_no]);
								$d=Utils::encode5t(str_replace(' ','',strtolower($data[$email])));
								
								$swhr1="WHERE ( CompanyEmail='$d' or PersonalNo='$e')";
								
							}
							else{
								///////// IF THERE IS EMPLOYEE CODE MENTIONED IN FILE THEN WE HAVE TO CHECK IT ACCORDING TO EMPLOYEE CODE/////////
								
								$sql = "SELECT * FROM EmployeeMaster WHERE EmployeeCode=? and OrganizationId=?";
								$query = $this->db->prepare($sql);
								$query->execute(array($data[$emp_code],$orgid));
								$swhr="AND EmployeeCode=?";
								$field=$data[$emp_code];
								
								$a=Utils::encode5t(str_replace(' ','',strtolower($data[$email])));
								$b=Utils::encode5t($data[$personal_no]);
								
								$swhr1="WHERE (CompanyEmail='$a' or PersonalNo='$b')";
								//$field1=$a." , ".$b;
								
								
							}
							//Utils::Trace("This is Emp_code ".$data[$emp_code]);
							
							if (($query->rowcount())>0) {
								
							   	/////// checking department code
								
								$sql2 = "SELECT * FROM DepartmentMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query2 = $this->db->prepare($sql2);
								$query2->execute(array($data[$department],$data[$department],$orgid));
								if($row2=$query2->fetch())
								{
									$data[$department]=$row2->Id;
								}else{
									if($data[$department] != ""){
										$code=substr($data[$department], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO DepartmentMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$department],$divcode,$mdate,$orgid));
										$data[$department]=$this->db->lastInsertId();
									}else{
										$data[$department]=0;
									}
									
								}
								
								/////// checking division code
								$sql3 = "SELECT * FROM DivisionMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query3 = $this->db->prepare($sql3);
								$query3->execute(array($data[$division],$data[$division],$orgid));
								if($row3=$query3->fetch())
								{
									$data[$division]=$row3->Id;
								}else{
									if($data[$division] != ""){
										$code=substr($data[$division], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO DivisionMaster (Name,Code,ShortName,CreatedDate, OrganizationId) values (?,?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$division],$divcode,$divcode,$mdate,$orgid));
										$data[$division]=$this->db->lastInsertId();
									}else{
										$data[$division]=0;
									}
								}
								/////// checking grade code/////
								$sql4 = "SELECT * FROM GradeMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query4 = $this->db->prepare($sql4);
							
							
								$query4->execute(array($data[$grade],$data[$grade],$orgid));
								if($row4=$query4->fetch())
								{
									$data[$grade]=$row4->Id;
								}else{
									if($data[$grade] != ""){
										$code=substr($data[$grade], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO GradeMaster (Name,Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$grade],$divcode,$mdate,$orgid));
										$data[$grade]=$this->db->lastInsertId();
									}else{
										$data[$grade]=0;
									}
								}
								
									/////// checking location code
								$sql5 = "SELECT * FROM LocationMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query5 = $this->db->prepare($sql5);
							
							
								$query5->execute(array($data[$location_code],$data[$location_code],$orgid));
								if($row5=$query5->fetch())
								{
									$data[$location_code]=$row5->Id;
								}else{
									if($data[$location_code] != ""){
										$code=substr($data[$location_code], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO LocationMaster (Name, Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$location_code],$divcode,$mdate,$orgid));
										$data[$location_code]=$this->db->lastInsertId();
									}else{
										$data[$location_code]=0;
									}
								}
								
								/////// checking Employment Type code
								$sql7 = "SELECT * FROM EmploymentTypeMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array($data[$employment_type],$data[$employment_type],$orgid));
								//Utils::Trace($data[$employment_type]);
								if($row7=$query7->fetch())
								{
									$data[$employment_type]=$row7->Id;
									
								}else{
									if($data[$employment_type] != ""){
										$code=substr($data[$employment_type], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO EmploymentTypeMaster (Name, Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$employment_type],$divcode,$mdate,$orgid));
										$data[$employment_type]=$this->db->lastInsertId();
									}else{
										$data[$employment_type]=0;
									}
								}
							//	Utils::Trace($data[$employment_type]);
								/////// checking Functional Area Master code
								$sql7 = "SELECT * FROM FunctionalAreaMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array($data[$functional_area_code],$orgid));
								if($row7=$query7->fetch())
								{
									$data[$functional_area_code]=$row7->Id;
								}else{
									if($data[$functional_area_code] != ""){
										$sql2 = "INSERT INTO FunctionalAreaMaster (Name,CreatedDate, OrganizationId) values (?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$functional_area_code],$mdate,$orgid));
										$data[$functional_area_code]=$this->db->lastInsertId();
									}else{
										$data[$functional_area_code]=0;
									}
								}
								/////// checking Shift Code
								
								$sql8 = "SELECT * FROM ShiftMaster WHERE Name = ? and OrganizationId=?";
								$query8 = $this->db->prepare($sql8);
							
						//	Utils::Trace($data[$shift_code]);
								$query8->execute(array($data[$shift_code],$orgid));
								if($row8=$query8->fetch())
								{
									$data[$shift_code]=$row8->Id;
								}else{
									if($data[$shift_code] != ""){
										$sql2 = "INSERT INTO ShiftMaster (Name, CreatedDate, OrganizationId) values (?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$shift_code],$mdate,$orgid));
										$data[$shift_code]=$this->db->lastInsertId();
									}else{
										$data[$shift_code]=0;
									}
								}
								//	Utils::Trace($data[$shift_code]);
								/////// checking Blood Group Code
								
								$sql9 = "SELECT * FROM BloodGroupMaster WHERE Name = ?";
								$query9 = $this->db->prepare($sql9);
								$query9->execute(array($data[$bloodgrp]));
								if($row9=$query9->fetch())
								{
									$data[$bloodgrp]=$row9->Id;
								}else{
									$data[$bloodgrp]=0;
								}
								
								/////// checking Nationality Master
								
								$sql10 = "SELECT * FROM NationalityMaster WHERE Lower(Name) =  ?";
								$query10 = $this->db->prepare($sql10);
								//Utils::Trace($data[$nat]);
								$query10->execute(array(strtolower($data[$nat])));
								if($row10=$query10->fetch())
								{
									$data[$nat]=$row10->Id;
								}else{
									$data[$nat]=0;
								}
								//	Utils::Trace($data[$nat]);
								/////// checking Country Master
								
								$sql11 = "SELECT * FROM CountryMaster WHERE Lower(Name)  = ?";
								$query11 = $this->db->prepare($sql11);
								$query11->execute(array(strtolower($data[$country])));
								if($row11=$query11->fetch())
								{
									$data[$country]=$row11->Id;
								}else{
									$data[$country]=0;
								}
								/////// checking Religion Master
								$sql12 = "SELECT * FROM ReligionMaster WHERE Lower(Name) = ?";
								$query12 = $this->db->prepare($sql12);
								$query12->execute(array(strtolower($data[$religion])));
								if($row12=$query12->fetch())
								{
									$data[$religion]=$row12->Id;
								}else{
									$data[$religion]=0;
								}
								/////// checking Desination Code
								$sql13 = "SELECT * FROM DesignationMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query13 = $this->db->prepare($sql13);
								$query13->execute(array($data[$designation],$data[$designation],$orgid));
								if($row13=$query13->fetch())
								{
									$data[$designation]=$row13->Id;
								}else{
									if($data[$designation] != ""){
										$code=substr($data[$designation], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO DesignationMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$designation],$divcode,$mdate,$orgid));
										$data[$designation]=$this->db->lastInsertId();
									}else{
										$data[$designation]=0;
									}
								}
								/////// checking bank code
								$sql14 = "SELECT * FROM BankMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query14 = $this->db->prepare($sql14);
								$query14->execute(array($data[$b_code],$data[$b_code],$orgid));
								if($row14=$query14->fetch())
								{
									$bank_id=$row14->Id;
									$branch=$row14->Description;
								}else{
									$bank_id=0;
									$branch="";
									if($data[$b_code] != ""){
										$code=substr($data[$b_code], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO BankMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$b_code],$divcode,$mdate,$orgid));
										$bank_id=$this->db->lastInsertId();
									}
								}
								//////////GETTING EMPLOYEESTATUS///////
								/////// checking Functional Area Master code
								
								$sql7 = "SELECT * FROM OtherMaster WHERE OtherType = 'EmployeeStatus' and Lower(DisplayName) = ?";
								$query7 = $this->db->prepare($sql7);
								$query7->execute(array(strtolower($data[$emp_sts])));
								
								if($row7 = $query7->fetch())
								{
									$data[$emp_sts]=$row7->ActualValue;
								}else{
									
									//////On job//////
									$data[$emp_sts]=5;
								}
								
								//////////////////////////////////
								
								if($data[$gender] == "Male")
									$data[$gender]=1;
								else
									$data[$gender]=2;
								
								if(trim($data[$marital]) == "Single" || trim($data[$marital]) == "Unmarried")
									$data[$marital]=1;
								elseif(trim($data[$marital]) == "Married")
									$data[$marital]=2;
								elseif(trim($data[$marital]) == "Widowed")
									$data[$marital]=3;
								elseif(trim($data[$marital]) == "Separated")
									$data[$marital]=4;
								elseif(trim($data[$marital]) == "Divorced")
									$data[$marital]=5;
									
								if($data[$dob]!=""){
									//$data[$dob]=Utils::getDateformat($data[$dob],'dd-mm-yyyy');
								}else{
									$data[$dob]="0000-00-00";
								}
								
								if($data[$doj]!=""){
									//$data[$doj]=Utils::getDateformat($data[$doj],'dd-mm-yyyy');
								}else{
									$data[$doj]="0000-00-00";
								}
								
								if($data[$doc]!=""){
									//$data[$doc]=Utils::getDateformat($data[$doc],'dd-mm-yyyy');
								}else{
									$data[$doc]="0000-00-00";
								}
								$count1 = 0;$count5=0;
								
							
						//echo $field1;
								
						 		$sql5 = "SELECT * FROM EmployeeMaster $swhr1 ";
						
								$query5 = $this->db->prepare($sql5);
								$query5->execute(array());
								$count5 =  $query5->rowCount();	
								if($count5==1)
								{
									if($data[$fname] != ""){
										
										
										// SQL Query to insert data into DataBase
										$sql1 = "UPDATE EmployeeMaster SET EmployeeCode=?, FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?,  DOJ=?,DOC=?, Gender=?,CurrentContactNumber=?, PersonalNo=?, CompanyEmail=?, CurrentEmailId=?,EmergencyEmailId=?,HomeEmailId=?,CurrentAddress=?, CurrentCountry=?, CurrentZipCode=?,  CreatedDate=?, MiddleName=?, EmployeeCTC=?, Division=?, Grade=?,  Department=?, Location=?, Shift=? ,FunctionalArea=?, EmploymentType=?, Designation=?, EmployeeStatus=? WHERE  OrganizationId=? $swhr";
								
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$emp_code],$data[$fname], $data[$lname],$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doc],$data[$gender],Utils::encode5t(str_replace(' ','',$data[$contact_no])),Utils::encode5t($data[$personal_no]),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t($data[$address]),$data[$country],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts],$orgid, $field));
										
										$count1 =  $query1->rowCount();		
										//Utils::Trace("this is insert part");
										
										
									}
									if ($count1 == 1) {
										
										  /////// checking Employee code
										$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
										$query16 = $this->db->prepare($sql16);
										$query16->execute(array($data[$emp_code],$orgid));
										if($row16=$query16->fetch())
										{
											$data[$emp_code]=$row16->Id;
												
										}else{
											$data[$emp_code]=0;
										}
										
										 $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array($data[$emp_code],$bank_id));
										
										if (($query15->rowcount())>0) {
										$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array(Utils::encode5t($data[$b_acc_no]),Utils::encode5t($data[$b_code]),Utils::encode5t($branch),$data[$emp_code],$bank_id));
										}else{
										$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array($data[$emp_code],$bank_id,Utils::encode5t($data[$b_code]),Utils::encode5t($branch), Utils::encode5t($data[$b_acc_no])));
										}
										
										
										/////////////////////////////////////////////////
										/////// checking user master//////
										/////////////////////////////////////////////////
														
										if($data[$email] != ""){
											$sql15 = "SELECT * FROM UserMaster WHERE EmployeeId=? or Username=?";
											$query15 = $this->db->prepare($sql15);
											$query15->execute(array($data[$emp_code],Utils::encode5t(strtolower($data[$email]))));
											
											if (($query15->rowcount())>0) {
												$sql17 = "UPDATE UserMaster SET Password=?,Username=?,VisibleSts=? WHERE EmployeeId=? and OrganizationId=?";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid));
											}else{
											$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId) VALUES (?, ?,?,?, ?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid));
											}
										}	
										$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
										$queryseq = $this->db->prepare($sqlseq);
										$queryseq->execute(array($maxid,$orgid));
										
										
									   $status =true;
									   $c1++;
									   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
									   
									   
									   
									}else{
										
										  /////// checking Employee code
										$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
										$query16 = $this->db->prepare($sql16);
										$query16->execute(array($data[$emp_code],$orgid));
										if($row16=$query16->fetch())
										{
											$data[$emp_code]=$row16->Id;
												
										}else{
											$data[$emp_code]=0;
										}
										
										 $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array($data[$emp_code],$bank_id));
										
										if (($query15->rowcount())>0) {
											$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t($data[$b_acc_no]),Utils::encode5t($data[$b_code]),Utils::encode5t($branch),$data[$emp_code],$bank_id));
											}else{
											$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array($data[$emp_code],$bank_id,Utils::encode5t($data[$b_code]),Utils::encode5t($branch), Utils::encode5t($data[$b_acc_no])));
										}
										
											/////////////////////////////////////////////////
										/////// checking user master//////
										/////////////////////////////////////////////////
										$orgname=Utils::getName($orgid, "Organization", "Name", $this->db);
										$orgname = substr($orgname, 0, 3);	
										$orgname = strtoupper($orgname);
										$password=$orgname."123";	
										$password="123456";	
										
										if (strpos($data[$email], '@') !== false && $data[$email] != "") {
											$sql15 = "SELECT * FROM UserMaster WHERE EmployeeId = ? or ( Username=? or username_mobile=?) ";
											$query15 = $this->db->prepare($sql15);
											$query15->execute(array($data[$emp_code],Utils::encode5t(strtolower($data[$email])) , Utils::encode5t($data[$personal_no])));
											
											if (($query15->rowcount())>0) {
												$sql17 = "UPDATE UserMaster SET username_mobile=? WHERE EmployeeId=? and OrganizationId=?";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(Utils::encode5t($data[$personal_no]),$data[$emp_code],$orgid));
											}else{
												$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts,EmployeeId,OrganizationId,username_mobile) VALUES (?, ?, ?, ?, ?, ?)";		
												$query17 = $this->db->prepare($sql17);
												$query17->execute(array(Utils::encode5t($password),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid,Utils::encode5t($data[$personal_no])));
											}
										}
										
										 $status =true;
									   
										  //$c1++;
										
									}
								}
							
							}
							else{
								/////// checking department code
								$sql2 = "SELECT * FROM DepartmentMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query2 = $this->db->prepare($sql2);
							
							
								$query2->execute(array($data[$department],$data[$department],$orgid));
								if($row2=$query2->fetch())
								{
									$data[$department]=$row2->Id;
								}else{
									if($data[$department] != ""){
										$code=substr($data[$department], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO DepartmentMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$department],$divcode,$mdate,$orgid));
										$data[$department]=$this->db->lastInsertId();
									}else{
										$data[$department]=0;
									}
								}
								
								/////// checking division code
								$sql3 = "SELECT * FROM DivisionMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query3 = $this->db->prepare($sql3);
							
							
								$query3->execute(array($data[$division],$data[$division],$orgid));
								if($row3=$query3->fetch())
								{
									$data[$division]=$row3->Id;
								}else{
									if($data[$division] != ""){
										$code=substr($data[$division], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO DivisionMaster (Name,Code,ShortName,CreatedDate, OrganizationId) values (?,?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$division],$divcode,$divcode,$mdate,$orgid));
										$data[$division]=$this->db->lastInsertId();
									}else{
										$data[$division]=0;
									}
								}
							
							
									/////// checking grade code
								$sql4 = "SELECT * FROM GradeMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query4 = $this->db->prepare($sql4);
							
							
								$query4->execute(array($data[$grade],$data[$grade],$orgid));
								if($row4=$query4->fetch())
								{
									$data[$grade]=$row4->Id;
								}else{
									if($data[$grade] != ""){
										$code=substr($data[$grade], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO GradeMaster (Name,Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$grade],$divcode,$mdate,$orgid));
										$data[$grade]=$this->db->lastInsertId();
									}else{
										$data[$grade]=0;
									}
								}
								
									/////// checking location code
								$sql5 = "SELECT * FROM LocationMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query5 = $this->db->prepare($sql5);
							
							
								$query5->execute(array($data[$location_code],$data[$location_code],$orgid));
								if($row5=$query5->fetch())
								{
									$data[$location_code]=$row5->Id;
								}else{
									if($data[$location_code] != ""){
										$code=substr($data[$location_code], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO LocationMaster (Name, Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$location_code],$divcode,$mdate,$orgid));
										$data[$location_code]=$this->db->lastInsertId();
									}else{
										$data[$location_code]=0;
									}
								}
								
								/////// checking Employment Type code
								$sql7 = "SELECT * FROM EmploymentTypeMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array($data[$employment_type],$orgid));
								if($row7=$query7->fetch())
								{
									$data[$employment_type]=$row7->Id;
								}else{
									if($data[$employment_type] != ""){
										$code=substr($data[$employment_type], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO EmploymentTypeMaster (Name, Code,CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$employment_type],$divcode,$mdate,$orgid));
										$data[$employment_type]=$this->db->lastInsertId();
									}else{
										$data[$employment_type]=0;
									}
								}
								
								/////// checking Functional Area Master code
								$sql7 = "SELECT * FROM FunctionalAreaMaster WHERE Name = ? and OrganizationId=?";
								$query7 = $this->db->prepare($sql7);
							
							
								$query7->execute(array($data[$functional_area_code],$orgid));
								if($row7=$query7->fetch())
								{
									$data[$functional_area_code]=$row7->Id;
								}else{
									if($data[$functional_area_code] != ""){
										$sql2 = "INSERT INTO FunctionalAreaMaster (Name, CreatedDate, OrganizationId) values (?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$functional_area_code],$mdate,$orgid));
										$data[$functional_area_code]=$this->db->lastInsertId();
									}else{
										$data[$functional_area_code]=0;
									}
								}
								
								//////////GETTING EMPLOYEESTATUS///////
								/////// checking Functional Area Master code
								
								$sql7 = "SELECT * FROM OtherMaster WHERE OtherType = 'EmployeeStatus' and Lower(DisplayName) = ?";
								$query7 = $this->db->prepare($sql7);
								$query7->execute(array(strtolower($data[$emp_sts])));
								
								if($row7 = $query7->fetch())
								{
									$data[$emp_sts]=$row7->ActualValue;
								}else{
									
									//////On job//////
									$data[$emp_sts]=5;
								}
								
								/////// checking Shift Code
								
									$sql8 = "SELECT * FROM ShiftMaster WHERE Name = ? and OrganizationId=?";
								$query8 = $this->db->prepare($sql8);
							
						//	Utils::Trace($data[$shift_code]);
								$query8->execute(array($data[$shift_code],$orgid));
								if($row8=$query8->fetch())
								{
									$data[$shift_code]=$row8->Id;
								}else{
									if($data[$shift_code] != ""){
										$sql2 = "INSERT INTO ShiftMaster (Name, CreatedDate, OrganizationId) values (?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$shift_code],$mdate,$orgid));
										$data[$shift_code]=$this->db->lastInsertId();
									}else{
										$data[$shift_code]=0;
									}
								}
									//Utils::Trace($data[$shift_code]);
								
								/////// checking Blood Group Code
								
									$sql9 = "SELECT * FROM BloodGroupMaster WHERE Name = ?";
								$query9 = $this->db->prepare($sql9);
							
							
								$query9->execute(array($data[$bloodgrp]));
								if($row9=$query9->fetch())
								{
									$data[$bloodgrp]=$row9->Id;
								}else{
									$data[$bloodgrp]=0;
								}
								
								/////// checking Nationality Master
								
									$sql10 = "SELECT * FROM NationalityMaster WHERE Lower(Name) =   ?";
								$query10 = $this->db->prepare($sql10);
							
							
								$query10->execute(array(strtolower($data[$nat])));
								if($row10=$query10->fetch())
								{
									$data[$nat]=$row10->Id;
								}else{
									$data[$nat]=0;
								}
								
								/////// checking Country Master
								
									$sql11 = "SELECT * FROM CountryMaster WHERE Lower(Name)   = ?";
								$query11 = $this->db->prepare($sql11);
							
							
								$query11->execute(array(strtolower($data[$country])));
								if($row11=$query11->fetch())
								{
									$data[$country]=$row11->Id;
								}else{
									$data[$country]=0;
								}
								
								
									/////// checking Religion Master
								
									$sql12 = "SELECT * FROM ReligionMaster WHERE Lower(Name)   = ?";
								$query12 = $this->db->prepare($sql12);
							
							
								$query12->execute(array(strtolower($data[$religion])));
								if($row12=$query12->fetch())
								{
									$data[$religion]=$row12->Id;
								}else{
									$data[$religion]=0;
								}
								
									/////// checking Desination Code
								
									$sql13 = "SELECT * FROM DesignationMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query13 = $this->db->prepare($sql13);
							
							
								$query13->execute(array($data[$designation],$data[$designation],$orgid));
								if($row13=$query13->fetch())
								{
									$data[$designation]=$row13->Id;
								}else{
									if($data[$designation] != ""){
										$code=substr($data[$designation], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO DesignationMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$designation],$divcode,$mdate,$orgid));
										$data[$designation]=$this->db->lastInsertId();
									}else{
										$data[$designation]=0;
									}
								}
								
								  /////// checking bank code
								$sql14 = "SELECT * FROM BankMaster WHERE (Name = ? or Code=?) and OrganizationId=?";
								$query14 = $this->db->prepare($sql14);
								$query14->execute(array($data[$b_code],$data[$b_code],$orgid));
								if($row14=$query14->fetch())
								{
									$bank_id=$row14->Id;
									$branch=$row14->Description;
								}else{
									$bank_id=0;
									$branch="";
									if($data[$b_code] != ""){
										$code=substr($data[$b_code], 0, 3);
										$divcode=strtoupper($code);
										$sql2 = "INSERT INTO BankMaster (Name, Code, CreatedDate, OrganizationId) values (?,?,?,?)";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$b_code],$divcode,$mdate,$orgid));
										$bank_id=$this->db->lastInsertId();
									}
								}
							//	Utils::Trace($branch);
								
								
								if($data[$gender] == "Male")
									$data[$gender]=1;
								else
									$data[$gender]=2;
								
								if(trim($data[$marital]) == "Single")
									$data[$marital]=1;
								elseif(trim($data[$marital]) == "Married")
									$data[$marital]=2;
								elseif(trim($data[$marital]) == "Widowed")
									$data[$marital]=3;
								elseif(trim($data[$marital]) == "Separated")
									$data[$marital]=4;
								elseif(trim($data[$marital]) == "Divorced")
									$data[$marital]=5;
								elseif(trim($data[$marital]) == "Unmarried")
									$data[$marital]=1;	
									
								if($data[$dob]!=""){
								//$data[$dob]=Utils::getDateformat($data[$dob],'dd-mm-yyyy');
								}else{
									$data[$dob]="0000-00-00";
								}
								
								if($data[$doj]!=""){
								//$data[$doj]=Utils::getDateformat($data[$doj],'dd-mm-yyyy');
								}else{
									$data[$doj]="0000-00-00";
								}
								if($data[$doc]!=""){
								//$data[$doc]=Utils::getDateformat($data[$doc],'dd-mm-yyyy');
								}else{
									$data[$doc]="0000-00-00";
								}
							// if($data[$dol]!=""){
								//$data[$dol]=Utils::getDateformat($data[$dol],'dd-mm-yyyy');
							//	}else{
							//		$data[$dol]="0000-00-00";
							//	} 
								$count1 = 0;
								
								
								
								if($data[$fname] != ""){
									// SQL Query to insert data into DataBase
									$sqll = "SELECT * FROM EmployeeMaster WHERE (CompanyEmail=? or PersonalNo=? ) and (CompanyEmail <>'' or PersonalNo <>'')";
									$queryl = $this->db->prepare($sqll);
									$queryl->execute(array(Utils::encode5t(str_replace(' ','',strtolower($data[$email]))),Utils::encode5t($data[$personal_no])));
								//	echo $z=$queryl->rowCount();exit();
									if($queryl->rowCount()==0){
										$sql1 = "INSERT INTO EmployeeMaster (EmployeeCode, FirstName, LastName, DOB, Nationality, MaritalStatus, Religion, BloodGroup,  DOJ,DOC,   Gender, CurrentContactNumber, PersonalNo, CompanyEmail, CurrentEmailId, EmergencyEmailId, HomeEmailId, CurrentAddress, CurrentCountry, CurrentZipCode,  CreatedDate, MiddleName, EmployeeCTC, OrganizationId, Division, Grade, Department, Location, Shift, FunctionalArea ,EmploymentType, Designation, EmployeeStatus ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";		
									
									
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$emp_code],$data[$fname], $data[$lname],$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doj],$data[$gender],Utils::encode5t($data[$contact_no]),Utils::encode5t($data[$personal_no]),Utils::encode5t(str_replace(' ','',strtolower($data[$email]))),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(strtolower($data[$email])),Utils::encode5t($data[$address]),$data[$country],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$orgid,$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts]));
										
										$count1 =  $query1->rowCount();		
										//Utils::Trace("this is insert part");
									}
									else{
										$sql1 = "UPDATE EmployeeMaster SET EmployeeCode=?, FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?,  DOJ=?,DOC=?, Gender=?,CurrentContactNumber=?, PersonalNo=?, CompanyEmail=?, CurrentEmailId=?,EmergencyEmailId=?,HomeEmailId=?,CurrentAddress=?, CurrentCountry=?, CurrentZipCode=?,  CreatedDate=?, MiddleName=?, EmployeeCTC=?, Division=?, Grade=?,  Department=?, Location=?, Shift=? ,FunctionalArea=?, EmploymentType=?, Designation=?, EmployeeStatus=? WHERE  OrganizationId=? and  CompanyEmail=?";
								
										
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($data[$emp_code],$data[$fname], $data[$lname],$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$doc],$data[$gender],Utils::encode5t(str_replace(' ','',$data[$contact_no])),Utils::encode5t($data[$personal_no]),Utils::encode5t(strtolower($data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t(str_replace(' ','',$data[$email])),Utils::encode5t($data[$address]),$data[$country],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$data[$division],$data[$grade],$data[$department],$data[$location_code],$data[$shift_code],$data[$functional_area_code],$data[$employment_type],$data[$designation],$data[$emp_sts],$orgid, Utils::encode5t(str_replace(' ','',$data[$email]))));
										
										$count1 =  $query1->rowCount();	
									}
								}
							
								if ($count1 == 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = "Employees imported successfully";
								    /////// checking Employee code
									
									$sql16 = "SELECT * FROM EmployeeMaster WHERE EmployeeCode = ? and OrganizationId=?";
									$query16 = $this->db->prepare($sql16);
									$query16->execute(array($data[$emp_code],$orgid));
									if($row16=$query16->fetch())
									{
										$data[$emp_code]=$row16->Id;
											
									}else{
										$data[$emp_code]=0;
									}
									
								     $sql15 = "SELECT * FROM EmployeeBankDetails WHERE EmployeeId=? and BankId=?";
									$query15 = $this->db->prepare($sql15);
									$query15->execute(array($data[$emp_code],$bank_id));
									
									if (($query15->rowcount())>0) {
										$sql17 = "UPDATE EmployeeBankDetails SET IBAN=?,SwiftCode=?,Branch=? WHERE EmployeeId=? and BankId=?";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array(Utils::encode5t($data[$b_acc_no]),Utils::encode5t($data[$b_code]),Utils::encode5t($branch),$data[$emp_code],$bank_id));
										}else{
										$sql17 = "INSERT INTO EmployeeBankDetails (EmployeeId, BankId, SwiftCode,Branch,IBAN) VALUES (?, ?,?,?, ?)";		
										$query17 = $this->db->prepare($sql17);
										$query17->execute(array($data[$emp_code],$bank_id,Utils::encode5t($data[$b_code]),Utils::encode5t($branch), Utils::encode5t($data[$b_acc_no])));
									}
									
									
										/////////////////////////////////////////////////
									/////// checking user master//////
									/////////////////////////////////////////////////
													
									if($data[$email] != ""){
										$sql15 = "SELECT * FROM UserMaster WHERE ( Username=? or username_mobile=?) and (Username <>'' or username_mobile <>'')";
										$query15 = $this->db->prepare($sql15);
										$query15->execute(array(Utils::encode5t(str_replace(' ','',strtolower($data[$email]))) , Utils::encode5t($data[$personal_no])));
										
										if (($query15->rowcount())>0) {
										//	 $sql17 = "UPDATE UserMaster SET Password=?,Username=?,VisibleSts=? WHERE EmployeeId=? and OrganizationId=?";		
										//	$query17 = $this->db->prepare($sql17);
										//	$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(strtolower($data[$email])),1,$data[$emp_code],$orgid)); 
										}else{
											$sql17 = "INSERT INTO UserMaster (Password, Username, VisibleSts, EmployeeId, OrganizationId,username_mobile) VALUES (?, ?, ?,?, ?,?)";		
											$query17 = $this->db->prepare($sql17);
											$query17->execute(array(Utils::encode5t("123456"),Utils::encode5t(str_replace(' ','',strtolower($data[$email]))),1,$data[$emp_code],$orgid,Utils::encode5t($data[$personal_no])));
										}
									}
									$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
									$queryseq = $this->db->prepare($sqlseq);
									$queryseq->execute(array($maxid,$orgid));
									
								} 
							}
						
						}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatemp"] =$c;
		$result["importemp"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	*/
}
