<?php

/**
 * ImportExportModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ImportExportModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

	public function UpdateModuleChildTable()
	{
		$sql = "SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA = 'ubihrm'";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "select Id from ModuleMaster WHERE ModuleName=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->TABLE_NAME));
			if($query1->rowCount()==0)
			{
				$sql2 ="INSERT INTO ModuleMaster(ModuleName, ModuleLabel) VALUES(?,?)";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($row->TABLE_NAME, $row->TABLE_NAME));
			}
		}
		
		$sql = "select Id, ModuleName from ModuleMaster where ReportSts=1";
		$query = $this->db->prepare($sql);
		$query->execute();
		$count =  $query->rowCount();
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$moduleid = $row->Id;
				$modulelabel = $row->ModuleName;
				$sql1 = "describe $modulelabel";
				$query1 = $this->db->prepare($sql1);
				$query1->execute();
				while($row1 = $query1->fetch())
				{
					$column = $row1->Field;
					$sql2 = "Select Id from ModuleChild where  ModuleId=? And ColumnName = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($moduleid, $column));
					if($query2->rowCount()==0)
					{
						$type = substr($row1->Type, 0 ,3);
						$sql2 ="INSERT INTO ModuleChild(ModuleId, ColumnName, ColumnLabel, FieldType) VALUES(?,?,?,?)";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($moduleid, $column, $column, $type));
					}
				}
			}	
		}
	}
   
	public function importfiledata($request)
    {
		try{
		$result = array();
		$count=array();   $errorMsg=""; $successMsg=""; $status=false;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$tablename = $request[2];	
		
		$postdata = json_decode($_POST['columnsdata'], true); 
		//print_r($postdata);
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$loop=0;
						
			$sql =""; $query="";
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				while (($data = fgetcsv($handle, 5000, ",")) !== FALSE) 
				{	
					/*if($loop==0)
					{ 
					}else{
						$sqlcond = "update EmployeeMaster set Division =?, BloodGroup=? where EmployeeCode=?";
						$querycond = $this->db->prepare($sqlcond);
						$querycond->execute(array($data[1], $data[2], $data[0]));
					}
					$name ="";
					for($i=0; $i<count($postdata); $i++)
						{
							if($postdata[$i]['name']=="Name"){
									
								$name = $data[$postdata[$i]['colindex']]; 
							}
						}
					if($name!=""){
							$sqlcond = "select * from $tablename where Name='$name'";
							$querycond = $this->db->prepare($sqlcond);
							$querycond->execute();
							if($querycond->rowCount()>0){
								continue;
							}
					}else{ continue;}*/	
					
					if($loop==0)
					{ 
						$coldata = array();
						$index=0;
						
						$sql = "INSERT INTO $tablename ( ";
						for($i=0; $i<count($postdata); $i++)
						{
							//echo $postdata[$i]['name']." - ".$postdata[$i]['colindex']."<br>";
							if((!empty($postdata[$i]['colindex'])) || $postdata[$i]['colindex']=="0")
							{
								if($index==0){$sql .= $postdata[$i]['name']; 
								}else{$sql .= ", ".$postdata[$i]['name'];} 
								
								//$coldata[$index++] = $data[$postdata[$i]['colindex']];
								$index++;
							}else{
								if($postdata[$i]['name']=="OrganizationId"){
									
									if($index==0){$sql .= $postdata[$i]['name']; 
									}else{$sql .= ", ".$postdata[$i]['name'];} 
									//$coldata[$index++] =$orgid;
								$index++;
								}else if($postdata[$i]['name']=="LastModifiedDate" || $postdata[$i]['name']=="CreatedDate"){
									
									if($index==0){$sql .= $postdata[$i]['name']; 
									}else{$sql .= ", ".$postdata[$i]['name'];} 
									//$coldata[$index++] =$mdate;
								$index++;
								}else if($postdata[$i]['name']=="LastModifiedById" || $postdata[$i]['name']=="CreatedById" || $postdata[$i]['name']=="OwnerId"){
									
									if($index==0){$sql .= $postdata[$i]['name']; 
									}else{$sql .= ", ".$postdata[$i]['name'];} 
									//$coldata[$index++] =$mid;
								$index++;
								}
							}
						}
						
						
						
						$index=0;
						$sql = $sql .",OrganizationId) VALUES (";
						for($i=0; $i<count($postdata); $i++)
						{
							if((!empty($postdata[$i]['colindex'])) || $postdata[$i]['colindex']=="0")
							{
								if($index==0){$sql .= "?"; 
								}else{$sql .= ", ?";} 
								$index++;
							}else{
								if($postdata[$i]['name']=="OrganizationId" || $postdata[$i]['name']=="LastModifiedDate" || $postdata[$i]['name']=="CreatedDate" || $postdata[$i]['name']=="LastModifiedById" || $postdata[$i]['name']=="CreatedById" || $postdata[$i]['name']=="OwnerId"){
									if($index==0){$sql .= "?"; 
									}else{$sql .= ", ?";}
									$index++;
								}
							}
						}
						$sql = $sql .",?)";
						//echo $sql;		
						Utils::Trace($sql);
						$query = $this->db->prepare($sql);
					}else{//if($loop<5){
						//echo $loop." - ".count($data)." - ".$data[0]."<br>";
						//print_r($data);
						$coldata = array();
						$index=0;
						for($i=0; $i<count($postdata); $i++)
						{
							if((!empty($postdata[$i]['colindex'])) || $postdata[$i]['colindex']=="0")
							{
								if($postdata[$i]['type']=="dat"){
									$coldata[$index++] = date("Y-m-d",strtotime(date($data[$postdata[$i]['colindex']])));
								}else{
									$coldata[$index++] = $data[$postdata[$i]['colindex']];
								}								
							}else{
								if($postdata[$i]['name']=="OrganizationId"){
									$coldata[$index++] =$orgid;
								}else if($postdata[$i]['name']=="LastModifiedDate" || $postdata[$i]['name']=="CreatedDate"){
									$coldata[$index++] =$mdate;
								}else if($postdata[$i]['name']=="LastModifiedById" || $postdata[$i]['name']=="CreatedById" || $postdata[$i]['name']=="OwnerId"){
									$coldata[$index++] =$mid;
								}
							}
						}
						$coldata[$index++] =$orgid;
						try{
							$query->execute($coldata);		
							if($query->rowCount()>0){
								$count[] =  1;
							}
						}catch(Exception $e) {
							$errorMsg .= 'Message: ' .$e->getMessage();
						}
					}			
						++$loop;
				}
			}		
		if(count($count)>0)
		{
			$status = true;
			$successMsg =count($count)." record inserted successfully.";
		}else{
			$status = false;
			$errorMsg .= " No record inserted.";
		}
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
			}catch(Exception $e)
			{
				Utils::Trace($e->getMessage());
			}
    }
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		$sql = "UPDATE VisaMaster SET Name=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($request[2], $orgid, $mdate, $mid, $request[3] ));			
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = VISA_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = VISA_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a VisaMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "INSERT INTO VisaMaster (Name, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?)";
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $orgid, $mdate, $mid, $mdate, $mid, $mid));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = VISA_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = VISA_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM VisaMaster WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = VISA_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = VISA_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM VisaMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'VisaMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editvisa/'.$aRow->{$aColumns[$i]}.'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip" title="Delete" data-href="'.URL.'employee/deletevisa/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'employee/viewvisa/'.$aRow->Id.'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
