<?php

/**
 * LeavetypeModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class GrievanceModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM GrievanceMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;   
				
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = NOTIFICATION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$emp="";
		
		$array=array();
        $sql = "SELECT * FROM GrievanceMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			$applist=array();
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['notificationname'] = $row->Name;
				$res['message'] = $row->Message;
				$res['appsts'] = $row->ApproveSts;
				$res['priority']=$row->Priority;
				$res['employeeids']=$row->EmployeeIds;
				$res['applydate']=Utils::dateformatter($row->ApplyDate);
				$res['empname']=Utils::getEmployeeName($row->CreatedById,$this->db);
				//$res['employeeids']=($row->EmployeeIds!="")?explode(",",$row->EmployeeIds):"";
				$sql1 = "SELECT * FROM GrievanceApproval WHERE GrievanceId = :id and ApproverSts<>3";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->ApproverId;
					$res1['name'] = Utils::getName($row1->ApproverId,'EmployeeMaster','FirstName',$this->db).' '.Utils::getName($row1->ApproverId,'EmployeeMaster','LastName',$this->db);
					$res1['appsts'] = $row1->ApproverSts;
					$res1['comment']=$row1->ApproverComment;
					$applist[]=$res1;
				}
				$res['loginid']=$_SESSION['ubihrm_user_id'];
				$res['approverlist']=$applist;
				$data[] = $res;
			}
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if ($count == 1) {
           $status =true;
		   $successMsg = GRIEVANCE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = GRIEVANCE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a DocumentMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		
        /*$empid= "0" ;
		$arr = json_decode($request[5],true);
		if(count($arr) != 0){
		for($i=0;$i<count($arr);$i++)
			{
				$empid =$empid.','.$arr[$i]['id'];
			}
		}*/
		
		$sql = "UPDATE GrievanceMaster SET Name=?, Message=?,  Priority=?,  LastModifiedDate=?, LastModifiedById=?,EmployeeIds=?  where Id=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$empid =Utils::getSeniorId($mid,$this->db);
			$query->execute(array($request[2],$request[3],$request[4],$mdate, $mid,$empid, $request[6] ));			
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			//$empid=Utils::getName($did,'GrievanceMaster','EmployeeIds',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Grievance has been updated of $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Grievance", $msg, $orgid));
           $status =true;
		   $successMsg = GRIEVANCE_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = GRIEVANCE_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a DocumentMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */

    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $empid= "0" ;
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid =Utils::getSeniorId($mid,$this->db);
		$sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";
		$query = $this->db->prepare($sql);
		$hr=0;
		$query->execute(array( $orgid));
		if($r=$query->fetch()){
			$hr=$r->EmployeeId;
		}
		if($empid==0)
			$empid=$hr;
		/*$arr = json_decode($request[4],true);
		if(count($arr) != 0){
		for($i=0;$i<count($arr);$i++)
			{
				$empid =$empid.','.$arr[$i]['id'];
			}
		}*/
		try{
			$sql = "SELECT * FROM GrievanceMaster WHERE Name = ? and Message=? and CreatedById=? and  OrganizationId=? and Priority=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $request[3], $mid,  $orgid, $request[5]));
			if($query->rowCount()==0){
				$sql = "INSERT INTO GrievanceMaster (Name, Message,   EmployeeIds, ApplyDate,  OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId ,Priority) VALUES ( ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?)";
			
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $request[3],  $empid, $mdate,  $orgid, $mdate, $mid, $mdate, $mid, $mid, $request[5] ));
			
				$count =  $query->rowCount();	
				$id=$this->db->lastInsertId();	
				if ($count == 1) {
					//$empid=Utils::getName($did,'GrievanceMaster','EmployeeIds',$this->db);
					$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
					$msg="$empname lodge Grievance ";
					$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($mid, "Grievance", $msg, $orgid));
					$status =true;
					$successMsg = GRIEVANCE_MODULE_CREATION_SUCCESS;
					$sql = "INSERT INTO GrievanceApproval( GrievanceId, ApproverId, ApproverSts, CreatedDate,  OrganizationId)values(?,?,?,?,?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($id,$empid,3,$mdate,$orgid));
					$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
					$seniorname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
					$senioremail=Utils::getName($empid,'EmployeeMaster','CompanyEmail',$this->db);
					$title="Lodged Grievance";
					$msg="<table>
							<tr><td>Hello $seniorname,</td></tr>
							<tr><td>$empname has lodged the Grievance.</td></tr>
							<tr><td>Thanks</td></tr>
					</table>";
					Utils::sendMail($senioremail, $empname ,$title ,$msg);
				} else {
				   $status =false;
				   $errorMsg = GRIEVANCE_MODULE_CREATION_FAILED;
				}
			}
			else {
				   $status =false;
				   $errorMsg = GRIEVANCE_MODULE_CREATION_DUPLICATE;
				}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
		try{
			$sql = "DELETE FROM GrievanceMaster WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$sql = "DELETE FROM GrievanceApproval WHERE GrievanceId= :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count >= 1) {
			$empid=Utils::getName($did,'GrievanceMaster','EmployeeIds',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Grievance has been deleted of $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Grievance", $msg, $orgid));
           $status =true;
		   $successMsg = GRIEVANCE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = GRIEVANCE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function UpdateGrievance($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$sql = "UPDATE GrievanceMaster SET Name=?, Message=?,  Priority=?,  LastModifiedDate=?, LastModifiedById=?,ApplyDate=?,ApproverId=?,ApproveSts=?  where Id=?";
		$query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array($request[2],$request[3],$request[4],$mdate, $mid,$mdate,$mid,$request[7], $request[6] ));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			$empid=Utils::getName($request[6],'GrievanceMaster','EmployeeIds',$this->db);
                $empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Grievance has been updated of $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Grievance Updated", $msg, $orgid));
           $status =true;
		   $successMsg = GRIEVANCE_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = GRIEVANCE_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	public function UpdateGrievanceApproval($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		if($request[5] == 2){
			$sql = "Update GrievanceApproval set ApproverSts=?,ApproverComment=?,ApprovalDate=? where GrievanceId=? and ApproverId=?";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array($request[5],$request[3],$mdate,$request[2],$mid ));			
				$count =  $query->rowCount();
				$approverid	=$mid;	
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
				$empid=Utils::getName($request[2],'GrievanceMaster','EmployeeIds',$this->db);
                $empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Grievance has been Approved of $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Grievance Approval", $msg, $orgid));
				$status =true;
				$successMsg = GRIEVANCE_MODULE_RESOLVE_SUCCESS;
				
			} else {
			   $status =false;
			   $errorMsg = GRIEVANCE_MODULE_UPDATION_FAILED;
			}
		}elseif($request[5] == 3){
			try{
				$sql = "Update GrievanceApproval set ApproverSts=?,ApproverComment=?,ApprovalDate=? where GrievanceId=? and ApproverId=?";
				$query = $this->db->prepare($sql);
				$query->execute(array(4,$request[3],$mdate,$request[2],$mid ));		
				
				$sql = "INSERT INTO GrievanceApproval( GrievanceId, ApproverId, ApproverSts, CreatedDate,  OrganizationId)values(?,?,?,?,?)";
				$query = $this->db->prepare($sql);
				
				$query->execute(array($request[2],$request[4],$request[5],$mdate, $orgid));
				$count =  $query->rowCount();	
				
				$approverid	=$request[4];					
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
				$status =true;
				$successMsg = GRIEVANCE_MODULE_ESCALATE_SUCCESS;
				
				
			} else {
			   $status =false;
			   $errorMsg = GRIEVANCE_MODULE_UPDATION_FAILED;
			}
		}
		elseif($request[5] == 1){
			
			$sql = "Update GrievanceApproval set ApproverSts=?,ApproverComment=?,ApprovalDate=? where GrievanceId=? and ApproverId=?";
			$query = $this->db->prepare($sql);
				
			try{
			$query->execute(array($request[5],$request[3],$mdate,$request[2],$mid ));
			$count =  $query->rowCount();	
			$approverid	=$mid;		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
				$status =true;
				$successMsg = GRIEVANCE_MODULE_DISMISS_SUCCESS;
				
			} else {
				$status =false;
				$errorMsg = GRIEVANCE_MODULE_UPDATION_FAILED;
			}
		}
        $sql = "UPDATE GrievanceMaster SET ApproveSts=?, EmployeeIds=?, LastModifiedDate=?, LastModifiedById=?  where Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[5],$approverid,$mdate,$mid,$request[2]));
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	public function CreateGrievance($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$empid= "0" ;
		$arr = json_decode($request[4],true);
		if(count($arr) != 0){
			for($i=0;$i<count($arr);$i++) {
				$empid =$empid.','.$arr[$i]['id'];
			}
		}
		$sql = "INSERT INTO GrievanceMaster (Name, Message,   EmployeeIds, ApplyDate,  OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId ,Priority,ApproverId,ApproveSts) VALUES ( ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?,?,?)";
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $request[3],  $empid, $mdate,  $orgid, $mdate, $mid, $mdate, $mid, $mid, $request[5],$mid,$request[6] ));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
				//$empid=Utils::getName($request[2],'GrievanceMaster','EmployeeIds',$this->db);
                $empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Grievance has been created";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Grievance Created", $msg, $orgid));
           $status =true;
		   $successMsg = GRIEVANCE_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = GRIEVANCE_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	/**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				if($table  == 'OtherMaster' ){
					
					$name=$row->DisplayName;
				}
				else if($table  == 'EmployeeMaster' ){
					$name=$row->FirstName.' '.$row->LastName;
				}
				else{
				$name = $row->Name;
				}
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getPriority($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE ActualValue = ? AND OtherType = 'Priority'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
					$name=$row->DisplayName;
				
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getApprover($id,$userid)
	{
		$name =false;
		$sql = "SELECT * FROM GrievanceApproval WHERE GrievanceId = ? and ApproverId=? and ApproverSts=3";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id,$userid ));
			while($row = $query->fetch())
			{
				$name=true;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	////////////////////////for grievance table/////////////
	
	public function getGrievanceTable($editper, $deleteper)
	{
		$sTable = 'GrievanceMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'CreatedById','Name', 'Message', 'Priority','ApproveSts','ApplyDate',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		else{
			/*$ids="";
			$sql="SELECT Id FROM EmployeeMaster where ReportingTo=$userid";
			$query = $this->db->prepare($sql);
			$query->execute();
			while($row = $query->fetch()){
				if($ids==""){
						$ids = "FIND_IN_SET(".$row->Id .", EmployeeIds )>0 ";
				}else{
					$ids .="OR FIND_IN_SET(".$row->Id .", EmployeeIds )>0 ";
				}
				
			}
			if($ids!="")
			{
			$ids.=' AND';
			}
			$sWhere = " Where ( $ids  OrganizationId= $orgid OR FIND_IN_SET($userid, EmployeeIds )>0 )";*/
			$sWhere = " WHERE OrganizationId= $orgid AND Id IN (SELECT GrievanceId FROM GrievanceApproval Where ApproverId=$userid )";
		}	
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="CreatedById"){
					$sWhere .= "(CreatedById in (select Id from EmployeeMaster where FirstName "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper  ){
						$approversts=$this->getApprover($aRow->Id,$userid);
						if($approversts && $aRow->ApproveSts==3){
							$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'employee/editgrievance/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-thumbs-up"></i></a>&nbsp;&nbsp;|';
						}
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to resolve"><i class="fa fa-edit"></i></a>&nbsp;&nbsp;|';
					}
					if($deleteper){
					
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
					
					$row[] =$edit."&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="Priority")
				{
					$row[] = $this->getPriority($aRow->{$aColumns[$i]},'OtherMaster');
				}
				
				elseif($aColumns[$i]=="ApproveSts"){
					$row[] = Utils::getgrievancetype($aRow->{$aColumns[$i]});
				}	
				elseif($aColumns[$i]=="CreatedById")
				{	
					$row[] = '<a rel="tooltip"  title="View" href="'.URL.'employee/viewgrievance/'.Utils::encode5t($aRow->Id).'/1">'.Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db).'</a>';
					
				}
				elseif($aColumns[$i]=="ApproverId")
				{
					$name = $this->getName($aRow->{$aColumns[$i]},'EmployeeMaster');
					if($name=="" || $aRow->ApproveSts == 3){
						$row[] = "Waiting for resolve";
					}
					else{
							$row[] = $name;
						}
				}
				else if($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'EmployeeMaster','FirstName',$this->db);
					
				}
				else if($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate" || $aColumns[$i]=="ApplyDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
