<?php

/**
 * GratuityModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class GratuityModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM GratuityMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = GRATUITY_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM GratuityMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['empstsid'] = (int)$row->EmployeeStatusId;
				$res['minexp'] = $row->MinExp;
				$res['maxexp'] = $row->MaxExp;
				$res['payday'] = $row->PayableDays;
				$res['appdate'] = Utils::dateformatter($row->ApplyDate);
				$res['paidyears'] = array();
				
				$sql = "SELECT * FROM GratuityChild WHERE GratuityId = :id";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $id ));
				while($row = $query->fetch())
				{
					$res1 = array();
					$res1['year'] = $row->GratuityYear;
					$res1['days'] = $row->GratuityDays;
					$res['paidyears'][] = $res1;
				}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = GRATUITY_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = GRATUITY_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a GratuityMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$id = Utils::decode5t($request[8]);
		$sql = "UPDATE GratuityMaster SET Name=?, EmployeeStatusId=?, MinExp=?, MaxExp=?, PayableDays=?, ApplyDate=?,  LastModifiedDate=?, LastModifiedById=? where OrganizationId=? and Id=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $this->getDateformat($request[7]), $mdate, $mid, $orgid, $id));			
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		/////////////   GRATUITY CHILD RECORD ENTRY  ////////////////
			$work = json_decode($_POST['gratuitychild'], true); 
			
			$sqlwork = " DELETE FROM GratuityChild WHERE GratuityId=?";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $id));
			
			for($i=0; $i<count($work); $i++)
			{
				$record = array();
				$record[0] = $id;
				$record[1] = $work[$i]['year'];
				$record[2] = $work[$i]['days'];
				$record[3] = 0;
				if($request[5]==0){
					$record[3] = 1;
				}
				$sqlwork = " INSERT INTO GratuityChild (GratuityId, GratuityYear, GratuityDays, GratuityAbove) values (?,?,?,?)";
				$querywork = $this->db->prepare($sqlwork);
				$querywork->execute($record);
			}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = GRATUITY_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = GRATUITY_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a GratuityMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "INSERT INTO GratuityMaster (Name, EmployeeStatusId, MinExp, MaxExp, PayableDays, ApplyDate, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$id =0;
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $this->getDateformat($request[7]), $orgid, $mdate, $mid, $mdate, $mid, $mid));
			
			$id = $this->db->lastInsertId();
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		/////////////   GRATUITY CHILD RECORD ENTRY  ////////////////
			$work = json_decode($_POST['gratuitychild'], true); 
			
			for($i=0; $i<count($work); $i++)
			{
				$record = array();
				$record[0] = $id;
				$record[1] = $work[$i]['year'];
				$record[2] = $work[$i]['days'];
				$record[3] = 0;
				if($request[5]==0){
					$record[3] = 1;
				}
					
				$sqlwork = " INSERT INTO GratuityChild (GratuityId, GratuityYear, GratuityDays, GratuityAbove) values (?,?,?,?)";
				$querywork = $this->db->prepare($sqlwork);
				$querywork->execute($record);
					
				
			}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = GRATUITY_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = GRATUITY_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM GratuityMaster WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = GRATUITY_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = GRATUITY_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM EmploymentStatusMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDateformat($date)
	{	
		$format = $_SESSION['ubihrm_dateformate1'];
		$changedate=$date;
		if($format=="dd/mm/yyyy" || $format=="mm/dd/yyyy" || $format=="yyyy/mm/dd"){
			$temp = explode('/', $date);
			if($format=="dd/mm/yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm/dd/yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}elseif($format=="yyyy/mm/dd"){
				$changedate=$temp[0]."-".$temp[1]."-".$temp[2];
			}
		}elseif($format=="dd-mm-yyyy" || $format=="mm-dd-yyyy" || $format=="yyyy-mm-dd"){
			$temp = explode('-', $date);
			if($format=="dd-mm-yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm-dd-yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}else{
				$changedate=$date;
			}
		}
		return $changedate;
	}
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'GratuityMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'EmployeeStatusId', 'MinExp', 'MaxExp', 'ApplyDate',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editgratuity/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}elseif($aColumns[$i]=="EmployeeStatusId")
				{
					$row[] = ($aRow->{$aColumns[$i]}==1)?"Terminated":"Resigned";
				}elseif($aColumns[$i]=="MinExp" )
				{
					$row[] = $aRow->{$aColumns[$i]}." Yr(s)";
					
				}elseif($aColumns[$i]=="MaxExp")
				{
					if($aRow->MaxExp==0){
						$row[] = " And Above";// $aRow->MinExp." Yr(s) And Above";
					}else{
						$row[] = $aRow->{$aColumns[$i]}." Yr(s)";
					}
				}elseif($aColumns[$i]=="PayableDays")
				{
					$row[] = $aRow->{$aColumns[$i]}." Day(s)";
				}
				elseif($aColumns[$i]=="ApplyDate"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				else if($aColumns[$i]=="Name"){
					$row[] = '<a href="'.URL.'salary/viewgratuity/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
