<?php

/**
 * GradeModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class GradeModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of GRADE
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM GradeMaster WHERE OrganizationId = :id order by GradeLevel";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['idst'] = $row->Id; //////////////use it when use in multiselect/bootstrap select
				$res['name'] = $row->Name;
				$res['NoOfMonths'] = (int)$row->NoOfMonths;
				$res['SalaryIncreament'] =(int) $row->SalaryIncreament;
				$res['level'] = $row->GradeLevel;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=GRADE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function levelDown($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$sql = "SELECT max(GradeLevel) as levelmax FROM GradeMaster";
        $query = $this->db->prepare($sql);
		$query->execute();
		$row1 = $query->fetch();
		$levelmax=$row1->levelmax;
		
        $sql = "SELECT GradeLevel FROM GradeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$level=$row->GradeLevel;
				
				if($level < $levelmax){
					$level1=$level+1;
				
					$sql2 = "UPDATE GradeMaster SET GradeLevel=? WHERE GradeLevel = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($level,$level1 ));
					$sql1 = "UPDATE GradeMaster SET GradeLevel=? WHERE Id = ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($level1,$id ));
					$count =  $query1->rowCount();
				}
				
				
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
			
		if($count>=1)
		{
			$status=true;
			$successMsg=GRADE_MODULE_LEVELDOWN;
        }else{
			$status=false;
			$errorMsg=GRADE_MODULE_UPDATION_FAILED;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function levelUp($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT GradeLevel FROM GradeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$level=$row->GradeLevel;
				$level1 = 1;
				if($level > 1){
					$level1=$level-1;
				}
				$sql2 = "UPDATE GradeMaster SET GradeLevel=? WHERE GradeLevel = ?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($level,$level1 ));
				$sql1 = "UPDATE GradeMaster SET GradeLevel=? WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($level1,$id ));
				$count =  $query1->rowCount();
				
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
			
			
		if($count>=1)
		{
			$status=true;
			$successMsg=GRADE_MODULE_LEVELUP;
        }else{
			$status=false;
			$errorMsg=GRADE_MODULE_UPDATION_FAILED;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM GradeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['code'] = $row->Code;
				$res['description'] = $row->Description;
				$res['nomonths'] = (int)$row->NoOfMonths;
				$res['salincreamentper'] = (int)$row->SalaryIncreament;
				
				$res['gradeid'] = array();
				
				$sql1 = "SELECT * FROM GradeBenefitChild WHERE GradeId = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $row->Id ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['gradeid'] = $row1->GradeId;
					$res1['benefit'] = $row1->BenefitId;
					$res1['amount'] = $row1->BenefitAmount;
					$res['gradeid'][] =$res1;
				}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = GRADE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=GRADE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a GradeMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$gradeid = Utils::decode5t($request[4]);
		
		$sql1 = "SELECT * FROM GradeMaster WHERE Id != ? AND Code = ? AND OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($gradeid, $request[5],$request[1]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=GRADE_MODULE_UPDATION_DUPLICATE;
		}else{
			
			$sql = "UPDATE GradeMaster SET Name=:name, Code = :code,  Description=:desc, OrganizationId=:orgid, LastModifiedDate=:mdate, LastModifiedById=:mid , NoOfMonths =:NoOfMonths, SalaryIncreament=:SalaryIncreament where Id=:id";
		
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array(':name' => $request[2], ':code' => $request[5], ':desc' => $request[3], ':orgid' => $orgid, ':mdate' => $mdate, ':mid' => $mid, ':NoOfMonths' => $request[6], ':SalaryIncreament' => $request[7], ':id' => $gradeid ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			$sql1 = "DELETE FROM GradeBenefitChild WHERE GradeId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($gradeid));	
					
			foreach($_POST['gradebenefits'] as $value)
			{
				if($value['benefit']!="")
				{
					$sql1 = "INSERT INTO GradeBenefitChild (GradeId, BenefitId, BenefitAmount) VALUES (?, ?, ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($gradeid, $value['benefit'], $value['amount']));	
				}
			}
			if ($count == 1) {
			   $status =true;
			   $successMsg = GRADE_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=GRADE_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a GradeMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $gradid=0;
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$sql1 = "SELECT * FROM GradeMaster WHERE Code = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( $request[4], $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status =false;
			 $errorMsg=GRADE_MODULE_CREATION_DUPLICATE;
		}else{
			$sqlmax = "select * from GradeMaster where OrganizationId=?";
			$querymax = $this->db->prepare($sqlmax);
			$querymax->execute(array($orgid));
			$GradeLevel = $querymax->rowCount();
			$GradeLevel = $GradeLevel+1;
			
			$sql = "INSERT INTO GradeMaster ( Name, Code, GradeLevel, Description, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,NoOfMonths,SalaryIncreament) VALUES (:name, :code, :level, :desc, :orgid, :mdate, :mid, :cdate, :cid, :ownerid,:NoOfMonths,:SalaryIncreament)";
			
			try{
								
				$query = $this->db->prepare($sql);
				$query->execute(array( ':name' => $request[2], ':code' => $request[4], ':level'=>$GradeLevel, ':desc' => $request[3], ':orgid' => $orgid, ':mdate' => $mdate, ':mid' => $mid, ':cdate' => $mdate, ':cid' => $mid, ':ownerid' => $mid , ':NoOfMonths' => $request[5], ':SalaryIncreament' => $request[6]));			
				$count =  $query->rowCount();
				$gradid = $this->db->lastInsertId();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			////////////  INSERT GRADE BENEFITS INTO TABLE  /////////////////////
			foreach($_POST['gradebenefits'] as $value)
			{
				if($value['benefit']!="")
				{
					$sql1 = "INSERT INTO GradeBenefitChild (GradeId, BenefitId, BenefitAmount) VALUES (?, ?, ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($gradid, $value['benefit'], $value['amount']));	
				}
			}
			if ($count == 1) {
			   $status =true;
			   $successMsg = GRADE_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=GRADE_MODULE_CREATION_FAILED;
			}
		
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific GRADE
     * @param  $did contains GRADE id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM EmployeeMaster WHERE Grade = :id";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=GRADE_MODULE_DELETE_EXIST;
		}else{
			$sql = "SELECT GradeLevel FROM GradeMaster WHERE Id = :id";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$row = $query->fetch();
			$level = $row->GradeLevel;
			
			$sql = "DELETE FROM GradeMaster WHERE Id = :id ";		
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));			
			$count =  $query->rowCount();	
			
			if ($count >= 1) {
				$sql = "SELECT Id, GradeLevel FROM GradeMaster WHERE GradeLevel > ?";
				$query = $this->db->prepare($sql);
				$query->execute(array( $level));
				while($row1 = $query->fetch())
				{
					$sql1 = "update GradeMaster set GradeLevel=? WHERE Id = ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( ($row1->GradeLevel-1), $row1->Id));
				}
			   $status =true;
			   $successMsg = GRADE_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=GRADE_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM GradeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'GradeMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Code', 'GradeLevel', 'LastModifiedDate','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY   ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete=""; $up=""; $down="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editgrade/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
						
						$up='<a  onclick="angular.element(this).scope().onchangelevel(\'gradelevelup/'.$aRow->Id.'\')" rel="tooltip"  title="One Level up"><i class="fa fa-arrow-up"></i></a>';	
						$down='<a onclick="angular.element(this).scope().onchangelevel(\'gradeleveldown/'.$aRow->Id.'\')" rel="tooltip"  title="One Level down"><i class="fa fa-arrow-down"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip" title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
					
					if($iFilteredTotal==$aRow->GradeLevel){
						$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete."&nbsp;&nbsp;|&nbsp;&nbsp;".$up;
					}elseif($aRow->GradeLevel==1){
						$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete."&nbsp;&nbsp;|&nbsp;&nbsp;".$down ;
					}else{
						$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete."&nbsp;&nbsp;|&nbsp;&nbsp;".$up."&nbsp;&nbsp;".$down ;
					}
					
				}
				
				elseif($aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
			$index++;
		}		
		return  $output ;
	}
}
