<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class GoalsModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		try{
			$sql = "SELECT * FROM GoalMaster WHERE OrganizationId = :id";
			$query = $this->db->prepare($sql);
			
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['gid'] = Utils::encode5t($row->Id);
					$res['dept'] = Utils::getName($row->DepartmentId,"DivisionMaster","Name",$this->db);
					$res['emp'] = Utils::getName($row->EmployeeId,"EmployeeMaster","FirstName",$this->db);
					$res['fromdate'] =  date("d M'y",strtotime($row->StartDate));
					$res['todate'] =  date("d M'y",strtotime($row->EndDate));
					$res['goal'] = $row->Goal;
					$res['status'] =$row->Status ;
					$res['weightage'] =  (int)$row->Weightage;
					$res['taskgiven'] =  (int)$row->TaskNumber;
					$res['quadrant'] =  Utils::getName($row->Quadrant,"Quadrants","Name",$this->db);
					
					
					$departmentgoal = array(); $totalwt=0;
					$sql1 = "SELECT * FROM DepartmentGoals WHERE GoalId = :id ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array(':id' =>  $row->Id ));
					while($row1 = $query1->fetch())
					{
						$res1=array();
						$res1['id'] = $row1->Id;
						$res1['dept'] = $row1->DepartmentId;
						$res1['deptname'] =  Utils::getName($row1->DepartmentId,"DepartmentMaster","Name",$this->db);
						
						$res1['fromdate'] =  date("d M'y",strtotime($row1->StartDate));
						$res1['todate'] =  date("d M'y",strtotime($row1->EndDate));
						$res1['goal'] = $row1->Goal;
						$res1['desc'] = $row1->Description;
						$res1['weightage'] = (int)$row1->Weightage;
						$res1['taskgiven'] =  (int)$row1->TaskNumber;
						$res1['quadrant'] = Utils::getName($row1->Quadrant,"Quadrants","Name",$this->db);
						
						$teamgoal=array(); $departmentwt=0;
						$sql2 = "SELECT * FROM TeamGoals WHERE GoalId = :id and DepartmentId = :did";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array(':id' =>  $row->Id , ':did' =>  $row1->Id));
						while($row2 = $query2->fetch())
						{
							$res2=array();
							$res2['id'] = $row2->Id;
							$res2['empid'] = $row2->EmployeeId;
							$res2['emp'] =  Utils::getName($row2->EmployeeId,"EmployeeMaster","FirstName",$this->db)." ".Utils::getName($row2->EmployeeId,"EmployeeMaster","LastName",$this->db);;
							$imgname =  Utils::getName($row2->EmployeeId,"EmployeeMaster","ImageName",$this->db);
							$pic="";
							$color = sprintf('%06X', mt_rand(0, 16777215));
							$name=$res2['emp'];
							$photo="public/uploads/$orgid/".$imgname;
							$res2['empletter'] =""; 
							if($imgname && file_exists($photo)){
								$res2['empimg'] =URL.$photo;
							}
							else{
								if(isset($name[0])){
									$pic='<p data-letters="'.strtoupper($name[0]).'" style="background-color:#'.$color.'"></p>';
									$res2['empletter'] =strtoupper($name[0]);
								}
							}
							//$res1['empimg'] = $pic;
							
							$res2['fromdate'] =  date("d M'y",strtotime($row2->StartDate));
							$res2['todate'] =  date("d M'y",strtotime($row2->EndDate));
							$res2['goal'] = $row2->Goal;
							$res2['desc'] = $row2->Description;
							$res2['weightage'] =$row2->Weightage;
							$res2['threshold'] =$row2->Threshold;
							$res2['taskgiven'] =  (int)$row2->TaskNumber;
							$res2['givenweightage'] =$this->getEmployeeTaskscount($row2->Id, $row2->EmployeeId);
							$departmentwt=$departmentwt+$res2['givenweightage'] ;
							$res2['quadrant'] = Utils::getName($row2->Quadrant,"Quadrants","Name",$this->db);
							$res2['progress'] =0;  $res2['bonus'] =0;  $res2['salaryincrement'] =0;
							if($res2['taskgiven'] !=0)
								$res2['progress'] =round(($res2['givenweightage']/$res2['taskgiven'] )*100,2);
							//echo $res2['threshold'] ." progress" .$res2['progress'];
							if($res2['progress'] >= $res2['threshold']  ){
								$empdivision=Utils::getName($row2->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
								$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
								
								$res2['currency']=$divcur;
								$res2['bonus']=$this->getEmployeeBonus($row2->EmployeeId,1);
								$res2['salaryincrement']=$this->getEmployeeBonus($row2->EmployeeId,2);
							}	
								
							$teamgoal[]=$res2;
						}
						$res1['givenweightage'] = $departmentwt;
						$res1['progress'] =0;
							if($res1['taskgiven'] !=0)
						$res1['progress'] =round(($res1['givenweightage']/$res1['taskgiven'] )*100,2);
						$totalwt=$totalwt+$res1['givenweightage'];
						$res1['teamgoals']=$teamgoal;
						$departmentgoal[]=$res1;
					}
					
					$res['givenweightage'] =$totalwt;
					$res['progress'] =0;
						if($res['taskgiven'] !=0)
					$res['progress'] =round(($res['givenweightage']/$res['taskgiven'] )*100,2);
					$res['departmentgoal']=$departmentgoal;
					$data[] = $res;
				}
			}else{
				$status=true;
				$successMsg = OBJECTIVE_MODULE_GETALL;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getAllEmployeeGoals()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $_SESSION['ubihrm_user_id'];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid   = $_SESSION['ubihrm_org_id'];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			
		try{
			$sql2 = "SELECT * FROM TeamGoals WHERE EmployeeId = :id ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array(':id' =>  $mid ));
			while($row2 = $query2->fetch())
			{
				$res2=array();
				$res2['id'] = $row2->Id;
				$res2['empid'] = $row2->EmployeeId;
				$res2['emp'] =  Utils::getName($row2->EmployeeId,"EmployeeMaster","FirstName",$this->db)." ".Utils::getName($row2->EmployeeId,"EmployeeMaster","LastName",$this->db);;
				$imgname =  Utils::getName($row2->EmployeeId,"EmployeeMaster","ImageName",$this->db);
				
				$res2['fromdate'] =  date("d M'y",strtotime($row2->StartDate));
				$res2['todate'] =  date("d M'y",strtotime($row2->EndDate));
				$res2['goal'] = $row2->Goal;
				$res2['desc'] = $row2->Description;
				$res2['weightage'] =$row2->Weightage;
				$res2['taskgiven'] =  (int)$row2->TaskNumber;
				$res2['taskcomplete'] =$this->getEmployeeTaskscount($row2->Id, $row2->EmployeeId);
				//$departmentwt=$departmentwt+$res2['givenweightage'] ;
				$res2['quadrant'] = Utils::getName($row2->Quadrant,"Quadrants","Name",$this->db);
				$res2['progress'] =0;
				if($res2['taskgiven'] !=0)
				$res2['progress'] =round(($res2['taskcomplete']/$res2['taskgiven'] )*100,2);
				$data[]=$res2;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		try{
			$sql = "SELECT * FROM GoalMaster WHERE Id = :id";
			$query = $this->db->prepare($sql);
		
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['dept'] = (int)$row->DepartmentId;
				$res['employeeid'] = $row->EmployeeId;
				$res['fromdate'] =  Utils::dateformatter($row->StartDate);
				$res['todate'] =  Utils::dateformatter($row->EndDate);
				$res['goal'] = $row->Goal;
				$res['weightage'] =  (int)$row->Weightage;
				$res['quadrant'] = $row->Quadrant;
				$res['tasknumber'] =(int) $row->TaskNumber;
				$res['groupbudget'] =(int) $row->GroupBudget;
				$res['divbudget'] =(int) $row->DivisionBudget;
				$res['threshold'] =(int) $row->Threshold;
				
				$departmentgoal=array();
				$results=array();
				$sql1 = "SELECT * FROM DepartmentGoals WHERE GoalId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['dept'] = (int)$row1->DepartmentId;
					$res1['goal'] = $row1->Goal;
					$res1['desc'] = $row1->Description;
					$res1['quadrant'] = $row1->Quadrant;
					$res1['weightage'] =  (int)$row1->Weightage;
					$res1['tasknumber'] = (int)$row1->TaskNumber;
					$res1['threshold'] =(int) $row1->Threshold;
					$res1['budget'] =(int) $row1->Budget;
					$sql2 = "SELECT * FROM TeamGoals WHERE GoalId = :id and DepartmentId=:did";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(':id' => $id,':did' => $row1->Id ));
					$teamarr=array();
					while($row2 = $query2->fetch())
					{
						$res2=array();
						$res2['id'] = $row2->Id;
						$res2['employeeid'] =$row2->EmployeeId;
						$res2['goal'] = $row2->Goal;
						$res2['desc'] = $row2->Description;
						$res2['quadrant'] = $row2->Quadrant;
						$res2['weightage'] =  (int)$row2->Weightage;
						$res2['tasknumber'] =(int) $row2->TaskNumber;
						$res2['threshold'] =(int) $row2->Threshold;
						$teamarr[]=$res2;
					}
					$res1['goalsarray'] =  $teamarr;
					$departmentgoal[]=$res1;
				}
				
				
				$sql1 = "SELECT * FROM GoalResult WHERE GoalId = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['minmarks'] = (int)$row1->MinMarks;
					$res1['maxmarks'] = (int)$row1->MaxMarks;
					$res1['result'] = $row1->Result;
					$res1['rating'] =(int) $row1->Rating;
					
					$results[]=$res1;
				}
				
				$res['result']=$results;
				$res['departmentgoal']=$departmentgoal;
				$data[] = $res;
			}
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
           $status =true;
		   $successMsg = OBJECTIVE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = OBJECTIVE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    public function getEmployeeTasks($empid,$goalid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM task_master WHERE assignto = :id AND GoalId=:gid ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $empid ,':gid' => $goalid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['task'] = $row->task_title;
				$res['fromdate'] =  date("d M,y",strtotime($row->fromdate));
				$res['todate'] =  date("d M,y",strtotime($row->todate));
				$res['hours'] = $row->Totalhour;
				$res['desc'] = $row->description;
				$res['status'] = $row->taskstatus;
				$res['goal'] = Utils::getName($row->GoalId,'TeamGoals','Goal',$this->db);
				$res['goalweightage'] = Utils::getName($row->GoalId,'TeamGoals','TaskNumber',$this->db);
				$res['task_no'] = $row->task_no;
				$res['taskstatus'] = $row->taskstatus;
				$res['givenweightage'] = $row->GivenWeightage;
				$res['progress'] =0;
				$res['assignto'] =$row->assignto;
				$res['orgid'] =$row->OrganizationId;
				if($row->GivenWeightage!=0)
					$res['progress'] =round(($res['givenweightage']/$res['goalweightage'] )*100,2);
				$data[] = $res;
			}
			
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getEmployeeAssignTasks($empid,$goalid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM task_master WHERE assignto = :id AND GoalId=:gid  and taskstatus=1";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $empid ,':gid' => $goalid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['task'] = $row->task_title;
				$res['fromdate'] =  date("d M,y",strtotime($row->fromdate));
				$res['todate'] =  date("d M,y",strtotime($row->todate));
				$res['hours'] = $row->Totalhour;
				$res['desc'] = $row->description;
				$res['status'] = $row->taskstatus;
				$res['goal'] = Utils::getName($row->GoalId,'TeamGoals','Goal',$this->db);
				$res['goalweightage'] = Utils::getName($row->GoalId,'TeamGoals','TaskNumber',$this->db);
				$res['task_no'] = $row->task_no;
				$res['taskstatus'] = $row->taskstatus;
				$res['givenweightage'] = $row->GivenWeightage;
				$res['progress'] =0;
				$res['assignto'] =$row->assignto;
				$res['orgid'] =$row->OrganizationId;
				if($row->GivenWeightage!=0)
					$res['progress'] =round(($res['givenweightage']/$res['goalweightage'] )*100,2);
				$data[] = $res;
			}
			
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmployeeComments($goalid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];	
        $sql = "SELECT * FROM GoalComments WHERE TeamGoalId = :id ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $goalid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['comments'] = $row->Comments;
				$res['givenby'] =Utils::getName($row->GivenBy,"EmployeeMaster","FirstName",$this->db);
				$res['givenon'] = date("d M'y h:i:s a",strtotime($row->GivenDate));
				$imgname =  Utils::getName($row->GivenBy,"EmployeeMaster","ImageName",$this->db);
				$pic="";
				$color = sprintf('%06X', mt_rand(0, 16777215));
				$name=$res['givenby'] ;
				$photo="public/uploads/$orgid/".$imgname;
				if($imgname && file_exists($photo)){
					$res['empimg'] =URL.$photo;
				}
				else{
					$pic='<p data-letters="'.strtoupper($name[0]).'" style="background-color:#'.$color.'"></p>';
					$res['empletter'] =strtoupper($name[0]);
				}
				$data[] = $res;
			}
			
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	
    /**
     * Setter for a GoalMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$fromdate=Utils::getDateformat($request[4]);
		$todate=Utils::getDateformat($request[5]);
		$mdate = date("Y-m-d H:i:s");
		try{
			$sql1 = "SELECT * FROM GoalMaster WHERE Id!=? and DepartmentId = ? and OrganizationId=? and EmployeeId=? and Weightage=? and  ((? between  StartDate and EndDate )or (? between StartDate and EndDate ))";
			$query1 = $this->db->prepare($sql1);
		
			$query1->execute(array($request[8], $request[2], $orgid,$request[3],$request[9],Utils::getDateformat($request[4]),Utils::getDateformat($request[5]) ));
			$count1 =  $query1->rowCount();
		
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=OBJECTIVE_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "UPDATE GoalMaster SET DepartmentId =? , EmployeeId =? , StartDate =? , EndDate =? , Goal =? , LastModifiedDate=?, LastModifiedById=?, Weightage=?,Quadrant=?,TaskNumber=?, GroupBudget=?, DivisionBudget=?, Threshold=? where Id=?";
			$query = $this->db->prepare($sql);
			
			
				
				$query->execute(array($request[2],$request[3],Utils::getDateformat($request[4]),Utils::getDateformat( $request[5]),$request[6], $mdate, $mid, $request[9], $request[10], $request[11], $request[12], $request[13], $request[14], $request[8] ));

			
			// INSERTING AND UPDATING OBJECTIVE CHILD IF PASSED AS AN JSON
			$departmentgoal = json_decode($_POST['departmentgoal'], true); 
			$teamgoalsid="0";
			for($i=0; $i<count($departmentgoal); $i++){
				$teamgoalsid .= ",".$departmentgoal[$i]['id'];
			}
			$sqlobjective = " DELETE FROM DepartmentGoals  WHERE GoalId=?  AND Id NOT IN ($teamgoalsid)";
			$queryobjective = $this->db->prepare($sqlobjective);
			$queryobjective->execute(array( $request[8]));
			
			for($i=0; $i<count($departmentgoal); $i++)
			{
				if($departmentgoal[$i]['dept']!="" || $departmentgoal[$i]['goal']!=""){
					$record = array();
					$record[0] = $request[8];
					$record[1] = $departmentgoal[$i]['dept'];
					$record[2] = $departmentgoal[$i]['goal'];
					$record[3] = $mid;
					$record[4] = $mdate;
					$record[5] = $departmentgoal[$i]['weightage'];
					$record[6] = $departmentgoal[$i]['quadrant'];
					$record[7] = $departmentgoal[$i]['tasknumber'];
					$record[8] = $fromdate;
					$record[9] = $todate;
					$record[10] = $departmentgoal[$i]['threshold'];
					$record[11] = $departmentgoal[$i]['budget'];
					$deptid = $departmentgoal[$i]['id'];
					
					if($deptid!=0){
						$sqlobjective = " UPDATE DepartmentGoals SET DepartmentId=?,  Goal=?, LastModifiedById =? , LastModifiedDate =?, Weightage=?, Quadrant=?, TaskNumber=?, StartDate=?, EndDate=? ,Threshold=?,Budget=? where Id=?";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute(array($departmentgoal[$i]['dept'], $departmentgoal[$i]['goal'],$mid, $mdate,$departmentgoal[$i]['weightage'], $departmentgoal[$i]['quadrant'], $departmentgoal[$i]['tasknumber'],$fromdate,$todate, $departmentgoal[$i]['threshold'], $departmentgoal[$i]['budget'], $deptid));
					}else{
						$sqlobjective = " INSERT INTO DepartmentGoals (GoalId, DepartmentId,  Goal, LastModifiedById, LastModifiedDate,Weightage, Quadrant, TaskNumber, StartDate, EndDate,Threshold,Budget) values (?,?,?,?,?,?,?,?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
						$deptid = $this->db->lastInsertId();
						
					}
					
				}
				
				$tgoal="0";
				$teamgoal=$departmentgoal[$i]['goalsarray'];
				for($ii=0; $ii<count($teamgoal); $ii++){
					$tgoal .= ",".$teamgoal[$ii]['id'];
				}
				$sqlobjective = " DELETE FROM TeamGoals  WHERE GoalId=? and DepartmentId=? AND Id NOT IN ($tgoal)";
				$queryobjective = $this->db->prepare($sqlobjective);
				$queryobjective->execute(array( $request[8] ,$deptid));
				
				for($j=0; $j<count($teamgoal); $j++)
				{
					if($teamgoal[$j]['employeeid']!="" || $teamgoal[$j]['goal']!=""){
						$record = array();
						$record[0] = $request[8];
						$record[1] = $teamgoal[$j]['employeeid'];
						$record[2] = $teamgoal[$j]['goal'];
						$record[3] = $mid;
						$record[4] = $mdate;
						$record[5] = $teamgoal[$j]['weightage'];
						$record[6] = $teamgoal[$j]['quadrant'];
						$record[7] = $deptid;
						$record[8] = $teamgoal[$j]['tasknumber'];
						$record[9] = $fromdate;
						$record[10] = $todate;
						$record[11] =$teamgoal[$j]['threshold'];
					
						$id = $teamgoal[$j]['id'];
						
						if($id!=0){
							$sqlobjective = " UPDATE TeamGoals SET EmployeeId=?,  Goal=?, LastModifiedById =? , LastModifiedDate =?, Weightage=?, Quadrant=?, DepartmentId=?, TaskNumber=?, StartDate=?, EndDate=?,Threshold=?  where Id=?";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute(array($teamgoal[$j]['employeeid'], $teamgoal[$j]['goal'],$mid, $mdate,$teamgoal[$j]['weightage'], $teamgoal[$j]['quadrant'], $deptid,  $teamgoal[$j]['tasknumber'],$fromdate,$todate, $teamgoal[$j]['threshold'], $id));
						}else{
							$sqlobjective = " INSERT INTO TeamGoals (GoalId, EmployeeId,  Goal, LastModifiedById, LastModifiedDate,Weightage,Quadrant,DepartmentId, TaskNumber,StartDate, EndDate,Threshold) values (?,?,?,?,?,?,?,?,?,?,?,?)";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute($record);
						}
						
					}
				}
			}
			
			
			
			// INSERTING AND UPDATING ASSESSMENT RESULT IF PASSED AS AN JSON
			$aresult = json_decode($_POST['result'], true); 
			$aresultid="0";
			for($i=0; $i<count($aresult); $i++){
				$aresultid .= ",".$aresult[$i]['id'];
			}
			$sqlaresult = " DELETE FROM GoalResult WHERE GoalId=? AND Id NOT IN ($aresultid)";
			$queryaresult = $this->db->prepare($sqlaresult);
			$queryaresult->execute(array( $request[8]));
			
			for($i=0; $i<count($aresult); $i++)
			{
				if(  $aresult[$i]['result']!=""){
					$record = array();
					$record[0] = $request[8];
					$record[1] = $aresult[$i]['minmarks'];
					$record[2] = $aresult[$i]['maxmarks'];
					$record[3] = $aresult[$i]['result'];
					$record[4] = $aresult[$i]['rating'];
					$id = $aresult[$i]['id'];
					
					if($id){
						$sqlaresult = " UPDATE GoalResult SET GoalId=?, MinMarks=?,MaxMarks=?, Result=?,Rating=? where Id=?";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute(array($request[8],$aresult[$i]['minmarks'],$aresult[$i]['maxmarks'],$aresult[$i]['result'],$aresult[$i]['rating'], $id));
					}else{
						$sqlaresult = " INSERT INTO GoalResult ( GoalId, MinMarks,MaxMarks, Result,Rating) values (?,?,?,?,?)";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute($record);
					}
					
				}
			}		
					
				$count =  $query->rowCount();
				
			
			
			if ($count == 1) {
			    $status =true;
			    $successMsg = "Goal has been configured successfully.";
			 
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while updating record.";
			}
		}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a GoalMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$fromdate=Utils::getDateformat($request[4]);
		$todate=Utils::getDateformat($request[5]);
				
       
		$mdate = date("Y-m-d H:i:s");
		
		
			$sql = "INSERT INTO GoalMaster (DepartmentId , EmployeeId , StartDate , EndDate, Goal, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById,Weightage,Quadrant,TaskNumber,GroupBudget,DivisionBudget,Threshold) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3],Utils::getDateformat($request[4]),Utils::getDateformat($request[5]),$request[6],$orgid, $mdate, $mid, $mdate, $mid,$request[8], $request[9], $request[10], $request[11], $request[12], $request[13]));
				$aid=$this->db->lastInsertId();
				
				// INSERTING AND UPDATING OBJECTIVE CHILD IF PASSED AS AN JSON
				$departmentgoal = json_decode($_POST['departmentgoal'], true); 
				
				for($i=0; $i<count($departmentgoal); $i++)
				{
					if($departmentgoal[$i]['dept']!="" || $departmentgoal[$i]['goal']!=""){
						$record = array();
						$record[0] =$aid;
						$record[1] = $departmentgoal[$i]['dept'];
						$record[2] = $departmentgoal[$i]['goal'];
						$record[3] = $mid;
						$record[4] = $mdate;
						$record[5] = $departmentgoal[$i]['weightage'];
						$record[6] = $departmentgoal[$i]['quadrant'];
						$record[7] = $departmentgoal[$i]['tasknumber'];
						$record[8] = $fromdate;
						$record[9] = $todate;
						$record[10] = $departmentgoal[$i]['threshold'];
						$record[11] = $departmentgoal[$i]['budget'];
						
						$sqlobjective = " INSERT INTO DepartmentGoals (GoalId, DepartmentId, Goal, LastModifiedById, LastModifiedDate, Weightage, Quadrant, TaskNumber, StartDate, EndDate,Threshold,Budget) values (?,?,?,?,?,?,?,?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
						$deptid=$this->db->lastInsertId();

					}
					
					$teamgoal=$departmentgoal[$i]['goalsarray'];
				
					for($j=0; $j<count($teamgoal); $j++)
					{
						if($teamgoal[$j]['employeeid']!="" || $teamgoal[$j]['goal']!=""){
							$record = array();
							$record[0] = $aid;
							$record[1] = $teamgoal[$j]['employeeid'];
							$record[2] = $teamgoal[$j]['goal'];
							$record[3] = $mid;
							$record[4] = $mdate;
							$record[5] = $teamgoal[$j]['weightage'];
							$record[6] = $teamgoal[$j]['quadrant'];
							$record[7] = $deptid;
							$record[8] = $teamgoal[$j]['tasknumber'];
							$record[9] = $fromdate;
							$record[10] = $todate;
							$record[11] =$teamgoal[$j]['threshold'];
						
							$sqlobjective = "INSERT INTO TeamGoals (GoalId, EmployeeId, Goal, LastModifiedById,  LastModifiedDate, Weightage, Quadrant, DepartmentId, TaskNumber, StartDate, EndDate,Threshold) values (?,?,?,?,?,?,?,?,?,?,?,?)";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute($record);
						}
					}
				}
					
				
				
					
				$aresult = json_decode($_POST['result'], true); 
							
				for($i=0; $i<count($aresult); $i++)
				{
					if(  $aresult[$i]['result']!=""){
						$record = array();
						$record[0] = $aid;
						$record[1] = $aresult[$i]['minmarks'];
						$record[2] = $aresult[$i]['maxmarks'];
						$record[3] = $aresult[$i]['result'];
						$record[4] = $aresult[$i]['rating'];
										
						$sqlaresult = " INSERT INTO GoalResult ( GoalId, MinMarks,MaxMarks, Result,Rating) values (?,?,?,?,?)";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute($record);
					}
				}		
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Goal has been configured successfully.";
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while configuring performance.";
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	 public function AddTask($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$title=$request[2];	
		$assignto=$request[3];	
		$GoalId=$request[8];	
		$val=$request[10];	
		$newmindate= date('M d, Y ', strtotime(Utils::getDateformat($request[4])));
		$newmaxdate= date('M d, Y ', strtotime(Utils::getDateformat($request[5])));
       try{
			$mdate = date("Y-m-d H:i:s");
			/////////////////////// To Make task number /////////////////////////
			$task_id="";
			$query1 = $this->db->prepare("SELECT max(id)+1 as maxid FROM task_master");
			$query1->execute();
			if ($row1=$query1->fetch()) {
				$num1 =str_pad($row1->maxid, 4, '0', STR_PAD_LEFT);
				$task_id="TSK-".$num1;
			}
			
			////////////TASK STATUS IS BY DEFAULT PENDING, BUT IF ITS ADDED BY SUPERVISOR OR ADMIN THEN IT IS APPROVED///////////
			
			$tasksts=1;
			if($val==1)
				$tasksts=4;
			
			$sql = "INSERT INTO task_master (task_title , assignto , fromdate , todate, GoalId, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, taskstatus, Totalhour, task_no,description,GivenWeightage) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$request[3],Utils::getDateformat($request[4]),Utils::getDateformat($request[5]),$request[8],$orgid, $mdate, $mid, $mdate, $mid,$tasksts ,$request[6],$task_id, $request[7], $request[9]));
			$aid=$this->db->lastInsertId();
			
			$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				 
				$sendmail=Utils::getSeniorId($assignto,$this->db);
			$assignedtoemail=Utils::decode5t(Utils::getName($assignto,'EmployeeMaster','CompanyEmail',$this->db));
			 $assignedbyemail=Utils::decode5t(Utils::getName($sendmail,'EmployeeMaster','CompanyEmail',$this->db));
			 if($GoalId!=0)
				$goalname=Utils::getName($GoalId,'TeamGoals','Goal',$this->db);
			
			$compeletedlink=URL."approvalbymail/goalstaskcompeleteapproval/$aid/$assignto/$orgid/4";
			$reassignlink=URL."approvalbymail/goalstaskcompeleteapproval/$aid/$assignto/$orgid/5";
			$totalgoal=Utils::getName($GoalId,'TeamGoals','TaskNumber',$this->db);
			//$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
			$assignedbyname=Utils::getEmployeeName($sendmail,$this->db);
			$assignedtoname=Utils::getEmployeeName($assignto,$this->db);
			$sub="New Task $task_id $title is assigned  by $assignedtoname.";
			$msg="
				<table>
				<tr><td>Dear $assignedbyname,</td></tr>
				<tr><td></td></tr>
				<tr><td>Subject: New Task $task_id $title is assigned  by $assignedtoname.</td></tr
				<tr><td>Goal: $goalname </td></tr>
				<tr><td>Task: $title </td></tr>
				<tr><td>Started on: From $newmindate to $newmaxdate </td></tr>
				<tr><td>Duration:  $request[6]</td></tr>
				<tr><td>Achievement:  $request[9] / $totalgoal</td></tr>
				<tr><td>Description: $request[7]</td></tr>";
				if($val!=1){
					
					////////IF TASK ADDEDD BY SUPERVISIOR THEN NO NEED TO SEND THE LINKS///////////
					
					$msg.="<tr><td><br/><br/>
						<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approved</a>
						&nbsp;&nbsp;
						&nbsp;&nbsp;
						<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Rejected</a>
						<br/><br/>
					</td>															
				</tr>";	
				}
				$msg.="</table>";
				/* <tr><td>New task has been assigned.</td></tr>
				<tr><td>Assigned by: $assignedtoname</td></tr> */
			//Utils::Trace($sub." ".$msg);
			//$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
			$sts=Utils::sendMail("monika@ubitechsolutions.com",$assignedtoname,$sub,$msg);
			Utils::Trace($sts." ".$assignedbyemail." ".$sub." ".$msg);
			///// end send mail to assigned_to//////
			   $status =true;
			   $successMsg = "Task has been added successfully.";
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while adding the task.";
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function UpdateTaskMailSts($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$sql1 = "SELECT * FROM task_master WHERE OrganizationId = ? and id =?";
        $query1 = $this->db->prepare($sql1);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query1->execute(array($request[1], $request[2]));
			$count =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			while($row1 = $query1->fetch()) {
				$taskstatus1=$row1->taskstatus;
				$task_no=$row1->task_no;
				$title=$row1->task_title;
				$GoalId=$row1->GoalId;
				$assignedbyid=$row1->CreatedById;
				$assigntoid=$row1->assignto;
				$fromdate=$row1->fromdate;
				$todate=$row1->todate;
				$desc=$row1->description;
			}
        }
		$sql = "UPDATE task_master SET  taskstatus=? where id=?";
		$mdate = date("Y-m-d H:i:s");
		$query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
			$query->execute(array($request[3], $request[2]));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count >= 1) {
			$sql = "INSERT INTO task_comments (taskid,  OrganizationId,  CreatedDate, CreatedBy, comment) VALUES (?, ?, ?, ?, ?)";
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $orgid, $mdate, $mid, $request[4]));
			$count =  $query->rowCount();		
				$assignedtoemail=Utils::decode5t(Utils::getName($assigntoid,'EmployeeMaster','CompanyEmail',$this->db));
				//$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
				if($GoalId!=0)
					$Goalname=Utils::getName($GoalId,'TeamGoals','Goal',$this->db);
				
				$assignedtoname=Utils::getEmployeeName($assigntoid,$this->db);
				$assignedbyname=Utils::getEmployeeName($mid,$this->db);
				if($request[3]==4)
				$sub="Task is Approved: $task_no- $title";
				if($request[3]==5)
				$sub="Task is Reject: $task_no- $title";
				$msg="
				<table>
				<tr><td>Dear $assignedtoname,</td></tr>
				<tr><td></td></tr>
				<tr><td>Task: $task_no- $title has been completed by $assignedbyname.</td></tr>
				<tr><td>Project: $Goalname</td></tr>
				<tr><td>Task: $title</td></tr>
				<tr><td>Remark: $request[4]</td></tr>
				
				</table>";
				$sts= Utils::sendMail($assignedtoemail,$assignedbyname,$sub,$msg);
				Utils::Trace($sts." ".$assignedtoemail." ".$sub." ".$msg);
				// end send mail to assigned to//
		
		   $status =true;
		   if($request[3]==4)
		   $successMsg = "Task has been approved successfully";
			if($request[3]==5)
			$successMsg = "Task has been reject";
		} else {
		   $status =false;
		   $errorMsg = TASK_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
  public function AddComments($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
       try{
			$mdate = date("Y-m-d H:i:s");
			/////////////////////// To Make task number /////////////////////////
			
			$sql = "INSERT INTO GoalComments (TeamGoalId , Comments , GivenBy , GivenDate) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$request[3],$mid,$mdate));
			$aid=$this->db->lastInsertId();
			
			$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Comments has been given successfully.";
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while giving the comments.";
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		try{
			$sql = "Select * from GoalMaster WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch()){
				$aid=$row->DesignationId;
				$sql2 = "Select * from EmployeeMaster WHERE Designation = :id ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array(':id' => $aid));	
				while($row2=$query2->fetch()){
					$eid=$row2->Id;
					$sql3 = "Select * from EmployeeAssessment WHERE EmployeeId = :id ";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array(':id' => $eid));	
					while($row3=$query3->fetch()){
						$count1++;
					}
				}
				if($count1>=1){
					$status =false;
					$errorMsg = OBJECTIVE_MODULE_DELETE_EXIST;
				
				}else{
						$sql1 = "DELETE FROM GoalMaster WHERE Id = :id ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(':id' => $did));
						
						$sql1 = "DELETE FROM GoalMasterChild WHERE GoalMasterId = :id ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(':id' => $did));
					
						$count =  $query1->rowCount();		
					
					
					if ($count == 1) {
					   $status =true;
					   $successMsg = OBJECTIVE_MODULE_DELETE_SUCCESS;
					}else {
					   $status =false;
					   $errorMsg = OBJECTIVE_MODULE_DELETE_FAILED;
					}
				}
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function getSeniorDesigs($desig)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $level=1;
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = "0";
		$res = array();
		$res['id'] = $desig;
		$res['name'] = $this->getName($desig,'DesignationMaster');
		$res['level'] = $level;
		$data[] = $res;
		$parentid=$desig;
		try{
			if($parentid!="0" && $parentid!="")
			{
				while($parentid!="")
				{
					
					$sql1 = "SELECT * FROM DesignationMaster WHERE OrganizationId = ? and Id in ( $parentid ) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($orgid));
					$count=$query1->rowCount();
					$parentid="";
					
					while($row1 = $query1->fetch())
					{
						$level++;
						if($parentid==""){
							$parentid = $row1->RoleId;
						}else{
							$parentid .= ", ".$row1->RoleId;
						}
						if($row1->RoleId != 0){
							$res = array();
							$res['id'] = $row1->RoleId;
							$res['name'] = $this->getName($row1->RoleId,'DesignationMaster');
							$res['level'] = $level;
							
							$data[] = $res;
							
						}
					
					}
				
				}
			}
		}catch(Exception $e){
			$status =false;
		   $errorMsg = $e->getMessage();
		}
		if ($count >= 1) {
           $status =true;
		   $successMsg = DESIGNATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = DESIGNATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
			
	}
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeTaskscount($goalid,$empid)
	{
		$count =0;
		$sql = "SELECT GivenWeightage FROM task_master WHERE assignto = ? and GoalId=? and taskstatus=4";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid, $goalid ));
			while($row = $query->fetch())
			{
				$count = $count + $row->GivenWeightage;
			}
		}catch(Exception $e) {
			
		}
		return $count;
	}
	
	public function getEmployeeBonus($empid,$val)
	{
		$count =""; $data =""; $field="NoOfMonths";
		$basesalary=Utils::getEmployeeBasicSalary($empid, $this->db);
		if($val==2)
			$field="SalaryIncreament";
		$sql = "SELECT $field FROM EmployeeMaster WHERE Id = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid));
			while($row = $query->fetch())
			{
				$data =  $row->$field;
				
			}
			if($data==""){
				$grade=Utils::getName($empid, "EmployeeMaster", "Grade", $this->db);
				$sql = "SELECT $field FROM GradeMaster WHERE Id = ? ";
				$query = $this->db->prepare($sql);
				$query->execute(array( $grade));
				while($row = $query->fetch())
				{
					$data =  $row->$field;
				}
			}
			$count =  $data*$basesalary;
			if($val==2)
				$count =  round($basesalary*($data/100),2);	
		}catch(Exception $e) {
			
		}
		return $count;
	}
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'GoalMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'DepartmentId','EmployeeId' ,'Goal','StartDate', 'EndDate','Status','Id','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$mid=$_SESSION['ubihrm_user_id'];
		$desig=Utils::getName($mid,'EmployeeMaster','Designation',$this->db);
		$ids=Utils::getReportingIds($mid,$this->db);
		$desigids=Utils::getJuniorDesigs($desig,$this->db);
		$sWhere = "WHERE OrganizationId= $orgid  and (DesignationId in (select Designation FROM EmployeeMaster where Id in ($ids)) or DesignationId in ($desigids))";
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="DesignationId"){
				$sWhere .= "(DesignationId in ( select Id from DesignationMaster where Name "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id" )
				{
					$edit =""; $delete=""; $tasks=""; $comments="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performance/editgoals/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
						
						$tasks = '<a rel="tooltip"  title="Tasks" onclick="angular.element(this).scope().gettasks(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#tasks" href="#" ><i class="fa fa-bars"></i></a>';
						
						$comments = '<a rel="tooltip"  title="Comments" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#comments" href="#" ><i class="fa fa-comments-o"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
					if($i==6)
						$row[]="";
					else
						$row[] =$comments."&nbsp;&nbsp;|&nbsp;&nbsp;".$tasks ."&nbsp;&nbsp;|&nbsp;&nbsp;".$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="DepartmentId")
				{
					$row[] = '<a href="'.URL.'performance/viewgoals/'.Utils::encode5t($aRow->Id).'/1">'.$this->getName($aRow->{$aColumns[$i]},'DepartmentMaster').'</a>';
					
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[] =Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db);
					
				}
				else if($aColumns[$i]=="StartDate" || $aColumns[$i]=="EndDate")
				{
					$row[] =Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="Status" )
				{
					if($aRow->{$aColumns[$i]} == 0)
						$row[] ="<label class='badge bg-red'>Not Completed</label>";
					else 
						$row[] ="<label class='badge bg-green'>Completed</label>";
					
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
