<?php

/**
 * FunctionalareaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class FunctionalareaModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM FunctionalAreaMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = FUNCAREA_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM FunctionalAreaMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = FUNCAREA_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = FUNCAREA_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a FunctionalAreaMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		$sql = "UPDATE FunctionalAreaMaster SET Name=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($request[2], $orgid, $mdate, $mid, $request[3] ));			
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = FUNCAREA_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = FUNCAREA_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a FunctionalAreaMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$sql="select Name from FunctionalAreaMaster where Name=? and OrganizationId=?";
		$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$orgid));
			$count =  $query->rowCount();
			if ($count >0)
			{		
		$result["data"] =$data;
		$result['status']=false;
		$result['successMsg']=$successMsg;
		$result['errorMsg']="This FunctionalArea is already exist";
		 return $result;
			}
			$sql = "INSERT INTO FunctionalAreaMaster (Name, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $orgid, $mdate, $mid, $mdate, $mid, $mid));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = FUNCAREA_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = FUNCAREA_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT Id FROM EmployeeMaster WHERE FunctionalArea = :id";
        	$query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=FUNCAREA_MODULE_DELETE_EXIST;
		}else{
		
			$sql = "DELETE FROM FunctionalAreaMaster WHERE Id = :id ";
		
			try{
			
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
		
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
			if ($count == 1) {
			   $status =true;
				   $successMsg = FUNCAREA_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
				   $errorMsg = FUNCAREA_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM FunctionalAreaMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'FunctionalAreaMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editfunctionalarea/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
					
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'employee/viewfunctionalarea/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				else if($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'EmployeeMaster','FirstName',$this->db);
					
				}
				else if($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
