<?php

/**
 * DiscussionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class FeedbackModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getsendmsg()
    {
	try {
		$mid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
			
		$sql = "SELECT * FROM Continuousfeedback where CreatedById=? and OrganizationId=? order by CreatedDate desc";
		
		$query = $this->db->prepare($sql);
        $query->execute(array($mid,$orgid));
        $result =array(); $data=array(); 
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->id;
			$res['emp_id1'] = self::getName($row->emp_id);
			$res['emp_id'] = Utils::getName($row->emp_id,'EmployeeMaster','FirstName',$this->db)." ".Utils::getName($row->emp_id,'EmployeeMaster','LastName',$this->db);
			$res['desi'] =Utils::getName(Utils::getName($row->emp_id,'EmployeeMaster','Designation',$this->db),'DesignationMaster','Name',$this->db); 
			$res['img']="";
			$image=Utils::getName($row->emp_id,'EmployeeMaster','ImageName',$this->db);
			if (file_exists( "public/uploads/$orgid/$image")) {
				
				$res['img']= URL."public/uploads/$orgid/$image";
			}
			if($image == ""){
				if(Utils::getName($row->emp_id,'EmployeeMaster','Gender',$this->db)== 1)
				{
					$res['img']= URL."public/avatars/male.png";
				}
				else{
					$res['img']= URL."public/avatars/female.png";
				}
			
			}
			//$res['img'] = $res['emp_id1']['img'];
			$res['owner_id'] =self::getName($row->CreatedById);
			$res['category'] = Utils::getName($row->category,'CategoryMaster','Name',$this->db);
			$res['rating1'] = $row->rating;
			if($row->rating==1){
				$res['rating'] = URL."public/uploads/1.jpg";
			}
			
			else if($row->rating==2 ){
				$res['rating'] = URL."public/uploads/2.png";
			}
			
			else if($row->rating==3 ){
				$res['rating'] = URL."public/uploads/thumbsdown.gif";
			}
			
			else if($row->rating==4 ){
				$res['rating'] = URL."public/uploads/4.jpg";
			}
			
			else if($row->rating==5 ){
				$res['rating'] = URL."public/uploads/thumpup.gif";
			} 			
			
			$res['remark'] =$row->remark;
			$res['CreatedDate'] = date('d F Y', strtotime($row->CreatedDate));
		
			$data[] =$res;
		}
      }catch(Exception $e){}
		$result['status']=true;
		$result['data']=$data;
		return $result;
       
    }
	
	public function getreceivemsg()
    {
	try {
		$mid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
			
		$sql = "SELECT * FROM Continuousfeedback where emp_id=? and OrganizationId=? order by CreatedDate desc";
		
		$query = $this->db->prepare($sql);
        $query->execute(array($mid,$orgid));
       $result =array(); $data=array(); 
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->id;
			$res['emp_id'] = self::getName($row->emp_id);
			$res['owner_id1'] =self::getName($row->CreatedById);
			$res['owner_id'] = $res['owner_id1']['name'];
			$res['desi'] = $res['owner_id1']['desi'];
			$res['img'] = $res['owner_id1']['img'];
			
			$res['category'] = Utils::getName($row->category,'CategoryMaster','Name',$this->db);
			$res['rating1'] = $row->rating;

			if($row->rating==1){
				$res['rating'] = URL."public/uploads/1.jpg";
			}
			
			else if($row->rating==2 ){
				$res['rating'] = URL."public/uploads/2.png";
			}
			
			else if($row->rating==3 ){
				$res['rating'] = URL."public/uploads/thumbsdown.png";
			}
			
			else if($row->rating==4 ){
				$res['rating'] = URL."public/uploads/4.jpg";
			}
			
			else if($row->rating==5 ){
				$res['rating'] = URL."public/uploads/thumpup.gif";
			} 			
			$res['remark'] =$row->remark;
			$res['CreatedDate'] = date('F d Y', strtotime($row->CreatedDate));
		
			$data[] =$res;
		}
      }catch(Exception $e){}
		$result['status']=true;
		$result['data']=$data;
		return $result;
       
    }
	
	public function getallfeedback()
    {
	try {
		$mid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
		$admin = $_SESSION['ubihrm_user_sts'];
		$hr = $_SESSION['ubihrm_hr_sts'];
		$fromdate=isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";	
		$todate=isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";	
		$empid=isset($_POST['empid'])?($_POST['empid']):"";	
		$empid1=is_array($empid)?implode(',',$empid):$empid;	
		$where="";
		if($fromdate!="" && $todate!=""){
			$where=" and (FeedbackDate between '$fromdate' and '$todate')";
		}
		if($empid!=""){
			$where.=" and emp_id in ($empid1)";
		}
		$sql = "SELECT * FROM Continuousfeedback where emp_id in (select Id from EmployeeMaster where ReportingTo = $mid) and OrganizationId=? $where order by CreatedDate desc";
		if($admin || $hr)
			$sql = "SELECT * FROM Continuousfeedback where OrganizationId=? $where order by CreatedDate desc";
		
		$query = $this->db->prepare($sql);
        $query->execute(array($orgid));
       $result =array(); $data=array(); 
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->id;
			$res['emp_id'] = self::getName($row->emp_id);
			$res['owner_id1'] =self::getName($row->CreatedById);
			$res['owner_id'] = $res['owner_id1']['name'];
			$res['desi'] = $res['owner_id1']['desi'];
			$res['img'] = $res['owner_id1']['img'];
			
			$res['category'] = Utils::getName($row->category,'CategoryMaster','Name',$this->db);
			$res['rating1'] = $row->rating;

			if($row->rating==1){
				$res['rating'] = URL."public/uploads/1.jpg";
			}
			
			else if($row->rating==2 ){
				$res['rating'] = URL."public/uploads/2.png";
			}
			
			else if($row->rating==3 ){
				$res['rating'] = URL."public/uploads/thumbsdown.png";
			}
			
			else if($row->rating==4 ){
				$res['rating'] = URL."public/uploads/4.jpg";
			}
			
			else if($row->rating==5 ){
				$res['rating'] = URL."public/uploads/thumpup.gif";
			} 			
			$res['remark'] =$row->remark;
			$res['CreatedDate'] = date('F d Y', strtotime($row->CreatedDate));
		
			$data[] =$res;
		}
      }catch(Exception $e){}
		$result['status']=true;
		$result['data']=$data;
		return $result;
       
    }
	public function getexternalfeedback()
    {
	try {
		$mid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
			
		$sql = "SELECT * FROM ExternalFeedback where EmployeeId=? and OrganizationId=? order by  RequestedDate desc";
		
		$query = $this->db->prepare($sql);
        $query->execute(array($mid,$orgid));
        $result =array(); $data=array(); 
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->Id;
			$res['fid'] = Utils::encode5t($row->Id);
			$res['emp'] = Utils::getEmployeeName($row->EmployeeId,$this->db);
			$res['requestedby'] =Utils::getEmployeeName($row->CreatedById,$this->db);
			$res['name'] = $row->Name;
			$res['desig'] = $row->Designation;
			$res['company'] = $row->Company;
			$res['sts'] = $row->Sts;
			$res['feedbackdate'] = ($row->FeedbackDate != "")? date('F d Y', strtotime($row->FeedbackDate)):"";
			
			$res['ratings'] =$row->Ratings;
			$res['remark'] =$row->Remarks;
			$res['fromdate'] =Utils::dateformatter($row->FromDate);
			$res['todate'] =Utils::dateformatter($row->ToDate);
			
			$res['requeston'] =($row->RequestedDate != "")? date('F d Y', strtotime($row->RequestedDate)):"";
			
			$skills=array();
			$sql1 = "SELECT * FROM FeedbackSkills where FeedbackId=? ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->Id));
			
			while($row1 = $query1->fetch())
			{
				$res1=array();
				$res1['id']=$row1->Id;
				$res1['skill']=$row1->Skill;
				$res1['rating']=$row1->Rating;
				$skills[]=$res1;
			}
			$res['skills']	= $skills;		
			$data[] =$res;
		}
      }catch(Exception $e){}
		$result['status']=true;
		$result['data']=$data;
		return $result;
       
    }
	
	public function getallexternalfeedback()
    {
	try {
		$mid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
		$admin = $_SESSION['ubihrm_user_sts'];
		$hr = $_SESSION['ubihrm_hr_sts'];
		
		$fromdate=isset($_POST['fromdate'])?Utils::getDateformat($_POST['fromdate']):"";	
		$todate=isset($_POST['todate'])?Utils::getDateformat($_POST['todate']):"";	
		$val=isset($_POST['val'])?($_POST['val']):"";	
		$empid=isset($_POST['empid'])?($_POST['empid']):"";	
		$empid1=is_array($empid)?implode(',',$empid):$empid;	
		$where="";
		if($fromdate!="" && $todate!=""){
			if($val==1){
				$where=" and (FeedbackDate between '$fromdate' and '$todate')";
			}if($val==2){
				$where=" and (date(RequestedDate) between '$fromdate' and '$todate')";
			}
		}
		if($empid!=""){
			$where.=" and EmployeeId in ($empid1)";
		}
		$sql = "SELECT * FROM ExternalFeedback where EmployeeId in (select Id from EmployeeMaster where ReportingTo = $mid) and OrganizationId=? $where order by  RequestedDate desc";
		if($admin || $hr)
			$sql = "SELECT * FROM ExternalFeedback where  OrganizationId=? $where order by  RequestedDate desc";
		$query = $this->db->prepare($sql);
        $query->execute(array($orgid));
        $result =array(); $data=array(); 
        while($row = $query->fetch())
        {
			$res= array();
			$res['id'] = $row->Id;
			$res['fid'] = Utils::encode5t($row->Id);
			$res['emp'] = Utils::getEmployeeName($row->EmployeeId,$this->db);
			$empd = Utils::getName($row->EmployeeId,"EmployeeMaster","Designation",$this->db);
			$res['empdesig'] = Utils::getName($empd,"DesignationMaster","Name",$this->db);
			$res['requestedby'] =Utils::getEmployeeName($row->CreatedById,$this->db);
			$res['name'] = $row->Name;
			$res['desig'] = $row->Designation;
			$res['company'] = $row->Company;
			$res['sts'] = $row->Sts;
			$res['feedbackdate'] = ($row->FeedbackDate != "")? date('F d Y', strtotime($row->FeedbackDate)):"";
			
			$res['ratings'] =$row->Ratings;
			$res['remark'] =$row->Remarks;
			$res['fromdate'] =Utils::dateformatter($row->FromDate);
			$res['todate'] =Utils::dateformatter($row->ToDate);
			
			$res['requeston'] =($row->RequestedDate != "")? date('F d Y', strtotime($row->RequestedDate)):"";
			
			$skills=array();
			$sql1 = "SELECT * FROM FeedbackSkills where FeedbackId=? ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->Id));
			
			while($row1 = $query1->fetch())
			{
				$res1=array();
				$res1['id']=$row1->Id;
				$res1['skill']=$row1->Skill;
				$res1['rating']=$row1->Rating;
				$skills[]=$res1;
			}
			$res['skills']	= $skills;		
			$data[] =$res;
		}
      }catch(Exception $e){}
		$result['status']=true;
		$result['data']=$data;
		return $result;
       
    }
	public function getDetail($id){
		try {
			$count1=0;$count=0;$result =array(); $data=array(); 
			//$mid = $_SESSION['ubihrm_user_id'];
			//$orgid = $_SESSION['ubihrm_org_id'];
			$orgid=Utils::getName($id,'ExternalFeedback','OrganizationId',$this->db);
			$sqlq="select * from Organization where Id=$orgid";
			$query=$this->db->prepare($sqlq);
			$query->execute();
			$count1=$query->rowCount();
			if($count1==1){
				while($rowq=$query->fetch()){
					$res=array();
					$res['id']=$rowq->Id;
					$res['Name']=$rowq->Name;
					$res['Website']=$rowq->Website;
					$res['PhoneNumber']=$rowq->PhoneNumber;
					$res['AltPhoneNumber']=$rowq->AltPhoneNumber;
					$res['Email']=$rowq->Email;
					$res['AltEmail']=$rowq->AltEmail;
					$res['logo'] = URL."public/uploads/$orgid/".$rowq->Logo;
					$res['Address']=$rowq->Address;
					$res['ZipCode']=$rowq->ZipCode;
					$res['Landmark']=$rowq->Landmark;
					$res['smtpuser']=$rowq->smtpuser;
					$res['Country']=Utils::getName($rowq->Country, "CountryMaster", "Name", $this->db);
					$res['City']=Utils::getName($rowq->Country, "CityMaster", "Name", $this->db);
					$data['companydetails']=$res;
				}
			}
			$sql = "SELECT * FROM ExternalFeedback where Id=? ";
			$query1 = $this->db->prepare($sql);
			$query1->execute(array($id));
			while($row = $query1->fetch()){
				$res= array();
				$res['id'] = $row->Id;
				$res['EmployeeId'] = $row->EmployeeId;
				$res['employee'] =Utils::getEmployeeName($row->EmployeeId,$this->db);
				$desig=Utils::getName($row->EmployeeId, "EmployeeMaster", "Designation", $this->db);
				$depart=Utils::getName($row->EmployeeId, "EmployeeMaster", "Department", $this->db);
				$res['designation']=Utils::getName($desig, "DesignationMaster", "Name", $this->db);
				$res['department']=Utils::getName($depart, "DepartmentMaster", "Name", $this->db);
				$res['FromDate']=date('d F Y',strtotime($row->FromDate));
				$res['ToDate']=date('d F Y',strtotime($row->ToDate));
				$res['starrating']=$row->Ratings;
				$res['remarks']=$row->Remarks;
				$res['sts'] =$row->Sts;
				
				$sqls="select * from FeedbackSkills where FeedbackId=?";
				$querys=$this->db->prepare($sqls);
				$querys->execute(array($row->Id));
				$count=$querys->rowCount();
				if($count>=1){
					while($rows=$querys->fetch()){
						$res1=array();
						$res1['Id']=$rows->Id;
						$res1['Skill']=$rows->Skill;
						$res1['Rating']=$rows->Rating;
						$res['feedskill'][]=$res1;
					}
				}
				$res['totalskill'] =$count;
				$data[] =$res;
			}
		}catch(Exception $e){}
		$result['status']=true;
		$result['data']=$data;
		return $result;
    }
	///////////////////////////////////Project Milestone/////////////////////////////////
  	////// test for project model //////
	public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM project_master WHERE id != ? and project_title = ? and owner_id=? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[8], $request[6],$request[2],$request[1]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=BANK_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "UPDATE project_master SET project_title=?, start_date=?, completed_date=?, owner_id =?, project_desc=?, updated_by=?, update_on=?, assigned_to=?, OrganizationId=? where id=?";
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				$assignto = is_array($request[7]) ? implode(',',$request[7]): $request[7];
				$from = Utils::getDateformat($request[3]);
				$to = Utils::getDateformat($request[4]);
				$query = $this->db->prepare($sql);
				$query->execute(array($request[6],$from,$to, $request[2], $request[5], $mid, $mdate, $assignto, $orgid,$request[8]));
				
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				$projectid = $request[8];
				$sqlwork = " DELETE from timesheet_master where project_id=?";
				$querywork = $this->db->prepare($sqlwork);
				$querywork->execute(array($projectid));
				
				$work = json_decode($_POST['timesheet'], true); 
					for($i=0; $i<count($work); $i++)
					{
						if($work[$i]['taskid']!="" and $work[$i]['assignto']!="" ){
							$res1 =array();
							$res1[0]= $work[$i]['priority'];
							$res1[1]= $projectid;
							
							$res1[2]= $work[$i]['taskid'];
							$res1[3]= $work[$i]['assignto'];
						
							$res1[4] = Utils::getDateTimeformat($work[$i]['sdate']);
							$res1[5] = Utils::getDateTimeformat($work[$i]['edate']);
							$res1[6] = $mdate; $res1[7] = $mdate;
							$res1[8] = 1; $res1[9] = $mdate;
							$res1[10] = $orgid;
							$sqlsalary = " INSERT INTO timesheet_master (priority,project_id, task_id, EmployeeId, start_time, end_time, created_date, updated_date , time_status, timesheet_date, OrganizationId) values (?,?,?,?,?,?,?,?,?,?,?)";
							$querysalary = $this->db->prepare($sqlsalary);
							$querysalary->execute($res1);
						}
					}
				 $status =true;
			   $successMsg = "Project has been updated successfully";
			} else {
			   $status =false;
			   $errorMsg = BANK_MODULE_UPDATION_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
    /**
     * Setter for a project_master (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $category="";
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$msg=""; $name=""; $i=1; $rating="";
		$sql = "INSERT INTO Continuousfeedback( emp_id, category, rating, remark, CreatedDate, LastModifiedDate, CreatedById,OrganizationId, FeedbackDate ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3],$request[4],$request[5],$mdate, $mdate, $mid, $orgid,$mdate));
			
				$count =  $query->rowCount();
				
				$sql="SELECT * from EmployeeMaster where Id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2]));
				while($row=$query->fetch()) {
					$user_email=Utils::decode5t($row->CompanyEmail);
					$user_name=Utils::getEmployeeName($mid,  $this->db);
				}
			//	$name = Utils::getEmployeeName($mid,$this->db);
				$senderpic = Utils::getName($mid, "EmployeeMaster", "ImageName", $this->db);
				$gender = Utils::getName($mid, "EmployeeMaster", "Gender", $this->db);
				if($senderpic == ""){
					if($gender== 1)
					{
						$senderpic= URL."public/avatars/male.png";
					}
					else{
						$senderpic= URL."public/avatars/female.png";
					}
				
				}
				else
				{
						$senderpic= URL."public/uploads/$orgid/$senderpic";
					
				}
				for($i=1; $i<=$request[4];$i++)
				{
					 $rating = $rating."<span style='font-size:20px'>&nbsp;&nbsp;*</span>";
				}
				$feedbackdate =date('F d Y', strtotime($mdate));
				$desig = Utils::getName($mid, "EmployeeMaster", "Designation", $this->db);
				$senderdesig = Utils::getName($desig, "DesignationMaster", "Name", $this->db);
				
				if($request[4] == 1){
					$category = URL."public/uploads/1.jpg";
				}
				
				else if($request[4] == 2 ){
					$category = URL."public/uploads/2.png";
				}
				
				else if($request[4] == 3 ){
					$category = URL."public/uploads/thumbsdown.png";
				}
				
				else if($request[4] == 4 ){
					$category = URL."public/uploads/4.jpg";
				}
				
				else if($request[4] == 5 ){
					$category = URL."public/uploads/thumpup.gif";
				} 		
				
				$category_name = Utils::getName($request[3],'CategoryMaster','Name',$this->db);

				
				$msg="
					<table  style=' border-collapse: collapse;width:70% ; '>
						<tr><td ><b>Feedback given by '".$user_name."'</b></td></tr>
						<tr><td ><b>Date:<b> $feedbackdate</td></tr>
						<tr><td style='text-align:justify'>$request[5]</td></tr>
						<tr><td><span style='color:red;font-size:27px;'><span>$rating</td></tr>
						<tr>
							<td width='140px' style='text-align:left'><img src='".$category."' height='100px' width='100px' /></td>
						</tr>
						
						
					</table>";
				
						
				$title = "Feedback Regarding ".$category_name;
			
			
				Utils::Trace($msg);
				$emailsts='';			
				if($user_email!="")
				{
					$emailsts=Utils::sendMail($user_email,$user_name,$title,$msg);
				}
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Feedback message given successfully";
			} else {
			   $status =false;
			   $errorMsg = BANK_MODULE_CREATION_FAILED;
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function sendFeedback($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $category="";
		
        $mid = isset($_POST['emp'])?$_POST['emp']:$request[0];	///////// $_POST['emp'] is coming from manager's view in employee,if emp not coming in request them we will use session user/////////;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$msg=""; $name=""; $i=1; $rating="";
		$sql="select * from ExternalFeedback where EmployeeId=? and Email=? and ((? between FromDate and ToDate) or (? between FromDate and ToDate))";
		$query=$this->db->prepare($sql);
		$query->execute(array($mid,$request[2],Utils::getDateformat($request[8]),Utils::getDateformat($request[9])));
		if($row = $query->fetch())
		{
			$result["data"] =$data;
			$result['status']=false;
			$result['successMsg']=$successMsg;
			$result['errorMsg']="You have already sent feedback request to this person";
			
			// default return
			return $result;
		}
		$empname=Utils::getEmployeeName($mid, $this->db);
		$empdiv=Utils::getName(Utils::getName($mid, "EmployeeMaster", "Division", $this->db),"DivisionMaster", "Name", $this->db);
		$empdesig=Utils::getName(Utils::getName($mid, "EmployeeMaster", "Designation", $this->db),"DesignationMaster", "Name", $this->db);
		$empdept=Utils::getName(Utils::getName($mid, "EmployeeMaster", "Department", $this->db),"DepartmentMaster", "Name", $this->db);
		$orgname=Utils::getName($orgid,"Organization", "Name", $this->db);
		$contactno=Utils::decode5t(Utils::getName($mid,"EmployeeMaster", "CurrentContactNumber", $this->db));
		
		$sql = "INSERT INTO ExternalFeedback( `Email`, `Name`, `Designation`, `Company`, `Subject`,  `OrganizationId`, `EmployeeId` , FromDate , ToDate, CreatedById) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3],$request[4],$request[5] ,$request[6], $orgid, $mid, Utils::getDateformat($request[8]), Utils::getDateformat($request[9]),$_SESSION['ubihrm_user_id']));
			
				$count =  $query->rowCount();
				$feedbackid=$this->db->lastinsertid();
				$feedbacklink = URL."approvalbymail/externalfeedback/".Utils::encode5t($feedbackid);
				$msg=$request[7];
				$msg=str_replace("{empname}","$empname",$msg);	
				$msg=str_replace("{emailid}",$request[2],$msg);	
				$msg=str_replace("{division}","$empdiv",$msg);	
				$msg=str_replace("{department}","$empdept",$msg);
				$msg=str_replace("{designation}","$empdesig",$msg);
				$msg=str_replace("{org}","$orgname",$msg);
				$msg=str_replace("{contactno}","$contactno",$msg);
				$msg=str_replace("{feedbacklink}","$feedbacklink",$msg);
				$sql = "UPDATE ExternalFeedback set Message =? where Id=?";
			
				$query = $this->db->prepare($sql);
				$query->execute(array($msg, $feedbackid));
				
				if($count>=1)
				{
					
					$skills=json_decode($request[10], true); 
					for($i=0; $i<count($skills); $i++) {
						//echo $skills[$i]['name'];
						if($skills[$i]['name']!=""){
							$record = array();
							$record[0] = $feedbackid;
							$record[1] = $skills[$i]['name'];
							
							$sqlwork = " INSERT INTO FeedbackSkills ( `FeedbackId`, `Skill` ) values (?,?)";
							$querywork = $this->db->prepare($sqlwork);
							$querywork->execute($record);
						}
					}		
					
				}
				$emailsts='';			
				if($request[2] != "")
				{
					$emailsts=Utils::sendMail($request[2],$empname,$request[6],$msg);
				}
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($emailsts) {
			   $status =true;
			   $successMsg = "Feedback Request has been sent successfully";
			} else {
			   $status =false;
			   $errorMsg = BANK_MODULE_CREATION_FAILED;
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $count2=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "DELETE FROM timesheet_master WHERE project_id = :id ";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 = $query1->rowCount();
			
			$sql = "DELETE FROM project_master WHERE id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
	
			$count =  $query->rowCount();		
			
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if ($count == 1) {
			   $status =true;
				   $successMsg = "Project has been Deleted successfully";
			}else {
			   $status =false;
				   $errorMsg = BANK_MODULE_DELETE_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$result =array();
		$sql = "SELECT * FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$res= array();
				$res['name'] = $row->FirstName.' '.$row->LastName;
				$res['desi'] = self::getdesi($row->Designation);
				$image= $row->ImageName;
				$res['img']="";
				
				if (file_exists( "public/uploads/$orgid/$image") && $image != "") {
					
					$res['img']= URL."public/uploads/$orgid/$image";
				}
				else{
					
					if($row->Gender== 1)
					{
						$res['img']= URL."public/avatars/male.png";
					}
					else{
						$res['img']= URL."public/avatars/female.png";
					}
				
				}
				
				
				$result= $res;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	public function getdesi($id)
	{
		$name ="";
		$sql = "SELECT * FROM DesignationMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function createextranalfeed($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "UPDATE ExternalFeedback SET Ratings=?, Remarks =?, FeedbackDate=?, Sts=1  where Id=?";
		$query = $this->db->prepare($sql);
		try{
			$query->execute(array($request[1],$request[2], $mdate, $request[0] ));
			// INSERTING AND UPDATING OBJECTIVE CHILD IF PASSED AS AN JSON
			$objective = json_decode($request[3], true); 
			
			for($i=0; $i<count($objective); $i++) {
				if($objective[$i]['Id']!="" && $objective[$i]['Rating']!=""){
					$sqlobjective = "UPDATE FeedbackSkills SET Rating=? where Id=? and FeedbackId=?	";
					$queryobjective = $this->db->prepare($sqlobjective);
					$queryobjective->execute(array($objective[$i]['Rating'], $objective[$i]['Id'],$request[0]));
				}
			}
			$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
			    $status =true;
			    $successMsg = "Feedback has been sumbitted successfully";
			} else {
			   $status =false;
			   $errorMsg = OBJECTIVE_MODULE_UPDATION_FAILED;
			}
	
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		$this->db = null;
        // default return
        return $result;
    }

	 
}
