<?php

/**
 * EmployeeModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class EncryptModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	
	   public function DecryptAllEmp()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
         $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT HomeEmailId, CurrentContactNumber, CurrentEmailId, CurrentAddress, HomeContactNumber, HomeAddress, EmergencyContactNumber, EmergencyAddress, EmergencyEmailId, BankIFSCCode, BankAddress, PersonalNo, CompanyEmail, Id FROM EmployeeMaster";
        $query1 = $this->db->prepare($sql1);
        try{
            $query1->execute(array($orgid));
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
            
                $id = $row->Id;
                $HomeEmailId = Utils::encode5t($row->HomeEmailId);
                $CurrentContactNumber = Utils::encode5t($row->CurrentContactNumber);
                $CurrentEmailId = Utils::encode5t($row->CurrentEmailId);
                $CurrentAddress = Utils::encode5t($row->CurrentAddress);
                $HomeContactNumber = Utils::encode5t($row->HomeContactNumber);
                $HomeAddress = Utils::encode5t($row->HomeAddress);
                $EmergencyContactNumber = Utils::encode5t($row->EmergencyContactNumber);
                $EmergencyAddress = Utils::encode5t($row->EmergencyAddress);
                $EmergencyEmailId = Utils::encode5t($row->EmergencyEmailId);
                $BankIFSCCode = Utils::encode5t($row->BankIFSCCode);
                $BankAddress = Utils::encode5t($row->BankAddress);
                $PersonalNo = Utils::encode5t($row->PersonalNo);
                $CompanyEmail = Utils::encode5t($row->CompanyEmail);
               
                $sql = "UPDATE EmployeeMaster SET  HomeEmailId=?, CurrentContactNumber=?,CurrentEmailId=?,CurrentAddress=?,HomeContactNumber=?,HomeAddress=?,EmergencyContactNumber=?,EmergencyEmailId=?,EmergencyAddress=?,BankIFSCCode=?,BankAddress=?,PersonalNo=?,CompanyEmail=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($HomeEmailId,$CurrentContactNumber,$CurrentEmailId,$CurrentAddress,$HomeContactNumber,$HomeAddress,$EmergencyContactNumber,$EmergencyEmailId,$EmergencyAddress,$BankIFSCCode,$BankAddress,$PersonalNo,$CompanyEmail, $id));            
            }
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    }  
	  public function DecryptEmpDetails()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
        $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT IBAN, SwiftCode, Branch, Id from EmployeeBankDetails";
        $query1 = $this->db->prepare($sql1);
        try{
             $query1->execute();
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
                $id = $row->Id;
                $IBAN = Utils::encode5t($row->IBAN);
                $SwiftCode = Utils::encode5t($row->SwiftCode);
                $Branch = Utils::encode5t($row->Branch);
                $sql = "UPDATE EmployeeBankDetails SET  IBAN=?, SwiftCode=?,Branch=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($IBAN,$SwiftCode,$Branch, $id));            
            }
			$sql2 = "SELECT LoanAmount, Tenure, EMI, Id from EmployeeBankLoan";
			$query2 = $this->db->prepare($sql2);
			$query2->execute();
            $count2 =  $query2->rowCount();
            while($row = $query2->fetch())
            {
                $id = $row->Id;
                $LoanAmount = Utils::encode5t($row->LoanAmount);
                $Tenure = Utils::encode5t($row->Tenure);
                $EMI = Utils::encode5t($row->EMI);
                $sql = "UPDATE EmployeeBankLoan SET  LoanAmount=?, Tenure=?,EMI=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($LoanAmount,$Tenure,$EMI, $id));            
            }	
			
			$sql3 = "SELECT CreditCardNo, Id from EmployeeCreditCard";
			$query3 = $this->db->prepare($sql3);
			$query3->execute();
            $count3 =  $query3->rowCount();
            while($row = $query3->fetch())
            {
                $id = $row->Id;
                $CreditCardNo = Utils::encode5t($row->CreditCardNo);
              
                $sql = "UPDATE EmployeeCreditCard SET  CreditCardNo=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($CreditCardNo, $id));            
            }
			
			$sql4 = "SELECT Contact, Id from EmployeeDependant";
			$query4 = $this->db->prepare($sql4);
			$query4->execute();
            $count4 =  $query4->rowCount();
            while($row = $query4->fetch())
            {
                $id = $row->Id;
                $Contact = Utils::encode5t($row->Contact);
               
                $sql = "UPDATE EmployeeDependant SET  Contact=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($Contact, $id));            
            }
			
			$sql5 = "SELECT DocumentNumber, Id from EmployeeDocument";
			$query5 = $this->db->prepare($sql5);
			$query5->execute();
            $count5 =  $query5->rowCount();
            while($row = $query5->fetch())
            {
                $id = $row->Id;
                $DocumentNumber = Utils::encode5t($row->DocumentNumber);
             
                $sql = "UPDATE EmployeeDocument SET  DocumentNumber=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($DocumentNumber, $id));            
            }
			
			$sql5 = "SELECT PassportNo, EmiratesId, Id from EmployeeLTADetail";
			$query5 = $this->db->prepare($sql5);
			$query5->execute();
            $count5 =  $query5->rowCount();
            while($row = $query5->fetch())
            {
                $id = $row->Id;
                $PassportNo = Utils::encode5t($row->PassportNo);
                $EmiratesId = Utils::encode5t($row->EmiratesId);
              
                $sql = "UPDATE EmployeeLTADetail SET  PassportNo=?, EmiratesId=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($PassportNo, $EmiratesId, $id));            
            } 
			$sql6 = "SELECT Contact, Email, Id from EmployeeReference";
			$query6 = $this->db->prepare($sql6);
			$query6->execute();
            $count6 =  $query6->rowCount();
            while($row = $query6->fetch())
            {
                $id = $row->Id;
                $Contact = Utils::encode5t($row->Contact);
                $Email = Utils::encode5t($row->Email);
              
                $sql = "UPDATE EmployeeReference SET  Contact=?, Email=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($Contact, $Email, $id));            
            }
			
			
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    }  
	//to encrypt all user email////
	
	  public function DecryptAllUser()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
         $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT Username, Id FROM UserMaster";
        $query1 = $this->db->prepare($sql1);
        try{
            $query1->execute(array($orgid));
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
            
                $id = $row->Id;
                $Username = Utils::encode5t($row->Username);
                
               
                $sql = "UPDATE UserMaster SET  Username=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($Username, $id));            
            }
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    }  
	///////to encrypt all new employee/////////
	  public function DecryptAllNewEmp()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
         $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT HomeEmailId, CurrentContactNumber, CurrentEmailId, CurrentAddress, HomeContactNumber, HomeAddress, EmergencyContactNumber, EmergencyAddress, EmergencyEmailId, BankIFSCCode, BankAddress, Id FROM EmployeeNewJoinee";
        $query1 = $this->db->prepare($sql1);
        try{
            $query1->execute(array($orgid));
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
            
                $id = $row->Id;
                $HomeEmailId = Utils::encode5t($row->HomeEmailId);
                $CurrentContactNumber = Utils::encode5t($row->CurrentContactNumber);
                $CurrentEmailId = Utils::encode5t($row->CurrentEmailId);
                $CurrentAddress = Utils::encode5t($row->CurrentAddress);
                $HomeContactNumber = Utils::encode5t($row->HomeContactNumber);
                $HomeAddress = Utils::encode5t($row->HomeAddress);
                $EmergencyContactNumber = Utils::encode5t($row->EmergencyContactNumber);
                $EmergencyAddress = Utils::encode5t($row->EmergencyAddress);
                $EmergencyEmailId = Utils::encode5t($row->EmergencyEmailId);
                $BankIFSCCode = Utils::encode5t($row->BankIFSCCode);
                $BankAddress = Utils::encode5t($row->BankAddress);
              
                $sql = "UPDATE EmployeeNewJoinee SET  HomeEmailId=?, CurrentContactNumber=?,CurrentEmailId=?,CurrentAddress=?,HomeContactNumber=?,HomeAddress=?,EmergencyContactNumber=?,EmergencyEmailId=?,EmergencyAddress=?,BankIFSCCode=?,BankAddress=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($HomeEmailId,$CurrentContactNumber,$CurrentEmailId,$CurrentAddress,$HomeContactNumber,$HomeAddress,$EmergencyContactNumber,$EmergencyEmailId,$EmergencyAddress,$BankIFSCCode,$BankAddress, $id));            
            }
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    }  
	
	 public function DecryptNewEmpDetails()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
        $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT Email, Contact, Id from EmployeeNewJoiningReference";
        $query1 = $this->db->prepare($sql1);
        try{
             $query1->execute();
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
                $id = $row->Id;
                $Email = Utils::encode5t($row->Email);
                $Contact = Utils::encode5t($row->Contact);
                
                $sql = "UPDATE EmployeeNewJoiningReference SET  Email=?, Contact=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($Email,$Contact, $id));            
            }
			
			$sql5 = "SELECT DocumentNumber, Id from EmployeeNewJoiningDocument";
			$query5 = $this->db->prepare($sql5);
			$query5->execute();
            $count5 =  $query5->rowCount();
            while($row = $query5->fetch())
            {
                $id = $row->Id;
                $DocumentNumber = Utils::encode5t($row->DocumentNumber);
             
                $sql = "UPDATE EmployeeNewJoiningDocument SET  DocumentNumber=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($DocumentNumber, $id));            
            }
			
			
			
			
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    } 
	
	public function DecryptSalaryDetails()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
        $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT BankCode, BankAccountNo, Id from SalaryMaster";
        $query1 = $this->db->prepare($sql1);
        try{
            $query1->execute();
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
                $id = $row->Id;
                $BankCode = Utils::encode5t($row->BankCode);
                $BankAccountNo = Utils::encode5t($row->BankAccountNo);
                
                $sql = "UPDATE SalaryMaster SET  BankCode=?, BankAccountNo=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($BankCode,$BankAccountNo, $id));            
            }
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    } 
    
	
}
