<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class EmploymentformModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
   
	public function checkforemployee($emailid, $orgid=0)
	{
		$result =0;
		$emailid=base64_decode($emailid);
		$whr="";
		if($orgid!=0)
			$whr=" AND OrganizationId=$orgid";
		$sql="SELECT UpdateSts from EmployeeNewJoinee where CurrentEmailId=? $whr";
			$query = $this->db->prepare($sql);
			$query->execute(array(Utils::encode5t($emailid)));
			if($query->rowCount()>0)
			{
				while($row = $query->fetch())
				{
					$result =$row->UpdateSts;
				}
			}
		return $result;
	}
	/////////get org id by org email/////////
	public function checkfororganization($emailid)
	{
		$result =0;
		$emailid=base64_decode($emailid);
		
		$sql="SELECT Id from Organization where Email=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($emailid));
			if($query->rowCount()>0)
			{
				while($row = $query->fetch())
				{
					$result =$row->Id;
				}
			}
		return $result;
	}
	
	public function getDetail($eid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid = $_SESSION['ubihrm_org_id'];
		$eid=base64_decode($eid);
        $sql = "SELECT * FROM EmployeeNewJoinee WHERE CurrentEmailId = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => Utils::encode5t($eid)));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{	
				$res = array();
				$res['updatests']=$row->UpdateSts;
				$res['emppic']="";
				$id=$res['id'] = $row->Id;
				$orgid = $row->OrganizationId;
				$res['empfname'] = $row->FirstName;
				$res['emplname'] = $row->LastName;
				if($row->DOB =="0000-00-00" ){
					$res['empdob']="";
				}else{
						$res['empdob'] =  ($row->DOB);
					}
				$dob =$row->DOB ;
				$res['empnation'] = $row->Nationality;
				$res['empgender'] = $row->Gender;
				$res['empmarists'] = $row->MaritalStatus;
				$res['empreligion'] = $row->Religion;
				$res['empbloodgroup'] = $row->BloodGroup;
				$res['emplang'] = $row->KnownLanguage;
				//$doj=$res['empdoj'] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($row->DOJ)):$row->DOJ;
				//$doc=$res['empdoc'] =isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($row->DOC)):$row->DOC; 
				//$res['empvisa'] = $row->Visa;
				$res['empcnumber'] = Utils::decode5t($row->CurrentContactNumber);
				$res['empcemail'] = Utils::decode5t($row->CurrentEmailId);
				$res['empcaddres'] = Utils::decode5t($row->CurrentAddress);
				$res['empccountry'] = $row->CurrentCountry;
				$res['empccity'] = $row->CurrentCity;
				$res['empczip'] = $row->CurrentZipCode;
				$res['emphnumber'] = Utils::decode5t($row->HomeContactNumber);
				$res['emphemail'] = Utils::decode5t($row->HomeEmailId);
				$res['emphaddres'] = Utils::decode5t($row->HomeAddress);
				$res['emphcountry'] = $row->HomeCountry;
				$res['emphcity'] = $row->HomeCity;
				$res['emphzip'] = $row->HomeZipCode;
				$res['empenumber'] = Utils::decode5t($row->EmergencyContactNumber);
				$res['empeemail'] = Utils::decode5t($row->EmergencyEmailId);
				$res['empeaddress'] = Utils::decode5t($row->EmergencyAddress);
				$res['empecountry'] = $row->EmergencyCountry;
				$res['empecity'] = $row->EmergencyCity;
				$res['empezip'] = $row->EmergencyZipCode;
				//$res['empreport'] = $row->ReportingTo;
				//$res['empdivision'] = $row->Division;
				//$res['empdepartment'] = $row->Department;
				//$res['empdesignation'] = $row->Designation;
				//$res['emplocation'] = $row->Location;
				//$res['empshift'] = $row->Shift;
				//$res['empsts'] = $row->EmployeeStatus;
				//$res['empgrade'] = $row->Grade;
				//$res['empworkday'] = $row->WorkingDays;
				$res['empfuncarea'] = $row->FunctionalArea;
				//$res['salaryctc'] = $row->EmployeeCTC;
				//$res['empepaypattern'] = $row->PayPattern;
				//$res['empebankname'] = $row->BankName;
				//$res['empebankcode'] = $row->BankIFSCCode;
				//$res['empebankaccount'] = $row->BankAccount;
				//$res['empebankaddress'] = $row->BankAddress;
				//$res['emptype'] = $row->EmploymentType;
				$res['empexp'] = $row->TotalExp;
				$res['empairport'] = $row->NearestAirport;
				//$res['cmpemail'] = $row->CompanyEmail;
				$image= $row->ImageName;
				if($image!=""){
					$res['emppic']=URL."public/uploads/newjoining/$image";
				}else{
					$res['emppic']="";
				}
				
				$work = array();
				$qual = array();
				$doc  = array();
				//$depen  = array();
				$skill = array();
				$ref = array();
				//$training = array();
				//$family = array();
				
				
				$sqlwork = "SELECT * FROM EmployeeNewJoiningWorkExperience WHERE EmployeeId = :id";
				$querywork = $this->db->prepare($sqlwork);
				$querywork->execute(array(':id' => $id ));
				while($rowwork = $querywork->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowwork->Id;
					$res1['name'] = $rowwork->CompanyName;
					$res1['desig'] = $rowwork->Designation;
					if($rowwork->FromDate =="0000-00-00" ){
					$res1['fdate'] ="";
					}else{
						$res1['fdate'] =  ($rowwork->FromDate);
					}
					if($rowwork->ToDate =="0000-00-00" ){
					$res1['tdate'] ="";
					}else{
						$res1['tdate'] =  ($rowwork->ToDate);
					}
					$res1['desc'] = $rowwork->Description;
					$work[] = $res1;
				}
				
				$sqlqual = "SELECT * FROM EmployeeNewJoiningQualification WHERE EmployeeId = :id";
				$queryqual = $this->db->prepare($sqlqual);
				$queryqual->execute(array(':id' => $id ));
				while($rowqual = $queryqual->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowqual->Id;
					$res1['name'] = $rowqual->InstituteName;
					$res1['desig'] = $rowqual->Degree;
					$res1['fdate'] = $rowqual->FOS;
					if($rowqual->DOC =="0000-00-00" ){
						$res1['tdate'] =" ";
					}else{
						$res1['tdate'] =  ($rowqual->DOC);
					}
					$res1['desc'] = $rowqual->GPA;
					$qual[] = $res1;
				}
				
				$sqldoc = "SELECT * FROM EmployeeNewJoiningDocument WHERE EmployeeId = :id";
				$querydoc = $this->db->prepare($sqldoc);
				$querydoc->execute(array(':id' => $id ));
				while($rowdoc = $querydoc->fetch())
				{
					$res1 = array();
					$docid=$res1['id'] = $rowdoc->Id;
					$res1['name'] = $rowdoc->DocumentTypeId;
					$res1['desig'] = Utils::decode5t($rowdoc->DocumentNumber);
					if($rowdoc->IssuedOn =="0000-00-00" ){
						$res1['fdate'] ="";
					}else{
						$res1['fdate'] =  ($rowdoc->IssuedOn);
					}
					
					if($rowdoc->ExpiredOn =="0000-00-00" ){
						$res1['tdate'] ="";
					}else{
						$res1['tdate'] =  ($rowdoc->ExpiredOn);
					}
					$res1['desc'] = "";
					
					
					
						$doc[] = $res1;
				}
				
				
				
				$sqlskill = "SELECT * FROM EmployeeNewJoiningSkills WHERE EmployeeId = :id";
				$queryskill = $this->db->prepare($sqlskill);
				$queryskill->execute(array(':id' => $id ));
				while($rowskill = $queryskill->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowskill->Id;
					(int)$res1['skill'] = $rowskill->SkillsId;
					$res1['desc'] = $rowskill->Description;
					
					$skill[] = $res1;
				}
				$sqlref = "SELECT * FROM EmployeeNewJoiningReference WHERE EmployeeId = :id";
				$queryref = $this->db->prepare($sqlref);
				$queryref->execute(array(':id' => $id ));
				while($rowref = $queryref->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowref->Id;
					$res1['name'] = $rowref->Name;
					$res1['email'] = Utils::decode5t($rowref->Email);
					$res1['company'] = $rowref->Company;
					$res1['contact'] = Utils::decode5t($rowref->Contact);
					
					$ref[] = $res1;
				}
				$sqlorg = "SELECT * from Organization where Id=?";
				$queryorg = $this->db->prepare($sqlorg);
				$queryorg->execute(array($orgid)); 
				while($roworg=$queryorg->fetch())
				{
					$orglogo=$roworg->Logo;
					$res['orglogo'] =URL."public/uploads/$orgid/$orglogo";
					
				}
				
				
				$res['empwork'] = $work;
				$res['empqual'] = $qual;
				$res['empdocarray'] = $doc;
				//$res['empdepenarray'] = $depen;
				$res['empskills'] = $skill;
				$res['empreference'] = $ref;
				
				$data[] = $res;
			}
        }
		
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_GETDETAIL_SUCCESS;
		   
        } else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
    
    /**
     * Setter for a BankMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
   public function Update()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$emailid=$_POST['emp_email1'];
		
		
		$arr = array();
		
		$arr[0] = $_POST['emp_fname'];
		$arr[1] = $_POST['emp_lname'];
		$arr[2] =  ( $_POST['emp_dob']);
		$arr[3] = $_POST['emp_nationality'];
		$arr[4] = $_POST['emp_marital'];
		$arr[5] = $_POST['emp_religion'];
		$arr[6] = $_POST['emp_blood_group'];
		$arr[7] = is_array($_POST['emp_known_lang']) ? implode(',',$_POST['emp_known_lang']) :$_POST['emp_known_lang'];
		//$arr[8] = $_POST['emp_doj'];
		//$arr[9] = $_POST['emp_doc'];
		//$arr[8] = $_POST['emp_visa_type'];
		$arr[8] = $_POST['emp_gender'];
		$arr[9] = Utils::encode5t($_POST['emp_contact1']);
		$arr[10] = Utils::encode5t($_POST['emp_email1']);
		$arr[11] = Utils::encode5t($_POST['emp_address1']);
		$arr[12] = $_POST['emp_city1'];
		$arr[13] = $_POST['emp_country1'];
		$arr[14] = $_POST['emp_zipcode1'];
		$arr[15] = Utils::encode5t($_POST['emp_contact2']);
		$arr[16] = Utils::encode5t($_POST['emp_email2']);
		$arr[17] = Utils::encode5t($_POST['emp_address2']);
		$arr[18] = $_POST['emp_country2'];
		$arr[19] = $_POST['emp_city2'];
		$arr[20] = $_POST['emp_zipcode2'];
		$arr[21] = Utils::encode5t($_POST['emp_contact3']);
		$arr[22] = Utils::encode5t($_POST['emp_email3']);
		$arr[23] = Utils::encode5t($_POST['emp_address3']);
		$arr[24] = $_POST['emp_country3'];
		$arr[25] = $_POST['emp_city3'];
		$arr[26] = $_POST['emp_zipcode3'];
		$arr[27] = $_POST['emp_experience'];
		$arr[28] = $_POST['emp_functional'];
		$arr[29] = $_POST['airport'];
		$arr[30] = 2;
		$arr[31] = $_POST['emp_mname'];
		$arr[32] = date("Y-m-d H:i:s");
		/*$arr[30] = $_POST['emp_report_to'];
		$arr[31] = $_POST['emp_division'];
		$arr[32] = $_POST['emp_depart'];
		$arr[33] = $_POST['emp_desig'];
		$arr[34] = $_POST['emp_location'];
		$arr[35] = $_POST['emp_shift'];
		$arr[36] = $_POST['emp_sts'];
		$arr[37] = $_POST['emp_grade'];
		$arr[38] = $_POST['emp_workdays'];
		$arr[39] = $_POST['emp_functional'];
		$arr[40] = $_POST['salaryctc'];
		$arr[41] = $_POST['paypattern'];
		$arr[42] = $_POST['bankname'];
		$arr[43] = $_POST['bankifsccode'];
		$arr[44] = $_POST['bankaccount'];
		$arr[45] = $_POST['bankaddress'];
		$arr[46] = $_POST['emp_type'];
		$arr[50] = $_POST['cmp_email'];*/
		
					
				
				//$empid=$_POST['emp_id'];
		$sql="SELECT * from EmployeeNewJoinee where CurrentEmailId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array(Utils::encode5t($emailid)));
		$count =  $query->rowCount();
			if($row = $query->fetch())
			{
				$empid=$row->Id;
				$arr[33]=$empid;
			}
	
		
		$this->db->beginTransaction();
		$this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);//raise error, throw errors
		try
		{
			
			$sql = "UPDATE EmployeeNewJoinee SET FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?, KnownLanguage=?,   Gender=?, CurrentContactNumber=?, CurrentEmailId=?, CurrentAddress=?,CurrentCity=?, CurrentCountry=?,  CurrentZipCode=?, HomeContactNumber=?, HomeEmailId=?, HomeAddress=?, HomeCountry=?, HomeCity=?, HomeZipCode=?, EmergencyContactNumber=?, EmergencyEmailId=?, EmergencyAddress=?, EmergencyCountry=?, EmergencyCity=?, EmergencyZipCode=?, TotalExp=?,FunctionalArea=?,NearestAirport=?,UpdateSts=?, MiddleName=?, LastModifiedDate=? where Id=?";
			
			$query = $this->db->prepare($sql);
			$query->execute($arr);
			
			// INSERTING AND UPDATING WORK EXPERIENCE RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_workarray'], true); 
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeNewJoiningWorkExperience WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$fdate=$record[3] =  ($work[$i]['fdate']);
					$tdate=$record[4] =  ($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mdate;
					
					
					$id = $work[$i]['id'];
					
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningWorkExperience SET CompanyName=?, Designation=?, FromDate=?, ToDate=?, Description=?, LastModifiedDate=?  where Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'],$work[$i]['desig'],$fdate,$tdate,$work[$i]['desc'],$mdate,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeNewJoiningWorkExperience (EmployeeId, CompanyName, Designation, FromDate, ToDate, Description, CreatedDate,  LastModifiedDate) values (?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
					
				}
			}
			
			// INSERTING AND UPDATING QUALIFICATION RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_qualificationarray'], true);
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeNewJoiningQualification WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$record[3] = $work[$i]['fdate'];
					$tdate=$record[4] =  ($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mdate;
					
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningQualification SET InstituteName=?, Degree=?, FOS=?, DOC=?, GPA=?, LastModifiedDate=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'],$work[$i]['desig'],$work[$i]['fdate'],$tdate,$work[$i]['desc'],$mdate,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeNewJoiningQualification (EmployeeId, InstituteName, Degree, FOS, DOC, GPA, CreatedDate,  LastModifiedDate) values (?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			// INSERTING AND UPDATING DOCUMENT RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_documentarray'], true); 
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeNewJoiningDocument WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = Utils::encode5t($work[$i]['desig']);
					$fdate=$record[3] =  ($work[$i]['fdate']);
					$tdate=$record[4] =  ($work[$i]['tdate']);
					//$record[5] = $work[$i]['desc'];
					$record[5] = $mdate;
					$record[6] = $mdate;
					
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningDocument SET DocumentTypeId=?, DocumentNumber=?, IssuedOn=?, ExpiredOn=?,LastModifiedDate=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'], Utils::encode5t($work[$i]['desig']), $fdate,$tdate,$mdate,   $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeNewJoiningDocument (EmployeeId, DocumentTypeId, DocumentNumber, IssuedOn, ExpiredOn,CreatedDate,  LastModifiedDate) values (?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			
			// INSERTING SKILLS OF EMPLOYEE IF PASSED AS AN JSON
			$skill = json_decode($_POST['emp_skill'], true); 
			$skillid="0";
			for($i=0; $i<count($skill); $i++){
				$skillid .= ",".$skill[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeNewJoiningSkills WHERE EmployeeId=? AND Id NOT IN ($skillid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			for($i=0; $i<count($skill); $i++)
			{
				if($skill[$i]['skill']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $skill[$i]['skill'];
					$record[2] = $skill[$i]['desc'];
					
					$id = $skill[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningSkills SET EmployeeId=?, SkillsId=?, Description=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$skill[$i]['skill'], $skill[$i]['desc'],  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeNewJoiningSkills (EmployeeId, SkillsId,Description) values (?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
					
				}
			}
			
			// INSERTING Reference person details OF EMPLOYEE IF PASSED AS AN JSON
			$ref = json_decode($_POST['reference_person'], true); 
			$refid="0";
			for($i=0; $i<count($ref); $i++){
				$refid .= ",".$ref[$i]['id'];
			}
			$sqlref= " DELETE FROM EmployeeNewJoiningReference WHERE EmployeeId=? AND Id NOT IN ($refid)";
			$queryref = $this->db->prepare($sqlref);
			$queryref->execute(array( $empid));
			for($i=0; $i<count($ref); $i++)
			{
				if($ref[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $ref[$i]['name'];
					$record[2] = $ref[$i]['company'];
					$record[3] = Utils::encode5t($ref[$i]['email']);
					$record[4] = Utils::encode5t($ref[$i]['contact']);
					
					
					$id = $ref[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningReference SET EmployeeId=?, Name=?, Company=? ,Email=?,Contact=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$ref[$i]['name'], $ref[$i]['company'],Utils::encode5t($ref[$i]['email']),Utils::encode5t($ref[$i]['contact']),  $id));
					}else{					
						$sqlwork = " INSERT INTO EmployeeNewJoiningReference ( EmployeeId, Name, Company, Email, Contact) values (?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			
			
			//$count =  $query->rowCount();		
			
			
			$status =true;
			$successMsg = EMPLOYEE_MODULE_UPDATION_SUCCESS;
			
			
			
		  $this->db->commit();     
		}catch(PDOException $e)
		{
			$pdo->rollBack();
			$errorMsg .= 'Message: ' .$e->getMessage();
		}catch(Exception $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}  
		
        
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
   
    public function Create()
    {
		$empid=0;
		$result1 = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid=$_SESSION['orgid'];
		$canid=isset($_POST['candidateid'])?$_POST['candidateid']:0;
		//echo $canid;
		Utils::Trace("modal:".$canid);
		$mdate = date("Y-m-d H:i:s");
		$emailid=$_POST['emp_email1'];
		$arr = array();
		$arr[0] = $_POST['emp_fname'];
		$arr[1] = $_POST['emp_lname'];
		$arr[2] =  ( $_POST['emp_dob']);
		$arr[3] = $_POST['emp_nationality'];
		$arr[4] = $_POST['emp_marital'];
		$arr[5] = $_POST['emp_religion'];
		$arr[6] = $_POST['emp_blood_group'];
		$arr[7] = is_array($_POST['emp_known_lang']) ? implode(',',$_POST['emp_known_lang']) :$_POST['emp_known_lang'];
		//$arr[8] = $_POST['emp_doj'];
		//$arr[9] = $_POST['emp_doc'];
		//$arr[8] = $_POST['emp_visa_type'];
		$arr[8] = $_POST['emp_gender'];
		$arr[9] = Utils::encode5t($_POST['emp_contact1']);
		$arr[10] = Utils::encode5t($_POST['emp_email1']);
		$arr[11] = Utils::encode5t($_POST['emp_address1']);
		$arr[12] = $_POST['emp_city1'];
		$arr[13] = $_POST['emp_country1'];
		$arr[14] = $_POST['emp_zipcode1'];
		$arr[15] = Utils::encode5t($_POST['emp_contact2']);
		$arr[16] = Utils::encode5t($_POST['emp_email2']);
		$arr[17] = Utils::encode5t($_POST['emp_address2']);
		$arr[18] = $_POST['emp_country2'];
		$arr[19] = $_POST['emp_city2'];
		$arr[20] = $_POST['emp_zipcode2'];
		$arr[21] = Utils::encode5t($_POST['emp_contact3']);
		$arr[22] = Utils::encode5t($_POST['emp_email3']);
		$arr[23] = Utils::encode5t($_POST['emp_address3']);
		$arr[24] = $_POST['emp_country3'];
		$arr[25] = $_POST['emp_city3'];
		$arr[26] = $_POST['emp_zipcode3'];
		$arr[27] = $_POST['emp_experience'];
		$arr[28] = $_POST['emp_functional'];
		$arr[29] = $_POST['airport'];
		$arr[30] = 2;
		$arr[31] = $_POST['emp_mname'];
		$arr[32] = date("Y-m-d H:i:s");
		$arr[33] = isset($_POST['orgid'])?$_POST['orgid']:$_SESSION['orgid'];
		$orgid=$arr[33];
		$arr[34] = isset($_POST['onboard'])?$_POST['onboard']:1;
		
		//Utils::Trace($orgid);
		/*$arr[30] = $_POST['emp_report_to'];
		$arr[31] = $_POST['emp_division'];
		$arr[32] = $_POST['emp_depart'];
		$arr[33] = $_POST['emp_desig'];
		$arr[34] = $_POST['emp_location'];
		$arr[35] = $_POST['emp_shift'];
		$arr[36] = $_POST['emp_sts'];
		$arr[37] = $_POST['emp_grade'];
		$arr[38] = $_POST['emp_workdays'];
		$arr[39] = $_POST['emp_functional'];
		$arr[40] = $_POST['salaryctc'];
		$arr[41] = $_POST['paypattern'];
		$arr[42] = $_POST['bankname'];
		$arr[43] = $_POST['bankifsccode'];
		$arr[44] = $_POST['bankaccount'];
		$arr[45] = $_POST['bankaddress'];
		$arr[46] = $_POST['emp_type'];
		$arr[50] = $_POST['cmp_email'];*/
		
					
				
			 	//$empid=$_POST['emp_id'];
			$sql="SELECT * from EmployeeNewJoinee where CurrentEmailId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( Utils::encode5t($emailid) ));
			$count =  $query->rowCount();
			if($row = $query->fetch())
			{
				$empid=$row->Id;
				$arr[35]=$empid;
			}
		
		
		$this->db->beginTransaction();
		$this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);//raise error, throw errors
		try
		{
			if($count==0){
				$sql = "INSERT into EmployeeNewJoinee (FirstName, LastName, DOB, Nationality, MaritalStatus, Religion, BloodGroup, KnownLanguage,   Gender, CurrentContactNumber, CurrentEmailId, CurrentAddress,CurrentCity, CurrentCountry,  CurrentZipCode, HomeContactNumber, HomeEmailId, HomeAddress, HomeCountry, HomeCity, HomeZipCode, EmergencyContactNumber, EmergencyEmailId, EmergencyAddress, EmergencyCountry, EmergencyCity, EmergencyZipCode, TotalExp,FunctionalArea,NearestAirport,UpdateSts, MiddleName, LastModifiedDate, OrganizationId,OnboardSts) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				
				$query = $this->db->prepare($sql);
				$query->execute($arr);
			}else{
				$sql = "UPDATE EmployeeNewJoinee SET FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?, KnownLanguage=?,   Gender=?, CurrentContactNumber=?, CurrentEmailId=?, CurrentAddress=?,CurrentCity=?, CurrentCountry=?,  CurrentZipCode=?, HomeContactNumber=?, HomeEmailId=?, HomeAddress=?, HomeCountry=?, HomeCity=?, HomeZipCode=?, EmergencyContactNumber=?, EmergencyEmailId=?, EmergencyAddress=?, EmergencyCountry=?, EmergencyCity=?, EmergencyZipCode=?, TotalExp=?,FunctionalArea=?,NearestAirport=?,UpdateSts=?, MiddleName=?, LastModifiedDate=?,OrganizationId=?,OnboardSts=? where Id=?";
			
				$query = $this->db->prepare($sql);
				$query->execute($arr);
			}
			/* $sql="SELECT * from EmployeeNewJoinee where CurrentEmailId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( Utils::encode5t($emailid) ));
			$count =  $query->rowCount();
				if($row = $query->fetch())
				{
					$empid=$row->Id;
					//$arr[33]=$empid;
				} */
			
			// INSERTING AND UPDATING WORK EXPERIENCE RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_workarray'], true); 
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeNewJoiningWorkExperience WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$fdate=$record[3] =  ($work[$i]['fdate']);
					$tdate=$record[4] =  ($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mdate;
					$record[8] = $orgid;
					
					$id = $work[$i]['id'];
					//Utils::Trace("Work Id:".$id);
					if($id){
						$sqlwork = "UPDATE EmployeeNewJoiningWorkExperience SET CompanyName=?, Designation=?, FromDate=?, ToDate=?, Description=?, LastModifiedDate=?  where Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'],$work[$i]['desig'],$fdate,$tdate,$work[$i]['desc'],$mdate,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeNewJoiningWorkExperience (EmployeeId, CompanyName, Designation, FromDate, ToDate, Description, CreatedDate,  LastModifiedDate, OrganizationId) values (?,?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			// INSERTING AND UPDATING QUALIFICATION RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_qualificationarray'], true);
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeNewJoiningQualification WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$record[3] = $work[$i]['fdate'];
					$tdate=$record[4] =  ($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mdate;
					$record[8] = $orgid;
					
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningQualification SET InstituteName=?, Degree=?, FOS=?, DOC=?, GPA=?, LastModifiedDate=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'],$work[$i]['desig'],$work[$i]['fdate'],$tdate,$work[$i]['desc'],$mdate,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeNewJoiningQualification (EmployeeId, InstituteName, Degree, FOS, DOC, GPA, CreatedDate,  LastModifiedDate, OrganizationId) values (?,?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			// INSERTING AND UPDATING DOCUMENT RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_documentarray'], true); 
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeNewJoiningDocument WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = Utils::encode5t($work[$i]['desig']);
					$fdate=$record[3] =  ($work[$i]['fdate']);
					$tdate=$record[4] =  ($work[$i]['tdate']);
					//$record[5] = $work[$i]['desc'];
					$record[5] = $mdate;
					$record[6] = $mdate;
					$record[7] = $orgid;
					
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningDocument SET DocumentTypeId=?, DocumentNumber=?, IssuedOn=?, ExpiredOn=?,LastModifiedDate=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'], Utils::encode5t($work[$i]['desig']), $fdate,$tdate,$mdate,   $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeNewJoiningDocument (EmployeeId, DocumentTypeId, DocumentNumber, IssuedOn, ExpiredOn,CreatedDate,  LastModifiedDate, OrganizationId) values (?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			
			// INSERTING SKILLS OF EMPLOYEE IF PASSED AS AN JSON
			$skill = json_decode($_POST['emp_skill'], true); 
			$skillid="0";
			for($i=0; $i<count($skill); $i++){
				$skillid .= ",".$skill[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeNewJoiningSkills WHERE EmployeeId=? AND Id NOT IN ($skillid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			for($i=0; $i<count($skill); $i++)
			{
				if($skill[$i]['skill']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $skill[$i]['skill'];
					$record[2] = $skill[$i]['desc'];
					
					$id = $skill[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningSkills SET EmployeeId=?, SkillsId=?, Description=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$skill[$i]['skill'], $skill[$i]['desc'],  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeNewJoiningSkills (EmployeeId, SkillsId,Description) values (?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
					
				}
			}
			
			// INSERTING Reference person details OF EMPLOYEE IF PASSED AS AN JSON
			$ref = json_decode($_POST['reference_person'], true); 
			$refid="0";
			for($i=0; $i<count($ref); $i++){
				$refid .= ",".$ref[$i]['id'];
			}
			$sqlref= " DELETE FROM EmployeeNewJoiningReference WHERE EmployeeId=? AND Id NOT IN ($refid)";
			$queryref = $this->db->prepare($sqlref);
			$queryref->execute(array( $empid));
			for($i=0; $i<count($ref); $i++)
			{
				if($ref[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $ref[$i]['name'];
					$record[2] = $ref[$i]['company'];
					$record[3] = Utils::encode5t($ref[$i]['email']);
					$record[4] = Utils::encode5t($ref[$i]['contact']);
					
					
					$id = $ref[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeNewJoiningReference SET EmployeeId=?, Name=?, Company=? ,Email=?,Contact=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$ref[$i]['name'], $ref[$i]['company'],$record[3],$record[4],  $id));
					}else{					
						$sqlwork = " INSERT INTO EmployeeNewJoiningReference ( EmployeeId, Name, Company, Email, Contact) values (?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
				
			
			//$count =  $query->rowCount();	
			
		   
			///////Start send onboard status of candidate to ubirecruit/////////
			//$jsondata[] =$canid;
			if($canid!=0){
				$url = "https://ubirecruit.ubihrm.com/login/onboardcandidate";		
				$postdata = http_build_query(
							array(
								'ubirec_data' => $canid
							)
						);

				 $opts = array('http' =>
					array(
						'method'  => 'POST',
						'header'  => 'Content-type: application/x-www-form-urlencoded',
						'content' => $postdata
					)
				);

				$context  = stream_context_create($opts);
				//print_r($context);
				$result = file_get_contents($url, false, $context);
				Utils::Trace("pass".$result);
			}
			//print_r($result);
			///////End send onboard status of candidate to ubirecruit/////////
			$this->db->commit();
			$status =true;
			
			$successMsg = "Employee has been registered successfully";
		}catch(PDOException $e)
		{
			Utils::Trace($e->getMessage());
			$pdo->rollBack();
			$errorMsg .= 'Message: ' .$e->getMessage();
		}catch(Exception $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}  
		
        Utils::Trace("status".$status);
		
		$result1["data"] =$data;
		$result1['status']=$status;
		$result1['successMsg']=$successMsg;
		$result1['errorMsg']=$errorMsg;
		
        // default return
        return $result1;
    }
   
   
    
    
	
	public function getCode($id)
	{
		$name ="";
		$sql = "SELECT * FROM EmployeeNewJoinee WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->EmployeeCode;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	
	public function getAllDoc($orgid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid=$_SESSION['orgid'];
        $sql = "SELECT * FROM DocumentMaster where OrganizationId=$orgid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = DOCUMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAllReligion()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM ReligionMaster ";
        $query = $this->db->prepare($sql);
		try{
			
			
			$query->execute();
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = DOCUMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAllfunc($orgid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid=$_SESSION['orgid'];
        $sql = "SELECT * FROM FunctionalAreaMaster where OrganizationId=$orgid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = FUNCAREA_MODULE_GETALL;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	public function getAllSkill($orgid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		//$orgid=$_SESSION['orgid'];
		
        $sql = "SELECT * FROM SkillTable where OrganizationId=$orgid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['code'] = $row->Code;
				$res['catid'] = $row->CategoryId;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SKILL_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	//////////////////////////////uploading image/////////////////////////////
	public function uploadImage($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$emailid = $request[0];
		$emailid=base64_decode($emailid);
		$empid="";//$_POST['emp_id'];
		$sql="SELECT * from EmployeeNewJoinee where CurrentEmailId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array( $emailid ));
		$count =  $query->rowCount();
		if($row = $query->fetch())
		{
			$empid=$row->Id;
			
		}
		
		$empcode=$empid;//$this->getCode($empid);
		$new_name="";
		
		if (!file_exists("public/uploads/newjoining")) {
			mkdir("public/uploads/newjoining" ,  0777,true);
		}
		
		$dir="public/uploads/newjoining";
		$filename="";
		
			
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				if ($ext=='png' || $ext=='jpg' || $ext=='gif' || $ext=='MOV' || $ext=='ico' || $ext=='tif'){
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext1 = end((explode(".", $filename)));
								if($filename=="$empcode.$ext1")
								{
									unlink("public/uploads/newjoining/$filename");
								}
							}
						closedir($dh);
						}
					}
					$new_name="$empcode.$ext";
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/newjoining/";
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						move_uploaded_file($file_tmp, $location.$new_name);
						
					}
					else{
						print_r($errors);
					}
				}
				else{
					$status =false;
					$successMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
				}				
			}
			
			//////////////updating path of employee profile picture in database/////////////
			
			$sql = "UPDATE EmployeeNewJoinee SET  ImageName=? where Id=?";	
            $query = $this->db->prepare($sql);
		
			try{
			
				$query->execute(array($new_name,$empid ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
			
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count >= 1) {
			
			   $status =true;
			   $successMsg = EMPLOYEE_MODULE_PROFILEIMAGE;
			} else {
			   $status =false;
			   
			   $errorMsg .= EMPLOYEE_MODULE_UPDATION_FAILED;
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}
	
	//////////////////////////////uploading document/////////////////////////////
	public function uploadDocument($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$emailid = $request[0];
		$emailid=base64_decode($emailid);
		
		$empid="";//$_POST['emp_id'];
			$sql="SELECT * from EmployeeNewJoinee where CurrentEmailId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $emailid ));
			$count =  $query->rowCount();
				if($row = $query->fetch())
				{
					$empid=$row->Id;
					
				}
		
		$empcode=$empid;//$this->getCode($empid);
		
		$new_name="";
			
		if (!file_exists("public/uploads/newjoining" )) {
			mkdir("public/uploads/newjoining" ,  0777,true);
		}
		
		$dir="public/uploads/newjoining";
		$filename="";
		
		
		for($i=0; $i < count($_FILES); $i++){	
			$docid = $_POST["doc_id$i"];
			$doc1="$empcode".'_'."$docid";
			if(isset($_FILES["file$i"])){
				$errors= array();
				$file_name = $_FILES["file$i"]['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				if ($ext=='png' || $ext=='jpg' || $ext=='gif' || $ext=='MOV' || $ext=='tif'){ 
					
				
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext1 = end((explode(".", $filename)));
								if($filename=="$doc1.$ext1")
								{
									unlink("public/uploads/newjoining/$filename");
								}
							}
						closedir($dh);
						}
					}
					$new_name="$empcode".'_'."$docid.$ext";
					
					$file_size =$_FILES["file$i"]['size'];
					$file_tmp =$_FILES["file$i"]['tmp_name'];
					$file_type=$_FILES["file$i"]['type'];   
					$location="public/uploads/newjoining/";
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						move_uploaded_file($file_tmp, $location.$new_name);
						 
						
					}else{
						print_r($errors);
					}
					
				}
				else {
				   $status =false;
				   $errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
				}
				
			}
			$count=$count+1;
		}	
			
		if ($count >= 1) {
		   $status =true;
		   $successMsg = EMPLOYEE_MODULE_DOCUPLOAD;
			} 
		else {
		   $status =false;
		   $errorMsg = EMPLOYEE_MODULE_DOCUPLOAD_FAILED;
		}	
			
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}
	
	
}
