<?php

/**
 * EmployeeincentiveModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class EmployeeovertimeModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
	 /* public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$applydate=$_POST['applymonth'];
		$dept=$_POST['deptid'];
		$div=$_POST['divisionid'];
		$sWhere ="";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hr=$_SESSION['ubihrm_hr_sts'];
		
		if($sts!=1 && $hr!=1){
			$sWhere = " AND ReportingTo=$mid  ";
		}
		if($div != 0 && $div != ''){
			$sWhere .= " AND Division=$div ";
		}
		if($dept != 0 && $dept != ''){
			$sWhere .= " AND Department =$dept ";
		}
		
		$sql = "SELECT Id, EmployeeCode, FirstName, MiddleName, LastName FROM EmployeeMaster WHERE OrganizationId = :id and OvertimePayment=1 $sWhere order by FirstName";
        $query = $this->db->prepare($sql);
		
        
		try{
			$query->execute(array(':id' => $orgid ));
			$count=$query->rowCount();
			while($row = $query->fetch())
			{
				$res = array(); $hourlyrate=0;
				$empid=$row->Id;
				$res['id'] = "";
				$res['employeeid'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".(ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName)));
				$res['desc'] = "";
                $res['amt'] = 0;         
				$ctc=Utils::getName($row->Id,'EmployeeMaster','EmployeeCTC',$this->db);
				$shift=Utils::getName($row->Id,'EmployeeMaster','Shift',$this->db);
				$shifthour=$this->getShifTotalHour($shift);
				if($shifthour>0){
					$hourlyrate=$res['hourlyrate'] =round((($ctc*12)/365)/$shifthour);
				}else{
					$res['hourlyrate'] ==0;
				}
				$overtime = $this->getTotalOvertime($empid,$orgid,$applydate);
				$res['overtime'] = gmdate('H:i', floor($overtime * 3600));
				if($hourlyrate>0)
				$res['amt'] = $this->getEmployeeOvertime($empid,$applydate,$hourlyrate);
				
				///////find out if overtime is already entered/////////////
                $sql1 = "SELECT * FROM EmployeeOvertime WHERE OrganizationId = ? AND EmployeeId = ? AND ApplyDate = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid , $empid , $applydate ));
				$count =  $query1->rowCount();
				while($row1 = $query1->fetch())
				{
					
					$res['id'] = $row1->Id;
					//$res['employeeid'] = $row1->EmployeeId;
					//$res['name'] = $this->getName($row1->EmployeeId);
					$res['desc'] = $row1->Description;
					$res['amt'] = $row1->OvertimeAmount;
					$res['applydate'] = $row1->ApplyDate;
					$res['applydate1'] = $row1->ApplyDate;
				}
				$data[] = $res;
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
			$status=true;
			$successMsg=" record found";
			
		
		 
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }*/
	 
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$applydate=isset($_POST['applymonth'])?$_POST['applymonth']:date("y-m-d");
		$dept=$_POST['deptid'];
		$div=$_POST['divisionid'];
		$sWhere ="";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hr=$_SESSION['ubihrm_hr_sts'];
		
		if($sts!=1 && $hr!=1){
			$sWhere = " AND ReportingTo=$mid  ";
		}
		if($div != 0 && $div != ''){
			$sWhere .= " AND Division=$div ";
		}
		if($dept != 0 && $dept != ''){
			$sWhere .= " AND Department =$dept ";
		}
		$sql="select e.Id as Id,concat(EmployeeCode,' - ',FirstName,' ', LastName) as empname, Overtime, AttendanceDate, EmployeeCTC, Shift, AttendanceStatus from AttendanceMaster a,EmployeeMaster e where a.EmployeeId=e.Id and e.OrganizationId=? and a.OrganizationId=? and e.OvertimePayment=1 and AttendanceDate between '$applydate' and  last_day('$applydate') and (Overtime>0 or Overtime<0 ) $sWhere order by EmployeeId,AttendanceDate ";
		
		//$sql = "SELECT Id, EmployeeCode, FirstName, MiddleName, LastName FROM EmployeeMaster WHERE OrganizationId = :id and OvertimePayment=1 $sWhere order by FirstName";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid,$orgid ));
			$count=$query->rowCount();
			while($row = $query->fetch())
			{
				$ov=0;
				$res = array(); $hourlyrate=0; $overtimeamt=0; $weekoff=0; $holiday=0; $weekdays=0;
				$empid=$row->Id;
				$res['id'] = "";
				$res['employeeid'] = $row->Id;
				$res['name'] = $row->empname;
				$res['amt'] = 0; 
				//$res['rate'] = 1;
				
				$res['applydate'] = Utils::dateformatter($row->AttendanceDate);
				$ctc=$row->EmployeeCTC;
				$shift=$row->Shift;
				$shifthour=$this->getShifTotalHour($shift);
		
				if($shifthour>0){
					$hourlyrate=round(($ctc/30)/$shifthour,2);
				}else{
					$hourlyrate=0;
				}
				$hr=0;
				$min=0;
				$res['hourlyrate']=$hourlyrate;
				$res['overtime']  = $temp1 = $row->Overtime;
				
				$temp=explode(':',$temp1);
				$hr=$temp[0];
				$min1=round(($temp[1]/60),2);
				if($min1 != '0'){
					$min2=explode('.',$min1);
					$min=	$min2[1];
				}				
				$ov=$hr.".".$min;
				$res['overtime_facter']  =$ov;
				if($row->AttendanceStatus==3)
				{
					$weekoff=$ov;
					$desc="Weekly off";
				}	
				elseif($row->AttendanceStatus==5)
				{
					$holiday=$ov;
					$desc="Public Holiday";
				}	
				else
				{
					$weekdays=$ov;
					$desc="Week day";
				}	
				$res['desc'] = $desc;
				////////////////   FIND OUT THE OVERTIME PAYMENT AVAILABLE FOR THE ORGANIZATION /////////////////////////////				
				$sql1 = "SELECT SettingId, ExecutionValue FROM SettingMaster sm, SettingChild sc where sm.Id=sc.SettingId and PageType=2 and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid));
				while($row1 = $query1->fetch())
				{
					
					if($row1->SettingId==4 && $row->AttendanceStatus==3)
						{
							$res['hourlyrate']=round($row1->ExecutionValue*$hourlyrate,2);
							$overtimeamt = $weekoff*$res['hourlyrate'];
							$res['rate']=$row1->ExecutionValue;
							break;
						}	
						elseif($row1->SettingId==5 && $row->AttendanceStatus==5)
						{
							$res['hourlyrate']=round($row1->ExecutionValue*$hourlyrate,2);
							$overtimeamt = $holiday*$res['hourlyrate'];
							$res['rate']=$row1->ExecutionValue;
							break;
						}	
						else
						{
							$res['hourlyrate']=round($row1->ExecutionValue*$hourlyrate,2);
							$overtimeamt = $weekdays*$res['hourlyrate'];
							$res['rate']=$row1->ExecutionValue;
						}	
				}
				$res['amt']=round($overtimeamt,2);
				///////find out if overtime is already entered/////////////
                $sql1 = "SELECT * FROM EmployeeOvertime WHERE OrganizationId = ? AND EmployeeId = ? AND AttendanceDate = ? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid , $empid , $row->AttendanceDate ));
				$count =  $query1->rowCount();
				while($row1 = $query1->fetch())
				{
					$res['id'] = $row1->Id;
					$res['hourlyrate'] = $row1->HourlyRate;
					$res['overtime'] = $row1->Overtime;
					$res['desc'] = $row1->Description;
					$res['amt'] = $row1->OvertimeAmount;
					$res['applydate'] = Utils::dateformatter($row1->ApplyDate);
					
				}
				$data[] = $res;
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
			$status=true;
			$successMsg=" record found";
			
		
		 
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getAll1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$applydate=isset($_POST['applymonth'])?$_POST['applymonth']:date("y-m-d");
		$dept=$_POST['deptid'];
		$div=$_POST['divisionid'];
		$sWhere ="";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hr=$_SESSION['ubihrm_hr_sts'];
		
		if($sts!=1 && $hr!=1){
			$sWhere = " AND ReportingTo=$mid  ";
		}
		if($div != 0 && $div != ''){
			$sWhere .= " AND Division=$div ";
		}
		if($dept != 0 && $dept != ''){
			$sWhere .= " AND Department =$dept ";
		}
		$sql = "SELECT Id, concat(EmployeeCode,' - ',FirstName,' ', LastName) as empname ,EmployeeCTC, Shift FROM EmployeeMaster WHERE OrganizationId = ? and OvertimePayment=1 and Is_Delete=0 $sWhere order by FirstName";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count=$query->rowCount();
			while($row = $query->fetch())
			{
				$res = array(); $hourlyrate=0; $overtimeamt=0; $weekoff=0; $holiday=0; $weekdays=0;
				$empid=$row->Id;
				$res['id'] = "";
				$res['employeeid'] = $row->Id;
				$res['name'] = $row->empname;
				$res['amt'] = 0; 
				$res['applydate'] = "";
				$ctc=$row->EmployeeCTC;
				$shift=$row->Shift;
				$shifthour=$this->getShifTotalHour($shift);
				if($shifthour>0){
					$hourlyrate=$res['hourlyrate'] =round((($ctc*12)/365)/$shifthour,2);
				}else{
					$res['hourlyrate'] ==0;
				}
				$res['overtime'] = "00:00:00";
				$res['desc'] = "";
				
				$res['amt']="";
				///////find out if overtime is already entered/////////////
                $sql1 = "SELECT * FROM EmployeeOvertime WHERE OrganizationId = ? AND EmployeeId = ? AND ApplyDate = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid , $empid , $applydate));
				$count =  $query1->rowCount();
				while($row1 = $query1->fetch())
				{
					$res['id'] = $row1->Id;
					$res['overtime'] = $row1->Overtime;
					$res['desc'] = $row1->Description;
					$res['amt'] = $row1->OvertimeAmount;
					$res['applydate'] = Utils::dateformatter($row1->ApplyDate);
					
				}
				$data[] = $res;
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
			$status=true;
			$successMsg=" record found";
			
		
		 
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$applydate="";
		$applydate1="";
        $sql = "SELECT * FROM EmployeeOvertime WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['employeeid'] = $row->EmployeeId;
				$res['name'] = Utils::getEmployeeName($row->EmployeeId, $this->db);
				$res['desc'] = $row->Description;
				$res['hourlyrate'] = $row->HourlyRate;
				$res['overtime'] = Utils::timeformatter($row->Overtime);
				$res['amt'] = $row->OvertimeAmount;
				$applydate=$res['applydate'] = Utils::dateformatter($row->AttendanceDate);
				$applydate1=$res['applydate1'] = $row->AttendanceDate;
				$res['rate']=$this->getOvertimeRate($row->EmployeeId,$row->ApplyDate);
                
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
		//$applydate=$amonth;
           $status =true;
		   $successMsg = INCENTIVE_MODULE_GETDETAIL_SUCCESS;
        } else {
			$applydate=date('F Y');
			$applydate1=date('Y-m-1');
			
           $status =true;
		   $errorMsg = INCENTIVE_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result["applydate"] =$applydate;
		$result["applydate1"] =$applydate1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a EmployeeOvertime (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
        $applymonth=$request[2];
		$mdate = date("Y-m-d H:i:s");
		$incentive = json_decode($_POST['overtimearr'], true); 
		try{	
			for($i=0; $i<count($incentive); $i++) {
				if($incentive[$i]['employeeid']!="" && $incentive[$i]['amt']!=0){
					$record = array();
					$record[0] = $incentive[$i]['employeeid'];
					$record[1] = $incentive[$i]['desc'];
					$record[2] = $incentive[$i]['overtime'];
					$record[3] = $incentive[$i]['hourlyrate'];
					$record[4] = $incentive[$i]['amt'];
					$record[5] = $applymonth;
					$record[6] = Utils::getDateformat($incentive[$i]['applydate']);
					$record[7] = $orgid;
					$record[8] = $mdate;
					$record[9] = $mid;
					$record[10] = $mdate;
					$record[11] = $mid;
					$record[12] = $mid;
					$sql1 = "SELECT * FROM EmployeeOvertime WHERE OrganizationId = ? AND EmployeeId = ? AND AttendanceDate = ? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid ,$incentive[$i]['employeeid'] , Utils::getDateformat($incentive[$i]['applydate']) ));
					if($query1->rowCount()>0 ){
						$r=$query1->fetch();
						$sqlincentive = " UPDATE EmployeeOvertime SET EmployeeId=?, Description=?, OvertimeAmount=?,Overtime=?, HourlyRate=?, ApplyDate=?, AttendanceDate=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
						$queryincentive = $this->db->prepare($sqlincentive);
						$queryincentive->execute(array($incentive[$i]['employeeid'],$incentive[$i]['desc'],$incentive[$i]['amt'],$incentive[$i]['overtime'],$incentive[$i]['hourlyrate'],$applymonth,Utils::getDateformat($incentive[$i]['applydate']),$orgid,$mdate,$mid,  $r->Id));
						$count =  $queryincentive->rowCount();
					}else{
						$sqlincentive = "INSERT INTO EmployeeOvertime ( EmployeeId, Description, Overtime, HourlyRate, OvertimeAmount, ApplyDate,AttendanceDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
						$queryincentive = $this->db->prepare($sqlincentive);
						$queryincentive->execute($record);
						$count =  $queryincentive->rowCount();
					}
				}
			}
		if ($count >= 1) {
			//$empid=Utils::getName($did,'AssetsIssued','EmployeeId',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Employee overtime has been updated";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Employeeovertime", $msg, $orgid));
           $status =true;
		   $successMsg = "Overtime Amount Added Successfully";
        } else {
           $status =false;
		   $errorMsg = INCENTIVE_MODULE_UPDATION_FAILED;
        }
		}catch(Exception $e){
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a EmployeeOvertime (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
        $applymonth=$request[2];
		$mdate = date("Y-m-d H:i:s");
			$incentive = json_decode($_POST['incentivearr'], true); 
			for($i=0; $i<count($incentive); $i++)
			{
				if($incentive[$i]['employeeid']!="" && $incentive[$i]['amt']!=""){
					$record = array();
					$record[0] = $incentive[$i]['employeeid'];
					$record[1] = $incentive[$i]['desc'];
					$record[2] = $incentive[$i]['amt'];
					$record[3] = $applymonth;
					$record[4] = $orgid;
					$record[5] = $mdate;
					$record[6] = $mid;
					$record[7] = $mdate;
					$record[8] = $mid;
					$record[9] = $mid;
					
					$sqlincentive = " INSERT INTO EmployeeOvertime ( EmployeeId, Description, IncentiveAmount, ApplyDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?,?,?,?,?,?,?,?,?,?)";
					$queryincentive = $this->db->prepare($sqlincentive);
					$queryincentive->execute($record);
					$count =  $queryincentive->rowCount();
				}
			}
		if ($count >= 1) {
			//$empid=Utils::getName($did,'AssetsIssued','EmployeeId',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Employee overtime has been created";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Employeeovertime", $msg, $orgid));
           $status =true;
		   $successMsg = INCENTIVE_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = INCENTIVE_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }


  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid= $_SESSION['ubihrm_org_id'];
		$sql = "DELETE FROM EmployeeOvertime  WHERE Id = :id ";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			$empid=Utils::getName($did,'EmployeeOvertime','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Employee overtime has been updated $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Employeeovertime", $msg, $orgid));
           $status =true;
		   $successMsg = "Overtime Pay deleted successfully";
        }else {
           $status =false;
		   $errorMsg = INCENTIVE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM EmployeeMaster  WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->EmployeeCode;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeId($code)
	{
		$name ="";
		$sql = "SELECT Id FROM EmployeeMaster WHERE EmployeeCode = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $code ));
			while($row = $query->fetch())
			{
				$name = $row->Id;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	public function getDateformat($date)
	{	
		$format = $_SESSION['ubihrm_dateformate1'];
		$changedate=$date;
		
		if($format=="dd/mm/yyyy" || $format=="mm/dd/yyyy" || $format=="yyyy/mm/dd"){
			$temp = explode('/', $date);
			if($format=="dd/mm/yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm/dd/yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}elseif($format=="yyyy/mm/dd"){
				$changedate=$temp[0]."-".$temp[1]."-".$temp[2];
			}
		}elseif($format=="dd-mm-yyyy" || $format=="mm-dd-yyyy" || $format=="yyyy-mm-dd"){
			$temp = explode('-', $date);
			if($format=="dd-mm-yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm-dd-yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}else{
				$changedate=$date;
			}
		}
		return $changedate;
	}
	////////////////   FIND OUT THE OVERTIME PAYMENT AVAILABLE FOR THE ORGANIZATION /////////////////////////////	
	public function getTotalOvertime($empid,$orgid,$date)
	{
		$overtime=0;
		//echo $attsts;
		$sql1 = "SELECT AttendanceStatus, hour(sum(Overtime)) as overtime FROM AttendanceMaster WHERE OrganizationId = ? and EmployeeId=? and AttendanceStatus NOT IN (2,6)  AND (AttendanceDate BETWEEN '$date' AND last_day('$date')) ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid));
		while($row1 = $query1->fetch())
		{
			$overtime+=$row1->overtime;
		}
		return $overtime;
	}
	
	public function getEmployeeOvertime($empid, $date,$hourlyrate)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		
		$overtime=0;$weekoff=0; $holiday=0; $weekdays=0;
		$sql1 = "SELECT AttendanceStatus, hour(sum(Overtime)) as overtime FROM AttendanceMaster WHERE OrganizationId = ? and EmployeeId=? and AttendanceStatus NOT IN (2,6)  AND (AttendanceDate BETWEEN '$date' AND last_day('$date')) group by AttendanceStatus";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid));
		while($row1 = $query1->fetch())
		{
			if($row1->AttendanceStatus==3)
				$weekoff+=$row1->overtime;
			elseif($row1->AttendanceStatus==5)
				$holiday+=$row1->overtime;
			else
				$weekdays+=$row1->overtime;
		}
		 		
		////////////////   FIND OUT THE OVERTIME PAYMENT AVAILABLE FOR THE ORGANIZATION /////////////////////////////				
		$sql1 = "SELECT SettingId, ExecutionValue FROM SettingMaster sm, SettingChild sc where sm.Id=sc.SettingId and PageType=2 and OrganizationId=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid));
		while($row1 = $query1->fetch())
		{
			if($row1->SettingId==4)
				$overtime += $weekoff*$row1->ExecutionValue*$hourlyrate;
			elseif($row1->SettingId==5)
				$overtime += $holiday*$row1->ExecutionValue*$hourlyrate;
			else
				$overtime += $weekdays*$row1->ExecutionValue*$hourlyrate;
		}
		return $overtime;
	}
	
	
	////////////get total hours of a shift///////////
	
	public function getShifTotalHour($shiftid)
	{
		$name =0;
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$sql = "SElect Id, Name, HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour , MINUTE(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn),TIMEDIFF(TimeOutBreak, TimeInBreak))) as totalmin,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? and Id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$shiftid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					if($row->totaltime < 0){
						$totalmin = ($row->totalmin/60)*100;
						$tot=$row->totalhour.".".$totalmin;
						$name =24 - $tot;
					}else{
						$totalmin = ($row->totalmin/60)*100;
						$name = $row->totalhour.".".$totalmin;
					}
				}
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	
	public function getOvertimeRate($empid,$date)
	{
		$name =0;
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$sql = "Select AttendanceStatus from AttendanceMaster where EmployeeId=? and AttendanceDate=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $empid,$date));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					
					$sql1 = "SELECT SettingId, ExecutionValue FROM SettingMaster sm, SettingChild sc where sm.Id=sc.SettingId and PageType=2 and OrganizationId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid));
					while($row1 = $query1->fetch())
					{
						if($row1->SettingId==4 && $row->AttendanceStatus==3)
						{
							$name=$row1->ExecutionValue;
						}	
						elseif($row1->SettingId==5 && $row->AttendanceStatus==5)
						{
							$name=$row1->ExecutionValue;
						}	
						elseif($row1->SettingId==6 && $row->AttendanceStatus==1 )
						{
							$name=$row1->ExecutionValue;
						}	
					}
				}
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'EmployeeOvertime';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','EmployeeId','HourlyRate','Overtime', 'OvertimeAmount', 'ApplyDate','AttendanceDate','Description',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
		$sWhere = " WHERE  OrganizationId= $orgid AND EmployeeId in (SELECT Id FROM EmployeeMaster where ReportingTo=$userid and Is_Delete=0) OR EmployeeId =$userid";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				if($aColumns[$i]=="EmployeeId" && $i==0){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where  EmployeeCode LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($i==5){
					$sWhere .= $aColumns[$i]." between ".($_GET['sSearch_'.$i])." ";
				}elseif($i==1){
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editovertimepay/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[] = '<a href="'.URL.'salary/viewovertimepay/'.Utils::encode5t($aRow->Id).'/1">'.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster","EmployeeCode",$this->db).'</a>';
				}
				elseif($aColumns[$i]=="EmployeeId")
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db);
				}
				elseif($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="AttendanceDate"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ApplyDate"){
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Overtime" )
				{
					if($aRow->{$aColumns[$i]} == '00:00:00'){
						$row[] = '00:00';
					}else{
						$row[] = $aRow->{$aColumns[$i]};
					}
					
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate" ){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}elseif($aColumns[$i]=="OvertimeAmount"){
					$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
					$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	/////////////////////////import attendance//////////////
	
	public function getFileHeaders($request)
	{	
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$file_name = "";
			
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION); 
				
				$storage_name="overtime.$ext";
				if (file_exists($storage_name))
				{ unlink($storage_name); 
				} 
				$file_size =$_FILES['file0']['size'];
				$file_tmp =$_FILES['file0']['tmp_name'];
				$file_type=$_FILES['file0']['type'];   
				$location="public/uploads/$orgid/";
				if($file_size > 5097152){
				$errors[]='File size must be less than 5 MB';
				}	
				
				if(empty($errors)==true){
				
					move_uploaded_file($file_tmp, $location.$storage_name );
					chmod($location.$storage_name, 0755);
					
				}else{
					print_r($errors);
				}
			}		
		//$actual_date = "candidate_details_".$_REQUEST['org_id'];
		//$org_id = isset($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
		//$fileName=isset ($_REQUEST['fileName'])	? $_REQUEST['fileName'] : '';
		$ext = pathinfo($file_name, PATHINFO_EXTENSION);
		if ($ext=='csv'){
		
			$fp = $location.$storage_name;
			
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				$row = 1;
				$ind=1;
				$arrData 		= array();
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
					if($row == 1)
					{
						for($i = 0 ; $i<count($data);$i++)
						{
							
							$record 	= array();				
							
							$record['head_name'] = $data[$i];
							//$record['name'] = '';
							//$record['type'] = '';
							//$record['data_label'] = '';
							$record['rows'] = $count;
							$record['column_index'] = $count;
							$record['sts'] = true;
							$count++;
							
							$arrData[] = $record;			
						}
									
						$row++;
						
					}
				}
				
				
				if ($count >= 1) {
				   $status =true;
				   
				} 
				else {
				   $status =false;
				   $errorMsg = "Check your file format";
				}
				
				
			}
		}
		$result["data"] =$arrData;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
		
	}
	
	
	public function insertFileHeaders($request)
    {
		
		$result = array();
		$count=0; $count1=0;  $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$emp = $request[2];
		$atdate = $request[3];
		$amount = $request[4];
		$desc = $request[5];
		$overtime = $request[6];
		$hourlyrate = $request[7];
		$overtimemonth = $request[8];
		
		$file_name = "overtime.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$i=0;	
			$skip=0; $nskip=0; $code=0;
			
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					//print_R( $data);
					
					if($i>0){
							if($data[$emp]!=""){
								
								$empid=$this->getEmployeeId($data[$emp]);
							}
							$adate=Utils::getDateformat($data[$atdate]);
							if($empid!=0 && $data[$emp]!=""){
								//print_r($empid);
								$sql = "SELECT * FROM EmployeeOvertime WHERE AttendanceDate=? AND EmployeeId =?";
								$query = $this->db->prepare($sql);
								try{
									$query->execute(array( $adate, $empid ));
									$count =  $query->rowCount();
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
								if ($count >= 1) {
								   $skip++;
								   $sql = "UPDATE EmployeeOvertime set ApplyDate=?, Description=?, Overtime=?, HourlyRate=?, OvertimeAmount=? WHERE EmployeeId=? and AttendanceDate=? ";		
									try{
										//echo $data[$amount].' ';
										//$amt = preg_replace('~[",]~',  '', $data[$amount] );
										$ot= gmdate('H:i', floor($data[$overtime] * 3600));
										$query = $this->db->prepare($sql);
										$query->execute(array( $overtimemonth,$data[$desc],$ot ,$data[$hourlyrate],$data[$amount],$empid,$adate));
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
								}
								else{
									// SQL Query to insert data into DataBase
									$sql = "INSERT INTO EmployeeOvertime ( EmployeeId, Description, Overtime, HourlyRate, OvertimeAmount, ApplyDate,AttendanceDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";		
									try{
										$ot= gmdate('H:i', floor($data[$overtime] * 3600));
										$query = $this->db->prepare($sql);
										$query->execute(array($empid, $data[$desc],$ot ,$data[$hourlyrate],$data[$amount],$overtimemonth,$adate, $orgid, $mdate, $mid, $mdate, $mid, $mid));
									
										$count =  $query->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count >= 1) {
									   $nskip++;
									} 
								}
							}else{
								$code++;
							}	
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = "Overtime not imported, please check your csv file format";
	} 
	else{
		$status =true;
		$successMsg = "$nskip Overtime imported, $skip skip, $code Employees not found";
	}		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
}
