<?php

/**
 * EmpleaveModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class EmployeeleaveModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database rel
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several rels (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM EmployeeLeave WHERE OrganizationId = :id and EmployeeId=:eid";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid , ':eid' => $mid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
                                 
				$res['employeeid'] = $row->EmployeeId;
				$res['leavefrom'] = $row->LeaveFrom;
				$res['leaveto'] = $row->LeaveTo;
				$res['leavereason'] = $row->LeaveReason;
				$res['leavestatus'] = $row->LeaveStatus;
				$res['approvercomment'] = $row->ApproverComment;
                $res['applydate'] = $row->ApplyDate;
                $res['leavevalidsts'] = $row->LeaveValidDays;
                $res['fiscalid'] = $row->FiscalId;
                $res['approvedby'] = $row->ApprovedBy;
                $res['leavetypeid'] = $row->LeaveTypeId;
                $res['resumptiondate'] = $row->ResumptionDate;
				$res['createdate'] = $row->CreatedDate;
				$res['lastmodifieddate'] = $row->LastModifiedDate;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEELEAVE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getTimeOffDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			
			$sql = "SELECT * FROM Timeoff WHERE Id = :id";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
			$res=array();
			$createdate=$row->CreatedDate;
			$timeofdate=$row->TimeofDate;
			
			$res["date"]=date("d/m/Y", strtotime($createdate));
			$res["timeoffdate"]=date("d/m/Y", strtotime($timeofdate));
			$res["employeeid"]=(int)$row->EmployeeId;
			$res["timefrom"]=$row->TimeFrom;
			$res["timeto"]=$row->TimeTo;
			$res["reason"]=$row->Reason;
			$sts=$row->ApprovalSts;
			if($sts==2)
			$res["sts"]="Approved";
		elseif($sts==3)
			$res["sts"]="Pending";
			elseif($sts==1)
			$res["sts"]="Rejected";
			elseif($sts==4)
			$res["sts"]="Cancel";
			elseif($sts==5)
			$res["sts"]="Withdraw";
			else
				$res["sts"]="Pending";
			$res["comment"]=$row->ApproverComment;
			$res["id"]=$row->Id;
			$data[]=$res;
				}
			}
			
			if ($count >= 1) {
			   $status =true;
			   $successMsg = EMPLOYEELEAVE_MODULE_GETDETAIL_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = EMPLOYEELEAVE_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$changests 	= 0;
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			if($sts==1 || $hrsts==1)
			{
				$changests 	= 1;
			}
			$sql = "SELECT * FROM EmployeeLeave WHERE Id = :id";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();				
					$res['fromdate'] 		= Utils::dateformatter($row->LeaveFrom);       
					$res['fromdate1'] 		= $row->LeaveFrom;       
					$res['employeeid'] 		= (int)$row->EmployeeId;
					$res['todate'] 			= Utils::dateformatter($row->LeaveTo);
					$res['todate1'] 		= $row->LeaveTo;
					$res['leavereason'] 	= $row->LeaveReason;
					$res['leavestatus'] 	= $row->LeaveStatus;
					$res['approvercomment'] = $row->ApproverComment;
					$res['applydate'] 		= Utils::dateformatter($row->ApplyDate);
					$res['leavevalidsts'] 	= $row->LeaveValidDays;
					$res['approvedby'] 		= (int)$row->ApprovedBy;
					$res['fiscalid'] 		= $row->FiscalId;
					$res['leavetypeid'] 	= (int)$row->LeaveTypeId;
					$res['resumptiondate'] 	= Utils::dateformatter($row->ResumptionDate);
					$res['substituteid'] 		= $row->SubstituteEmployeeId;
					$res['emergencycontact'] 	= $row->EmergencyContact;
					$res['fromdaytype'] 	= $row->FromDayType;
					$res['todaytype'] 	= $row->ToDayType;
					$res['timeoffrom'] 	= $row->TimeOfFrom;
					$res['timeofto'] 	= $row->TimeOfTo;
					$res['leavebreakdown'] 	= $row->LeaveBreakDown;
					$res['leaveattachment'] 	= "";
					$code=Utils::getName($row->EmployeeId,'EmployeeMaster','EmployeeCode',$this->db);
					$doc1="$code".'_'."$id";
					$dir="public/uploads/$orgid/$code";
					$filename="";
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext = pathinfo($filename, PATHINFO_EXTENSION);
								if($filename=="$doc1.$ext")
								{
									$res['leaveattachment']=URL.$dir."/$filename";
								}
							}
							closedir($dh);
						}
					}
					
					$data[] = $res;
				}
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = EMPLOYEELEAVE_MODULE_GETDETAIL_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = EMPLOYEELEAVE_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['changestatus']=$changests;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a Employeeleave (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {         
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $id = $request[8]; $annualsts=0;
        $month = Utils::getDateformat($request[9]);
		$leavefrom = Utils::getDateformat($request[3]);
		$leaveto = Utils::getDateformat($request[4]);
		$mdate = date("Y-m-d H:i:s");
		$fiscal =Utils::getFiscalId($month, $this->db);
		try{
		$sql = "SELECT * FROM EmployeeLeave WHERE EmployeeId=? and ((? between  LeaveFrom and LeaveTo )or (? between  LeaveFrom and LeaveTo )) and (LeaveStatus=2 or LeaveStatus=3) and Id<>?";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[2],$leavefrom,$leaveto,$id));
		$count =$count +  $query->rowCount();
		
		if($count>=1)
		{
			$status=false;
			$errorMsg=" Leave already Exist";
		}else{
		if($fiscal>0)
		{
			$sql = "UPDATE EmployeeLeave SET  EmployeeId=?, LeaveFrom=?,  LeaveTo=?, LeaveReason=?, LeaveTypeId=?, ResumptionDate=?, ApplyDate=?, LeaveStatus=?, ApprovedBy=?, ApproverComment=?, LastModifiedDate=?, LastModifiedById=?, EmergencyContact=?,LeaveValidDays=?,FromDayType=?,ToDayType=?,TimeOfFrom=?,TimeOfTo=? ,LeaveBreakDown=?,FiscalId=? where Id=?";	
				   $query = $this->db->prepare($sql);
			
			
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array( $request[2], Utils::getDateformat($request[3]), Utils::getDateformat($request[4]), $request[5], $request[6], Utils::getDateformat($request[7]), Utils::getDateformat($request[9]), $request[10], $request[11],$request[12], $mdate, $mid, $request[13],$request[14],$request[15],$request[16],$request[17],$request[18],$request[19],$fiscal, $id));			
				$count =  $query->rowCount();
				
				$sql = "DELETE FROM EmployeeLeaveChild  where EmployeeLeaveId =?";
				$query = $this->db->prepare($sql);
				$query->execute(array( $id));
				$leavecal=Utils::getName($request[6],'LeaveMaster','CarryForward',$this->db);
				$leavebreakdown = explode(',',$request[19]);
				$entitled=$leavebreakdown[0];
				$carryforward=$leavebreakdown[1];
				$advance=$leavebreakdown[2];
				$unpaid=$leavebreakdown[3];
				$i=0; $e=0; $c=0; $a=0; $l=0;
					
						while(date($leavefrom)<=date($leaveto))
						{
							$halfday=0;
							
							
							if($this->checkHoliday($leavefrom, $request[2],$leavecal))
							{
								
								if($i==0)
								{
									if($request[15]==2)
									{
										//$halfday=1;
									}	
								}
								if(($leavefrom == $leaveto) && ($this->checkHoliday($leaveto, $request[2],$leavecal)))
								{
									if($request[16]==2)
									{
										//$halfday=1;
									}
								}
								if($this->checkHalfday($leavefrom, $request[2]))
								{
									//$halfday=1;
								}
								$paysts = Utils::getName($request[6], "LeaveMaster", "LeavePayRule", $this->db);
								/*if($paysts !=0){
									$leftleave=$this->getEmployeeLeftLeave($request[2],$request[6],$leavefrom);
									if($leftleave<=0)
									{
										$paysts =0;
									}
								}*/
								
								//////This calculation belongs to leave break down//////////
								
								if($entitled>0)
								{
									$e=1; $c=0; $a=0; $l=0;
									
									/* $entitled--;
									if($entitled == ".5")
										$halfday=1; */
									//if($i>0)
									if($entitled == ".5")
										$halfday=1;	
									$entitled--;
									
								}
								elseif($carryforward>0 )
								{
									$e=0; $c=1; $a=0; $l=0;
									/* $carryforward--;
									if($carryforward == ".5")
										$halfday=1; */
									//if($i>0)
									if($carryforward == ".5")
										$halfday=1;	
									$carryforward--;
								
								}
								elseif($advance>0 )
								{
									$e=0; $c=0; $a=1; $l=0;
									/* $advance--;
									if($advance == ".5")
										$halfday=1; */
									//if($i>0)
									if($advance == ".5")
										$halfday=1;	
									$advance--;
									
								}
								elseif($unpaid>0 )
								{
									$e=0; $c=0; $a=0; $l=1;
									
									/* if($unpaid == ".5")
										$halfday=1; */
									//if($i>0)
									if($unpaid == ".5")
										$halfday=1;	
									$unpaid--;
									
								}
								
								$sql = "INSERT INTO EmployeeLeaveChild  (EmployeeLeaveId, LeaveDay, LeaveStatus, LeaveTypeId, PaySts,HalfDaySts,Entitled, CarriedForward, Advance, LossOfPay) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
								$query = $this->db->prepare($sql);
								$query->execute(array( $id, $leavefrom, 2, $request[6], $paysts,$halfday,$e,$c,$a,$l));
								
							}
							
							$i++;
							$leavefrom = date("Y-m-d", strtotime(date($leavefrom).", +1 day"));							
						}
			
			if ($count == 1) {
				//////////////////// ACTIVITY LOG///////////////////////////////
                $empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$msg="A leave of $empname has been updated";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Leave", $msg, $orgid));
				$status =true;
				$successMsg = EMPLOYEELEAVE_MODULE_SUCCESS;
			}else{ 
				$status =false;
				$errorMsg = EMPLOYEELEAVE_MODULE_FAILED;
			}    
		}else{
			$status =false;
			$errorMsg = FISCAL_MODULE_GETALL;
		}
		}
		}catch(Exception $e) {                              
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result["leaveid"] =$id;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a Employeeleave (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $leaveid=0;
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$annualsts=0;
		try{		
		$mdate = date("Y-m-d H:i:s");
		$month = Utils::getDateformat($request[8]);
		$fiscal =Utils::getFiscalId($month, $this->db);
		$leavefrom = Utils::getDateformat($request[3]);
		$leaveto = Utils::getDateformat($request[4]);
		$sql = "SELECT * FROM EmployeeLeave WHERE EmployeeId=? and ((? between  LeaveFrom and LeaveTo )or (? between  LeaveFrom and LeaveTo )) and (LeaveStatus=2 or LeaveStatus=3)";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[2],$leavefrom,$leaveto));
		$count =$count +  $query->rowCount();
		
		if($count>=1)
		{
			$status=false;
			$errorMsg=" Leave already Exist";
		}else{
		if($fiscal>0)
		{
			$sql = "INSERT INTO EmployeeLeave  (EmployeeId, LeaveFrom, LeaveTo, LeaveReason,   ApplyDate, LeaveTypeId, ResumptionDate, FiscalId, LeaveStatus, ApprovedBy, ApproverComment, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, EmergencyContact,LeaveValidDays,FromDayType, ToDayType, TimeOfFrom, TimeOfTo,LeaveBreakDown) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";		
			$query = $this->db->prepare($sql);
			$query->execute(array( $request[2], $leavefrom, $leaveto, $request[5], Utils::getDateformat($request[8]), $request[6], Utils::getDateformat($request[7]), $fiscal, 2, $mid,$request[11], $orgid, $mdate, $mid, $mdate, $mid, $mid, $request[12],$request[13],$request[14],$request[15],$request[16],$request[17],$request[18]));
			$leaveid=$result['leaveid'] = $this->db->lastInsertId();
			$count =  $query->rowCount();		
			if ($count == 1) {
				//////////////////// ACTIVITY LOG///////////////////////////////
                 $empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$msg="A leave of $empname has been created";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Leave", $msg, $orgid)); 
				
			   $status =true;
			   $successMsg = EMPLOYEELEAVE_MODULE_CREATION_SUCCESS;
			   
			  
				$leavecal=Utils::getName($request[6],'LeaveMaster','CarryForward',$this->db);
				//$balanceleave=$this->getEntitledLeave($request[2],$fiscal);
				$leavebreakdown = explode(',',$request[18]);
				$entitled=$leavebreakdown[0];
				$carryforward=$leavebreakdown[1];
				$advance=$leavebreakdown[2];
				$unpaid=$leavebreakdown[3];
					$i=0; $e=0; $c=0; $a=0; $l=0;
						while(date($leavefrom)<=date($leaveto))
						{
							$halfday=0;
							if($this->checkHoliday($leavefrom, $request[2],$leavecal))
							{
								if($i==0)
								{
									if($request[14]==2)
									{
										//$halfday=1;
									}	
								}
								if(($leavefrom == $leaveto) && ($this->checkHoliday($leaveto, $request[2],$leavecal)))
								{
									if($request[15]==2)
									{
										//$halfday=1;
									}
								}
								if($this->checkHalfday($leavefrom, $request[2]))
								{
									//$halfday=1;
								}
								$paysts = Utils::getName($request[6], "LeaveMaster", "LeavePayRule", $this->db);
								/*if($paysts !=0){
									$leftleave=$this->getEmployeeLeftLeave($request[2],$request[6],$leavefrom);
									if($leftleave<=0)
									{
										$paysts =0;
									}
								}*/
								
								//////This calculation belongs to leave break down//////////
								
								if($entitled>0)
								{
									$e=1; $c=0; $a=0; $l=0;
									
									/* $entitled--;
									if($entitled == ".5")
										$halfday=1; */
									//if($i>0)
									if($entitled == ".5")
										$halfday=1;	
									$entitled--;
									
								}
								elseif($carryforward>0 )
								{
									$e=0; $c=1; $a=0; $l=0;
									/* $carryforward--;
									if($carryforward == ".5")
										$halfday=1; */
									//if($i>0)
									if($carryforward == ".5")
										$halfday=1;	
									$carryforward--;
								
								}
								elseif($advance>0 )
								{
									$e=0; $c=0; $a=1; $l=0;
									/* $advance--;
									if($advance == ".5")
										$halfday=1; */
									//if($i>0)
									if($advance == ".5")
										$halfday=1;	
									$advance--;
									
								}
								elseif($unpaid>0 )
								{
									$e=0; $c=0; $a=0; $l=1;
									
									/* if($unpaid == ".5")
										$halfday=1; */
									//if($i>0)
									if($unpaid == ".5")
										$halfday=1;	
									$unpaid--;
									
								}
								
								$sql2 = "SELECT * from EmployeeLeaveChild  where EmployeeLeaveId =? and LeaveDay =? and LeaveTypeId=? ";
								$query2 = $this->db->prepare($sql2);
								$query2->execute(array( $leaveid, $leavefrom,  $request[6]));
								if($query2->rowCount()==0){
									$sql = "INSERT INTO EmployeeLeaveChild  (EmployeeLeaveId, LeaveDay, LeaveStatus, LeaveTypeId, PaySts,HalfDaySts,Entitled, CarriedForward, Advance, LossOfPay) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
									$query = $this->db->prepare($sql);
									$query->execute(array( $leaveid, $leavefrom, 2, $request[6], $paysts,$halfday,$e,$c,$a,$l));
								}else{
									$sql = "UPDATE EmployeeLeaveChild  set  LeaveStatus=?, PaySts=?,HalfDaySts=?, Entitled=?, CarriedForward=?, Advance=?, LossOfPay=? where EmployeeLeaveId =? and LeaveDay =? and LeaveTypeId=?";
									$query = $this->db->prepare($sql);
									$query->execute(array( 2,  $paysts,$halfday,$e,$c,$a,$l,$leaveid, $leavefrom, $request[6] ));
								
								}
							}
							$i++;
							$leavefrom = date("Y-m-d", strtotime(date($leavefrom).", +1 day"));		
						}
					/*$senior = Utils::getApprovalLevelEmp($request[2], 1, $this->db);
					if($senior!=0)
					{
						$temp = explode(",", $senior);
						for($i=0; $i<count($temp); $i++)
						{
							$sql = "INSERT INTO LeaveApproval ( LeaveId, ApproverId, ApproverSts, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
							$query = $this->db->prepare($sql);
							$query->execute(array($leaveid, $temp[$i], 3, $mdate, $orgid));
						}
					}*/
			} else {
			   $status =false;
			   $errorMsg = EMPLOYEELEAVE_MODULE_CREATION_FAILED;
			}
		}else{
			$status =false;
			   $errorMsg = FISCAL_MODULE_GETALL;
		}
		}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result["leaveid"] =$leaveid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function checkHolidaybak5oct2018($leavefrom, $empid,$leavecal)
	{
		if($leavecal==0){
			$orgid=$_SESSION['ubihrm_org_id'];
			$div=Utils::getName($empid,'EmployeeMaster','Division',$this->db);
			$sql = "SELECT Id, Name FROM HolidayMaster WHERE OrganizationId=? and ? between DateFrom and DateTo and FIND_IN_SET($div,DivisionId)";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$leavefrom ));
			if($query->rowCount()>0)
			{
				return false;
			}else{
				$sql1 = "SELECT WorkingDays FROM EmployeeMaster WHERE Id = ?";
				 $query1 = $this->db->prepare($sql1);
				 $query1->execute(array( $empid ));			
				 $row1 = $query1->fetch();
				 $workingday = $row1->WorkingDays;
				 
				$temparr = explode(',',$workingday);
				$dw = date( "w", strtotime(date($leavefrom)));
				$date = "Leave Day";
				for($i=0; $i<count($temparr); $i++)
				{
					if($dw == $i){
						if($temparr[$i]==3){
							return false;
							//break;
						}/* elseif($temparr[$i]==2){
							return false;
							break;
						} */
					}
				}			
			}
			return true;
		}else{
			return true;
		}
		
		
	}
	
	public function checkHoliday($leavefrom, $empid,$leavecal)
	{
		$weekno=Utils::weekOfMonth($leavefrom);
		$dayofdate= 1 + date("w", strtotime($leavefrom));
		if($leavecal==0){
			$orgid=$_SESSION['ubihrm_org_id'];
			$div=Utils::getName($empid,'EmployeeMaster','Division',$this->db);
			$sql = "SELECT Id, Name FROM HolidayMaster WHERE OrganizationId=? and ? between DateFrom and DateTo and FIND_IN_SET($div,DivisionId)";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid,$leavefrom ));
			if($query->rowCount()>0)
			{
				return false;
			}else{
				//$sql1 = "SELECT WorkingDays FROM EmployeeMaster WHERE Id = ?";
				$sql1 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=(select shift from EmployeeMaster where Id=$empid) and Day=$dayofdate";
				 $query1 = $this->db->prepare($sql1);
				 $query1->execute(array( $empid ));			
				 $row1 = $query1->fetch();
				 $workingday = $row1->WeekOff;
				 
				$temparr = explode(',',$workingday);
				$dw = date( "w", strtotime(date($leavefrom)));
				$date = "Leave Day";
				if($temparr[$weekno-1]==1){
					return false;
					//break;
				}
				/* for($i=0; $i<count($temparr); $i++)
				{
					if($dw == $i){
						if($temparr[$i]==3){
							return false;
							break;
						}
					}
				} */			
			}
			return true;
		}else{
			return true;
		}
		
		
	}
	
	public function checkHalfday($leavefrom, $empid)
	{
		$weekno=Utils::weekOfMonth($leavefrom);
		$dayofdate= 1 + date("w", strtotime($leavefrom));
		$sql1 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=(select shift from EmployeeMaster where Id=$empid) and Day=$dayofdate";
		 $query1 = $this->db->prepare($sql1);
		 $query1->execute(array( $empid ));			
		
		if( $row1 = $query1->fetch()) {
			$workingday = $row1->WeekOff;
			$temparr = explode(',',$workingday);
			$dw = date( "w", strtotime(date($leavefrom)));
			$date = "Leave Day";
			if($temparr[$weekno-1]==2){
				return true;
				//break;
			}
		}
		return false;
		
	}
	
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM LeaveApproval WHERE LeaveId = :id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		
		$sql = "DELETE FROM EmployeeLeaveChild WHERE EmployeeLeaveId = :id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		$empid=Utils::getName($did,'EmployeeLeave','EmployeeId',$this->db);	
			
		$sql = "DELETE FROM EmployeeLeave WHERE Id = :id ";
		try{			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$mid= $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		if ($count == 1) {
			//////////////////// ACTIVITY LOG///////////////////////////////
			 
                $empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="A leave of $empname has been updated";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Employee Leave", $msg, $orgid));
           $status =true;
		   $successMsg = EMPLOYEELEAVE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = EMPLOYEELEAVE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getleavetype($id)
	{
		$name ="";
		$sql = "SELECT * FROM LeaveMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getEmployeeName($id)
	{
		$name ="";
		$sql = "SELECT FirstName, MiddleName, LastName FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName));
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getEntitledLeave($empid,$fiscal)
	{
		$name =0;
		$sql = "SELECT BalanceLeave FROM LeaveHistory WHERE EmployeeId = :id and FiscalId= :fid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $empid,':fid' => $fiscal ));
			while($row = $query->fetch())
			{
				$name = $row->BalanceLeave;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		
		$sTable = 'EmployeeLeave';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId', 'LeaveFrom', 'LeaveTo','ApplyDate','LeaveValidDays', 'ApprovedBy','LeaveTypeId', "LeaveBreakDown",'ResumptionDate', 'LeaveReason','ApproverComment','LeaveStatus','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY  ApplyDate desc";
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$fiscalid=Utils::getFiscalId(date('Y-m-d'), $this->db);
		$ids = Utils::getReportingIds($userid, $this->db);
		$dept=isset($_GET['department'])?$_GET['department']:0;
		$desig=isset($_GET['designation'])?$_GET['designation']:0;
		$div=isset($_GET['division'])?$_GET['division']:0;
		$sWhere = "";
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
			if($dept != 0 || $desig != 0 || $div != 0){
				$sWhere = "Where (EmployeeId in (select Id from EmployeeMaster where  Is_Delete=0 and Department=$dept or Designation =$desig OR Division =$div) AND OrganizationId= $orgid) ";
			}
			if($dept != 0 && $desig != 0 && $div != 0){
				$sWhere = " WHERE  OrganizationId = $orgid and (EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 and Department=$dept AND Designation =$desig AND Division =$div))";
			}
		}else{
			$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)) ";
			if($dept != 0 || $desig != 0 || $div != 0){
				$sWhere = "Where (EmployeeId in ($ids) and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 and Department=$dept or Designation =$desig OR Division =$div) AND OrganizationId= $orgid) ";
			}
			if($dept != 0 && $desig != 0 && $div != 0){
				$sWhere = " WHERE (EmployeeId in ($ids) and OrganizationId = $orgid and (EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 and  Department=$dept AND Designation =$desig AND Division =$div))";
			}
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}
				elseif($aColumns[$i]=="LeaveTypeId"){
				$sWhere .= " (LeaveTypeId in ( select Id from LeaveMaster where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				if($i==3){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}else if($i==1){
					$sWhere .= " Id in( select EmployeeLeaveId from EmployeeLeaveChild where LeaveDay between ".($_GET['sSearch_'.$i]).") ";
					//$sWhere .= " (".$aColumns[$i]." = ".Utils::getDateformat($_GET['sSearch_'.$i]).") ";
				}
				else{
					//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
					$sWhere .= $aColumns[$i]." = '".($_GET['sSearch_'.$i])."' ";
				}
			}
		}
		
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array(); $flg=false;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
									
					$edit =""; $delete="";
					$flg = ($aRow->LeaveStatus == 1) ? true : (($aRow->LeaveStatus == 5)  ? true : false);
					
					if($editper && !$flg){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'leave/editemployeeleave/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
					elseif($editper &&  $flg){
						$edit = '<a href="#" rel="tooltip" title="Application is either Rejected or Withdrawn"><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
					
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				
					
				}elseif($aColumns[$i]=="EmployeeId" ){
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'leave/viewemployeeleave/'.Utils::encode5t($aRow->Id).'/1" >'.self::getEmployeeName($aRow->{$aColumns[$i]}).'</a>';
				
					
				}elseif( $aColumns[$i]=="ApprovedBy" || $aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById"){
					$row[] = self::getEmployeeName($aRow->{$aColumns[$i]});
					
				}
				elseif($aColumns[$i]=="LeaveStatus"){
					if($aRow->{$aColumns[$i]}==3){
						$pendingapprover=$this->getApproversts($aRow->{$aColumns[12]},3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
                 }
				elseif($aColumns[$i]=="LeaveTypeId"){
					$row[] = self::getName($aRow->{$aColumns[$i]},'LeaveMaster');
				}				
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate" ){
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ApplyDate" || $aColumns[$i]=="ResumptionDate" || $aColumns[$i]=="LeaveFrom" || $aColumns[$i]=="LeaveTo"){
					if(($aRow->{$aColumns[$i]})=="0000-00-00")
					{
						$row[]="-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}elseif($aColumns[$i]=="LeaveBreakDown"){
					$leavebreakdown=explode(",",$aRow->{$aColumns[$i]});
					$en=""; $cf=""; $ad=""; $lop="";
					if(count($leavebreakdown)>0)
					{
						$entitled=isset($leavebreakdown[0])?$leavebreakdown[0]:0;
						$carryforward=isset($leavebreakdown[1])?$leavebreakdown[1]:0;
						$advance=isset($leavebreakdown[2])?$leavebreakdown[2]:0;
						$unpaid=isset($leavebreakdown[3])?$leavebreakdown[3]:0;
						if($entitled!=0 && $entitled !=null )
							$en=$entitled."-Entitled ";
						if($carryforward!=0 && $carryforward!=null )
							$cf=$carryforward."-Carry forward ";
						if($advance!=0 && $advance!=null )
							$ad=$advance."-Advance ";
						if($unpaid!=0 && $unpaid!=null )
							$lop=$unpaid."-Loss of Pay";
					}
					$row[] = $en.$cf.$ad.$lop;
				}		
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	
	
////////////////////////////////////////////////////////////////////////
	public function getEmployeeLeftLeave($mid,$leavetype,$applydate)
    {
		$orgid=$_SESSION['ubihrm_org_id'];
		$count=0; $leftleave=0;
		$leaveid=0; $result=0;
			try{
				$fiscalid = Utils::getFiscalId($applydate, $this->db);
				$employeeusedleave=0;
				$sql1 = "SELECT Id  FROM EmployeeLeave WHERE OrganizationId = ? and EmployeeId =? and LeaveTypeId=? and FiscalId =? and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $mid, $leavetype, $fiscalid));
				while($row1=$query1->fetch()){
					$leaveid.=','.$row1->Id;
				}
				$sql1 = "SELECT LeaveDays FROM LeaveMaster WHERE Id =?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $leavetype));
				while($row1=$query1->fetch()){
					$total=$row1->LeaveDays;
				}
				
					$sql = "SELECT HalfDaySts  FROM EmployeeLeaveChild WHERE EmployeeLeaveId in ($leaveid) and LeaveTypeId=? and Entitled=1 and LeaveStatus=2";
					$query = $this->db->prepare($sql);
					$query->execute(array( $leavetype));
					while($row1=$query->fetch())
					{
						if($row1->HalfDaySts == 1 ){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					}
					$leftleave = $total-$employeeusedleave;
					if($leftleave>0)
					{
						$result=$leftleave;
					}
				
				
				
		}catch(Exception $e) {
			
			$e->getMessage();
		}
		
		
		return $result;
    }
	
		//////////////////////////// to find out the approver on which the leave is pending ///////////////////////////
	
		public function getApproversts($id,$sts)
		{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM LeaveApproval where LeaveId=? and ApproverSts=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM LeaveApproval where LeaveId=? and ApproverSts=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					$name = $row->ApproverId;
				}
			}catch(Exception $e) {}
			return $name;
		}

}
