<?php

/**
 * EmployeeincentiveModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class EmployeeincentiveModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$applydate=$_POST['applymonth'];
		$dept=$_POST['deptid'];
		$div=$_POST['divisionid'];
		$sWhere ="";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hr=$_SESSION['ubihrm_hr_sts'];
		
		if($sts!=1 && $hr!=1){
			$sWhere = " AND ReportingTo=$mid  ";
		}
		if($div != 0 && $div != ''){
			$sWhere .= " AND Division=$div ";
		}
		if($dept != 0 && $dept != ''){
			$sWhere .= " AND Department =$dept ";
		}
		
		
		
		
		$sql = "SELECT Id, EmployeeCode, FirstName, MiddleName, LastName FROM EmployeeMaster WHERE OrganizationId = :id and PayPattern=1 $sWhere";
        $query = $this->db->prepare($sql);
		
        
		try{
			$query->execute(array(':id' => $orgid ));
			while($row = $query->fetch())
			{
				$res = array();
				$empid=$row->Id;
				$res['id'] = "";
				$res['employeeid'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".(ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName)));
				$res['desc'] = "";
                $res['amt'] = 0;
                
				
                $sql1 = "SELECT * FROM EmployeeIncentive WHERE OrganizationId = ? AND EmployeeId = ? AND ApplyDate = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid , $empid , $applydate ));
				$count =  $query1->rowCount();
				while($row1 = $query1->fetch())
				{
					
					$res['id'] = $row1->Id;
					//$res['employeeid'] = $row1->EmployeeId;
					//$res['name'] = $this->getName($row1->EmployeeId);
					$res['desc'] = $row1->Description;
					$res['amt'] = $row1->IncentiveAmount;
					$res['applydate'] = $row1->ApplyDate;
					$res['applydate1'] = $row1->ApplyDate;
				}
				$data[] = $res;
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
			$status=true;
			$successMsg=" record found";
			
		
		 
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$applydate="";
		$applydate1="";
        $sql = "SELECT * FROM EmployeeIncentive WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['employeeid'] = $row->EmployeeId;
				$res['name'] = Utils::getEmployeeName($row->EmployeeId, $this->db);
				$res['desc'] = $row->Description;
				$res['amt'] = $row->IncentiveAmount;
				$applydate=$res['applydate'] = Utils::monthdateformatter($row->ApplyDate);
				$applydate1=$res['applydate1'] = $row->ApplyDate;
                
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
		//$applydate=$amonth;
           $status =true;
		   $successMsg = INCENTIVE_MODULE_GETDETAIL_SUCCESS;
        } else {
			$applydate=date('F Y');
			$applydate1=date('Y-m-1');
			
           $status =true;
		   $errorMsg = INCENTIVE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result["applydate"] =$applydate;
		$result["applydate1"] =$applydate1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a EmployeeIncentive (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
        $applymonth=$request[2];
		$mdate = date("Y-m-d H:i:s");
		$incentive = json_decode($_POST['incentivearr'], true); 
		for($i=0; $i<count($incentive); $i++) {
			if($incentive[$i]['employeeid']!="" && $incentive[$i]['amt']!=""){
				$record = array();
				$record[0] = $incentive[$i]['employeeid'];
				$record[1] = $incentive[$i]['desc'];
				$record[2] = $incentive[$i]['amt'];
				$record[3] = $applymonth;
				$record[4] = $orgid;
				$record[5] = $mdate;
				$record[6] = $mid;
				$record[7] = $mdate;
				$record[8] = $mid;
				$record[9] = $mid;
				$id=$incentive[$i]['id'];
				if($id && strtotime($applymonth) == strtotime($incentive[$i]['applydate1'])){
					$sqlincentive = " UPDATE EmployeeIncentive SET EmployeeId=?, Description=?, IncentiveAmount=?, ApplyDate=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
					$queryincentive = $this->db->prepare($sqlincentive);
					$queryincentive->execute(array($incentive[$i]['employeeid'],$incentive[$i]['desc'],$incentive[$i]['amt'],$applymonth,$orgid,$mdate,$mid,  $id));
					$count =  $queryincentive->rowCount();
				}else{
					$sqlincentive = " INSERT INTO EmployeeIncentive ( EmployeeId, Description, IncentiveAmount, ApplyDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?,?,?,?,?,?,?,?,?,?)";
					$queryincentive = $this->db->prepare($sqlincentive);
					$queryincentive->execute($record);
					$count =  $queryincentive->rowCount();
				}
			}
			elseif($incentive[$i]['employeeid']!="" && $incentive[$i]['id']!="" && $incentive[$i]['amt']==""){
				$id=$incentive[$i]['id'];
				$sqlincentive = " UPDATE EmployeeIncentive SET EmployeeId=?, Description=?, IncentiveAmount=?, ApplyDate=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
				$queryincentive = $this->db->prepare($sqlincentive);
				$queryincentive->execute(array($incentive[$i]['employeeid'],$incentive[$i]['desc'],$incentive[$i]['amt'],$applymonth,$orgid,$mdate,$mid,  $id));
				$count =  $queryincentive->rowCount();
			}
		}
		if ($count >= 1) {
			//$empid=Utils::getName($did,'DocumentReleaseMaster','EmployeeId',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Employee incentive has been updated";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Employee Incentive", $msg, $orgid));
           $status =true;
		   $successMsg = INCENTIVE_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = INCENTIVE_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a EmployeeIncentive (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
        $applymonth=$request[2];
		$mdate = date("Y-m-d H:i:s");
		$incentive = json_decode($_POST['incentivearr'], true); 
		for($i=0; $i<count($incentive); $i++) {
			if($incentive[$i]['employeeid']!="" && $incentive[$i]['amt']!=""){
				$record = array();
				$record[0] = $incentive[$i]['employeeid'];
				$record[1] = $incentive[$i]['desc'];
				$record[2] = $incentive[$i]['amt'];
				$record[3] = $applymonth;
				$record[4] = $orgid;
				$record[5] = $mdate;
				$record[6] = $mid;
				$record[7] = $mdate;
				$record[8] = $mid;
				$record[9] = $mid;
				$sqlincentive = " INSERT INTO EmployeeIncentive ( EmployeeId, Description, IncentiveAmount, ApplyDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?,?,?,?,?,?,?,?,?,?)";
				$queryincentive = $this->db->prepare($sqlincentive);
				$queryincentive->execute($record);
				$count =  $queryincentive->rowCount();
			}
		}
		if ($count >= 1) {
			//$empid=Utils::getName($did,'DocumentReleaseMaster','EmployeeId',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Employee incentive has been created";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Employee Incentive", $msg, $orgid));
           $status =true;
		   $successMsg = INCENTIVE_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = INCENTIVE_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }


  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "DELETE FROM EmployeeIncentive  WHERE Id = :id ";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			$empid=Utils::getName($did,'EmployeeIncentive','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Employee incentive has been deleted $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Employee Incentive", $msg, $orgid));
           $status =true;
		   $successMsg = INCENTIVE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = INCENTIVE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM EmployeeMaster  WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->EmployeeCode;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeId($code)
	{
		$name ="";
		$sql = "SELECT Id FROM EmployeeMaster WHERE EmployeeCode = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $code ));
			while($row = $query->fetch())
			{
				$name = $row->Id;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	public function getDateformat($date)
	{	
		$format = $_SESSION['ubihrm_dateformate1'];
		$changedate=$date;
		
		if($format=="dd/mm/yyyy" || $format=="mm/dd/yyyy" || $format=="yyyy/mm/dd"){
			$temp = explode('/', $date);
			if($format=="dd/mm/yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm/dd/yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}elseif($format=="yyyy/mm/dd"){
				$changedate=$temp[0]."-".$temp[1]."-".$temp[2];
			}
		}elseif($format=="dd-mm-yyyy" || $format=="mm-dd-yyyy" || $format=="yyyy-mm-dd"){
			$temp = explode('-', $date);
			if($format=="dd-mm-yyyy"){
				$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
			}elseif($format=="mm-dd-yyyy"){
				$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
			}else{
				$changedate=$date;
			}
		}
		return $changedate;
	}
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'EmployeeIncentive';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','EmployeeId', 'IncentiveAmount', 'ApplyDate','Description',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid";
		}
		else{
		$sWhere = " WHERE  OrganizationId= $orgid AND EmployeeId in (SELECT Id FROM EmployeeMaster where ReportingTo=$userid) OR EmployeeId =$userid";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				if($aColumns[$i]=="EmployeeId" && $i==0){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where  EmployeeCode LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($i==3){
					$sWhere .= $aColumns[$i]." LIKE ".($_GET['sSearch_'.$i])." ";
				}elseif($i==1){
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editemployeeincentive/'.$aRow->{$aColumns[$i]}.'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[] = '<a href="'.URL.'salary/viewincentive/'.$aRow->Id.'/1">'.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster","EmployeeCode",$this->db).'</a>';
				}
				elseif($aColumns[$i]=="EmployeeId")
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db);
				}
				elseif($aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById")
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ApplyDate"){
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate" ){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}elseif($aColumns[$i]=="IncentiveAmount"){
					$empdivision=Utils::getName($aRow->EmployeeId,"EmployeeMaster",'DIvision',$this->db);
					$divcur= Utils::getDivisioncurrency($empdivision,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	/////////////////////////import attendance//////////////
	
	public function getFileHeaders($request)
	{	
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$file_name = "";
			
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION); 
				
				$storage_name="incentive.$ext";
				if (file_exists($storage_name))
				{ unlink($storage_name); 
				} 
				$file_size =$_FILES['file0']['size'];
				$file_tmp =$_FILES['file0']['tmp_name'];
				$file_type=$_FILES['file0']['type'];   
				$location="public/uploads/$orgid/";
				if($file_size > 2097152){
				$errors[]='File size must be less than 2 MB';
				}	
				
				if(empty($errors)==true){
				
					move_uploaded_file($file_tmp, $location.$storage_name );
					chmod($location.$storage_name, 0755);
					
				}else{
					print_r($errors);
				}
			}		
		//$actual_date = "candidate_details_".$_REQUEST['org_id'];
		//$org_id = isset($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
		//$fileName=isset ($_REQUEST['fileName'])	? $_REQUEST['fileName'] : '';
		$ext = pathinfo($file_name, PATHINFO_EXTENSION);
		if ($ext=='csv'){
		
			$fp = $location.$storage_name;
			
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				$row = 1;
				$ind=1;
				$arrData 		= array();
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
					if($row == 1)
					{
						for($i = 0 ; $i<count($data);$i++)
						{
							
							$record 	= array();				
							
							$record['head_name'] = $data[$i];
							//$record['name'] = '';
							//$record['type'] = '';
							//$record['data_label'] = '';
							$record['rows'] = $count;
							$record['column_index'] = $count;
							$record['sts'] = true;
							$count++;
							
							$arrData[] = $record;			
						}
									
						$row++;
						
					}
				}
				
				
				if ($count >= 1) {
				   $status =true;
				   
				} 
				else {
				   $status =false;
				   $errorMsg = ATTENDANCE_MODULE_CREATION_FAILED;
				}
				
				
			}
		}
		$result["data"] =$arrData;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;
				return $result;
		
	}
	
	
	public function insertFileHeaders($request)
    {
		$result = array();
		$count=0; $count1=0;  $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$emp = $request[2];
		$atdate = $request[3];
		$amount = $request[4];
		$desc = $request[5];
		
		$file_name = "incentive.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$i=0;	
			$skip=0; $nskip=0; $code=0;
			
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					//print_R( $data);
					
					if($i>0){
					
							$empid=$this->getEmployeeId($data[$emp]);
							if($empid){
								$sql = "SELECT * FROM EmployeeIncentive WHERE ApplyDate = ? AND EmployeeId =?";
								$query = $this->db->prepare($sql);
								try{
									$query->execute(array($atdate, $empid ));
									$count =  $query->rowCount();
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
								if ($count >= 1) {
								   $skip++;
								}
								else{
									// SQL Query to insert data into DataBase
									$sql = "INSERT INTO EmployeeIncentive ( EmployeeId, ApplyDate, IncentiveAmount,Description, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
									try{
										//echo $data[$amount].' ';
										//$amt = preg_replace('~[",]~',  '', $data[$amount] );
										$query = $this->db->prepare($sql);
										$query->execute(array($empid, $atdate,$data[$amount] ,$data[$desc], $orgid, $mdate, $mid, $mdate, $mid, $mid));
									
										$count =  $query->rowCount();		
									}catch(Exception $e) {
										$errorMsg .= 'Message: ' .$e->getMessage();
									}
									if ($count >= 1) {
									   $nskip++;
									} 
								}
							}else{
								$code++;
							}	
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = "Incentive not imported, please check your csv file format";
	} 
	else{
		$status =true;
		$successMsg = "$nskip Incentive imported, $skip skip, $code Employees not found";
	}		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
}
