<?php

/**
 * DocumentModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DocumentrequestModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getEmployeeDocument($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM EmployeeDocument WHERE OrganizationId = ? and EmployeeId = ? and OriginalDocSts = 1" ;
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($orgid ,$mid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$sql1 = "SELECT * FROM DocumentReleaseMaster WHERE EmployeeId = ? and FIND_IN_SET(".$row->DocumentTypeId .", RequestDocId )>0  and (ReleaseTo>CURDATE() or ReleaseTo='0000-00-00' ) AND ApproverSts in (3,2)" ;
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid));
				if($query1->rowCount()==0)
				{
					$res = array();
					$res['id'] = $row->DocumentTypeId;
					$res['document'] = $this->getName($row->DocumentTypeId, "DocumentMaster");
					$res['documentnumber'] = $row->DocumentNumber;
					$res['vsts'] = false;
					$data[] = $res;		
				
				}
				
				
				
			}
        }else{
			$status=true;
			$successMsg = DOCUMENT_REQUEST_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
		try{
			//$id=Utils::decode5t($id);
			$sql = "SELECT * FROM DocumentReleaseMaster WHERE Id = :id";
			$query = $this->db->prepare($sql);			
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['employeeid'] = (int)$row->EmployeeId;
					$res['employee'] = $this->getName($row->EmployeeId,'EmployeeMaster');
					$res['releasefrom'] = Utils::dateformatter($row->ReleaseFrom);
					$res['releasefrom1'] = $row->ReleaseFrom;
					$res['releaseto'] =  Utils::dateformatter($row->ReleaseTo);
					$res['reason'] = $row->Remarks;
					$res['approverid'] =$this->getName( $row->ApproverId,'EmployeeMaster');
					$res['appsts'] = ($row->ApproverSts==0)?3:$row->ApproverSts;
					$res['requestdocid'] = $row->RequestDocId;
					
					$sql1 = "SELECT Department, Designation FROM EmployeeMaster WHERE Id = ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->EmployeeId ));
					while($row1 = $query1->fetch())
					{
						$res['department'] = Utils::getName($row1->Department, "DepartmentMaster","Name", $this->db);
						$res['designation'] = Utils::getName($row1->Designation, "DesignationMaster","Name", $this->db);
						
					}
					$docs= ($row->RequestDocId=="")?"0":$row->RequestDocId;
					$sql1 = "SELECT * FROM DocumentMaster where Id in ( ".$docs." ) and  OrganizationId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid ));
					while($row1 = $query1->fetch())
					{
						$res1 = array();
						$res1['id'] = $row1->Id;
						$res1['name'] = $row1->Name;
						$res['docs'][] = $res1;
					}
					$data[] = $res;
				}
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
	 public function Approve($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		try{
			$docid =  $request[2];
			$sql = "UPDATE DocumentApproval SET LeaveStatus =?, ApprovalDate =?, ApproverComment=? WHERE DocumentId =? AND ApproverId=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[3], $mdate, $request[4], $docid, $mid, $orgid));
			$count =  $query->rowCount();		
			if ($count >= 1) {
				$empid=Utils::getName($docid,'DocumentReleaseMaster','EmployeeId',$this->db);
				$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Document request has been approval $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Document Request Model", $msg, $orgid));
			   $status =true;
			    if($request[3]==2){
					$successMsg = DOCUMENT_REQUEST_APPROVED;
					$sql1 = "select * from DocumentApproval WHERE DocumentId = ? and LeaveStatus<>2 and OrganizationId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $docid, $orgid));
					if($query1->rowCount()==0) {
						$sql2 = "UPDATE DocumentReleaseMaster SET ApproverSts =? , ApproveDate=?,LastModifiedDate=?,LastModifiedById=? WHERE Id =? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array(2,$mdate,$mdate,$mid, $docid));
					}
				}else{
					$successMsg = DOCUMENT_REQUEST_REJECTED;
					$sql2 = "UPDATE DocumentReleaseMaster SET ApproverSts =?,LastModifiedDate=?,LastModifiedById=? WHERE Id =? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(1,$mdate,$mid, $docid));
				}
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_UPDATION_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function Release($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$val=$request[5];
		try{
			$sql = "SELECT RequestDocId from DocumentReleaseMaster where Id=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2]));
			while($r=$query->fetch()) {
				$docid=$r->RequestDocId;
			}
			$docid = explode(",",$docid);
			if($val==1){
				$sql2 = "UPDATE DocumentReleaseMaster SET ApproverSts =? ,ApproverId=?, ReleaseFrom=? ,LastModifiedDate=?,LastModifiedById=? WHERE Id =? ";
				for($i=0; $i<count($docid); $i++) {
					$sql = "UPDATE EmployeeDocument SET ReleaseSts=? where Id=?";
					$query = $this->db->prepare($sql);
					$query->execute(array(1, $docid[$i]));
				}
			}
			else{
				$sql2 = "UPDATE DocumentReleaseMaster SET ApproverSts =? ,ApproverId=?, ReleaseTo=? ,LastModifiedDate=?,LastModifiedById=? WHERE Id =? ";
				for($i=0; $i<count($docid); $i++) {
					$sql = "UPDATE EmployeeDocument SET ReleaseSts=? where Id=?";
					$query = $this->db->prepare($sql);
					$query->execute(array(0, $docid[$i]));
				}
			}
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($request[3],$mid,Utils::getDateformat($request[4]),$mdate,$mid, $request[2]));
			$count=$query2->rowCount();
			if($count>=1){
				$empid=Utils::getName($request[2],'DocumentReleaseMaster','EmployeeId',$this->db);
				$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Document request has been release $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Document Request Model", $msg, $orgid));
				 $status =true;
				 if($val==1){
					$successMsg = "Document Released Successfully!";
				 }else{
					$successMsg = "Document Returned Successfully!";
				 }
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_UPDATION_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
    /**
     * Setter for a DocumentReleaseMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
  

	public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		$id=$request[5];
		$sql = "UPDATE DocumentReleaseMaster SET  Remarks =?,RequestDocId= ?,ApproverSts=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
		$query = $this->db->prepare($sql);
		$sts = ($request[7]==0)?3:$request[7];
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array( $request[4],$request[6],$sts,  $orgid, $mdate, $mid, $id));$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			if($request[7]==2) {
				$docid = explode(",",$request[6]);
				for($i=0; $i<count($docid); $i++) {
					$sql = "UPDATE EmployeeDocument SET ReleaseSts=? where Id=?";
					$query = $this->db->prepare($sql);
					$query->execute(array(1, $docid[$i]));
				}
			}
			$empid=Utils::getName($id,'DocumentReleaseMaster','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Document request has been updated $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Document Request", $msg, $orgid));
			$status =true;
			$successMsg = DOCUMENT_REQUEST_MODULE_UPDATION_SUCCESS;
		} else {
		   $status =false;
		   $errorMsg = DOCUMENT_REQUEST_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a DocumentReleaseMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$rdate = "";
		$sql = "INSERT INTO DocumentReleaseMaster (EmployeeId,  Remarks, RequestDocId,ApproverSts,OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,ReleaseFrom,ReleaseTo) VALUES (? ,? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$sts = ($request[7]==0)?3:$request[7];
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array($request[6], $request[4],$request[5],$sts, $orgid, $mdate, $mid, $mdate, $mid, $mid,$request[2],$request[3]));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {	
			//$empid=Utils::getName($id,'DocumentReleaseMaster','EmployeeId',$this->db);
			$empname=Utils::getName($request[6],'EmployeeMaster','FirstName',$this->db);
			$msg="Document request has been created $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Document Request", $msg, $orgid));
			$status =true;
			$successMsg = DOCUMENT_REQUEST_MODULE_CREATION_SUCCESS;
			$leaveid = $this->db->lastInsertId();
			$senior = Utils::getApprovalLevelEmp($request[6], 3, $this->db);
			if($senior!=0) {
				$temp = explode(",", $senior);
				for($i=0; $i<count($temp); $i++) {
					$sql = "INSERT INTO DocumentApproval ( DocumentId, ApproverId, LeaveStatus, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($leaveid, $temp[$i], 3, $mdate, $orgid));
					$empname=Utils::getName($request[6],'EmployeeMaster','FirstName',$this->db);
					$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
					$senioremail=Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db);
					$title="Document request";
					$msg="<table>
							<tr><td>Hello $seniorname,</td></tr>
							<tr><td>$empname has requested for document release. Kindly approve the request.</td></tr>
							<tr><td>Thanks</td></tr>
					</table>";
					Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
				}
			}
		} else {
			$status =false;
			$errorMsg = DOCUMENT_REQUEST_MODULE_CREATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		// default return
        return $result;
    }
  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "DELETE FROM DocumentReleaseMaster WHERE Id = :id ";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			$empid=Utils::getName($did,'DocumentReleaseMaster','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Document request has been deleted $empname";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Document Request", $msg, $orgid));
           $status =true;
		   $successMsg = DOCUMENT_REQUEST_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = DOCUMENT_REQUEST_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				if($table == 'EmployeeMaster')
				{
					$name = $row->FirstName.' '.$row->LastName;
				}
				else{
					$name = $row->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDocumentName($ids)
	{
		$name ="";
		$orgid = $_SESSION['ubihrm_org_id'];
		$sql = "SELECT Name FROM DocumentMaster WHERE Id in ($ids) and OrganizationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ));
			while($row = $query->fetch())
			{
				if($name == '')
				{
					$name = $row->Name;
				}
				else{
					$name .= ", ".$row->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDocument($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$docid = $row->DocumentTypeId;
				$sql1 = "SELECT * FROM DocumentMaster WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $docid ));
				if($row1= $query1->fetch())
				{
					$name=$row1->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	
	public function getTableData($editper,$viewper,$doctype)
	{
		$sTable = 'DocumentReleaseMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','ReleaseFrom'  ,'ReleaseTo','ApproveDate','RequestDocId' ,'ApproverId', 'ApproverSts', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		if($sts==1 || $hrsts==1){
			if($doctype==1){
				$sWhere = " WHERE  OrganizationId= $orgid and ApproverSts=2 and ReleaseFrom='0000-00-00'";
			}
			else{
				$sWhere = " WHERE  OrganizationId= $orgid and ApproverSts<>3 ";
			}
		}
		else{
			if($doctype==1){
				$sWhere = " WHERE  OrganizationId= $orgid and ApproverSts=2 and ReleaseFrom='0000-00-00' and EmployeeId in($ids)";
			}
			else{
				$sWhere = " WHERE  OrganizationId= $orgid and ApproverSts=2 and ReleaseFrom<>'0000-00-00' and EmployeeId in($ids)";
			}
		
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
					$id=Utils::encode5t($aRow->Id);
					$edit =""; $delete ="";
					if($aRow->ApproverSts==2){
						if($hrsts==1 && $aRow->ReleaseFrom == "0000-00-00" && $doctype==1){
							$edit = '<a rel="tooltip" title="Release" href="'.URL.'employee/editdocumentrequest/'.$id.'/'.$doctype.'" ><i class="fa fa-thumbs-o-up"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;';
						}
						if($hrsts==1 && $aRow->ReleaseFrom != "0000-00-00" && $doctype==2){
							$edit = '<a rel="tooltip" title="Return" href="'.URL.'employee/editdocumentrequest/'.$id.'/'.$doctype.'" ><i class="fa fa-thumbs-o-up"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;';
							
						}
					}
					if($hrsts==1 || $sts==1){
						
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}
					
								
					$row[] =$edit.$delete;
				}
				
				else if($aColumns[$i]=="ReleaseFrom" || $aColumns[$i]=="ReleaseTo" || $aColumns[$i]=="ApproveDate"){
					if($aRow->{$aColumns[$i]} == '0000-00-00' || $aRow->{$aColumns[$i]} == '0000-00-00 00:00:00'){
						$row[] ="";
					}else{
						$row[] =Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}	
				elseif($aColumns[$i]=="EmployeeId"){
					$id=Utils::encode5t($aRow->Id);
					$row[] ='<a rel="tooltip"  href="'.URL.'employee/viewdocumentrequest/'.$id.'/1/'.$doctype.'" > '.$this->getName($aRow->{$aColumns[$i]},'EmployeeMaster').'</a>';
				}					
				elseif($aColumns[$i]=="ApproverSts"){
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="RequestDocId"){
					$row[] = $this->getDocumentName($aRow->{$aColumns[$i]});
				}				
				elseif($aColumns[$i]=="ApproverId")
				{
					if($aRow->ApproverSts == 2){
						$name = $this->getName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$name="";
					}
					
					$row[] = $name;
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		
		$sTable = 'DocumentReleaseMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId','ReleaseFrom'  ,'ReleaseTo','ApproveDate','RequestDocId' ,'ApproverId', 'ApproverSts', 'Id');
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY ApproveDate desc";
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		//$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		
		$sWhere = " WHERE OrganizationId= $orgid AND Id IN (SELECT DocumentId FROM DocumentApproval Where ApproverId=$userid )";
			//Where ApproverId=$userid 
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		
		$sQuery = "
		 SELECT SQL_CALC_FOUND_ROWS   ".str_replace(" , ", " ", implode(", ", $aColumns))."  
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
										
					$edit =""; $delete="";
					$sts=$this->getApproverSts($aRow->Id,$userid);
					if($sts && $aRow->ApproverSts==3){	
						$id=Utils::encode5t($aRow->{$aColumns[$i]});
						$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'employee/editdocumentapproval/'.$id.'" class="text-green"><i class="fa fa-thumbs-up"></i></a>';
						
					}
					
					$row[] =$edit;
					
				}
				elseif($aColumns[$i]=="ApproverSts"){
                    
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
                 }
				 elseif($aColumns[$i]=="EmployeeId"){
                    $id=Utils::encode5t($aRow->Id);
					$row[] = '<a rel="tooltip" title="View Request" href="'.URL.'employee/viewdocumentapproval/'.$id.'/1" >'.Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'</a>';
                 }
				elseif($aColumns[$i]=="ApproveDate" || $aColumns[$i]=="ReleaseFrom" || $aColumns[$i]=="ReleaseTo"){
					if(($aRow->{$aColumns[$i]})=="0000-00-00" || ($aRow->{$aColumns[$i]})=="0000-00-00 00:00:00")
					{
						$row[]="-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				elseif($aColumns[$i]=="RequestDocId"){
					$row[] = $this->getDocumentName($aRow->{$aColumns[$i]});
				}				
				elseif($aColumns[$i]=="ApproverId")
				{
					if($aRow->ApproverSts == 2){
						$name = $this->getName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$name="";
					}
					
					$row[] = $name;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getApproverSts($id,$userid)
	{
		$flg =false;
		$employee=0;
		$sql = "SELECT * FROM DocumentApproval WHERE DocumentId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
				if($row->LeaveStatus==3){
					$employee=$row->ApproverId;
					break;
				}
			}
			if($employee ==  $userid){
					$flg = true;
				}
		}catch(Exception $e) {
			
		}
		return $flg;
	}
	
	public function getAllApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $request[1];
		$documentid = $request[2];
		
		$s1="SELECT * from DocumentApproval WHERE OrganizationId=? and DocumentId = ? and LeaveStatus<>3";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $documentid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->LeaveStatus;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data[] = $res;
			
			$successMsg=""; $status=true;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
}

