<?php

/**
 * DivisionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DivisionModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = " and Id in (select Division FROM EmployeeMaster where Id in ($ids) )";	
		if($sts==1 || $hrsts==1){
			$sWhere = " ";
		}
        $sql = "SELECT * FROM DivisionMaster WHERE OrganizationId = :id $sWhere and ArchiveSts=0 order by name";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['idst'] = $row->Id; //////////////use it when use in multiselect/bootstrap select
				$res['name'] = $row->Name;
				$res['cperson'] = $row->ContactPerson;
				$res['cnumber'] = $row->ContactNumber;
				$res['altcnumber'] = $row->AltContactNumber;
				$res['email'] = $row->Email;
				$res['address'] = $row->Address;
				$res['countryid'] = $row->CountryId;
				$res['cityid'] = $row->CityId;
				$res['zipcode'] = $row->ZipCode;
				$res['landmark'] = $row->Landmark;
				$res['currencyid'] = $row->CurrencyId;
				$res['dateformat'] = $row->DateFormatId;
				$res['timeformat'] = $row->TimeFormatId;
				$res['timezone'] = $row->TimeZoneId;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=DIVISION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM DivisionMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['code'] = $row->Code;
				$res['cperson'] = $row->ContactPerson;
				$res['cnumber'] = (int)$row->ContactNumber;
				$res['altcnumber'] = (int)$row->AltContactNumber;
				$res['email'] = $row->Email;
				$res['address'] = $row->Address;
				$res['countryid'] = $row->CountryId;
				$res['cityid'] = $row->CityId;
				$res['zipcode'] = $row->ZipCode;
				$res['landmark'] = $row->Landmark;
				$res['currencyid'] = $row->CurrencyId;
				$res['dateformat'] = $row->DateFormatId;
				$res['timeformat'] = $row->TimeFormatId;
				$res['timezone'] = $row->TimeZoneId;
				$res['shortname'] = $row->ShortName;
				$res['account'] = $row->Account;
				$res['establishment'] = $row->Establishment;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = DIVISION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=DIVISION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
    ////////////////////////////////////////////////////////////////////
    
   /* public function getColumns()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = :table_name";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':table_name' => 'DivisionMaster' ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['cperson'] = $row->ContactPerson;
				$res['cnumber'] = $row->ContactNumber;
				$res['altcnumber'] = $row->AltContactNumber;
				$res['email'] = $row->Email;
				$res['address'] = $row->Address;
				$res['countryid'] = $row->CountryId;
				$res['cityid'] = $row->CityId;
				$res['zipcode'] = $row->ZipCode;
				$res['landmark'] = $row->Landmark;
				$res['currencyid'] = $row->CurrencyId;
				$res['dateformat'] = $row->DateFormatId;
				$res['timeformat'] = $row->TimeFormatId;
				$res['timezone'] = $row->TimeZoneId;
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = DIVISION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=DIVISION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }*/
    
    
	public function SetArchive($id,$val)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
			
		$sql1 = "UPDATE DivisionMaster SET ArchiveSts=? WHERE Id = ? ";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($val,$id));
			$count =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		if ($count == 1) {
			
		   $status =true;
		   if($val==1){
			$successMsg = "Division Archived";
		   }else{
			$successMsg = "Division Active";
		   }
		} else {
		   $status =false;
		   $errorMsg=DIVISION_MODULE_UPDATION_FAILED;
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    
    /**
     * Setter for a DivisionMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $shortname = $_POST['shortname'];
		$org_id=$request[1];
		$mdate = date("Y-m-d H:i:s");
		
		
		$sql1 = "SELECT * FROM DivisionMaster WHERE Id != ? AND (Name = ? or ShortName=?) and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array(Utils::decode5t($request[16]), $request[2], $shortname,$org_id));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=DIVISION_MODULE_UPDATION_DUPLICATE;
		}else{
			
			$sql = "UPDATE DivisionMaster SET OrganizationId=?, Name=?, ContactPerson=?, ContactNumber=?, AltContactNumber=?, Email=?, Address=?, CountryId=?, CityId=?, ZipCode=?, Landmark=?, CurrencyId=?, DateFormatId=?, TimeFormatId=?, TimeZoneId=?,  LastModifiedDate=?, LastModifiedById=?, Code=?, ShortName=?, Account=?, Establishment=? where Id=?";
		
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array($request[1], $request[2], $request[3], $request[4], $request[5], $request[6], $request[7], $request[8], $request[9], $request[10], $request[11], $request[12], $request[13], $request[14], $request[15], $mdate, $mid, $request[17], $shortname, $request[18], $request[19], Utils::decode5t($request[16])));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = DIVISION_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=DIVISION_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a DivisionMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
	 
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $shortname = $_POST['shortname'];
		$mdate = date("Y-m-d H:i:s");
		$org_id=$request[1];
		$sql1 = "SELECT * FROM DivisionMaster WHERE (Name = ? or Code= ? or ShortName=?) and OrganizationId=?";
		//Utils::Trace($sql1);
		//Utils::Trace($request[2]." ".$request[16]." ".$shortname." ".$org_id);
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( $request[2], $request[16], $shortname,$org_id));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status =false;
			 $errorMsg=DIVISION_MODULE_CREATION_DUPLICATE;
		}else{
			 
			$sql = "INSERT INTO DivisionMaster (OrganizationId, Name, ContactPerson, ContactNumber, AltContactNumber, Email, Address, CountryId, CityId, ZipCode, Landmark, CurrencyId, DateFormatId, TimeFormatId, TimeZoneId, LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, Code, ShortName, Account, Establishment) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[1], $request[2], $request[3], $request[4], $request[5], $request[6], $request[7], $request[8], $request[9], $request[10], $request[11], $request[12], $request[13], $request[14], $request[15], $mdate, $mid, $mdate, $mid, $mid, $request[16], $shortname, $request[17], $request[18]));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = DIVISION_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=DIVISION_MODULE_CREATION_FAILED;
			}
		
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM EmployeeMaster WHERE Division = :id";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=DIVISION_MODULE_DELETE_EXIST;
		}else{
			
			$sql = "DELETE FROM DivisionMaster WHERE Id = :id ";		
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = DIVISION_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=DIVISION_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable( $editper, $deleteper)
	{
		$sTable = 'DivisionMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Code', 'Name', 'ContactNumber', 'ContactPerson', 'Email' ,'AltContactNumber' ,'Address' ,'CountryId','CityId','ZipCode','Landmark','CurrencyId','ArchiveSts','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$mid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = "WHERE OrganizationId= $orgid and Id in (select Division FROM EmployeeMaster where Id in ($ids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$id=Utils::encode5t($aRow->{$aColumns[$i]});
					$edit =""; $view =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editdivision/'.$id.'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($editper){
						if($aRow->ArchiveSts ==0){
							$view = '<a rel="tooltip" title="Set Archive" onclick="angular.element(this).scope().getarchiveId(\''.$aRow->Id.'\',1)" data-toggle="modal" data-target="#aconfirm" href="#"><i class="fa fa-font"></i></a>';
						}else{
							$view = '<a rel="tooltip" title="Set Active" onclick="angular.element(this).scope().getarchiveId(\''.$aRow->Id.'\',0)" data-toggle="modal" data-target="#aconfirm" href="#"><span class="fa-stack"><i class="fa fa-font fa-stack-1x"></i><i class="fa fa-ban fa-stack-2x text-danger"></i></span></a>';
						}
					}else{
						$view = '<a href="#" rel="tooltip" title="No permission to archive"><i class="fa fa-font"></i></a>';
					}
					
					if($deleteper){
						$delete ='<a rel="tooltip" title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#"><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$view."&nbsp;&nbsp;|&nbsp;&nbsp;".$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}else if($aColumns[$i]=="ParentId")
				{
					$row[] = self::getName($aRow->{$aColumns[$i]},'DivisionMaster');
					
				}
				else if($aColumns[$i]=="CountryId")
				{
					$row[] = self::getName($aRow->{$aColumns[$i]},'CountryMaster');
					
				}
				else if($aColumns[$i]=="CityId")
				{
					$row[] = self::getName($aRow->{$aColumns[$i]},'CityMaster');
					
				}
				
				else if($aColumns[$i]=="CurrencyId")
				{
					$row[] = self::getName($aRow->{$aColumns[$i]},'CurrencyMaster');
					
				}
				else if($aColumns[$i]=="ArchiveSts")
				{
					if($aRow->{$aColumns[$i]}==1){
						$row[] = "<span class='label label-danger'>Archived</span>";
					}else{
						$row[] = "<span class='label label-success'>Active</span>";
					}
				}else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'setup/viewdivision/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
				}else
				{
					$row[] = $aRow->{$aColumns[$i]};
					
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
