<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DesiredlevelModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAllDesiredlevels($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM DesiredLevel WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = COMPETENCY_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getCompetency($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM CompetencyMaster WHERE OrganizationId = :id and TypeId=:typeid";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$competencytypeid = $request[2];
			$query->execute(array(':id' => $orgid,':typeid' => $competencytypeid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = COMPETENCY_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDesiredLevel()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id'];
        $sql = "SELECT * FROM DesiredLevel WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['level'] = $row->Name;
				$res['desc'] = $row->Behaviour;
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = COMPETENCY_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = COMPETENCY_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a CompetencyMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function updateDesiredLevel($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		/* 		
		$sql1 = "SELECT * FROM CompetencyMaster WHERE Id != ? and Name = ? and TypeId=? and OrganizationId =? ";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[4], $request[2], $request[3], $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=COMPETENCY_MODULE_UPDATION_DUPLICATE;
		}else{ */
		
			/* $sql = "UPDATE CompetencyMaster SET Name=?, TypeId=?,LastModifiedById=?, LastModifiedDate=? where Id=?";
			$query = $this->db->prepare($sql); */
			try{
				/* $query->execute(array($request[2],$request[3],$mid,$mdate, $request[4]));
				// INSERTING COMPETENCY LEVEL RECORD OF COMPETENCY IF PASSED AS AN JSON
				 */
				$work = json_decode($_POST['competencylevel'], true); 
				$workid="0";
				for($i=0; $i<count($work); $i++){
					$workid .= ",".$work[$i]['id'];
				}
				$sqlwork = " DELETE FROM DesiredLevel WHERE OrganizationId=? AND Id NOT IN ($workid)";
				$querywork = $this->db->prepare($sqlwork);
				$querywork->execute(array( $orgid));
				$count +=  $querywork->rowCount();
				for($i=0; $i<count($work); $i++)
				{
					if($work[$i]['level']!="" || $work[$i]['desc']!=""){
					
						$record = array();
						$record[0] =$work[$i]['level'];
						$record[1] = $work[$i]['desc'];
						$record[2] = $i+1;
						$record[3] = $orgid;
						$record[4] = $mid;
						$record[5] = $mdate;
						$record[6] = $mid;
						$record[7] = $mdate;
						$id = $work[$i]['id'];
						
						if($id){
							$sqlwork = " UPDATE DesiredLevel SET  Name=?, Behaviour=?,Level=?,LastModifiedDate=?, LastModifiedById=? where Id=?";
							$querywork = $this->db->prepare($sqlwork);
							$querywork->execute(array($work[$i]['level'],$work[$i]['desc'],($i+1),$mdate,$mid,  $id));
							$count +=  $querywork->rowCount();
						}else{
							$sqlwork = " INSERT INTO DesiredLevel ( Name, Behaviour, Level,OrganizationId,CreatedById, CreatedDate, LastModifiedById, LastModifiedDate) values (?,?,?,?,?,?,?,?)";
							$querywork = $this->db->prepare($sqlwork);
							$querywork->execute($record);
							$count +=  $querywork->rowCount();
						
						}
								
					}
				}				
				//$count +=  $query->rowCount();
				
			if ($count >= 1 ) {
			   $status =true;
			   $successMsg = COMPETENCY_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = COMPETENCY_MODULE_UPDATION_FAILED;
			}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a CompetencyMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$sql1 = "SELECT * FROM CompetencyMaster WHERE Name = ? and TypeId=? and OrganizationId = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[2], $request[3], $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=COMPETENCY_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "INSERT INTO CompetencyMaster (  Name, TypeId, OrganizationId, CreatedById, CreatedDate, LastModifiedById, LastModifiedDate, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3],  $orgid, $mid, $mdate, $mid, $mdate, $mid));
				$cid=$this->db->lastInsertId();
				// INSERTING COMPETENCY LEVEL RECORD OF COMPETENCY IF PASSED AS AN JSON
				$work = json_decode($_POST['competencylevel'], true); 
				for($i=0; $i<count($work); $i++)
				{
					if($work[$i]['level']!="" || $work[$i]['desc']!=""){
					
						$record = array();
						$record[0] =$cid;
						$record[1] = $work[$i]['level'];
						$record[2] = $work[$i]['desc'];
						$record[3] = $i+1;
						$sqlwork = " INSERT INTO CompetencyChild ( CompetencyId, CompLevel, BehaviouralIndicator,Level) values (?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
				
			
				$count =  $query->rowCount();	
				$count1 =  $querywork->rowCount();
			if ($count == 1 || $count1 >= 1) {				
			   $status =true;
			   $successMsg = COMPETENCY_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = COMPETENCY_MODULE_CREATION_FAILED;
			}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $count2=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT Id FROM CompetencyChild WHERE CompetencyId = :id";
        	$query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$sql2 = "SELECT Id FROM CompetencyAnalysisChild WHERE Competency = :id";
        	$query2 = $this->db->prepare($sql2);
		try{
			$query2->execute(array( ':id' => $did));
			$count2 =  $query2->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if($count1>=1 || $count2>=1)
		{
			 $status =false;
			 $errorMsg=COMPETENCY_MODULE_DELETE_EXIST;
		}else{
		
			$sql = "DELETE FROM CompetencyMaster WHERE Id = :id ";
		
			try{
			
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
		
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
			if ($count == 1) {
			   $status =true;
				   $successMsg = COMPETENCY_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
				   $errorMsg = COMPETENCY_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM CompetencyMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'CompetencyMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'TypeId', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}if($aColumns[$i]=="TypeId"){
					$sWhere .= "(TypeId in (select id from CompetencyType where Name"." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performance/editcompetency/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'performance/viewcompetency/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				else if($aColumns[$i]=="TypeId")
				{
					
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'CompetencyType','Name',$this->db);
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
