<?php

/**
 * DesignationModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DesignationModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$desig=Utils::getName($mid,'EmployeeMaster','Designation',$this->db);
		$ids=Utils::getReportingIds($mid,$this->db);
		$desigids=Utils::getJuniorDesigs($desig,$this->db);
		$sWhere = " and (Id in (select Designation FROM EmployeeMaster where Id in ($ids)) or Id in ($desigids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = " ";
		}
        $sql = "SELECT * FROM DesignationMaster WHERE OrganizationId = :id $sWhere order by name ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->Name;
				//$res['code'] = $row->Code;
				$res['parent'] = $row->RoleId;
				//$res['grade'] = $row->GradeId;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = DESIGNATION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	
	public function getalldesigforparentdesig($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;$desigid=0;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$desigid=Utils::decode5t($request[2]);
	
		$desig=Utils::getName($mid,'EmployeeMaster','Designation',$this->db);
		$ids=Utils::getReportingIds($mid,$this->db);
		$desigids=Utils::getJuniorDesigs($desig,$this->db);
		$sWhere = " and (Id in (select Designation FROM EmployeeMaster where Id in ($ids)) or Id in ($desigids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = " ";
		}
		if($desigid!=0){
			$sql = "SELECT * FROM DesignationMaster WHERE OrganizationId = :id and Id!=$desigid $sWhere order by name ";
			$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array(':id' => $orgid ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = (int)$row->Id;
					$res['ids'] = $row->Id;
					$res['name'] = $row->Name;
					//$res['code'] = $row->Code;
					$res['parent'] = $row->RoleId;
					//$res['grade'] = $row->GradeId;
					$data[] = $res;
				}
			}else{
				$status=false;
				$errorMsg = "No record Found ";
			}
		}else{
			$status=false;
			$errorMsg = "No record Found ";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
	/* for functional competencies
	to fetch the designations whose competencies are not configured*/
    public function getCompetencyDesignation($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$desig=Utils::getName($mid,'EmployeeMaster','Designation',$this->db);
		$ids=Utils::getReportingIds($mid,$this->db);
		$desigids=Utils::getJuniorDesigs($desig,$this->db);
		$sWhere = " and (Id in (select Designation FROM EmployeeMaster where Id in ($ids)) or Id in ($desigids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = " ";
		}
        $sql = "SELECT * FROM DesignationMaster WHERE OrganizationId = :id $sWhere and Id not in (Select DesignationId from AssessmentObjective where OrganizationId = $orgid) order by name ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->Name;
				//$res['code'] = $row->Code;
				$res['parent'] = $row->RoleId;
				//$res['grade'] = $row->GradeId;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = DESIGNATION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	/* for behavioural competencies
	to fetch the designations whose skill gap are not configured*/
    public function getSkillGapDesignation($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$desig=Utils::getName($mid,'EmployeeMaster','Designation',$this->db);
		$ids=Utils::getReportingIds($mid,$this->db);
		$desigids=Utils::getJuniorDesigs($desig,$this->db);
		$sWhere = " and (Id in (select Designation FROM EmployeeMaster where Id in ($ids)) or Id in ($desigids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = " ";
		}
        $sql = "SELECT * FROM DesignationMaster WHERE OrganizationId = :id $sWhere and Id not in (Select DesignationId from SkillGapObjective where OrganizationId = $orgid) order by name ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->Name;
				//$res['code'] = $row->Code;
				$res['parent'] = $row->RoleId;
				//$res['grade'] = $row->GradeId;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = DESIGNATION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	public function getDesignationHeirarchy($request)
    {
		$result = array();
		$count=1; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        	$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$status=true;
			$successMsg=$count." record found";
			$res = array();
			$res['id'] = 1;
			$res['name'] = Utils::getName($orgid, 'Organization', 'Name', $this->db);
			$res['parent'] = 0;
			$data[] = $res;
			$parent=0;$index=0;
			while($count>0)
			{
				$index++;
				$sql = "SELECT * FROM DesignationMaster WHERE OrganizationId = :id and RoleId in ($parent)";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $orgid ));
				$count =  $query->rowCount().",";
				$parent="";
				while($row = $query->fetch())
				{
					if($parent=="")
						$parent = $row->Id;
					else
						$parent .= ",".$row->Id;
					
					$res = array();
					$res['id'] = (int)$row->Id;
					$res['name'] = $row->Name;
					$res['parent'] = (int)($row->RoleId==0)?1:$row->RoleId;
					$data[] = $res;
				}
			}
        
			$status=true;
			$successMsg = DESIGNATION_MODULE_GETALL;
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM DesignationMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$r = array();
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['code'] = $row->Code;
				$res['desc'] = $row->Description;
				$res['hrsts'] = $row->HRSts;
				$parent=$res['parent'] = (int)$row->RoleId;
				//$res['grade'] = $row->GradeId;
				
				//$ids = $this->getParentIds($parent );
				//$ids = $ids.",". $parent;
				/*$sql1 = "SELECT Id, Name,RoleId FROM DesignationMaster WHERE  Id in ( $ids ) ";
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute();
				while($row = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row->Id;
					$res1['name'] = $row->Name;
					$res1['parent'] = $row->RoleId;
					$r[]=$res1;
				}*/	
				
				$res['rolearr']=$r;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = DESIGNATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = DESIGNATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a DesignationMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sql1 = "SELECT * FROM DesignationMaster WHERE Id != ? and Code = ? and OrganizationId = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( Utils::decode5t($request[3]), $request[4], $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{			
			$status =false;
			$errorMsg = DESIGNATION_MODULE_CREATION_DUPLICATE;
	
		}else{
		
			$sql = "UPDATE DesignationMaster SET Name=:name, Code=:code, RoleId=:roleid,  OrganizationId=:orgid, LastModifiedDate=:mdate, LastModifiedById=:mid, Description=:desc, HRSts=:hrsts where Id=:id";
		
			$query = $this->db->prepare($sql);
			
			try{
				
				
				$query->execute(array(':name' => $request[2], ':code' => $request[4], ':roleid'=>$request[5], ':orgid' => $orgid, ':mdate' => $mdate, ':mid' => $mid, ':desc' => $request[7] , ':hrsts' => $request[8],  ':id' => Utils::decode5t($request[3]) ));
				if($request[8] == 1)
				{
					$sql1 = "UPDATE DesignationMaster SET HRSts = ? WHERE OrganizationId =? AND Id <> ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( 0,$request[1] ,Utils::decode5t($request[3])));
				
				}
				
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = DESIGNATION_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = DESIGNATION_MODULE_UPDATION_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a DesignationMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sql1 = "SELECT * FROM DesignationMaster WHERE Code = :name AND OrganizationId = :orgid";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':name' => $request[3], ':orgid' => $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{			
			$status =false;
			$errorMsg = DESIGNATION_MODULE_CREATION_DUPLICATE;
	
		}
		else
		{		
			
			
			try{
				
				$sql="select Name from DesignationMaster where Name=? and OrganizationId=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$orgid));
				$count =  $query->rowCount();
				if ($count >0)
				{		
					$result["data"] =$data;
					$result['status']=false;
					$result['successMsg']=$successMsg;
					$result['errorMsg']="This Designation is already exist";
					 return $result;
				}
				$sql = "INSERT INTO DesignationMaster (Name, Code,RoleId,   OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, Description ,HRSts) VALUES (:name, :code, :roleid, :orgid, :mdate, :mid, :cdate, :cid, :ownerid, :desc, :hrsts)";
				$query = $this->db->prepare($sql);
				$query->execute(array(':name' => $request[2], ':code' => $request[3],':roleid'=>$request[4],':orgid' => $orgid, ':mdate' => $mdate, ':mid' => $mid, ':cdate' => $mdate, ':cid' => $mid, ':ownerid' => $mid, ':desc' => $request[6] , ':hrsts' => $request[7] ));
				$id=$this->db->lastInsertid();
				if($request[7] == 1)
				{
					$sql1 = "UPDATE DesignationMaster SET HRSts = ? WHERE OrganizationId =? AND Id <> ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( 0,$orgid ,$id));
				
				}
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count==1)
			{
				$rsql1 = "SELECT * FROM ModuleMaster where TabId>0";
				$rquery1 = $this->db->prepare($rsql1);
				$rquery1->execute();
				$count =  $rquery1->rowCount();
				if($count>=1)
				{
					while($row = $rquery1->fetch())
					{
						$sql2 = "INSERT INTO UserPermission (RoleId, ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
			
						try{
								
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array($id, $row->Id, 0, 0, 0, 0 , $orgid, $mdate, $mid, $mdate, $mid, $mid ));
			
							$count =  $query2->rowCount();		
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					}
				}
				
			}
		}
			if ($count == 1) {
			   $status =true;
			   $successMsg = DESIGNATION_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = DESIGNATION_MODULE_CREATION_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT Id FROM EmployeeMaster WHERE Designation = :id";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=DESIGNATION_MODULE_DELETE_EXIST;
		}else{		
			$sql = "DELETE FROM DesignationMaster WHERE Id = :id";
			try{				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));			
				$count =  $query->rowCount();	
				if($count)
				{
					$sql2 = "Update DesignationMaster set RoleId=0 WHERE RoleId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $did));
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = DESIGNATION_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg = DESIGNATION_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'DesignationMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name','RoleId', 'Code',  'Id');
		$orgid = $_SESSION['ubihrm_org_id'];
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$mid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = "WHERE OrganizationId= $orgid and Id in (select Designation FROM EmployeeMaster where Id in ($ids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editdesignation/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}else if($aColumns[$i]=="RoleId"){
					$row[] = $this->getName($aRow->{$aColumns[$i]},"DesignationMaster");
				}
				
				else if($aColumns[$i]=="HRSts")
				{
					if($aRow->{$aColumns[$i]}==1){
						$row[]=	"<span class='badge bg-red'>YES</span>";
					}
					else{
						$sts=$_SESSION['ubihrm_hr_sts'];
						if($sts==1){
							$row[]=	'<a rel="tooltip"  title="Change to HR" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirmhr" href="#" ><span class="badge bg-aqua">NO</span></a>';
						}
						else{
							$row[]=	"<span class='badge bg-aqua'>NO</span>";
						}
					
					
					}
				}else
				{
					if($i==0)
					{
					$row[] = '<a href="'.URL.'setup/viewdesignation/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					}
					else
					{
					$row[] = $aRow->{$aColumns[$i]};
					}
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getParentIds($id)
	{
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = "0";
		
		$parentid=$id;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT RoleId FROM DesignationMaster WHERE OrganizationId = ? and Id in ( $parentid )";
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{	
				
					if($parentid==""){
						$parentid = $row1->RoleId;
					}else{
						$parentid .= ", ".$row1->RoleId;
					}
					if($ids==""){
						$ids = $row1->RoleId;
					}else{
						$ids .= ",".$row1->RoleId;
					}
					
					
					
				}
				
			}
		}
			return $ids;
	}
	
	public function AddDesigStatus($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$sql = "UPDATE DesignationMaster SET HRSts = ? WHERE  Id = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array( 1,$request[1] ));
		if($query->rowCount()>0)
		{
			$sql1 = "UPDATE DesignationMaster SET HRSts = ? WHERE OrganizationId =? AND Id <> ?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( 0,$request[0] ,$request[1]));
			$status=true;
			$successMsg = DESIGNATION_MODULE_STATUSCHANGE;
		}else{
			$status=false;
			$errorMsg = DESIGNATION_MODULE_UPDATION_FAILED;
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
}
