<?php

/**
 * DepartmentModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DepartmentModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = " and Id in (select Department FROM EmployeeMaster where Id in ($ids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = " ";
		}
        $sql = "SELECT * FROM DepartmentMaster WHERE OrganizationId = :id $sWhere order by name";
        $query = $this->db->prepare($sql);
		try{
			
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['idst'] = $row->Id; //////////////use it when use in multiselect/bootstrap select
				$res['name'] = $row->Name;
				$res['code'] = $row->Code;
				$res['parent'] = $row->ParentId;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=DEPARTMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getAll1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$ids=isset($_REQUEST['items'])?$_REQUEST['items']:"";
		$locids=isset($_REQUEST['locids'])?$_REQUEST['locids']:"";
		
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids = join(",",$ids); 


		if(isset($_REQUEST['locids']) and $locids != "" and $locids != 0){
			$locids = join(",",$locids); 
			
			 $sql="SELECT * FROM EmployeeMaster WHERE `Department` IN ($ids) and `Division` IN ($locids) and OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) and Is_Delete=0 order by FirstName";
		
		}else{
            $sql="SELECT * FROM EmployeeMaster WHERE `Department` IN ($ids) and OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) and Is_Delete=0 order by FirstName";
		}
		$query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if($count>=1)
		{
			//$successMsg=$count." record found";
			while($row = $query->fetch())
			{
					$status=true;
		
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['idst'] = $row->Id;
			    $res['EmployeeCode'] = $row->EmployeeCode; //////////////use it when use in multiselect/bootstrap select
				
				$res['FirstName'] = $row->FirstName;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$data[] = $res;
				
			}
		$result["data"]=$data;
		$result['status']=$status;
	    $result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		 

		}
		
	   return $result;
	   $sql = "";
	}

	 public function getDepartmentbyDivision($divid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		
        $sql = "SELECT * FROM DepartmentMaster WHERE  Id in (select Department FROM EmployeeMaster where Division=$divid) order by name";
        $query = $this->db->prepare($sql);
		try{
			
			
			$query->execute( );
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['idst'] = $row->Id; //////////////use it when use in multiselect/bootstrap select
				$res['name'] = $row->Name;
				$res['parent'] = $row->ParentId;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=DEPARTMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM DepartmentMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['code'] = $row->Code;
				$res['parentid'] = $row->ParentId;
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = DEPARTMENT_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=DEPARTMENT_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a DepartmentMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		$sql1 = "SELECT * FROM DepartmentMaster WHERE Id != ? AND Code = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array(Utils::decode5t($request[4]), $request[5],$request[1]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=DEPARTMENT_MODULE_UPDATION_DUPLICATE;
		}else{
			
			$sql = "UPDATE DepartmentMaster SET Name=:name, Code=:code, ParentId=:parentid, OrganizationId=:orgid, LastModifiedDate=:mdate, LastModifiedById=:mid where Id=:id";
		
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array(':name' => $request[2], ':code'=>$request[5], ':parentid' => $request[3], ':orgid' => $orgid, ':mdate' => $mdate, ':mid' => $mid, ':id' => Utils::decode5t($request[4]) ));
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = DEPARTMENT_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=DEPARTMENT_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a DepartmentMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sql1 = "SELECT * FROM DepartmentMaster WHERE Code = :code and Name=:name and OrganizationId=:org";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':code' => $request[2],':name' => $request[4],  ':org' => $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status =false;
			 $errorMsg=DEPARTMENT_MODULE_CREATION_DUPLICATE;
		}else{
			 
			
			try{
				
				$sql = "INSERT INTO DepartmentMaster (Name, ParentId, Code, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (:name, :parentid, :code,  :orgid, :mdate, :mid, :cdate, :cid, :ownerid)";
			
				$query = $this->db->prepare($sql);
				$query->execute(array(':name' => $request[2], ':code'=>$request[4], ':parentid' => $request[3], ':orgid' => $orgid, ':mdate' => $mdate, ':mid' => $mid, ':cdate' => $mdate, ':cid' => $mid, ':ownerid' => $mid ));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = DEPARTMENT_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=DEPARTMENT_MODULE_CREATION_FAILED;
			}
		
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT Id FROM EmployeeMaster WHERE Department = :id";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=DEPARTMENT_MODULE_DELETE_EXIST;
		}else{
			
			$sql = "DELETE FROM DepartmentMaster WHERE Id = :id ";		
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = DEPARTMENT_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=DEPARTMENT_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM DepartmentMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'DepartmentMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Code', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$mid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = "WHERE OrganizationId= $orgid and Id in (select Department FROM EmployeeMaster where Id in ($ids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editdepartment/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}else if($aColumns[$i]=="ParentId")
				{
					$row[] = self::getName($aRow->{$aColumns[$i]});
					
				}else
				{
					if($i==0)
					{
					$row[] = '<a href="'.URL.'setup/viewdepartment/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					}
					else
					{
					$row[] = $aRow->{$aColumns[$i]};
					}
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getEmployee($deptid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
        $sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and Department=:dp and (DOL='0000-00-00' or DOL>curdate()) order by FirstName";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $orgid ,':dp' => $deptid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empcode'] = $row->EmployeeCode;
				$res['empfname'] = $row->FirstName;
				$res['emplname'] = $row->LastName;
				$res['empdob'] = $row->DOB;
				$res['empnation'] = $row->Nationality;
				$res['empgender'] = $row->Gender;
				$res['empcdate'] = $row->CreatedDate;
				$res['empmdate'] = $row->LastModifiedDate;
				$res['image'] = $row->ImageName;
				$res['sts']=0;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
}
