<?php

/**
 * DashboardModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class DashboardModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getSetupDashboard1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();

		$res = array();
		$res['value'] = $this->getTotalCount($request[1], 'DivisionMaster');
		$res['label'] = "Divisions";				
		$data[] = $res;				
		$res = array();
		$res['value'] = $this->getTotalCount($request[1], 'DepartmentMaster');
		$res['label'] = "Departments";				
		$data[] = $res;				
		$res = array();
		$res['value'] = $this->getTotalCount($request[1], 'DesignationMaster');
		$res['label'] = "Designations";				
		$data[] = $res;

		$res = array();
				$res['value'] = $this->getTotalCount($request[1], 'GradeMaster');
				$res['label'] = "Grades";				
				$data[] = $res;

				$res = array();
				$res['value'] = $this->getTotalCount($request[1], 'ShiftMaster');
				$res['label'] = "Shifts";				
				$data[] = $res;

				$sql = "SELECT DOJ FROM EmployeeMaster WHERE OrganizationId = ? and DOL = '0000-00-00' and Is_Delete=0";
				$query = $this->db->prepare($sql);
				$query->execute(array( $request[1] ));
				$totalemp =  $query->rowCount();

				$res = array();
				$res['value'] = $totalemp;
				$res['label'] = "Total No. of Employees";				
				$data[] = $res;

				/*$res = array();
				$res['value'] = $this->getTotalCount($request[1], 'UserMaster');
				$res['label'] = "Users";
				$data[] = $res;*/

				$status=true;
				$successMsg = VISA_MODULE_GETALL;

				$result["data"] =$data;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function getSetupDashboard2($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$divid = $request[2];
        $sql = "SELECT * FROM DivisionMaster WHERE Id = ? and ArchiveSts=0";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $divid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['contname'] = $row->ContactPerson;
				$res['contnum'] = $row->ContactNumber;
				$res['email'] = $row->Email;
				$res['address'] = $row->Address;
				$res['currency'] = $this->getName($row->CurrencyId,'CurrencyMaster');
				$res['country'] = $this->getName($row->CountryId,'CountryMaster');
				$res['city'] = $this->getName($row->CityId,'CityMaster');

				$data[] = $res;
			}
        }

		if ($count == 1) {
           $status =true;
		   $successMsg = VISA_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = VISA_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function getSetupDashboard3($request)
    {

		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();

		$data['empindivision'] = array();
		$data['empindepartment'] = array();
		$data['empindesignation'] = array();
		$data['empingrade'] = array();
		$data['empinshift'] = array();
		$data['empinnationality'] = array();
		$data['empinage'] = array();
		$data['empingender'] = array();

		$userid = $request[0];
		$orgid = $request[1];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$emptable = "";
		$nonemptable = "";
		$notification="";

		$emptable = " and  DOL='0000-00-00' ";

		$sql = "SELECT DOJ FROM EmployeeMaster WHERE OrganizationId = ? and Is_Delete=0 $emptable ";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		$totalemp =  $query->rowCount();

		///////////////// GETTING LIST OF EMPLOYEES IN DIVISIONS ///////////////

		 $sql = "SELECT count(*) as totalcount, Division FROM EmployeeMaster WHERE OrganizationId=? and Is_Delete=0  $emptable  GROUP BY Division";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$type = Utils::getName($row->Division, 'DivisionMaster', 'ShortName', $this->db);
				$res['type'] = ($type =="")?"Not Assign":$type;
				//$res['count'] = round(($row->totalcount*100)/$totalemp, 1);	
				$res['count'] = $row->totalcount;	
				$data['empindivision'][] = $res;
			}
        }

		///////////////// GETTING LIST OF EMPLOYEES IN DEPARTMENT ///////////////

		 $sql = "SELECT count(*) as totalcount, Department FROM EmployeeMaster WHERE OrganizationId=? and Is_Delete=0 $emptable  GROUP BY Department";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$type = $this->getName($row->Department, 'DepartmentMaster');
				$res['type'] = ($type =="")?"Not Assign":$type;
				//$res['count'] = round(($row->totalcount*100)/$totalemp, 1);	
				$res['count'] = $row->totalcount;	
				$data['empindepartment'][] = $res;
			}
        }

		///////////////// GETTING LIST OF EMPLOYEES IN DESIGNATION ///////////////

		 $sql = "SELECT count(*) as totalcount, Designation FROM EmployeeMaster WHERE OrganizationId=? and Is_Delete=0 $emptable GROUP BY Designation";

		 //Utils::Trace($sql);
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				if($count>=20)//NO. OF DESIGNATION
				{
				if($row->totalcount>2){//NO. OF EMPLOYEE
				$res = array();
				$type = $this->getName($row->Designation, 'DesignationMaster');
				$res['type'] = ($type =="")?"Not Assign":$type;
				//$res['count'] = round(($row->totalcount*100)/$totalemp, 1);	
				$res['count'] = $row->totalcount;	
				$data['empindesignation'][] = $res;
				}
				}else{
					$res = array();
				$type = $this->getName($row->Designation, 'DesignationMaster');
				$res['type'] = ($type =="")?"Not Assign":$type;
				//$res['count'] = round(($row->totalcount*100)/$totalemp, 1);	
				$res['count'] = $row->totalcount;	
				$data['empindesignation'][] = $res;
					}
			}
        }

		///////////////// GETTING LIST OF EMPLOYEES IN GRADE ///////////////

		 //$sql = "SELECT count(*) as totalcount, Grade FROM EmployeeMaster WHERE OrganizationId=? $emptable GROUP BY Grade";
		 $sql = "SELECT count(*) as totalcount, Grade FROM EmployeeMaster e,GradeMaster g WHERE g.id=e.grade and e.OrganizationId=? and g.OrganizationId=? and e.DOL='0000-00-00'  group by Grade";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid,$orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$type = $this->getName($row->Grade, 'GradeMaster');
				$res['type'] = ($type =="")?"Not Assign":$type;
				//$res['count'] = round(($row->totalcount*100)/$totalemp, 1);	
				$res['count'] = $row->totalcount;					
				$data['empingrade'][] = $res;
			}
        }

		///////////////// GETTING LIST OF EMPLOYEES IN SHIFT ///////////////

		 $sql = "SELECT count(*) as totalcount, Shift FROM EmployeeMaster WHERE OrganizationId=? $emptable GROUP BY Shift";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$type = $this->getName($row->Shift, 'ShiftMaster');
				$res['type'] = ($type =="")?"Not Assign":$type;
				//$res['count'] = round(($row->totalcount*100)/$totalemp, 1);		
				$res['count'] = $row->totalcount;		
				$data['empinshift'][] = $res;
			}
        }

		///////////////// GETTING LIST OF EMPLOYEES IN NATIONALITY ///////////////

		 $sql = "SELECT count(*) as totalcount, Nationality FROM EmployeeMaster WHERE OrganizationId=? $emptable GROUP BY Nationality";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$type = $this->getName($row->Nationality, 'NationalityMaster');
				$res['type'] = ($type =="")?"Not Assign":$type;
				$res['count'] = round(($row->totalcount*100)/$totalemp, 1);	
				$data['empinnationality'][] = $res;
			}
        }

		///////////////// GETTING LIST OF EMPLOYEES IN GENDER ///////////////

		 $sql = "SELECT count(*) as totalcount, Gender FROM EmployeeMaster WHERE OrganizationId=? $emptable GROUP BY Gender";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$res['type'] = Utils::getOtherName($row->Gender, 'Gender', $this->db);
				$res['count'] = round(($row->totalcount*100)/$totalemp, 1);		
				$data['empingender'][] = $res;
			}
        }

		///////////////// GETTING LIST OF EMPLOYEES IN AGE GROUP ///////////////

		 $sql = "SELECT TIMESTAMPDIFF(YEAR, DOB, CURDATE()) AS age FROM EmployeeMaster WHERE OrganizationId=? and Is_Delete=0 $emptable ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$keyarr= array("0","0","0","0","0");
			$label= array('18 to 25 Yr', '26 to 35 Yr', '36 to 45 Yr', '46 to 55 Yr', '56 to 65 Yr');
			while($row = $query->fetch())
			{

				if($row->age>=18 && $row->age<=25){
					$keyarr[0] = $keyarr[0]+1;
				}elseif($row->age>=26 && $row->age<=35){
					$keyarr[1] = $keyarr[1]+1;
				}elseif($row->age>=36 && $row->age<=45){
					$keyarr[2] = $keyarr[2]+1;
				}elseif($row->age>=46 && $row->age<=55){
					$keyarr[3] = $keyarr[3]+1;
				}elseif($row->age>=56 && $row->age<=65){
					$keyarr[4] = $keyarr[4]+1;
				}

			}
			for($i=0; $i<count($label); $i++)
			{
				$res = array();
				//$res["value"] = $keyarr[$i];
				$res['value'] = round(($keyarr[$i]*100)/$totalemp, 1);	
				$res['name'] =$label[$i];
				$data['empinage'][] = $res;
			}
        }

		$status=true;

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	/*
	*	EMPLOYEE TAB DASHBOARD
	*	FETCH DATA FOR UPCOMING BIRTHDAY DASHBOARD
	*/
	public function getEmployeeDashboard1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{

		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$emptable = "";
		$nonemptable = "";
		$notification="";
		if($sts==1 || $hrsts==1){
			$emptable = " and  DOL='0000-00-00' ";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
			$nonemptable = " and EmployeeId in ($ids)";
			$notification = " and CreatedById in ($ids)";
		}

		$data['newjoinings'] = array();
		$data['employeebyage'] = array();
		$data['employeebyqualify'] = array();
		$data['totaltransfer']= array(); 
		$data['totalpromotion']= array(); 
		$data['employeebyskills']= array();
		$data['overallturnover']= array();
		$data['turnoverbyreason']= array();
		$data['turnoverbydivision']= array();

		$startdate = date("Y-04-01");
		//$enddate =  date("Y-m-d");
		$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));

		///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
		$count=0;
		if($type=="next")
		{
			$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			$count=$query->rowCount();
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
				$filscalid=  $row->Id;
			}	
			if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
		}	
		elseif($type=="previous")
		{
			$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			$count=$query->rowCount();
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
				$filscalid=  $row->Id;
			}	
			if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
		}
		else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
				$filscalid=  $row->Id;
			}
		}
		$startdate1= $startdate;

		while(strtotime(date($startdate1)) <= strtotime(date($enddate))){
			$lastdate = date("Y-m-t", strtotime(date($startdate1)));
			$sql = "SELECT count(*) as totalcount FROM EmployeeMaster WHERE OrganizationId=? and Is_Delete=0 and DOJ between ? and ?  order by DOJ desc";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $startdate1, $lastdate ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();
					$res['months'] = date('F',strtotime(date($startdate1)));					
					$res['count'] = $row->totalcount;	
					$data['newjoinings'][] = $res;
				}
			}else{
				$res = array();
					$res['months'] = date('F',strtotime(date($startdate1)));					
					$res['count'] = 0;	
					$data['newjoinings'][] = $res;
			}
			$startdate1 = date("Y-m-d", strtotime("+1 month, ".date($startdate1)));
		}

		///////////////// GETTING LIST OF EMPLOYEE BY EXPERIENCE ///////////////
		$keyarr= array(0,0,0,0,0,0);
		$label= array('Below 1Y', '1Y to 3Y', '3Y to 5Y', '5Y to 10Y', '10Y to 15Y', 'Above 15Y' );
		$sql = "SELECT TIMESTAMPDIFF(year,DOJ, curdate()) as totalcount FROM EmployeeMaster WHERE OrganizationId=? and DOL ='0000-00-00' ";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		$count =  $query->rowCount();
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				if($row->totalcount<=1){
						$keyarr[0] = $keyarr[0]+1;
					}elseif($row->totalcount>1 && $row->totalcount<=3){
						$keyarr[1] = $keyarr[1]+1;
					}elseif($row->totalcount>3 && $row->totalcount<=5){
						$keyarr[2] = $keyarr[2]+1;
					}elseif($row->totalcount>5 && $row->totalcount<=10){
						$keyarr[3] = $keyarr[3]+1;
					}elseif($row->totalcount>10 && $row->totalcount<=15){
						$keyarr[4] = $keyarr[4]+1;
					}elseif($row->totalcount>15){
						$keyarr[5] = $keyarr[5]+1;
					}

			}
		}
		for($i=0; $i<count($label); $i++)
		{
			$res = array();
			$res["count"] = $keyarr[$i];
			$res['name'] =$label[$i];
			$data['employeebyage'][] = $res;
		}

		///////////////// GETTING LIST OF EMPLOYEE BY QUALIFICATION ///////////////
		$sql = "SELECT Id, Name FROM CategoryMaster WHERE TypeId=3 ";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM EmployeeQualification WHERE Degree in ( select Id from QualificationTable where OrganizationId=? and CategoryId =?)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $row->Id ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					if($row1->totalcount>0){
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->Name;
					$data['employeebyqualify'][] = $res;						
					}
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->Name;
					$data['employeebyqualify'][] = $res;
			}
		}

		///////////////// GETTING LIST OF EMPLOYEE TRANSFER BY DIVISION ///////////////
		$sql = "SELECT Id, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0 ";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(jmc.Id) as totalcount FROM JobModificationMaster jm, JobModificationChild jmc WHERE jm.Id = jmc.JobId and jm.OrganizationId=? and FieldName ='Division' and ApplyFrom between ? and ?  and NewValue=? group by FieldName";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate, $row->Id ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->ShortName;
					$data['totaltransfer'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->ShortName;
					$data['totaltransfer'][] = $res;
			}
		}

		///////////////// GETTING LIST OF EMPLOYEE PROMOTION BY DIVISION ///////////////
		$sql = "SELECT Id, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0 ";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM JobModificationMaster where OrganizationId=? and ApplyFrom between ? and ? and EmployeeId in (select Id from EmployeeMaster where Division=? and Is_Delete=0) and PromotionType=1";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate, $row->Id ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->ShortName;
					$data['totalpromotion'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->ShortName;
					$data['totalpromotion'][] = $res;
			}
		}

		///////////////// GETTING LIST OF EMPLOYEE BY SKILLS ///////////////
		$sql = "SELECT Id, Name FROM CategoryMaster WHERE TypeId=2 ";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM EmployeeSkills WHERE SkillsId in ( select Id from SkillTable where OrganizationId=? and CategoryId =?)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $row->Id ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->Name;
					$data['employeebyskills'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->Name;
					$data['employeebyskills'][] = $res;
			}
		}

		///////////////// GETTING LIST OF OVERALL TURNOVER ///////////////
		$stdate = $startdate;
		while(strtotime(date($stdate)) <= strtotime(date($enddate)))
		{

			$res = array();
			$res['name'] =date("F",strtotime(date($stdate)));
			$sql1 = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='EmployeeStatus' and ActualValue in (1,2,3)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($r1=$query1->fetch()){
				$sql2 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and LAST_DAY(?)  and SeveranceStatus=2 and EmployeeStatus=?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $orgid, $stdate, $stdate, $r1->ActualValue ));
				$count =  $query2->rowCount();

				while($row1 = $query2->fetch())
				{
					$res[$r1->ActualValue] = (int)$row1->totalcount;
				}

			}
			$data['overallturnover'][] = $res;	
			$stdate = date("Y-m-d",strtotime("+1 month, ".date($stdate)));
		}

		///////////////// GETTING LIST OF EMPLOYEE TURNOVER BY REASON ///////////////
		/*$sql = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='SeveranceReason'";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ?  and TurnoverReason=? and SeveranceStatus=2";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate, $row->ActualValue ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->DisplayName;
					$data['turnoverbyreason'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->DisplayName;
					$data['turnoverbyreason'][] = $res;
			}
		}*/

		///////////////// GETTING LIST OF EMPLOYEE TURNOVER BY DIVISION ///////////////
		/*$sql = "SELECT Id, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0 ";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ?  and EmployeeId in ( select Id from EmployeeMaster where Division=?) and SeveranceStatus=2";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate, $row->Id ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->ShortName;
					$data['turnoverbydivision'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->ShortName;
					$data['turnoverbydivision'][] = $res;
			}
		}*/
		$sql = "SELECT Id, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0 ";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			$res = array();
			$res['name'] =$row->ShortName;
			$sql1 = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='EmployeeStatus' and ActualValue in (1,2,3)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($r1=$query1->fetch()){
				$sql2 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ?  and EmployeeId in ( select Id from EmployeeMaster where Division=?) and SeveranceStatus=2 and EmployeeStatus=?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $orgid, $startdate, $enddate, $row->Id,$r1->ActualValue ));
				$count =  $query2->rowCount();

				while($row1 = $query2->fetch())
				{
					$res[$r1->ActualValue] = (int)$row1->totalcount;
				}

			}
			$data['turnoverbydivision'][] = $res;
		}

		///////////////// GETTING LIST OF OVERALL RESGNATION BY REASON ///////////////
		/*$sql = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='SeveranceReason' and ActualValue<20 and ActualValue<>0";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ?  and TurnoverReason=? and SeveranceStatus=2 and EmployeeStatus=1";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate, $row->ActualValue ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->DisplayName;
					$data['overallturnover'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->DisplayName;
					$data['overallturnover'][] = $res;
			}
		}*/

		///////////////// GETTING LIST OF OVERALL TERMINATION BY REASON  //and (ActualValue>=20 or ActualValue=0)///////////////
		$sql = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='SeveranceReason' ";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ?  and TurnoverReason=? and SeveranceStatus=2 group by TurnoverReason";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate, $row->ActualValue ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->DisplayName;
					$data['turnoverbyreason'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->DisplayName;
					$data['turnoverbyreason'][] = $res;
			}
		}

		///////////////// GETTING LIST OF OVERALL ABSCONDED EMPLOYEE BY REASON ///////////////
		/*$sql = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='SeveranceReason' and ActualValue>=20";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ?  and TurnoverReason=? and SeveranceStatus=2 and EmployeeStatus=3";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate, $row->ActualValue ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->DisplayName;
					$data['turnoverbydivision'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->DisplayName;
					$data['turnoverbydivision'][] = $res;
			}
		}

		*/

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
	}

	public function getEmployeeReportingDashboard($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////

		$filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{

		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$emptable = "";
		$nonemptable = "";
		$notification="";

		$ids = Utils::getReportingIds($userid, $this->db);
		$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
		$nonemptable = " and EmployeeId in ($ids)";
		$notification = " and CreatedById in ($ids)";

		$data['newjoinings'] = array();
		$data['employeebyage'] = array();
		$data['employeebyqualify'] = array();
		$data['totaltransfer']= array(); 
		$data['totalpromotion']= array(); 
		$data['employeebyskills']= array();
		$data['overallturnover']= array();
		$data['turnoverbyreason']= array();
		$data['turnoverbydivision']= array();

		$startdate = date("Y-04-01");
		//$enddate =  date("Y-m-d");
		$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));

		///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
		$count=0;
		if($type=="next")
		{
			$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			$count=$query->rowCount();;
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
				$filscalid=  $row->Id;
			}	
			if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
		}	
		elseif($type=="previous")
		{
			$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			 $count=$query->rowCount();

			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
				$filscalid=  $row->Id;
			}
			if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
		}
		else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
			while($row = $query->fetch()){
				$startdate = $row->StartDate;
				$enddate =  $row->EndDate;
				$filscalid=  $row->Id;
			}
		}
		$startdate1= $startdate;
		while(date($startdate1) <= date($enddate)){
			$lastdate = date("Y-m-t", strtotime(date($startdate1)));
			$sql = "SELECT count(*) as totalcount FROM EmployeeMaster WHERE OrganizationId=? and Is_Delete=0 and DOJ between ? and ? $emptable  order by DOJ desc";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $startdate1, $lastdate ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();
					$res['months'] = date('F',strtotime(date($startdate1)));					
					$res['count'] = $row->totalcount;	
					$data['newjoinings'][] = $res;
				}
			}else{
				$res = array();
					$res['months'] = date('F',strtotime(date($startdate1)));					
					$res['count'] = 0;	
					$data['newjoinings'][] = $res;
			}
			$startdate1 = date("Y-m-d", strtotime("+1 month, ".date($startdate1)));
		}

		///////////////// GETTING LIST OF EMPLOYEE BY EXPERIENCE ///////////////
		$keyarr= array(0,0,0,0,0,0);
		$label= array('Below 1Y', '1Y to 3Y', '3Y to 5Y', '5Y to 10Y', '10Y to 15Y', 'Above 15Y' );
		$sql = "SELECT TIMESTAMPDIFF(year,DOJ, curdate()) as totalcount FROM EmployeeMaster WHERE OrganizationId=? $emptable";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		$count =  $query->rowCount();
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				if($row->totalcount<=1){
						$keyarr[0] = $keyarr[0]+1;
					}elseif($row->totalcount>1 && $row->totalcount<=3){
						$keyarr[1] = $keyarr[1]+1;
					}elseif($row->totalcount>3 && $row->totalcount<=5){
						$keyarr[2] = $keyarr[2]+1;
					}elseif($row->totalcount>5 && $row->totalcount<=10){
						$keyarr[3] = $keyarr[3]+1;
					}elseif($row->totalcount>10 && $row->totalcount<=15){
						$keyarr[4] = $keyarr[4]+1;
					}elseif($row->totalcount>15){
						$keyarr[5] = $keyarr[5]+1;
					}

			}
		}
		for($i=0; $i<count($label); $i++)
		{
			$res = array();
			$res["count"] = $keyarr[$i];
			$res['name'] =$label[$i];
			$data['employeebyage'][] = $res;
		}

		///////////////// GETTING LIST OF EMPLOYEE BY QUALIFICATION ///////////////
		$sql = "SELECT Id, Name FROM CategoryMaster WHERE TypeId=3 ";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM EmployeeQualification WHERE Degree in ( select Id from QualificationTable where OrganizationId=? and CategoryId =?) $nonemptable";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $row->Id ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					if($row1->totalcount>0){
						$res = array();
						$res["count"] = (int)$row1->totalcount;
						$res['name'] =$row->Name;
						$data['employeebyqualify'][] = $res;						
					}else{
						$res = array();
						$res["count"] = 0;
						$res['name'] =$row->Name;
						$data['employeebyqualify'][] = $res;
					}
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->Name;
					$data['employeebyqualify'][] = $res;
			}
		}

		///////////////// GETTING LIST OF EMPLOYEE TRANSFER BY DIVISION ///////////////

			$sql1 = "SELECT * FROM JobModificationMaster jm, JobModificationChild jmc WHERE jm.Id = jmc.JobId and jm.OrganizationId=? and ModifyType=3 and ApplyFrom between ? and ?  $nonemptable group by ApplyFrom desc";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row = $query1->fetch())
				{
					$res = array();
					$res["name"] = Utils::getEmployeeName($row->EmployeeId,$this->db);
					if($row->FieldName=='Division'){
						$res['message'] =Utils::getName($row->NewValue,'DivisionMaster','Name',$this->db);
					}else{
						$res['message'] =Utils::getName($row->NewValue,'LocationMaster','Name',$this->db);
					}
					$data['totaltransfer'][] = $res;						
				}
			}

		///////////////// GETTING LIST OF EMPLOYEE PROMOTION BY DIVISION ///////////////

			$sql1 = "SELECT * FROM JobModificationMaster where OrganizationId=? and ApplyFrom between ? and ? and PromotionType=1 $nonemptable";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["name"] = Utils::getEmployeeName($row1->EmployeeId,$this->db);
					$res['message'] ="";
					$data['totalpromotion'][] = $res;						
				}
			}

		///////////////// GETTING LIST OF EMPLOYEE BY SKILLS ///////////////
		$sql = "SELECT Id, Name FROM CategoryMaster WHERE TypeId=2 ";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM EmployeeSkills WHERE SkillsId in ( select Id from SkillTable where OrganizationId=? and CategoryId =?) $nonemptable";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $row->Id ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->Name;
					$data['employeebyskills'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->Name;
					$data['employeebyskills'][] = $res;
			}
		}

		///////////////// GETTING LIST OF OVERALL TURNOVER ///////////////
		$stdate = $startdate;
		while(date($stdate) <= date($enddate))
		{
			$lastdate = date("Y-m-t",strtotime(date($stdate)));

			$res = array();
			$res['name'] =date("F",strtotime(date($stdate)));
			$sql1 = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='EmployeeStatus' and ActualValue in (1,2,3)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($r1=$query1->fetch()){
				$sql2 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ? and EmployeeId in ( select Id from EmployeeMaster where Division=? and Is_Delete=0) and SeveranceStatus=2 and EmployeeStatus=? $nonemptable";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $orgid, $stdate, $lastdate, $r1->ActualValue ));
				$count =  $query2->rowCount();

				while($row1 = $query2->fetch())
				{
					$res[$r1->ActualValue] = (int)$row1->totalcount;
				}

			}
			$data['overallturnover'][] = $res;	
			$stdate = date("Y-m-01",strtotime("+1 month, ".date($stdate)));
		}

		$sql = "SELECT Id, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids))";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			$res = array();
			$res['name'] =$row->ShortName;
			$sql1 = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='EmployeeStatus' and ActualValue in (1,2,3)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();
			while($r1=$query1->fetch()){
				$sql2 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ?  and EmployeeId in ( select Id from EmployeeMaster where Division=?) and SeveranceStatus=2 and EmployeeStatus=? $nonemptable";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $orgid, $startdate, $enddate, $row->Id,$r1->ActualValue ));
				$count =  $query2->rowCount();

				while($row1 = $query2->fetch())
				{
					$res[$r1->ActualValue] = (int)$row1->totalcount;
				}

			}
			$data['turnoverbydivision'][] = $res;
		}

		///////////////// GETTING LIST OF OVERALL TERMINATION BY REASON  //and (ActualValue>=20 or ActualValue=0)///////////////
		$sql = "SELECT Id, DisplayName, ActualValue FROM OtherMaster WHERE OtherType='SeveranceReason' ";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row = $query->fetch())
		{
			$sql1 = "SELECT count(Id) as totalcount FROM SeveranceMaster WHERE OrganizationId=?  and EffectDate between ? and ?  and TurnoverReason=? and SeveranceStatus=2 and EmployeeStatus=2 $nonemptable";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $startdate, $enddate, $row->ActualValue ));
			$count =  $query1->rowCount();
			if($count>=1)
			{
				while($row1 = $query1->fetch())
				{
					$res = array();
					$res["count"] = (int)$row1->totalcount;
					$res['name'] =$row->DisplayName;
					$data['turnoverbyreason'][] = $res;						
				}
			}else{
				$res = array();
					$res["count"] = 0;
					$res['name'] =$row->DisplayName;
					$data['turnoverbyreason'][] = $res;
			}
		}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
	}

	public function Closed_getEmployeeDashboard1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];

		try{

		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$emptable = "";
		$nonemptable = "";
		$notification="";
		if($sts==1 || $hrsts==1){
			$emptable = " and  DOL='0000-00-00' ";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
			$nonemptable = " and EmployeeId in ($ids)";
			$notification = " and CreatedById in ($ids)";
		}

		/*
		$data['birthdays'] = array();
		$data['newjoinings'] = array();
		$data['totaljoin'] = array();
		*/

		//////////////////// GETTING LIST OF COMMING BIRTHDAY //////////////////

    /*    $sql = "SELECT Id, FirstName, LastName, DOB, Gender, ImageName, datediff( DATE_ADD(dob, INTERVAL YEAR(CURDATE())-YEAR(dob)+ IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0) YEAR), curdate()) as diff  FROM EmployeeMaster WHERE DATE_ADD(dob,INTERVAL YEAR(CURDATE())-YEAR(dob)
                         + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0) YEAR)
            BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY) and OrganizationId=? and  DOL='0000-00-00' order by (DATE_ADD(dob, INTERVAL YEAR(CURDATE())-YEAR(dob)+ IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0) YEAR)) limit 8";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['birthday'] = ($row->diff==0)?"Today":(($row->diff==1)?"Tomorrow":date("d M", strtotime($row->DOB)));
				$res['image'] = $row->ImageName;
				if($row->ImageName==""){
					if($row->Gender==1){
						$res['image'] =URL."public/avatars/male.png";
					}else{
						$res['image'] =URL."public/avatars/female.png";
					}
				}else{
					$res['image'] = URL."public/uploads/".$orgid."/".$row->ImageName;
				}
				$data['birthdays'][] = $res;
			}
        }

		///////////////// GETTING LIST OF LAST NEW JOINNINGS OF EMPLOYEE ///////////////

		 $sql = "SELECT Id, FirstName, LastName, DOJ, Gender, ImageName  FROM EmployeeMaster WHERE OrganizationId=? and  DOL='0000-00-00' order by DOJ desc limit 8";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['joining'] = date("d M", strtotime($row->DOJ));
				$res['image'] = $row->ImageName;
				$res['image'] = $row->ImageName;
				if($row->ImageName==""){
					if($row->Gender==1){
						$res['image'] =URL."public/avatars/male.png";
					}else{
						$res['image'] =URL."public/avatars/female.png";
					}
				}else{
					$res['image'] = URL."public/uploads/".$orgid."/".$row->ImageName;
				}
				$data['newjoinings'][] = $res;
			}
        }

		///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////

		 $sql = "SELECT count(*) as totalcount, DATE_ADD(LAST_DAY(DATE_SUB(doj, INTERVAL 1 MONTH)), INTERVAL 1 DAY) AS joinmonth FROM EmployeeMaster WHERE OrganizationId=? GROUP BY year(doj), month(doj) order by DOJ desc limit 12";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$res['month'] = date('M Y',strtotime($row->joinmonth));					
				$res['count'] = $row->totalcount;	
				$data['totaljoin'][] = $res;
			}
        }

		/*$data['empindivision'] = array();
		$data['empindepartment'] = array();
		$data['empindesignation'] = array();
		$data['empingrade'] = array();
		$data['empinshift'] = array();*/

		$data['newjoinings'] = array();
		$data['probation'] = array();
		$data['grievance'] = array();
		$data['notification']= array(); 
		$data['approvals']= array(); 
		$data['forthcomingevents']= array();

		///////////////// GETTING LIST OF LAST NEW JOINNINGS OF EMPLOYEE ///////////////

		 $sql = "SELECT Id, FirstName, LastName, DOJ, Gender, ImageName,Designation  FROM EmployeeMaster WHERE OrganizationId = ? and Is_Delete=0 $emptable and  curdate() between DOJ and Date_add(DOJ, interval 7 day) order by DOJ desc limit 20";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = Utils::encode5t($row->Id);
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['joining'] = date("d M Y", strtotime($row->DOJ));
				$res['image'] = $row->ImageName;
				$res['desig'] = $this->getName($row->Designation,'DesignationMaster');
				if($row->ImageName==""){
					if($row->Gender==1){
						$res['image'] =URL."public/avatars/male.png";
					}else{
						$res['image'] =URL."public/avatars/female.png";
					}
				}else{
					$res['image'] = URL."public/uploads/".$orgid."/".$row->ImageName;
				}
				$data['newjoinings'][] = $res;
			}
        }

		///////////////// GETTING LIST OF UNDER PROBATION EMPLOYEE ///////////////

		 $sql = "SELECT Id, FirstName, LastName, DOJ, Gender, ImageName,datediff(DATE_ADD(DOJ, INTERVAL ProvisionPeriod month), curdate()) as daysleft  FROM EmployeeMaster WHERE OrganizationId=? and Is_Delete=0 $emptable and ProvisionPeriod <>0  and CURDATE() BETWEEN DOJ AND DATE_ADD(DOJ, INTERVAL ProvisionPeriod month) order by daysleft asc";
		 //AND DATE_ADD(CURDATE(), INTERVAL 30 DAY)  ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1 )
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = Utils::encode5t($row->Id);
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['joining'] = date("d M Y", strtotime($row->DOJ));
				$res['image'] = $row->ImageName;
				$res['provision'] = $row->daysleft.' days left in probation';
				if($row->ImageName==""){
					if($row->Gender==1){
						$res['image'] =URL."public/avatars/male.png";
					}else{
						$res['image'] =URL."public/avatars/female.png";
					}
				}else{
					$res['image'] = URL."public/uploads/".$orgid."/".$row->ImageName;
				}
				$data['probation'][] = $res;
			}
        }
		////////////  FETCH ALL NOTIFICATION OF THE EMPLOYEE  //////////////////////

		$sql = "SELECT * FROM NotificationMaster WHERE OrganizationId = ? $notification  AND CURDATE() BETWEEN StartDate and EndDate ORDER BY NotificationPriority,StartDate desc";
		try{
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();	
					$res['id'] = Utils::encode5t($row->Id);					
					$res['name'] = $row->Name;   
					//$res['time'] = date("H:i A", strtotime($row->CreatedDate)); 
					$res['message'] = $row->Message; 
					$res['employee'] =Utils::getEmployeeName($row->CreatedById, $this->db);
					$image =$this->getName($row->CreatedById,'EmployeeMaster', 'ImageName');
					if(!empty($image))
					{
						$image = URL."public/uploads/$orgid/$image";
						if(file_exists($image)){
							$image = URL."public/avatars/male.png";
						}
					}else{
						$image = URL."public/avatars/male.png";
					}
					$res['image'] = URL."public/uploads/".$orgid."/".$row->ImageName;
					$res['priority'] = $row->NotificationPriority;						

					if($row->Division==0 && $row->Designation==0 && $row->Department==0 && $row->EmployeeIds==0){
						$data['notification'][] = $res;
					}else{
						$cond="and ";
						if($row->Division!=0){
							$cond .=" Division=".$row->Division." AND ";
						}
						if($row->Designation!=0){
							$cond .=" Designation=".$row->Designation." AND ";
						}
						if($row->Department!=0){
							$cond .=" Department=".$row->Department." AND ";
						}
						if($row->EmployeeIds!=0){
							$cond .=" Id in (".$row->EmployeeIds.") and";
						}

						$cond = substr($cond, 0, -4);
						if($cond!="")
						{	
							$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? $emptable  $cond ";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($orgid));
							if($query1->rowCount()>0)
							{
								$data['notification'][] = $res;
							}
						}
					}

				}
			}
			}catch(Exception $e){
				$e->getMessage();
			}
			////////////  FETCH ALL GRIEVANCES OF THE  EMPLOYEES  //////////////////////

		$sql = "SELECT * FROM GrievanceMaster WHERE OrganizationId = ? and Id in (select GrievanceId from GrievanceApproval where ApproverId = $userid and ApproveSts=3) ORDER BY Priority,LastModifiedDate desc";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();		
					$res['id'] = Utils::encode5t($row->Id);	
					//$res['name'] = $row->Name;   
					//$res['time'] = date("H:i A", strtotime($row->CreatedDate)); 
					$res['message'] = $row->Message; 
					$res['employee'] =Utils::getEmployeeName($row->CreatedById, $this->db);
					$image =$this->getName($row->CreatedById,'EmployeeMaster', 'ImageName');
					if(!empty($image))
					{
						$image = URL."public/uploads/$orgid/$image";
						if(file_exists($image)){
							$image = URL."public/avatars/male.png";
						}
					}else{
						$image = URL."public/avatars/male.png";
					}
					$res['image']= $image."?img=" .rand(1,100);
					$res['priority'] = $row->Priority;						

					$data['grievance'][] = $res;

				}
			}

		////////////  FETCH ALL APPROVAL ITEM OF THE EMPLOYEES  //////////////////////

		/*$sql = "SELECT * FROM GrievanceMaster WHERE OrganizationId = ?  and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month)";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();					
					$res['name'] = $row->Name;   
					$emp = Utils::getEmployeeName($row->CreatedById, $this->db); 
					$res['time'] = Utils::datetimeformatter($row->CreatedDate); 
					$res['message'] = $emp."'s Grievance has been ".$this->getStatus($row->ApproveSts); 
					//$res['priority'] = $this->getpriority($row->NotificationPriority);

					$data['approvals'][] = $res;

				}
			}*/
		$sql = "SELECT * FROM EmployeeLeave WHERE Id in (SELECT LeaveId from LeaveApproval where ApproverId=$userid and ApproverSts=3) and LeaveStatus=3 and OrganizationId = ? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month)  limit 10";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();	
					$res['link'] = 'leave/editleaveapproval/'.Utils::encode5t($row->Id);
					$emp=Utils::getEmployeeName($row->EmployeeId, $this->db);	
					$res['name'] = "Leave Application";//Utils::getEmployeeName($row->EmployeeId, $this->db);  
					$res['time'] = Utils::datetimeformatter($row->LastModifiedDate);
					$res['time1'] = $row->LastModifiedDate; 
					$res['message'] = $emp."'s request for Leave  is ".$this->getStatus($row->LeaveStatus,'LeaveStatus'); 
					//$res['priority'] = $this->getpriority($row->NotificationPriority);

					$data['approvals'][] = $res;

				}
			}

		$sql = "SELECT * FROM SalaryAdvance WHERE Id in (SELECT SalaryAdvanceId from SalaryApproval where ApproverId=$userid and LeaveStatus=3) and LeaveStatus=3 and OrganizationId = ? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) limit 0,10";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();	
					$res['link'] = 'salary/viewsalaryadvanceapproval/'.Utils::encode5t($row->Id).'/0';
					$emp=Utils::getEmployeeName($row->EmployeeId, $this->db); 	
					$res['name'] = "Personal Loan";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
					$res['time'] = Utils::datetimeformatter($row->LastModifiedDate);
					$res['time1'] = $row->LastModifiedDate; 	
					$res['message'] = $emp."'s request for Personal Loan is ".$this->getStatus($row->LeaveStatus,'LeaveStatus'); 
					//$res['status'] = $this->getStatus($row->ApproverSts);

					$data['approvals'][] = $res;

				}
			}

		$sql = "SELECT * FROM DocumentReleaseMaster WHERE Id in (SELECT DocumentId from DocumentApproval where ApproverId=$userid and ApproverSts=3) and ApproverSts=3 and OrganizationId = ? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month )  limit 0,10";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();	
					$res['link'] = 'employee/editdocumentapproval/'.Utils::encode5t($row->Id);
					$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
					$res['name'] = "Document Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);  
					$res['time1'] = $row->LastModifiedDate; 					
					$res['time'] = Utils::datetimeformatter($row->LastModifiedDate); 
					$res['message'] = $emp."'s request for Document Release is ".$this->getStatus($row->ApproverSts,'LeaveStatus'); 
					//$res['status'] = $this->getStatus($row->ApproverSts);

					$data['approvals'][] = $res;

				}
			}

			$sql = "SELECT * FROM CertificateReleaseMaster WHERE Id in (SELECT CertificateId from CertificateApproval where ApproverId=$userid and ApproverSts=3) and ApproverSts=3  and OrganizationId = ? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) limit 0,10";
			$query = $this->db->prepare($sql);
			$query->execute(array(  $orgid ));
			$count =  $query->rowCount();
				if($count>=1)
				{
					$status=true;
					while($row = $query->fetch())
					{
						$res = array();	
						$res['link'] = 'employee/editcertificateapproval/'.Utils::encode5t($row->Id);
						$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
						$res['name'] = "Certificate Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
						$res['time1'] = $row->LastModifiedDate; 
						$res['time'] = Utils::datetimeformatter($row->LastModifiedDate); 
						if($row->ApproverSts==6){
							$sts="Issued";
						}else{
							$sts=$this->getStatus($row->ApproverSts,'LeaveStatus');
						}
						$res['message'] = $emp."'s request for Certificate Release is ".$sts; 
						//$res['status'] = $this->getStatus($row->ApproverSts);

						$data['approvals'][] = $res;

					}
				}

				$sql = "SELECT * FROM SeveranceMaster WHERE Id in (SELECT ResignationId from ResignationApproval where ApproverId=$userid and LeaveStatus=3) and SeveranceStatus=3  and OrganizationId = ?  limit 0,10";
				$query = $this->db->prepare($sql);
				$query->execute(array(  $orgid ));
				$count =  $query->rowCount();
					if($count>=1)
					{
						$status=true;
						while($row = $query->fetch())
						{
							$res = array();	
							$res['link'] = 'employee/editseveranceapproval/'.Utils::encode5t($row->Id).'';
							$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
							$res['name'] = "Severance Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
							$res['time1'] = $row->LastModifiedDate; 
							$res['time'] = Utils::datetimeformatter($row->LastModifiedDate); 

							$sts=$this->getStatus($row->SeveranceStatus,'LeaveStatus');

							$res['message'] = $emp."'s request for Severance is ".$sts; 
							//$res['status'] = $this->getStatus($row->ApproverSts);

							$data['approvals'][] = $res;

						}
					}

				if(count($data['approvals'])>0){
					foreach ($data['approvals'] as $key => $row) {
						$edition[$key] = $row['time1'];
					}

					array_multisort( $edition, SORT_DESC, $data['approvals']);
				}

		////////////  FETCH ALL FORTHCOMING EVENT ITEM FOR THE LOGGED IN EMPLOYEE  //////////////////////
		$sql = "SELECT DOB, FirstName, LastName FROM EmployeeMaster WHERE OrganizationId = ? and Is_Delete=0  and  (DAY(DOB) = DAY(CURDATE())) AND (MONTH(DOB) = MONTH(CURDATE())) and (DOL = '0000-00-00' or DOL > CURDATE() )   order by month(DOB),day(DOB) limit 10  ";
		/*$sql = "SELECT DOB, FirstName, LastName FROM EmployeeMaster WHERE OrganizationId = ? $emptable and  DATE_ADD(DOB,INTERVAL YEAR(CURDATE())-YEAR(DOB)
                         +  IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(DOB),1,0) YEAR)
            = CURDATE() and (DOL = '0000-00-00' or DOL > CURDATE() ) order by month(DOB),day(DOB) limit 10  ";*/
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();					
					$res['name'] = "Birthday";   
					$res['date'] = Utils::dateformatter($row->DOB); 
					$res['message'] = "It's ".ucwords(strtolower($row->FirstName." ".$row->LastName))."'s birthday today"; 

					$data['forthcomingevents'][] = $res;

				}
			}

		$sql = "SELECT * FROM HolidayMaster WHERE OrganizationId = ? AND DateFrom>=CURDATE() order by DateFrom limit 5";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();					
					$res['name'] = "Holiday - ".$row->Name;   
					$res['date'] = Utils::dateformatter($row->DateFrom); 
					$res['message'] = $row->Description; 

					$data['forthcomingevents'][] = $res;

				}
			}

		}catch(Exception $e){
			$status=false;
			$errorMsg = $e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	/*
	*	EMPLOYEE TAB DASHBOARD
	*	FETCH DATA FOR NEW JOINING DASHBOARD
	*/
	public function getEmployeeDashboard2($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $request[1];
		$userid = $request[0];

		$ids = Utils::getReportingIds($userid, $this->db);
		$sts=$_SESSION['ubihrm_user_sts'];
		$sWhere = "";
		if($sts==1){
			$sWhere = " and  DOL='0000-00-00' ";
		}else{
			$sWhere = " and Id in ($ids) and  DOL='0000-00-00'  ";
		}

        $sql = "SELECT Id, FirstName, LastName, DOJ, Gender, ImageName  FROM EmployeeMaster WHERE OrganizationId=? and Is_Delete=0 $sWhere order by DOJ desc limit 8";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['joining'] = date("d M", strtotime($row->DOJ));
				$res['image'] = $row->ImageName;
				$res['image'] = $row->ImageName;
				if($row->ImageName==""){
					if($row->Gender==1){
						$res['image'] =URL."public/avatars/male.png";
					}else{
						$res['image'] =URL."public/avatars/female.png";
					}
				}else{
					$res['image'] = URL."public/uploads/".$orgid."/".$row->ImageName;
				}
				$data[] = $res;
			}
        }else {
           $status =false;
		   $errorMsg = VISA_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	/*
	*	ATTENDANCE TAB DASHBOARD
	*	FETCH DATA FOR PUNCTUALITY GRAPH DASHBOARD
	*/
	public function getAttendanceDashboard($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];
		$filscalid = ($request[2]!=0)?$request[2]:$_SESSION['ubihrm_fiscalid'];
		$type = $request[3];

		try{
			//$filscalid=$_SESSION['ubihrm_fiscalid'];
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}

			$data['chartdata1date'] = "";
			$data['chartdata1'] = array();
			$data['chartdata2'] = array();
			$data['chartdata3'] = array();
			$data['chartdata4']= array(); 
			$data['chartdata5']= array(); 
			$data['chartdata6']= array();
			$data['chartdata7']= array();
			$data['chartdata8']= array();
			$data['chartdata9']= array();

			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));

		///////////////// GETTING FISCAL START AND END DATES ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();;
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
					$filscalid=  $row->Id;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}	
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();;
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
					$filscalid=  $row->Id;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
				$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}

		///////////  GETTING LIST OF  PRESENT, LATECOMER OR OVERTIME //////////////////

			$sql1 = "Select AttendanceDate from AttendanceMaster Where OrganizationId=? order by AttendanceDate desc limit 1";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ));
			$count1 =  $query1->rowCount();
			$present=0; $latecomer=0; $overtime=0; $undertime=0;
			if($count1>=1)
			{
				$row1 = $query1->fetch();
				//$data['chartdata1date'] = Utils::dateformatter($row1->AttendanceDate);
				$data['chartdata1date'] = date("M j, Y", strtotime(date($row1->AttendanceDate)));
				$sql = "SELECT ((TIME_TO_SEC(a.TimeIn)-TIME_TO_SEC(s.TimeIn))/60 >0) as undertime, ((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, AttendanceDate, TIME_TO_SEC(Overtime) as otime FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and a.OrganizationId=? and AttendanceStatus=1 and AttendanceDate = ?";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $row1->AttendanceDate));
				$count =  $query->rowCount();

				if($count>=1)
				{				
					while($row = $query->fetch())
					{
						if($row->perc==1){
							$present++;
						}else{
							$latecomer++;
						}
						if($row->undertime>0){
							$undertime++;
						}
						if($row->otime>0){
							$overtime++;
						}
					}

				}
				   $res = array();
				   $res['label'] = "Present";
					$res['value'] = $present;
					$data['chartdata1'][] = $res;

					$res = array();
				   $res['label'] = "Tardy";
					$res['value'] = $latecomer;
					$data['chartdata1'][] = $res;

					$res = array();
				   $res['label'] = "Overtime";
					$res['value'] = $overtime;
					$data['chartdata1'][] = $res;

				$res = array();
				   $res['label'] = "Undertime";
					$res['value'] = $undertime;
					$data['chartdata1'][] = $res;
			}

		///////////  GETTING LIST OF  PRESENT, LATECOMER OR OVERTIME //////////////////

			$present=0; $latecomer=0; $overtime=0; $undertime=0;
			$totalP =0;$totalT =0;$totalO =0;$totalU =0;
			$sql = "SELECT ((TIME_TO_SEC(a.TimeIn)-TIME_TO_SEC(s.TimeIn))/60 >0) as undertime, ((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, AttendanceDate, TIME_TO_SEC(Overtime) as otime ,AttendanceStatus as sts FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and a.OrganizationId=? and  (Month(AttendanceDate)=Month(curdate())) and (AttendanceDate between ? and ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$startdate,$enddate));
			$count =  $query->rowCount();
			if($count>=1)
			{				
				while($row = $query->fetch())
				{
					if($row->sts ==1 ){
						if($row->perc==1){
							$present++;
						}else{
							$latecomer++;
						}
						if($row->undertime>0){
								$undertime++;
							}	
						if($row->otime>0){
							$overtime++;
						}
					}
				}
				$totalP = round((($present/$count)*100),2);
				$totalT = round((($latecomer/$count)*100),2);
				$totalO = round((($overtime/$count)*100),2);
				$totalU = round((($undertime/$count)*100),2);

			}

				   $res = array();
				   $res['label'] = "Present";
					$res['value'] = $totalP;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Tardy";
					$res['value'] = $totalT;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Overtime";
					$res['value'] = $totalO;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Undertime";
					$res['value'] = $totalU;
					$data['chartdata2'][] = $res;

		///////////  GETTING LIST OF HABITUAL TARDINESS BY NUMBER OF REPETITION  ////////////////////

			$keys = array(0, 0, 0, 0 , 0);
			$labels = array('1-5 Times', '5-10 Times', '10-15 Times', '15-20 Times' , 'Above 20 Times');

					$total =0;
					$sql1 = "SELECT count(EmployeeId) as totalcount FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and a.OrganizationId=? and AttendanceStatus=1 AND ((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 < 0)  and  (Month(AttendanceDate)=Month(curdate())) and (AttendanceDate between ? and ?) group by EmployeeId";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid,$startdate,$enddate));
					if($query1->rowCount()>0){
						while($row1 = $query1->fetch())
						{
							if($row1->totalcount<=5){
								$keys[0]=$keys[0]+1; 
							}elseif($row1->totalcount>=6 && $row1->totalcount<=10){
								$keys[1]++;
							}elseif($row1->totalcount>=11 && $row1->totalcount<=15){
								$keys[2]++;
							}elseif($row1->totalcount>=16 && $row1->totalcount<=20){
								$keys[3]++;
							}elseif($row1->totalcount>20){
								$keys[4]++;
							}
						}						
					}
					for($i=0; $i<count($labels); $i++){
						$res = array();
						$res['name'] = $labels[$i];
						$res['count'] = $keys[$i];
						$data['chartdata3'][] = $res;
					}

		///////////  GETTING LIST OF ANNUAL ATTENDANCE DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$totalP =0;$totalA =0;$totalL =0;$total =0;
					$sql1 = "SELECT  Id, AttendanceStatus FROM AttendanceMaster where OrganizationId=? and AttendanceStatus IN (1,2,6) and (AttendanceDate between ? and ?) and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and DOL='0000-00-00' and Is_Delete=0)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $startdate, $enddate, $row->Id, $orgid));
					$total = $query1->rowCount();
					if($total > 0){
						while($row1 = $query1->fetch())
						{
							if($row1->AttendanceStatus==1){
								$totalP++;
							}elseif($row1->AttendanceStatus==2){
								$totalA++;
							}elseif($row1->AttendanceStatus==6){
								$totalL++;
							}
						}
						$totalP = ($totalP/$total)*100;
						$totalA = ($totalA/$total)*100;
						$totalL = ($totalL/$total)*100;
					}
						$res = array();
						$res['name'] = $row->ShortName;
						$res['totalpresent'] = round($totalP,2);
						$res['totalabsent'] =round( $totalA,2);
						$res['totalleave'] =round( $totalL,2);						
						$data['chartdata4'][] = $res;
				}
			}

		///////////  GETTING LIST OF MONTHLY PRESENT DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$total =0; $totalP =0;
					$sql1 = "SELECT  *  FROM AttendanceMaster where OrganizationId=? and  (Month(AttendanceDate)=Month(curdate())) and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and DOL='0000-00-00' and Is_Delete=0) and (AttendanceDate between ? and ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $orgid,$startdate,$enddate));
					$count=$query1->rowCount();
					if($count>0){
						while($row1 = $query1->fetch())
						{
							if($row1->AttendanceStatus ==1)
							$total++ ;
						}
					$totalP = ($total/$count)*100;	
					}
						$res = array();
						$res['name'] = $row->ShortName;
						$res['count'] =round( $totalP,2);
						$data['chartdata5'][] = $res;
				}
			}
		///////////  GETTING LIST OF MONTHLY ABSENT DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$total =0; $totalP =0;
					$sql1 = "SELECT  *  FROM AttendanceMaster where OrganizationId=? and  (Month(AttendanceDate)=Month(curdate())) and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and DOL='0000-00-00' and Is_Delete=0) and (AttendanceDate between ? and ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $orgid,$startdate,$enddate));
					$count=$query1->rowCount();
					if($count>0){
						while($row1 = $query1->fetch())
						{
							if($row1->AttendanceStatus ==2)
							$total++ ;
						}
					$totalP = ($total/$count)*100;	
					}

						$res = array();
						$res['name'] = $row->ShortName;
						$res['count'] = round( $totalP,2);
						$data['chartdata6'][] = $res;
				}
			}

		///////////  GETTING LIST OF NUMBER OF EMPLOYEE IN WORK HOURS DAILY  ////////////////////
		/*	$temparr=array();
			$sql = "Select HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? GROUP BY HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak)))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{

				while($row= $query->fetch()){
					if($row->totaltime < 0)
					{
						$totalhour =24 - $row->totalhour;
					}else{
						$totalhour = $row->totalhour;
					}

					$sql1 ="Select count(Id) as totalcount from EmployeeMaster where OrganizationId=? and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $orgid, $totalhour ));
					while($row1 = $query1->fetch())
					{
						$res = array();
						$res['name'] = $totalhour .' hr';
						//$totalmin = ($row->totalmin/60)*100;
						$res['count'] = $row1->totalcount;//.".".$totalmin;
						$temparr[] = $res;
					}
				}
				$temparr=array_unique($temparr,SORT_REGULAR);
				for($i=0;$i<count($temparr);$i++)
				{
					$data['chartdata7'][]=$temparr[$i];
				}

			}
		*/

			$temparr=array();
			$sql = "Select HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? GROUP BY HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak)))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				$temp=array(); $temp1=array();
				while($row= $query->fetch()){
					if($row->totaltime < 0)
					{
						$totalhour =24 - $row->totalhour;
					}else{
						$totalhour = $row->totalhour;
					}
					$res = array();
					$res['name'] = $totalhour .' hr';
					$sql1 ="Select DISTINCT WorkingDays  from EmployeeMaster where OrganizationId=? and Is_Delete=0 and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $orgid, $totalhour ));
					$totalcount=0; 
					while($row1 = $query1->fetch())
					{
						$workingdays=0;
						$workingdays=$row1->WorkingDays;
						$workingdays=substr_count($workingdays, '1');
						$halfdays=	substr_count($row1->WorkingDays, '2');
						$workingdays=$workingdays+($halfdays * 0.5);
						$temp[] = $workingdays;
						$temp1[] = $workingdays.' days';
						$sql2="select count(Id) as totalcount from EmployeeMaster where LENGTH(WorkingDays) - LENGTH(REPLACE(WorkingDays, '1', '')) = ? and OrganizationId=? and Is_Delete=0 and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?)";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $workingdays,$orgid, $orgid, $totalhour ));
						while($r=$query2->fetch())
						{

							$res[$workingdays] = $r->totalcount;
						}

					}
					//$temp=array_unique($temp,SORT_REGULAR);

					$temparr[] = $res;
				}
				$temp=array_unique($temp);
				$temp1=array_unique($temp1);
				$data['chartdata7']['ykeys']=$temp;
				$data['chartdata7']['labels']=$temp1;
				$temparr=array_unique($temparr,SORT_REGULAR);
				$data['chartdata7']['data']=$temparr;

			}
		///////////  GETTING LIST OF WORK HOURS SHIFT WISE  ////////////////////

			$sql = "SElect Id, Name, HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour , MINUTE(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn),TIMEDIFF(TimeOutBreak, TimeInBreak))) as totalmin,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? ";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$res = array();
					$res['name'] = $row->Name;

					if($row->totaltime < 0){
						$res['count'] =24 - $row->totalhour;
					}else{
					//$totalmin = ($row->totalmin/60)*100;
						$res['count'] = $row->totalhour;//.".".$totalmin;
					}
					$data['chartdata8'][] = $res;
				}
			}
		///////////  GETTING LIST OF MONTHLY OVERTIME DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$total =0;
					$sql1 = "SELECT  HOUR(sec_to_time(sum(time_to_sec(overtime)))) as totalcount FROM AttendanceMaster where OrganizationId=? and  (Month(AttendanceDate)=Month(curdate()))  and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and Is_Delete=0 and DOL='0000-00-00') and (AttendanceDate between ? and ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $orgid,$startdate,$enddate));
					if($query1->rowCount()>0){
						$row1 = $query1->fetch();
						$total = $row1->totalcount;

					}
						$res = array();
						$res['name'] = $row->ShortName;
						$res['count'] = $total;
						$data['chartdata9'][] = $res;
						//echo $total;
				}
			}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$curmonth=date('F');
		$result["data"] =$data;
		$result["curmonth"] =$curmonth;
		$result['status']=$status;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function getAttendanceReportingDashboard($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];
		$filscalid = ($request[2]!=0)?$request[2]:$_SESSION['ubihrm_fiscalid'];
		$type = $request[3];
		try{

			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";

			$ids = Utils::getReportingIds($userid, $this->db);
			$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
			$nonemptable = " and EmployeeId in ($ids)";
			$notification = " and CreatedById in ($ids)";

			$data['chartdata1date'] = "";
			$data['chartdata1'] = array();
			$data['chartdata2'] = array();
			$data['chartdata3'] = array();
			$data['chartdata4']= array(); 
			$data['chartdata5']= array(); 
			$data['chartdata6']= array();
			$data['chartdata7']= array();
			$data['chartdata8']= array();
			$data['chartdata9']= array();

			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
				$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();;
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
					$filscalid=  $row->Id;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}	
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();;
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
					$filscalid=  $row->Id;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
				$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
			///////////  GETTING LIST OF  PRESENT, LATECOMER OR OVERTIME //////////////////

			$sql1 = "Select AttendanceDate from AttendanceMaster Where OrganizationId=? $nonemptable  order by AttendanceDate  desc limit 1";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ));
			$count1 =  $query1->rowCount();
			$present=0; $latecomer=0; $overtime=0; $undertime=0;
			if($count1>=1)
			{
				$row1 = $query1->fetch();
				//$data['chartdata1date'] = Utils::dateformatter($row1->AttendanceDate);
				$data['chartdata1date'] = date("M j, Y", strtotime(date($row1->AttendanceDate)));
				$sql = "SELECT ((TIME_TO_SEC(a.TimeIn)-TIME_TO_SEC(s.TimeIn))/60 >0) as undertime, ((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, AttendanceDate, TIME_TO_SEC(Overtime) as otime FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and a.OrganizationId=? and AttendanceStatus=1 and AttendanceDate = ? $nonemptable";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $row1->AttendanceDate));
				$count =  $query->rowCount();

				if($count>=1)
				{				
					while($row = $query->fetch())
					{
						if($row->perc==1){
							$present++;
						}else{
							$latecomer++;
						}
						if($row->undertime>0){
							$undertime++;
						}
						if($row->otime>0){
							$overtime++;
						}
					}
					$res = array();
				   $res['label'] = "Present";
					$res['value'] = $present;
					$data['chartdata1'][] = $res;

					$res = array();
				   $res['label'] = "Tardy";
					$res['value'] = $latecomer;
					$data['chartdata1'][] = $res;

					$res = array();
				   $res['label'] = "Overtime";
					$res['value'] = $overtime;
					$data['chartdata1'][] = $res;

					$res = array();
				   $res['label'] = "Undertime";
					$res['value'] = $undertime;
					$data['chartdata1'][] = $res;

				}

			}

		///////////  GETTING LIST OF  PRESENT, LATECOMER OR OVERTIME //////////////////

			$present=0; $latecomer=0; $overtime=0; $undertime=0;
			$totalP=0; $totalT=0; $totalO=0; $totalU=0;
			$sql = "SELECT ((TIME_TO_SEC(a.TimeIn)-TIME_TO_SEC(s.TimeIn))/60 >0) as undertime, ((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 >0) as perc, AttendanceDate, TIME_TO_SEC(Overtime) as otime ,AttendanceStatus as sts FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and a.OrganizationId=? and  (Month(AttendanceDate)=Month(curdate())) and (AttendanceDate between ? and ?) $nonemptable";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,$startdate,$enddate));
			$count =  $query->rowCount();
			if($count>=1)
			{				
				while($row = $query->fetch())
				{
					if($row->sts ==1 ){
						if($row->perc==1){
							$present++;
						}else{
							$latecomer++;
						}
						if($row->undertime>0){
								$undertime++;
							}	
						if($row->otime>0){
							$overtime++;
						}
					}
				}

				$totalP = round((($present/$count)*100),2);
				$totalT = round((($latecomer/$count)*100),2);
				$totalO = round((($overtime/$count)*100),2);
				$totalU = round((($undertime/$count)*100),2);

			}

				   $res = array();
				   $res['label'] = "Present";
					$res['value'] = $totalP;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Tardy";
					$res['value'] = $totalT;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Overtime";
					$res['value'] = $totalO;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Undertime";
					$res['value'] = $totalU;
					$data['chartdata2'][] = $res;

		///////////  GETTING LIST OF HABITUAL TARDINESS BY NUMBER OF REPETITION  ////////////////////

			$keys = array(0, 0, 0, 0 , 0);
			$labels = array('1-5 Times', '5-10 Times', '10-15 Times', '15-20 Times' , 'Above 20 Times');

					$total =0;
					$sql1 = "SELECT count(EmployeeId) as totalcount FROM AttendanceMaster a, ShiftMaster s where a.ShiftId= s.Id and a.OrganizationId=? and AttendanceStatus=1 AND ((TIME_TO_SEC(s.TimeInGrace)-TIME_TO_SEC(a.TimeIn))/60 < 0)  and  (Month(AttendanceDate)=Month(curdate())) and (AttendanceDate between ? and ?) $nonemptable group by EmployeeId";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid,$startdate,$enddate));
					if($query1->rowCount()>0){
						while($row1 = $query1->fetch())
						{
							if($row1->totalcount<=5){
								$keys[0]=$keys[0]+1; 
							}elseif($row1->totalcount>=6 && $row1->totalcount<=10){
								$keys[1]++;
							}elseif($row1->totalcount>=11 && $row1->totalcount<=15){
								$keys[2]++;
							}elseif($row1->totalcount>=16 && $row1->totalcount<=20){
								$keys[3]++;
							}elseif($row1->totalcount>20){
								$keys[4]++;
							}
						}						
					}
					for($i=0; $i<count($labels); $i++){
						$res = array();
						$res['name'] = $labels[$i];
						$res['count'] = $keys[$i];
						$data['chartdata3'][] = $res;
					}
					///////////  GETTING LIST OF ANNUAL ATTENDANCE DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$totalP =0;$totalA =0;$totalL =0;$total =0;
					$sql1 = "SELECT  Id, AttendanceStatus FROM AttendanceMaster where OrganizationId=? and AttendanceStatus IN (1,2,6) and (AttendanceDate between ? and ?) and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and Is_Delete=0 and DOL='0000-00-00' $emptable) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $startdate, $enddate, $row->Id, $orgid));
					$total = $query1->rowCount();
					if($total > 0){
						while($row1 = $query1->fetch())
						{
							if($row1->AttendanceStatus==1){
								$totalP++;
							}elseif($row1->AttendanceStatus==2){
								$totalA++;
							}elseif($row1->AttendanceStatus==6){
								$totalL++;
							}
						}
						$totalP = ($totalP/$total)*100;
						$totalA = ($totalA/$total)*100;
						$totalL = ($totalL/$total)*100;
					}
						$res = array();
						$res['name'] = $row->ShortName;
						$res['totalpresent'] = round($totalP,2);
						$res['totalabsent'] =round( $totalA,2);
						$res['totalleave'] =round( $totalL,2);						
						$data['chartdata4'][] = $res;
				}
			}

		///////////  GETTING LIST OF MONTHLY PRESENT DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$total =0; $totalP =0;
					$sql1 = "SELECT  *  FROM AttendanceMaster where OrganizationId=? and  (Month(AttendanceDate)=Month(curdate())) and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and Is_Delete=0 and DOL='0000-00-00' $emptable) and (AttendanceDate between ? and ?) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $orgid,$startdate,$enddate));
					$count=$query1->rowCount();
					if($count>0){
						while($row1 = $query1->fetch())
						{
							if($row1->AttendanceStatus ==1)
							$total++ ;
						}
					$totalP = ($total/$count)*100;	
					}
						$res = array();
						$res['name'] = $row->ShortName;
						$res['count'] =round( $totalP,2);
						$data['chartdata5'][] = $res;
				}
			}
		///////////  GETTING LIST OF MONTHLY ABSENT DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$total =0; $totalP =0;
					$sql1 = "SELECT  *  FROM AttendanceMaster where OrganizationId=? and  (Month(AttendanceDate)=Month(curdate())) and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and Is_Delete=0 and DOL='0000-00-00' $emptable) and (AttendanceDate between ? and ?) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $orgid,$startdate,$enddate));
					$count=$query1->rowCount();
					if($count>0){
						while($row1 = $query1->fetch())
						{
							if($row1->AttendanceStatus ==2)
							$total++ ;
						}
					$totalP = ($total/$count)*100;	
					}

						$res = array();
						$res['name'] = $row->ShortName;
						$res['count'] = round( $totalP,2);
						$data['chartdata6'][] = $res;
				}
			}

		///////////  GETTING LIST OF NUMBER OF EMPLOYEE IN WORK HOURS DAILY  ////////////////////
		/*	$temparr=array();
			$sql = "Select HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? GROUP BY HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak)))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{

				while($row= $query->fetch()){
					if($row->totaltime < 0)
					{
						$totalhour =24 - $row->totalhour;
					}else{
						$totalhour = $row->totalhour;
					}

					$sql1 ="Select count(Id) as totalcount from EmployeeMaster where OrganizationId=? and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $orgid, $totalhour ));
					while($row1 = $query1->fetch())
					{
						$res = array();
						$res['name'] = $totalhour .' hr';
						//$totalmin = ($row->totalmin/60)*100;
						$res['count'] = $row1->totalcount;//.".".$totalmin;
						$temparr[] = $res;
					}
				}
				$temparr=array_unique($temparr,SORT_REGULAR);
				for($i=0;$i<count($temparr);$i++)
				{
					$data['chartdata7'][]=$temparr[$i];
				}

			}
		*/

			$temparr=array();
			$sql = "Select HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? and Id in (Select Shift From EmployeeMaster where Id in ($ids) ) GROUP BY HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak)))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				$temp=array(); $temp1=array();
				while($row= $query->fetch()){
					if($row->totaltime < 0)
					{
						$totalhour =24 - $row->totalhour;
					}else{
						$totalhour = $row->totalhour;
					}
					$res = array();
					$res['name'] = $totalhour .' hr';
					$sql1 ="Select DISTINCT WorkingDays  from EmployeeMaster where OrganizationId=? and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $orgid, $totalhour ));
					$totalcount=0; 
					while($row1 = $query1->fetch())
					{
						$workingdays=0;
						$workingdays=$row1->WorkingDays;
						$workingdays=substr_count($workingdays, '1');
						$halfdays=	substr_count($row1->WorkingDays, '2');
						$workingdays=$workingdays+($halfdays * 0.5);
						$temp[] = $workingdays;
						$temp1[] = $workingdays.' days';
						$sql2="select count(Id) as totalcount from EmployeeMaster where LENGTH(WorkingDays) - LENGTH(REPLACE(WorkingDays, '1', '')) = ? and OrganizationId=? and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?) $emptable";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $workingdays,$orgid, $orgid, $totalhour ));
						while($r=$query2->fetch())
						{

							$res[$workingdays] = $r->totalcount;
						}

					}
					//$temp=array_unique($temp,SORT_REGULAR);

					$temparr[] = $res;
				}
				$temp=array_unique($temp);
				$temp1=array_unique($temp1);
				$data['chartdata7']['ykeys']=$temp;
				$data['chartdata7']['labels']=$temp1;
				$temparr=array_unique($temparr,SORT_REGULAR);
				$data['chartdata7']['data']=$temparr;

			}
		///////////  GETTING LIST OF WORK HOURS SHIFT WISE  ////////////////////

			$sql = "SElect Id, Name, HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour , MINUTE(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn),TIMEDIFF(TimeOutBreak, TimeInBreak))) as totalmin,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? and Id in (Select Shift From EmployeeMaster where Id in ($ids) )";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$res = array();
					$res['name'] = $row->Name;

					if($row->totaltime < 0){
						$res['count'] =24 - $row->totalhour;
					}else{
					//$totalmin = ($row->totalmin/60)*100;
						$res['count'] = $row->totalhour;//.".".$totalmin;
					}
					$data['chartdata8'][] = $res;
				}
			}
		///////////  GETTING LIST OF MONTHLY OVERTIME DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$total =0;
					$sql1 = "SELECT  HOUR(sec_to_time(sum(time_to_sec(overtime)))) as totalcount FROM AttendanceMaster where OrganizationId=? and  (Month(AttendanceDate)=Month(curdate()))  and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and Is_Delete=0 and DOL='0000-00-00' and Is_Delete=0 $emptable) and (AttendanceDate between ? and ?) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $orgid,$startdate,$enddate));
					if($query1->rowCount()>0){
						$row1 = $query1->fetch();
						$total = $row1->totalcount;

					}
						$res = array();
						$res['name'] = $row->ShortName;
						$res['count'] = $total;
						$data['chartdata9'][] = $res;
						//echo $total;
				}
			}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$curmonth=date('F');
		$result["data"] =$data;
		$result["curmonth"] =$curmonth;
		$result['status']=$status;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	/*
	*	LEAVE TAB DASHBOARD 1
	*	FETCH DATA FOR TODAYS LEAVE DASHBOARD
	*/
	public function getLeaveDashboard1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		$data['leavetype'] = array();
		$data['teamleave'] = array();
		$data['leaveutilized'] = array();
		$data['employeeonleave'] = array();
		$data['financialyear'] = array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];
		//$this->GenerateLeaveHistory($orgid);
		//$fid = Utils::getFiscalId(date("Y-m-d"),$this->db);
		$date = isset($_POST['monthview'])?$_POST['monthview']:"";

		$date = ($date=="")?date("Y-m-01"):$date;
		$lastday = date("Y-m-t", strtotime($date));

		//////////////////// GETTING CURRENT FINANCIAL YEAR //////////////////
		$fiscaldate="";
		$fstart = date("Y-04-01");
		//$enddate =  date("Y-m-d");
		$fend =date("Y-03-t", strtotime("+1 year ".date($fstart)));

		try{
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$fstart=$row->StartDate; 
					$fend=$row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=true;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$fstart=$row->StartDate; 
					$fend=$row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=true;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$fstart=$row->StartDate; 
					$fend=$row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;

				}
			}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		//////////////  EMPLOYEE ON LEAVE DIVISION WISE FOR THE CURRENT FISCAL YEAR   ///////////////////////
		$sql = "SELECT Id, Name, ShortName, Code from DivisionMaster where OrganizationId=? and ArchiveSts=0";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
			while($row = $query->fetch())
			{
				$res = array();
				$res['label'] = $row->ShortName;
				$emptotal=0;
				$sql1 = "SELECT EmployeeId,count(DISTINCT EmployeeId) as totalcount FROM EmployeeLeaveChild E, EmployeeLeave L where L.Id = E.EmployeeLeaveId and leaveDay between '$fstart' and '$fend' and EmployeeId in (Select Id from EmployeeMaster where Division=? and OrganizationId=? and Is_Delete=0) and (Month(LeaveDay)=Month(curdate())) ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id, $orgid ));
				while($row1 = $query1->fetch())
				{
					$emptotal= $row1->totalcount;
				}
				$res['value'] = $emptotal;
				$data['employeeonleave'][] = $res;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		//////////////  EMPLOYEE LEAVE UTILIZATION MONTHLY FOR THE CURRENT FISCAL YEAR   ///////////////////////

		$sql = "SELECT Id, StartDate, EndDate from FiscalMaster where OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
			while($row = $query->fetch())
			{

				$emptotal=0;
				$strt = $row->StartDate;
				$end = $row->EndDate;
				while(date($strt)<=date($end))
				{
					$res = array();
					$res['label'] = date("F", strtotime($strt));
					$paid =0;$unpaid=0;
					$endtemp = date("Y-m-t", strtotime(date($strt)));
					$sql1 = "SELECT count(EmployeeId) as totalcount FROM EmployeeLeaveChild E, EmployeeLeave L where L.Id = E.EmployeeLeaveId and OrganizationId=? and LeaveDay between '$strt' and '$endtemp' and LossOfPay=0 ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid ));
					while($row1 = $query1->fetch())
					{
						$paid = $row1->totalcount;
					}
					$sql1 = "SELECT count(EmployeeId) as totalcount FROM EmployeeLeaveChild E, EmployeeLeave L where L.Id = E.EmployeeLeaveId and OrganizationId=? and leaveDay between '$strt' and '$endtemp' and LossOfPay=1 ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid ));
					while($row1 = $query1->fetch())
					{
						$unpaid = $row1->totalcount;
					}

					$res['paidleave'] = $paid;
					$res['unpaidleave'] = $unpaid;

					$data['leaveutilized'][] = $res;
					$strt = date("Y-m-d", strtotime("+1 month,".date($strt)));
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		//////////////  GETTING LIST OF LEAVE TYPE AVAILABLE IN ORGANIZATION  ////////////////////////////////
        $sql = "SELECT Name, LeaveDays, LeaveColor from LeaveMaster where OrganizationId=? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['label'] = $row->Name;
				$res['value'] = $row->LeaveDays;
				$res['color'] = $row->LeaveColor;

				$data['leavetype'][] = $res;
			}
        }

		$sWhere = "";
		$sts=$_SESSION['ubihrm_user_sts'];
		if($sts!=1){
			//$ids = Utils::getReportingIds($userid, $this->db);
			//$sWhere = " and EmployeeId in ($ids) ";
		}

		while(date($date)<=$lastday){
			// fetch leave of all junior with status approved or pending

			$sql = "SELECT EmployeeId, LeaveFrom, LeaveTo, LeaveStatus from EmployeeLeave where LeaveStatus in (2,3) and  OrganizationId=?  and ('$date' between LeaveFrom and LeaveTo) $sWhere";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $orgid));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['label'] = Utils::getEmployeeName($row->EmployeeId, $this->db);  
					$res['from'] = $date;
					$res['to'] = $date;
					$backcolor='#00a65a';
					if($row->LeaveStatus==2){
						if(date($date)<=date("Y-m-d"))
							$backcolor='#337ab7';
						else
							$backcolor='#00a65a';
					}elseif($row->LeaveStatus==3){
						$backcolor='#f0ad4e';
					}
					$res['backcolor'] = $backcolor;
					$data['teamleave'][] = $res;
				}
			}
			$date = date("Y-m-d", strtotime("$date, +1 day"));
		}

		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($fstart)))." - ".date("M'y", strtotime(date($fend))));
		$result["curmonth"] =$curmonth;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function getLeaveReportingDashboard($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['leavetype'] = array();
		$data['teamleave'] = array();
		$data['leaveutilized'] = array();
		$data['employeeonleave'] = array();
		$data['financialyear'] = array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];
		$ids = Utils::getReportingIds($userid, $this->db);
		//$fid = Utils::getFiscalId(date("Y-m-d"),$this->db);
		$date = isset($_POST['monthview'])?$_POST['monthview']:"";

		$date = ($date=="")?date("Y-m-01"):$date;
		$lastday = date("Y-m-t", strtotime($date));

		//////////////////// GETTING CURRENT FINANCIAL YEAR //////////////////
		$fiscaldate="";
		$fstart = "";
		//$enddate =  date("Y-m-d");
		$fend ="";

        try{
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$fstart=$row->StartDate; 
					$fend=$row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$fstart=$row->StartDate; 
					$fend=$row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$fstart=$row->StartDate; 
					$fend=$row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;

				}
			}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		//////////////  EMPLOYEE ON LEAVE DIVISION WISE FOR THE CURRENT FISCAL YEAR   ///////////////////////
		$sql = "SELECT Id, Name, ShortName, Code from DivisionMaster where OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids))";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
			while($row = $query->fetch())
			{
				$res = array();
				$res['label'] = $row->ShortName;
				$emptotal=0;

				$sql1 = "SELECT EmployeeId,count(DISTINCT EmployeeId) as totalcount FROM EmployeeLeaveChild E, EmployeeLeave L where L.Id = E.EmployeeLeaveId and leaveDay between '$fstart' and '$fend' and EmployeeId in (Select Id from EmployeeMaster where Division=? and OrganizationId=? and Is_Delete=0) and (Month(LeaveDay)=Month(curdate())) and EmployeeId in ($ids)";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id, $orgid ));
				while($row1 = $query1->fetch())
				{
					$emptotal= $row1->totalcount;
				}
				$res['value'] = $emptotal;
				$data['employeeonleave'][] = $res;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		//////////////  EMPLOYEE LEAVE UTILIZATION MONTHLY FOR THE CURRENT FISCAL YEAR   ///////////////////////

		$sql = "SELECT Id, StartDate, EndDate from FiscalMaster where OrganizationId=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid));
			$count =  $query->rowCount();
			while($row = $query->fetch())
			{

				$emptotal=0;
				$strt = $row->StartDate;
				$end = $row->EndDate;
				while(date($strt)<=date($end))
				{
					$res = array();
					$res['label'] = date("F", strtotime($strt));
					$paid =0;$unpaid=0;
					$endtemp = date("Y-m-t", strtotime(date($strt)));
					$sql1 = "SELECT count(EmployeeId) as totalcount FROM EmployeeLeaveChild E, EmployeeLeave L where L.Id = E.EmployeeLeaveId and OrganizationId=? and LeaveDay between '$strt' and '$endtemp' and LossOfPay=0 and L.EmployeeId in ($ids)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid ));
					while($row1 = $query1->fetch())
					{
						$paid = $row1->totalcount;
					}
					$sql1 = "SELECT count(EmployeeId) as totalcount FROM EmployeeLeaveChild E, EmployeeLeave L where L.Id = E.EmployeeLeaveId and OrganizationId=? and leaveDay between '$strt' and '$endtemp' and LossOfPay=1 and L.EmployeeId in ($ids)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid ));
					while($row1 = $query1->fetch())
					{
						$unpaid = $row1->totalcount;
					}

					$res['paidleave'] = $paid;
					$res['unpaidleave'] = $unpaid;

					$data['leaveutilized'][] = $res;
					$strt = date("Y-m-d", strtotime("+1 month,".date($strt)));
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		//////////////  GETTING LIST OF LEAVE TYPE Visible To Employees ////////////////////////////////
        $sql = "SELECT Name, LeaveDays, LeaveColor from LeaveMaster where OrganizationId=? and  VisibleSts=1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['label'] = $row->Name;
				$res['value'] = $row->LeaveDays;
				$res['color'] = $row->LeaveColor;

				$data['leavetype'][] = $res;
			}
        }

		$sWhere = " and EmployeeId in ($ids) ";

		while(date($date)<=$lastday){
			// fetch leave of all junior with status approved or pending

			$sql = "SELECT EmployeeId, LeaveFrom, LeaveTo, LeaveStatus from EmployeeLeave where LeaveStatus in (2,3) and  OrganizationId=?  and ('$date' between LeaveFrom and LeaveTo) $sWhere";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $orgid));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['label'] = Utils::getEmployeeName($row->EmployeeId, $this->db);  
					$res['from'] = $date;
					$res['to'] = $date;
					$backcolor='#00a65a';
					if($row->LeaveStatus==2){
						if(date($date)<=date("Y-m-d"))
							$backcolor='#337ab7';
						else
							$backcolor='#00a65a';
					}elseif($row->LeaveStatus==3){
						$backcolor='#f0ad4e';
					}
					$res['backcolor'] = $backcolor;
					$data['teamleave'][] = $res;
				}
			}
			$date = date("Y-m-d", strtotime("$date, +1 day"));
		}

		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($fstart)))." - ".date("M'y", strtotime(date($fend))));
		$result["curmonth"] =$curmonth;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	/*
	*	LEAVE TAB DASHBOARD 2
	*	FETCH DATA FOR AVERAGE LEAVE PER MONTH GRAPH DASHBOARD
	*/
	public function getLeaveDashboard2($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $request[1];

        $sql = "SELECT EmployeeId from EmployeeLeave where OrganizationId=? and (curdate() between LeaveFrom and LeaveTo) Limit 7";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['name'] = Utils::getEmployeeName($row->EmployeeId, $this->db);  

				$data[] = $res;
			}
        }

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	/*
	*	SALARY TAB DASHBOARD
	*	FETCH DATA FOR SALARY DASHBOARD
	*/
	public function getSalaryDashboard1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['salarygroup']= array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
			//////////////////// GETTING CURRENT FINANCIAL YEAR //////////////////
			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();	
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}	
			}	
			elseif($type=="previous")
			{
			$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
				$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
				///////////////// LIST THE EMPLOYEE SALARY RANGE ////////////////////////
			$keyarr= array("0","0","0","0","0","0","0");
			$label= array('Below 5K', '5K to 10K', '10K to 15K', '15K to 20K', '20K to 30K', '30K to 50K', 'Above 50K' );
			$sql1 ="SELECT EmployeeCTC FROM EmployeeMaster where OrganizationId=? and Is_Delete=0 and DOL='0000-00-00'  order by EmployeeCTC";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid));
			while($row1 = $query1->fetch())
			{
				if($row1->EmployeeCTC<=5000){
				$keyarr[0] = $keyarr[0]+1;
				}elseif($row1->EmployeeCTC>5000 && $row1->EmployeeCTC<=10000){
				$keyarr[1] = $keyarr[1]+1;
				}elseif($row1->EmployeeCTC>10000 && $row1->EmployeeCTC<=15000){
				$keyarr[2] = $keyarr[2]+1;
				}elseif($row1->EmployeeCTC>15000 && $row1->EmployeeCTC<=20000){
				$keyarr[3] = $keyarr[3]+1;
				}elseif($row1->EmployeeCTC>20000 && $row1->EmployeeCTC<=30000){
				$keyarr[4] = $keyarr[4]+1;
				}elseif($row1->EmployeeCTC>=30000 && $row1->EmployeeCTC<=50000){
				$keyarr[5] = $keyarr[5]+1;
				}elseif($row1->EmployeeCTC>50000){
				$keyarr[6] = $keyarr[6]+1;
				}
			}
			for($i=0; $i<count($label); $i++)
			{
				$res = array();
				$res["value"] = $keyarr[$i];
				$res['label'] =$label[$i];
				$data['salarygroup']['data'][] = $res;
			}
		}catch(PDOException $e)
		{

			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getSalaryDashboard2($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['salarytype'] = array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";

			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
			//////////////////// GETTING CURRENT FINANCIAL YEAR //////////////////
			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}

			///////////////// GETTING LIST OF SALARY BREAKDOWNS ///////////////
			$sql = "SELECT Id, Name, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			if($query->rowCount()>0)
			{

				while($row = $query->fetch())
				{
					$res = array(); $keys=array(); $label=array();
					$res['division'] = $row->ShortName;
					$amount=0; $balance=0; 
					$sql1 = "SELECT  Id,Name FROM SalaryTypeMaster where OrganizationId=? order by Name";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($orgid ));
					$count =  $query1->rowCount();
					if($count>=1)
					{
						while($row1 = $query1->fetch())
						{
							$salarytype=$row1->Id;
							$keys[] = $salarytype;
							$label[] = $row1->Name;

							$sql2 = "SELECT  Count(Bankaccount) as totalcount FROM EmployeeMaster where Bankaccount=? and Division=? and OrganizationId =?";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array($salarytype ,$row->Id ,$orgid ));
							if($r1=$query2->fetch())
							{
								$balance+=$r1->totalcount;
								$res[$salarytype] = $r1->totalcount;
							}
						}
					}
					$temparr[] = $res;
				}
				$data['salarytype']['ykeys']=$keys;
				$data['salarytype']['labels']=$label;
				$data['salarytype']['data']=$temparr;
			}	
		}catch(PDOException $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function getSalaryDashboard21($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['salarytype'] = array();

		$userid = $request[0];
		$orgid = $request[1];

		$fid = $filscalid=$_SESSION['ubihrm_fiscalid'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$emptable = "";
		$nonemptable = "";
		$notification="";
		if($sts==1 || $hrsts==1){
			$emptable = " and  DOL='0000-00-00' ";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
			$nonemptable = " and EmployeeId in ($ids)";
			$notification = " and CreatedById in ($ids)";
		}

		//////////////////// GETTING CURRENT FINANCIAL YEAR //////////////////
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");
		$this->db->beginTransaction();	
		try{
		///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $filscalid ));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;
			$res = array();
			$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
			$res['name'] = $fiscaldate;
			$data['financialyear'][] = $res;
		}
		///////////////// GETTING LIST OF SALARY BREAKDOWNS ///////////////
		$sql = "SELECT Id, Name FROM SalaryTypeMaster where OrganizationId=? order by Name";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$keyarr= array();
			$label= array();$ykey="";
			while($row = $query->fetch())
			{
				$res = array();
				$sql1 ="SELECT SalaryId, SalaryPercent, Name, SalaryHeadId FROM SalaryTypeChild sc, SalaryHead sh where sh.Id=sc.SalaryHeadId and SalaryId=?  order by SalaryId, Name";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id ));
				while($row1 = $query1->fetch())
				{
					$res[$row1->SalaryHeadId] = $row1->SalaryPercent;
					if($ykey==""){
						$keyarr[] = $row1->SalaryHeadId;
						$label[] = $row1->Name;
					}
				}
				$ykey="no";
				$res['name'] = $row->Name;
				$data['salarytype']['data'][] = $res;

			}
			$data['salarytype']['ykey']=$keyarr;
			$data['salarytype']['label']=$label;
        }
	}catch(PDOException $e)
		{		
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function getSalaryDashboard3($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['compansation'] = array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
			//////////////////// GETTING CURRENT FINANCIAL YEAR //////////////////
			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
			///////////////// GETTING LIST OF TOTAL COMPANSETION FOR CURRENT FISCAL YEAR ///////////////
			$currentsalmonth=$this->getCurrentSalaryMonth();
			$stdate = $startdate;
			while(date($stdate) <= date($enddate))
			{
				$res = array();
				$res['month'] = date("F", strtotime(date($stdate)));
				$head1=0; $head2=0;$deduct1=0;$deduct2=0;

				/*while($row = $query->fetch())
				{
					$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId = ? and HeadAddDeduct in (2,4) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));
					while($row1 = $query1->fetch())
					{
						$head1 += $row1->hdamnt;
					}
					$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId = ? AND HeadAddDeduct =3 ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));
					while($row1 = $query1->fetch())
					{
						$deduct1 += $row1->hdamnt;
					}
					///USE HeadId=5,FOR EMPLOYEE INCENTIVE/////////////
					$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId = ? AND HeadAddDeduct =1 and HeadId=5";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));
					while($row1 = $query1->fetch())
					{
						$head2 += $row1->hdamnt;
					}
					$sql1 = "SELECT sum(HeadAmount) as hdamnt from  	SalaryChild  where SalaryId = ? AND HeadAddDeduct =0 ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));
					while($row1 = $query1->fetch())
					{
						$deduct2 += $row1->hdamnt;
					}
				}*/
				////////FIND OUT FIXED PAY WHICH IS GAURANTEED PAY FOR A PERTICULAR MONTH///////////
				$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId in (SELECT Id From SalaryMaster WHERE SalaryMonth=? and SalaryMonth<='$currentsalmonth' and OrganizationId=?) and HeadType=1 and HeadAddDeduct =4 ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $stdate, $orgid ));
				while($row1 = $query1->fetch())
				{
					$head1 += $row1->hdamnt;
				}
				////////FIND OUT INCENTIVE PAY WHICH IS VARIABLE PAY FOR A PERTICULAR MONTH///////////
				$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId in (SELECT Id From SalaryMaster WHERE SalaryMonth=? and SalaryMonth<='$currentsalmonth' and OrganizationId=?) AND HeadType=2 AND HeadAddDeduct =1 AND HeadId=5";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $stdate, $orgid));
				while($row1 = $query1->fetch())
				{
					$head2 += $row1->hdamnt;
				}

				$res['fixpay'] = $head1;
				$res['variablepay'] = $head2;//-$deduct2;
				$data['compansation']['data'][] = $res;		
				$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
			}
		}catch(PDOException $e)
		{

			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getSalaryDashboard4($request)
    {

		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['monthlypayroll']= array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
			$currentsalmonth=$this->getCurrentSalaryMonth();
			//////////////////// GETTING CURRENT FINANCIAL YEAR 

			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
			///////////////// GETTING LIST OF MONTHLY PAYROLL FOR CURRENT FISCAL YEAR ///////////////
			$stdate = $startdate;
			while(date($stdate) <= date($enddate))
			{
				$total=0;
				$sql = "SELECT sum(EmployeeCTC) as totalpayroll, SalaryMonth FROM SalaryMaster WHERE OrganizationId=? AND SalaryMonth=? and SalaryMonth<='$currentsalmonth' GROUP BY SalaryMonth";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $stdate ));
				$count =  $query->rowCount();
				if($count>=1)
				{
					while($row = $query->fetch())
					{
						$total=$row->totalpayroll;
					}
				}
				$res = array();
				$res['division'] = date("F", strtotime(date($stdate)));
				$res['payroll'] = round($total);	
				$data['monthlypayroll']['data'][] = $res;
				$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
			}
		}catch(PDOException $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getSalaryDashboard5($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['divisionloan']= array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
				$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
			///////////////// GETTING LIST OF PERSONAL LOAN FOR CURRENT FISCAL YEAR BY DIVISION ///////////////
			$sql = "SELECT Id, Name, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				$amount=0; $balance=0;
				$sql1 = "SELECT Id, AdvanceAmount,EmployeeId FROM SalaryAdvance WHERE LeaveStatus=2 and OrganizationId=? AND FiscalId=? and EmployeeId in (Select Id from EmployeeMaster where Division =? )";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $fid, $row->Id ));
				$count =  $query1->rowCount();
				if($count>=1)
				{
					while($row1 = $query1->fetch())
					{
						$amount = $amount + $row1->AdvanceAmount;
						$amt = Utils::getOutstandingLoanAmount($row1->EmployeeId,$row1->Id, $orgid, $this->db);
						$balance = $balance + $amt;
					}
				}
				$res = array();
				$res['division'] = $row->ShortName;
				$res['loanamount'] = $amount;	
				$res['balanceamount'] = $balance;
				$data['divisionloan']['data'][] = $res;
			}
		}catch(PDOException $e)
		{

			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getSalaryDashboard6($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['divisionincrement']= array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
				$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}

			///////////////// GETTING LIST OF SALARY INCREMENT FOR CURRENT FISCAL YEAR BY DIVISION ///////////////
			$sql = "SELECT Id, Name, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			if($query->rowCount()>0)
			{
				while($row = $query->fetch())
				{
					$oldvalue=0; $newvalue=0; $con=0;
					$sql1 = "SELECT count(EmployeeId) as empcount, sum(OldValue) as oldvalue ,sum(NewValue) as newvalue FROM JobModificationMaster j,JobModificationChild jc where j.Id=jc.JobId and OrganizationId=? and PromotionType in (1,3) and FieldName='EmployeeCTC' and EmployeeId in (Select Id from EmployeeMaster where Division = ? and OrganizationId=? and Is_Delete=0 and DOL='0000-00-00') AND (ApplyFrom between ? and ?) AND ApplySts=1"; 
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid,  $row->Id, $orgid, 	$startdate,$enddate ));
					$count =  $query1->rowCount();
					if($count>=1)
					{
						while($row1 = $query1->fetch())
						{
							$oldvalue = $row1->oldvalue;
							$newvalue =  $row1->newvalue;
							$con =  $row1->empcount;
						}
					}
					$res = array();
					$res['division'] = $row->ShortName;
					$res['increment'] = $newvalue-$oldvalue;	
					$res['count'] = $con;	
					$data['divisionincrement']['data'][] = $res;
				}
			}
		}catch(PDOException $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getSalaryDashboard7($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['monthlyovertime']= array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
				$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
			///////////////// GETTING LIST OF MONTHLY OVERTIME FOR CURRENT 	FISCAL YEAR ///////////////
			//$currentsalmonth=$this->getCurrentSalaryMonth();
			$stdate = $startdate;
			while(date($stdate) <= date($enddate))
			{
				$total=0;
				$sql = "SELECT sum(OvertimeAmount) as totalpayroll FROM EmployeeOvertime WHERE  OrganizationId=? AND ApplyDate=? ";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $stdate ));
				$count =  $query->rowCount();
				if($count>=1)
				{
					while($row = $query->fetch())
					{
						$total += $row->totalpayroll;
					}
				}
				$res = array();
				$res['months'] = date("F", strtotime(date($stdate)));
				$res['overtime'] = $total;	
				$data['monthlyovertime']['data'][] = $res;
				$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
			}
		}catch(PDOException $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getSalaryDashboard8($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['monthlyincentive']= array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
				$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
				$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
			///////////////// GETTING TOTAL INCENTIVE FOR CURRENT FISCAL YEAR BY DIVISION ///////////////
			$sql = "SELECT Id, Name, ShortName FROM DivisionMaster WHERE 		OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			if($query->rowCount()>0)
			{
				while($row = $query->fetch())
				{
					$amount=0; $balance=0;
					$sql1 = "SELECT  IncentiveAmount FROM EmployeeIncentive WHERE  OrganizationId=?  and EmployeeId in (Select Id from EmployeeMaster where Division =? and Is_Delete=0 ) AND ApplyDate between ? and ? and MONTH(ApplyDate)=MONTH(CURDATE())";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid,  $row->Id,$startdate,$enddate ));
					$count =  $query1->rowCount();
					if($count>=1)
					{
						while($row1 = $query1->fetch())
						{
							$amount = $amount + $row1->IncentiveAmount;
							//$amt = Utils::getOutstandingLoanAmount($row1->Id, 	$orgid, $this->db);
							//$balance = $balance + $amt;
						}
					}
					$res = array();
					$res['division'] = $row->ShortName;
					$res['incentive'] = $amount;	
					$data['monthlyincentive']['data'][] = $res;
				}
			}	
		}catch(PDOException $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getSalaryDashboard9($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['monthlycompensation']= array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}
			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
			$this->db->beginTransaction();
			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";

					return $result;

				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";

					return $result;

				}

			}
			else{
				$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
			///////////////// GETTING LIST OF MONTHLY COMPENSATION FOR CURRENT FISCAL YEAR ///////////////
			$stdate = $startdate;
			while(date($stdate) <= date($enddate))
			{
				$total=0;
				$sql = "SELECT sum(TotalCompansation) as totalcomp FROM BenefitCompansationMaster WHERE  OrganizationId=? AND BenCompMonth=? ";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $stdate ));
				$count =  $query->rowCount();
				if($count>=1)
				{
					while($row = $query->fetch())
					{
						$total += $row->totalcomp;
					}
				}
				$res = array();
				$res['months'] = date("F", strtotime(date($stdate)));
				$res['compensation'] = $total;	
				$data['monthlycompensation']['data'][] = $res;
				$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
			}
		}catch(PDOException $e)
		{

			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result["curmonth"] =$curmonth;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	/*
	*	SALARY TAB DASHBOARD
	*	FETCH DATA FOR SALARY DASHBOARD
	*/

	public function getSalaryReportingDashboard($request,$val)
    {

		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['financialyear'] = array();
		$data['lastsalarymonth'] = array();
		$data['lastincentivemonth'] = array();
		$data['salaryheads'] = array();
		$data['salarytype'] = array();
		$data['salarygroup']= array();
		$data['monthlypayroll']= array();
		$data['divisionloan']= array();
		$data['divisionincrement']= array();
		$data['monthlyovertime']= array();
		$currentsalmonth=$this->getCurrentSalaryMonth();
		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$fid = $filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];
		try{
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			$emptable = "";
			$nonemptable = "";
			$notification="";

			$ids = Utils::getReportingIds($userid, $this->db);
			$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
			$nonemptable = " and EmployeeId in ($ids)";
			$notification = " and CreatedById in ($ids)";

			/*$ids = Utils::getReportingIds($userid, $this->db);
			$sts=$_SESSION['ubihrm_user_sts'];
			$sWhere = "";
			if($sts==1){
				$sWhere = " and  DOL='0000-00-00' ";
			}else{
				$sWhere = " and Id in ($ids) and  DOL='0000-00-00'  ";
			}*/

			//////////////////// GETTING CURRENT FINANCIAL YEAR //////////////////
			$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
			$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));

			///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
			$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		///////////////// LIST THE EMPLOYEE SALARY RANGE ////////////////////////
		if($val==11){
			$keyarr= array("0","0","0","0","0","0","0");
			$label= array('Below 5K', '5K to 10K', '10K to 15K', '15K to 20K', '20K to 30K', '30K to 50K', 'Above 50K' );
			$sql1 ="SELECT EmployeeCTC FROM EmployeeMaster where OrganizationId=? and DOL='0000-00-00' and Is_Delete=0 $emptable  order by EmployeeCTC";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid));
			while($row1 = $query1->fetch())
			{

				if($row1->EmployeeCTC<=5000){
					$keyarr[0] = $keyarr[0]+1;
				}elseif($row1->EmployeeCTC>5000 && $row1->EmployeeCTC<=10000){
					$keyarr[1] = $keyarr[1]+1;
				}elseif($row1->EmployeeCTC>10000 && $row1->EmployeeCTC<=15000){
					$keyarr[2] = $keyarr[2]+1;
				}elseif($row1->EmployeeCTC>15000 && $row1->EmployeeCTC<=20000){
					$keyarr[3] = $keyarr[3]+1;
				}elseif($row1->EmployeeCTC>20000 && $row1->EmployeeCTC<=30000){
					$keyarr[4] = $keyarr[4]+1;
				}elseif($row1->EmployeeCTC<=30000 && $row1->EmployeeCTC<=50000){
					$keyarr[5] = $keyarr[5]+1;
				}elseif($row1->EmployeeCTC>50000){
					$keyarr[6] = $keyarr[6]+1;
				}

			}
			for($i=0; $i<count($label); $i++)
			{
				$res = array();
				$res["value"] = $keyarr[$i];
				$res['label'] =$label[$i];
				$data['salarygroup']['data'][] = $res;
			}

		}
		///////////////// GETTING LIST OF SALARY BREAKDOWNS ///////////////
		if($val==22){
		 $sql = "SELECT Id, Name, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			if($query->rowCount()>0)
			{

				while($row = $query->fetch())
				{
					$res = array(); $keys=array(); $label=array();
					$res['division'] = $row->ShortName;
					$amount=0; $balance=0; 
					$sql1 = "SELECT  Id,Name FROM SalaryTypeMaster where OrganizationId=? order by Name";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($orgid ));
					$count =  $query1->rowCount();
					if($count>=1)
					{
						while($row1 = $query1->fetch())
						{
							$salarytype=$row1->Id;
							$keys[] = $salarytype;
							$label[] = $row1->Name;

							$sql2 = "SELECT  Count(Bankaccount) as totalcount FROM EmployeeMaster where Bankaccount=? and Division=? and OrganizationId =?";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array($salarytype ,$row->Id ,$orgid ));
							if($r1=$query2->fetch())
							{
								$balance+=$r1->totalcount;
								$res[$salarytype] = $r1->totalcount;
							}
						}
					}
					$temparr[] = $res;
				}
				$data['salarytype']['ykeys']=$keys;
				$data['salarytype']['labels']=$label;
				$data['salarytype']['data']=$temparr;
			}	
		}
		///////////////// GETTING LIST OF TOTAL COMPANSETION FOR CURRENT FISCAL YEAR ///////////////
		if($val==33){
		$stdate = $startdate;
		while(date($stdate) <= date($enddate))
		{
			$res = array();
			$res['month'] = date("F", strtotime(date($stdate)));
			$head1=0; $head2=0;$deduct1=0;$deduct2=0;
			$sql ="SELECT Id From SalaryMaster WHERE SalaryMonth=? and SalaryMonth<='$currentsalmonth' $nonemptable and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $stdate, $orgid ));
			while($row = $query->fetch())
			{

				$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId = ? and HeadAddDeduct in (2,4) ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id ));
				while($row1 = $query1->fetch())
				{
					$head1 += $row1->hdamnt;
				}
				$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId = ? AND HeadAddDeduct =3 ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id ));
				while($row1 = $query1->fetch())
				{
					$deduct1 += $row1->hdamnt;
				}
				$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId = ? AND HeadAddDeduct =1 ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id ));
				while($row1 = $query1->fetch())
				{
					$head2 += $row1->hdamnt;
				}
				$sql1 = "SELECT sum(HeadAmount) as hdamnt from  SalaryChild  where SalaryId = ? AND HeadAddDeduct =0 ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id ));
				while($row1 = $query1->fetch())
				{
					$deduct2 += $row1->hdamnt;
				}
			}
			$res['fixpay'] = $head1-$deduct1;
			$res['variablepay'] = $head2-$deduct2;
			$data['compansation']['data'][] = $res;		

			$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
		}
		}
		///////////////// GETTING LIST OF MONTHLY PAYROLL FOR CURRENT FISCAL YEAR ///////////////

		if($val==44){
		$stdate = $startdate;
		while(date($stdate) <= date($enddate))
		{
			$total=0;

			$sql = "SELECT sum(EmployeeCTC) as totalpayroll, SalaryMonth FROM SalaryMaster WHERE OrganizationId=? AND SalaryMonth=? and SalaryMonth<='$currentsalmonth' $nonemptable GROUP BY SalaryMonth";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $stdate ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$total=$row->totalpayroll;
				}
			}

					$res = array();
					$res['division'] = date("F", strtotime(date($stdate)));
					$res['payroll'] = $total;	
					$data['monthlypayroll']['data'][] = $res;
			$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
		}
		}
		///////////////// GETTING LIST OF PERSONAL LOAN FOR CURRENT FISCAL YEAR BY DIVISION ///////////////
		if($val==55){
		$sql = "SELECT Id, Name, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids) and Is_Delete=0)";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			$amount=0; $balance=0;
			$sql1 = "SELECT Id, AdvanceAmount,EmployeeId FROM SalaryAdvance WHERE LeaveStatus=2 and OrganizationId=? AND FiscalId=? and EmployeeId in (Select Id from EmployeeMaster where Division =? and Is_Delete=0) $nonemptable";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $fid, $row->Id ));
			$count =  $query1->rowCount();
			if($count>=1)
			{

				while($row1 = $query1->fetch())
				{
					$amount = $amount + $row1->AdvanceAmount;
					$amt = Utils::getOutstandingLoanAmount($row1->EmployeeId,$row1->Id, $orgid, $this->db);
					$balance = $balance + $amt;
				}
			}
			$res = array();
			$res['division'] = $row->ShortName;
			$res['loanamount'] = $amount;	
			$res['balanceamount'] = $balance;
			$data['divisionloan']['data'][] = $res;
		}
		}
		///////////////// GETTING LIST OF SALARY INCREMENT FOR CURRENT FISCAL YEAR BY DIVISION ///////////////
		if($val==66){
		$sql = "SELECT Id, Name, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids) and Is_Delete=0)";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		if($query->rowCount()>0)
		{
			while($row = $query->fetch())
			{
				$oldvalue=0; $newvalue=0; $con=0;
				$sql1 = "SELECT count(EmployeeId) as empcount, sum(OldValue) as oldvalue ,sum(NewValue) as newvalue FROM JobModificationMaster j,JobModificationChild jc where j.Id=jc.JobId and OrganizationId=? and PromotionType=1 and FieldName='EmployeeCTC' and EmployeeId in (Select Id from EmployeeMaster where Division = ? and OrganizationId=? and DOL='0000-00-00' and Is_Delete=0) AND (ApplyFrom between ? and ?) AND ApplySts=1 $nonemptable"; 
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,  $row->Id, $orgid, $startdate,$enddate ));
				$count =  $query1->rowCount();
				if($count>=1)
				{

					while($row1 = $query1->fetch())
					{
						$oldvalue = $row1->oldvalue;
						$newvalue =  $row1->newvalue;
						$con =  $row1->empcount;

					}
				}
				$res = array();
				$res['division'] = $row->ShortName;
				$res['increment'] = $newvalue-$oldvalue;	
				$res['count'] = $con;	
				$data['divisionincrement']['data'][] = $res;
			}
		}

		}
		///////////////// GETTING LIST OF MONTHLY OVERTIME FOR CURRENT FISCAL YEAR ///////////////
		if($val==77){
		$stdate = $startdate;
		while(date($stdate) <= date($enddate))
		{
			$total=0;
			$sql = "SELECT sum(HeadAmount) as totalpayroll FROM SalaryMaster sm, SalaryChild sc WHERE sm.Id = sc.SalaryId and OrganizationId=? AND SalaryMonth=? and SalaryMonth<='$currentsalmonth' and HeadType=2 and HeadId=2 $nonemptable GROUP BY HeadType, HeadId";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $stdate ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$total += $row->totalpayroll;
				}
			}

			$res = array();
			$res['months'] = date("F", strtotime(date($stdate)));
			$res['overtime'] = $total;	
			$data['monthlyovertime']['data'][] = $res;

			$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
		}
		}
		///////////////// GETTING TOTAL INCENTIVE FOR CURRENT FISCAL YEAR BY DIVISION ///////////////
		if($val==88){
		$sql = "SELECT Id, Name, ShortName FROM DivisionMaster WHERE OrganizationId=? and ArchiveSts=0 and Id in (select Division from EmployeeMaster where Id in ($ids) and Is_Delete=0)";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		if($query->rowCount()>0)
		{
			while($row = $query->fetch())
			{
				$amount=0; $balance=0;
				$sql1 = "SELECT  IncentiveAmount FROM EmployeeIncentive WHERE  OrganizationId=?  and EmployeeId in (Select Id from EmployeeMaster where Division =? and Is_Delete=0 ) AND ApplyDate between ? and ? and MONTH(ApplyDate)=MONTH(CURDATE()) $nonemptable";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,  $row->Id,$startdate,$enddate ));
				$count =  $query1->rowCount();
				if($count>=1)
				{

					while($row1 = $query1->fetch())
					{
						$amount = $amount + $row1->IncentiveAmount;
						//$amt = Utils::getOutstandingLoanAmount($row1->Id, $orgid, $this->db);
						//$balance = $balance + $amt;
					}
				}
				$res = array();
				$res['division'] = $row->ShortName;
				$res['incentive'] = $amount;	
				$data['monthlyincentive']['data'][] = $res;
			}
		}	
		}
		///////////////// GETTING LIST OF MONTHLY COMPENSATION FOR CURRENT FISCAL YEAR ///////////////
		if($val==99){
		$stdate = $startdate;
		while(date($stdate) <= date($enddate))
		{
			$total=0;
			$sql = "SELECT sum(TotalCompansation) as totalcomp FROM BenefitCompansationMaster WHERE  OrganizationId=? AND BenCompMonth=? $nonemptable";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $stdate ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$total += $row->totalcomp;
				}
			}

			$res = array();
			$res['months'] = date("F", strtotime(date($stdate)));
			$res['compensation'] = $total;	
			$data['monthlycompensation']['data'][] = $res;

			$stdate = date('Y-m-d', strtotime("+1 month, ".date($stdate)));
		}
		}
		$curmonth=date('F');
		$result["data"] =$data;
		$result["curmonth"] =$curmonth;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result["currency"] =Utils::getcurrency();
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	///////////////// GET SELF SERVICE DASHBOARD CONTENT FOR ALL SECTION ON THAT PAGE /////////////////////

	public function getSelfServiceDashboard($arr)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();   
		$userid = $arr[0];
		$orgid = $arr[1];
		$data['attandance']= array(); 
		$data['leave']= array(); 
		$data['reportto']= array();
		$data['notification']= array(); 
		$data['approvals']= array(); 
		$data['forthcomingevents']= array();
		$data['leavesummary']= array();
		$data['colleagues']= array();
		$data['juniors']= array();
		$data['skillgap']= array();
		$data['empassessment']= array();
		$data['tasksheet']= array();
		try{
		//////////////////// GETTING CURRENT FINANCIAL YEAR //////////////////
		$startdate = date("Y-m-d");
		$enddate =  date("Y-m-d");    
		 $startdate1=date('Y-m-1');
		$enddate1=date("Y-m-t");
		$fiscalid=$_SESSION['ubihrm_fiscalid'];
		///////////////// GETTING LIST OF MONTH WISE NEW JOINNINGS OF EMPLOYEE ///////////////
		$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $fiscalid ));
		while($row = $query->fetch()){
			$startdate = $row->StartDate;
			$enddate =  $row->EndDate;

		}

		////////////////// SHOW THE TOTAL ATTENDANCE PERCENTAGE IN LINE GRAPH  ////////////////////
	$present =0;$absent =0;$leave =0;$total =0;$month=0;
		 $sql1 = "SELECT  * FROM AttendanceMaster where OrganizationId= ? and AttendanceStatus IN (1,2,6) and (AttendanceDate between ? and ?) and EmployeeId =? ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid,$startdate1,$enddate1 , $userid));
		$total = $query1->rowCount();
		//$sql = "SELECT AttendanceDate, count(if(AttendanceStatus=2,1,NULL)) as totalabsent,count(if(AttendanceStatus=6,1,NULL)) as totalleave, Count(Id) as countid, DAYOFMONTH(LAST_DAY(AttendanceDate)) as totalday FROM AttendanceMaster WHERE EmployeeId = ? And OrganizationId = ? And (AttendanceDate between '$startdate' and '$enddate')  group by DATE_FORMAT(AttendanceDate, '%Y-%m')";
		//$query = $this->db->prepare($sql);
	//	$query->execute(array( $userid, $orgid ));
	//	$count =  $query->rowCount();
		if($total > 0){
			while($row1 = $query1->fetch())
			{
				$res = array();
				$res['id'] = $row1->Id;
				$res['name'] = 'Present';
				$res['datefrom'] = $row1->AttendanceDate;
				$res['dateto'] = $row1->AttendanceDate;
				$res['timein'] = $row1->TimeIn;
				$res['timeout'] = $row1->TimeOut;
				$month=	date("M", strtotime($row1->AttendanceDate));
				if($row1->AttendanceStatus==2){
						 $absent++;
				}elseif($row1->AttendanceStatus==1){
						$present++;
				}
				elseif($row1->AttendanceStatus==6){
					$leave++; 
				}
						
							$data[] = $res;
			}
		}
		$res = array();
		$res['month'] = $month;		
		$res['totalpresent'] =$present;
		$res['totalabsent'] =$absent;
		$res['totalleave'] =$leave;						
		$data['attandance'][] = $res;

		//////////// SHOW TOTAL LEAVE TAKEN BY THE USER ////////////////

		/*$sql = "SELECT DATE_SUB(DATE_ADD(LAST_DAY(ApplyDate), INTERVAL 1 DAY),INTERVAL 1 MONTH) as monthview,  Count(Id) as countid,LeaveTypeId FROM EmployeeLeave WHERE EmployeeId = ? And OrganizationId = ? And  (ApplyDate between Date_sub(curdate(), Interval 6 month) and curdate())  group by DATE_FORMAT(ApplyDate, '%Y-%m')";
		$query = $this->db->prepare($sql);
		$query->execute(array( $userid, $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();	
					$res['leavetype'] = $this->getName($row->LeaveTypeId,'LeaveMaster');	
					//$res['month'] = $row->monthview;					
					$res['count'] = $row->countid;
					$data['leave'][] = $res;

				}
			}
		*/

		////////////  FETCH DEATILS OF REPORT TO OF LOGGED IN EMPLOYEE ////////////////////

		$sql = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and  Id =? and Is_Delete=0 ";
        $query = $this->db->prepare($sql);
		$query->execute(array($orgid,$userid));
		$count =  $query->rowCount();
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$image="";
				$reportingto = $row->ReportingTo;
				$sql1 = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and  Id =? and Is_Delete=0 ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid,$reportingto));
				while($row1 = $query1->fetch())
				{
					$res['name']=ucwords(strtolower($row1->FirstName." ".$row1->LastName));
					$image=$row1->ImageName;
					if($image != ""){
						$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
					}
					else{
						$gen=$row1->Gender;
						if($gen == 1){
							$res['image']= URL."public/avatars/male.png";
						}
						else{
							$res['image']= URL."public/avatars/female.png";
						}
					}

					$res['desig']=$this->getName($row1->Designation,'DesignationMaster');
					$data['reportto'][] = $res;
				}

			}
        }

		////////////  FETCH ALL NOTIFICATION OF THE LOGGED IN EMPLOYEE  //////////////////////

		/*$sql = "SELECT * FROM NotificationMaster WHERE OrganizationId = ? AND CURDATE() BETWEEN StartDate and EndDate ORDER BY NotificationPriority";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();					
					//$res['name'] = $row->Name;   
					//$res['time'] = date("H:i A", strtotime($row->CreatedDate)); 
					$res['id'] =Utils::encode5t($row->Id);		

					$res['message'] = $row->Message; 
					$res['employee'] =Utils::getEmployeeName($row->CreatedById, $this->db);
					$image =$this->getName($row->CreatedById,'EmployeeMaster', 'ImageName');
					if(!empty($image))
					{
						$image = URL."public/uploads/$orgid/$image";
						if(file_exists($image)){
							$image = URL."public/avatars/male.png";
						}
					}else{
						$image = URL."public/avatars/male.png";
					}
					$res['image']= $image."?img=" .rand(1,100);
					$res['priority'] = $row->NotificationPriority;						

					if($row->Division==0 && $row->Designation==0 && $row->Department==0 && $row->EmployeeIds==0){
						$data['notification'][] = $res;
					}else{
						$cond="and ";
						if($row->Division!=0){
							$cond .=" Division=".$row->Division." AND ";
						}
						if($row->Designation!=0){
							$cond .=" Designation=".$row->Designation." AND ";
						}
						if($row->Department!=0){
							$cond .=" Department=".$row->Department." AND ";
						}
						if($row->EmployeeIds!=0){
							$cond .=" Id in (".$row->EmployeeIds.") and ";
						}

						$cond = substr($cond, 0, -4);
						if($cond!="")
						{	
							$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and Id = ? $cond ";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($orgid,$userid));
							if($query1->rowCount()>0)
							{
								$data['notification'][] = $res;
							}
						}
					}

				}
			}*/
		////////////  FETCH ALL MILESTONE OF THE EMPLOYEE  ////////////////////////////////////

			$sql = "SELECT * from EmployeeHistory where EmployeeId=? and OrganizationId=? and EventDate between '$startdate' and '$enddate' and (Title not like '%Salary%' and Message not like '%Gross%') order by EventDate desc limit 2";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $userid, $orgid ));
				$date ="";
				while($row = $query->fetch())
				{

					if($date != date("dS M, Y", strtotime($row->EventDate)))
					{
						$res = array();
						$res['date'] = date("dS M, Y", strtotime($row->EventDate));
						$data[] = $res;
						$date = date("dS M, Y", strtotime($row->EventDate));
					}
					$res = array();
					$res['message'] =$row->Message;
					$res['title'] = $row->Title;
					$res['date'] = date("d M, Y", strtotime($row->EventDate));
					$data['notification'][] = $res;
				}

			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}

		////////////  FETCH ALL APPROVAL ITEM OF THE LOGGED IN EMPLOYEE  //////////////////////

		$sql = "SELECT * FROM GrievanceMaster WHERE OrganizationId = ? AND CreatedById=? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) and CreatedDate between '$startdate' and '$enddate' ";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid, $userid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();		
					$res['id'] =Utils::encode5t($row->Id);
					$res['type'] ="Grievance";						
					$res['name'] = "Grievance";  
					$res['time1'] = $row->LastModifiedDate; 
					$res['time'] = Utils::datetimeformatter($row->LastModifiedDate); 
					$res['message'] = "Your Grievance has been ".$this->getStatus($row->ApproveSts,'GrievanceStatus'); 
					//$res['priority'] = $this->getpriority($row->NotificationPriority);

					$data['approvals'][] = $res;

				}
			}
		$sql = "SELECT * FROM EmployeeLeave WHERE OrganizationId = ? AND EmployeeId=? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) and CreatedDate between '$startdate' and '$enddate'";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid, $userid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();	
					$res['id'] =Utils::encode5t($row->Id);
					$res['type'] ="Leave";					
					$res['name'] = "Leave Application";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
					$res['time1'] = $row->LastModifiedDate; 
					$res['time'] = Utils::datetimeformatter($row->LastModifiedDate);
					if($row->LeaveStatus == 3){
						$pendingapprover=$this->getApproversts($row->Id,3);	
						$approvedapprover=$this->getApproversts($row->Id,2);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);
						$approveapp=Utils::getEmployeeName($approvedapprover,$this->db);
						$res['message'] = "Approved by $approveapp, pending at $pendingapp";
						if($approveapp =="")
						$res['message'] = "pending at $pendingapp";
						}else{
						$res['message'] = "Your request for Leave  is ".$this->getStatus($row->LeaveStatus,'LeaveStatus'); 
					}					

					//$res['priority'] = $this->getpriority($row->NotificationPriority);

					$data['approvals'][] = $res;

				}
			}

		$sql = "SELECT * FROM Timeoff WHERE EmployeeId=? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) and CreatedDate between '$startdate' and '$enddate'";
        $query = $this->db->prepare($sql);
		$query->execute(array($userid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();	
					$res['id'] =$row->Id;
					$res['type'] ="time_off";					
					$res['name'] = "Timeoff Application";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
					$res['time1'] = $row->ModifiedDate; 
					$res['time'] = Utils::datetimeformatter($row->ModifiedDate);
					if($row->ApprovalSts == 3){
						$pendingapprover=$this->getApprovertimeoffsts($row->Id,3);	
						$approvedapprover=$this->getApprovertimeoffsts($row->Id,2);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);

						$approveapp=Utils::getEmployeeName($approvedapprover,$this->db);
						$res['message'] = "Approved by $approveapp, pending at $pendingapp";
						if($approveapp =="")
							$res['message'] = "pending at $pendingapp";

					}else{
						$res['message'] = "Your request for Timeoff  is ".$this->getStatus($row->ApprovalSts,'LeaveStatus'); 
					}					

					//$res['priority'] = $this->getpriority($row->NotificationPriority);

					$data['approvals'][] = $res;

				}
			}

		$sql = "SELECT * FROM SalaryAdvance WHERE OrganizationId = ? AND EmployeeId=? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) and CreatedDate between '$startdate' and '$enddate'";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid, $userid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();		
					$res['id'] =Utils::encode5t($row->Id);
					$res['type'] ="SalaryAdvance";	
					$res['name'] = "Personal Loan";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
					$res['time1'] = $row->LastModifiedDate; 
					$res['time'] = Utils::datetimeformatter($row->LastModifiedDate); 
					$res['message'] = "Your request for Personal Loan is ".$this->getStatus($row->LeaveStatus,'LeaveStatus'); 
					//$res['status'] = $this->getStatus($row->ApproverSts);

					$data['approvals'][] = $res;

				}
			}

		$sql = "SELECT * FROM DocumentReleaseMaster WHERE OrganizationId = ? AND EmployeeId=? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) and CreatedDate between '$startdate' and '$enddate'";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid, $userid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();	
					$res['id'] =Utils::encode5t($row->Id);
					$res['type'] ="DocumentRequest";	
					$res['name'] = "Document Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
					$res['time1'] = $row->LastModifiedDate; 
					$res['time'] = Utils::datetimeformatter($row->LastModifiedDate); 
					$res['message'] = "Your request for Document Release is ".$this->getStatus($row->ApproverSts,'LeaveStatus'); 
					//$res['status'] = $this->getStatus($row->ApproverSts);

					$data['approvals'][] = $res;

				}
			}
			$sql = "SELECT * FROM CertificateReleaseMaster WHERE OrganizationId = ? AND EmployeeId=? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) and CreatedDate between '$startdate' and '$enddate'";
			$query = $this->db->prepare($sql);
			$query->execute(array(  $orgid, $userid ));
			$count =  $query->rowCount();
				if($count>=1)
				{
					while($row = $query->fetch())
					{
						$res = array();	
						$res['id'] =Utils::encode5t($row->Id);
						$res['type'] ="certificaterequest";	
						$res['name'] = "Certificate Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
						$res['time1'] = $row->LastModifiedDate; 
						$res['time'] = Utils::datetimeformatter($row->LastModifiedDate); 
						if($row->ApproverSts==6){
							$sts="Issued";
						}else{
							$sts=$this->getStatus($row->ApproverSts,'LeaveStatus');
						}
						$res['message'] = "Your request for Certificate Release is ".$sts; 
						//$res['status'] = $this->getStatus($row->ApproverSts);

						$data['approvals'][] = $res;

					}
				}

				$sql = "SELECT * FROM SeveranceMaster WHERE OrganizationId = ? AND EmployeeId=? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) and CreatedDate between '$startdate' and '$enddate'";
				$query = $this->db->prepare($sql);
				$query->execute(array(  $orgid, $userid ));
				$count =  $query->rowCount();
					if($count>=1)
					{
						$status=true;
						while($row = $query->fetch())
						{
							$res = array();	
							$res['type'] ="severance";	
							$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
							$res['name'] = "Severance Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
							$res['time1'] = $row->LastModifiedDate; 
							$res['time'] = Utils::datetimeformatter($row->LastModifiedDate); 

							$sts=$this->getStatus($row->SeveranceStatus,'LeaveStatus');

							$res['message'] = "Your request for Severance is ".$sts; 
							//$res['status'] = $this->getStatus($row->ApproverSts);

							$data['approvals'][] = $res;

						}
					}

				$edition=array();

				foreach ($data['approvals'] as $key => $row) {
					$edition[$key] = $row['time1'];
				}

				array_multisort( $edition, SORT_DESC, $data['approvals']);

		////////////  FETCH ALL FORTHCOMING EVENT ITEM FOR THE LOGGED IN EMPLOYEE  //////////////////////

	/*	$sql = "SELECT DOB, FirstName, LastName FROM EmployeeMaster WHERE OrganizationId = ? and  DATE_ADD(dob,INTERVAL YEAR(CURDATE())-YEAR(dob)
                         + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0) YEAR)
            BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 10 DAY) order by DATE_ADD(dob,INTERVAL YEAR(CURDATE())-YEAR(dob)
                         + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0) YEAR) limit 10";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();					
					$res['name'] = "Birthday - ".ucwords(strtolower($row->FirstName." ".$row->LastName));   
					$res['date'] = Utils::dateformatter($row->DOB); 
					$res['message'] = "Upcoming birthday"; 

					$data['forthcomingevents'][] = $res;

				}
			}
			*/
			$userdesig=Utils::getName($userid, "EmployeeMaster", "Division", $this->db);
			if($userdesig==""){
				$userdesig=0;
			}
		$sql = "SELECT * FROM HolidayMaster WHERE OrganizationId = ? AND DateFrom>=CURDATE() and find_in_set($userdesig,DivisionId)  order by DateFrom asc  limit 7";

        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$temp="";
					$res = array();					
					$res['name'] = "Holiday - ".$row->Name; 
					if($row->DateFrom != $row->DateTo)
						$temp=" - ".Utils::dateformatter($row->DateTo);	

					$res['date'] = Utils::dateformatter($row->DateFrom).$temp; 
					$res['message'] = $row->Description; 

					$data['forthcomingevents'][] = $res;

				}
			}
		/////////FETCH COLLEAGUES//////////////////
		$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? AND Designation IN (select Designation from EmployeeMaster where Id= $userid) and  DOL='0000-00-00' and Is_Delete=0 and Id != $userid ";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();	
					$res['id'] =Utils::encode5t($row->Id);					
					$res['name'] = $row->FirstName.' '.$row->LastName;
					$res['desig'] = $this->getName($row->Designation,"DesignationMaster");					
					$image=$row->ImageName;
					if($image != ""){
					$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
					}
					else{
						$gen=$row->Gender;
						if($gen == 1){
							$res['image']= URL."public/avatars/male.png";
						}
						else{
							$res['image']= URL."public/avatars/female.png";
						}
					}

					$data['colleagues'][] = $res;

				}
			}
		///////////fetch team members/////////////
			$ids = Utils::getReportingIds($userid, $this->db);
		$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and  Id in ( $ids ) and  DOL='0000-00-00' and Is_Delete=0 order by FirstName";
		
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)	{
				$junior=array();
				while($row = $query->fetch())	{
					$res = array();	
					
					$ids=Utils::encode5t($row->Id);					
					$res['id'] =$row->Id;	
					$link=URL."profile/viewemployee/$ids";
					 if($row->ImageName != ""){
						$image= URL."public/uploads/$orgid/$row->ImageName". "?img=" .rand(1,100);
					}
					else{
						$gen=$row->Gender;
						if($gen == 1){
							$image= URL."public/avatars/male.png";
						}
						else{
							$image= URL."public/avatars/female.png";
						}
					} 
					$desig= $this->getName($row->Designation,"DesignationMaster");	
					$res['name'] = $row->FirstName.' '.$row->LastName; 
					$res['text'] ="<a href='$link'><img src ='".$image."' style='border-radius: 50%;width:40px;height:40px;border: 2px solid #00a65a'><b> ".  $row->FirstName.' '.$row->LastName.'</b><br><span style="margin-left:65px;color:black">'.$desig. "</span></a>"; 
					
					$res['parent_id'] = $row->ReportingTo;
					$junior[] = $res;
				}
				 foreach($junior as $key => &$value){
						
					 $output[$value["id"]] = &$value;
				}
				foreach($junior as $key => &$value){
						//print_r($output[$value["parent_id"]]);
					 if($value["parent_id"] && isset($output[$value["parent_id"]])){
						$output[$value["parent_id"]]["nodes"][] = &$value;
					 }
				}
				foreach($junior as $key => &$value){
					 if($value["parent_id"] && isset($output[$value["parent_id"]])) {
						unset($junior[$key]);
					 }
				} 
				$newjunior=array();
				foreach($junior as $key){
						$newjunior[]= $key;
				}
				$data['juniors']= $newjunior;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		///////////// FETCH ALL LEAVE SUMMARY FOR LOGGED IN EMPLOYEE ///////////////
		try{
			$workingdays=0;
			$fiscalid = Utils::getFiscalId(date('Y-m-d'), $this->db);
			/* $sql = "SELECT WorkingDays FROM EmployeeMaster WHERE OrganizationId = ? and Id =? ";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $userid));
			while($r1=$query->fetch())
			{
				$workingdays=$r1->WorkingDays;
				$workingdays=substr_count($workingdays, '1');
				$halfdays=	substr_count($r1->WorkingDays, '2');
				$workingdays=$workingdays+($halfdays * 0.5);
			} */
			$shift=Utils::getName($userid,"EmployeeMaster","Shift",$this->db);
			$workingdays=$this->averageWorkingDayWeek($shift, $orgid);
			$sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and WorkingDays =$workingdays and AnnualLeaveSts=1 AND CASE 
			   WHEN LeaveUsableSts =2 THEN FIND_IN_SET($userid, EmployeeIds)
			   END";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			$leavetype=0;
			while($r1=$query->fetch())
			{
				$leavetype=$r1->Name;
			}

			$sql = "SELECT * FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $userid, $fiscalid));
			while($row = $query->fetch())
			{
				$res = array();
				$res['days'] =$row->LeaveAllotted;
				$res['name'] = $leavetype;//substr($row->Name,0,5)."...";
				$res['used'] = $row->UsedLeave;
				$res['balance'] = $row->BalanceLeave;
				$data['leavesummary']['data'][] = $res;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		/*$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $workingdays=0; $religion=0; 
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $halfdays=0; $religionflg=false;

		$sql = "SELECT MaritalStatus, Gender, Division, Department, Designation, Grade, TotalExp,WorkingDays,Religion FROM EmployeeMaster WHERE OrganizationId = ? and Id =? ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $userid));
		while($row = $query->fetch())
		{
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=$row->WorkingDays;
			$religion=$row->Religion;
			$workingdays=substr_count($workingdays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);
		}

        $sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and WorkingDays =$workingdays and AnnualLeaveSts=1";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			$keyarr= array();
			$label= array(); $ykey=array();
			while($row = $query->fetch())
			{
				$divisionflg=true;
				$departmentflg=true; 
				$designationflg=true; 
				$gradeflg=true; 
				$genderflg=true; $maritalflg=true;
				$religionflg=true;
				$fiscalid = Utils::getFiscalId(date('Y-m-d'), $this->db);
				$employeeusedleave=0;
				$sql1 = "SELECT *  FROM EmployeeLeave WHERE OrganizationId = ? and EmployeeId =? and LeaveTypeId=? and FiscalId =? AND ApplyDate<=CURDATE()  and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $userid, $row->Id,$fiscalid));
				while($row1=$query1->fetch()){
					$employeeusedleave=$employeeusedleave+$row1->LeaveValidDays;
				}
				if($row->LeaveUsableSts==1){
					if($row->DivisionId>0){
						if($row->DivisionId==$division){
							$divisionflg=true;
						}else{$divisionflg=false;}
					}
					if($row->DepartmentIds>0){
						if($row->DepartmentIds==$department){
							$departmentflg=true; 
						}else{$departmentflg=false; }
					}
					if($row->DesignationIds>0){
						if($row->DesignationIds==$designation){
							$designationflg=true; 
						}else{$designationflg=false; }
					}
					if($row->GenderId>0){
						if($row->GenderId==$gender){
							$genderflg=true;
						}else{$genderflg=false;}
					}
					if($row->MaritalId>0){
						if($row->MaritalId==$marital){
							$maritalflg=true;
						}else{$maritalflg=false;}
					}
					if($row->GradeId>0){
						if($row->GradeId==$grade){
							$gradeflg=true; 
						}else{$gradeflg=false; }
					}
					if($row->ReligionId>0){
						if($row->ReligionId==$religion){
							$religionflg=true; 
						}else{$religionflg=false; }
					}
				}elseif($row->LeaveUsableSts==2){
					$divisionflg=false;
					$departmentflg=false; 
					$designationflg=false; 
					$gradeflg=false; 
					$genderflg=false; $maritalflg=false;
					$religionflg=false;

					if($row->EmployeeIds!="")
					{
						$temp = explode(",", $row->EmployeeIds);
						for($i=0; $i<count($temp); $i++)
						{
							if($mid==$temp[$i]){
								$divisionflg=true;
								$departmentflg=true; 
								$designationflg=true; 
								$gradeflg=true; 
								$genderflg=true; $maritalflg=true;
								$religionflg=true;
								break;
							}

						}
					}
				}
				$annual=true;
				if($row->AnnualLeaveSts==1){
						if($row->WorkingDays ==$workingdays){
							$annual=true;
						}else{$annual=false;}
				}

				if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg && $annual && $religionflg)
				{

					$res = array();
					$res['days'] =(int)$row->LeaveDays;
					$res['name'] = $row->Name;//substr($row->Name,0,5)."...";
					$res['used'] = $employeeusedleave;
					$res['balance'] = (int)$row->LeaveDays-$employeeusedleave;

					$data['leavesummary']['data'][] = $res;
					//$res['id'] = $row->Id;
					//$res['label'] = $row->Name;
					//$res['value'] = (int)$row->LeaveDays;
					//$res['usedleave'] = (int)$employeeusedleave;
					//$data['leavesummary'][] = $res;
					//$data['usedleave'][] = (int)$employeeusedleave;

				}

			}

        }*/

		$sql = "SELECT * FROM SkillGapAssessment where EmployeeId =? AND OrganizationId=? and FromDate >='$startdate' and ToDate<='$enddate' ORDER BY ToDate limit 1";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($userid,$orgid));
			$count =  $query->rowCount();

		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			 $res2=array();
			while($row = $query->fetch())
			{

				$maxlevel=0;
				$sqlmax = "SELECT  Level FROM SkillGapApproval WHERE SkillGapId = ? and AssessmentSts=1 ";
				$querymax = $this->db->prepare($sqlmax);
				$querymax->execute(array(  $row->Id));
				while($rowmax=$querymax->fetch()){
					$maxlevel=$rowmax->Level;
				}
				$sql1 = "SELECT * FROM SkillGapChild WHERE SkillGapId = ? and Level =?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(  $row->Id,$maxlevel));
				while($row1=$query1->fetch()){
						$res = array();

						$aid=$row1->AnalysisId;
						$sql2 = "SELECT  * FROM CompetencyAnalysisChild WHERE Id = ? " ;
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $aid ));
						while($row2 = $query2->fetch())
						{

							$compid=$row2->Competency;
							$res['competency'] =Utils::getName($compid,'CompetencyMaster','Name',$this->db);

							$qid=$row2->CompetencyType;
							$sqlc = "SELECT Color FROM CompetencyType WHERE Id = ? ";
							$queryc = $this->db->prepare($sqlc);
							$queryc->execute(array( $qid ));
							while($rowc = $queryc->fetch()){

								$res['competencycolor'] = $rowc->Color;

							}

						}

						$res['desirelevel'] =(int)$row1->DesireLevel;
						$res['assesslevel'] =(int)$row1->AssessedLevel;
						/*$gap =  ($row1->DesireLevel - $row1->AssessedLevel);
						if($gap >0){
							$res['gap'] = $gap;
						}
						else{
							$res['gap'] = 0;
						}*/

						//$data['skillgap']['competencycolor']= $res2;
						//$data['skillgap']['labels']= $label;
						//$data['skillgap']['ykey'] = $res1;
						$data['skillgap']['data'][] = $res;	
					}

				}
			}			

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		///////////assessment graph////////////

		$sql = "SELECT * FROM EmployeeAssessment WHERE EmployeeId =? AND AssessmentSts=1 AND OrganizationId=? and FromDate >='$startdate' and ToDate<='$enddate'  ORDER BY ToDate limit 1";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($userid,$orgid));
			$count =  $query->rowCount();

			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				$keyarr= array();
				$label= array(); $ykey=array();
				while($row = $query->fetch())
				{
					$objids="0";
					$sql1 = "SELECT DISTINCT ObjectiveId FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id ORDER BY Level";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array(':id' => $row->Id ));
					while($row1 = $query1->fetch())
					{
						if($objids=="0"){
							$objids=$row1->ObjectiveId;
						}else{
							$objids=$objids.",".$row1->ObjectiveId;
						}

					}	
					$dlevel=explode(',',$row->DesignationLevel);	
						$sql2 = "SELECT DISTINCT QuadrantId FROM AssessmentObjectiveChild WHERE Id in ($objids)";
						$query2 = $this->db->prepare($sql2);
						$query2->execute();
						while($row2 = $query2->fetch())
						{
							$res=array();
							$qid=$row2->QuadrantId;
							//$aid=$row2->AssessmentObjectiveId;
							$res['quadrant'] = Utils::getName($qid,'Quadrants','Name',$this->db);
							$res1=array();
							$res1[]='Weightage';
							$res2=array();
							$res2[]="w";

							for($level=1;$level<=count($dlevel);$level++){
								$weightage=0;
								$score1=0;
								$score=0;
								$sql3 = "SELECT * FROM EmployeeAssessmentChild, AssessmentObjectiveChild WHERE EmployeeAssessmentChild.EmployeeAssessmentId = ? and AssessmentObjectiveChild.QuadrantId=? and EmployeeAssessmentChild.ObjectiveId=AssessmentObjectiveChild.Id Group BY EmployeeAssessmentChild.ObjectiveId";
								$query3 = $this->db->prepare($sql3);
								$query3->execute(array( $row->Id,$qid ));
								while($row3 = $query3->fetch())
								{

									$oid= $row3->Id;
									$weightage+=$row3->Weightage;

									$sql4 = "SELECT * FROM EmployeeAssessmentChild where EmployeeAssessmentId =? and ObjectiveId=? and Level =?";
									$query4 = $this->db->prepare($sql4);
									$query4->execute(array( $row->Id,$oid,$level ));
									while($row4 = $query4->fetch())
									{

										$score1+=(int)$row4->Score;

									}
									$score=$score1;									

								}

								$res2[]=$level;	
								$res1[]='Level '.$level;
								$res[$level]=$score;	

							}

							$res['w'] = $weightage;
							$data['empassessment']['labels']=$res1;
							$data['empassessment']['ykey']=$res2;
							$data['empassessment']['data'][]=$res;
						}	

						//$label[]='Level '.$row->Level;
				}
			}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}	
		$mdate = date('Y-m-d h:i:s');
	/* 	$sql = "SELECT id, TIMESTAMPDIFF(hour, start_time, end_time) as totaltime, TIMESTAMPDIFF(hour, timesheetstart, timesheetend) as takentime, task_id, project_id  FROM timesheet_master WHERE EmployeeId= ? and OrganizationId=? and timesheetstart <> '0000-00-00 00:00:00' and timesheetend <> '0000-00-00 00:00:00'"; */
		/* SELECT *  FROM timesheet_master WHERE EmployeeId=3503 and (curdate()<= start_time or curdate()<=end_time); */
		$sql = "select * from task_master where (taskstatus=1 or taskstatus=5) and assignto=? and OrganizationId=? order by fromdate desc";
		try{$query = $this->db->prepare($sql);
			$query->execute(array( $userid ,$orgid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					
					$res = array();	
					$task=ucwords($row->task_title);
					$project = ucwords(Utils::getName($row->projectid,"project_master","project_title", $this->db)); 
					$res['name'] = $task.' ('.$project.')'; 
					$res['id'] = Utils::encode5t($row->id);
					$res['fromdate'] =Utils::dateformatter($row->fromdate);
					$res['description'] = $row->description;
					$data['tasksheet'][] = $res;

				
				}
					}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			Utils::Trace($errorMsg);
		}
		$availemp=Utils::getTotalEmp($orgid, $this->db);	
		$status=true;
		$successMsg="Record found";
		$result["data"] =$data;
		$result["availemp"] =$availemp;
		$result['status']=true;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	public function getNotifications($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];
		//$ids = Utils::getReportingIds($userid, $this->db);
		$sts=$_SESSION['ubihrm_user_sts'];

		$sWhere = " and EmployeeId = $userid ";

		$sql = "SELECT * FROM GenerateNotification WHERE  OrganizationId = ? and NotifyDate = CURDATE() AND VisibleSts <> 0 AND VisibleSts<>4 $sWhere limit 3";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['message'] = $row->Message;
			$res['title'] = $row->Title;
			$res['time'] = Utils::dateformatter($row->NotifyDate);	
			$data[] = $res;
		}

		if (count($data) > 0) {
           $status =true;
		   $successMsg = VISA_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =true;
		   //$errorMsg = "There is no notification";
        }

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;

	}
	
	public function averageWorkingDayWeek($shiftid,$orgid)
	{
		 
		 $sql1 = "SELECT * FROM ShiftMasterChild where ShiftId=? and Day in (1,2,3,4,5,6,7)";
		 $query1 = $this->db->prepare($sql1);
		 $query1->execute(array( $shiftid));		
		 $count=0;
		 while($row1 = $query1->fetch()){
		 $workingday = $row1->WeekOff;
		 $temparr = explode(',',$workingday);
			 foreach($temparr as $value){
				 if($value==0){
					 $count=$count+1;
				 }elseif($value==2){
					 $count=$count+0.5;
				 }
			}
		}
		$count=ceil($count/5);
		return $count;
	}
	
	public function getAllNotifications($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];
		//$ids = Utils::getReportingIds($userid, $this->db);
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];

		$ids = Utils::getReportingIds($userid, $this->db);
		$notification="";
		if($sts==1 || $hrsts==1){
			$notification="";
		}else{
			$notification = " and CreatedById in ($ids)";
		}

		$data['notification']= array(); 
		$data['approvals']= array(); 
		$data['alerts']= array(); 
		try{
		$sql = "SELECT * FROM NotificationMaster WHERE OrganizationId = ? AND CURDATE() BETWEEN StartDate and EndDate and ( (FIND_IN_SET($userid, EmployeeIds )>0) or Division in (SELECT Division FROM EmployeeMaster where Id=$userid ) OR Department in (SELECT Department FROM EmployeeMaster where Id=$userid ) OR Designation in (SELECT Designation FROM EmployeeMaster where Id=$userid ) ) ORDER BY StartDate desc";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$res = array();					
					$res['title'] = $row->Name;   
					$res['time'] = Utils::dateformatter($row->CreatedDate);
					$res['id'] =Utils::encode5t($row->Id);		
					$res['link'] = 'profile/viewnotification/'.Utils::encode5t($row->Id).'/1';
					$res['message'] = $row->Message; 
					$res['employee'] =Utils::getEmployeeName($row->CreatedById, $this->db);
					$res['priority'] = $row->NotificationPriority;						
					$data['notification'][] = $res;
					/*if($row->Division==0 && $row->Designation==0 && $row->Department==0 && $row->EmployeeIds==0){
						$data['notification'][] = $res;
					}else{
						$cond="and ";
						if($row->Division!=0){
							$cond .=" Division=".$row->Division." AND ";
						}
						if($row->Designation!=0){
							$cond .=" Designation=".$row->Designation." AND ";
						}
						if($row->Department!=0){
							$cond .=" Department=".$row->Department." AND ";
						}
						if($row->EmployeeIds!=0){
							$cond .=" Id in (".$row->EmployeeIds.") and ";
						}

						$cond = substr($cond, 0, -4);
						if($cond!="")
						{	
							$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and Id = ? $cond ";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($orgid,$userid));
							if($query1->rowCount()>0)
							{
								$data['notification'][] = $res;
							}
						}
					}
					*/
				}
			}

		$sql = "SELECT * FROM EmployeeLeave WHERE Id in (SELECT LeaveId from (select * from LeaveApproval where  ApproverSts = 3 Group by LeaveId) s where ApproverId=$userid) AND OrganizationId= ? AND LeaveStatus = 3" ;
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();	

					if($hrsts==1){
						$res['link'] = 'leave/viewemployeeleaveapproval/'.Utils::encode5t($row->Id).'/2';
					}else{
						$res['link'] = 'leave/editleaveapproval/'.Utils::encode5t($row->Id);
					}
					$emp=Utils::getEmployeeName($row->EmployeeId, $this->db);	
					$res['name'] = "Leave Application";//Utils::getEmployeeName($row->EmployeeId, $this->db);  
					$res['time'] = Utils::dateformatter($row->LastModifiedDate);
					$res['time1'] = $row->LastModifiedDate; 
					$res['message'] = $emp."'s request for Leave  is ".$this->getStatus($row->LeaveStatus,'LeaveStatus'); 
					//$res['priority'] = $this->getpriority($row->NotificationPriority);

					$data['approvals'][] = $res;

				}
			}

		$sql = "SELECT * FROM SalaryAdvance WHERE Id in (SELECT SalaryAdvanceId from (select * from SalaryApproval where  LeaveStatus = 3 Group by SalaryAdvanceId) s where ApproverId=$userid) AND OrganizationId= ? AND LeaveStatus = 3";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();	
					$res['link'] = 'salary/viewsalaryadvanceapproval/'.Utils::encode5t($row->Id).'/0';
					$emp=Utils::getEmployeeName($row->EmployeeId, $this->db); 	
					$res['name'] = "Personal Loan";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
					$res['time'] = Utils::dateformatter($row->LastModifiedDate);
					$res['time1'] = $row->LastModifiedDate; 	
					$res['message'] = $emp."'s request for Personal Loan is ".$this->getStatus($row->LeaveStatus,'LeaveStatus'); 
					//$res['status'] = $this->getStatus($row->ApproverSts);

					$data['approvals'][] = $res;

				}
			}

		$sql = "SELECT * FROM Timeoff WHERE Id in (SELECT TimeofId from (select * from TimeoffApproval where  ApproverSts = 3 Group by TimeofId) s where ApproverId=$userid) AND OrganizationId= ? AND ApprovalSts = 3" ;
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();	

					if($hrsts==1){
						$res['link'] = 'leave/edittimeoffapproval/'.Utils::encode5t($row->Id).'/2';
					}else{
						$res['link'] = 'leave/edittimeoffapproval/'.Utils::encode5t($row->Id);
					}
					$emp=Utils::getEmployeeName($row->EmployeeId, $this->db);	
					$res['name'] = "Timeoff Application";//Utils::getEmployeeName($row->EmployeeId, $this->db);  
					$res['time'] = Utils::dateformatter($row->ModifiedDate);
					$res['time1'] = $row->ModifiedDate; 
					$res['message'] = $emp."'s request for Timeoff  is ".$this->getStatus($row->ApprovalSts,'LeaveStatus'); 
					//$res['priority'] = $this->getpriority($row->NotificationPriority);

					$data['approvals'][] = $res;

				}
			}

		$sql = "SELECT * FROM DocumentReleaseMaster WHERE Id in (SELECT DocumentId from (select * from DocumentApproval where  LeaveStatus = 3 Group by DocumentId) s where ApproverId=$userid) AND OrganizationId= ? AND ApproverSts = 3";
        $query = $this->db->prepare($sql);
		$query->execute(array(  $orgid ));
		$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();	
					$res['link'] = 'employee/editdocumentapproval/'.Utils::encode5t($row->Id);
					$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
					$res['name'] = "Document Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);  
					$res['time1'] = $row->LastModifiedDate; 					
					$res['time'] = Utils::dateformatter($row->LastModifiedDate); 
					$res['message'] = $emp."'s request for Document Release is ".$this->getStatus($row->ApproverSts,'LeaveStatus'); 
					//$res['status'] = $this->getStatus($row->ApproverSts);

					$data['approvals'][] = $res;

				}
			}

			$sql = "SELECT * FROM CertificateReleaseMaster WHERE Id in (SELECT CertificateId from CertificateApproval where ApproverId=$userid and ApproverSts=3) and ApproverSts=3 and OrganizationId = ? and CreatedDate between Date_sub(curdate(), interval 1 month) and Date_add(curdate(), interval 1 month) ";
			$query = $this->db->prepare($sql);
			$query->execute(array(  $orgid ));
			$count =  $query->rowCount();
				if($count>=1)
				{
					$status=true;
					while($row = $query->fetch())
					{
						$res = array();	
						$res['link'] = 'employee/editcertificateapproval/'.Utils::encode5t($row->Id);
						$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
						$res['name'] = "Certificate Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
						$res['time1'] = $row->LastModifiedDate; 
						$res['time'] = Utils::dateformatter($row->LastModifiedDate); 
						if($row->ApproverSts==6){
							$sts="Issued";
						}else{
							$sts=$this->getStatus($row->ApproverSts,'LeaveStatus');
						}
						$res['message'] = $emp."'s request for Certificate Release is ".$sts; 
						//$res['status'] = $this->getStatus($row->ApproverSts);

						$data['approvals'][] = $res;

					}
				}

				$sql = "SELECT * FROM SeveranceMaster WHERE Id in (SELECT ResignationId from (select * from ResignationApproval where  LeaveStatus = 3 Group by ResignationId) s where ApproverId=$userid) AND OrganizationId= ? AND (SeveranceStatus = 3 OR SeveranceStatus = 0)";
				$query = $this->db->prepare($sql);
				$query->execute(array(  $orgid ));
				$count =  $query->rowCount();
					if($count>=1)
					{
						$status=true;
						while($row = $query->fetch())
						{
							$res = array();	
							$res['link'] = 'employee/editseveranceapproval/'.Utils::encode5t($row->Id);
							$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
							$res['name'] = "Severance Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
							$res['time1'] = $row->LastModifiedDate; 
							$res['time'] = Utils::dateformatter($row->LastModifiedDate); 

							$sts=$this->getStatus($row->SeveranceStatus,'LeaveStatus');

							$res['message'] = $emp."'s request for Severance is ".$sts; 
							//$res['status'] = $this->getStatus($row->ApproverSts);

							$data['approvals'][] = $res;

						}
					}

				$sql = "SELECT * FROM GrievanceMaster WHERE Id in (SELECT GrievanceId from GrievanceApproval where ApproverId=$userid and ApproverSts=3)  and ApproveSts=3 and OrganizationId = ?  limit 0,10";
					$query = $this->db->prepare($sql);
					$query->execute(array(  $orgid ));
					$count =  $query->rowCount();
						if($count>=1)
						{
							$status=true;
							while($row = $query->fetch())
							{
								$res = array();	
								$res['link'] = 'employee/editgrievance/'.Utils::encode5t($row->Id);
								$emp = Utils::getEmployeeName($row->CreatedById, $this->db);  	
								$res['name'] = "Grievance";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
								$res['time1'] = $row->LastModifiedDate; 
								$res['time'] = Utils::dateformatter($row->LastModifiedDate); 

								$sts=$this->getStatus($row->ApproveSts,'LeaveStatus');

								$res['message'] = $emp."'s request for Grievance is ".$sts; 
								//$res['status'] = $this->getStatus($row->ApproverSts);

								$data['approvals'][] = $res;

							}
						}
					$sql = "SELECT * FROM ClaimsMaster WHERE Id in (SELECT ClaimId from (select * from ClaimApproval where  ApproverSts = 3 Group by ClaimId) s where ApproverId=$userid) AND OrganizationId= ? AND (ApproverSts = 3 OR ApproverSts = 0)";
					$query = $this->db->prepare($sql);
					$query->execute(array(  $orgid ));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$status=true;
						while($row = $query->fetch())
						{
							$res = array();	
							$res['link'] = 'salary/editclaimapproval/'.Utils::encode5t($row->Id);
							$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
							$res['name'] = "Claims Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
							$res['time1'] = $row->LastModifiedDate; 
							$res['time'] = Utils::dateformatter($row->LastModifiedDate); 

							$sts=$this->getStatus($row->ApproverSts,'LeaveStatus');

							$res['message'] = $emp."'s request for Claims is ".$sts; 
							//$res['status'] = $this->getStatus($row->ApproverSts);

							$data['approvals'][] = $res;

						}
					}
					if($hrsts==1){
					$sql = "SELECT * FROM MedicalClaim WHERE OrganizationId= ? AND ApproveSts = 1 or (ApproveSts = 2  and financeby = $userid)";
					}
					else{
					$sql = "SELECT * FROM MedicalClaim WHERE OrganizationId= ? AND ApproveSts = 2 and financeby = $userid";
					}
					$query = $this->db->prepare($sql);
					$query->execute(array($orgid));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$status=true;
						while($row = $query->fetch())
						{
							$res = array();	
							$res['link'] ="";
							if($row->ApproveSts==1){
							$res['link'] = 'employee/approvemedicalclaim/'.Utils::encode5t($row->Id);
							}else if($row->ApproveSts==2){
							$res['link'] = 'employee/releasemedicalclaim/'.Utils::encode5t($row->Id);
							}
							$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
							$res['name'] = "Medical Claim Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
							$res['time1'] = $row->LastModifiedDate; 
							$res['time'] = Utils::dateformatter($row->LastModifiedDate); 

							$sts=$this->getStatus($row->ApproveSts,'MedClaimSts');

							$res['message'] = $emp."'s request for Claims is ".$sts; 
							//$res['status'] = $this->getStatus($row->ApproverSts);
							if ($row->ApproveSts==2){
								$res['message'] = $emp."'s request for Claims is ".$sts.", now it is pending for release."; 
							}
							$data['approvals'][] = $res;

						}
					}

					$sql = "SELECT * FROM PersonnelRequisition WHERE Id in (SELECT PersonnelRequisitionId from (select * from PersonnelRequisitionApproval where  ApproverSts = 3 Group by PersonnelRequisitionId) s where ApproverId=$userid) AND OrganizationId= ? AND (ApproverSts = 3 OR ApproverSts = 0)";
					$query = $this->db->prepare($sql);
					$query->execute(array(  $orgid ));
					$count =  $query->rowCount();
					if($count>=1)
					{
						$status=true;
						while($row = $query->fetch())
						{
							$res = array();	
							$res['link'] = 'setup/viewpersonnel_requisition/'.Utils::encode5t($row->Id).'/1';
							$emp = Utils::getEmployeeName($row->CreatedById, $this->db);  	
							$res['name'] = "Personnel Requisition Request";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
							$res['time1'] = $row->LastModifiedDate; 
							$res['time'] = Utils::dateformatter($row->LastModifiedDate); 

							$sts=$this->getStatus($row->ApproverSts,'LeaveStatus');

							$res['message'] = $emp."'s request for personnel requisition is ".$sts; 
							//$res['status'] = $this->getStatus($row->ApproverSts);

							$data['approvals'][] = $res;

						}
					}						

			if($hrsts==1){				
				$sql = "SELECT * FROM CertificateReleaseMaster WHERE ApproverSts=2 AND OrganizationId= ?";
				$query = $this->db->prepare($sql);
				$query->execute(array(  $orgid ));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$status=true;
					while($row = $query->fetch())
					{
						$res = array();	
						$res['link'] = 'employee/sendcertificateapproval/'.Utils::encode5t($row->Id);
						$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
						$res['name'] = "Certificate Release";//Utils::getEmployeeName($row->EmployeeId, $this->db);   
						$res['time1'] = $row->LastModifiedDate; 
						$res['time'] = Utils::dateformatter($row->LastModifiedDate); 

						$res['message'] = $emp."'s Certificate Release is pending"; 
									//$res['status'] = $this->getStatus($row->ApproverSts);

						$data['approvals'][] = $res;

					}
				}

				$sql = "SELECT * FROM DocumentReleaseMaster WHERE ApproverSts=2 AND (ReleaseFrom='0000-00-00' or ReleaseTo='0000-00-00') AND OrganizationId= ?";
				$query = $this->db->prepare($sql);
				$query->execute(array(  $orgid ));
				$count =  $query->rowCount();
					if($count>=1)
					{
						$status=true;
						while($row = $query->fetch())
						{
							$res = array();	
							$res['link'] = 'employee/editdocumentrequest/'.Utils::encode5t($row->Id).'/2';
							if($row->ReleaseFrom=='0000-00-00'){
								$res['link'] = 'employee/editdocumentrequest/'.Utils::encode5t($row->Id).'/1';
							}
							$emp = Utils::getEmployeeName($row->EmployeeId, $this->db);  	
							$res['name'] = "Document Return";
							if($row->ReleaseFrom=='0000-00-00'){
								$res['name'] = "Document Release"; 
							}
							//Utils::getEmployeeName($row->EmployeeId, $this->db);  
							$res['time1'] = $row->LastModifiedDate; 					
							$res['time'] = Utils::dateformatter($row->LastModifiedDate); 
							$res['message'] = "Return date of $emp's Document has to be filled"; 
							if($row->ReleaseFrom=='0000-00-00'){
								$res['message'] = "Release date of $emp's Document has to be filled";  

							}
							//$res['status'] = $this->getStatus($row->ApproverSts);

							$data['approvals'][] = $res;

						}
					}
			}	

				if(count($data['approvals'])>0){
					foreach ($data['approvals'] as $key => $row) {
						$edition[$key] = $row['time1'];
					}

					array_multisort( $edition, SORT_DESC, $data['approvals']);
				}

		$sql = "SELECT * FROM GenerateNotification WHERE  OrganizationId = ? and NotifyDate = CURDATE()  and EmployeeId = $userid order by Title ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));

		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['message'] = $row->Message;
			$res['title'] = $row->Title;
			$res['time'] = Utils::dateformatter($row->NotifyDate);	
			$data['alerts'][] = $res;
		}

		if (count($data) > 0) {
           $status =true;
		   $successMsg = VISA_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =true;
		   //$errorMsg = "There is no notification";
        }

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;

	}

	public function setNotifySts($id,$sts)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();

		$sql = "UPDATE GenerateNotification SET VisibleSts = ? WHERE  Id= ?";
        $query = $this->db->prepare($sql);
		$query->execute(array( $sts,$id ));
		$count=$query->rowCount();
		if ($count >= 1) {
           $status =true;
		   $successMsg = VISA_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =true;
		   //$errorMsg = "There is no notification";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;

	}
	 /* public function getNotifications($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];
		$probation=15; $joining=10; $birthday=1;

		$ids = Utils::getReportingIds($userid, $this->db);
		$sts=$_SESSION['ubihrm_user_sts'];
		$sWhere = "";
		$leave = "";
		if($sts==1){
			$sWhere = " and  DOL='0000-00-00' ";
		}else{
			$sWhere = " and Id in ($ids) and  DOL='0000-00-00'  ";
			$leave = " and EmployeeId in ($ids) ";
		}

		///////// FIND OUT NOTIFICATION SETTINGS FOR ORGANIZATION  ////////////////

      $sql = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and  SettingId in (1,2,3)";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			if($row->SettingId==1){
			$probation=$row->ExecutionValue;
			}elseif($row->SettingId==2){
			$joining=$row->ExecutionValue;
			}elseif($row->SettingId==3){
			$birthday=$row->ExecutionValue;
			}
		}

		///////// NOTIFICATION FOR EMPLOYEE BIRTHDAY  ////////////////

        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, DOB, datediff( DATE_ADD(dob, INTERVAL YEAR(CURDATE())-YEAR(dob)+ IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0) YEAR), curdate()) as diff FROM EmployeeMaster WHERE  OrganizationId = ? and DATE_ADD(dob,INTERVAL YEAR(CURDATE())-YEAR(dob)
                         + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0) YEAR)
            BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $birthday DAY) $sWhere ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$name = $row->EmployeeCode." ".ucwords(strtolower($row->FirstName." ".$row->LastName."'s"));
				if($row->Id==$userid)
				{
					$name = "Your ";
				}
				$dat = ($row->diff==0)?"Today":(($row->diff==1)?"Tomorrow":date("d F", strtotime($row->DOB)));
				$res['message'] = $name." having birthday on ".$dat;
				$res['title'] = " Birthday Notification";

				$data[] = $res;
			}
        }

		///////// FINDING PROBATION PERIOD ENDING DAYS ////////////////

        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, DOJ, datediff(DATE_ADD(DOJ, INTERVAL Provisionperiod month), curdate()) as daysleft FROM EmployeeMaster WHERE Provisionperiod<>0 and OrganizationId = ? and  DATE_ADD(DOJ, INTERVAL Provisionperiod month) BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $probation DAY) $sWhere ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$name = $row->EmployeeCode." ".ucwords(strtolower($row->FirstName." ".$row->LastName."'s"));
				if($row->Id==$userid)
				{
					$name = "Your ";
				}
				$dat = ($row->daysleft==0)?"Today":(($row->daysleft==1)?"Tomorrow":"within ".$row->daysleft." days");

				$res['message'] = $name." probation period is going to expire ".$dat;
				$res['title'] = $row->daysleft." Days left in Probation";

				$data[] = $res;
			}
        }

		///////// FINDING NEW JOINING OF EMPLOYEE ////////////////

        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, DOJ, datediff( DOJ, curdate()) as daysleft FROM EmployeeMaster WHERE Id<>$userid and OrganizationId = ? and (CURDATE() BETWEEN DATE_SUB(DOJ, INTERVAL $joining DAY) and DOJ) $sWhere ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$name = $row->EmployeeCode." ".ucwords(strtolower($row->FirstName." ".$row->LastName."'s"));

				$dat = ($row->daysleft==0)?"Today":(($row->daysleft==1)?"Tomorrow":"within ".$row->daysleft." day's");

				$res['message'] = $name." joining ".$dat;
				$res['title'] = "New Joining Notification";

				$data[] = $res;
			}
        }
		//////////////////  NOTIFICATION FOR EMPLOYEES WHOS TAKING LEAVE ON TODAY  ////////////////

		$sql = "SELECT EmployeeId from EmployeeLeave where OrganizationId=? and LeaveStatus=2 and (curdate() between LeaveFrom and LeaveTo) $leave ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				$res = array();
				$name = Utils::getEmployeeName($row->EmployeeId, $this->db);
				if($row->EmployeeId==$userid)
				{
					$name = "You are  ";
				}
				$res['message'] = $name." on leave for today ";
				$res['title'] = "Employee on leave";

				$data[] = $res;
			}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		/////////////  NOTIFICATION FOR DOCUMENT EXPIRED SOON ///////////////

		$sql = "SELECT EmployeeId, DocumentTypeId, DATEDIFF(curdate(),ExpiredOn) as daysleft from EmployeeDocument where OrganizationId=? and ExpiredOn<>'0000-00-00' and(DATEDIFF(curdate(),ExpiredOn) between 0 and 7) $leave";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				$res = array();
				$name = Utils::getEmployeeName($row->EmployeeId, $this->db);
				$doc = $this->getName($row->DocumentTypeId, 'DocumentMaster');

				if($row->EmployeeId==$userid)
				{
					$name = "Your  ";
				}
				$dat = ($row->daysleft==0)?"Today":(($row->daysleft==1)?"Tomorrow":"within ".$row->daysleft." days");
				$res['message'] = $name." ".$doc." is about to expire ".$dat;
				$res['title'] = "Document Expiration Notice";

				$data[] = $res;
			}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		if (count($data) > 0) {
           $status =true;
		   $successMsg = VISA_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =true;
		   //$errorMsg = "There is no notification";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }*/
	public function searchForTimeline($id, $array) {
	   foreach ($array as $key => $val) {
			if(isset($val['title'])){
			   if ($val['title'] === $id) {
				   return false;
			   }
		   }
	   }
	   return true;
	}

	public function getTimeLine($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $desig= ""; $data1 = array(); $username="";
		$userid = $request[0];
		$orgid = $request[1];

		/*$sql = "SELECT Id, FirstName, LastName, EmployeeCode, Provisionperiod, DATE_ADD(DOJ, INTERVAL Provisionperiod month) as confirmationday, DOL FROM EmployeeMaster WHERE Id=? and OrganizationId = ? and DOL<>'0000-00-00'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $userid, $orgid ));
			$count =  $query->rowCount();

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
					$res['date'] = date("dS M, Y", strtotime($row->DOL));
					$data[] = $res;

					$res = array();
					$res['message'] = "This is the end of journey in the company on ".date("dS F, Y", strtotime($row->DOL));
					$res['title'] = "Date of Leaving";			
					$res['date'] = "";
					$res['time']="";
					$data[] = $res;
			}
        }*/

		$sql = "SELECT * from EmployeeHistory where EmployeeId=? and OrganizationId=? order by EventDate desc";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $userid, $orgid ));
			$date ="";
			while($row = $query->fetch())
			{

				if($date != date("dS M, Y", strtotime($row->EventDate)))
				{
					$res = array();
					$res['date'] = date("dS M, Y", strtotime($row->EventDate));
					$data[] = $res;
					$date = date("dS M, Y", strtotime($row->EventDate));
				}
				$res = array();
				$res['message'] =$row->Message;
				$res['title'] = $row->Title;
				$res['date'] = "";
				$res['time']= date("h:i A", strtotime($row->EventDate));
				$data[] = $res;
			}

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, Provisionperiod, DATE_ADD(DOJ, INTERVAL Provisionperiod month) as confirmationday, DOJ,Designation,DOC,Division,DOL,EmployeeStatus FROM EmployeeMaster WHERE Id=? and OrganizationId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $userid, $orgid ));
			$count =  $query->rowCount();

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				if($row->DOL != '0000-00-00')
				{
					/* $sts=$this->searchForTimeline('Termination',$data);
					$sts1=$this->searchForTimeline('Resignation',$data);
					$sts2=$this->searchForTimeline('Absconding',$data);

					if($sts || $sts1 || $sts2)
					{
						$sts=Utils::getOtherName($row->EmployeeStatus,'EmployeeStatus',$this->db);
						$res = array();
						$res['date'] = date("dS M, Y", strtotime($row->DOL));
						$data[] = $res;
						$desig=$this->getName($row->Designation,'DesignationMaster');	
						$division=$this->getName($row->Division,'DivisionMaster');	
						$res = array();	
						$res['message'] = "You $sts on ".date("dS F, Y", strtotime($row->DOL));
						$res['title'] = $sts;		
						$res['date'] = "";
						$res['time']="";
						$data[] = $res;
					} */
				}
				$sts=$this->searchForTimeline('Confirmation',$data);
				if($sts)
				{
					$res = array();
					if($row->DOC != "0000-00-00"){
						$res['date'] = date("dS M, Y", strtotime($row->DOC));
						$data[] = $res;

						$res = array();
						//$res['message'] = "Confirmed on ".date("dS F, Y", strtotime($row->DOC));
						$res['message'] = "You have completed your probation period and now became a confirmed employee";
						$res['title'] = "Confirmation";			
						$res['date'] = "";
						$res['time']="";
						$data[] = $res;
					}
				}

				$sts=$this->searchForTimeline('Joining',$data);
				if($sts)
				{
					$res = array();
					if($row->DOJ != "0000-00-00"){
						$res['date'] = date("dS M, Y", strtotime($row->DOJ));
						$data[] = $res;
						$desig=$this->getOldValue($userid,"Designation");
						$desig=($desig=="")?$this->getName($row->Designation,'DesignationMaster'):$desig;
						
						$division=$this->getOldValue($userid,"Division");
						$division=($division=="")?$this->getName($row->Division,'DivisionMaster'):$division;			
						$res = array();	
						$res['message'] = "Joined $division on ".date("dS F, Y", strtotime($row->DOJ))." as $desig ";
						$res['title'] = "Joining";		
						$res['date'] = "";
						$res['time']="";
						$data[] = $res;
					}
				}

			}
        }
		$sql = "SELECT  FirstName, LastName FROM EmployeeMaster WHERE Id=? and OrganizationId = ? ";
		$query = $this->db->prepare($sql);
		$query->execute(array( $userid, $orgid ));
		while($row = $query->fetch())
		{

			$username = $row->FirstName." ".$row->LastName;

		}		
		if (count($data) > 0) {

            $status =true;
		    $successMsg = VISA_MODULE_GETDETAIL_SUCCESS;

        } else {
           $status =true;
		   $errorMsg = VISA_MODULE_GETDETAIL_FAILED;
        }
		$result["username"] =$username;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	
	public function getOldValue($userid,$val)
	{
		
		$name ="";
		$sql = "SELECT * FROM JobModificationChild WHERE 	FieldName = ? and JobId in (Select Id from JobModificationMaster where EmployeeId=? Order By ApplyFrom asc ) limit 1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $val, $userid ));
			while($row1 = $query->fetch())
			{
				if($row1->FieldName=="Division"){
					$name = Utils::getName($row1->OldValue,'DivisionMaster','Name',$this->db);
					break;
				}elseif($row1->FieldName=="Department"){
					$name = Utils::getName($row1->OldValue,'DepartmentMaster','Name',$this->db);
					break;
				}elseif($row1->FieldName=="Designation"){
					$name = Utils::getName($row1->OldValue,'DesignationMaster','Name',$this->db);
					break;
				}elseif($row1->FieldName=="Grade"){
					$name = Utils::getName($row1->OldValue,'GradeMaster','Name',$this->db);
					break;
				}elseif($row1->FieldName=="EmployeeCTC"){
					$name = Utils::getcurrency().' '.$row1->OldValue;
					break;
				}elseif($row1->FieldName=="Location"){
					$name = Utils::getName($row1->OldValue,'LocationMaster','Name',$this->db);
					break;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeHierarchy($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();

		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid   = $request[2];	//USER ID CONTAINS IN ARRAY FIRST VALUE;

		$ids = Utils::getReportingIds($empid, $this->db);
		$ids = $ids.",". $empid;
        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and  Id in ( $ids ) and  DOL='0000-00-00' and Is_Delete=0 order by FirstName";
		//$sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and  (ReportingTo = $empid or Id=$empid ) and  DOL='0000-00-00'";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".ucwords(strtolower($row->FirstName." ".$row->LastName));
				if($row->Id==$empid)
				$res['parent'] = 0;
				else
				$res['parent'] = $row->ReportingTo;

				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=ROLE_MODULE_GETALL;
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getEmployeeListbyreport($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();

		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid   = $request[2];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$adminsts=$_SESSION['ubihrm_user_sts'];
		$ids = Utils::getReportingIds($empid, $this->db);
		$ids = $ids.",". $empid;
        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo ,Designation FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00' and Is_Delete=0  order by FirstName";
		//$sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo ,Designation FROM EmployeeMaster WHERE OrganizationId = ? and  Id in ( $ids ) and  DOL='0000-00-00'  order by FirstName";
		if($adminsts==1 || $hrsts==1)
		$sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo ,Designation  FROM EmployeeMaster where  OrganizationId= $orgid and  DOL='0000-00-00' and Is_Delete=0  order by FirstName";
		//$sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and  (ReportingTo = $empid or Id=$empid ) and  DOL='0000-00-00'";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['designationid']=$row->Designation;
				$res['designationname']=$this->getName($row->Designation,'DesignationMaster');
				$res['colindex']="";////for indexing profile add project//////
				if($row->Id==$empid)
				$res['parent'] = 0;
				else
				$res['parent'] = $row->ReportingTo;
				$res['vsts']=false;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=ROLE_MODULE_GETALL;
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getEmployeeListbyreportproject($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();

		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid   = $request[2];	//USER ID CONTAINS IN ARRAY FIRST VALUE;

		$ids = Utils::getReportingIds($empid, $this->db);
		$ids = $ids.",". $empid;
        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo ,Designation FROM EmployeeMaster WHERE OrganizationId = ? and  Id in ( $ids ) and  DOL='0000-00-00' and Is_Delete=0  order by FirstName";
		//$sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and  (ReportingTo = $empid or Id=$empid ) and  DOL='0000-00-00'";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['designationid']=$row->Designation;
				$res['designationname']=$this->getName($row->Designation,'DesignationMaster');
				$res['colindex']="";////for indexing profile add project//////
				if($row->Id==$empid)
				$res['parent'] = 0;
				else
				$res['parent'] = $row->ReportingTo;
				$res['vsts']=false;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=ROLE_MODULE_GETALL;
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function getStatus($id,$type)
	{
		$name ="";
		if($id == 0){
			$name="waiting for approval";
		}else{
			$sql = "SELECT DisplayName FROM OtherMaster WHERE ActualValue = ? and OtherType='$type'";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id ));
				while($row = $query->fetch())
				{
					$name = $row->DisplayName;
				}
			}catch(Exception $e) {

			}
		}
		return $name;
	}

	public function getApproversts($id,$sts)
	{
		$name ="0";
		if($sts==2)//approved
			$sql = "SELECT * FROM LeaveApproval where LeaveId=? and ApproverSts=? order by Id desc limit 1";
		else//pending	
			$sql = "SELECT * FROM LeaveApproval where LeaveId=? and ApproverSts=? order by Id asc limit 1";
		$query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id,$sts ));
			while($row = $query->fetch())
			{
				$name = $row->ApproverId;
			}
		}catch(Exception $e) {

		}

		return $name;
	}
	public function getApprovertimeoffsts($id,$sts)
	{
		$name ="0";
		if($sts==2)//approved
			$sql = "SELECT * FROM TimeoffApproval where timeofId=? and ApproverSts=? order by Id desc limit 1";
		else//pending	
			$sql = "SELECT * FROM TimeoffApproval where timeofId=? and ApproverSts=? order by Id asc limit 1";
		$query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id,$sts ));
			while($row = $query->fetch())
			{
				$name = $row->ApproverId;
			}
		}catch(Exception $e) {

		}

		return $name;
	}

	public function getName($id, $tablename, $column="Name")
	{
		$name ="";
		$sql = "SELECT $column FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$column;
			}
		}catch(Exception $e) {

		}
		return $name;
	}

	public function getTotalCount($orgid, $tablename)
	{
		$name ="";
		$sql = "SELECT count(*) as total FROM $tablename WHERE OrganizationId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ));
			while($row = $query->fetch())
			{
				$name = $row->total;
			}
		}catch(Exception $e) {

		}
		return $name;
	}
	//////////employee incentive////////
	////////////////////////getting weightage of objective///

	public function getWeightage($id)
	{
		$empcode =0;
		$sql = "SELECT Weightage FROM AssessmentObjectiveChild WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->Weightage;;
			}
		}catch(Exception $e) {

		}
		return $empcode;
	}
	public function getPerformanceDashboard1($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['performance'] = array();
		$data['objectivesales'] = array();
		$data['objectivenonsales'] = array();
		$data['skillgapcompetency'] = array();
		$data['competencytype'] = array();
		$data['performancedistribution'] = array();
		$data['performancedistributionsales'] = array();
		$data['performancedistributionnonsales'] = array();
		$data['performancetoplow'] = array();
		$data['topperformerlist'] = array();
		$data['bottomperformerlist'] = array();
		$data['toplowperformer'] = array();
		$data['attributelist'] = array();
		$data['traineeslist'] = array();
		$data['goalspiearr'] = array();
		$data['goalsprogressarr'] = array();

		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$ids = Utils::getReportingIds($userid, $this->db);
		//$filscalid = ($request[3]!='')?$request[3]:$_SESSION['ubihrm_fiscalid'];
		$salesdeptid=0;
		$sql = "SELECT Id FROM DepartmentMaster WHERE  OrganizationId=? and (Name='SALES AND MARKETING' OR Name like '%sales%')";
        $query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		if($r=$query->fetch())
		{
			$salesdeptid=$r->Id;
		}
	$startdate = ($request[3]!='')?$request[3]:date("Y-m-1");
	$enddate = date("Y-m-t", strtotime($startdate));	
		//$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));
		try{
			$count=0;
			if($type=="next")
			{
				/* $sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				} */
					$startdate = date("Y-m-d", strtotime("+1 months ".date($startdate)));
					$enddate =   date("Y-m-t", strtotime($startdate));
					$res = array();
					$fiscaldate=Utils::monthdateformatter($startdate)." - ".Utils::monthdateformatter($enddate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
			}
			elseif($type=="previous")
			{
				/* $sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				} */
					$startdate = date("Y-m-d", strtotime("-1 months ".date($startdate)));
					$enddate =   date("Y-m-t", strtotime($startdate));
					$res = array();
					$fiscaldate=Utils::monthdateformatter($startdate)." - ".Utils::monthdateformatter($enddate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
			}
			else{
			/* $sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				} */
				$startdate =  date("Y-m-1");
				$enddate = date("Y-m-t", strtotime($startdate));
					$res = array();
					$fiscaldate=Utils::monthdateformatter($startdate)." - ".Utils::monthdateformatter($enddate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;

			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			$keyarr= array(); $quadcolor= array();
			$label= array(); $ykey="";
		if(Utils::checkOrgPermission(221)){
			$sql = "SELECT Id, Name, Color from Quadrants where OrganizationId=? ";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $orgid ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['label'] = $row->Name;
					$res['value'] = 1;//(100/$count);
					$res['color'] = $row->Color;
					$keyarr[] = $row->Id;
					$label[] = $row->Name;
					$quadcolor[] = $row->Color;
					$data['performance'][] = $res;
				}
			}
		}
			///////////////weightage of all designations,which comes in sales department////////////		
			$sql1 = "SELECT * from AssessmentObjective where OrganizationId=? and DesignationId in (SELECT Designation FROM EmployeeMaster where Department=? group by designation)";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid,$salesdeptid ));
				$count1 =  $query1->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count1>=1)
			{
				//$keyarr= array();
				//$label= array(); $ykey="";
				while($row1 = $query1->fetch())
				{
					$res = array();
					for($i=0; $i<count($keyarr); $i++)
					{
						$res[$keyarr[$i]] = 0;
					}
					$sql2 ="SELECT SUM(Weightage) as Sum, QuadrantId FROM AssessmentObjectiveChild where AssessmentObjectiveId=? GROUP BY QuadrantId";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row1->Id));
					while($row2 = $query2->fetch())
					{
						$res[$row2->QuadrantId] = $row2->Sum;
					}
					//$ykey="";
					$res['name'] = $this->getName($row1->DesignationId,'DesignationMaster');
					$data['objectivesales']['data'][] = $res;
				}
				$data['objectivesales']['ykey']=$keyarr;
				$data['objectivesales']['label']=$label;
				$data['objectivesales']['quadcolor']=$quadcolor;
			}
			///////////////weightage of all designations,which comes in non-sales department////////////	
			$sql1 = "SELECT * from AssessmentObjective where OrganizationId=? and DesignationId in (SELECT Designation FROM EmployeeMaster where Department<>? group by designation)";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid,$salesdeptid ));
				$count1 =  $query1->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count1>=1)
			{
				//$keyarr= array();
				//$label= array(); $ykey="";
				while($row1 = $query1->fetch())
				{
					$res = array();
					for($i=0; $i<count($keyarr); $i++)
					{
						$res[$keyarr[$i]] = 0;
					}
					$sql2 ="SELECT SUM(Weightage) as Sum, QuadrantId FROM AssessmentObjectiveChild where AssessmentObjectiveId=? GROUP BY QuadrantId";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row1->Id));
					while($row2 = $query2->fetch())
					{
						$res[$row2->QuadrantId] = $row2->Sum;
					}
					//$ykey="";
					$res['name'] = $this->getName($row1->DesignationId,'DesignationMaster');
					$data['objectivenonsales']['data'][] = $res;
				}
				$data['objectivenonsales']['ykey']=$keyarr;
				$data['objectivenonsales']['label']=$label;
				$data['objectivenonsales']['quadcolor']=$quadcolor;
			}
			/*$sql = "SELECT Id, Name, Color from Quadrants where OrganizationId=? ";
			$query = $this->db->prepare($sql);
			try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();

			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";

				while($row = $query->fetch())
				{
					$total=0; $totals=0; $totalw=0;

					$sql3 = "SELECT Sum(Score) as totalscore,sum(Weightage) as totalwt FROM EmployeeAssessmentChild Ec, AssessmentObjectiveChild Ac WHERE OrganizationId=? and Ac.QuadrantId=? and Ec.ObjectiveId=Ac.Id AND EmployeeAssessmentId in (select Id from EmployeeAssessment where AssessmentSts=1 and OrganizationId=? and FromDate >= ? and ToDate<= ?)";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array( $orgid,$row->Id,$orgid ,$startdate,$enddate ));
					while($row3 = $query3->fetch())
					{
						$totals=$row3->totalscore;
						$totalw=$row3->totalwt;
					}
					if($totals !=0 && $totalw !=0){
						$total=round((($totals/$totalw)*100),2);
					}
					$res = array();
					$res['label'] = $row->Name;
					$res['value'] = $total;//(100/$count);

					$data['performancescore'][] = $res;

				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}*/

			//////////////////Performance Distribution for organization in current fiscal year///////////////
			if(Utils::checkOrgPermission(184)){
			$keyarr= array("0","0","0","0");
			$label= array('Top Performer', 'Good Performer', 'Average Performer', 'Poor Performer' );
			$keyarr1= array("10","20","65","5");
			$sql = "SELECT * FROM EmployeeAssessment WHERE  OrganizationId=? and AssessmentSts=1 and FromDate >= ? and ToDate<= ? and EmployeeId in ($ids) Group by EmployeeId";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array($orgid,$startdate,$enddate));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$status=true;
					$successMsg=$count." record found";
					while($row = $query->fetch())
					{
						$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $row->EmployeeId ));
						while($row1 = $query2->fetch())
						{
							$desig=$row1->Designation;
						}

						$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $desig ));
						$aid="";
						while($row1 = $query2->fetch())
						{
							$aid=$row1->Id;
						}
						$score=0;
						$desiglvl=explode(',',$row->DesignationLevel);
						$highlvl=0;
						$sql1 = "SELECT max(Level) as maxlevel FROM EmployeeAssessmentApproval where EmployeeAssessmentId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $row->Id ));
						if($r1=$query1->fetch())
						{
							$highlvl=$r1->maxlevel;
						}
						$sql1 = "SELECT * FROM EmployeeAssessmentChild where EmployeeAssessmentId=? and Level = $highlvl";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $row->Id ));

						while($row1 = $query1->fetch())
						{
							//$score+=(int)$row1->score;
							$avgscore=0;
							$weightage=self::getWeightage($row1->ObjectiveId);
							if($row1->Score != 0)
							$avgscore=$weightage * ($row1->Score/100);
							$score=$score+$avgscore;
						}
						if($score>100)
						$score=100;
						$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? and $score between MinMarks and MaxMarks";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $aid ));
						while($row1 = $query2->fetch())
						{
							$rate=$row1->Rating;

							if($rate==1){
								$keyarr[0] = $keyarr[0]+1;
							}elseif($rate==2){
								$keyarr[1] = $keyarr[1]+1;
							}elseif($rate==3){
								$keyarr[2] = $keyarr[2]+1;
							}elseif($rate==4){
								$keyarr[3] = $keyarr[3]+1;
							}else{
								$keyarr[3] = $keyarr[3]+1;
							}
						}
					}
					$key=1;	
					for($i=0; $i<count($label); $i++)
					{
						$res = array();
						$res['key'] ="$key ($label[$i])";
						$res['key1'] ="$label[$i]";
						$res["value"] = round(($keyarr[$i]/$count)*100,2);
						$res["nvalue"] = $keyarr[$i];
						$res["value1"] = $keyarr1[$i];
						$res['label'] =$key;
						$data['performancedistribution']['data'][] = $res;
						$key++;
					}
				}else{
				$key=1;	
				for($i=0; $i<count($label); $i++)
				{
					$res = array();
					$res['key'] ="$key ($label[$i])";
					$res['key1'] ="$label[$i]";
					$res["value"] = 0;
					$res["nvalue"] = 0;
					$res["value1"] = $keyarr1[$i];
					$res['label'] =$label[$i];
					$data['performancedistribution']['data'][] = $res;
					$key++;
				}
			}
			}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			}	
		}
			//////////////////Performance Distribution for sales and marketing department in current fiscal year///////////////
			if(Utils::checkOrgPermission(223) ){
			
			$keyarr= array("0","0","0","0");
			$label= array('Top Performer', 'Good Performer', 'Average Performer', 'Poor Performer' );
			$keyarr1= array("10","20","65","5");
			$sql = "SELECT * FROM EmployeeAssessment WHERE  OrganizationId=? and EmployeeId in (SELECT Id FROM EmployeeMaster where Department=?) and AssessmentSts=1 and FromDate >= ? and ToDate<= ? Group by EmployeeId";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array($orgid,$salesdeptid,$startdate,$enddate));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$status=true;
					$successMsg=$count." record found";

					while($row = $query->fetch())
					{
						$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $row->EmployeeId ));
						while($row1 = $query2->fetch())
						{
							$desig=$row1->Designation;
						}
						$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $desig ));
						while($row1 = $query2->fetch())
						{
							$aid=$row1->Id;
						}
						$score=0;
						$desiglvl=explode(',',$row->DesignationLevel);
						$highlvl=0;
						$sql1 = "SELECT max(Level) as maxlevel FROM EmployeeAssessmentApproval where EmployeeAssessmentId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $row->Id ));
						if($r1=$query1->fetch())
						{
							$highlvl=$r1->maxlevel;
						}
						$sql1 = "SELECT * FROM EmployeeAssessmentChild where EmployeeAssessmentId=? and Level = $highlvl";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $row->Id ));

						while($row1 = $query1->fetch())
						{
							$avgscore=0;
							$weightage=self::getWeightage($row1->ObjectiveId);
							if($row1->Score != 0)
							$avgscore=$weightage * ($row1->Score/100);
							$score=$score+$avgscore;
						}
						if($score !=0){
							if($score>100)
							$score=100;

							$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? and $score between MinMarks and MaxMarks";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array( $aid ));
							while($row1 = $query2->fetch())
							{
								$rate=$row1->Rating;

								if($rate==1){
								$keyarr[0] = $keyarr[0]+1;
								}elseif($rate==2){
								$keyarr[1] = $keyarr[1]+1;
								}elseif($rate==3){
								$keyarr[2] = $keyarr[2]+1;
								}elseif($rate==4){
								$keyarr[3] = $keyarr[3]+1;
								}else{
								$keyarr[3] = $keyarr[3]+1;
								}
							}
						}
					}
					//print_r($keyarr);
					$key=1;	
					for($i=0; $i<count($label); $i++)
					{
						$res = array();
						$res['key'] ="$key ($label[$i])";
						$res["value"] = round(($keyarr[$i]/$count)*100,2);
						$res["value1"] = $keyarr1[$i];
						$res['label'] =$label[$i];
						$data['performancedistributionsales']['data'][] = $res;
						$key++;
					}
				}else{
					$key=1;	
					for($i=0; $i<count($label); $i++)
					{
						$res = array();
						$res['key'] ="$key ($label[$i])";
						$res["value"] = 0;
						$res["value1"] = $keyarr1[$i];
						$res['label'] =$label[$i];
						$data['performancedistributionsales']['data'][] = $res;
						$key++;
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		if(Utils::checkOrgPermission(223) ){
			$keyarr= array("0","0","0","0");
			$label= array('Top Performer', 'Good Performer', 'Average Performer', 'Poor Performer' );
			$keyarr1= array("10","20","65","5");
			$sql = "SELECT * FROM EmployeeAssessment WHERE  OrganizationId=? and EmployeeId in (SELECT Id FROM EmployeeMaster where Department<>?) and AssessmentSts=1 and FromDate >= ? and ToDate<= ? Group by EmployeeId";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array($orgid,$salesdeptid,$startdate,$enddate));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$status=true;
					$successMsg=$count." record found";
					while($row = $query->fetch())
					{
						$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $row->EmployeeId ));
						while($row1 = $query2->fetch())
						{
							$desig=$row1->Designation;
						}
						$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $desig ));
						while($row1 = $query2->fetch())
						{
							$aid=$row1->Id;
						}
						$score=0;
						$desiglvl=explode(',',$row->DesignationLevel);
						$highlvl=0;
						$sql1 = "SELECT max(Level) as maxlevel FROM EmployeeAssessmentApproval where EmployeeAssessmentId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $row->Id ));
						if($r1=$query1->fetch())
						{
							$highlvl=$r1->maxlevel;
						}
						$sql1 = "SELECT * FROM EmployeeAssessmentChild where EmployeeAssessmentId=? and Level = $highlvl";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $row->Id ));

						while($row1 = $query1->fetch())
						{
							$avgscore=0;
							$weightage=self::getWeightage($row1->ObjectiveId);
							if($row1->Score != 0)
							$avgscore=$weightage * ($row1->Score/100);
							$score=$score+$avgscore;
						}
						if($score !=0){
							if($score>100)
							$score=100;
							$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? and $score between MinMarks and MaxMarks";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array( $aid ));
							while($row1 = $query2->fetch())
							{

								$rate=$row1->Rating;

								if($rate==1){
									$keyarr[0] = $keyarr[0]+1;
								}elseif($rate==2){
									$keyarr[1] = $keyarr[1]+1;
								}elseif($rate==3){
									$keyarr[2] = $keyarr[2]+1;
								}elseif($rate==4){
									$keyarr[3] = $keyarr[3]+1;
								}else{
									$keyarr[3] = $keyarr[3]+1;
								}
							}
						}
					}
					$key=1;	
					for($i=0; $i<count($label); $i++)
					{
						$res = array();
						$res['key'] ="$key ($label[$i])";
						//$res["value"] = round(($keyarr[$i]/$count)*100,2);
						$res["value"] = round(($keyarr[$i]/$count)*100,2);
						$res["value1"] = $keyarr1[$i];
						$res['label'] =$label[$i];
						$data['performancedistributionnonsales']['data'][] = $res;
						$key++;
					}
				}else{
					$key=1;	
					for($i=0; $i<count($label); $i++)
					{
						$res = array();
						$res['key'] ="$key ($label[$i])";
						$res["value"] = 0;
						$res["value1"] = $keyarr1[$i];
						$res['label'] =$label[$i];
						$data['performancedistributionnonsales']['data'][] = $res;
						$key++;
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
			$sql1 = "SELECT * from CompetencyType where OrganizationId=? ";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();

				if($count1>=1)
				{
					//$keyarr= array();
					//$label= array(); $ykey="";
					while($row1 = $query1->fetch())
					{
						$sql3 ="SELECT sum(AssessedLevel) as stotal,sum(DesireLevel) as dtotal FROM SkillGapChild ak,CompetencyAnalysisChild ca where ak.AnalysisId=ca.Id and CompetencyType=? and SkillGapId in (select Id from SkillGapAssessment where AssessmentSts=1 and FromDate >= ? and ToDate<= ?);";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $row1->Id,$startdate,$enddate));
						$gap=0;	
						while($row2 = $query3->fetch())
						{
							$gap=$row2->dtotal-$row2->stotal;
							$res = array();
							$res['label']=$row1->Name;
							$res['value']=0;
							if($gap>0){
								$res['value']=$gap;
							}
							$data['skillgapresult']['data'][] = $res;
						}	
						//$ykey="";
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			$sql1 = "SELECT * from CompetencyMaster where OrganizationId=? Group By Name";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();
				if($count1>=1)
				{
					while($row1 = $query1->fetch())
					{
						$res=array();
						$res['value']=1;	
						$res['label']=$row1->Name;	
						$data['skillgapcompetency']['data'][] = $res;
					}
				}
				$sql1 = "SELECT * from CompetencyType where OrganizationId=? Group By Name";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();
				if($count1>=1)
				{
					while($row1 = $query1->fetch())
					{
						$res=array();
						$res['value']=1;	
						$res['label']=$row1->Name;	
						$res['color']=$row1->Color;	
						$data['competencytype']['data'][] = $res;
					}
				}
			}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			}
			/////top performers///////
			$top=0;$bottom=0;$trainee=0;
			$sql1 = "SELECT Rating FROM EmployeeAssessment WHERE OrganizationId=? and FromDate>= '$startdate' and ToDate<='$enddate' and EmployeeId in ($ids)";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();
				$res=array();
				if($count1>=1)
				{	
					while($row1 = $query1->fetch())
					{
						if($row1->Rating >3)
							$top++;
						if($row1->Rating <3 && $row1->Rating >0)
							$bottom++;
						/* $sql2 = "SELECT id FROM RatingCriteria WHERE org_id=? and rating>3 and ? between MinMarks and MaxMarks";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $orgid, $row1->percentage));
						if($query2->rowCount()>0){
						$top=$top+1;}
						$sql3 = "SELECT * FROM RatingCriteria WHERE org_id=? and rating<3 and ? between MinMarks and MaxMarks";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $orgid, $row1->percentage));
						if($query3->rowCount()>0){
						$bottom=$bottom+1;} */
					}
				}
				 $sql1 = "SELECT distinct trainee from training where OrganizationId=? and startdate >= '$startdate' and enddate <='$enddate' and trainee in ($ids)";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();
				if($count1>=1)
				{
					while($row1 = $query1->fetch())
					{
						$trainee=$trainee+1;
					}
				} 
				$res['trainees']=$trainee;
				$res['topperformer']=$top;
				$res['bottomperformer']=$bottom;
				$data['toplowperformer'] = $res;
			}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			}
////graph to find performance by attributes////
				/* $minrating=0;
				$maxrating=0;

				$sqlr ="SELECT MinMarks, MaxMarks from RatingCriteria where org_id=? and Rating=3";
					$queryr= $this->db->prepare($sqlr);
					$queryr->execute(array($orgid));
					while($rowr = $queryr->fetch()){
						$minrating=$rowr->MinMarks;
						$maxrating=$rowr->MaxMarks;
						} */
			if(Utils::checkOrgPermission(184) ){
		 	$sql1 = "SELECT * from EmployeeAssessment where OrganizationId=? and FromDate >= '$startdate' and ToDate <='$enddate' and EmployeeId in ($ids)";
			// and FromDate >= '$startdate' and ToDate <='$enddate' and EmployeeId in ($ids)
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array($orgid));
				$count1 =  $query1->rowCount();
			if($count1>=1)
			{
				$res1=array();
				while($row1 = $query1->fetch())
				{
					$top=1;
					$good=2;
					$average=3;
					$poor=4;

					if($row1->Rating!=0){
						$res = array();
					/* $sql2 ="Select EmployeeAssessmentId from EmployeeAssessmentApproval where DesignationId =?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($row1->DesignationId));
					if($query2->rowCount()){
					while($row2 = $query2->fetch())
					{
						$sql3 ="SELECT Rating from EmployeeAssessment where Id=? and FromDate>= '$startdate' and ToDate<='$enddate'";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array($row2->EmployeeAssessmentId));
						while($row3 = $query3->fetch())
						{
							if($row3->Rating >3)
								$top++;
							elseif($row3->Rating < 3 && $row3->Rating > 0)
								$bottom++;
							elseif($row3->Rating == 3)
								$medium++;
						}
						//$res['attribute']=$per;
						//$res['label']=$row2->Objective;
						/* 
						if($row2->percentage >$maxrating){
						$top = $top+1;
						}
						elseif($row2->percentage <$minrating)
						{
						$bottom = $bottom+1;
						}
						else{
						$medium = $medium+1;
						} 
						$res['top']=$top;
						$res['medium']=$medium;
						$res['bottom']=$bottom; 
					} */

					//$ykey="";
					//$label=explode('(', $row1->attribute, 2);	
					if($row1->Rating==5)
					{
						$res['x']=$top;
					}
					elseif($row1->Rating==4)
					{
						$res['x']=$good;
					}elseif($row1->Rating==3)
					{
						$res['x']=$average;
					}elseif($row1->Rating==2 || $row1->Rating==1)
					{
						$res['x']=$poor;
					}					
					$res['value'] = Utils::getEmployeeName($row1->EmployeeId,$this->db);
					$image = $this->getName($row1->EmployeeId,'EmployeeMaster','ImageName');
					$gen = $this->getName($row1->EmployeeId,'EmployeeMaster','Gender');
					if($image != ""){
					$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
					}
					else{
						if($gen == 1){
							$res['image']= URL."public/avatars/male.png";
						}
						else{
							$res['image']= URL."public/avatars/female.png";
						}
					}
					$res['y'] = round((($row1->ObtainedMarks * 100)/$row1->TotalMarks),2);
					$data['performancetoplow']['data'][] = $res;
					}
					}
					//$res1[]=$row1->attribute;
				}

				//$data['performancetoplow']['ykey']=$keyarr;
				//$data['performancetoplow']['label']=$labels;
				//$data['performancetoplow']['quadcolor']=$quadcolor;

			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			}/*   */
			/////top performers detail/////
			$sql1 = "SELECT EmployeeId, Rating FROM EmployeeAssessment WHERE OrganizationId=? and FromDate>= '$startdate' and ToDate<='$enddate' and EmployeeId in ($ids)";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();
				$result=array();
				if($count1>=1)
				{	
					while($row1 = $query1->fetch())
					{
						$res=array();
						/* $sql3 = "SELECT rating FROM RatingCriteria WHERE org_id=? and ? between MinMarks and MaxMarks";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $orgid, $row1->percentage));
						$row3 = $query3->fetch();
						if($query3->rowCount() >0){*/
						if($row1->Rating>3){ 
						$res=array();
						$res['id']=$row1->EmployeeId;
						$res['name']=Utils::getEmployeeName($row1->EmployeeId,$this->db);
						$sql2 = "SELECT Designation, ImageName,Gender from EmployeeMaster where Id=?";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($row1->EmployeeId));
						$count2 =  $query2->rowCount();
						$row2 = $query2->fetch();
						$res['designation']=$this->getName($row2->Designation,'DesignationMaster');
						for($i=1;$i<=$row1->Rating;$i++)
						$res['rating'][]=$i;
						$image=$row2->ImageName;
					if($image != ""){
					$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
					}
					else{
						$gen=$row2->Gender;
						if($gen == 1){
							$res['image']= URL."public/avatars/male.png";
						}
						else{
							$res['image']= URL."public/avatars/female.png";
						}
					}

						$result[]=$res;
					 }/*
					} */}
				}

				/*  $sql1 = "SELECT distinct trainee from training where OrganizationId=? and startdate >= '$startdate' and enddate <='$enddate'";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();
				if($count1>=1)
				{
					while($row1 = $query1->fetch())
					{
						$trainee=$trainee+1;
					}
				}  */
				/* $res['trainees']=$trainee;
				$res['topperformer']=$top;
				$res['bottomperformer']=$bottom; */
				$data['topperformerlist'] = $result;
			}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			}

			/////bottom performers detail/////
			$sql1 = "SELECT EmployeeId, Rating FROM EmployeeAssessment WHERE OrganizationId=? and FromDate>= '$startdate' and ToDate<='$enddate' and EmployeeId in ($ids)";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();

				$result=array();
				if($count1>=1)
				{	
					while($row1 = $query1->fetch())
					{$res=array();
						/* $sql3 = "SELECT rating FROM RatingCriteria WHERE org_id=? and ? between MinMarks and MaxMarks";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $orgid, $row1->percentage));
						$row3 = $query3->fetch();
						if($query3->rowCount() >0){ */
						if($row1->Rating<3 && $row1->Rating>0){
						$res=array();
						$res['id']=$row1->EmployeeId;
						$res['name']=Utils::getEmployeeName($row1->EmployeeId,$this->db);
						$sql2 = "SELECT Designation, ImageName,Gender from EmployeeMaster where Id=?";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($row1->EmployeeId));
						$count2 =  $query2->rowCount();
						$row2 = $query2->fetch();
						$res['designation']=$this->getName($row2->Designation,'DesignationMaster');
						for($i=1;$i<=$row1->Rating;$i++)
						$res['rating'][]=$i;
						$image=$row2->ImageName;
					if($image != ""){
					$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
					}
					else{
						$gen=$row2->Gender;
						if($gen == 1){
							$res['image']= URL."public/avatars/male.png";
						}
						else{
							$res['image']= URL."public/avatars/female.png";
						}
					}

						$result[]=$res;
					}
					/* } */}
				}
				$data['bottomperformerlist'] = $result;
			}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			}
			/////////Trainees List///////////
			$sql1 = "SELECT trainee FROM training WHERE OrganizationId=? and startdate >= '$startdate' and enddate<='$enddate' and trainee in ($ids) group by trainee";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();

				$result=array();
				if($count1>=1)
				{	
					while($row1 = $query1->fetch())
					{	$res=array();
						/* $sql3 = "SELECT rating FROM RatingCriteria WHERE org_id=? and ? between MinMarks and MaxMarks";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $orgid, $row1->percentage));
						$row3 = $query3->fetch(); */
						//$res['id']=$row1->trainee;
						$res['name']=Utils::getEmployeeName($row1->trainee,$this->db);
						$sql2 = "SELECT Designation, ImageName,Gender from EmployeeMaster where Id=?";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($row1->trainee));
						$count2 =  $query2->rowCount();
						$row2 = $query2->fetch();
						$res['designation']=$this->getName($row2->Designation,'DesignationMaster');
						$image=$row2->ImageName;
					if($image != ""){
					$res['image']= URL."public/uploads/$orgid/$image". "?img=" .rand(1,100);
					}
					else{
						$gen=$row2->Gender;
						if($gen == 1){
							$res['image']= URL."public/avatars/male.png";
						}
						else{
							$res['image']= URL."public/avatars/female.png";
						}
					}
						$result[]=$res;

					}
				}
				$data['traineeslist'] = $result;
			}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			}

			////////for donut of attributes//////
			$sql1 = "SELECT Id, DesignationId from AssessmentObjective where OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $orgid ));
				$count1 =  $query1->rowCount();
				if($count1>=1)
				{
					while($row1 = $query1->fetch())
					{
						$sql2 = "SELECT count(Id) as total from AssessmentObjectiveChild where AssessmentObjectiveId=?";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $row1->Id ));
						$row2 =  $query2->fetch();
						$res=array();
						$res['value']=$row2->total;
						$res['label']=$this->getName($row1->DesignationId,'DesignationMaster');
						$data['attributelist']['data'][] = $res;
					}
				}
			}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			}
			/*get goals pie chart*/
			if(Utils::checkOrgPermission(253) ){
			$goals=array();
			$sql = "SELECT * FROM GoalMaster WHERE OrganizationId = :id";
			$query = $this->db->prepare($sql);
			
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				$overachieve=0;
				$totalgoals=0;
				$inprogress=0;
				$notstarted=0;
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['gid'] = Utils::encode5t($row->Id);
					$res['dept'] = Utils::getName($row->DepartmentId,"DivisionMaster","Name",$this->db);
					$res['emp'] = Utils::getName($row->EmployeeId,"EmployeeMaster","FirstName",$this->db);
					$res['fromdate'] =  date("d M'y",strtotime($row->StartDate));
					$res['todate'] =  date("d M'y",strtotime($row->EndDate));
					$res['goal'] = $row->Goal;
					$res['status'] =$row->Status ;
					$res['weightage'] =  (int)$row->Weightage;
					$res['taskgiven'] =  (int)$row->TaskNumber;
					$res['quadrant'] =  Utils::getName($row->Quadrant,"Quadrants","Name",$this->db);
					
					
					$departmentgoal = array(); $totalwt=0;
					$sql1 = "SELECT * FROM DepartmentGoals WHERE GoalId = :id ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array(':id' =>  $row->Id ));
					while($row1 = $query1->fetch())
					{
						$res1=array();
						$res1['id'] = $row1->Id;
						$res1['dept'] = $row1->DepartmentId;
						$res1['deptname'] =  Utils::getName($row1->DepartmentId,"DepartmentMaster","Name",$this->db);
						$res1['fromdate'] =  date("d M'y",strtotime($row1->StartDate));
						$res1['todate'] =  date("d M'y",strtotime($row1->EndDate));
						$res1['goal'] = $row1->Goal;
						$res1['desc'] = $row1->Description;
						$res1['weightage'] = (int)$row1->Weightage;
						$res1['taskgiven'] =  (int)$row1->TaskNumber;
						$res1['quadrant'] = Utils::getName($row1->Quadrant,"Quadrants","Name",$this->db);
						$teamgoal=array(); $departmentwt=0;
						$sql2 = "SELECT * FROM TeamGoals WHERE GoalId = :id and DepartmentId = :did";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array(':id' =>  $row->Id , ':did' =>  $row1->Id));
						while($row2 = $query2->fetch())
						{
							$res2=array();
							$res2['id'] = $row2->Id;
							$res2['empid'] = $row2->EmployeeId;
							$res2['emp'] =  Utils::getName($row2->EmployeeId,"EmployeeMaster","FirstName",$this->db)." ".Utils::getName($row2->EmployeeId,"EmployeeMaster","LastName",$this->db);;
							$imgname =  Utils::getName($row2->EmployeeId,"EmployeeMaster","ImageName",$this->db);
							$pic="";
							$color = sprintf('%06X', mt_rand(0, 16777215));
							$name=$res2['emp'];
							$photo="public/uploads/$orgid/".$imgname;
							$res2['empletter'] =""; 
							if($imgname && file_exists($photo)){
								$res2['empimg'] =URL.$photo;
							}
							else{
								if(isset($name[0])){
									$pic='<p data-letters="'.strtoupper($name[0]).'" style="background-color:#'.$color.'"></p>';
									$res2['empletter'] =strtoupper($name[0]);
								}
							}
							//$res1['empimg'] = $pic;
							
							$res2['fromdate'] =  date("d M'y",strtotime($row2->StartDate));
							$res2['todate'] =  date("d M'y",strtotime($row2->EndDate));
							$res2['goal'] = $row2->Goal;
							$res2['desc'] = $row2->Description;
							$res2['weightage'] =$row2->Weightage;
							$res2['taskgiven'] =  (int)$row2->TaskNumber;
							$res2['givenweightage'] =$this->getEmployeeTaskscount($row2->Id, $row2->EmployeeId);
							$departmentwt=$departmentwt+$res2['givenweightage'] ;
							$res2['quadrant'] = Utils::getName($row2->Quadrant,"Quadrants","Name",$this->db);
							$res2['progress'] =0;
							if($res2['taskgiven'] !=0)
							$res2['progress'] =round(($res2['givenweightage']/$res2['taskgiven'] )*100,2);
							$teamgoal[]=$res2;
						}
						$res1['givenweightage'] = $departmentwt;
						$res1['progress'] =0;
							if($res1['taskgiven'] !=0)
						$res1['progress'] =round(($res1['givenweightage']/$res1['taskgiven'] )*100,2);
						$totalwt=$totalwt+$res1['givenweightage'];
						$res1['teamgoals']=$teamgoal;
						$departmentgoal[]=$res1;
					}
					$res['givenweightage'] =$totalwt;
					$res['progress'] =0;
						if($res['taskgiven'] !=0)
					$res['progress'] =round(($res['givenweightage']/$res['taskgiven'] )*100,2);
					$res['departmentgoal']=$departmentgoal;
					if($res['progress']>100){
						$overachieve++;
					}if($res['progress']<100 && $res['progress']>0){
						$inprogress++;
					}if($res['progress']==0){
						$notstarted++;
					}
					$totalgoals++;
					$data['goalsprogressarr']['data'][] = $res;
				}
				$goalres=array();
				$goalres['value']= $totalgoals;
				$goalres['label']= "Total Goals";
				$goalres['color']= "#4775ba";
				$data['goalspiearr']['data'][] = $goalres;
				$goalres=array();
				$goalres['value']= $overachieve;
				$goalres['label']= "Over Acheived Goals";
				$goalres['color']= "#5cc8ea";
				$data['goalspiearr']['data'][] = $goalres;
				$goalres=array();
				$goalres['value']= $inprogress;
				$goalres['label']= "In Progress Goals";
				$goalres['color']= "#33827d";
				$data['goalspiearr']['data'][] = $goalres;
				$goalres=array();
				$goalres['value']= $notstarted;
				$goalres['label']= "Not Started Goals";
				$goalres['color']= "#6a2e2e";
				$data['goalspiearr']['data'][] = $goalres;
			}else{
				$status=true;
				$successMsg = OBJECTIVE_MODULE_GETALL;
			}
			}
			$result["data"] =$data;
			$result['filscalid']=$startdate;
			$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
			$result['status']=true;
			$result['successMsg']=$successMsg;
			$result['errorMsg']=$errorMsg;

			return $result;
		}
	
	public function getEmployeeTaskscount($goalid,$empid)
	{
		$count =0;
		$sql = "SELECT GivenWeightage FROM task_master WHERE assignto = ? and GoalId=? and taskstatus=4";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid, $goalid ));
			while($row = $query->fetch())
			{
				$count = $count + $row->GivenWeightage;
			}
		}catch(Exception $e) {
			
		}
		return $count;
	}
	
	public function getPerformanceReportingDashboard($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$data['performance'] = array();
		$data['objectivesales'] = array();
		$data['objectivenonsales'] = array();
		$data['skillgapcompetency'] = array();
		$data['competencytype'] = array();
		$data['performancedistribution'] = array();
		$data['performancedistributionsales'] = array();
		$data['performancedistributionnonsales'] = array();

		//$data['leavecolor'] = array();
		$userid = $request[0];
		$orgid = $request[1];
		$type = $request[2];///type previous and nex//////////
		$filscalid = ($request[3]!=0)?$request[3]:$_SESSION['ubihrm_fiscalid'];

		$ids = Utils::getReportingIds($userid, $this->db);
		$salesdeptid=0;
		$sql = "SELECT Id FROM DepartmentMaster WHERE  OrganizationId=? and (Name='SALES  AND MARKETING' OR Name like '%sales%') ";
        $query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		if($r=$query->fetch())
		{
			$salesdeptid=$r->Id;
		}
		$startdate = date("Y-04-01");
			//$enddate =  date("Y-m-d");
		$enddate =date("Y-03-t", strtotime("+1 year ".date($startdate)));

		$count=0;
			if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}
			else{
			$sql = "SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$filscalid=  $row->Id;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}

		$keyarr= array(); $quadcolor= array();
		$label= array(); $ykey="";

        $sql = "SELECT Id, Name, Color from Quadrants where OrganizationId=? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['label'] = $row->Name;
				$res['value'] = 1;//(100/$count);
				$res['color'] = $row->Color;

				$keyarr[] = $row->Id;
				$label[] = $row->Name;
				$quadcolor[] = $row->Color;

				$data['performance'][] = $res;

			}
        }

        ///////////////weightage of all designations,which comes in sales department////////////		
        $sql1 = "SELECT * from AssessmentObjective where OrganizationId=? and DesignationId in (SELECT Designation FROM EmployeeMaster where Department=? and Id in ($ids) group by designation)";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( $orgid,$salesdeptid ));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			//$keyarr= array();
			//$label= array(); $ykey="";
			while($row1 = $query1->fetch())
			{
				$res = array();
				for($i=0; $i<count($keyarr); $i++)
				{
					$res[$keyarr[$i]] = 0;
				}
				$sql2 ="SELECT SUM(Weightage) as Sum, QuadrantId FROM AssessmentObjectiveChild where AssessmentObjectiveId=? GROUP BY QuadrantId";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $row1->Id));

				while($row2 = $query2->fetch())
				{

					$res[$row2->QuadrantId] = $row2->Sum;

				}
				//$ykey="";
				$res['name'] = $this->getName($row1->DesignationId,'DesignationMaster');
				$data['objectivesales']['data'][] = $res;

			}
			$data['objectivesales']['ykey']=$keyarr;
			$data['objectivesales']['label']=$label;
			$data['objectivesales']['quadcolor']=$quadcolor;
        }
		///////////////weightage of all designations,which comes in non-sales department////////////	
		$sql1 = "SELECT * from AssessmentObjective where OrganizationId=? and DesignationId in (SELECT Designation FROM EmployeeMaster where Department<>? and Id in ($ids) group by designation)";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( $orgid,$salesdeptid ));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			//$keyarr= array();
			//$label= array(); $ykey="";
			while($row1 = $query1->fetch())
			{
				$res = array();
				for($i=0; $i<count($keyarr); $i++)
				{
					$res[$keyarr[$i]] = 0;
				}
				$sql2 ="SELECT SUM(Weightage) as Sum, QuadrantId FROM AssessmentObjectiveChild where AssessmentObjectiveId=? GROUP BY QuadrantId";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $row1->Id));

				while($row2 = $query2->fetch())
				{

					$res[$row2->QuadrantId] = $row2->Sum;

				}
				//$ykey="";
				$res['name'] = $this->getName($row1->DesignationId,'DesignationMaster');
				$data['objectivenonsales']['data'][] = $res;

			}
			$data['objectivenonsales']['ykey']=$keyarr;
			$data['objectivenonsales']['label']=$label;
			$data['objectivenonsales']['quadcolor']=$quadcolor;
        }

		/*$sql = "SELECT Id, Name, Color from Quadrants where OrganizationId=? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();

			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";

				while($row = $query->fetch())
				{
					$total=0; $totals=0; $totalw=0;

					$sql3 = "SELECT Sum(Score) as totalscore,sum(Weightage) as totalwt FROM EmployeeAssessmentChild Ec, AssessmentObjectiveChild Ac WHERE OrganizationId=? and Ac.QuadrantId=? and Ec.ObjectiveId=Ac.Id AND EmployeeAssessmentId in (select Id from EmployeeAssessment where AssessmentSts=1 and OrganizationId=? and FromDate >= ? and ToDate<= ?)";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array( $orgid,$row->Id,$orgid ,$startdate,$enddate ));
					while($row3 = $query3->fetch())
					{
						$totals=$row3->totalscore;
						$totalw=$row3->totalwt;
					}
					if($totals !=0 && $totalw !=0){
						$total=round((($totals/$totalw)*100),2);
					}
					$res = array();
					$res['label'] = $row->Name;
					$res['value'] = $total;//(100/$count);

					$data['performancescore'][] = $res;

				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}*/

		//////////////////Performance Distribution for organization in current fiscal year///////////////
		$keyarr= array("0","0","0","0");
		$label= array('Top Performer', 'Good Performer', 'Average Performer', 'Poor Performer' );
		$keyarr1= array("10","20","65","5");
		$sql = "SELECT * FROM EmployeeAssessment WHERE  OrganizationId=? and EmployeeId in ($ids) and AssessmentSts=1 and FromDate >= ? and ToDate<= ? Group by EmployeeId";
        $query = $this->db->prepare($sql);

		try{

			$query->execute(array($orgid,$startdate,$enddate));
			$count =  $query->rowCount();

			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";

				while($row = $query->fetch())
				{

					$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->EmployeeId ));
					while($row1 = $query2->fetch())
					{
						$desig=$row1->Designation;
					}

					$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $desig ));
					while($row1 = $query2->fetch())
					{
						$aid=$row1->Id;
					}
					$score=0;
					$desiglvl=explode(',',$row->DesignationLevel);
					$highlvl=0;
					$sql1 = "SELECT max(Level) as maxlevel FROM EmployeeAssessmentApproval where EmployeeAssessmentId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));
					if($r1=$query1->fetch())
					{
						$highlvl=$r1->maxlevel;
					}
					$sql1 = "SELECT * FROM EmployeeAssessmentChild where EmployeeAssessmentId=? and Level = $highlvl";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));

					while($row1 = $query1->fetch())
					{
						$avgscore=0;
						$weightage=self::getWeightage($row1->ObjectiveId);
						if($row1->Score != 0)
							$avgscore=$weightage * ($row1->Score/100);
						$score=$score+$avgscore;
					}
					if($score !=0){
						if($score>100)
							$score=100;
						$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? and $score between MinMarks and MaxMarks";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $aid ));
						while($row1 = $query2->fetch())
						{
							$rate=$row1->Rating;

							if($rate==1){
								$keyarr[0] = $keyarr[0]+1;
							}elseif($rate==2){
								$keyarr[1] = $keyarr[1]+1;
							}elseif($rate==3){
								$keyarr[2] = $keyarr[2]+1;
							}elseif($rate==4){
								$keyarr[3] = $keyarr[3]+1;
							}else{
								$keyarr[3] = $keyarr[3]+1;
							}
						}

					}

				}
				$key=1;	
				for($i=0; $i<count($label); $i++)
				{
					$res = array();
					$res['key'] ="$key ($label[$i])";
					$res['key1'] ="$label[$i]";
					$res["value"] = round(($keyarr[$i]/$count)*100,2);
					$res["nvalue"] = $keyarr[$i];
					$res["value1"] = $keyarr1[$i];
					$res['label'] =$key;
					$data['performancedistribution']['data'][] = $res;
					$key++;
				}

			}else{
				$key=1;	
				for($i=0; $i<count($label); $i++)
				{
					$res = array();
					$res['key'] ="$key ($label[$i])";
					$res['key1'] ="$label[$i]";
					$res["value"] = 0;
					$res["nvalue"] = 0;
					$res["value1"] = $keyarr1[$i];
					$res['label'] =$label[$i];
					$data['performancedistribution']['data'][] = $res;
					$key++;
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}	

		//////////////////Performance Distribution for sales and marketing department in current fiscal year///////////////

		$keyarr= array("0","0","0","0");
		$label= array('Top Performer', 'Good Performer', 'Average Performer', 'Poor Performer' );
		$keyarr1= array("10","20","65","5");

		$sql = "SELECT * FROM EmployeeAssessment WHERE  OrganizationId=? and EmployeeId in (SELECT Id FROM EmployeeMaster where Department=? and Id in ($ids)) and AssessmentSts=1 and FromDate >= ? and ToDate<= ? Group by EmployeeId";
        $query = $this->db->prepare($sql);

		try{

			$query->execute(array($orgid,$salesdeptid,$startdate,$enddate));
			$count =  $query->rowCount();

			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";

				while($row = $query->fetch())
				{
					$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->EmployeeId ));
					while($row1 = $query2->fetch())
					{
						$desig=$row1->Designation;
					}

					$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $desig ));
					while($row1 = $query2->fetch())
					{
						$aid=$row1->Id;
					}
					$score=0;
					$desiglvl=explode(',',$row->DesignationLevel);
					$highlvl=0;
					$sql1 = "SELECT max(Level) as maxlevel FROM EmployeeAssessmentApproval where EmployeeAssessmentId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));
					if($r1=$query1->fetch())
					{
						$highlvl=$r1->maxlevel;
					}
					$sql1 = "SELECT * FROM EmployeeAssessmentChild where EmployeeAssessmentId=? and Level = $highlvl";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));

					while($row1 = $query1->fetch())
					{
						$avgscore=0;
						$weightage=self::getWeightage($row1->ObjectiveId);
						if($row1->Score != 0)
							$avgscore=$weightage * ($row1->Score/100);
						$score=$score+$avgscore;
					}
					if($score !=0){
						if($score>100)
							$score=100;
						$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? and $score between MinMarks and MaxMarks";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $aid ));
						while($row1 = $query2->fetch())
						{

							$rate=$row1->Rating;

							if($rate==1){
								$keyarr[0] = $keyarr[0]+1;
							}elseif($rate==2){
								$keyarr[1] = $keyarr[1]+1;
							}elseif($rate==3){
								$keyarr[2] = $keyarr[2]+1;
							}elseif($rate==4){
								$keyarr[3] = $keyarr[3]+1;
							}else{
								$keyarr[3] = $keyarr[3]+1;
							}
						}
					}

				}
				$key=1;	
				for($i=0; $i<count($label); $i++)
				{
					$res = array();
					$res['key'] ="$key ($label[$i])";
					$res["value"] = round(($keyarr[$i]/$count)*100,2);
					$res["value1"] = $keyarr1[$i];
					$res['label'] =$label[$i];
					$data['performancedistributionsales']['data'][] = $res;
					$key++;
				}

			}else{
				$key=1;	
				for($i=0; $i<count($label); $i++)
				{
					$res = array();
					$res['key'] ="$key ($label[$i])";
					$res["value"] = 0;
					$res["value1"] = $keyarr1[$i];
					$res['label'] =$label[$i];
					$data['performancedistributionsales']['data'][] = $res;
					$key++;
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$keyarr= array("0","0","0","0");
		$label= array('Top Performer', 'Good Performer', 'Average Performer', 'Poor Performer' );
		$keyarr1= array("10","20","65","5");
		$sql = "SELECT * FROM EmployeeAssessment WHERE  OrganizationId=? and EmployeeId in (SELECT Id FROM EmployeeMaster where Department<>? and Id in ($ids)) and AssessmentSts=1 and FromDate >= ? and ToDate<= ? Group by EmployeeId";
        $query = $this->db->prepare($sql);

		try{

			$query->execute(array($orgid,$salesdeptid,$startdate,$enddate));
			$count =  $query->rowCount();

			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";

				while($row = $query->fetch())
				{
					$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->EmployeeId ));
					while($row1 = $query2->fetch())
					{
						$desig=$row1->Designation;
					}

					$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $desig ));
					while($row1 = $query2->fetch())
					{
						$aid=$row1->Id;
					}
					$score=0;
					$desiglvl=explode(',',$row->DesignationLevel);
					$highlvl=0;
					///////////////findout the highest level of assessment///////////
					$sql1 = "SELECT max(Level) as maxlevel FROM EmployeeAssessmentApproval where EmployeeAssessmentId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));
					if($r1=$query1->fetch())
					{
						$highlvl=$r1->maxlevel;
					}
					$sql1 = "SELECT * FROM EmployeeAssessmentChild where EmployeeAssessmentId=? and Level = $highlvl";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->Id ));

					while($row1 = $query1->fetch())
					{
						$avgscore=0;
						$weightage=self::getWeightage($row1->ObjectiveId);
						if($row1->Score != 0)
							$avgscore=$weightage * ($row1->Score/100);
						$score=$score+$avgscore;
					}

					if($score !=0){
						if($score>100)
							$score=100;
						$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? and $score between MinMarks and MaxMarks";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $aid ));
						while($row1 = $query2->fetch())
						{

							$rate=$row1->Rating;

							if($rate==1){
								$keyarr[0] = $keyarr[0]+1;
							}elseif($rate==2){
								$keyarr[1] = $keyarr[1]+1;
							}elseif($rate==3){
								$keyarr[2] = $keyarr[2]+1;
							}elseif($rate==4){
								$keyarr[3] = $keyarr[3]+1;
							}else{
								$keyarr[3] = $keyarr[3]+1;
							}
						}
					}

				}
				$key=1;	
				for($i=0; $i<count($label); $i++)
				{
					$res = array();
					$res['key'] ="$key ($label[$i])";
					$res["value"] = round(($keyarr[$i]/$count)*100,2);
					$res["value1"] = $keyarr1[$i];
					$res['label'] =$label[$i];
					$data['performancedistributionnonsales']['data'][] = $res;
					$key++;
				}

			}else{
				$key=1;	
				for($i=0; $i<count($label); $i++)
				{
					$res = array();
					$res['key'] ="$key ($label[$i])";
					$res["value"] = 0;
					$res["value1"] = $keyarr1[$i];
					$res['label'] =$label[$i];
					$data['performancedistributionnonsales']['data'][] = $res;
					$key++;
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$sql1 = "SELECT * from CompetencyType where OrganizationId=? ";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( $orgid ));
			$count1 =  $query1->rowCount();

		if($count1>=1)
		{
			//$keyarr= array();
			//$label= array(); $ykey="";
			while($row1 = $query1->fetch())
			{
				$sql3 ="SELECT sum(AssessedLevel) as stotal,sum(DesireLevel) as dtotal FROM SkillGapChild ak,CompetencyAnalysisChild ca where ak.AnalysisId=ca.Id and CompetencyType=? and SkillGapId in (select Id from SkillGapAssessment where AssessmentSts=1 and FromDate >= ? and ToDate<= ?);";
				$query3 = $this->db->prepare($sql3);
				$query3->execute(array( $row1->Id,$startdate,$enddate));
				$gap=0;	
				while($row2 = $query3->fetch())
				{
					$gap=$row2->dtotal-$row2->stotal;
					$res = array();
					$res['label']=$row1->Name;
					$res['value']=0;
					if($gap>0){
						$res['value']=$gap;
					}
					$data['skillgapresult']['data'][] = $res;
				}
				//$ykey="";

			}

        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$sql1 = "SELECT * from CompetencyMaster where OrganizationId=? Group By Name";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( $orgid ));
			$count1 =  $query1->rowCount();

		if($count1>=1)
		{

			while($row1 = $query1->fetch())
			{

				$res=array();
				$res['value']=1;	
				$res['label']=$row1->Name;	

				$data['skillgapcompetency']['data'][] = $res;

			}

        }

		$sql1 = "SELECT * from CompetencyType where OrganizationId=? Group By Name";
        $query1 = $this->db->prepare($sql1);

			$query1->execute(array( $orgid ));
			$count1 =  $query1->rowCount();

		if($count1>=1)
		{
			while($row1 = $query1->fetch())
			{
				$res=array();
				$res['value']=1;	
				$res['label']=$row1->Name;	
				$res['color']=$row1->Color;	
				$data['competencytype']['data'][] = $res;
			}
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['filscalid']=$filscalid;
		$result['fiscal_format']=(date("M'y", strtotime(date($startdate)))." - ".date("M'y", strtotime(date($enddate))));
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

    public function getHierarchy1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();

		$mid    = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid  = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$divi   = $request[2];
		$dept   = $request[3];			
		/*$ids = Utils::getReportingIds($empid, $this->db);
		$ids = $ids.",". $empid;
        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and  Id in ( $ids ) and  DOL='0000-00-00'";*/
		$sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo, Department, Division FROM EmployeeMaster WHERE OrganizationId = ? and Is_Delete=0 AND  (Division = $divi AND Department = $dept)";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			$i=0; $id='';

			$res1=array();
			$res1['id'] = 1;
			$res1['name'] = Utils::getName($divi, 'DivisionMaster', 'Name', $this->db).' / '.Utils::getName($dept, 'DepartmentMaster', 'Name', $this->db);
			$res1['parent'] = 0;
			$id=1;

			$data[]=$res1;
			$parent=0;//$index=0;
			while($row = $query->fetch())
			{
				//$index++;
				//$parent=$row->ReportingTo;
				$sql1 = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and Is_Delete=0 AND (Division = $divi AND Department = $dept) OR ReportingTo in ($parent)";
				$query1 = $this->db->prepare($sql1);
				try{
					$query1->execute(array(':id' => $orgid ));
					$parent="";
					while($row2 = $query1->fetch())
					{
						if($parent=="")
							$parent = $row2->Id;
						else
							$parent .= ",".$row2->Id;

						$res = array();
						$res['id'] = (int)$row2->Id;
						$res['name'] = $row2->EmployeeCode."<br> ".ucwords(strtolower($row2->FirstName." ".$row2->LastName));
						$res['parent'] = (int)($row2->ReportingTo==0)?1:$row2->ReportingTo;
						$data[] = $res;
					}
				}
				catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				/*$res = array();

				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode."<br> ".ucwords(strtolower($row->FirstName." ".$row->LastName));

				if($row->Id==$mid)
					$res['parent'] = 0;
				else
					$res['parent'] = $row->ReportingTo;

				$data[] = $res;*/
			}

        	}else{
			$status=false;
			$successMsg="Hierarchy get detail success!";
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

    public function getHierarchy($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();

		$mid    = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid  = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$divi   = $request[2];
		$dept   = $request[3];	
		$whrdiv="";  $whrdept="";  
		if($dept!="")
			$whrdept="AND Department = $dept";	
		if($divi!="")
			$whrdiv="AND Division = $divi";	
		/*$ids = Utils::getReportingIds($empid, $this->db);
		$ids = $ids.",". $empid;
        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and  Id in ( $ids ) and  DOL='0000-00-00'";*/
		
		$sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo, Department, Division FROM EmployeeMaster WHERE OrganizationId = ? and Is_Delete=0 $whrdiv $whrdept and  DOL='0000-00-00'";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			$i=0; $id='';

			$res1=array();
			$res1['id'] = 1;
			$res1['name'] = Utils::getName($divi, 'DivisionMaster', 'Name', $this->db).' / '.Utils::getName($dept, 'DepartmentMaster', 'Name', $this->db);
			$res1['parent'] = 0;
			//$id=1;

			$data[]=$res1;
			$parent=0;//$index=0;
			while($row = $query->fetch())
			{
				//$index++;
				$count1=0;
				$parent=$row->ReportingTo;
				$sql1 = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and Is_Delete=0 $whrdiv $whrdept AND Id = :pid AND  DOL='0000-00-00'";
				$query1 = $this->db->prepare($sql1);
				try{
					$query1->execute(array(':id' => $orgid, ':pid' => $parent ));
					$count1 =  $query1->rowCount();
				}
				catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->EmployeeCode."<br> ".ucwords(strtolower($row->FirstName." ".$row->LastName));
				if($count1>=1)
				{
					$res['parent'] = $row->ReportingTo;

				}else{
					$res['parent'] = 1;
				}
				$sql1="";
				$data[] = $res;

			}

        	}else{
			$status=false;
			$successMsg="Hierarchy get detail success!";
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function getDepartments($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$div=$request[2];
        $sql = "SELECT Id,Name,ParentId FROM DepartmentMaster WHERE OrganizationId = ? and Id in (Select Department from EmployeeMaster where Division=?) order by name";
        $query = $this->db->prepare($sql);
		try{

			$query->execute(array($orgid,$div ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->Name;
				$res['parent'] = $row->ParentId;

				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=DEPARTMENT_MODULE_GETALL;
		}

		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }
	public function getCurrentSalaryMonth()
	{
		$month= date("Y-m-01");
		$orgid = $_SESSION['ubihrm_org_id'];
		 $sql = "SELECT SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = ? order by Id desc limit 1";

        $query = $this->db->prepare($sql);
		try{

			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$month = $row->SalaryMonth;
			}
        }

		return $month;
	}

	public function gettimesheetDashboard($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		$userid = $request[0];
		$orgid = $request[1];
		//$filscalid = ($request[2]!=0)?$request[2]:$_SESSION['ubihrm_fiscalid'];
		//Utils::Trace("Fiscal Id".$request[2]);
		$type = $request[3];
		$senior = Utils::getApprovalLevelEmp($userid, 1, $this->db);
		$senioremail=Utils::decode5t(Utils::getName($senior,'EmployeeMaster','CompanyEmail',$this->db));
		//echo "$filscalid";
		try{
			//$filscalid=$_SESSION['ubihrm_fiscalid'];
			$sts=1;
			$hrsts=1;
			$emptable = "";
			$nonemptable = "";
			$notification="";
			if($sts==1 || $hrsts==1){
				$emptable = " and  DOL='0000-00-00' ";
			}else{
				$ids = Utils::getReportingIds($userid, $this->db);
				$emptable = " and Id in ($ids) and  DOL='0000-00-00'  ";
				$nonemptable = " and EmployeeId in ($ids)";
				$notification = " and CreatedById in ($ids)";
			}

			$data['chartdata1date'] = "";
			$data['chartdata1'] = array();
			$data['chartdata2'] = array();
			$data['chartdata3'] = array();
			$data['chartdata4']= array(); 
			$data['chartdata5']= array(); 
			$data['chartdata6']= array();
			$data['chartdata7']= array();
			$data['chartdata8']= array();
			$data['chartdata9']= array();
			$startdate = isset($request[4])?$request[4]:"";
			$enddate = isset($request[4])?$request[4]:"";
			
			if($startdate==""){
				$startdate=date("Y-m-d");
				$enddate=date("Y-m-d");
			}elseif($type=="next"){
				$startdate =date("Y-m-d",strtotime("+1 month ".date($startdate)));
			}elseif($type=="previous"){
				$startdate =date("Y-m-d",strtotime("-1 month ".date($startdate)));
			}

			//Utils::Trace($startdate);

			///////////////// GETTING FISCAL START AND END DATES ///////////////
			//$count=0;
		/* 	if($type=="next")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id > ? ORDER BY id ASC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();;
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
					$filscalid=  $row->Id;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}	
			elseif($type=="previous")
			{
				$sql="SELECT StartDate, EndDate, Id FROM FiscalMaster WHERE OrganizationId=? and id < ? ORDER BY id DESC LIMIT 1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				$count=$query->rowCount();
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
					$filscalid=  $row->Id;
				}	
				if($count==0)
				{
					$result['status']=false;
					$result['errorMsg']="No data available";
					return $result;
				}
			}

			else{
				$sql = "SELECT StartDate, EndDate FROM FiscalMaster WHERE OrganizationId=? and Id=? and FiscalSts=1";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid, $filscalid ));
				while($row = $query->fetch()){
					$startdate = $row->StartDate;
					$enddate =  $row->EndDate;
					$res = array();
					$fiscaldate=Utils::monthdateformatter($row->StartDate)." - ".Utils::monthdateformatter($row->EndDate);
					$res['name'] = $fiscaldate;
					$data['financialyear'][] = $res;
				}
			}
			*/

		///////////  GETTING LIST OF  open and closed tasks //////////////////

			// $sql1 = "Select * from project_master Where OrganizationId=? and (MONTH(start_date) = MONTH('$startdate'))";
			$sql1 = "Select * from project_master Where OrganizationId=? and ('$startdate' between start_date and completed_date)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid ));
			$count1 =  $query1->rowCount();
			$open=0; $closed=0;$notstart=0;$reopen=0;$abandoned=0;
			if($count1>=1)
			{
				while($row1 = $query1->fetch())
				{
					if($row1->project_status == '1')
					{
						$open++;
					}
					if($row1->project_status == '2')
					{
						$abandoned++;
					}if($row1->project_status == '3')
					{
						$closed++;
					}if($row1->project_status == '4')
					{
						$reopen++;
					}if($row1->project_status == '5')
					{
						$notstart++;
					}
				};
				//$data['chartdata1date'] = Utils::dateformatter($row1->AttendanceDate);
				   $res = array();
				   $res['value'] = $open;
				   $res['name'] = "Running projects";
					$data['chartdata1'][] = $res;

					$res = array();
					$res['value'] = $closed;
					$res['name'] = "Finished projects";
					$data['chartdata1'][] = $res;
					
					$res = array();
					$res['value'] = $abandoned;
					$res['name'] = "Abandoned projects";
					$data['chartdata1'][] = $res;
					
					$res = array();
					$res['value'] = $notstart;
					$res['name'] = "Not Started projects";
					$data['chartdata1'][] = $res;
					
					$res = array();
					$res['value'] = $reopen;
					$res['name'] = "Re-opened projects";
					$data['chartdata1'][] = $res;
				
			}else{
				  $res = array();
				  $res['value'] = 0;
				  $res['name'] = "Running projects";
				$data['chartdata1'][] = $res;
			}

			///////////  GETTING LIST OF  running tasks by employees //////////////////

			$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sql1 = "Select count(assignto) as counttask, assignto from task_master Where OrganizationId=? and month(fromdate) = month('$startdate') and assignto in ($ids) and (taskstatus=1 or taskstatus=5) group by assignto";
			//$sql1 = "Select count(assignto) as counttask, assignto from task_master Where OrganizationId=? and ('$startdate' between start_date and completed_date) and assignto in ($ids) and (taskstatus=1 or taskstatus=5) group by assignto";
			//Utils::Trace($sql1);
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid));
			$count1 =  $query1->rowCount();
			$open=0; $closed=0;
			if($count1>=1)
			{
				while($row1 = $query1->fetch())
				{
				$res = array();
				$res['value'] = $row1->counttask;
				$res['name'] = Utils::getEmployeeName($row1->assignto,$this->db);
				$data['chartdata7'][] = $res;
				};

				//$data['chartdata1date'] = Utils::dateformatter($row1->AttendanceDate);

			}
			else{
				  $res = array();
				  $res['value'] = 0;
				  $res['name'] = "Running tasks to employee";
				  $data['chartdata7'][] = $res;
			}
		///////////  GETTING LIST OF  PRESENT, LATECOMER OR OVERTIME //////////////////
		/*
			$present=0; $latecomer=0; $overtime=0; $undertime=0;
			$totalP =0;$totalT =0;$totalO =0;$totalU =0;
			$sql = "SELECT * FROM timesheet_master WHERE OrganizationId = ? and EmployeeId=? and curdate() between start_time and timesheetend";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			$count =  $query->rowCount();
			if($count>=1)
			{				
				while($row = $query->fetch())
				{
					if($row->sts ==1 ){
						if($row->perc==1){
							$present++;
						}else{
							$latecomer++;
						}
						if($row->undertime>0){
								$undertime++;
							}	
						if($row->otime>0){
							$overtime++;
						}
					}
				}
				$totalP = round((($present/$count)*100),2);
				$totalT = round((($latecomer/$count)*100),2);
				$totalO = round((($overtime/$count)*100),2);
				$totalU = round((($undertime/$count)*100),2);

			}

				   $res = array();
				   $res['label'] = "Present";
					$res['value'] = $totalP;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Tardy";
					$res['value'] = $totalT;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Overtime";
					$res['value'] = $totalO;
					$data['chartdata2'][] = $res;

					$res = array();
				   $res['label'] = "Undertime";
					$res['value'] = $totalU;
					$data['chartdata2'][] = $res;
			*/
			///////////  Tasks Completion per month  ////// chart 3//////////////
			//$month= date('m');
			//$sql = "select * FROM  project_master WHERE OrganizationId = ? AND month(created_date) = month('$startdate')";
			$sql = "select * FROM  project_master WHERE OrganizationId = ? AND ('$startdate' between start_date and completed_date)";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			while($row = $query->fetch()){
				$proId = $row->id;
				$totalday=0;$totalhour=0; $totalminute=0;
			$totalday1=0;$totalhour1=0; $totalminute1=0;
			 $sql1 = "SELECT SUM(TIME_TO_SEC(Totalhour))as totalEST,id FROM task_master WHERE OrganizationId=? AND projectid=?";
			 $query1 = $this->db->prepare($sql1);
			 $query1->execute(array($orgid,$proId));
			 while($row1 = $query1->fetch()){
			 	$taskId = $row1->id; 
			 	$data['chartdata2totalest'][]  = (intval($row1->totalEST)/3600)% 24;
			 	 //$data['chartdata5count'][] = round(($row->actualday)/60, 2);
			 	/* $start = $row1->totalEST;
				 if($row1->totalEST!=""){
					$hours1= $start[0];
					$totalhour1=$totalhour1+$hours1;
					$minutes1 = $start[1];
					$totalminute1=$totalminute1+$minutes1;
					if($totalminute1>60){
						$totalhour1=$totalhour1+1;
						$totalminute1=$totalminute1-60;
					}
					if($totalhour1>60){
						$totalday = $totalday+1;
						$totalhour1= $totalhour1-60;
					}
				$data['chartdata2totalest'][] = $totalday;
				}*/
				$sql2 = "SELECT SUM(TIME_TO_SEC(total_time))as totallogged from timesheet_master WHERE OrganizationId=? and project_id =? and task_id=? ";
			 $query2 = $this->db->prepare($sql2);
			 $query2->execute(array($orgid,$proId,$taskId));
			 while($row2 = $query2->fetch()){
			 	$data['chartdata2loggedtotal'][] = (intval($row2->totallogged)/3600)% 24;
			 	/* if($row2->total_time!=""){				(intval($seconds) / 3600) % 24
					$hours = $starthrs[0];
					$totalhour = $totalhour+$hours;
					$minutes = $starthrs[1];
					$totalminute = $totalminute+$minutes;
					if($totalminute>60){
						$totalhour=$totalhour+1;
						$totalminute=$totalminute-60;
					}
				}*/
			 }
			 }
					$data['chartdata2name'][] = strtoupper($row->project_title);
					//$data['chartdata2totalest'][] = $totalhour1.':'.$totalminute1;
					//echo $data['chartdata2totalest'];
					//$data['chartdata2loggedtotal'][] = $totalhour.":".$totalminute;
			}
			
			
			/*$sql = "select datediff(completed_date, start_date) as totaltime, project_title from project_master where Month(curdate()) between month(start_date) and month(completed_date) and OrganizationId=? order by start_date";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
						$data['chartdata2name'][] = strtoupper($row->project_title);
						$data['chartdata2total'][] = $row->totaltime;			
				}

			}
		else{
			$data['chartdata2name'][] = 'No data';
						$data['chartdata2total'][] = 0;
		}*/

		///////////  Assigned projects chart 2 ////////////////////

			//$sql = "Select * from project_master Where OrganizationId=? and project_status = 1 and month(created_date) = month('$startdate') order by start_date desc";
			$sql = "Select * from project_master Where OrganizationId=? and project_status = 1 and ('$startdate' between start_date and completed_date) order by start_date desc";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					
						$data['chartdata4name'][] = strtoupper($row->project_title);
						$data['chartdata4total'][] = count(explode(',',$row->assigned_to));	
				}
			}
			else{
				
						$data['chartdata4name'][] = 'No Data';
						$data['chartdata4total'][] = 0;
			}
		///////////  Top 10 Members with Most Tasks Closed  /////chart 4 ///////////////

			//$sql = "select sum(TIMESTAMPDIFF(minute,start_time,end_time)) as totalday, sum(TIMESTAMPDIFF(minute , timesheetstart,timesheetend)) as actualday, sum(TIMESTAMPDIFF(minute,start_time,end_time) - TIMESTAMPDIFF(minute , timesheetstart,timesheetend)) as beforeday, EmployeeId from timesheet_master where OrganizationId = ? and month(timesheetend) = month('$startdate') group by EmployeeId order by beforeday desc limit 10";
			
			
			
			//This query commented by pratibha bcz we want data of dedicated employee earlier giving only one employee !!!!
			//		$sql = "SELECT SUM(TIME_TO_SEC(T.Totalhour))as totalday,SUM(TIME_TO_SEC(S.total_time))as actualday, S.EmployeeId FROM task_master T, timesheet_master S WHERE T.id = S.task_id AND T.Totalhour > S.total_time AND T.OrganizationId=? AND month(T.fromdate) = month('$startdate')";
			
			$sql = "SELECT SUM(TIME_TO_SEC(T.Totalhour)) as totalday,SUM(TIME_TO_SEC(S.total_time)) as actualday, S.EmployeeId FROM task_master T, timesheet_master S WHERE T.id = S.task_id AND T.Totalhour > S.total_time AND T.OrganizationId=? AND month(T.fromdate) = month('$startdate') group by S.EmployeeId";
			//SELECT sum(TIME_TO_SEC( Totalhour )) AS totalhrs FROM  `task_master` WHERE  `assignto` =  '4120' AND MONTH(  `fromdate` ) =06;
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					//if($row->beforeday >=0){
						
						$data['chartdata5name'][]= strtoupper($this->getName($row->EmployeeId, 'EmployeeMaster', 'FirstName'));
								
							//$days = floor(($row->actualday) / 86400);$days.".".
							$hours = floor(($row->actualday)/3600);
							$minuts = floor($row->actualday/60%60);
							//$days1 = floor(($row->totalday) / 86400);$days1.".".
							$hours1 = floor(($row->totalday)/3600);
							$minuts1 = floor(($row->totalday)/60%60);
						$data['chartdata5count'][] =$hours.".".$minuts;
						$data['chartdata5total'][] =$hours1.".".$minuts1;				
					//}
				}
			}
			else{
					$data['chartdata5name'][] = 'No data';
					$data['chartdata5count'][]  = 0;
					$data['chartdata5total'][] = 0;
			}

			///////////  Bottom 10 Members with Least Tasks Closed  ////chart 5 ////////////////		
			//$sql = "SELECT SUM(TIME_TO_SEC(Totalhour))as esttotal,id FROM task_master WHERE OrganizationId=? and month(fromdate) = month('$startdate')";
			$sql = "SELECT SUM(TIME_TO_SEC(T.Totalhour))as totalday,SUM(TIME_TO_SEC(S.total_time))as actualday, S.EmployeeId FROM task_master T, timesheet_master S WHERE T.id = S.task_id AND T.Totalhour < S.total_time AND T.OrganizationId=? AND month(T.CreatedDate) = month('$startdate') group by S.EmployeeId";
			
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			while($row = $query->fetch()){
				
				$ESThours = $row->totalday;
					//$dayes = floor($ESThours/24*3600);
					$hours	= floor($ESThours/3600);
					$minuts = floor(($ESThours/60)%60);
			  $data['chartdata6total'][] = $hours.".".$minuts;
					    $actualtime	= $row->actualday;
						$hours1 = floor($actualtime/3600);
						$minuts1 = floor(($actualtime/60)%60);
				 $data['chartdata6name'][]= strtoupper($this->getName($row->EmployeeId,'EmployeeMaster', 'FirstName'));
						$data['chartdata6count'][] =$hours1.".".$minuts1;
						
				
				/*if($i==0){
					$data['chartdata6name'][] = 'No data';
					$data['chartdata6count'][] = 0;
					$data['chartdata6total'][]= 0;
				}*/
	
			}
			///////////  Top 10 delayed tasks  ////chart 6////////////////
	//$sql = "SELECT task_master.projectid,task_master.id, timesheet_master.task_id, TIMEDIFF('task_master.Totalhour','timesheet_master.total_time') as total FROM task_master INNER JOIN timesheet_master ON task_master.id= timesheet_master.task_id where task_master.OrganizationId =?  order by total desc limit 10";
			//$sql = "SELECT * from project_master where OrganizationId = ? AND project_status ='1' AND month(created_date) = month('$startdate')";
			$sql = "SELECT * from project_master where OrganizationId = ? AND project_status =3 AND ('$startdate' between start_date and completed_date)";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			
			if($query->rowCount()>0){
			while($row = $query->fetch()){
				$proId = $row->id;
			$sql1 = "select SUM(TIME_TO_SEC(T.Totalhour))as esttotal, SUM(TIME_TO_SEC(S.total_time))as actualtime,(TIMEDIFF(S.total_time, T.Totalhour))as totaldiff FROM task_master T,timesheet_master S WHERE T.projectid = $proId ";
			//$sql1 = "SELECT (SUM(TIME_TO_SEC(T.Totalhour)))as esttotal,SUM(TIME_TO_SEC(S.total_time))as actualtime FROM task_master T,timesheet_master S WHERE T.id = S.task_id AND T.projectid = '$proId' AND T.OrganizationId=? ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($orgid));
			if($query1->rowCount()>0)
			{
				$i=0;
				while($row1= $query1->fetch()){
				//intval(intval($seconds) / (3600*24))
						$totaldiif = $row1->totaldiff;
						//echo $totaldiif.",";
					//if($row1->totaldiff > 0)
					//{
		
						$esttotal = $row1->esttotal;
						$dayss = intval(intval($esttotal) / 86400);
						$minutss = $esttotal / 3600;
						$actime = $row1->actualtime;
						$dayss1 = intval(intval($actime) / 86400);
						$data['esttotal'][] = round($dayss,2);
						$data['actualtime'][] = round($dayss1,2);
						$data['chartdata3name'][] =  $row->project_title;
						
						$i++;
					//}
				}
				if($i==0){
				
				$data['esttotal'] = 0;
				$data['actualtime'] = 0;
				$data['chartdata3name'][] = 'No data';
				}
			}
			else{
				$data['esttotal'] = 0;
				$data['actualtime'] = 0;
				$data['chartdata3name'][] = 'No data';
				
			}
			}
			}else{
				$data['esttotal'] = 0;
				$data['actualtime'] = 0;
				$data['chartdata3name'][] = 'No data';
			}
			
		///////////  GETTING LIST OF MONTHLY ABSENT DIVISION WISE  ////////////////////

		/*	$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$total =0; $totalP =0;
					$sql1 = "SELECT  *  FROM AttendanceMaster where OrganizationId=? and  (Month(AttendanceDate)=Month(curdate())) and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and DOL='0000-00-00') and (AttendanceDate between ? and ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $orgid,$startdate,$enddate));
					$count=$query1->rowCount();
					if($count>0){
						while($row1 = $query1->fetch())
						{
							if($row1->AttendanceStatus ==2)
							$total++ ;
						}
					$totalP = ($total/$count)*100;	
					}

						$res = array();
						$res['name'] = $row->ShortName;
						$res['count'] = round( $totalP,2);
						$data['chartdata6'][] = $res;
				}
			}

		///////////  GETTING LIST OF NUMBER OF EMPLOYEE IN WORK HOURS DAILY  ////////////////////fiscal_format
		/*	$temparr=array();
			$sql = "Select HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? GROUP BY HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak)))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{

				while($row= $query->fetch()){
					if($row->totaltime < 0)
					{
						$totalhour =24 - $row->totalhour;
					}else{
						$totalhour = $row->totalhour;
					}

					$sql1 ="Select count(Id) as totalcount from EmployeeMaster where OrganizationId=? and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $orgid, $totalhour ));
					while($row1 = $query1->fetch())
					{
						$res = array();
						$res['name'] = $totalhour .' hr';
						//$totalmin = ($row->totalmin/60)*100;
						$res['count'] = $row1->totalcount;//.".".$totalmin;
						$temparr[] = $res;
					}
				}
				$temparr=array_unique($temparr,SORT_REGULAR);
				for($i=0;$i<count($temparr);$i++)
				{
					$data['chartdata7'][]=$temparr[$i];
				}

			}
		*/
		/*
			$temparr=array();
			$sql = "Select HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? GROUP BY HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak)))";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				$temp=array(); $temp1=array();
				while($row= $query->fetch()){
					if($row->totaltime < 0)
					{
						$totalhour =24 - $row->totalhour;
					}else{
						$totalhour = $row->totalhour;
					}
					$res = array();
					$res['name'] = $totalhour .' hr';
					$sql1 ="Select DISTINCT WorkingDays  from EmployeeMaster where OrganizationId=? and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $orgid, $totalhour ));
					$totalcount=0; 
					while($row1 = $query1->fetch())
					{
						$workingdays=0;
						$workingdays=$row1->WorkingDays;
						$workingdays=substr_count($workingdays, '1');
						$halfdays=	substr_count($row1->WorkingDays, '2');
						$workingdays=$workingdays+($halfdays * 0.5);
						$temp[] = $workingdays;
						$temp1[] = $workingdays.' days';
						$sql2="select count(Id) as totalcount from EmployeeMaster where LENGTH(WorkingDays) - LENGTH(REPLACE(WorkingDays, '1', '')) = ? and OrganizationId=? and DOL='0000-00-00' and Shift in (Select Id from ShiftMaster where OrganizationId=? and HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) = ?)";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $workingdays,$orgid, $orgid, $totalhour ));
						while($r=$query2->fetch())
						{

							$res[$workingdays] = $r->totalcount;
						}

					}
					//$temp=array_unique($temp,SORT_REGULAR);

					$temparr[] = $res;
				}
				$temp=array_unique($temp);
				$temp1=array_unique($temp1);
				$data['chartdata7']['ykeys']=$temp;
				$data['chartdata7']['labels']=$temp1;
				$temparr=array_unique($temparr,SORT_REGULAR);
				$data['chartdata7']['data']=$temparr;

			}
		///////////  GETTING LIST OF WORK HOURS SHIFT WISE  ////////////////////

			$sql = "SElect Id, Name, HOUR(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn), TIMEDIFF(TimeOutBreak,TimeInBreak))) as totalhour , MINUTE(TIMEDIFF(TIMEDIFF(TimeOut,TimeIn),TIMEDIFF(TimeOutBreak, TimeInBreak))) as totalmin,TIMEDIFF(TimeOut,TimeIn) as totaltime from ShiftMaster where OrganizationId=? ";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$res = array();
					$res['name'] = $row->Name;

					if($row->totaltime < 0){
						$res['count'] =24 - $row->totalhour;
					}else{
					//$totalmin = ($row->totalmin/60)*100;
						$res['count'] = $row->totalhour;//.".".$totalmin;
					}
					$data['chartdata8'][] = $res;
				}
			}
		///////////  GETTING LIST OF MONTHLY OVERTIME DIVISION WISE  ////////////////////

			$sql = "SElect Id, ShortName from DivisionMaster where OrganizationId=? and ArchiveSts=0";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
			if($query->rowCount()>0)
			{
				while($row= $query->fetch()){
					$total =0;
					$sql1 = "SELECT  HOUR(sec_to_time(sum(time_to_sec(overtime)))) as totalcount FROM AttendanceMaster where OrganizationId=? and  (Month(AttendanceDate)=Month(curdate()))  and EmployeeId in ( Select Id from EmployeeMaster where Division=? and OrganizationId=? and DOL='0000-00-00') and (AttendanceDate between ? and ?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $orgid,$startdate,$enddate));
					if($query1->rowCount()>0){
						$row1 = $query1->fetch();
						$total = $row1->totalcount;

					}
						$res = array();
						$res['name'] = $row->ShortName;
						$res['count'] = $total;
						$data['chartdata9'][] = $res;
						//echo $total;0
				}
			}
		*/

		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		$curmonth=date('F');
		$result["data"] =$data;
		$result["senioremail"] =$senioremail;
		$result["curmonth"] =$curmonth;
		$result['status']=$status;
		$result['filscalid']=0;
		$result['fiscal_format']=date("M'y", strtotime(date($startdate)));
		$result['date']=$startdate;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

	public function mailDashboard($name){
		$result=array();
		$emp_name=$_SESSION['user_empname'];
		$status=false;
		$successMsg="";
		$errorMsg="";
		$mail=$_POST["mail"];
		$report=date('Y_m_d_H_i_s');
		if(!empty($_FILES['mypdf'])){
			$sts=move_uploaded_file(
			$_FILES['mypdf']['tmp_name'],
			'public/uploads/'.$report.'.pdf'
			);
			$file=URL."public/uploads/".$report.'.pdf';
			if($sts){
				$successMsg= "Pdf is successfully saved";
				$sts1=Utils::sendMail($mail,$emp_name,$name,"Please, find the attachment",$file);
				if($sts1){
					$status=true;
					$successMsg.= "  Mailed successfully";
				}else{
					$status=false;
					$errorMsg=$successMsg." Mail not sent";
				}
			}	
			else{
				$errorMsg= "Pdf is not saved";
				$status=false;
			}
		}else {
			$errorMsg= "No data is sent";
			$status=false;
		}
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
	}
	
 }
 ?>