<?php

/**
 * CurrencyModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CurrencyModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the all country details
     * @return array an array with several objects (the results)
     */
    public function getAllCurrency()
    {
		$result = array();	$data = array();
		
			$res = array();
			$res['id'] = 0;
			$res['code'] = "";
			$res['name'] = "Select Currency";
			$res['symbol'] = "";
			$result[] = $res;
			
        $sql = "SELECT * FROM CurrencyMaster";
        $query = $this->db->prepare($sql);
        $query->execute();
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['code'] = $row->CurrencyCode;
			$res['name'] = $row->CurrencyName;
			$res['symbol'] = $row->CurrencySymbol;		
			$res['country'] = $row->Name;		
			$data[] = $res;
		}
        
		$result['status']=true;
		$result['data']=$data;
		return $result;
    }
	
	public function getCountryCurrency($country)
    {
		$result = array();
		
			$res = array();
			$res['id'] = 0;
			$res['name'] = "Select Currency";
			$res['symbol'] = "";
			$result[] = $res;
			
        $sql = "SELECT * FROM CurrencyMaster where Name in (select Name from CountryMaster where Id=?)";
        $query = $this->db->prepare($sql);
        $query->execute(array($country));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = $row->CurrencyName."(".$row->CurrencyCode.")";
			$res['symbol'] = $row->CurrencySymbol;		
			$result[] = $res;
		}
        
		return $result;
    }
}
