<?php

/**
 * CountryModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CountryModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	
	/**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM CountryMaster order by Name";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPSTATUS_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    /**
     * Get method for fetching the all country details
     * @return array an array with several objects (the results)
     */
    public function getAllCountry()
    {
		$result = array();
			
        $sql = "SELECT * FROM CountryMaster order by Name";
        $query = $this->db->prepare($sql);
        $query->execute();
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = $row->Name;			
			$result[] = $res;
		}
        
		return $result;
    }
}
