<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CompetencyanalysisModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM CompetencyAnalysis WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = COMPETENCYANALYSIS_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM CompetencyAnalysis WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['desig'] = (int)$row->Designation;
				$res['period'] = $row->Period;
				$res['desiglevel'] = isset($row->AssessmentLevel)?explode(",",$row->AssessmentLevel):"";
				$objective=array();
				
				$sql1 = "SELECT * FROM CompetencyAnalysisChild WHERE AnalysisId = :id and VisibleSts=1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['ctype'] = $row1->CompetencyType;
					$res1['comp'] = $row1->Competency;
					$res1['level'] = (int)$row1->Level;
					$res1['desc'] = $row1->BehaviouralIndicator;
					$objective[]=$res1;
				}
				
				$res['competencyanalysis']=$objective;
				
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = COMPETENCYANALYSIS_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = COMPETENCYANALYSIS_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    public function getCombo($field,$val)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		if($val ==1){
			$sql = "SELECT * FROM CompetencyMaster WHERE TypeId = :id";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array(':id' => $field ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['name'] = $row->Name;				
					$data[] = $res;
				}
			}
		}
		elseif($val ==2){
			$sql = "SELECT * FROM CompetencyChild WHERE CompetencyId = :id";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array(':id' => $field ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] =  (int)$row->Id;
					$res['level'] = (int)$row->Level;
					$res['name'] = $row->CompLevel;
					$res['desc'] = $row->BehaviouralIndicator;
										
					$data[] = $res;
				}
			}
		}
		
        
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = COMPETENCYANALYSIS_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = COMPETENCYANALYSIS_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	
    /**
     * Setter for a CompetencyAnalysis (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$desiglevel="";
        $temp=$request[4];
		for($i=0;$i<count($temp);$i++){
			if($desiglevel == ""){
				$desiglevel =$temp[$i]['desiglevel'];
			}
			else{
				$desiglevel .=",". $temp[$i]['desiglevel'];
			}
		}
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM CompetencyAnalysis WHERE Id != ? and Designation = ?  and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[5], $request[2], $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=COMPETENCYANALYSIS_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "UPDATE CompetencyAnalysis SET Designation=?,Period =?, AssessmentLevel=?,LastModifiedById=?,LastModifiedDate=? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				
				$query->execute(array($request[2],$request[3], $desiglevel,$mid,$mdate, $request[5] ));

			
				// INSERTING AND UPDATING COMPETENCYANALYSIS CHILD IF PASSED AS AN JSON
				$objective = json_decode($_POST['competencyanalysis'], true); 
				$objectiveid="0";
				for($i=0; $i<count($objective); $i++){
					$objectiveid .= ",".$objective[$i]['id'];
				}
				$sqlobjective1 = " UPDATE CompetencyAnalysisChild SET VisibleSts=0 WHERE AnalysisId=? AND Id NOT IN ($objectiveid)";
				$queryobjective1 = $this->db->prepare($sqlobjective1);
				$queryobjective1->execute(array( $request[5]));
				$count +=  $queryobjective1->rowCount();
				for($i=0; $i<count($objective); $i++)
				{
					if($objective[$i]['ctype']!="" && $objective[$i]['comp']!=""  && $objective[$i]['level']!=""){
							$record = array();
							$record[0] = $request[5];
							$record[1] = $objective[$i]['ctype'];
							$record[2] = $objective[$i]['comp'];
							$record[3] = $objective[$i]['level'];
							$record[4] = $objective[$i]['desc'];
							$id=$objective[$i]['id'];
						if($id){
							$sqlobjective = " UPDATE CompetencyAnalysisChild SET AnalysisId=?, CompetencyType=?, Competency=?, Level=?,BehaviouralIndicator=? where Id=?";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute(array($request[5],$objective[$i]['ctype'],$objective[$i]['comp'],$objective[$i]['level'],$objective[$i]['desc'],  $id));
							$count +=  $queryobjective->rowCount();
						}else{
							$sqlobjective = " INSERT INTO CompetencyAnalysisChild ( AnalysisId, CompetencyType, Competency, Level,BehaviouralIndicator) values (?,?,?,?,?)";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute($record);
							$count +=  $queryobjective->rowCount();
						}
						
					}
				}

					
				$count +=  $query->rowCount();
				
				if ($count >= 1 ) {	
					$status =true;
					$successMsg = COMPETENCYANALYSIS_MODULE_UPDATION_SUCCESS;
				} else {
				   $status =false;
				   $errorMsg = COMPETENCYANALYSIS_MODULE_UPDATION_FAILED;
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a CompetencyAnalysis (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
        $desiglevel="";
        $temp=$request[4];
		for($i=0;$i<count($temp);$i++){
			if($desiglevel == ""){
				$desiglevel =$temp[$i]['desiglevel'];
			}
			else{
				$desiglevel .=",". $temp[$i]['desiglevel'];
			}
		}
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM CompetencyAnalysis WHERE Designation = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[2],$orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=COMPETENCYANALYSIS_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "INSERT INTO CompetencyAnalysis (Designation, Period, AssessmentLevel, OrganizationId, CreatedById, CreatedDate, LastModifiedById, LastModifiedDate) VALUES (?, ?, ?, ?,?,?,?,?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3], $desiglevel, $orgid,$mid,$mdate,$mid,$mdate));
				
				$aid=$this->db->lastInsertId();;
				
					// INSERTING COMPETENCYANALYSIS CHILD IF PASSED AS AN JSON
				$objective = json_decode($_POST['competencyanalysis'], true); 
				for($i=0; $i<count($objective); $i++)
				{
					if($objective[$i]['ctype']!="" && $objective[$i]['comp']!=""  && $objective[$i]['level']!=""){
						$record = array();
						$record[0] = $aid;
						$record[1] = $objective[$i]['ctype'];
						$record[2] = $objective[$i]['comp'];
						$record[3] = $objective[$i]['level'];
						//$record[4] = $objective[$i]['desc'];
						
						
						$sqlobjective = " INSERT INTO CompetencyAnalysisChild ( AnalysisId, CompetencyType, Competency, Level) values (?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
						$count1 =  $queryobjective->rowCount();
					}
				}
				
				
			$count =  $query->rowCount();	
			
			if ($count == 1 || $count1 >= 1) {				
			   $status =true;
			   $successMsg = COMPETENCYANALYSIS_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = COMPETENCYANALYSIS_MODULE_CREATION_FAILED;
			}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		try{
			$sql = "Select * from CompetencyAnalysisChild WHERE AnalysisId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch()){
				
					$sql3 = "Select * from SkillGapChild WHERE AnalysisId = ? ";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array($row->Id));	
					while($row3=$query3->fetch()){
						$count1++;
					}
				}
				if($count1>=1){
					$status =false;
					$errorMsg = COMPETENCYANALYSIS_MODULE_DELETE_EXIST;
				
				}else{
						$sql1 = "DELETE FROM CompetencyAnalysis WHERE Id = :id ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(':id' => $did));
						$count +=  $query1->rowCount();	
						$sql1 = "DELETE FROM CompetencyAnalysisChild WHERE AnalysisId = :id ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(':id' => $did));
					
						$count +=  $query1->rowCount();		
					
					
					if ($count >= 1) {
					   $status =true;
					   $successMsg = COMPETENCYANALYSIS_MODULE_DELETE_SUCCESS;
					}else {
					   $status =false;
					   $errorMsg = COMPETENCYANALYSIS_MODULE_DELETE_FAILED;
					}
				}
			}
		catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'CompetencyAnalysis';
		$sIndexColumn = "Id";
		$aColumns = array( 'Designation','Period' , 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="Designation"){
				$sWhere .= "(Designation in ( select Id from DesignationMaster where Name "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performanceold/editcompetencyanalysis/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="Designation")
				{
					$row[] = '<a href="'.URL.'performanceold/viewcompetencyanalysis/'.Utils::encode5t($aRow->Id).'/1">'.$this->getName($aRow->{$aColumns[$i]},'DesignationMaster').'</a>';
					
				}
				else if($aColumns[$i]=="Period")
				{
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
