<?php

/**
 * CompandbenefitModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CompandbenefitModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of GRADE
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$ids =Utils::getReportingIds($mid, $this->db);
		
        $sql = "SELECT * FROM SalaryMaster WHERE OrganizationId = :id and EmployeeId in ($ids)";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				//$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=SALARYMASTER_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$salaryid = $request[2];	//SALARY ID CONTAINS IN ARRAY THIRD VALUE;
		
		$bankname =""; $bankcode =""; $bankacct =0;
        $sql = "SELECT * FROM BenefitCompansationMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $salaryid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['salaryid'] = $row->Id;
				$res['employee'] = $row->EmployeeId;
				$res['empmonthdate'] = $row->BenCompMonth;
				$res['totalbenefit'] = $row->TotalBenefitPay;
				$res['totalcomp'] = $row->TotalCompansation;
				$res['totalgau'] = $row->TotalGauranteedPay;
				$res['variable'] = $row->TotalVariablePay;
				$res['totalcash'] = $row->TotalGauranteedPay+$row->TotalVariablePay;
				$res['empmonthname'] = date("F Y", strtotime($row->BenCompMonth));
				
				$res['salarydetail'] = array();
				$headarray = array();
				$total=0;$totaldeduction=0;
				
				
				////////////////   FIND OUT THE COMPANY DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT * FROM Organization WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->OrganizationId ));
				while($row1 = $query1->fetch())
				{
					$res['companyname'] = $row1->Name;
					$res['logo'] = URL."public/uploads/".$row->OrganizationId."/".$row1->Logo;
				}
				
				////////////////   FIND OUT THE EMPLOYEE DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->EmployeeId, $orgid ));
				while($row1 = $query1->fetch())
				{
					$res['id'] = $row1->Id;
					$res['name'] = ucwords(strtolower($row1->FirstName." ".$row1->LastName));
					$res['empcode'] = $row1->EmployeeCode;
					$res['empdivision'] = $this->getName($row1->Division,'DivisionMaster');
					$res['empdept'] = $this->getName($row1->Department,'DepartmentMaster');
					$res['empdesig'] = $this->getName($row1->Designation,'DesignationMaster');
					$res['empshift'] =$this->getName( $row1->Shift,'ShiftMaster');
					$res['empgrade'] = $this->getName($row1->Grade,'GradeMaster');
				}
				
				////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT * FROM BenefitMaster sh, BenefitCompansationChild sc where sc.BenefitId=sh.id and BenefitCompansationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->Id;
					$res1['amount'] = (int)$row1->BenefitAmount;					
					$res1['name'] =$row1->Name;
					$res1['type'] = 1;
					
					$headarray[]=$res1;
					$total += (int)$row1->BenefitAmount;
				}
				
				$res['salarydetail'] = $headarray;
				$res['emptotal'] = $total;
				$res['emptotaldeduction'] = $totaldeduction;
				$res['netpay'] = $total-$totaldeduction;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYMASTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=SALARYMASTER_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	public function getMonthCompandBenefitDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$grandheadarray = array();
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$salarymonth = $request[2];	//SALARY ID CONTAINS IN ARRAY THIRD VALUE;
		$grandtotal=0;$grandtotaldeduction=0;$grandnettotals=0;
		$grandctc=0; $granddays=0;
		
        $sql = "SELECT *, sm.Id FROM BenefitCompansationMaster sm, EmployeeMaster em WHERE sm.EmployeeId=em.Id and em.OrganizationId = ? and BenCompMonth=? order by Division, DOJ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid, $salarymonth ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['salaryid'] = $row->Id;
				$res['employee'] = $row->EmployeeId;
				$res['empmonthdate'] = $row->BenCompMonth;
				$res['empgauranteedpay'] = $row->TotalGauranteedPay;
				$res['empvariablepay'] = $row->TotalVariablePay;
				$res['empmonthname'] = date("F Y", strtotime($row->BenCompMonth));
				$res['salarydetail'] = array();
				$headarray = array();
				$total=0;$totaldeduction=0;
				$salaryid = $row->Id;
				
				$grandctc += $row->TotalGauranteedPay; 
				$granddays +=$row->TotalVariablePay;
				
				$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empcode'] = $row->EmployeeCode;
				$res['empdivision'] = Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
				$division=0;
				
				
				////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT *, sh.Id FROM BenefitMaster sh LEFT JOIN BenefitCompansationChild sc on sh.Id=sc.BenefitId and BenefitCompansationId=? order by Name";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = $row1->Id;
					$res1['amount'] = (int)$row1->BenefitAmount;					
					$res1['name'] =$row1->Name;
					
					$headarray[]=$res1;
					if(count($grandheadarray)>0){
						$flg=false;
						for($i=0; $i<count($grandheadarray); $i++)
						{
							if($grandheadarray[$i]['id']==$row1->Id)
							{
								$flg=true;
								$grandheadarray[$i]['amount'] += (int)$row1->BenefitAmount;
								break;
							}
						}
						if(!$flg){
							$grandheadarray[] = $res1;
						}
					}else{
						$grandheadarray[] = $res1;
					}
					$total += (int)$row1->BenefitAmount;
					
					
				}
				
				$res['salarydetail'] = $headarray;
				$res['emptotal'] = $row->TotalBenefitPay;
				
				$grandtotal +=$row->TotalBenefitPay;
					
				
				$data[] = $res;
			}
				$res = array();
				$res['salaryid'] = 0;
				$res['name'] = "Grand Total";
				$res['empdivision'] = "Grand Total";
				$res['empmonthdate'] = '-';
				$res['empgauranteedpay'] = $grandctc;
				$res['empvariablepay'] = $granddays;
				$res['empmonthname'] ='-';
				$res['salarydetail'] = $grandheadarray;
				$res['emptotal'] = $grandtotal;
				
				$data[] = $res;
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = SALARYMASTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg="Compensation and Benefit not found for ".date("F Y",strtotime(date($salarymonth)));
        }
		$companyname = ""; $logo ="";
		////////////////   FIND OUT THE COMPANY DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT * FROM Organization WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid ));
				while($row1 = $query1->fetch())
				{
					$companyname = $row1->Name;
					$logo = URL."public/uploads/".$orgid."/".$row1->Logo;
				}
				
		$result["data"] =$data;
		$result['status']=$status;
		$result['companyname']=$companyname;
		$result['companylogo']=$logo;
		$result['salarymonth']=date("F Y",strtotime(date($salarymonth)));
		$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	
	////////////////  GET DETAILS OF EMPLOYEE BENEFITS  //////////////////////////
	
	public function getEmployeeCompAndBenefitDetail1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$headarray1 = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$month = $this->getBenefitMonth($request);//Utils::getDateformat( $request[2]);
		$division = 0;//isset($_POST['division']) ? $_POST['division'] : "0";
		if($month!="")
		{
			if(date("Y-m-d")<date($month))
			{
				$result["data"] =$data;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']="Cannot generate future month salary";
			
			return $result;
			}
			$sWhere="";
			$sts=$_SESSION['ubihrm_user_sts'];
			if($sts!=1){
				$ids = Utils::getReportingIds($mid, $this->db);
				$sWhere = " and Id in ($ids) ";
			}
			if($division!=0){
				$sWhere .= " and Division = $division ";
			}
			$lta = 0;
			$ltamonth = 0;
					
			////////////////   FIND OUT THE BENEFIT HEADS ARE AVAILABLE  //////////////////////////			
			$sql1 = "SELECT Id, Name FROM BenefitMaster WHERE OrganizationId = ? ORDER BY Name";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $request[1]));
			while($row1 = $query1->fetch())
			{
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['name'] =$row1->Name;
				$headarray[]=$res1;
			}
				
			$date1 = date('Y-m-d', strtotime(date('Y-m-01', strtotime($month))." +1 month"));
			
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and (DOL='0000-00-00' or DOL>='$month') $sWhere and DOJ<='$month'  order by Division, EmployeeCode, FirstName, MiddleName, LastName";
			$query = $this->db->prepare($sql);
			try{
			
			$query->execute(array( $orgid, $orgid, $orgid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$empcount=0;
				while($row = $query->fetch())
				{
					$emptotal = 0; 
					$emptotaldeduction = 0;
					$onedaysal =0; $gradeid=0;
					$res = array();
					$res['id'] = $row->Id;
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['empcode'] = $row->EmployeeCode;
					$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
					$res['empctc'] = $row->EmployeeCTC;
					$ctc = $row->EmployeeCTC;
					$res['empmonthname']=""; 
					$res['empmonthdate']=""; 
					$gradeid=$row->Grade;
					
					
					$onedaysal = round($ctc/30, 2);
					
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
					$res['emppaiddays']=$number;
					
					if(date($res['empmonthdate'])<date($row->DOJ))
					{
						$d = date('d', strtotime($row->DOJ));
						$res['emppaiddays'] = $res['emppaiddays']-($d-1);
						$ctc = round(($ctc * $onedaysal),2);	
					}
					
					///////////FOR AUTO FILL THE BENEFITS,FETCH AMOUNT FROM BENEFIT&COMPANSATION CHILD THROUGH LAST COMP&BEN MONTH////
			
					
					
					/*for($i=0;$i<count($headarray);$i++)
					{
						$sql1 = "SELECT BenefitAmount FROM GradeBenefitChild WHERE GradeId = ? and BenefitId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($gradeid,$headarray[$i]['id'] ));
						if($row1 = $query1->fetch())
						{
							$headarray[$i]['amount'] = $row1->BenefitAmount;
						}else{
							$headarray[$i]['amount'] = 0;
						}
						$emptotal=$emptotal+(float)$headarray[$i]['amount'];		
					}*/
					$lastbencompid=$this->getLastCompBenefitId($row->Id,$orgid);
					for($i=0;$i<count($headarray);$i++)
					{
						$sql1 = "SELECT BenefitAmount FROM BenefitCompansationChild WHERE BenefitCompansationId = ? and BenefitId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($lastbencompid,$headarray[$i]['id'] ));
						if($row1 = $query1->fetch())
						{
							$headarray[$i]['amount'] = $row1->BenefitAmount;
						}else{
							$headarray[$i]['amount'] = 0;
						}
						$emptotal=$emptotal+(float)$headarray[$i]['amount'];		
					}
					for($i=0;$i<count($headarray);$i++)
					{
						
						if($headarray[$i]['name']=='Gratuity')
						{
							/////find out gratuity on termination of this month////////
							$temp=$headarray[$i]['amount'];
							$amt=0;
							$gratuitythismonth = Utils::getEmployeeGratuity($row->Id, 2, $this->db, date("Y-m-t", strtotime($month)));
							$gratuitylastmonth = Utils::getEmployeeGratuity($row->Id, 2, $this->db,  date("Y-m-t", strtotime("-1 month, ".date($month))));
							$amt=$gratuitythismonth-$gratuitylastmonth;
							if($amt>0){
								$headarray[$i]['amount'] =round($amt,2);
								$emptotal=$emptotal-(float)$temp;
								$emptotal=$emptotal+(float)$headarray[$i]['amount'];
							}
						}
								
					}
					
					$res['totalgauranteepay']=0;
					$res['totalvariablepay']=0;
					$res['totalpay']=0;
					$res['totalbenefit']=0;
					
					$sql1 = "SELECT * FROM SalaryMaster WHERE OrganizationId = ? and EmployeeId=? and SalaryMonth=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id, $month));
					if($query1->rowCount()>0)
					{
						while($row1 = $query1->fetch())
						{
							/*$sql2 = "SELECT sum(HeadAmount) as totalsum, HeadAddDeduct FROM SalaryChild WHERE SalaryId=? group by HeadAddDeduct";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array($row1->Id));
							while($row2 = $query2->fetch())
							{
								if($row2->HeadAddDeduct==0){
									$res['totalvariablepay'] = $res['totalvariablepay']-$row2->totalsum;
								}elseif($row2->HeadAddDeduct==3){
									$res['totalgauranteepay'] = $res['totalgauranteepay']-$row2->totalsum;
								}elseif($row2->HeadAddDeduct==2 || $row2->HeadAddDeduct==4 ){
									$res['totalgauranteepay'] = $res['totalgauranteepay']+$row2->totalsum;
								}elseif($row2->HeadAddDeduct==1){
									$res['totalvariablepay'] = $res['totalvariablepay']+$row2->totalsum;
								}
							}*/
							
							$sql2 = "SELECT * FROM SalaryChild WHERE SalaryId=?";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array($row1->Id));
							while($row2 = $query2->fetch())
							{
								if($row2->HeadAddDeduct==4 ){
									$res['totalgauranteepay'] = $res['totalgauranteepay']+$row2->HeadAmount;
								}elseif($row2->HeadAddDeduct==2 ){
									$res['totalgauranteepay'] = $res['totalgauranteepay']+$row2->HeadAmount;
								}elseif($row2->HeadAddDeduct==1 && $row2->HeadId==5){
									$res['totalvariablepay'] = $res['totalvariablepay']+$row2->HeadAmount;
								}
							}
						}
						//$res['salarysts'] = true;
					}else{
						//$res['salarysts'] = false;
						$empcount++;
					}
					$res['salarysts'] = true;
					///////total cash= guarantee + variable pay//////
					$res['totalpay'] = $res['totalgauranteepay'] + $res['totalvariablepay'];
					
					/////////total benefits/////////
					$res['totalbenefit']=$emptotal;
					
					/////////total compensation= total cash + total benefits//////////////////
					$res['total'] = $res['totalpay']+$res['totalbenefit'];	
					
					$res['salarydetail']=$headarray;
					
					$res['sts'] = $res['salarysts'];
					$data[] = $res;
				}
				if($empcount>0){
					$status=true;
					$successMsg=$empcount." Employee found without salary distribution.";
				}
			}else{
				$status=false;
				$errorMsg = "No employee left to generate salary";
			}
			}catch(Exception $e) {
				$status=false;
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
		}else{
			$status=false;
				$errorMsg = "Benefit can be added after generating salary";
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['mnth']=$month;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmployeeCompAndBenefitDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$headarray = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$month = ($request[2]!='')?( $request[2]):date('Y-m-01');//$this->getBenefitMonth($request);
		$division = 0;//isset($_POST['division']) ? $_POST['division'] : "0";
		if($month!=0)
		{
			if(date("Y-m-d")<date($month))
			{
				$result["data"] =$data;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']="Cannot add future's Benefits";
			
			return $result;
			}
			$sWhere="";
			$sts=$_SESSION['ubihrm_user_sts'];
			if($sts!=1){
				$ids = Utils::getReportingIds($mid, $this->db);
				$sWhere = " and Id in ($ids) ";
			}
			if($division!=0){
				$sWhere .= " and Division = $division ";
			}
			$lta = 0;
			$ltamonth = 0;
					
			////////////////   FIND OUT THE BENEFIT HEADS ARE AVAILABLE  //////////////////////////			
			$sql1 = "SELECT Id, Name FROM BenefitMaster WHERE OrganizationId = ? ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $request[1]));
			while($row1 = $query1->fetch())
			{
				$res1 = array();
				$res1['id'] = $row1->Id;
				$res1['amount'] = 0;
				$res1['name'] =$row1->Name;
				$headarray[]=$res1;
			}
				
			$date1 = date('Y-m-d', strtotime(date('Y-m-01', strtotime($month))." +1 month"));
			
			$sql = "SELECT Id,FirstName,LastName,EmployeeCode,Division,EmployeeCTC,DOJ,Grade FROM EmployeeMaster WHERE OrganizationId = ? and (DOL='0000-00-00' or DOL>='$month') $sWhere and DOJ<=last_day('$month') order by Division, EmployeeCode, FirstName, MiddleName, LastName";
			$query = $this->db->prepare($sql);
			try{
			
			$query->execute(array( $orgid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$empcount=0;
				while($row = $query->fetch())
				{
					$emptotal = 0; 
					$emptotaldeduction = 0;
					$onedaysal =0; $gradeid=0;
					$res = array();
					$res['id'] = $row->Id;
					$res['name'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
					$res['empcode'] = $row->EmployeeCode;
					$res['empdivision'] = $this->getName($row->Division,'DivisionMaster');
					$res['empctc'] = $row->EmployeeCTC;
					$ctc = $row->EmployeeCTC;
					$res['empmonthname']=""; 
					$res['empmonthdate']=""; 
					$gradeid=$row->Grade;
					
					
					$onedaysal = round($ctc/30, 2);
					
					$res['empmonthdate']= $month;
					$res['empmonthname']=Utils::monthdateformatter($month);
					$number = cal_days_in_month(CAL_GREGORIAN, date('m', strtotime($month)), date('Y', strtotime($month)));
					$res['emppaiddays']=$number;
					
					if(date($res['empmonthdate'])<date($row->DOJ))
					{
						$d = date('d', strtotime($row->DOJ));
						$res['emppaiddays'] = $res['emppaiddays']-($d-1);
						$ctc = round(($ctc * $onedaysal),2);	
					}
					
					///////////FOR AUTO FILL THE BENEFITS,FETCH AMOUNT FROM BENEFIT&COMPANSATION CHILD THROUGH LAST COMP&BEN MONTH////
			
					
					$lastbencompid=$this->getLastCompBenefitId($row->Id,$orgid);
					for($i=0;$i<count($headarray);$i++)
					{
						$sql1 = "SELECT BenefitAmount FROM BenefitCompansationChild WHERE BenefitCompansationId = ? and BenefitId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($lastbencompid,$headarray[$i]['id'] ));
						if($row1 = $query1->fetch())
						{
							$headarray[$i]['amount'] = $row1->BenefitAmount;
						}else{
							$headarray[$i]['amount'] = 0;
						}
						$emptotal=$emptotal+(float)$headarray[$i]['amount'];		
					}
					for($i=0;$i<count($headarray);$i++)
					{
						
						if($headarray[$i]['name']=='Gratuity')
						{
							/////find out gratuity on termination of this month////////
							$temp=$headarray[$i]['amount'];
							$amt=0;
							$gratuitythismonth = Utils::getEmployeeGratuity($row->Id, 2, $this->db, date("Y-m-t", strtotime($month)));
							$gratuitylastmonth = Utils::getEmployeeGratuity($row->Id, 2, $this->db,  date("Y-m-t", strtotime("-1 month, ".date($month))));
							$amt=$gratuitythismonth-$gratuitylastmonth;
							if($amt>0){
								$headarray[$i]['amount'] =round($amt);
								$emptotal=$emptotal-(float)$temp;
								$emptotal=$emptotal+(float)$headarray[$i]['amount'];
							}
						}
						if($headarray[$i]['name']=='LTA')
						{
							/////find out the LTA Which wa paid in that month////////
							$temp=$headarray[$i]['amount'];
							$amt=0;
							
							$amt = self::getLTA($row->Id, $month);
							if($amt>0){
								$headarray[$i]['amount'] =round($amt);
								$emptotal=$emptotal-(float)$temp;
								$emptotal=$emptotal+(float)$headarray[$i]['amount'];
							}
						}
								
					}
					
					$res['totalgauranteepay']=0;
					$res['totalvariablepay']=0;
					$res['totalpay']=0;
					$res['totalbenefit']=0;
					
					$sql1 = "SELECT * FROM EmployeeSalaryDetails WHERE OrganizationId = ? and EmployeeId=? and HeadType=4";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id));
					if($query1->rowCount()>0)
					{
						while($row1 = $query1->fetch())
						{
							$res['totalgauranteepay'] = $res['totalgauranteepay']+$row1->HeadAmount;							
						}
						//$res['salarysts'] = true;
					}else{
						//$res['salarysts'] = false;
						$empcount++;
					}
					$sql1 = "SELECT * FROM EmployeeIncentive WHERE OrganizationId = ? and EmployeeId=? and ApplyDate=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid, $row->Id,$month));
					if($query1->rowCount()>0)
					{
						while($row1 = $query1->fetch())
						{
							$res['totalvariablepay'] = $res['totalvariablepay']+$row1->IncentiveAmount;							
						}
						//$res['salarysts'] = true;
					}
					
					$res['salarysts'] = true;
					///////total cash= guarantee + variable pay//////
					$res['totalpay'] = $res['totalgauranteepay'] + $res['totalvariablepay'];
					
					/////////total benefits/////////
					$res['totalbenefit']=$emptotal;
					
					/////////total compensation= total cash + total benefits//////////////////
					$res['total'] = $res['totalpay']+$res['totalbenefit'];	
					
					$res['salarydetail']=$headarray;
					
					$res['sts'] = $res['salarysts'];
					$data[] = $res;
				}
				if($empcount>0){
					$status=true;
					$successMsg=$empcount." Employee found without salary distribution.";
				}
			}else{
				$status=false;
				$errorMsg = "No employee left to add benefits";
			}
			}catch(Exception $e) {
				$status=false;
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
		}else{
			$status=false;
			$errorMsg = "Select Month for adding benefits";
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['mnth']=$month;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
	public function CreateCompandBenefit($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		///////////////  TRANSACTION BEGINS HERE ///////////////////////////////
		$this->db->beginTransaction();		
		try{	
			$emparr = json_decode($request[2] , true);
			$fiscalid = Utils::getFiscalId($emparr[0]['empmonthdate'], $this->db);
			
			if($fiscalid!=0)
			{
				for($i=0; $i<count($emparr); $i++)
				{
					
					if($emparr[$i]['sts'])
					{
						$bankname ="";
						$bankcode ="";
						$bankacct =0;
						
						$empid=0;
						$sql1="SELECT Id from BenefitCompansationMaster where EmployeeId=? and BenCompMonth=? and OrganizationId=?";
						$query1=$this->db->prepare($sql1);
						$query1->execute(array($emparr[$i]['id'],$emparr[$i]['empmonthdate'],$orgid));
						if($row=$query1->fetch())
						{
							$empid =$row->Id;
							$sql = "UPDATE BenefitCompansationMaster set TotalGauranteedPay=?, TotalVariablePay=?, TotalCompansation=?, TotalBenefitPay=?,  LastModifiedDate=?, LastModifiedById=? where Id=? ";
							try{
								$query = $this->db->prepare($sql);
								$query->execute(array( $emparr[$i]['totalgauranteepay'], $emparr[$i]['totalvariablepay'], $emparr[$i]['total'], $emparr[$i]['totalbenefit'], $mdate, $mid, $empid ));
								$count =  $query->rowCount();	
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}else{
							$sql = "INSERT INTO BenefitCompansationMaster (EmployeeId, BenCompMonth, TotalGauranteedPay, TotalVariablePay, TotalCompansation, TotalBenefitPay, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
							
							try{
								$query = $this->db->prepare($sql);
								$query->execute(array($emparr[$i]['id'], $emparr[$i]['empmonthdate'], $emparr[$i]['totalgauranteepay'], $emparr[$i]['totalvariablepay'], $emparr[$i]['total'], $emparr[$i]['totalbenefit'], $orgid, $mdate, $mid, $mdate, $mid));
								$empid = $this->db->lastInsertId();
								$count =  $query->rowCount();		
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}
							if ($count == 1) {
								///////////////////INSERT CHILD TABLE RECORD OF SALARY MASTER ////////////
								$sqlchild="delete from BenefitCompansationChild where BenefitCompansationId=?";
								$querychild=$this->db->prepare($sqlchild);
								$querychild->execute(array($empid));
								$salarychild = $emparr[$i]['salarydetail'];
								foreach( $salarychild as $value)
								{
									$sql = "INSERT INTO BenefitCompansationChild (BenefitCompansationId, BenefitId, BenefitAmount) values(?,?,?)";		
									$query = $this->db->prepare($sql);			
									try{
										
										$query->execute(array($empid, $value['id'], $value['amount'] ));
										$count =  $query->rowCount();						
									}catch(Exception $e) {
										$errorMsg = 'Message: ' .$e->getMessage();
									}
								}	
								//$empid=Utils::getName($did,'AttendanceMaster','EmployeeId',$this->db);
								$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
								$msg="Compandbenefit  of $empname has been created ";
								$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
								$query = $this->db->prepare($sql);
								$query->execute(array($mid, "Compandbenefit", $msg, $orgid));
							   $status =true;
							   $successMsg = "Compensation and Benefit saved successfully";
							}
					}
				}
			}else{
				$status =false;
				$errorMsg="Fiscal year not found for selected month";
			}
		//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
			$this->db->commit(); 
				 
			}catch(PDOException $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			}catch(Exception $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			} 
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		///////////////  TRANSACTION BEGINS HERE ///////////////////////////////
		$this->db->beginTransaction();		
		try{	
			$emparr = json_decode($request[2] , true);
			
			$fiscalid = Utils::getFiscalId($emparr['empmonthdate'], $this->db);
			
			if($fiscalid!=0)
			{
				
				$empid=0;
				$sql1="SELECT Id from BenefitCompansationMaster where EmployeeId=? and BenCompMonth=? and OrganizationId=?";
				$query1=$this->db->prepare($sql1);
				$query1->execute(array($emparr['id'],$emparr['empmonthdate'],$orgid));
				if($row=$query1->fetch())
				{
					$empid =$row->Id;
							
					$sql = "UPDATE BenefitCompansationMaster set TotalGauranteedPay=?, TotalVariablePay=?, TotalCompansation=?, TotalBenefitPay=?,  LastModifiedDate=?, LastModifiedById=? where Id=? ";
					try{
						$query = $this->db->prepare($sql);
						$query->execute(array( $emparr['totalgauranteepay'], $emparr['totalvariablepay'], $emparr['total'], $emparr['totalbenefit'], $mdate, $mid, $empid ));
						$count =  $query->rowCount();	
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}else{
					$sql = "INSERT INTO BenefitCompansationMaster (EmployeeId, BenCompMonth, TotalGauranteedPay, TotalVariablePay, TotalCompansation, TotalBenefitPay, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
							
					try{
						$query = $this->db->prepare($sql);
						$query->execute(array($emparr['id'], $emparr['empmonthdate'], $emparr['totalgauranteepay'], $emparr['totalvariablepay'], $emparr['total'], $emparr['totalbenefit'], $orgid, $mdate, $mid, $mdate, $mid));
						$empid = $this->db->lastInsertId();
						$count =  $query->rowCount();		
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				}
					if ($count == 1) {
						///////////////////INSERT CHILD TABLE RECORD OF SALARY MASTER ////////////
						$salarychild = $emparr['salarydetail'];
						$sqlchild="delete from BenefitCompansationChild where BenefitCompansationId=?";
						$querychild=$this->db->prepare($sqlchild);
						$querychild->execute(array($empid));
						foreach( $salarychild as $value)
						{
							$sql = "INSERT INTO BenefitCompansationChild (BenefitCompansationId, BenefitId, BenefitAmount) values(?,?,?)";		
							$query = $this->db->prepare($sql);			
							try{
									
								$query->execute(array($empid, $value['id'], $value['amount'] ));
								$count =  $query->rowCount();						
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
							}
						}	
						//$empid=Utils::getName($did,'AttendanceMaster','EmployeeId',$this->db);
						$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
						$msg="Compandbenefit  of $empname has been updated  ";
						$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($mid, "Compandbenefit", $msg, $orgid));
					   $status =true;
					   $successMsg = "Compensation and Benefit saved successfully";
					}
			}else{
				$status =false;
				$errorMsg="Fiscal year not found for selected month";
			}
		//////////////////////  TRANSANCTION COMMITTED HERE /////////////////////	
			$this->db->commit(); 
				 
			}catch(PDOException $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			}catch(Exception $e)
			{
				$status =false;
				$this->db->rollBack();
				$errorMsg = 'Message: ' .$e->getMessage();
			} 
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific SALARYMASTER
     * @param  $did contains SALARYMASTER id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid= $_SESSION['ubihrm_org_id'];
		$sql1 = "delete from BenefitCompansationChild where BenefitCompansationId= :id";		
		try{
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $did));
			
				//$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			$sql = "DELETE FROM BenefitCompansationMaster WHERE Id = :id ";		
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				$empid=Utils::getName($did,'BenefitCompansationMaster','EmployeeId',$this->db);
				$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Compandbenefit  of $empname has been deleted  ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Compandbenefit", $msg, $orgid));
			   $status =true;
			   $successMsg = SALARYMASTER_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=SALARYMASTER_MODULE_DELETE_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id, $tablename, $column='Name')
	{
		$name ="";
		$sql = "SELECT $column FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$column;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'BenefitCompansationMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'BenCompMonth', 'TotalGauranteedPay','TotalVariablePay','TotalVariablePay','TotalBenefitPay', 'TotalCompansation',  'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY Id, ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid ";
		}
		else{
			$ids =Utils::getReportingIds($userid, $this->db);
			$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid) ";
		}	
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( Select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($i==1){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
				
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete="";
					if($editper){
						$edit = '<a href="'.URL.'salary/viewcompandbenefit/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" rel="tooltip" title="View" ><i class="fa fa-eye"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;';
					}
					if($deleteper){
						$delete = '<a data-href="'.URL.'salary/deletecompandbenefit/'.$aRow->{$aColumns[$i]}.'"  href="#" data-toggle="modal" rel="tooltip" title="Delete" data-target="#confirm"><i class="fa fa-trash"></i></a>';
					}
					$row[] =$edit.$delete;
										
				}else if($aColumns[$i]=="EmployeeId")
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
				}
				elseif($aColumns[$i]=="EmployeeCTC" )
				{
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="BenCompMonth"){
					$row[] = Utils::monthdateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="TotalVariablePay" && $i==4){
					$totalcash=$aRow->TotalGauranteedPay+$aRow->TotalVariablePay;
					$row[] = $totalcash;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getLastCompBenefitId($empid,$orgid)
	{
		
		$month = "";
		
        $sql = "SELECT Id FROM BenefitCompansationMaster WHERE OrganizationId = ? and EmployeeId=? order by BenCompMonth desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid,$empid ));
			$count =  $query->rowCount();
		
			if($count>=1)
			{
				while($row = $query->fetch())
				{
					$month = $row->Id;					
				}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}	
		
		return $month;
	}
	public function getLTA($id, $month)
	{
		$result =0;
		$sql = "SELECT HeadAmount FROM SalaryMaster sm, SalaryChild sc WHERE sm.Id=sc.SalaryId and EmployeeId = ? and SalaryMonth=? and sc.Headid=9 and sc.HeadType=2 and HeadAmount>0";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id,$month ));
			if($row=$query->fetch())
			{
				$result =$row->HeadAmount;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	public function getBenefitMonth($request)
	{
		$result = array();
		$month = "";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT BenCompMonth FROM BenefitCompansationMaster WHERE OrganizationId = ? order by BenCompMonth desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$month = $row->BenCompMonth;					
			}
        }
			$sql = "SELECT SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = ? order by SalaryMonth desc limit 1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				//$month = $row->SalaryMonth;		
				if($month != $row->SalaryMonth){
					$month = $row->SalaryMonth;
				}else{
					$month = "";
				}
			}
			$status=true;
			$errorMsg="No Record found";
		
		return $month;
	}
	
	
}
