<?php

/**
 * RoleModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ClientModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
    /**
      * Get method for fetching the records of department
      * @return array an array with several objects (the results)
     */
   public function getAll($request){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$request[1];	
		$userid=$request[0];		
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$adminsts=$_SESSION['ubihrm_user_sts'];
        $sql = "SELECT Id,Name, CurrencyId FROM EmployerMaster WHERE OrganizationId = :id and Status=1 order by Name";
        $query = $this->db->prepare($sql);
		try{
				//USER ID CONTAINS IN ARRAY FIRST VALUE;
		//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1){
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch()){
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$res['currency'] = Utils::getName($row->CurrencyId ,"CurrencyMaster","CurrencyCode",$this->db); 
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg="Client get successfully";
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
    public function getDetail($id)  {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$sql = "SELECT * FROM EmployerMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1){
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch()){
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['clientmanager'] = (int)$row->ClientManager;
				$res['cperson'] = $row->ContactPerson;
				$res['cnumber'] = Utils::decode5t($row->ContactNumber);
				$res['email'] = Utils::decode5t($row->Email);
				$res['countryid'] = $row->CountryId;
				$res['currency'] =$row->CurrencyId;
				$res['cityid'] =$row->CityId;
				//$res['projectsts'] =$row->Projectsts;
				//$res['zipcode'] = $row->ZipCode;
				//$res['landmark'] = $row->Landmark;
				$res['companywebsite'] = $row->CompanyWebsite;
				$data[] = $res;
			}
        }
		if ($count == 1) {
           $status =true;
		   $successMsg ="Client get successfully";
        } else {
           $status =false;
		   $errorMsg="There are some problem";
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
     /**
     * Setter for a RoleMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
	   public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM EmployerMaster WHERE Id != ? AND Name = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[19], $request[2]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg="Client name already exist with the entered name.";
		}else{
			$sql = "UPDATE EmployerMaster SET OrganizationId=?, Name=?, ClientManager=?, ContactPerson=?, ContactNumber=?, Email=?, CountryId=?, CityId=?, CompanyWebsite=?,  LastModifiedDate=?, OwnerId=? , CurrencyId=? where Id=?";
			$query = $this->db->prepare($sql);
			try{
				//$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array($request[1], $request[2],$request[5], $request[3], Utils::encode5t($request[4]), Utils::encode5t($request[6]),  $request[8], $request[9],  $request[17], $mdate,$request[0], $request[7], $request[19]));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Client Updated Successfully!";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while updating record.";
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	/**
     * Setter for a RoleMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
	   public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM EmployerMaster WHERE Name = :name and OrganizationId=:orgid";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':name' => $request[2] , ':orgid' =>$orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status =false;
			 $errorMsg="Client name already exist with the entered name.";
		}else{
			$sql = "INSERT INTO EmployerMaster (OrganizationId, Name,  ClientManager, ContactPerson, ContactNumber, Email, CurrencyId, CountryId, CityId, CompanyWebsite,  LastModifiedDate,  CreatedDate,OwnerId) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
			
			try{
				//$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query = $this->db->prepare($sql);
				$query->execute(array($orgid, $request[2],$request[5], $request[3], Utils::encode5t($request[4]),Utils::encode5t($request[6]), $request[7], $request[8], $request[9],  $request[17], $mdate,  $mdate, $mid));
				
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Client Created Successfully!";
			} else {
			   $status =false;
			   $errorMsg="There is some problem while updating record.";
			}
		
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  
  public function getFileHeaders($request)
	{
			try {
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$file_name = "";
			
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];

				$ext = pathinfo($file_name, PATHINFO_EXTENSION); 
				$storage_name="newjoiningClient.$ext";
				
					if (!file_exists("public/uploads/$orgid/")) {
						 mkdir("public/uploads/$orgid/", 0777, true);
						}
				if (file_exists($storage_name))
				{ unlink("public/uploads/$orgid/$storage_name"); 
				}

				$file_size =$_FILES['file0']['size'];
				$file_tmp =$_FILES['file0']['tmp_name'];
				$file_type=$_FILES['file0']['type'];   
				$location="public/uploads/$orgid/";
				if($file_size > 2097152){
				$errors[]='File size must be less than 2 MB';
				}	
				
				if(empty($errors)==true){
				
					move_uploaded_file($file_tmp, $location.$storage_name );
					
				}else{
					print_r($errors);
				}
			}		
	
		$ext = pathinfo($file_name, PATHINFO_EXTENSION);
		if ($ext=='csv'){
		
			$fp = $location.$storage_name;
			
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				$row = 1;
				$ind=1;
				$arrData 		= array();
				while (($data = fgetcsv($handle, 5000, ",")) !== FALSE) 
				{
					
					if($row == 1)
					{
						for($i = 0 ; $i<count($data);$i++)
						{
							
							$record 	= array();				
							
							$record['head_name'] = $data[$i];
							$record['rows'] = $count;
							$record['column_index'] = (int)$count;
							$record['sts'] = true;
							$count++;
							
							$arrData[] = $record;			
						}
									
						$row++;
						
					}
				}
				
				
				if ($count >= 1) {
				   $status =true;
				   
				} 
				else {
				   $status =false;
				   $errorMsg = EMPLOYEE_MODULE_CREATION_FAILED;
				}
				$result["data"] =$arrData;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;
				return $result;
			}
		} 
		else if (strpos('xls',$ext)!==false || strpos('xlsx',$ext)!==false){
			require_once  LIBS_PATH.'ExcelClasses/PHPExcel/IOFactory.php';
			
			if ($ext=='xls'){
				$objReader = PHPExcel_IOFactory::createReader('Excel5');
			}else if($ext=='xlsx'){
				$objReader = PHPExcel_IOFactory::createReader('Excel2007');
			}
			 $objReader->setReadDataOnly(true); $objPHPExcel = $objReader->load($location.$file_name.".".$ext);
			 $objWorksheet = $objPHPExcel->getActiveSheet(); 
			 foreach ($objWorksheet->getRowIterator() as $row) 
			 {
				 $cellIterator = $row->getCellIterator(); 
				 $cellIterator->setIterateOnlyExistingCells(false); 
				 $count = 0;
					$record 						= array();				
					$record['head_name'] = "None";
					$record['name'] = '';
					$record['type'] = '';
					$record['data_label'] = '';
					$record['rows'] = $count;
					$record['h_count'] = $count;
					$record['sts'] = true;
					$arrData[] = $record;
					
				 foreach ($cellIterator as $cell) 
				 {
					
					$record = array();				
							
					$record['head_name'] = $cell->getValue();
					$record['name'] = '';
					$record['type'] = '';
					$record['data_label'] = '';
					$record['rows'] = $count;
					$record['h_count'] = $count;
					$record['sts'] = true;
					$count++;
					$arrData[] = $record;
				 } 
				 
				  array_pop($arrData);
				 break;
			 }
				
				return $result;
		}
			}catch(Exception $e){
				Utils::Trace($e->getMessage());
			}
	}
  
  
  public function importClient($request){
  	
  	$result = array();
  	$count=0; $errorMsg=""; $successMsg=""; $status=false;
  	 $c=0; $c1=0;
  	$mid = $request[0];
  	$orgid = $request[1];
  	$clientname = $request[2];
  	$contperson = $request[3];
  	$contnum = $request[4];
  	$email = $request[5];
  	$country = $request[6];
  	$city = $request[7];
  	$website = $request[8];
  	$sts = 1;
  	$file_name = "newjoiningClient.csv";		
	$mdate = date("Y-m-d H:i:s");
	$location=URL."public/uploads/$orgid/";
	$fp = $location.$file_name;
	
			$i=0;	
		if (($handle = fopen($fp, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				$countryId = ""; $cityId="";
				if($i>0){ 
				$sql1 = "SELECT Id FROM CountryMaster WHERE Name=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($data[$country]));
				while($row = $query1->fetch()){
					$countryId = $row->Id;
					
					$sql2 = "SELECT Id FROM CityMaster WHERE CountryId=? AND Name=?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($countryId,$data[$city]));
					while($row1 = $query2->fetch())
					{
						  $cityId = $row1->Id;
					}
				}
					$sql = "SELECT * FROM EmployerMaster WHERE Name = ? AND CountryId =? AND CityId=?";
					$query = $this->db->prepare($sql);
					try{ 
						$query->execute(array($data[$clientname],$countryId,$cityId));
						$count =  $query->rowCount();
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
					if ($count >= 1) {
						$status =true;
						$c++;
						$errorMsg = EMPLOYEE_MODULE_UPDATION_DUPLICATE;
					}else{
						
						$sql = "INSERT INTO EmployerMaster (OrganizationId,Name,`ContactPerson`,`ContactNumber`,`Email`, `CountryId`, `CityId`,`CompanyWebsite`, `CreatedDate`, `CreatedById`, `LastModifiedDate`, `OwnerId`,`Status`) VALUES (?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)";		
						try{
							$query = $this->db->prepare($sql);
							$query->execute(array($orgid,$data[$clientname],$data[$contperson],Utils::encode5t($data[$contnum]),Utils::encode5t($data[$email]),$countryId ,$cityId,$data[$website],$mdate,$mid,$mdate,$mid,$sts));
							$count1 =  $query->rowCount();		
						}catch(Exception $e) {
							$errorMsg .= 'Message: ' .$e->getMessage();
						}
						
					}
				}							
				$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatemp"] =$c;
		$result["importemp"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
  	
  }
  
	/**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
	 public function DeleteClient($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM EmployerMaster WHERE Id = :id ";		
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg =  "Client Deleted Successfully!";
			}else {
			   $status =false;
			   $errorMsg="There is some problem while deleting record.";
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	 
    public function ChangeClientStatus($id)
    {
		$result = array();
		$count=0; $count1=0; $count2=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$sts=1;
		$usts=1;
		
		$sql1 = "SELECT * FROM EmployerMaster WHERE Id = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($id));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$row1 = $query1->fetch();
			$empsts = $row1->Status;
			//$userid = $row1->user_id;
			
			if($empsts==0)
			{
				$sts=1;
			}
			else
			{
				$sts=0;
			}
			$sql = "UPDATE EmployerMaster SET Status=?, LastModifiedDate=? where Id=?";
		
			$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array($sts, $mdate, $id));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if ($count == 1) {
			   $status =true;
			   //$successMsg = "Client status has been updated successfully !";
			} else {
			   $status =false;
			   //$errorMsg="There is some problem while updating record !";
			}
		}else{
			
			$status=false;
			$errorMsg="Record does not exist !";
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getDataTable($editper,$deleteper)
	{
		$sTable = 'EmployerMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name','Id','ContactPerson','CountryId','Email','ContactNumber','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid ";
		}else{
			//$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sWhere = " WHERE id in (select company from project_master where ((owner_id=$userid) OR (ClientManager=$userid) OR (ProjectLead=$userid) )) AND OrganizationId= $orgid  ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		$totalcount=$query->rowCount();
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$index++;
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				if($aColumns[$i]=="Id" && $i==6)
				{
					$edit =""; $delete="";$viewdetail="";$addproject ="";
					if($editper)
					{
						$edit ='<a rel="tooltip" href="'.URL.'client/editclient/'.Utils::encode5t($aRow->{$aColumns[$i]}).'"  title="Edit Client"><i class="fa fa-pencil-square-o green-700"></i></a>';
					}else{
						$edit ='<a href="#" data-toggle="tooltip" rel="tooltip" title="No permission to edit"><i class="fa fa-pencil green-700"></i></a>';
					}
					if($deleteper){
						$delete ='<a onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" rel="tooltip" title="Delete"><i class="fa fa-trash" rel="tooltip"></i></a>';
					}else{
						$delete ='<a href="#" data-toggle="tooltip" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
					$viewdetail='<a rel="tooltip" href="'.URL.'client/ViewClientDetail/'.Utils::encode5t($aRow->{$aColumns[$i]}).'"  title="View Details"><i class="fa fa-eye green-700"></i></a>';
					
					$addproject ='<a href="'.URL.'timesheet/addproject/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" rel="tooltip" title="Add Project"><i class="fa fa-file-powerpoint-o" rel="tooltip"></i></a>';
					/* if($deleteper)
					{
					$delete = '<a onclick="angular.element(this).scope().getId(\''.$aRow->id.'\')" data-toggle="modal" rel="tooltip" data-target="#delete" href="#" title="Delete"><i class="icon wb-trash"></i></a>';
					} */
					$row[] =$viewdetail."&nbsp;|&nbsp;".$addproject."&nbsp;|&nbsp;".$edit."&nbsp;|&nbsp;".$delete ;
				}
				/* else if($aColumns[$i]=="Status")
				{
						if($aRow->{$aColumns[$i]}==1){
							
							if($aRow->{$aColumns[$i]}==1){
								$row[]=	"<center><a rel='tooltip' title='Change Status' href='#' onclick=\"angular.element(this).scope().onchangeadmin('".$aRow->Id."')\" ><span class='label label-success'>Active</span></a></center>";
							}else{
								$row[]=	"<center><span class='label label-success'>Active</span></center>";
							}
						}
						else{
						if($aRow->{$aColumns[$i]}==0){
								$row[]=	"<center><a rel='tooltip' title='Change Status' href='#' onclick=\"angular.element(this).scope().onchangeadmin('".$aRow->Id."')\" ><span class='label label-danger'>Inactive</span></a></center>";
							}else{
								$row[]=	"<center><span class=''label label-danger'>Inactive</span></center>";
							}
						}
					
				} */
				elseif($aColumns[$i]=="ContactNumber"){
					$row[] = Utils::decode5t($aRow->ContactNumber);
					
				}elseif($aColumns[$i]=="Name"){
					$row[] = '  <a  rel="tooltip" title="View Details" href="'.URL.'client/ViewClientDetail/'.Utils::encode5t($aRow->Id).'">'.$aRow->Name.'</a>';
					
				}elseif($aColumns[$i]=="Email")
				{
					$row[] = Utils::decode5t($aRow->Email);
				}elseif($aColumns[$i]=="CountryId")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},"CountryMaster","Name",$this->db);
				}else	if($aColumns[$i]=="Id" && $i==1)
				{
					$row[] = $this->getNoOfProject($aRow->{$aColumns[$i]});
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
				
			}			
			$output['aaData'][] = $row;
			
		}		
		return  $output ;
	}
	
	///////////Get Employee Name/////////////
	public function getEmployeeName($id)
	{
		$name ="";
		$sql = "SELECT FirstName, MiddleName, LastName FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName));
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	 public function getNoOfProject($clientid)
    {
		$result = array();	$data = array(); $count=0;
		$sql = "SELECT count(id) as totalproject FROM project_master where company=?";
        $query = $this->db->prepare($sql);
        $query->execute(array($clientid));
		while($row = $query->fetch())
		{
			
			$count= $row->totalproject;	
		
		}
		return $count;
    }

	public function getClientprojectDataTable($clientid)
	{
		$sTable = 'project_master';
		$sIndexColumn = "id";
		$aColumns = array('project_title','ProjectTypeId', 'id','id','Billingsts', 'project_status','id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  id desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid and company=$clientid  ";
		}else{
			//$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			$sWhere = " WHERE ((owner_id=$userid or ClientManager=$userid or ProjectLead=$userid) AND OrganizationId= $orgid and company=$clientid) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id" && $i==7){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (owner_id in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					
						
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				/* if($aColumns[$i]=="owner_id" )
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					
				} */
				if($aColumns[$i]=="id" && $i==6)
				{
					$viewdetail="";
					$viewdetail= '  <a rel="tooltip" title="Edit detail	" href="'.URL.'timesheet/editproject/'.Utils::encode5t($aRow->id).'/'.Utils::encode5t($clientid).'/2"><i class="fa fa-edit green-700"></i></a>';
					$row[] =$viewdetail;
				}else if($aColumns[$i]=="ProjectTypeId" )
				{ 
						$teamcount ="";
						$teamcount = $this->countprojecteam($aRow->id);
					//$row[] = Utils::getName($aRow->{$aColumns[$i]},"ProjectTypeMaster","Name",$this->db);
					$row[] = count($teamcount);
				}elseif($aColumns[$i]=="project_title"){
					$row[] = '  <a  rel="tooltip" title="View Detail" href="'.URL.'timesheet/editproject/'.Utils::encode5t($aRow->id).'/'.Utils::encode5t($clientid).'/1">'.$aRow->project_title.'</a>';
					
				}elseif($aColumns[$i]=="id" && $i==2){
										
					$row[] =$this->TotaltaskTime($aRow->id ,2);
				}elseif($aColumns[$i]=="id" && $i==3){
											
					$row[] =$this->TotaltaskTime($aRow->id ,3);
				}
				else if($aColumns[$i]=="project_status"){
					
					if($aRow->{$aColumns[$i]}==1)
						$sts="<span class='label label-success'>Running</span>";
					else if($aRow->{$aColumns[$i]}==2)
						$sts="<span class='label label-warning'>Abandoned</span>";
					else if($aRow->{$aColumns[$i]}==3)
						$sts="<span class='label label-danger'>Finished</span>";
					else if($aRow->{$aColumns[$i]}==4)
						$sts="<span class='label label-info'>Re opened</span>";
					else if($aRow->{$aColumns[$i]}==5)
						$sts="<span class='label label-primary'>Not Started</span>";
					$row[] = $sts;
				}else if($aColumns[$i]=="Billingsts"){
					$billsts="";
					if($aRow->{$aColumns[$i]}==1)
						$billsts="<span class='label label-info'>Billable</span>";
					else if($aRow->{$aColumns[$i]}==2)
						$billsts="<span class='label label-warning'>Non Billable</span>";
					$row[] = $billsts;
				}
				/* elseif($aColumns[$i]=="assigned_to"){
					$assign=explode(",",$aRow->{$aColumns[$i]});
					$assignemp="";
					for($ij=0;$ij<count($assign);$ij++)
					{
						if($assignemp=="")
							$assignemp=Utils::getEmployeeName($assign[$ij], $this->db);
						else
							$assignemp.=", ".Utils::getEmployeeName($assign[$ij], $this->db);
					}
					$row[] = $assignemp;
				} */
				
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}

	public function getProjectTeamData($clientid) {
		$count=0; $result=array(); $data=array(); $status=false;
		$sql="select * from project_master where company=?";
		$query=$this->db->prepare($sql);
		$query->execute(array($clientid));
		$count=$query->rowcount();
		if($count>=1){
			$status=true;
			$successMsg=$count." record found";
			while($row=$query->fetch()) {
				//$assigned_to['empid']=explode(',' ,$row->assigned_to);
				if($row->assigned_to!=0){
					$assign=$this->getEmpdesig($row->assigned_to);
				
				foreach($assign as $key=>$value){
					$res=array();
					//$assigned_to=array;
					$res['projectid']=$row->id;
					$res['project_title']=$row->project_title;
					$res['start_date']=$row->start_date;
					$res['completed_date']=$row->completed_date;
					$res['empid']=$value['empid'];
					$res['empname']=$value['empname'];
					$res['empimage']=$value['ImageName'];
					$res['designame']=$value['designame'];
					$res['taskcomplete']=$this->getEmptask($row->id , $value['empid'],1);
					$res['taskassign']=$this->getEmptask($row->id , $value['empid'],2);
					$res['esttotaltime']=$this->getesttotaltime($row->id , $value['empid'],1);
					$res['getactultotaltime']=$this->getesttotaltime($row->id , $value['empid'],2);
					$result[]=$res;
				}
				}
					//	$res['assigned_to']=$assigned_to;
			}
			}else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		return $result;
	}
	public function TotaltaskTime($projectid,$val)
	{
		$result = array(); $res=array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$totalleave=0;
			$totalday=0;$totalhour=0; $totalminute=0;
			$totalday1=0;$totalhour1=0; $totalminute1=0;
			//$sql="select * from task_master where projectid =? ";
			$sql="select * from project_master where id =? ";
			$query=$this->db->prepare($sql);
			$query->execute(array($projectid));
			$count = $query->rowcount();
			$days1='';$hours1='';$minutes1='';
			while($row1= $query->fetch()) {
				//$start = new DateTime($row1->fromdate);
			//	$since_start1 = $start->diff(new DateTime($row1->todate));
				$start = $row1->start_date;
				$today = $row1->completed_date;
				$days1 = strtotime($today) - strtotime($start);
				$totalday1 = floor($days1/(60*60*24));
				/* if($since_start1->d>0){
					$days1=$since_start1->d.' days';
					$totalday1=$totalday1+$since_start1->d;
				} */
				/* if($since_start1->h>0){
					$hours1 = $since_start1->h.' hours';
					$totalhour1=$totalhour1+$since_start1->h;
				}
				if($since_start1->i>0){
					$minutes1 = $since_start1->i.' minutes';
					$totalminute1=$totalminute1+$since_start1->i;
				}
				if($totalhour1>24){
					$totalday1=$totalday1+1;
					$totalhour1=$totalhour1-24;
				}
				if($totalminute1>60){
					$totalhour1=$totalhour1+1;
					$totalminute1=$totalminute1-60;
				} */
			}
			$sql="select * from task_master where projectid =? and OrganizationId=?";
			$query=$this->db->prepare($sql);
			$query->execute(array($projectid, $orgid));
			$count = $query->rowcount();
			while($row1= $query->fetch()) {
				$start = explode(":", $row1->Totalhour);
				if($row1->Totalhour!=""){
					$hours1= $start[0];
					$totalhour1=$totalhour1+$hours1;
					$minutes1 = $start[1];
					$totalminute1=$totalminute1+$minutes1;
				}
			
			$sql2="SELECT * FROM timesheet_master where task_id=? and  project_id = ? and OrganizationId=?";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($row1->id,$projectid, $orgid));
			$con1=$query2->rowCount();
			$mindate="";
			$maxdate="";	$days='';$hours='';$minutes=''; 	$acttotal_time="";
			while($row2 = $query2->fetch()) {
				$total_time = explode(":", $row2->total_time);
				if($row2->total_time!=""){
					$hours= $total_time[0];
					$totalhour=$totalhour+$hours;
					$minutes = $total_time[1];
					$totalminute=$totalminute+$minutes;
					if($totalminute>60){
						$totalhour=$totalhour+1;
						$totalminute=$totalminute-60;
					}
				}
				/*$maxdate=$row2->timesheetend;
				$mindate=$row2->timesheetstart;
				$start_date = new DateTime($mindate);
				$since_start = $start_date->diff(new DateTime($maxdate));
				 if($since_start->d>0){
					$days=$since_start->d.' days';
					$totalday=$totalday+$since_start->d;
				} 
				if($since_start->h>0){
					$hours = $since_start->h.' hours';
					$totalhour=$totalhour+$since_start->h;
				}
				if($since_start->i>0){
					$minutes = $since_start->i.' minutes';
					$totalminute=$totalminute+$since_start->i;
				}
				/* if($totalhour>24){
					$totalday=$totalday+1;
					$totalhour=$totalhour-24;
				} 
				if($totalminute>60){
					$totalhour=$totalhour+1;
					$totalminute=$totalminute-60;
				}*/
			}
		}
			//$acttotaltime= $days.' '.$hours.' '.$minutes;
			//$acttotaltime= $hours.' '.$minutes;
			$esttotal_time =$totalhour1.' hours, '.$totalminute1.' minutes';
			$project_time =$totalday1.' days';
			//$acttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
			$acttotal_time =$totalhour.' hours, '.$totalminute.' minutes';
				
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($val==1)
		return $project_time;
		if($val==2)
		return $acttotal_time;
		if($val==3)
		return $esttotal_time;
	}

	public function getEmpdesig($empid){
		$result=array(); $count=0;
		$orgid = $_SESSION['ubihrm_org_id'];	
		if($empid!=""){
		$sql="select * from EmployeeMaster where Id in ($empid)";
		$query=$this->db->prepare($sql);
		$query->execute();
		$count = $query->rowcount();
			while($row= $query->fetch()){
				$res=array();
				$res['empid']=$row->Id;
				$image= $row->ImageName;
			//	$res['empgender'] = $row->Gender;
				$res['ImageName']='<img src="'.URL.'public/avatars/male.png" height="50px" width="50px"  class="img-circle">';
				if($image != ""){
					if (file_exists( "public/uploads/$orgid/$image")) {
						 $res['ImageName']='<img src="'.URL.'public/uploads/'.$orgid.'/'.$image.'" height="50px" width="50px"  class="img-circle">';
					}
				}
				if($image == ""){
					if($row->Gender== 2)	{
						$res['ImageName']='<img src="'.URL.'public/avatars/female.png" height="50px" width="50px" class="img-circle">';
					}
				}
				$res['empname']= self::getEmployeeName($row->Id);
				$res['desigid']=$row->Designation;
				$res['designame']= Utils::getName($row->Designation,"DesignationMaster","Name",$this->db);
				$result[]=$res;
			}
			return $result;
		}
	}
	
	public function countprojecteam($productid){
		$result=array(); $count=0;$completed=0;
		if($productid!=""){
		$sql="select assigned_to from project_master where id =?";
		$query=$this->db->prepare($sql);
		$query->execute(array($productid));
		$count = $query->rowcount();
			while($row= $query->fetch()){
				$completed=explode(',' ,$row->assigned_to);
			}
				return $completed;
			
		}
	}
	public function countprojectask($projectid){
		$result=array(); $count=0;$completed=0;
		if($projectid!=""){
		$sql="select * from task_master where projectid =?";
		$query=$this->db->prepare($sql);
		$query->execute(array($projectid));
		$count = $query->rowcount();
		return $count;
			
		}
	}
	public function getEmptask($productid,$empid,$val){
		$result=array(); $count=0;$completed=0;
		if($empid!="" && $productid!=""){
		$sql="select * from task_master where projectid =? and assignto=?";
		$query=$this->db->prepare($sql);
		$query->execute(array($productid,$empid));
		$count = $query->rowcount();
			while($row= $query->fetch()){
			if($row->taskstatus==2){
					$completed++;
				}
			}
			if($val ==1){
				return $completed;
			}else{
				return $count;
			}
		}
	}
	public function getesttotaltime($productid,$empid,$val){
		$result=array();$esttotal_time="";$acttotal_time ="";
		if($empid!="" && $productid!="") {
			$sql="select * from task_master where projectid =? and assignto=?";
			$query=$this->db->prepare($sql);
			$query->execute(array($productid,$empid));
			$count = $query->rowcount();
			$totalday=0;$totalhour=0; $totalminute=0;
			$totalday1=0;$totalhour1=0; $totalminute1=0;
			
			while($row1= $query->fetch()) {
				$start = explode(":", $row1->Totalhour);
				if($row1->Totalhour!=""){
					$hours1= $start[0];
					$totalhour1=$totalhour1+$hours1;
					$minutes1 = $start[1];
					$totalminute1=$totalminute1+$minutes1;
				}
				/* $start = new DateTime($row1->fromdate);
				$since_start1 = $start->diff(new DateTime($row1->todate)); */
				/* if($since_start1->d>0){
					$days1=$since_start1->d.' days';
					$totalday1=$totalday1+$since_start1->d;
				}
				if($since_start1->h>0){
					$hours1 = $since_start1->h.' hours';
					$totalhour1=$totalhour1+$since_start1->h;
				}
				if($since_start1->i>0){
					$minutes1 = $since_start1->i.' minutes';
					$totalminute1=$totalminute1+$since_start1->i;
				}
				if($totalhour1>24){
					$totalday1=$totalday1+1;
					$totalhour1=$totalhour1-24;
				}
				if($totalminute1>60){
					$totalhour1=$totalhour1+1;
					$totalminute1=$totalminute1-60;
				} */
				
			
				$sql2="SELECT * FROM timesheet_master where task_id=? and project_id = ? and EmployeeId=?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($row1->id,$productid,$empid));
				$con1=$query2->rowCount();
				$days='';$hours='';$minutes='';
					$days1='';$hours1='';$minutes1='';
				while($row2 = $query2->fetch()) 	{
					$total_time = explode(":", $row2->total_time);
					if($row2->total_time!=""){
						$hours= $total_time[0];
						$totalhour=$totalhour+$hours;
						$minutes = $total_time[1];
						$totalminute=$totalminute+$minutes;
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
					}
					//$maxdate=$row2->timesheetend;
					//$mindate=$row2->timesheetstart;
					/* $start = strtotime($mindate);
						$end   = strtotime($maxdate);
						$diff  = $end - $start;

						 $hours = floor($diff / (60 * 60));
						 $totalhour=$totalhour+	$hours ;
						$minutes1 = $diff - $hours * (60 * 60);
						$minutes = floor( $minutes1 / 60 ) ;
						$totalminute=$totalminute+$minutes;
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}  
					 $start_date = new DateTime($mindate);
					 $since_start = $start_date->diff(new DateTime($maxdate));
					//echo("hrs-".$since_start->h." min-".$since_start->i);
					/* if($since_start->d>0){
						$days=$since_start->d.' days';
						$totalday=$totalday+$since_start->d;
					}
					 if($since_start->h>0){
						$hours = $since_start->h.' hours';
						$totalhour=$totalhour+$since_start->h;
					}
					if($since_start->i>0){
						$minutes = $since_start->i.' minutes';
						 $totalminute=$totalminute+$since_start->i;
					} 
					 if($totalhour>24){
						$totalday=$totalday+1;
						$totalhour=$totalhour-24;
					}
					 if($totalminute>60){
						$totalhour=$totalhour+1;
						$totalminute=$totalminute-60;
					}  */ 
				}
			}
			//$esttotal_time = $totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
			//$acttotal_time =$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
			//$esttotal_time =$totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
			$esttotal_time =$totalhour1.' hours, '.$totalminute1.' minutes';
			//$acttotal_time = $totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
			$acttotal_time = $totalhour.' hours, '.$totalminute.' minutes';
		}
		if($val==1)
			return $esttotal_time;
		if($val==2)
			return $acttotal_time;
	}
	
	public function ViewEmpTaskDetail($projectid,$empid)
	{
		$result = array(); $res=array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $orgdetails=array();
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$totalleave=0; $timesheet=array();$timesheet1=array();
			$res=array(); 
			$res['project']=Utils::getName($projectid,'project_master','project_title',$this->db);
			$res['empname']=self::getEmployeeName($empid);
			$sql1="SELECT * FROM task_master where projectid=? and assignto =? ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($projectid, $empid));
			$con=$query1->rowCount();
			if($con>=1){
				while($row1 = $query1->fetch()) {
					$res1=array(); 
					$totalday=0; $totalhour=0; $totalminute=0;
					$totalday1=0;$totalhour1=0; $totalminute1=0;
				
					$res1['taskno']=$row1->task_no;
					$res1['tasktitle']=$row1->task_title;
				
					$res1['eststartdate']=Utils::dateformatter($row1->fromdate);
					$res1['estenddate']=Utils::dateformatter($row1->todate);
					$res1['taskstatus']=$row1->taskstatus;
					$totoalhour="";
					$totoalhour= explode(":",$row1->Totalhour);
					if($row1->Totalhour!=""){
						if($totoalhour[0]<=9 && $totoalhour[1]<=9){
								$res1['esttotaltime']= '0'.$totoalhour[0] .':'.'0'.$totoalhour[1];
						}else if($totoalhour[0]<=9 && $totoalhour[1]<>9){
								$res1['esttotaltime']= '0'.$totoalhour[0] .':'.$totoalhour[1];
						}else if($totoalhour[0]<>9 && $totoalhour[1]<=9){
								$res1['esttotaltime']= $totoalhour[0] .':'.'0'.$totoalhour[1];
						}else{
								$res1['esttotaltime']= $totoalhour[0] .':'.$totoalhour[1];
						}
						//$res1['esttotaltime']=  '0'.$totoalhour[0] .' hours, '.'0'.$totoalhour[1].' minutes ';
					//$row[] = '0'.$totoalhour[0] .':'.'0'.$totoalhour[1];
					}else{
							$res1['esttotaltime']="";
					}
					
			
					////////////////////GET data timesheet////////////////////////////////
					$sql2="SELECT * FROM timesheet_master where task_id = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($row1->id));
					$con1=$query2->rowCount();
					$mindate="";
					$maxdate="";
				//	$start_date1 = new DateTime($row1->fromdate);
					//$since_start1 = $start_date1->diff(new DateTime($row1->todate));
				
					$days1='';$hours1='';$minutes1='';
					$res1['actstartdate']="";$res1['actenddate']="";$res1['acttotaltime']="";
					while($row2 = $query2->fetch())	{
						$days='';$hours='';$minutes='';$totalhour1="";
						$maxdate=$row2->timesheetend;
						$mindate=$row2->timesheetstart;
						$res1['actstartdate']=Utils::dateformatter($row2->timesheetstart);
						$totoalhour1= explode(":",$row2->total_time);
						if($row2->total_time!=""){
							$res1['acttotaltime']= $totoalhour1[0] .':'.$totoalhour1[1];
						}else{
							$res1['acttotaltime']="";
						}
						//$res1['actenddate']=Utils::datetimeformatter($row2->timesheetend);
						/* $start_date = new DateTime($mindate);
						$since_start = $start_date->diff(new DateTime($maxdate));
						$res1['acttotaltime']= $since_start->h.' hours, '.$since_start->i.' minutes'; */
						$result[]=$res1;	
				}	
				if($con1<1){
					$result[]=$res1;	
				}
				
						//print_r($result);
				}
			}
			$res['taskdata']=$result;	
			//print_r($res);
			$data[] =$res;
			///Get for other data///	
/* 			$sql2="SELECT * FROM timesheet_master where task_id =0 and project_id=? and EmployeeId=? ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($projectid,$empid));
				$con1=$query2->rowCount();
				$mindate="";
				$maxdate="";	
				$totalday=0; $totalhour=0; $totalminute=0;
				$totalday1=0;$totalhour1=0; $totalminute1=0;
				while($row2 = $query2->fetch())	{
					$maxdate=$row2->timesheetend;
					$mindate=$row2->timesheetstart;
					if($con1>0){
						$res1=array();
						$res1['empname']=self::getEmployeeName($empid);
						$res1['taskno']="";
						$res1['tasktitle']="Other";
						$res1['project']=Utils::getName($projectid,'project_master','project_title',$this->db);
						$res1['taskstatus']="0";
						$days='';$hours='';$minutes='';
						$days1='';$hours1='';$minutes1='';
						$start_date1 = new DateTime("0000-00-00");
						$since_start1 = $start_date1->diff(new DateTime('0000-00-00'));
						/////actual duration/////
						$start_date = new DateTime($mindate);
						$since_start = $start_date->diff(new DateTime($maxdate));
						if($since_start->d>0){
							$days=$since_start->d.' days';
							$totalday=$totalday+$since_start->d;
						}
						if($since_start->h>0){
							$hours = $since_start->h.' hours';
							$totalhour=$totalhour+$since_start->h;
						}
						if($since_start->i>0){
							$minutes = $since_start->i.' minutes';
							$totalminute=$totalminute+$since_start->i;
						}
						if($totalhour>24){
							$totalday=$totalday+1;
							$totalhour=$totalhour-24;
						}
						if($totalminute>60){
							$totalhour=$totalhour+1;
							$totalminute=$totalminute-60;
						}
					}
				}
				if($since_start1->d>0){
					$days1=$since_start1->d.' days';
					$totalday1=$totalday1+$since_start1->d;
				}
				if($since_start1->h>0){
					$hours1 = $since_start1->h.' hours';
					$totalhour1=$totalhour1+$since_start1->h;
				}
				if($since_start1->i>0){
					$minutes1 = $since_start1->i.' minutes';
					$totalminute1=$totalminute1+$since_start1->i;
				}
				if($totalhour1>24){
					$totalday1=$totalday1+1;
					$totalhour1=$totalhour1-24;
				}
				if($totalminute1>60){
					$totalhour1=$totalhour1+1;
					$totalminute1=$totalminute1-60;
				}
				if($con1>0){
				$res1['acttotaltime']=$totalday.' days, '.$totalhour.' hours, '.$totalminute.' minutes';
				$res1['esttotaltime']= $totalday1.' days, '.$totalhour1.' hours, '.$totalminute1.' minutes';
				$data[]=$res1;
			} */
			}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		return $data;
	}
	public function getClientDashboard($clientid)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=true;
		$data = array();
		 $startdate = isset($_POST['startdate'])?$_POST['startdate']:"";
		
		$enddate =  isset($_POST['enddate'])?$_POST['enddate']:"";
		if($startdate=="")
			$startdate = date("Y-m-01");  // hard-coded '01' for first day
		if($enddate=="")
			$enddate = date("Y-m-t");
		$swhere ="";
		if(isset($_POST['projectstatus']) && $_POST['projectstatus']!=0) {
			$swhere =" AND project_status=".$_POST['projectstatus'];
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
	
		//$senior = Utils::getApprovalLevelEmp($userid, 1, $this->db);
		//$senioremail=Utils::decode5t(Utils::getName($senior,'EmployeeMaster','CompanyEmail',$this->db));
		//echo "$filscalid";
		try{
			$sts=1;
			$hrsts=1;
		
			$data['chartdata1date'] = "";
			$data['chartdata1'] = array();
			$data['chartdata2'] = array();
			///////////  GETTING LIST OF Project employees And Assign Task//////////////////
			//$sql="select * from project_master where company=? $swhere AND created_date between '$startdate' and '$enddate'";
			$sql="select * from project_master where company=? $swhere AND created_date between '$startdate' and '$enddate'";
			$query=$this->db->prepare($sql);
			$query->execute(array($clientid));
			$count=$query->rowcount();
			if($count>=1){
				while($row=$query->fetch()) {
				//$assigned_to['empid']=explode(',' ,$row->assigned_to);
					$res = array();
					$res['projectid']=$row->id;
					$res['projectname']= $row->project_title;
					$res['totalactualtime']=$this->TotaltaskTime($row->id ,2);
					$res['totalestimatedtime']=$this->TotaltaskTime($row->id,3);
					if($row->assigned_to!=0){
						$assign=$this->getEmpdesig($row->assigned_to);
					
					}
					$res['assigno']=count($assign);
					$data['chartdata1'][] = $res;
					
				}
			}
			//Utils::Trace($sql1);
		
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}

		//$curmonth=date('F');
		$result["data"] =$data;
		$result["startdate"] =$startdate;
		$result["enddate"] =$enddate;
		//$result["curmonth"] =$curmonth;
		$result['status']=$status;
		//$result['filscalid']=0;
		//$result['fiscal_format']=date("M'y", strtotime(date($startdate)));
		//$result['date']=$startdate;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;

		return $result;
    }

}
