<?php

/**
 * DocumentModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ClaimModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    

	public function getDetail($id)
    {
		
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
		try{
			//$id=Utils::decode5t($id);
			$sql = "SELECT * FROM ClaimsMaster WHERE Id = :id";
			$query = $this->db->prepare($sql);			
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['employeeid'] = (int)$row->EmployeeId;
					$res['employee'] = $this->getName($row->EmployeeId,'EmployeeMaster');
					$res['fromdate'] = Utils::dateformatter($row->FromDate);
					$res['todate'] =  Utils::dateformatter($row->ToDate);
					$res['purpose'] = $row->Purpose;
					$res['totalclaim'] = $row->TotalAmt;
					$res['approverid'] =Utils::getEmployeeName( $row->ApproverId,$this->db);
					$res['appsts'] = ($row->ApproverSts==0)?3:$row->ApproverSts;
					$empcode=Utils::getName($row->EmployeeId,'EmployeeMaster','EmployeeCode',$this->db);
					
					$sql1 = "SELECT Department, Designation,Division FROM EmployeeMaster WHERE Id = ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $row->EmployeeId ));
					while($row1 = $query1->fetch())
					{
						$res['department'] = Utils::getName($row1->Department, "DepartmentMaster","Name", $this->db);
						$res['designation'] = Utils::getName($row1->Designation, "DesignationMaster","Name", $this->db);
						$res['division'] = Utils::getName($row1->Division, "DivisionMaster","Name", $this->db);
						
					}
					
					$sql2 = "SELECT * FROM ClaimsChild where ClaimId=? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($id ));
					while($row1 = $query2->fetch())
					{
						$res1 = array();
						$res1['id'] = $row1->Id;
						$res1['date'] = Utils::dateformatter($row1->EventDate);
						$res1['head'] = $row1->ClaimHead;
						$res1['desc'] = $row1->Description;
						$res1['claimamt'] = $row1->ClaimAmt;
						$image = $row1->Doc;
						if($image!=""){
							if (file_exists( "public/uploads/$orgid/$empcode/$image")) {
								$res1['doc']= URL."public/uploads/$orgid/$empcode/$image". "?img=" .rand(1,100);
							}
						}
						$res['claimarr'][] = $res1;
					}
					$data[] = $res;
				}
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
	 public function Approve($request)
    {
		$result = array();
		$count=0;$count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$claimid =  $request[2];
		$empid= Utils::getName($claimid,'ClaimsMaster','EmployeeId',$this->db);
		try{
			
			$sql = "UPDATE ClaimApproval SET ApproverSts =?, ApprovalDate =?, ApproverComment=? WHERE ClaimId =? AND ApproverId=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[3], $mdate, $request[4], $claimid, $mid, $orgid));
			$count =  $query->rowCount();		
			
			if ($count >= 1) {
			   $status =true;
			   
			   if($request[3]==2){
					$successMsg = "Claim request has been approved";
					///////Insert Finance ID in Claim Approval Table///////////
					if($request[6]!=0){
						$sqlfin="insert into ClaimApproval (ClaimId,ApproverId, ApproverSts, CreatedDate, OrganizationId)values(?,?,?,?,?)";
						$queryfin=$this->db->prepare($sqlfin);
						$queryfin->execute(array($claimid,$request[6],3,$mdate,$orgid));
						/////Update Finance ID in Claim MAster Table /////////
						$sql2 = "UPDATE ClaimsMaster SET financeby =? WHERE Id =? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($request[6], $claimid));
						///////MAIl FOR FINANCE////////
						$fname=Utils::getName($request[6],'EmployeeMaster','FirstName',$this->db);
							$fmail=Utils::decode5t(Utils::getName($request[6],'EmployeeMaster','CompanyEmail',$this->db));
							$title="Reimbursement Claim";
							$msg="<table>
									<tr><td>Hello $fname,</td></tr>
									<tr><td>A Reimbursement Claim request is pending at your level for finance release.</td></tr>
									<tr><td>Thanks</td></tr>
								</table>";
								Utils::Trace($msg);
							Utils::sendMail($fmail,"UBIHRM",$title,$msg);
					}
					$sql1 = "select * from ClaimApproval WHERE ClaimId = ? and ApproverSts<>2 and OrganizationId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $claimid, $orgid));
					if($query1->rowCount()==0)
					{
						$sql2 = "UPDATE ClaimsMaster SET ApproverSts =? , ApprovalDate=?,LastModifiedDate=?,LastModifiedById=?, ApplyMonth=?  WHERE Id =? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array(2,$mdate,$mdate,$mid,$request[5], $claimid));
						$count=$query->rowCount();
						if($count1==1){
							/*Send mail to employee*/
							$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
							$empmail=Utils::decode5t(Utils::getName($empid,'EmployeeMaster','CompanyEmail',$this->db));
							$title="Medical Claim";
							$msg="<table>
									<tr><td>Hello $empname,</td></tr>
									<tr><td>Your Medical Claim request has been approved by finance.</td></tr>
									<tr><td>Thanks</td></tr>
								</table>";
								Utils::Trace($msg);
							Utils::sendMail($empmail,"UBIHRM",$title,$msg);
							/*Send mail to HR */
							$fname=Utils::getName($request[6],'EmployeeMaster','FirstName',$this->db);
							$fmail=Utils::decode5t(Utils::getName($request[6],'EmployeeMaster','CompanyEmail',$this->db));
							$title="Reimbursement Claim";
							$msg="<table>
									<tr><td>Hello $fname,</td></tr>
									<tr><td>A Reimbursement Claim request is approved by  finance.</td></tr>
									<tr><td>Thanks</td></tr>
								</table>";
								Utils::Trace($msg);
							Utils::sendMail($fmail,"UBIHRM",$title,$msg);
						}
					}
					
					
			   }else{
				$successMsg = "Claim request has been rejected";
				$sql2 = "UPDATE ClaimsMaster SET ApproverSts =?,LastModifiedDate=?,LastModifiedById=? WHERE Id =? ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array(1,$mdate,$mid, $claimid));
			   }
			  
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_UPDATION_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	
	
	
    /**
     * Setter for a ClaimsMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
  

	public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$leavefrom = Utils::getDateformat($request[2]);
		$leaveto = Utils::getDateformat($request[3]);
		$leavefrom1 = date('M d, Y ', strtotime($leavefrom));
		$leaveto1 = date('M d, Y ', strtotime($leaveto));
		$id=$request[7];
		try{
		$sql1="SELECT Id FROM ClaimsMaster where EmployeeId=? and OrganizationId=? and ((? between  FromDate and ToDate )or (? between  FromDate and ToDate )) and ApproverSts in(2,3) and Id<>$id";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($request[6],$orgid, Utils::getDateformat($request[2]),Utils::getDateformat($request[3])));
		if($query1->rowCount()>0){
			$result["data"] =$data;
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']="You have already applied for the same duration";
			return $result;

		}
			$sql = "UPDATE ClaimsMaster SET  FromDate =?, ToDate= ?, Purpose=?, TotalAmt=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
			$query = $this->db->prepare($sql);
			
			//$sts = ($request[7]==0)?3:$request[7];
			
				$query->execute(array( Utils::getDateformat($request[2]),Utils::getDateformat($request[3]),$request[4],$request[5],  $orgid, $mdate, $mid, $id));			
				$count =  $query->rowCount();
				
			
			if ($count == 1) {
				///////Activity Log History File//////////
				$empname=Utils::getEmployeeName($request[6],$this->db);
				$msg="<b>$empname</b> has updated for a <b>$request[4]</b> from <b>$leavefrom1</b> to <b>$leaveto1</b>";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Self Service", $msg, $orgid));
			   $status =true;
			   $successMsg = "Claim request updated successfully";
			   
			   $claim = json_decode($_POST['claimarr'], true); 
			   $claimid="0";
				for($i=0; $i<count($claim); $i++){
					$claimid .= ",".$claim[$i]['id'];
				}
				$sqlwork = " DELETE FROM ClaimsChild WHERE ClaimId=? AND Id NOT IN ($claimid)";
				$querywork = $this->db->prepare($sqlwork);
				$querywork->execute(array( $id));
			    // INSERTING CLAIM CHILD IF PASSED AS AN JSON
				
				for($i=0; $i<count($claim); $i++)
				{
					if($claim[$i]['date']!="" && $claim[$i]['claimamt']!="" && $claim[$i]['head']!=""){
						$record = array();
						$record[0] = $id;
						$record[1] = Utils::getDateformat($claim[$i]['date']);
						$record[2] = $claim[$i]['head'];
						$record[3] = $claim[$i]['desc'];
						$record[4] = $claim[$i]['claimamt'];
						
						$cid = $claim[$i]['id'];
						if($cid){
							$sqlwork = " UPDATE ClaimsChild SET EventDate=?, ClaimHead=?, Description=?,  ClaimAmt=? WHERE Id=?";
							$querywork = $this->db->prepare($sqlwork);
							$querywork->execute(array(Utils::getDateformat($claim[$i]['date']), $claim[$i]['head'], $claim[$i]['desc'],  $claim[$i]['claimamt'],  $cid));
						}else{						
							$sqlobjective = " INSERT INTO ClaimsChild (ClaimId, EventDate, ClaimHead, Description, ClaimAmt) values (?,?,?,?,?)";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute($record);
						}
					}
				}
				
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_UPDATION_FAILED;
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a ClaimsMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$leavefrom = Utils::getDateformat($request[2]);
		$leaveto = Utils::getDateformat($request[3]);
		$leavefrom1 = date('M d, Y ', strtotime($leavefrom));
		$leaveto1 = date('M d, Y ', strtotime($leaveto));
		$rdate = "";
		$sql1="SELECT Id FROM ClaimsMaster where EmployeeId=? and OrganizationId=? and ((? between  FromDate and ToDate )or (? between  FromDate and ToDate )) and ApproverSts in(2,3)";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($request[6],$orgid, Utils::getDateformat($request[2]),Utils::getDateformat($request[3])));
		if($query1->rowCount()>0){
			$result["data"] =$data;
			$result['status']=$status;
			$result['successMsg']=$successMsg;
			$result['errorMsg']="You have already applied for the same duration";
			return $result;

		}		
			$sql = "INSERT INTO ClaimsMaster ( EmployeeId, FromDate, ToDate, Purpose, ApproverSts,  TotalAmt, OrganizationId, CreatedById, CreatedDate, LastModifiedById, LastModifiedDate, OwnerId) VALUES (? ,? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			$sts = ($request[7]==0)?3:$request[7];
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[6], Utils::getDateformat($request[2]),Utils::getDateformat($request[3]),$request[4],$sts,$request[5], $orgid, $mid, $mdate,  $mid,$mdate, $mid));
				 $claimid = $this->db->lastInsertId();
				$count =  $query->rowCount();		
			
			
			if ($count == 1) {		
				///////Activity Log History File//////////
				$empname=Utils::getEmployeeName($request[6],$this->db);
				$msg="<b>$empname</b> has Applied for a <b>$request[4]</b> from <b>$leavefrom1</b> to <b>$leaveto1</b>";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Self Service", $msg, $orgid));
			   $status =true;
			   $successMsg = "Your request for claim has been sent!";
			  
			  
			  // INSERTING CLAIM CHILD IF PASSED AS AN JSON
				$claim = json_decode($_POST['claimarr'], true); 
				for($i=0; $i<count($claim); $i++)
				{
					if($claim[$i]['date']!="" && $claim[$i]['claimamt']!="" && $claim[$i]['head']!=""){
						$record = array();
						$record[0] = $claimid;
						$record[1] = Utils::getDateformat($claim[$i]['date']);
						$record[2] = $claim[$i]['head'];
						$record[3] = $claim[$i]['desc'];
						$record[4] = $claim[$i]['claimamt'];
						
												
						$sqlobjective = " INSERT INTO ClaimsChild (ClaimId, EventDate, ClaimHead, Description, ClaimAmt) values (?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
					}
				}
				
				$sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";
					$query = $this->db->prepare($sql);
					$query->execute(array( $orgid));
					if($r=$query->fetch()){
						$hr=$r->EmployeeId;
					} 
				$senior = Utils::getApprovalLevelEmp($request[6], 7, $this->db);
				if($senior!=0)
				{
					$temp = explode(",", $senior);
					for($i=0; $i<count($temp); $i++)
					{
						$sql = "INSERT INTO ClaimApproval ( ClaimId, ApproverId, ApproverSts, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($claimid, $temp[$i], 3, $mdate, $orgid));
						$empname=Utils::getName($request[6],'EmployeeMaster','FirstName',$this->db);
						$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
						$senioremail=Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db);
						$title="Certificate request";
						$msg="<table>
								<tr><td>Hello $seniorname,</td></tr>
								<tr><td>$empname has requested for reimbursement.</td></tr>
								<tr><td>Thanks</td></tr>
						</table>";
						Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
					}
				}else{
					$senior = Utils::getSeniorId($request[6],$this->db);
					if($senior != $hr){
						if($hr !=0)
						$senior.=','.$hr;
					}
					$temp = explode(",", $senior);
					for($i=0; $i<count($temp); $i++)
					{
						$sql = "INSERT INTO ClaimApproval ( ClaimId, ApproverId, ApproverSts, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($claimid, $temp[$i], 3, $mdate, $orgid));
						$empname=Utils::getName($request[6],'EmployeeMaster','FirstName',$this->db);
						$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
						$senioremail=Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db);
						$title="Certificate request";
						$msg="<table>
								<tr><td>Hello $seniorname,</td></tr>
								<tr><td>$empname has requested for reimbursement.</td></tr>
								<tr><td>Thanks</td></tr>
						</table>";
						Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
					}
				}
			} else {
			   $status =false;
			   $errorMsg = DOCUMENT_REQUEST_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
		$result["data"] =$data;
		$result["employeeid"] =$request[6];
		$result["claimid"] =$claimid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$empid=Utils::getName($did,'ClaimsMaster','EmployeeId',$this->db);
		$applydate =Utils::getName($did,'ClaimsMaster','ApplyMonth',$this->db);
		$applydate1 = date('M d, Y ', strtotime($applydate));
		$empname=Utils::getEmployeeName($empid,$this->db);
		$mid= $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "DELETE FROM ClaimApproval WHERE ClaimId = :id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		$sql = "DELETE FROM ClaimsChild WHERE ClaimId = :id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		$sql = "DELETE FROM ClaimsMaster WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			///////Activity Log History File//////////
			$msg="Claim of <b>$empname</b> applied on <b>$applydate1</b> has been deleted";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Self Service", $msg, $orgid));
           $status =true;
		   $successMsg = "Reimbursement deleted successfully";
        }else {
           $status =false;
		   $errorMsg = DOCUMENT_REQUEST_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				if($table == 'EmployeeMaster')
				{
					$name = $row->FirstName.' '.$row->LastName;
				}
				else{
					$name = $row->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDocumentName($ids)
	{
		$name ="";
		$orgid = $_SESSION['ubihrm_org_id'];
		$sql = "SELECT Name FROM DocumentMaster WHERE Id in ($ids) and OrganizationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ));
			while($row = $query->fetch())
			{
				if($name == '')
				{
					$name = $row->Name;
				}
				else{
					$name .= ", ".$row->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDocument($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$docid = $row->DocumentTypeId;
				$sql1 = "SELECT * FROM DocumentMaster WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $docid ));
				if($row1= $query1->fetch())
				{
					$name=$row1->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		
		$sTable = 'ClaimsMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId','FromDate'  ,'ToDate','Purpose','TotalAmt' ,'ApproverId', 'ApproverSts', 'Id');
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY ApproveDate desc";
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$asts=$_SESSION['ubihrm_user_sts'];
		//$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		
		$sWhere = " WHERE OrganizationId= $orgid AND Id IN (SELECT ClaimId FROM ClaimApproval Where ApproverId=$userid )";
		if($asts==1 || $hrsts==1)
		$sWhere = " WHERE  OrganizationId= $orgid ";
		
			
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		
		$sQuery = "
		 SELECT SQL_CALC_FOUND_ROWS   ".str_replace(" , ", " ", implode(", ", $aColumns))."  
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
										
					$edit =""; $delete="";$release="";
					$financeby=Utils::getName($aRow->{$aColumns[$i]},"ClaimsMaster", "financeby", $this->db);
					$sts=$this->getApproverSts($aRow->Id,$userid);
					if($sts && $financeby==0){	
						$id=Utils::encode5t($aRow->{$aColumns[$i]});
						$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'salary/editclaimapproval/'.$id.'" class="text-green"><i class="fa fa-thumbs-up"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;';
						
					}
					
					if($aRow->ApproverSts==3 && $userid==$financeby){
						$release = '<a rel="tooltip" title="Release" href="'.URL.'salary/releaseclaim/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-paper-plane"></i>&nbsp;&nbsp;&nbsp;&nbsp;</a>';
					}
					if($sts==1 || $hrsts==1){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}
					$row[] =$release.$edit.$delete;
					
				}
				elseif($aColumns[$i]=="ApproverSts"){
                    if($aRow->{$aColumns[$i]}==3){
						$pendingapprover=$this->getApproverstsname($aRow->Id,3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
					//$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
                 }
				 elseif($aColumns[$i]=="EmployeeId"){
                    $id=Utils::encode5t($aRow->Id);
					$row[] = '<a rel="tooltip" title="View Request" href="'.URL.'salary/viewclaimapproval/'.$id.'/1" >'.Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'</a>';
                 }
				elseif($aColumns[$i]=="ApproveDate" || $aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate"){
					if(($aRow->{$aColumns[$i]})=="0000-00-00" || ($aRow->{$aColumns[$i]})=="0000-00-00 00:00:00")
					{
						$row[]="-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				elseif($aColumns[$i]=="TotalAmt"){
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]});
				}				
				elseif($aColumns[$i]=="ApproverId")
				{
					if($aRow->ApproverSts == 2){
						$name = $this->getName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$name="";
					}
					
					$row[] = $name;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	//////////////////////////// to find out the approver on which the Claim is pending ///////////////////////////
	
		public function getApproverstsname($id,$sts)
		{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM ClaimApproval where ClaimId=? and ApproverSts=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM ClaimApproval where ClaimId=? and ApproverSts=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					$name = $row->ApproverId;
				}
			}catch(Exception $e) {

			}

			return $name;
		}
	//////////////////////////////uploading document/////////////////////////////
	public function uploadDocument($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];
		$docid = $request[3];
		$claimid = $request[4];
		try{
		$empcode=Utils::getName($empid,'EmployeeMaster','EmployeeCode',$this->db);
		
		$new_name="";
		//$this->deletedoc("public/uploads/$orgid/2SD" );
		$dir="public/uploads/$orgid/$empcode";
		
		if (! is_dir($dir)) {
			mkdir($dir);
			chmod($dir,0755);
			
		}
		$doc1='claim_'."$claimid".'_'."$docid";
		
		$filename="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext1 = end((explode(".", $filename)));
								if($filename=="$doc1.$ext1")
								{
									unlink("public/uploads/$orgid/$empcode/$filename");
								}
							}
						closedir($dh);
						}
					}
					$new_name='claim_'.$claimid.'_'.$docid.'.'.$ext;
					
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/$orgid/$empcode/";
					if($file_size > 2097152){
					//$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						if(move_uploaded_file($file_tmp, $location.$new_name)){
						$count++; }
						
					}else{
						print_r($errors);
					}
					if ($count >= 1) {
						$status =true;
					    $successMsg = "Document uploaded successfully";
						
						$sql="Update ClaimsChild set Doc=? where ClaimId=? And ClaimHead =? ";
						$query=$this->db->prepare($sql);
						$query->execute(array($new_name,$claimid,$docid));
					} else {
					   $status =false;
					   $errorMsg = EMPLOYEE_MODULE_DOCUPLOAD_FAILED;
					}
				
				
			}
			
		}catch(Exception $e)
		{}		
			
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}
	
	public function getApproverSts($id,$userid)
	{
		$flg =false;
		$employee=0;
		$sql = "SELECT * FROM ClaimApproval WHERE ClaimId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
				if($row->ApproverSts==3){
					$employee=$row->ApproverId;
					break;
				}
			}
			if($employee ==  $userid){
					$flg = true;
				}
		}catch(Exception $e) {
			
		}
		return $flg;
	}
	
	public function getAllApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $request[1];
		$documentid = $request[2];
		
		$s1="SELECT * from ClaimApproval WHERE OrganizationId=? and ClaimId = ? and ApproverSts<>3";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $documentid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->ApproverSts;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data[] = $res;
			
			$successMsg=""; $status=true;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
}

